# -*- coding: utf-8 -*-

import os, sys

import xbmc, xbmcplugin, xbmcgui

from xbmcup.app import Link, Handler, Plugin, _setting
import kinovhd
from history import History, HistoryAdd

_view_ = _setting['view']


class Menu(Handler):
	def handle(self):
		self.item(Link('catalog',{'search': True}), title='[Поиск]')
		self.item(Link('history'), title='[История поиска]')
		self.item(Link('genre'), title='Все жанры')
		self.item(Link('genre',{'filmspro': True}), title='Фильмы про')
		Catalog().handle()

class Catalog(Handler):
	def handle(self):
		search = self.argv.get('search')
		url = self.argv.get('url')
		s_kbd = self.argv.get('s_kbd', False)
		if search:
			if isinstance(search, bool):
				textsearch = self.argv.get('textsearch', '')
				search = self.kbdinput('Поиск', textsearch)
				if search is None: return True
				s_kbd = True
				HistoryAdd(search)
			s1, data = kinovhd.search(search)
		else:
			data = kinovhd.catalog(url)
		if (data['data'] == []) and s_kbd:
			xbmcgui.Dialog().ok('Кино в HD', 'Ничего не найдено')
		for i in data['data']:
			popup = []
			popup.extend(self.popup)
			title = i['info']['title']
			popup.insert(1, (Link('catalog', {'search': True, 'textsearch': title}, True), 'Поиск') )
			if i['suna'] !='': title = title + ' [ '+i['suna']+' ]'
			if  (u'сезон,' not in i['info']['title']) and (u'Сериалы' not in i['info']['genre']) and (u', Сериалы' not in i['ctype']):
				self.item(Link('play', {'url': i['url']}), title=title, media='video', info=i['info'], thumb=i['thumb'], popup=popup, popup_replace=True, property=[('IsPlayable','true')], folder=False)
			else:
				self.item(Link('video', {'url': i['url']}), title=title, media='video', info=i['info'], thumb=i['thumb'], popup=popup, popup_replace=True)
		if data['page']['next']:
			titlepage = 'Следующая страница '+ str(data['page']['current']+1)+ ' из ' + str(data['page']['max']) + ' >>'
			self.item(Link('catalog',{'url':data['page']['next']}), title=titlepage)
		self.render(nextmode=_view_)


class Genres(Handler):
	def handle(self):
		filmspro = self.argv.get('filmspro')
		if filmspro:
			data = kinovhd.filmspro()
		else:
			data = kinovhd.genre()
		for i in data:
			self.item(Link('catalog',{'url': i[1]}), title=i[0])
		self.render(nextmode=_view_)


class VideoInfo(Handler):
	def handle(self):
		url = self.argv.get('url')
		d = kinovhd.videoinfo(url)
		data = d['data'][0]
		self.item(Link('video', {'url': data['url'] }), title=data['info']['title'], media='video', info=data['info'], thumb=data['thumb'], popup=self.popup, popup_replace=True)
		title = data['info']['title']
		info = data['info']
		for name, durl, index in d['url']:
			info['title'] = title + u' / ' + name
			self.item(Link('play',{'url': data['url'], 'index': index }), title=name, media='video', info=info, thumb=data['thumb'], popup=self.popup, popup_replace=True, property=[('IsPlayable','true')], folder=False)
		self.render(nextmode=_view_)


class Play(Handler):
	def handle(self):
		url = self.argv.get('url')
		durl = self.argv.get('durl')
		index = self.argv.get('index')
		if url:
			link, error = kinovhd.play_link(url, index)
		elif durl: link = durl
		if link:
			#xbmc.Player().play(link)
			from urllib import urlencode
			link = link + '|' + urlencode( {'Referer': link, 'User-Agent': kinovhd.headers['User-Agent']} )
			item = xbmcgui.ListItem(path=link)
			xbmcplugin.setResolvedUrl(int(sys.argv[1]),True, item)
		else:
			xbmcgui.Dialog().ok('Кино в HD', *error)


def main():
	plugin = Plugin(Menu)
	plugin.route('catalog', Catalog)
	plugin.route('genre', Genres)
	plugin.route('video', VideoInfo)
	plugin.route('play', Play)
	plugin.route('history', History)
	plugin.run()


if __name__ == '__main__':
	try:
                search_vars = sys.argv[2].split('?')
                search_vars = search_vars[-1].split('&')
                if 'usearch=True' in search_vars:
                        from urlparse import parse_qs
                        params = parse_qs(sys.argv[2].replace('?', ''))
                        united_search = {'route': 'catalog', 'argv': { 'search': params['keyword'][0] } }
			from urllib import quote_plus
                        import json
                        sys.argv[2] = '?'+quote_plus(json.dumps(united_search))
	except BaseException as e:
		from xbmcup.errors import log
		log(e)

	main()
