# -*- coding: utf-8 -*-

import sys, os
import re


site_url = 'http://kinovhd.net'

try:
	from xbmcup.app import _setting
	_quality_ = _setting['quality']
	_domain_ = _setting['site_domain']
	if _domain_:
		_domain_ = _domain_.replace('https://', '').replace('http://', '').strip('/').strip()
		if _domain_:
			if _setting['use_https'] == 'true': site_url = 'https://' + _domain_
			else: site_url = 'http://' + _domain_
except Exception:
	_quality_ = '720'
	sys.path.append(os.path.join(os.path.dirname(__file__), '..', 'script.module.beautifulsoup4', 'lib'))


headers = {
	'User-Agent': 'Mozilla/5.0 (Windows NT 6.1; rv:10.0.2) Gecko/20100101 Firefox/10.0.2',
	'Accept': 'text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8',
	'Accept-Language': 'ru-ru,ru;q=0.8,en-us;q=0.5,en;q=0.3',
	'Cache-Control': 'no-cache',
	'Referer': site_url
	}

Quality = (360, 480, 720, 1080)

class Error(Exception):
    def __init__(self, msg):
	self.msg = msg

    def __str__(self):
	return '{}'.format(self.msg)

def getUrl(url, rurl=False, rheaders=False, referer=None):
	from xbmcup.net import HTTP
	http = HTTP()
	if isinstance(url, unicode):
		url = url.encode('utf8')
	if referer: headers['Referer'] = referer
	response = http.fetch(url, headers=headers, cookies='kinovhd.moz')
	if response.code == 200:
		if rurl:
			return response.url , response.body
		elif rheaders:
			return response.headers, response.body
		else:
			return response.body
        else:
		try:
			from xbmcup.errors import message
			message('Ошибка '+str(response.code)+' HTTP:', response.error)
			import xbmc
			xbmc.sleep(3000)
		except: pass
		raise Error(response.error)
		return response.code

def postUrl(url, param):
	from xbmcup.net import HTTP
	http = HTTP()
	if isinstance(url, unicode):
		url = url.encode('utf8')
	response = http.fetch(url, method='POST', params=param, headers=headers, cookies='kinovhd.moz')
	if response.code == 200:
			return response.url , response.body
        else:
		try:
			from xbmcup.errors import message
			message('Ошибка '+str(response.code)+' HTTP:', response.error)
			import xbmc
			xbmc.sleep(3000)
		except: pass
		raise Error(response.error)
		return response.code

def r_u(url):
	if url.startswith(site_url): return url.replace(site_url,'')
	else: return url

def n_u(url):
	if ('://' in url) or (url is None) or (url[0] != '/'): return url
	else: return site_url + url

def pars(data):
	from bs4 import BeautifulSoup
	soup = BeautifulSoup(data, 'html.parser')

	genres_list = []
	g = soup.find('td', 'catek')
	for i in g.findAll('a'):
		genres_list.append( (i.text, i['href']) )
	g = soup.find('td', 'cate')
	for i in g.findAll('a'):
		genres_list.append( (i.text, i['href']) )
	return genres_list


def pars2(data, is_search=False):
	from bs4 import BeautifulSoup
	soup = BeautifulSoup(data.replace(' </tr>',''), 'html.parser') # replace -> fix site bug

	#p = soup.find('div', 'content')
	#print p
	content_list = []
	v = soup.findAll('div', 'conte')
	#i = v[0]
	for i in v:
	#if i:
		info = {}
		r = i.find('a')
		url = r['href']
		if '://' not in url: url = site_url + url
		info['title'] = r.text
		yr = re.compile(', ([1-2]{1}\d{3})',re.S).search(r.text)
		if yr: info['year'] = int(yr.group(1))
		else: is_search = True
		img = i.find('img', 'sk')['src']
		if '://' not in img: img = site_url + img
		#print i
		c = i.findAll('div', 'tr')
		n = i.findAll('div', 'tl')
		ctype = ''
		for j in range(len(c)):
			#print n[j].text, ' ', c[j].text
			if u'Оригинал' in n[j].text: info['originaltitle'] = c[j].text
			if u'Время' in n[j].text:
	    			dc = re.compile(u'[ \dxх]*?(\d+) м',re.S).search(c[j].text)
				if dc:	info['duration'] = int(dc.group(1)) * 60
			if u'Категории' in n[j].text: info['genre'] = c[j].text
			if u'Качество' in n[j].text: info['writer'] = n[j].text+': '+c[j].text
			if u'Год' in n[j].text: info['year'] = int(c[j].text)
			if u'Раздел' in n[j].text:
						info['tagline'] = n[j].text+': '+c[j].text
						ctype = c[j].text.lower()
		plot = i.find('p')
		if plot: info['plot'] = plot.text
		suna = ''
		sunaf = i.find('div', 'suna')
		if sunaf:
			suna = sunaf.text.strip().replace(' ','')
			info['plotoutline'] = suna
			if '-' in suna: suna = u'[COLOR red]' + suna + u'[/COLOR]'
			else: suna = u'[COLOR green]' + suna + u'[/COLOR]'
		if is_search:
			if (u'Мультфильмы' in info['genre']) or (u'Аниме' in info['genre']):
				data2 = getUrl(url)
				r = re.compile(r',\s*?file:\s*?"(.+?)",',re.S).search(data2)
				if r:
					purl = r.group(1)
					if purl.startswith('/sz.txt'): ctype = ctype + u', Сериалы'
		content_list.append( {'url': r_u(url), 'thumb': img, 'info': info, 'ctype': ctype, 'suna': suna} )
	page = {'max': 1, 'current': 1, 'next': None, 'prev': None}
	pg = soup.find('div', 'navi')
	#print pg
	if pg:
		t = pg.findAll('a')
		cu = pg.findAll('span')
		try: page['max'] = int(t[-2].text)
		except: page['max'] = -1
		try: page['current'] = int(cu[-1].text)
		except: page['current'] = int(cu[-2].text)
		for i in t:
			if u'Вперед' in i.text: page['next'] = i['href']
			if u'Назад' in i.text: page['prev'] = i['href']
		#print page
	return {'data': content_list, 'page': page}


def pars3(data):
	from bs4 import BeautifulSoup
	soup = BeautifulSoup(data, 'html.parser')

	p = soup.find('div', 'content')
	#print p
	content_list = []
	if p:
		info = {}
		r = p.find('h1')
		info['title'] = r.text

		g = p.find('div', 'cat').findAll(text=re.compile('[^\s]'))
		info['genre'] = ', '.join(g)
		info['plot'] = soup.find('div', 'story').find('p').text


		yr = re.compile(', ([1-2]{1}\d{3})',re.S).search(r.text)
		if yr: info['year'] = int(yr.group(1))
		k = soup.find('img', 'kart')
		img = n_u(k['src'])
		#print k
		l = k.findNext('div') # fix old bs4 4.6.2-
		#print l
		ur = l.find('meta', itemprop='url')
		url = ur['content']
		c = l.findAll('div', 'tr')
		n = l.findAll('div', 'tl')
		ctype = u''
		for j in range(len(c)):
			#print n[j].text, ' ', c[j].text
			if u'Оригинал' in n[j].text: info['originaltitle'] = c[j].text
			if u'Время' in n[j].text:
	    			dc = re.compile(u'[ \dxх]*?(\d+) м',re.S).search(c[j].text)
				if dc:	info['duration'] = int(dc.group(1)) * 60
			if u'Качество' in n[j].text: info['writer'] = n[j].text+': '+c[j].text
			if u'Год' in n[j].text: info['year'] = int(c[j].text)
			if u'Раздел' in n[j].text:
						info['tagline'] = n[j].text+': '+c[j].text
						ctype = c[j].text.lower()
		suna = ''
		sunaf = p.find('span', style=re.compile('color'))
		if sunaf:
			suna = sunaf.text.strip().replace(' ','')
			info['plotoutline'] = suna
			if '-' in suna: suna = u'[COLOR red]' + suna + u'[/COLOR]'
			else: suna = u'[COLOR green]' + suna + u'[/COLOR]'
		r = re.compile(r',\s*?file:\s*?"(.+?)",',re.S).search(data)
		if r:
			purl = r.group(1)
			if purl.startswith('/sz.txt'): ctype = ctype + u', Сериалы'
		content_list.append( {'url': r_u(url), 'thumb': img, 'info': info, 'ctype': ctype, 'suna': suna} )

	page = {'max': 1, 'current': 1, 'next': None, 'prev': None}
	return {'data': content_list, 'page': page}


def pars4(data):
	from bs4 import BeautifulSoup
	soup = BeautifulSoup(data, 'html.parser')

	v = soup.findAll('div', 'cont')
	fplist=[]
	#i = v[0]
	for i in v:
	#if i:
		name = i.find('h2')
		fp = i.find('a')
		if fp:
			fpurl = fp['href']
			if '://' not in fpurl: fpurl = site_url + fpurl
			fplist.append( ( name.text, r_u(fpurl) ) )
	return fplist

def qurl(url, quality=_quality_):
			urls = url.split(',[')
			listurls = {}
			gl = []
			for i in urls:
				d = i.replace('[','').split(']')
				if u'4K' in d[0]: d[0] = '4000'
				listurls[str(d[0])] = d[1]
				gl.append( (int(d[0]), d[1]) )
			#print listurls
			gl.sort()
			#print gl
			qprev = 0
			for i in gl:
				if int(i[0]) > int(quality):
					q = qprev
					break
				qprev = i[0]
				q = i[0]
			url = listurls[str(q)]
			return url


def pars_seria(data):
	lurls = eval(data)
	list_seria = []
	index = 0
	for i in lurls:
		sezon_name = i['title']
		for j in i['folder']:
			seria_num = j['title']
			url = j['file']
			if ',[' in url:
				url = qurl(url)
			name = sezon_name + ' / ' + seria_num
			list_seria.append( (name.decode('utf8'), url, index) )
			index += 1
	return list_seria

def pars_play(data, quality=_quality_):
	r = re.compile(r'e",\s*?file:\s*?"(.+?)",',re.S).search(data)
	if not r: r = re.compile(r',\s*?file:\s*?"(.+?)",',re.S).search(data)
	if r:
		url = r.group(1)
		#print url
		if url.startswith('/sz.txt'):
			data2 = getUrl(site_url+url)
			url = pars_seria(data2)
		elif ',[' in url:
			url = qurl(url)
	return url


def catalog(url=site_url):
	if not url: url = site_url
	data = getUrl(n_u(url))
	return pars2(data)

def genre():
	data = getUrl(site_url)
	return pars(data)

def filmspro():
	data = getUrl(site_url+'/фильмы-про/')
	return pars4(data)

def videoinfo(url):
	data = getUrl(n_u(url))
	#file('/home/osmc/search.txt', 'wb').write( data )
	res = pars3(data)
	res['url'] = pars_play(data)
	return res


def search(text):
	if isinstance(text, unicode): text = text.encode('utf8')
	url, data = postUrl(site_url,{'do': 'search', 'subaction': 'search' , 'story': text, 'submit': 'Найти'} )
	#file('/home/osmc/search.txt', 'wb').write( data )
	if url == site_url:
		return False, pars2(data, True)
	else:
		return True, pars3(data)


def play_link(url, index=None):
	try:
		from xbmcup.errors import log
		log(url,'url=')
	except: pass
	data = getUrl(n_u(url))
	#file('/home/osmc/z2-kinovhd.net.txt', 'wb').write(data)
	if index or index == 0:
		return pars_play(data)[index][1], None
	else:
		return pars_play(data), None


if __name__ == '__main__':

	#file('/home/osmc/film.txt', 'wb').write( getUrl( genre()[0][1] ) )
	data = file('/home/osmc/search.txt', 'rb').read()
	print
        d = pars3(data)

	print d
	pass

