# -*- coding: utf-8 -*-

import sys, os
import re
import time

site_url = 'https://hdone.tv' #.net' #kinovhd.net'

try:
	from xbmcup.app import _setting
	if _setting['change'] != '1':
		_setting['quality'] = '360'
		_setting['video_m3u8'] = 'false'
		_setting['change'] = '1'
		time.sleep(0.5)
	_quality_ = _setting['quality']
	_domain_ = _setting['site_domain']
	_get_domain_ = bool(_setting['get_domain'] == 'true')
	_videom3u8_ = bool(_setting['video_m3u8'] == 'true')
	if _domain_:
		_domain_ = _domain_.replace('https://', '').replace('http://', '').strip('/').strip()
		if _domain_:
			if _setting['use_https'] == 'true': site_url = 'https://' + _domain_
			else: site_url = 'http://' + _domain_
except Exception:
	_videom3u8_ = False
	_get_domain_ = False
	_quality_ = '720'
	sys.path.append(os.path.join(os.path.dirname(__file__), '..', 'script.module.beautifulsoup4', 'lib'))
	#_setting = {}

headers = {
	#'User-Agent': 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_13_6) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/76.0.3783.0 Safari/537.36',
	'User-Agent': 'Mozilla/5.0 (Windows NT 6.1; WOW64; rv:67.0) Gecko/20100101 Firefox/67.0',  #'Mozilla/5.0 (Windows NT 6.1; rv:10.0.2) Gecko/20100101 Firefox/10.0.2',
	'Accept': 'text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8',
	'Accept-Language': 'ru-ru,ru;q=0.8,en-us;q=0.5,en;q=0.3',
	'Cache-Control': 'no-cache',
	'Referer': site_url
	}

Quality = (360, 480, 720, 1080)

class Error(Exception):
    def __init__(self, msg):
	self.msg = msg

    def __str__(self):
	return '{}'.format(self.msg)

def urlp(url):
	try:
		s = url.decode('ascii')
		return url
	except:
		if isinstance(url, unicode):
			url = url.encode('utf8')
		from urllib import quote
		url = quote(url, ':/')
		return url

def getUrl(url, rurl=False, rheaders=False, referer=None, proxy=None):
	from xbmcup.net import HTTP
	http = HTTP()
	url = urlp(url)
	if referer: headers['Referer'] = referer
	if proxy:
		response = http.fetch(url, headers=headers, cookies='kinovhd.moz', proxy_protocol=url.split(':')[0], proxy_host=proxy.split(':')[0], proxy_port=proxy.split(':')[1] )
	else:
		response = http.fetch(url, headers=headers, cookies='kinovhd.moz')
	if response.code == 200:
		if rurl:
			return response.url , response.body
		elif rheaders:
			return response.headers, response.body
		else:
			return response.body
        else:
		try:
			from xbmcup.errors import message
			message('Ошибка '+str(response.code)+' HTTP:', response.error)
			import xbmc
			xbmc.sleep(3000)
		except: pass
		raise Error(response.error)
		return response.code

def postUrl(url, param):
	from xbmcup.net import HTTP
	http = HTTP()
	url = urlp(url)
	response = http.fetch(url, method='POST', params=param, headers=headers, cookies='kinovhd.moz')
	if response.code == 200:
			return response.url , response.body
        else:
		try:
			from xbmcup.errors import message
			message('Ошибка '+str(response.code)+' HTTP:', response.error)
			import xbmc
			xbmc.sleep(3000)
		except: pass
		raise Error(response.error)
		return response.code

def GetProxyList():
	import httplib
	conn = httplib.HTTPConnection("antizapret.prostovpn.org")
	conn.request("GET", "/proxy.pac", headers={"User-Agent": 'Mozilla/4.0 (compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1) ; .NET CLR 1.1.4322; .NET CLR 2.0.50727; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729; .NET4.0C)'})
	r1 = conn.getresponse()
	data = r1.read()
	conn.close()
	proxylist = re.compile('PROXY (.+?); DIRECT').findall(data)
	return proxylist

def proxy_update():
	return GetProxyList()[0]

if _get_domain_:
		try: pt=float(_setting['proxy_time'])
		except: pt=0
		if time.time()-pt > 36000:
			proxy1 = proxy_update()
			#proxy1=__setting['proxy_serv']
			#print proxy1
			try:
				_setting['proxy_time'] = str(time.time())
			except: pass
			redirect_url, data = getUrl(site_url, proxy=proxy1, rurl=True)
			redirect_url = redirect_url.strip('/')
			if site_url != redirect_url:
				try:
					_setting['site_domain'] = redirect_url.split('/')[2]
					_setting['use_https'] = 'true' if redirect_url.split(':')[0] == 'https' else 'false'
				except: pass
				site_url = redirect_url
				#print redirect_url
				#print _setting

def r_u(url):
	if url.startswith(site_url): return url.replace(site_url,'')
	else: return url

def n_u(url):
	if ('://' in url) or (url is None) or (url[0] != '/'): return url
	else: return site_url + url

def pars(data):
	from bs4 import BeautifulSoup
	soup = BeautifulSoup(data, 'html.parser')

	genres_list = []
	g = soup.find('td', 'catek')
	for i in g.findAll('a'):
		genres_list.append( (i.text, i['href']) )
	g = soup.find('td', 'cate')
	for i in g.findAll('a'):
		genres_list.append( (i.text, i['href']) )
	return genres_list


def pars2(data, is_search=False):
	from bs4 import BeautifulSoup
	soup = BeautifulSoup(data.replace(' </tr>',''), 'html.parser') # replace -> fix site bug

	#p = soup.find('div', 'content')
	#print p
	content_list = []
	v = soup.findAll('div', 'conte')
	#z = v[0]
	for z in v:
	#if z:
		info = {'mediatype': 'movie'}
		sunaf = None
		zr = z.find('h3')
		if not zr: zr = z.find('a')
		if zr:
			info['title'] = zr.text
			sunaf = zr.findNext('div', 'suna')
		else: zr = z
		suna = ''
		if sunaf:
			suna = sunaf.text.strip().replace(' ','')
			#info['plotoutline'] = suna
			info['votes'] = str(suna.split(':')[1].split(')')[0].strip())
			suna = suna.split('(')[0]
			info['rating'] = float(suna)
			if suna == '0' : suna = ''
			else:
				if suna < '3': suna = u'[COLOR red]' + suna + u'[/COLOR]'
				if suna < '4': suna = u'[COLOR yellow]' + suna + u'[/COLOR]'
				else: suna = u'[COLOR green]' + suna + u'[/COLOR]'
		i = zr.findNext('div', 'sw')
		if not i: i = z
		#print i
		r = i.find('a')
		url = r['href']
		if '://' not in url: url = site_url + url
		yr = re.compile(', ([1-2]{1}\d{3})',re.S).search(zr.text)
		if yr: info['year'] = int(yr.group(1))
		else: is_search = True
		img = i.find('img', 'sk')['src']
		if '://' not in img: img = site_url + img
		#print i
		temp = None
		c = i.find('div', 'sw2')
		if c: c = c.text.splitlines()
		else:
			c = i.findAll('div', re.compile('t'))
			if c:
				temp = []
				for t in c:
					temp.append(t.text)
				c = ''
				for t in range(0, len(temp), 2):
					c += u': '.join([ temp[t],temp[t+1] ]) + u'\n'
				c = c.splitlines()

		ctype = ''
		for j in range(len(c)):
			#print c[j]
			if u'Оригинал:' in c[j]: info['originaltitle'] = c[j].split(':', 1)[1].strip()
			if u'Время:' in c[j]:
				dc = re.compile(u'[ \dxх]*?(\d+) м',re.S).search(c[j])
				if dc:	info['duration'] = int(dc.group(1)) * 60
			if u'Категории:' in c[j]: info['genre'] = c[j].split(':')[1].strip()
			if u'Качество:' in c[j]:
				info['writer'] = c[j].strip()
				if not temp: info['writer'] += u' ' + c[j+1].strip()
			if u'Год:' in c[j]: info['year'] = int(c[j].split(':')[1].strip())
			if u'Раздел:' in c[j]:
						info['tagline'] = c[j]
						ctype = c[j].split(':')[1].lower()
		plot = i.find('p')
		if plot: info['plot'] = plot.text
		if is_search:
			if (u'Мультфильмы' in info['genre']) or (u'Аниме' in info['genre']) or (u'Мультфильмы' in info['tagline']) or (u'Аниме' in info['tagline']):
				data2 = getUrl(url)
				r = re.compile(r',\s*?file:\s*?"(.+?)",',re.S).search(data2)
				if r:
					purl = r.group(1)
					if purl.startswith('/sz.txt'): ctype = ctype + u', Сериалы'
		content_list.append( {'url': r_u(url), 'thumb': img, 'info': info, 'ctype': ctype, 'suna': suna} )
	page = {'max': 1, 'current': 1, 'next': None, 'prev': None}
	pg = soup.find('div', 'navi')
	#print pg
	if pg:
		t = pg.findAll('a')
		cu = pg.findAll('span')
		try: page['max'] = int(t[-2].text)
		except: page['max'] = -1
		try: page['current'] = int(cu[-1].text)
		except: page['current'] = int(cu[-2].text)
		for i in t:
			if u'Вперед' in i.text: page['next'] = i['href']
			if u'Назад' in i.text: page['prev'] = i['href']
		#print page
	return {'data': content_list, 'page': page}

def pars_trailer(data):
	r = re.compile(r'''"trailer\('(http[^']+)'\)"''',re.S).search(data)
	if r:
		return r.group(1)
	else:
		return None

def pars3(data):
	from bs4 import BeautifulSoup
	soup = BeautifulSoup(data, 'html.parser')

	p = soup.find('div', 'content')
	#print p
	content_list = []
	if p:
		info = {'mediatype': 'movie'}
		r = p.find('h1')
		info['title'] = r.text

		g = p.find('div', 'cat').findAll(text=re.compile('[^\s]'))
		info['genre'] = ', '.join(g)
		pl = soup.find('div', 'story')
		if pl:
			pl2=None
			pl1 = pl.find('p')
			if pl1: info['plot'] = pl1.text
			else: pl2 = soup.find('div', 'add')
			if pl2: info['plot'] = pl2.findNext('p').text

		yr = re.compile(', ([1-2]{1}\d{3})',re.S).search(r.text)
		if yr: info['year'] = int(yr.group(1))
		k = soup.find('img', 'kart')
		img = n_u(k['src'])
		#print k
		l = k.findNext('div') # fix old bs4 4.6.2-
		#print l
		ur = l.find('meta', itemprop='url')
		url = ur['content']
		if '://' in url: url = site_url+ '/' + '/'.join(url.split('/')[3:])
		c = l.findAll('div', 'tr')
		n = l.findAll('div', 'tl')
		ctype = u''
		for j in range(len(c)):
			#print n[j].text, ' ', c[j].text
			if u'Оригинал' in n[j].text: info['originaltitle'] = c[j].text
			if u'Время' in n[j].text:
	    			dc = re.compile(u'[ \dxх]*?(\d+) м',re.S).search(c[j].text)
				if dc:	info['duration'] = int(dc.group(1)) * 60
			if u'Качество' in n[j].text: info['writer'] = n[j].text+': '+c[j].text
			if u'Год' in n[j].text: info['year'] = int(c[j].text)
			if u'Раздел' in n[j].text:
						info['tagline'] = n[j].text+': '+c[j].text
						ctype = c[j].text.lower()
		suna = ''
		sunaf = p.find('div', 'rating')
		if sunaf:
			sunav = sunaf.find('meta')
			if sunav:
				info['votes'] = str(sunav['content'])
			sunaf = sunaf.findAll(text=re.compile('[^\n]'))[-1] #'span', style=re.compile('color'))
			suna = sunaf.strip()
			info['rating'] = float(suna)
			if suna < '3': suna = u'[COLOR red]' + suna + u'[/COLOR]'
			if suna < '4': suna = u'[COLOR yellow]' + suna + u'[/COLOR]'
			else: suna = u'[COLOR green]' + suna + u'[/COLOR]'
			suna = suna.strip()
		r = re.compile(r',\s*?file:\s*?"(.+?)",',re.S).search(data)
		if r:
			purl = r.group(1)
			if purl.startswith('/sz.txt'): ctype = ctype + u', Сериалы'
		trailer = pars_trailer(data)
		if trailer:
			info['trailer'] = trailer
		content_list.append( {'url': r_u(url), 'thumb': img, 'info': info, 'ctype': ctype, 'suna': suna} )

	page = {'max': 1, 'current': 1, 'next': None, 'prev': None}
	return {'data': content_list, 'page': page}


def pars4(data):
	from bs4 import BeautifulSoup
	soup = BeautifulSoup(data, 'html.parser')

	v = soup.findAll('div', 'cont')
	fplist=[]
	#i = v[0]
	for i in v:
	#if i:
		name = i.find('h2')
		fp = i.find('a')
		if fp:
			fpurl = fp['href']
			if '://' not in fpurl: fpurl = site_url + fpurl
			fplist.append( ( name.text, r_u(fpurl) ) )
	return fplist

def qurl(url, quality=_quality_):
			urls = url.split(',[')
			listurls = {}
			gl = []
			for i in urls:
				d = i.replace('[','').split(']')
				if u'4K' in d[0]: d[0] = '4000'
				listurls[str(d[0])] = d[1]
				gl.append( (int(d[0]), d[1]) )
			#print listurls
			gl.sort()
			#print gl
			qprev = 0
			for i in gl:
				if int(i[0]) > int(quality):
					q = qprev
					break
				qprev = i[0]
				q = i[0]
			url = listurls[str(q)]
			return url


def pars_seria(data):
	lurls = eval(data)
	list_seria = []
	index = 0
	for i in lurls:
		sezon_name = i['title']
		for j in i['folder']:
			seria_num = j['title']
			url = j['file']
			if ',[' in url:
				url = qurl(url)
			name = sezon_name + ' / ' + seria_num
			list_seria.append( (name.decode('utf8'), url, index) )
			index += 1
	return list_seria

def pars_m3u8(data, quality=_quality_):
	#print data
	listurl = {}
	d = data.splitlines()
	#print d
	for i in d:
		if (i !='') and (i[0] == '#') and ('RESOLUTION=' in i):
			if ('x360' in i) or ('640x' in i): qu = '360'
			elif ('x480' in i) or ('854x' in i): qu = '480'
			elif ('x720' in i) or ('1280x' in i): qu = '720'
			elif ('x1080' in i) or ('1920x' in i): qu = '1080'
			else:
				res = i.split('RESOLUTION=')[1].split(',')[0].split('x')
				#print res
				if int(res[0]) < 1000 and int(res[1]) < 480 : qu = '360'
				elif int(res[0]) < 1000 and int(res[1]) < 720 : qu = '480'
				elif int(res[0]) > 1000 and int(res[1]) > 480 and int(res[1]) < 720 : qu = '720'
				else: qu = '1080'
		if (i != '') and (i[0] != '#'):
			#print i
			listurl[qu] = i
			#if i.startswith('http'): listurl[qu] = i
			#else: listurl[qu] = url[:url.rfind('/')+1] + i
	#print listurl
	gl = []
	for i in listurl:
			gl.append((int(i), listurl[i]))
	gl.sort()
	qprev = 0
	for i in gl:
			if int(i[0]) > int(quality):
					q = qprev
					break
			qprev = i[0]
			q = i[0]
	if q == 0: q = i[0]
	return listurl[str(q)]

def clear_kinovhd(url):
	import base64
	url = url.replace('#2', '')
	tokens = ('//bnQseg==', '//ay4say4=', '//Z2hiZHRu')
	for i in tokens:
		url = url.replace(i, '')
	#print url
	return base64.b64decode(url)

def clear_kinovhd2(url):
	import base64
	tokens = ('zCvZGZzamRmdWhqIGRzZmlzdWRoaXNhanNkZmRzIGxranNkZ2Y=',
                  'zCvIWpmamtka2pmZHNkc2YgZHNmIGhzZGpmaCBkc2tmIGo=',
		  'zCvZGYgZHNmIGRzamZoIGRzamhmIGpzZGhmIHVldXdpb2VyIWRqa2o=',
		  'zCvITMyM2Rkamxma2Rkc2YgbGRzZmggamhkc2YgZHMgZnNq',
		  'zCvZHNmZHNoamtmaGpkc2ggZmR1b3Bld2l1',
		  'zCvITMyM2Rkamxma2Rkc2YgbGRzZmggamhkc2YgZHMgZnNq',
                  'd29waSE=')

	url = url.replace('#2', '')
	index = 0
	while index < 11:
		index += 1
		for i in tokens:
			url = url.replace(i, '')
		#print url
		if ('=' not in url[:-1]) or (index == 10 and url.endswith('==')):
			#print url
			return base64.b64decode(url)

	#file('/home/osmc/de-kinovhd.net.txt', 'wb').write(url)
	return None


def pars_play(data, quality=_quality_, videom3u8=_videom3u8_):
	r = None
	if videom3u8:
		r = re.compile(r',\s*?file:\s*?"(.+?\.m3u8)",',re.S).search(data)
		if not r:
			r = re.compile(r',\s*?file:\s*?"(#2.+?)",',re.S).search(data)
	if not r: r = re.compile(r'e",\s*?file:\s*?"(.+?)",',re.S).search(data)
	if not r: r = re.compile(r',\s*?file:\s*?"(.+?)",',re.S).search(data)
	if r:
		url = r.group(1)
		#print url
		if url.startswith('#2'):
			url = clear_kinovhd2(url)
		if '.m3u8' in url:
			data = getUrl(url)
			#print data
			#file('/home/osmc/m3u8-kinovhd.txt', 'wb').write( data )
			url = pars_m3u8(data)
		elif url.startswith('/sz.txt'):
			data2 = getUrl(site_url+url)
			url = pars_seria(data2)
		elif ',[' in url:
			url360 = qurl(url,'360')
			rs = url360[url360.rfind('&ha='):]
			url = qurl(url)
			url = url[:url.rfind('&ha=')] + rs
	return url


def catalog(url=site_url):
	if not url: url = site_url
	data = getUrl(n_u(url))
	#file('/home/osmc/catalog.txt', 'wb').write( data )
	return pars2(data)

def genre():
	data = getUrl(site_url)
	return pars(data)

def filmspro():
	data = getUrl(site_url+'/фильмы-про/')
	return pars4(data)

def videoinfo(url):
	data = getUrl(n_u(url))
	#file('/home/osmc/search.txt', 'wb').write( data )
	res = pars3(data)
	res['url'] = pars_play(data)
	return res


def search(text):
	if isinstance(text, unicode): text = text.encode('utf8')
	url, data = postUrl(site_url,{'do': 'search', 'subaction': 'search' , 'story': text, 'submit': r'Найти'} )
	#file('/home/osmc/search.txt', 'wb').write( data )
	if url == site_url:
		return False, pars2(data, True)
	else:
		return True, pars3(data)


def trailer_link(url):
	try:
		from xbmcup.errors import log
		log(url,'url=')
	except: pass
	data = getUrl(n_u(url))
	link = pars_trailer(data)
	if link: return link, None
	else: return None, ['Трейлер не найден.']

def play_link(url, index=None):
	try:
		from xbmcup.errors import log
		log(url,'url=')
	except: pass
	#headers['User-Agent'] = 'Mozilla/5.0 (Android 8.1.0; Mobile; rv:67.0) Gecko/67.0 Firefox/67.0'
	data = getUrl(n_u(url))
	#file('/home/osmc/z2-kinovhd.net.txt', 'wb').write(data)
	if index or index == 0:
		return pars_play(data)[index][1], None
	else:
		return pars_play(data), None


if __name__ == '__main__':

	#file('/home/osmc/film.txt', 'wb').write( getUrl( genre()[0][1] ) )
	data = file('/home/osmc/search.txt', 'rb').read()
	#print play_link('/2464-ганц-о-2016.html')
	#print search('джуманджи новый уровень')
	#print trailer_link('/2464-ганц-о-2016.html')
	#print search('джуманджи')
	#print search('том и джерри')
	#data = file('/home/osmc/z2-kinovhd.net.txt', 'rb').read()
        print 
	pars3(data)
	#print pars_trailer(data)
	#print pars_m3u8(data)

	#data = file('/home/osmc/z2-kinovhd.net.txt', 'rb').read()
	#print pars_play(data)

	pass

