# -*- coding: utf-8 -*-

import sys, os
import re
import socket
import random, time
socket.setdefaulttimeout(10)

site_url = 'https://kinovod.net' #.cc'

randindex = random.randint(0,1)

try:
	from xbmcup.app import _setting
	_quality_ = _setting['quality']
	_domain_ = _setting['site_domain']
	_rating_ = int(_setting['rating_type'])
	_subtitles_ = bool(_setting['view_subtitles'] == 'true')
	_get_domain_ = bool(_setting['get_domain'] == 'true')
	_kodi_ = True
	if _domain_:
		_domain_ = _domain_.replace('https://', '').replace('http://', '').strip('/').strip()
		if _domain_:
			if _setting['use_https'] == 'true': site_url = 'https://' + _domain_
			else: site_url = 'http://' + _domain_
except Exception:
	_get_domain_ = False
	_kodi_ = False
	_subtitles_ = True
	_rating_ = 0
	_quality_ = '720'
	sys.path.append(os.path.join(os.path.dirname(__file__), '..', 'script.module.beautifulsoup4', 'lib'))


headers = {
	'User-Agent': 'Mozilla/5.0 (Windows NT 6.1; rv:10.0.2) Gecko/20100101 Firefox/10.0.2',
	'Accept': 'text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8',
	'Accept-Language': 'ru-ru,ru;q=0.8,en-us;q=0.5,en;q=0.3',
	'Cache-Control': 'no-cache',
	'Referer': site_url
	}

Quality = (360, 480, 720, 1080)

class Error(Exception):
    def __init__(self, msg):
	self.msg = msg

    def __str__(self):
	return '{}'.format(self.msg)

def getUrl(url, rurl=False, rheaders=False, referer=None, proxy=None):
	from xbmcup.net import HTTP
	http = HTTP()
	if isinstance(url, unicode):
		url = url.encode('utf8')
	if referer: headers['Referer'] = referer
	if proxy:
		response = http.fetch(url, headers=headers, cookies='kinovod.moz', proxy_protocol=url.split(':')[0], proxy_host=proxy.split(':')[0], proxy_port=proxy.split(':')[1])
	else:
		response = http.fetch(url, headers=headers, cookies='kinovod.moz')
	if response.code == 200:
		if rurl:
			return response.url , response.body
		elif rheaders:
			return response.headers, response.body
		else:
			return response.body
        else:
		try:
			from xbmcup.errors import message
			message('Ошибка '+str(response.code)+' HTTP:', response.error)
			import xbmc
			xbmc.sleep(3000)
		except: pass
		raise Error(response.error)
		return response.code

def postUrl(url, param):
	from xbmcup.net import HTTP
	http = HTTP()
	if isinstance(url, unicode):
		url = url.encode('utf8')
	response = http.fetch(url, method='POST', params=param, headers=headers, cookies='kinovod.moz')
	if response.code == 200:
			return response.url , response.body
        else:
		try:
			from xbmcup.errors import message
			message('Ошибка '+str(response.code)+' HTTP:', response.error)
			import xbmc
			xbmc.sleep(3000)
		except: pass
		raise Error(response.error)
		return response.code

def GetProxyList():
	import httplib
	conn = httplib.HTTPConnection("antizapret.prostovpn.org")
	conn.request("GET", "/proxy.pac", headers={"User-Agent": 'Mozilla/4.0 (compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1) ; .NET CLR 1.1.4322; .NET CLR 2.0.50727; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729; .NET4.0C)'})
	r1 = conn.getresponse()
	data = r1.read()
	conn.close()
	proxylist = re.compile('PROXY (.+?); DIRECT').findall(data)
	#print proxylist
	return proxylist

def proxy_update():
	return GetProxyList()[0]

if _get_domain_:
		try: pt=float(_setting['proxy_time'])
		except: pt=0
		if time.time()-pt > 36000:
			proxy1 = proxy_update()
			#proxy1=__setting['proxy_serv']
			#print proxy1
			try:
				_setting['proxy_time'] = str(time.time())
			except: pass
			data = getUrl('https://t.me/s/kinovodnet', proxy=proxy1)
			#file('/home/osmc/tme-kinovodnet.txt', 'wb').write(data)
			r = re.compile('"(http[s]?://kinovod[0-9]*?\.[a-z]*?)/"',re.S|re.U).findall(data)
			#print r
			redirect_url = r[-1]
			if site_url != redirect_url:
				try:
					_setting['site_domain'] = redirect_url.split('/')[2]
					_setting['use_https'] = 'true' if redirect_url.split(':')[0] == 'https' else 'false'
				except: pass
				site_url = redirect_url
				#print redirect_url, site_url
				#print _setting

def r_u(url):
	if url.startswith(site_url): return url.replace(site_url,'')
	else: return url

def n_u(url):
	if ('://' in url) or (url is None) or (url[0] != '/'): return url
	else: return site_url + url

def pars(data):
	from bs4 import BeautifulSoup
	soup = BeautifulSoup(data, 'html.parser')

	g_t_list = []
	g = soup.find('div', id='main')
	for i in g.findAll('a', 'h3'):
		#print i.text, i['href']
		g_t_list.append( (i.text, r_u(i['href'])) )
	video_list = []
	v = g.findAll('div', 'row items')
	#i = v[0]
	#print i
	for i in v:
	#if i:
		v_temp_list = []
		x = i.findAll('div', 'col-xs-2')
		#j = x[0]
		for j in x:
		#if j:
			info = {}
			img = n_u(j.find('img')['src'])
			tr = j.find('div', 'title').find('a')
			#print j
			info['title'] = tr.text
			url = r_u(tr['href'])
			yq = j.find('div', 'desc')
			yqt = ''
			if yq:
				yqt = yq.text
				yr = re.compile('([1-2]{1}\d{3})',re.S).search(yqt)
				if yr:
					info['year'] = int(yr.group(1))
				if ',' in yqt:
					info['tagline'] = u'Качество: ' + yqt.split(',')[1].strip()
			sr = j.find('span', 'label')
			if sr:
				info['plotoutline'] = sr.text
			v_temp_list.append( {'url': url, 'thumb': img, 'info': info, 'yq': yqt} )
		#print v_temp_list
		video_list.append( v_temp_list )

	s = soup.find('div', id='sidebar')
	l = s.findAll('a', 'sidebar-link')
	start = False
	for i in l:
		#print i.text, i['href']
		if i.text == u'Фильмы':
			start = True
			temp_list = []
		elif i.text == u'Биография':
			category = []
			category.extend(temp_list)
			temp_list = []
		elif i.text == u'Австралия':
			genres = []
			genres.extend(temp_list)
			temp_list = []
			first = True
		elif i.text.isdigit() and first:
			country = []
			country.extend(temp_list)
			first = False
			temp_list = []
		elif i.text == u'Показать все':
			years = []
			years.extend(temp_list)

		if start:
			if i['href'][0] == '/':
				temp_list.append( (i.text, i['href']) )
	#print category
	#print genres
	#print country
	#print years
	return {'gpt': g_t_list, 'data': video_list, 'category': category, 'genres': genres, 'country': country, 'years': years}


def pars2(data, is_sort=True):
	from bs4 import BeautifulSoup
	soup = BeautifulSoup(data, 'html.parser')

	v = soup.findAll('div', 'row items')
	v_temp_list = []
	podbor_list = []
	navi = soup.find('ul', 'nav nav-tabs')
	if navi:
		navtabs = navi.findAll(text=re.compile('[^\s]'))
	#i = v[0]
	#print i
	inx_nav = 0
	for i in v:
	#if i:
		if navi:
			info = {}
			info['title'] = u'[COLOR green]' + navtabs[inx_nav] + u':[/COLOR]'
			inx_nav += 1
			v_temp_list.append( {'url': 0, 'thumb': None, 'info': info, 'yq': ''} )
		x = i.findAll('div', 'col-xs-2')
		#j = x[0]
		for j in x:
		#if j:
			info = {}
			img = n_u(j.find('img')['src'])
			tr = j.find('div', 'title').find('a')
			#print j
			info['title'] = tr.text
			url = r_u(tr['href'])
			yq = j.find('div', 'desc')
			yqt = ''
			if yq:
				yqt = yq.text
				yr = re.compile('([1-2]{1}\d{3})',re.S).search(yqt)
				if yr:
					info['year'] = int(yr.group(1))
				if ',' in yqt:
					info['tagline'] = u'Качество: ' + yqt.split(',')[1].strip()
			sr = j.find('span', 'label')
			if sr:
				info['plotoutline'] = sr.text
			v_temp_list.append( {'url': url, 'thumb': img, 'info': info, 'yq': yqt} )
		#print v_temp_list

		y = i.findAll('div', 'col-xs-3')
		#j = y[0]
		for j in y:
		#if j:
			info = {}
			img = n_u(j.find('img')['src'])
			tr = j.find('div', 'title').find('a')
			info['title'] = tr.text
			url = r_u(tr['href'])
			podbor_list.append( {'url': url, 'thumb': img, 'info': info} )

	v = soup.find('div', style='margin-bottom:30px;')
	if v:
		n = v.findAll('a')
		if n:
			podbor_list.append( {'url': 0, 'thumb': None, 'info': {'title':u'[COLOR green]Найдены имена:[/COLOR]'} } )
			for i in n:
				info = {}
				info['title'] = i.text
				podbor_list.append( {'url': r_u(i['href']), 'thumb': None, 'info':info} )

	page = {'max': 1, 'current': 1, 'next': None, 'prev': None}
	pg = soup.find('ul', 'pagination')
	#print pg
	if pg:
		t = pg.findAll('a')
		cu = pg.findAll('span')
		try: page['max'] = int(t[-1]['href'].split('page=')[1])
		except: page['max'] = -1
		try: page['current'] = int(cu[-1].text)
		except: page['current'] = int(cu[-3].text)
		for i in t:
			if u'Следующая' in i.text: page['next'] = i['href']
			if u'Предыдущая' in i.text: page['prev'] = i['href']
		#print page

	sort_list = []
	if is_sort and (page['current'] == 1):
		names = []
		n = soup.findAll('span', 'dropdown-u')
		if n:
			for i in n:
				names.append( i.text )
			v = soup.findAll('ul', 'dropdown-menu')
			for i, name in zip(v, names):
				#actives = []
				sort_name = name+u': '
				actives_name = []
				a = i.findAll('li', 'active')
				if a:
					for a1 in a:
						a2 = a1.find('a')
						if a2:
							#actives.append( (a2.text , a2['href']) )
							actives_name.append( a2.text)
					sort_param = u', '.join(actives_name)
				else:
					sort_param = u'Все'
					a = i.findAll('a', 'active')
					if a:
						for a2 in a:
							#actives.append( (a2.text , a2['href']) )
							actives_name.append( a2.text)
						sort_param = u', '.join(actives_name)
				sort_name = u''.join([u'[COLOR green]', sort_name, sort_param, u'[/COLOR]'])
				#print sort_name
				#print actives
				all_sort = []
				for j in i.findAll('a'):
					s_name = j.text
					if s_name in actives_name: s_name = u'[COLOR gold]' + s_name + u'[/COLOR]'
					all_sort.append( (s_name, j['href']) )
				#print all_sort
				sort_list.append( {'name': sort_name, 'sort': all_sort} ) # 'active': actives} )
	return {'data': v_temp_list, 'page': page, 'podbor': podbor_list, 'filter': sort_list}


def pars3(data, rating_type=_rating_):
	from bs4 import BeautifulSoup
	soup = BeautifulSoup(data, 'html.parser')

	ur= soup.find('meta', property='og:url')
	url = ur['content']
	p = soup.find('div', id='movie')
	content_list = []
	if p:
		info = {}
		r = p.find('h1')
		if r: info['title'] = r.text
		r = p.find('h4', 'alternative_title')
		if r: info['originaltitle'] = r.text
		l = p.find('div', 'poster-data')
		t = l.find('img')
		if t: img = n_u(t['src'])
		if rating_type == 0:
			r = l.find('div', 'rating-votes')
			if r:
				rt = re.compile(u'([\d\.]+) \(([ \d]+)',re.S).search(r.text)
				if rt:
					info['rating'] = float(rt.group(1))
					info['votes'] = rt.group(2).strip().replace(' ','')
		g = p.find('ul')
		if g:
			text = ''.join(g.findAll(text=True))
		for j in text.splitlines():
			#print j
			if u'Страна:' in j: info['studio'] = j.split(':')[1].strip()
			if u'Жанр:' in j: info['genre'] = j.split(':')[1].strip()
			if u'Слоган:' in j: info['tagline'] = j.split(':')[1].strip()
			if u'Сценарий:' in j: info['writer'] = j.split(':')[1].strip()
			if u'Режиссер:' in j: info['director'] = j.split(':')[1].strip()
			if u'Продолжительность:' in j:
	    			dc = re.compile(u'(\d+:\d+:\d+)',re.S).search(j)
				if dc:
					ts = dc.group(1).split(':')
					info['duration'] = int(ts[0])*60*60+int(ts[1])*60+int(ts[2])
			if u'Качество:' in j: info['plotoutline'] = j
			if u'Перевод:' in j: info['mpaa'] = j
			if u'Год:' in j: info['year'] = int(j.split(':')[1].strip())
			if u'Актеры:' in j:
				info['cast'] = [i.strip() for i in j.split(':')[1].split(',') if i]
			if rating_type == 1:
				if u'Рейтинг Кинопоиска:' in j:
					r = j.split(':')[1]
					info['rating'] = float(r.split('(')[0].strip())
					info['votes'] = r.split('(')[1].replace(' ','').strip(')')
			elif rating_type == 2:
				if u'Рейтинг IMDb:' in j:
					r = j.split(':')[1]
					info['rating'] = float(r.split('(')[0].strip())
					info['votes'] = r.split('(')[1].replace(' ','').strip(')')

		o = p.find('div','body')
		if o:
			info['plot'] = o.text
		r = re.compile(r'<iframe class="embed-responsive-item" src="https://www.youtube.com/embed/([^"]+?)" allowfullscreen></iframe>',re.S).search(data)
		if r: info['trailer'] = 'plugin://plugin.video.youtube/play/?video_id=' + r.group(1)

		content_list.append( {'url': r_u(url), 'thumb': img, 'info': info} )

	n = p.find('ul', 'list-unstyled related')
	podbor_list = []
	if n:
		numb = 1
		podbor_list.append( {'url': 0, 'thumb': None, 'info': {'title': u'[COLOR green]Порядок просмотра:[/COLOR]'} } )
		for i in n.findAll('a'):
			podbor_list.append( {'url': i['href'], 'thumb': None, 'info': {'title': unicode(numb) + u'. ' + i.text} } )
			numb += 1

	page = {'max': 1, 'current': 1, 'next': None, 'prev': None}
	return {'data': content_list, 'page': page, 'podbor2': podbor_list}


def vtt_to_srt(fileContents):
	replacement = re.sub(r'(\d\d:\d\d:\d\d).(\d\d\d) --> (\d\d:\d\d:\d\d).(\d\d\d)(?:[ \-\w]+:[\w\%\d:]+)*\n', r'\1,\2 --> \3,\4\n', fileContents)
	replacement = re.sub(r'(\d\d:\d\d).(\d\d\d) --> (\d\d:\d\d).(\d\d\d)(?:[ \-\w]+:[\w\%\d:]+)*\n', r'00:\1,\2 --> 00:\3,\4\n', replacement)
	replacement = re.sub(r'(\d\d).(\d\d\d) --> (\d\d).(\d\d\d)(?:[ \-\w]+:[\w\%\d:]+)*\n', r'00:00:\1,\2 --> 00:00:\3,\4\n', replacement)
	replacement = re.sub(r'WEBVTT\n', '', replacement)
	replacement = re.sub(r'Kind:[ \-\w]+\n', '', replacement)
	replacement = re.sub(r'Language:[ \-\w]+\n', '', replacement)
	#replacement = re.sub(r'^\d+\n', '', replacement)
	#replacement = re.sub(r'\n\d+\n', '\n', replacement)
	replacement = re.sub(r'<c[.\w\d]*>', '', replacement)
	replacement = re.sub(r'</c>', '', replacement)
	replacement = re.sub(r'<\d\d:\d\d:\d\d.\d\d\d>', '', replacement)
	replacement = re.sub(r'::[\-\w]+\([\-.\w\d]+\)[ ]*{[.,:;\(\) \-\w\d]+\n }\n', '', replacement)
	replacement = re.sub(r'Style:\n##\n', '', replacement)
	id = 1
	out = ''
	for i in replacement.splitlines():
		if i == '':
			if id == 1:
				out = out + str(id) + '\n'
			else:
				out = out + '\n' + str(id) + '\n'
			id += 1
		else:
			out = out + i + '\n'
	return out

def qurl(url, quality=_quality_):
			urls = url.split(',[')
			listurls = {}
			gl = []
			for i in urls:
				d = i.replace('[','').split(']')
				if u'4K' in d[0]: d[0] = '4000'
				elif u'p' in d[0]: d[0] = d[0].strip('p')
				listurls[str(d[0])] = d[1]
				gl.append( (int(d[0]), d[1]) )
			#print listurls
			gl.sort()
			#print gl
			qprev = 0
			for i in gl:
				if int(i[0]) > int(quality):
					q = qprev
					break
				qprev = i[0]
				q = i[0]
			url = listurls[str(q)]
			return url

def turl(url):
	turls = url.split(';{')
	list_trans = []
	index = 0
	for i in turls:
		url = i.split('}')[1]
		name = i.split('}')[0].strip('{')
		list_trans.append( (name.decode('utf8'), url, None, index) )
		index += 1
	return list_trans

def surl(url):
	surls = url.split(',[')
	list_subt = []
	for i in surls:
		url = i.split(']')[1]
		list_subt.append( url )
	return list_subt

def pars_seria(data):
	lurls = eval(data)
	list_seria = []
	index = 0
	for i in lurls:
		sezon_name = i['comment']
		if 'playlist' in i:
			for j in i['playlist']:
				seria_num = j['comment']
				url = j['file']
				if '[' in url:
					url = qurl(url)
				subt = j['subtitle']
				if subt:
					suburl = surl(subt)
				else: suburl = None
				name = sezon_name + ' / ' + seria_num
				list_seria.append( (name.decode('unicode-escape'), url, suburl, index) )
				index += 1
		else:
			url = i['file']
			if '[' in url:
				url = qurl(url)
			subt = i['subtitle']
			if subt:
				suburl = surl(subt)
			else: suburl = None
			list_seria.append( (sezon_name.decode('unicode-escape'), url, suburl, index) )
			index += 1
	return list_seria

def pars_play(data, quality=_quality_):
	t = re.compile('(<div class="one-video" id="trailer">)',re.S).search(data)
	if t:
		t = re.compile(r'<iframe class="embed-responsive-item" src="https://www.youtube.com/embed/([^"]+?)" allowfullscreen></iframe>',re.S).search(data)
		if t: y_id = t.group(1)
		return 'plugin://plugin.video.youtube/play/?video_id=' + y_id, None
	r = re.compile('var MOVIE_ID\s*?=\s*?(\d+?);',re.S).search(data)
	if r: m_id = r.group(1)
	#print m_id
	r = re.compile('var VOD_HASH\s*?=\s*?"(.+?)";',re.S).search(data)
	if r: v_hash = r.group(1)
	#print v_hash
	r = re.compile('var VOD_TIME\s*?=\s*?"(.+?)";',re.S).search(data)
	if r: v_time = r.group(1)
	#print v_time
	r = re.compile('var IDENTIFIER\s*?=\s*?"(.+?)";',re.S).search(data)
	if r: identifier = r.group(1)
	#print identifier
	param = {'identifier': identifier, 'st': v_hash, 'e': v_time, 'file_type': 'hls', 'player_type': 'new'}
	from urllib import urlencode
	data2 = getUrl(site_url+'/vod/'+m_id+'?'+urlencode(param) )
	#print data2
	#file('/home/osmc/kinovod-data.txt', 'wb').write(data2)
	if data2:
		subtitles = None
		if data2.startswith('file|'):
			data3 = data2.split('file|')[1].split('|')[0]
			url = qurl(data3)
			if ';{' in url:
				url = turl(url)
			data4 = data2.split('|')[2]
			if data4:
				subtitles = surl(data4)
		elif data2.startswith('pl|'):
			data2 = data2.split('pl|')[1].split('|')[0]
			url = pars_seria(data2.replace('\/','/'))
	return url , subtitles


def catalog(url=site_url):
	if not url: url = site_url
	data = getUrl(n_u(url))
	#file('/home/osmc/catalog.txt', 'wb').write( data )
	return pars2(data)

def startpage():
	data = getUrl(site_url)
	return pars(data)

def genre():
	data = getUrl(site_url)
	return pars(data)


def videoinfo(url):
	data = getUrl(n_u(url))
	#file('/home/osmc/kinovod.txt', 'wb').write( data )
	res = pars3(data)
	res['url'] = pars_play(data)[0]
	return res

def search(text):
	if isinstance(text, unicode): text = text.encode('utf8')
	from urllib import urlencode
	url, data = getUrl(site_url+'/search?'+urlencode({'query': text}), rurl=True)
	#file('/home/osmc/search.txt', 'wb').write( data )
	if url.startswith(site_url+'/search?'):
		return False, pars2(data, False)
	else:
		return True, pars3(data)


def subt_convert(subtlist, subtitleson=_subtitles_):
	if subtitleson and subtlist:
		subt_list = []
		for i in subtlist:
				if '.vtt' in i:
					name = i.split('/')[-1].replace('.vtt','.srt')
					isu = i
					if ' or ' in i: isu = i.split(' or ')[randindex]
					data_vtt = getUrl(isu)
					data_srt = vtt_to_srt(data_vtt)
					if _kodi_:
						from xbmcup.app import Handler
						sdir = Handler().path('srt')
						if not os.path.isdir(sdir): os.mkdir(sdir)
						f_name = Handler().path('srt', name)
					else:
						f_name = name
					file(f_name, 'wb').write(data_srt)
					subt_list.append( f_name )
				else:
					subt_list.append( i )
		return subt_list
	else:
		return None

def play_link2(url, index=None):
	try:
		from xbmcup.errors import log
		log(url,'url=')
	except: pass
	data = getUrl(n_u(url))
	#file('/home/osmc/z2-kinovod.net.txt', 'wb').write(data)
	d_play = pars_play(data)
	try:
		from xbmcup.errors import log
		log(d_play,'d_play=')
	except: pass
	if index or index == 0:
		if d_play[1]:
			return [ d_play[0][index][1], subt_convert( d_play[1] ) ], None
		return [ d_play[0][index][1], subt_convert( d_play[0][index][2] ) ], None
	else:
		if d_play[1]:
			return [d_play[0], subt_convert(d_play[1]) ], None
		return d_play, None


def play_link(url, index=None):
	d = play_link2(url, index)
	if ' or ' in d[0][0]:
		return ( d[0][0].split(' or ')[randindex], d[0][1] ), d[1]
	return d

if __name__ == '__main__':

	data = file('/home/osmc/kinovod.txt', 'rb').read()
	#print(play_link('/film/43176-tihoe-mesto-2'))
	#print(videoinfo('/film/43176-tihoe-mesto-2'))
	pass

