# -*- coding: utf-8 -*-

import os, sys, gc
PY2 = sys.version_info.major == 2
sys.path.append(os.path.join(os.path.dirname(__file__)))
sys.path.append(os.path.join(os.path.dirname(__file__), 'xbmcup'))
import xbmc, xbmcplugin, xbmcgui

from xbmcup.app import Link, Handler, Plugin, _setting, UrlLink, translatePath
from xbmcup.utils23 import *
import megapeer
from history import History, HistoryAdd

_view_ = _setting['view']

plugin = Plugin()


def normname(s):
	if ' (' in s: s = s[:s.find(' (')]
	return s


@plugin.radd()
class Menu(Handler):
	def handle(self):
		self.item(Link('catalog',{'search': True}), title='[Поиск]')
		self.item(Link('history'), title='[История поиска]')
		#self.item(Link(Filters), title='Умный поиск')
		self.item(Link(Catalog, {'url': '/all_torrents.php'}), title='Все раздачи')
		self.item(Link(Glav), title='Разделы')
		self.item(Link(Genres), title='Жанры')
		#self.item(Link(GenreAudioBook), title='Жанр Аудиокниг')
		#self.item(Link(Catalog, {'url': '/audio'}), title='Музыка')
		#self.item(Link(Authors), title='Авторы')
		#self.item(Link(Readers), title='Исполнители')
		#self.item(Link(TopWeek), title='Топ книг за неделю')
		self.render(nextmode=_view_)


@plugin.radd()
class Filters(Handler):
	def handle(self):
		nazvanie = self.argv.get('nazvanie')
		cikl = self.argv.get('cikl')
		ispolnitel = self.argv.get('ispolnitel')
		autor = self.argv.get('autor')

		sort_i = self.argv.get('sort_i', 0)
		order_i = self.argv.get('order_i', 0)
		d = self.argv.get('d')
		if d is None:
			d = megapeer.filter()
			replace = False
		else: replace = True

		if nazvanie == True:
			nazvanie = self.kbdinput('Введите название книги:')
			if nazvanie is None: return True
		elif cikl == True:
			cikl = self.kbdinput('Введите название цикла:')
			if cikl is None: return True
		elif ispolnitel == True:
			ispolnitel = self.kbdinput('Введите фамилию чтеца:')
			if ispolnitel is None: return True
		elif autor == True:
			autor = self.kbdinput('Введите фамилию автора:')
			if autor is None: return True
		elif isinstance(sort_i, bool):
			index = xbmcgui.Dialog().select(self.nameaddon, [ x[1] for x in d['sort'] ])
			if index < 0:
				return True
			else:
				sort_i = index
		elif isinstance(order_i, bool):
			index = xbmcgui.Dialog().select(self.nameaddon, [ x[1] for x in d['order'] ])
			if index < 0:
				return True
			else:
				order_i = index
		n_nazv = nazvanie if nazvanie else 'Введите название книги'
		n_cikl = cikl if cikl else 'Введите название цикла'
		n_ispo = ispolnitel if ispolnitel else 'Введите фамилию чтеца'
		n_auto = autor if autor else 'Введите фамилию автора'
		self.item(Link(Filters,{'d':d, 'nazvanie': True, 'cikl': cikl, 'ispolnitel': ispolnitel, 'autor': autor, 'sort_i': sort_i, 'order_i': order_i}) , title=n_nazv)
		self.item(Link(Filters,{'d':d, 'nazvanie': nazvanie, 'cikl': True, 'ispolnitel': ispolnitel, 'autor': autor, 'sort_i': sort_i, 'order_i': order_i}) , title=n_cikl)
		self.item(Link(Filters,{'d':d, 'nazvanie': nazvanie, 'cikl': cikl, 'ispolnitel': True, 'autor': autor, 'sort_i': sort_i, 'order_i': order_i}) , title=n_ispo)
		self.item(Link(Filters,{'d':d, 'nazvanie': nazvanie, 'cikl': cikl, 'ispolnitel': ispolnitel, 'autor': True, 'sort_i': sort_i, 'order_i': order_i}) , title=n_auto)
		self.item(Link(Filters,{'d':d, 'nazvanie': nazvanie, 'cikl': cikl, 'ispolnitel': ispolnitel, 'autor': autor, 'sort_i': True, 'order_i': order_i}), title=d['sort'][sort_i][1])
		self.item(Link(Filters,{'d':d, 'nazvanie': nazvanie, 'cikl': cikl, 'ispolnitel': ispolnitel, 'autor': autor, 'sort_i': sort_i, 'order_i': True}), title=d['order'][order_i][1])
		f = {}
		def _enc(s):
			if isinstance(s, unicode): s = s.encode('utf8')
			return s
		if isinstance(nazvanie, basestring) and _enc(nazvanie) != '': f['nazvanie'] = _enc(nazvanie)
		if isinstance(cikl, basestring) and _enc(cikl) != '': f['cikl'] = _enc(cikl)
		if isinstance(ispolnitel, basestring) and _enc(ispolnitel) != '': f['t-x.ispolnitel;x.ispolnitel2;x.ispolnitel3'] = _enc(ispolnitel)
		if isinstance(autor, basestring) and _enc(autor) != '': f['autor'] = _enc(autor)
		f['order_by'] = d['sort'][sort_i][0]
		if order_i > 0: f['order'] = d['order'][order_i][0]
		from urllib import urlencode
		furl = urlencode(f).replace('&','/')
		url = '/f/'+furl
		self.item(Link(Catalog,{'url':url, 's_kbd': True}), title='Найти книги')
		self.item(Link(Filters,{'d':d}), title='Очистить список')
		self.render(nextmode=_view_, replace=replace)

@plugin.radd()
class Glav(Handler):
	def handle(self):
		data = megapeer.glav()
		for i in data['glav']:
			self.item(Link('catalog',{'url': i[1]}), title=i[0])
		self.render(nextmode=_view_)


@plugin.radd()
class Genres(Handler):
	def handle(self):
		data = megapeer.genres()
		for i in data['genres']:
			self.item(Link('catalog',{'url': i[1]}), title=i[0])
		self.render(nextmode=_view_)


@plugin.radd()
class GenreAudioBook(Handler):
	def handle(self):
		data = megapeer.genreaudiobook()
		for i in data:
			self.item(Link('catalog',{'url': i[1]}), title=i[0])
		self.render(nextmode=_view_)


@plugin.radd('usearch')
@plugin.radd()
class Catalog(Handler):
	def handle(self):
		search = self.argv.get('search')
		search = self.argv.get('keyword', search)
		url = self.argv.get('url')
		s_kbd = self.argv.get('s_kbd', False)
		sort = self.argv.get('sort')
		data = self.argv.get('data', None)
		page = self.argv.get('page')
		if sort:
			index = xbmcgui.Dialog().select(self.nameaddon, [x[0] for x in sort])
			if index < 0:
				return True
			else:
				url = sort[index][1]
		if page and search:
			s1, data = megapeer.nextsearch(search, page)
		elif search:
			if isinstance(search, bool):
				textsearch = self.argv.get('textsearch', '')
				search = self.kbdinput('Поиск', textsearch)
				if search is None: return
				s_kbd = True
				HistoryAdd(search)
			s1, data = megapeer.search(search)
		elif url == 0:
			return True
		elif data is None:
			data = megapeer.catalog(url)
		if (data['data']==[]) and s_kbd and (data['podbor'] ==[]):
			xbmcgui.Dialog().ok(self.nameaddon, 'Ничего не найдено')
		if data.get('filter'):
			for i in data['filter']:
				self.item(Link('catalog', {'sort': i['sort']}), title=i['name'], media='video', popup=self.popup, popup_replace=True)
		for i in data['data']:
			popup = []
			popup.extend(self.popup)
			title = i['info']['title']
			#popup[0] = (Link(BookInfo, {'info': i['info']}), 'Информация о книге')
			popup[0] = (Link(Descript, {'url': i['url']}), 'Описание')
			popup.insert(-1, (Link(ScreenShot, {'url': i['url']}), 'Обложка') )
			popup.insert(-1, (Link('catalog', {'search': True, 'textsearch': title}, True), 'Поиск') )
			popup.insert(-1, (Link(AddTorrserverBase, {'url': i['url'], 'title': title, 'torrent':i['torrent'], 'info':i['info']}), 'Сохранить в базу TorrServer') )
			if i['info'].get('mpaa'): popup.insert(-1, (Link(Filters, {'cikl': normname(i['info']['mpaa'])}, True), 'Искать цикл') )
			if i['info'].get('writer'): popup.insert(-1, (Link(Catalog, {'search': i['info']['writer']}, True), 'Еще книги этого автора') )
			if i['info'].get('plotoutline'):
				title = title + u' (' + i['yq'] + u', ' + i['info']['plotoutline'] + u')'
			elif i.get('yq'):
				title = title + u' (' + i['yq'] + u')'
			if i['info'].get('rating'):
				title = title + u' [' + unicode(i['info']['rating']) + u']'
			if ' MP3' in title or u' МР3' in title:
				title = u'[COLOR gold][B]' + title + u'[/B][/COLOR]'
			elif ' FLAC' in title:
				title = u'[COLOR lightgreen][B]' + title + u'[/B][/COLOR]'
			#self.item(Link('video', {'url': i['url']}), title=title, media='video', info=i['info'], thumb=i['thumb'], popup=popup, popup_replace=True)
			self.item(Link(Torrent, {'url': i['torrent'], 'thumb': i['thumb']}), title=title, media='video', info=i['info'], thumb=i['thumb'], popup=popup, popup_replace=True, folder=False)
		for i in data['podbor']:
			self.item(Link('catalog', {'url': i['url']}), title=i['info']['title'], media='video', info=i['info'], thumb=i['thumb'], popup=self.popup, popup_replace=True)
		if data['page']['next']:
			titlepage = 'Следующая страница '+ str(data['page']['current']+1)+ ' из ' + str(data['page']['max']) + ' >>'
			if data['page']['next'] == '#':
				self.item(Link('catalog',{'page':data['page']['snext'], 'search': search}), title=titlepage)
			else:
				self.item(Link('catalog',{'url':data['page']['next']}), title=titlepage)
		self.render(nextmode=_view_)


@plugin.radd()
class Video(Handler):
	def handle(self):
		url = self.argv.get('url')
		if url == 0:
			return True
		d = megapeer.videoinfo(url)
		data = d['data'][0]
		title = data['info']['title']
		info = data['info']
		self.popupadd(Link(BookInfo, {'info': info}), 'Информация о книге', start=True)
		if d.get('torrent'): self.popupadd(Link(Torrent, {'url': d['torrent'], 'thumb':data['thumb']}, True), 'Открыть торрент')
		if data.get('screenshot'): self.popupadd(Link('screenshot', data['screenshot']), 'Скриншоты' + ' (' + str(len(data['screenshot'])) + ')')
		if d.get('comments'): self.popupadd(Link(Comments, d['comments']), 'Комментарии' + ' (' + str(len(d['comments'])) + ')')
		self.popupadd(Link('catalog', {'search': True, 'textsearch': title}, True), 'Поиск')
		if info.get('mpaa'): self.popupadd(Link(Filters, {'cikl': normname(info['mpaa'])}, True), 'Искать цикл')
		if info.get('writer'):
			if ',' in info['writer']:
				for i in normname(info['writer']).split(','):
					self.popupadd(Link(Catalog, {'search': i.strip()}, True), u'Еще книги ' + i.strip())
				self.popupadd(Link(Catalog, {'search': normname(info['writer'])}, True), 'Еще книги этих авторов')
			else:
				self.popupadd(Link(Catalog, {'search': normname(info['writer'])}, True), 'Еще книги этого автора')
		if isinstance(d['url'], basestring):
			self.item(Link('play',{'url': data['url']}), title=title, media='video', info=info, thumb=data['thumb'], popup=True, popup_replace=True, property=[('IsPlayable','true')], cast=data['cast'], folder=False)
		else:
			self.item(Link('video', {'url': data['url'] }), title=title, media='video', info=data['info'], thumb=data['thumb'], popup=True, popup_replace=True, cast=data['cast'])
			if d['url'] is not None:
				for i in d['url']:
					info['title'] = title + u' / ' + i['title']
					info['tracknumber'] = i['index'] + 1
					self.item(Link('play',{'url': data['url'], 'index': i['index'] }), title=i['title'], media='video', info=info, thumb=data['thumb'], popup=True, popup_replace=True, property=[('IsPlayable','true')], cast=data['cast'], folder=False)
			else:
				self.item(Link('video', {'url': data['url'] }), title='[COLOR yellow]Нет ссылок на аудио.[/COLOR]', media='video', info=info, thumb=data['thumb'], popup=True, popup_replace=True, cast=data['cast'])
				if d.get('pr'): self.item(Link('video', {'url': data['url'] }), title=u'[COLOR pink]'+d['pr']['title']+u'[/COLOR]', media='video', thumb=d['pr']['thumb'], info=info, popup=True, popup_replace=True)
		for i in d['podbor2']:
			self.popupadd(Link(BookInfo, {'info': i['info']}), 'Информация о книге', True, start=True)
			self.item(Link('video', {'url': i['url']}), title=i['info']['title'], media='video', info=i['info'], thumb=i['thumb'], popup=True, popup_replace=True)
		self.render(nextmode=_view_)

@plugin.radd()
class Play(Handler):
	def handle(self):
		url = self.argv.get('url')
		durl = self.argv.get('durl')
		index = self.argv.get('index')
		if url:
			link, error = megapeer.play_link(url, index)
		elif durl: link = durl
		if link == '': error = ['Нет ссылки на аудио.']
		if link:
			#xbmc.Player().play(link)
			item = xbmcgui.ListItem(path=link)
			xbmcplugin.setResolvedUrl(int(sys.argv[1]),True, item)
			xbmc.sleep(100)
		else:
			xbmcgui.Dialog().ok(self.nameaddon, *error)


@plugin.radd()
class Torrent(Handler):
	def handle(self):
		engine = self.setting['p2p_engine']
		self.show_busy()
		if engine == '0':
			self.run(Link(TorrServer, self.argv))
		elif engine == '1':
			import totam
			return totam.opentam(megapeer.n_u(self.argv['url']))
		elif engine == '2':
			data, filelist = megapeer.get_torrent(self.argv['url'])
			from xbmcup.torrserver import Engine
			ts = Engine(data=data)
			self.run(UrlLink('plugin://plugin.video.torrserve/?action=gotInfo&magnet=%s&poster=%s' % (quote_plus(ts.magneturi), quote_plus(self.argv.get('thumb', ''))) ))
		return True

@plugin.radd()
class TorrServer(Handler):
	def handle(self):
		if 'index' in self.argv:
			data = open(_de(translatePath('special://temp/megapeer.torrent')), 'rb').read()
			from xbmcup import torrserver
			torrserver.play(index=self.argv['index'], data=data)
			return True
		else:
			data, filelist = megapeer.get_torrent(self.argv['url'])
			open(_de(translatePath('special://temp/megapeer.torrent')), 'wb').write(data)
			for i in filelist:
				self.argv['index'] = i['id']
				self.item(Link(TorrServer, self.argv), title=i['name'], media='video', info={'title': i['name'], 'size': i['size']}, thumb=self.argv.get('thumb'), playable=True, popup=True)
			self.render(nextmode=_view_)

@plugin.radd()
class ScreenShot(Handler):
	def handle(self):
		self.show_busy()
		url = self.argv.get('url')
		data = megapeer.videoinfo(url)
		from xbmcup import slideshow
		self.hide_busy()
		if data.get('cover'): slideshow.open([data['cover']], 0)
		return True

@plugin.radd()
class BookInfo(Handler):
	def handle(self):
		info = self.argv.get('info')
		text = u''
		if 'writer' in info:	text += u'Автор книги: ' + info['writer'] + u'\n'
		if 'director' in info:	text += u'Читает: ' + info['director'] + u'\n'
		if 'genre' in info:	text += u'Жанр: ' + info['genre'] + u'\n'
		if 'mpaa' in info:	text += u'Цикл: ' + info['mpaa'] + u'\n'
		if 'year' in info:	text += u'Год выпуска: ' + unicode(info['year']) + u'\n'
		if 'tagline' in info:	text += u'Длительность книги: ' + info['tagline'] + u'\n'
		if 'plotoutline' in info: text += u'Качество: ' + info['plotoutline'] + u'\n'
		if 'studio' in info:	text += u'Добавлено: ' + info['studio'] + u'\n'
		if 'plot' in info:	text += u'Описание: ' + info['plot'] + u'\n'
		gui = GuiTextViewer('DialogTextViewer.xml', sys.argv[0], descript=text, title=info['title'])
		gui.doModal()
		del gui
		return True

@plugin.radd()
class Comments(Handler):
	def handle(self):
		d = self.argv
		text = u''
		for a, c in d:
			text += a + u'\n' + c + u'\n\n'
		gui = GuiTextViewer('DialogTextViewer.xml', sys.argv[0], descript=text, title='Комментарии к книге')
		gui.doModal()
		del gui
		return True


@plugin.radd()
class AddTorrserverBase(Handler):
	def handle(self):
		self.show_busy()
		url = self.argv.get('url')
		info = megapeer.videoinfo(url)
		data, filelist = megapeer.get_torrent(self.argv['torrent'])
		from xbmcup import torrserver
		res = torrserver.add(title=self.argv['title'], info={'descript':info['text'], 'poster_path':info['cover'], 'kodi': { 'info' : self.argv['info']} }, data=data)
		if res: xbmcgui.Dialog().ok(self.nameaddon, 'Раздача успешно сохранена в базу TorrServera.')
		return True

@plugin.radd()
class Descript(Handler):
	def handle(self):
		self.show_busy()
		url = self.argv.get('url')
		data = megapeer.videoinfo(url)
		text = data['text']
		gui = GuiTextViewer('DialogTextViewer.xml', sys.argv[0], descript=text, title='Описание')
		self.hide_busy()
		gui.doModal()
		del gui
		return True


class GuiTextViewer(xbmcgui.WindowXMLDialog):
    def __init__(self, *args, **kwargs):
        self.descript = kwargs['descript']
        self.title = kwargs['title']
        xbmcgui.WindowXMLDialog.__init__(self, *args, **kwargs)
    
    def onInit(self):
        #lang = Lang()
        self.getControl(1).setLabel(self.title)
        self.getControl(5).setText(self.descript)
    
    def onFocus(self, control):
        pass


def main():
	plugin.route('history', History)
	plugin.run()


if __name__ == '__main__':

	main()
