# -*- coding: utf-8 -*-
import sys, os
sys.path.append(os.path.dirname(__file__))
from utils23 import PY2
from torconfig import REVERSE, SORTFILE, PATHFILE, SORTPATH, ONLYVIDEO, ONLYAUDIO
import bencode

def torrent_files(torrent, reverse=REVERSE, sortfile=SORTFILE, pathfile=PATHFILE, sortpath=SORTPATH, onlyvideo=ONLYVIDEO, onlyaudio=ONLYAUDIO):
        try:
                info = bencode.bdecode(torrent)['info']
        except bencode.BTFailure as e:
                from errors import log
                log(e)
        else:
                def _decode(s):
                    try:
                        return s.decode('utf8')
                    except:
                        try:
                             return s.decode('cp1251')
                        except:
                             return s

                if 'files' in info:
                   if pathfile:
                            files = [dict(id=i, fullname=_decode(os.sep.join([info['name'], os.sep.join(x['path'])])), path=x['path'], name=_decode(os.sep.join(x['path'])), size=x['length']) for i, x in enumerate(info['files'])]
                   else:
                            files = [dict(id=i, fullname=_decode(os.sep.join([info['name'], os.sep.join(x['path'])])), path=x['path'], name=_decode(x['path'][-1]), size=x['length']) for i, x in enumerate(info['files'])]
                else:
                            files = [dict(id=0, fullname=_decode(info['name']), path=[info['name']], name=_decode(info['name']), size=info['length'])]
                if sortfile:
                    if PY2:
                        if sortpath:
                                files.sort(cmp=lambda f1, f2: cmp(f1['fullname'], f2['fullname']))
                        else:
                                    files.sort(cmp=lambda f1, f2: cmp(f1['name'], f2['name']))
                    else:
                        if sortpath:
                                files = sorted(files, key=lambda f: f['fullname'])
                        else:
                                    files = sorted(files, key=lambda f: f['name'])
                if reverse:
                            files.reverse()
                file_ext= []
                if onlyvideo:
                        video_file_ext = ['3gp', 'avi', 'mkv', 'mp4', 'mov', 'wmv', 'm2ts', 'ts', 'divx', 'ogm', 'm4v',
                                      'flv', 'm2v', 'mpeg', 'mpg', 'mts', 'vob', 'bdmv']
                        file_ext.extend(video_file_ext)
                if onlyaudio:
                        audio_file_ext = ['mp3', 'flac', 'ape', 'ogg', 'ac3', 'dts', 'wma', 'wav', 'aac', 'mp2', 'mka',
                                        'midi', 'aiff', 'it', 's3m', 'mod', 'm4a']
                        file_ext.extend(audio_file_ext)
                if onlyvideo or onlyaudio:
                        files_temp = list()
                        for i in files:
                                if i['name'].split('.')[-1].lower() in file_ext:
                                        files_temp.append(i)
                        files = files_temp
                return files
