# -*- coding: utf-8 -*-
import json
import socket
import threading

from config import TORRSERVED_HOST, PY2
if PY2:
       from urllib2 import HTTPError, URLError, HTTPRedirectHandler, Request, urlopen, HTTPHandler, build_opener
       from urllib import urlencode
else:
       from urllib.parse import urlencode
       from urllib.error import HTTPError, URLError
       from urllib.request import HTTPRedirectHandler, Request, urlopen, HTTPHandler, build_opener

class closing(object):
    def __init__(self, thing):
        self.thing = thing

    def __enter__(self):
        return self.thing

    def __exit__(self, *exc_info):
        self.thing.close()


class NoRedirectHandler(HTTPRedirectHandler):
    def http_error_302(self, req, fp, code, msg, headers):
        import urllib
        infourl = urllib.addinfourl(fp, headers, headers["Location"])
        infourl.status = code
        infourl.code = code
        return infourl

    http_error_300 = http_error_302
    http_error_301 = http_error_302
    http_error_303 = http_error_302
    http_error_307 = http_error_302


def client(url, post_data=None, get_data=None, raw=False, host=None):
    socket.setdefaulttimeout(30)
    if get_data:
        url += '?' + urlencode(get_data)
    if post_data and raw:
        post_data = post_data
    elif post_data:
        try:
            post_data = json.dumps(post_data)
            if not PY2: post_data = post_data.encode('utf8')
        except:
            post_data = {"": ""}
    if host:
        url = host + url
    else:
        url = TORRSERVED_HOST+url
    req = Request(url, post_data)
    req.add_header('Content-Type', 'application/json')
    req.add_header('Accept-Charset', 'utf-8')
    req.add_header('User-Agent', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.8; rv:21.0) Gecko/20100101 Firefox/21.0')

    try:
        with closing(urlopen(req)) as response:
            payload = response.read()

            try:
                if payload:
                    return json.loads(payload.decode('utf-8', 'replace'))
            except:
                return payload
    except HTTPError as e:
        print(e)
        print(e.readlines())
        print(e.code)
        print(e.reason)
        print(e.args)
        return None
    except URLError as e:
        print(e)
        print(e.args)
        print(e.reason)
        return None
    except Exception as e:
        print(e)
        return None

class MyHandler(HTTPHandler):
    def http_response(self, req, response):
        return response


def touch(url):
    o = build_opener(MyHandler())
    t = threading.Thread(target=o.open, args=(url,))
    t.start()


def getTSVer():
    z = client('/echo', get_data={})
    if z is None:
          return
    if not PY2: z = z.decode('utf8')
    ver = tuple(str(z).split('.')[:2])
    if ver == ('1','1'):
          return 1
    elif ver == ('1','2') or ver[0] == 'MatriX':
          return 2
    else:
          return z


def Mto1(d):
    key = {'hash':'Hash', 'file_stats':'FileStats', 'path':'Path', 'id':'Id',
           'download_speed':'DownloadSpeed', 'preloaded_bytes':'PreloadedBytes',
           'preload_size':'PreloadSize', 'connected_seeders':'ConnectedSeeders',
           'active_peers':'ActivePeers', 'total_peers':'TotalPeers', 'length':'Length',
           'loaded_size':'LoadedSize', 'torrent_size':'TorrentSize',
    }
    if d:
       for k in list(d):
            if k in key:
                   if isinstance(d[k], list):
                        for i in range(len(d[k])):
                            if isinstance(d[k][i], dict):
                                 for k2 in list(d[k][i]):
                                       if k2 in key:
                                           d[k][i][key[k2]] = d[k][i][k2]
                                           del d[k][i][k2]
                   d[key[k]] = d[k]
                   del d[k]
    return d
