# -*- coding: utf-8 -*-
import xbmc
import xbmcgui
from collections import OrderedDict
from torrserve.config import ADDON_NAME, ADDON_ICON


resolutions = OrderedDict()
resolutions['[COLOR=FFFC3401]240p[/COLOR]'] = ['240p', u'240р']
resolutions['[COLOR=FFA56F01]480p[/COLOR]'] = ['480p', u'480р', 'XviD', 'SATRip']
resolutions['[COLOR=FF539A02]720p[/COLOR]'] = ['720p', u'720р', '720i']
resolutions['[COLOR=FF0166FC]1080p[/COLOR]'] = ['1080p', u'1080р', '1080i']
resolutions['[COLOR=FFF15052]2K[/COLOR]'] = ['2K', '1440p', u'1440р']
resolutions['[COLOR=FF6BB9EC]4K[/COLOR]'] = ['4K', '2160p', u'2160р']


def humanizeSize(size):
    B = u"б"
    KB = u"Кб"
    MB = u"Мб"
    GB = u"Гб"
    TB = u"Тб"
    UNITS = [B, KB, MB, GB, TB]
    HUMANFMT = "%.2f %s"
    HUMANRADIX = 1024.

    for u in UNITS[:-1]:
        if size < HUMANRADIX: return HUMANFMT % (size, u)
        size /= HUMANRADIX

    return HUMANFMT % (size, UNITS[-1])


def notify(message, header=ADDON_NAME, time=5000, image=ADDON_ICON):
    dialog = xbmcgui.Dialog()
    return dialog.notification(toUtf8(header), toUtf8(message), toUtf8(image), time, False)


def toUtf8(string):
    if isinstance(string, unicode):
        return string.encode('utf-8', 'ignore')
    return string


def settingsIsOpen():
    return xbmc.getCondVisibility('Window.IsVisible(10140)') or xbmc.getCondVisibility('Window.IsActive(10140)') or xbmc.getCondVisibility('Window.IsVisible(12002)')


def makeMovieItem(i, remDate=False, size=0):
    trailer = id = studio = ""
    genre = []
    country = []
    casts = []
    directors = []
    writers = []
    if len(i['trailers']['youtube']):
        try:
            id = i['trailers']['youtube'][1]['source']
        except:
            id = i['trailers']['youtube'][0]['source']
        finally:
            trailer = "plugin://plugin.video.youtube/play/?video_id={0}".format(id)

    try:
        for genreName in i['genres']:
            genre.append(genreName['name'])
    except:
        genre = []

    try:
        for cName in i['production_countries']:
            country.append(cName['name'])
    except:
        country = []

    try:
        for c in i['credits']['cast']:
            casts.append({
                'name': c['name'],
                'role': c['character'],
                'thumbnail': "https://image.tmdb.org/t/p/w200{0}".format(c['profile_path']),
                'order': c['order']
            })
    except:
        casts = []

    try:
        for dName in i['credits']['crew']:
            if dName['job'] == "Director":
                directors.append(dName['name'])
            elif dName['department'] == "Writing":
                writers.append(dName['name'])
    except:
        directors = []
        writers = []

    try:
        studio = i.get('production_companies')[0]['name']
    except:
        studio = ""
    duration = 0
    try:
        duration = int(i.get('runtime')) * 60
    except:
        duration = 0
    year = 0
    premiered = i.get('release_date', '')
    try:
        year = int(i.get('release_date')[:4])
    except:
        year = 0
    if remDate:
        year = 0
        premiered = ""

    item = {
        'label': i.get('title', ''),
        'art': {
            'thumb': "https://image.tmdb.org/t/p/w500{0}".format(i.get('poster_path', '/')),
            'poster': "https://image.tmdb.org/t/p/w500{0}".format(i.get('poster_path', '/')),
            'fanart': "https://image.tmdb.org/t/p/w1280{0}".format(i.get('backdrop_path', '/')),
        },
        'info': {
            'video': {
                'genre': genre,
                'country': country,
                'year': year,
                'rating': i.get('vote_average', 0.0),
                'director': directors,
                'plot': i.get('overview', ''),
                'plotoutline': i.get('overview', ''),
                'title': i.get('title', ''),
                'originaltitle': i.get('original_title', ''),
                'duration': duration,
                'studio': studio,
                'tagline': i.get('tagline', ''),
                'writer': writers,
                'premiered': premiered,
                'imdbnumber': i.get('imdb_id', ''),
                'votes': i.get('vote_count', 0),
                'trailer': trailer,
                'mediatype': 'movie',
                'size': size,
            },
        },
        'cast': casts,
    }
    return item


def makeTvShowItem(i, types="tvshow", number=None, remDate=False, size=0):
    item = {}
    casts = []
    genre = []
    studio = []
    first_date = ""
    try:
        first_date = i.get('first_air_date')[:4]
    except:
        if remDate:
            first_date = ""
        else:
            first_date = "0000"
    duration = 0
    id = trailer = ""
    rating = ""
    country = ""

    try:
        country = i.get('origin_country')[0]
    except:
        country = ""

    try:
        for rat in i['content_ratings']['results']:
            if rat['iso_3166_1'] == "RU":
                rating = rat['rating']
            elif rat['iso_3166_1'] == 'US':
                rating = rat['rating']
    except:
        rating = "0"

    if len(i['videos']['results']):
        try:
            id = i['videos']['results'][1]['key']
        except:
            id = i['videos']['results'][0]['key']
        finally:
            trailer = "plugin://plugin.video.youtube/play/?video_id={0}".format(id)
    try:
        for genreName in i['genres']:
            genre.append(genreName['name'])
    except:
        genre = []

    try:
        for c in i['credits']['cast']:
            casts.append({
                'name': c['name'],
                'role': c['character'],
                'thumbnail': "https://image.tmdb.org/t/p/w200{0}".format(c['profile_path']),
                'order': c['order']
            })
    except:
        pass

    try:
        duration = i.get('episode_run_time')[0]
    except:
        duration = 0

    try:
        studio = i.get('networks')[0]['name']
    except:
        studio = ""
    if types == "episode":
        pass
    elif types == "season":
        s = []
        for season in i['seasons']:
            if season.get('season_number', 0) == number:
                s = season
        ov = ''
        if s['overview']:
            ov = s.get('overview')
        else:
            ov = i.get('overview')
        air_date = s.get('air_date', '')
        if remDate:
            first_date = "0"
            air_date = ""

        item = {
            'label': s['name'],
            'art': {
                'thumb': "https://image.tmdb.org/t/p/w500{0}".format(s.get('poster_path', '/')),
                'poster': "https://image.tmdb.org/t/p/w500{0}".format(s.get('poster_path', '/')),
                'fanart': "https://image.tmdb.org/t/p/w1280{0}".format(i.get('backdrop_path', '/')),
            },
            'info': {
                'video': {
                    'genre': genre,
                    'season': number,
                    'episode': s.get('episode_count', 0),
                    'tvshowtitle': s.get('name', ''),
                    'year': int(first_date),
                    'title': i.get('original_name'),
                    'plot': ov,
                    'plotoutline': ov,
                    'aired': air_date,
                    'status': i.get('status', ''),
                    'votes': i.get('votes', 0),
                    'mediatype': 'tvshow',
                    'originaltitle': i['original_name'],
                    'rating': i['vote_average'],
                    'duration': duration * 60,
                    'country': country,
                    'studio': studio,
                    'imdbnumber': i['external_ids']['imdb_id'],
                    'trailer': trailer,
                    'mpaa': rating,
                    'size': size,
                }
            },
            'cast': casts,
        }
    else:
        item = {
            'label': i.get('name', ''),
            'art': {
                'thumb': "https://image.tmdb.org/t/p/w500{0}".format(i.get('poster_path', '/')),
                'poster': "https://image.tmdb.org/t/p/w500{0}".format(i.get('poster_path', '/')),
                'fanart': "https://image.tmdb.org/t/p/w1280{0}".format(i.get('backdrop_path', '/')),
            },
            'info': {
                'video': {
                    'genre': genre,
                    'season': i.get('number_of_seasons', 0),
                    'episode': i.get('number_of_episodes', 0),
                    'tvshowtitle': i.get('name', ''),
                    'year': int(first_date),
                    'plot': i.get('overview', ''),
                    'plotoutline': i.get('overview', ''),
                    'aired': i.get('first_air_date', ''),
                    'status': i.get('status', ''),
                    'votes': i.get('votes', 0),
                    'mediatype': 'tvshow',
                    'title': i.get('original_name'),
                    'originaltitle': i['original_name'],
                    'rating': i['vote_average'],
                    'duration': duration * 60,
                    'country': country,
                    'studio': studio,
                    'imdbnumber': i['external_ids']['imdb_id'],
                    'trailer': trailer,
                    'mpaa': rating,
                    'size': size,
                }
            },
            'cast': casts,
        }
    return item


def parseName(torrentName):
    for k, values in resolutions.items():
        for v in values:
            torrentName = torrentName.replace(v, k)
    return torrentName


def checkMime(file):
    ext = file.lower()[file.rfind(".")+1:]
    if extVideo.count(ext):
        return "video/*"
    return "*/*"


def getGenres(id):
    return genres.get(id, "None "+str(id))


def FC(s, color="FFFFFF00"):
    s = "[COLOR "+color+"]"+s+"[/COLOR]"
    return s


def get_label(text):
    text = text.lower()
    if 'Трейлер' in text: return FC('Трейлер', 'FFFF9999')
    if ' кпк' in text: return FC('КПК', 'FFF8888F')
    if ' Android' in text: return FC('КПК', 'FFF8888F')
    if 'tvrip' in text: return FC('TV', 'FEFFFF88')
    if 'satrip' in text: return FC('TV', 'FEFFFF88')
    if 'dvb ' in text: return FC('TV', 'FEFFFF88')
    if 'hdtv' in text: return FC('HDTV', 'FEFFFF88')
    if 'telesyn' in text: return FC('TS', 'FFFF2222')
    if 'telecin' in text: return FC('TS', 'FFFF2222')
    if 'camrip' in text: return FC('TS', 'FFFF2222')
    if ' ts' in text: return FC('TS', 'FFFF2222')
    if 'dvdscr' in text: return FC('Scr', 'FFFF2222')
    if ' 3d' in text: return FC('3D', 'FC45FF45')
    if '720' in text: return FC('720p', 'FBFFFF55')
    if '1080' in text: return FC('1080p', 'FAFF9535')
    if '1440' in text: return FC('1440p', 'FAFА90FF')
    if '2160' in text: return FC('2160p', 'FAFF3030')
    if ' 4k' in text: return FC('2160p', 'FAFF3030')
    if 'webrip' in text: return FC('WEB', 'FEFF88FF')
    if 'WEB' in text: return FC('WEB', 'FEFF88FF')
    if 'web-dl' in text: return FC('WEB', 'FEFF88FF')
    if 'hdrip' in text: return FC('HDRip', 'FE98FF98')
    if 'dvd5' in text: return FC('DVD', 'FE88FFFF')
    if 'xdvd' in text: return FC('DVD', 'FE88FFFF')
    if 'dvd-5' in text: return FC('DVD', 'FE88FFFF')
    if 'dvd-9' in text: return FC('DVD', 'FE88FFFF')
    if 'dvd9' in text: return FC('DVD', 'FE88FFFF')
    if 'dvdrip' in text: return FC('DVDRip', 'FE88FFFF')
    if 'blu-ray' in text: return FC('BRay', 'FF5555FF')
    if 'bdremux' in text: return FC('BDRemux', 'FF5555FF')
    if 'bdrip' in text: return FC('BDRip', 'FE98FF98')
    if 'drip' in text: return FC('BDRip', 'FE98FF98')
    return FC('[   ????  ]', 'FFFFFFFF')


genres = {
    12: "приключения",
    14: "фэнтези",
    16: "мультфильм",
    18: "драма",
    27: "ужасы",
    28: "боевик",
    35: "комедия",
    36: "история",
    37: "вестерн",
    53: "триллер",
    80: "криминал",
    99: "документальный",
    878: "фантастика",
    9648: "детектив",
    10402: "музыка",
    10749: "мелодрама",
    10751: "семейный",
    10752: "военный",
    10759: "Боевик и Приключения",
    10762: "Детский",
    10763: "Новости",
    10764: "Реалити-шоу",
    10765: "НФ и Фэнтези",
    10766: "Мыльная опера",
    10767: "Ток-шоу",
    10768: "Война и Политика",
    10770: "телевизионный фильм"
}

extVideo = ["3g2", "3gp", "aaf", "asf", "avchd", "avi", "drc", "flv", "iso", "m2v", "m2ts", "m4p", "m4v", "mkv", "mng", "mov", "mp2", "mp4", "mpe", "mpeg", "mpg", "mpv", "mxf", "nsv", "ogg", "ogv", "ts", "qt", "rm", "rmvb", "roq", "svi", "vob", "webm", "wmv", "yuv"]
