# -*- coding: utf-8 -*-

import json
import urllib
import urllib2
import ssl
import time
from Queue import Queue, PriorityQueue
from threading import Thread
ssl._create_default_https_context = ssl._create_unverified_context

class TMDB:
    def __init__(self):
        self.api_key = '99e8b7beac187a857152f57d67495cf4'

    def discover_movie(self, year, page):
        global maxpage
        data = {}
        data['api_key'] = self.api_key
        data['language'] = 'ru-RU'
        data['region'] = 'RU'
        data['year'] = year
        data['page'] = page
        url_values = urllib.urlencode(data)
        url = 'https://api.themoviedb.org/3/discover/movie?{0}'.format(url_values)
        infostring = self.req(url)
        infostring = moreInfo(infostring, 'movie')
        return infostring

    def discover_tvshow(self, year, page):
        global maxpage
        data = {}
        data['api_key'] = self.api_key
        data['language'] = 'ru-RU'
        data['year'] = year
        data['page'] = page
        url_values = urllib.urlencode(data)
        url = 'https://api.themoviedb.org/3/discover/tv?{0}'.format(url_values)
        infostring = self.req(url)
        infostring = moreInfo(infostring, 'tvshow')
        return infostring

    def search_movies(self, query, page):
        global maxpage
        data = {}
        data['api_key'] = self.api_key
        data['page'] = str(page)
        data['query'] = query
        data['language'] = 'ru-RU'
        url_values = urllib.urlencode(data)
        url = 'https://api.themoviedb.org/3/search/movie?{0}'.format(url_values)
        infostring = self.req(url)
        infostring = moreInfo(infostring, 'movie')
        return infostring

    def search_tv_shows(self, query, page):
        global maxpage
        data = {}
        data['api_key'] = self.api_key
        data['page'] = str(page)
        data['query'] = query
        data['language'] = 'ru-RU'
        url_values = urllib.urlencode(data)
        url = 'https://api.themoviedb.org/3/search/tv?{0}'.format(url_values)
        infostring = self.req(url)
        infostring = moreInfo(infostring, 'tvshow')
        return infostring

    def get_movie(self, id):
        data = {}
        data['append_to_response'] = 'credits,trailers,releases'
        data['api_key'] = self.api_key
        data['language'] = 'ru_RU'
        url_values = urllib.urlencode(data)
        url = 'http://api.themoviedb.org/3/movie/{0}?{1}'.format(id, url_values)
        infostring = self.req(url)
        return infostring

    def get_tv_show(self, id):
        data = {}
        data['api_key'] = self.api_key
        data['language'] = 'ru-RU'
        data['region'] = 'RU'
        data['append_to_response'] = 'credits,releases,external_ids,videos,content_ratings'
        url_values = urllib.urlencode(data)
        url = 'http://api.themoviedb.org/3/tv/{0}?{1}'.format(id, url_values)
        infostring = self.req(url)
        return infostring

    def req(self, url):
        resp = "{}"
        try:
            responce = urllib2.urlopen(url)
        except urllib2.HTTPError, e:
            if e.code == 429:
                ret_after = float(e.info().get('Retry-After', 10))
                time.sleep(ret_after + 0.5)
                responce = urllib2.urlopen(url)
        else:
            resp = responce.read()
        infostring = json.loads(resp.decode('utf-8', 'replace'))
        return infostring

def moreInfo(infostring, type):
    queue = Queue()
    result = PriorityQueue()
    for i in infostring.get('results', []):
        queue.put(i.get('id'))
    for i in xrange(5):
        w = Worker(queue, result, type)
        w.start()
    queue.join()
    out = []
    while not result.empty():
        out.append(result.get()[1])
    infostring['results'] = out
    return infostring


class Worker(Thread):
    counter = -1

    def __init__(self, queue_in, queue_out, type):
        super(Worker, self).__init__()
        self.setDaemon(True)
        self.__queue_in = queue_in
        self.__queue_out = queue_out
        self.type = type
        self.tmdb = TMDB()

    def run(self):
        while True:
            job = self.__queue_in.get()
            Worker.counter += 1
            num = Worker.counter
            if self.type == 'movie':
                job = self.tmdb.get_movie(job)
            else:
                job = self.tmdb.get_tv_show(job)
            self.__queue_out.put((num, job))
            self.__queue_in.task_done()
