# -*- coding: utf-8 -*-
import json
import time
import urllib
import re
import hashlib
import bencode
import os

import xbmc
import xbmcgui
import xbmcplugin
import xbmcvfs

from client import client, touch
from config import TORRSERVED_HOST, ADDON_PATH
from simpleplugin import Plugin
from utils import humanizeSize, notify, settingsIsOpen, parseName, checkMime, makeMovieItem, makeTvShowItem, get_label
from tmdb.api import TMDB

plugin = Plugin()
translate = plugin.initialize_gettext()
tmdb = TMDB()

@plugin.action()
def root():
    resp = client("/echo")
    if not resp:
        notify(translate("Server {0} is down").format(TORRSERVED_HOST))
        listing = get_listing("noindex")
        return Plugin.create_listing(listing, category="N/A")
    else:
        listing = get_listing("index")
        return Plugin.create_listing(listing, category="v"+resp, content='videos')

def get_listing(params, type=None):
    listing = []
    if params == "index":
        listing.append({
            'label': translate("Torrents List"),
            'url': plugin.get_url(action='torrents', mod='list'),
            'icon': os.path.join(ADDON_PATH, "resources", "img", "list.png"),
            'is_folder': True
        })
        listing.append({
            'label': translate("Search"),
            'url': plugin.get_url(action="search", mod="index"),
            'icon': os.path.join(ADDON_PATH, "resources", "img", "search.png"),
            'is_folder': True
        })
        listing.append({
            'label': translate('Open .torrent'),
            'url': plugin.get_url(action='file', mod='open'),
            'icon': os.path.join(ADDON_PATH, "resources", "img", "add.png"),
            'is_folder': True,
        })
        listing.append({
            'label': translate("Settings"),
            'icon': os.path.join(ADDON_PATH, "resources", "img", "settings.png"),
            'url': plugin.get_url(action='settings', mod='read'),
            'is_folder': False,
        })
    elif params == "noindex":
        listing.append({
            'label': translate("Settings"),
            'icon': os.path.join(ADDON_PATH, "resources", "img", "settings.png"),
            'url': plugin.get_url(action='settings', mod='open'),
            'is_folder': False
        })
    elif params == "search":
        if type == "movie":
            listing.append({
                'label': "{0} {1}".format(translate("Discover"), translate("Movies")),
                'url': plugin.get_url(action='search', mod='discover', type='movie', page=1),
                'icon': os.path.join(ADDON_PATH, "resources", "img", "top.png"),
                'is_playable': False,
                'is_folder': True,
            })
            listing.append({
                "label": translate("New Search"),
                'url': plugin.get_url(action='search', mod="search", type="movie"),
                'icon': os.path.join(ADDON_PATH, "resources", "img", "search.png"),
                "is_playable": False,
                'is_folder': True,
            })
        elif type == "tvshow":
            listing.append({
                'label': "{0} {1}".format(translate("Discover"), translate("TV Shows")),
                'url': plugin.get_url(action='search', mod='discover', type='tvshow', page=1),
                'icon': os.path.join(ADDON_PATH, "resources", "img", "top.png"),
                'is_playable': False,
                'is_folder': True,
            })
            listing.append({
                "label": translate("New Search"),
                'url': plugin.get_url(action='search', mod="search", type="tvshow"),
                'icon': os.path.join(ADDON_PATH, "resources", "img", "search.png"),
                "is_playable": False,
                'is_folder': True,
            })
        else:
            listing.append({
                "label": translate("Movies"),
                'url': plugin.get_url(action='search', mod="index", type="movie"),
                'icon': os.path.join(ADDON_PATH, "resources", "img", "movies.png"),
                "is_playable": False,
                'is_folder': True,
            })
            listing.append({
                "label": translate("TV Shows"),
                'url': plugin.get_url(action='search', mod="index", type="tvshow"),
                'icon': os.path.join(ADDON_PATH, "resources", "img", "tv.png"),
                "is_playable": False,
                'is_folder': True,
            })
            listing.append({
                'label': translate("Torrents"),
                'url': plugin.get_url(action='search', mod="torrent"),
                'icon': os.path.join(ADDON_PATH, "resources", "img", "search.png"),
                'is_playable': False,
                'is_folder': True,
            })
            return listing
        with plugin.get_storage('historySearch'+type) as storage:
            i = 0
            while i < 10:
                try:
                    if storage['title{0}'.format(i)]:
                        listing.append({
                            'label': storage['title{0}'.format(i)],
                            'url': plugin.get_url(action='search', mod="search", type=type, query=storage['title{0}'.format(i)]),
                            'icon': os.path.join(ADDON_PATH, "resources", "img", "search.png"),
                            'is_playable': False,
                            'is_folder': True,
                            "context_menu": [(
                                translate("Remove query"),
                                "RunPlugin(%s)" % plugin.get_url(action="search", mod="history", type=type, delete='title{0}'.format(i)),
                            )]
                        })
                except:
                    pass
                finally:
                    i += 1
    return listing

@plugin.action('file')
def open_file(params):
    dialog = xbmcgui.Dialog()
    tFile = dialog.browseSingle(1, translate('Select torrent file'), 'files', '.torrent')

    if tFile != '':
        tf = xbmcvfs.File(tFile)
        i = tf.read()
        tf.close()
        metainfo = bencode.bdecode(i)
        infohash = hashlib.sha1(bencode.bencode(metainfo['info'])).hexdigest()
        tr = [metainfo['announce']]
        for t in metainfo['announce-list']:
            tr.append(t.pop())
        params = {
            'dn': metainfo['info']['name'],
            'tr': tr,
        }
        magneturi = 'magnet:?xt=urn:btih:{0}&{1}'.format(str(infohash).upper(), urllib.urlencode(params, True))
        listing = [{
            'label': metainfo['info']['name'],
            'url': plugin.get_url(action='gotInfo', magnet=magneturi),
            'icon': os.path.join(ADDON_PATH, "resources", "img", "magnet.png"),
            'is_folder': True,
            "context_menu": [(
                translate("Add to DB"),
                "RunPlugin(%s)" % plugin.get_url(action="torrents", mod="add", magnet=magneturi),
            )]
        }]
        return Plugin.create_listing(listing, cache_to_disk=True, category=tFile)

@plugin.action("search")
def search(params):
    listing = []
    view_mode = 50
    if params.mod == "index":
        return Plugin.create_listing(get_listing("search", params.type))
    elif params.mod == "history":
        with plugin.get_storage('historySearch'+params.type) as storage:
            storage[params.delete] = None
        xbmc.executebuiltin("Container.Refresh")
        return
    elif params.mod == "discover":
        result = []
        page = params.page
        nextPage = int(page) + 1
        if params.type == "movie":
            query = "2019"
            result = tmdb.discover_movie(2019, page)
            movie_ids = result['results']
            for movie in movie_ids:
                item = makeMovieItem(movie)
                item.update({'url': plugin.get_url(action='search', mod="torrent", query=movie['original_title'].encode('utf-8')+" "+str(movie['release_date'][:4]), type="movie", id=movie['id'])}),
                listing.append(item)
        elif params.type == "tvshow":
            query = "2019"
            result = tmdb.discover_tvshow(2019, page)
            shows_ids = result['results']
            for show in shows_ids:
                item = makeTvShowItem(show)
                item.update({'url': plugin.get_url(action='search', mod="torrent", query=show['original_name'].encode('utf-8'), type="tvshow", id=show['id'])})
                listing.append(item)
        listing.append({
            'label': translate("Next page ({0})").format(nextPage),
            'icon': os.path.join(ADDON_PATH, "resources", "img", "nextpage.png"),
            'url': plugin.get_url(action='search', mod='discover', type=params.type, page=nextPage)
        })
        return Plugin.create_listing(listing, category="{0}: {1}".format(translate("Discover"), query), cache_to_disk=True, content="{0}s".format(params.type), view_mode=view_mode)
    elif params.mod == "search":
        result = []
        query = params.query
        dialog = xbmcgui.Dialog()
        if not query:
            query = dialog.input("Yohoho", type=xbmcgui.INPUT_ALPHANUM)
            if query == "":
                return
            with plugin.get_storage('historySearch'+params.type) as storage:
                storage['title9'] = storage.get('title8')
                storage['title8'] = storage.get('title7')
                storage['title7'] = storage.get('title6')
                storage['title6'] = storage.get('title5')
                storage['title5'] = storage.get('title4')
                storage['title4'] = storage.get('title3')
                storage['title3'] = storage.get('title2')
                storage['title2'] = storage.get('title1')
                storage['title1'] = storage.get('title0')
                storage['title0'] = query
        if params.type == "movie":
            result = tmdb.search_movies(query, 1)
        else:
            result = tmdb.search_tv_shows(query, 1)
        # maxpage = result['total_pages']
        movie_ids = result['results']
        for movie in movie_ids:
            if params.type == "movie":
                item = makeMovieItem(movie)
                item.update({'url': plugin.get_url(action='search', mod="torrent", query=movie['original_title'].encode('utf-8')+" "+str(movie['release_date'][:4]), type="movie", id=movie['id'])})
                listing.append(item)
            elif params.type == "tvshow":
                if movie['number_of_seasons'] > 0:
                    item = makeTvShowItem(movie)
                    item.update({
                        'url': plugin.get_url(action='search', mod="torrent", query=movie['original_name'].encode('utf-8'), type="tvshow", id=movie['id']),
                    })
                    listing.append(item)
        return Plugin.create_listing(listing, category="{0}: {1}".format(translate("Search"), query), cache_to_disk=True, content="{0}s".format(params.type), view_mode=50)
    elif params.mod == "torrent":
        selSeason = params.selSeason
        ext_info = ""
        query = params.query
        if query is None:
            params.type = "video"
            dialog = xbmcgui.Dialog()
            query = dialog.input(translate("Torrents"), type=xbmcgui.INPUT_ALPHANUM)
            if query == "":
                return False
        else:
            query = query.decode('utf-8')
        if params.type == "tvshow" and selSeason is None:
            ext_info = tmdb.get_tv_show(params.id)
            listing = []
            for number in range(1, ext_info['number_of_seasons']+1, 1):
                item = makeTvShowItem(ext_info, "season", number)
                item.update({
                    'url': plugin.get_url(action='search', mod=params.mod, type=params.type, id=params.id, query=params.query, selSeason=number)
                })
                listing.append(item)
            return Plugin.create_listing(listing, cache_to_disk=True, sort_methods=xbmcplugin.SORT_METHOD_LABEL, content="{0}s".format(params.type), view_mode=50)
        elif params.type == "tvshow" and selSeason:
            ext_info = tmdb.get_tv_show(params.id)
            selSeason = "{0:02d}".format(int(selSeason))
            query = ext_info['original_name'].encode('utf-8')
        elif params.type == "movie":
            ext_info = tmdb.get_movie(params.id)
            query = "{0} ({1})".format(ext_info['original_title'].encode('utf-8'), ext_info['release_date'][:4])
        if (plugin.get_setting("use_torlook", True)):
            torlook_query = query.replace(" ", "%20")
            result = client("/{0}/size".format(torlook_query), host='https://torlook.info')
            if not result:
                notify(translate("Empty result")+" "+query)
                return False
            match = re.finditer(r'<p><a rel="nofollow".+?>(.+?)</a></p>.+?blank">(.+?)</a>.+?<span class="size">(.+?)</span>.+?href="(.+?)"', result, re.DOTALL)
        else:
            yohoho_query = query.replace(" ", "%20").replace("-", "+")
            result = client("/4h0y", get_data={'title': yohoho_query}, post_data={}, host='https://ahoy.yohoho.cc')
            if not result:
                notify(translate("Empty result")+" "+query)
                return False
            match = re.finditer(r"href =.+?'(magnet:\?.+?)';\">(.+?)<\/span>.+?<div>(.+?)<\/div>", result, re.DOTALL)
        for t in match:
            if(plugin.get_setting("use_torlook", True)):
                magnet = t.group(4)
                name = t.group(1)
                trackers = t.group(2)
            else:
                magnet = t.group(1)
                name = t.group(2)
                trackers = "yohoho"
            name = name.replace("<b>", "").replace("</b>", "")

            if trackers not in ["kinozal.tv", "yohoho", "rutor.info", "nnmclub.to", "rutracker.org", "torrent.by", "underverse.su", "toloka.to"]:
                continue
            item = dict()
            size = ""
            stringSize = t.group(3).replace('&nbsp;', ' ')
            if stringSize[stringSize.rfind(' ')+1:] in ['МБ', 'MB']:
                size = long(stringSize[:stringSize.rfind(' ')]) * 2 << 19
            else:
                size = long(float(stringSize[:stringSize.rfind(' ')]) * float(2 << 29))
            context_menu = [(
                translate("Add to DB"),
                "RunPlugin(%s)" % plugin.get_url(action="torrents", mod="add", magnet=magnet),
            )]
            if params.type == 'movie':
                if name.find(query) == -1:
                    continue
                item = makeMovieItem(ext_info, True, size)
                context_menu.append((
                    translate('Save to Library'),
                    'RunPlugin({0})'.format(plugin.get_url(action='library', mod='save', id=ext_info['id'], year=ext_info['release_date'][:4], magnet=magnet, item=repr(item)))
                ))
            elif params.type == 'tvshow':
                numEp = ""
                if query in name and name.find('S'+selSeason) > -1:
                    if '[S'+selSeason+']' in name:
                        numEp = "All"
                    elif '[S01-' in name:
                        numEp = "Multi"
                    else:
                        numEp = name[name.find('S'+selSeason)+4:name.find('S'+selSeason)+6]
                elif query in name and name.find(selSeason+'x') > -1:
                    numEp = name[name.find(selSeason+'x')+6:name.find(selSeason+'x')+8]
                    if 'и' in numEp:
                        numEp = name[name.find(selSeason+'x')+3:name.find(selSeason+'x')+5]
                elif query in name and name.find('['+selSeason+'-') > -1:
                    numEp = name[name.find('['+selSeason+'-')+4:name.find('['+selSeason+'-')+6]
                else: continue
                item = makeTvShowItem(ext_info, "season", int(params.selSeason), True, size)
                context_menu.append((
                    translate('Save to Library'),
                    'RunPlugin({0})'.format(plugin.get_url(action='library', mod='save', id=ext_info['id'], year=ext_info['first_air_date'][:4], magnet=magnet, season=selSeason, numEp=numEp, item=repr(item)))
                ))
            label = get_label(name)
            name = "[B]{1}[COLOR=FFFFFFFF]/{0}/[/COLOR][/B] {2}".format(stringSize.replace(' ', ''), label, name)
            stream_info = ""
            if '2160' in label:
                stream_info = {'video': {'width': 3840, 'height': 2160}}
            elif '1080' in label:
                stream_info = {'video': {'width': 1920, 'height': 1080}}
            elif '720' in label:
                stream_info = {'video': {'width': 1280, 'height': 720}}
            else:
                stream_info = ""
            item.update({
                "label": name,
                'url': plugin.get_url(action='gotInfo', magnet=magnet),
                'is_folder': True,
                "context_menu": context_menu,
                'stream_info': stream_info
            })
            listing.append(item)
        return Plugin.create_listing(listing, category="{0}".format(translate("Search")), cache_to_disk=True, sort_methods=(xbmcplugin.SORT_METHOD_LABEL, xbmcplugin.SORT_METHOD_SIZE), content="{0}s".format(params.type), view_mode=55)
    return False

@plugin.action("torrents")
def torrents(params):
    listing = []
    if params.mod == "list":
        listing = makeFileList()
    elif params.mod == "files":
        listing = makeFileList(params.hash)
    elif params.mod == "add":
        client("/torrent/add", post_data={"Link": params.magnet, "Info": params.info})
        notify(translate("Saved!"))
        return
    elif params.mod == "delete":
        client("/torrent/rem", post_data={"Hash": params.hash})
        notify(translate("Deleted!"))
        xbmc.executebuiltin("Container.Refresh")
        return
    return Plugin.create_listing(listing, content="videos", category="Torrents")

@plugin.action()
def settings(params):
    if params.mod == "read":
        resp = client("/settings/read", post_data={"read": 1})
        for k, v in resp.items():
            if k == "CacheSize" or k == "PreloadBufferSize":
                v = (v / 1024) / 1024
            plugin.set_setting(k, str(v).lower())
        plugin.addon.openSettings()
        while settingsIsOpen():
            continue

        jset = {
            "CacheSize": plugin.get_setting("CacheSize", True) * 1024 * 1024,
            "PreloadBufferSize": plugin.get_setting("PreloadBufferSize", True) * 1024 * 1024,
            "RetrackersMode": plugin.get_setting("RetrackersMode", True),
            "DisableTCP": plugin.get_setting("DisableTCP", True),
            "DisableUTP": plugin.get_setting("DisableUTP", True),
            "DisableUPNP": plugin.get_setting("DisableUPNP", True),
            "DisableDHT": plugin.get_setting("DisableDHT", True),
            "DisableUpload": plugin.get_setting("DisableUpload", True),
            "Encryption": plugin.get_setting("Encryption", True),
            "DownloadRateLimit": plugin.get_setting("DownloadRateLimit", True),
            "UploadRateLimit": plugin.get_setting("UploadRateLimit", True),
            "ConnectionsLimit": plugin.get_setting("ConnectionsLimit", True),
            "PeersListenPort": plugin.get_setting("PeersListenPort", True)
        }
        if not resp == jset:
            resp = client("/settings/write", post_data=jset)
            if resp == "Ok":
                notify(translate("Settings saved! Restart service"))
                client("/torrent/restart")
                xbmc.executebuiltin("Container.Refresh")
            else:
                notify(translate("Settings not saved!"))
                plugin.log_error(repr(resp))
    elif params.mod == "open":
        plugin.addon.openSettings()

@plugin.action("play")
def play(params):
    touch("{0}{1}".format(TORRSERVED_HOST, params.link))
    hash = params.link[17:57]
    success = makePreloadDialog(hash)
    return Plugin.resolve_url(TORRSERVED_HOST + params.link.replace('/preload/', '/view/'), succeeded=success)

@plugin.action("play_now")
def play_now(params):
    touch(TORRSERVED_HOST+"/torrent/play?link="+params.magnet+"&file="+str(params.selFile)+"&save="+str(plugin.get_setting("save_in_db", True)))
    success = makePreloadDialog(params.magnet[20:60], params.selFile)
    return Plugin.resolve_url(TORRSERVED_HOST + "/torrent/play?link="+params.magnet+"&file="+str(params.selFile)+"&save="+str(plugin.get_setting("save_in_db", True)), succeeded=success)

@plugin.action("gotInfo")
def gotInfo(params):
    pDialog = xbmcgui.DialogProgress()
    pDialog.create("TorrServer", translate("Wait for info..."))
    tInfo = []
    listing = []
    success = False
    i = 0
    while not pDialog.iscanceled():
        xbmc.sleep(500)
        stat = client("/torrent/play", get_data={"stat": "true", "link": params.magnet})
        if stat is None or len(stat['FileStats']) == 0:
            xbmc.sleep(500)
            i += 1
            m = 0
            s = 0
            if i > 59:
                m = i / 60
            s = i - (m*60)
            if i > 100:
                pDialog.update(i, 'Информация о [B]{2}[/B] не получена за {0:02d} : {1:02d} с.'.format(m, s, stat.get('Name', 'раздаче')), 'Видимо это мертвая раздача и отсутствуют пиры.')
            else:
                pDialog.update(i, 'Пытаемся подключиться к раздаче [B]{0:02d} : {1:02d}[/B] с.'.format(m, s))
            continue
        elif stat and len(stat['FileStats']) > 0:
            tInfo = client("/torrent/stat", post_data={"Hash": stat['Hash']})
            for file in tInfo['FileStats']:
                if file['Path'].find('/BDMV/') > 0:
                    if long(file['Length']) > 1073741824 or file['Path'].find('/BDMV/index.bdmv') > 0:
                        listing.append({
                            "label": file['Path'][file['Path'].rfind('/')+1:],
                            "url": plugin.get_url(action="play_now", magnet=params.magnet, selFile=file['Id']),
                            "is_playable": True,
                            "info": {"video": {
                                'size': file['Length'],
                            }}
                        })
                elif checkMime(file['Path']) == "video/*":
                    listing.append({
                        "label": file['Path'][file['Path'].find('/')+1:],
                        "url": plugin.get_url(action="play_now", magnet=params.magnet, selFile=file['Id']),
                        "is_playable": True,
                        "info": {"video": {
                            'size': file['Length'],
                        }}
                    })
            pDialog.close()
            success = True
            return Plugin.create_listing(listing, content="videos", category="Файлы", succeeded=success)
    return Plugin.create_listing(listing, succeeded=success)

def makeFileList(hash=None):
    request = int(plugin.get_setting("without_info", True))
    response = client("/torrent/list", post_data={"Request": request})
    listing = []
    for t in response:
        if not hash:
            item = {
                "label": u"[{0}] {1}".format(humanizeSize(t['Length']), parseName(t['Name'])),
                "url": plugin.get_url(action="torrents", mod="files", hash=t['Hash']),
                "icon": os.path.join(ADDON_PATH, "resources", "img", "magnet.png"),
                "context_menu": [(
                    translate("Delete from DB"),
                    "RunPlugin(%s)" % plugin.get_url(action="torrents", mod="delete", hash=t["Hash"]),
                )],
            }
            if t['Info'] != "{}":
                try:
                    i = json.loads(t['Info'])
                    item.update({'art': {
                        'thumb': i.get('poster_path'),
                        'poster': i.get('poster_path'),
                    }})
                except:
                    pass
            listing.append(item)
        elif hash == t['Hash']:
            for f in t['Files']:
                item = {
                    "label": parseName(f['Name'][f['Name'].find('/')+1:]),
                    "title": f['Name'],
                    "url": plugin.get_url(action="play", link=f['Preload'].encode("utf-8", "replace")),
                    "is_playable": True,
                    "info": {"video": {
                        'size': f['Size'],
                        'playcount': int(f['Viewed'])
                    }}
                }
                if t['Info'] != "{}":
                    try:
                        i = json.loads(t['Info'])
                        if i.get('poster_path'):
                            item.update({'art': {
                                'thumb': i.get('poster_path'),
                                'poster': i.get('poster_path'),
                            }})
                    except:
                        pass
                listing.append(item)
    return listing

def makePreloadDialog(hash, fileId=None):
    pDialog = xbmcgui.DialogProgress()
    pDialog.create("TorrServer", translate("Wait for info..."), translate("Connected: {0} | Active: {1} | Total: {2}").format(0, 0, 0))
    success = False
    counter = 0
    name = ""
    while not pDialog.iscanceled():
        if pDialog.iscanceled():
            pDialog.close()
            client("/torrent/drop", post_data={"Hash": hash})
            break
        time.sleep(0.5)
        stat = client("/torrent/stat", post_data={"Hash": hash})
        if stat is None:
            counter += 1
            if counter < 60:
                time.sleep(0.5)
                continue
            else:
                notify("Time is over")
                pDialog.close()
                break
        else:
            if name == "":
                if fileId and stat['FileStats']:
                    for f in stat['FileStats']:
                        if int(f['Id']) == int(fileId):
                            name = f['Path'][f['Path'].rfind('/')+1:]
                else:
                    name = stat['Name']
            downSpeed = humanizeSize(stat['DownloadSpeed'])
            preloadedBytes = stat['PreloadedBytes']
            preloadSize = stat['PreloadSize']
            line2 = translate("Connected: {0} | Active: {1} | Total: {2}").format(stat['ConnectedSeeders'], stat['ActivePeers'], stat['TotalPeers'])
            line3 = u"D: {0}/сек [{1}/{2}]".format(downSpeed, humanizeSize(preloadedBytes), humanizeSize(preloadSize))
            if preloadSize > 0 and preloadedBytes < preloadSize:
                prc = preloadedBytes * 100 / preloadSize
                if prc > 100:
                    prc = 100
                pDialog.update(prc, name, line2, line3)
            elif preloadedBytes > preloadSize:
                success = True
                pDialog.close()
                break
    return success

@plugin.action('library')
def library(params):
    if params.mod == 'save':
        import ast
        item = ast.literal_eval(params.item)
        info = item['info']['video']
        name = info['originaltitle'] + " ("+params.year+")"
        name = name.replace("/", " ").replace("\\", " ").replace("?", "").replace(":", "").replace('"', "").replace('*', "").replace('|', "")
        path = plugin.get_setting("library_path", True)

        if info.get('mediatype', 'movie') == "movie":
            path = os.path.join(xbmc.translatePath(path), 'videos', name)
            if not os.path.exists(path):
                os.makedirs(path)
            uri = plugin.get_url(action="play_now", magnet=params.magnet, selFile=0)
            fl = open(os.path.join(path, name+".strm"), "w")
            fl.write(uri)
            fl.close()
            notify(path)
        elif info.get('mediatype', 'movie') == "tvshow":
            path = os.path.join(xbmc.translatePath(path), 'tvshows', name)
            if not os.path.exists(path):
                os.makedirs(path)
            numEp = 1
            if 'All' in params.numEp:
                numEp = int(info.get('episode', 1))
            elif 'Multi' in params.numEp:
                notify("Multi seasons not saved", time=10000)
                return False
            else:
                numEp = int(params.numEp)
            for ep in range(numEp):
                epname = name + " S{0}E{1:02d}".format(params.season, ep+1)
                uri = plugin.get_url(action="play_now", magnet=params.magnet, selFile=ep)
                fl = open(os.path.join(path, epname+".strm"), "w")
                fl.write(uri)
                fl.close()
        xbmc.executebuiltin('UpdateLibrary("video")')
        return True

def run():
    plugin.run()
