# -*- coding: utf-8 -*-
import os

import xbmc
import xbmcgui

from config import ADDON_PATH
from utils import plugin, _T, notify


def addCategory(hash=None, category=None):
    storage = plugin.get_storage('categoriesDict')
    categories = storage.get('categories', {_T('Movies'):[], _T('TV Shows'):[], _T('Cartoons'):[], _T('Еще смотрю видео'):[], _T('Еще слушаю аудио'):[]})
    dialog = xbmcgui.Dialog()
    clist = []
    nlist = []
    if not hash and not category:
          for k in categories:
               nlist.append({'label': "%s (%s)" % (k, len(categories[k])),
               'url': plugin.get_url(action="torrents", mod="list", category=k),
               'icon': os.path.join(ADDON_PATH, "resources", "img", "list.png"),
               'is_playable': False,
               'is_folder': True,
               'context_menu': [(
                                _T("Удалить категорию"),
                                'RunPlugin(%s)' % plugin.get_url(action="category", category=k, hash='delete')
                               )]
               })
          return sorted(nlist, key=lambda f: f['label'])
    elif not hash and category:
          return categories[category]
    elif hash == 'delete' and category:
          if not dialog.yesno(_T('Удалить категорию?'), '%s: %s (%s)' % (_T("Удалить категорию"), category, len(categories[category]))):
                     return
          del categories[category]
          notify(_T("Категория %s удалена") % category)
          storage['categories'] = categories
          xbmc.executebuiltin("Container.Refresh")
          return
    elif category and isinstance(hash, list):
          if category in categories:
               save = False
               for h in hash:
                  if h in categories[category]:
                       categories[category].remove(h)
                       save = True
               if save: storage['categories'] = categories
          return
    elif category and hash:
          if hash not in categories.get(category, []):
                 if category in categories:
                        categories[category].append(hash)
                 else:
                        categories[category] = [hash]
                 storage['categories'] = categories
          return
    for k, v in categories.items():
             if hash in v: clist.append(k)
             else: nlist.append(k)
    clist.sort()
    nlist.sort()
    clist.append('[COLOR=yellow]%s[/COLOR]' % _T("Добавить торрент в категорию"))
    nlist.append('[COLOR=violet]%s[/COLOR]' % _T("Добавить торрент в новую категорию"))
    index = dialog.select(heading=_T('Торрент состоит в категориях'), list=clist)
    if index == -1: return
    name = clist[index]
    if index == len(clist)-1:
             index2 = dialog.select(heading=_T('Выберите категорию'), list=nlist)
             if index2 == -1: return
             name = nlist[index2]
             if index2 == len(nlist)-1:
                  name = dialog.input(_T('Введите название категории'), type=xbmcgui.INPUT_ALPHANUM)
                  if name == "": return
                  if name not in categories:
                       categories[name] = [hash]
             else:
                  categories[name].append(hash)
    else:
            if not dialog.yesno(_T('Убрать торрент из категории?'), '%s: %s' % (_T("Убрать торрент из категории"), name)):
                return
            categories[name].remove(hash)
            if len(categories[name]) == 0:
                if dialog.yesno(_T('Удалить категорию?'), '%s: %s' % (_T("Удалить пустую категорию"), name)):
                     del categories[name]
    storage['categories'] = categories


@plugin.action()
def category(params):
    listing = addCategory(params.hash, params.category)
    if listing: return plugin.create_listing(listing, content='videos', category=_T("Категории"), sort_methods=None, view_mode='0', cache_to_disk=False)
