# -*- coding: utf-8 -*-
import sys
PY2 = sys.version_info.major == 2
from threading import Thread
if PY2:
	from Queue import Queue, PriorityQueue
else:
	from queue import Queue, PriorityQueue
	xrange = range
from scrapers import scrapersList
from importlib import import_module
#from scrapers import *

all_trackers_on = False
disabled_trackers = () #('torlook', 'rutracker') # for debug
disable_timeout = False

try:
	__settings__ = __import__('xbmcaddon').Addon()
	from xbmcup.errors import log
	auto_disable_tracker = __settings__.getSetting("auto_disable_tracker") == 'true'
	multi_thread = __settings__.getSetting("multi_thread_search_trackers") == 'true'
	timeout_sets = int(__settings__.getSetting("timeout_multi_thread_search_trackers"))
	MaxThread = int(__settings__.getSetting("max_multi_thread_search_trackers"))
	TimeOut = None if timeout_sets == 0 else timeout_sets
	Kodi = True
except ImportError:
	Kodi = False
	multi_thread = False
	TimeOut = None
	MaxThread = None

class Worker(Thread):
	def __init__(self, qs, queue, result):
		super(Worker, self).__init__()
		self.setDaemon(True)
		self.qs = qs
		self.queue = queue
		self.result = result

	def run(self):
		while not self.queue.empty():
			try:
				self.i = self.queue.get()
				print(self.i)
				im = import_module("scrapers."+self.i)
				s = im.Tracker()
				fis = []
				def _query(result):
					try:
						result.extend(s.Query(self.qs))
					except Exception as e:
						if Kodi:
							log(e, self.i)
							if auto_disable_tracker:
								__settings__.setSetting(self.i, 'false')
						else:
							print(e)
							exc_type, exc_val, exc_tb = sys.exc_info()
							import traceback
							print(u''.join(traceback.format_exception(exc_type, exc_val, exc_tb, limit=10)))
#							raise
				if TimeOut and not disable_timeout:
					thread = Thread(target=_query, args=(fis,))
					thread.start()
					thread.join(timeout=TimeOut)
					if thread.is_alive(): print(self.i+': thread timeout!')
				else:
					fis = s.Query(self.qs)
				if fis:
					print(self.i+': '+str(len(fis)))
					self.result.put((self.i, fis))
				else:
					print(self.i+': None')
				del fis
			except Exception as e:
				if Kodi:
					log(e, self.i)
					if auto_disable_tracker:
						__settings__.setSetting(self.i, 'false')
				else:
					print(e)
					exc_type, exc_val, exc_tb = sys.exc_info()
					import traceback
					print(u''.join(traceback.format_exception(exc_type, exc_val, exc_tb, limit=10)))
#					self.queue.task_done()
#					raise
			self.queue.task_done()


def Query(qs, multi=multi_thread, max_threads=MaxThread):
	Lout = []
	if multi:
		print("start multi-thread...")
		result = PriorityQueue()
		queue = Queue()
		runTrackers = []

	for i in scrapersList():
		if Kodi:
			s_on = __settings__.getSetting(i)
			if s_on == 'true' or s_on == '': s_on = True
			else: s_on = False
		else:
			s_on = True
		if (s_on or all_trackers_on) and i not in disabled_trackers:
#			exec("from scrapers import "+i)
#			exec("s="+i+".Tracker()")
			if multi:
				queue.put(i)
				runTrackers.append(i)
			else:
				print(i)
				im = import_module("scrapers."+i)
				s = im.Tracker()
				try:
					fis = s.Query(qs)
					if fis:
						print(i+': '+str(len(fis)))
						Lout.extend(fis)
					else:
						print(i+': None')
				except Exception as e:
					if Kodi:
						log(e, i)
						if auto_disable_tracker:
							__settings__.setSetting(i, 'false')
					else:
						print(e)
						raise
	if multi:
		num_threads = len(runTrackers)
		if max_threads and max_threads < num_threads and max_threads > 0:
			num_threads = max_threads
		print("number threads: %s" % num_threads)
		for i in xrange(num_threads):
			w = Worker(qs, queue, result)
			w.start()
		queue.join()
		#print("start merge results!")
		while not result.empty():
			Lout.extend(result.get()[1])
		print("finish multi-thread search!!!")
		print("total found: %s" % len(Lout))
	return Lout


if __name__ == '__main__':
	import time
	print(scrapersList())
#	print(len(Query('гамбит')))
	time1 = time.time()
	print(len(Query('гамбит', True)))
#	print(len(Query('Terminator', True)))
#	print(len(Query('eternals', True)))
	print('times: %s' % (time.time()-time1))
#	time.sleep(10)
