# -*- coding: utf-8 -*-

import sys, os, time
PY2 = sys.version_info.major == 2
import xbmc
import xbmcgui
import xbmcplugin
import xbmcaddon
if PY2:
       from xbmc import translatePath
else:
       from xbmcvfs import translatePath
from client import client, getTSVer, Mto1
from utils import humanizeSize

addon = xbmcaddon.Addon()

def abortRequested():
    return xbmc.abortRequested if xbmc.getInfoLabel('System.BuildVersion')[:2] < '18' else xbmc.Monitor().abortRequested()

def fs_dec(path):
    if not PY2: return path
    sys_enc = sys.getfilesystemencoding() if sys.getfilesystemencoding() else 'utf-8'
    return path.decode(sys_enc).encode('utf-8')

def fs_enc(path):
        if not PY2: return path
        path=translatePath(path)
        sys_enc = sys.getfilesystemencoding() if sys.getfilesystemencoding() else 'utf-8'
        try:path2=path.decode('utf-8')
        except: pass
        try:path2=path2.encode(sys_enc)
        except: path2=path
        return path2


class xPlayer(xbmc.Player):
        def __init__(self, hash=None, index=None):
                self.tsserv = None
                self.hash = hash
                self.index = index
                self.active = True
                self.started = False
                self.ended = False
                self.paused = False
                self.buffering = False
                xbmc.Player.__init__(self)
                width, height = xPlayer.get_skin_resolution()
                w = width
                h = int(0.14 * height)
                x = 0
                y = int((height - h) / 2)
                self._ov_window = xbmcgui.Window(12005)
                self._ov_label = xbmcgui.ControlLabel(x, y, w, h, '', alignment=6)
                self._ov_background = xbmcgui.ControlImage(x, y, w, h, fs_dec(xPlayer.get_ov_image()))
                self._ov_background.setColorDiffuse('0xD0000000')
                self.ov_visible = False
                self.tsv = getTSVer()
                self.onPlayBackStarted()


        def onPlayBackPaused(self):
                self.ov_show()
                if not xbmc.Player().isPlaying(): xbmc.sleep(2000)
                status = ''
                self.paused = True
                while xbmc.Player().isPlaying() and self.paused and not abortRequested():
                        if self.ov_visible == True:
                              try:
                                if self.tsv == 2:
                                     info = Mto1(client("/stream", get_data={"link": self.hash, "stat":"true"}))
                                else:
                                     info = client("/torrent/stat", post_data={"Hash": self.hash})
                                if info is None:
                                     if self.getTotalTime() > 0 and self.getTotalTime() - self.getTime() < 4*60 and client("/echo"): status = u'Конец скоро'
                                     elif client("/echo"): status = u'Нет данных о раздаче'
                                     else: status = u'TorrServer не отвечает'
                                else:
                                 downloaded        = int(info['LoadedSize'])
                                 dl_speed        = int(info.get('DownloadSpeed', 0))
                                 ul_speed        = int(info.get('UploadSpeed', 0))
                                 if self.index is not None:
                                   size                = int(info['FileStats'][self.index]['Length'])
                                 else:
                                   size                = int(info['TorrentSize'])
                                 percent = float(downloaded) * 100 / size
                                 if percent >= 0:
                                        heading = u"Загружено: {} Мб из {} Мб - {}% ({})".format(int(downloaded/1024/1024), int(size/1024/1024), int(percent), humanizeSize(int(info['TorrentSize']))) + '\n'
                                        if percent: #< 100:
                                                heading += u"Скорость загрузки: {}/сек   Скорость отдачи: {}/сек\n".format(humanizeSize(dl_speed), humanizeSize(ul_speed))
                                                heading += u"Сиды: {}    Активные пиры: {}    Всего пиров: {}".format(info['ConnectedSeeders'], info['ActivePeers'], info['TotalPeers'])

                                        status = heading
                              except:
                                        status = 'error'
                              self.ov_update(status)
                        xbmc.sleep(800)


        def onPlayBackStarted(self):
                self.ov_hide()

        def onPlayBackResumed(self):
                self.paused = False
                self.ov_hide()
                
        def onPlayBackStopped(self):
                self.ov_hide()
        
        def __del__(self):
                self.ov_hide()

        @staticmethod
        def get_ov_image():
                ov_image = fs_enc(os.path.join(addon.getAddonInfo('path'), 'bg.png'))
                if not os.path.isfile(ov_image):
                        import base64
                        fl = open(ov_image, 'wb')
                        fl.write(base64.b64decode('iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAQAAAC1HAwCAAAAC0lEQVR42mNk+A8AAQUBAScY42YAAAAASUVORK5CYII='))
                        fl.close()
                return ov_image

        @staticmethod
        def get_skin_resolution():
                import xml.etree.ElementTree as Et
                skin_path = fs_enc(translatePath('special://skin/'))
                tree = Et.parse(os.path.join(skin_path, 'addon.xml'))
                res = tree.findall('./extension/res')[0]
                return int(res.attrib['width']), int(res.attrib['height'])

        def ov_show(self):
                if not self.ov_visible:
                        self._ov_window.addControls([self._ov_background, self._ov_label])
                        self.ov_visible = True

        def ov_hide(self):
                if self.ov_visible:
                        self._ov_window.removeControls([self._ov_background, self._ov_label])
                        self.ov_visible = False

        def ov_update(self, txt=" "):
                if self.ov_visible:
                        self._ov_label.setLabel(txt)
