# -*- coding: utf-8 -*-
import sys
PY2 = sys.version_info.major == 2
import json
import socket
import ssl
import time
from threading import Thread
if PY2:
      from urllib import urlencode
#      from urllib2 import HTTPError, urlopen
      from Queue import Queue, PriorityQueue
else:
      xrange = range
      from urllib.parse import urlencode
#      from urllib.error import HTTPError
#      from urllib.request import urlopen
      from queue import Queue, PriorityQueue


socket.setdefaulttimeout(24)
ssl._create_default_https_context = ssl._create_unverified_context

try:
    addon = __import__('xbmcaddon').Addon()
    language = addon.getSetting('LanguageID')
    is_region = addon.getSetting('is_region') == 'true'
    regionid = addon.getSetting('regionID')
    adult = addon.getSetting('is_adult') == 'true'
    block_tmdb = addon.getSetting('block_tmdb') == 'true'
    block_tmdb_dns = addon.getSetting('block_tmdb_dns') == 'true'
    short_tmdb = addon.getSetting('short_tmdb') == 'true'
    trailer_orig_if_not_localize = addon.getSetting('trailer_orig_if_not_localize') == 'true'
except:
    language = 'ru'
    is_region = True
    regionid = 'RU'
    adult = False
    block_tmdb = False
    block_tmdb_dns = False
    short_tmdb = False
    trailer_orig_if_not_localize = True


if block_tmdb_dns:
    prv_getaddrinfo = socket.getaddrinfo
    dns_cache = {
#    ('api.themoviedb.org', 80, 0, 1): [(10, 1, 6, '', ('2600:9000:21f3:c600:c:174a:c400:93a1', 80, 0, 0)), (10, 1, 6, '', ('2600:9000:21f3:d800:c:174a:c400:93a1', 80, 0, 0)), (10, 1, 6, '', ('2600:9000:21f3:8a00:c:174a:c400:93a1', 80, 0, 0)), (10, 1, 6, '', ('2600:9000:21f3:9200:c:174a:c400:93a1', 80, 0, 0)), (10, 1, 6, '', ('2600:9000:21f3:7400:c:174a:c400:93a1', 80, 0, 0)), (10, 1, 6, '', ('2600:9000:21f3:2e00:c:174a:c400:93a1', 80, 0, 0)), (10, 1, 6, '', ('2600:9000:21f3:dc00:c:174a:c400:93a1', 80, 0, 0)), (10, 1, 6, '', ('2600:9000:21f3:3800:c:174a:c400:93a1', 80, 0, 0)), (2, 1, 6, '', ('13.35.180.61', 80)), (2, 1, 6, '', ('13.35.180.96', 80)), (2, 1, 6, '', ('13.35.180.55', 80)), (2, 1, 6, '', ('13.35.180.40', 80))],
#    ('api.themoviedb.org', 80, 0, 1): [(10, 1, 6, '', ('2600:9000:2118:8000:c:174a:c400:93a1', 80, 0, 0)), (10, 1, 6, '', ('2600:9000:2118:3400:c:174a:c400:93a1', 80, 0, 0)), (10, 1, 6, '', ('2600:9000:2118:3200:c:174a:c400:93a1', 80, 0, 0)), (10, 1, 6, '', ('2600:9000:2118:5200:c:174a:c400:93a1', 80, 0, 0)), (10, 1, 6, '', ('2600:9000:2118:5c00:c:174a:c400:93a1', 80, 0, 0)), (10, 1, 6, '', ('2600:9000:2118:6e00:c:174a:c400:93a1', 80, 0, 0)), (10, 1, 6, '', ('2600:9000:2118:e600:c:174a:c400:93a1', 80, 0, 0)), (10, 1, 6, '', ('2600:9000:2118:5a00:c:174a:c400:93a1', 80, 0, 0)), (2, 1, 6, '', ('13.33.242.81', 80)), (2, 1, 6, '', ('13.33.242.29', 80)), (2, 1, 6, '', ('13.33.242.105', 80)), (2, 1, 6, '', ('13.33.242.39', 80))]
    ('api.themoviedb.org', 80, 0, 1): [(10, 1, 6, '', ('2600:9000:2304:1a00:c:174a:c400:93a1', 80, 0, 0)), (10, 1, 6, '', ('2600:9000:2304:5600:c:174a:c400:93a1', 80, 0, 0)), (10, 1, 6, '', ('2600:9000:2304:de00:c:174a:c400:93a1', 80, 0, 0)), (10, 1, 6, '', ('2600:9000:2304:b600:c:174a:c400:93a1', 80, 0, 0)), (10, 1, 6, '', ('2600:9000:2304:e800:c:174a:c400:93a1', 80, 0, 0)), (10, 1, 6, '', ('2600:9000:2304:c800:c:174a:c400:93a1', 80, 0, 0)), (10, 1, 6, '', ('2600:9000:2304:ee00:c:174a:c400:93a1', 80, 0, 0)), (10, 1, 6, '', ('2600:9000:2304:ce00:c:174a:c400:93a1', 80, 0, 0)), (2, 1, 6, '', ('18.66.15.99', 80)), (2, 1, 6, '', ('18.66.15.57', 80)), (2, 1, 6, '', ('18.66.15.36', 80)), (2, 1, 6, '', ('18.66.15.39', 80))],
    ('api.themoviedb.org', 443, 0, 1): [(10, 1, 6, '', ('2600:9000:2304:1a00:c:174a:c400:93a1', 443, 0, 0)), (10, 1, 6, '', ('2600:9000:2304:5600:c:174a:c400:93a1', 443, 0, 0)), (10, 1, 6, '', ('2600:9000:2304:de00:c:174a:c400:93a1', 443, 0, 0)), (10, 1, 6, '', ('2600:9000:2304:b600:c:174a:c400:93a1', 443, 0, 0)), (10, 1, 6, '', ('2600:9000:2304:e800:c:174a:c400:93a1', 443, 0, 0)), (10, 1, 6, '', ('2600:9000:2304:c800:c:174a:c400:93a1', 443, 0, 0)), (10, 1, 6, '', ('2600:9000:2304:ee00:c:174a:c400:93a1', 443, 0, 0)), (10, 1, 6, '', ('2600:9000:2304:ce00:c:174a:c400:93a1', 443, 0, 0)), (2, 1, 6, '', ('18.66.15.99', 443)), (2, 1, 6, '', ('18.66.15.57', 443)), (2, 1, 6, '', ('18.66.15.36', 443)), (2, 1, 6, '', ('18.66.15.39', 443))]
    }

    def new_getaddrinfo(*args):
        if args in dns_cache:
            return dns_cache[args]
        res = prv_getaddrinfo(*args)
        dns_cache[args] = res
#        print(dns_cache)
#        open('dns_cache.txt', 'wb').write(str(dns_cache))
        return res

    socket.getaddrinfo = new_getaddrinfo


class TMDB:
    def __init__(self):
#        self.api_key = 'f090bb54758cabf231fb605d3e3e0468'
        self.api_key = '99e8b7beac187a857152f57d67495cf4'
        self.language = language #'ru-RU' if language=='ru' else language
        self.is_region = is_region
        self.adult = adult
        self.region = regionid

    def discover_movie(self, year=None, page=None, wolang=None, genres=None, ngenres=None, params=None):
        data = {}
        data['api_key'] = self.api_key
        data['language'] = self.language
        if self.is_region: data['region'] = self.region
#        data['with_release_type'] = '2|3'
        if year: data['year'] = year
        if page: data['page'] = page
        if wolang: data['with_original_language'] = wolang
        if genres: data['with_genres'] = genres
        if ngenres:data['without_genres'] = ngenres
#        data['sort_by'] = 'vote_count.desc'
        if self.adult: data['include_adult'] = 'true'
        if params: data.update(params)
        url_values = urlencode(data)
        url = 'http://api.themoviedb.org/3/discover/movie?{0}'.format(url_values)
        infostring = self.req(url)
        infostring = moreInfo(infostring, 'movie')
        return infostring

    def discover_tvshow(self, year=None, page=None, wolang=None, genres=None, ngenres=None, params=None):
        data = {}
        data['api_key'] = self.api_key
        data['language'] = self.language
        if year: data['air_date.gte'] = str(year)+'-01-01'
        if page: data['page'] = page
        if wolang: data['with_original_language'] = wolang
        if genres: data['with_genres'] = genres
        if ngenres:data['without_genres'] = ngenres
        if self.adult: data['include_adult'] = 'true'
        if params: data.update(params)
        url_values = urlencode(data)
        url = 'http://api.themoviedb.org/3/discover/tv?{0}'.format(url_values)
        infostring = self.req(url)
        infostring = moreInfo(infostring, 'tv')
        return infostring

    def trending(self, mtype='all', wtime='day', page=None):
        data = {}
        data['api_key'] = self.api_key
        data['language'] = self.language
        if page: data['page'] = page
        #if self.adult: data['include_adult'] = 'true'
        url_values = urlencode(data)
        url = 'http://api.themoviedb.org/3/trending/{0}/{1}?{2}'.format(mtype, wtime, url_values)
        infostring = self.req(url)
        infostring = moreInfo(infostring)
        return infostring

    def top_rated(self, mtype='movie', page=None):
        data = {}
        data['api_key'] = self.api_key
        data['language'] = self.language
        if page: data['page'] = page
        if self.adult: data['include_adult'] = 'true'
        if self.is_region: data['region'] = self.region
        url_values = urlencode(data)
        url = 'http://api.themoviedb.org/3/{0}/top_rated?{1}'.format(mtype, url_values)
        infostring = self.req(url)
        infostring = moreInfo(infostring, mtype)
        return infostring

    def genre(self, mtype='movie'):
        data = {}
        data['api_key'] = self.api_key
        data['language'] = self.language
        if self.adult: data['include_adult'] = 'true'
        url_values = urlencode(data)
        url = 'http://api.themoviedb.org/3/genre/{0}/list?{1}'.format(mtype, url_values)
        infostring = self.req(url)
        return infostring

    def search_movies(self, query, page=None, params=None):
        data = {}
        data['api_key'] = self.api_key
        if page: data['page'] = str(page)
        data['query'] = query
        data['language'] = self.language
        if self.adult: data['include_adult'] = 'true'
        if params: data.update(params)
        url_values = urlencode(data)
        url = 'http://api.themoviedb.org/3/search/movie?{0}'.format(url_values)
        infostring = self.req(url)
        infostring = moreInfo(infostring, 'movie')
        return infostring

    def search_tv_shows(self, query, page=None, params=None):
        data = {}
        data['api_key'] = self.api_key
        if page: data['page'] = str(page)
        data['query'] = query
        data['language'] = self.language
        if self.adult: data['include_adult'] = 'true'
        if params: data.update(params)
        url_values = urlencode(data)
        url = 'http://api.themoviedb.org/3/search/tv?{0}'.format(url_values)
        infostring = self.req(url)
        infostring = moreInfo(infostring, 'tv')
        return infostring

    def get_movie(self, id):
        data = {}
        data['api_key'] = self.api_key
        data['language'] = self.language
        data['append_to_response'] = 'credits,trailers,release_dates,alternative_titles'
        url_values = urlencode(data, True)
        url = 'http://api.themoviedb.org/3/movie/{0}?{1}'.format(id, url_values)
        infostring = self.req(url)
        if trailer_orig_if_not_localize and not infostring.get('trailers', {}).get('youtube'):
             url2 = 'http://api.themoviedb.org/3/movie/{0}/trailers?{1}'.format(id, urlencode({'api_key':self.api_key}, True))
             trailers = self.req(url2)
             if infostring and trailers: infostring['trailers']['youtube'] = trailers['youtube']
        return infostring

    def get_tv_show(self, id):
        data = {}
        data['api_key'] = self.api_key
        data['language'] = self.language
        data['append_to_response'] = 'credits,external_ids,videos,content_ratings,alternative_titles'
        url_values = urlencode(data, True)
        url = 'http://api.themoviedb.org/3/tv/{0}?{1}'.format(id, url_values)
        infostring = self.req(url)
        if trailer_orig_if_not_localize and not infostring.get('videos', {}).get('results'):
             url2 = 'http://api.themoviedb.org/3/tv/{0}/videos?{1}'.format(id, urlencode({'api_key':self.api_key}, True))
             videos = self.req(url2)
             if infostring and videos: infostring['videos']['results'] = videos['results']
        return infostring

    def get_person(self, id):
        data = {}
        data['api_key'] = self.api_key
        data['language'] = self.language
        data['append_to_response'] = 'movie_credits,tv_credits'
        if self.adult: data['include_adult'] = 'true'
        url_values = urlencode(data)
        url = 'http://api.themoviedb.org/3/person/{0}?{1}'.format(id, url_values)
        infostring = self.req(url)
        return infostring

    def req(self, url):
        if PY2:
              from urllib2 import HTTPError, urlopen
        else:
              from urllib.error import HTTPError
              from urllib.request import urlopen
        resp = b"{}"
        if block_tmdb: url = 'http://127.0.0.1:8095/proxy/'+url.replace('http://', 'https://') # через TAM прокси
        try:
            response = urlopen(url)
        except HTTPError as e:
#            print(e.readlines())
            if e.code == 429:
                ret_after = float(e.info().get('Retry-After', 10))
                time.sleep(ret_after + 0.5)
                response = urlopen(url)
                resp = response.read()
#            else: raise e
        else:
            resp = response.read()
        infostring = json.loads(resp.decode('utf-8', 'replace'))
        return infostring

def moreInfo(infostring, type='movie'):
    if short_tmdb: return infostring
    queue = Queue()
    result = PriorityQueue()
    for i in infostring.get('results', []):
        queue.put(( i.get('id'), i.get('media_type', type) ))
    for i in xrange(5):
        w = Worker(queue, result, type)
        w.start()
    queue.join()
    out = []
    while not result.empty():
        out.append(result.get()[1])
    infostring['results'] = out
    return infostring


class Worker(Thread):
    counter = -1

    def __init__(self, queue_in, queue_out, type):
        super(Worker, self).__init__()
        self.setDaemon(True)
        self.__queue_in = queue_in
        self.__queue_out = queue_out
        self.type = type
        self.tmdb = TMDB()

    def run(self):
        while not self.__queue_in.empty():
            job = self.__queue_in.get()
            Worker.counter += 1
            num = Worker.counter
            id = job[0]
            mtype = job[1]
            try:
                if mtype == 'movie':
                   job = self.tmdb.get_movie(id)
                elif mtype == 'person':
                   job = self.tmdb.get_person(id)
                else:
                   job = self.tmdb.get_tv_show(id)
            except BaseException as e:
                job = {'error': e, 'id': id, 'media_type': mtype}
                print(e)
            else:
                if job: job['media_type'] = mtype
            self.__queue_out.put((num, job))
            self.__queue_in.task_done()

if __name__ == '__main__':
#	print(len(TMDB().trending('tv', 'day', page=1)))
#	print(TMDB().genre())
#	print(TMDB().genre('tv'))
#	print(len(TMDB().discover_movie('2020',1, ngenres='16,12')))
#	print(len(TMDB().discover_movie('2020',1)))
#	print(TMDB().discover_tvshow('2020',1,genres='16')['results'][0]['id'])
#	print(len(TMDB().trending('movie', 'day')))
#	print(len(TMDB().trending('person', 'day')))
#	print(len(TMDB().top_rated('tv')))
	import threading
	for i in threading.enumerate()[1:]:
		print(i)
		print(i.counter)
#	time.sleep(0.1)
	print(threading.enumerate())
