# -*- coding: utf-8 -*-
import os, sys
import re
import time

import xbmc
import xbmcgui
import xbmcplugin

from config import ADDON_PATH
from utils import plugin, _T, PY2,  _en, _de, makeLabel, makeMovieItem, makeTvShowItem, showHistory, addHistory, ruCountry, _showRating_, _showYear_, _showGenre_, _showCountry_, genres as GENRES
from tmdb.api import TMDB
from searcher.scrapers import rutor
if not PY2:
    unicode = str
    long = int


DEBUG = False

tmdb = TMDB()

siteUrl = 'https://raw.githubusercontent.com/yourok-0001/releases1/master/releases/'

QualityStr = {
0  : 'LOWER',
100: 'WEBDL 720p',
101: 'BDRIP 720p',
102: 'BDRIP HEVC 720p',
200: 'WEBDL 1080p',
201: 'BDRIP 1080p',
202: 'BDRIP HEVC 1080p',
203: 'BDREMUX 1080p',
300: 'WEBDL SDR 2160p',
301: 'WEBDL HDR 2160p',
302: 'WEBDL DV 2160p',
303: 'BDRIP SDR 2160p',
304: 'BDRIP HDR 2160p',
305: 'BDRIP DV 2160p',
306: 'UHD BDREMUX SDR',
307: 'UHD BDREMUX HDR',
308: 'UHD BDREMUX DV'
}

VoiceStr = {
0:   '',   # неизвестно
1:   'A',  # Авторский, по типу Гоблина или старых переводчиков
100: 'L1', # Любительский одноголосый закадровый
101: 'L2', # Любительский двухголосый закадровый
102: 'L',  # Любительский 3-5 человек закадровый
103: 'LS', # Любительский студия
200: 'P1', # Професиональный одноголосый закадровый
201: 'P2', # Профессиональный двухголосый закадровый
202: 'P',  # Профессиональный 3-5 человек закадровый
203: 'PS', # Профессиональный студия
300: 'D',  # Официальное профессиональное многоголосое озвучивание
301: 'LICENSE' # Лицензия
}

def numSize(stringSize):
    if stringSize[stringSize.rfind(' ')+1:] in ['МБ', 'MB']:
          size = long(float(stringSize[:stringSize.rfind(' ')]) * float(2 << 19))
    else:
          size = long(float(stringSize[:stringSize.rfind(' ')]) * float(2 << 29))
    return size


def makeItem(t, file, index, timeadd=0, show_rating_list=_showRating_, show_year=_showYear_, show_genre=_showGenre_, show_country=_showCountry_):
    i = {}
    genres = []
    for g in t.get('genre_ids', []): genres.append(GENRES[g])
    size = numSize(t['torrent'][0]['size'])
    dateadded = time.strftime("%Y-%m-%d %H:%M:%S", time.localtime(timeadd) )
    i['label'] = t['torrent'][0].get('name', '[COLOR red]None[/COLOR] - id: '+str(t['id'])+' - index: '+str(index))
    i['url'] = plugin.get_url(action='releases/select', file=file, index=index)
    premiered = t.get('release_date')
    i.update({ 'info':{
    'video':{
       'genre' : genres,
       'rating': t.get('vote_average', 0),
       'votes' : t.get('vote_count', 0),
       'country': [ruCountry(c) for c in t.get('countries')] if t.get('countries') else None,
       'premiered': premiered,
       'mediatype': 'tvshow' if t['media_type'] == 'tv' else 'movie',
       'size': size,
       'dateadded': dateadded,
       'date': t['torrent'][0]['date'],
    }}})
    if premiered: i['info']['video']['year'] = int(premiered[-4:])
    if show_rating_list:
       i['label'] = makeLabel(i['label'], t.get('vote_average'),
                              i.get('info', {}).get('video', {}).get('year') if show_year else None,
                              genres if show_genre else None,
                              i.get('info',{}).get('video', {}).get('country') if show_country else None)
    return i


@plugin.action('releases/select')
def selectTorrent(params):
    data = GET(params.file)
    info = data['items'][int(params.index)]
    li = []
    del params['action']
    id = None
    if True:
        id = info['id']
        params.type = 'tvshow' if info['media_type'] == 'tv' else info['media_type']
        item = makeItemTMDB(params.type, id)
    if not item.get('label'):
        item = makeItem(info, params.file, params.index)
    params.poster = item.get('art', {}).get('poster')
    for t in info['torrent']:
        size = numSize(t['size'])
        params.ttn = t['source']
        params.size = size
        params.magnet = t['magnet']
        if t['source'].lower() == 'rutor' and t['link'].startswith('/'):
              params.pageurl = rutor.httpSiteUrl+t['link']
        else:
              params.pageurl = t['link']
        item.update({
        'label': t.get('name', '[COLOR red]None[/COLOR] - id: '+str(info['id']))+'\n'+ \
                 t['size']+'  '+VoiceStr[t.get('voice', 0)]+'  '+QualityStr[t.get('quality', 0)]+'   [ '+t['source']+' ]   '+t.get('date', '')+'   [COLOR green]'+t.get('upload', '')+'[/COLOR]   [COLOR red]'+t.get('download', '')+'[/COLOR]',
        'url': plugin.get_url(action='gotInfo', **params),
        })
        item['info']['video']['size'] = size
        title = t.get('name', item['info']['video'].get('title'))
        query_year = titlefull = title
        org_title = item['info']['video'].get('originaltitle')
        if org_title and org_title.lower() not in titlefull.lower(): titlefull += ' / '+item['info']['video']['originaltitle']
        if item['info']['video'].get('year'):
            titlefull += ' / '+str(item['info']['video']['year'])
            query_year+= ' ('+str(item['info']['video']['year'])+')'
        if t.get('voice'): titlefull += ' / ' + VoiceStr[t.get('voice', 0)]
        if t.get('quality'): titlefull += ' / ' + QualityStr[t.get('quality', 0)]
        item['context_menu'] = [(
            _T('Сохранить в списке'),
            "RunPlugin(%s)" % plugin.get_url(action='torrents', mod='add', cast=repr(item.get('cast')), **params)
          ), (
            _T('Сохранить в списке с названием'),
            "RunPlugin(%s)" % plugin.get_url(action='torrents', mod='add', title=_en(titlefull), cast=repr(item.get('cast')), **params)
          ), (
            _T('Поиск'),
            "Container.Update(%s)" % plugin.get_url(action="search", mod="torrent", query='', id=id, **params)
          ), (
            "Поиск по названию и году без фильтра",
            "Container.Update(%s)" % plugin.get_url(action="search", mod="torrent", type='video', getinfo=True, query=_en(query_year)),
          ), (
            "Поиск по названию без фильтра",
            "Container.Update(%s)" % plugin.get_url(action="search", mod="torrent", type='video', getinfo=True, query=_en(title)),
          ), (
            "%s TheMovieDB" % _T("Найти на"),
            "Container.Update(%s)" % plugin.get_url(action="search", mod="search", query=_en(title), **params)
          ), (
            "%s World-art.ru" % _T("Найти на"),
            "Container.Update(%s)" % plugin.get_url(action='worldart/search', mod='cinema', query=_en(title), origquery=_en(item['info']['video'].get('originaltitle','')))
          ), (
            _T('Open TAM'),
            "RunPlugin(%s)" % plugin.get_url(action='tam', **params)
          ), (
            _T("Settings"), "RunPlugin(%s)" % plugin.get_url(action="settings", mod="read")
        )]
        li.append(item)
    return plugin.create_listing(li, category="Варианты раздач", content='videos', cache_to_disk=False, sort_methods=None)


def chkUrl(url, addurl=siteUrl):
    if addurl:
       addurl = addurl[:addurl.rfind('/')+1]
       if not addurl.startswith('http'):
          addurl = siteUrl + addurl
       if url and not url.startswith('http'):
          if url.startswith('../'):
             addurl = addurl[:addurl.rfind('/')+1]
             url = url[2:]
          url = addurl + url
    return url


@plugin.mem_cached(600, '__cache_tmdb__.pcl')
def makeItemTMDB(type, id, size=None):
    if type == "movie":  item = makeMovieItem(tmdb.get_movie(id), False, size)
    elif type == "tvshow": item = makeTvShowItem(tmdb.get_tv_show(id), "tvshow", None, True, size)
    return item


@plugin.mem_cached(120)
def GET(url, post=None, getp=None, debug=False):
    host=siteUrl
    if url.startswith('http://') or url.startswith('https://'):
        host=url
        url=''
    if debug:
       filename='/home/osmc/'+url.replace('/','_').replace('http://','').replace('https://','').replace('.','_')+'.txt'
       if os.path.isfile(filename):
           return open(filename, 'r').read()
#    if post:
#       for k in post:
#           post[k] = post[k].encode('windows-1251')
#       post = urlencode(post).encode()
#       xbmcgui.Dialog().textviewer('debug - GET', str(post))
    from client import client
    data = client(url, post_data=post, get_data=getp, host=host, ljs=False, err=True)
    if url.endswith('.json'):
        import zlib
        data = zlib.decompressobj(16 + zlib.MAX_WBITS).decompress(data)
        import json
        data = json.loads(data)
#    from searcher.xbmcup.net import HTTP
#    h = HTTP()
#    res = h.fetch(host+url)
#    data = res.body
    if debug:
       dataf = unicode(data).decode('windows-1251')
       open(filename, 'w').write(dataf)
    return data


@plugin.action('releases')
def main(params):
    listing = []
    year = int( time.strftime('%Y') )
    listing.append({
            'label': "4K",
            'url': plugin.get_url(action="releases/list", file='4k_id.json'),
            'icon': os.path.join(ADDON_PATH, "resources", "img", "top.png"),
            'is_folder': True,
            'properties': {'specialsort': 'top'}
    })
    listing.append({
            'label': "Фильмы",
            'url': plugin.get_url(action="releases/list", file='movies_id.json'),
            'icon': os.path.join(ADDON_PATH, "resources", "img", "movies.png"),
            'is_folder': True,
            'properties': {'specialsort': 'top'}
    })
    listing.append({
            'label': "Мультфильмы",
            'url': plugin.get_url(action="releases/list", file='cartoons_id.json'),
            'icon': os.path.join(ADDON_PATH, "resources", "img", "movies.png"),
            'is_folder': True,
            'properties': {'specialsort': 'top'}
    })
    listing.append({
            'label': "Сериалы",
            'url': plugin.get_url(action="releases/list", file='tv_id.json'),
            'icon': os.path.join(ADDON_PATH, "resources", "img", "tv.png"),
            'is_folder': True,
            'properties': {'specialsort': 'top'}
    })
    listing.append({
            'label': "Мультсериалы",
            'url': plugin.get_url(action="releases/list", file='cartoons_tv_id.json'),
            'icon': os.path.join(ADDON_PATH, "resources", "img", "tv.png"),
            'is_folder': True,
            'properties': {'specialsort': 'top'}
    })
    listing.append({
            'label': "Легенды",
            'url': plugin.get_url(action="releases/list", file='legends_id.json'),
            'icon': os.path.join(ADDON_PATH, "resources", "img", "top.png"),
            'is_folder': True,
            'properties': {'specialsort': 'top'}
    })
    listing.append({
            'label': "Фильмы по году",
            'url': plugin.get_url(action="releases/yearlist", file='movies_id_{}.json', title='{} год - фильмы', years='1980-'+str(year)),
            'icon': os.path.join(ADDON_PATH, "resources", "img", "movies.png"),
            'is_folder': True,
            'properties': {'specialsort': 'top'}
    })
    '''
    mod = "cinema"
    listing.append({
            'label': "Поиск в разделе кино",
            'url': plugin.get_url(action="worldart/search", mod=mod),
            'icon': os.path.join(ADDON_PATH, "resources", "img", "search.png"),
            'is_folder': True,
            'properties': {'specialsort': 'top'}
    })
    def search_url(q):
        return plugin.get_url(action="worldart/search", mod=mod, query=q)
    listing = showHistory(listing, 'Worldart_'+mod, search_url)
    '''
    return plugin.create_listing(listing, category="Подборки", content='videos', cache_to_disk=False, sort_methods=None)


@plugin.action('releases/list')
def showlist(params):
    data = GET(params.file)
    listing=[]
    index = 0
    timeadd = time.time()
    for t in data['items']:
       item = makeItem(t, params.file, index, timeadd)
       item['context_menu'] = [(_T("Settings"), "RunPlugin(%s)" % plugin.get_url(action="settings", mod="read"))]
       index += 1
       timeadd -= 1
       listing.append(item)
    return plugin.create_listing(listing, category="Подборка от "+_en(data['date'])+" "+_en(data['time']),
           content='videos', cache_to_disk=True, sort_methods=(xbmcplugin.SORT_METHOD_UNSORTED, xbmcplugin.SORT_METHOD_LABEL, xbmcplugin.SORT_METHOD_VIDEO_RATING, xbmcplugin.SORT_METHOD_GENRE, xbmcplugin.SORT_METHOD_SIZE, xbmcplugin.SORT_METHOD_COUNTRY, xbmcplugin.SORT_METHOD_VIDEO_YEAR, xbmcplugin.SORT_METHOD_DATE, xbmcplugin.SORT_METHOD_DATEADDED))

@plugin.action('releases/yearlist')
def showyear(params):
    listing = []
    for year in range(int(params.years.split('-')[0]), int(params.years.split('-')[1])+1):
       listing.append({
            'label': params.title.format(year),
            'url': plugin.get_url(action="releases/list", file=params.file.format(year)),
            'icon': os.path.join(ADDON_PATH, "resources", "img", "movies.png"),
            'is_folder': True,
#            'properties': {'specialsort': 'top'},
       })
    return plugin.create_listing(listing, category="По году", content='videos', cache_to_disk=False,
           sort_methods=(xbmcplugin.SORT_METHOD_LABEL))

