# -*- coding: utf-8 -*-
import os
import re
import time

import xbmc
import xbmcgui

from config import ADDON_PATH
from utils import plugin, _T, PY2,  _en, _de, makeLabel, showHistory, addHistory
if not PY2: unicode = str

DEBUG = False

siteUrl = 'http://world-art.ru/'


def chkUrl(url, addurl=siteUrl):
    if addurl:
       addurl = addurl[:addurl.rfind('/')+1]
       if not addurl.startswith('http'):
          addurl = siteUrl + addurl
       if url and not url.startswith('http'):
          if url.startswith('../'):
             addurl = addurl[:addurl.rfind('/')+1]
             url = url[2:]
          url = addurl + url
    return url

def getAttr(soup, atr=None):
    if soup: return soup[atr] if atr else soup.text.strip()
    return soup



def GET(url, post=None, getp=None, debug=False):
    host=siteUrl
    if url.startswith('http://') or url.startswith('https://'):
        host=url
        url=''
    if debug:
       filename='/home/osmc/'+url.replace('/','_').replace('http://','').replace('https://','').replace('.','_')+'.txt'
       if os.path.isfile(filename):
           return open(filename, 'r').read()
#    if post:
#       for k in post:
#           post[k] = post[k].encode('windows-1251')
#       post = urlencode(post).encode()
#       xbmcgui.Dialog().textviewer('debug - GET', str(post))
    from client import client
    data = client(url, post_data=post, get_data=getp, raw=False, host=host, ljs=False, err=True)
    if debug:
       dataf = data.decode('windows-1251')
       open(filename, 'w').write(dataf)
    return data


@plugin.action('worldart/kino')
def main(params):
    listing = []
    year = int( time.strftime('%Y') )
    listing.append({
            'label': "База данных по кино",
            'url': plugin.get_url(action="worldart/navigator"),
            'icon': os.path.join(ADDON_PATH, "resources", "img", "kinoWA.png"),
            'is_folder': True,
            'properties': {'specialsort': 'top'}
    })
    listing.append({
            'label': "Новинки %s года" % year,
            'url': plugin.get_url(action="worldart/catalog", url='cinema/list.php', getp=repr({'public_year': year, 'status':1, 'sort':3}) ),
            'icon': os.path.join(ADDON_PATH, "resources", "img", "kinoWA.png"),
            'is_folder': True,
            'properties': {'specialsort': 'top'}
    })
    listing.append({
            'label': "Фильмы %s года" % year,
            'url': plugin.get_url(action="worldart/catalog", url='cinema/list.php', getp=repr({'public_type':1, 'public_year': year, 'status':3, 'sort':2}) ),
            'icon': os.path.join(ADDON_PATH, "resources", "img", "movies.png"),
            'is_folder': True,
            'properties': {'specialsort': 'top'}
    })
    listing.append({
            'label': "Фильмы %s года по рейтингу" % year,
            'url': plugin.get_url(action="worldart/catalog", url='cinema/list.php', getp=repr({'public_type':1, 'public_year': year, 'status':3, 'sort':1}) ),
            'icon': os.path.join(ADDON_PATH, "resources", "img", "movies.png"),
            'is_folder': True,
            'properties': {'specialsort': 'top'}
    })
    listing.append({
            'label': "Фильмы %s года" % (year-1),
            'url': plugin.get_url(action="worldart/catalog", url='cinema/list.php', getp=repr({'public_type':1, 'public_year': year-1, 'status':3, 'sort':2}) ),
            'icon': os.path.join(ADDON_PATH, "resources", "img", "movies.png"),
            'is_folder': True,
            'properties': {'specialsort': 'top'}
    })
    listing.append({
            'label': "Фильмы %s года по рейтингу" % (year-1),
            'url': plugin.get_url(action="worldart/catalog", url='cinema/list.php', getp=repr({'public_type': 1, 'public_year': year-1, 'status':3, 'sort':1}) ),
            'icon': os.path.join(ADDON_PATH, "resources", "img", "movies.png"),
            'is_folder': True,
            'properties': {'specialsort': 'top'}
    })
    listing.append({
            'label': "Самые дорогие фильмы %s года" % (year-1),
            'url': plugin.get_url(action="worldart/catalog", url='cinema/list.php', getp=repr({'public_type':1, 'public_year': year-1, 'status':3, 'sort':7}) ),
            'icon': os.path.join(ADDON_PATH, "resources", "img", "top.png"),
            'is_folder': True,
            'properties': {'specialsort': 'top'}
    })
    listing.append({
            'label': "Самые кассовые фильмы %s года" % (year-1),
            'url': plugin.get_url(action="worldart/catalog", url='cinema/list.php', getp=repr({'public_type':1, 'public_year': year-1, 'status':3, 'sort':8}) ),
            'icon': os.path.join(ADDON_PATH, "resources", "img", "top.png"),
            'is_folder': True,
            'properties': {'specialsort': 'top'}
    })
    listing.append({
            'label': "Все фильмы по рейтингу",
            'url': plugin.get_url(action="worldart/catalog", url='cinema/list.php', getp=repr({'public_type':1, 'status':3, 'sort':1}) ),
            'icon': os.path.join(ADDON_PATH, "resources", "img", "movies.png"),
            'is_folder': True,
            'properties': {'specialsort': 'top'}
    })
    listing.append({
            'label': "Самые дорогие фильмы в истории",
            'url': plugin.get_url(action="worldart/catalog", url='cinema/list.php', getp=repr({'public_type':1, 'status':3, 'sort':7}) ),
            'icon': os.path.join(ADDON_PATH, "resources", "img", "top.png"),
            'is_folder': True,
            'properties': {'specialsort': 'top'}
    })
    listing.append({
            'label': "Самые кассовые фильмы в истории",
            'url': plugin.get_url(action="worldart/catalog", url='cinema/list.php', getp=repr({'public_type':1, 'status':3, 'sort':8}) ),
            'icon': os.path.join(ADDON_PATH, "resources", "img", "top.png"),
            'is_folder': True,
            'properties': {'specialsort': 'top'}
    })
    listing.append({
            'label': "Все сериалы по рейтингу",
            'url': plugin.get_url(action="worldart/catalog", url='cinema/list.php', getp=repr({'public_type':2, 'status':3, 'sort':1}) ),
            'icon': os.path.join(ADDON_PATH, "resources", "img", "tv.png"),
            'is_folder': True,
            'properties': {'specialsort': 'top'}
    })
    listing.append({
            'label': "Сериалы стартовавшие в %s году" % year,
            'url': plugin.get_url(action="worldart/catalog", url='cinema/list.php', getp=repr({'public_type':2, 'public_year': year, 'status':3, 'sort':2}) ),
            'icon': os.path.join(ADDON_PATH, "resources", "img", "tv.png"),
            'is_folder': True,
            'properties': {'specialsort': 'top'}
    })
    listing.append({
            'label': "Сериалы стартовавшие в %s году" % (year-1),
            'url': plugin.get_url(action="worldart/catalog", url='cinema/list.php', getp=repr({'public_type':2, 'public_year': year-1, 'status':3, 'sort':2}) ),
            'icon': os.path.join(ADDON_PATH, "resources", "img", "tv.png"),
            'is_folder': True,
            'properties': {'specialsort': 'top'}
    })
    listing.append({
            'label': "Неоконченные западные сериалы",
            'url': plugin.get_url(action="worldart/catalog", url='cinema/list.php', getp=repr({'public_keyword':5}) ),
            'icon': os.path.join(ADDON_PATH, "resources", "img", "tv.png"),
            'is_folder': True,
            'properties': {'specialsort': 'top'}
    })
    listing.append({
            'label': "Неоконченные корейские дорамы",
            'url': plugin.get_url(action="worldart/catalog", url='cinema/list.php', getp=repr({'status':1, 'public_keyword':6, 'sort':3}) ),
            'icon': os.path.join(ADDON_PATH, "resources", "img", "tv.png"),
            'is_folder': True,
            'properties': {'specialsort': 'top'}
    })
    mod = "cinema"
    listing.append({
            'label': "Поиск в разделе кино",
            'url': plugin.get_url(action="worldart/search", mod=mod),
            'icon': os.path.join(ADDON_PATH, "resources", "img", "search.png"),
            'is_folder': True,
            'properties': {'specialsort': 'top'}
    })
    def search_url(q):
        return plugin.get_url(action="worldart/search", mod=mod, query=q)
    listing = showHistory(listing, 'Worldart_'+mod, search_url)
    return plugin.create_listing(listing, category="World-art.ru - Кино", content='videos', cache_to_disk=False, sort_methods=None)


@plugin.action('worldart/navigator')
def navigator(params):
    storage = plugin.get_mem_storage('worldart')
    navlist = storage.get('navigator', [])
    input = storage.get('input', {})
    if not navlist and not input:
       html = GET('cinema/list.php')
       from bs4 import BeautifulSoup
       soup = BeautifulSoup(html, 'html.parser')
       form = soup.find("form", action="list.php")
       trs = form.findAll('tr')
       for tr in trs:
           select = tr.find('select')
           if select:
              name = select['name']
              td = tr.findAll('td')[-1]
              opts = []
              for opt in select.findAll('option'):
                 opts.append({'text':opt.text.strip(), 'value':opt.get('value', opt.text.strip()) })
              navlist.append({'name': name, 'text': td.text.strip(), 'values': opts, 'index':0, 'value':opts[0]['value']})
           else:
                inp = tr.find('input')
                if inp:
                      input = {'type': inp['type'], 'value': inp['value']}
                      storage['input'] = input
       storage['navigator'] = navlist
    update_listing = False
    if params.mod:
       for n in range(len(navlist)):
           if navlist[n]['name'] == params.mod:
              nav_new = navlist[n]
              index = xbmcgui.Dialog().select(heading=nav_new['text'], list=[i['text'] for i in nav_new['values']])
              if index > -1:
                 nav_new['index'] = index
                 nav_new['value'] = nav_new['values'][index]['value']
                 navlist[n] = nav_new
                 storage['navigator'] = navlist
#                 xbmc.executebuiltin('Container.Update(%s,replace)' % plugin.get_url(action="worldart/navigator") )
              return
    listing = []
    finish = {}
    for nav in navlist:
       if nav['value']:
          finish.update({nav['name']: nav['value']})
       listing.append({
            'label': nav['text']+": "+nav['values'][nav['index']]['text'],
            'url': plugin.get_url(action="worldart/navigator", mod=nav['name']),
            'icon': None,
            'is_folder': True,
            'properties': {'specialsort': 'top'}
       })
#    finish.update({'submit':'отобразить список фильмов'}) #{'type':input['type'], 'value':input['value']}
    listing.append({
            'label': "[B]Отобразить список фильмов[/B]",
            'url': plugin.get_url(action="worldart/catalog", url='cinema/list.php', getp=repr(finish)),
            'icon': None,
            'is_folder': True,
            'properties': {'specialsort': 'top'}
    })
    if DEBUG:
       listing.append({
            'label': unicode(finish),
            'url': plugin.get_url(action="worldart/catalog", url='cinema/list.php', getp=repr(finish)),
            'icon': None,
            'is_folder': True,
            'properties': {'specialsort': 'top'}
       })
    return plugin.create_listing(listing, category="World-art.ru - База данных по кино", content='videos', update_listing=update_listing, cache_to_disk=False, sort_methods=None)


@plugin.action('worldart/catalog')
def catalog(params):
    if DEBUG: xbmcgui.Dialog().textviewer('debug', unicode(params))
    getp = None
    if params.getp: getp = eval(params.getp)
    html = GET(params.url, getp=getp)
    from bs4 import BeautifulSoup
    soup = BeautifulSoup(html, 'html.parser')
    if DEBUG: xbmcgui.Dialog().textviewer('debug', unicode( soup.prettify() ))
#    if DEBUG: open('/home/osmc/html.txt', 'w').write( soup.prettify() )
    tables = soup.findAll('table',  cellpadding='0', cellspacing='0', border='0', width='100%', height='1')
#    if DEBUG: xbmcgui.Dialog().textviewer('debug', unicode(tables[2].findNext('td', 'review', valign='top').findAll(text=True) ))
    listing = []
    show_rating_list = plugin.get_setting('show_rating_list_wa', True)
    for t in tables:
       info = {}
       img = getAttr( t.findNext('img', border='1'), 'src')
       img = chkUrl(img, params.url)
       if img: # полноразмерный постер:
          poster = img.replace('/converted_images_','/').replace('/optimize_a/','/').replace('-optimize_a.','.').replace('-','/').replace('world/art', 'world-art')
       td = t.findNext('td', 'review', valign='top')
       num = td.find('font')
       if num:
          numstr = num.text
       ti = td.find('a', 'h3')
       if ti:
          title = ti.text.strip()
          info['title'] = title
       furl = chkUrl( getAttr(ti, 'href'), params.url )
       id = furl.split('id=')[1]
       if img is None or '/'+id+'/' not in poster:
          poster=None
          a = t.findNext('a')
          if a:
             img = getAttr( a.find('img'), 'src')
             img = chkUrl(img, params.url)
             if img and 'id='+id in img:
                poster = 'http://world-art.ru/'+img.split('type=')[1].split('_')[0].split('&')[0]+'/img/'+img.split('pack=')[1].split('&')[0]+'/'+id+'/'+img.split('code_name=')[1].split('&')[0]+'.jpg'
       ye = ti.findNext('font')
       serial = ''
       if ye:
          text_year = ye.text
          if u'сериал' in text_year: serial = u'сериал'
          r = re.compile('([12]\d\d\d)').search(text_year)
          if r:
             info['year'] = int(r.group(1))
       pl = td.find('div', 'hide')
       if pl:
          info['plot'] = pl.text
          info['plotoutline'] = pl.text
       budget = pay = False
       for i in td.findAll(text=True):
          if i.startswith(u'Производство:'):
              info['studio'] = i.split(':', 1)[1].split('(')[0].split(',')
          elif i.startswith(u'Фильм совместного производства:'):
              info['studio'] = i.split(':', 1)[1].split('(')[0].split(',')
          elif i.startswith(u'Жанры:'):
              info['genre'] = i.split(':', 1)[1].split(',')
          elif i.startswith(u'Первый релиз:'):
              info['premiered'] = i.split(':', 1)[1].split('(')[0].strip()
              info['writer'] = i
          elif i.startswith(u'бюджет:'):
              info['tagline'] = i
              budget = True
          elif i.startswith(u'мировые кассовые сборы:'):
              info['mpaa'] = i
              pay = True
          elif budget:
              info['tagline'] += i
              budget = False
          elif pay:
              info['mpaa'] += i
              pay = False
       tdc = td.findNext('td', 'review', width='450')
       if tdc:
           info['cast'] = [i.text for i in tdc.findAll('a', 'review')]
       rg = t.findNext('a', href=re.compile('votes_history\.php\?id='+id))
       if rg:
           info['rating'] = float(rg.text)
       if show_rating_list:
          label = makeLabel(numstr+" "+title, info.get('rating'), info.get('year'), info.get('genre'), info.get('studio'), serial)
       else:
          label = numstr+" "+title+" "+text_year
       query = title #.replace('\u00ab','').replace('\u00bb','')
       info['mediatype'] = "movie" #if serial == '' else "tvshow"
       if info.get('year'):
          query_year = query+" ("+str(info['year'])+')'
          if serial=='': query = query_year
       else: query_year = None
       item = {
            'label': label,
            'url': plugin.get_url(action="search", mod="torrent", type='video', getinfo=True, qfilter=True, query=_en(query)),
            'art': {
                'thumb':  poster,
                'poster': poster,
                'fanart': poster,
            },
            'info': {
                'video': info,
            },
            'is_folder': True,
            'context_menu': [(
                _T("Поиск по названию"),
                "Container.Update(%s)" % plugin.get_url(action="search", mod="torrent", type='video', getinfo=True, qfilter=True, query=_en(title)),
                ),(
                "Поиск без фильтра",
                "Container.Update(%s)" % plugin.get_url(action="search", mod="torrent", type='video', getinfo=True, query=_en(query)),
                ),(
                "Поиск по названию без фильтра",
                "Container.Update(%s)" % plugin.get_url(action="search", mod="torrent", type='video', getinfo=True, query=_en(title)),
            )],
       }
       if serial and query_year:
          item['context_menu'][0] = (
                _T("Поиск по названию и году"),
                "Container.Update(%s)" % plugin.get_url(action="search", mod="torrent", type='video', getinfo=True, qfilter=True, query=_en(query_year)),
          )
          item['context_menu'][2] = (
                "Поиск по названию и году без фильтра",
                "Container.Update(%s)" % plugin.get_url(action="search", mod="torrent", type='video', getinfo=True, query=_en(query_year)),
          )
       item["context_menu"].append(("Подробнее о кино", "Container.Update(%s)" % plugin.get_url(action="worldart/view", url=furl)))
       item["context_menu"].append(("%s TheMovieDB" % _T("Найти на"), "Container.Update(%s)" % plugin.get_url(action="search", mod="search", type='tvshow' if serial else 'movie', query=_en(title))))
       item["context_menu"].append((_T("Settings"), "RunPlugin(%s)" % plugin.get_url(action="settings", mod="read")))
       listing.append(item)
    pg = tables[-1].findNext('div', 'list_button') if len(tables)>0 else None
    if pg:
       next_page = chkUrl(getAttr(pg.find('a'), 'href'), params.url)
       if next_page:
          nf = tables[0].findPrevious(text=re.compile(u'найдено фильмов - \d+'))
          if DEBUG: xbmcgui.Dialog().textviewer('debug', unicode( nf ))
          if nf:
             kino_count = int(nf.split('-')[1])
          else: kino_count = 0
          num_page = 1+int(int(next_page.split('limit_1=')[1].split('&')[0])/25)
          listing.append({
            'label': "{0} / ({1}) - #{2}".format(_T("Next page ({0})").format(num_page), int(float(kino_count)/25+0.9999), kino_count),
            'url': plugin.get_url(action="worldart/catalog", url=next_page),
            'icon': os.path.join(ADDON_PATH, "resources", "img", "nextpage.png"),
            'is_folder': True,
            'properties': {'specialsort': 'bottom'}
          })
    if DEBUG: xbmcgui.Dialog().textviewer('debug', unicode(listing))
    return plugin.create_listing(listing, category="World-art.ru - Каталог кино", content='movies',
           cache_to_disk=True, sort_methods=None, view_mode=plugin.get_setting('search_view'))


@plugin.action('worldart/search')
def search(params):
    query = params.query
    if not query:
        query = xbmcgui.Dialog().input(_T("Поиск"), type=xbmcgui.INPUT_ALPHANUM)
        if query == "":
                return
        addHistory('Worldart_'+params.mod, query)
    elif params.origquery and params.query:
         qlist = [params.origquery, query]
         index = xbmcgui.Dialog().select(heading=_T("Поиск"), list=qlist)
         if index == -1: return
         query = qlist[index]
    query = _de(query)
    query = query.encode('cp1251', 'xmlcharrefreplace')
#    if DEBUG: xbmcgui.Dialog().textviewer('debug', unicode( query ))
    html = GET('search.php', getp={'public_search': query, 'global_sector': params.mod})
    from bs4 import BeautifulSoup
    soup = BeautifulSoup(html, 'html.parser')
    if DEBUG: xbmcgui.Dialog().textviewer('debug', unicode( soup.prettify() ))
#    if DEBUG: open('/home/osmc/html.txt', 'w').write( soup.prettify() )
    rez = soup.find('td', 'line', border='1', cellpadding='0', width='1')
#    if DEBUG: xbmcgui.Dialog().textviewer('debug', unicode( rez ))
    listing = []
    show_rating_list = plugin.get_setting('show_rating_list_wa', True)
    if rez:
       for t in rez.findAll('tr'):
           info = {}
           ti = t.find('a', 'estimation')
           title = getAttr(ti)
           furl = chkUrl( getAttr(ti, 'href') )
           if title:
              info['title'] = title
              i = t.find('a')
              poster = None
              if i:
                img = getAttr( i.find('img'), 'src')
                img = chkUrl(img, params.url)
                if img: # полноразмерный постер:
                   poster = img.replace('/converted_images_','/').replace('/optimize_a/','/').replace('-optimize_a.','.').replace('-','/').replace('world/art', 'world-art')
              year = getAttr ( t.find('td', align='center', valign='top', width='40') )
              if year and year.isdigit(): info['year'] = year
              tye = t.findAll('font', size='3')
              if tye:
                 text_year = getAttr( tye[-1] )
              else:
                 text_year = None
              typ = None
              if text_year:
                 info['studio'] = text_year.split(',')[0].strip('(')
                 typ = text_year.split(',')[1].strip(') ')
              tis = t.findAll('font', size='1')
              if tis:
                 info['originaltitle'] = tis[0].text
                 info['plot'] = ''
                 for ti in tis:
                    info['plot'] += ti.text+'\n'
              query = title
              info['mediatype'] = "movie"
              if info.get('year'):
                 query_year = query+" ("+str(info['year'])+')'
              else:
                 query_year = None
              if show_rating_list:
                 label = makeLabel(title, info.get('rating'), info.get('year'), info.get('genre'), info.get('studio'), typ)
              else:
                 label = title+" "+text_year
              item = {
               'label': label,
               'url': plugin.get_url(action="worldart/view", url=furl),
               'art': {
                 'thumb':  poster,
                 'poster': poster,
                 'fanart': poster,
               },
               'info': {
                 'video': info,
               },
               'is_folder': True,
               'context_menu': [(
                _T("Поиск по названию"),
                "Container.Update(%s)" % plugin.get_url(action="search", mod="torrent", type='video', getinfo=True, qfilter=True, query=_en(title)),
                ),(
                "Поиск по названию без фильтра",
                "Container.Update(%s)" % plugin.get_url(action="search", mod="torrent", type='video', getinfo=True, query=_en(title)),
                )],
              }
              if query_year:
                 item['context_menu'].insert(0, (
                  _T("Поиск по названию и году"),
                  "Container.Update(%s)" % plugin.get_url(action="search", mod="torrent", type='video', getinfo=True, qfilter=True, query=_en(query_year)),
                 ))
                 item['context_menu'].insert(2, (
                  "Поиск по названию и году без фильтра",
                  "Container.Update(%s)" % plugin.get_url(action="search", mod="torrent", type='video', getinfo=True, query=_en(query_year)),
                 ))
              item["context_menu"].append((_T("Settings"), "RunPlugin(%s)" % plugin.get_url(action="settings", mod="read")))
              listing.append(item)
    else:
        meta = soup.find('meta')
#        if DEBUG: xbmcgui.Dialog().textviewer('debug', unicode( meta ))
        if meta:
            params.url = chkUrl( meta['content'].split(' url=')[1] )
            return view(params)
    return plugin.create_listing(listing, category="World-art.ru - Поиск", content='movies',
           cache_to_disk=True, sort_methods=None, view_mode=plugin.get_setting('search_view'))


@plugin.action('worldart/view')
def view(params):
    if DEBUG: xbmcgui.Dialog().textviewer('debug', unicode(params))
    html = GET(params.url)
    from bs4 import BeautifulSoup
    soup = BeautifulSoup(html, 'html.parser')
    if DEBUG: xbmcgui.Dialog().textviewer('debug', unicode( soup.prettify() ))
#    if DEBUG: open('/home/osmc/html.txt', 'w').write( soup.prettify() )
    show_rating_list = plugin.get_setting('show_rating_list_wa', True)
    td = soup.find('td', bgcolor='#ffffff', height='100%', valign='top')
    dv = td.find('div', 'comment_block')
    if DEBUG: xbmcgui.Dialog().textviewer('debug', unicode( dv ))
    img = getAttr( dv.find('img', border='1'), 'src')
    poster = chkUrl(img, params.url)
    info = {}
    title = getAttr( td.find('font', size='5') )
    info['title'] = title
    query = ""
    typ = ""
    text_year = ""
    reviews = td.findAll('td', 'review')
    if DEBUG: xbmcgui.Dialog().textviewer('debug', unicode( reviews ))
    key = load = False
    s = ''
    for tr in reviews:
       t = tr.text
       if t == u'Названия':
            key = 'originaltitle'
       elif t.startswith(u'Производство'):
            key = 'studio'
       elif t.startswith(u'Формат'):
            key = False
            load = True
       elif t.startswith(u'Хронометраж'):
            key = 'duration'
       elif t.startswith(u'Жанр'):
            key = 'genre'
       elif t.startswith(u'Первый показ') or t.startswith(u'Трансляция'):
            key = 'premiered'
       elif t.startswith(u'Бюджет'):
            s = t+" "
            key = 'tagline'
       elif t.startswith(u'Мировые сборы'):
            s = t+" "
            key = 'mpaa'
       elif t.startswith(u'Режиссёр'):
            key = 'director'
       elif t.startswith(u'Сценарий'):
            key = 'writer'
       elif t.startswith(u'В ролях'):
            key = 'cast'
       elif t.startswith(u'Средний балл'):
            key = 'rating'
       elif t.startswith(u'Проголосовало'):
            key = 'votes' if info.get('rating') else False
       elif key:
            if key == 'duration':
                r = re.compile('(\d+)').findall(t)
                if r:
                   info[key] = int(r[0])*60
            elif key in ('genre', 'cast', 'director', 'writer'):
                info[key] = t.split(',')
            elif key == 'rating':
                r = re.compile('([\d\.]+)').findall(t)
                if r:
                   info[key] = float(r[0])
            elif key == 'premiered':
                 r = re.compile('([12]\d\d\d.[\d\.]+)').findall(t)
                 if r:
                    info[key] = r[0]
                 r = re.compile('([12]\d\d\d)').search(t)
                 if r:
                      info['year'] = int(r.group(1))
                 text_year = t.strip()
            elif key == 'votes':
                 info[key] = t.split(' ')[0]
            else:
                info[key] = s+t
            key = False
            s = ''
       elif load:
            typ = t
            load = False
    pl = td.findNext('p', 'review', align='justify')
    if pl:
       info['plot'] = pl.text
    if show_rating_list:
       label = makeLabel(title, info.get('rating'), info.get('year'), info.get('genre'), info.get('studio'), typ)
    else:
       label = title+" "+text_year
    query = title
    info['mediatype'] = "movie"
    if info.get('year'):
        query_year = query+" ("+str(info['year'])+')'
        if u'сериал' not in typ:
           query = query_year
    else:
        query_year = None
    item = {
               'label': label,
               'url': plugin.get_url(action="search", mod="torrent", type='video', getinfo=True, qfilter=True, query=_en(query)),
               'art': {
                 'thumb':  poster,
                 'poster': poster,
                 'fanart': poster,
               },
               'info': {
                 'video': info,
               },
               'is_folder': True,
               'context_menu': [(
                _T("Поиск по названию"),
                "Container.Update(%s)" % plugin.get_url(action="search", mod="torrent", type='video', getinfo=True, qfilter=True, query=_en(title)),
                ),(
                "Поиск без фильтра",
                "Container.Update(%s)" % plugin.get_url(action="search", mod="torrent", type='video', getinfo=True, query=_en(query)),
                ),(
                "Поиск по названию без фильтра",
                "Container.Update(%s)" % plugin.get_url(action="search", mod="torrent", type='video', getinfo=True, query=_en(title)),
                )],
    }
    serial = False
    if query_year and u'сериал' in typ:
          serial = True
          item['context_menu'][0] = (
                _T("Поиск по названию и году"),
                "Container.Update(%s)" % plugin.get_url(action="search", mod="torrent", type='video', getinfo=True, qfilter=True, query=_en(query_year)),
          )
          item['context_menu'][2] = (
                "Поиск по названию и году без фильтра",
                "Container.Update(%s)" % plugin.get_url(action="search", mod="torrent", type='video', getinfo=True, query=_en(query_year)),
          )
    item["context_menu"].append(("%s TheMovieDB" % _T("Найти на"), "Container.Update(%s)" % plugin.get_url(action="search", mod="search", type='tvshow' if serial else 'movie', query=_en(title))))
    item["context_menu"].append((_T("Settings"), "RunPlugin(%s)" % plugin.get_url(action="settings", mod="read")))
    if DEBUG: xbmcgui.Dialog().textviewer('debug', unicode( item ))
    listing = [item]
    return plugin.create_listing(listing, category="World-art.ru - Сведения о кино", content='movies',
           cache_to_disk=True, sort_methods=None, view_mode=plugin.get_setting('search_view'))
