# -*- coding: utf-8 -*-
import os
import json
import socket
import threading
import base64

try:
     from config import TORRSERVED_HOST, PY2, TORRSERVED_AUTH
except ImportError:
     from .config import TORRSERVED_HOST, PY2, TORRSERVED_AUTH

if PY2:
       from urllib2 import HTTPError, URLError, HTTPRedirectHandler, Request, urlopen, HTTPHandler, build_opener
       from urllib import urlencode, quote, quote_plus
       from urlparse import parse_qsl
else:
       from urllib.parse import urlencode, quote, parse_qsl, quote_plus
       from urllib.error import HTTPError, URLError
       from urllib.request import HTTPRedirectHandler, Request, urlopen, HTTPHandler, build_opener

USER_AGENT = 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.8; rv:21.0) Gecko/20100101 Firefox/21.0'

class closing(object):
    def __init__(self, thing):
        self.thing = thing

    def __enter__(self):
        return self.thing

    def __exit__(self, *exc_info):
        self.thing.close()

    def __del__(self):
        self.thing.close()


class NoRedirectHandler(HTTPRedirectHandler):
    def http_error_302(self, req, fp, code, msg, headers):
        import urllib
        infourl = urllib.addinfourl(fp, headers, headers["Location"])
        infourl.status = code
        infourl.code = code
        return infourl

    http_error_300 = http_error_302
    http_error_301 = http_error_302
    http_error_303 = http_error_302
    http_error_307 = http_error_302


def client(url, post_data=None, get_data=None, raw=False, host=None, ljs=True, login=None, password=None, touch=False, uploadfile=None, err=False, resp=None, size=0):
    socket.setdefaulttimeout(45)
    url = quote(url, ':/?=%&+') # fixed code 7f-ff chars in url
    if get_data:
        url += '?' + urlencode(get_data)
    if post_data and raw:
        post_data = post_data
    elif uploadfile:
        post_data, content_type = encode_multipart_data(uploadfile, post_data)
    elif post_data:
        try:
            post_data = json.dumps(post_data)
            if not PY2: post_data = post_data.encode('utf8')
        except:
            post_data = {"": ""}
    if host:
        url = host + url
    elif touch:
        pass
    else:
        url = TORRSERVED_HOST+url
    req = Request(url, post_data)
    if uploadfile:
        req.add_header('Content-Type', content_type)
        req.add_header('Content-Length', len(post_data))
    else:
        req.add_header('Content-Type', 'application/json')
        req.add_header('Accept-Charset', 'utf-8')
    req.add_header('User-Agent', USER_AGENT)
    if not (login and password) and not host and TORRSERVED_AUTH:
        login = TORRSERVED_AUTH[0]
        password = TORRSERVED_AUTH[1]
    if login and password:
        if PY2:
           req.add_header('Authorization', 'Basic %s' % base64.encodestring(':'.join([login, password])).strip())
        else:
           req.add_header('Authorization', 'Basic %s' % base64.b64encode(b':'.join([login.encode('utf8'), password.encode('utf8')])).decode('ascii').strip())
    try:

        if touch:
            o = build_opener(MyHandler())
            return o.open(req)

        elif resp:
            if size > 0:
               req.add_header('Range', 'bytes=%d-' % int(size))
            return urlopen(req)

        with closing(urlopen(req)) as response:
            payload = response.read()

            try:
                if payload and ljs:
                    return json.loads(payload.decode('utf-8', 'replace'))
                else:
                    return payload
            except ValueError:
                return payload
    except HTTPError as e:
        print(url)
        print(e)
        errlines = e.readlines()
        print(errlines)
        print(e.code)
        print(e.reason)
        print(e.args)
        if e.code == 401:
            import xbmcaddon
            from utils import notify, plugin
            notify(xbmcaddon.Addon().getLocalizedString(30346))
            plugin.openSettings()
            if plugin.settingsChanged:
                from settings import container_refresh
                container_refresh()
        if err:
               rete = {'e.code':e.code, 'e.reason': e.reason, 'e.args': e.args, 'e':e}
               if errlines and len(errlines) > 0:
                  try:
                     rete.update(json.loads(errlines[0].decode('utf-8', 'replace')))
                  except:
                     rete['e.errlines'] = errlines
               return rete
        return None
    except URLError as e:
        print(url)
        print(e)
        print(e.args)
        print(e.reason)
        if err: return {'e.reason': e.reason, 'e.args': e.args, 'e':e}
        return None
    except Exception as e:
        print(e)
        if isinstance(e, MemoryError): raise
        if err: return {'e':e}
        return None

def encode_multipart_data(data, params=None):
    from io import BytesIO
    import binascii
    body = BytesIO()
    boundary = binascii.hexlify(os.urandom(16))

    if params:
        for k, v in params.items():
           if v:
               if isinstance(v, bool): v = str(int(v))
               if not PY2 and isinstance(v, str): v = v.encode('utf8')
               if not PY2 and isinstance(k, str): k = k.encode('utf8')
               body.write(b"--%s\r\n" % boundary)
               body.write(b"Content-Disposition: form-data; name=\"%s\"\r\n" % k)
               body.write(b"\r\n")
               body.write(v)
               body.write(b"\r\n")
    body.write(b"--%s\r\n" % boundary)
    body.write(b"Content-Disposition: form-data; name=\"file\"; filename=tclient.torrent\r\n")
    body.write(b"Content-Type: application/octet-stream\r\n")
    body.write(b"\r\n")
    body.write(data)
    body.write(b"\r\n")
    body.write(b"--%s--\r\n" % boundary)

    content_type = "multipart/form-data; boundary=%s" % boundary
    return body.getvalue(), content_type

class MyHandler(HTTPHandler):
    def http_response(self, req, response):
        return response


def touch_old(url):
    o = build_opener(MyHandler())
    t = threading.Thread(target=o.open, args=(url,))
    t.start()

def client_touch(url):
    return client(url, touch=True)

def touch(url):
    t = threading.Thread(target=client_touch, args=(url,))
    t.start()

def getTSVer():
    z = client('/echo', get_data={})
    if z is None:
          return
    if not PY2: z = z.decode('utf8')
    ver = tuple(str(z).split('.')[:2])
    if ver == ('1','1'):
          return 1
    elif ver == ('1','2') or ver[0] == 'MatriX':
          return 2
    else:
          return z


def getTSVer2():
    z = client('/echo', get_data={})
    if z is None:
          return None, None
    if not PY2: z = z.decode('utf8')
    ver = tuple(str(z).split('.')[:2])
    if ver == ('1','1'):
          if z.startswith('1.1.77_'):
                 sv = z.split('_')[1]
                 try: sv = int(sv)
                 except: sv = 0
                 return 1, sv
          return 1, 0
    elif ver == ('1','2') or ver[0] == 'MatriX':
          return 2, 0
    else:
          return z, 0


def Mto1(d):
    key = {'hash':'Hash', 'file_stats':'FileStats', 'path':'Path', 'id':'Id',
           'download_speed':'DownloadSpeed', 'preloaded_bytes':'PreloadedBytes',
           'preload_size':'PreloadSize', 'connected_seeders':'ConnectedSeeders',
           'active_peers':'ActivePeers', 'total_peers':'TotalPeers', 'length':'Length',
           'loaded_size':'LoadedSize', 'torrent_size':'TorrentSize', 'upload_speed':'UploadSpeed',
    }
    if d:
       for k in list(d):
            if k in key:
                   if isinstance(d[k], list):
                        for i in range(len(d[k])):
                            if isinstance(d[k][i], dict):
                                 for k2 in list(d[k][i]):
                                       if k2 in key:
                                           d[k][i][key[k2]] = d[k][i][k2]
                                           del d[k][i][k2]
                   d[key[k]] = d[k]
                   del d[k]
    return d


def userMD5(left=False, right=False):
    import hashlib
    if TORRSERVED_AUTH:
       if PY2: md5 = hashlib.md5(''.join(TORRSERVED_AUTH)).hexdigest()
       else: md5 = hashlib.md5(''.join(TORRSERVED_AUTH).encode('utf8')).hexdigest()
       if left: md5 = "/" + md5
       if right: md5 = md5 + "/"
       return md5
    else:
       return ''



def _T(s):
    return s

class StopDownloading(Exception):
    def __init__(self, value):
        self.value = value

    def __str__(self):
        return repr(self.value)


def downloadFile(url, name, i18n=_T):
    import time
    import tempfile
    import xbmcaddon
    import xbmcgui
    import xbmcvfs
    import xbmc
    dialog = xbmcgui.Dialog()
    timer = time.clock if PY2 else time.perf_counter

    def _pbhook(downloaded, filesize, url=None, dp=None, name='', start=0):
        try:
            percent = min(int((downloaded * 100) / filesize), 100)
            currently_downloaded = float(downloaded) / (1024 * 1024)
            kbps_speed = int(downloaded / (timer() - start) )
            if kbps_speed > 0:
                eta = (filesize - downloaded) / kbps_speed
            else:
                eta = 0
            kbps_speed = kbps_speed / 1024
            total = float(filesize) / (1024 * 1024)
            mbs = '%.02f MB of %.02f MB - %s%%' % (currently_downloaded, total, percent)
            e = 'Speed: %.02f Kb/s ' % kbps_speed
            e += 'ETA: %02d:%02d' % divmod(eta, 60)
            dp.update(percent, '{0}[CR]{1}[CR]{2}'.format(name[:60], mbs, e))
        except Exception as e:
            percent = 100
            dp.update(percent)
#            from errors import log
#            log(e)
        if dp.iscanceled():
            dp.close()
            raise StopDownloading('Stopped Downloading')

    def getResponse(url, headers2, size):
        if url.startswith('/'):
             return client(url, resp=True, size=size)
        else:
          try:
             if size > 0:
                size = int(size)
                headers2['Range'] = 'bytes=%d-' % size

             req = Request(url, headers=headers2)

             resp = urlopen(req, timeout=30)
             return resp
          except:
             return None

    def doDownload(url, dest, dp, name):
        headers = {}

        if '|' in url:
            url, uheaders = url.split('|')
            headers = dict(parse_qsl(uheaders))

        if 'User-Agent' not in list(headers.keys()):
            headers.update({'User-Agent': USER_AGENT})

        resp = getResponse(url, headers, 0)

        if not resp:
            dialog.ok(i18n("Скачивание"), '{0}[CR]{1}'.format(i18n("Ошибка скачки файла"), i18n('Нет данных от хоста')))
            print("Download: no response")
            return False
        try:
            content = int(resp.headers['Content-Length'])
        except:
            content = 0
        try:
            resumable = 'bytes' in resp.headers['Accept-Ranges'].lower()
        except:
            resumable = False
        if resumable:
            print("Download is resumable")

        if content < 1:
            dialog.ok(i18n("Скачивание"), '{0}[CR]{1}'.format(i18n("Неизвестный размер файла"), i18n("Скачивание невозможно")))
            print("Download: Unknown size")
            return False

        size = 8192
        mb = content / (1024 * 1024)

        if content < size:
            size = content

        total = 0
        errors = 0
        count = 0
        resume = 0
        sleep = 0

        print('{0} : {1}MB {2} '.format('file_size', mb, dest))
        f = xbmcvfs.File(dest, 'w')

        chunk = None
        chunks = []

        start = timer()

        while True:
            downloaded = total
            for c in chunks:
                downloaded += len(c)
            percent = min(100 * downloaded / content, 100)

            _pbhook(downloaded, content, url, dp, name, start)

            chunk = None
            error = False

            try:
                chunk = resp.read(size)
                if not chunk:
                    if percent < 99:
                        error = True
                    else:
                        while len(chunks) > 0:
                            c = chunks.pop(0)
                            f.write(c)
                            del c
                        f.close()
                        return True

            except Exception as e:
#                from errors import log
#                log(e)
                print(str(e))
                error = True
                sleep = 10
                errno = 0

                if hasattr(e, 'errno'):
                    errno = e.errno

                if errno == 10035:  # 'A non-blocking socket operation could not be completed immediately'
                    pass

                if errno == 10054:  # 'An existing connection was forcibly closed by the remote host'
                    errors = 10  # force resume
                    sleep = 30

                if errno == 11001:  # 'getaddrinfo failed'
                    errors = 10  # force resume
                    sleep = 30

            if chunk:
                errors = 0
                chunks.append(chunk)
                if len(chunks) > 5:
                    c = chunks.pop(0)
                    f.write(c)
                    total += len(c)
                    del c

            if error:
                errors += 1
                count += 1
                xbmc.sleep(sleep * 1000)

            if (resumable and errors > 0) or errors >= 10:
                if (not resumable and resume >= 50) or resume >= 500:
                    # Give up!
                    return False

                resume += 1
                errors = 0
                if resumable:
                    chunks = []
                    # create new response
                    resp = getResponse(url, headers, total)
                else:
                    # use existing response
                    pass

    def clean_filename(s):
        if not s:
            return ''
        badchars = '\\/:*?\"<>|\''
        for c in badchars:
            s = s.replace(c, '_')
        return s.strip()

    download_path = xbmcaddon.Addon().getSetting('download_path')
    if download_path == '':
        try:
            download_path = dialog.browse(0, i18n('Путь скачки'), "", "", False, False)
            xbmcaddon.Addon().setSetting(id='download_path', value=download_path)
            if not xbmcvfs.exists(download_path):
                xbmcvfs.mkdir(download_path)
        except:
            pass
    if download_path != '':
        dp = xbmcgui.DialogProgress()
#        name = re.sub(r'\[COLOR.+?\/COLOR\]', '', name).strip()
        dp.create(i18n("Скачивание"), name[:60])
        tmp_file = tempfile.mktemp(dir=download_path, suffix=".tmp")
        tmp_file = xbmc.makeLegalFilename(tmp_file) if PY2 else xbmcvfs.makeLegalFilename(tmp_file)
        try:
            downloaded = doDownload(url, tmp_file, dp, name)
            if downloaded:
                if PY2:
                    vidfile = xbmc.makeLegalFilename(download_path + clean_filename(name) )
                else:
                    vidfile = xbmcvfs.makeLegalFilename(download_path + clean_filename(name) )
                dp.close()
                try:
                    xbmcvfs.rename(tmp_file, vidfile)
                    return vidfile
                except:
                    return tmp_file
            else:
                raise StopDownloading('stop_download')
        except Exception as e:
            dp.close()
            while xbmcvfs.exists(tmp_file):
                try:
                    xbmcvfs.delete(tmp_file)
                    break
                except:
                    pass
            if str(e) != "'Stopped Downloading'":
               raise
               #from errors import log
               #log(e)

if __name__ == "__main__":
    print(encode_multipart_data(b'1234a', {"test":"test2"}))
    TORRSERVED_HOST='http://127.0.0.1:8091'
    print(client('/viewed', post_data={'action':'list', 'hash': ''}))
    hash = client('/torrents', post_data={'action':'list'})[2]['hash']
    print(client('/viewed', post_data={'action':'list', 'hash': hash}))
    print(client('/viewed', post_data={'action':'rem', 'hash': hash, 'file_index':0}))
    print(client('/viewed', post_data={'action':'list', 'hash': hash}))
    print(client('/torrents', post_data={'action':'get', 'hash': client('/torrents', post_data={'action':'list'})[2]['hash']}))

