# -*- coding: utf-8 -*-
import os
import sys
PY2 = sys.version_info.major == 2
import json
import time
if PY2:
       from HTMLParser import HTMLParser
       unescape = HTMLParser().unescape
else:
       from html import unescape
       unicode = str
       basestring = str
       long = int
       xrange = range
from copy import deepcopy

import xbmc
import xbmcgui
import xbmcplugin
from config import ADDON_PATH
from utils import plugin, _T, _en, _de, humanizeSize, notify, makeMovieItem, makeTvShowItem, get_label, checkHEVC, altTitle, checkHDR, getInfoAndItem, addHistory, showHistory, pNone
from tmdb.api import TMDB
import searcher

translate = _T
tmdb = TMDB()

VIEW_STUDIO = plugin.get_setting("view_studio", True)
STUDIOS = plugin.get_setting("studio_list", False).split("|")
HIDE_PHRASE = plugin.get_setting("hide_phrase", True)
PHRASES = plugin.get_setting("phrase_list", False).split("|")
LABELMASK = "%L" if plugin.get_setting("use_label_for_sort_kodi19", True) else "%T"

langD = (('ru', 'russians'), ('en', 'english speaking'), ('fr', 'french'),
         ('de', 'german'), ('es', 'spanish'), ('it', 'italian'), ('tr', 'turkish'), ('sv', 'swedish'),
         ('ko', 'korean'), ('ja', 'japanese'), ('hi', 'hindi')
)


def get_ipv4_dns_name(name):
    import socket
    return [i[4][0] for i in socket.getaddrinfo(name, 80) if i[0] is socket.AF_INET and i[1] is socket.SOCK_RAW]

def check_tmdb_api():
    try:
        resp = tmdb.trending()
        return bool(len(resp) > 3)
    except:
        return False

def first_search():
    fs = 3
    if plugin.get_setting('first_start', True) != fs:
        plugin.settingsInit()
        plugin.set_setting('first_start', fs)
        plugin.set_setting('block_tmdb', 'false')
        plugin.set_setting('block_image', 'false')
        plugin.set_setting('short_tmdb', 'false')
        if '127.0.0.1' in get_ipv4_dns_name('api.themoviedb.org'):
              plugin.set_setting('block_tmdb_dns', 'true')
        else:
              plugin.set_setting('block_tmdb_dns', 'false')
        altImage = False
        for i in xrange(10):
            if '127.0.0.1' in get_ipv4_dns_name('image.tmdb.org'):
                 altImage = True
                 break
            xbmc.sleep(60)
        if altImage:
              plugin.set_setting('alt_tmdb_image', 'true')
        else:
              plugin.set_setting('alt_tmdb_image', 'false')
        if plugin.settingsChanged:
              from settings import container_refresh
              container_refresh()
        return
    elif plugin.get_setting('second_start', True) != fs:
        if check_tmdb_api():
              plugin.set_setting('second_start', fs)
              return
        if xbmc.getCondVisibility("System.HasAddon(plugin.video.tam)") == 1:
              plugin.settingsInit()
              plugin.set_setting('block_tmdb', 'true')
              plugin.set_setting('block_image', 'true')
              plugin.set_setting('short_tmdb', 'true')
              xbmcgui.Dialog().textviewer('Разблокировка API и картинок themoviedb.org:', 'Завершена. Для ускорения работы включены [B]Короткие описания[/B].[CR]Убедитесь что в настройках дополнения TAM включен [B]Разблокировщик:[/B] в [B]proxy list[/B][CR][CR][COLOR pink]Внимание !!! При работе через прокси дополнения TAM возможны глюки и баги в получении данных...[/COLOR][CR][CR]Лучше использовать VPN и т.п. Либо используете DNS server 9.9.9.9')
              plugin.set_setting('second_start', fs)
              if plugin.settingsChanged:
                 from settings import container_refresh
                 container_refresh()
              return
        else:
              xbmcgui.Dialog().textviewer('Чтобы разблокировать каталог фильмов themoviedb.org необходимо:', 'Установить дополнение TAM и в его настройках рекомендуется выбрать [B]Разблокировщик:[/B] в [B]proxy list[/B]')
              return

def studio(s):
    slist = ""
    if VIEW_STUDIO:
        for l in STUDIOS:
            if l.strip() in s: slist += "[COLOR pink]" + l.strip() + "[/COLOR]|"
        if "|" in slist: slist = slist[:-1] + "/"
    return slist

def isHide(s):
    if HIDE_PHRASE:
        for p in PHRASES:
           if p in s: return True
    return False

def get_listing(params, type=None):
    listing = []
    if params == "search":
        year = time.strftime('%Y') #"2020"
        if type == "movie":
            first_search()
            listing.append({
                'label': "{0} {1}, {2} {3}".format(translate("Discover"), translate("Movies"), translate("Cartoons"), translate("per day")),
                'url': plugin.get_url(action='search', mod='trending', type='movie', wtime='day', page=1),
                'icon': os.path.join(ADDON_PATH, "resources", "img", "top.png"),
                'is_playable': False,
                'is_folder': True,
            })
            listing.append({
                'label': "{0} {1}, {2} {3}".format(translate("Discover"), translate("Movies"), translate("Cartoons"), translate("per week")),
                'url': plugin.get_url(action='search', mod='trending', type='movie', wtime='week', page=1),
                'icon': os.path.join(ADDON_PATH, "resources", "img", "top.png"),
                'is_playable': False,
                'is_folder': True,
            })
            listing.append({
                'label': "{0} {1}".format(translate("Discover"), translate("Movies")),
                'url': plugin.get_url(action='search', mod='discover', type='movie', page=1, ngenres='16'),
                'icon': os.path.join(ADDON_PATH, "resources", "img", "top.png"),
                'is_playable': False,
                'is_folder': True,
            })
            listing.append({
                'label': "{0} {1}".format(translate("Discover"), translate("Cartoons")),
                'url': plugin.get_url(action='search', mod='discover', type='movie', page=1, genres='16'),
                'icon': os.path.join(ADDON_PATH, "resources", "img", "top.png"),
                'is_playable': False,
                'is_folder': True,
            })
            listing.append({
                'label': "{0} {1} {2}".format(translate("Discover"), translate("Movies"), translate("by genre")),
                'url': plugin.get_url(action='search', mod='genre', type='movie', ngenres='16'),
                'icon': os.path.join(ADDON_PATH, "resources", "img", "top.png"),
                'is_playable': False,
                'is_folder': True,
            })
            listing.append({
                'label': "{0} {1} {2}".format(translate("Discover"), translate("Cartoons"), translate("by genre")),
                'url': plugin.get_url(action='search', mod='genre', type='movie', genres='16'),
                'icon': os.path.join(ADDON_PATH, "resources", "img", "top.png"),
                'is_playable': False,
                'is_folder': True,
            })
            listing.append({
                'label': "{0} {1} {2}".format(translate("Discover"), translate("Movies"), year),
                'url': plugin.get_url(action='search', mod='discover', type='movie', page=1, year=year, ngenres='16'),
                'icon': os.path.join(ADDON_PATH, "resources", "img", "top.png"),
                'is_playable': False,
                'is_folder': True,
            })
            listing.append({
                'label': "{0} {1} {2}".format(translate("Discover"), translate("Cartoons"), year),
                'url': plugin.get_url(action='search', mod='discover', type='movie', page=1, year=year, genres='16'),
                'icon': os.path.join(ADDON_PATH, "resources", "img", "top.png"),
                'is_playable': False,
                'is_folder': True,
            })
            listing.append({
                'label': "{0} {1} {3} {2}".format(translate("Discover"), translate("Movies"), year, translate("by genre")),
                'url': plugin.get_url(action='search', mod='genre', type='movie', year=year, ngenres='16'),
                'icon': os.path.join(ADDON_PATH, "resources", "img", "top.png"),
                'is_playable': False,
                'is_folder': True,
            })
            listing.append({
                'label': "{0} {1} {3} {2}".format(translate("Discover"), translate("Cartoons"), year, translate("by genre")),
                'url': plugin.get_url(action='search', mod='genre', type='movie', year=year, genres='16'),
                'icon': os.path.join(ADDON_PATH, "resources", "img", "top.png"),
                'is_playable': False,
                'is_folder': True,
            })
            listing.append({
                'label': "{0}, {1} {2}".format(translate("Movies"), translate("Cartoons"), translate("top rated")),
                'url': plugin.get_url(action='search', mod='toprated', type='movie', page=1),
                'icon': os.path.join(ADDON_PATH, "resources", "img", "top.png"),
                'is_playable': False,
                'is_folder': True,
            })
            for l, m in langD:
              if plugin.get_setting("d_"+l, True):
                listing.append({
                'label': "{0} {2} {1}".format(translate("Discover"), translate("Movies"), translate(m)),
                'url': plugin.get_url(action='search', mod='discover', type='movie', page=1, lang=l, ngenres='16'),
                'icon': os.path.join(ADDON_PATH, "resources", "img", "top.png"),
                'is_playable': False,
                'is_folder': True,
                })
                listing.append({
                'label': "{0} {2} {1}".format(translate("Discover"), translate("Cartoons"), translate(m)),
                'url': plugin.get_url(action='search', mod='discover', type='movie', page=1, lang=l, genres='16'),
                'icon': os.path.join(ADDON_PATH, "resources", "img", "top.png"),
                'is_playable': False,
                'is_folder': True,
                })
                listing.append({
                'label': "{0} {2} {1} {3}".format(translate("Discover"), translate("Movies"), translate(m), translate("by genre")),
                'url': plugin.get_url(action='search', mod='genre', type='movie', lang=l, ngenres='16'),
                'icon': os.path.join(ADDON_PATH, "resources", "img", "top.png"),
                'is_playable': False,
                'is_folder': True,
                })
                listing.append({
                'label': "{0} {2} {1} {3}".format(translate("Discover"), translate("Cartoons"), translate(m), translate("by genre")),
                'url': plugin.get_url(action='search', mod='genre', type='movie', lang=l, genres='16'),
                'icon': os.path.join(ADDON_PATH, "resources", "img", "top.png"),
                'is_playable': False,
                'is_folder': True,
                })
                listing.append({
                'label': "{0} {3} {1} {2}".format(translate("Discover"), translate("Movies"), year, translate(m)),
                'url': plugin.get_url(action='search', mod='discover', type='movie', page=1, year=year, lang=l, ngenres='16'),
                'icon': os.path.join(ADDON_PATH, "resources", "img", "top.png"),
                'is_playable': False,
                'is_folder': True,
                })
                listing.append({
                'label': "{0} {3} {1} {2}".format(translate("Discover"), translate("Cartoons"), year, translate(m)),
                'url': plugin.get_url(action='search', mod='discover', type='movie', page=1, year=year, lang=l, genres='16'),
                'icon': os.path.join(ADDON_PATH, "resources", "img", "top.png"),
                'is_playable': False,
                'is_folder': True,
                })
                listing.append({
                'label': "{0} {3} {1} {4} {2}".format(translate("Discover"), translate("Movies"), year, translate(m), translate("by genre")),
                'url': plugin.get_url(action='search', mod='genre', type='movie', year=year, lang=l, ngenres='16'),
                'icon': os.path.join(ADDON_PATH, "resources", "img", "top.png"),
                'is_playable': False,
                'is_folder': True,
                })
                listing.append({
                'label': "{0} {3} {1} {4} {2}".format(translate("Discover"), translate("Cartoons"), year, translate(m), translate("by genre")),
                'url': plugin.get_url(action='search', mod='genre', type='movie', year=year, lang=l, genres='16'),
                'icon': os.path.join(ADDON_PATH, "resources", "img", "top.png"),
                'is_playable': False,
                'is_folder': True,
                })
            listing.append({
                "label": translate("New Search"),
                'url': plugin.get_url(action='search', mod="search", type="movie"),
                'icon': os.path.join(ADDON_PATH, "resources", "img", "search.png"),
                "is_playable": False,
                'is_folder': True,
            })
        elif type == "tvshow":
            first_search()
            listing.append({
                'label': "{0} {1}, {2} {3}".format(translate("Discover"), translate("TV Shows"), translate("Animated series"), translate("per day")),
                'url': plugin.get_url(action='search', mod='trending', type='tvshow', wtime='day', page=1),
                'icon': os.path.join(ADDON_PATH, "resources", "img", "top.png"),
                'is_playable': False,
                'is_folder': True,
            })
            listing.append({
                'label': "{0} {1}, {2} {3}".format(translate("Discover"), translate("TV Shows"), translate("Animated series"), translate("per week")),
                'url': plugin.get_url(action='search', mod='trending', type='tvshow', wtime='week', page=1),
                'icon': os.path.join(ADDON_PATH, "resources", "img", "top.png"),
                'is_playable': False,
                'is_folder': True,
            })
            listing.append({
                'label': "{0} {1}".format(translate("Discover"), translate("TV Shows")),
                'url': plugin.get_url(action='search', mod='discover', type='tvshow', page=1, ngenres='16'),
                'icon': os.path.join(ADDON_PATH, "resources", "img", "top.png"),
                'is_playable': False,
                'is_folder': True,
            })
            listing.append({
                'label': "{0} {1}".format(translate("Discover"), translate("Animated series")),
                'url': plugin.get_url(action='search', mod='discover', type='tvshow', page=1, genres='16'),
                'icon': os.path.join(ADDON_PATH, "resources", "img", "top.png"),
                'is_playable': False,
                'is_folder': True,
            })
            listing.append({
                'label': "{0} {1} {2}".format(translate("Discover"), translate("TV Shows"), translate("by genre")),
                'url': plugin.get_url(action='search', mod='genre', type='tvshow', ngenres='16'),
                'icon': os.path.join(ADDON_PATH, "resources", "img", "top.png"),
                'is_playable': False,
                'is_folder': True,
            })
            listing.append({
                'label': "{0} {1} {2}".format(translate("Discover"), translate("Animated series"), translate("by genre")),
                'url': plugin.get_url(action='search', mod='genre', type='tvshow', genres='16'),
                'icon': os.path.join(ADDON_PATH, "resources", "img", "top.png"),
                'is_playable': False,
                'is_folder': True,
            })
            listing.append({
                'label': "{0} {1} {2}".format(translate("Discover"), translate("TV Shows"), year),
                'url': plugin.get_url(action='search', mod='discover', type='tvshow', page=1, year=year, ngenres='16'),
                'icon': os.path.join(ADDON_PATH, "resources", "img", "top.png"),
                'is_playable': False,
                'is_folder': True,
            })
            listing.append({
                'label': "{0} {1} {2}".format(translate("Discover"), translate("Animated series"), year),
                'url': plugin.get_url(action='search', mod='discover', type='tvshow', page=1, year=year, genres='16'),
                'icon': os.path.join(ADDON_PATH, "resources", "img", "top.png"),
                'is_playable': False,
                'is_folder': True,
            })
            listing.append({
                'label': "{0} {1} {3} {2}".format(translate("Discover"), translate("TV Shows"), year, translate("by genre")),
                'url': plugin.get_url(action='search', mod='genre', type='tvshow', year=year, ngenres='16'),
                'icon': os.path.join(ADDON_PATH, "resources", "img", "top.png"),
                'is_playable': False,
                'is_folder': True,
            })
            listing.append({
                'label': "{0} {1} {3} {2}".format(translate("Discover"), translate("Animated series"), year, translate("by genre")),
                'url': plugin.get_url(action='search', mod='genre', type='tvshow', year=year, genres='16'),
                'icon': os.path.join(ADDON_PATH, "resources", "img", "top.png"),
                'is_playable': False,
                'is_folder': True,
            })
            listing.append({
                'label': "{0}, {1} {2}".format(translate("TV Shows"), translate("Animated series"), translate("top rated")),
                'url': plugin.get_url(action='search', mod='toprated', type='tvshow', page=1),
                'icon': os.path.join(ADDON_PATH, "resources", "img", "top.png"),
                'is_playable': False,
                'is_folder': True,
            })
            for l, m in langD:
              if plugin.get_setting("d_"+l, True):
                listing.append({
                'label': "{0} {2} {1}".format(translate("Discover"), translate("TV Shows"), translate(m)),
                'url': plugin.get_url(action='search', mod='discover', type='tvshow', page=1, lang=l, ngenres='16'),
                'icon': os.path.join(ADDON_PATH, "resources", "img", "top.png"),
                'is_playable': False,
                'is_folder': True,
                })
                listing.append({
                'label': "{0} {2} {1}".format(translate("Discover"), translate("Animated series"), translate(m)),
                'url': plugin.get_url(action='search', mod='discover', type='tvshow', page=1, lang=l, genres='16'),
                'icon': os.path.join(ADDON_PATH, "resources", "img", "top.png"),
                'is_playable': False,
                'is_folder': True,
                })
                listing.append({
                'label': "{0} {2} {1} {3}".format(translate("Discover"), translate("TV Shows"), translate(m), translate("by genre")),
                'url': plugin.get_url(action='search', mod='genre', type='tvshow', lang=l, ngenres='16'),
                'icon': os.path.join(ADDON_PATH, "resources", "img", "top.png"),
                'is_playable': False,
                'is_folder': True,
                })
                listing.append({
                'label': "{0} {2} {1} {3}".format(translate("Discover"), translate("Animated series"), translate(m), translate("by genre")),
                'url': plugin.get_url(action='search', mod='genre', type='tvshow', lang=l, genres='16'),
                'icon': os.path.join(ADDON_PATH, "resources", "img", "top.png"),
                'is_playable': False,
                'is_folder': True,
                })
                listing.append({
                'label': "{0} {3} {1} {2}".format(translate("Discover"), translate("TV Shows"), year, translate(m)),
                'url': plugin.get_url(action='search', mod='discover', type='tvshow', page=1, year=year, lang=l, ngenres='16'),
                'icon': os.path.join(ADDON_PATH, "resources", "img", "top.png"),
                'is_playable': False,
                'is_folder': True,
                })
                listing.append({
                'label': "{0} {3} {1} {2}".format(translate("Discover"), translate("Animated series"), year, translate(m)),
                'url': plugin.get_url(action='search', mod='discover', type='tvshow', page=1, year=year, lang=l, genres='16'),
                'icon': os.path.join(ADDON_PATH, "resources", "img", "top.png"),
                'is_playable': False,
                'is_folder': True,
                })
                listing.append({
                'label': "{0} {3} {1} {4} {2}".format(translate("Discover"), translate("TV Shows"), year, translate(m), translate("by genre")),
                'url': plugin.get_url(action='search', mod='genre', type='tvshow', year=year, lang=l, ngenres='16'),
                'icon': os.path.join(ADDON_PATH, "resources", "img", "top.png"),
                'is_playable': False,
                'is_folder': True,
                })
                listing.append({
                'label': "{0} {3} {1} {4} {2}".format(translate("Discover"), translate("Animated series"), year, translate(m), translate("by genre")),
                'url': plugin.get_url(action='search', mod='discover', type='tvshow', year=year, lang=l, genres='16'),
                'icon': os.path.join(ADDON_PATH, "resources", "img", "top.png"),
                'is_playable': False,
                'is_folder': True,
                })
            listing.append({
                "label": translate("New Search"),
                'url': plugin.get_url(action='search', mod="search", type="tvshow"),
                'icon': os.path.join(ADDON_PATH, "resources", "img", "search.png"),
                "is_playable": False,
                'is_folder': True,
            })
        else:
            listing.append({
                "label": translate("Movies")+" - themoviedb",
                'url': plugin.get_url(action='search', mod="index", type="movie"),
                'icon': os.path.join(ADDON_PATH, "resources", "img", "movies.png"),
                "is_playable": False,
                'is_folder': True,
            })
            listing.append({
                "label": translate("TV Shows")+" - themoviedb",
                'url': plugin.get_url(action='search', mod="index", type="tvshow"),
                'icon': os.path.join(ADDON_PATH, "resources", "img", "tv.png"),
                "is_playable": False,
                'is_folder': True,
            })
            listing.append({
                "label": "Кино и сериалы - world-art.ru",
                'url': plugin.get_url(action='worldart/kino'),
                'icon': os.path.join(ADDON_PATH, "resources", "img", "kinoWA.png"),
                "is_playable": False,
                'is_folder': True,
            })
            listing.append({
                "label": "Подборки - numparser",
                'url': plugin.get_url(action='releases'),
                'icon': os.path.join(ADDON_PATH, "resources", "img", "num.png"),
                "is_playable": False,
                'is_folder': True,
            })
            listing.append({
                'label': _T("Торренты с фильтром"),
                'url': plugin.get_url(action='search', mod="torrent", qfilter=True),
                'icon': os.path.join(ADDON_PATH, "resources", "img", "search.png"),
                'is_playable': False,
                'is_folder': True,
            })
            listing.append({
                'label': translate("Torrents"),
                'url': plugin.get_url(action='search', mod="torrent"),
                'icon': os.path.join(ADDON_PATH, "resources", "img", "search.png"),
                'is_playable': False,
                'is_folder': True,
            })
            type='video'
        def get_url(k):
            return plugin.get_url(action='search', mod="search", type=type, query=k) if type != 'video' else plugin.get_url(action='search', mod="torrent", type=type, query=k)
        def get_url_filter(k):
            return plugin.get_url(action='search', mod="torrent", type=type, qfilter=True, query=k)
        listting = showHistory(listing, type, get_url, get_url_filter if type == 'video' else None)
    return listing


@plugin.action("search")
def search(params):
    poster = None
    info = None
    listing = []
    if params.mod == "index":
        return plugin.create_listing(get_listing("search", params.type))
    elif params.mod in ("discover","trending","toprated","genre"):
        result = {}
        page = params.page
        query = pNone(params.year)
        lang = pNone(params.lang)
        genres = pNone(params.genres)
        ngenres = pNone(params.ngenres)
        if params.mod == "genre":
            mtype = "tv" if params.type == "tvshow" else "movie"
            result = tmdb.genre(mtype)['genres']
            nid = str(ngenres).split(',') if ngenres else []
            ids = [ i['id'] for i in result if str(i['id']) not in nid]
            names = [ i['name'] for i in result if str(i['id']) not in nid]
            preselect = [ ids.index(int(i)) for i in str(genres).split(',') ] if genres else []
            indexes = plugin.multiselect(heading=translate("Select genre(s)"), options=names, preselect=preselect)
            if indexes is None: return
            genres = ''
            for i in indexes:
                genres += ',' + str(ids[i])
                genres = genres.strip(',')
            #xbmc.executebuiltin("Container.Update(%s)" % plugin.get_url(action='search', mod='discover', type=params.type, page=1, year=query, lang=lang, genres=genres, ngenres=ngenres)) #don't work on 18+ Kodi
            #return
            page = 1
            params.mod = 'discover'
        nextPage = int(page) + 1
        if params.type == "movie":
            if params.mod == "discover":
               result = tmdb.discover_movie(query, page, lang, genres, ngenres)
            elif params.mod == "toprated":
               result = tmdb.top_rated(mtype="movie", page=page)
            else:
               result = tmdb.trending(mtype="movie", wtime=params.wtime, page=page)
            movie_ids = result['results']
            for movie in movie_ids:
              if movie:
                item = makeMovieItem(movie)
                item.update({'url': plugin.get_url(action='search', mod="torrent", query=_en(movie['original_title'])+" "+str(movie['release_date'][:4]), type="movie", id=movie['id']),
                'context_menu': [( translate('Search title and year'),
                    'Container.Update(%s)' % plugin.get_url(action='search', mod="torrent", query=_en(movie['title'])+" "+str(movie['release_date'][:4]), type="movie", id=movie['id'], title='true') ),
                    ( translate('Search title'),
                    'Container.Update(%s)' % plugin.get_url(action='search', mod="torrent", query=_en(movie['title'])+" "+str(movie['release_date'][:4]), type="movie", id=movie['id'], title='onlyname'),
                    )],
                })
                if altTitle(movie):
                    item['context_menu'].append(( translate('Search alternative title'),
                    'Container.Update(%s)' % plugin.get_url(action='search', mod="torrent", query=_en(movie['title'])+" "+str(movie['release_date'][:4]), type="movie", id=movie['id'], title='alt'),
                    ))
                item['context_menu'].append((
                   "%s World-art.ru" % _T('Найти на'),
                   'Container.Update(%s)' % plugin.get_url(action='worldart/search', mod='cinema', query=_en(movie['title']), origquery=_en(movie['original_title'])), #TODO
                ))
                item['context_menu'].append((
                   translate('Settings'),
                   'RunPlugin({0})'.format(plugin.get_url(action='settings', mod='read')),
                ))
                listing.append(item)
        elif params.type == "tvshow":
            if params.mod == "discover":
               result = tmdb.discover_tvshow(query, page, lang, genres, ngenres)
            elif params.mod == "toprated":
               result = tmdb.top_rated(mtype="tv", page=page)
            else:
               result = tmdb.trending(mtype="tv", wtime=params.wtime, page=page)
            shows_ids = result['results']
            for show in shows_ids:
              if show:
                item = makeTvShowItem(show)
                item.update({'url': plugin.get_url(action='search', mod="torrent", query=_en(show['original_name']), type="tvshow", id=show['id']),
                'context_menu': [( translate('Search title'),
                    'Container.Update(%s)' % plugin.get_url(action='search', mod="torrent", query=_en(show['name']), type="tvshow", id=show['id'], title='true'),
                    )],
                })
                if altTitle(show):
                       item['context_menu'].append(( translate('Search alternative title'),
                       'Container.Update(%s)' % plugin.get_url(action='search', mod="torrent", query=_en(show['name']), type="tvshow", id=show['id'], title='alt'),
                       ))
                item['context_menu'].append((
                   "%s World-art.ru" % _T('Найти на'),
                   'Container.Update(%s)' % plugin.get_url(action='worldart/search', mod='cinema', query=_en(show['name']), origquery=_en(show['original_name'])), #TODO
                ))
                item['context_menu'].append((
                   translate('Settings'),
                   'RunPlugin({0})'.format(plugin.get_url(action='settings', mod='read')),
                ))
                listing.append(item)
        maxPage = int(result.get('total_pages', '1'))
        if nextPage <= maxPage:
           listing.append({
              'label': "{0} / ({1})".format(translate("Next page ({0})").format(nextPage), maxPage),
              'icon': os.path.join(ADDON_PATH, "resources", "img", "nextpage.png"),
              'url': plugin.get_url(action='search', mod=params.mod, type=params.type, page=nextPage, year=query, lang=lang, genres=genres, ngenres=ngenres, wtime=params.wtime)
           })
        return plugin.create_listing(listing, category="{0}: {1} {2}".format(translate("Discover"), params.type, query if query else ''), cache_to_disk=True, content="{0}s".format(params.type), view_mode=plugin.get_setting('search_view'))
    elif params.mod == "search":
        result = {}
        query = params.query
        dialog = xbmcgui.Dialog()
        if not query:
            query = dialog.input("Yohoho", type=xbmcgui.INPUT_ALPHANUM)
            if query == "":
                return
            addHistory(params.type, query)
        if params.type == "movie":
            result = tmdb.search_movies(query, params.page)
        else:
            result = tmdb.search_tv_shows(query, params.page)
        maxPage = int(result['total_pages'])
        nextPage = int(result['page'])+1
        movie_ids = result['results']
        for movie in movie_ids:
          if movie:
            if params.type == "movie":
                item = makeMovieItem(movie)
                item.update({'url': plugin.get_url(action='search', mod="torrent", query=_en(movie['original_title'])+" "+str(movie['release_date'][:4]), type="movie", id=movie['id']),
                'context_menu': [( translate('Search title and year'),
                    'Container.Update(%s)' % plugin.get_url(action='search', mod="torrent", query=_en(movie['title'])+" "+str(movie['release_date'][:4]), type="movie", id=movie['id'], title='true') ),
                    ( translate('Search title'),
                    'Container.Update(%s)' % plugin.get_url(action='search', mod="torrent", query=_en(movie['title'])+" "+str(movie['release_date'][:4]), type="movie", id=movie['id'], title='onlyname'),
                    )],
                })
                if altTitle(movie):
                    item['context_menu'].append(( translate('Search alternative title'),
                    'Container.Update(%s)' % plugin.get_url(action='search', mod="torrent", query=_en(movie['title'])+" "+str(movie['release_date'][:4]), type="movie", id=movie['id'], title='alt'),
                    ))
                item['context_menu'].append((
                   translate('Settings'),
                   'RunPlugin({0})'.format(plugin.get_url(action='settings', mod='read')),
                ))
                listing.append(item)
            elif params.type == "tvshow":
                    item = makeTvShowItem(movie)
                    item.update({
                        'url': plugin.get_url(action='search', mod="torrent", query=_en(movie['original_name']), type="tvshow", id=movie['id']),
                        'context_menu': [( translate('Search title'),
                            'Container.Update(%s)' % plugin.get_url(action='search', mod="torrent", query=_en(movie['name']), type="tvshow", id=movie['id'], title='true'),
                            )],
                    })
                    if altTitle(movie):
                       item['context_menu'].append(( translate('Search alternative title'),
                       'Container.Update(%s)' % plugin.get_url(action='search', mod="torrent", query=_en(movie['name']), type="tvshow", id=movie['id'], title='alt'),
                       ))
                    item['context_menu'].append((
                      translate('Settings'),
                     'RunPlugin({0})'.format(plugin.get_url(action='settings', mod='read')),
                    ))
                    listing.append(item)
        if nextPage <= maxPage:
           listing.append({
             'label': "{0} / ({1})".format(translate("Next page ({0})").format(nextPage), maxPage),
             'icon': os.path.join(ADDON_PATH, "resources", "img", "nextpage.png"),
             'url': plugin.get_url(action='search', mod='search', type=params.type, query=query, page=nextPage)
           })
        return plugin.create_listing(listing, category="{0}: {1}".format(translate("Search"), query), cache_to_disk=True, content="{0}s".format(params.type), view_mode=plugin.get_setting('search_view'))
    elif params.mod == "torrent":
        selSeason = params.selSeason
        ext_info = ""
        query = params.query
        if query is None:
            params.type = "video"
            dialog = xbmcgui.Dialog()
            query = dialog.input(translate("Torrents"), type=xbmcgui.INPUT_ALPHANUM)
            if query == "":
                return False
            addHistory(params.type, query)
        else:
            query = _de(query)
        if params.type == "tvshow" and params.title:
            ext_info = tmdb.get_tv_show(params.id)
            if selSeason is None: selSeason = ""
            query = _en(ext_info['name'])
            if params.title == 'alt':
                queryAlt = altTitle(ext_info, True, translate('Select alternative title'))
                if queryAlt: query = _en(queryAlt)
                else: return
        elif params.type == "tvshow" and selSeason is None:
            ext_info = tmdb.get_tv_show(params.id)
            listing = []
            for number in xrange(1, ext_info['number_of_seasons']+1, 1):
                item = makeTvShowItem(ext_info, "season", number)
                item.update({
                    'url': plugin.get_url(action='search', mod=params.mod, type=params.type, id=params.id, query=params.query, selSeason=number),
                    'context_menu': [( translate('Search title'),
                            'Container.Update(%s)' % plugin.get_url(action='search', mod=params.mod, type=params.type, id=params.id, query=_en(ext_info['name']), selSeason=number),
                            )],
                })
                if altTitle(ext_info):
                    item['context_menu'].append(( translate('Search alternative title'),
                       'Container.Update(%s)' % plugin.get_url(action='search', mod=params.mod, type=params.type, id=params.id, query=params.query, selSeason=number, title='alt'),
                    ))
                listing.append(item)
            return plugin.create_listing(listing, cache_to_disk=True, sort_methods={'sortMethod':xbmcplugin.SORT_METHOD_LABEL, 'labelMask':LABELMASK}, content="{0}s".format(params.type), view_mode=plugin.get_setting('search_view'))
        elif params.type == "tvshow" and selSeason:
            ext_info = tmdb.get_tv_show(params.id)
            selSeason = "{0:02d}".format(int(selSeason))
            query = params.query if params.query else _en(ext_info['original_name'])
        elif params.type == "movie":
            ext_info = tmdb.get_movie(params.id)
            if params.title:
                  query = "{0}".format(_en(ext_info['title']))
            else:
                  query = "{0}".format(_en(ext_info['original_title']))
            if params.title == "onlyname":
                  pass
            elif params.title == "alt":
                  queryAlt = altTitle(ext_info, True, translate('Select alternative title'))
                  if queryAlt: query = _en(queryAlt)
                  else: return
            else:
                  query = query + " ({0})".format(ext_info['release_date'][:4])
        if True:
            if params.qs and params.query: query = params.query
            if isinstance(query, unicode): query = _en(query)
            result = searcher.Query(query)
            if not result:
                notify(translate("Empty result")+" "+query)
                return False
        exclude_hevc = plugin.get_setting('exclude_hevc')
        exclude_hdr = plugin.get_setting('exclude_hdr')
        if params.type == 'movie' or params.qfilter:
            query_name = query_god1 = query_god2 = query_god3 = query
            if '(' in query:
               query_name = query.split('(')[0]
               query_god1 = query.replace('(','([').split('(')[1].strip(' )')
               query_god2 = query.replace('(','((').split('(', 1)[1].strip()
               query_god3 = query.replace('(','(/ ').split('(', 1)[1].strip().replace(')',' /')
        elif params.type == 'tvshow':
               numSeason = selSeason[1:] if selSeason and selSeason.startswith('0') else selSeason
               if params.qs and params.query and '(' in query: query = query.split('(')[0]
        k_item = k_info = None
        if params.getinfo:
            k_item, k_info = getInfoAndItem()
        out = []
        for ti in xrange(len(result)):
            t = result.pop(0)
            name = t['title']
            if exclude_hevc and checkHEVC(name): continue
            if exclude_hdr and checkHDR(name): continue
            if isHide(name): continue
            if params.type == 'movie' or params.qfilter:
                if name.find(query) == -1 and not (name.find(query_name)>-1 and (name.find(query_god1)>-1 or name.find(query_god2)>-1 or name.find(query_god3)>-1)):
                    continue
            elif params.type == 'tvshow':
                if query in name:
                    if name.find('S'+selSeason) > -1:
                       pass
                    elif name.find(selSeason+'x') > -1:
                       pass
                    elif name.find('['+selSeason+'-') > -1:
                       pass
                    elif params.qs:
                       pass
                    elif name.find('Сезон: '+numSeason) > -1:
                       fk = 'Сезон: '+numSeason
                       sk = name.find(fk)
                       if name[sk+len(fk):sk+len(fk)+1].isdigit() and numSeason: continue
                    elif name.find(numSeason+' сезон') > -1 or name.find('сезон '+numSeason) > -1:
                       fk = 'сезон '+numSeason
                       sk = name.find(fk)
                       if sk > -1 and name[sk+len(fk):sk+len(fk)+1].isdigit() and numSeason: continue
                    elif name.find(' S'+numSeason+' ') > -1:
                       pass
                    elif name.find(' S'+numSeason+'E') > -1:
                       pass
                    else: continue
                else: continue
            out.append(t)
        max_result_fix_memory = plugin.get_setting('max_result_fix_memory', True)
        enable_fix_memory = plugin.get_setting('fix_memory') and len(out) > max_result_fix_memory
        ms = plugin.get_mem_storage('i')
        if enable_fix_memory and params.getinfo:
             ms['info'] = k_info
        else:
             try: del ms['info']
             except: pass
        fix_memory = enable_fix_memory
        for ti in xrange(len(out)):
            t = out.pop(0)
            magnet    = t['url']
            name      = t['title']
            if '&' in name:
                 name = _en(unescape(_de(name)))
                 if '&#' in name: name = _en(unescape(_de(name)))
            ttn = tracker = t.get('ttn', '')
            pageurl = t.get('pageurl', '')
            scr = t.get('scr', '')
            stringSize= t['size']
            seeds = t['sids']
            name = name.replace("<b>", "").replace("</b>", "")
            item = dict()
            size = ""
            if stringSize is None:
                stringSize = '?'
                size = None
            elif not isinstance(stringSize, basestring):
                size = long(stringSize)
                stringSize = _en(humanizeSize(stringSize))
            elif stringSize == '?' or stringSize == '': size = None
            elif stringSize[stringSize.rfind(' ')+1:] in ['МБ', 'MB']:
                size = long(float(stringSize[:stringSize.rfind(' ')]) * float(2 << 19))
            else:
                size = long(float(stringSize[:stringSize.rfind(' ')]) * float(2 << 29))
            context_menu = [(
                translate("Add to DB"),
                "RunPlugin(%s)" % plugin.get_url(action="torrents", mod="add", magnet=magnet, pageurl=pageurl, ttn=ttn, scr=scr),
            )]
            context_menu.append((
                translate("Add to DB with title"),
                "RunPlugin(%s)" % plugin.get_url(action="torrents", mod="add", magnet=magnet, title=name, pageurl=pageurl, ttn=ttn, scr=scr),
            ))
            if params.type == 'movie':
                item = makeMovieItem(ext_info, False, size)
                poster = item['art'].get('poster')
                if fix_memory:
                    item['info']['video'] = {}
                    item['cast'] = []
                    context_menu = [(
                    translate("Add to DB"),
                    "RunPlugin(%s)" % plugin.get_url(action="torrents", mod="add", magnet=magnet, id=ext_info['id'], type='movie', size=size, pageurl=pageurl, ttn=ttn, scr=scr),
                    )]
                    context_menu.append((
                    translate("Add to DB with title"),
                    "RunPlugin(%s)" % plugin.get_url(action="torrents", mod="add", magnet=magnet, title=name, id=ext_info['id'], type='movie', size=size, pageurl=pageurl, ttn=ttn, scr=scr),
                    ))
                    context_menu.append((
                    translate('Save to Library'),
                    'RunPlugin({0})'.format(plugin.get_url(action='library', mod='save', id=ext_info['id'], year=ext_info['release_date'][:4], magnet=magnet, type='movie', size=size))
                    ))
                else:
                    info = json.dumps({'kodi':{'info': item['info']['video'], 'cast':item['cast']}, 'poster_path':item['art']['poster'], 'backdrop_path':item['art']['fanart'] })
                    context_menu = [(
                    translate("Add to DB"),
                    "RunPlugin(%s)" % plugin.get_url(action="torrents", mod="add", magnet=magnet, info=info, pageurl=pageurl, ttn=ttn, scr=scr),
                    )]
                    context_menu.append((
                    translate("Add to DB with title"),
                    "RunPlugin(%s)" % plugin.get_url(action="torrents", mod="add", magnet=magnet, info=info, title=name, pageurl=pageurl, ttn=ttn, scr=scr),
                    ))
                    context_menu.append((
                    translate('Save to Library'),
                    'RunPlugin({0})'.format(plugin.get_url(action='library', mod='save', id=ext_info['id'], year=ext_info['release_date'][:4], magnet=magnet, item=repr(item)))
                    ))
            elif params.type == 'tvshow':
                numEp = ""
                if query in name:
                    if name.find('S'+selSeason) > -1:
                       if '[S'+selSeason+']' in name:
                          numEp = "All"
                       elif '[S01-' in name:
                          numEp = "Multi"
                       else:
                          numEp = name[name.find('S'+selSeason)+4:name.find('S'+selSeason)+6]
                    elif name.find(selSeason+'x') > -1:
                       numEp = name[name.find(selSeason+'x')+6:name.find(selSeason+'x')+8]
                       if 'и' in numEp:
                          numEp = name[name.find(selSeason+'x')+3:name.find(selSeason+'x')+5]
                    elif name.find('['+selSeason+'-') > -1:
                       numEp = name[name.find('['+selSeason+'-')+4:name.find('['+selSeason+'-')+6]
                    elif params.qs:
                       numEp = 'Multi'
                    elif name.find('Сезон: '+numSeason) > -1:
                       fk = 'Сезон: '+numSeason
                       sk = name.find(fk)
                       if name[sk+len(fk):sk+len(fk)+1].isdigit() and numSeason: continue
                       numEp = 'Multi' #TODO
                    elif name.find(numSeason+' сезон') > -1 or name.find('сезон '+numSeason) > -1:
                       fk = 'сезон '+numSeason
                       sk = name.find(fk)
                       if sk > -1 and name[sk+len(fk):sk+len(fk)+1].isdigit() and numSeason: continue
                       numEp = 'Multi'
                    elif name.find(' S'+numSeason+' ') > -1 or name.find(' S'+numSeason+'E') > -1:
                       numEp = 'Multi'
                    else: continue
                else: continue
                if params.selSeason:
                     item = makeTvShowItem(ext_info, "season", int(params.selSeason), False, size)
                else:
                     item = makeTvShowItem(ext_info, "tvshow", None, True, size)
                poster = item['art'].get('poster')
                first_air_date = ext_info['first_air_date']
                year = first_air_date[:4] if first_air_date else ''
                if fix_memory:
                    item['info']['video'] = {}
                    item['cast'] = []
                    context_menu = [(
                    translate("Add to DB"),
                    "RunPlugin(%s)" % plugin.get_url(action="torrents", mod="add", magnet=magnet, id=ext_info['id'], type='tvshow', size=size, selSeason=selSeason, pageurl=pageurl, ttn=ttn, scr=scr),
                    )]
                    context_menu.append((
                    translate("Add to DB with title"),
                    "RunPlugin(%s)" % plugin.get_url(action="torrents", mod="add", magnet=magnet, title=name, id=ext_info['id'], type='tvshow', size=size, selSeason=selSeason, pageurl=pageurl, ttn=ttn, scr=scr),
                    ))
                    context_menu.append((
                    translate('Save to Library'),
                    'RunPlugin({0})'.format(plugin.get_url(action='library', mod='save', id=ext_info['id'], year=year, magnet=magnet, season=selSeason, numEp=numEp, type='tvshow', size=size))
                    ))
                else:
                    info = json.dumps({'kodi':{'info': item['info']['video'], 'cast':item['cast']}, 'poster_path':item['art']['poster'], 'backdrop_path':item['art']['fanart'] })
                    context_menu = [(
                    translate("Add to DB"),
                    "RunPlugin(%s)" % plugin.get_url(action="torrents", mod="add", magnet=magnet, info=info, pageurl=pageurl, ttn=ttn, scr=scr),
                    )]
                    context_menu.append((
                    translate("Add to DB with title"),
                    "RunPlugin(%s)" % plugin.get_url(action="torrents", mod="add", magnet=magnet, info=info, title=name, pageurl=pageurl, ttn=ttn, scr=scr),
                    ))
                    context_menu.append((
                    translate('Save to Library'),
                    'RunPlugin({0})'.format(plugin.get_url(action='library', mod='save', id=ext_info['id'], year=year, magnet=magnet, season=selSeason, numEp=numEp, item=repr(item)))
                    ))
            elif params.getinfo:
                item.update(deepcopy(k_item))
                poster = item.get('art', {}).get('poster')
                if fix_memory:
                    item['info']['video'] = {}
                else:
                    info = json.dumps(k_info)
                    context_menu = [(
                    translate("Add to DB"),
                    "RunPlugin(%s)" % plugin.get_url(action="torrents", mod="add", magnet=magnet, info=info, pageurl=pageurl, ttn=ttn, scr=scr),
                    )]
                    context_menu.append((
                    translate("Add to DB with title"),
                    "RunPlugin(%s)" % plugin.get_url(action="torrents", mod="add", magnet=magnet, info=info, title=name, pageurl=pageurl, ttn=ttn, scr=scr),
                    ))
            label = get_label(name)
            sort_title = name
            name = "[B]{1}[COLOR=FFFFFFFF]/{0}/[/COLOR][COLOR blue]{3}[/COLOR]/{4}[/B] {2}".format(stringSize.replace(' ', ''), label, name, seeds, studio(name))
            stream_info = ""
            if '2160' in label:
                stream_info = {'video': {'width': 3840, 'height': 2160}}
            elif '1080' in label:
                stream_info = {'video': {'width': 1920, 'height': 1080}}
            elif '720' in label:
                stream_info = {'video': {'width': 1280, 'height': 720}}
            else:
                stream_info = ""
            if fix_memory and params.type in ('movie', 'tvshow'):
                context_menu.append((
                translate('Open TAM'),
                'RunPlugin({0})'.format(plugin.get_url(action='tam', magnet=magnet, id=ext_info['id'], size=size, type=params.type, selSeason=params.selSeason)),
                ))
            else:
                context_menu.append((
                translate('Open TAM'),
                'RunPlugin({0})'.format(plugin.get_url(action='tam', magnet=magnet)),
                ))
            context_menu.append((
                translate('Settings'),
                'RunPlugin({0})'.format(plugin.get_url(action='settings', mod='read')),
            ))
            extparam = {}
            if fix_memory and params.type in ('movie', 'tvshow'):
                extparam['id'] = ext_info['id']
                extparam['type'] = params.type
                extparam['selSeason'] = params.selSeason
                extparam['size'] = size
            if poster: extparam['poster'] = poster
            if ttn: extparam['ttn'] = ttn
            if pageurl: extparam['pageurl'] = pageurl
            if scr: extparam['scr'] = scr
            item.update({
                "label": name,
                'url': plugin.get_url(action='gotInfo', magnet=magnet, **extparam),
                'is_folder': True,
                "context_menu": context_menu,
                'stream_info': stream_info,
            })
            if params.type not in ('movie', 'tvshow') and not item.get('info', {}).get('video'): item.update({'info':{'video':{}}})
            item['info']['video']['playcount'] = 0 if seeds == '?' or seeds == '-' or seeds == '' else int(seeds)
            if size: item['info']['video']['size'] = size
            item['info']['video']['sorttitle'] = sort_title
            if plugin.get_setting("fix_result_search_list_view", True):
                if params.type == 'movie': item['info']['video']['title'] = name
                elif params.type == 'tvshow': item['info']['video']['title'] = name
                elif item.get('info', {}).get('video', {}).get('title'): item['info']['video']['title'] = name
            listing.append(item)
        view_mode = plugin.get_setting('result_view')
        if params.usearch == 'True': view_mode = '0'
        if params.type == 'video': params.type = 'movie' # fix view from torrents search
        return plugin.create_listing(listing, category="{0}".format(translate("Search")), cache_to_disk=True, sort_methods=({'sortMethod':xbmcplugin.SORT_METHOD_LABEL, 'labelMask':LABELMASK}, {'sortMethod':xbmcplugin.SORT_METHOD_SIZE, 'labelMask':LABELMASK}, {'sortMethod':xbmcplugin.SORT_METHOD_PLAYCOUNT, 'labelMask':LABELMASK}, {'sortMethod':xbmcplugin.SORT_METHOD_VIDEO_SORT_TITLE, 'labelMask':LABELMASK}), content="{0}s".format(params.type), view_mode=view_mode)
    return False
