# -*- coding: utf-8 -*-
import os
import sys
PY2 = sys.version_info.major == 2
if PY2:
       pass
else:
       unicode = str
       basestring = str
       long = int
       xrange = range

import xbmc

from config import TORRSERVED_HOST, ADDON_PATH
from utils import plugin, _T, notify

translate = _T

@plugin.action()
def root(params):
    if plugin.get_setting('check_torrserver_main_menu', True):
        from client import client
        resp = client("/echo")
    else:
        resp = '?'
    if not resp:
        notify(translate("Server {0} is down").format(TORRSERVED_HOST))
        listing = get_listing("noindex")
        return plugin.create_listing(listing, category="N/A")
    else:
        if not PY2 and isinstance(resp, bytes): resp = resp.decode('utf8')
        cache_to_disk = False
        sort_methods = None
        listing = get_listing("index")
        if plugin.get_setting('torrent_list_in_root', True):
           from main import torrents
           params.mod = 'list'
           params.root = True
           listing_torrents, sort_methods = torrents(params)
           cache_to_disk = True
           listing.extend(listing_torrents)
        return plugin.create_listing(listing, category="v"+str(resp), content='videos', cache_to_disk=cache_to_disk, sort_methods=sort_methods)

def get_listing(params, type=None):
    listing = []
    if params == "index":
        listing.append({
            'label': translate("Torrents List"),
            'url': plugin.get_url(action='torrents', mod='list'),
            'icon': os.path.join(ADDON_PATH, "resources", "img", "list.png"),
            'is_folder': True,
            'properties': {'specialsort': 'top'}
        })
        listing.append({
            'label': _T("Категории"),
            'url': plugin.get_url(action='category'),
            'icon': os.path.join(ADDON_PATH, "resources", "img", "category.png"),
            'is_folder': True,
            'properties': {'specialsort': 'top'}
        })
        listing.append({
            'label': _T("Загружаемые сейчас торренты"),
            'url': plugin.get_url(action='dpcontrol_run'),
            'icon': os.path.join(ADDON_PATH, "resources", "img", "add.png"),
            'is_folder': False,
            'properties': {'specialsort': 'top'}
        })
        if plugin.get_setting("use_torlook", True):
          listing.append({
            'label': translate("Search"),
            'url': plugin.get_url(action="search", mod="index"),
            'icon': os.path.join(ADDON_PATH, "resources", "img", "search.png"),
            'is_folder': True,
            'properties': {'specialsort': 'top'}
          })
        listing.append({
            'label': translate('Open .torrent'),
            'url': plugin.get_url(action='openfile', mod='open'),
            'icon': os.path.join(ADDON_PATH, "resources", "img", "add.png"),
            'is_folder': True,
            'properties': {'specialsort': 'top'}
        })
        listing.append({
            'label': translate('Open all .torrent in dir'),
            'url': plugin.get_url(action='openfile', mod='opendir'),
            'icon': os.path.join(ADDON_PATH, "resources", "img", "add.png"),
            'is_folder': True,
            'properties': {'specialsort': 'top'}
        })
        listing.append({
            'label': translate("Settings"),
            'icon': os.path.join(ADDON_PATH, "resources", "img", "settings.png"),
            'url': plugin.get_url(action='settings', mod='read'),
            'is_folder': False,
            'properties': {'specialsort': 'top'}
        })
        if xbmc.getCondVisibility("System.HasAddon(script.extendedinfo)") == 1:
          listing.append({
            'label': _T("Запуск ExtendedInfo Script"),
            'icon': os.path.join(ADDON_PATH, "..", "script.extendedinfo", "resources", "icon.png"),
            'url': plugin.get_url(action='extendedinfo'),
            'is_folder': False,
            'properties': {'specialsort': 'top'}
          })
    elif params == "noindex":
        listing.append({
            'label': translate("Settings"),
            'icon': os.path.join(ADDON_PATH, "resources", "img", "settings.png"),
            'url': plugin.get_url(action='settings', mod='open'),
            'is_folder': False
        })
    return listing


@plugin.action('extendedinfo')
def extendedinfo(params):
    xbmc.executebuiltin("RunScript(script.extendedinfo,)")


# old api
@plugin.action('file')
def old_open_file(params):
    from openfile import open_file
    open_file(params)


def run():
    plugin.run()
