# -*- coding: utf-8 -*-
import os
import sys
PY2 = sys.version_info.major == 2
import json
import time
if PY2:
       import urllib
else:
       import urllib.parse as urllib
       unicode = str
       basestring = str
       long = int
       xrange = range
import re
import hashlib
import bencode
import threading

import xbmc
import xbmcgui
import xbmcplugin
import xbmcvfs
if PY2:
       from xbmc import translatePath
else:
       from xbmcvfs import translatePath
from client import client, touch, getTSVer, Mto1, getTSVer2, client_touch, userMD5, downloadFile
from config import TORRSERVED_HOST, ADDON_PATH
from utils import plugin, _T, _en, _de, _de3r, humanizeSize, notify, parseName, checkMime, makeMovieItem, makeTvShowItem, isPicture, pNone
from xplayer import xPlayer, abortRequested
from category import addCategory
from tmdb.api import TMDB

translate = _T
tmdb = TMDB()

LABELMASK = "%L" if plugin.get_setting("use_label_for_sort_kodi19", True) else "%T"
if LABELMASK == "%L" and plugin.get_setting("added_played_in_label", True):
    LABELMASK += "\n    {}: %a   {}: %p".format(_T('Добавлен'), _T('Воспроизведён'))


def del_mem_info():
    ms = plugin.get_mem_storage('i')
    try: del ms['info']
    except: pass


def torrentToMagnet(metainfo, url='bdecode error'):
    if not isinstance(metainfo, dict):
            try:
               metainfo = bencode.bdecode(metainfo)
            except Exception as e:
               from errors import log
               log(e, url)
               return
    infohash = hashlib.sha1(bencode.bencode(metainfo['info'])).hexdigest()
    name = metainfo['info'].get('name.utf-8', metainfo['info']['name'])
    tr = [metainfo.get('announce')]
    if 'announce-list' in metainfo:
          for t in metainfo['announce-list']:
                    if t: tr.append(t.pop())
    mparams = {
            'dn': name.encode('utf8') if isinstance(name, unicode) else name,
            'tr': tr,
    }
    return 'magnet:?xt=urn:btih:{0}&{1}'.format(str(infohash).upper(), urllib.urlencode(mparams, True))


def checkMagnet(magneturi):
    kinozalurl = plugin.get_setting("kinozal_url")
    if not magneturi:
            pass
    elif '://torlook.info/dl/' in magneturi:
            html = client('', host=magneturi, ljs=False)
            r = re.compile(r"(magnet:.+?)'>").search(_de3r(html))
            if not r:
                return
            magneturi = r.group(1)
    elif '://kinozal-me.appspot.com/magnet?' in magneturi or '://kinozal.tv/magnet?' in magneturi or (kinozalurl.strip() !="" and '://'+kinozalurl.strip()+'/magnet?' in magneturi):
            from searcher.scrapers.kinozal import get_magnet as kz_magnet
            magneturi = kz_magnet(magneturi.split('magnet?')[1])
            if not magneturi:
                      notify("Kinozal.tv: {}".format(_T("магнет не найден")))
                      return
            elif magneturi == 'login':
                      notify("Kinozal.tv: {}".format(_T("Нужен логин и пароль")))
                      return
            elif magneturi == 'user':
                      notify("Kinozal.tv: {}".format(_T("Неверный логин")))
                      return
            elif magneturi == 'pass':
                      notify("Kinozal.tv: {}".format(_T("Неверный пароль")))
                      return
    elif magneturi.startswith('rutracker:'):
            id = magneturi.split(':')[1]
            from drivers.rutracker import RuTracker
            r = RuTracker()
            magneturi = torrentToMagnet(r.download(id), magneturi)
    elif magneturi.startswith('http'):
            data = client('', host=magneturi, ljs=False, err=True)
            if isinstance(data, dict):
                if (data.get('e.code') == 302 or data.get('e.code') == 301) and data.get('e.reason', '').find("'magnet:?xt") > 0:
                     return data['e.reason'].split("'")[1]
                else:
                     from errors import log
                     log(data['e'], magneturi)
                     return
            try:
               metainfo = bencode.bdecode(data)
            except BaseException as e:
               from errors import log
               if _de3r(data).find('keywords" content="nnm-club,') != -1:
#                  file('/home/osmc/tserror.txt', 'wb').write(data.decode('cp1251').encode('utf8'))
                  r = re.compile(r'name="redirect"\s+value="([^"]+)"').search(_de3r(data))
                  if not r:
                     return
                  redirect = r.group(1)
                  r = re.compile(r'name="code"\s+value="([^"]+)"').search(_de3r(data))
                  code = r.group(1)
                  from searcher.scrapers.nnmclub import Tracker
                  login = plugin.get_setting("nnmclub_login")
                  password = plugin.get_setting("nnmclub_password")
                  if login == "" or password == "":
                      notify(_T("Нужен логин и пароль NNMClub для просмотра раздачи"))
                      return
                  data2 = Tracker().Login(login, password, redirect, code)
                  if _de3r(data2).find('keywords" content="nnm-club,') != -1:
                      notify(_T("Неверный логин и пароль от NNMClub"))
                      return
                  try:
                      metainfo = bencode.bdecode(data2)
                  except BaseException as e:
                      log(e, magneturi)
                      return
               else:
                  log(e, magneturi)
                  return
            magneturi = torrentToMagnet(metainfo)
    return magneturi

@plugin.action("torrents")
def torrents(params):
    listing = []
    view_mode = '0'
    content = 'videos'
    cache_to_disk = False
    sort_methods = None
    tsv, mod_tsv = getTSVer2()
    if params.watch == "select":
        slist = [_T("Unwatched"), _T('Watched')]
        watched = False
        if tsv == 2:
           viewlist = client("/viewed", post_data={'action':'list', 'hash':params.hash})
           if viewlist:
                for i in viewlist:
                   if int(params.id) == i['file_index']:
                         watched = True
                         break
           else: watched = False
        elif mod_tsv > 9:
           res = client("/torrent/viewed/get", post_data={'Hash': params.hash})
           if res is None: watched = None
           elif _de(params.name) in res: watched = True
        if watched is not None:
           if watched:
               slist[1] += ' [COLOR yellow]| torrserver |[/COLOR]'
           else:
               slist[0] += ' [COLOR yellow]| torrserver |[/COLOR]'
        if xbmc.getInfoLabel('ListItem.Overlay').find('Unwatched') == -1:
           slist[1] += ' [COLOR pink]| kodi |[/COLOR]'
        else:
           slist[0] += ' [COLOR pink]| kodi |[/COLOR]'
        index = xbmcgui.Dialog().select(_T("Выбрать отметку"), slist)
        if index == -1: return
        params.mod = 'watched' if index == 1 else "nowatched"
    if params.mod == "list":
        listing = makeFileListM(category=params.category) if tsv == 2 else makeFileList(category=params.category, mod_tsv=mod_tsv)
        sort_methods = ({'sortMethod':xbmcplugin.SORT_METHOD_UNSORTED, 'labelMask':LABELMASK},
                        {'sortMethod':xbmcplugin.SORT_METHOD_DATEADDED, 'labelMask':LABELMASK, 'label2Mask':'%a'},
                        {'sortMethod':xbmcplugin.SORT_METHOD_VIDEO_SORT_TITLE, 'labelMask':LABELMASK},
                        {'sortMethod':xbmcplugin.SORT_METHOD_SIZE, 'labelMask':LABELMASK},
                        {'sortMethod':xbmcplugin.SORT_METHOD_PLAYCOUNT, 'labelMask':LABELMASK},
                        {'sortMethod':xbmcplugin.SORT_METHOD_VIDEO_TITLE, 'labelMask':LABELMASK},
                        {'sortMethod':xbmcplugin.SORT_METHOD_LASTPLAYED, 'labelMask':LABELMASK,'label2Mask':'%p'})
        if params.root: return listing, sort_methods
    elif params.mod == "files":
        listing = makeFileList(params.hash, mod_tsv=mod_tsv)
        view_mode = plugin.get_setting('files_view')
        if params.hash:
              cache_to_disk = plugin.get_setting('list_files_cache', True)
              sort_methods = (xbmcplugin.SORT_METHOD_UNSORTED, xbmcplugin.SORT_METHOD_LABEL, xbmcplugin.SORT_METHOD_SIZE, xbmcplugin.SORT_METHOD_PLAYCOUNT)
        if plugin.get_setting('content_movies', True) and len(listing) > 0 and checkMime(listing[0]['label']) == 'video/*':
              content = 'movies'
              view_mode = plugin.get_setting('video_files_view')
    elif params.mod == "add":
        magneturi = checkMagnet(params.magnet)
        if params.id and params.type and not params.info:
             if params.type == "movie":  item = makeMovieItem(tmdb.get_movie(params.id), False, params.size)
             elif params.type == "tvshow":
                ext_info = tmdb.get_tv_show(params.id)
                if pNone(params.selSeason):
                     item = makeTvShowItem(ext_info, "season", int(params.selSeason), False, params.size)
                else:
                     item = makeTvShowItem(ext_info, "tvshow", None, True, params.size)
             params.info = json.dumps({'kodi':{'info': item['info']['video'], 'cast':item['cast']}, 'poster_path':item['art']['poster'], 'backdrop_path':item['art']['fanart'] })
        elif params.cast and not params.info:
             import totam
             info = totam.getKodiInfo()
             if 'kodi' in info:
                info['kodi']['cast'] = eval(params.cast)
             params.info = json.dumps(info)
        elif not params.info:
             ms = plugin.get_mem_storage('i')
             minfo = ms.get('info')
             if minfo: params.info = json.dumps(minfo)
        poster = None
        info = {}
        if params.info:
             info = json.loads(params.info)
             poster = info.get('poster_path')
        if pNone(params.pageurl):
             info['TSA'] = {'srcUrl': params.pageurl}
             info['pageurl'] = params.pageurl
        if pNone(params.ttn): info['ttn'] = params.ttn
        if pNone(params.scr): info['scr'] = params.scr
        if params.poster:
             poster = params.poster
             info['poster_path'] = params.poster
        if info: params.info = json.dumps(info)
        if tsv == 2:
             client("/torrents", post_data={"action":"add", "Link": magneturi, "poster":poster, "data": params.info, "title":params.title, "save_to_db":True})
        elif mod_tsv > 24:
             client("/torrent/addrun", post_data={"Link": magneturi, "Info": params.info, "Title": params.title})
        else:
             client("/torrent/add", post_data={"Link": magneturi, "Info": params.info, "Title": params.title})
        notify(translate("Saved!"))
        return
    elif params.mod == "delete":
        if tsv == 2:
             client("/torrents", post_data={"action":"rem", "Hash": params.hash})
        else:
             client("/torrent/rem", post_data={"Hash": params.hash})
        notify(translate("Deleted!"))
        if plugin.get_setting('save_lastplayed', True):
             extTorrents = ExtTorrents()
             extTorrents.remove(params.hash)
        if plugin.get_setting('refresh_after_delete', True): xbmc.executebuiltin("Container.Refresh")
        return
    elif params.mod == "watched" or params.mod == "viewed":
        if mod_tsv > 24 or tsv == 2:
              notify(translate("Watched")+"!")
              if params.mod == "viewed":
                if tsv == 2:
                   client("/viewed", post_data={"action":"set", "hash": params.hash, "file_index": 0})
                else:
                   client("/torrent/info/add", post_data={"Hash": params.hash, "Info": json.dumps({"Viewed":True})})
              else:
                if tsv == 2:
                   client("/viewed", post_data={"action":"set", "hash": params.hash, "file_index": int(params.id)})
                else:
                   client("/torrent/viewed/add", post_data={"Hash": params.hash, "Title": params.name})
              if params.mod == "watched" and plugin.get_setting('reset_resume_time', True):
                 if plugin.kodiMajor < '18':
                     from kodidb import resetResumeTime
                     resetResumeTime()
                 elif xbmc.getInfoLabel('ListItem.Overlay').find('Unwatched') == -1:
                     if plugin.kodiMajor == '18':
                        from kodidb import resetResumeTime
                        resetResumeTime()
                     else:
                        from kodirpc import resetResumeTime
                        resetResumeTime()
              if params.mod == "watched" and xbmc.getInfoLabel('ListItem.Overlay').find('Unwatched') != -1:
                xbmc.executebuiltin("Action(ToggleWatched)")
              else:
                xbmc.executebuiltin("Container.Refresh")
        return
    elif params.mod == "nowatched" or params.mod == "noviewed":
        if mod_tsv > 24 or tsv == 2:
              notify(translate("Unwatched")+"!")
              if params.mod == "noviewed":
                if tsv == 2:
                   client("/viewed", post_data={"action":"rem", "hash": params.hash, "file_index": 0})
                else:
                   client("/torrent/info/add", post_data={"Hash": params.hash, "Info": json.dumps({"Viewed":False})})
              else:
                if tsv == 2:
                   client("/viewed", post_data={"action":"rem", "hash": params.hash, "file_index": int(params.id)})
                else:
                   client("/torrent/viewed/drop", post_data={"Hash": params.hash, "Title": params.name})
              if params.mod == "nowatched" and plugin.get_setting('reset_resume_time', True):
                 if plugin.kodiMajor < '18':
                     from kodidb import resetResumeTime
                     resetResumeTime()
                 elif xbmc.getInfoLabel('ListItem.Overlay').find('Unwatched') != -1:
                     if plugin.kodiMajor == '18':
                        from kodidb import resetResumeTime
                        resetResumeTime()
                     else:
                        from kodirpc import resetResumeTime
                        resetResumeTime()
              if params.mod == "nowatched" and xbmc.getInfoLabel('ListItem.Overlay').find('Unwatched') == -1:
                xbmc.executebuiltin("Action(ToggleWatched)")
              else:
                xbmc.executebuiltin("Container.Refresh")
        return
    elif params.mod == "upload":
        if params.tfile:
           files = [params.tfile]
        elif params.files:
           import ast
           files = ast.literal_eval(params.files)
        for tfile in files:
           tf = xbmcvfs.File(tfile)
           if PY2: tdata = tf.read()
           else: tdata = bytes(tf.readBytes())
           tf.close()
           if tsv == 2:
              client("/torrent/upload", post_data={"save":True, 'title':params.title, 'poster':params.poster, 'data':params.info}, uploadfile=tdata)
           else:
              if mod_tsv > 28 and len(files) > 5:
                   client("/torrent/upload", post_data={"DropAfter":True}, uploadfile=tdata)
              else:
                   client("/torrent/upload", uploadfile=tdata)
        notify(translate("Saved!"))
        return
    elif params.mod == "removedead":
        if not xbmcgui.Dialog().yesno(_T('Удаление всех мёртвых торрентов из списка'), _T('Поиск мёртвых раздач будет идти в фоне.[CR]После завершения будет окно выбора.[CR]Это займёт некоторое время.[CR]Вы уверены?')):
               return
        to = plugin.get_setting("dead_timeout", True)
        if tsv == 2:
             res = Mto1(client("/torrents", post_data={"action":"list"}))
             to = 1+int(to/10)
        else:
             if mod_tsv > 9: res = client("/torrent/shortlist", post_data={"Request": 0, "Info":0})
             else: res = client("/torrent/list", post_data={"Request": 0})
        names = []
        hashs = []
        for t in res:
             name = t.get("title", t.get("Name", ""))
             hash = t["Hash"]
             link = t.get("Magnet", hash)
             stat = None
             for i in xrange(to):
                      if tsv == 2: stat = Mto1(client("/stream", get_data={"stat":"true", "link":link}))
                      else:
                            stat = client("/torrent/play", get_data={"stat":"true", "link":link})
                            if stat and stat.get('TorrentStatus') > 1 and len(stat.get('FileStats')) == 0:
                                 stat = client("/torrent/stat", post_data={"Hash": hash}) # если только картинки в раздаче
                      if stat is None or len(stat.get('FileStats', [])) == 0:
                            xbmc.sleep(1000)
                            continue
                      else: break
             if tsv == 2: client("/torrents", post_data={"action":"drop", "hash":hash})
             else: client("/torrent/drop", post_data={"Hash":hash})
             if stat and len(stat.get('FileStats', [])) > 0: continue
             names.append(name)
             hashs.append(hash)
        if hashs:
            preselect = [i for i in xrange(len(hashs))]
            indexes = xbmcgui.Dialog().multiselect(heading=_T("Выбрано мёртвых торрентов на удаление"), options=names, preselect=preselect)
            if indexes is None: return
            for i in indexes:
                  if tsv == 2: client("/torrents", post_data={"action":"rem", "hash":hashs[i]})
                  else: client("/torrent/rem", post_data={"Hash": hashs[i]})
            notify(translate("Deleted!"))
        else: notify(_T("Нет мёртвых раздач!"))
        return
    elif params.mod == "category":
        listing = addCategory(params.hash, params.category)
        if not listing: return
    elif params.mod == "removeallwatched":
        refresh = False
        if xbmcgui.Dialog().yesno(_T('Удаление всех отметок о просмотре файлов'), _T('Хотите удалить все отметки о просмотре файлов торрента?')):
            if tsv == 2: client("/viewed", post_data={"action":"rem", "hash":params.hash, "file_index": -1})
            else: client("/torrent/viewed/remove", post_data={"Hash": params.hash})
            refresh = True
            if plugin.kodiMajor < '18':
                  from kodidb import removeAllWatched
                  removeAllWatched()
        if xbmcgui.Dialog().yesno(_T('Удалить все отметки файлов'), _T('Хотите удалить все позиции воспроизведения файлов торрента?')):
               if plugin.kodiMajor > '18':
                    from kodirpc import resetAllResumeTime
                    resetAllResumeTime()
               else:
                    from kodidb import resetAllResumeTime
                    resetAllResumeTime()
               refresh = True
        if refresh: xbmc.executebuiltin("Container.Refresh")
        return
    elif params.mod == "addposter":
         poster_path = TORRSERVED_HOST + params.link
         if tsv == 2:
             tinfo = client("/torrents", post_data={"action":"get", "hash": params.hash})
             info = tinfo.get('data', '{}')
             info = json.loads(info)
             info['poster_path'] = poster_path
             info = json.dumps(info)
             client("/torrents", post_data={"action":"set", "hash": params.hash, "poster": poster_path, "data": info, "title":tinfo.get('title', ''), "save_to_db":True})
         elif mod_tsv > 24:
             client("/torrent/info/add", post_data={"Hash": params.hash, "Info": json.dumps({"poster_path":poster_path})})
         xbmc.executebuiltin("Container.Refresh")
         return
    del_mem_info()
    return plugin.create_listing(listing, content=content, category="Torrents", sort_methods=sort_methods, view_mode=view_mode, cache_to_disk=cache_to_disk)


def getHash(mag):
    if mag.startswith("magnet%"):
         mag = urllib.unquote_plus(mag)
    if mag.startswith("magnet:"):
         return mag[20:60]
    return mag

@plugin.action("play")
def play(params):
    xbmc.executebuiltin('Dialog.Close(busydialog)', wait=True)
    touch("{0}{1}".format(TORRSERVED_HOST, params.link))
    index = None
    if '/preload/' in params.link: hash = params.link[17:57]
    else: # add support torrserver 1.1.77
         hash = getHash(params.link.split('?link=')[1].split('&')[0])
         index = params.link.split('&file=')[1].split('&')[0]
         #xbmcgui.Dialog().ok('magnet', str(params.link.split('?link=')[1].split('&')[0]))
         if index == 'true':
              index = None
         else:
              index = int(index)
    subtitles = loadsubtitles(hash, params.link)
    touch("{0}{1}".format(TORRSERVED_HOST, params.link))
    success, index = makePreloadDialog(hash, index, link=params.link)
#    return plugin.resolve_url(TORRSERVED_HOST + params.link.replace('/preload/', '/view/'), succeeded=success)
    plugin.log_debug('Preload stoped')
#    xbmcgui.Dialog().ok('preload', str(success), str(index))
    if not success:
            client("/torrent/drop", post_data={"Hash": hash})
#            xbmcgui.Dialog().ok('cancel', str(success))
            xbmc.PlayList(xbmc.PLAYLIST_VIDEO).clear()
            xbmc.PlayList(xbmc.PLAYLIST_MUSIC).clear()
            return #plugin.resolve_url(succeeded=False)
    plugin.log_debug('Player starting')
    if isPicture(params.link.split('?')[0]):
         xbmc.executebuiltin('ShowPicture(%s)' % (TORRSERVED_HOST + params.link.replace('/preload/', '/view/')))
         if plugin.get_setting("picture_viewed", True):
           tinfo = client("/torrent/get", post_data={"Hash": hash})
           for f in tinfo['Files']:
               if checkMime(f['Name']) == "*/*" and not isPicture(f['Name']): continue
               viewed = f['Viewed']
               if not viewed: break
           if viewed and tinfo.get('Info', '').find('"Viewed":true') == -1:
               client("/torrent/info/add", post_data={"Hash": hash, "Info": json.dumps({'Viewed':True})})
         return #plugin.resolve_url(succeeded=False)
    mimeType = checkMime(params.link.split('?')[0])
    Player = xPlayer(hash=hash, index=index)
    plugin.log_debug('xPlayer on')
    item = xbmcgui.ListItem(path=TORRSERVED_HOST + params.link.replace('/preload/', '/view/'))
    plugin.log_debug('Created item')
    if subtitles:
            item.setSubtitles(subtitles)
    plugin.log_debug('Starting play')
    xbmcplugin.setResolvedUrl(int(sys.argv[1]), success, item)
    plugin.log_debug('Play started')
    if waitPlayer(hash, mimeType=mimeType, tsv=1): return plugin.resolve_url(succeeded=False)
    plugin.log_debug('Play stoped')
    Player = xbmc.Player
    plugin.log_debug('Play end')
#    client("/torrent/drop", post_data={"Hash": hash})
#    xbmcgui.Dialog().ok('abort', str(success))
    return True


def waitPlayer(hash, id=None, mimeType='video/*', tsv=1):
    i = 80
    while not xbmc.Player().isPlaying() and not abortRequested():
               xbmc.sleep(100)
               i -= 1
               if i < 0: break
    if not xbmc.Player().isPlaying() or i < 0: return True
    #
    if tsv == 2 and id:
        tinfo = client("/torrents", post_data={'action':'get', 'hash':hash})
        for f in tinfo['file_stats']:
            if f['id'] == int(id):
                  mimeType = checkMime(f['path'])
                  break
    #
    endtime = 0
    onesetviewed = True
    video_recent = plugin.get_setting('auto_category_recent', True)
    saveInRecent = False
    isPlayable = True
    if mimeType == 'video/*':
          saveCategory = _T('Еще смотрю видео')
    elif mimeType == 'audio/*':
          saveCategory = _T('Еще слушаю аудио')
    else: isPlayable = False
    #xbmcgui.Dialog().ok('play start', str(abortRequested()), str(xbmc.Player().isPlaying()) )
    # Wait until playing finished or abort requested
    while not abortRequested() and xbmc.Player().isPlaying():
        xbmc.sleep(500)
        if onesetviewed and xbmc.Player().isPlaying() and xbmc.Player().getTotalTime() > 0:
          if video_recent and isPlayable and xbmc.Player().getTime() > 2*60: saveInRecent = True
#          xbmcgui.Dialog().ok('play', str(xbmc.Player().getTime()), str(saveInRecent) )
          if endtime == 0:
                endtime = float(xbmc.Player().getTotalTime()) * 8 / 100
                if endtime < 5*60 and mimeType == 'video/*': endtime = 5*60
          if xbmc.Player().getTotalTime() - xbmc.Player().getTime() <= endtime:
             onesetviewed = False
#             xbmcgui.Dialog().ok('play', str(xbmc.Player().getTime()), str(xbmc.Player().getTotalTime()) )
             if tsv == 2:
                 tinfo = client("/torrents", post_data={'action':'get', 'hash':hash})
                 indexListViewed = []
                 viewlist = client("/viewed", post_data={'action':'list', 'hash':hash})
                 if viewlist:
                     for i in viewlist:
                        indexListViewed.append(i['file_index'])
                 if tinfo:
                   for f in tinfo['file_stats']:
                     if checkMime(f['path']) == "*/*": continue
                     viewed = True if f['id'] in indexListViewed else False
                     if not viewed: break
                   if viewed and 0 not in indexListViewed:
                     client("/viewed", post_data={"action":"set", "hash": hash, "file_index":0})
             else:
                 tinfo = client("/torrent/get", post_data={"Hash": hash})
                 if tinfo:
                   for f in tinfo['Files']:
                     if checkMime(f['Name']) == "*/*": continue
                     viewed = f['Viewed']
                     if not viewed: break
                   if viewed and tinfo.get('Info', '').find('"Viewed":true') == -1:
                     client("/torrent/info/add", post_data={"Hash": hash, "Info": json.dumps({'Viewed':True})})
             if video_recent and isPlayable and tinfo and viewed:
                    addCategory([hash], saveCategory)
                    saveInRecent = False
#    xbmcgui.Dialog().ok('play end', str(saveInRecent) )
    if saveInRecent: addCategory(hash, saveCategory)
    if plugin.get_setting('save_lastplayed', True):
          extTorrents = ExtTorrents()
          extTorrents.setLastPlayed(hash)


@plugin.action("play_now")
def play_now(params):
    if (plugin.get_setting("files_klay", True) and str(params.selFile) == '0' and not params.isGotinfo) or (params.isKlay and not params.isGotinfo):
         if params.isYatse or not params.isKlay: params['notKinfo'] = True
         params['isKlay'] = True
         listing = gotInfo(params)
         if len(listing) > 1:
            xbmc.executebuiltin('Dialog.Close(busydialog)', wait=True)
            if not xbmc.getCondVisibility('Window.IsMedia'):
                xbmc.executebuiltin('ActivateWindow(videos,%s,return)' % plugin.get_url(action="gotInfo", magnet=params.magnet, notKinfo=params.get('notKinfo', '')))
            else:
                xbmc.executebuiltin('Container.Update(%s)' % plugin.get_url(action="gotInfo", magnet=params.magnet, poster=params.poster if params.poster else '', info=params.info if params.info else '', notKinfo=params.get('notKinfo', '')))
            return
         elif len(listing) == 0:
           tsv = getTSVer()
           if tsv == 2:
              client("/torrents", post_data={"action":"drop", "Hash": getHash(params.magnet)})
           else:
              client("/torrent/drop", post_data={"Hash": getHash(params.magnet)})
           return
    tsv, mod_tsv = getTSVer2()
    if tsv == 2:
         playuri = TORRSERVED_HOST+"/stream?link="+params.magnet+"&index="+str(params.selFile)+"&preload"
         if params.poster: playuri += '&poster='+ urllib.quote_plus(params.poster)
         if params.title: playuri += '&title='+ urllib.quote_plus(params.title)
    else:
         auth = ""
         if mod_tsv > 27: auth = userMD5(True)
         playuri = TORRSERVED_HOST+"/torrent/play"+auth+"?link="+params.magnet+"&file="+str(params.selFile)
    xbmc.executebuiltin('Dialog.Close(busydialog)', wait=True)
    touch(playuri)
    subtitles = loadsubtitles(getHash(params.magnet), fileid = params.selFile)
    if plugin.get_setting("save_in_db", True): playuri +='&save=true'
    #touch(playuri)
    success, index = makePreloadDialog(getHash(params.magnet), params.selFile, playuri)
    if not success:
         if tsv == 2:
              client("/torrents", post_data={"action":"drop", "Hash": getHash(params.magnet)})
         else:
              client("/torrent/drop", post_data={"Hash": getHash(params.magnet)})
         xbmc.PlayList(xbmc.PLAYLIST_VIDEO).clear()
         xbmc.PlayList(xbmc.PLAYLIST_MUSIC).clear()
         return #plugin.resolve_url(succeeded=False)
    if params.link and isPicture(params.link.split('?')[0]):
         xbmc.executebuiltin('ShowPicture(%s)' % (TORRSERVED_HOST + params.link))
         if plugin.get_setting("picture_viewed", True):
           hash = getHash(params.magnet)
           if tsv == 2:
                 tinfo = client("/torrents", post_data={'action':'get', 'hash':hash})
                 indexListViewed = []
                 viewlist = client("/viewed", post_data={'action':'list', 'hash':hash})
                 if viewlist:
                     for i in viewlist:
                        indexListViewed.append(i['file_index'])
                 if tinfo:
                   for f in tinfo['file_stats']:
                     if checkMime(f['path']) == "*/*" and not isPicture(f['path']): continue
                     viewed = True if f['id'] in indexListViewed else False
                     if not viewed: break
                   if viewed and 0 not in indexListViewed:
                     client("/viewed", post_data={"action":"set", "hash": hash, "file_index":0})
           else:
             tinfo = client("/torrent/get", post_data={"Hash": hash})
             for f in tinfo['Files']:
               if checkMime(f['Name']) == "*/*" and not isPicture(f['Name']): continue
               viewed = f['Viewed']
               if not viewed: break
             if viewed and tinfo.get('Info', '').find('"Viewed":true') == -1:
               client("/torrent/info/add", post_data={"Hash": hash, "Info": json.dumps({'Viewed':True})})
         return #plugin.resolve_url(succeeded=False)
    Player = xPlayer(hash=getHash(params.magnet), index=index)
    if tsv == 2: playuri = playuri.replace('&preload','&play').replace('&save=true','') # fix bug MatriX db save
    item = xbmcgui.ListItem(path=playuri)
    if subtitles:
            item.setSubtitles(subtitles)
    if params.isYatse:
        item.setProperty('IsPlayable', 'true')
        item.setInfo(type='video', infoLabels={'title': listing[0]['label']}) #TODO:  Kodi 20.1+
        if 'action=play&' in listing[0]['url']: playuri = listing[0]['url']
        xbmc.Player().play(playuri, item)
    else:
        xbmcplugin.setResolvedUrl(int(sys.argv[1]), success, item)
    if waitPlayer(getHash(params.magnet), id=params.selFile, tsv=tsv): return plugin.resolve_url(succeeded=False)
    Player = xbmc.Player
#    if tsv == 2: client("/torrents", post_data={"action":"drop", "Hash": getHash(params.magnet)})
    return True


def viewedFile(fPath, tGetInfo):
    for i in tGetInfo['Files']:
        if i['Name'] == fPath: return i['Viewed']
    return None

def getPreloadUri(fPath, tGetInfo):
    for i in tGetInfo['Files']:
        if i['Name'] == fPath: return i['Preload']
    return None

@plugin.action("gotInfo")
def gotInfo(params):
    magneturi = checkMagnet(params.magnet)
    if not magneturi:
       return
    import totam
    kinfo = totam.getKodiInfo()
#    xbmcgui.Dialog().textviewer('abort', str(kinfo))
    ms = plugin.get_mem_storage('i')
    minfo = ms.get('info')
    if minfo:
        if params.isKlay:
             del ms['info']
        else:
             plugin.deepupdate(kinfo, minfo, True, True)
#    magneturi = 'magnet:?xt' # test error
    if params.notKinfo: kinfo = {}
    if params.id and params.type and not params.info:
        if params.type == "movie":  item = makeMovieItem(tmdb.get_movie(params.id), False, params.size)
        elif params.type == "tvshow":
              ext_info = tmdb.get_tv_show(params.id)
              if pNone(params.selSeason):
                     item = makeTvShowItem(ext_info, "season", int(params.selSeason), False, params.size)
              else:
                     item = makeTvShowItem(ext_info, "tvshow", None, True, params.size)
        tminfo = {'kodi':{'info': item['info']['video'], 'cast':item['cast']}, 'poster_path':item['art']['poster'], 'backdrop_path':item['art']['fanart'] }
        plugin.deepupdate(kinfo, tminfo, True)
        params.info = json.dumps(tminfo)
        if not params.poster: params.poster = item['art']['poster']
    xbmc.executebuiltin('Dialog.Close(busydialog)', wait=True)
    pDialog = xbmcgui.DialogProgress()
    pDialog.create("TorrServer", translate("Wait for info..."))
    tsv, mod_tsv = getTSVer2()
    cache_to_disk = True
    if tsv == 2 and plugin.get_setting("drop_torrent", True):
       client("/torrents", post_data={"action":"drop", "hash": getHash(magneturi)}) #fix drop cache after playback on MatriX.98
       cache_to_disk = False
    content = 'videos'
    content_movies = plugin.get_setting('content_movies', True)
    tInfo = []
    listing = []
    success = False
    i = 0
    onlymedia = plugin.get_setting("only_media", True)
    fix_getinfo = plugin.get_setting('fix_getinfo', True)
    if fix_getinfo and tsv == 2:
         global stat, _stop_stat_
         stat = None
         _stop_stat_ = True
         def stat_tsv2(uri, poster):
             global stat, _stop_stat_
             _stop_stat_ = False
             stat = Mto1(client("/stream", get_data={"stat": "true", "link": uri, "poster": poster}, err=True))
             _stop_stat_ = True
    while not pDialog.iscanceled():
        xbmc.sleep(500)
        if tsv == 2:
           if fix_getinfo:
#             xbmcgui.Dialog().textviewer('abort', str(_stop_stat_))
             if _stop_stat_:
                  t = threading.Thread(target=stat_tsv2, args=(magneturi, params.poster, ))
                  t.start()
           else:
             stat = Mto1(client("/stream", get_data={"stat": "true", "link": magneturi, "poster": params.poster}, err=True))
        else:
             stat = client("/torrent/play", get_data={"stat": "true", "link": magneturi}, err=True)
        if stat and stat.get('e'):
            xbmc.sleep(500)
            pDialog.update(i, '[CR]'.join([_T('Ошибка {}: {}').format(stat.get('e.code', ''), stat.get("e.reason","")),
                                           _en(stat.get('message', '')), _T('Ссылка: {}').format(magneturi) ]))
        elif stat is None or len(stat.get('FileStats', [])) == 0:
            xbmc.sleep(500)
            i += 1
            if not fix_getinfo and tsv == 2: i += 19
            m = 0
            s = 0
            if i > 59:
                m = int(i / 60)
            s = i - (m*60)
            if i > 100:
                if stat is None: stat = {}
                pDialog.update(i, '[CR]'.join([_T('Информация о [B]{2}[/B] не получена за {0:02d} : {1:02d} с.').format(m, s, _en(stat.get('Name', _T('раздаче')))), _T('Видимо это мертвая раздача и отсутствуют пиры.')]))
            else:
                pDialog.update(i, _T('Пытаемся подключиться к раздаче [B]{0:02d} : {1:02d}[/B] с.').format(m, s))
            continue
        elif stat and len(stat.get('FileStats', [])) > 0:
            if tsv == 2:
                 tInfo = stat
                 info = tInfo.get('data')
                 indexViewedList = []
                 viewlist = client("/viewed", post_data={'action':'list', 'hash':stat['Hash']})
                 if viewlist:
                    for i in viewlist:
                       indexViewedList.append(i['file_index'])
            else:
                 tInfo = client("/torrent/stat", post_data={"Hash": stat['Hash']})
                 tGetInfo = client("/torrent/get", post_data={"Hash": stat['Hash']})
                 info = tGetInfo.get('Info')
                 filesviewed = []
                 if mod_tsv > 9 and len(tGetInfo.get('Files', [])) == 1:
                     filesviewed = client("/torrent/viewed/get", post_data={"Hash": stat['Hash']})
            try:
                info = json.loads(info)
            except: info = {}
            plugin.deepupdate(info, kinfo, True, True)
            for file in tInfo['FileStats']:
                if file['Path'].find('/BDMV/') > 0:
                    if mod_tsv > 9:
                        if not filesviewed: filesviewed = client("/torrent/viewed/get", post_data={"Hash": stat['Hash']})
                    if long(file.get('Length', 0)) > 1073741824 or file['Path'].find('/BDMV/index.bdmv') > 0:
                        item = {
                            "label": file['Path'][file['Path'].rfind('/')+1:],
                            "url": plugin.get_url(action="play_now", magnet=magneturi, selFile=file['Id'], isGotinfo=True),
                            "is_playable": True,
                            "info": {"video": {
                                'size': file.get('Length'),
                            }}
                        }
                        if tsv == 1 and mod_tsv > 24:
#                             xbmcgui.Dialog().textviewer('abort', unicode(file['Path'])+'[CR]'+unicode(tGetInfo))
                             plink = getPreloadUri(file['Path'], tGetInfo)
                             if plink:
                                 item.update({"url": plugin.get_url(action="play", link=_en(plink)) })
                        elif tsv == 2:
                             item["url"] = plugin.get_url(action="play_now", magnet=stat['Hash'], selFile=file['Id'], isGotinfo=True)
                        item = makeInfoItem(item, info, stat, False, False, True)
                        if params.poster:
                             item.update({'art': {
                              'thumb': params.poster,
                              'poster': params.poster,
                             }})
                        elif kinfo.get('poster_path'):
                             item.update({'art': {
                              'thumb': kinfo['poster_path'],
                              'poster': kinfo['poster_path'],
                             }})
                        item["context_menu"] = [(translate("Settings"), "RunPlugin(%s)" % plugin.get_url(action="settings", mod="read"))]
                        item["context_menu"].insert(0, (
                             _T("Скачать"),
                             "RunPlugin(%s)" % plugin.get_url(action="download", magnet=magneturi, selFile=file['Id'], name=_en(file['Path'])),
                        ))
                        item["context_menu"].insert(0, (
                             _T("Удалить все отметки файлов"),
                             "RunPlugin(%s)" % plugin.get_url(action="torrents", mod="removeallwatched", hash=stat['Hash']),
                        ))
                        if tsv == 2:
                          Viewed = 1 if file['Id'] in indexViewedList else 0
                          item['info']['video']['playcount'] = Viewed
                          item["context_menu"].insert(0,(
                              _T("Выбрать отметку"),
                              "RunPlugin(%s)" % plugin.get_url(action="torrents", watch="select", hash=stat["Hash"], id=file['Id']),
                          ))
                          if Viewed == 0:
                            item["context_menu"].insert(0,(
                            translate("Watched"),
                            "RunPlugin(%s)" % plugin.get_url(action="torrents", mod="watched", hash=stat["Hash"], id=file['Id']),
                            ))
                          else:
                            item["context_menu"].insert(0,(
                            translate("Unwatched"),
                            "RunPlugin(%s)" % plugin.get_url(action="torrents", mod="nowatched", hash=stat["Hash"], id=file['Id']),
                            ))
                        else:
                          Viewed = viewedFile(file['Path'], tGetInfo)
                          if Viewed is None: Viewed = 1 if file['Path'] in filesviewed else 0
                          item['info']['video']['playcount'] = int(Viewed)
                          if mod_tsv > 24:
                            item["context_menu"].insert(0,(
                              _T("Выбрать отметку"),
                              "RunPlugin(%s)" % plugin.get_url(action="torrents", watch="select", hash=stat["Hash"], name=_en(file['Path'])),
                            ))
                            if Viewed == 0:
                              item["context_menu"].insert(0,(
                              translate("Watched"),
                              "RunPlugin(%s)" % plugin.get_url(action="torrents", mod="watched", hash=stat["Hash"], name=_en(file['Path'])),
                              ))
                            else:
                              item["context_menu"].insert(0,(
                              translate("Unwatched"),
                              "RunPlugin(%s)" % plugin.get_url(action="torrents", mod="nowatched", hash=stat["Hash"], name=_en(file['Path'])),
                              ))
                        listing.append(item)
                elif checkMime(file['Path']) in ("video/*", "audio/*") or (not onlymedia and isPicture(file['Path'])):
                    if content_movies and content == 'videos' and checkMime(file['Path']) == "video/*": content = 'movies'
                    item = {
                        "label": file['Path'][file['Path'].find('/')+1:],
                        "url": plugin.get_url(action="play_now", magnet=magneturi, selFile=file['Id'], isGotinfo=True),
                        "is_playable": True,
                        "info": {"video": {
#                            'title': file['Path'],
                            'size': file.get('Length'),
                        }}
                    }
                    item["context_menu"] = [(translate("Settings"), "RunPlugin(%s)" % plugin.get_url(action="settings", mod="read"))]
                    plink = None
                    if tsv == 1 and mod_tsv > 24:
                       plink = _en(getPreloadUri(file['Path'], tGetInfo))
                       if plink is None:
                           auth = ""
                           if mod_tsv > 27: auth = userMD5(True)
                           plink = "/torrent/play"+auth+"/"+urllib.quote(_en(file['Path']))+"?"+urllib.urlencode({"link":magneturi,"file":file['Id']})
                       if plink: item.update({"url": plugin.get_url(action="play", link=plink) })
                    elif tsv == 2:
                       item["url"] = plugin.get_url(action="play_now", magnet=stat['Hash'], selFile=file['Id'], isGotinfo=True)
                    if not onlymedia and isPicture(file['Path']):
                       if tsv == 2:
                          plink ='/stream/'+urllib.quote(_en(file['Path']))+'?'+urllib.urlencode({'link': stat['Hash'], 'index': file['Id']})+'&play'
                          item["url"] = plugin.get_url(action="play_now", magnet=stat['Hash'], selFile=file['Id'], isGotinfo=True, link=plink)
                       if plink:
                          item.update({"is_playable": False, "is_folder": False})
                          item["context_menu"].insert(0, (
                           _T("Просмотр всех картинок"),
                           "RunPlugin(%s)" % plugin.get_url(action="pictures", link=plink),
                          ))
                          item["context_menu"].insert(1, (
                            _T("Обновить картинку в кэше"),
                            "RunPlugin(%s)" % plugin.get_url(action="pictures", thumbcache="clear", link=plink),
                          ))
                          item["context_menu"].insert(2, (
                            _T("Сделать картинку постером"),
                            "RunPlugin(%s)" % plugin.get_url(action="torrents", mod="addposter", hash=stat['Hash'], link=plink),
                          ))
                    item = makeInfoItem(item, info, stat, False, False, True)
                    if info.get('poster_path'):
                             params.poster = info['poster_path']
                    if params.poster:
                             item.update({'art': {
                              'thumb': params.poster,
                              'poster': params.poster,
                             }})
                    elif kinfo.get('poster_path'):
                             item.update({'art': {
                              'thumb': kinfo['poster_path'],
                              'poster': kinfo['poster_path'],
                             }})
                    item["context_menu"].insert(0, (
                             _T("Скачать"),
                             "RunPlugin(%s)" % plugin.get_url(action="download", magnet=magneturi, selFile=file['Id'], name=_en(file['Path'])),
                    ))
                    item["context_menu"].insert(0, (
                             _T("Удалить все отметки файлов"),
                             "RunPlugin(%s)" % plugin.get_url(action="torrents", mod="removeallwatched", hash=stat['Hash']),
                    ))
                    if tsv == 2:
                         Viewed = 1 if file['Id'] in indexViewedList else 0
                         item['info']['video']['playcount'] = Viewed
                         item["context_menu"].insert(0,(
                              _T("Выбрать отметку"),
                              "RunPlugin(%s)" % plugin.get_url(action="torrents", watch="select", hash=stat["Hash"], id=file['Id']),
                         ))
                         if Viewed == 0:
                            item["context_menu"].insert(0,(
                            translate("Watched"),
                            "RunPlugin(%s)" % plugin.get_url(action="torrents", mod="watched", hash=stat["Hash"], id=file['Id']),
                            ))
                         else:
                            item["context_menu"].insert(0,(
                            translate("Unwatched"),
                            "RunPlugin(%s)" % plugin.get_url(action="torrents", mod="nowatched", hash=stat["Hash"], id=file['Id']),
                            ))
                    else:
                         Viewed = viewedFile(file['Path'], tGetInfo)
                         if Viewed is None: Viewed = 1 if file['Path'] in filesviewed else 0
                         item['info']['video']['playcount'] = int(Viewed)
                         if mod_tsv > 24:
                           item["context_menu"].insert(0,(
                              _T("Выбрать отметку"),
                              "RunPlugin(%s)" % plugin.get_url(action="torrents", watch="select", hash=stat["Hash"], name=_en(file['Path'])),
                           ))
                           if Viewed == 0:
                             item["context_menu"].insert(0,(
                             translate("Watched"),
                             "RunPlugin(%s)" % plugin.get_url(action="torrents", mod="watched", hash=stat["Hash"], name=_en(file['Path'])),
                             ))
                           else:
                             item["context_menu"].insert(0,(
                             translate("Unwatched"),
                             "RunPlugin(%s)" % plugin.get_url(action="torrents", mod="nowatched", hash=stat["Hash"], name=_en(file['Path'])),
                             ))
                    listing.append(item)
            pDialog.close()
            success = True
            info = kinfo
            if plugin.get_setting("save_in_db", True) and (params.info or kinfo or params.poster or params.title):
              if tsv == 2:
                 # for MatriX server
                 tinfo = client("/torrents", post_data={"action":"get", "hash": getHash(magneturi)})
                 #xbmcgui.Dialog().textviewer('tinfo', str(tinfo))
                 info = tinfo.get('data')
                 if info is None or info == '{}' or len(info) < 8:
                   try:
                     info = json.loads(info)
                   except: info = {}
                   if params.poster: info['poster_path'] = params.poster
                   if params.title: info['title'] = params.title
                   if params.info:
                     try:
                       info.update(json.loads(params.info))
                     except:
                       info.update(eval(params.info))
                   else:
                       info.update(kinfo)
                   if info:
                      client("/torrents", post_data={"action":"add", "link": magneturi, "data": json.dumps(info), 'poster': params.poster, 'title': params.title, "save_to_db":True})
                      if params.isKlay: xbmc.sleep(250)
              else: # 1.1.77_22 +
                info = client("/torrent/info/get", post_data={"Hash": getHash(magneturi)})
                if info is None or info == '{}' or len(info) < 18:
                   try:
                     info = json.loads(info)
                   except: info = {}
                   if params.poster: info['poster_path'] = params.poster
                   if params.title: info['title'] = params.title
                   if params.info:
                     try:
                       info.update(json.loads(params.info))
                     except:
                       info.update(eval(params.info))
                   else:
                       info.update(kinfo)
                   if info:
                      if mod_tsv > 24 and (not params.isKlay or (params.isKlay and len(listing) > 1)):
                           client("/torrent/addrun", post_data={"Link": magneturi, "Info": json.dumps(info)})
                      else:
                           client("/torrent/info/add", post_data={"Hash": getHash(magneturi), "Info": json.dumps(info)})
                      if params.isKlay: xbmc.sleep(250)
            if params.isKlay: return listing
            if plugin.get_setting("save_in_db", True) and not info and mod_tsv > 24 and tsv == 1:
                 client("/torrent/addrun", post_data={"Link": magneturi})
            return plugin.create_listing(listing, content=content, category="Файлы", succeeded=success, view_mode=plugin.get_setting('files_view'), cache_to_disk=cache_to_disk, sort_methods = (xbmcplugin.SORT_METHOD_UNSORTED, xbmcplugin.SORT_METHOD_LABEL, xbmcplugin.SORT_METHOD_SIZE, xbmcplugin.SORT_METHOD_PLAYCOUNT))
    pDialog.close()
    if params.isKlay: return listing
    return plugin.create_listing(listing, succeeded=success)


def makeFileListM(category=None):
    fix_view = plugin.get_setting("fix_torrent_list_view", True)
    both_fix_view = plugin.get_setting("both_titles_torrent_list_view", True)
    extTorrents = ExtTorrents()
    lastplayedHashs = extTorrents.getHashs() if plugin.get_setting('remove_unuse_lastplayed', True) else []
    categoryhashs = addCategory(category=category) if category else None
    ViewedHashsList = []
    viewlist = client("/viewed", post_data={'action':'list', 'hash':''})
    if viewlist:
       for i in viewlist:
           if i['file_index'] == 0 : ViewedHashsList.append(i['hash'])
    res = client("/torrents", post_data={'action':'list'})
    listing = []
    for t in res:
            if t['hash'] in lastplayedHashs: lastplayedHashs.remove(t['hash'])
            if category:
                if not categoryhashs: break
                elif t['hash'] not in categoryhashs: continue
                else: categoryhashs.remove(t['hash'])
            item = {
                "label": u"[{0}] {1}".format(humanizeSize(t.get('torrent_size', 0)), parseName(t['title'])),
                "url": plugin.get_url(action="gotInfo", magnet=t['hash'], poster=t.get('poster','')),
                "icon": os.path.join(ADDON_PATH, "resources", "img", "magnet.png"),
                "context_menu": [(
                    _T("Категория"),
                    "RunPlugin(%s)" % plugin.get_url(action="category", hash=t["hash"]),
                ), (
                    translate("Delete from DB"),
                    "RunPlugin(%s)" % plugin.get_url(action="torrents", mod="delete", hash=t["hash"]),
                ), (
                    _T("Удалить мёртвые раздачи из списка"),
                    "RunPlugin(%s)" % plugin.get_url(action="torrents", mod="removedead"),
                ), (
                    translate("Open TAM"),
                    "RunPlugin(%s)" % plugin.get_url(action="tam", hash=t["hash"], name=_en(t['title'])),
                )],
            }
            if t.get('data') != "{}":
#                file('/home/osmc/info/'+cleanname(parseName(t['Name']))+'.txt', 'wb').write(t['Info'].encode('utf8', 'replace'))
#                file('/home/osmc/info/'+t['Hash']+'.txt', 'wb').write(t['Info'].encode('utf8', 'replace'))
                try:
                    i = json.loads(t['data'])
                    item = makeInfoItem(item, i, t, fix_view, both_fix_view)
                except:
                    pass
            if t.get('poster') and t.get('poster') != 'None':
                    if 'art' not in item: item['art'] = {}
                    item['art']['thumb'] = t['poster']
                    item['art']['poster'] = t['poster']
            Viewed = True if t['hash'] in ViewedHashsList else False
            if Viewed:
                item["context_menu"].insert(0, (
                    translate("Unwatched"),
                    "RunPlugin(%s)" % plugin.get_url(action="torrents", mod="noviewed", hash=t["hash"]) ))
            else:
                item["context_menu"].insert(0, (
                    translate("Watched"),
                    "RunPlugin(%s)" % plugin.get_url(action="torrents", mod="viewed", hash=t["hash"]) ))
            if 'info' not in item and 'video' not in item.get('info', {}): item['info'] = {'video':{}}
            if 'size' not in item['info']['video']: item['info']['video']['size'] = t.get('torrent_size', 0)
            if 'sorttitle' not in item['info']['video']: item['info']['video']['sorttitle'] = t['title']
            if 'dateadded' not in item['info']['video']: item['info']['video']['dateadded'] = time.strftime("%Y-%m-%d %H:%M:%S", time.localtime(t['timestamp']))
            if 'playcount' not in item['info']['video']: item['info']['video']['playcount'] = int(Viewed)
            if 'lastplayed' not in item['info']['video']: item['info']['video']['lastplayed'] = extTorrents.getLastPlayed(t["hash"])
            item["context_menu"].append((translate("Settings"), "RunPlugin(%s)" % plugin.get_url(action="settings", mod="read")))
            listing.append(item)
    if categoryhashs: addCategory(categoryhashs, category)
    if lastplayedHashs: extTorrents.removeList(lastplayedHashs)
    return listing


def makeFileList(hash=None, category=None, mod_tsv=0):
    request = int(plugin.get_setting("without_info", True))
    onlymedia = plugin.get_setting("only_media", True)
    fix_view = plugin.get_setting("fix_torrent_list_view", True)
    both_fix_view = plugin.get_setting("both_titles_torrent_list_view", True)
    listing = []
    extTorrents = ExtTorrents()
    lastplayedHashs = extTorrents.getHashs() if plugin.get_setting('remove_unuse_lastplayed', True) else []
    categoryhashs = addCategory(category=category) if category else None
    if hash:
            t = client("/torrent/get", post_data={"Hash": hash})
            if t is None: return listing
            content_movies = plugin.get_setting('content_movies', True)
            files = t['Files']
            for fi in xrange(len(files)):
                f =  files.pop(0)
                mime = checkMime(f['Name'])
                if onlymedia and mime == "*/*": continue
                item = {
                    "label": parseName(f['Name'][f['Name'].find('/')+1:]),
                    "url": plugin.get_url(action="play", link=_en(f['Preload'])),
                    "is_playable": True,
                    "info": {"video": {
#                        'title': f['Name'],
                        'size': f['Size'],
                        'playcount': int(f['Viewed'])
                    }}
                }
                if int(f['Viewed']) == 0:
                  item["context_menu"] = [(
                    translate("Watched"),
                    "RunPlugin(%s)" % plugin.get_url(action="torrents", mod="watched", hash=t["Hash"], name=_en(f['Name'])),
                  )]
                else:
                  item["context_menu"] = [(
                    translate("Unwatched"),
                    "RunPlugin(%s)" % plugin.get_url(action="torrents", mod="nowatched", hash=t["Hash"], name=_en(f['Name'])),
                  )]
                item["context_menu"].append((
                    _T("Выбрать отметку"),
                    "RunPlugin(%s)" % plugin.get_url(action="torrents", watch="select", hash=hash, name=_en(f['Name'])),
                ))
                item["context_menu"].append((
                    _T("Удалить все отметки файлов"),
                    "RunPlugin(%s)" % plugin.get_url(action="torrents", mod="removeallwatched", hash=hash),
                ))
                item["context_menu"].append((
                    _T("Скачать"),
                    "RunPlugin(%s)" % plugin.get_url(action="download", hash=hash, link=_en(f['Preload']), name=_en(f['Name'])),
                ))
                if not onlymedia and isPicture(f['Name']):
                    item.update({"is_playable": False, "is_folder": False})
                    item["context_menu"].append((
                    _T("Просмотр всех картинок"),
                    "RunPlugin(%s)" % plugin.get_url(action="pictures", hash=hash, link=_en(f['Preload']), name=_en(f['Name'])),
                    ))
                    item["context_menu"].append((
                    _T("Обновить картинку в кэше"),
                    "RunPlugin(%s)" % plugin.get_url(action="pictures", thumbcache="clear", hash=hash, link=_en(f['Preload']), name=_en(f['Name'])),
                    ))
                    item["context_menu"].append((
                    _T("Сделать картинку постером"),
                    "RunPlugin(%s)" % plugin.get_url(action="torrents", mod="addposter", hash=hash, link=_en(f['Preload']), name=_en(f['Name'])),
                    ))
                item["context_menu"].append((translate("Settings"), "RunPlugin(%s)" % plugin.get_url(action="settings", mod="read")))
                if content_movies and mime == "video/*":
                    item['info']['video']['mediatype'] = "movie"
                if t['Info'] != "{}":
                    try:
                      i = json.loads(t['Info'])
                      item = makeInfoItem(item, i, t, fix_view, both_fix_view, True)
                    except:
                        pass
                listing.append(item)
            return listing
    if mod_tsv > 9:
         response = client("/torrent/shortlist", post_data={"Request": request, "Info": 1})
    else:
         response = client("/torrent/list", post_data={"Request": request})
    for ti in xrange(len(response)):
            t = response.pop(0)
            if t['Hash'] in lastplayedHashs: lastplayedHashs.remove(t['Hash'])
            if category:
                if not categoryhashs: break
                elif t['Hash'] not in categoryhashs: continue
                else: categoryhashs.remove(t['Hash'])
            item = {
                "label": u"[{0}] {1}".format(humanizeSize(t['Length']), parseName(t['Name'])),
                "url": plugin.get_url(action="torrents", mod="files", hash=t['Hash']),
                "icon": os.path.join(ADDON_PATH, "resources", "img", "magnet.png"),
                "context_menu": [(
                    _T("Категория"),
                    "RunPlugin(%s)" % plugin.get_url(action="category", hash=t["Hash"]),
                ), (
                    translate("Delete from DB"),
                    "RunPlugin(%s)" % plugin.get_url(action="torrents", mod="delete", hash=t["Hash"]),
                ), (
                    _T("Удалить мёртвые раздачи из списка"),
                    "RunPlugin(%s)" % plugin.get_url(action="torrents", mod="removedead"),
                ), (
                    translate("Open TAM"),
                    "RunPlugin(%s)" % plugin.get_url(action="tam", hash=t["Hash"], name=_en(t['Name'])),
                ), (
                    "{0} {1}".format(translate("Open TAM"), translate("with trackers")),
                    "RunPlugin(%s)" % plugin.get_url(action="tam", magnet=t["Magnet"]),
                )],
            }
            Viewed = False
            if t['Info'] != "{}":
#                file('/home/osmc/info/'+cleanname(parseName(t['Name']))+'.txt', 'wb').write(t['Info'].encode('utf8', 'replace'))
#                file('/home/osmc/info/'+t['Hash']+'.txt', 'wb').write(t['Info'].encode('utf8', 'replace'))
                try:
                    i = json.loads(t['Info'])
                    Viewed = i.get('Viewed', False)
                    item = makeInfoItem(item, i, t, fix_view, both_fix_view)
                except:
                    pass
            if Viewed:
                item["context_menu"].insert(0, (
                    translate("Unwatched"),
                    "RunPlugin(%s)" % plugin.get_url(action="torrents", mod="noviewed", hash=t["Hash"]) ))
            else:
                item["context_menu"].insert(0, (
                    translate("Watched"),
                    "RunPlugin(%s)" % plugin.get_url(action="torrents", mod="viewed", hash=t["Hash"]) ))
            if 'info' not in item and 'video' not in item.get('info', {}): item['info'] = {'video':{}}
            if 'size' not in item['info']['video']: item['info']['video']['size'] = t['Length']
            if 'sorttitle' not in item['info']['video']: item['info']['video']['sorttitle'] = t['Name']
            if 'dateadded' not in item['info']['video']: item['info']['video']['dateadded'] = time.strftime("%Y-%m-%d %H:%M:%S", time.localtime(t['AddTime']))
            if 'playcount' not in item['info']['video']: item['info']['video']['playcount'] = int(Viewed)
            if 'lastplayed' not in item['info']['video']: item['info']['video']['lastplayed'] = extTorrents.getLastPlayed(t["Hash"])
            item["context_menu"].append((translate("Settings"), "RunPlugin(%s)" % plugin.get_url(action="settings", mod="read")))
            listing.append(item)
    if categoryhashs: addCategory(categoryhashs, category)
    if lastplayedHashs: extTorrents.removeList(lastplayedHashs)
    return listing


def makeInfoItem(item, i, t, fix_view, both_fix_view, removeTitle=False):
                    if removeTitle:
                       previnfo = dict(item['info']['video'])
                    if 'poster_path' in i:
                       item.update({'art': {
                          'thumb': i.get('poster_path'),
                          'poster': i.get('poster_path'),
                       }})
                    if 'backdrop_path' in i:
                       item['art']['fanart'] = i.get('backdrop_path')
                    if 'title' in i:
                       item['info'] = { 'video': {'title': i['title']} }
                    if 'overview' in i:
                       item['info']['video']['plot'] = i.get('overview', '')
                    if 'year' in i:
                       item['info']['video']['year'] = int(i.get('year'))
                    if 'genres' in i:
                       genres = []
                       for g in i['genres']:
                            genres.append(g['name'])
                       if genres: item['info']['video']['genre'] = genres
                    if 'original_title' in i:
                       item['info']['video']['originaltitle'] = i.get('original_title')
                    if 'vote_average' in i:
                       item['info']['video']['rating'] = i.get('vote_average', 0.0)
                    if 'origin_country' in i:
                       country = ''
                       for g in i.get('origin_country'):
                           country += g + ', '
                       if country: item['info']['video']['studio'] = country.strip(' ,')
                    if 'runtime' in i:
                       item['info']['video']['duration'] = i.get('runtime', 0) / 1000
                    if 'info' in item and item['info'].get('video'): item['info']['video']['mediatype'] = "movie"

                    if 'descript' in i and not removeTitle:
                       item['context_menu'].insert(0,(
                           translate("Description"),
                           "RunPlugin(%s)" % plugin.get_url(action="descript", text=_en(i['descript'])),
                       ))
                    if 'kodi' in i:
                       if 'info' in i['kodi'] and i['kodi'].get('info'):
                           item['info'] = { 'video': dict(i['kodi']['info']) }
                       if 'cast' in i['kodi'] and i['kodi'].get('cast'):
                           item['cast'] = i['kodi']['cast']
                    if fix_view and 'title' in item.get('info', {}).get('video', {}) and not removeTitle:
                         if both_fix_view:
                           t3 = item['info']['video']['title']
                           t2 = ''
                           for n in t3.split(' / '):
                                  n2 = n.strip()
                                  if n2 not in t.get('Name', t.get('name', t.get('title', ''))):
                                       t2 += n2 + ' / '
                           title = u"[{0}] {1}{2}".format(humanizeSize(t.get('Length', t.get('torrent_size', 0))), t2, parseName(t.get('Name', t.get('name', t.get('title', '')))))
                         else:
                           title = item['label']
                         item['info']['video']['title'] = title
                    if removeTitle:
                        item['info']['video'].update(previnfo)
                        if 'info' in item:
                              if 'title' in item.get('info', {}).get('video', {}):
                                 del item['info']['video']['title']
                              if 'duration' in item.get('info', {}).get('video', {}):
                                 del item['info']['video']['duration']
                    return item


def cleanname(s):
    for i in (' ','%','!','*',"'",'(',')',';',':','@','&','=','+','$',',','/','?','#','[',']','~','"','{','}'):
         s = s.replace(i,'_')
    s = s.replace('__','_')
    if isinstance(s, unicode): s = _en(s)
    return s


def loadsubtitles(hash=None, link=None, fileid=None):
    if hash and (link or fileid) and plugin.get_setting('use_subtitles', True):
                xbmc.log('-- loadsubtitles start --')
                success = False
                global self_prev_name, self_rus
                self_prev_name = ''
                self_rus = ''

                def cfname(name, rus=''):
                        global self_prev_name, self_rus
                        if '/' in name: name = name.split('/')[-1]
                        if (name == self_prev_name) and (rus == self_rus): name = name[:name.rfind('.')] + u'_2_' + name[name.rfind('.'):]
                        self_prev_name = name
                        self_rus = rus
                        if rus and (rus.lower() in name.lower()) and len(name.split('.')) > 2 and name.split('.')[-2].lower() == rus.lower().strip('.'):
                             name = name.replace(rus.lower(), rus).replace(rus.upper(), rus)
                        elif rus: name = name[:name.rfind('.')] + rus + name[name.rfind('.'):]
                        return name

                if link:
                        fname = link.split('/')[-1]
                        if '/preload/' not in link: fname = fname.split('?')[0]
                        fname = urllib.unquote_plus(fname)
                        if isinstance(fname, unicode): fname = _en(fname)
                stat = {}
                counter = 0
                tsv, mod_tsv = getTSVer2()
                pdialog = xbmcgui.DialogProgress()
                pdialog.create('TorrServer', translate('Start find subtitles...'))
                while not (stat.get('FileStats') and stat.get('ActivePeers', 0) > 0):
                        if pdialog.iscanceled():
                                pdialog.close()
                                return False
                        prc = counter*100/120
                        pdialog.update(int(prc), translate('Find subtitles...'))
                        if tsv == 2:
                                stat = Mto1(client("/stream", get_data={"stat":"true", "link": hash}))
                        else:
                                stat = client("/torrent/stat", post_data={"Hash": hash})
                        if stat is None:
                                stat = {}
                        if counter > 120:
#                                pdialog.update(1, translate('Find subtitles...'))
                                pdialog.close()
                                return False
                        counter += 1
                        time.sleep(0.5)

                self_filestats = stat['FileStats']
                ind = 0
                self_index = ind
                findfullname = None
                for f in self_filestats:
                        if fileid:
                                if int(f['Id']) == int(fileid):
                                        findfullname = f['Path']
                                        self_index = ind
                        elif link:
                                if cleanname(f['Path']) == fname:
                                        findfullname = f['Path']
                                        self_index = ind
                        ind += 1
                if not findfullname:
                          pdialog.close()
                          return False
                findname = findfullname
                if '/' in findname:
                                findname = findname.split('/')[-1]
                findname = findname[:findname.rfind('.')]
                index = 0
                temp_list = []
                for i in self_filestats:
                        name = i['Path']
                        if findname in name:
                                if index != self_index:
                                        if '.' in name:
                                                ext = name.split('.')[-1]
                                                if ext in ('srt', 'ass', 'ssa', 'smi'):
                                                        fileid = int(i['Id'])
                                                        temp_list.append( (index, fileid, name) )
                        index += 1
#                xbmcgui.Dialog().textviewer('temp_list', unicode(temp_list))
                xbmc.log('--sort subtitles--')
                if temp_list !=[]:
                        temp_rus = []
                        temp_eng = []
                        temp_other = []
                        del_list = []
                        for f in xrange(len(temp_list)):
                                i = temp_list[f]
                                n = i[2].lower()
                                if '/rus/' in n:
                                        if ('.forc' in n) or ('_forc' in n) or ('rus forc' in n):
                                                temp_rus.insert( 0, (i[0], i[1], cfname(i[2], '.Rus'), i[2] ) )
                                        else:
                                                temp_rus.append( (i[0], i[1], cfname(i[2], '.Rus'), i[2] ) )
                                        del_list.insert(0, f)
                                elif '/eng/' in n:
                                        temp_eng.append( (i[0], i[1], cfname(i[2], '.Eng'), i[2] ) )
                                        del_list.insert(0, f)
                                elif '/fre/' in n:
                                        temp_other.append( (i[0], i[1], cfname(i[2], '.Fre'), i[2] ) )
                                        del_list.insert(0, f)
                                elif '/chi/' in n:
                                        temp_other.append( (i[0], i[1], cfname(i[2], '.Chi'), i[2] ) )
                                        del_list.insert(0, f)
                        for i in del_list: del temp_list[i]
                        for i in temp_list:
                                n = i[2].lower()
                                if ('.rus' in n) or ('_rus' in n) or ('_ru.' in n):
                                        if ('.forc' in n) or ('_forc' in n) or ('rus forc' in n):
                                                temp_rus.insert( 0, (i[0], i[1], cfname(i[2], '.Rus'), i[2] ) )
                                        else:
                                                temp_rus.append( (i[0], i[1], cfname(i[2], '.Rus'), i[2] ) )
                                elif ('.eng' in n) or ('_eng' in n): temp_eng.append( (i[0], i[1], cfname(i[2], '.Eng'), i[2] ) )
                                elif 'rus ' in n:
                                        if ('.forc' in n) or ('_forc' in n) or ('rus forc' in n):
                                                temp_rus.insert( 0, (i[0], i[1], cfname(i[2], '.Rus'), i[2] ) )
                                        else:
                                                temp_rus.append( (i[0], i[1], cfname(i[2], '.Rus'), i[2] ) )
                                elif 'eng ' in n: temp_eng.append( (i[0], i[1], cfname(i[2], '.Eng'), i[2] ) )
                                else: temp_other.append( (i[0], i[1], cfname(i[2]), i[2] ) )
                        if temp_rus == [] and temp_other:
                                i = temp_other[0]
                                temp_rus.append( (i[0], i[1], cfname(i[3], '.Rus'), i[3] ) )
                                del temp_other[0]
                        temp_l = []
                        temp_l.extend(temp_rus)
                        temp_l.extend(temp_eng)
                        temp_l.extend(temp_other)
#                        xbmcgui.Dialog().textviewer('temp_l', unicode(temp_l))
                        subtitles = []
                        counter = 1
                        for i in temp_l:
                                        if tsv == 2:
                                             uname = "/stream?link="+str(hash).lower()+"&index="+str(i[1])+"&play"
                                        else:
                                             auth = ""
                                             if mod_tsv > 27: auth = userMD5(right=True)
                                             uname = "/torrent/view/"+auth+str(hash).lower()+"/"+urllib.quote_plus( cleanname(i[3]) )
                                        prc = counter*100/len(temp_l)
                                        pdialog.update(int(prc), translate('Load subtitles {0} / {1}').format(counter,len(temp_l)) )
                                        data = client(uname)
                                        if data:
                                                class Handler:
                                                        @staticmethod
                                                        def path(*path):
                                                                p = [_de(translatePath('special://temp'))]
                                                                p.extend(path)
                                                                return os.path.join(*p)
                                                sdir  = Handler().path('subtitles_torrserve')
                                                if not os.path.isdir(sdir): os.mkdir(sdir)
                                                fname = Handler().path('subtitles_torrserve', i[2])
                                                open(fname, 'wb').write(data)
                                                subtitles.append(fname)
                                        else:
                                                xbmc.log('error loading subtitles!')
                                                success = False
                                                break
                        if subtitles !=[]: success = subtitles
                else:
                        xbmc.log('subtitles not found!')
                xbmc.log('-- loadsubtitles stop --')
                pdialog.close()
                return success
    return False


def makePreloadDialog(hash, fileId=None, link=None):
    tsv = getTSVer()
    if tsv == 2 and fileId == '0': fileId = '1' # в версии MatriX нет id: 0, исправление для Kinotrend
    pDialog = xbmcgui.DialogProgress()
    pDialog.create("TorrServer", "[CR]".join([translate("Wait for info..."), translate("Connected: {0} | Active: {1} | Total: {2}").format(0, 0, 0)]))
    success = False
    onetouch = True
    global _stop_preload_
    _stop_preload_ = False
    if link and link.startswith('http'):
        def preload(url):
            try:
                client_touch(url)
            except BaseException as e:
                print(e)
            global _stop_preload_
            _stop_preload_ = True

        t = threading.Thread(target=preload, args=(link, ))
        t.start()
    ind = None
    counter = 0
    name = ""
    while not pDialog.iscanceled():
        if pDialog.iscanceled():
            if tsv == 2:
                 client("/torrents", post_data={"action":"drop", "Hash": hash})
            else:
                 client("/torrent/drop", post_data={"Hash": hash})
            break
        time.sleep(0.5)
        if tsv == 2:
              stat = Mto1(client("/stream", get_data={"link": hash, "stat":"true"}))
#              stat = Mto1(client("/torrents", post_data={"action":"get", "hash": hash}))
        else:
              stat = client("/torrent/stat", post_data={"Hash": hash})
        if onetouch and link and stat and (stat.get('PreloadSize') == 0 or (stat.get('PreloadSize', 0) > 0 and stat.get('PreloadedBytes') == 0)) and stat.get('TorrentStatus') == 3: # fix wait info
            if link.startswith('http'): touch(link)
            else: touch("{0}{1}".format(TORRSERVED_HOST, link))
            onetouch = False
#        xbmcgui.Dialog().textviewer('preload', unicode(stat))
        if stat is None:
            counter += 1
            if counter < 60:
                time.sleep(0.5)
                continue
            else:
                notify("Time is over")
                break
        else:
            if name == "":
                if (fileId or link) and ('FileStats' not in stat or not stat['FileStats']):
                    stat = {}
                    while not stat.get('FileStats') and not pDialog.iscanceled():
                         time.sleep(0.5)
                         stat = client("/torrent/stat", post_data={"Hash": hash})
                if fileId and stat['FileStats']:
                    itemp = 0
                    for f in stat['FileStats']:
                        if int(f['Id']) == int(fileId):
                            name = f['Path'][f['Path'].rfind('/')+1:]
                            fileSize = f.get('Length', 0)
                            ind = itemp
                        itemp += 1
                elif link and stat['FileStats']:
                    fname = link.split('/')[-1]
                    if '/preload/' not in link: fname = fname.split('?')[0]
                    fname = urllib.unquote_plus(fname)
                    if isinstance(fname, unicode): fname = _en(fname)
                    itemp = 0
                    for f in stat['FileStats']:
                        if cleanname(f['Path']) == fname:
                            name = f['Path'][f['Path'].rfind('/')+1:]
                            fileSize = f.get('Length', 0)
                            ind = itemp
                        itemp += 1
                else:
                    name = stat['Name']
                    fileSize = stat['TorrentSize']
            downSpeed = humanizeSize(stat.get('DownloadSpeed', 0))
            preloadedBytes = stat.get('PreloadedBytes', 0)
            preloadSize = stat.get('PreloadSize', 0)
            line2 = translate("Connected: {0} | Active: {1} | Total: {2}").format(stat.get('ConnectedSeeders', 0), stat.get('ActivePeers', 0), stat.get('TotalPeers', 0))
            line3 = u"D: {0}/сек [{1}/{2}]".format(downSpeed, humanizeSize(preloadedBytes), humanizeSize(preloadSize))
            if preloadSize > 0 and (preloadedBytes < preloadSize or not _stop_preload_):
                prc = preloadedBytes * 100 / preloadSize
                if prc > 100:
                    prc = 100
                pDialog.update(int(prc), "[CR]".join([name, _de(line2), line3]))
            if link and link.startswith('http') and tsv == 1 and _stop_preload_:
                break
            elif preloadedBytes >= preloadSize and not (link and link.startswith('http')):
                break
            if tsv == 2 and (preloadedBytes >= preloadSize or preloadedBytes >= fileSize) and _stop_preload_:
                break
    if not pDialog.iscanceled(): success = True
    pDialog.close()
    return success , ind


def getLinkUri(fPath, tGetInfo):
    for i in tGetInfo['Files']:
        if i['Name'] == fPath: return i['Link']
    return None

@plugin.action()
def download(params):
    tsv, mod_tsv = getTSVer2()
    bg = xbmcgui.Dialog().yesno(_T('Скачивание'), _T('Скачать в фоне?'))
    if params.magnet and params.selFile:
      if tsv == 2:
         playuri = TORRSERVED_HOST+"/stream?link="+params.magnet+"&index="+str(params.selFile)+"&preload"
         if params.poster: playuri += '&poster='+ urllib.quote_plus(params.poster)
         if params.title: playuri += '&title='+ urllib.quote_plus(params.title)
      else:
         auth = ""
         if mod_tsv > 27: auth = userMD5(True)
         playuri = TORRSERVED_HOST+"/torrent/play"+auth+"?link="+params.magnet+"&file="+str(params.selFile)
      success, index = makePreloadDialog(getHash(params.magnet), params.selFile, playuri)
      if not success:
         return
      if not params.link and params.name:
         if tsv == 2:
              params.link = "/stream?link="+params.magnet+"&index="+str(params.selFile)+"&play"
         else:
              tGetInfo = client('/torrent/get', post_data={'Hash':getHash(params.magnet)})
              params.link = getLinkUri(params.name, tGetInfo)
    if params.link and params.name:
         if not params.magnet and not params.selFile and params.hash and tsv != 2:
             touch(TORRSERVED_HOST+params.link)
             success, index = makePreloadDialog(params.hash, None, link=params.link)
             if not success:
                  return
             params.link = params.link.replace('/preload/','/view/')
         downloadFile(params.link, params.name, _T, bg)
    else:
         xbmcgui.Dialog().textviewer('download - debug', unicode(params))
         raise


class ExtTorrents:
    def __init__(self):
        self.storage = plugin.get_storage('extTorrents')

    def setLastPlayed(self, hash):
        self.storage[hash] = { 'lastplayed': time.strftime("%Y-%m-%d %H:%M:%S", time.localtime(time.time())) }

    def getLastPlayed(self, hash):
        return self.storage.get(hash, {}).get('lastplayed', '')

    def remove(self, hash):
        if hash in self.storage: del self.storage[hash]

    def removeList(self, hashs):
        for hash in hashs:
            self.remove(hash)

    def getHashs(self):
        return [hash for hash in self.storage]

