# -*- coding: utf-8 -*-

try:
	from sqlite3 import dbapi2 as sqlite
except:
	from pysqlite2 import dbapi2 as sqlite


DB_VERS = {
	'10': '37',
	'11': '60',
	'12': '75',
	'13': '78',
	'14': '90',
	'15': '93',
	'16': '99',
	'17': '107',
	'18': '116',
	'19': '119'
}


def changeWatchedStatus(fpath, playcount):
	from simpleplugin import translatePath
	from utils import plugin
	db = sqlite.connect(translatePath('special://database/MyVideos{}.db'.format(DB_VERS[plugin.kodiMajor]) ))
	cur = db.cursor()

	cur.execute('UPDATE files SET playCount=? WHERE strFilename=?', (playcount, fpath))
	db.commit()

	cur.close()
	db.close()


def changeResumeTime(fpath, resumetime):
	from simpleplugin import translatePath
	from utils import plugin
	db = sqlite.connect(translatePath('special://database/MyVideos{}.db'.format(DB_VERS[plugin.kodiMajor]) ))
	cur = db.cursor()

	cur.execute('SELECT idFIle FROM files WHERE strFilename=?', (fpath,))
	idfiles = [i[0] for i in cur.fetchall()]

	for id in idfiles:
		cur.execute('UPDATE bookmark SET timeInSeconds=? WHERE type=1 and idFile=?', (resumetime, id))
	if idfiles:
		db.commit()

	cur.close()
	db.close()


def getFullPath():
	import xbmc
	return xbmc.getInfoLabel('ListItem.FileNameAndPath')


# для Kodi >= 19 лучше использовать JSON-RPC API
def resetResumeTime():
	changeResumeTime(getFullPath(), 0)

def resetAllResumeTime():
	import xbmc
	numitems = int(xbmc.getInfoLabel('Container().NumItems'))
	for f in range(1, numitems+1):
		path = xbmc.getInfoLabel('Container().ListItemAbsolute(%s).FileNameAndPath' % f)
		changeResumeTime(path, 0)

def removeAllWatched():
	import xbmc
	numitems = int(xbmc.getInfoLabel('Container().NumItems'))
	for f in range(1, numitems+1):
		path = xbmc.getInfoLabel('Container().ListItemAbsolute(%s).FileNameAndPath' % f)
		changeWatchedStatus(path, 0)
