# -*- coding: utf-8 -*-
import os

import xbmc

from utils import plugin, PY2, notify, makeMovieItem, makeTvShowItem
from main import checkMagnet, translatePath
from tmdb.api import TMDB

if not PY2:
    xrange = range

tmdb = TMDB()

@plugin.action('library')
def library(params):
    if params.mod == 'save':
        magneturi = checkMagnet(params.magnet)
        if not magneturi:
           return
        if params.item:
           import ast
           item = ast.literal_eval(params.item)
           info = item['info']['video']
        elif params.type and params.id:
           if params.type == "movie":  item = makeMovieItem(tmdb.get_movie(params.id), False, params.size)
           elif params.type == "tvshow":
                ext_info = tmdb.get_tv_show(params.id)
                if pNone(params.season):
                     item = makeTvShowItem(ext_info, "season", int(params.season), False, params.size)
                else:
                     item = makeTvShowItem(ext_info, "tvshow", None, True, params.size)
           info = item['info']['video']
        else:
           import totam
           info = totam.getKodiInfo()['kodi']['info']
        name = info['originaltitle'] + " ("+params.year+")"
        name = name.replace("/", " ").replace("\\", " ").replace("?", "").replace(":", "").replace('"', "").replace('*', "").replace('|', "")
        path = plugin.get_setting("library_path", True)

        if info.get('mediatype', 'movie') == "movie":
            path = os.path.join(translatePath(path), 'videos', name)
            if not os.path.exists(path):
                os.makedirs(path)
            uri = plugin.get_url(action="play_now", magnet=magneturi, selFile=0, isGotInfo=True)
            fl = open(os.path.join(path, name+".strm"), "w")
            fl.write(uri)
            fl.close()
            notify(path)
        elif info.get('mediatype', 'movie') == "tvshow":
            path = os.path.join(translatePath(path), 'tvshows', name)
            if not os.path.exists(path):
                os.makedirs(path)
            numEp = 1
            if 'All' in params.numEp:
                numEp = int(info.get('episode', 1))
            elif 'Multi' in params.numEp:
                notify("Multi seasons not saved", time=10000)
                return False
            else:
                numEp = int(params.numEp)
            for ep in xrange(numEp):
                epname = name + " S{0}E{1:02d}".format(params.season, ep+1)
                uri = plugin.get_url(action="play_now", magnet=magneturi, selFile=ep, isGotInfo=True)
                fl = open(os.path.join(path, epname+".strm"), "w")
                fl.write(uri)
                fl.close()
            notify(path)
        xbmc.executebuiltin('UpdateLibrary("video")')
        return True

