# -*- coding: utf-8 -*-
import xbmcgui

from utils import plugin, _T, notify
import searcher

freejacketts = [('j.yourok.ru', '1'), ('jac.lampa32.ru', '1'), ('jac.my.to', ''), ('jacred.xyz', ''),
                ('spawn.pp.ua:59117', '2'), ('74.119.194.209:9117', '1'), ('88.210.12.237:9118', '1'),
                ('jacc.drstein.xyz', ''),
                ('j5.drstein.xyz', '1'), ('15.164.68.244:54544', '1'), ('j1.govno.co.uk', 'govno'),
                ('j1.tsarea.us', 'ts'), ('j.freewan.win', 'jac')]


freetsparsers = [('trs.my.to:8595', '', ''), ('spawn.pp.ua:59119', '', '')]


def tsparser(params):
         index = plugin.select(heading=_T('Выберите доступный сервер'), list=[i[0] for i in freetsparsers if i])
         if index == -1: return
         tsp = freetsparsers[index]
         plugin.set_setting('tsparser_url', tsp[0])
         plugin.set_setting('tsparser_login', tsp[1])
         plugin.set_setting('tsparser_password', tsp[2])
         plugin.set_setting('tsparser_use_ts', 'false')


def jacsets(params):
    dialog = xbmcgui.Dialog()
    if params.cmd == 'trackerslist':
         from searcher.scrapers.jackett import Tracker
         config = Tracker().Config()
         if '404' == config:
              dialog.ok(_T('Список трекеров на сервере')+' '+plugin.get_setting('jackett_url'), _T('Список не найден')+' - '+config)
         else:
              import xml.etree.ElementTree as et
              tree  = et.XML(config)
              tr = tree.findall('indexer')
              trackerlist = []
              for t in tr:
                  trackerlist.append(t.find('title').text+' - '+t.find('link').text+' ')
              trackerlist.append('[COLOR gold]'+ _T('Список трекеров на сервере') +' - '+str(len(trackerlist))+'[/COLOR]' )
              preselect = -1
              while True:
                index = plugin.select(_T('Список трекеров на сервере')+' '+plugin.get_setting('jackett_url'), trackerlist, preselect=preselect)
                if index == -1: return
                preselect = index
                if index == len(trackerlist)-1:
                   dialog.textviewer(_T('Список трекеров на сервере')+' '+plugin.get_setting('jackett_url'), config)
                else:
                  ftr = ''
                  for t in tr[index]:
                      ftr += t.tag+': '+ t.text + '\n'
                  for t in tr[index].find('caps').find('categories'):
                      ftr += ' - '+ t.tag+': ' + t.get('name') + '\n'
                      for s in t.findall('subcat'):
                         ftr += ' ---- '+ s.tag+': ' + s.get('name') + '\n'
                  dialog.textviewer(trackerlist[index], ftr )
    else:
         index = plugin.select(heading=_T('Выберите доступный сервер'), list=[i[0] for i in freejacketts if i])
         if index == -1: return
         jac = freejacketts[index]
         plugin.set_setting('jackett_url', jac[0])
         plugin.set_setting('jackett_key', jac[1])


@plugin.action('sets')
def selectsets(params):
    if params.mod == 'jackett':
         jacsets(params)
    elif params.mod == 'tsparser': tsparser(params)
    elif params.mod == 'searcher':
         for i in searcher.scrapersList():
             if params.cmd == 'all_on' : plugin.set_setting(i, 'true')
             elif params.cmd == 'all_off': plugin.set_setting(i, 'false')
             elif params.cmd == 'open':
                  if i in ('jackett', 'prowlarr', 'tsparser', 'nnmclub', 'rutracker'): plugin.set_setting(i, 'false')
                  else: plugin.set_setting(i, 'true')
             elif params.cmd == 'work': plugin.set_setting(i, 'true')
         if params.cmd == 'work' or params.cmd == 'check':
             notify(_T("Идёт проверка. Ждите сообщения о её завершении"))
             searcher.auto_disable_tracker = True
             searcher.disable_timeout = True
             searcher.all_trackers_on = True if params.cmd == 'work' else False
             searcher.Query('Wars')
    elif params.mod == 'kodi':
         for i in ('fix_torrent_list_view', 'fix_result_search_list_view', 'fix_show_rating_list_discover',
                   'fix_show_season_list'):
             plugin.set_setting(i, 'false' if params.cmd == 'old' or params.cmd == 'label' or (params.cmd == 'k18' and ('rating' in i or 'season' in i)) else 'true')
         plugin.set_setting('use_label_for_sort_kodi19', 'true' if params.cmd == 'label' else 'false')
         plugin.set_setting('content_movies', 'true' if params.cmd == 'old' else 'false')
    elif params.mod == 'tmdb':
         from search import langD
         for l, m in langD:
             if params.cmd == 'all_on' : plugin.set_setting('d_'+l, 'true')
             elif params.cmd == 'all_off': plugin.set_setting('d_'+l, 'false')
    notify(_T("Действие завершено"))
