# -*- coding: utf-8 -*-
import sys
import re
PY2 = sys.version_info.major == 2
if PY2:
       import urllib
else:
       import urllib.parse as urllib
       basestring = str
       unicode = str
import xbmc

#from xbmcup.errors import log
def _de(s):
    if PY2: return s.decode('utf8')
    return s

def _en(s):
    return s.encode('utf8') if PY2 and isinstance(s, unicode) else s

def clear_tc(title):
    match = re.compile(r"(\[B\]\[COLOR.+\[/COLOR\]/\[/B\])").search(title)
    if match:
        if title.startswith(match.group(1)): title = title.replace(match.group(1), '')
    return title

def getKodiInfo(tam=False, fixtitle=True):
        thumb = _de(xbmc.getInfoLabel('ListItem.Art(thumb)'))
        poster = _de(xbmc.getInfoLabel('ListItem.Art(poster)'))
        fanart = _de(xbmc.getInfoLabel('ListItem.Art(fanart)'))
        if 'http://' in fanart: pass
        elif 'https://' in fanart: pass
        else: fanart = None
        if fanart:
            if fanart[-6:].find('.') == -1: fanart = None
        info = { 'title': _de(xbmc.getInfoLabel('ListItem.Title')),
        'originaltitle': _de(xbmc.getInfoLabel('ListItem.OriginalTitle')),
        'premiered': _de(xbmc.getInfoLabel('ListItem.Premiered')).replace(u'.',u'-'),
        'genre': _de(xbmc.getInfoLabel('ListItem.Genre')),
        'director': _de(xbmc.getInfoLabel('ListItem.Director')),
        'rating': _de(xbmc.getInfoLabel('ListItem.Rating')),
        'votes': _de(xbmc.getInfoLabel('ListItem.Votes')).replace(u',',u''),
        'mpaa': _de(xbmc.getInfoLabel('ListItem.Mpaa')),
        'cast': _de(xbmc.getInfoLabel('ListItem.Cast')).split(u'\n'),
        'castandrole': [(i.split(u' в роли ')) for i in _de(xbmc.getInfoLabel('ListItem.CastAndRole')).split(u'\n') if i],
        'studio': _de(xbmc.getInfoLabel('ListItem.Studio')),
        'trailer': _de(xbmc.getInfoLabel('ListItem.Trailer')),
        'writer': _de(xbmc.getInfoLabel('ListItem.Writer')),
        'tagline': _de(xbmc.getInfoLabel('ListItem.Tagline')),
        'plot': _de(xbmc.getInfoLabel('ListItem.Plot')),
        'code': _de(xbmc.getInfoLabel('ListItem.IMDBNumber')),
        'plotoutline': _de(xbmc.getInfoLabel('ListItem.PlotOutline')),
        'mediatype': _de(xbmc.getInfoLabel('ListItem.DBTYPE')),
        }
        duration = _de(xbmc.getInfoLabel('ListItem.Duration'))
        if duration:
           if ':' in duration:
              d = duration.split(':')
              if len(d) == 3:
                  du = int(d[0])*60*60+int(d[1])*60+int(d[2])
              elif len(d) == 2:
                  du = int(d[0])*60+int(d[1])
           else: du = int(duration)*60
           info['duration'] = du
        year = _de(xbmc.getInfoLabel('ListItem.Year'))
        if year: info['year'] = year
        for i in list(info):
           if not info[i] or info[i] == [''] or (i == 'votes' and info[i] == '0'): del info[i]
        if tam:
           info.update({ 'cover': poster if poster else thumb,
             'fanart': fanart,
             'icon': None,
             })
           if not info.get('mediatype'): info['mediatype'] = 'movie' # fix android info
        else:
           if fixtitle and info.get('title'): info['title'] = clear_tc(info['title'])
           if info: info = {'kodi': {'info': info}}
           if poster or thumb: info['poster_path'] = poster if poster else thumb
           if fanart: info['backdrop_path'] = fanart
#        import xbmcgui
#        xbmcgui.Dialog().textviewer('Info', str(info))
        return info

def opentam(uri, up_info=None):
#        log('start - opentam')
        info = getKodiInfo(True)
        if up_info: info.update(up_info)
#        log(info)
        infoout = {}
        for i in info:
              if info[i] and info[i] != ['']:
                  if not (i == 'votes' and info[i] == u'0'):
                        if isinstance(info[i], basestring):
                             infoout[i] = _en(info[i].replace('|', '#')) #fix bug in TAM
                        else:
                             infoout[i] = info[i]
        purl = "?mode=open&url="+ urllib.quote(uri)+"&info="+ urllib.quote(repr(infoout))
#        log('try - xbmc.executebuiltin("Container.Update(plugin://plugin.video.tam/%s"))' %purl)
        xbmc.executebuiltin('Container.Update(plugin://plugin.video.tam/%s)' %purl)
#        log('end - opentam')
        return True
