# -*- coding: utf-8 -*-

import os, sys

import xbmc, xbmcplugin, xbmcgui

from xbmcup.app import Link, Handler, Plugin, _setting
import yummy
from history import History, HistoryAdd

_view_ = _setting['view']


class Menu(Handler):
	def handle(self):
		self.item(Link('catalog',{'search': True}), title='[Поиск]')
		self.item(Link('history'), title='[История поиска]')
		self.item(Link('catalog',{'url': 1}), title='Последние обновления аниме')
		self.item(Link('ongoing'), title='Онгоинги')
		self.item(Link('catalog'), title='Каталог по алфавиту')
		self.item(Link('genre'), title='Жанр')
		self.item(Link('god'), title='Год')
		self.item(Link('video'), title='Случайное аниме')
		self.item(Link('catalog',{'top': '1'}), title='ТОП-100 сериалов')
		self.item(Link('catalog',{'top': '0'}), title='ТОП-100 фильмов')
		self.render(nextmode=_view_)

class Ongoing(Handler):
	def handle(self):
		data = yummy.ongoing()
		for i in data:
			popup = []
			popup.extend(self.popup)
			popup.insert(1, (Link('catalog',{'search': True, 'textsearch': i['info']['title']}, True), 'Поиск' ) )
			title = i['info']['title'] + ' (' + i['year'] + ')'
			self.item(Link('video', {'url': i['url']}), title=title, media='video', info=i['info'], thumb=i['thumb'], popup=popup, popup_replace=True)
		self.render(nextmode=_view_)


class Catalog(Handler):
	def handle(self):
		search = self.argv.get('search')
		top100 = self.argv.get('top')
		god_start = self.argv.get('god_start')
		god_end = self.argv.get('god_end')
		url = self.argv.get('url')
		s_kbd = self.argv.get('s_kbd', False)
		if search:
			if isinstance(search, bool):
				textsearch = self.argv.get('textsearch', '')
				search = self.kbdinput('Поиск', textsearch)
				if search is None: return True
				s_kbd = True
				HistoryAdd(search)
			url = yummy.search(search)
		elif top100:
			url = yummy.top100(bool(int(top100)))
		elif god_start and god_end:
			url = yummy.filter_god(god_start, god_end)
		if url == 1:
			data = yummy.updates()
		else:
			data = yummy.catalog(url)
		if (data['data'] == []) and s_kbd:
			xbmcgui.Dialog().ok('YummyAnime', 'Ничего не найдено')
		for i in data['data']:
			popup = []
			popup.extend(self.popup)
			popup.insert(1, (Link('catalog',{'search': True, 'textsearch': i['info']['title']}, True), 'Поиск' ) )
			title = i['info']['title'] +' (' + i['year'] +',' + i['type'] + ')'
			self.item(Link('video', {'url': i['url']}), title=title, media='video', info=i['info'], thumb=i['thumb'], popup=popup, popup_replace=True)
		if data['page']['next']:
			titlepage = 'Следующая страница '+ str(data['page']['current']+1)+ ' из ' + str(data['page']['max']) + ' >>'
			self.item(Link('catalog',{'url':data['page']['next']}), title=titlepage)
		self.render(nextmode=_view_)


class Genres(Handler):
	def handle(self):
		data = yummy.genre()
		for n, l in data:
			self.item(Link('catalog', {'url': l}), title=n, media='video', popup=self.popup, popup_replace=True)
		self.render(nextmode=_view_)

class God(Handler):
	def handle(self):
		self.item(Link('catalog', {'god_start': 1950, 'god_end': 1989}), title='1950-1989', media='video', popup=self.popup, popup_replace=True)
		import time
		year = time.gmtime(time.time()).tm_year
		for l in range(1990, year+1):
			self.item(Link('catalog', {'god_start': l, 'god_end': l}), title=str(l), media='video', popup=self.popup, popup_replace=True)
		self.render(nextmode=_view_)

class VideoInfo(Handler):
	def handle(self):
		url = self.argv.get('url')
		if url:
			data = yummy.videoinfo(url)
			rand = u''
		elif url == 0:
			return True
		else:
			url, data =yummy.random_anime()
			rand = u' {Случайное аниме}'
		self.item(Link('video', {'url': url}), title=data['info']['title']+rand, media='video', info=data['info'], thumb=data['thumb'], popup=self.popup, popup_replace=True)
		for j in range(1, len(data['video'])+1):
			i = str(j)
			info = data['info']
			#del info['title']
			self.item(Link('serials',{'slist': data['video'][i]['serials'], 'thumb': data['thumb']}), title=u'#'+i+u' '+data['video'][i]['name']+u' ('+data['video'][i]['len']+u')', media='video', info=info, thumb=data['thumb'], popup=self.popup, popup_replace=True)
		if data['view']:
			for title , url in data['view']:
				self.item(Link('video', {'url': url}), title=title, media='video', popup=self.popup, popup_replace=True)
		self.render(nextmode=_view_)

class Serials(Handler):
	def handle(self):
		slist = self.argv.get('slist')
		thumb = self.argv.get('thumb')
		info = {}
		for i, l in slist:
			info['title'] = i+ u' Серия'
			self.item(Link('play',{'url': l}), title=info['title'], media='video', info=info, thumb=thumb, property=[('IsPlayable','true')], folder=False, popup=self.popup, popup_replace=True)
		self.render(nextmode=_view_)

class Play(Handler):
	def handle(self):
		url = self.argv.get('url')
		link, error = yummy.play_link(url)
		if link:
			#xbmc.Player().play(link)
			item = xbmcgui.ListItem(path=link)
			xbmcplugin.setResolvedUrl(int(sys.argv[1]),True, item)
		else:
			xbmcgui.Dialog().ok('YummyAnime', *error)


def main():
	plugin = Plugin(Menu)
	plugin.route('catalog', Catalog)
	plugin.route('genre', Genres)
	plugin.route('video', VideoInfo)
	plugin.route('serials', Serials)
	plugin.route('play', Play)
	plugin.route('ongoing', Ongoing)
	plugin.route('god', God)
	plugin.route('history', History)
	plugin.run()


if __name__ == '__main__':
	try:
                search_vars = sys.argv[2].split('?')
                search_vars = search_vars[-1].split('&')
                if 'usearch=True' in search_vars:
                        from urlparse import parse_qs
                        params = parse_qs(sys.argv[2].replace('?', ''))
                        united_search = {'route': 'catalog', 'argv': { 'search': params['keyword'][0] } }
			from urllib import quote_plus
                        import json
                        sys.argv[2] = '?'+quote_plus(json.dumps(united_search))
	except BaseException, e:
		from xbmcup.errors import log
		log(e)

	main()
