# -*- coding: utf-8 -*-
import platform
import sys

import xbmc

from torrserver.log import log


def get_platform():
    build = xbmc.getInfoLabel("System.BuildVersion")
    kodi_version = int(build.split()[0][:2])
    ret = {
        "auto_arch": sys.maxsize > 2 ** 32 and "64-bit" or "32-bit",
        "arch": sys.maxsize > 2 ** 32 and "amd64" or "386",
        "os": "",
        "version": platform.release(),
        "kodi": kodi_version,
        "build": build,
        "fork": True,
    }
    if xbmc.getCondVisibility("system.platform.linux"):
        ret["os"] = "linux"
        if "aarch" in platform.machine().lower() or "arm64" in platform.machine().lower():
            dump_version()

            if xbmc.getCondVisibility("system.platform.linux.raspberrypi"):
                ret["arch"] = "arm7"
            elif ret["auto_arch"] == "32-bit":
                ret["arch"] = "arm7"
            elif ret["auto_arch"] == "64-bit":
                ret["arch"] = "arm64"
            else:
                ret["arch"] = "arm7"
        elif "arm" in platform.machine():
            dump_version()

            cpuarch = ""
            if "aarch" in platform.machine().lower() or "arm" in platform.machine().lower():
                info = cpuinfo()
                for proc in info.keys():
                    log.info("CPU: %s=%s" % (proc, info[proc]))
                    model = ""
                    if "Processor" in info[proc]:
                        model = info[proc]["Processor"].lower()
                    elif "model name" in info[proc]:
                        model = info[proc]["model name"].lower()

                    if model:
                        log.info("Exploring model: %s" % model)
                        if "aarch" in model or "arm64" in model or "v8l" in model:
                            cpuarch = "arm64"
                        elif "armv7" in model or "v7l" in model:
                            cpuarch = "arm7"
                        break

            if cpuarch:
                log.info("Using CPU info arch: %s" % cpuarch)
                ret["arch"] = cpuarch
            else:
                ret["arch"] = "arm6"
    elif xbmc.getCondVisibility("system.platform.windows"):
        ret["os"] = "windows"
        if platform.machine().endswith('64'):
            ret["arch"] = "amd64"
    return ret


def linux_distribution():
    try:
        return platform.linux_distribution()
    except:
        return "N/A"


def cpuinfo():
    cpuinfo = {}
    procinfo = {}
    nprocs = 0
    with open('/proc/cpuinfo') as f:
        for line in f:
            if not line.strip():
                cpuinfo['proc%s' % nprocs] = procinfo
                nprocs = nprocs + 1
            else:
                if len(line.split(':')) == 2:
                    procinfo[line.split(':')[0].strip()] = line.split(':')[1].strip()
                else:
                    procinfo[line.split(':')[0].strip()] = ''
    return cpuinfo


def dump_version():
    try:
        p = platform.platform()
    except:
        p = "Could not detect"

    log.info("""Python version: %s
    dist: %s
    linux_distribution: %s
    system: %s
    machine: %s
    platform: %s
    uname: %s
    version: %s
    mac_ver: %s
    """ % (
        sys.version.split('\n'),
        str(platform.dist()),
        linux_distribution(),
        platform.system(),
        platform.machine(),
        p,
        platform.uname(),
        platform.version(),
        platform.mac_ver()
    ))


PLATFORM = get_platform()
