import threading

import xbmc

from torrserver.daemon import torrserverd_thread
from torrserver.monitor import TorrServerMonitor


def run():
    # Make the monitor
    monitor = TorrServerMonitor()

    threads = [
        threading.Thread(target=torrserverd_thread, args=[monitor]),
    ]
    for t in threads:
        t.daemon = True
        t.start()

    # XBMC loop
    while not xbmc.abortRequested:
        xbmc.sleep(1000)

    xbmc.log("TorrServer: exiting torrserverd", level=xbmc.LOGNOTICE)
