import os
import threading

import xbmc

from torrserver.daemon import shutdown


class TorrServerMonitor(xbmc.Monitor):
    def __init__(self):
        self._closing = threading.Event()

    @property
    def closing(self):
        return self._closing

    def onAbortRequested(self):
        # Only when closing Kodi
        if xbmc.abortRequested:
            xbmc.executebuiltin("Dialog.Close(all, true)")
            shutdown()
            try:
                self._closing.set()
                self._closing.clear()
            except SystemExit as e:
                if e.code != 0:
                    os._exit(1)
                pass
