# -*- coding: utf-8 -*-
# Borrowed and modified from xbmcswift
import logging

import xbmc

from torrserver.addon import ADDON_ID, ADDON
from torrserver.utils23 import *


class XBMCHandler(logging.StreamHandler):
    xbmc_levels = {
        'DEBUG': xbmc.LOGDEBUG,
        'INFO': xbmc.LOGINFO,
        'WARNING': xbmc.LOGWARNING,
        'ERROR': xbmc.LOGERROR,
        'CRITICAL': xbmc.LOGSEVERE if PY2 else xbmc.LOGFATAL,
    }

    def emit(self, record):
        xbmc_level = self.xbmc_levels.get(record.levelname)
        if PY2 and isinstance(record.msg, unicode):
            record.msg = record.msg.encode('utf-8', 'replace')
        elif not PY2 and isinstance(record.msg, bytes):
            record.msg = record.msg.decode('utf-8', 'replace')
        xbmc.log(self.format(record), xbmc_level)


loggers = {}


def _get_logger(name):
    global loggers

    if loggers.get(name):
        return loggers.get(name)
    else:
        logger = logging.getLogger(ADDON_ID)
        if ADDON.getSetting("log_only_error") == "true":
            logger.setLevel(logging.ERROR)
        else:
            logger.setLevel(logging.DEBUG)

        handler = XBMCHandler()
        handler.setFormatter(logging.Formatter('[%(name)s] %(message)s'))
        logger.addHandler(handler)
        return logger


log = _get_logger(__name__)
