import threading

import xbmc

from torrserver.log import log
from torrserver.daemon import torrserverd_thread
from torrserver.monitor import TorrServerMonitor


def run():
    # Make the monitor
    monitor = TorrServerMonitor()

    threads = [
        threading.Thread(target=torrserverd_thread, args=[monitor]),
    ]
    for t in threads:
        t.daemon = True
        t.start()

    # XBMC loop
    while not monitor.abortRequested():
        xbmc.sleep(1000)

    monitor.onAbortRequested()

    log.info("TorrServer: exiting torrserverd")
