class Random {

    constructor(s) {
        s = s ? s : 123456789;
        this.seed(s);
        this.mask = 0xffffffff;
    }

    // Takes any integer
    seed(i) {
        this.m_w = i;
        this.m_z = 987654321;
    }

    // Returns number between 0 (inclusive) and 1.0 (exclusive),
    // just like Math.random().
    random()
    {
        this.m_z = (36969 * (this.m_z & 65535) + (this.m_z >> 16)) & this.mask;
        this.m_w = (18000 * (this.m_w & 65535) + (this.m_w >> 16)) & this.mask;
        var result = ((this.m_z << 16) + this.m_w) & this.mask;
        result /= 4294967296;
        return result + 0.5;
    }

    randInt(rngMax)
    {
	return Math.floor(this.random()*rngMax);
    }

    shuffle(arr)
    {
	let i = arr.length;
	while(i) {
	    let j = Math.floor(this.random() * i--);
	    [arr[j], arr[i]] = [arr[i], arr[j]];
	}

	return arr;
    }
}
