// dependencies:
//      d3.js
//      d3-color-cie-luv-xyz.js
//      jquery-3.2.1.min.js
//      score.js
//      global.js
//      distance.js
//      util.js

function inverseFunc(x)
{
    //return Math.exp(-x);
    x = x == 0 ? 1 : x;
    return 1/x;
}

function E_cd(sigma, distanceOf2Clusters, distanceOf2Colors) {
    var score = 0;
    for(var l of distanceOf2Clusters.keys()) {
        var [i,j] = l.split(',');
        var color_pair = sigma[i] < sigma[j] ? [sigma[i], sigma[j]] : [sigma[j], sigma[i]];
        score += lambda*distanceOf2Clusters.get([i,j]) * distanceOf2Colors.get(color_pair);
    }
    return score;
}

// Evaluation function
function E(sigma, distanceOf2Clusters, saliencyWeight, distanceOf2Colors, debug)
{
    function E_lc() {
        var score = 0;
        for(var i=0; i<sigma.length; i++) {
            var tmp = (1-lambda)*saliencyWeight[i]*distanceOf2Colors.get([sigma[i], palettes.length]);
            score += tmp;
        }
        return score;
    }

    var score_cd = E_cd(sigma, distanceOf2Clusters, distanceOf2Colors),
        score_lc = E_lc();
    var score = score_cd+score_lc;
    if(debug) {
        console.log("cd:"+score_cd+", lc:"+score_lc);
    }
    return score;
}

function getVariablesForComputeScore(labelSet, data, width, height, radius)
{
    //auxiliary variables
    var labelToClass = getLabelToClassMapping(labelSet);
    var clusters = SplitDataByClass(data, labelToClass);
    console.time("getVariablesForComputeScore");
    var [labels, knng] = getKNNG(clusters, NeighborNum);
    console.timeEnd("getVariablesForComputeScore");

    //variables in evaluation function
    var saliencyWeight = getSaliencyWeightOfClass(labels, knng),
        distanceWeight = getDistanceWeightOf2Classes(labels, knng, labelSet.size),
        distanceOf2Colors = getDistanceOf2Colors(labelSet.size);

    return [labelToClass, saliencyWeight, distanceWeight, distanceOf2Colors];
}

//main function for BF attack
function getSigmasAndScores(labelSet, data, width, height, radius)
{
    var [labelToClass, saliencyWeight, distanceWeight, distanceOf2Colors] = getVariablesForComputeScore(labelSet, data, width, height, radius);

    // sigmas and scores
    var allSigma = getAllSigma(labelSet.size),
        [scoreList, sortIndex] = getScores(allSigma, distanceWeight, saliencyWeight, distanceOf2Colors),
        naturalSigmaInfo = getNaturalSigmaInfo(allSigma, labelToClass);

    return [labelToClass, allSigma, scoreList, sortIndex, naturalSigmaInfo, (sigma, debug) => E(sigma, distanceWeight, saliencyWeight, distanceOf2Colors, debug), (sigma) => E_cd(sigma, distanceWeight, distanceOf2Colors)];
}

//main function for GA
function getTargetSigma(labelSet, data, width, height, radius, comp, selectionScoreFunc)
{
    var [labelToClass, saliencyWeight, distanceWeight, distanceOf2Colors] = getVariablesForComputeScore(labelSet, data, width, height, radius);

    var labelNum = labelSet.size;
    var ga = new GA(new Random(Date.now()),
        labelSet.size,
        comp,
        (sigma) => E(sigma, distanceWeight, saliencyWeight, distanceOf2Colors),
        selectionScoreFunc,);
    console.time("ga");
    var sigmaAndScore = ga.compute();
    console.timeEnd("ga");

    var tableauSigma = getClassToLabel(labelToClass),
        tableauScore = E(tableauSigma, distanceWeight, saliencyWeight, distanceOf2Colors),
        info = [tableauScore, tableauSigma];

    return [labelToClass, sigmaAndScore.sigma, sigmaAndScore.score, info, (sigma, debug) => E(sigma, distanceWeight, saliencyWeight, distanceOf2Colors, debug), (sigma) => E_cd(sigma, distanceOf2Clusters, distanceOf2Colors)];
}

function getLabelToClassMapping(labelSet)
{
    var i = 0;
    var label2class = {};
    for(let e of labelSet.values()){
        label2class[e] = i++;
    }
    return label2class;
}

function SplitDataByClass(data, label2class)
{
    var clusters = {};
    for (let d of data) {
        if(clusters[label2class[d.label]] == undefined)
            clusters[label2class[d.label]] = [];
        clusters[label2class[d.label]].push({x:xMap(d), y:yMap(d)});
    }
    return clusters;
}

function getKNNG(clusters, k)
{
    var labels = [], dataset = [];
    for(var i in clusters) {
        for(var d of clusters[i]) {
            labels.push(i);
            dataset.push([d.x, d.y]);
        }
    }

    console.time('build index');
    var index = Flann.fromDataset(dataset);
    console.timeEnd('build index');
    var result = index.multiQuery(dataset, k+1);

    return [labels, result];
}

function getKDTrees(classifiedPixels, labelNum)
{
    var trees = new Array(labelNum);
    for(var i=0; i<labelNum; i++) {
        trees[i] = new kdTree(classifiedPixels[i], no_sqrt_euclidean_metric, ["x", "y"]);
    }
    return trees;
}

function getSaliencyWeightOfClass(labels, knng)
{
    var saliencyWeight = [];
    for(var i=0; i<labels.length; i++) {
        if(saliencyWeight[labels[i]] === undefined)
            saliencyWeight[labels[i]] = 0;
        var stat = [0, 0];
        for(var j in knng[i]) {
            if(knng[i][j] === 0) // if distance between point i and j is 0
                continue;
            if(labels[i] != labels[j])
                stat[0]+=inverseFunc(Math.sqrt(knng[i][j]));
            else
                stat[1]+=inverseFunc(Math.sqrt(knng[i][j]));
        }
        saliencyWeight[labels[i]] += (stat[0]-stat[1]);
    }
    console.log("saliencyWeight:");
    console.log(saliencyWeight);
    return saliencyWeight;
}

function getDistanceWeightOf2Classes(labels, knng, labelNum)
{
    var distanceDict = {};
    for(var i=0; i<knng.length; i++) {
        for(var j in knng[i]) {
            if(labels[i] != labels[j]) {
                if(distanceDict[labels[i]]===undefined)
                    distanceDict[labels[i]] = {};
                if(distanceDict[labels[i]][labels[j]]===undefined)
                    distanceDict[labels[i]][labels[j]] = [];
                distanceDict[labels[i]][labels[j]].push(inverseFunc(Math.sqrt(knng[i][j])));
            }
        }
    }

    var distanceOf2Clusters = new TupleDictionary();
    for(var i in distanceDict) {
        for(var j in distanceDict[i]) {
            i = +i, j = +j; //str to int
            var dist;
            if(distanceDict[j] === undefined || distanceDict[j][i] === undefined)
                dist = 2*d3.sum(distanceDict[i][j]);
            else
                dist = d3.sum(distanceDict[i][j])+d3.sum(distanceDict[j][i]);
            if(i<j)
                distanceOf2Clusters.put([i, j], dist);
            else
                distanceOf2Clusters.put([j, i], dist);
        }
    }
    console.log("disOf2Class");
    console.log(distanceOf2Clusters);
    return distanceOf2Clusters;
}

function color_contrast(hex1, hex2)
{
    var c1 = d3.hcl(hex1), c2 = d3.hcl(hex2);
    var dl = c1.l-c2.l, dc = c1.c-c2.c;
    return Math.sqrt(dl*dl)//+dc*dc);
}

function getDistanceOf2Colors(labelNum)
{
    var distanceOf2Colors = new TupleDictionary();
    //var color_difference = function(hex1, hex2) { return ciede2000(d3.lab(hex1), d3.lab(hex2)); }
    //var color_difference = function(hex1, hex2) { return cie76(d3.lab(hex1), d3.lab(hex2)); }
    var color_difference = function(hex1, hex2) { return euclidean_of_rgb(d3.rgb(hex1), d3.rgb(hex2)); };
    //var color_difference = function(hex1, hex2) { return euclidean_of_CIELuv(d3.color.luv(hex1), d3.color.luv(hex2)); };
    for(var i=0; i<labelNum; i++) {
        for(var j=i+1; j<labelNum; j++) {
            var dis = color_difference(palettes[i], palettes[j]);
            distanceOf2Colors.put([i, j], dis);
        }
        distanceOf2Colors.put([i, palettes.length], color_contrast(palettes[i], bgcolor));
    }
    console.log(distanceOf2Colors);
    return distanceOf2Colors;
}

function find_pos(index)
{
    var score = scoreList[index];
    for(var i=0; i<sortIndex.length; i++) {
        if(sortIndex[i] == index)
            return [score, sortIndex.length - i];
    }
}

function getClassToLabel(labelToClass)
{
    var class2label = {};
    var i=0;
    for(var k in labelToClass)
        class2label[labelToClass[k]] = i++;
    return Object.values(class2label);
}

function getNaturalSigmaInfo(all_sigma, label2class)
{
    var class2label = getClassToLabel(label2class);

    var rank = sigmaToRank(class2label, all_sigma);
    return [rank[1], class2label, rank[0]];
}

function sigmaToRank(sigma, all_sigma)
{
    var rank, flag;
    for(var i=0; i<all_sigma.length; i++) {
        flag = true;
        for(var j=0; j<all_sigma[i].length; j++) {
            flag = flag && sigma[j] === all_sigma[i][j];
        }
        if(flag) {
            rank = find_pos(i);
            break;
        }
    }
    return rank;
}

function getAllSigma(labelNum)
{
    console.time("perm");
    var condSigma = []; // possible mapping from class to color after pruning
    var origin = []; // the identical transformation
    for(var i = 0; i<labelNum; i++)
        origin.push(i);
    cond_perm(condSigma,origin,origin.length,0, (sigma, i) => false);
    console.timeEnd("perm");
    return condSigma;
}

function getScores(allSigma, distanceWeight, saliencyWeight, distanceOf2Colors)
{
    console.time("calculate color assignment score");
    scoreList = [];
    sortIndex = [];
    for(var i=0; i<allSigma.length; i++) {
        var score = E(allSigma[i], distanceWeight, saliencyWeight, distanceOf2Colors);
        scoreList.push(score);
        sortIndex.push(i);
    }
    console.timeEnd("calculate color assignment score");
    console.log(scoreList);
    sortIndex = sortIndex.sort(function(a,b) { return scoreList[a]-scoreList[b]; });
    console.log(sortIndex);

    return [scoreList, sortIndex];
}
