/*
This is flann.js, a port of C++ FLANN library to JavaScript.

FLANN is C++ library written by Marius Muja and David G. Lowe.
In order to be consistent with FLANN's license, this JavaScript port together
with glue code available in this repository is licensed under BSD License.

Ported by Anton Grbin using emscripten (http://emscripten.org).

-------------------------------------------------------------------------------

Original FLANN License

Software License Agreement (BSD License)

Copyright 2008-2009  Marius Muja (mariusm@cs.ubc.ca). All rights reserved.
Copyright 2008-2009  David G. Lowe (lowe@cs.ubc.ca). All rights reserved.

THE BSD LICENSE

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*/
// fix browserify poor shim for process.
if (typeof process !== 'undefined' && !('platform' in process)) {
  (function () {
    var write, output;
    write = write || (typeof console === 'undefined' ? null :
                      console.log.bind(console));
    write = write || (typeof print === 'undefined' ? null : print);
    write = write || function () {};
    output = { write: write };
    process.platform = 'maybe-browserify';
    if (!('stderr' in process)) process.stderr = output;
    if (!('stdout' in process)) process.stdout = output;
  }());
}

var Flann = (function() {
  var Module = this;
Module["FLANN_INDEX_LINEAR"]=0;Module["FLANN_INDEX_KDTREE"]=1;Module["FLANN_INDEX_KMEANS"]=2;Module["FLANN_INDEX_COMPOSITE"]=3;Module["FLANN_INDEX_KDTREE_SINGLE"]=4;Module["FLANN_INDEX_HIERARCHICAL"]=5;Module["FLANN_INDEX_LSH"]=6;Module["FLANN_INDEX_SAVED"]=254;Module["FLANN_INDEX_AUTOTUNED"]=255;Module["FLANN_CENTERS_RANDOM"]=0;Module["FLANN_CENTERS_GONZALES"]=1;Module["FLANN_CENTERS_KMEANSPP"]=2;Module["FLANN_LOG_NONE"]=0;Module["FLANN_LOG_FATAL"]=1;Module["FLANN_LOG_ERROR"]=2;Module["FLANN_LOG_WARN"]=3;Module["FLANN_LOG_INFO"]=4;Module["FLANN_LOG_DEBUG"]=5;Module["FLANN_DIST_EUCLIDEAN"]=1;Module["FLANN_DIST_L2"]=1;Module["FLANN_DIST_MANHATTAN"]=2;Module["FLANN_DIST_L1"]=2;Module["FLANN_DIST_MINKOWSKI"]=3;Module["FLANN_DIST_MAX"]=4;Module["FLANN_DIST_HIST_INTERSECT"]=5;Module["FLANN_DIST_HELLINGER"]=6;Module["FLANN_DIST_CHI_SQUARE"]=7;Module["FLANN_DIST_KULLBACK_LEIBLER"]=8;Module["FLANN_DIST_HAMMING"]=9;Module["FLANN_DIST_HAMMING_LUT"]=10;Module["FLANN_DIST_HAMMING_POPCNT"]=11;Module["FLANN_DIST_L2_SIMPLE"]=12;Module["FLANN_NONE"]=-1;Module["FLANN_INT8"]=0;Module["FLANN_INT16"]=1;Module["FLANN_INT32"]=2;Module["FLANN_INT64"]=3;Module["FLANN_UINT8"]=4;Module["FLANN_UINT16"]=5;Module["FLANN_UINT32"]=6;Module["FLANN_UINT64"]=7;Module["FLANN_FLOAT32"]=8;Module["FLANN_FLOAT64"]=9;Module["FLANN_CHECKS_UNLIMITED"]=-1;Module["FLANN_CHECKS_AUTOTUNED"]=-2;((function(){Module["Index"]=(function(indexPtr,datasetPtr){var N,K,that=this;this.getVeclen=(function(){return K});this.getSize=(function(){return N});this.query=(function(query,nn){return that.multiQuery([query],nn)[0]});this.multiQuery=(function(query,nn){if(typeof nn==="undefined"){nn=1}if(!(nn>0&&nn<N)){throw"nn should be in <0, N>"}var dim,Q,nSolutions;var queryHeap,idsHeap,distsHeap;var ids,dists,i,ret;dim=getDimensions(query);if(dim.length!=2){throw"query should be Q x K rectangural matrix of numbers"}if(dim[1]!=K){throw"vector query length should be of same size as index"}Q=dim[0];queryHeap=allocateHeapWords(Q*K);idsHeap=allocateHeapWords(Q*nn);distsHeap=allocateHeapWords(Q*nn);arrayToTyped(Q,K,query,queryHeap.floats);nSolutions=Module.ccall("knnSearch","number",["number","number","number","number","number","number","number"],[indexPtr,queryHeap.ptr,idsHeap.ptr,distsHeap.ptr,nn,Q,K]);if(nSolutions!=Q*nn){throw"couldn't find enough solutions. aborting."}ids=emptyArray(Q,nn);dists=emptyArray(Q,nn);typedToArray(Q,nn,idsHeap.ints,ids);typedToArray(Q,nn,distsHeap.floats,dists);Module._free(queryHeap.ptr);Module._free(idsHeap.ptr);Module._free(distsHeap.ptr);return collateResults(Q,nn,ids,dists)});this.destroy=(function(){ccall("destroyIndex","void",["number"],[indexPtr]);Module._free(datasetPtr)});this.serialize=(function(){var filename=randomFileName();ccall("saveIndex","void",["number","string"],[indexPtr,filename]);var ret=FS.readFile(filename,{encoding:"binary"});ret=arrayBufferToUint8Array(ret.buffer);FS.unlink(filename);return ret});this.getParameters=(function(){var str,pair,it,sol={};str=ccall("indexParameters","string",["number"],[indexPtr]).split(" ");for(it=0;it<str.length;++it){if(str[it]){pair=str[it].split("=");if(pair.length===2){sol[pair[0]]=pair[1]}}}return sol});((function(){N=ccall("indexSize","number",["number"],[indexPtr]);K=ccall("indexVeclen","number",["number"],[indexPtr])}))()});Module["fromDataset"]=(function(dataset,options){var sol,subHeap,dim=[];subHeap=datasetToHeap(dataset,dim);sol=Module.ccall("buildFromDataset","number",["number","number","number","string"],[subHeap.ptr,dim[0],dim[1],buildOptionsString(options)]);if(sol){return new Module["Index"](sol,subHeap.ptr)}else{throw"building from file failed\n"}});Module["fromSerialized"]=(function(dataset,indexContents){var filename,ptr;var datasetSubHeap,datasetDim=[];if(dataset){datasetSubHeap=datasetToHeap(dataset,datasetDim)}else{datasetSubHeap={ptr:0};datasetDim=[0,0]}filename=randomFileName();if(indexContents instanceof ArrayBuffer){indexContents=new Uint8Array(indexContents)}FS.writeFile(filename,indexContents,{encoding:"binary"});indexContents=null;ptr=ccall("buildFromFile","number",["number","number","number","string"],[datasetSubHeap.ptr,datasetDim[0],datasetDim[1],filename]);FS.unlink(filename);if(ptr){return new Module["Index"](ptr,datasetSubHeap.ptr)}else{throw"building from file failed\n"}});function randomFileName(){return"file_"+Math.random().toString().substr(2)}function arrayBufferToUint8Array(src){var dst=new ArrayBuffer(src.byteLength);var view=new Uint8Array(dst);view.set(new Uint8Array(src));return view}function getDimensions(a){var ret,it;if(!(a instanceof Array)){if(typeof a!=="number"){}return[]}if(!a.length)return[0];ret=getDimensions(a[0]);for(it=0;it<a.length;++it){if(ret.length&&a[it].length!==a[0].length){throw"not rectangular."}if(!ret.length&&typeof a[it]!="number"){throw"not all elements are numbers."}}ret.unshift(a.length);return ret}function arrayToTyped(N,M,arr,typed){for(i=0;i<N;++i)for(j=0;j<M;++j)typed[i*M+j]=arr[i][j]}function typedToArray(N,M,typed,arr){for(i=0;i<N;++i)for(j=0;j<M;++j)arr[i][j]=typed[i*M+j]}function emptyArray(N,M){var ret=Array(N),it,jt;for(it=0;it<N;++it){ret[it]=Array(M);for(jt=0;jt<M;++jt){ret[it][jt]=0}}return ret}function allocateHeapWords(count){ptr=Module._malloc(count*4);if(ptr%4!==0){throw"internal error. I expected malloc to return 4byte aligned ptr"}off=ptr/4;return{floats:Module.HEAPF32.subarray(off,off+count),ints:Module.HEAPU32.subarray(off,off+count),ptr:ptr}}function collateResults(Q,nn,ids,dists){var ret=Array(Q),i,j;for(i=0;i<Q;++i){ret[i]={};for(j=0;j<nn;++j){ret[i][ids[i][j]]=dists[i][j]}}return ret}function buildOptionsString(options){if(!options){return""}var str=[];for(var key in options){str.push(key+"="+options[key])}return str.join(" ")}function datasetToHeap(dataset,dim){var subHeap;Array.prototype.push.apply(dim,getDimensions(dataset));if(dim.length!=2){throw"dataset should be N x K rectangural matrix of numbers"}subHeap=allocateHeapWords(dim[0]*dim[1]);arrayToTyped(dim[0],dim[1],dataset,subHeap.floats);return subHeap}}))();var Module;if(!Module)Module=(typeof Module!=="undefined"?Module:null)||{};var moduleOverrides={};for(var key in Module){if(Module.hasOwnProperty(key)){moduleOverrides[key]=Module[key]}}var ENVIRONMENT_IS_NODE=typeof process==="object"&&typeof require==="function";var ENVIRONMENT_IS_WEB=typeof window==="object";var ENVIRONMENT_IS_WORKER=typeof importScripts==="function";var ENVIRONMENT_IS_SHELL=!ENVIRONMENT_IS_WEB&&!ENVIRONMENT_IS_NODE&&!ENVIRONMENT_IS_WORKER;if(ENVIRONMENT_IS_NODE){if(!Module["print"])Module["print"]=function print(x){process["stdout"].write(x+"\n")};if(!Module["printErr"])Module["printErr"]=function printErr(x){process["stderr"].write(x+"\n")};var nodeFS=require("fs");var nodePath=require("path");Module["read"]=function read(filename,binary){filename=nodePath["normalize"](filename);var ret=nodeFS["readFileSync"](filename);if(!ret&&filename!=nodePath["resolve"](filename)){filename=path.join(__dirname,"..","src",filename);ret=nodeFS["readFileSync"](filename)}if(ret&&!binary)ret=ret.toString();return ret};Module["readBinary"]=function readBinary(filename){return Module["read"](filename,true)};Module["load"]=function load(f){globalEval(read(f))};Module["thisProgram"]=process["argv"][1];Module["arguments"]=process["argv"].slice(2);module["exports"]=Module}else if(ENVIRONMENT_IS_SHELL){if(!Module["print"])Module["print"]=print;if(typeof printErr!="undefined")Module["printErr"]=printErr;if(typeof read!="undefined"){Module["read"]=read}else{Module["read"]=function read(){throw"no read() available (jsc?)"}}Module["readBinary"]=function readBinary(f){return read(f,"binary")};if(typeof scriptArgs!="undefined"){Module["arguments"]=scriptArgs}else if(typeof arguments!="undefined"){Module["arguments"]=arguments}this["Module"]=Module}else if(ENVIRONMENT_IS_WEB||ENVIRONMENT_IS_WORKER){Module["read"]=function read(url){var xhr=new XMLHttpRequest;xhr.open("GET",url,false);xhr.send(null);return xhr.responseText};if(typeof arguments!="undefined"){Module["arguments"]=arguments}if(typeof console!=="undefined"){if(!Module["print"])Module["print"]=function print(x){console.log(x)};if(!Module["printErr"])Module["printErr"]=function printErr(x){console.log(x)}}else{var TRY_USE_DUMP=false;if(!Module["print"])Module["print"]=TRY_USE_DUMP&&typeof dump!=="undefined"?(function(x){dump(x)}):(function(x){})}if(ENVIRONMENT_IS_WEB){window["Module"]=Module}else{Module["load"]=importScripts}}else{throw"Unknown runtime environment. Where are we?"}function globalEval(x){eval.call(null,x)}if(!Module["load"]=="undefined"&&Module["read"]){Module["load"]=function load(f){globalEval(Module["read"](f))}}if(!Module["print"]){Module["print"]=(function(){})}if(!Module["printErr"]){Module["printErr"]=Module["print"]}if(!Module["arguments"]){Module["arguments"]=[]}Module.print=Module["print"];Module.printErr=Module["printErr"];Module["preRun"]=[];Module["postRun"]=[];for(var key in moduleOverrides){if(moduleOverrides.hasOwnProperty(key)){Module[key]=moduleOverrides[key]}}var Runtime={setTempRet0:(function(value){tempRet0=value}),getTempRet0:(function(){return tempRet0}),stackSave:(function(){return STACKTOP}),stackRestore:(function(stackTop){STACKTOP=stackTop}),forceAlign:(function(target,quantum){quantum=quantum||4;if(quantum==1)return target;if(isNumber(target)&&isNumber(quantum)){return Math.ceil(target/quantum)*quantum}else if(isNumber(quantum)&&isPowerOfTwo(quantum)){return"((("+target+")+"+(quantum-1)+")&"+ -quantum+")"}return"Math.ceil(("+target+")/"+quantum+")*"+quantum}),isNumberType:(function(type){return type in Runtime.INT_TYPES||type in Runtime.FLOAT_TYPES}),isPointerType:function isPointerType(type){return type[type.length-1]=="*"},isStructType:function isStructType(type){if(isPointerType(type))return false;if(isArrayType(type))return true;if(/<?\{ ?[^}]* ?\}>?/.test(type))return true;return type[0]=="%"},INT_TYPES:{"i1":0,"i8":0,"i16":0,"i32":0,"i64":0},FLOAT_TYPES:{"float":0,"double":0},or64:(function(x,y){var l=x|0|(y|0);var h=(Math.round(x/4294967296)|Math.round(y/4294967296))*4294967296;return l+h}),and64:(function(x,y){var l=(x|0)&(y|0);var h=(Math.round(x/4294967296)&Math.round(y/4294967296))*4294967296;return l+h}),xor64:(function(x,y){var l=(x|0)^(y|0);var h=(Math.round(x/4294967296)^Math.round(y/4294967296))*4294967296;return l+h}),getNativeTypeSize:(function(type){switch(type){case"i1":case"i8":return 1;case"i16":return 2;case"i32":return 4;case"i64":return 8;case"float":return 4;case"double":return 8;default:{if(type[type.length-1]==="*"){return Runtime.QUANTUM_SIZE}else if(type[0]==="i"){var bits=parseInt(type.substr(1));assert(bits%8===0);return bits/8}else{return 0}}}}),getNativeFieldSize:(function(type){return Math.max(Runtime.getNativeTypeSize(type),Runtime.QUANTUM_SIZE)}),dedup:function dedup(items,ident){var seen={};if(ident){return items.filter((function(item){if(seen[item[ident]])return false;seen[item[ident]]=true;return true}))}else{return items.filter((function(item){if(seen[item])return false;seen[item]=true;return true}))}},set:function set(){var args=typeof arguments[0]==="object"?arguments[0]:arguments;var ret={};for(var i=0;i<args.length;i++){ret[args[i]]=0}return ret},STACK_ALIGN:8,getAlignSize:(function(type,size,vararg){if(!vararg&&(type=="i64"||type=="double"))return 8;if(!type)return Math.min(size,8);return Math.min(size||(type?Runtime.getNativeFieldSize(type):0),Runtime.QUANTUM_SIZE)}),calculateStructAlignment:function calculateStructAlignment(type){type.flatSize=0;type.alignSize=0;var diffs=[];var prev=-1;var index=0;type.flatIndexes=type.fields.map((function(field){index++;var size,alignSize;if(Runtime.isNumberType(field)||Runtime.isPointerType(field)){size=Runtime.getNativeTypeSize(field);alignSize=Runtime.getAlignSize(field,size)}else if(Runtime.isStructType(field)){if(field[1]==="0"){size=0;if(Types.types[field]){alignSize=Runtime.getAlignSize(null,Types.types[field].alignSize)}else{alignSize=type.alignSize||QUANTUM_SIZE}}else{size=Types.types[field].flatSize;alignSize=Runtime.getAlignSize(null,Types.types[field].alignSize)}}else if(field[0]=="b"){size=field.substr(1)|0;alignSize=1}else if(field[0]==="<"){size=alignSize=Types.types[field].flatSize}else if(field[0]==="i"){size=alignSize=parseInt(field.substr(1))/8;assert(size%1===0,"cannot handle non-byte-size field "+field)}else{assert(false,"invalid type for calculateStructAlignment")}if(type.packed)alignSize=1;type.alignSize=Math.max(type.alignSize,alignSize);var curr=Runtime.alignMemory(type.flatSize,alignSize);type.flatSize=curr+size;if(prev>=0){diffs.push(curr-prev)}prev=curr;return curr}));if(type.name_&&type.name_[0]==="["){type.flatSize=parseInt(type.name_.substr(1))*type.flatSize/2}type.flatSize=Runtime.alignMemory(type.flatSize,type.alignSize);if(diffs.length==0){type.flatFactor=type.flatSize}else if(Runtime.dedup(diffs).length==1){type.flatFactor=diffs[0]}type.needsFlattening=type.flatFactor!=1;return type.flatIndexes},generateStructInfo:(function(struct,typeName,offset){var type,alignment;if(typeName){offset=offset||0;type=(typeof Types==="undefined"?Runtime.typeInfo:Types.types)[typeName];if(!type)return null;if(type.fields.length!=struct.length){printErr("Number of named fields must match the type for "+typeName+": possibly duplicate struct names. Cannot return structInfo");return null}alignment=type.flatIndexes}else{var type={fields:struct.map((function(item){return item[0]}))};alignment=Runtime.calculateStructAlignment(type)}var ret={__size__:type.flatSize};if(typeName){struct.forEach((function(item,i){if(typeof item==="string"){ret[item]=alignment[i]+offset}else{var key;for(var k in item)key=k;ret[key]=Runtime.generateStructInfo(item[key],type.fields[i],alignment[i])}}))}else{struct.forEach((function(item,i){ret[item[1]]=alignment[i]}))}return ret}),dynCall:(function(sig,ptr,args){if(args&&args.length){if(!args.splice)args=Array.prototype.slice.call(args);args.splice(0,0,ptr);return Module["dynCall_"+sig].apply(null,args)}else{return Module["dynCall_"+sig].call(null,ptr)}}),functionPointers:[],addFunction:(function(func){for(var i=0;i<Runtime.functionPointers.length;i++){if(!Runtime.functionPointers[i]){Runtime.functionPointers[i]=func;return 2*(1+i)}}throw"Finished up all reserved function pointers. Use a higher value for RESERVED_FUNCTION_POINTERS."}),removeFunction:(function(index){Runtime.functionPointers[(index-2)/2]=null}),getAsmConst:(function(code,numArgs){if(!Runtime.asmConstCache)Runtime.asmConstCache={};var func=Runtime.asmConstCache[code];if(func)return func;var args=[];for(var i=0;i<numArgs;i++){args.push(String.fromCharCode(36)+i)}var source=Pointer_stringify(code);if(source[0]==='"'){if(source.indexOf('"',1)===source.length-1){source=source.substr(1,source.length-2)}else{abort("invalid EM_ASM input |"+source+"|. Please use EM_ASM(..code..) (no quotes) or EM_ASM({ ..code($0).. }, input) (to input values)")}}try{var evalled=eval("(function("+args.join(",")+"){ "+source+" })")}catch(e){Module.printErr("error in executing inline EM_ASM code: "+e+" on: \n\n"+source+"\n\nwith args |"+args+"| (make sure to use the right one out of EM_ASM, EM_ASM_ARGS, etc.)");throw e}return Runtime.asmConstCache[code]=evalled}),warnOnce:(function(text){if(!Runtime.warnOnce.shown)Runtime.warnOnce.shown={};if(!Runtime.warnOnce.shown[text]){Runtime.warnOnce.shown[text]=1;Module.printErr(text)}}),funcWrappers:{},getFuncWrapper:(function(func,sig){assert(sig);if(!Runtime.funcWrappers[func]){Runtime.funcWrappers[func]=function dynCall_wrapper(){return Runtime.dynCall(sig,func,arguments)}}return Runtime.funcWrappers[func]}),UTF8Processor:(function(){var buffer=[];var needed=0;this.processCChar=(function(code){code=code&255;if(buffer.length==0){if((code&128)==0){return String.fromCharCode(code)}buffer.push(code);if((code&224)==192){needed=1}else if((code&240)==224){needed=2}else{needed=3}return""}if(needed){buffer.push(code);needed--;if(needed>0)return""}var c1=buffer[0];var c2=buffer[1];var c3=buffer[2];var c4=buffer[3];var ret;if(buffer.length==2){ret=String.fromCharCode((c1&31)<<6|c2&63)}else if(buffer.length==3){ret=String.fromCharCode((c1&15)<<12|(c2&63)<<6|c3&63)}else{var codePoint=(c1&7)<<18|(c2&63)<<12|(c3&63)<<6|c4&63;ret=String.fromCharCode(Math.floor((codePoint-65536)/1024)+55296,(codePoint-65536)%1024+56320)}buffer.length=0;return ret});this.processJSString=function processJSString(string){string=unescape(encodeURIComponent(string));var ret=[];for(var i=0;i<string.length;i++){ret.push(string.charCodeAt(i))}return ret}}),getCompilerSetting:(function(name){throw"You must build with -s RETAIN_COMPILER_SETTINGS=1 for Runtime.getCompilerSetting or emscripten_get_compiler_setting to work"}),stackAlloc:(function(size){var ret=STACKTOP;STACKTOP=STACKTOP+size|0;STACKTOP=STACKTOP+7&-8;return ret}),staticAlloc:(function(size){var ret=STATICTOP;STATICTOP=STATICTOP+size|0;STATICTOP=STATICTOP+7&-8;return ret}),dynamicAlloc:(function(size){var ret=DYNAMICTOP;DYNAMICTOP=DYNAMICTOP+size|0;DYNAMICTOP=DYNAMICTOP+7&-8;if(DYNAMICTOP>=TOTAL_MEMORY)enlargeMemory();return ret}),alignMemory:(function(size,quantum){var ret=size=Math.ceil(size/(quantum?quantum:8))*(quantum?quantum:8);return ret}),makeBigInt:(function(low,high,unsigned){var ret=unsigned?+(low>>>0)+ +(high>>>0)*+4294967296:+(low>>>0)+ +(high|0)*+4294967296;return ret}),GLOBAL_BASE:8,QUANTUM_SIZE:4,__dummy__:0};Module["Runtime"]=Runtime;var __THREW__=0;var ABORT=false;var EXITSTATUS=0;var undef=0;var tempValue,tempInt,tempBigInt,tempInt2,tempBigInt2,tempPair,tempBigIntI,tempBigIntR,tempBigIntS,tempBigIntP,tempBigIntD,tempDouble,tempFloat;var tempI64,tempI64b;var tempRet0,tempRet1,tempRet2,tempRet3,tempRet4,tempRet5,tempRet6,tempRet7,tempRet8,tempRet9;function assert(condition,text){if(!condition){abort("Assertion failed: "+text)}}var globalScope=this;function getCFunc(ident){var func=Module["_"+ident];if(!func){try{func=eval("_"+ident)}catch(e){}}assert(func,"Cannot call unknown function "+ident+" (perhaps LLVM optimizations or closure removed it?)");return func}var cwrap,ccall;((function(){var stack=0;var JSfuncs={"stackSave":(function(){stack=Runtime.stackSave()}),"stackRestore":(function(){Runtime.stackRestore(stack)}),"arrayToC":(function(arr){var ret=Runtime.stackAlloc(arr.length);writeArrayToMemory(arr,ret);return ret}),"stringToC":(function(str){var ret=0;if(str!==null&&str!==undefined&&str!==0){ret=Runtime.stackAlloc(str.length+1);writeStringToMemory(str,ret)}return ret})};var toC={"string":JSfuncs["stringToC"],"array":JSfuncs["arrayToC"]};ccall=function ccallFunc(ident,returnType,argTypes,args){var func=getCFunc(ident);var cArgs=[];if(args){for(var i=0;i<args.length;i++){var converter=toC[argTypes[i]];if(converter){if(stack===0)stack=Runtime.stackSave();cArgs[i]=converter(args[i])}else{cArgs[i]=args[i]}}}var ret=func.apply(null,cArgs);if(returnType==="string")ret=Pointer_stringify(ret);if(stack!==0)JSfuncs["stackRestore"]();return ret};var sourceRegex=/^function\s*\(([^)]*)\)\s*{\s*([^*]*?)[\s;]*(?:return\s*(.*?)[;\s]*)?}$/;function parseJSFunc(jsfunc){var parsed=jsfunc.toString().match(sourceRegex).slice(1);return{arguments:parsed[0],body:parsed[1],returnValue:parsed[2]}}var JSsource={};for(var fun in JSfuncs){if(JSfuncs.hasOwnProperty(fun)){JSsource[fun]=parseJSFunc(JSfuncs[fun])}}cwrap=function cwrap(ident,returnType,argTypes){var cfunc=getCFunc(ident);var numericArgs=argTypes.every((function(type){return type==="number"}));var numericRet=returnType!=="string";if(numericRet&&numericArgs){return cfunc}var argNames=argTypes.map((function(x,i){return"$"+i}));var funcstr="(function("+argNames.join(",")+") {";var nargs=argTypes.length;if(!numericArgs){funcstr+=JSsource["stackSave"].body+";";for(var i=0;i<nargs;i++){var arg=argNames[i],type=argTypes[i];if(type==="number")continue;var convertCode=JSsource[type+"ToC"];funcstr+="var "+convertCode.arguments+" = "+arg+";";funcstr+=convertCode.body+";";funcstr+=arg+"="+convertCode.returnValue+";"}}var cfuncname=parseJSFunc((function(){return cfunc})).returnValue;funcstr+="var ret = "+cfuncname+"("+argNames.join(",")+");";if(!numericRet){var strgfy=parseJSFunc((function(){return Pointer_stringify})).returnValue;funcstr+="ret = "+strgfy+"(ret);"}if(!numericArgs){funcstr+=JSsource["stackRestore"].body+";"}funcstr+="return ret})";return eval(funcstr)}}))();Module["cwrap"]=cwrap;Module["ccall"]=ccall;function setValue(ptr,value,type,noSafe){type=type||"i8";if(type.charAt(type.length-1)==="*")type="i32";switch(type){case"i1":HEAP8[ptr>>0]=value;break;case"i8":HEAP8[ptr>>0]=value;break;case"i16":HEAP16[ptr>>1]=value;break;case"i32":HEAP32[ptr>>2]=value;break;case"i64":tempI64=[value>>>0,(tempDouble=value,+Math_abs(tempDouble)>=+1?tempDouble>+0?(Math_min(+Math_floor(tempDouble/+4294967296),+4294967295)|0)>>>0:~~+Math_ceil((tempDouble- +(~~tempDouble>>>0))/+4294967296)>>>0:0)],HEAP32[ptr>>2]=tempI64[0],HEAP32[ptr+4>>2]=tempI64[1];break;case"float":HEAPF32[ptr>>2]=value;break;case"double":HEAPF64[ptr>>3]=value;break;default:abort("invalid type for setValue: "+type)}}Module["setValue"]=setValue;function getValue(ptr,type,noSafe){type=type||"i8";if(type.charAt(type.length-1)==="*")type="i32";switch(type){case"i1":return HEAP8[ptr>>0];case"i8":return HEAP8[ptr>>0];case"i16":return HEAP16[ptr>>1];case"i32":return HEAP32[ptr>>2];case"i64":return HEAP32[ptr>>2];case"float":return HEAPF32[ptr>>2];case"double":return HEAPF64[ptr>>3];default:abort("invalid type for setValue: "+type)}return null}Module["getValue"]=getValue;var ALLOC_NORMAL=0;var ALLOC_STACK=1;var ALLOC_STATIC=2;var ALLOC_DYNAMIC=3;var ALLOC_NONE=4;Module["ALLOC_NORMAL"]=ALLOC_NORMAL;Module["ALLOC_STACK"]=ALLOC_STACK;Module["ALLOC_STATIC"]=ALLOC_STATIC;Module["ALLOC_DYNAMIC"]=ALLOC_DYNAMIC;Module["ALLOC_NONE"]=ALLOC_NONE;function allocate(slab,types,allocator,ptr){var zeroinit,size;if(typeof slab==="number"){zeroinit=true;size=slab}else{zeroinit=false;size=slab.length}var singleType=typeof types==="string"?types:null;var ret;if(allocator==ALLOC_NONE){ret=ptr}else{ret=[_malloc,Runtime.stackAlloc,Runtime.staticAlloc,Runtime.dynamicAlloc][allocator===undefined?ALLOC_STATIC:allocator](Math.max(size,singleType?1:types.length))}if(zeroinit){var ptr=ret,stop;assert((ret&3)==0);stop=ret+(size&~3);for(;ptr<stop;ptr+=4){HEAP32[ptr>>2]=0}stop=ret+size;while(ptr<stop){HEAP8[ptr++>>0]=0}return ret}if(singleType==="i8"){if(slab.subarray||slab.slice){HEAPU8.set(slab,ret)}else{HEAPU8.set(new Uint8Array(slab),ret)}return ret}var i=0,type,typeSize,previousType;while(i<size){var curr=slab[i];if(typeof curr==="function"){curr=Runtime.getFunctionIndex(curr)}type=singleType||types[i];if(type===0){i++;continue}if(type=="i64")type="i32";setValue(ret+i,curr,type);if(previousType!==type){typeSize=Runtime.getNativeTypeSize(type);previousType=type}i+=typeSize}return ret}Module["allocate"]=allocate;function Pointer_stringify(ptr,length){var hasUtf=false;var t;var i=0;while(1){t=HEAPU8[ptr+i>>0];if(t>=128)hasUtf=true;else if(t==0&&!length)break;i++;if(length&&i==length)break}if(!length)length=i;var ret="";if(!hasUtf){var MAX_CHUNK=1024;var curr;while(length>0){curr=String.fromCharCode.apply(String,HEAPU8.subarray(ptr,ptr+Math.min(length,MAX_CHUNK)));ret=ret?ret+curr:curr;ptr+=MAX_CHUNK;length-=MAX_CHUNK}return ret}var utf8=new Runtime.UTF8Processor;for(i=0;i<length;i++){t=HEAPU8[ptr+i>>0];ret+=utf8.processCChar(t)}return ret}Module["Pointer_stringify"]=Pointer_stringify;function UTF16ToString(ptr){var i=0;var str="";while(1){var codeUnit=HEAP16[ptr+i*2>>1];if(codeUnit==0)return str;++i;str+=String.fromCharCode(codeUnit)}}Module["UTF16ToString"]=UTF16ToString;function stringToUTF16(str,outPtr){for(var i=0;i<str.length;++i){var codeUnit=str.charCodeAt(i);HEAP16[outPtr+i*2>>1]=codeUnit}HEAP16[outPtr+str.length*2>>1]=0}Module["stringToUTF16"]=stringToUTF16;function UTF32ToString(ptr){var i=0;var str="";while(1){var utf32=HEAP32[ptr+i*4>>2];if(utf32==0)return str;++i;if(utf32>=65536){var ch=utf32-65536;str+=String.fromCharCode(55296|ch>>10,56320|ch&1023)}else{str+=String.fromCharCode(utf32)}}}Module["UTF32ToString"]=UTF32ToString;function stringToUTF32(str,outPtr){var iChar=0;for(var iCodeUnit=0;iCodeUnit<str.length;++iCodeUnit){var codeUnit=str.charCodeAt(iCodeUnit);if(codeUnit>=55296&&codeUnit<=57343){var trailSurrogate=str.charCodeAt(++iCodeUnit);codeUnit=65536+((codeUnit&1023)<<10)|trailSurrogate&1023}HEAP32[outPtr+iChar*4>>2]=codeUnit;++iChar}HEAP32[outPtr+iChar*4>>2]=0}Module["stringToUTF32"]=stringToUTF32;function demangle(func){var i=3;var basicTypes={"v":"void","b":"bool","c":"char","s":"short","i":"int","l":"long","f":"float","d":"double","w":"wchar_t","a":"signed char","h":"unsigned char","t":"unsigned short","j":"unsigned int","m":"unsigned long","x":"long long","y":"unsigned long long","z":"..."};var subs=[];var first=true;function dump(x){if(x)Module.print(x);Module.print(func);var pre="";for(var a=0;a<i;a++)pre+=" ";Module.print(pre+"^")}function parseNested(){i++;if(func[i]==="K")i++;var parts=[];while(func[i]!=="E"){if(func[i]==="S"){i++;var next=func.indexOf("_",i);var num=func.substring(i,next)||0;parts.push(subs[num]||"?");i=next+1;continue}if(func[i]==="C"){parts.push(parts[parts.length-1]);i+=2;continue}var size=parseInt(func.substr(i));var pre=size.toString().length;if(!size||!pre){i--;break}var curr=func.substr(i+pre,size);parts.push(curr);subs.push(curr);i+=pre+size}i++;return parts}function parse(rawList,limit,allowVoid){limit=limit||Infinity;var ret="",list=[];function flushList(){return"("+list.join(", ")+")"}var name;if(func[i]==="N"){name=parseNested().join("::");limit--;if(limit===0)return rawList?[name]:name}else{if(func[i]==="K"||first&&func[i]==="L")i++;var size=parseInt(func.substr(i));if(size){var pre=size.toString().length;name=func.substr(i+pre,size);i+=pre+size}}first=false;if(func[i]==="I"){i++;var iList=parse(true);var iRet=parse(true,1,true);ret+=iRet[0]+" "+name+"<"+iList.join(", ")+">"}else{ret=name}paramLoop:while(i<func.length&&limit-->0){var c=func[i++];if(c in basicTypes){list.push(basicTypes[c])}else{switch(c){case"P":list.push(parse(true,1,true)[0]+"*");break;case"R":list.push(parse(true,1,true)[0]+"&");break;case"L":{i++;var end=func.indexOf("E",i);var size=end-i;list.push(func.substr(i,size));i+=size+2;break};case"A":{var size=parseInt(func.substr(i));i+=size.toString().length;if(func[i]!=="_")throw"?";i++;list.push(parse(true,1,true)[0]+" ["+size+"]");break};case"E":break paramLoop;default:ret+="?"+c;break paramLoop}}}if(!allowVoid&&list.length===1&&list[0]==="void")list=[];if(rawList){if(ret){list.push(ret+"?")}return list}else{return ret+flushList()}}try{if(func=="Object._main"||func=="_main"){return"main()"}if(typeof func==="number")func=Pointer_stringify(func);if(func[0]!=="_")return func;if(func[1]!=="_")return func;if(func[2]!=="Z")return func;switch(func[3]){case"n":return"operator new()";case"d":return"operator delete()"}return parse()}catch(e){return func}}function demangleAll(text){return text.replace(/__Z[\w\d_]+/g,(function(x){var y=demangle(x);return x===y?x:x+" ["+y+"]"}))}function stackTrace(){var stack=(new Error).stack;return stack?demangleAll(stack):"(no stack trace available)"}var PAGE_SIZE=4096;function alignMemoryPage(x){return x+4095&-4096}var HEAP;var HEAP8,HEAPU8,HEAP16,HEAPU16,HEAP32,HEAPU32,HEAPF32,HEAPF64;var STATIC_BASE=0,STATICTOP=0,staticSealed=false;var STACK_BASE=0,STACKTOP=0,STACK_MAX=0;var DYNAMIC_BASE=0,DYNAMICTOP=0;function enlargeMemory(){while(TOTAL_MEMORY<=DYNAMICTOP){TOTAL_MEMORY=alignMemoryPage(2*TOTAL_MEMORY)}assert(TOTAL_MEMORY<=Math.pow(2,30));var oldHEAP8=HEAP8;var buffer=new ArrayBuffer(TOTAL_MEMORY);Module["HEAP8"]=HEAP8=new Int8Array(buffer);Module["HEAP16"]=HEAP16=new Int16Array(buffer);Module["HEAP32"]=HEAP32=new Int32Array(buffer);Module["HEAPU8"]=HEAPU8=new Uint8Array(buffer);Module["HEAPU16"]=HEAPU16=new Uint16Array(buffer);Module["HEAPU32"]=HEAPU32=new Uint32Array(buffer);Module["HEAPF32"]=HEAPF32=new Float32Array(buffer);Module["HEAPF64"]=HEAPF64=new Float64Array(buffer);HEAP8.set(oldHEAP8);_emscripten_replace_memory(HEAP8,HEAP16,HEAP32,HEAPU8,HEAPU16,HEAPU32,HEAPF32,HEAPF64)}var TOTAL_STACK=Module["TOTAL_STACK"]||5242880;var TOTAL_MEMORY=Module["TOTAL_MEMORY"]||16777216;var FAST_MEMORY=Module["FAST_MEMORY"]||2097152;var totalMemory=4096;while(totalMemory<TOTAL_MEMORY||totalMemory<2*TOTAL_STACK){if(totalMemory<16*1024*1024){totalMemory*=2}else{totalMemory+=16*1024*1024}}if(totalMemory!==TOTAL_MEMORY){Module.printErr("increasing TOTAL_MEMORY to "+totalMemory+" to be more reasonable");TOTAL_MEMORY=totalMemory}assert(typeof Int32Array!=="undefined"&&typeof Float64Array!=="undefined"&&!!(new Int32Array(1))["subarray"]&&!!(new Int32Array(1))["set"],"JS engine does not provide full typed array support");var buffer=new ArrayBuffer(TOTAL_MEMORY);HEAP8=new Int8Array(buffer);HEAP16=new Int16Array(buffer);HEAP32=new Int32Array(buffer);HEAPU8=new Uint8Array(buffer);HEAPU16=new Uint16Array(buffer);HEAPU32=new Uint32Array(buffer);HEAPF32=new Float32Array(buffer);HEAPF64=new Float64Array(buffer);HEAP32[0]=255;assert(HEAPU8[0]===255&&HEAPU8[3]===0,"Typed arrays 2 must be run on a little-endian system");Module["HEAP"]=HEAP;Module["HEAP8"]=HEAP8;Module["HEAP16"]=HEAP16;Module["HEAP32"]=HEAP32;Module["HEAPU8"]=HEAPU8;Module["HEAPU16"]=HEAPU16;Module["HEAPU32"]=HEAPU32;Module["HEAPF32"]=HEAPF32;Module["HEAPF64"]=HEAPF64;function callRuntimeCallbacks(callbacks){while(callbacks.length>0){var callback=callbacks.shift();if(typeof callback=="function"){callback();continue}var func=callback.func;if(typeof func==="number"){if(callback.arg===undefined){Runtime.dynCall("v",func)}else{Runtime.dynCall("vi",func,[callback.arg])}}else{func(callback.arg===undefined?null:callback.arg)}}}var __ATPRERUN__=[];var __ATINIT__=[];var __ATMAIN__=[];var __ATEXIT__=[];var __ATPOSTRUN__=[];var runtimeInitialized=false;function preRun(){if(Module["preRun"]){if(typeof Module["preRun"]=="function")Module["preRun"]=[Module["preRun"]];while(Module["preRun"].length){addOnPreRun(Module["preRun"].shift())}}callRuntimeCallbacks(__ATPRERUN__)}function ensureInitRuntime(){if(runtimeInitialized)return;runtimeInitialized=true;callRuntimeCallbacks(__ATINIT__)}function preMain(){callRuntimeCallbacks(__ATMAIN__)}function exitRuntime(){callRuntimeCallbacks(__ATEXIT__);runtimeInitialized=false}function postRun(){if(Module["postRun"]){if(typeof Module["postRun"]=="function")Module["postRun"]=[Module["postRun"]];while(Module["postRun"].length){addOnPostRun(Module["postRun"].shift())}}callRuntimeCallbacks(__ATPOSTRUN__)}function addOnPreRun(cb){__ATPRERUN__.unshift(cb)}Module["addOnPreRun"]=Module.addOnPreRun=addOnPreRun;function addOnInit(cb){__ATINIT__.unshift(cb)}Module["addOnInit"]=Module.addOnInit=addOnInit;function addOnPreMain(cb){__ATMAIN__.unshift(cb)}Module["addOnPreMain"]=Module.addOnPreMain=addOnPreMain;function addOnExit(cb){__ATEXIT__.unshift(cb)}Module["addOnExit"]=Module.addOnExit=addOnExit;function addOnPostRun(cb){__ATPOSTRUN__.unshift(cb)}Module["addOnPostRun"]=Module.addOnPostRun=addOnPostRun;function intArrayFromString(stringy,dontAddNull,length){var ret=(new Runtime.UTF8Processor).processJSString(stringy);if(length){ret.length=length}if(!dontAddNull){ret.push(0)}return ret}Module["intArrayFromString"]=intArrayFromString;function intArrayToString(array){var ret=[];for(var i=0;i<array.length;i++){var chr=array[i];if(chr>255){chr&=255}ret.push(String.fromCharCode(chr))}return ret.join("")}Module["intArrayToString"]=intArrayToString;function writeStringToMemory(string,buffer,dontAddNull){var array=intArrayFromString(string,dontAddNull);var i=0;while(i<array.length){var chr=array[i];HEAP8[buffer+i>>0]=chr;i=i+1}}Module["writeStringToMemory"]=writeStringToMemory;function writeArrayToMemory(array,buffer){for(var i=0;i<array.length;i++){HEAP8[buffer+i>>0]=array[i]}}Module["writeArrayToMemory"]=writeArrayToMemory;function writeAsciiToMemory(str,buffer,dontAddNull){for(var i=0;i<str.length;i++){HEAP8[buffer+i>>0]=str.charCodeAt(i)}if(!dontAddNull)HEAP8[buffer+str.length>>0]=0}Module["writeAsciiToMemory"]=writeAsciiToMemory;function unSign(value,bits,ignore){if(value>=0){return value}return bits<=32?2*Math.abs(1<<bits-1)+value:Math.pow(2,bits)+value}function reSign(value,bits,ignore){if(value<=0){return value}var half=bits<=32?Math.abs(1<<bits-1):Math.pow(2,bits-1);if(value>=half&&(bits<=32||value>half)){value=-2*half+value}return value}if(!Math["imul"]||Math["imul"](4294967295,5)!==-5)Math["imul"]=function imul(a,b){var ah=a>>>16;var al=a&65535;var bh=b>>>16;var bl=b&65535;return al*bl+(ah*bl+al*bh<<16)|0};Math.imul=Math["imul"];var Math_abs=Math.abs;var Math_cos=Math.cos;var Math_sin=Math.sin;var Math_tan=Math.tan;var Math_acos=Math.acos;var Math_asin=Math.asin;var Math_atan=Math.atan;var Math_atan2=Math.atan2;var Math_exp=Math.exp;var Math_log=Math.log;var Math_sqrt=Math.sqrt;var Math_ceil=Math.ceil;var Math_floor=Math.floor;var Math_pow=Math.pow;var Math_imul=Math.imul;var Math_fround=Math.fround;var Math_min=Math.min;var runDependencies=0;var runDependencyWatcher=null;var dependenciesFulfilled=null;function addRunDependency(id){runDependencies++;if(Module["monitorRunDependencies"]){Module["monitorRunDependencies"](runDependencies)}}Module["addRunDependency"]=addRunDependency;function removeRunDependency(id){runDependencies--;if(Module["monitorRunDependencies"]){Module["monitorRunDependencies"](runDependencies)}if(runDependencies==0){if(runDependencyWatcher!==null){clearInterval(runDependencyWatcher);runDependencyWatcher=null}if(dependenciesFulfilled){var callback=dependenciesFulfilled;dependenciesFulfilled=null;callback()}}}Module["removeRunDependency"]=removeRunDependency;Module["preloadedImages"]={};Module["preloadedAudios"]={};var memoryInitializer=null;var __ZTVN10__cxxabiv117__class_type_infoE=24440;var __ZTIf=24624;var __ZTIi=24592;var __ZTVN10__cxxabiv120__si_class_type_infoE=24720;var __ZTIj=24608;STATIC_BASE=8;STATICTOP=STATIC_BASE+Runtime.alignMemory(26507);__ATINIT__.push({func:(function(){__GLOBAL__I_a()})});allocate([101,120,99,101,112,116,105,111,110,32,119,104,105,108,101,32,98,117,105,108,100,105,110,103,32,102,114,111,109,32,100,97,116,97,115,101,116,58,32,37,115,10,0,0,0,0,0,0,101,120,99,101,112,116,105,111,110,32,119,104,105,108,101,32,98,117,105,108,100,105,110,103,32,102,114,111,109,32,102,105,108,101,58,32,37,115,10,0,101,120,99,101,112,116,105,111,110,32,119,104,105,108,101,32,115,97,118,105,110,103,58,32,37,115,10,0,0,0,0,0,101,120,99,101,112,116,105,111,110,32,119,104,105,108,101,32,115,101,97,114,99,104,105,110,103,58,32,37,115,10,0,0,101,120,99,101,112,116,105,111,110,32,119,104,105,108,101,32,103,101,116,116,105,110,103,32,112,97,114,97,109,97,115,58,32,37,115,10,0,0,0,0,119,98,0,0,0,0,0,0,67,97,110,110,111,116,32,111,112,101,110,32,102,105,108,101,0,0,0,0,0,0,0,0,78,53,102,108,97,110,110,49,52,70,76,65,78,78,69,120,99,101,112,116,105,111,110,69,0,0,0,0,0,0,0,0,152,96,0,0,232,0,0,0,48,52,0,0,0,0,0,0,0,0,0,0,8,1,0,0,1,0,0,0,2,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,112,1,0,0,3,0,0,0,4,0,0,0,97,108,103,111,114,105,116,104,109,0,0,0,0,0,0,0,78,53,102,108,97,110,110,53,73,110,100,101,120,73,78,83,95,50,76,50,73,102,69,69,69,69,0,0,0,0,0,0,128,95,0,0,80,1,0,0,85,110,107,110,111,119,110,32,105,110,100,101,120,32,116,121,112,101,0,0,0,0,0,0,85,110,115,117,112,112,111,114,116,101,100,32,105,110,100,101,120,47,100,105,115,116,97,110,99,101,32,99,111,109,98,105,110,97,116,105,111,110,0,0,0,0,0,0,168,2,0,0,5,0,0,0,6,0,0,0,2,0,0,0,3,0,0,0,4,0,0,0,5,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,6,0,0,0,7,0,0,0,4,0,0,0,1,0,0,0,5,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,8,0,0,0,9,0,0,0,0,0,0,0,116,97,98,108,101,95,110,117,109,98,101,114,0,0,0,0,109,117,108,116,105,95,112,114,111,98,101,95,108,101,118,101,108,0,0,0,0,0,0,0,78,53,102,108,97,110,110,56,76,115,104,73,110,100,101,120,73,78,83,95,50,76,50,73,102,69,69,69,69,0,0,0,78,53,102,108,97,110,110,55,78,78,73,110,100,101,120,73,78,83,95,50,76,50,73,102,69,69,69,69,0,0,0,0,78,53,102,108,97,110,110,57,73,110,100,101,120,66,97,115,101,69,0,0,0,0,0,0,128,95,0,0,120,2,0,0,152,96,0,0,88,2,0,0,144,2,0,0,0,0,0,0,152,96,0,0,56,2,0,0,152,2,0,0,0,0,0,0,76,83,72,32,105,115,32,110,111,116,32,105,109,112,108,101,109,101,110,116,101,100,32,102,111,114,32,116,104,97,116,32,116,121,112,101,0,0,0,0,113,117,101,114,105,101,115,46,99,111,108,115,32,61,61,32,118,101,99,108,101,110,95,0,102,108,97,110,110,45,115,114,99,47,115,114,99,47,99,112,112,47,102,108,97,110,110,47,97,108,103,111,114,105,116,104,109,115,47,108,115,104,95,105,110,100,101,120,46,104,0,0,107,110,110,83,101,97,114,99,104,0,0,0,0,0,0,0,105,110,100,105,99,101,115,46,114,111,119,115,32,62,61,32,113,117,101,114,105,101,115,46,114,111,119,115,0,0,0,0,100,105,115,116,115,46,114,111,119,115,32,62,61,32,113,117,101,114,105,101,115,46,114,111,119,115,0,0,0,0,0,0,105,110,100,105,99,101,115,46,99,111,108,115,32,62,61,32,107,110,110,0,0,0,0,0,100,105,115,116,115,46,99,111,108,115,32,62,61,32,107,110,110,0,0,0,0,0,0,0,0,0,0,0,8,4,0,0,10,0,0,0,11,0,0,0,7,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,78,53,102,108,97,110,110,49,50,75,78,78,82,101,115,117,108,116,83,101,116,73,102,69,69,0,0,0,0,0,0,0,78,53,102,108,97,110,110,57,82,101,115,117,108,116,83,101,116,73,102,69,69,0,0,0,128,95,0,0,232,3,0,0,152,96,0,0,200,3,0,0,0,4,0,0,0,0,0,0,0,0,0,0,88,4,0,0,12,0,0,0,13,0,0,0,8,0,0,0,1,0,0,0,2,0,0,0,0,0,0,0,78,53,102,108,97,110,110,49,53,85,110,105,113,117,101,82,101,115,117,108,116,83,101,116,73,102,69,69,0,0,0,0,152,96,0,0,56,4,0,0,0,4,0,0,0,0,0,0,0,0,0,0,168,4,0,0,14,0,0,0,15,0,0,0,8,0,0,0,2,0,0,0,2,0,0,0,0,0,0,0,78,53,102,108,97,110,110,49,56,75,78,78,85,110,105,113,117,101,82,101,115,117,108,116,83,101,116,73,102,69,69,0,152,96,0,0,136,4,0,0,88,4,0,0,0,0,0,0,112,111,105,110,116,115,46,99,111,108,115,61,61,118,101,99,108,101,110,95,0,0,0,0,97,100,100,80,111,105,110,116,115,0,0,0,0,0,0,0,0,0,0,0,152,2,0,0,16,0,0,0,17,0,0,0,2,0,0,0,3,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,7,0,0,0,4,0,0,0,2,0,0,0,5,0,0,0,1,0,0,0,2,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,113,117,101,114,105,101,115,46,99,111,108,115,32,61,61,32,118,101,99,108,101,110,40,41,0,0,0,0,0,0,0,0,102,108,97,110,110,45,115,114,99,47,115,114,99,47,99,112,112,47,102,108,97,110,110,47,97,108,103,111,114,105,116,104,109,115,47,110,110,95,105,110,100,101,120,46,104,0,0,0,0,0,0,0,200,5,0,0,18,0,0,0,19,0,0,0,9,0,0,0,3,0,0,0,3,0,0,0,0,0,0,0,78,53,102,108,97,110,110,49,56,75,78,78,83,105,109,112,108,101,82,101,115,117,108,116,83,101,116,73,102,69,69,0,152,96,0,0,168,5,0,0,0,4,0,0,0,0,0,0,0,0,0,0,24,6,0,0,20,0,0,0,21,0,0,0,10,0,0,0,4,0,0,0,4,0,0,0,0,0,0,0,78,53,102,108,97,110,110,49,51,75,78,78,82,101,115,117,108,116,83,101,116,50,73,102,69,69,0,0,0,0,0,0,152,96,0,0,248,5,0,0,0,4,0,0,0,0,0,0,70,117,110,99,116,105,111,110,97,108,105,116,121,32,110,111,116,32,115,117,112,112,111,114,116,101,100,32,98,121,32,116,104,105,115,32,105,110,100,101,120,0,0,0,0,0,0,0,115,97,118,101,95,100,97,116,97,115,101,116,0,0,0,0,83,97,118,101,100,32,105,110,100,101,120,32,100,111,101,115,32,110,111,116,32,99,111,110,116,97,105,110,32,116,104,101,32,100,97,116,97,115,101,116,32,97,110,100,32,110,111,32,100,97,116,97,115,101,116,32,119,97,115,32,112,114,111,118,105,100,101,100,46,0,0,0,78,53,102,108,97,110,110,55,97,110,121,105,109,112,108,49,50,98,97,100,95,97,110,121,95,99,97,115,116,69,0,0,152,96,0,0,176,6,0,0,48,52,0,0,0,0,0,0,67,97,110,110,111,116,32,99,111,110,118,101,114,116,32,39,97,110,121,39,32,118,97,108,117,101,0,0,0,0,0,0,0,0,0,0,208,6,0,0,22,0,0,0,23,0,0,0,1,0,0,0,0,0,0,0,70,76,65,78,78,95,73,78,68,69,88,0,0,0,0,0,49,46,56,46,52,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,0,0,6,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,2,0,0,0,11,0,0,0,12,0,0,0,4,0,0,0,78,53,102,108,97,110,110,55,97,110,121,105,109,112,108,49,54,115,109,97,108,108,95,97,110,121,95,112,111,108,105,99,121,73,106,69,69,0,0,0,78,53,102,108,97,110,110,55,97,110,121,105,109,112,108,50,49,116,121,112,101,100,95,98,97,115,101,95,97,110,121,95,112,111,108,105,99,121,73,106,69,69,0,0,0,0,0,0,78,53,102,108,97,110,110,55,97,110,121,105,109,112,108,49,53,98,97,115,101,95,97,110,121,95,112,111,108,105,99,121,69,0,0,0,0,0,0,0,128,95,0,0,192,7,0,0,152,96,0,0,144,7,0,0,232,7,0,0,0,0,0,0,152,96,0,0,104,7,0,0,240,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208,8,0,0,7,0,0,0,5,0,0,0,6,0,0,0,7,0,0,0,3,0,0,0,13,0,0,0,14,0,0,0,8,0,0,0,78,53,102,108,97,110,110,55,97,110,121,105,109,112,108,49,52,98,105,103,95,97,110,121,95,112,111,108,105,99,121,73,78,83,48,95,57,101,109,112,116,121,95,97,110,121,69,69,69,0,0,0,0,0,0,0,78,53,102,108,97,110,110,55,97,110,121,105,109,112,108,50,49,116,121,112,101,100,95,98,97,115,101,95,97,110,121,95,112,111,108,105,99,121,73,78,83,48,95,57,101,109,112,116,121,95,97,110,121,69,69,69,0,0,0,0,0,0,0,0,152,96,0,0,128,8,0,0,232,7,0,0,0,0,0,0,152,96,0,0,72,8,0,0,192,8,0,0,0,0,0,0,91,101,109,112,116,121,95,97,110,121,93,0,0,0,0,0,78,53,102,108,97,110,110,55,97,110,121,105,109,112,108,57,101,109,112,116,121,95,97,110,121,69,0,0,0,0,0,0,128,95,0,0,240,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,232,9,0,0,8,0,0,0,9,0,0,0,10,0,0,0,11,0,0,0,4,0,0,0,15,0,0,0,16,0,0,0,12,0,0,0,78,53,102,108,97,110,110,55,97,110,121,105,109,112,108,49,54,115,109,97,108,108,95,97,110,121,95,112,111,108,105,99,121,73,78,83,95,49,55,102,108,97,110,110,95,97,108,103,111,114,105,116,104,109,95,116,69,69,69,0,0,0,0,0,78,53,102,108,97,110,110,55,97,110,121,105,109,112,108,50,49,116,121,112,101,100,95,98,97,115,101,95,97,110,121,95,112,111,108,105,99,121,73,78,83,95,49,55,102,108,97,110,110,95,97,108,103,111,114,105,116,104,109,95,116,69,69,69,0,0,0,0,0,0,0,0,152,96,0,0,144,9,0,0,232,7,0,0,0,0,0,0,152,96,0,0,80,9,0,0,216,9,0,0,0,0,0,0,78,53,102,108,97,110,110,49,55,102,108,97,110,110,95,97,108,103,111,114,105,116,104,109,95,116,69,0,0,0,0,0,64,96,0,0,248,9,0,0,69,114,114,111,114,32,108,111,97,100,105,110,103,32,102,114,111,109,32,102,105,108,101,0,73,110,118,97,108,105,100,32,105,110,100,101,120,32,102,105,108,101,44,32,119,114,111,110,103,32,115,105,103,110,97,116,117,114,101,0,0,0,0,0,68,97,116,97,116,121,112,101,32,111,102,32,115,97,118,101,100,32,105,110,100,101,120,32,105,115,32,100,105,102,102,101,114,101,110,116,32,116,104,97,110,32,111,102,32,116,104,101,32,111,110,101,32,116,111,32,98,101,32,99,114,101,97,116,101,100,46,0,0,0,0,0,83,97,118,101,100,32,105,110,100,101,120,32,116,121,112,101,32,105,115,32,100,105,102,102,101,114,101,110,116,32,116,104,101,110,32,116,104,101,32,99,117,114,114,101,110,116,32,105,110,100,101,120,32,116,121,112,101,46,0,0,0,0,0,0,0,0,0,0,176,11,0,0,24,0,0,0,25,0,0,0,2,0,0,0,3,0,0,0,17,0,0,0,18,0,0,0,1,0,0,0,9,0,0,0,10,0,0,0,19,0,0,0,7,0,0,0,4,0,0,0,3,0,0,0,5,0,0,0,1,0,0,0,2,0,0,0,2,0,0,0,26,0,0,0,27,0,0,0,0,0,0,0,98,114,97,110,99,104,105,110,103,0,0,0,0,0,0,0,99,101,110,116,101,114,115,95,105,110,105,116,0,0,0,0,116,114,101,101,115,0,0,0,108,101,97,102,95,109,97,120,95,115,105,122,101,0,0,0,78,53,102,108,97,110,110,50,55,72,105,101,114,97,114,99,104,105,99,97,108,67,108,117,115,116,101,114,105,110,103,73,110,100,101,120,73,78,83,95,50,76,50,73,102,69,69,69,69,0,0,0,0,0,0,0,152,96,0,0,120,11,0,0,152,2,0,0,0,0,0,0,66,114,97,110,99,104,105,110,103,32,102,97,99,116,111,114,32,109,117,115,116,32,98,101,32,97,116,32,108,101,97,115,116,32,50,0,0,0,0,0,70,97,105,108,101,100,32,116,111,32,97,108,108,111,99,97,116,101,32,109,101,109,111,114,121,46,10,0,0,0,0,0,102,108,97,110,110,45,115,114,99,47,115,114,99,47,99,112,112,47,102,108,97,110,110,47,97,108,103,111,114,105,116,104,109,115,47,104,105,101,114,97,114,99,104,105,99,97,108,95,99,108,117,115,116,101,114,105,110,103,95,105,110,100,101,120,46,104,0,0,0,0,0,0,108,101,97,102,95,115,105,122,101,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,13,0,0,11,0,0,0,13,0,0,0,14,0,0,0,15,0,0,0,5,0,0,0,20,0,0,0,21,0,0,0,16,0,0,0,78,53,102,108,97,110,110,55,97,110,121,105,109,112,108,49,54,115,109,97,108,108,95,97,110,121,95,112,111,108,105,99,121,73,78,83,95,50,48,102,108,97,110,110,95,99,101,110,116,101,114,115,95,105,110,105,116,95,116,69,69,69,0,0,78,53,102,108,97,110,110,55,97,110,121,105,109,112,108,50,49,116,121,112,101,100,95,98,97,115,101,95,97,110,121,95,112,111,108,105,99,121,73,78,83,95,50,48,102,108,97,110,110,95,99,101,110,116,101,114,115,95,105,110,105,116,95,116,69,69,69,0,0,0,0,0,152,96,0,0,216,12,0,0,232,7,0,0,0,0,0,0,152,96,0,0,152,12,0,0,32,13,0,0,0,0,0,0,78,53,102,108,97,110,110,50,48,102,108,97,110,110,95,99,101,110,116,101,114,115,95,105,110,105,116,95,116,69,0,0,64,96,0,0,64,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,14,0,0,12,0,0,0,17,0,0,0,18,0,0,0,19,0,0,0,6,0,0,0,22,0,0,0,23,0,0,0,20,0,0,0,78,53,102,108,97,110,110,55,97,110,121,105,109,112,108,49,54,115,109,97,108,108,95,97,110,121,95,112,111,108,105,99,121,73,105,69,69,0,0,0,78,53,102,108,97,110,110,55,97,110,121,105,109,112,108,50,49,116,121,112,101,100,95,98,97,115,101,95,97,110,121,95,112,111,108,105,99,121,73,105,69,69,0,0,0,0,0,0,152,96,0,0,200,13,0,0,232,7,0,0,0,0,0,0,152,96,0,0,160,13,0,0,248,13,0,0,0,0,0,0,85,110,107,110,111,119,110,32,97,108,103,111,114,105,116,104,109,32,102,111,114,32,99,104,111,111,115,105,110,103,32,105,110,105,116,105,97,108,32,99,101,110,116,101,114,115,46,0,0,0,0,0,192,14,0,0,28,0,0,0,29,0,0,0,1,0,0,0,0,0,0,0,78,53,102,108,97,110,110,50,49,75,77,101,97,110,115,112,112,67,101,110,116,101,114,67,104,111,111,115,101,114,73,78,83,95,50,76,50,73,102,69,69,69,69,0,0,0,0,0,78,53,102,108,97,110,110,49,51,67,101,110,116,101,114,67,104,111,111,115,101,114,73,78,83,95,50,76,50,73,102,69,69,69,69,0,0,0,0,0,128,95,0,0,144,14,0,0,152,96,0,0,96,14,0,0,184,14,0,0,0,0,0,0,105,110,100,101,120,32,62,61,48,32,38,38,32,105,110,100,101,120,32,60,32,110,0,0,102,108,97,110,110,45,115,114,99,47,115,114,99,47,99,112,112,47,102,108,97,110,110,47,97,108,103,111,114,105,116,104,109,115,47,99,101,110,116,101,114,95,99,104,111,111,115,101,114,46,104,0,0,0,0,0,111,112,101,114,97,116,111,114,40,41,0,0,0,0,0,0,0,0,0,0,120,15,0,0,30,0,0,0,31,0,0,0,2,0,0,0,0,0,0,0,78,53,102,108,97,110,110,50,49,71,111,110,122,97,108,101,115,67,101,110,116,101,114,67,104,111,111,115,101,114,73,78,83,95,50,76,50,73,102,69,69,69,69,0,0,0,0,0,152,96,0,0,72,15,0,0,184,14,0,0,0,0,0,0,114,110,100,32,62,61,48,32,38,38,32,114,110,100,32,60,32,110,0,0,0,0,0,0,0,0,0,0,232,15,0,0,32,0,0,0,33,0,0,0,3,0,0,0,0,0,0,0,78,53,102,108,97,110,110,49,57,82,97,110,100,111,109,67,101,110,116,101,114,67,104,111,111,115,101,114,73,78,83,95,50,76,50,73,102,69,69,69,69,0,0,0,0,0,0,0,152,96,0,0,184,15,0,0,184,14,0,0,0,0,0,0,0,0,0,0,192,16,0,0,34,0,0,0,35,0,0,0,24,0,0,0,25,0,0,0,26,0,0,0,27,0,0,0,13,0,0,0,14,0,0,0,15,0,0,0,28,0,0,0,36,0,0,0,16,0,0,0,4,0,0,0,17,0,0,0,1,0,0,0,3,0,0,0,3,0,0,0,37,0,0,0,38,0,0,0,0,0,0,0,116,97,114,103,101,116,95,112,114,101,99,105,115,105,111,110,0,0,0,0,0,0,0,0,98,117,105,108,100,95,119,101,105,103,104,116,0,0,0,0,109,101,109,111,114,121,95,119,101,105,103,104,116,0,0,0,115,97,109,112,108,101,95,102,114,97,99,116,105,111,110,0,78,53,102,108,97,110,110,49,52,65,117,116,111,116,117,110,101,100,73,110,100,101,120,73,78,83,95,50,76,50,73,102,69,69,69,69,0,0,0,0,152,96,0,0,152,16,0,0,152,2,0,0,0,0,0,0,102,97,108,115,101,0,0,0,102,108,97,110,110,45,115,114,99,47,115,114,99,47,99,112,112,47,102,108,97,110,110,47,97,108,103,111,114,105,116,104,109,115,47,97,117,116,111,116,117,110,101,100,95,105,110,100,101,120,46,104,0,0,0,0,102,105,110,100,78,101,105,103,104,98,111,114,115,0,0,0,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,10,0,0,0,65,117,116,111,116,117,110,101,100,32,112,97,114,97,109,101,116,101,114,115,58,10,0,0,83,101,97,114,99,104,32,112,97,114,97,109,101,116,101,114,115,58,10,0,0,0,0,0,115,101,97,114,99,104,95,112,97,114,97,109,115,0,0,0,115,112,101,101,100,117,112,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,18,0,0,18,0,0,0,21,0,0,0,22,0,0,0,23,0,0,0,7,0,0,0,29,0,0,0,30,0,0,0,24,0,0,0,78,53,102,108,97,110,110,55,97,110,121,105,109,112,108,49,54,115,109,97,108,108,95,97,110,121,95,112,111,108,105,99,121,73,102,69,69,0,0,0,78,53,102,108,97,110,110,55,97,110,121,105,109,112,108,50,49,116,121,112,101,100,95,98,97,115,101,95,97,110,121,95,112,111,108,105,99,121,73,102,69,69,0,0,0,0,0,0,152,96,0,0,0,18,0,0,232,7,0,0,0,0,0,0,152,96,0,0,216,17,0,0,48,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,19,0,0,19,0,0,0,25,0,0,0,26,0,0,0,27,0,0,0,8,0,0,0,31,0,0,0,32,0,0,0,28,0,0,0,78,53,102,108,97,110,110,55,97,110,121,105,109,112,108,49,52,98,105,103,95,97,110,121,95,112,111,108,105,99,121,73,78,83,95,49,50,83,101,97,114,99,104,80,97,114,97,109,115,69,69,69,0,0,0,0,78,53,102,108,97,110,110,55,97,110,121,105,109,112,108,50,49,116,121,112,101,100,95,98,97,115,101,95,97,110,121,95,112,111,108,105,99,121,73,78,83,95,49,50,83,101,97,114,99,104,80,97,114,97,109,115,69,69,69,0,0,0,0,0,152,96,0,0,192,18,0,0,232,7,0,0,0,0,0,0,152,96,0,0,136,18,0,0,0,19,0,0,0,0,0,0,78,53,102,108,97,110,110,49,50,83,101,97,114,99,104,80,97,114,97,109,115,69,0,0,128,95,0,0,32,19,0,0,99,104,101,99,107,115,32,58,32,0,0,0,0,0,0,0,101,112,115,32,58,32,0,0,115,111,114,116,101,100,32,58,32,0,0,0,0,0,0,0,109,97,120,95,110,101,105,103,104,98,111,114,115,32,58,32,0,0,0,0,0,0,0,0,98,101,115,116,73,110,100,101,120,95,32,33,61,32,78,85,76,76,0,0,0,0,0,0,101,115,116,105,109,97,116,101,83,101,97,114,99,104,80,97,114,97,109,115,0,0,0,0,67,111,109,112,117,116,105,110,103,32,103,114,111,117,110,100,32,116,114,117,116,104,10,0,69,115,116,105,109,97,116,105,110,103,32,110,117,109,98,101,114,32,111,102,32,99,104,101,99,107,115,10,0,0,0,0,75,77,101,97,110,115,32,97,108,103,111,114,105,116,104,109,44,32,101,115,116,105,109,97,116,105,110,103,32,99,108,117,115,116,101,114,32,98,111,114,100,101,114,32,102,97,99,116,111,114,10,0,0,0,0,0,79,112,116,105,109,117,109,32,99,98,95,105,110,100,101,120,58,32,37,103,10,0,0,0,99,98,95,105,110,100,101,120,0,0,0,0,0,0,0,0,82,101,113,117,105,114,101,100,32,110,117,109,98,101,114,32,111,102,32,99,104,101,99,107,115,58,32,37,100,32,10,0,32,32,78,111,100,101,115,32,32,80,114,101,99,105,115,105,111,110,40,37,41,32,32,32,84,105,109,101,40,115,41,32,32,32,84,105,109,101,47,118,101,99,40,109,115,41,32,32,77,101,97,110,32,100,105,115,116,10,0,0,0,0,0,0,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,10,0,0,0,0,0,0,71,111,116,32,97,115,32,99,108,111,115,101,32,97,115,32,73,32,99,97,110,10,0,0,83,116,97,114,116,32,108,105,110,101,97,114,32,101,115,116,105,109,97,116,105,111,110,10,0,0,0,0,0,0,0,0,78,111,32,110,101,101,100,32,102,111,114,32,108,105,110,101,97,114,32,101,115,116,105,109,97,116,105,111,110,10,0,0,109,97,116,99,104,101,115,46,99,111,108,115,61,37,100,44,32,110,110,61,37,100,10,0,71,114,111,117,110,100,32,116,114,117,116,104,32,105,115,32,110,111,116,32,99,111,109,112,117,116,101,100,32,102,111,114,32,97,115,32,109,97,110,121,32,110,101,105,103,104,98,111,114,115,32,97,115,32,114,101,113,117,101,115,116,101,100,0,37,56,100,32,37,49,48,46,52,103,32,37,49,48,46,53,103,32,37,49,48,46,53,103,32,37,49,48,46,53,103,10,0,0,0,0,0,0,0,0,32,58,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,69,110,116,101,114,105,110,103,32,97,117,116,111,116,117,110,105,110,103,44,32,100,97,116,97,115,101,116,32,115,105,122,101,58,32,37,100,44,32,115,97,109,112,108,101,83,105,122,101,58,32,37,100,44,32,116,101,115,116,83,97,109,112,108,101,83,105,122,101,58,32,37,100,44,32,116,97,114,103,101,116,32,112,114,101,99,105,115,105,111,110,58,32,37,103,10,0,0,0,0,0,0,0,0,67,104,111,111,115,105,110,103,32,108,105,110,101,97,114,44,32,100,97,116,97,115,101,116,32,116,111,111,32,115,109,97,108,108,10,0,0,0,0,0,67,111,109,112,117,116,105,110,103,32,103,114,111,117,110,100,32,116,114,117,116,104,46,46,46,32,10,0,0,0,0,0,65,117,116,111,116,117,110,105,110,103,32,112,97,114,97,109,101,116,101,114,115,46,46,46,10,0,0,0,0,0,0,0,84,105,109,101,32,99,111,115,116,58,32,37,103,10,0,0,66,101,115,116,32,116,105,109,101,32,99,111,115,116,58,32,37,103,10,0,0,0,0,0,67,111,115,116,58,32,37,103,10,0,0,0,0,0,0,0,66,101,115,116,32,99,111,115,116,58,32,37,103,10,0,0,75,68,45,84,82,69,69,44,32,83,116,101,112,32,49,58,32,69,120,112,108,111,114,105,110,103,32,112,97,114,97,109,101,116,101,114,32,115,112,97,99,101,10,0,0,0,0,0,1,0,0,0,4,0,0,0,8,0,0,0,16,0,0,0,32,0,0,0,0,0,0,0,75,68,84,114,101,101,32,117,115,105,110,103,32,112,97,114,97,109,115,58,32,116,114,101,101,115,61,37,100,10,0,0,75,68,84,114,101,101,32,98,117,105,108,100,84,105,109,101,61,37,103,44,32,115,101,97,114,99,104,84,105,109,101,61,37,103,10,0,0,0,0,0,0,0,0,0,0,24,0,0,39,0,0,0,40,0,0,0,2,0,0,0,3,0,0,0,33,0,0,0,34,0,0,0,1,0,0,0,20,0,0,0,21,0,0,0,35,0,0,0,7,0,0,0,4,0,0,0,5,0,0,0,5,0,0,0,1,0,0,0,2,0,0,0,4,0,0,0,41,0,0,0,42,0,0,0,0,0,0,0,78,53,102,108,97,110,110,49,49,75,68,84,114,101,101,73,110,100,101,120,73,78,83,95,50,76,50,73,102,69,69,69,69,0,0,0,0,0,0,0,152,96,0,0,216,23,0,0,152,2,0,0,0,0,0,0,73,116,32,100,111,101,115,110,39,116,32,109,97,107,101,32,97,110,121,32,115,101,110,115,101,32,116,111,32,117,115,101,32,109,111,114,101,32,116,104,97,110,32,111,110,101,32,116,114,101,101,32,102,111,114,32,101,120,97,99,116,32,115,101,97,114,99,104,0,0,0,0,102,108,97,110,110,45,115,114,99,47,115,114,99,47,99,112,112,47,102,108,97,110,110,47,97,108,103,111,114,105,116,104,109,115,47,107,100,116,114,101,101,95,105,110,100,101,120,46,104,0,0,0,0,0,0,0,77,105,115,115,105,110,103,32,112,97,114,97,109,101,116,101,114,32,39,0,0,0,0,0,39,32,105,110,32,116,104,101,32,112,97,114,97,109,101,116,101,114,115,32,103,105,118,101,110,0,0,0,0,0,0,0,75,77,69,65,78,83,44,32,83,116,101,112,32,49,58,32,69,120,112,108,111,114,105,110,103,32,112,97,114,97,109,101,116,101,114,32,115,112,97,99,101,10,0,0,0,0,0,0,1,0,0,0,5,0,0,0,10,0,0,0,15,0,0,0,16,0,0,0,32,0,0,0,64,0,0,0,128,0,0,0,0,1,0,0,0,0,0,0,105,116,101,114,97,116,105,111,110,115,0,0,0,0,0,0,75,77,101,97,110,115,84,114,101,101,32,117,115,105,110,103,32,112,97,114,97,109,115,58,32,109,97,120,95,105,116,101,114,97,116,105,111,110,115,61,37,100,44,32,98,114,97,110,99,104,105,110,103,61,37,100,10,0,0,0,0,0,0,0,75,77,101,97,110,115,84,114,101,101,32,98,117,105,108,100,84,105,109,101,61,37,103,44,32,115,101,97,114,99,104,84,105,109,101,61,37,103,44,32,98,117,105,108,100,95,119,101,105,103,104,116,61,37,103,10,0,0,0,0,0,0,0,0,0,0,0,0,48,26,0,0,43,0,0,0,44,0,0,0,2,0,0,0,3,0,0,0,36,0,0,0,37,0,0,0,1,0,0,0,22,0,0,0,23,0,0,0,38,0,0,0,7,0,0,0,4,0,0,0,6,0,0,0,5,0,0,0,1,0,0,0,2,0,0,0,5,0,0,0,45,0,0,0,46,0,0,0,0,0,0,0,78,53,102,108,97,110,110,49,49,75,77,101,97,110,115,73,110,100,101,120,73,78,83,95,50,76,50,73,102,69,69,69,69,0,0,0,0,0,0,0,152,96,0,0,8,26,0,0,152,2,0,0,0,0,0,0,102,108,97,110,110,45,115,114,99,47,115,114,99,47,99,112,112,47,102,108,97,110,110,47,97,108,103,111,114,105,116,104,109,115,47,107,109,101,97,110,115,95,105,110,100,101,120,46,104,0,0,0,0,0,0,0,116,97,114,103,101,116,95,112,114,101,99,105,115,105,111,110,95,0,0,0,0,0,0,0,98,117,105,108,100,95,119,101,105,103,104,116,95,0,0,0,109,101,109,111,114,121,95,119,101,105,103,104,116,95,0,0,115,97,109,112,108,101,95,102,114,97,99,116,105,111,110,95,0,0,0,0,0,0,0,0,0,0,0,0,72,27,0,0,47,0,0,0,48,0,0,0,39,0,0,0,40,0,0,0,41,0,0,0,42,0,0,0,1,0,0,0,24,0,0,0,25,0,0,0,43,0,0,0,49,0,0,0,4,0,0,0,7,0,0,0,26,0,0,0,1,0,0,0,2,0,0,0,6,0,0,0,50,0,0,0,51,0,0,0,0,0,0,0,78,53,102,108,97,110,110,49,52,67,111,109,112,111,115,105,116,101,73,110,100,101,120,73,78,83,95,50,76,50,73,102,69,69,69,69,0,0,0,0,152,96,0,0,32,27,0,0,152,2,0,0,0,0,0,0,66,117,105,108,100,105,110,103,32,107,109,101,97,110,115,32,116,114,101,101,46,46,46,10,0,0,0,0,0,0,0,0,66,117,105,108,100,105,110,103,32,107,100,116,114,101,101,32,116,114,101,101,46,46,46,10,0,0,0,0,0,0,0,0,0,0,0,0,32,28,0,0,52,0,0,0,53,0,0,0,2,0,0,0,3,0,0,0,44,0,0,0,45,0,0,0,1,0,0,0,27,0,0,0,28,0,0,0,46,0,0,0,7,0,0,0,4,0,0,0,8,0,0,0,5,0,0,0,1,0,0,0,2,0,0,0,7,0,0,0,54,0,0,0,55,0,0,0,0,0,0,0,114,101,111,114,100,101,114,0,78,53,102,108,97,110,110,49,55,75,68,84,114,101,101,83,105,110,103,108,101,73,110,100,101,120,73,78,83,95,50,76,50,73,102,69,69,69,69,0,152,96,0,0,248,27,0,0,152,2,0,0,0,0,0,0,105,110,100,101,120,32,62,32,48,32,38,38,32,105,110,100,101,120,32,60,32,99,111,117,110,116,0,0,0,0,0,0,102,108,97,110,110,45,115,114,99,47,115,114,99,47,99,112,112,47,102,108,97,110,110,47,97,108,103,111,114,105,116,104,109,115,47,107,100,116,114,101,101,95,115,105,110,103,108,101,95,105,110,100,101,120,46,104,0,0,0,0,0,0,0,0,109,105,100,100,108,101,83,112,108,105,116,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,29,0,0,29,0,0,0,29,0,0,0,30,0,0,0,31,0,0,0,9,0,0,0,47,0,0,0,48,0,0,0,32,0,0,0,78,53,102,108,97,110,110,55,97,110,121,105,109,112,108,49,54,115,109,97,108,108,95,97,110,121,95,112,111,108,105,99,121,73,98,69,69,0,0,0,78,53,102,108,97,110,110,55,97,110,121,105,109,112,108,50,49,116,121,112,101,100,95,98,97,115,101,95,97,110,121,95,112,111,108,105,99,121,73,98,69,69,0,0,0,0,0,0,152,96,0,0,0,29,0,0,232,7,0,0,0,0,0,0,152,96,0,0,216,28,0,0,48,29,0,0,0,0,0,0,0,0,0,0,208,29,0,0,56,0,0,0,57,0,0,0,2,0,0,0,3,0,0,0,49,0,0,0,50,0,0,0,1,0,0,0,30,0,0,0,31,0,0,0,51,0,0,0,7,0,0,0,4,0,0,0,9,0,0,0,5,0,0,0,1,0,0,0,2,0,0,0,8,0,0,0,58,0,0,0,59,0,0,0,0,0,0,0,78,53,102,108,97,110,110,49,49,76,105,110,101,97,114,73,110,100,101,120,73,78,83,95,50,76,50,73,102,69,69,69,69,0,0,0,0,0,0,0,152,96,0,0,168,29,0,0,152,2,0,0,0,0,0,0,102,108,97,110,110,45,115,114,99,47,115,114,99,47,99,112,112,47,102,108,97,110,110,47,97,108,103,111,114,105,116,104,109,115,47,108,105,110,101,97,114,95,105,110,100,101,120,46,104,0,0,0,0,0,0,0,78,83,116,51,95,95,49,49,50,98,97,115,105,99,95,115,116,114,105,110,103,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,78,83,95,57,97,108,108,111,99,97,116,111,114,73,99,69,69,69,69,0,0,78,83,116,51,95,95,49,50,49,95,95,98,97,115,105,99,95,115,116,114,105,110,103,95,99,111,109,109,111,110,73,76,98,49,69,69,69,0,0,0,128,95,0,0,88,30,0,0,248,96,0,0,24,30,0,0,0,0,0,0,1,0,0,0,128,30,0,0,0,0,0,0,114,98,0,0,0,0,0,0,73,110,118,97,108,105,100,32,105,110,100,101,120,32,102,105,108,101,44,32,99,97,110,110,111,116,32,114,101,97,100,0,61,0,0,0,0,0,0,0,32,0,0,0,0,0,0,0,56,0,0,0,0,0,0,0,72,31,0,0,60,0,0,0,61,0,0,0,200,255,255,255,200,255,255,255,72,31,0,0,62,0,0,0,63,0,0,0,78,83,116,51,95,95,49,49,57,98,97,115,105,99,95,111,115,116,114,105,110,103,115,116,114,101,97,109,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,78,83,95,57,97,108,108,111,99,97,116,111,114,73,99,69,69,69,69,0,0,0,152,96,0,0,0,31,0,0,224,56,0,0,0,0,0,0,56,0,0,0,0,0,0,0,224,56,0,0,64,0,0,0,65,0,0,0,200,255,255,255,200,255,255,255,224,56,0,0,66,0,0,0,67,0,0,0,0,0,0,0,8,32,0,0,68,0,0,0,69,0,0,0,32,0,0,0,1,0,0,0,4,0,0,0,9,0,0,0,52,0,0,0,53,0,0,0,2,0,0,0,54,0,0,0,55,0,0,0,10,0,0,0,3,0,0,0,11,0,0,0,78,83,116,51,95,95,49,49,53,98,97,115,105,99,95,115,116,114,105,110,103,98,117,102,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,78,83,95,57,97,108,108,111,99,97,116,111,114,73,99,69,69,69,69,0,0,0,0,0,0,0,152,96,0,0,192,31,0,0,216,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,33,0,0,33,0,0,0,33,0,0,0,34,0,0,0,35,0,0,0,12,0,0,0,56,0,0,0,57,0,0,0,36,0,0,0,78,53,102,108,97,110,110,55,97,110,121,105,109,112,108,49,52,98,105,103,95,97,110,121,95,112,111,108,105,99,121,73,78,83,116,51,95,95,49,49,50,98,97,115,105,99,95,115,116,114,105,110,103,73,99,78,83,50,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,78,83,50,95,57,97,108,108,111,99,97,116,111,114,73,99,69,69,69,69,69,69,0,0,0,0,0,0,78,53,102,108,97,110,110,55,97,110,121,105,109,112,108,50,49,116,121,112,101,100,95,98,97,115,101,95,97,110,121,95,112,111,108,105,99,121,73,78,83,116,51,95,95,49,49,50,98,97,115,105,99,95,115,116,114,105,110,103,73,99,78,83,50,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,78,83,50,95,57,97,108,108,111,99,97,116,111,114,73,99,69,69,69,69,69,69,0,0,0,0,0,0,0,152,96,0,0,184,32,0,0,232,7,0,0,0,0,0,0,152,96,0,0,80,32,0,0,40,33,0,0,0,0,0,0,105,103,110,111,114,105,110,103,32,98,97,100,32,111,112,116,105,111,110,32,119,111,114,100,32,37,115,10,0,0,0,0,60,0,0,0,0,0,0,0,216,33,0,0,70,0,0,0,71,0,0,0,196,255,255,255,196,255,255,255,216,33,0,0,72,0,0,0,73,0,0,0,78,83,116,51,95,95,49,49,57,98,97,115,105,99,95,105,115,116,114,105,110,103,115,116,114,101,97,109,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,78,83,95,57,97,108,108,111,99,97,116,111,114,73,99,69,69,69,69,0,0,0,152,96,0,0,144,33,0,0,80,56,0,0,0,0,0,0,60,0,0,0,0,0,0,0,80,56,0,0,74,0,0,0,75,0,0,0,196,255,255,255,196,255,255,255,80,56,0,0,76,0,0,0,77,0,0,0,108,111,103,95,108,101,118,101,108,0,0,0,0,0,0,0,116,114,117,101,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,248,34,0,0,34,0,0,0,37,0,0,0,38,0,0,0,39,0,0,0,13,0,0,0,58,0,0,0,59,0,0,0,40,0,0,0,78,53,102,108,97,110,110,55,97,110,121,105,109,112,108,49,54,115,109,97,108,108,95,97,110,121,95,112,111,108,105,99,121,73,78,83,95,49,55,102,108,97,110,110,95,108,111,103,95,108,101,118,101,108,95,116,69,69,69,0,0,0,0,0,78,53,102,108,97,110,110,55,97,110,121,105,109,112,108,50,49,116,121,112,101,100,95,98,97,115,101,95,97,110,121,95,112,111,108,105,99,121,73,78,83,95,49,55,102,108,97,110,110,95,108,111,103,95,108,101,118,101,108,95,116,69,69,69,0,0,0,0,0,0,0,0,152,96,0,0,160,34,0,0,232,7,0,0,0,0,0,0,152,96,0,0,96,34,0,0,232,34,0,0,0,0,0,0,78,53,102,108,97,110,110,49,55,102,108,97,110,110,95,108,111,103,95,108,101,118,101,108,95,116,69,0,0,0,0,0,64,96,0,0,8,35],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE);allocate([168,49,0,0,78,0,0,0,79,0,0,0,35,0,0,0,4,0,0,0,5,0,0,0,10,0,0,0,60,0,0,0,61,0,0,0,5,0,0,0,62,0,0,0,63,0,0,0,14,0,0,0,6,0,0,0,15,0,0,0,78,83,116,51,95,95,49,49,49,95,95,115,116,100,111,117,116,98,117,102,73,119,69,69,0,0,0,0,0,0,0,0,152,96,0,0,136,49,0,0,24,56,0,0,0,0,0,0,0,0,0,0,16,50,0,0,80,0,0,0,81,0,0,0,36,0,0,0,4,0,0,0,5,0,0,0,10,0,0,0,64,0,0,0,61,0,0,0,5,0,0,0,65,0,0,0,66,0,0,0,16,0,0,0,7,0,0,0,17,0,0,0,78,83,116,51,95,95,49,49,48,95,95,115,116,100,105,110,98,117,102,73,119,69,69,0,152,96,0,0,248,49,0,0,24,56,0,0,0,0,0,0,117,110,115,117,112,112,111,114,116,101,100,32,108,111,99,97,108,101,32,102,111,114,32,115,116,97,110,100,97,114,100,32,105,110,112,117,116,0,0,0,0,0,0,0,168,50,0,0,82,0,0,0,83,0,0,0,37,0,0,0,1,0,0,0,6,0,0,0,11,0,0,0,67,0,0,0,53,0,0,0,2,0,0,0,68,0,0,0,55,0,0,0,18,0,0,0,8,0,0,0,19,0,0,0,78,83,116,51,95,95,49,49,49,95,95,115,116,100,111,117,116,98,117,102,73,99,69,69,0,0,0,0,0,0,0,0,152,96,0,0,136,50,0,0,216,55,0,0,0,0,0,0,0,0,0,0,16,51,0,0,84,0,0,0,85,0,0,0,38,0,0,0,1,0,0,0,6,0,0,0,11,0,0,0,52,0,0,0,53,0,0,0,2,0,0,0,69,0,0,0,70,0,0,0,20,0,0,0,3,0,0,0,21,0,0,0,78,83,116,51,95,95,49,49,48,95,95,115,116,100,105,110,98,117,102,73,99,69,69,0,152,96,0,0,248,50,0,0,216,55,0,0,0,0,0,0,78,83,116,51,95,95,49,49,52,95,95,115,104,97,114,101,100,95,99,111,117,110,116,69,0,0,0,0,0,0,0,0,128,95,0,0,32,51,0,0,0,0,0,0,136,51,0,0,86,0,0,0,87,0,0,0,71,0,0,0,0,0,0,0,0,0,0,0,48,52,0,0,88,0,0,0,89,0,0,0,1,0,0,0,0,0,0,0,83,116,49,49,108,111,103,105,99,95,101,114,114,111,114,0,152,96,0,0,120,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,200,51,0,0,86,0,0,0,90,0,0,0,71,0,0,0,0,0,0,0,83,116,49,50,108,101,110,103,116,104,95,101,114,114,111,114,0,0,0,0,0,0,0,0,152,96,0,0,176,51,0,0,136,51,0,0,0,0,0,0,0,0,0,0,8,52,0,0,86,0,0,0,91,0,0,0,71,0,0,0,0,0,0,0,83,116,49,50,111,117,116,95,111,102,95,114,97,110,103,101,0,0,0,0,0,0,0,0,152,96,0,0,240,51,0,0,136,51,0,0,0,0,0,0,83,116,49,51,114,117,110,116,105,109,101,95,101,114,114,111,114,0,0,0,0,0,0,0,152,96,0,0,24,52,0,0,0,0,0,0,0,0,0,0,58,32,0,0,0,0,0,0,0,0,0,0,120,52,0,0,92,0,0,0,93,0,0,0,1,0,0,0,0,0,0,0,78,83,116,51,95,95,49,49,50,115,121,115,116,101,109,95,101,114,114,111,114,69,0,0,152,96,0,0,96,52,0,0,48,52,0,0,0,0,0,0,78,83,116,51,95,95,49,49,52,101,114,114,111,114,95,99,97,116,101,103,111,114,121,69,0,0,0,0,0,0,0,0,128,95,0,0,136,52,0,0,78,83,116,51,95,95,49,49,50,95,95,100,111,95,109,101,115,115,97,103,101,69,0,0,152,96,0,0,176,52,0,0,168,52,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,98,97,115,105,99,95,115,116,114,105,110,103,0,0,0,0,0,0,0,0,216,55,0,0,94,0,0,0,95,0,0,0,32,0,0,0,1,0,0,0,6,0,0,0,11,0,0,0,52,0,0,0,53,0,0,0,2,0,0,0,68,0,0,0,55,0,0,0,18,0,0,0,3,0,0,0,21,0,0,0,0,0,0,0,24,56,0,0,96,0,0,0,97,0,0,0,39,0,0,0,4,0,0,0,5,0,0,0,10,0,0,0,64,0,0,0,61,0,0,0,5,0,0,0,62,0,0,0,63,0,0,0,14,0,0,0,7,0,0,0,17,0,0,0,8,0,0,0,0,0,0,0,80,56,0,0,74,0,0,0,75,0,0,0,248,255,255,255,248,255,255,255,80,56,0,0,76,0,0,0,77,0,0,0,8,0,0,0,0,0,0,0,152,56,0,0,98,0,0,0,99,0,0,0,248,255,255,255,248,255,255,255,152,56,0,0,100,0,0,0,101,0,0,0,4,0,0,0,0,0,0,0,224,56,0,0,64,0,0,0,65,0,0,0,252,255,255,255,252,255,255,255,224,56,0,0,66,0,0,0,67,0,0,0,4,0,0,0,0,0,0,0,40,57,0,0,102,0,0,0,103,0,0,0,252,255,255,255,252,255,255,255,40,57,0,0,104,0,0,0,105,0,0,0,105,111,115,116,114,101,97,109,0,0,0,0,0,0,0,0,117,110,115,112,101,99,105,102,105,101,100,32,105,111,115,116,114,101,97,109,95,99,97,116,101,103,111,114,121,32,101,114,114,111,114,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,54,0,0,106,0,0,0,107,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,24,55,0,0,108,0,0,0,109,0,0,0,105,111,115,95,98,97,115,101,58,58,99,108,101,97,114,0,78,83,116,51,95,95,49,56,105,111,115,95,98,97,115,101,55,102,97,105,108,117,114,101,69,0,0,0,0,0,0,0,152,96,0,0,208,54,0,0,120,52,0,0,0,0,0,0,78,83,116,51,95,95,49,56,105,111,115,95,98,97,115,101,69,0,0,0,0,0,0,0,128,95,0,0,0,55,0,0,78,83,116,51,95,95,49,57,98,97,115,105,99,95,105,111,115,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,69,69,0,0,0,0,0,0,0,152,96,0,0,32,55,0,0,24,55,0,0,0,0,0,0,78,83,116,51,95,95,49,57,98,97,115,105,99,95,105,111,115,73,119,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,119,69,69,69,69,0,0,0,0,0,0,0,152,96,0,0,96,55,0,0,24,55,0,0,0,0,0,0,78,83,116,51,95,95,49,49,53,98,97,115,105,99,95,115,116,114,101,97,109,98,117,102,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,69,69,0,0,0,0,0,0,0,0,128,95,0,0,160,55,0,0,78,83,116,51,95,95,49,49,53,98,97,115,105,99,95,115,116,114,101,97,109,98,117,102,73,119,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,119,69,69,69,69,0,0,0,0,0,0,0,0,128,95,0,0,224,55,0,0,78,83,116,51,95,95,49,49,51,98,97,115,105,99,95,105,115,116,114,101,97,109,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,69,69,0,0,248,96,0,0,32,56,0,0,0,0,0,0,1,0,0,0,80,55,0,0,3,244,255,255,78,83,116,51,95,95,49,49,51,98,97,115,105,99,95,105,115,116,114,101,97,109,73,119,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,119,69,69,69,69,0,0,248,96,0,0,104,56,0,0,0,0,0,0,1,0,0,0,144,55,0,0,3,244,255,255,78,83,116,51,95,95,49,49,51,98,97,115,105,99,95,111,115,116,114,101,97,109,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,69,69,0,0,248,96,0,0,176,56,0,0,0,0,0,0,1,0,0,0,80,55,0,0,3,244,255,255,78,83,116,51,95,95,49,49,51,98,97,115,105,99,95,111,115,116,114,101,97,109,73,119,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,119,69,69,69,69,0,0,248,96,0,0,248,56,0,0,0,0,0,0,1,0,0,0,144,55,0,0,3,244,255,255,0,0,0,0,136,57,0,0,110,0,0,0,111,0,0,0,72,0,0,0,41,0,0,0,9,0,0,0,10,0,0,0,42,0,0,0,0,0,0,0,78,83,116,51,95,95,49,49,57,95,95,105,111,115,116,114,101,97,109,95,99,97,116,101,103,111,114,121,69,0,0,0,152,96,0,0,104,57,0,0,200,52,0,0,0,0,0,0,0,0,0,0,176,71,0,0,112,0,0,0,113,0,0,0,114,0,0,0,1,0,0,0,12,0,0,0,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,216,71,0,0,115,0,0,0,116,0,0,0,114,0,0,0,2,0,0,0,13,0,0,0,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,76,0,0,117,0,0,0,118,0,0,0,114,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,4,0,0,0,5,0,0,0,6,0,0,0,7,0,0,0,8,0,0,0,9,0,0,0,10,0,0,0,11,0,0,0,0,0,0,0,0,0,0,0,48,49,50,51,52,53,54,55,56,57,97,98,99,100,101,102,65,66,67,68,69,70,120,88,43,45,112,80,105,73,110,78,0,0,0,0,0,0,0,0,37,112,0,0,0,0,0,0,0,0,0,0,32,77,0,0,119,0,0,0,120,0,0,0,114,0,0,0,12,0,0,0,13,0,0,0,14,0,0,0,15,0,0,0,16,0,0,0,17,0,0,0,18,0,0,0,19,0,0,0,20,0,0,0,21,0,0,0,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,77,0,0,121,0,0,0,122,0,0,0,114,0,0,0,7,0,0,0,8,0,0,0,23,0,0,0,9,0,0,0,24,0,0,0,1,0,0,0,2,0,0,0,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,120,78,0,0,123,0,0,0,124,0,0,0,114,0,0,0,11,0,0,0,12,0,0,0,25,0,0,0,13,0,0,0,26,0,0,0,3,0,0,0,4,0,0,0,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,37,0,0,0,0,0,0,0,37,112,0,0,0,0,0,0,0,0,0,0,160,73,0,0,125,0,0,0,126,0,0,0,114,0,0,0,73,0,0,0,27,0,0,0,28,0,0,0,29,0,0,0,30,0,0,0,31,0,0,0,1,0,0,0,248,255,255,255,160,73,0,0,74,0,0,0,75,0,0,0,76,0,0,0,77,0,0,0,78,0,0,0,79,0,0,0,80,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,37,72,58,37,77,58,37,83,37,109,47,37,100,47,37,121,37,89,45,37,109,45,37,100,37,73,58,37,77,58,37,83,32,37,112,0,0,0,0,0,37,72,58,37,77,0,0,0,37,72,58,37,77,58,37,83,0,0,0,0,64,74,0,0,127,0,0,0,128,0,0,0,114,0,0,0,81,0,0,0,32,0,0,0,33,0,0,0,34,0,0,0,35,0,0,0,36,0,0,0,2,0,0,0,248,255,255,255,64,74,0,0,82,0,0,0,83,0,0,0,84,0,0,0,85,0,0,0,86,0,0,0,87,0,0,0,88,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,37,0,0,0,72,0,0,0,58,0,0,0,37,0,0,0,77,0,0,0,58,0,0,0,37,0,0,0,83,0,0,0,37,0,0,0,109,0,0,0,47,0,0,0,37,0,0,0,100,0,0,0,47,0,0,0,37,0,0,0,121,0,0,0,37,0,0,0,89,0,0,0,45,0,0,0,37,0,0,0,109,0,0,0,45,0,0,0,37,0,0,0,100,0,0,0,37,0,0,0,73,0,0,0,58,0,0,0,37,0,0,0,77,0,0,0,58,0,0,0,37,0,0,0,83,0,0,0,32,0,0,0,37,0,0,0,112,0,0,0,0,0,0,0,37,0,0,0,72,0,0,0,58,0,0,0,37,0,0,0,77,0,0,0,0,0,0,0,37,0,0,0,72,0,0,0,58,0,0,0,37,0,0,0,77,0,0,0,58,0,0,0,37,0,0,0,83,0,0,0,0,0,0,0,208,74,0,0,129,0,0,0,130,0,0,0,114,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,75,0,0,131,0,0,0,132,0,0,0,114,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,72,0,0,133,0,0,0,134,0,0,0,114,0,0,0,89,0,0,0,90,0,0,0,40,0,0,0,41,0,0,0,42,0,0,0,43,0,0,0,91,0,0,0,44,0,0,0,45,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,104,72,0,0,135,0,0,0,136,0,0,0,114,0,0,0,92,0,0,0,93,0,0,0,46,0,0,0,47,0,0,0,48,0,0,0,49,0,0,0,94,0,0,0,50,0,0,0,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,168,72,0,0,137,0,0,0,138,0,0,0,114,0,0,0,95,0,0,0,96,0,0,0,52,0,0,0,53,0,0,0,54,0,0,0,55,0,0,0,97,0,0,0,56,0,0,0,57,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,232,72,0,0,139,0,0,0,140,0,0,0,114,0,0,0,98,0,0,0,99,0,0,0,58,0,0,0,59,0,0,0,60,0,0,0,61,0,0,0,100,0,0,0,62,0,0,0,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,79,0,0,141,0,0,0,142,0,0,0,114,0,0,0,3,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,49,50,51,52,53,54,55,56,57,0,0,0,0,0,0,37,76,102,0,0,0,0,0,109,111,110,101,121,95,103,101,116,32,101,114,114,111,114,0,0,0,0,0,152,79,0,0,143,0,0,0,144,0,0,0,114,0,0,0,5,0,0,0,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,49,50,51,52,53,54,55,56,57,0,0,0,0,0,0,0,0,0,0,40,80,0,0,145,0,0,0,146,0,0,0,114,0,0,0,1,0,0,0,37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,37,46,48,76,102,0,0,0,0,0,0,0,184,80,0,0,147,0,0,0,148,0,0,0,114,0,0,0,2,0,0,0,38,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144,75,0,0,149,0,0,0,150,0,0,0,114,0,0,0,13,0,0,0,15,0,0,0,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,200,75,0,0,151,0,0,0,152,0,0,0,114,0,0,0,14,0,0,0,16,0,0,0,65,0,0,0,0,0,0,0,0,0,0,0,118,101,99,116,111,114,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,67,0,0,0,0,0,0,0,0,0,0,0,136,71,0,0,153,0,0,0,154,0,0,0,114,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96,68,0,0,155,0,0,0,156,0,0,0,114,0,0,0,22,0,0,0,15,0,0,0,23,0,0,0,16,0,0,0,24,0,0,0,1,0,0,0,17,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,69,0,0,157,0,0,0,158,0,0,0,114,0,0,0,1,0,0,0,2,0,0,0,4,0,0,0,101,0,0,0,102,0,0,0,5,0,0,0,103,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,71,0,0,159,0,0,0,160,0,0,0,114,0,0,0,104,0,0,0,105,0,0,0,66,0,0,0,67,0,0,0,68,0,0,0,0,0,0,0,96,71,0,0,161,0,0,0,162,0,0,0,114,0,0,0,106,0,0,0,107,0,0,0,69,0,0,0,70,0,0,0,71,0,0,0,116,114,117,101,0,0,0,0,116,0,0,0,114,0,0,0,117,0,0,0,101,0,0,0,0,0,0,0,0,0,0,0,102,97,108,115,101,0,0,0,102,0,0,0,97,0,0,0,108,0,0,0,115,0,0,0,101,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,37,109,47,37,100,47,37,121,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,37,0,0,0,109,0,0,0,47,0,0,0,37,0,0,0,100,0,0,0,47,0,0,0,37,0,0,0,121,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,37,72,58,37,77,58,37,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,37,0,0,0,72,0,0,0,58,0,0,0,37,0,0,0,77,0,0,0,58,0,0,0,37,0,0,0,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,37,97,32,37,98,32,37,100,32,37,72,58,37,77,58,37,83,32,37,89,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,37,0,0,0,97,0,0,0,32,0,0,0,37,0,0,0,98,0,0,0,32,0,0,0,37,0,0,0,100,0,0,0,32,0,0,0,37,0,0,0,72,0,0,0,58,0,0,0,37,0,0,0,77,0,0,0,58,0,0,0,37,0,0,0,83,0,0,0,32,0,0,0,37,0,0,0,89,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,37,73,58,37,77,58,37,83,32,37,112,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,37,0,0,0,73,0,0,0,58,0,0,0,37,0,0,0,77,0,0,0,58,0,0,0,37,0,0,0,83,0,0,0,32,0,0,0,37,0,0,0,112,0,0,0,0,0,0,0,108,111,99,97,108,101,32,110,111,116,32,115,117,112,112,111,114,116,101,100,0,0,0,0,0,0,0,0,152,67,0,0,163,0,0,0,164,0,0,0,114,0,0,0,0,0,0,0,78,83,116,51,95,95,49,54,108,111,99,97,108,101,53,102,97,99,101,116,69,0,0,0,152,96,0,0,128,67,0,0,64,51,0,0,0,0,0,0,0,0,0,0,40,68,0,0,163,0,0,0,165,0,0,0,114,0,0,0,18,0,0,0,2,0,0,0,3,0,0,0,4,0,0,0,25,0,0,0,19,0,0,0,26,0,0,0,20,0,0,0,27,0,0,0,5,0,0,0,21,0,0,0,6,0,0,0,0,0,0,0,78,83,116,51,95,95,49,53,99,116,121,112,101,73,119,69,69,0,0,0,0,0,0,0,78,83,116,51,95,95,49,49,48,99,116,121,112,101,95,98,97,115,101,69,0,0,0,0,128,95,0,0,8,68,0,0,248,96,0,0,240,67,0,0,0,0,0,0,2,0,0,0,152,67,0,0,2,0,0,0,32,68,0,0,2,0,0,0,78,83,116,51,95,95,49,53,99,116,121,112,101,73,99,69,69,0,0,0,0,0,0,0,248,96,0,0,72,68,0,0,0,0,0,0,2,0,0,0,152,67,0,0,2,0,0,0,32,68,0,0,2,0,0,0,0,0,0,0,248,68,0,0,163,0,0,0,166,0,0,0,114,0,0,0,3,0,0,0,4,0,0,0,7,0,0,0,108,0,0,0,109,0,0,0,8,0,0,0,110,0,0,0,78,83,116,51,95,95,49,55,99,111,100,101,99,118,116,73,99,99,49,49,95,95,109,98,115,116,97,116,101,95,116,69,69,0,0,0,0,0,0,0,78,83,116,51,95,95,49,49,50,99,111,100,101,99,118,116,95,98,97,115,101,69,0,0,128,95,0,0,216,68,0,0,248,96,0,0,176,68,0,0,0,0,0,0,2,0,0,0,152,67,0,0,2,0,0,0,240,68,0,0,2,0,0,0,78,83,116,51,95,95,49,55,99,111,100,101,99,118,116,73,119,99,49,49,95,95,109,98,115,116,97,116,101,95,116,69,69,0,0,0,0,0,0,0,248,96,0,0,24,69,0,0,0,0,0,0,2,0,0,0,152,67,0,0,2,0,0,0,240,68,0,0,2,0,0,0,0,0,0,0,184,69,0,0,163,0,0,0,167,0,0,0,114,0,0,0,5,0,0,0,6,0,0,0,9,0,0,0,111,0,0,0,112,0,0,0,10,0,0,0,113,0,0,0,78,83,116,51,95,95,49,55,99,111,100,101,99,118,116,73,68,115,99,49,49,95,95,109,98,115,116,97,116,101,95,116,69,69,0,0,0,0,0,0,248,96,0,0,144,69,0,0,0,0,0,0,2,0,0,0,152,67,0,0,2,0,0,0,240,68,0,0,2,0,0,0,0,0,0,0,48,70,0,0,163,0,0,0,168,0,0,0,114,0,0,0,7,0,0,0,8,0,0,0,11,0,0,0,114,0,0,0,115,0,0,0,12,0,0,0,116,0,0,0,78,83,116,51,95,95,49,55,99,111,100,101,99,118,116,73,68,105,99,49,49,95,95,109,98,115,116,97,116,101,95,116,69,69,0,0,0,0,0,0,248,96,0,0,8,70,0,0,0,0,0,0,2,0,0,0,152,67,0,0,2,0,0,0,240,68,0,0,2,0,0,0,0,0,0,0,168,70,0,0,163,0,0,0,169,0,0,0,114,0,0,0,7,0,0,0,8,0,0,0,11,0,0,0,114,0,0,0,115,0,0,0,12,0,0,0,116,0,0,0,78,83,116,51,95,95,49,49,54,95,95,110,97,114,114,111,119,95,116,111,95,117,116,102,56,73,76,106,51,50,69,69,69,0,0,0,0,0,0,0,152,96,0,0,128,70,0,0,48,70,0,0,0,0,0,0,0,0,0,0,16,71,0,0,163,0,0,0,170,0,0,0,114,0,0,0,7,0,0,0,8,0,0,0,11,0,0,0,114,0,0,0,115,0,0,0,12,0,0,0,116,0,0,0,78,83,116,51,95,95,49,49,55,95,95,119,105,100,101,110,95,102,114,111,109,95,117,116,102,56,73,76,106,51,50,69,69,69,0,0,0,0,0,0,152,96,0,0,232,70,0,0,48,70,0,0,0,0,0,0,78,83,116,51,95,95,49,56,110,117,109,112,117,110,99,116,73,99,69,69,0,0,0,0,152,96,0,0,32,71,0,0,152,67,0,0,0,0,0,0,78,83,116,51,95,95,49,56,110,117,109,112,117,110,99,116,73,119,69,69,0,0,0,0,152,96,0,0,72,71,0,0,152,67,0,0,0,0,0,0,78,83,116,51,95,95,49,54,108,111,99,97,108,101,53,95,95,105,109,112,69,0,0,0,152,96,0,0,112,71,0,0,152,67,0,0,0,0,0,0,78,83,116,51,95,95,49,55,99,111,108,108,97,116,101,73,99,69,69,0,0,0,0,0,152,96,0,0,152,71,0,0,152,67,0,0,0,0,0,0,78,83,116,51,95,95,49,55,99,111,108,108,97,116,101,73,119,69,69,0,0,0,0,0,152,96,0,0,192,71,0,0,152,67,0,0,0,0,0,0,78,83,116,51,95,95,49,49,48,109,111,110,101,121,112,117,110,99,116,73,99,76,98,48,69,69,69,0,0,0,0,0,78,83,116,51,95,95,49,49,48,109,111,110,101,121,95,98,97,115,101,69,0,0,0,0,128,95,0,0,8,72,0,0,248,96,0,0,232,71,0,0,0,0,0,0,2,0,0,0,152,67,0,0,2,0,0,0,32,72,0,0,2,0,0,0,78,83,116,51,95,95,49,49,48,109,111,110,101,121,112,117,110,99,116,73,99,76,98,49,69,69,69,0,0,0,0,0,248,96,0,0,72,72,0,0,0,0,0,0,2,0,0,0,152,67,0,0,2,0,0,0,32,72,0,0,2,0,0,0,78,83,116,51,95,95,49,49,48,109,111,110,101,121,112,117,110,99,116,73,119,76,98,48,69,69,69,0,0,0,0,0,248,96,0,0,136,72,0,0,0,0,0,0,2,0,0,0,152,67,0,0,2,0,0,0,32,72,0,0,2,0,0,0,78,83,116,51,95,95,49,49,48,109,111,110,101,121,112,117,110,99,116,73,119,76,98,49,69,69,69,0,0,0,0,0,248,96,0,0,200,72,0,0,0,0,0,0,2,0,0,0,152,67,0,0,2,0,0,0,32,72,0,0,2,0,0,0,78,83,116,51,95,95,49,56,116,105,109,101,95,103,101,116,73,99,78,83,95,49,57,105,115,116,114,101,97,109,98,117,102,95,105,116,101,114,97,116,111,114,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,69,69,69,69,0,0,0,0,78,83,116,51,95,95,49,57,116,105,109,101,95,98,97,115,101,69,0,0,0,0,0,0,128,95,0,0,80,73,0,0,78,83,116,51,95,95,49,50,48,95,95,116,105,109,101,95,103,101,116,95,99,95,115,116,111,114,97,103,101,73,99,69,69,0,0,0,0,0,0,0,128,95,0,0,112,73,0,0,248,96,0,0,8,73,0,0,0,0,0,0,3,0,0,0,152,67,0,0,2,0,0,0,104,73,0,0,2,0,0,0,152,73,0,0,0,8,0,0,78,83,116,51,95,95,49,56,116,105,109,101,95,103,101,116,73,119,78,83,95,49,57,105,115,116,114,101,97,109,98,117,102,95,105,116,101,114,97,116,111,114,73,119,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,119,69,69,69,69,69,69,0,0,0,0,78,83,116,51,95,95,49,50,48,95,95,116,105,109,101,95,103,101,116,95,99,95,115,116,111,114,97,103,101,73,119,69,69,0,0,0,0,0,0,0,128,95,0,0,16,74,0,0,248,96,0,0,200,73,0,0,0,0,0,0,3,0,0,0,152,67,0,0,2,0,0,0,104,73,0,0,2,0,0,0,56,74,0,0,0,8,0,0,78,83,116,51,95,95,49,56,116,105,109,101,95,112,117,116,73,99,78,83,95,49,57,111,115,116,114,101,97,109,98,117,102,95,105,116,101,114,97,116,111,114,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,69,69,69,69,0,0,0,0,78,83,116,51,95,95,49,49,48,95,95,116,105,109,101,95,112,117,116,69,0,0,0,0,128,95,0,0,176,74,0,0,248,96,0,0,104,74,0,0,0,0,0,0,2,0,0,0,152,67,0,0,2,0,0,0,200,74,0,0,0,8,0,0,78,83,116,51,95,95,49,56,116,105,109,101,95,112,117,116,73,119,78,83,95,49,57,111,115,116,114,101,97,109,98,117,102,95,105,116,101,114,97,116,111,114,73,119,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,119,69,69,69,69,69,69,0,0,0,0,248,96,0,0,240,74,0,0,0,0,0,0,2,0,0,0,152,67,0,0,2,0,0,0,200,74,0,0,0,8,0,0,78,83,116,51,95,95,49,56,109,101,115,115,97,103,101,115,73,99,69,69,0,0,0,0,78,83,116,51,95,95,49,49,51,109,101,115,115,97,103,101,115,95,98,97,115,101,69,0,128,95,0,0,112,75,0,0,248,96,0,0,88,75,0,0,0,0,0,0,2,0,0,0,152,67,0,0,2,0,0,0,136,75,0,0,2,0,0,0,78,83,116,51,95,95,49,56,109,101,115,115,97,103,101,115,73,119,69,69,0,0,0,0,248,96,0,0,176,75,0,0,0,0,0,0,2,0,0,0,152,67,0,0,2,0,0,0,136,75,0,0,2,0,0,0,78,83,116,51,95,95,49,55,110,117,109,95,103,101,116,73,99,78,83,95,49,57,105,115,116,114,101,97,109,98,117,102,95,105,116,101,114,97,116,111,114,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,69,69,69,69,0,0,0,0,0,78,83,116,51,95,95,49,57,95,95,110,117,109,95,103,101,116,73,99,69,69,0,0,0,78,83,116,51,95,95,49,49,52,95,95,110,117,109,95,103,101,116,95,98,97,115,101,69,0,0,0,0,0,0,0,0,128,95,0,0,72,76,0,0,248,96,0,0,48,76,0,0,0,0,0,0,1,0,0,0,104,76,0,0,0,0,0,0,248,96,0,0,232,75,0,0,0,0,0,0,2,0,0,0,152,67,0,0,2,0,0,0,112,76,0,0,0,0,0,0,78,83,116,51,95,95,49,55,110,117,109,95,103,101,116,73,119,78,83,95,49,57,105,115,116,114,101,97,109,98,117,102,95,105,116,101,114,97,116,111,114,73,119,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,119,69,69,69,69,69,69,0,0,0,0,0,78,83,116,51,95,95,49,57,95,95,110,117,109,95,103,101,116,73,119,69,69,0,0,0,248,96,0,0,240,76,0,0,0,0,0,0,1,0,0,0,104,76,0,0,0,0,0,0,248,96,0,0,168,76,0,0,0,0,0,0,2,0,0,0,152,67,0,0,2,0,0,0,8,77,0,0,0,0,0,0,78,83,116,51,95,95,49,55,110,117,109,95,112,117,116,73,99,78,83,95,49,57,111,115,116,114,101,97,109,98,117,102,95,105,116,101,114,97,116,111,114,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,69,69,69,69,0,0,0,0,0,78,83,116,51,95,95,49,57,95,95,110,117,109,95,112,117,116,73,99,69,69,0,0,0,78,83,116,51,95,95,49,49,52,95,95,110,117,109,95,112,117,116,95,98,97,115,101,69,0,0,0,0,0,0,0,0,128,95,0,0,160,77,0,0,248,96,0,0,136,77,0,0,0,0,0,0,1,0,0,0,192,77,0,0,0,0,0,0,248,96,0,0,64,77,0,0,0,0,0,0,2,0,0,0,152,67,0,0,2,0,0,0,200,77,0,0,0,0,0,0,78,83,116,51,95,95,49,55,110,117,109,95,112,117,116,73,119,78,83,95,49,57,111,115,116,114,101,97,109,98,117,102,95,105,116,101,114,97,116,111,114,73,119,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,119,69,69,69,69,69,69,0,0,0,0,0,78,83,116,51,95,95,49,57,95,95,110,117,109,95,112,117,116,73,119,69,69,0,0,0,248,96,0,0,72,78,0,0,0,0,0,0,1,0,0,0,192,77,0,0,0,0,0,0,248,96,0,0,0,78,0,0,0,0,0,0,2,0,0,0,152,67,0,0,2,0,0,0,96,78,0,0,0,0,0,0,78,83,116,51,95,95,49,57,109,111,110,101,121,95,103,101,116,73,99,78,83,95,49,57,105,115,116,114,101,97,109,98,117,102,95,105,116,101,114,97,116,111,114,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,69,69,69,69,0,0,0,78,83,116,51,95,95,49,49,49,95,95,109,111,110,101,121,95,103,101,116,73,99,69,69,0,0,0,0,0,0,0,0,128,95,0,0,224,78,0,0,248,96,0,0,152,78,0,0,0,0,0,0,2,0,0,0,152,67,0,0,2,0,0,0,0,79,0,0,0,0,0,0,78,83,116,51,95,95,49,57,109,111,110,101,121,95,103,101,116,73,119,78,83,95,49,57,105,115,116,114,101,97,109,98,117,102,95,105,116,101,114,97,116,111,114,73,119,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,119,69,69,69,69,69,69,0,0,0,78,83,116,51,95,95,49,49,49,95,95,109,111,110,101,121,95,103,101,116,73,119,69,69,0,0,0,0,0,0,0,0,128,95,0,0,112,79,0,0,248,96,0,0,40,79,0,0,0,0,0,0,2,0,0,0,152,67,0,0,2,0,0,0,144,79,0,0,0,0,0,0,78,83,116,51,95,95,49,57,109,111,110,101,121,95,112,117,116,73,99,78,83,95,49,57,111,115,116,114,101,97,109,98,117,102,95,105,116,101,114,97,116,111,114,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,69,69,69,69,0,0,0,78,83,116,51,95,95,49,49,49,95,95,109,111,110,101,121,95,112,117,116,73,99,69,69,0,0,0,0,0,0,0,0,128,95,0,0,0,80,0,0,248,96,0,0,184,79,0,0,0,0,0,0,2,0,0,0,152,67,0,0,2,0,0,0,32,80,0,0,0,0,0,0,78,83,116,51,95,95,49,57,109,111,110,101,121,95,112,117,116,73,119,78,83,95,49,57,111,115,116,114,101,97,109,98,117,102,95,105,116,101,114,97,116,111,114,73,119,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,119,69,69,69,69,69,69,0,0,0,78,83,116,51,95,95,49,49,49,95,95,109,111,110,101,121,95,112,117,116,73,119,69,69,0,0,0,0,0,0,0,0,128,95,0,0,144,80,0,0,248,96,0,0,72,80,0,0,0,0,0,0,2,0,0,0,152,67,0,0,2,0,0,0,176,80,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,65,0,0,0,77,0,0,0,0,0,0,0,0,0,0,0,80,0,0,0,77,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,65,77,0,0,0,0,0,0,80,77,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,74,0,0,0,97,0,0,0,110,0,0,0,117,0,0,0,97,0,0,0,114,0,0,0,121,0,0,0,0,0,0,0,70,0,0,0,101,0,0,0,98,0,0,0,114,0,0,0,117,0,0,0,97,0,0,0,114,0,0,0,121,0,0,0,0,0,0,0,0,0,0,0,77,0,0,0,97,0,0,0,114,0,0,0,99,0,0,0,104,0,0,0,0,0,0,0,65,0,0,0,112,0,0,0,114,0,0,0,105,0,0,0,108,0,0,0,0,0,0,0,74,0,0,0,117,0,0,0,110,0,0,0,101,0,0,0,0,0,0,0,0,0,0,0,74,0,0,0,117,0,0,0,108,0,0,0,121,0,0,0,0,0,0,0,0,0,0,0,65,0,0,0,117,0,0,0,103,0,0,0,117,0,0,0,115,0,0,0,116,0,0,0,0,0,0,0,0,0,0,0,83,0,0,0,101,0,0,0,112,0,0,0,116,0,0,0,101,0,0,0,109,0,0,0,98,0,0,0,101,0,0,0,114,0,0,0,0,0,0,0,79,0,0,0,99,0,0,0,116,0,0,0,111,0,0,0,98,0,0,0,101,0,0,0,114,0,0,0,0,0,0,0,78,0,0,0,111,0,0,0,118,0,0,0,101,0,0,0,109,0,0,0,98,0,0,0,101,0,0,0,114,0,0,0,0,0,0,0,0,0,0,0,68,0,0,0,101,0,0,0,99,0,0,0,101,0,0,0,109,0,0,0,98,0,0,0,101,0,0,0,114,0,0,0,0,0,0,0,0,0,0,0,74,0,0,0,97,0,0,0,110,0,0,0,0,0,0,0,70,0,0,0,101,0,0,0,98,0,0,0,0,0,0,0,77,0,0,0,97,0,0,0,114,0,0,0,0,0,0,0,65,0,0,0,112,0,0,0,114,0,0,0,0,0,0,0,77,0,0,0,97,0,0,0,121,0,0,0,0,0,0,0,74,0,0,0,117,0,0,0,110,0,0,0,0,0,0,0,74,0,0,0,117,0,0,0,108,0,0,0,0,0,0,0,65,0,0,0,117,0,0,0,103,0,0,0,0,0,0,0,83,0,0,0,101,0,0,0,112,0,0,0,0,0,0,0,79,0,0,0,99,0,0,0,116,0,0,0,0,0,0,0,78,0,0,0,111,0,0,0,118,0,0,0,0,0,0,0,68,0,0,0,101,0,0,0,99],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+12612);allocate([74,97,110,117,97,114,121,0,70,101,98,114,117,97,114,121,0,0,0,0,0,0,0,0,77,97,114,99,104,0,0,0,65,112,114,105,108,0,0,0,77,97,121,0,0,0,0,0,74,117,110,101,0,0,0,0,74,117,108,121,0,0,0,0,65,117,103,117,115,116,0,0,83,101,112,116,101,109,98,101,114,0,0,0,0,0,0,0,79,99,116,111,98,101,114,0,78,111,118,101,109,98,101,114,0,0,0,0,0,0,0,0,68,101,99,101,109,98,101,114,0,0,0,0,0,0,0,0,74,97,110,0,0,0,0,0,70,101,98,0,0,0,0,0,77,97,114,0,0,0,0,0,65,112,114,0,0,0,0,0,74,117,110,0,0,0,0,0,74,117,108,0,0,0,0,0,65,117,103,0,0,0,0,0,83,101,112,0,0,0,0,0,79,99,116,0,0,0,0,0,78,111,118,0,0,0,0,0,68,101,99,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,83,0,0,0,117,0,0,0,110,0,0,0,100,0,0,0,97,0,0,0,121,0,0,0,0,0,0,0,0,0,0,0,77,0,0,0,111,0,0,0,110,0,0,0,100,0,0,0,97,0,0,0,121,0,0,0,0,0,0,0,0,0,0,0,84,0,0,0,117,0,0,0,101,0,0,0,115,0,0,0,100,0,0,0,97,0,0,0,121,0,0,0,0,0,0,0,87,0,0,0,101,0,0,0,100,0,0,0,110,0,0,0,101,0,0,0,115,0,0,0,100,0,0,0,97,0,0,0,121,0,0,0,0,0,0,0,84,0,0,0,104,0,0,0,117,0,0,0,114,0,0,0,115,0,0,0,100,0,0,0,97,0,0,0,121,0,0,0,0,0,0,0,0,0,0,0,70,0,0,0,114,0,0,0,105,0,0,0,100,0,0,0,97,0,0,0,121,0,0,0,0,0,0,0,0,0,0,0,83,0,0,0,97,0,0,0,116,0,0,0,117,0,0,0,114,0,0,0,100,0,0,0,97,0,0,0,121,0,0,0,0,0,0,0,0,0,0,0,83,0,0,0,117,0,0,0,110,0,0,0,0,0,0,0,77,0,0,0,111,0,0,0,110,0,0,0,0,0,0,0,84,0,0,0,117,0,0,0,101,0,0,0,0,0,0,0,87,0,0,0,101,0,0,0,100,0,0,0,0,0,0,0,84,0,0,0,104,0,0,0,117,0,0,0,0,0,0,0,70,0,0,0,114,0,0,0,105,0,0,0,0,0,0,0,83,0,0,0,97,0,0,0,116,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,83,117,110,100,97,121,0,0,77,111,110,100,97,121,0,0,84,117,101,115,100,97,121,0,87,101,100,110,101,115,100,97,121,0,0,0,0,0,0,0,84,104,117,114,115,100,97,121,0,0,0,0,0,0,0,0,70,114,105,100,97,121,0,0,83,97,116,117,114,100,97,121,0,0,0,0,0,0,0,0,83,117,110,0,0,0,0,0,77,111,110,0,0,0,0,0,84,117,101,0,0,0,0,0,87,101,100,0,0,0,0,0,84,104,117,0,0,0,0,0,70,114,105,0,0,0,0,0,83,97,116,0,0,0,0,0,2,0,0,192,3,0,0,192,4,0,0,192,5,0,0,192,6,0,0,192,7,0,0,192,8,0,0,192,9,0,0,192,10,0,0,192,11,0,0,192,12,0,0,192,13,0,0,192,14,0,0,192,15,0,0,192,16,0,0,192,17,0,0,192,18,0,0,192,19,0,0,192,20,0,0,192,21,0,0,192,22,0,0,192,23,0,0,192,24,0,0,192,25,0,0,192,26,0,0,192,27,0,0,192,28,0,0,192,29,0,0,192,30,0,0,192,31,0,0,192,0,0,0,179,1,0,0,195,2,0,0,195,3,0,0,195,4,0,0,195,5,0,0,195,6,0,0,195,7,0,0,195,8,0,0,195,9,0,0,195,10,0,0,195,11,0,0,195,12,0,0,195,13,0,0,211,14,0,0,195,15,0,0,195,0,0,12,187,1,0,12,195,2,0,12,195,3,0,12,195,4,0,12,211,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,248,94,0,0,171,0,0,0,172,0,0,0,117,0,0,0,0,0,0,0,115,116,100,58,58,98,97,100,95,99,97,115,116,0,0,0,83,116,57,116,121,112,101,95,105,110,102,111,0,0,0,0,128,95,0,0,208,94,0,0,83,116,56,98,97,100,95,99,97,115,116,0,0,0,0,0,152,96,0,0,232,94,0,0,0,0,0,0,0,0,0,0,78,49,48,95,95,99,120,120,97,98,105,118,49,49,54,95,95,115,104,105,109,95,116,121,112,101,95,105,110,102,111,69,0,0,0,0,0,0,0,0,152,96,0,0,8,95,0,0,224,94,0,0,0,0,0,0,78,49,48,95,95,99,120,120,97,98,105,118,49,49,55,95,95,99,108,97,115,115,95,116,121,112,101,95,105,110,102,111,69,0,0,0,0,0,0,0,152,96,0,0,64,95,0,0,48,95,0,0,0,0,0,0,0,0,0,0,104,95,0,0,173,0,0,0,174,0,0,0,175,0,0,0,176,0,0,0,22,0,0,0,17,0,0,0,1,0,0,0,14,0,0,0,0,0,0,0,232,95,0,0,173,0,0,0,177,0,0,0,175,0,0,0,176,0,0,0,23,0,0,0,0,0,0,0,78,49,48,95,95,99,120,120,97,98,105,118,49,50,51,95,95,102,117,110,100,97,109,101,110,116,97,108,95,116,121,112,101,95,105,110,102,111,69,0,152,96,0,0,192,95,0,0,48,95,0,0,0,0,0,0,98,0,0,0,0,0,0,0,168,95,0,0,248,95,0,0,105,0,0,0,0,0,0,0,168,95,0,0,8,96,0,0,106,0,0,0,0,0,0,0,168,95,0,0,24,96,0,0,102,0,0,0,0,0,0,0,168,95,0,0,40,96,0,0,0,0,0,0,128,96,0,0,173,0,0,0,178,0,0,0,175,0,0,0,176,0,0,0,24,0,0,0,0,0,0,0,78,49,48,95,95,99,120,120,97,98,105,118,49,49,54,95,95,101,110,117,109,95,116,121,112,101,95,105,110,102,111,69,0,0,0,0,0,0,0,0,152,96,0,0,88,96,0,0,48,95,0,0,0,0,0,0,0,0,0,0,224,96,0,0,173,0,0,0,179,0,0,0,175,0,0,0,176,0,0,0,22,0,0,0,18,0,0,0,2,0,0,0,15,0,0,0,78,49,48,95,95,99,120,120,97,98,105,118,49,50,48,95,95,115,105,95,99,108,97,115,115,95,116,121,112,101,95,105,110,102,111,69,0,0,0,0,152,96,0,0,184,96,0,0,104,95,0,0,0,0,0,0,0,0,0,0,64,97,0,0,173,0,0,0,180,0,0,0,175,0,0,0,176,0,0,0,22,0,0,0,19,0,0,0,3,0,0,0,16,0,0,0,78,49,48,95,95,99,120,120,97,98,105,118,49,50,49,95,95,118,109,105,95,99,108,97,115,115,95,116,121,112,101,95,105,110,102,111,69,0,0,0,152,96,0,0,24,97,0,0,104,95,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,99,0,0,181,0,0,0,182,0,0,0,118,0,0,0,0,0,0,0,115,116,100,58,58,98,97,100,95,97,108,108,111,99,0,0,83,116,57,98,97,100,95,97,108,108,111,99,0,0,0,0,152,96,0,0,112,99,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,1,2,3,4,5,6,7,8,9,255,255,255,255,255,255,255,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,255,255,255,255,255,255,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,1,2,4,7,3,6,5,0,0,0,0,0,0,0,0,105,110,102,105,110,105,116,121,0,0,0,0,0,0,0,0,110,97,110,0,0,0,0,0,95,112,137,0,255,9,47,15,10,0,0,0,100,0,0,0,232,3,0,0,16,39,0,0,160,134,1,0,64,66,15,0,128,150,152,0,0,225,245,5,17,0,10,0,17,17,17,0,0,0,0,5,0,0,0,0,0,0,9,0,0,0,0,11,0,0,0,0,0,0,0,0,17,0,15,10,17,17,17,3,10,7,0,1,19,9,11,11,0,0,9,6,11,0,0,11,0,6,17,0,0,0,17,17,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,0,17,0,10,10,17,17,17,0,10,0,0,2,0,9,11,0,0,0,9,0,11,0,0,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,0,12,0,0,0,0,9,12,0,0,0,0,0,12,0,0,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,0,0,0,0,0,0,0,0,0,0,0,13,0,0,0,4,13,0,0,0,0,9,14,0,0,0,0,0,14,0,0,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,0,0,0,0,0,0,0,0,0,0,0,15,0,0,0,0,15,0,0,0,0,9,16,0,0,0,0,0,16,0,0,16,0,0,18,0,0,0,18,18,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,0,0,0,18,18,18,0,0,0,0,0,0,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,0,0,0,0,10,0,0,0,0,10,0,0,0,0,9,11,0,0,0,0,0,11,0,0,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,0,12,0,0,0,0,9,12,0,0,0,0,0,12,0,0,12,0,0,45,43,32,32,32,48,88,48,120,0,0,0,0,0,0,0,40,110,117,108,108,41,0,0,45,48,88,43,48,88,32,48,88,45,48,120,43,48,120,32,48,120,0,0,0,0,0,0,105,110,102,0,0,0,0,0,73,78,70,0,0,0,0,0,110,97,110,0,0,0,0,0,78,65,78,0,0,0,0,0,48,49,50,51,52,53,54,55,56,57,65,66,67,68,69,70,46,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+22936);var tempDoublePtr=Runtime.alignMemory(allocate(12,"i8",ALLOC_STATIC),8);assert(tempDoublePtr%8==0);function copyTempFloat(ptr){HEAP8[tempDoublePtr]=HEAP8[ptr];HEAP8[tempDoublePtr+1]=HEAP8[ptr+1];HEAP8[tempDoublePtr+2]=HEAP8[ptr+2];HEAP8[tempDoublePtr+3]=HEAP8[ptr+3]}function copyTempDouble(ptr){HEAP8[tempDoublePtr]=HEAP8[ptr];HEAP8[tempDoublePtr+1]=HEAP8[ptr+1];HEAP8[tempDoublePtr+2]=HEAP8[ptr+2];HEAP8[tempDoublePtr+3]=HEAP8[ptr+3];HEAP8[tempDoublePtr+4]=HEAP8[ptr+4];HEAP8[tempDoublePtr+5]=HEAP8[ptr+5];HEAP8[tempDoublePtr+6]=HEAP8[ptr+6];HEAP8[tempDoublePtr+7]=HEAP8[ptr+7]}function _atexit(func,arg){__ATEXIT__.unshift({func:func,arg:arg})}function ___cxa_atexit(){return _atexit.apply(null,arguments)}Module["_rand_r"]=_rand_r;var ___rand_seed=allocate([41108891,0,0,0],"i32",ALLOC_STATIC);Module["_rand"]=_rand;Module["_i64Subtract"]=_i64Subtract;function _fabsf(){return Math_abs.apply(null,arguments)}Module["_i64Add"]=_i64Add;function __ZSt18uncaught_exceptionv(){return!!__ZSt18uncaught_exceptionv.uncaught_exception}function ___cxa_is_number_type(type){var isNumber=false;try{if(type==__ZTIi)isNumber=true}catch(e){}try{if(type==__ZTIj)isNumber=true}catch(e){}try{if(type==__ZTIl)isNumber=true}catch(e){}try{if(type==__ZTIm)isNumber=true}catch(e){}try{if(type==__ZTIx)isNumber=true}catch(e){}try{if(type==__ZTIy)isNumber=true}catch(e){}try{if(type==__ZTIf)isNumber=true}catch(e){}try{if(type==__ZTId)isNumber=true}catch(e){}try{if(type==__ZTIe)isNumber=true}catch(e){}try{if(type==__ZTIc)isNumber=true}catch(e){}try{if(type==__ZTIa)isNumber=true}catch(e){}try{if(type==__ZTIh)isNumber=true}catch(e){}try{if(type==__ZTIs)isNumber=true}catch(e){}try{if(type==__ZTIt)isNumber=true}catch(e){}return isNumber}function ___cxa_does_inherit(definiteType,possibilityType,possibility){if(possibility==0)return false;if(possibilityType==0||possibilityType==definiteType)return true;var possibility_type_info;if(___cxa_is_number_type(possibilityType)){possibility_type_info=possibilityType}else{var possibility_type_infoAddr=HEAP32[possibilityType>>2]-8;possibility_type_info=HEAP32[possibility_type_infoAddr>>2]}switch(possibility_type_info){case 0:var definite_type_infoAddr=HEAP32[definiteType>>2]-8;var definite_type_info=HEAP32[definite_type_infoAddr>>2];if(definite_type_info==0){var defPointerBaseAddr=definiteType+8;var defPointerBaseType=HEAP32[defPointerBaseAddr>>2];var possPointerBaseAddr=possibilityType+8;var possPointerBaseType=HEAP32[possPointerBaseAddr>>2];return ___cxa_does_inherit(defPointerBaseType,possPointerBaseType,possibility)}else return false;case 1:return false;case 2:var parentTypeAddr=possibilityType+8;var parentType=HEAP32[parentTypeAddr>>2];return ___cxa_does_inherit(definiteType,parentType,possibility);default:return false}}var ___cxa_last_thrown_exception=0;function ___resumeException(ptr){if(!___cxa_last_thrown_exception){___cxa_last_thrown_exception=ptr}throw ptr}var ___cxa_exception_header_size=8;function ___cxa_find_matching_catch(thrown,throwntype){if(thrown==-1)thrown=___cxa_last_thrown_exception;header=thrown-___cxa_exception_header_size;if(throwntype==-1)throwntype=HEAP32[header>>2];var typeArray=Array.prototype.slice.call(arguments,2);if(throwntype!=0&&!___cxa_is_number_type(throwntype)){var throwntypeInfoAddr=HEAP32[throwntype>>2]-8;var throwntypeInfo=HEAP32[throwntypeInfoAddr>>2];if(throwntypeInfo==0)thrown=HEAP32[thrown>>2]}for(var i=0;i<typeArray.length;i++){if(___cxa_does_inherit(typeArray[i],throwntype,thrown))return(asm["setTempRet0"](typeArray[i]),thrown)|0}return(asm["setTempRet0"](throwntype),thrown)|0}function ___cxa_throw(ptr,type,destructor){if(!___cxa_throw.initialized){try{HEAP32[__ZTVN10__cxxabiv119__pointer_type_infoE>>2]=0}catch(e){}try{HEAP32[__ZTVN10__cxxabiv117__class_type_infoE>>2]=1}catch(e){}try{HEAP32[__ZTVN10__cxxabiv120__si_class_type_infoE>>2]=2}catch(e){}___cxa_throw.initialized=true}var header=ptr-___cxa_exception_header_size;HEAP32[header>>2]=type;HEAP32[header+4>>2]=destructor;___cxa_last_thrown_exception=ptr;if(!("uncaught_exception"in __ZSt18uncaught_exceptionv)){__ZSt18uncaught_exceptionv.uncaught_exception=1}else{__ZSt18uncaught_exceptionv.uncaught_exception++}throw ptr}var ERRNO_CODES={EPERM:1,ENOENT:2,ESRCH:3,EINTR:4,EIO:5,ENXIO:6,E2BIG:7,ENOEXEC:8,EBADF:9,ECHILD:10,EAGAIN:11,EWOULDBLOCK:11,ENOMEM:12,EACCES:13,EFAULT:14,ENOTBLK:15,EBUSY:16,EEXIST:17,EXDEV:18,ENODEV:19,ENOTDIR:20,EISDIR:21,EINVAL:22,ENFILE:23,EMFILE:24,ENOTTY:25,ETXTBSY:26,EFBIG:27,ENOSPC:28,ESPIPE:29,EROFS:30,EMLINK:31,EPIPE:32,EDOM:33,ERANGE:34,ENOMSG:42,EIDRM:43,ECHRNG:44,EL2NSYNC:45,EL3HLT:46,EL3RST:47,ELNRNG:48,EUNATCH:49,ENOCSI:50,EL2HLT:51,EDEADLK:35,ENOLCK:37,EBADE:52,EBADR:53,EXFULL:54,ENOANO:55,EBADRQC:56,EBADSLT:57,EDEADLOCK:35,EBFONT:59,ENOSTR:60,ENODATA:61,ETIME:62,ENOSR:63,ENONET:64,ENOPKG:65,EREMOTE:66,ENOLINK:67,EADV:68,ESRMNT:69,ECOMM:70,EPROTO:71,EMULTIHOP:72,EDOTDOT:73,EBADMSG:74,ENOTUNIQ:76,EBADFD:77,EREMCHG:78,ELIBACC:79,ELIBBAD:80,ELIBSCN:81,ELIBMAX:82,ELIBEXEC:83,ENOSYS:38,ENOTEMPTY:39,ENAMETOOLONG:36,ELOOP:40,EOPNOTSUPP:95,EPFNOSUPPORT:96,ECONNRESET:104,ENOBUFS:105,EAFNOSUPPORT:97,EPROTOTYPE:91,ENOTSOCK:88,ENOPROTOOPT:92,ESHUTDOWN:108,ECONNREFUSED:111,EADDRINUSE:98,ECONNABORTED:103,ENETUNREACH:101,ENETDOWN:100,ETIMEDOUT:110,EHOSTDOWN:112,EHOSTUNREACH:113,EINPROGRESS:115,EALREADY:114,EDESTADDRREQ:89,EMSGSIZE:90,EPROTONOSUPPORT:93,ESOCKTNOSUPPORT:94,EADDRNOTAVAIL:99,ENETRESET:102,EISCONN:106,ENOTCONN:107,ETOOMANYREFS:109,EUSERS:87,EDQUOT:122,ESTALE:116,ENOTSUP:95,ENOMEDIUM:123,EILSEQ:84,EOVERFLOW:75,ECANCELED:125,ENOTRECOVERABLE:131,EOWNERDEAD:130,ESTRPIPE:86};var ERRNO_MESSAGES={0:"Success",1:"Not super-user",2:"No such file or directory",3:"No such process",4:"Interrupted system call",5:"I/O error",6:"No such device or address",7:"Arg list too long",8:"Exec format error",9:"Bad file number",10:"No children",11:"No more processes",12:"Not enough core",13:"Permission denied",14:"Bad address",15:"Block device required",16:"Mount device busy",17:"File exists",18:"Cross-device link",19:"No such device",20:"Not a directory",21:"Is a directory",22:"Invalid argument",23:"Too many open files in system",24:"Too many open files",25:"Not a typewriter",26:"Text file busy",27:"File too large",28:"No space left on device",29:"Illegal seek",30:"Read only file system",31:"Too many links",32:"Broken pipe",33:"Math arg out of domain of func",34:"Math result not representable",35:"File locking deadlock error",36:"File or path name too long",37:"No record locks available",38:"Function not implemented",39:"Directory not empty",40:"Too many symbolic links",42:"No message of desired type",43:"Identifier removed",44:"Channel number out of range",45:"Level 2 not synchronized",46:"Level 3 halted",47:"Level 3 reset",48:"Link number out of range",49:"Protocol driver not attached",50:"No CSI structure available",51:"Level 2 halted",52:"Invalid exchange",53:"Invalid request descriptor",54:"Exchange full",55:"No anode",56:"Invalid request code",57:"Invalid slot",59:"Bad font file fmt",60:"Device not a stream",61:"No data (for no delay io)",62:"Timer expired",63:"Out of streams resources",64:"Machine is not on the network",65:"Package not installed",66:"The object is remote",67:"The link has been severed",68:"Advertise error",69:"Srmount error",70:"Communication error on send",71:"Protocol error",72:"Multihop attempted",73:"Cross mount point (not really error)",74:"Trying to read unreadable message",75:"Value too large for defined data type",76:"Given log. name not unique",77:"f.d. invalid for this operation",78:"Remote address changed",79:"Can   access a needed shared lib",80:"Accessing a corrupted shared lib",81:".lib section in a.out corrupted",82:"Attempting to link in too many libs",83:"Attempting to exec a shared library",84:"Illegal byte sequence",86:"Streams pipe error",87:"Too many users",88:"Socket operation on non-socket",89:"Destination address required",90:"Message too long",91:"Protocol wrong type for socket",92:"Protocol not available",93:"Unknown protocol",94:"Socket type not supported",95:"Not supported",96:"Protocol family not supported",97:"Address family not supported by protocol family",98:"Address already in use",99:"Address not available",100:"Network interface is not configured",101:"Network is unreachable",102:"Connection reset by network",103:"Connection aborted",104:"Connection reset by peer",105:"No buffer space available",106:"Socket is already connected",107:"Socket is not connected",108:"Can't send after socket shutdown",109:"Too many references",110:"Connection timed out",111:"Connection refused",112:"Host is down",113:"Host is unreachable",114:"Socket already connected",115:"Connection already in progress",116:"Stale file handle",122:"Quota exceeded",123:"No medium (in tape drive)",125:"Operation canceled",130:"Previous owner died",131:"State not recoverable"};var ___errno_state=0;function ___setErrNo(value){HEAP32[___errno_state>>2]=value;return value}var PATH={splitPath:(function(filename){var splitPathRe=/^(\/?|)([\s\S]*?)((?:\.{1,2}|[^\/]+?|)(\.[^.\/]*|))(?:[\/]*)$/;return splitPathRe.exec(filename).slice(1)}),normalizeArray:(function(parts,allowAboveRoot){var up=0;for(var i=parts.length-1;i>=0;i--){var last=parts[i];if(last==="."){parts.splice(i,1)}else if(last===".."){parts.splice(i,1);up++}else if(up){parts.splice(i,1);up--}}if(allowAboveRoot){for(;up--;up){parts.unshift("..")}}return parts}),normalize:(function(path){var isAbsolute=path.charAt(0)==="/",trailingSlash=path.substr(-1)==="/";path=PATH.normalizeArray(path.split("/").filter((function(p){return!!p})),!isAbsolute).join("/");if(!path&&!isAbsolute){path="."}if(path&&trailingSlash){path+="/"}return(isAbsolute?"/":"")+path}),dirname:(function(path){var result=PATH.splitPath(path),root=result[0],dir=result[1];if(!root&&!dir){return"."}if(dir){dir=dir.substr(0,dir.length-1)}return root+dir}),basename:(function(path){if(path==="/")return"/";var lastSlash=path.lastIndexOf("/");if(lastSlash===-1)return path;return path.substr(lastSlash+1)}),extname:(function(path){return PATH.splitPath(path)[3]}),join:(function(){var paths=Array.prototype.slice.call(arguments,0);return PATH.normalize(paths.join("/"))}),join2:(function(l,r){return PATH.normalize(l+"/"+r)}),resolve:(function(){var resolvedPath="",resolvedAbsolute=false;for(var i=arguments.length-1;i>=-1&&!resolvedAbsolute;i--){var path=i>=0?arguments[i]:FS.cwd();if(typeof path!=="string"){throw new TypeError("Arguments to path.resolve must be strings")}else if(!path){continue}resolvedPath=path+"/"+resolvedPath;resolvedAbsolute=path.charAt(0)==="/"}resolvedPath=PATH.normalizeArray(resolvedPath.split("/").filter((function(p){return!!p})),!resolvedAbsolute).join("/");return(resolvedAbsolute?"/":"")+resolvedPath||"."}),relative:(function(from,to){from=PATH.resolve(from).substr(1);to=PATH.resolve(to).substr(1);function trim(arr){var start=0;for(;start<arr.length;start++){if(arr[start]!=="")break}var end=arr.length-1;for(;end>=0;end--){if(arr[end]!=="")break}if(start>end)return[];return arr.slice(start,end-start+1)}var fromParts=trim(from.split("/"));var toParts=trim(to.split("/"));var length=Math.min(fromParts.length,toParts.length);var samePartsLength=length;for(var i=0;i<length;i++){if(fromParts[i]!==toParts[i]){samePartsLength=i;break}}var outputParts=[];for(var i=samePartsLength;i<fromParts.length;i++){outputParts.push("..")}outputParts=outputParts.concat(toParts.slice(samePartsLength));return outputParts.join("/")})};var TTY={ttys:[],init:(function(){}),shutdown:(function(){}),register:(function(dev,ops){TTY.ttys[dev]={input:[],output:[],ops:ops};FS.registerDevice(dev,TTY.stream_ops)}),stream_ops:{open:(function(stream){var tty=TTY.ttys[stream.node.rdev];if(!tty){throw new FS.ErrnoError(ERRNO_CODES.ENODEV)}stream.tty=tty;stream.seekable=false}),close:(function(stream){if(stream.tty.output.length){stream.tty.ops.put_char(stream.tty,10)}}),read:(function(stream,buffer,offset,length,pos){if(!stream.tty||!stream.tty.ops.get_char){throw new FS.ErrnoError(ERRNO_CODES.ENXIO)}var bytesRead=0;for(var i=0;i<length;i++){var result;try{result=stream.tty.ops.get_char(stream.tty)}catch(e){throw new FS.ErrnoError(ERRNO_CODES.EIO)}if(result===undefined&&bytesRead===0){throw new FS.ErrnoError(ERRNO_CODES.EAGAIN)}if(result===null||result===undefined)break;bytesRead++;buffer[offset+i]=result}if(bytesRead){stream.node.timestamp=Date.now()}return bytesRead}),write:(function(stream,buffer,offset,length,pos){if(!stream.tty||!stream.tty.ops.put_char){throw new FS.ErrnoError(ERRNO_CODES.ENXIO)}for(var i=0;i<length;i++){try{stream.tty.ops.put_char(stream.tty,buffer[offset+i])}catch(e){throw new FS.ErrnoError(ERRNO_CODES.EIO)}}if(length){stream.node.timestamp=Date.now()}return i})},default_tty_ops:{get_char:(function(tty){if(!tty.input.length){var result=null;if(ENVIRONMENT_IS_NODE){result=process["stdin"]["read"]();if(!result){if(process["stdin"]["_readableState"]&&process["stdin"]["_readableState"]["ended"]){return null}return undefined}}else if(typeof window!="undefined"&&typeof window.prompt=="function"){result=window.prompt("Input: ");if(result!==null){result+="\n"}}else if(typeof readline=="function"){result=readline();if(result!==null){result+="\n"}}if(!result){return null}tty.input=intArrayFromString(result,true)}return tty.input.shift()}),put_char:(function(tty,val){if(val===null||val===10){Module["print"](tty.output.join(""));tty.output=[]}else{tty.output.push(TTY.utf8.processCChar(val))}})},default_tty1_ops:{put_char:(function(tty,val){if(val===null||val===10){Module["printErr"](tty.output.join(""));tty.output=[]}else{tty.output.push(TTY.utf8.processCChar(val))}})}};var MEMFS={ops_table:null,mount:(function(mount){return MEMFS.createNode(null,"/",16384|511,0)}),createNode:(function(parent,name,mode,dev){if(FS.isBlkdev(mode)||FS.isFIFO(mode)){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}if(!MEMFS.ops_table){MEMFS.ops_table={dir:{node:{getattr:MEMFS.node_ops.getattr,setattr:MEMFS.node_ops.setattr,lookup:MEMFS.node_ops.lookup,mknod:MEMFS.node_ops.mknod,rename:MEMFS.node_ops.rename,unlink:MEMFS.node_ops.unlink,rmdir:MEMFS.node_ops.rmdir,readdir:MEMFS.node_ops.readdir,symlink:MEMFS.node_ops.symlink},stream:{llseek:MEMFS.stream_ops.llseek}},file:{node:{getattr:MEMFS.node_ops.getattr,setattr:MEMFS.node_ops.setattr},stream:{llseek:MEMFS.stream_ops.llseek,read:MEMFS.stream_ops.read,write:MEMFS.stream_ops.write,allocate:MEMFS.stream_ops.allocate,mmap:MEMFS.stream_ops.mmap}},link:{node:{getattr:MEMFS.node_ops.getattr,setattr:MEMFS.node_ops.setattr,readlink:MEMFS.node_ops.readlink},stream:{}},chrdev:{node:{getattr:MEMFS.node_ops.getattr,setattr:MEMFS.node_ops.setattr},stream:FS.chrdev_stream_ops}}}var node=FS.createNode(parent,name,mode,dev);if(FS.isDir(node.mode)){node.node_ops=MEMFS.ops_table.dir.node;node.stream_ops=MEMFS.ops_table.dir.stream;node.contents={}}else if(FS.isFile(node.mode)){node.node_ops=MEMFS.ops_table.file.node;node.stream_ops=MEMFS.ops_table.file.stream;node.usedBytes=0;node.contents=null}else if(FS.isLink(node.mode)){node.node_ops=MEMFS.ops_table.link.node;node.stream_ops=MEMFS.ops_table.link.stream}else if(FS.isChrdev(node.mode)){node.node_ops=MEMFS.ops_table.chrdev.node;node.stream_ops=MEMFS.ops_table.chrdev.stream}node.timestamp=Date.now();if(parent){parent.contents[name]=node}return node}),getFileDataAsRegularArray:(function(node){if(node.contents&&node.contents.subarray){var arr=[];for(var i=0;i<node.usedBytes;++i)arr.push(node.contents[i]);return arr}return node.contents}),getFileDataAsTypedArray:(function(node){if(node.contents&&node.contents.subarray)return node.contents.subarray(0,node.usedBytes);return new Uint8Array(node.contents)}),expandFileStorage:(function(node,newCapacity){if(node.contents&&node.contents.subarray&&newCapacity>node.contents.length){node.contents=MEMFS.getFileDataAsRegularArray(node);node.usedBytes=node.contents.length}if(!node.contents||node.contents.subarray){var prevCapacity=node.contents?node.contents.buffer.byteLength:0;if(prevCapacity>=newCapacity)return;var CAPACITY_DOUBLING_MAX=1024*1024;newCapacity=Math.max(newCapacity,prevCapacity*(prevCapacity<CAPACITY_DOUBLING_MAX?2:1.125)|0);if(prevCapacity!=0)newCapacity=Math.max(newCapacity,256);var oldContents=node.contents;node.contents=new Uint8Array(newCapacity);if(node.usedBytes>0)node.contents.set(oldContents.subarray(0,node.usedBytes),0);return}if(!node.contents&&newCapacity>0)node.contents=[];while(node.contents.length<newCapacity)node.contents.push(0)}),resizeFileStorage:(function(node,newSize){if(node.usedBytes==newSize)return;if(newSize==0){node.contents=null;node.usedBytes=0;return}if(!node.contents||node.contents.subarray){var oldContents=node.contents;node.contents=new Uint8Array(new ArrayBuffer(newSize));node.contents.set(oldContents.subarray(0,Math.min(newSize,node.usedBytes)));node.usedBytes=newSize;return}if(!node.contents)node.contents=[];if(node.contents.length>newSize)node.contents.length=newSize;else while(node.contents.length<newSize)node.contents.push(0);node.usedBytes=newSize}),node_ops:{getattr:(function(node){var attr={};attr.dev=FS.isChrdev(node.mode)?node.id:1;attr.ino=node.id;attr.mode=node.mode;attr.nlink=1;attr.uid=0;attr.gid=0;attr.rdev=node.rdev;if(FS.isDir(node.mode)){attr.size=4096}else if(FS.isFile(node.mode)){attr.size=node.usedBytes}else if(FS.isLink(node.mode)){attr.size=node.link.length}else{attr.size=0}attr.atime=new Date(node.timestamp);attr.mtime=new Date(node.timestamp);attr.ctime=new Date(node.timestamp);attr.blksize=4096;attr.blocks=Math.ceil(attr.size/attr.blksize);return attr}),setattr:(function(node,attr){if(attr.mode!==undefined){node.mode=attr.mode}if(attr.timestamp!==undefined){node.timestamp=attr.timestamp}if(attr.size!==undefined){MEMFS.resizeFileStorage(node,attr.size)}}),lookup:(function(parent,name){throw FS.genericErrors[ERRNO_CODES.ENOENT]}),mknod:(function(parent,name,mode,dev){return MEMFS.createNode(parent,name,mode,dev)}),rename:(function(old_node,new_dir,new_name){if(FS.isDir(old_node.mode)){var new_node;try{new_node=FS.lookupNode(new_dir,new_name)}catch(e){}if(new_node){for(var i in new_node.contents){throw new FS.ErrnoError(ERRNO_CODES.ENOTEMPTY)}}}delete old_node.parent.contents[old_node.name];old_node.name=new_name;new_dir.contents[new_name]=old_node;old_node.parent=new_dir}),unlink:(function(parent,name){delete parent.contents[name]}),rmdir:(function(parent,name){var node=FS.lookupNode(parent,name);for(var i in node.contents){throw new FS.ErrnoError(ERRNO_CODES.ENOTEMPTY)}delete parent.contents[name]}),readdir:(function(node){var entries=[".",".."];for(var key in node.contents){if(!node.contents.hasOwnProperty(key)){continue}entries.push(key)}return entries}),symlink:(function(parent,newname,oldpath){var node=MEMFS.createNode(parent,newname,511|40960,0);node.link=oldpath;return node}),readlink:(function(node){if(!FS.isLink(node.mode)){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}return node.link})},stream_ops:{read:(function(stream,buffer,offset,length,position){var contents=stream.node.contents;if(position>=stream.node.usedBytes)return 0;var size=Math.min(stream.node.usedBytes-position,length);assert(size>=0);if(size>8&&contents.subarray){buffer.set(contents.subarray(position,position+size),offset)}else{for(var i=0;i<size;i++)buffer[offset+i]=contents[position+i]}return size}),write:(function(stream,buffer,offset,length,position,canOwn){if(!length)return 0;var node=stream.node;node.timestamp=Date.now();if(buffer.subarray&&(!node.contents||node.contents.subarray)){if(canOwn){node.contents=buffer.subarray(offset,offset+length);node.usedBytes=length;return length}else if(node.usedBytes===0&&position===0){node.contents=new Uint8Array(buffer.subarray(offset,offset+length));node.usedBytes=length;return length}else if(position+length<=node.usedBytes){node.contents.set(buffer.subarray(offset,offset+length),position);return length}}MEMFS.expandFileStorage(node,position+length);if(node.contents.subarray&&buffer.subarray)node.contents.set(buffer.subarray(offset,offset+length),position);else for(var i=0;i<length;i++){node.contents[position+i]=buffer[offset+i]}node.usedBytes=Math.max(node.usedBytes,position+length);return length}),llseek:(function(stream,offset,whence){var position=offset;if(whence===1){position+=stream.position}else if(whence===2){if(FS.isFile(stream.node.mode)){position+=stream.node.usedBytes}}if(position<0){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}stream.ungotten=[];stream.position=position;return position}),allocate:(function(stream,offset,length){MEMFS.expandFileStorage(stream.node,offset+length);stream.node.usedBytes=Math.max(stream.node.usedBytes,offset+length)}),mmap:(function(stream,buffer,offset,length,position,prot,flags){if(!FS.isFile(stream.node.mode)){throw new FS.ErrnoError(ERRNO_CODES.ENODEV)}var ptr;var allocated;var contents=stream.node.contents;if(!(flags&2)&&(contents.buffer===buffer||contents.buffer===buffer.buffer)){allocated=false;ptr=contents.byteOffset}else{if(position>0||position+length<stream.node.usedBytes){if(contents.subarray){contents=contents.subarray(position,position+length)}else{contents=Array.prototype.slice.call(contents,position,position+length)}}allocated=true;ptr=_malloc(length);if(!ptr){throw new FS.ErrnoError(ERRNO_CODES.ENOMEM)}buffer.set(contents,ptr)}return{ptr:ptr,allocated:allocated}})}};var IDBFS={dbs:{},indexedDB:(function(){return window.indexedDB||window.mozIndexedDB||window.webkitIndexedDB||window.msIndexedDB}),DB_VERSION:21,DB_STORE_NAME:"FILE_DATA",mount:(function(mount){return MEMFS.mount.apply(null,arguments)}),syncfs:(function(mount,populate,callback){IDBFS.getLocalSet(mount,(function(err,local){if(err)return callback(err);IDBFS.getRemoteSet(mount,(function(err,remote){if(err)return callback(err);var src=populate?remote:local;var dst=populate?local:remote;IDBFS.reconcile(src,dst,callback)}))}))}),getDB:(function(name,callback){var db=IDBFS.dbs[name];if(db){return callback(null,db)}var req;try{req=IDBFS.indexedDB().open(name,IDBFS.DB_VERSION)}catch(e){return callback(e)}req.onupgradeneeded=(function(e){var db=e.target.result;var transaction=e.target.transaction;var fileStore;if(db.objectStoreNames.contains(IDBFS.DB_STORE_NAME)){fileStore=transaction.objectStore(IDBFS.DB_STORE_NAME)}else{fileStore=db.createObjectStore(IDBFS.DB_STORE_NAME)}fileStore.createIndex("timestamp","timestamp",{unique:false})});req.onsuccess=(function(){db=req.result;IDBFS.dbs[name]=db;callback(null,db)});req.onerror=(function(){callback(this.error)})}),getLocalSet:(function(mount,callback){var entries={};function isRealDir(p){return p!=="."&&p!==".."}function toAbsolute(root){return(function(p){return PATH.join2(root,p)})}var check=FS.readdir(mount.mountpoint).filter(isRealDir).map(toAbsolute(mount.mountpoint));while(check.length){var path=check.pop();var stat;try{stat=FS.stat(path)}catch(e){return callback(e)}if(FS.isDir(stat.mode)){check.push.apply(check,FS.readdir(path).filter(isRealDir).map(toAbsolute(path)))}entries[path]={timestamp:stat.mtime}}return callback(null,{type:"local",entries:entries})}),getRemoteSet:(function(mount,callback){var entries={};IDBFS.getDB(mount.mountpoint,(function(err,db){if(err)return callback(err);var transaction=db.transaction([IDBFS.DB_STORE_NAME],"readonly");transaction.onerror=(function(){callback(this.error)});var store=transaction.objectStore(IDBFS.DB_STORE_NAME);var index=store.index("timestamp");index.openKeyCursor().onsuccess=(function(event){var cursor=event.target.result;if(!cursor){return callback(null,{type:"remote",db:db,entries:entries})}entries[cursor.primaryKey]={timestamp:cursor.key};cursor.continue()})}))}),loadLocalEntry:(function(path,callback){var stat,node;try{var lookup=FS.lookupPath(path);node=lookup.node;stat=FS.stat(path)}catch(e){return callback(e)}if(FS.isDir(stat.mode)){return callback(null,{timestamp:stat.mtime,mode:stat.mode})}else if(FS.isFile(stat.mode)){node.contents=MEMFS.getFileDataAsTypedArray(node);return callback(null,{timestamp:stat.mtime,mode:stat.mode,contents:node.contents})}else{return callback(new Error("node type not supported"))}}),storeLocalEntry:(function(path,entry,callback){try{if(FS.isDir(entry.mode)){FS.mkdir(path,entry.mode)}else if(FS.isFile(entry.mode)){FS.writeFile(path,entry.contents,{encoding:"binary",canOwn:true})}else{return callback(new Error("node type not supported"))}FS.utime(path,entry.timestamp,entry.timestamp)}catch(e){return callback(e)}callback(null)}),removeLocalEntry:(function(path,callback){try{var lookup=FS.lookupPath(path);var stat=FS.stat(path);if(FS.isDir(stat.mode)){FS.rmdir(path)}else if(FS.isFile(stat.mode)){FS.unlink(path)}}catch(e){return callback(e)}callback(null)}),loadRemoteEntry:(function(store,path,callback){var req=store.get(path);req.onsuccess=(function(event){callback(null,event.target.result)});req.onerror=(function(){callback(this.error)})}),storeRemoteEntry:(function(store,path,entry,callback){var req=store.put(entry,path);req.onsuccess=(function(){callback(null)});req.onerror=(function(){callback(this.error)})}),removeRemoteEntry:(function(store,path,callback){var req=store.delete(path);req.onsuccess=(function(){callback(null)});req.onerror=(function(){callback(this.error)})}),reconcile:(function(src,dst,callback){var total=0;var create=[];Object.keys(src.entries).forEach((function(key){var e=src.entries[key];var e2=dst.entries[key];if(!e2||e.timestamp>e2.timestamp){create.push(key);total++}}));var remove=[];Object.keys(dst.entries).forEach((function(key){var e=dst.entries[key];var e2=src.entries[key];if(!e2){remove.push(key);total++}}));if(!total){return callback(null)}var errored=false;var completed=0;var db=src.type==="remote"?src.db:dst.db;var transaction=db.transaction([IDBFS.DB_STORE_NAME],"readwrite");var store=transaction.objectStore(IDBFS.DB_STORE_NAME);function done(err){if(err){if(!done.errored){done.errored=true;return callback(err)}return}if(++completed>=total){return callback(null)}}transaction.onerror=(function(){done(this.error)});create.sort().forEach((function(path){if(dst.type==="local"){IDBFS.loadRemoteEntry(store,path,(function(err,entry){if(err)return done(err);IDBFS.storeLocalEntry(path,entry,done)}))}else{IDBFS.loadLocalEntry(path,(function(err,entry){if(err)return done(err);IDBFS.storeRemoteEntry(store,path,entry,done)}))}}));remove.sort().reverse().forEach((function(path){if(dst.type==="local"){IDBFS.removeLocalEntry(path,done)}else{IDBFS.removeRemoteEntry(store,path,done)}}))})};var NODEFS={isWindows:false,staticInit:(function(){NODEFS.isWindows=!!process.platform.match(/^win/)}),mount:(function(mount){assert(ENVIRONMENT_IS_NODE);return NODEFS.createNode(null,"/",NODEFS.getMode(mount.opts.root),0)}),createNode:(function(parent,name,mode,dev){if(!FS.isDir(mode)&&!FS.isFile(mode)&&!FS.isLink(mode)){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}var node=FS.createNode(parent,name,mode);node.node_ops=NODEFS.node_ops;node.stream_ops=NODEFS.stream_ops;return node}),getMode:(function(path){var stat;try{stat=fs.lstatSync(path);if(NODEFS.isWindows){stat.mode=stat.mode|(stat.mode&146)>>1}}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}return stat.mode}),realPath:(function(node){var parts=[];while(node.parent!==node){parts.push(node.name);node=node.parent}parts.push(node.mount.opts.root);parts.reverse();return PATH.join.apply(null,parts)}),flagsToPermissionStringMap:{0:"r",1:"r+",2:"r+",64:"r",65:"r+",66:"r+",129:"rx+",193:"rx+",514:"w+",577:"w",578:"w+",705:"wx",706:"wx+",1024:"a",1025:"a",1026:"a+",1089:"a",1090:"a+",1153:"ax",1154:"ax+",1217:"ax",1218:"ax+",4096:"rs",4098:"rs+"},flagsToPermissionString:(function(flags){if(flags in NODEFS.flagsToPermissionStringMap){return NODEFS.flagsToPermissionStringMap[flags]}else{return flags}}),node_ops:{getattr:(function(node){var path=NODEFS.realPath(node);var stat;try{stat=fs.lstatSync(path)}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}if(NODEFS.isWindows&&!stat.blksize){stat.blksize=4096}if(NODEFS.isWindows&&!stat.blocks){stat.blocks=(stat.size+stat.blksize-1)/stat.blksize|0}return{dev:stat.dev,ino:stat.ino,mode:stat.mode,nlink:stat.nlink,uid:stat.uid,gid:stat.gid,rdev:stat.rdev,size:stat.size,atime:stat.atime,mtime:stat.mtime,ctime:stat.ctime,blksize:stat.blksize,blocks:stat.blocks}}),setattr:(function(node,attr){var path=NODEFS.realPath(node);try{if(attr.mode!==undefined){fs.chmodSync(path,attr.mode);node.mode=attr.mode}if(attr.timestamp!==undefined){var date=new Date(attr.timestamp);fs.utimesSync(path,date,date)}if(attr.size!==undefined){fs.truncateSync(path,attr.size)}}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}}),lookup:(function(parent,name){var path=PATH.join2(NODEFS.realPath(parent),name);var mode=NODEFS.getMode(path);return NODEFS.createNode(parent,name,mode)}),mknod:(function(parent,name,mode,dev){var node=NODEFS.createNode(parent,name,mode,dev);var path=NODEFS.realPath(node);try{if(FS.isDir(node.mode)){fs.mkdirSync(path,node.mode)}else{fs.writeFileSync(path,"",{mode:node.mode})}}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}return node}),rename:(function(oldNode,newDir,newName){var oldPath=NODEFS.realPath(oldNode);var newPath=PATH.join2(NODEFS.realPath(newDir),newName);try{fs.renameSync(oldPath,newPath)}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}}),unlink:(function(parent,name){var path=PATH.join2(NODEFS.realPath(parent),name);try{fs.unlinkSync(path)}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}}),rmdir:(function(parent,name){var path=PATH.join2(NODEFS.realPath(parent),name);try{fs.rmdirSync(path)}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}}),readdir:(function(node){var path=NODEFS.realPath(node);try{return fs.readdirSync(path)}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}}),symlink:(function(parent,newName,oldPath){var newPath=PATH.join2(NODEFS.realPath(parent),newName);try{fs.symlinkSync(oldPath,newPath)}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}}),readlink:(function(node){var path=NODEFS.realPath(node);try{return fs.readlinkSync(path)}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}})},stream_ops:{open:(function(stream){var path=NODEFS.realPath(stream.node);try{if(FS.isFile(stream.node.mode)){stream.nfd=fs.openSync(path,NODEFS.flagsToPermissionString(stream.flags))}}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}}),close:(function(stream){try{if(FS.isFile(stream.node.mode)&&stream.nfd){fs.closeSync(stream.nfd)}}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}}),read:(function(stream,buffer,offset,length,position){var nbuffer=new Buffer(length);var res;try{res=fs.readSync(stream.nfd,nbuffer,0,length,position)}catch(e){throw new FS.ErrnoError(ERRNO_CODES[e.code])}if(res>0){for(var i=0;i<res;i++){buffer[offset+i]=nbuffer[i]}}return res}),write:(function(stream,buffer,offset,length,position){var nbuffer=new Buffer(buffer.subarray(offset,offset+length));var res;try{res=fs.writeSync(stream.nfd,nbuffer,0,length,position)}catch(e){throw new FS.ErrnoError(ERRNO_CODES[e.code])}return res}),llseek:(function(stream,offset,whence){var position=offset;if(whence===1){position+=stream.position}else if(whence===2){if(FS.isFile(stream.node.mode)){try{var stat=fs.fstatSync(stream.nfd);position+=stat.size}catch(e){throw new FS.ErrnoError(ERRNO_CODES[e.code])}}}if(position<0){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}stream.position=position;return position})}};var _stdin=allocate(1,"i32*",ALLOC_STATIC);var _stdout=allocate(1,"i32*",ALLOC_STATIC);var _stderr=allocate(1,"i32*",ALLOC_STATIC);function _fflush(stream){}var FS={root:null,mounts:[],devices:[null],streams:[],nextInode:1,nameTable:null,currentPath:"/",initialized:false,ignorePermissions:true,trackingDelegate:{},tracking:{openFlags:{READ:1,WRITE:2}},ErrnoError:null,genericErrors:{},handleFSError:(function(e){if(!(e instanceof FS.ErrnoError))throw e+" : "+stackTrace();return ___setErrNo(e.errno)}),lookupPath:(function(path,opts){path=PATH.resolve(FS.cwd(),path);opts=opts||{};var defaults={follow_mount:true,recurse_count:0};for(var key in defaults){if(opts[key]===undefined){opts[key]=defaults[key]}}if(opts.recurse_count>8){throw new FS.ErrnoError(ERRNO_CODES.ELOOP)}var parts=PATH.normalizeArray(path.split("/").filter((function(p){return!!p})),false);var current=FS.root;var current_path="/";for(var i=0;i<parts.length;i++){var islast=i===parts.length-1;if(islast&&opts.parent){break}current=FS.lookupNode(current,parts[i]);current_path=PATH.join2(current_path,parts[i]);if(FS.isMountpoint(current)){if(!islast||islast&&opts.follow_mount){current=current.mounted.root}}if(!islast||opts.follow){var count=0;while(FS.isLink(current.mode)){var link=FS.readlink(current_path);current_path=PATH.resolve(PATH.dirname(current_path),link);var lookup=FS.lookupPath(current_path,{recurse_count:opts.recurse_count});current=lookup.node;if(count++>40){throw new FS.ErrnoError(ERRNO_CODES.ELOOP)}}}}return{path:current_path,node:current}}),getPath:(function(node){var path;while(true){if(FS.isRoot(node)){var mount=node.mount.mountpoint;if(!path)return mount;return mount[mount.length-1]!=="/"?mount+"/"+path:mount+path}path=path?node.name+"/"+path:node.name;node=node.parent}}),hashName:(function(parentid,name){var hash=0;for(var i=0;i<name.length;i++){hash=(hash<<5)-hash+name.charCodeAt(i)|0}return(parentid+hash>>>0)%FS.nameTable.length}),hashAddNode:(function(node){var hash=FS.hashName(node.parent.id,node.name);node.name_next=FS.nameTable[hash];FS.nameTable[hash]=node}),hashRemoveNode:(function(node){var hash=FS.hashName(node.parent.id,node.name);if(FS.nameTable[hash]===node){FS.nameTable[hash]=node.name_next}else{var current=FS.nameTable[hash];while(current){if(current.name_next===node){current.name_next=node.name_next;break}current=current.name_next}}}),lookupNode:(function(parent,name){var err=FS.mayLookup(parent);if(err){throw new FS.ErrnoError(err)}var hash=FS.hashName(parent.id,name);for(var node=FS.nameTable[hash];node;node=node.name_next){var nodeName=node.name;if(node.parent.id===parent.id&&nodeName===name){return node}}return FS.lookup(parent,name)}),createNode:(function(parent,name,mode,rdev){if(!FS.FSNode){FS.FSNode=(function(parent,name,mode,rdev){if(!parent){parent=this}this.parent=parent;this.mount=parent.mount;this.mounted=null;this.id=FS.nextInode++;this.name=name;this.mode=mode;this.node_ops={};this.stream_ops={};this.rdev=rdev});FS.FSNode.prototype={};var readMode=292|73;var writeMode=146;Object.defineProperties(FS.FSNode.prototype,{read:{get:(function(){return(this.mode&readMode)===readMode}),set:(function(val){val?this.mode|=readMode:this.mode&=~readMode})},write:{get:(function(){return(this.mode&writeMode)===writeMode}),set:(function(val){val?this.mode|=writeMode:this.mode&=~writeMode})},isFolder:{get:(function(){return FS.isDir(this.mode)})},isDevice:{get:(function(){return FS.isChrdev(this.mode)})}})}var node=new FS.FSNode(parent,name,mode,rdev);FS.hashAddNode(node);return node}),destroyNode:(function(node){FS.hashRemoveNode(node)}),isRoot:(function(node){return node===node.parent}),isMountpoint:(function(node){return!!node.mounted}),isFile:(function(mode){return(mode&61440)===32768}),isDir:(function(mode){return(mode&61440)===16384}),isLink:(function(mode){return(mode&61440)===40960}),isChrdev:(function(mode){return(mode&61440)===8192}),isBlkdev:(function(mode){return(mode&61440)===24576}),isFIFO:(function(mode){return(mode&61440)===4096}),isSocket:(function(mode){return(mode&49152)===49152}),flagModes:{"r":0,"rs":1052672,"r+":2,"w":577,"wx":705,"xw":705,"w+":578,"wx+":706,"xw+":706,"a":1089,"ax":1217,"xa":1217,"a+":1090,"ax+":1218,"xa+":1218},modeStringToFlags:(function(str){var flags=FS.flagModes[str];if(typeof flags==="undefined"){throw new Error("Unknown file open mode: "+str)}return flags}),flagsToPermissionString:(function(flag){var accmode=flag&2097155;var perms=["r","w","rw"][accmode];if(flag&512){perms+="w"}return perms}),nodePermissions:(function(node,perms){if(FS.ignorePermissions){return 0}if(perms.indexOf("r")!==-1&&!(node.mode&292)){return ERRNO_CODES.EACCES}else if(perms.indexOf("w")!==-1&&!(node.mode&146)){return ERRNO_CODES.EACCES}else if(perms.indexOf("x")!==-1&&!(node.mode&73)){return ERRNO_CODES.EACCES}return 0}),mayLookup:(function(dir){return FS.nodePermissions(dir,"x")}),mayCreate:(function(dir,name){try{var node=FS.lookupNode(dir,name);return ERRNO_CODES.EEXIST}catch(e){}return FS.nodePermissions(dir,"wx")}),mayDelete:(function(dir,name,isdir){var node;try{node=FS.lookupNode(dir,name)}catch(e){return e.errno}var err=FS.nodePermissions(dir,"wx");if(err){return err}if(isdir){if(!FS.isDir(node.mode)){return ERRNO_CODES.ENOTDIR}if(FS.isRoot(node)||FS.getPath(node)===FS.cwd()){return ERRNO_CODES.EBUSY}}else{if(FS.isDir(node.mode)){return ERRNO_CODES.EISDIR}}return 0}),mayOpen:(function(node,flags){if(!node){return ERRNO_CODES.ENOENT}if(FS.isLink(node.mode)){return ERRNO_CODES.ELOOP}else if(FS.isDir(node.mode)){if((flags&2097155)!==0||flags&512){return ERRNO_CODES.EISDIR}}return FS.nodePermissions(node,FS.flagsToPermissionString(flags))}),MAX_OPEN_FDS:4096,nextfd:(function(fd_start,fd_end){fd_start=fd_start||0;fd_end=fd_end||FS.MAX_OPEN_FDS;for(var fd=fd_start;fd<=fd_end;fd++){if(!FS.streams[fd]){return fd}}throw new FS.ErrnoError(ERRNO_CODES.EMFILE)}),getStream:(function(fd){return FS.streams[fd]}),createStream:(function(stream,fd_start,fd_end){if(!FS.FSStream){FS.FSStream=(function(){});FS.FSStream.prototype={};Object.defineProperties(FS.FSStream.prototype,{object:{get:(function(){return this.node}),set:(function(val){this.node=val})},isRead:{get:(function(){return(this.flags&2097155)!==1})},isWrite:{get:(function(){return(this.flags&2097155)!==0})},isAppend:{get:(function(){return this.flags&1024})}})}var newStream=new FS.FSStream;for(var p in stream){newStream[p]=stream[p]}stream=newStream;var fd=FS.nextfd(fd_start,fd_end);stream.fd=fd;FS.streams[fd]=stream;return stream}),closeStream:(function(fd){FS.streams[fd]=null}),getStreamFromPtr:(function(ptr){return FS.streams[ptr-1]}),getPtrForStream:(function(stream){return stream?stream.fd+1:0}),chrdev_stream_ops:{open:(function(stream){var device=FS.getDevice(stream.node.rdev);stream.stream_ops=device.stream_ops;if(stream.stream_ops.open){stream.stream_ops.open(stream)}}),llseek:(function(){throw new FS.ErrnoError(ERRNO_CODES.ESPIPE)})},major:(function(dev){return dev>>8}),minor:(function(dev){return dev&255}),makedev:(function(ma,mi){return ma<<8|mi}),registerDevice:(function(dev,ops){FS.devices[dev]={stream_ops:ops}}),getDevice:(function(dev){return FS.devices[dev]}),getMounts:(function(mount){var mounts=[];var check=[mount];while(check.length){var m=check.pop();mounts.push(m);check.push.apply(check,m.mounts)}return mounts}),syncfs:(function(populate,callback){if(typeof populate==="function"){callback=populate;populate=false}var mounts=FS.getMounts(FS.root.mount);var completed=0;function done(err){if(err){if(!done.errored){done.errored=true;return callback(err)}return}if(++completed>=mounts.length){callback(null)}}mounts.forEach((function(mount){if(!mount.type.syncfs){return done(null)}mount.type.syncfs(mount,populate,done)}))}),mount:(function(type,opts,mountpoint){var root=mountpoint==="/";var pseudo=!mountpoint;var node;if(root&&FS.root){throw new FS.ErrnoError(ERRNO_CODES.EBUSY)}else if(!root&&!pseudo){var lookup=FS.lookupPath(mountpoint,{follow_mount:false});mountpoint=lookup.path;node=lookup.node;if(FS.isMountpoint(node)){throw new FS.ErrnoError(ERRNO_CODES.EBUSY)}if(!FS.isDir(node.mode)){throw new FS.ErrnoError(ERRNO_CODES.ENOTDIR)}}var mount={type:type,opts:opts,mountpoint:mountpoint,mounts:[]};var mountRoot=type.mount(mount);mountRoot.mount=mount;mount.root=mountRoot;if(root){FS.root=mountRoot}else if(node){node.mounted=mount;if(node.mount){node.mount.mounts.push(mount)}}return mountRoot}),unmount:(function(mountpoint){var lookup=FS.lookupPath(mountpoint,{follow_mount:false});if(!FS.isMountpoint(lookup.node)){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}var node=lookup.node;var mount=node.mounted;var mounts=FS.getMounts(mount);Object.keys(FS.nameTable).forEach((function(hash){var current=FS.nameTable[hash];while(current){var next=current.name_next;if(mounts.indexOf(current.mount)!==-1){FS.destroyNode(current)}current=next}}));node.mounted=null;var idx=node.mount.mounts.indexOf(mount);assert(idx!==-1);node.mount.mounts.splice(idx,1)}),lookup:(function(parent,name){return parent.node_ops.lookup(parent,name)}),mknod:(function(path,mode,dev){var lookup=FS.lookupPath(path,{parent:true});var parent=lookup.node;var name=PATH.basename(path);var err=FS.mayCreate(parent,name);if(err){throw new FS.ErrnoError(err)}if(!parent.node_ops.mknod){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}return parent.node_ops.mknod(parent,name,mode,dev)}),create:(function(path,mode){mode=mode!==undefined?mode:438;mode&=4095;mode|=32768;return FS.mknod(path,mode,0)}),mkdir:(function(path,mode){mode=mode!==undefined?mode:511;mode&=511|512;mode|=16384;return FS.mknod(path,mode,0)}),mkdev:(function(path,mode,dev){if(typeof dev==="undefined"){dev=mode;mode=438}mode|=8192;return FS.mknod(path,mode,dev)}),symlink:(function(oldpath,newpath){var lookup=FS.lookupPath(newpath,{parent:true});var parent=lookup.node;var newname=PATH.basename(newpath);var err=FS.mayCreate(parent,newname);if(err){throw new FS.ErrnoError(err)}if(!parent.node_ops.symlink){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}return parent.node_ops.symlink(parent,newname,oldpath)}),rename:(function(old_path,new_path){var old_dirname=PATH.dirname(old_path);var new_dirname=PATH.dirname(new_path);var old_name=PATH.basename(old_path);var new_name=PATH.basename(new_path);var lookup,old_dir,new_dir;try{lookup=FS.lookupPath(old_path,{parent:true});old_dir=lookup.node;lookup=FS.lookupPath(new_path,{parent:true});new_dir=lookup.node}catch(e){throw new FS.ErrnoError(ERRNO_CODES.EBUSY)}if(old_dir.mount!==new_dir.mount){throw new FS.ErrnoError(ERRNO_CODES.EXDEV)}var old_node=FS.lookupNode(old_dir,old_name);var relative=PATH.relative(old_path,new_dirname);if(relative.charAt(0)!=="."){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}relative=PATH.relative(new_path,old_dirname);if(relative.charAt(0)!=="."){throw new FS.ErrnoError(ERRNO_CODES.ENOTEMPTY)}var new_node;try{new_node=FS.lookupNode(new_dir,new_name)}catch(e){}if(old_node===new_node){return}var isdir=FS.isDir(old_node.mode);var err=FS.mayDelete(old_dir,old_name,isdir);if(err){throw new FS.ErrnoError(err)}err=new_node?FS.mayDelete(new_dir,new_name,isdir):FS.mayCreate(new_dir,new_name);if(err){throw new FS.ErrnoError(err)}if(!old_dir.node_ops.rename){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}if(FS.isMountpoint(old_node)||new_node&&FS.isMountpoint(new_node)){throw new FS.ErrnoError(ERRNO_CODES.EBUSY)}if(new_dir!==old_dir){err=FS.nodePermissions(old_dir,"w");if(err){throw new FS.ErrnoError(err)}}try{if(FS.trackingDelegate["willMovePath"]){FS.trackingDelegate["willMovePath"](old_path,new_path)}}catch(e){console.log("FS.trackingDelegate['willMovePath']('"+old_path+"', '"+new_path+"') threw an exception: "+e.message)}FS.hashRemoveNode(old_node);try{old_dir.node_ops.rename(old_node,new_dir,new_name)}catch(e){throw e}finally{FS.hashAddNode(old_node)}try{if(FS.trackingDelegate["onMovePath"])FS.trackingDelegate["onMovePath"](old_path,new_path)}catch(e){console.log("FS.trackingDelegate['onMovePath']('"+old_path+"', '"+new_path+"') threw an exception: "+e.message)}}),rmdir:(function(path){var lookup=FS.lookupPath(path,{parent:true});var parent=lookup.node;var name=PATH.basename(path);var node=FS.lookupNode(parent,name);var err=FS.mayDelete(parent,name,true);if(err){throw new FS.ErrnoError(err)}if(!parent.node_ops.rmdir){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}if(FS.isMountpoint(node)){throw new FS.ErrnoError(ERRNO_CODES.EBUSY)}try{if(FS.trackingDelegate["willDeletePath"]){FS.trackingDelegate["willDeletePath"](path)}}catch(e){console.log("FS.trackingDelegate['willDeletePath']('"+path+"') threw an exception: "+e.message)}parent.node_ops.rmdir(parent,name);FS.destroyNode(node);try{if(FS.trackingDelegate["onDeletePath"])FS.trackingDelegate["onDeletePath"](path)}catch(e){console.log("FS.trackingDelegate['onDeletePath']('"+path+"') threw an exception: "+e.message)}}),readdir:(function(path){var lookup=FS.lookupPath(path,{follow:true});var node=lookup.node;if(!node.node_ops.readdir){throw new FS.ErrnoError(ERRNO_CODES.ENOTDIR)}return node.node_ops.readdir(node)}),unlink:(function(path){var lookup=FS.lookupPath(path,{parent:true});var parent=lookup.node;var name=PATH.basename(path);var node=FS.lookupNode(parent,name);var err=FS.mayDelete(parent,name,false);if(err){if(err===ERRNO_CODES.EISDIR)err=ERRNO_CODES.EPERM;throw new FS.ErrnoError(err)}if(!parent.node_ops.unlink){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}if(FS.isMountpoint(node)){throw new FS.ErrnoError(ERRNO_CODES.EBUSY)}try{if(FS.trackingDelegate["willDeletePath"]){FS.trackingDelegate["willDeletePath"](path)}}catch(e){console.log("FS.trackingDelegate['willDeletePath']('"+path+"') threw an exception: "+e.message)}parent.node_ops.unlink(parent,name);FS.destroyNode(node);try{if(FS.trackingDelegate["onDeletePath"])FS.trackingDelegate["onDeletePath"](path)}catch(e){console.log("FS.trackingDelegate['onDeletePath']('"+path+"') threw an exception: "+e.message)}}),readlink:(function(path){var lookup=FS.lookupPath(path);var link=lookup.node;if(!link.node_ops.readlink){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}return link.node_ops.readlink(link)}),stat:(function(path,dontFollow){var lookup=FS.lookupPath(path,{follow:!dontFollow});var node=lookup.node;if(!node.node_ops.getattr){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}return node.node_ops.getattr(node)}),lstat:(function(path){return FS.stat(path,true)}),chmod:(function(path,mode,dontFollow){var node;if(typeof path==="string"){var lookup=FS.lookupPath(path,{follow:!dontFollow});node=lookup.node}else{node=path}if(!node.node_ops.setattr){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}node.node_ops.setattr(node,{mode:mode&4095|node.mode&~4095,timestamp:Date.now()})}),lchmod:(function(path,mode){FS.chmod(path,mode,true)}),fchmod:(function(fd,mode){var stream=FS.getStream(fd);if(!stream){throw new FS.ErrnoError(ERRNO_CODES.EBADF)}FS.chmod(stream.node,mode)}),chown:(function(path,uid,gid,dontFollow){var node;if(typeof path==="string"){var lookup=FS.lookupPath(path,{follow:!dontFollow});node=lookup.node}else{node=path}if(!node.node_ops.setattr){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}node.node_ops.setattr(node,{timestamp:Date.now()})}),lchown:(function(path,uid,gid){FS.chown(path,uid,gid,true)}),fchown:(function(fd,uid,gid){var stream=FS.getStream(fd);if(!stream){throw new FS.ErrnoError(ERRNO_CODES.EBADF)}FS.chown(stream.node,uid,gid)}),truncate:(function(path,len){if(len<0){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}var node;if(typeof path==="string"){var lookup=FS.lookupPath(path,{follow:true});node=lookup.node}else{node=path}if(!node.node_ops.setattr){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}if(FS.isDir(node.mode)){throw new FS.ErrnoError(ERRNO_CODES.EISDIR)}if(!FS.isFile(node.mode)){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}var err=FS.nodePermissions(node,"w");if(err){throw new FS.ErrnoError(err)}node.node_ops.setattr(node,{size:len,timestamp:Date.now()})}),ftruncate:(function(fd,len){var stream=FS.getStream(fd);if(!stream){throw new FS.ErrnoError(ERRNO_CODES.EBADF)}if((stream.flags&2097155)===0){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}FS.truncate(stream.node,len)}),utime:(function(path,atime,mtime){var lookup=FS.lookupPath(path,{follow:true});var node=lookup.node;node.node_ops.setattr(node,{timestamp:Math.max(atime,mtime)})}),open:(function(path,flags,mode,fd_start,fd_end){if(path===""){throw new FS.ErrnoError(ERRNO_CODES.ENOENT)}flags=typeof flags==="string"?FS.modeStringToFlags(flags):flags;mode=typeof mode==="undefined"?438:mode;if(flags&64){mode=mode&4095|32768}else{mode=0}var node;if(typeof path==="object"){node=path}else{path=PATH.normalize(path);try{var lookup=FS.lookupPath(path,{follow:!(flags&131072)});node=lookup.node}catch(e){}}if(flags&64){if(node){if(flags&128){throw new FS.ErrnoError(ERRNO_CODES.EEXIST)}}else{node=FS.mknod(path,mode,0)}}if(!node){throw new FS.ErrnoError(ERRNO_CODES.ENOENT)}if(FS.isChrdev(node.mode)){flags&=~512}var err=FS.mayOpen(node,flags);if(err){throw new FS.ErrnoError(err)}if(flags&512){FS.truncate(node,0)}flags&=~(128|512);var stream=FS.createStream({node:node,path:FS.getPath(node),flags:flags,seekable:true,position:0,stream_ops:node.stream_ops,ungotten:[],error:false},fd_start,fd_end);if(stream.stream_ops.open){stream.stream_ops.open(stream)}if(Module["logReadFiles"]&&!(flags&1)){if(!FS.readFiles)FS.readFiles={};if(!(path in FS.readFiles)){FS.readFiles[path]=1;Module["printErr"]("read file: "+path)}}try{if(FS.trackingDelegate["onOpenFile"]){var trackingFlags=0;if((flags&2097155)!==1){trackingFlags|=FS.tracking.openFlags.READ}if((flags&2097155)!==0){trackingFlags|=FS.tracking.openFlags.WRITE}FS.trackingDelegate["onOpenFile"](path,trackingFlags)}}catch(e){console.log("FS.trackingDelegate['onOpenFile']('"+path+"', flags) threw an exception: "+e.message)}return stream}),close:(function(stream){try{if(stream.stream_ops.close){stream.stream_ops.close(stream)}}catch(e){throw e}finally{FS.closeStream(stream.fd)}}),llseek:(function(stream,offset,whence){if(!stream.seekable||!stream.stream_ops.llseek){throw new FS.ErrnoError(ERRNO_CODES.ESPIPE)}return stream.stream_ops.llseek(stream,offset,whence)}),read:(function(stream,buffer,offset,length,position){if(length<0||position<0){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}if((stream.flags&2097155)===1){throw new FS.ErrnoError(ERRNO_CODES.EBADF)}if(FS.isDir(stream.node.mode)){throw new FS.ErrnoError(ERRNO_CODES.EISDIR)}if(!stream.stream_ops.read){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}var seeking=true;if(typeof position==="undefined"){position=stream.position;seeking=false}else if(!stream.seekable){throw new FS.ErrnoError(ERRNO_CODES.ESPIPE)}var bytesRead=stream.stream_ops.read(stream,buffer,offset,length,position);if(!seeking)stream.position+=bytesRead;return bytesRead}),write:(function(stream,buffer,offset,length,position,canOwn){if(length<0||position<0){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}if((stream.flags&2097155)===0){throw new FS.ErrnoError(ERRNO_CODES.EBADF)}if(FS.isDir(stream.node.mode)){throw new FS.ErrnoError(ERRNO_CODES.EISDIR)}if(!stream.stream_ops.write){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}if(stream.flags&1024){FS.llseek(stream,0,2)}var seeking=true;if(typeof position==="undefined"){position=stream.position;seeking=false}else if(!stream.seekable){throw new FS.ErrnoError(ERRNO_CODES.ESPIPE)}var bytesWritten=stream.stream_ops.write(stream,buffer,offset,length,position,canOwn);if(!seeking)stream.position+=bytesWritten;try{if(stream.path&&FS.trackingDelegate["onWriteToFile"])FS.trackingDelegate["onWriteToFile"](stream.path)}catch(e){console.log("FS.trackingDelegate['onWriteToFile']('"+path+"') threw an exception: "+e.message)}return bytesWritten}),allocate:(function(stream,offset,length){if(offset<0||length<=0){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}if((stream.flags&2097155)===0){throw new FS.ErrnoError(ERRNO_CODES.EBADF)}if(!FS.isFile(stream.node.mode)&&!FS.isDir(node.mode)){throw new FS.ErrnoError(ERRNO_CODES.ENODEV)}if(!stream.stream_ops.allocate){throw new FS.ErrnoError(ERRNO_CODES.EOPNOTSUPP)}stream.stream_ops.allocate(stream,offset,length)}),mmap:(function(stream,buffer,offset,length,position,prot,flags){if((stream.flags&2097155)===1){throw new FS.ErrnoError(ERRNO_CODES.EACCES)}if(!stream.stream_ops.mmap){throw new FS.ErrnoError(ERRNO_CODES.ENODEV)}return stream.stream_ops.mmap(stream,buffer,offset,length,position,prot,flags)}),ioctl:(function(stream,cmd,arg){if(!stream.stream_ops.ioctl){throw new FS.ErrnoError(ERRNO_CODES.ENOTTY)}return stream.stream_ops.ioctl(stream,cmd,arg)}),readFile:(function(path,opts){opts=opts||{};opts.flags=opts.flags||"r";opts.encoding=opts.encoding||"binary";if(opts.encoding!=="utf8"&&opts.encoding!=="binary"){throw new Error('Invalid encoding type "'+opts.encoding+'"')}var ret;var stream=FS.open(path,opts.flags);var stat=FS.stat(path);var length=stat.size;var buf=new Uint8Array(length);FS.read(stream,buf,0,length,0);if(opts.encoding==="utf8"){ret="";var utf8=new Runtime.UTF8Processor;for(var i=0;i<length;i++){ret+=utf8.processCChar(buf[i])}}else if(opts.encoding==="binary"){ret=buf}FS.close(stream);return ret}),writeFile:(function(path,data,opts){opts=opts||{};opts.flags=opts.flags||"w";opts.encoding=opts.encoding||"utf8";if(opts.encoding!=="utf8"&&opts.encoding!=="binary"){throw new Error('Invalid encoding type "'+opts.encoding+'"')}var stream=FS.open(path,opts.flags,opts.mode);if(opts.encoding==="utf8"){var utf8=new Runtime.UTF8Processor;var buf=new Uint8Array(utf8.processJSString(data));FS.write(stream,buf,0,buf.length,0,opts.canOwn)}else if(opts.encoding==="binary"){FS.write(stream,data,0,data.length,0,opts.canOwn)}FS.close(stream)}),cwd:(function(){return FS.currentPath}),chdir:(function(path){var lookup=FS.lookupPath(path,{follow:true});if(!FS.isDir(lookup.node.mode)){throw new FS.ErrnoError(ERRNO_CODES.ENOTDIR)}var err=FS.nodePermissions(lookup.node,"x");if(err){throw new FS.ErrnoError(err)}FS.currentPath=lookup.path}),createDefaultDirectories:(function(){FS.mkdir("/tmp")}),createDefaultDevices:(function(){FS.mkdir("/dev");FS.registerDevice(FS.makedev(1,3),{read:(function(){return 0}),write:(function(){return 0})});FS.mkdev("/dev/null",FS.makedev(1,3));TTY.register(FS.makedev(5,0),TTY.default_tty_ops);TTY.register(FS.makedev(6,0),TTY.default_tty1_ops);FS.mkdev("/dev/tty",FS.makedev(5,0));FS.mkdev("/dev/tty1",FS.makedev(6,0));var random_device;if(typeof crypto!=="undefined"){var randomBuffer=new Uint8Array(1);random_device=(function(){crypto.getRandomValues(randomBuffer);return randomBuffer[0]})}else if(ENVIRONMENT_IS_NODE){random_device=(function(){return require("crypto").randomBytes(1)[0]})}else{random_device=(function(){return Math.floor(Math.random()*256)})}FS.createDevice("/dev","random",random_device);FS.createDevice("/dev","urandom",random_device);FS.mkdir("/dev/shm");FS.mkdir("/dev/shm/tmp")}),createStandardStreams:(function(){if(Module["stdin"]){FS.createDevice("/dev","stdin",Module["stdin"])}else{FS.symlink("/dev/tty","/dev/stdin")}if(Module["stdout"]){FS.createDevice("/dev","stdout",null,Module["stdout"])}else{FS.symlink("/dev/tty","/dev/stdout")}if(Module["stderr"]){FS.createDevice("/dev","stderr",null,Module["stderr"])}else{FS.symlink("/dev/tty1","/dev/stderr")}var stdin=FS.open("/dev/stdin","r");HEAP32[_stdin>>2]=FS.getPtrForStream(stdin);assert(stdin.fd===0,"invalid handle for stdin ("+stdin.fd+")");var stdout=FS.open("/dev/stdout","w");HEAP32[_stdout>>2]=FS.getPtrForStream(stdout);assert(stdout.fd===1,"invalid handle for stdout ("+stdout.fd+")");var stderr=FS.open("/dev/stderr","w");HEAP32[_stderr>>2]=FS.getPtrForStream(stderr);assert(stderr.fd===2,"invalid handle for stderr ("+stderr.fd+")")}),ensureErrnoError:(function(){if(FS.ErrnoError)return;FS.ErrnoError=function ErrnoError(errno){this.errno=errno;for(var key in ERRNO_CODES){if(ERRNO_CODES[key]===errno){this.code=key;break}}this.message=ERRNO_MESSAGES[errno]};FS.ErrnoError.prototype=new Error;FS.ErrnoError.prototype.constructor=FS.ErrnoError;[ERRNO_CODES.ENOENT].forEach((function(code){FS.genericErrors[code]=new FS.ErrnoError(code);FS.genericErrors[code].stack="<generic error, no stack>"}))}),staticInit:(function(){FS.ensureErrnoError();FS.nameTable=new Array(4096);FS.mount(MEMFS,{},"/");FS.createDefaultDirectories();FS.createDefaultDevices()}),init:(function(input,output,error){assert(!FS.init.initialized,"FS.init was previously called. If you want to initialize later with custom parameters, remove any earlier calls (note that one is automatically added to the generated code)");FS.init.initialized=true;FS.ensureErrnoError();Module["stdin"]=input||Module["stdin"];Module["stdout"]=output||Module["stdout"];Module["stderr"]=error||Module["stderr"];FS.createStandardStreams()}),quit:(function(){FS.init.initialized=false;for(var i=0;i<FS.streams.length;i++){var stream=FS.streams[i];if(!stream){continue}FS.close(stream)}}),getMode:(function(canRead,canWrite){var mode=0;if(canRead)mode|=292|73;if(canWrite)mode|=146;return mode}),joinPath:(function(parts,forceRelative){var path=PATH.join.apply(null,parts);if(forceRelative&&path[0]=="/")path=path.substr(1);return path}),absolutePath:(function(relative,base){return PATH.resolve(base,relative)}),standardizePath:(function(path){return PATH.normalize(path)}),findObject:(function(path,dontResolveLastLink){var ret=FS.analyzePath(path,dontResolveLastLink);if(ret.exists){return ret.object}else{___setErrNo(ret.error);return null}}),analyzePath:(function(path,dontResolveLastLink){try{var lookup=FS.lookupPath(path,{follow:!dontResolveLastLink});path=lookup.path}catch(e){}var ret={isRoot:false,exists:false,error:0,name:null,path:null,object:null,parentExists:false,parentPath:null,parentObject:null};try{var lookup=FS.lookupPath(path,{parent:true});ret.parentExists=true;ret.parentPath=lookup.path;ret.parentObject=lookup.node;ret.name=PATH.basename(path);lookup=FS.lookupPath(path,{follow:!dontResolveLastLink});ret.exists=true;ret.path=lookup.path;ret.object=lookup.node;ret.name=lookup.node.name;ret.isRoot=lookup.path==="/"}catch(e){ret.error=e.errno}return ret}),createFolder:(function(parent,name,canRead,canWrite){var path=PATH.join2(typeof parent==="string"?parent:FS.getPath(parent),name);var mode=FS.getMode(canRead,canWrite);return FS.mkdir(path,mode)}),createPath:(function(parent,path,canRead,canWrite){parent=typeof parent==="string"?parent:FS.getPath(parent);var parts=path.split("/").reverse();while(parts.length){var part=parts.pop();if(!part)continue;var current=PATH.join2(parent,part);try{FS.mkdir(current)}catch(e){}parent=current}return current}),createFile:(function(parent,name,properties,canRead,canWrite){var path=PATH.join2(typeof parent==="string"?parent:FS.getPath(parent),name);var mode=FS.getMode(canRead,canWrite);return FS.create(path,mode)}),createDataFile:(function(parent,name,data,canRead,canWrite,canOwn){var path=name?PATH.join2(typeof parent==="string"?parent:FS.getPath(parent),name):parent;var mode=FS.getMode(canRead,canWrite);var node=FS.create(path,mode);if(data){if(typeof data==="string"){var arr=new Array(data.length);for(var i=0,len=data.length;i<len;++i)arr[i]=data.charCodeAt(i);data=arr}FS.chmod(node,mode|146);var stream=FS.open(node,"w");FS.write(stream,data,0,data.length,0,canOwn);FS.close(stream);FS.chmod(node,mode)}return node}),createDevice:(function(parent,name,input,output){var path=PATH.join2(typeof parent==="string"?parent:FS.getPath(parent),name);var mode=FS.getMode(!!input,!!output);if(!FS.createDevice.major)FS.createDevice.major=64;var dev=FS.makedev(FS.createDevice.major++,0);FS.registerDevice(dev,{open:(function(stream){stream.seekable=false}),close:(function(stream){if(output&&output.buffer&&output.buffer.length){output(10)}}),read:(function(stream,buffer,offset,length,pos){var bytesRead=0;for(var i=0;i<length;i++){var result;try{result=input()}catch(e){throw new FS.ErrnoError(ERRNO_CODES.EIO)}if(result===undefined&&bytesRead===0){throw new FS.ErrnoError(ERRNO_CODES.EAGAIN)}if(result===null||result===undefined)break;bytesRead++;buffer[offset+i]=result}if(bytesRead){stream.node.timestamp=Date.now()}return bytesRead}),write:(function(stream,buffer,offset,length,pos){for(var i=0;i<length;i++){try{output(buffer[offset+i])}catch(e){throw new FS.ErrnoError(ERRNO_CODES.EIO)}}if(length){stream.node.timestamp=Date.now()}return i})});return FS.mkdev(path,mode,dev)}),createLink:(function(parent,name,target,canRead,canWrite){var path=PATH.join2(typeof parent==="string"?parent:FS.getPath(parent),name);return FS.symlink(target,path)}),forceLoadFile:(function(obj){if(obj.isDevice||obj.isFolder||obj.link||obj.contents)return true;var success=true;if(typeof XMLHttpRequest!=="undefined"){throw new Error("Lazy loading should have been performed (contents set) in createLazyFile, but it was not. Lazy loading only works in web workers. Use --embed-file or --preload-file in emcc on the main thread.")}else if(Module["read"]){try{obj.contents=intArrayFromString(Module["read"](obj.url),true);obj.usedBytes=obj.contents.length}catch(e){success=false}}else{throw new Error("Cannot load without read() or XMLHttpRequest.")}if(!success)___setErrNo(ERRNO_CODES.EIO);return success}),createLazyFile:(function(parent,name,url,canRead,canWrite){function LazyUint8Array(){this.lengthKnown=false;this.chunks=[]}LazyUint8Array.prototype.get=function LazyUint8Array_get(idx){if(idx>this.length-1||idx<0){return undefined}var chunkOffset=idx%this.chunkSize;var chunkNum=Math.floor(idx/this.chunkSize);return this.getter(chunkNum)[chunkOffset]};LazyUint8Array.prototype.setDataGetter=function LazyUint8Array_setDataGetter(getter){this.getter=getter};LazyUint8Array.prototype.cacheLength=function LazyUint8Array_cacheLength(){var xhr=new XMLHttpRequest;xhr.open("HEAD",url,false);xhr.send(null);if(!(xhr.status>=200&&xhr.status<300||xhr.status===304))throw new Error("Couldn't load "+url+". Status: "+xhr.status);var datalength=Number(xhr.getResponseHeader("Content-length"));var header;var hasByteServing=(header=xhr.getResponseHeader("Accept-Ranges"))&&header==="bytes";var chunkSize=1024*1024;if(!hasByteServing)chunkSize=datalength;var doXHR=(function(from,to){if(from>to)throw new Error("invalid range ("+from+", "+to+") or no bytes requested!");if(to>datalength-1)throw new Error("only "+datalength+" bytes available! programmer error!");var xhr=new XMLHttpRequest;xhr.open("GET",url,false);if(datalength!==chunkSize)xhr.setRequestHeader("Range","bytes="+from+"-"+to);if(typeof Uint8Array!="undefined")xhr.responseType="arraybuffer";if(xhr.overrideMimeType){xhr.overrideMimeType("text/plain; charset=x-user-defined")}xhr.send(null);if(!(xhr.status>=200&&xhr.status<300||xhr.status===304))throw new Error("Couldn't load "+url+". Status: "+xhr.status);if(xhr.response!==undefined){return new Uint8Array(xhr.response||[])}else{return intArrayFromString(xhr.responseText||"",true)}});var lazyArray=this;lazyArray.setDataGetter((function(chunkNum){var start=chunkNum*chunkSize;var end=(chunkNum+1)*chunkSize-1;end=Math.min(end,datalength-1);if(typeof lazyArray.chunks[chunkNum]==="undefined"){lazyArray.chunks[chunkNum]=doXHR(start,end)}if(typeof lazyArray.chunks[chunkNum]==="undefined")throw new Error("doXHR failed!");return lazyArray.chunks[chunkNum]}));this._length=datalength;this._chunkSize=chunkSize;this.lengthKnown=true};if(typeof XMLHttpRequest!=="undefined"){if(!ENVIRONMENT_IS_WORKER)throw"Cannot do synchronous binary XHRs outside webworkers in modern browsers. Use --embed-file or --preload-file in emcc";var lazyArray=new LazyUint8Array;Object.defineProperty(lazyArray,"length",{get:(function(){if(!this.lengthKnown){this.cacheLength()}return this._length})});Object.defineProperty(lazyArray,"chunkSize",{get:(function(){if(!this.lengthKnown){this.cacheLength()}return this._chunkSize})});var properties={isDevice:false,contents:lazyArray}}else{var properties={isDevice:false,url:url}}var node=FS.createFile(parent,name,properties,canRead,canWrite);if(properties.contents){node.contents=properties.contents}else if(properties.url){node.contents=null;node.url=properties.url}Object.defineProperty(node,"usedBytes",{get:(function(){return this.contents.length})});var stream_ops={};var keys=Object.keys(node.stream_ops);keys.forEach((function(key){var fn=node.stream_ops[key];stream_ops[key]=function forceLoadLazyFile(){if(!FS.forceLoadFile(node)){throw new FS.ErrnoError(ERRNO_CODES.EIO)}return fn.apply(null,arguments)}}));stream_ops.read=function stream_ops_read(stream,buffer,offset,length,position){if(!FS.forceLoadFile(node)){throw new FS.ErrnoError(ERRNO_CODES.EIO)}var contents=stream.node.contents;if(position>=contents.length)return 0;var size=Math.min(contents.length-position,length);assert(size>=0);if(contents.slice){for(var i=0;i<size;i++){buffer[offset+i]=contents[position+i]}}else{for(var i=0;i<size;i++){buffer[offset+i]=contents.get(position+i)}}return size};node.stream_ops=stream_ops;return node}),createPreloadedFile:(function(parent,name,url,canRead,canWrite,onload,onerror,dontCreateFile,canOwn){Browser.init();var fullname=name?PATH.resolve(PATH.join2(parent,name)):parent;function processData(byteArray){function finish(byteArray){if(!dontCreateFile){FS.createDataFile(parent,name,byteArray,canRead,canWrite,canOwn)}if(onload)onload();removeRunDependency("cp "+fullname)}var handled=false;Module["preloadPlugins"].forEach((function(plugin){if(handled)return;if(plugin["canHandle"](fullname)){plugin["handle"](byteArray,fullname,finish,(function(){if(onerror)onerror();removeRunDependency("cp "+fullname)}));handled=true}}));if(!handled)finish(byteArray)}addRunDependency("cp "+fullname);if(typeof url=="string"){Browser.asyncLoad(url,(function(byteArray){processData(byteArray)}),onerror)}else{processData(url)}}),indexedDB:(function(){return window.indexedDB||window.mozIndexedDB||window.webkitIndexedDB||window.msIndexedDB}),DB_NAME:(function(){return"EM_FS_"+window.location.pathname}),DB_VERSION:20,DB_STORE_NAME:"FILE_DATA",saveFilesToDB:(function(paths,onload,onerror){onload=onload||(function(){});onerror=onerror||(function(){});var indexedDB=FS.indexedDB();try{var openRequest=indexedDB.open(FS.DB_NAME(),FS.DB_VERSION)}catch(e){return onerror(e)}openRequest.onupgradeneeded=function openRequest_onupgradeneeded(){console.log("creating db");var db=openRequest.result;db.createObjectStore(FS.DB_STORE_NAME)};openRequest.onsuccess=function openRequest_onsuccess(){var db=openRequest.result;var transaction=db.transaction([FS.DB_STORE_NAME],"readwrite");var files=transaction.objectStore(FS.DB_STORE_NAME);var ok=0,fail=0,total=paths.length;function finish(){if(fail==0)onload();else onerror()}paths.forEach((function(path){var putRequest=files.put(FS.analyzePath(path).object.contents,path);putRequest.onsuccess=function putRequest_onsuccess(){ok++;if(ok+fail==total)finish()};putRequest.onerror=function putRequest_onerror(){fail++;if(ok+fail==total)finish()}}));transaction.onerror=onerror};openRequest.onerror=onerror}),loadFilesFromDB:(function(paths,onload,onerror){onload=onload||(function(){});onerror=onerror||(function(){});var indexedDB=FS.indexedDB();try{var openRequest=indexedDB.open(FS.DB_NAME(),FS.DB_VERSION)}catch(e){return onerror(e)}openRequest.onupgradeneeded=onerror;openRequest.onsuccess=function openRequest_onsuccess(){var db=openRequest.result;try{var transaction=db.transaction([FS.DB_STORE_NAME],"readonly")}catch(e){onerror(e);return}var files=transaction.objectStore(FS.DB_STORE_NAME);var ok=0,fail=0,total=paths.length;function finish(){if(fail==0)onload();else onerror()}paths.forEach((function(path){var getRequest=files.get(path);getRequest.onsuccess=function getRequest_onsuccess(){if(FS.analyzePath(path).exists){FS.unlink(path)}FS.createDataFile(PATH.dirname(path),PATH.basename(path),getRequest.result,true,true,true);ok++;if(ok+fail==total)finish()};getRequest.onerror=function getRequest_onerror(){fail++;if(ok+fail==total)finish()}}));transaction.onerror=onerror};openRequest.onerror=onerror})};function _close(fildes){var stream=FS.getStream(fildes);if(!stream){___setErrNo(ERRNO_CODES.EBADF);return-1}try{FS.close(stream);return 0}catch(e){FS.handleFSError(e);return-1}}function _fsync(fildes){var stream=FS.getStream(fildes);if(stream){return 0}else{___setErrNo(ERRNO_CODES.EBADF);return-1}}function _fileno(stream){stream=FS.getStreamFromPtr(stream);if(!stream)return-1;return stream.fd}function _fclose(stream){var fd=_fileno(stream);_fsync(fd);return _close(fd)}var _emscripten_resume=true;var _emscripten_landingpad=true;function _free(){}Module["_free"]=_free;function ___cxa_free_exception(ptr){try{return _free(ptr-___cxa_exception_header_size)}catch(e){}}var ___cxa_caught_exceptions=[];function ___cxa_end_catch(){if(___cxa_end_catch.rethrown){___cxa_end_catch.rethrown=false;return}asm["setThrew"](0);var ptr=___cxa_caught_exceptions.pop();if(ptr){header=ptr-___cxa_exception_header_size;var destructor=HEAP32[header+4>>2];if(destructor){Runtime.dynCall("vi",destructor,[ptr]);HEAP32[header+4>>2]=0}___cxa_free_exception(ptr);___cxa_last_thrown_exception=0}}function _open(path,oflag,varargs){var mode=HEAP32[varargs>>2];path=Pointer_stringify(path);try{var stream=FS.open(path,oflag,mode);return stream.fd}catch(e){FS.handleFSError(e);return-1}}function _fopen(filename,mode){var flags;mode=Pointer_stringify(mode);if(mode[0]=="r"){if(mode.indexOf("+")!=-1){flags=2}else{flags=0}}else if(mode[0]=="w"){if(mode.indexOf("+")!=-1){flags=2}else{flags=1}flags|=64;flags|=512}else if(mode[0]=="a"){if(mode.indexOf("+")!=-1){flags=2}else{flags=1}flags|=64;flags|=1024}else{___setErrNo(ERRNO_CODES.EINVAL);return 0}var fd=_open(filename,flags,allocate([511,0,0,0],"i32",ALLOC_STACK));return fd===-1?0:FS.getPtrForStream(FS.getStream(fd))}function _mkport(){throw"TODO"}var SOCKFS={mount:(function(mount){return FS.createNode(null,"/",16384|511,0)}),createSocket:(function(family,type,protocol){var streaming=type==1;if(protocol){assert(streaming==(protocol==6))}var sock={family:family,type:type,protocol:protocol,server:null,peers:{},pending:[],recv_queue:[],sock_ops:SOCKFS.websocket_sock_ops};var name=SOCKFS.nextname();var node=FS.createNode(SOCKFS.root,name,49152,0);node.sock=sock;var stream=FS.createStream({path:name,node:node,flags:FS.modeStringToFlags("r+"),seekable:false,stream_ops:SOCKFS.stream_ops});sock.stream=stream;return sock}),getSocket:(function(fd){var stream=FS.getStream(fd);if(!stream||!FS.isSocket(stream.node.mode)){return null}return stream.node.sock}),stream_ops:{poll:(function(stream){var sock=stream.node.sock;return sock.sock_ops.poll(sock)}),ioctl:(function(stream,request,varargs){var sock=stream.node.sock;return sock.sock_ops.ioctl(sock,request,varargs)}),read:(function(stream,buffer,offset,length,position){var sock=stream.node.sock;var msg=sock.sock_ops.recvmsg(sock,length);if(!msg){return 0}buffer.set(msg.buffer,offset);return msg.buffer.length}),write:(function(stream,buffer,offset,length,position){var sock=stream.node.sock;return sock.sock_ops.sendmsg(sock,buffer,offset,length)}),close:(function(stream){var sock=stream.node.sock;sock.sock_ops.close(sock)})},nextname:(function(){if(!SOCKFS.nextname.current){SOCKFS.nextname.current=0}return"socket["+SOCKFS.nextname.current++ +"]"}),websocket_sock_ops:{createPeer:(function(sock,addr,port){var ws;if(typeof addr==="object"){ws=addr;addr=null;port=null}if(ws){if(ws._socket){addr=ws._socket.remoteAddress;port=ws._socket.remotePort}else{var result=/ws[s]?:\/\/([^:]+):(\d+)/.exec(ws.url);if(!result){throw new Error("WebSocket URL must be in the format ws(s)://address:port")}addr=result[1];port=parseInt(result[2],10)}}else{try{var runtimeConfig=Module["websocket"]&&"object"===typeof Module["websocket"];var url="ws:#".replace("#","//");if(runtimeConfig){if("string"===typeof Module["websocket"]["url"]){url=Module["websocket"]["url"]}}if(url==="ws://"||url==="wss://"){url=url+addr+":"+port}var subProtocols="binary";if(runtimeConfig){if("string"===typeof Module["websocket"]["subprotocol"]){subProtocols=Module["websocket"]["subprotocol"]}}subProtocols=subProtocols.replace(/^ +| +$/g,"").split(/ *, */);var opts=ENVIRONMENT_IS_NODE?{"protocol":subProtocols.toString()}:subProtocols;var WebSocket=ENVIRONMENT_IS_NODE?require("ws"):window["WebSocket"];ws=new WebSocket(url,opts);ws.binaryType="arraybuffer"}catch(e){throw new FS.ErrnoError(ERRNO_CODES.EHOSTUNREACH)}}var peer={addr:addr,port:port,socket:ws,dgram_send_queue:[]};SOCKFS.websocket_sock_ops.addPeer(sock,peer);SOCKFS.websocket_sock_ops.handlePeerEvents(sock,peer);if(sock.type===2&&typeof sock.sport!=="undefined"){peer.dgram_send_queue.push(new Uint8Array([255,255,255,255,"p".charCodeAt(0),"o".charCodeAt(0),"r".charCodeAt(0),"t".charCodeAt(0),(sock.sport&65280)>>8,sock.sport&255]))}return peer}),getPeer:(function(sock,addr,port){return sock.peers[addr+":"+port]}),addPeer:(function(sock,peer){sock.peers[peer.addr+":"+peer.port]=peer}),removePeer:(function(sock,peer){delete sock.peers[peer.addr+":"+peer.port]}),handlePeerEvents:(function(sock,peer){var first=true;var handleOpen=(function(){try{var queued=peer.dgram_send_queue.shift();while(queued){peer.socket.send(queued);queued=peer.dgram_send_queue.shift()}}catch(e){peer.socket.close()}});function handleMessage(data){assert(typeof data!=="string"&&data.byteLength!==undefined);data=new Uint8Array(data);var wasfirst=first;first=false;if(wasfirst&&data.length===10&&data[0]===255&&data[1]===255&&data[2]===255&&data[3]===255&&data[4]==="p".charCodeAt(0)&&data[5]==="o".charCodeAt(0)&&data[6]==="r".charCodeAt(0)&&data[7]==="t".charCodeAt(0)){var newport=data[8]<<8|data[9];SOCKFS.websocket_sock_ops.removePeer(sock,peer);peer.port=newport;SOCKFS.websocket_sock_ops.addPeer(sock,peer);return}sock.recv_queue.push({addr:peer.addr,port:peer.port,data:data})}if(ENVIRONMENT_IS_NODE){peer.socket.on("open",handleOpen);peer.socket.on("message",(function(data,flags){if(!flags.binary){return}handleMessage((new Uint8Array(data)).buffer)}));peer.socket.on("error",(function(){}))}else{peer.socket.onopen=handleOpen;peer.socket.onmessage=function peer_socket_onmessage(event){handleMessage(event.data)}}}),poll:(function(sock){if(sock.type===1&&sock.server){return sock.pending.length?64|1:0}var mask=0;var dest=sock.type===1?SOCKFS.websocket_sock_ops.getPeer(sock,sock.daddr,sock.dport):null;if(sock.recv_queue.length||!dest||dest&&dest.socket.readyState===dest.socket.CLOSING||dest&&dest.socket.readyState===dest.socket.CLOSED){mask|=64|1}if(!dest||dest&&dest.socket.readyState===dest.socket.OPEN){mask|=4}if(dest&&dest.socket.readyState===dest.socket.CLOSING||dest&&dest.socket.readyState===dest.socket.CLOSED){mask|=16}return mask}),ioctl:(function(sock,request,arg){switch(request){case 21531:var bytes=0;if(sock.recv_queue.length){bytes=sock.recv_queue[0].data.length}HEAP32[arg>>2]=bytes;return 0;default:return ERRNO_CODES.EINVAL}}),close:(function(sock){if(sock.server){try{sock.server.close()}catch(e){}sock.server=null}var peers=Object.keys(sock.peers);for(var i=0;i<peers.length;i++){var peer=sock.peers[peers[i]];try{peer.socket.close()}catch(e){}SOCKFS.websocket_sock_ops.removePeer(sock,peer)}return 0}),bind:(function(sock,addr,port){if(typeof sock.saddr!=="undefined"||typeof sock.sport!=="undefined"){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}sock.saddr=addr;sock.sport=port||_mkport();if(sock.type===2){if(sock.server){sock.server.close();sock.server=null}try{sock.sock_ops.listen(sock,0)}catch(e){if(!(e instanceof FS.ErrnoError))throw e;if(e.errno!==ERRNO_CODES.EOPNOTSUPP)throw e}}}),connect:(function(sock,addr,port){if(sock.server){throw new FS.ErrnoError(ERRNO_CODS.EOPNOTSUPP)}if(typeof sock.daddr!=="undefined"&&typeof sock.dport!=="undefined"){var dest=SOCKFS.websocket_sock_ops.getPeer(sock,sock.daddr,sock.dport);if(dest){if(dest.socket.readyState===dest.socket.CONNECTING){throw new FS.ErrnoError(ERRNO_CODES.EALREADY)}else{throw new FS.ErrnoError(ERRNO_CODES.EISCONN)}}}var peer=SOCKFS.websocket_sock_ops.createPeer(sock,addr,port);sock.daddr=peer.addr;sock.dport=peer.port;throw new FS.ErrnoError(ERRNO_CODES.EINPROGRESS)}),listen:(function(sock,backlog){if(!ENVIRONMENT_IS_NODE){throw new FS.ErrnoError(ERRNO_CODES.EOPNOTSUPP)}if(sock.server){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}var WebSocketServer=require("ws").Server;var host=sock.saddr;sock.server=new WebSocketServer({host:host,port:sock.sport});sock.server.on("connection",(function(ws){if(sock.type===1){var newsock=SOCKFS.createSocket(sock.family,sock.type,sock.protocol);var peer=SOCKFS.websocket_sock_ops.createPeer(newsock,ws);newsock.daddr=peer.addr;newsock.dport=peer.port;sock.pending.push(newsock)}else{SOCKFS.websocket_sock_ops.createPeer(sock,ws)}}));sock.server.on("closed",(function(){sock.server=null}));sock.server.on("error",(function(){}))}),accept:(function(listensock){if(!listensock.server){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}var newsock=listensock.pending.shift();newsock.stream.flags=listensock.stream.flags;return newsock}),getname:(function(sock,peer){var addr,port;if(peer){if(sock.daddr===undefined||sock.dport===undefined){throw new FS.ErrnoError(ERRNO_CODES.ENOTCONN)}addr=sock.daddr;port=sock.dport}else{addr=sock.saddr||0;port=sock.sport||0}return{addr:addr,port:port}}),sendmsg:(function(sock,buffer,offset,length,addr,port){if(sock.type===2){if(addr===undefined||port===undefined){addr=sock.daddr;port=sock.dport}if(addr===undefined||port===undefined){throw new FS.ErrnoError(ERRNO_CODES.EDESTADDRREQ)}}else{addr=sock.daddr;port=sock.dport}var dest=SOCKFS.websocket_sock_ops.getPeer(sock,addr,port);if(sock.type===1){if(!dest||dest.socket.readyState===dest.socket.CLOSING||dest.socket.readyState===dest.socket.CLOSED){throw new FS.ErrnoError(ERRNO_CODES.ENOTCONN)}else if(dest.socket.readyState===dest.socket.CONNECTING){throw new FS.ErrnoError(ERRNO_CODES.EAGAIN)}}var data;if(buffer instanceof Array||buffer instanceof ArrayBuffer){data=buffer.slice(offset,offset+length)}else{data=buffer.buffer.slice(buffer.byteOffset+offset,buffer.byteOffset+offset+length)}if(sock.type===2){if(!dest||dest.socket.readyState!==dest.socket.OPEN){if(!dest||dest.socket.readyState===dest.socket.CLOSING||dest.socket.readyState===dest.socket.CLOSED){dest=SOCKFS.websocket_sock_ops.createPeer(sock,addr,port)}dest.dgram_send_queue.push(data);return length}}try{dest.socket.send(data);return length}catch(e){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}}),recvmsg:(function(sock,length){if(sock.type===1&&sock.server){throw new FS.ErrnoError(ERRNO_CODES.ENOTCONN)}var queued=sock.recv_queue.shift();if(!queued){if(sock.type===1){var dest=SOCKFS.websocket_sock_ops.getPeer(sock,sock.daddr,sock.dport);if(!dest){throw new FS.ErrnoError(ERRNO_CODES.ENOTCONN)}else if(dest.socket.readyState===dest.socket.CLOSING||dest.socket.readyState===dest.socket.CLOSED){return null}else{throw new FS.ErrnoError(ERRNO_CODES.EAGAIN)}}else{throw new FS.ErrnoError(ERRNO_CODES.EAGAIN)}}var queuedLength=queued.data.byteLength||queued.data.length;var queuedOffset=queued.data.byteOffset||0;var queuedBuffer=queued.data.buffer||queued.data;var bytesRead=Math.min(length,queuedLength);var res={buffer:new Uint8Array(queuedBuffer,queuedOffset,bytesRead),addr:queued.addr,port:queued.port};if(sock.type===1&&bytesRead<queuedLength){var bytesRemaining=queuedLength-bytesRead;queued.data=new Uint8Array(queuedBuffer,queuedOffset+bytesRead,bytesRemaining);sock.recv_queue.unshift(queued)}return res})}};function _send(fd,buf,len,flags){var sock=SOCKFS.getSocket(fd);if(!sock){___setErrNo(ERRNO_CODES.EBADF);return-1}return _write(fd,buf,len)}function _pwrite(fildes,buf,nbyte,offset){var stream=FS.getStream(fildes);if(!stream){___setErrNo(ERRNO_CODES.EBADF);return-1}try{var slab=HEAP8;return FS.write(stream,slab,buf,nbyte,offset)}catch(e){FS.handleFSError(e);return-1}}function _write(fildes,buf,nbyte){var stream=FS.getStream(fildes);if(!stream){___setErrNo(ERRNO_CODES.EBADF);return-1}try{var slab=HEAP8;return FS.write(stream,slab,buf,nbyte)}catch(e){FS.handleFSError(e);return-1}}function _fputc(c,stream){var chr=unSign(c&255);HEAP8[_fputc.ret>>0]=chr;var fd=_fileno(stream);var ret=_write(fd,_fputc.ret,1);if(ret==-1){var streamObj=FS.getStreamFromPtr(stream);if(streamObj)streamObj.error=true;return-1}else{return chr}}function _sysconf(name){switch(name){case 30:return PAGE_SIZE;case 132:case 133:case 12:case 137:case 138:case 15:case 235:case 16:case 17:case 18:case 19:case 20:case 149:case 13:case 10:case 236:case 153:case 9:case 21:case 22:case 159:case 154:case 14:case 77:case 78:case 139:case 80:case 81:case 79:case 82:case 68:case 67:case 164:case 11:case 29:case 47:case 48:case 95:case 52:case 51:case 46:return 200809;case 27:case 246:case 127:case 128:case 23:case 24:case 160:case 161:case 181:case 182:case 242:case 183:case 184:case 243:case 244:case 245:case 165:case 178:case 179:case 49:case 50:case 168:case 169:case 175:case 170:case 171:case 172:case 97:case 76:case 32:case 173:case 35:return-1;case 176:case 177:case 7:case 155:case 8:case 157:case 125:case 126:case 92:case 93:case 129:case 130:case 131:case 94:case 91:return 1;case 74:case 60:case 69:case 70:case 4:return 1024;case 31:case 42:case 72:return 32;case 87:case 26:case 33:return 2147483647;case 34:case 1:return 47839;case 38:case 36:return 99;case 43:case 37:return 2048;case 0:return 2097152;case 3:return 65536;case 28:return 32768;case 44:return 32767;case 75:return 16384;case 39:return 1e3;case 89:return 700;case 71:return 256;case 40:return 255;case 2:return 100;case 180:return 64;case 25:return 20;case 5:return 16;case 6:return 6;case 73:return 4;case 84:{if(typeof navigator==="object")return navigator["hardwareConcurrency"]||1;return 1}}___setErrNo(ERRNO_CODES.EINVAL);return-1}var _emscripten_postinvoke=true;function _fwrite(ptr,size,nitems,stream){var bytesToWrite=nitems*size;if(bytesToWrite==0)return 0;var fd=_fileno(stream);var bytesWritten=_write(fd,ptr,bytesToWrite);if(bytesWritten==-1){var streamObj=FS.getStreamFromPtr(stream);if(streamObj)streamObj.error=true;return 0}else{return Math.floor(bytesWritten/size)}}function ___gxx_personality_v0(){}Module["_bitshift64Lshr"]=_bitshift64Lshr;function _recv(fd,buf,len,flags){var sock=SOCKFS.getSocket(fd);if(!sock){___setErrNo(ERRNO_CODES.EBADF);return-1}return _read(fd,buf,len)}function _pread(fildes,buf,nbyte,offset){var stream=FS.getStream(fildes);if(!stream){___setErrNo(ERRNO_CODES.EBADF);return-1}try{var slab=HEAP8;return FS.read(stream,slab,buf,nbyte,offset)}catch(e){FS.handleFSError(e);return-1}}function _read(fildes,buf,nbyte){var stream=FS.getStream(fildes);if(!stream){___setErrNo(ERRNO_CODES.EBADF);return-1}try{var slab=HEAP8;return FS.read(stream,slab,buf,nbyte)}catch(e){FS.handleFSError(e);return-1}}function _fread(ptr,size,nitems,stream){var bytesToRead=nitems*size;if(bytesToRead==0){return 0}var bytesRead=0;var streamObj=FS.getStreamFromPtr(stream);if(!streamObj){___setErrNo(ERRNO_CODES.EBADF);return 0}while(streamObj.ungotten.length&&bytesToRead>0){HEAP8[ptr++>>0]=streamObj.ungotten.pop();bytesToRead--;bytesRead++}var err=_read(streamObj.fd,ptr,bytesToRead);if(err==-1){if(streamObj)streamObj.error=true;return 0}bytesRead+=err;if(bytesRead<bytesToRead)streamObj.eof=true;return Math.floor(bytesRead/size)}var _BDtoIHigh=true;function _pthread_cond_broadcast(){return 0}function __exit(status){Module["exit"](status)}function _exit(status){__exit(status)}function __ZSt9terminatev(){_exit(-1234)}Module["_strlen"]=_strlen;function __reallyNegative(x){return x<0||x===0&&1/x===-Infinity}function __formatString(format,varargs){var textIndex=format;var argIndex=0;function getNextArg(type){var ret;if(type==="double"){ret=(HEAP32[tempDoublePtr>>2]=HEAP32[varargs+argIndex>>2],HEAP32[tempDoublePtr+4>>2]=HEAP32[varargs+(argIndex+4)>>2],+HEAPF64[tempDoublePtr>>3])}else if(type=="i64"){ret=[HEAP32[varargs+argIndex>>2],HEAP32[varargs+(argIndex+4)>>2]]}else{type="i32";ret=HEAP32[varargs+argIndex>>2]}argIndex+=Runtime.getNativeFieldSize(type);return ret}var ret=[];var curr,next,currArg;while(1){var startTextIndex=textIndex;curr=HEAP8[textIndex>>0];if(curr===0)break;next=HEAP8[textIndex+1>>0];if(curr==37){var flagAlwaysSigned=false;var flagLeftAlign=false;var flagAlternative=false;var flagZeroPad=false;var flagPadSign=false;flagsLoop:while(1){switch(next){case 43:flagAlwaysSigned=true;break;case 45:flagLeftAlign=true;break;case 35:flagAlternative=true;break;case 48:if(flagZeroPad){break flagsLoop}else{flagZeroPad=true;break};case 32:flagPadSign=true;break;default:break flagsLoop}textIndex++;next=HEAP8[textIndex+1>>0]}var width=0;if(next==42){width=getNextArg("i32");textIndex++;next=HEAP8[textIndex+1>>0]}else{while(next>=48&&next<=57){width=width*10+(next-48);textIndex++;next=HEAP8[textIndex+1>>0]}}var precisionSet=false,precision=-1;if(next==46){precision=0;precisionSet=true;textIndex++;next=HEAP8[textIndex+1>>0];if(next==42){precision=getNextArg("i32");textIndex++}else{while(1){var precisionChr=HEAP8[textIndex+1>>0];if(precisionChr<48||precisionChr>57)break;precision=precision*10+(precisionChr-48);textIndex++}}next=HEAP8[textIndex+1>>0]}if(precision<0){precision=6;precisionSet=false}var argSize;switch(String.fromCharCode(next)){case"h":var nextNext=HEAP8[textIndex+2>>0];if(nextNext==104){textIndex++;argSize=1}else{argSize=2}break;case"l":var nextNext=HEAP8[textIndex+2>>0];if(nextNext==108){textIndex++;argSize=8}else{argSize=4}break;case"L":case"q":case"j":argSize=8;break;case"z":case"t":case"I":argSize=4;break;default:argSize=null}if(argSize)textIndex++;next=HEAP8[textIndex+1>>0];switch(String.fromCharCode(next)){case"d":case"i":case"u":case"o":case"x":case"X":case"p":{var signed=next==100||next==105;argSize=argSize||4;var currArg=getNextArg("i"+argSize*8);var origArg=currArg;var argText;if(argSize==8){currArg=Runtime.makeBigInt(currArg[0],currArg[1],next==117)}if(argSize<=4){var limit=Math.pow(256,argSize)-1;currArg=(signed?reSign:unSign)(currArg&limit,argSize*8)}var currAbsArg=Math.abs(currArg);var prefix="";if(next==100||next==105){if(argSize==8&&i64Math)argText=i64Math.stringify(origArg[0],origArg[1],null);else argText=reSign(currArg,8*argSize,1).toString(10)}else if(next==117){if(argSize==8&&i64Math)argText=i64Math.stringify(origArg[0],origArg[1],true);else argText=unSign(currArg,8*argSize,1).toString(10);currArg=Math.abs(currArg)}else if(next==111){argText=(flagAlternative?"0":"")+currAbsArg.toString(8)}else if(next==120||next==88){prefix=flagAlternative&&currArg!=0?"0x":"";if(argSize==8&&i64Math){if(origArg[1]){argText=(origArg[1]>>>0).toString(16);var lower=(origArg[0]>>>0).toString(16);while(lower.length<8)lower="0"+lower;argText+=lower}else{argText=(origArg[0]>>>0).toString(16)}}else if(currArg<0){currArg=-currArg;argText=(currAbsArg-1).toString(16);var buffer=[];for(var i=0;i<argText.length;i++){buffer.push((15-parseInt(argText[i],16)).toString(16))}argText=buffer.join("");while(argText.length<argSize*2)argText="f"+argText}else{argText=currAbsArg.toString(16)}if(next==88){prefix=prefix.toUpperCase();argText=argText.toUpperCase()}}else if(next==112){if(currAbsArg===0){argText="(nil)"}else{prefix="0x";argText=currAbsArg.toString(16)}}if(precisionSet){while(argText.length<precision){argText="0"+argText}}if(currArg>=0){if(flagAlwaysSigned){prefix="+"+prefix}else if(flagPadSign){prefix=" "+prefix}}if(argText.charAt(0)=="-"){prefix="-"+prefix;argText=argText.substr(1)}while(prefix.length+argText.length<width){if(flagLeftAlign){argText+=" "}else{if(flagZeroPad){argText="0"+argText}else{prefix=" "+prefix}}}argText=prefix+argText;argText.split("").forEach((function(chr){ret.push(chr.charCodeAt(0))}));break};case"f":case"F":case"e":case"E":case"g":case"G":{var currArg=getNextArg("double");var argText;if(isNaN(currArg)){argText="nan";flagZeroPad=false}else if(!isFinite(currArg)){argText=(currArg<0?"-":"")+"inf";flagZeroPad=false}else{var isGeneral=false;var effectivePrecision=Math.min(precision,20);if(next==103||next==71){isGeneral=true;precision=precision||1;var exponent=parseInt(currArg.toExponential(effectivePrecision).split("e")[1],10);if(precision>exponent&&exponent>=-4){next=(next==103?"f":"F").charCodeAt(0);precision-=exponent+1}else{next=(next==103?"e":"E").charCodeAt(0);precision--}effectivePrecision=Math.min(precision,20)}if(next==101||next==69){argText=currArg.toExponential(effectivePrecision);if(/[eE][-+]\d$/.test(argText)){argText=argText.slice(0,-1)+"0"+argText.slice(-1)}}else if(next==102||next==70){argText=currArg.toFixed(effectivePrecision);if(currArg===0&&__reallyNegative(currArg)){argText="-"+argText}}var parts=argText.split("e");if(isGeneral&&!flagAlternative){while(parts[0].length>1&&parts[0].indexOf(".")!=-1&&(parts[0].slice(-1)=="0"||parts[0].slice(-1)==".")){parts[0]=parts[0].slice(0,-1)}}else{if(flagAlternative&&argText.indexOf(".")==-1)parts[0]+=".";while(precision>effectivePrecision++)parts[0]+="0"}argText=parts[0]+(parts.length>1?"e"+parts[1]:"");if(next==69)argText=argText.toUpperCase();if(currArg>=0){if(flagAlwaysSigned){argText="+"+argText}else if(flagPadSign){argText=" "+argText}}}while(argText.length<width){if(flagLeftAlign){argText+=" "}else{if(flagZeroPad&&(argText[0]=="-"||argText[0]=="+")){argText=argText[0]+"0"+argText.slice(1)}else{argText=(flagZeroPad?"0":" ")+argText}}}if(next<97)argText=argText.toUpperCase();argText.split("").forEach((function(chr){ret.push(chr.charCodeAt(0))}));break};case"s":{var arg=getNextArg("i8*");var argLength=arg?_strlen(arg):"(null)".length;if(precisionSet)argLength=Math.min(argLength,precision);if(!flagLeftAlign){while(argLength<width--){ret.push(32)}}if(arg){for(var i=0;i<argLength;i++){ret.push(HEAPU8[arg++>>0])}}else{ret=ret.concat(intArrayFromString("(null)".substr(0,argLength),true))}if(flagLeftAlign){while(argLength<width--){ret.push(32)}}break};case"c":{if(flagLeftAlign)ret.push(getNextArg("i8"));while(--width>0){ret.push(32)}if(!flagLeftAlign)ret.push(getNextArg("i8"));break};case"n":{var ptr=getNextArg("i32*");HEAP32[ptr>>2]=ret.length;break};case"%":{ret.push(curr);break};default:{for(var i=startTextIndex;i<textIndex+2;i++){ret.push(HEAP8[i>>0])}}}textIndex+=2}else{ret.push(curr);textIndex+=1}}return ret}function _fprintf(stream,format,varargs){var result=__formatString(format,varargs);var stack=Runtime.stackSave();var ret=_fwrite(allocate(result,"i8",ALLOC_STACK),1,result.length,stream);Runtime.stackRestore(stack);return ret}function _vfprintf(s,f,va_arg){return _fprintf(s,f,HEAP32[va_arg>>2])}function _pthread_mutex_unlock(){}function _emscripten_memcpy_big(dest,src,num){HEAPU8.set(HEAPU8.subarray(src,src+num),dest);return dest}Module["_memcpy"]=_memcpy;function _pthread_mutex_lock(){}function ___cxa_call_unexpected(exception){Module.printErr("Unexpected exception thrown, this is not properly supported - aborting");ABORT=true;throw exception}function _sbrk(bytes){var self=_sbrk;if(!self.called){DYNAMICTOP=alignMemoryPage(DYNAMICTOP);self.called=true;assert(Runtime.dynamicAlloc);self.alloc=Runtime.dynamicAlloc;Runtime.dynamicAlloc=(function(){abort("cannot dynamically allocate, sbrk now has control")})}var ret=DYNAMICTOP;if(bytes!=0)self.alloc(bytes);return ret}Module["_bitshift64Shl"]=_bitshift64Shl;function ___cxa_guard_abort(){}function _malloc(bytes){var ptr=Runtime.dynamicAlloc(bytes+8);return ptr+8&4294967288}Module["_malloc"]=_malloc;function _newlocale(mask,locale,base){return _malloc(4)}Module["_memmove"]=_memmove;var _emscripten_preinvoke=true;function _strerror_r(errnum,strerrbuf,buflen){if(errnum in ERRNO_MESSAGES){if(ERRNO_MESSAGES[errnum].length>buflen-1){return ___setErrNo(ERRNO_CODES.ERANGE)}else{var msg=ERRNO_MESSAGES[errnum];writeAsciiToMemory(msg,strerrbuf);return 0}}else{return ___setErrNo(ERRNO_CODES.EINVAL)}}function _strerror(errnum){if(!_strerror.buffer)_strerror.buffer=_malloc(256);_strerror_r(errnum,_strerror.buffer,256);return _strerror.buffer}function _catclose(catd){return 0}function ___cxa_rethrow(){___cxa_end_catch.rethrown=true;var ptr=___cxa_caught_exceptions.pop();throw ptr}function ___cxa_guard_release(){}function _ungetc(c,stream){stream=FS.getStreamFromPtr(stream);if(!stream){return-1}if(c===-1){return c}c=unSign(c&255);stream.ungotten.push(c);stream.eof=false;return c}function _uselocale(locale){return 0}function ___assert_fail(condition,filename,line,func){ABORT=true;throw"Assertion failed: "+Pointer_stringify(condition)+", at: "+[filename?Pointer_stringify(filename):"unknown filename",line,func?Pointer_stringify(func):"unknown function"]+" at "+stackTrace()}function ___errno_location(){return ___errno_state}Module["_memset"]=_memset;var _BDtoILow=true;var _BItoD=true;function __isLeapYear(year){return year%4===0&&(year%100!==0||year%400===0)}function __arraySum(array,index){var sum=0;for(var i=0;i<=index;sum+=array[i++]);return sum}var __MONTH_DAYS_LEAP=[31,29,31,30,31,30,31,31,30,31,30,31];var __MONTH_DAYS_REGULAR=[31,28,31,30,31,30,31,31,30,31,30,31];function __addDays(date,days){var newDate=new Date(date.getTime());while(days>0){var leap=__isLeapYear(newDate.getFullYear());var currentMonth=newDate.getMonth();var daysInCurrentMonth=(leap?__MONTH_DAYS_LEAP:__MONTH_DAYS_REGULAR)[currentMonth];if(days>daysInCurrentMonth-newDate.getDate()){days-=daysInCurrentMonth-newDate.getDate()+1;newDate.setDate(1);if(currentMonth<11){newDate.setMonth(currentMonth+1)}else{newDate.setMonth(0);newDate.setFullYear(newDate.getFullYear()+1)}}else{newDate.setDate(newDate.getDate()+days);return newDate}}return newDate}function _strftime(s,maxsize,format,tm){var date={tm_sec:HEAP32[tm>>2],tm_min:HEAP32[tm+4>>2],tm_hour:HEAP32[tm+8>>2],tm_mday:HEAP32[tm+12>>2],tm_mon:HEAP32[tm+16>>2],tm_year:HEAP32[tm+20>>2],tm_wday:HEAP32[tm+24>>2],tm_yday:HEAP32[tm+28>>2],tm_isdst:HEAP32[tm+32>>2]};var pattern=Pointer_stringify(format);var EXPANSION_RULES_1={"%c":"%a %b %d %H:%M:%S %Y","%D":"%m/%d/%y","%F":"%Y-%m-%d","%h":"%b","%r":"%I:%M:%S %p","%R":"%H:%M","%T":"%H:%M:%S","%x":"%m/%d/%y","%X":"%H:%M:%S"};for(var rule in EXPANSION_RULES_1){pattern=pattern.replace(new RegExp(rule,"g"),EXPANSION_RULES_1[rule])}var WEEKDAYS=["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"];var MONTHS=["January","February","March","April","May","June","July","August","September","October","November","December"];function leadingSomething(value,digits,character){var str=typeof value==="number"?value.toString():value||"";while(str.length<digits){str=character[0]+str}return str}function leadingNulls(value,digits){return leadingSomething(value,digits,"0")}function compareByDay(date1,date2){function sgn(value){return value<0?-1:value>0?1:0}var compare;if((compare=sgn(date1.getFullYear()-date2.getFullYear()))===0){if((compare=sgn(date1.getMonth()-date2.getMonth()))===0){compare=sgn(date1.getDate()-date2.getDate())}}return compare}function getFirstWeekStartDate(janFourth){switch(janFourth.getDay()){case 0:return new Date(janFourth.getFullYear()-1,11,29);case 1:return janFourth;case 2:return new Date(janFourth.getFullYear(),0,3);case 3:return new Date(janFourth.getFullYear(),0,2);case 4:return new Date(janFourth.getFullYear(),0,1);case 5:return new Date(janFourth.getFullYear()-1,11,31);case 6:return new Date(janFourth.getFullYear()-1,11,30)}}function getWeekBasedYear(date){var thisDate=__addDays(new Date(date.tm_year+1900,0,1),date.tm_yday);var janFourthThisYear=new Date(thisDate.getFullYear(),0,4);var janFourthNextYear=new Date(thisDate.getFullYear()+1,0,4);var firstWeekStartThisYear=getFirstWeekStartDate(janFourthThisYear);var firstWeekStartNextYear=getFirstWeekStartDate(janFourthNextYear);if(compareByDay(firstWeekStartThisYear,thisDate)<=0){if(compareByDay(firstWeekStartNextYear,thisDate)<=0){return thisDate.getFullYear()+1}else{return thisDate.getFullYear()}}else{return thisDate.getFullYear()-1}}var EXPANSION_RULES_2={"%a":(function(date){return WEEKDAYS[date.tm_wday].substring(0,3)}),"%A":(function(date){return WEEKDAYS[date.tm_wday]}),"%b":(function(date){return MONTHS[date.tm_mon].substring(0,3)}),"%B":(function(date){return MONTHS[date.tm_mon]}),"%C":(function(date){var year=date.tm_year+1900;return leadingNulls(Math.floor(year/100),2)}),"%d":(function(date){return leadingNulls(date.tm_mday,2)}),"%e":(function(date){return leadingSomething(date.tm_mday,2," ")}),"%g":(function(date){return getWeekBasedYear(date).toString().substring(2)}),"%G":(function(date){return getWeekBasedYear(date)}),"%H":(function(date){return leadingNulls(date.tm_hour,2)}),"%I":(function(date){return leadingNulls(date.tm_hour<13?date.tm_hour:date.tm_hour-12,2)}),"%j":(function(date){return leadingNulls(date.tm_mday+__arraySum(__isLeapYear(date.tm_year+1900)?__MONTH_DAYS_LEAP:__MONTH_DAYS_REGULAR,date.tm_mon-1),3)}),"%m":(function(date){return leadingNulls(date.tm_mon+1,2)}),"%M":(function(date){return leadingNulls(date.tm_min,2)}),"%n":(function(){return"\n"}),"%p":(function(date){if(date.tm_hour>0&&date.tm_hour<13){return"AM"}else{return"PM"}}),"%S":(function(date){return leadingNulls(date.tm_sec,2)}),"%t":(function(){return"\t"}),"%u":(function(date){var day=new Date(date.tm_year+1900,date.tm_mon+1,date.tm_mday,0,0,0,0);return day.getDay()||7}),"%U":(function(date){var janFirst=new Date(date.tm_year+1900,0,1);var firstSunday=janFirst.getDay()===0?janFirst:__addDays(janFirst,7-janFirst.getDay());var endDate=new Date(date.tm_year+1900,date.tm_mon,date.tm_mday);if(compareByDay(firstSunday,endDate)<0){var februaryFirstUntilEndMonth=__arraySum(__isLeapYear(endDate.getFullYear())?__MONTH_DAYS_LEAP:__MONTH_DAYS_REGULAR,endDate.getMonth()-1)-31;var firstSundayUntilEndJanuary=31-firstSunday.getDate();var days=firstSundayUntilEndJanuary+februaryFirstUntilEndMonth+endDate.getDate();return leadingNulls(Math.ceil(days/7),2)}return compareByDay(firstSunday,janFirst)===0?"01":"00"}),"%V":(function(date){var janFourthThisYear=new Date(date.tm_year+1900,0,4);var janFourthNextYear=new Date(date.tm_year+1901,0,4);var firstWeekStartThisYear=getFirstWeekStartDate(janFourthThisYear);var firstWeekStartNextYear=getFirstWeekStartDate(janFourthNextYear);var endDate=__addDays(new Date(date.tm_year+1900,0,1),date.tm_yday);if(compareByDay(endDate,firstWeekStartThisYear)<0){return"53"}if(compareByDay(firstWeekStartNextYear,endDate)<=0){return"01"}var daysDifference;if(firstWeekStartThisYear.getFullYear()<date.tm_year+1900){daysDifference=date.tm_yday+32-firstWeekStartThisYear.getDate()}else{daysDifference=date.tm_yday+1-firstWeekStartThisYear.getDate()}return leadingNulls(Math.ceil(daysDifference/7),2)}),"%w":(function(date){var day=new Date(date.tm_year+1900,date.tm_mon+1,date.tm_mday,0,0,0,0);return day.getDay()}),"%W":(function(date){var janFirst=new Date(date.tm_year,0,1);var firstMonday=janFirst.getDay()===1?janFirst:__addDays(janFirst,janFirst.getDay()===0?1:7-janFirst.getDay()+1);var endDate=new Date(date.tm_year+1900,date.tm_mon,date.tm_mday);if(compareByDay(firstMonday,endDate)<0){var februaryFirstUntilEndMonth=__arraySum(__isLeapYear(endDate.getFullYear())?__MONTH_DAYS_LEAP:__MONTH_DAYS_REGULAR,endDate.getMonth()-1)-31;var firstMondayUntilEndJanuary=31-firstMonday.getDate();var days=firstMondayUntilEndJanuary+februaryFirstUntilEndMonth+endDate.getDate();return leadingNulls(Math.ceil(days/7),2)}return compareByDay(firstMonday,janFirst)===0?"01":"00"}),"%y":(function(date){return(date.tm_year+1900).toString().substring(2)}),"%Y":(function(date){return date.tm_year+1900}),"%z":(function(date){return""}),"%Z":(function(date){return""}),"%%":(function(){return"%"})};for(var rule in EXPANSION_RULES_2){if(pattern.indexOf(rule)>=0){pattern=pattern.replace(new RegExp(rule,"g"),EXPANSION_RULES_2[rule](date))}}var bytes=intArrayFromString(pattern,false);if(bytes.length>maxsize){return 0}writeArrayToMemory(bytes,s);return bytes.length-1}function _strftime_l(s,maxsize,format,tm){return _strftime(s,maxsize,format,tm)}function _abort(){Module["abort"]()}function _pthread_cond_wait(){return 0}function _fabs(){return Math_abs.apply(null,arguments)}function _clock(){if(_clock.start===undefined)_clock.start=Date.now();return Math.floor((Date.now()-_clock.start)*(1e6/1e3))}function _fgetc(stream){var streamObj=FS.getStreamFromPtr(stream);if(!streamObj)return-1;if(streamObj.eof||streamObj.error)return-1;var ret=_fread(_fgetc.ret,1,1,stream);if(ret==0){return-1}else if(ret==-1){streamObj.error=true;return-1}else{return HEAPU8[_fgetc.ret>>0]}}function _getc(){return _fgetc.apply(null,arguments)}var Browser={mainLoop:{scheduler:null,method:"",shouldPause:false,paused:false,queue:[],pause:(function(){Browser.mainLoop.shouldPause=true}),resume:(function(){if(Browser.mainLoop.paused){Browser.mainLoop.paused=false;Browser.mainLoop.scheduler()}Browser.mainLoop.shouldPause=false}),updateStatus:(function(){if(Module["setStatus"]){var message=Module["statusMessage"]||"Please wait...";var remaining=Browser.mainLoop.remainingBlockers;var expected=Browser.mainLoop.expectedBlockers;if(remaining){if(remaining<expected){Module["setStatus"](message+" ("+(expected-remaining)+"/"+expected+")")}else{Module["setStatus"](message)}}else{Module["setStatus"]("")}}}),runIter:(function(func){if(ABORT)return;if(Module["preMainLoop"]){var preRet=Module["preMainLoop"]();if(preRet===false){return}}try{func()}catch(e){if(e instanceof ExitStatus){return}else{if(e&&typeof e==="object"&&e.stack)Module.printErr("exception thrown: "+[e,e.stack]);throw e}}if(Module["postMainLoop"])Module["postMainLoop"]()})},isFullScreen:false,pointerLock:false,moduleContextCreatedCallbacks:[],workers:[],init:(function(){if(!Module["preloadPlugins"])Module["preloadPlugins"]=[];if(Browser.initted)return;Browser.initted=true;try{new Blob;Browser.hasBlobConstructor=true}catch(e){Browser.hasBlobConstructor=false;console.log("warning: no blob constructor, cannot create blobs with mimetypes")}Browser.BlobBuilder=typeof MozBlobBuilder!="undefined"?MozBlobBuilder:typeof WebKitBlobBuilder!="undefined"?WebKitBlobBuilder:!Browser.hasBlobConstructor?console.log("warning: no BlobBuilder"):null;Browser.URLObject=typeof window!="undefined"?window.URL?window.URL:window.webkitURL:undefined;if(!Module.noImageDecoding&&typeof Browser.URLObject==="undefined"){console.log("warning: Browser does not support creating object URLs. Built-in browser image decoding will not be available.");Module.noImageDecoding=true}var imagePlugin={};imagePlugin["canHandle"]=function imagePlugin_canHandle(name){return!Module.noImageDecoding&&/\.(jpg|jpeg|png|bmp)$/i.test(name)};imagePlugin["handle"]=function imagePlugin_handle(byteArray,name,onload,onerror){var b=null;if(Browser.hasBlobConstructor){try{b=new Blob([byteArray],{type:Browser.getMimetype(name)});if(b.size!==byteArray.length){b=new Blob([(new Uint8Array(byteArray)).buffer],{type:Browser.getMimetype(name)})}}catch(e){Runtime.warnOnce("Blob constructor present but fails: "+e+"; falling back to blob builder")}}if(!b){var bb=new Browser.BlobBuilder;bb.append((new Uint8Array(byteArray)).buffer);b=bb.getBlob()}var url=Browser.URLObject.createObjectURL(b);var img=new Image;img.onload=function img_onload(){assert(img.complete,"Image "+name+" could not be decoded");var canvas=document.createElement("canvas");canvas.width=img.width;canvas.height=img.height;var ctx=canvas.getContext("2d");ctx.drawImage(img,0,0);Module["preloadedImages"][name]=canvas;Browser.URLObject.revokeObjectURL(url);if(onload)onload(byteArray)};img.onerror=function img_onerror(event){console.log("Image "+url+" could not be decoded");if(onerror)onerror()};img.src=url};Module["preloadPlugins"].push(imagePlugin);var audioPlugin={};audioPlugin["canHandle"]=function audioPlugin_canHandle(name){return!Module.noAudioDecoding&&name.substr(-4)in{".ogg":1,".wav":1,".mp3":1}};audioPlugin["handle"]=function audioPlugin_handle(byteArray,name,onload,onerror){var done=false;function finish(audio){if(done)return;done=true;Module["preloadedAudios"][name]=audio;if(onload)onload(byteArray)}function fail(){if(done)return;done=true;Module["preloadedAudios"][name]=new Audio;if(onerror)onerror()}if(Browser.hasBlobConstructor){try{var b=new Blob([byteArray],{type:Browser.getMimetype(name)})}catch(e){return fail()}var url=Browser.URLObject.createObjectURL(b);var audio=new Audio;audio.addEventListener("canplaythrough",(function(){finish(audio)}),false);audio.onerror=function audio_onerror(event){if(done)return;console.log("warning: browser could not fully decode audio "+name+", trying slower base64 approach");function encode64(data){var BASE="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";var PAD="=";var ret="";var leftchar=0;var leftbits=0;for(var i=0;i<data.length;i++){leftchar=leftchar<<8|data[i];leftbits+=8;while(leftbits>=6){var curr=leftchar>>leftbits-6&63;leftbits-=6;ret+=BASE[curr]}}if(leftbits==2){ret+=BASE[(leftchar&3)<<4];ret+=PAD+PAD}else if(leftbits==4){ret+=BASE[(leftchar&15)<<2];ret+=PAD}return ret}audio.src="data:audio/x-"+name.substr(-3)+";base64,"+encode64(byteArray);finish(audio)};audio.src=url;Browser.safeSetTimeout((function(){finish(audio)}),1e4)}else{return fail()}};Module["preloadPlugins"].push(audioPlugin);var canvas=Module["canvas"];function pointerLockChange(){Browser.pointerLock=document["pointerLockElement"]===canvas||document["mozPointerLockElement"]===canvas||document["webkitPointerLockElement"]===canvas||document["msPointerLockElement"]===canvas}if(canvas){canvas.requestPointerLock=canvas["requestPointerLock"]||canvas["mozRequestPointerLock"]||canvas["webkitRequestPointerLock"]||canvas["msRequestPointerLock"]||(function(){});canvas.exitPointerLock=document["exitPointerLock"]||document["mozExitPointerLock"]||document["webkitExitPointerLock"]||document["msExitPointerLock"]||(function(){});canvas.exitPointerLock=canvas.exitPointerLock.bind(document);document.addEventListener("pointerlockchange",pointerLockChange,false);document.addEventListener("mozpointerlockchange",pointerLockChange,false);document.addEventListener("webkitpointerlockchange",pointerLockChange,false);document.addEventListener("mspointerlockchange",pointerLockChange,false);if(Module["elementPointerLock"]){canvas.addEventListener("click",(function(ev){if(!Browser.pointerLock&&canvas.requestPointerLock){canvas.requestPointerLock();ev.preventDefault()}}),false)}}}),createContext:(function(canvas,useWebGL,setInModule,webGLContextAttributes){if(useWebGL&&Module.ctx)return Module.ctx;var ctx;var errorInfo="?";function onContextCreationError(event){errorInfo=event.statusMessage||errorInfo}try{if(useWebGL){var contextAttributes={antialias:false,alpha:false};if(webGLContextAttributes){for(var attribute in webGLContextAttributes){contextAttributes[attribute]=webGLContextAttributes[attribute]}}canvas.addEventListener("webglcontextcreationerror",onContextCreationError,false);try{["experimental-webgl","webgl"].some((function(webglId){return ctx=canvas.getContext(webglId,contextAttributes)}))}finally{canvas.removeEventListener("webglcontextcreationerror",onContextCreationError,false)}}else{ctx=canvas.getContext("2d")}if(!ctx)throw":("}catch(e){Module.print("Could not create canvas: "+[errorInfo,e]);return null}if(useWebGL){canvas.style.backgroundColor="black"}if(setInModule){if(!useWebGL)assert(typeof GLctx==="undefined","cannot set in module if GLctx is used, but we are a non-GL context that would replace it");Module.ctx=ctx;if(useWebGL)GLctx=ctx;Module.useWebGL=useWebGL;Browser.moduleContextCreatedCallbacks.forEach((function(callback){callback()}));Browser.init()}return ctx}),destroyContext:(function(canvas,useWebGL,setInModule){}),fullScreenHandlersInstalled:false,lockPointer:undefined,resizeCanvas:undefined,requestFullScreen:(function(lockPointer,resizeCanvas){Browser.lockPointer=lockPointer;Browser.resizeCanvas=resizeCanvas;if(typeof Browser.lockPointer==="undefined")Browser.lockPointer=true;if(typeof Browser.resizeCanvas==="undefined")Browser.resizeCanvas=false;var canvas=Module["canvas"];function fullScreenChange(){Browser.isFullScreen=false;var canvasContainer=canvas.parentNode;if((document["webkitFullScreenElement"]||document["webkitFullscreenElement"]||document["mozFullScreenElement"]||document["mozFullscreenElement"]||document["fullScreenElement"]||document["fullscreenElement"]||document["msFullScreenElement"]||document["msFullscreenElement"]||document["webkitCurrentFullScreenElement"])===canvasContainer){canvas.cancelFullScreen=document["cancelFullScreen"]||document["mozCancelFullScreen"]||document["webkitCancelFullScreen"]||document["msExitFullscreen"]||document["exitFullscreen"]||(function(){});canvas.cancelFullScreen=canvas.cancelFullScreen.bind(document);if(Browser.lockPointer)canvas.requestPointerLock();Browser.isFullScreen=true;if(Browser.resizeCanvas)Browser.setFullScreenCanvasSize()}else{canvasContainer.parentNode.insertBefore(canvas,canvasContainer);canvasContainer.parentNode.removeChild(canvasContainer);if(Browser.resizeCanvas)Browser.setWindowedCanvasSize()}if(Module["onFullScreen"])Module["onFullScreen"](Browser.isFullScreen);Browser.updateCanvasDimensions(canvas)}if(!Browser.fullScreenHandlersInstalled){Browser.fullScreenHandlersInstalled=true;document.addEventListener("fullscreenchange",fullScreenChange,false);document.addEventListener("mozfullscreenchange",fullScreenChange,false);document.addEventListener("webkitfullscreenchange",fullScreenChange,false);document.addEventListener("MSFullscreenChange",fullScreenChange,false)}var canvasContainer=document.createElement("div");canvas.parentNode.insertBefore(canvasContainer,canvas);canvasContainer.appendChild(canvas);canvasContainer.requestFullScreen=canvasContainer["requestFullScreen"]||canvasContainer["mozRequestFullScreen"]||canvasContainer["msRequestFullscreen"]||(canvasContainer["webkitRequestFullScreen"]?(function(){canvasContainer["webkitRequestFullScreen"](Element["ALLOW_KEYBOARD_INPUT"])}):null);canvasContainer.requestFullScreen()}),nextRAF:0,fakeRequestAnimationFrame:(function(func){var now=Date.now();if(Browser.nextRAF===0){Browser.nextRAF=now+1e3/60}else{while(now+2>=Browser.nextRAF){Browser.nextRAF+=1e3/60}}var delay=Math.max(Browser.nextRAF-now,0);setTimeout(func,delay)}),requestAnimationFrame:function requestAnimationFrame(func){if(typeof window==="undefined"){Browser.fakeRequestAnimationFrame(func)}else{if(!window.requestAnimationFrame){window.requestAnimationFrame=window["requestAnimationFrame"]||window["mozRequestAnimationFrame"]||window["webkitRequestAnimationFrame"]||window["msRequestAnimationFrame"]||window["oRequestAnimationFrame"]||Browser.fakeRequestAnimationFrame}window.requestAnimationFrame(func)}},safeCallback:(function(func){return(function(){if(!ABORT)return func.apply(null,arguments)})}),safeRequestAnimationFrame:(function(func){return Browser.requestAnimationFrame((function(){if(!ABORT)func()}))}),safeSetTimeout:(function(func,timeout){Module["noExitRuntime"]=true;return setTimeout((function(){if(!ABORT)func()}),timeout)}),safeSetInterval:(function(func,timeout){Module["noExitRuntime"]=true;return setInterval((function(){if(!ABORT)func()}),timeout)}),getMimetype:(function(name){return{"jpg":"image/jpeg","jpeg":"image/jpeg","png":"image/png","bmp":"image/bmp","ogg":"audio/ogg","wav":"audio/wav","mp3":"audio/mpeg"}[name.substr(name.lastIndexOf(".")+1)]}),getUserMedia:(function(func){if(!window.getUserMedia){window.getUserMedia=navigator["getUserMedia"]||navigator["mozGetUserMedia"]}window.getUserMedia(func)}),getMovementX:(function(event){return event["movementX"]||event["mozMovementX"]||event["webkitMovementX"]||0}),getMovementY:(function(event){return event["movementY"]||event["mozMovementY"]||event["webkitMovementY"]||0}),getMouseWheelDelta:(function(event){var delta=0;switch(event.type){case"DOMMouseScroll":delta=event.detail;break;case"mousewheel":delta=-event.wheelDelta;break;case"wheel":delta=event.deltaY;break;default:throw"unrecognized mouse wheel event: "+event.type}return Math.max(-1,Math.min(1,delta))}),mouseX:0,mouseY:0,mouseMovementX:0,mouseMovementY:0,touches:{},lastTouches:{},calculateMouseEvent:(function(event){if(Browser.pointerLock){if(event.type!="mousemove"&&"mozMovementX"in event){Browser.mouseMovementX=Browser.mouseMovementY=0}else{Browser.mouseMovementX=Browser.getMovementX(event);Browser.mouseMovementY=Browser.getMovementY(event)}if(typeof SDL!="undefined"){Browser.mouseX=SDL.mouseX+Browser.mouseMovementX;Browser.mouseY=SDL.mouseY+Browser.mouseMovementY}else{Browser.mouseX+=Browser.mouseMovementX;Browser.mouseY+=Browser.mouseMovementY}}else{var rect=Module["canvas"].getBoundingClientRect();var cw=Module["canvas"].width;var ch=Module["canvas"].height;var scrollX=typeof window.scrollX!=="undefined"?window.scrollX:window.pageXOffset;var scrollY=typeof window.scrollY!=="undefined"?window.scrollY:window.pageYOffset;if(event.type==="touchstart"||event.type==="touchend"||event.type==="touchmove"){var touch=event.touch;if(touch===undefined){return}var adjustedX=touch.pageX-(scrollX+rect.left);var adjustedY=touch.pageY-(scrollY+rect.top);adjustedX=adjustedX*(cw/rect.width);adjustedY=adjustedY*(ch/rect.height);var coords={x:adjustedX,y:adjustedY};if(event.type==="touchstart"){Browser.lastTouches[touch.identifier]=coords;Browser.touches[touch.identifier]=coords}else if(event.type==="touchend"||event.type==="touchmove"){Browser.lastTouches[touch.identifier]=Browser.touches[touch.identifier];Browser.touches[touch.identifier]={x:adjustedX,y:adjustedY}}return}var x=event.pageX-(scrollX+rect.left);var y=event.pageY-(scrollY+rect.top);x=x*(cw/rect.width);y=y*(ch/rect.height);Browser.mouseMovementX=x-Browser.mouseX;Browser.mouseMovementY=y-Browser.mouseY;Browser.mouseX=x;Browser.mouseY=y}}),xhrLoad:(function(url,onload,onerror){var xhr=new XMLHttpRequest;xhr.open("GET",url,true);xhr.responseType="arraybuffer";xhr.onload=function xhr_onload(){if(xhr.status==200||xhr.status==0&&xhr.response){onload(xhr.response)}else{onerror()}};xhr.onerror=onerror;xhr.send(null)}),asyncLoad:(function(url,onload,onerror,noRunDep){Browser.xhrLoad(url,(function(arrayBuffer){assert(arrayBuffer,'Loading data file "'+url+'" failed (no arrayBuffer).');onload(new Uint8Array(arrayBuffer));if(!noRunDep)removeRunDependency("al "+url)}),(function(event){if(onerror){onerror()}else{throw'Loading data file "'+url+'" failed.'}}));if(!noRunDep)addRunDependency("al "+url)}),resizeListeners:[],updateResizeListeners:(function(){var canvas=Module["canvas"];Browser.resizeListeners.forEach((function(listener){listener(canvas.width,canvas.height)}))}),setCanvasSize:(function(width,height,noUpdates){var canvas=Module["canvas"];Browser.updateCanvasDimensions(canvas,width,height);if(!noUpdates)Browser.updateResizeListeners()}),windowedWidth:0,windowedHeight:0,setFullScreenCanvasSize:(function(){if(typeof SDL!="undefined"){var flags=HEAPU32[SDL.screen+Runtime.QUANTUM_SIZE*0>>2];flags=flags|8388608;HEAP32[SDL.screen+Runtime.QUANTUM_SIZE*0>>2]=flags}Browser.updateResizeListeners()}),setWindowedCanvasSize:(function(){if(typeof SDL!="undefined"){var flags=HEAPU32[SDL.screen+Runtime.QUANTUM_SIZE*0>>2];flags=flags&~8388608;HEAP32[SDL.screen+Runtime.QUANTUM_SIZE*0>>2]=flags}Browser.updateResizeListeners()}),updateCanvasDimensions:(function(canvas,wNative,hNative){if(wNative&&hNative){canvas.widthNative=wNative;canvas.heightNative=hNative}else{wNative=canvas.widthNative;hNative=canvas.heightNative}var w=wNative;var h=hNative;if(Module["forcedAspectRatio"]&&Module["forcedAspectRatio"]>0){if(w/h<Module["forcedAspectRatio"]){w=Math.round(h*Module["forcedAspectRatio"])}else{h=Math.round(w/Module["forcedAspectRatio"])}}if((document["webkitFullScreenElement"]||document["webkitFullscreenElement"]||document["mozFullScreenElement"]||document["mozFullscreenElement"]||document["fullScreenElement"]||document["fullscreenElement"]||document["msFullScreenElement"]||document["msFullscreenElement"]||document["webkitCurrentFullScreenElement"])===canvas.parentNode&&typeof screen!="undefined"){var factor=Math.min(screen.width/w,screen.height/h);w=Math.round(w*factor);h=Math.round(h*factor)}if(Browser.resizeCanvas){if(canvas.width!=w)canvas.width=w;if(canvas.height!=h)canvas.height=h;if(typeof canvas.style!="undefined"){canvas.style.removeProperty("width");canvas.style.removeProperty("height")}}else{if(canvas.width!=wNative)canvas.width=wNative;if(canvas.height!=hNative)canvas.height=hNative;if(typeof canvas.style!="undefined"){if(w!=wNative||h!=hNative){canvas.style.setProperty("width",w+"px","important");canvas.style.setProperty("height",h+"px","important")}else{canvas.style.removeProperty("width");canvas.style.removeProperty("height")}}}})};function _lseek(fildes,offset,whence){var stream=FS.getStream(fildes);if(!stream){___setErrNo(ERRNO_CODES.EBADF);return-1}try{return FS.llseek(stream,offset,whence)}catch(e){FS.handleFSError(e);return-1}}function _fseek(stream,offset,whence){var fd=_fileno(stream);var ret=_lseek(fd,offset,whence);if(ret==-1){return-1}stream=FS.getStreamFromPtr(stream);stream.eof=false;return 0}function _rewind(stream){_fseek(stream,0,0);var streamObj=FS.getStreamFromPtr(stream);if(streamObj)streamObj.error=false}function ___ctype_b_loc(){var me=___ctype_b_loc;if(!me.ret){var values=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,8195,8194,8194,8194,8194,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,24577,49156,49156,49156,49156,49156,49156,49156,49156,49156,49156,49156,49156,49156,49156,49156,55304,55304,55304,55304,55304,55304,55304,55304,55304,55304,49156,49156,49156,49156,49156,49156,49156,54536,54536,54536,54536,54536,54536,50440,50440,50440,50440,50440,50440,50440,50440,50440,50440,50440,50440,50440,50440,50440,50440,50440,50440,50440,50440,49156,49156,49156,49156,49156,49156,54792,54792,54792,54792,54792,54792,50696,50696,50696,50696,50696,50696,50696,50696,50696,50696,50696,50696,50696,50696,50696,50696,50696,50696,50696,50696,49156,49156,49156,49156,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];var i16size=2;var arr=_malloc(values.length*i16size);for(var i=0;i<values.length;i++){HEAP16[arr+i*i16size>>1]=values[i]}me.ret=allocate([arr+128*i16size],"i16*",ALLOC_NORMAL)}return me.ret}function _freelocale(locale){_free(locale)}function ___cxa_allocate_exception(size){var ptr=_malloc(size+___cxa_exception_header_size);return ptr+___cxa_exception_header_size}function _fmod(x,y){return x%y}function _fmodl(){return _fmod.apply(null,arguments)}function ___cxa_pure_virtual(){ABORT=true;throw"Pure virtual function called!"}function _catgets(catd,set_id,msg_id,s){return s}var ctlz_i8=allocate([8,7,6,6,5,5,5,5,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"i8",ALLOC_STATIC);Module["_llvm_ctlz_i32"]=_llvm_ctlz_i32;function _time(ptr){var ret=Math.floor(Date.now()/1e3);if(ptr){HEAP32[ptr>>2]=ret}return ret}function ___ctype_toupper_loc(){var me=___ctype_toupper_loc;if(!me.ret){var values=[128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,-1,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,123,124,125,126,127,128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255];var i32size=4;var arr=_malloc(values.length*i32size);for(var i=0;i<values.length;i++){HEAP32[arr+i*i32size>>2]=values[i]}me.ret=allocate([arr+128*i32size],"i32*",ALLOC_NORMAL)}return me.ret}function ___cxa_guard_acquire(variable){if(!HEAP8[variable>>0]){HEAP8[variable>>0]=1;return 1}return 0}function ___ctype_tolower_loc(){var me=___ctype_tolower_loc;if(!me.ret){var values=[128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,-1,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,112,113,114,115,116,117,118,119,120,121,122,91,92,93,94,95,96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255];var i32size=4;var arr=_malloc(values.length*i32size);for(var i=0;i<values.length;i++){HEAP32[arr+i*i32size>>2]=values[i]}me.ret=allocate([arr+128*i32size],"i32*",ALLOC_NORMAL)}return me.ret}function ___cxa_begin_catch(ptr){__ZSt18uncaught_exceptionv.uncaught_exception--;___cxa_caught_exceptions.push(___cxa_last_thrown_exception);return ptr}function _llvm_eh_typeid_for(type){return type}function __ZNSt9exceptionD2Ev(){}function _catopen(name,oflag){return-1}function _copysign(a,b){return __reallyNegative(a)===__reallyNegative(b)?a:-a}function _copysignl(){return _copysign.apply(null,arguments)}var __ZTISt9exception=allocate([allocate([1,0,0,0,0,0,0],"i8",ALLOC_STATIC)+8,0],"i32",ALLOC_STATIC);var ___dso_handle=allocate(1,"i32*",ALLOC_STATIC);Module["_emscripten_replace_memory"]=_emscripten_replace_memory;FS.staticInit();__ATINIT__.unshift({func:(function(){if(!Module["noFSInit"]&&!FS.init.initialized)FS.init()})});__ATMAIN__.push({func:(function(){FS.ignorePermissions=false})});__ATEXIT__.push({func:(function(){FS.quit()})});Module["FS_createFolder"]=FS.createFolder;Module["FS_createPath"]=FS.createPath;Module["FS_createDataFile"]=FS.createDataFile;Module["FS_createPreloadedFile"]=FS.createPreloadedFile;Module["FS_createLazyFile"]=FS.createLazyFile;Module["FS_createLink"]=FS.createLink;Module["FS_createDevice"]=FS.createDevice;___errno_state=Runtime.staticAlloc(4);HEAP32[___errno_state>>2]=0;__ATINIT__.unshift({func:(function(){TTY.init()})});__ATEXIT__.push({func:(function(){TTY.shutdown()})});TTY.utf8=new Runtime.UTF8Processor;if(ENVIRONMENT_IS_NODE){var fs=require("fs");NODEFS.staticInit()}_fputc.ret=allocate([0],"i8",ALLOC_STATIC);__ATINIT__.push({func:(function(){SOCKFS.root=FS.mount(SOCKFS,{},null)})});_fgetc.ret=allocate([0],"i8",ALLOC_STATIC);Module["requestFullScreen"]=function Module_requestFullScreen(lockPointer,resizeCanvas){Browser.requestFullScreen(lockPointer,resizeCanvas)};Module["requestAnimationFrame"]=function Module_requestAnimationFrame(func){Browser.requestAnimationFrame(func)};Module["setCanvasSize"]=function Module_setCanvasSize(width,height,noUpdates){Browser.setCanvasSize(width,height,noUpdates)};Module["pauseMainLoop"]=function Module_pauseMainLoop(){Browser.mainLoop.pause()};Module["resumeMainLoop"]=function Module_resumeMainLoop(){Browser.mainLoop.resume()};Module["getUserMedia"]=function Module_getUserMedia(){Browser.getUserMedia()};STACK_BASE=STACKTOP=Runtime.alignMemory(STATICTOP);staticSealed=true;STACK_MAX=STACK_BASE+5242880;DYNAMIC_BASE=DYNAMICTOP=Runtime.alignMemory(STACK_MAX);assert(DYNAMIC_BASE<TOTAL_MEMORY,"TOTAL_MEMORY not big enough for stack");var cttz_i8=allocate([8,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,6,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,7,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,6,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0],"i8",ALLOC_DYNAMIC);var Math_min=Math.min;function invoke_iiiiiiii(index,a1,a2,a3,a4,a5,a6,a7){try{return Module["dynCall_iiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiiii(index,a1,a2,a3,a4,a5){try{Module["dynCall_viiiii"](index,a1,a2,a3,a4,a5)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_vi(index,a1){try{Module["dynCall_vi"](index,a1)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_vii(index,a1,a2){try{Module["dynCall_vii"](index,a1,a2)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iiiiiii(index,a1,a2,a3,a4,a5,a6){try{return Module["dynCall_iiiiiii"](index,a1,a2,a3,a4,a5,a6)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_ii(index,a1){try{return Module["dynCall_ii"](index,a1)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiiidiidii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10){try{Module["dynCall_viiiidiidii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iiiiiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11){try{return Module["dynCall_iiiiiiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_vidi(index,a1,a2,a3){try{Module["dynCall_vidi"](index,a1,a2,a3)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iiii(index,a1,a2,a3){try{return Module["dynCall_iiii"](index,a1,a2,a3)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiiiiiiiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15){try{Module["dynCall_viiiiiiiiiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiiiid(index,a1,a2,a3,a4,a5,a6){try{Module["dynCall_viiiiid"](index,a1,a2,a3,a4,a5,a6)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8){try{Module["dynCall_viiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiiiii(index,a1,a2,a3,a4,a5,a6){try{Module["dynCall_viiiiii"](index,a1,a2,a3,a4,a5,a6)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_di(index,a1){try{return Module["dynCall_di"](index,a1)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiiidid(index,a1,a2,a3,a4,a5,a6,a7){try{Module["dynCall_viiiidid"](index,a1,a2,a3,a4,a5,a6,a7)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_vidddd(index,a1,a2,a3,a4,a5){try{Module["dynCall_vidddd"](index,a1,a2,a3,a4,a5)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8){try{return Module["dynCall_iiiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiiiiii(index,a1,a2,a3,a4,a5,a6,a7){try{Module["dynCall_viiiiiii"](index,a1,a2,a3,a4,a5,a6,a7)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiiiiid(index,a1,a2,a3,a4,a5,a6,a7){try{Module["dynCall_viiiiiid"](index,a1,a2,a3,a4,a5,a6,a7)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9){try{Module["dynCall_viiiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10){try{Module["dynCall_viiiiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iii(index,a1,a2){try{return Module["dynCall_iii"](index,a1,a2)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iiiiii(index,a1,a2,a3,a4,a5){try{return Module["dynCall_iiiiii"](index,a1,a2,a3,a4,a5)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_diii(index,a1,a2,a3){try{return Module["dynCall_diii"](index,a1,a2,a3)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_i(index){try{return Module["dynCall_i"](index)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_diiiidiiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9){try{return Module["dynCall_diiiidiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iiiii(index,a1,a2,a3,a4){try{return Module["dynCall_iiiii"](index,a1,a2,a3,a4)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viii(index,a1,a2,a3){try{Module["dynCall_viii"](index,a1,a2,a3)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_v(index){try{Module["dynCall_v"](index)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viid(index,a1,a2,a3){try{Module["dynCall_viid"](index,a1,a2,a3)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiii(index,a1,a2,a3,a4){try{Module["dynCall_viiii"](index,a1,a2,a3,a4)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function asmPrintInt(x,y){Module.print("int "+x+","+y)}function asmPrintFloat(x,y){Module.print("float "+x+","+y)}var asm=(function(global,env,buffer) {
// EMSCRIPTEN_START_ASM
"almost asm";var a=new global.Int8Array(buffer);var b=new global.Int16Array(buffer);var c=new global.Int32Array(buffer);var d=new global.Uint8Array(buffer);var e=new global.Uint16Array(buffer);var f=new global.Uint32Array(buffer);var g=new global.Float32Array(buffer);var h=new global.Float64Array(buffer);var i=env.STACKTOP|0;var j=env.STACK_MAX|0;var k=env.tempDoublePtr|0;var l=env.ABORT|0;var m=env.cttz_i8|0;var n=env.ctlz_i8|0;var o=env.___rand_seed|0;var p=env.__ZTISt9exception|0;var q=env.___dso_handle|0;var r=env._stderr|0;var s=env._stdin|0;var t=env._stdout|0;var u=0;var v=0;var w=0;var x=0;var y=+env.NaN,z=+env.Infinity;var A=0,B=0,C=0,D=0,E=0.0,F=0,G=0,H=0,I=0.0;var J=0;var K=0;var L=0;var M=0;var N=0;var O=0;var P=0;var Q=0;var R=0;var S=0;var T=global.Math.floor;var U=global.Math.abs;var V=global.Math.sqrt;var W=global.Math.pow;var X=global.Math.cos;var Y=global.Math.sin;var Z=global.Math.tan;var _=global.Math.acos;var $=global.Math.asin;var aa=global.Math.atan;var ba=global.Math.atan2;var ca=global.Math.exp;var da=global.Math.log;var ea=global.Math.ceil;var fa=global.Math.imul;var ga=env.abort;var ha=env.assert;var ia=env.asmPrintInt;var ja=env.asmPrintFloat;var ka=env.min;var la=env.invoke_iiiiiiii;var ma=env.invoke_viiiii;var na=env.invoke_vi;var oa=env.invoke_vii;var pa=env.invoke_iiiiiii;var qa=env.invoke_ii;var ra=env.invoke_viiiidiidii;var sa=env.invoke_iiiiiiiiiiii;var ta=env.invoke_vidi;var ua=env.invoke_iiii;var va=env.invoke_viiiiiiiiiiiiiii;var wa=env.invoke_viiiiid;var xa=env.invoke_viiiiiiii;var ya=env.invoke_viiiiii;var za=env.invoke_di;var Aa=env.invoke_viiiidid;var Ba=env.invoke_vidddd;var Ca=env.invoke_iiiiiiiii;var Da=env.invoke_viiiiiii;var Ea=env.invoke_viiiiiid;var Fa=env.invoke_viiiiiiiii;var Ga=env.invoke_viiiiiiiiii;var Ha=env.invoke_iii;var Ia=env.invoke_iiiiii;var Ja=env.invoke_diii;var Ka=env.invoke_i;var La=env.invoke_diiiidiiii;var Ma=env.invoke_iiiii;var Na=env.invoke_viii;var Oa=env.invoke_v;var Pa=env.invoke_viid;var Qa=env.invoke_viiii;var Ra=env._fabs;var Sa=env._fread;var Ta=env.__ZSt9terminatev;var Ua=env.___cxa_guard_acquire;var Va=env._fmodl;var Wa=env.___assert_fail;var Xa=env.__ZSt18uncaught_exceptionv;var Ya=env.___ctype_toupper_loc;var Za=env.__addDays;var _a=env._sbrk;var $a=env.___cxa_begin_catch;var ab=env._emscripten_memcpy_big;var bb=env._sysconf;var cb=env._close;var db=env._clock;var eb=env._rewind;var fb=env._write;var gb=env.__isLeapYear;var hb=env._fsync;var ib=env.__ZNSt9exceptionD2Ev;var jb=env.___cxa_atexit;var kb=env.___cxa_does_inherit;var lb=env.___cxa_rethrow;var mb=env._catclose;var nb=env._send;var ob=env.___cxa_is_number_type;var pb=env.___cxa_free_exception;var qb=env.___cxa_find_matching_catch;var rb=env.___cxa_guard_release;var sb=env._strerror_r;var tb=env.___setErrNo;var ub=env._newlocale;var vb=env.___resumeException;var wb=env._freelocale;var xb=env.___cxa_call_unexpected;var yb=env._read;var zb=env._fwrite;var Ab=env._time;var Bb=env._fprintf;var Cb=env._catopen;var Db=env._exit;var Eb=env.___cxa_guard_abort;var Fb=env.___ctype_b_loc;var Gb=env._fmod;var Hb=env._lseek;var Ib=env._vfprintf;var Jb=env.___cxa_allocate_exception;var Kb=env._pwrite;var Lb=env._open;var Mb=env._fabsf;var Nb=env._uselocale;var Ob=env.___cxa_end_catch;var Pb=env._strftime;var Qb=env._fseek;var Rb=env._fclose;var Sb=env._pthread_cond_broadcast;var Tb=env._recv;var Ub=env._fgetc;var Vb=env._abort;var Wb=env._fopen;var Xb=env.___cxa_pure_virtual;var Yb=env._pthread_cond_wait;var Zb=env.___gxx_personality_v0;var _b=env._ungetc;var $b=env._fflush;var ac=env._strftime_l;var bc=env._pthread_mutex_lock;var cc=env.__reallyNegative;var dc=env._llvm_eh_typeid_for;var ec=env._catgets;var fc=env._fileno;var gc=env.__exit;var hc=env.__arraySum;var ic=env.___ctype_tolower_loc;var jc=env._pthread_mutex_unlock;var kc=env._pread;var lc=env._mkport;var mc=env._getc;var nc=env.___errno_location;var oc=env._copysign;var pc=env._fputc;var qc=env.___cxa_throw;var rc=env._copysignl;var sc=env._strerror;var tc=env.__formatString;var uc=env._atexit;var vc=0.0;
// EMSCRIPTEN_START_FUNCS
function ad(a){a=a|0;var b=0;b=i;i=i+a|0;i=i+7&-8;return b|0}function bd(){return i|0}function cd(a){a=a|0;i=a}function dd(a,b){a=a|0;b=b|0;if((u|0)==0){u=a;v=b}}function ed(b){b=b|0;a[k>>0]=a[b>>0];a[k+1>>0]=a[b+1>>0];a[k+2>>0]=a[b+2>>0];a[k+3>>0]=a[b+3>>0]}function fd(b){b=b|0;a[k>>0]=a[b>>0];a[k+1>>0]=a[b+1>>0];a[k+2>>0]=a[b+2>>0];a[k+3>>0]=a[b+3>>0];a[k+4>>0]=a[b+4>>0];a[k+5>>0]=a[b+5>>0];a[k+6>>0]=a[b+6>>0];a[k+7>>0]=a[b+7>>0]}function gd(a){a=a|0;J=a}function hd(){return J|0}function id(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,q=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,da=0,ea=0,fa=0,ga=0,ha=0,ia=0,ja=0,ka=0,la=0,ma=0,pa=0,ra=0,sa=0,ta=0,ua=0,va=0,wa=0,xa=0,ya=0,za=0,Aa=0,Ca=0;h=i;i=i+496|0;g=h+8|0;x=h;E=h+484|0;D=h+472|0;L=h+468|0;Q=h+456|0;F=h+452|0;H=h+440|0;S=h+436|0;R=h+424|0;C=h+420|0;V=h+408|0;G=h+404|0;K=h+392|0;z=h+252|0;W=h+248|0;I=h+244|0;U=h+240|0;P=h+236|0;B=h+232|0;T=h+488|0;n=h+92|0;w=h+80|0;o=h+68|0;s=h+56|0;v=h+44|0;y=h+24|0;j=h+12|0;c[y>>2]=d;c[y+4>>2]=e;c[y+12>>2]=8;c[y+16>>2]=b;c[y+8>>2]=e<<2;u=0;Ba(1,j|0,.800000011920929,.009999999776482582,0.0,.10000000149011612);Aa=u;u=0;if(Aa&1){l=qb(-1,-1,p|0)|0;m=J}else{a:do{if((f|0)!=0?(a[f>>0]|0)!=0:0){e=sw(f|0)|0;if(e>>>0>4294967279?(u=0,na(183,0),Aa=u,u=0,Aa&1):0){k=238;break}if(e>>>0<11){a[w>>0]=e<<1;b=w+1|0}else{d=e+16&-16;u=0;b=qa(119,d|0)|0;Aa=u;u=0;if(Aa&1){k=238;break}c[w+8>>2]=b;c[w>>2]=d|1;c[w+4>>2]=e}tw(b|0,f|0,e|0)|0;a[b+e>>0]=0;A=n+60|0;Y=n+8|0;c[n>>2]=8692;d=n+60|0;c[d>>2]=8712;c[n+4>>2]=0;f=n+60|0;u=0;oa(72,f|0,Y|0);Aa=u;u=0;do{if(!(Aa&1)){c[n+132>>2]=0;c[n+136>>2]=-1;c[n>>2]=8564;c[A>>2]=8584;c[Y>>2]=13624;b=n+12|0;ys(b);e=n+16|0;c[e+0>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;c[e+12>>2]=0;c[e+16>>2]=0;c[e+20>>2]=0;c[Y>>2]=8072;e=n+40|0;Aa=n+56|0;c[e+0>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;c[e+12>>2]=0;c[Aa>>2]=8;u=0;oa(73,Y|0,w|0);Aa=u;u=0;if(Aa&1){Z=qb(-1,-1,p|0)|0;X=J;if(!((a[e>>0]&1)==0)){Hv(c[n+48>>2]|0)}c[Y>>2]=13624;u=0;na(184,b|0);Aa=u;u=0;if(Aa&1){Aa=qb(-1,-1,0)|0;jd(Aa)}else{l=Z;m=X;k=19;break}}if(!((a[w>>0]&1)==0)){Hv(c[w+8>>2]|0)}c[o+0>>2]=0;c[o+4>>2]=0;c[o+8>>2]=0;ga=j+4|0;Bd(j,c[ga>>2]|0);ha=j+8|0;c[ha>>2]=0;ka=j+4|0;c[j>>2]=ka;c[ka>>2]=0;ka=c[r>>2]|0;ua=o+1|0;w=o+8|0;ia=s+1|0;ta=v+1|0;$=z+60|0;ca=z+8|0;da=z+60|0;sa=z+4|0;Y=z+60|0;la=z+132|0;ma=z+136|0;Z=z+12|0;pa=z+16|0;aa=z+40|0;ra=z+56|0;ba=z+8|0;A=s+8|0;X=v+8|0;_=z+48|0;ea=v+4|0;ja=s+4|0;fa=o+4|0;b:while(1){u=0;va=Ha(28,n|0,o|0)|0;Aa=u;u=0;if(Aa&1){k=35;break}xa=a[o>>0]|0;wa=(xa&1)==0;if((c[va+((c[(c[va>>2]|0)+ -12>>2]|0)+16)>>2]&5|0)!=0){k=213;break}if(wa){va=(xa&255)>>>1}else{va=c[fa>>2]|0}ya=c[w>>2]|0;if(((va|0)!=0?(N=wa?ua:ya,O=jw(N,61,va)|0,(O|0)!=0):0)?(M=O-N|0,!((M|0)==-1)):0){if(wa){va=(xa&255)>>>1;ya=ua}else{va=c[fa>>2]|0}za=va>>>0<M>>>0?va:M;if(za>>>0>4294967279){k=42;break}if(za>>>0<11){va=za<<1&255;a[s>>0]=va;Aa=ia}else{va=za+16&-16;u=0;Aa=qa(119,va|0)|0;Ca=u;u=0;if(Ca&1){k=35;break}c[A>>2]=Aa;va=va|1;c[s>>2]=va;c[ja>>2]=za;va=va&255}tw(Aa|0,ya|0,za|0)|0;a[Aa+za>>0]=0;ya=M+1|0;if(wa){xa=(xa&255)>>>1}else{xa=c[fa>>2]|0}if(xa>>>0<ya>>>0){k=52;break}wa=N+ya|0;xa=xa-ya|0;if(xa>>>0>4294967279){k=55;break}if(xa>>>0<11){a[v>>0]=xa<<1;ya=ta}else{za=xa+16&-16;u=0;ya=qa(119,za|0)|0;Ca=u;u=0;if(Ca&1){k=205;break}c[X>>2]=ya;c[v>>2]=za|1;c[ea>>2]=xa}tw(ya|0,wa|0,xa|0)|0;a[ya+xa>>0]=0;c[z>>2]=8692;c[da>>2]=8712;c[sa>>2]=0;u=0;oa(72,Y|0,ca|0);Ca=u;u=0;if(Ca&1){k=67;break}c[la>>2]=0;c[ma>>2]=-1;c[z>>2]=8564;c[$>>2]=8584;c[ca>>2]=13624;ys(Z);c[pa+0>>2]=0;c[pa+4>>2]=0;c[pa+8>>2]=0;c[pa+12>>2]=0;c[pa+16>>2]=0;c[pa+20>>2]=0;c[ca>>2]=8072;c[aa+0>>2]=0;c[aa+4>>2]=0;c[aa+8>>2]=0;c[aa+12>>2]=0;c[ra>>2]=8;u=0;oa(73,ca|0,v|0);Ca=u;u=0;if(Ca&1){k=63;break}wa=(va&1)==0;if(wa){za=(va&255)>>>1;ya=ia}else{za=c[ja>>2]|0;ya=c[A>>2]|0}xa=za>>>0>8;do{if((kw(ya,5176,xa?8:za)|0)==0){if(!(za>>>0>7&(xa^1))){k=97;break}u=0;Ha(29,z|0,W|0)|0;Ca=u;u=0;if(Ca&1){k=91;break b}va=Pf(j,G,s)|0;wa=c[va>>2]|0;if((wa|0)==0){u=0;Na(43,K|0,j|0,s|0);Ca=u;u=0;if(Ca&1){k=91;break b}wa=c[K>>2]|0;c[K>>2]=0;xa=c[G>>2]|0;c[wa>>2]=0;c[wa+4>>2]=0;c[wa+8>>2]=xa;c[va>>2]=wa;xa=c[c[j>>2]>>2]|0;if((xa|0)==0){va=wa}else{c[j>>2]=xa;va=c[va>>2]|0}ge(c[ga>>2]|0,va);c[ha>>2]=(c[ha>>2]|0)+1}va=wa+28|0;Ca=c[va>>2]|0;wa=wa+32|0;u=0;oa(c[c[Ca>>2]>>2]|0,Ca|0,wa|0);Ca=u;u=0;if(Ca&1){k=91;break b}do{if((a[2072]|0)==0){if((Ua(2072)|0)==0){break}c[516]=2088;rb(2072)}}while(0);c[va>>2]=2064;do{if((a[4520]|0)==0){if((Ua(4520)|0)==0){break}c[1128]=4536;rb(4520)}}while(0);c[va>>2]=4512;u=0;Na(c[(c[1128]|0)+4>>2]|0,4512,W|0,wa|0);Ca=u;u=0;if(Ca&1){k=91;break b}}else{k=97}}while(0);c:do{if((k|0)==97){k=0;u=0;Ha(30,z|0,I|0)|0;Ca=u;u=0;if(Ca&1){k=91;break b}if(wa){za=(va&255)>>>1;ya=ia}else{za=c[ja>>2]|0;ya=c[A>>2]|0}xa=za>>>0>9;do{if((kw(ya,320,xa?9:za)|0)==0){if(!(za>>>0>8&(xa^1))){break}va=Pf(j,C,s)|0;wa=c[va>>2]|0;if((wa|0)==0){u=0;Na(43,V|0,j|0,s|0);Ca=u;u=0;if(Ca&1){k=91;break b}wa=c[V>>2]|0;c[V>>2]=0;xa=c[C>>2]|0;c[wa>>2]=0;c[wa+4>>2]=0;c[wa+8>>2]=xa;c[va>>2]=wa;xa=c[c[j>>2]>>2]|0;if((xa|0)==0){va=wa}else{c[j>>2]=xa;va=c[va>>2]|0}ge(c[ga>>2]|0,va);c[ha>>2]=(c[ha>>2]|0)+1}c[U>>2]=c[I>>2];va=wa+28|0;Ca=c[va>>2]|0;wa=wa+32|0;u=0;oa(c[c[Ca>>2]>>2]|0,Ca|0,wa|0);Ca=u;u=0;if(Ca&1){k=91;break b}do{if((a[2072]|0)==0){if((Ua(2072)|0)==0){break}c[516]=2088;rb(2072)}}while(0);c[va>>2]=2064;do{if((a[2336]|0)==0){if((Ua(2336)|0)==0){break}c[582]=2352;rb(2336)}}while(0);c[va>>2]=2328;u=0;Na(c[(c[582]|0)+4>>2]|0,2328,U|0,wa|0);Ca=u;u=0;if(Ca&1){k=91;break b}else{break c}}}while(0);if(wa){za=(va&255)>>>1;ya=ia}else{za=c[ja>>2]|0;ya=c[A>>2]|0}xa=za>>>0>12;do{if((kw(ya,2896,xa?12:za)|0)==0){if(!(za>>>0>11&(xa^1))){break}wa=Pf(j,S,s)|0;va=c[wa>>2]|0;if((va|0)==0){u=0;Na(43,R|0,j|0,s|0);Ca=u;u=0;if(Ca&1){k=91;break b}va=c[R>>2]|0;c[R>>2]=0;xa=c[S>>2]|0;c[va>>2]=0;c[va+4>>2]=0;c[va+8>>2]=xa;c[wa>>2]=va;xa=c[c[j>>2]>>2]|0;if((xa|0)==0){wa=va}else{c[j>>2]=xa;wa=c[wa>>2]|0}ge(c[ga>>2]|0,wa);c[ha>>2]=(c[ha>>2]|0)+1}c[P>>2]=c[I>>2];wa=va+28|0;Ca=c[wa>>2]|0;va=va+32|0;u=0;oa(c[c[Ca>>2]>>2]|0,Ca|0,va|0);Ca=u;u=0;if(Ca&1){k=91;break b}do{if((a[2072]|0)==0){if((Ua(2072)|0)==0){break}c[516]=2088;rb(2072)}}while(0);c[wa>>2]=2064;do{if((a[3176]|0)==0){if((Ua(3176)|0)==0){break}c[792]=3192;rb(3176)}}while(0);c[wa>>2]=3168;u=0;Na(c[(c[792]|0)+4>>2]|0,3168,P|0,va|0);Ca=u;u=0;if(Ca&1){k=91;break b}else{break c}}}while(0);if(wa){va=(va&255)>>>1;wa=ia}else{va=c[ja>>2]|0;wa=c[A>>2]|0}xa=va>>>0>9;do{if((kw(wa,8720,xa?9:va)|0)==0){if(!(va>>>0>8&(xa^1))){break}wa=Pf(j,F,s)|0;va=c[wa>>2]|0;if((va|0)==0){u=0;Na(43,H|0,j|0,s|0);Ca=u;u=0;if(Ca&1){k=91;break b}va=c[H>>2]|0;c[H>>2]=0;xa=c[F>>2]|0;c[va>>2]=0;c[va+4>>2]=0;c[va+8>>2]=xa;c[wa>>2]=va;xa=c[c[j>>2]>>2]|0;if((xa|0)==0){wa=va}else{c[j>>2]=xa;wa=c[wa>>2]|0}ge(c[ga>>2]|0,wa);c[ha>>2]=(c[ha>>2]|0)+1}c[B>>2]=c[I>>2];wa=va+28|0;Ca=c[wa>>2]|0;va=va+32|0;u=0;oa(c[c[Ca>>2]>>2]|0,Ca|0,va|0);Ca=u;u=0;if(Ca&1){k=91;break b}do{if((a[2072]|0)==0){if((Ua(2072)|0)==0){break}c[516]=2088;rb(2072)}}while(0);c[wa>>2]=2064;do{if((a[8752]|0)==0){if((Ua(8752)|0)==0){break}c[2186]=8768;rb(8752)}}while(0);c[wa>>2]=8744;u=0;Na(c[(c[2186]|0)+4>>2]|0,8744,B|0,va|0);Ca=u;u=0;if(Ca&1){k=91;break b}else{break c}}}while(0);wa=a[v>>0]|0;va=(wa&1)==0;if(va){za=(wa&255)>>>1;ya=ta}else{za=c[ea>>2]|0;ya=c[X>>2]|0}xa=za>>>0>4;if(!((kw(ya,8736,xa?4:za)|0)==0?za>>>0>3&(xa^1):0)){k=157}do{if((k|0)==157){k=0;if(va){va=(wa&255)>>>1;wa=ta}else{va=c[ea>>2]|0;wa=c[X>>2]|0}xa=va>>>0>5;if((kw(wa,4304,xa?5:va)|0)==0?va>>>0>4&(xa^1):0){break}wa=Pf(j,E,s)|0;va=c[wa>>2]|0;if((va|0)==0){u=0;Na(43,D|0,j|0,s|0);Ca=u;u=0;if(Ca&1){k=91;break b}va=c[D>>2]|0;c[D>>2]=0;xa=c[E>>2]|0;c[va>>2]=0;c[va+4>>2]=0;c[va+8>>2]=xa;c[wa>>2]=va;xa=c[c[j>>2]>>2]|0;if((xa|0)==0){wa=va}else{c[j>>2]=xa;wa=c[wa>>2]|0}ge(c[ga>>2]|0,wa);c[ha>>2]=(c[ha>>2]|0)+1}wa=va+28|0;Ca=c[wa>>2]|0;va=va+32|0;u=0;oa(c[c[Ca>>2]>>2]|0,Ca|0,va|0);Ca=u;u=0;if(Ca&1){k=91;break b}do{if((a[2072]|0)==0){if((Ua(2072)|0)==0){break}c[516]=2088;rb(2072)}}while(0);c[wa>>2]=2064;do{if((a[3440]|0)==0){if((Ua(3440)|0)==0){break}c[858]=3456;rb(3440)}}while(0);c[wa>>2]=3432;u=0;Na(c[(c[858]|0)+4>>2]|0,3432,I|0,va|0);Ca=u;u=0;if(Ca&1){k=91;break b}else{break c}}}while(0);wa=Pf(j,L,s)|0;va=c[wa>>2]|0;if((va|0)==0){u=0;Na(43,Q|0,j|0,s|0);Ca=u;u=0;if(Ca&1){k=91;break b}va=c[Q>>2]|0;c[Q>>2]=0;xa=c[L>>2]|0;c[va>>2]=0;c[va+4>>2]=0;c[va+8>>2]=xa;c[wa>>2]=va;xa=c[c[j>>2]>>2]|0;if((xa|0)==0){wa=va}else{c[j>>2]=xa;wa=c[wa>>2]|0}ge(c[ga>>2]|0,wa);c[ha>>2]=(c[ha>>2]|0)+1}wa=a[v>>0]|0;if((wa&1)==0){wa=(wa&255)>>>1;ya=ta}else{wa=c[ea>>2]|0;ya=c[X>>2]|0}xa=wa>>>0>4;ya=kw(ya,8736,xa?4:wa)|0;if((ya|0)==0){ya=wa>>>0<4?-1:xa&1}a[T>>0]=(ya|0)==0&1;wa=va+28|0;Ca=c[wa>>2]|0;va=va+32|0;u=0;oa(c[c[Ca>>2]>>2]|0,Ca|0,va|0);Ca=u;u=0;if(Ca&1){k=91;break b}do{if((a[2072]|0)==0){if((Ua(2072)|0)==0){break}c[516]=2088;rb(2072)}}while(0);c[wa>>2]=2064;do{if((a[7336]|0)==0){if((Ua(7336)|0)==0){break}c[1832]=7352;rb(7336)}}while(0);c[wa>>2]=7328;u=0;Na(c[(c[1832]|0)+4>>2]|0,7328,T|0,va|0);Ca=u;u=0;if(Ca&1){k=91;break b}}}while(0);c[z>>2]=8564;c[da>>2]=8584;c[ba>>2]=8072;if(!((a[aa>>0]&1)==0)){Hv(c[_>>2]|0)}c[ba>>2]=13624;u=0;na(184,Z|0);Ca=u;u=0;if(Ca&1){k=196;break}u=0;na(108,Y|0);Ca=u;u=0;if(Ca&1){k=208;break}if(!((a[v>>0]&1)==0)){Hv(c[X>>2]|0)}if((a[s>>0]&1)==0){continue}Hv(c[A>>2]|0);continue}c[g>>2]=wa?ua:ya;Bb(ka|0,8520,g|0)|0}switch(k|0){case 35:{q=qb(-1,-1,p|0)|0;t=J;k=37;break};case 42:{u=0;na(183,0);Ca=u;u=0;if(Ca&1){q=qb(-1,-1,p|0)|0;t=J;k=37;break}break};case 52:{u=0;na(185,0);Ca=u;u=0;if(Ca&1){k=206}break};case 55:{u=0;na(183,0);Ca=u;u=0;if(Ca&1){k=206}break};case 63:{y=qb(-1,-1,p|0)|0;x=J;if(!((a[aa>>0]&1)==0)){Hv(c[_>>2]|0)}c[ca>>2]=13624;u=0;na(184,Z|0);Ca=u;u=0;if(Ca&1){Ca=qb(-1,-1,0)|0;jd(Ca)}else{k=69;break}break};case 67:{y=qb(-1,-1,p|0)|0;x=J;k=69;break};case 91:{x=qb(-1,-1,p|0)|0;y=J;c[z>>2]=8564;c[da>>2]=8584;c[ba>>2]=8072;if(!((a[aa>>0]&1)==0)){Hv(c[_>>2]|0)}c[ba>>2]=13624;u=0;na(184,Z|0);Ca=u;u=0;if(Ca&1){s=qb(-1,-1,0)|0;u=0;na(108,Y|0);Ca=u;u=0;if(Ca&1){Ca=qb(-1,-1,0)|0;jd(Ca)}else{Ca=s;jd(Ca)}}else{u=0;na(108,Y|0);Ca=u;u=0;if(!(Ca&1)){t=y;q=x;k=209;break}Ca=qb(-1,-1,0)|0;jd(Ca)}break};case 196:{x=qb(-1,-1,p|0)|0;y=J;u=0;na(108,Y|0);Ca=u;u=0;if(Ca&1){Ca=qb(-1,-1,0)|0;jd(Ca)}else{t=y;q=x;k=209}break};case 205:{q=qb(-1,-1,p|0)|0;t=J;k=207;break};case 208:{q=qb(-1,-1,p|0)|0;t=J;k=209;break};case 213:{if(!wa){Hv(c[w>>2]|0)}c[n>>2]=8564;c[d>>2]=8584;s=n+8|0;c[s>>2]=8072;if(!((a[e>>0]&1)==0)){Hv(c[n+48>>2]|0)}c[s>>2]=13624;u=0;na(184,b|0);Ca=u;u=0;if(!(Ca&1)){u=0;na(108,f|0);Ca=u;u=0;if(Ca&1){k=238;break a}else{k=232;break a}}s=qb(-1,-1,p|0)|0;v=J;u=0;na(108,f|0);Ca=u;u=0;if(!(Ca&1)){m=v;l=s;k=239;break a}jd(qb(-1,-1,0)|0);break}}do{if((k|0)!=37)if((k|0)==69){u=0;na(108,$|0);Ca=u;u=0;if(Ca&1){Ca=qb(-1,-1,0)|0;jd(Ca)}else{t=x;q=y;k=209;break}}else if((k|0)==206){q=qb(-1,-1,p|0)|0;t=J;k=207}}while(0);if((k|0)==207){k=211}else if((k|0)==209){if((a[v>>0]&1)==0){k=211}else{Hv(c[X>>2]|0);k=211}}if((k|0)==211){if(!((a[s>>0]&1)==0)){Hv(c[A>>2]|0)}}if(!((a[o>>0]&1)==0)){Hv(c[w>>2]|0)}c[n>>2]=8564;c[d>>2]=8584;o=n+8|0;c[o>>2]=8072;if(!((a[e>>0]&1)==0)){Hv(c[n+48>>2]|0)}c[o>>2]=13624;u=0;na(184,b|0);Ca=u;u=0;if(Ca&1){n=qb(-1,-1,0)|0;u=0;na(108,f|0);Ca=u;u=0;if(Ca&1){Ca=qb(-1,-1,0)|0;jd(Ca)}else{Ca=n;jd(Ca)}}else{u=0;na(108,f|0);Ca=u;u=0;if(!(Ca&1)){l=q;m=t;break}Ca=qb(-1,-1,0)|0;jd(Ca)}}else{l=qb(-1,-1,p|0)|0;m=J;k=19}}while(0);if((k|0)==19){u=0;na(108,A|0);Ca=u;u=0;if(Ca&1){Ca=qb(-1,-1,0)|0;jd(Ca)}if(!((a[w>>0]&1)==0)){Hv(c[w+8>>2]|0)}}k=239}else{k=232}}while(0);do{if((k|0)==232){u=0;l=qa(119,24)|0;Ca=u;u=0;if(Ca&1){k=238}else{u=0;a[g+0>>0]=a[x+0>>0]|0;Qa(17,l|0,y|0,j|0,g|0);Ca=u;u=0;if(Ca&1){Ca=qb(-1,-1,p|0)|0;m=J;Hv(l);l=Ca;break}if((a[l+8>>0]|0)==0?(Ca=c[l+4>>2]|0,u=0,na(c[(c[Ca>>2]|0)+40>>2]|0,Ca|0),Ca=u,u=0,Ca&1):0){k=238;break}Bd(j,c[j+4>>2]|0);Ca=l;i=h;return Ca|0}}}while(0);if((k|0)==238){l=qb(-1,-1,p|0)|0;m=J;k=239}Bd(j,c[j+4>>2]|0)}if((m|0)!=(dc(p|0)|0)){vb(l|0)}Aa=$a(l|0)|0;Ca=c[r>>2]|0;Aa=Bc[c[(c[Aa>>2]|0)+8>>2]&255](Aa)|0;c[g>>2]=Aa;Bb(Ca|0,8,g|0)|0;Ob();Ca=0;i=h;return Ca|0}function jd(a){a=a|0;$a(a|0)|0;Ta()}function kd(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,q=0,s=0,t=0,v=0,w=0,x=0;g=i;i=i+80|0;k=g+16|0;s=g+8|0;o=g;h=g+64|0;m=g+52|0;n=g+40|0;q=g+20|0;t=sw(f|0)|0;do{if(t>>>0>4294967279){u=0;na(183,0);w=u;u=0;if(w&1){j=26}}else{if(t>>>0<11){l=t<<1&255;a[h>>0]=l;v=h;w=h+1|0}else{l=t+16&-16;u=0;w=qa(119,l|0)|0;v=u;u=0;if(v&1){j=26;break}c[h+8>>2]=w;l=l|1;c[h>>2]=l;c[h+4>>2]=t;v=h;l=l&255}tw(w|0,f|0,t|0)|0;a[w+t>>0]=0;a:do{if((l&1)==0){c[n+0>>2]=c[v+0>>2];c[n+4>>2]=c[v+4>>2];c[n+8>>2]=c[v+8>>2];j=18}else{t=c[h+8>>2]|0;f=c[h+4>>2]|0;do{if(f>>>0>4294967279){u=0;na(183,0);w=u;u=0}else{if(f>>>0<11){a[n>>0]=f<<1;w=n+1|0}else{v=f+16&-16;u=0;w=qa(119,v|0)|0;x=u;u=0;if(x&1){break}c[n+8>>2]=w;c[n>>2]=v|1;c[n+4>>2]=f}tw(w|0,t|0,f|0)|0;a[w+f>>0]=0;j=18;break a}}while(0);m=qb(-1,-1,p|0)|0;v=J}}while(0);do{if((j|0)==18){u=0;oa(74,m|0,n|0);x=u;u=0;if(x&1){m=qb(-1,-1,p|0)|0;v=J;if((a[n>>0]&1)==0){break}Hv(c[n+8>>2]|0);break}if(!((a[n>>0]&1)==0)){Hv(c[n+8>>2]|0)}do{if((b|0)==0){u=0;n=qa(119,24)|0;x=u;u=0;if(!(x&1)){u=0;a[k+0>>0]=a[o+0>>0]|0;Na(44,n|0,m|0,k|0);x=u;u=0;if(x&1){x=qb(-1,-1,p|0)|0;v=J;Hv(n);n=x;break}if((a[n+8>>0]|0)==0?(x=c[n+4>>2]|0,u=0,na(c[(c[x>>2]|0)+40>>2]|0,x|0),x=u,u=0,x&1):0){j=30}else{j=37}}else{j=30}}else{c[q>>2]=d;c[q+4>>2]=e;c[q+12>>2]=8;c[q+16>>2]=b;c[q+8>>2]=e<<2;u=0;n=qa(119,24)|0;x=u;u=0;if(!(x&1)){u=0;a[k+0>>0]=a[s+0>>0]|0;Qa(17,n|0,q|0,m|0,k|0);x=u;u=0;if(x&1){x=qb(-1,-1,p|0)|0;v=J;Hv(n);n=x;break}if((a[n+8>>0]|0)==0?(x=c[n+4>>2]|0,u=0,na(c[(c[x>>2]|0)+40>>2]|0,x|0),x=u,u=0,x&1):0){j=30}else{j=37}}else{j=30}}}while(0);if((j|0)==30){n=qb(-1,-1,p|0)|0;v=J}else if((j|0)==37){Bd(m,c[m+4>>2]|0);if((l&1)==0){x=n;i=g;return x|0}Hv(c[h+8>>2]|0);x=n;i=g;return x|0}Bd(m,c[m+4>>2]|0);m=n}}while(0);if((l&1)==0){l=m}else{Hv(c[h+8>>2]|0);l=m}}}while(0);if((j|0)==26){l=qb(-1,-1,p|0)|0;v=J}if((v|0)!=(dc(p|0)|0)){vb(l|0)}w=$a(l|0)|0;x=c[r>>2]|0;w=Bc[c[(c[w>>2]|0)+8>>2]&255](w)|0;c[k>>2]=w;Bb(x|0,56,k|0)|0;Ob();x=0;i=g;return x|0}function ld(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0;k=i;i=i+16|0;g=k;f=k+4|0;l=sw(d|0)|0;do{if(l>>>0>4294967279){u=0;na(183,0);o=u;u=0;if(o&1){h=19}}else{if(l>>>0<11){n=l<<1&255;a[f>>0]=n;m=f;o=f+1|0}else{m=l+16&-16;u=0;o=qa(119,m|0)|0;n=u;u=0;if(n&1){h=19;break}c[f+8>>2]=o;n=m|1;c[f>>2]=n;c[f+4>>2]=l;m=f;n=n&255}tw(o|0,d|0,l|0)|0;a[o+l>>0]=0;if((n&1)==0){l=f+1|0}else{l=c[f+8>>2]|0}l=Wb(l|0,200)|0;do{if((l|0)==0){b=Jb(8)|0;u=0;oa(75,b|0,208);o=u;u=0;if(o&1){j=qb(-1,-1,p|0)|0;e=J;pb(b|0);break}c[b>>2]=288;u=0;Na(45,b|0,264,1);o=u;u=0;if(o&1){h=20}}else{o=c[b+4>>2]|0;u=0;oa(c[(c[o>>2]|0)+32>>2]|0,o|0,l|0);o=u;u=0;if(o&1){h=20}else{Rb(l|0)|0;if((a[m>>0]&1)==0){i=k;return}Hv(c[f+8>>2]|0);i=k;return}}}while(0);if((h|0)==20){j=qb(-1,-1,p|0)|0;e=J}if((a[m>>0]&1)==0){n=j;m=e}else{Hv(c[f+8>>2]|0);n=j;m=e}}}while(0);if((h|0)==19){n=qb(-1,-1,p|0)|0;m=J}if((m|0)!=(dc(p|0)|0)){vb(n|0)}n=$a(n|0)|0;o=c[r>>2]|0;n=Bc[c[(c[n>>2]|0)+8>>2]&255](n)|0;c[g>>2]=n;Bb(o|0,96,g|0)|0;Ob();i=k;return}function md(a){a=a|0;var b=0;b=i;if((a|0)==0){i=b;return}yc[c[(c[a>>2]|0)+4>>2]&255](a);i=b;return}function nd(b,d,e,f,h,j,k){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;k=k|0;var l=0,m=0,n=0,o=0,q=0,s=0;m=i;i=i+96|0;l=m;s=m+72|0;q=m+52|0;o=m+32|0;n=m+4|0;c[s>>2]=j;c[s+4>>2]=k;c[s+12>>2]=8;c[s+16>>2]=d;c[s+8>>2]=k<<2;c[q>>2]=j;c[q+4>>2]=h;c[q+12>>2]=2;c[q+16>>2]=e;d=h<<2;c[q+8>>2]=d;c[o>>2]=j;c[o+4>>2]=h;c[o+12>>2]=8;c[o+16>>2]=f;c[o+8>>2]=d;c[n>>2]=32;g[n+4>>2]=0.0;a[n+8>>0]=1;c[n+12>>2]=-1;c[n+16>>2]=2;c[n+20>>2]=1;a[n+24>>0]=0;u=0;j=pa(4,c[b+4>>2]|0,s|0,q|0,o|0,h|0,n|0)|0;d=u;u=0;if(!(d&1)){s=j;i=m;return s|0}j=qb(-1,-1,p|0)|0;s=J;if((s|0)!=(dc(p|0)|0)){vb(j|0)}q=$a(j|0)|0;s=c[r>>2]|0;q=Bc[c[(c[q>>2]|0)+8>>2]&255](q)|0;c[l>>2]=q;Bb(s|0,128,l|0)|0;Ob();s=0;i=m;return s|0}function od(a){a=a|0;var b=0;b=i;a=c[a+4>>2]|0;a=Bc[c[(c[a>>2]|0)+8>>2]&255](a)|0;i=b;return a|0}function pd(a){a=a|0;var b=0;b=i;a=c[a+4>>2]|0;a=Bc[c[(c[a>>2]|0)+12>>2]&255](a)|0;i=b;return a|0}function qd(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,q=0,s=0,t=0,v=0,w=0,x=0;d=i;i=i+192|0;f=d;s=d+176|0;e=d+164|0;g=d+152|0;k=d+16|0;o=d+4|0;x=c[b+4>>2]|0;u=0;oa(c[(c[x>>2]|0)+24>>2]|0,e|0,x|0);x=u;u=0;if(x&1){h=qb(-1,-1,p|0)|0;j=J}else{c[g+0>>2]=0;c[g+4>>2]=0;c[g+8>>2]=0;t=k+56|0;q=k+4|0;c[k>>2]=8036;n=k+56|0;c[n>>2]=8056;b=k+56|0;u=0;oa(72,b|0,q|0);x=u;u=0;a:do{if(!(x&1)){c[k+128>>2]=0;c[k+132>>2]=-1;c[k>>2]=7908;c[t>>2]=7928;c[q>>2]=13624;l=k+8|0;ys(l);m=k+12|0;c[m+0>>2]=0;c[m+4>>2]=0;c[m+8>>2]=0;c[m+12>>2]=0;c[m+16>>2]=0;c[m+20>>2]=0;c[q>>2]=8072;m=k+36|0;x=k+52|0;c[m+0>>2]=0;c[m+4>>2]=0;c[m+8>>2]=0;c[m+12>>2]=0;c[x>>2]=16;c[s+0>>2]=0;c[s+4>>2]=0;c[s+8>>2]=0;u=0;oa(73,q|0,s|0);x=u;u=0;if(x&1){w=qb(-1,-1,p|0)|0;v=J;if(!((a[s>>0]&1)==0)){Hv(c[s+8>>2]|0)}if(!((a[m>>0]&1)==0)){Hv(c[k+44>>2]|0)}c[q>>2]=13624;u=0;na(184,l|0);x=u;u=0;if(x&1){x=qb(-1,-1,0)|0;jd(x)}else{s=14;break}}if(!((a[s>>0]&1)==0)){Hv(c[s+8>>2]|0)}t=c[e>>2]|0;s=e+4|0;b:do{if((t|0)==(s|0)){s=37}else{while(1){v=t+16|0;w=a[v>>0]|0;if((w&1)==0){w=(w&255)>>>1;x=v+1|0}else{w=c[t+20>>2]|0;x=c[t+24>>2]|0}if(!((kw(x,4488,w>>>0>13?13:w)|0)==0&(w|0)==13)){u=0;v=Ha(31,k|0,v|0)|0;x=u;u=0;if(x&1){break}u=0;v=Ha(32,v|0,7880)|0;x=u;u=0;if(x&1){break}x=c[t+28>>2]|0;u=0;Na(c[(c[x>>2]|0)+28>>2]|0,x|0,v|0,t+32|0);x=u;u=0;if(x&1){break}u=0;Ha(32,v|0,7888)|0;x=u;u=0;if(x&1){break}}v=c[t+4>>2]|0;if((v|0)==0){while(1){v=c[t+8>>2]|0;if((c[v>>2]|0)==(t|0)){t=v;break}else{t=v}}}else{t=v;while(1){v=c[t>>2]|0;if((v|0)==0){break}else{t=v}}}if((t|0)==(s|0)){s=37;break b}}o=qb(-1,-1,p|0)|0;q=J;s=31}}while(0);do{if((s|0)==37){u=0;oa(76,o|0,q|0);x=u;u=0;if(x&1){o=qb(-1,-1,p|0)|0;q=J;s=31;break}u=0;Ha(33,g|0,o|0)|0;x=u;u=0;if(x&1){t=qb(-1,-1,p|0)|0;q=J;if((a[o>>0]&1)==0){o=t;break}Hv(c[o+8>>2]|0);o=t;break}if(!((a[o>>0]&1)==0)){Hv(c[o+8>>2]|0)}c[k>>2]=7908;c[n>>2]=7928;h=k+4|0;c[h>>2]=8072;if(!((a[m>>0]&1)==0)){Hv(c[k+44>>2]|0)}c[h>>2]=13624;u=0;na(184,l|0);x=u;u=0;if(x&1){h=qb(-1,-1,p|0)|0;j=J;u=0;na(108,b|0);x=u;u=0;if(!(x&1)){s=28;break a}x=qb(-1,-1,0)|0;jd(x)}u=0;na(108,b|0);x=u;u=0;if(x&1){h=qb(-1,-1,p|0)|0;j=J;s=28;break a}f=a[g>>0]|0;if((f&1)==0){x=(f&255)>>>1;f=Av(x+1|0)|0;tw(f|0,g+1|0,x|0)|0;a[f+x>>0]=0}else{w=c[g+4>>2]|0;f=Av(w+1|0)|0;x=c[g+8>>2]|0;tw(f|0,x|0,w|0)|0;a[f+w>>0]=0;Hv(x)}Bd(e,c[e+4>>2]|0);x=f;i=d;return x|0}}while(0);c[k>>2]=7908;c[n>>2]=7928;n=k+4|0;c[n>>2]=8072;if(!((a[m>>0]&1)==0)){Hv(c[k+44>>2]|0)}c[n>>2]=13624;u=0;na(184,l|0);x=u;u=0;if(x&1){k=qb(-1,-1,0)|0;u=0;na(108,b|0);x=u;u=0;if(x&1){x=qb(-1,-1,0)|0;jd(x)}else{x=k;jd(x)}}else{u=0;na(108,b|0);x=u;u=0;if(!(x&1)){h=o;j=q;break}x=qb(-1,-1,0)|0;jd(x)}}else{w=qb(-1,-1,p|0)|0;v=J;s=14}}while(0);do{if((s|0)==14){u=0;na(108,t|0);x=u;u=0;if(x&1){x=qb(-1,-1,0)|0;jd(x)}else{j=v;h=w;s=28;break}}}while(0);if(!((a[g>>0]&1)==0)){Hv(c[g+8>>2]|0)}Bd(e,c[e+4>>2]|0)}if((j|0)!=(dc(p|0)|0)){vb(h|0)}w=$a(h|0)|0;x=c[r>>2]|0;w=Bc[c[(c[w>>2]|0)+8>>2]&255](w)|0;c[f>>2]=w;Bb(x|0,160,f|0)|0;Ob();x=0;i=d;return x|0}function rd(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0,n=0,o=0;k=i;i=i+32|0;l=k;h=c[d>>2]|0;j=d+4|0;m=c[j>>2]|0;o=fa(m,h)|0;o=Gv(o>>>0>1073741823?-1:o<<2)|0;c[l>>2]=h;c[l+4>>2]=m;h=l+8|0;c[l+12>>2]=6;n=l+16|0;c[n>>2]=o;c[h>>2]=m<<2;b=Ac[c[(c[a>>2]|0)+60>>2]&7](a,b,l,e,f,g)|0;l=c[d>>2]|0;e=c[n>>2]|0;if((l|0)!=0){f=d+16|0;g=d+8|0;m=c[j>>2]|0;a=0;do{if((m|0)==0){m=0}else{l=c[f>>2]|0;n=0;do{o=e+(fa(c[h>>2]|0,a)|0)+(n<<2)|0;m=l+(fa(c[g>>2]|0,a)|0)+(n<<2)|0;c[m>>2]=c[o>>2];n=n+1|0;m=c[j>>2]|0}while(n>>>0<m>>>0);l=c[d>>2]|0}a=a+1|0}while(a>>>0<l>>>0)}if((e|0)==0){i=k;return b|0}Iv(e);i=k;return b|0}function sd(a){a=a|0;var b=0;b=i;ym(a);i=b;return}function td(a){a=a|0;var b=0;b=i;ym(a);Hv(a);i=b;return}function ud(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0;j=i;i=i+112|0;o=j+96|0;z=j+92|0;x=j+88|0;q=j+68|0;p=j+56|0;m=j+36|0;k=j+24|0;h=j+12|0;n=j+100|0;l=j;c[b>>2]=312;g=b+12|0;f=b+16|0;c[f>>2]=0;c[b+20>>2]=0;y=b+16|0;c[g>>2]=y;A=c[d>>2]|0;w=d+4|0;a:do{if((A|0)!=(w|0)){t=q+12|0;v=q+16|0;r=q+8|0;while(1){c[x>>2]=y;u=0;oa(77,q|0,A+16|0);B=u;u=0;if(B&1){h=21;break}u=0;c[o+0>>2]=c[x+0>>2];Qa(18,z|0,g|0,o|0,q|0);B=u;u=0;if(B&1){h=10;break}B=c[t>>2]|0;u=0;oa(c[c[B>>2]>>2]|0,B|0,v|0);B=u;u=0;if(B&1){h=8;break}if(!((a[q>>0]&1)==0)){Hv(c[r>>2]|0)}B=c[A+4>>2]|0;if((B|0)==0){B=A;while(1){A=c[B+8>>2]|0;if((c[A>>2]|0)==(B|0)){break}else{B=A}}}else{while(1){A=c[B>>2]|0;if((A|0)==0){A=B;break}else{B=A}}}if((A|0)==(w|0)){break a}}do{if((h|0)==8){s=qb(-1,-1)|0;if(!((a[q>>0]&1)==0)){Hv(c[r>>2]|0)}}else if((h|0)==10){h=qb(-1,-1)|0;B=c[t>>2]|0;u=0;oa(c[c[B>>2]>>2]|0,B|0,v|0);B=u;u=0;if(!(B&1)){if((a[q>>0]&1)==0){s=h;break}Hv(c[r>>2]|0);s=h;break}h=qb(-1,-1,0)|0;if((a[q>>0]&1)==0){jd(h)}Hv(c[r>>2]|0);jd(h)}else if((h|0)==21){s=qb(-1,-1)|0}}while(0);Bd(g,c[f>>2]|0);vb(s|0)}}while(0);a[p>>0]=18;s=p+1|0;q=320|0;r=s+9|0;do{a[s>>0]=a[q>>0]|0;s=s+1|0;q=q+1|0}while((s|0)<(r|0));a[p+10>>0]=0;u=0;q=Ha(34,d|0,p|0)|0;B=u;u=0;do{if(B&1){j=qb(-1,-1)|0;if(!((a[p>>0]&1)==0)){Hv(c[p+8>>2]|0)}}else{if(!((a[p>>0]&1)==0)){Hv(c[p+8>>2]|0)}p=b+8|0;a[p>>0]=0;c[m>>2]=0;c[m+4>>2]=0;c[m+8>>2]=0;c[m+12>>2]=-1;c[m+16>>2]=0;if((q|0)!=254){a[l>>0]=18;s=l+1|0;q=320|0;r=s+9|0;do{a[s>>0]=a[q>>0]|0;s=s+1|0;q=q+1|0}while((s|0)<(r|0));a[l+10>>0]=0;u=0;h=Ha(34,d|0,l|0)|0;B=u;u=0;if(B&1){j=qb(-1,-1)|0;if((a[l>>0]&1)==0){break}Hv(c[l+8>>2]|0);break}if(!((a[l>>0]&1)==0)){Hv(c[l+8>>2]|0)}u=0;h=Ma(7,h|0,m|0,d|0,e|0)|0;B=u;u=0;if(B&1){j=qb(-1,-1)|0;break}c[b+4>>2]=h;i=j;return}a[h>>0]=16;B=h+1|0;A=B;a[A>>0]=1701603686;a[A+1>>0]=6646889;a[A+2>>0]=25964;a[A+3>>0]=101;B=B+4|0;a[B>>0]=1701667182;a[B+1>>0]=6647137;a[B+2>>0]=25965;a[B+3>>0]=101;a[h+9>>0]=0;u=0;Na(46,k|0,d|0,h|0);B=u;u=0;do{if(B&1){j=qb(-1,-1)|0}else{u=0;a[o+0>>0]=a[n+0>>0]|0;l=Ma(6,0,m|0,k|0,o|0)|0;B=u;u=0;if(B&1){j=qb(-1,-1)|0;if((a[k>>0]&1)==0){break}Hv(c[k+8>>2]|0);break}c[b+4>>2]=l;if(!((a[k>>0]&1)==0)){Hv(c[k+8>>2]|0)}if(!((a[h>>0]&1)==0)){Hv(c[h+8>>2]|0)}a[p>>0]=1;i=j;return}}while(0);if(!((a[h>>0]&1)==0)){Hv(c[h+8>>2]|0)}}}while(0);Bd(g,c[f>>2]|0);vb(j|0)}function vd(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0;g=i;i=i+64|0;m=g+52|0;j=g+48|0;l=g+36|0;f=g+24|0;e=g+12|0;h=g;pf(j,b,d);j=c[j>>2]|0;if((j|0)!=(b+4|0)){e=j+28|0;o=c[e>>2]|0;o=(Bc[c[(c[o>>2]|0)+24>>2]&255](o)|0)+4|0;if((c[o>>2]|0)==2552){c[m>>2]=c[j+32>>2];o=c[e>>2]|0;o=Sc[c[(c[o>>2]|0)+16>>2]&63](o,m)|0;i=g;return c[o>>2]|0}e=Jb(8)|0;u=0;oa(75,e|0,1760);o=u;u=0;if(o&1){o=qb(-1,-1)|0;pb(e|0);vb(o|0)}else{c[e>>2]=1800;qc(e|0,1744,22)}}g=Jb(8)|0;u=0;o=qa(119,32)|0;n=u;u=0;do{if(!(n&1)){j=e+8|0;c[j>>2]=o;c[e>>2]=33;c[e+4>>2]=19;b=o+0|0;m=6288|0;n=b+19|0;do{a[b>>0]=a[m>>0]|0;b=b+1|0;m=m+1|0}while((b|0)<(n|0));a[o+19>>0]=0;u=0;Na(47,f|0,e|0,d|0);o=u;u=0;if(!(o&1)){u=0;o=qa(119,32)|0;n=u;u=0;if(!(n&1)){d=h+8|0;c[d>>2]=o;c[h>>2]=33;c[h+4>>2]=25;b=o+0|0;m=6312|0;n=b+25|0;do{a[b>>0]=a[m>>0]|0;b=b+1|0;m=m+1|0}while((b|0)<(n|0));a[o+25>>0]=0;u=0;Na(47,l|0,f|0,h|0);o=u;u=0;if(!(o&1)){u=0;oa(78,g|0,l|0);o=u;u=0;if(!(o&1)){c[g>>2]=288;u=0;Na(45,g|0,264,1);o=u;u=0;if(o&1){k=0}}else{k=1}m=qb(-1,-1)|0;if(!((a[l>>0]&1)==0)){Hv(c[l+8>>2]|0)}}else{m=qb(-1,-1)|0;k=1}if(!((a[h>>0]&1)==0)){Hv(c[d>>2]|0)}}else{m=qb(-1,-1)|0;k=1}if(!((a[f>>0]&1)==0)){Hv(c[f+8>>2]|0)}}else{m=qb(-1,-1)|0;k=1}if((a[e>>0]&1)==0){if(k){break}vb(m|0)}else{Hv(c[j>>2]|0);if(k){break}vb(m|0)}}else{m=qb(-1,-1)|0}}while(0);pb(g|0);o=m;vb(o|0);return 0}function wd(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;g=i;i=i+96|0;m=g+88|0;l=g+76|0;k=g+24|0;b=g+12|0;h=g;if((a[e>>0]&1)==0){e=e+1|0}else{e=c[e+8>>2]|0}j=Wb(e|0,7840)|0;if((j|0)==0){q=0;i=g;return q|0}Yk(k,j);if((c[k+32>>2]|0)!=8){b=Jb(8)|0;u=0;oa(75,b|0,2656);q=u;u=0;if(!(q&1)){c[b>>2]=288;qc(b|0,264,1)}q=qb(-1,-1)|0;pb(b|0);vb(q|0)}e=b+4|0;c[e>>2]=0;n=b+8|0;c[n>>2]=0;c[b>>2]=b+4;a[h>>0]=18;q=h+1|0;p=320|0;o=q+9|0;do{a[q>>0]=a[p>>0]|0;q=q+1|0;p=p+1|0}while((q|0)<(o|0));a[h+10>>0]=0;o=Pf(b,m,h)|0;p=c[o>>2]|0;if((p|0)==0){u=0;Na(43,l|0,b|0,h|0);q=u;u=0;if(q&1){l=28}else{p=c[l>>2]|0;c[l>>2]=0;l=c[m>>2]|0;c[p>>2]=0;c[p+4>>2]=0;c[p+8>>2]=l;c[o>>2]=p;l=c[c[b>>2]>>2]|0;if((l|0)==0){l=p}else{c[b>>2]=l;l=c[o>>2]|0}ge(c[e>>2]|0,l);c[n>>2]=(c[n>>2]|0)+1;l=14}}else{l=14}if((l|0)==14){k=k+36|0;m=p+28|0;q=c[m>>2]|0;n=p+32|0;u=0;oa(c[c[q>>2]>>2]|0,q|0,n|0);q=u;u=0;if(!(q&1)){if((a[2072]|0)==0?(Ua(2072)|0)!=0:0){c[516]=2088;rb(2072)}c[m>>2]=2064;if((a[2336]|0)==0?(Ua(2336)|0)!=0:0){c[582]=2352;rb(2336)}c[m>>2]=2328;u=0;Na(c[(c[582]|0)+4>>2]|0,2328,k|0,n|0);q=u;u=0;if(!(q&1)){if(!((a[h>>0]&1)==0)){Hv(c[h+8>>2]|0)}u=0;d=Ma(7,c[k>>2]|0,d|0,b|0,f|0)|0;q=u;u=0;if(!(q&1)?(eb(j|0),u=0,oa(c[(c[d>>2]|0)+28>>2]|0,d|0,j|0),q=u,u=0,!(q&1)):0){Rb(j|0)|0;Bd(b,c[e>>2]|0);q=d;i=g;return q|0}d=qb(-1,-1)|0}else{l=28}}else{l=28}}if((l|0)==28){d=qb(-1,-1)|0;if(!((a[h>>0]&1)==0)){Hv(c[h+8>>2]|0)}}Bd(b,c[e>>2]|0);q=d;vb(q|0);return 0}function xd(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0;j=i;i=i+64|0;n=j+52|0;m=j+48|0;l=j+36|0;g=j+24|0;f=j+12|0;h=j;pf(m,d,e);m=c[m>>2]|0;if((m|0)!=(d+4|0)){f=m+28|0;o=c[f>>2]|0;o=(Bc[c[(c[o>>2]|0)+24>>2]&255](o)|0)+4|0;if((c[o>>2]|0)!=7704){f=Jb(8)|0;u=0;oa(75,f|0,1760);o=u;u=0;if(o&1){o=qb(-1,-1)|0;pb(f|0);vb(o|0)}else{c[f>>2]=1800;qc(f|0,1744,22)}}c[n>>2]=c[m+32>>2];g=c[f>>2]|0;g=Sc[c[(c[g>>2]|0)+16>>2]&63](g,n)|0;if((a[g>>0]&1)==0){c[b+0>>2]=c[g+0>>2];c[b+4>>2]=c[g+4>>2];c[b+8>>2]=c[g+8>>2];i=j;return}f=c[g+8>>2]|0;g=c[g+4>>2]|0;if(g>>>0>4294967279){Mm(0)}if(g>>>0<11){a[b>>0]=g<<1;h=b+1|0}else{o=g+16&-16;h=Fv(o)|0;c[b+8>>2]=h;c[b>>2]=o|1;c[b+4>>2]=g}tw(h|0,f|0,g|0)|0;a[h+g>>0]=0;i=j;return}j=Jb(8)|0;u=0;o=qa(119,32)|0;d=u;u=0;do{if(!(d&1)){b=f+8|0;c[b>>2]=o;c[f>>2]=33;c[f+4>>2]=19;n=o+0|0;d=6288|0;m=n+19|0;do{a[n>>0]=a[d>>0]|0;n=n+1|0;d=d+1|0}while((n|0)<(m|0));a[o+19>>0]=0;u=0;Na(47,g|0,f|0,e|0);o=u;u=0;if(!(o&1)){u=0;o=qa(119,32)|0;d=u;u=0;if(!(d&1)){e=h+8|0;c[e>>2]=o;c[h>>2]=33;c[h+4>>2]=25;n=o+0|0;d=6312|0;m=n+25|0;do{a[n>>0]=a[d>>0]|0;n=n+1|0;d=d+1|0}while((n|0)<(m|0));a[o+25>>0]=0;u=0;Na(47,l|0,g|0,h|0);o=u;u=0;if(!(o&1)){u=0;oa(78,j|0,l|0);o=u;u=0;if(!(o&1)){c[j>>2]=288;u=0;Na(45,j|0,264,1);o=u;u=0;if(o&1){k=0}}else{k=1}m=qb(-1,-1)|0;if(!((a[l>>0]&1)==0)){Hv(c[l+8>>2]|0)}}else{m=qb(-1,-1)|0;k=1}if(!((a[h>>0]&1)==0)){Hv(c[e>>2]|0)}}else{m=qb(-1,-1)|0;k=1}if(!((a[g>>0]&1)==0)){Hv(c[g+8>>2]|0)}}else{m=qb(-1,-1)|0;k=1}if((a[f>>0]&1)==0){if(k){break}vb(m|0)}else{Hv(c[b>>2]|0);if(k){break}vb(m|0)}}else{m=qb(-1,-1)|0}}while(0);pb(j|0);o=m;vb(o|0)}function yd(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;f=i;i=i+208|0;g=f+202|0;h=f+200|0;o=f+176|0;p=f+152|0;q=f+128|0;k=f+96|0;n=f+72|0;s=f+48|0;r=f+24|0;m=f;a:do{switch(b|0){case 3:{c[k+0>>2]=c[d+0>>2];c[k+4>>2]=c[d+4>>2];c[k+8>>2]=c[d+8>>2];c[k+12>>2]=c[d+12>>2];c[k+16>>2]=c[d+16>>2];l=Fv(96)|0;u=0;a[g+0>>0]=a[f+201>>0]|0;Na(48,l|0,e|0,g|0);s=u;u=0;if(s&1){s=qb(-1,-1)|0;Hv(l);vb(s|0)}c[l>>2]=6864;u=0;m=qa(119,136)|0;s=u;u=0;do{if(!(s&1)){u=0;a[g+0>>0]=a[f+120>>0]|0;Qa(20,m|0,k|0,e|0,g|0);s=u;u=0;if(s&1){f=qb(-1,-1)|0;Hv(m);break}c[l+92>>2]=m;u=0;m=qa(119,140)|0;s=u;u=0;if(!(s&1)){u=0;a[g+0>>0]=a[h+0>>0]|0;Qa(21,m|0,k|0,e|0,g|0);s=u;u=0;if(s&1){f=qb(-1,-1)|0;Hv(m);break}else{c[l+88>>2]=m;break a}}else{j=22}}else{j=22}}while(0);if((j|0)==22){f=qb(-1,-1)|0}u=0;na(186,l|0);s=u;u=0;if(s&1){s=qb(-1,-1,0)|0;jd(s)}s=f;Hv(l);vb(s|0)};case 4:{c[r+0>>2]=c[d+0>>2];c[r+4>>2]=c[d+4>>2];c[r+8>>2]=c[d+8>>2];c[r+12>>2]=c[d+12>>2];c[r+16>>2]=c[d+16>>2];l=Fv(168)|0;u=0;a[g+0>>0]=a[h+0>>0]|0;Qa(19,l|0,r|0,e|0,g|0);s=u;u=0;if(s&1){s=qb(-1,-1)|0;Hv(l);vb(s|0)}else{break a}};case 1:{c[s+0>>2]=c[d+0>>2];c[s+4>>2]=c[d+4>>2];c[s+8>>2]=c[d+8>>2];c[s+12>>2]=c[d+12>>2];c[s+16>>2]=c[d+16>>2];l=Fv(136)|0;u=0;a[g+0>>0]=a[h+0>>0]|0;Qa(20,l|0,s|0,e|0,g|0);s=u;u=0;if(s&1){s=qb(-1,-1)|0;Hv(l);vb(s|0)}else{break a}};case 0:{c[m+0>>2]=c[d+0>>2];c[m+4>>2]=c[d+4>>2];c[m+8>>2]=c[d+8>>2];c[m+12>>2]=c[d+12>>2];c[m+16>>2]=c[d+16>>2];j=Fv(88)|0;u=0;a[g+0>>0]=a[h+0>>0]|0;Na(48,j|0,e|0,g|0);s=u;u=0;if(s&1){s=qb(-1,-1)|0;Hv(j);vb(s|0)}c[j>>2]=7512;u=0;oa(79,j|0,m|0);s=u;u=0;if(s&1){e=qb(-1,-1)|0;u=0;na(186,j|0);s=u;u=0;if(s&1){s=qb(-1,-1,0)|0;jd(s)}else{s=e;Hv(j);vb(s|0)}}else{l=j}break};case 2:{c[n+0>>2]=c[d+0>>2];c[n+4>>2]=c[d+4>>2];c[n+8>>2]=c[d+8>>2];c[n+12>>2]=c[d+12>>2];c[n+16>>2]=c[d+16>>2];l=Fv(140)|0;u=0;a[g+0>>0]=a[h+0>>0]|0;Qa(21,l|0,n|0,e|0,g|0);s=u;u=0;if(s&1){s=qb(-1,-1)|0;Hv(l);vb(s|0)}else{break a}};case 6:{c[o+0>>2]=c[d+0>>2];c[o+4>>2]=c[d+4>>2];c[o+8>>2]=c[d+8>>2];c[o+12>>2]=c[d+12>>2];c[o+16>>2]=c[d+16>>2];l=Fv(124)|0;u=0;a[g+0>>0]=a[h+0>>0]|0;Qa(24,l|0,o|0,e|0,g|0);s=u;u=0;if(s&1){s=qb(-1,-1)|0;Hv(l);vb(s|0)}else{break a}};case 5:{c[p+0>>2]=c[d+0>>2];c[p+4>>2]=c[d+4>>2];c[p+8>>2]=c[d+8>>2];c[p+12>>2]=c[d+12>>2];c[p+16>>2]=c[d+16>>2];l=Fv(148)|0;u=0;a[g+0>>0]=a[h+0>>0]|0;Qa(23,l|0,p|0,e|0,g|0);s=u;u=0;if(s&1){s=qb(-1,-1)|0;Hv(l);vb(s|0)}else{break a}};case 255:{c[q+0>>2]=c[d+0>>2];c[q+4>>2]=c[d+4>>2];c[q+8>>2]=c[d+8>>2];c[q+12>>2]=c[d+12>>2];c[q+16>>2]=c[d+16>>2];l=Fv(232)|0;u=0;a[g+0>>0]=a[h+0>>0]|0;Qa(22,l|0,q|0,e|0,g|0);s=u;u=0;if(s&1){s=qb(-1,-1)|0;Hv(l);vb(s|0)}else{break a}};default:{f=Jb(8)|0;u=0;oa(75,f|0,376);s=u;u=0;if(!(s&1)){c[f>>2]=288;qc(f|0,264,1)}s=qb(-1,-1)|0;pb(f|0);vb(s|0)}}}while(0);if((l|0)!=0){i=f;return l|0}f=Jb(8)|0;u=0;oa(75,f|0,400);s=u;u=0;if(!(s&1)){c[f>>2]=288;qc(f|0,264,1)}s=qb(-1,-1)|0;pb(f|0);vb(s|0);return 0}function zd(a){a=a|0;var b=0,d=0;b=i;c[a>>2]=312;d=c[a+4>>2]|0;if((d|0)!=0?(u=0,na(c[(c[d>>2]|0)+4>>2]|0,d|0),d=u,u=0,d&1):0){d=qb(-1,-1)|0;Bd(a+12|0,c[a+16>>2]|0);vb(d|0)}Bd(a+12|0,c[a+16>>2]|0);i=b;return}function Ad(a){a=a|0;var b=0,d=0;b=i;c[a>>2]=312;d=c[a+4>>2]|0;if((d|0)!=0?(u=0,na(c[(c[d>>2]|0)+4>>2]|0,d|0),d=u,u=0,d&1):0){d=qb(-1,-1)|0;Bd(a+12|0,c[a+16>>2]|0);Hv(a);vb(d|0)}Bd(a+12|0,c[a+16>>2]|0);Hv(a);i=b;return}function Bd(b,d){b=b|0;d=d|0;var e=0,f=0;e=i;if((d|0)==0){i=e;return}Bd(b,c[d>>2]|0);Bd(b,c[d+4>>2]|0);b=d+16|0;f=c[d+28>>2]|0;u=0;oa(c[c[f>>2]>>2]|0,f|0,d+32|0);f=u;u=0;if(f&1){e=qb(-1,-1)|0;if((a[b>>0]&1)==0){xb(e|0)}Hv(c[d+24>>2]|0);xb(e|0)}else{if(!((a[b>>0]&1)==0)){Hv(c[d+24>>2]|0)}Hv(d);i=e;return}}function Cd(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0;l=i;i=i+64|0;f=l+49|0;j=l+48|0;p=l+36|0;w=l+32|0;o=l+20|0;v=l+16|0;k=l+4|0;m=l;a[f+0>>0]=a[j+0>>0]|0;Dd(b,e,f);c[b>>2]=448;f=b+88|0;c[f>>2]=0;e=b+92|0;c[e>>2]=0;c[b+96>>2]=0;j=b+112|0;c[j>>2]=0;g=b+116|0;c[g>>2]=0;c[b+120>>2]=0;n=b+24|0;u=0;x=qa(119,16)|0;t=u;u=0;do{if(!(t&1)){t=p+8|0;c[t>>2]=x;c[p>>2]=17;c[p+4>>2]=12;q=x+0|0;r=528|0;s=q+12|0;do{a[q>>0]=a[r>>0]|0;q=q+1|0;r=r+1|0}while((q|0)<(s|0));a[x+12>>0]=0;c[w>>2]=12;u=0;q=ua(26,n|0,p|0,w|0)|0;x=u;u=0;if(x&1){d=qb(-1,-1)|0;if((a[p>>0]&1)==0){break}Hv(c[t>>2]|0);break}c[b+100>>2]=q;if(!((a[p>>0]&1)==0)){Hv(c[t>>2]|0)}a[o>>0]=16;q=o+1|0;x=q;a[x>>0]=1601791339;a[x+1>>0]=6256997;a[x+2>>0]=24441;a[x+3>>0]=95;q=q+4|0;a[q>>0]=1702521203;a[q+1>>0]=6650473;a[q+2>>0]=25978;a[q+3>>0]=101;a[o+9>>0]=0;c[v>>2]=20;u=0;q=ua(26,n|0,o|0,v|0)|0;x=u;u=0;if(x&1){d=qb(-1,-1)|0;if((a[o>>0]&1)==0){break}Hv(c[o+8>>2]|0);break}p=b+104|0;c[p>>2]=q;if(!((a[o>>0]&1)==0)){Hv(c[o+8>>2]|0)}u=0;t=qa(119,32)|0;x=u;u=0;if(!(x&1)){o=k+8|0;c[o>>2]=t;c[k>>2]=33;c[k+4>>2]=17;q=t+0|0;r=544|0;s=q+17|0;do{a[q>>0]=a[r>>0]|0;q=q+1|0;r=r+1|0}while((q|0)<(s|0));a[t+17>>0]=0;c[m>>2]=2;u=0;m=ua(26,n|0,k|0,m|0)|0;x=u;u=0;if(x&1){d=qb(-1,-1)|0;if((a[k>>0]&1)==0){break}Hv(c[o>>2]|0);break}h=b+108|0;c[h>>2]=m;if(!((a[k>>0]&1)==0)){Hv(c[o>>2]|0);m=c[h>>2]|0}u=0;ma(4,b|0,0,c[p>>2]|0,m|0,j|0);x=u;u=0;if(!(x&1)?(u=0,oa(79,b|0,d|0),x=u,u=0,!(x&1)):0){i=l;return}else{h=15}}else{h=15}}else{h=15}}while(0);if((h|0)==15){d=qb(-1,-1)|0}h=c[j>>2]|0;if((h|0)!=0){j=c[g>>2]|0;if((j|0)!=(h|0)){c[g>>2]=j+(~((j+ -4+(0-h)|0)>>>2)<<2)}Hv(h)}g=c[f>>2]|0;do{if((g|0)!=0){while(1){h=c[e>>2]|0;if((h|0)==(g|0)){h=30;break}x=h+ -60|0;c[e>>2]=x;u=0;na(187,x|0);x=u;u=0;if(x&1){h=29;break}}if((h|0)==29){x=qb(-1,-1)|0;xb(x|0)}else if((h|0)==30){Hv(c[f>>2]|0);break}}}while(0);u=0;na(186,b|0);x=u;u=0;if(x&1){x=qb(-1,-1,0)|0;jd(x)}else{vb(d|0)}}function Dd(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;j=i;i=i+32|0;n=j+28|0;m=j+24|0;o=j+20|0;e=j;c[b>>2]=1256;r=b+8|0;f=b+24|0;g=b+28|0;c[g>>2]=0;c[b+32>>2]=0;p=b+28|0;c[r+0>>2]=0;c[r+4>>2]=0;c[r+8>>2]=0;c[r+12>>2]=0;c[f>>2]=p;r=c[d>>2]|0;q=d+4|0;if((r|0)==(q|0)){f=b+36|0;a[f>>0]=0;f=b+40|0;f=f+0|0;e=f+48|0;do{c[f>>2]=0;f=f+4|0}while((f|0)<(e|0));i=j;return}k=e+12|0;l=e+16|0;d=e+8|0;s=r;while(1){c[o>>2]=p;u=0;oa(77,e|0,s+16|0);r=u;u=0;if(r&1){m=21;break}u=0;c[n+0>>2]=c[o+0>>2];Qa(18,m|0,f|0,n|0,e|0);r=u;u=0;if(r&1){m=10;break}r=c[k>>2]|0;u=0;oa(c[c[r>>2]>>2]|0,r|0,l|0);r=u;u=0;if(r&1){m=8;break}if(!((a[e>>0]&1)==0)){Hv(c[d>>2]|0)}r=c[s+4>>2]|0;if((r|0)==0){while(1){r=c[s+8>>2]|0;if((c[r>>2]|0)==(s|0)){break}else{s=r}}}else{while(1){s=c[r>>2]|0;if((s|0)==0){break}else{r=s}}}if((r|0)==(q|0)){m=22;break}else{s=r}}do{if((m|0)==8){h=qb(-1,-1)|0;if(!((a[e>>0]&1)==0)){Hv(c[d>>2]|0)}}else if((m|0)==10){j=qb(-1,-1)|0;s=c[k>>2]|0;u=0;oa(c[c[s>>2]>>2]|0,s|0,l|0);s=u;u=0;if(!(s&1)){if((a[e>>0]&1)==0){h=j;break}Hv(c[d>>2]|0);h=j;break}j=qb(-1,-1,0)|0;if((a[e>>0]&1)==0){jd(j)}Hv(c[d>>2]|0);jd(j)}else if((m|0)==21){h=qb(-1,-1)|0}else if((m|0)==22){f=b+36|0;a[f>>0]=0;f=b+40|0;f=f+0|0;e=f+48|0;do{c[f>>2]=0;f=f+4|0}while((f|0)<(e|0));i=j;return}}while(0);Bd(f,c[g>>2]|0);vb(h|0)}function Ed(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0;e=i;i=i+16|0;f=e+4|0;g=e;pf(g,a,b);b=c[g>>2]|0;if((b|0)==(a+4|0)){g=d;g=c[g>>2]|0;i=e;return g|0}d=b+28|0;g=c[d>>2]|0;g=(Bc[c[(c[g>>2]|0)+24>>2]&255](g)|0)+4|0;if((c[g>>2]|0)==(c[24612>>2]|0)){c[f>>2]=c[b+32>>2];g=c[d>>2]|0;g=Sc[c[(c[g>>2]|0)+16>>2]&63](g,f)|0;g=c[g>>2]|0;i=e;return g|0}e=Jb(8)|0;u=0;oa(75,e|0,1760);g=u;u=0;if(g&1){g=qb(-1,-1)|0;pb(e|0);vb(g|0)}else{c[e>>2]=1800;qc(e|0,1744,22)}return 0}function Fd(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;g=i;k=f+4|0;m=c[k>>2]|0;j=f+8|0;if((m|0)==(c[j>>2]|0)){h=c[f>>2]|0;m=m-h|0;o=m>>2;n=o+1|0;if(n>>>0>1073741823){ss(0)}if(o>>>0<536870911){q=m>>1;q=q>>>0<n>>>0?n:q;if((q|0)==0){p=0;q=0}else{l=9}}else{q=1073741823;l=9}if((l|0)==9){p=q;q=Fv(q<<2)|0}l=q+(o<<2)|0;if((l|0)!=0){c[l>>2]=b}tw(q|0,h|0,m|0)|0;c[f>>2]=q;c[k>>2]=q+(n<<2);c[j>>2]=q+(p<<2);if((h|0)!=0){Hv(h)}}else{if((m|0)!=0){c[m>>2]=b}c[k>>2]=m+4}if(!((e|0)!=0&(d|0)>0)){i=g;return}h=e+ -1|0;do{d=d+ -1|0;Fd(a,1<<d|b,d,h,f)}while((d|0)>0);i=g;return}function Gd(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0;e=i;j=c[d>>2]|0;g=b+12|0;c[g>>2]=j;c[b+20>>2]=c[d+4>>2];c[b+8>>2]=0;k=c[b+60>>2]|0;l=b+64|0;h=c[l>>2]|0;if((h|0)!=(k|0)){c[l>>2]=h+(~((h+ -4+(0-k)|0)>>>2)<<2)}h=c[b+40>>2]|0;k=(c[b+44>>2]|0)-h|0;if((k|0)>0){j=k>>2;m=0-j|0;ww(h|0,0,(((m|0)>-1?m:1073741823)+j<<2)+4|0)|0;j=c[g>>2]|0}a[b+36>>0]=0;c[b+56>>2]=0;h=b+72|0;k=b+76|0;b=c[k>>2]|0;l=c[h>>2]|0;m=b-l>>2;if(!(m>>>0<j>>>0)){if(m>>>0>j>>>0?(f=l+(j<<2)|0,(b|0)!=(f|0)):0){c[k>>2]=b+(~((b+ -4+(0-f)|0)>>>2)<<2)}}else{Ie(h,j-m|0);j=c[g>>2]|0}if((j|0)==0){i=e;return}f=d+16|0;d=c[d+8>>2]|0;g=0;do{m=(c[f>>2]|0)+(fa(d,g)|0)|0;c[(c[h>>2]|0)+(g<<2)>>2]=m;g=g+1|0}while(g>>>0<j>>>0);i=e;return}function Hd(a){a=a|0;var b=0,d=0,e=0,f=0;b=i;c[a>>2]=1256;d=c[a+84>>2]|0;if((d|0)!=0){Iv(d)}d=c[a+72>>2]|0;if((d|0)!=0){e=a+76|0;f=c[e>>2]|0;if((f|0)!=(d|0)){c[e>>2]=f+(~((f+ -4+(0-d)|0)>>>2)<<2)}Hv(d)}f=c[a+60>>2]|0;if((f|0)!=0){d=a+64|0;e=c[d>>2]|0;if((e|0)!=(f|0)){c[d>>2]=e+(~((e+ -4+(0-f)|0)>>>2)<<2)}Hv(f)}f=c[a+40>>2]|0;if((f|0)==0){e=a+24|0;f=a+28|0;f=c[f>>2]|0;Bd(e,f);i=b;return}d=a+44|0;e=c[d>>2]|0;if((e|0)!=(f|0)){c[d>>2]=e+(~((e+ -4+(0-f)|0)>>>2)<<2)}Hv(f);e=a+24|0;f=a+28|0;f=c[f>>2]|0;Bd(e,f);i=b;return}function Id(a){a=a|0;var b=0;b=i;Xf(a);i=b;return}function Jd(a){a=a|0;var b=0,c=0;b=i;u=0;na(188,a|0);c=u;u=0;if(c&1){c=qb(-1,-1)|0;Hv(a);vb(c|0)}else{Hv(a);i=b;return}}function Kd(a){a=a|0;return c[a+20>>2]|0}function Ld(a){a=a|0;return(c[a+12>>2]|0)-(c[a+56>>2]|0)|0}function Md(a){a=a|0;return 6}function Nd(a){a=a|0;return c[a+12>>2]<<2|0}function Od(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;h=i;i=i+32|0;n=h+28|0;m=h+24|0;o=h+20|0;f=h;e=b+4|0;c[e>>2]=0;c[b+8>>2]=0;l=b+4|0;c[b>>2]=l;r=c[d+24>>2]|0;p=d+28|0;if((r|0)==(p|0)){i=h;return}j=f+12|0;k=f+16|0;d=f+8|0;while(1){c[o>>2]=l;u=0;oa(77,f|0,r+16|0);q=u;u=0;if(q&1){l=21;break}u=0;c[n+0>>2]=c[o+0>>2];Qa(18,m|0,b|0,n|0,f|0);q=u;u=0;if(q&1){l=10;break}q=c[j>>2]|0;u=0;oa(c[c[q>>2]>>2]|0,q|0,k|0);q=u;u=0;if(q&1){l=8;break}if(!((a[f>>0]&1)==0)){Hv(c[d>>2]|0)}q=c[r+4>>2]|0;if((q|0)==0){while(1){q=c[r+8>>2]|0;if((c[q>>2]|0)==(r|0)){r=q;break}else{r=q}}}else{r=q;while(1){q=c[r>>2]|0;if((q|0)==0){break}else{r=q}}}if((r|0)==(p|0)){l=23;break}}do{if((l|0)==8){g=qb(-1,-1)|0;if(!((a[f>>0]&1)==0)){Hv(c[d>>2]|0)}}else if((l|0)==10){h=qb(-1,-1)|0;r=c[j>>2]|0;u=0;oa(c[c[r>>2]>>2]|0,r|0,k|0);r=u;u=0;if(!(r&1)){if((a[f>>0]&1)==0){g=h;break}Hv(c[d>>2]|0);g=h;break}h=qb(-1,-1,0)|0;if((a[f>>0]&1)==0){jd(h)}Hv(c[d>>2]|0);jd(h)}else if((l|0)==21){g=qb(-1,-1)|0}else if((l|0)==23){i=h;return}}while(0);Bd(b,c[e>>2]|0);vb(g|0)}function Pd(b,d){b=b|0;d=d|0;var e=0,f=0,g=0;f=i;i=i+16|0;g=f;e=g+4|0;c[e>>2]=d;d=g+8|0;a[d>>0]=0;u=0;oa(80,b|0,g|0);b=u;u=0;if(b&1){b=qb(-1,-1)|0;if((a[d>>0]|0)==0){vb(b|0)}Rb(c[e>>2]|0)|0;vb(b|0)}else{if((a[d>>0]|0)==0){i=f;return}Rb(c[e>>2]|0)|0;i=f;return}}function Qd(b,d){b=b|0;d=d|0;var e=0,f=0,g=0;f=i;i=i+16|0;g=f;e=g+4|0;c[e>>2]=d;d=g+8|0;a[d>>0]=0;u=0;oa(81,b|0,g|0);b=u;u=0;if(b&1){b=qb(-1,-1)|0;if((a[d>>0]|0)==0){vb(b|0)}Rb(c[e>>2]|0)|0;vb(b|0)}else{if((a[d>>0]|0)==0){i=f;return}Rb(c[e>>2]|0)|0;i=f;return}}function Rd(a){a=a|0;var b=0,c=0;c=i;b=Fv(124)|0;u=0;oa(82,b|0,a|0);a=u;u=0;if(a&1){c=qb(-1,-1)|0;Hv(b);vb(c|0)}else{i=c;return b|0}return 0}function Sd(a){a=a|0;var b=0;b=i;yc[c[(c[a>>2]|0)+68>>2]&255](a);Je(a);yc[c[(c[a>>2]|0)+72>>2]&255](a);c[a+16>>2]=c[a+12>>2];i=b;return}function Td(a,b){a=a|0;b=b|0;var d=0;d=i;Gd(a,b);yc[c[(c[a>>2]|0)+40>>2]&255](a);i=d;return}function Ud(a,b,d){a=a|0;b=b|0;d=+d;var e=0,f=0,g=0,h=0;e=i;if((c[b+4>>2]|0)!=(c[a+20>>2]|0)){Wa(1208,760,148,1232)}h=a+12|0;g=c[h>>2]|0;He(a,b);if(d>1.0?+((c[a+16>>2]|0)>>>0)*d<+((c[h>>2]|0)>>>0):0){yc[c[(c[a>>2]|0)+40>>2]&255](a);i=e;return}a=c[a+100>>2]|0;if((a|0)==0){i=e;return}if(g>>>0<(c[h>>2]|0)>>>0){ee(0,0)|0}else{f=0}do{f=f+1|0}while(f>>>0<a>>>0);i=e;return}function Vd(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;e=i;h=b+36|0;if((a[h>>0]|0)==0){l=b+60|0;g=b+12|0;q=c[g>>2]|0;j=b+64|0;o=c[j>>2]|0;m=c[l>>2]|0;n=o-m>>2;if(!(n>>>0<q>>>0)){if(n>>>0>q>>>0?(p=m+(q<<2)|0,(o|0)!=(p|0)):0){c[j>>2]=o+(~((o+ -4+(0-p)|0)>>>2)<<2)}}else{$d(l,q-n|0);q=c[g>>2]|0}if((q|0)==0){m=0}else{n=c[l>>2]|0;l=0;do{c[n+(l<<2)>>2]=l;l=l+1|0;m=c[g>>2]|0}while(l>>>0<m>>>0)}l=b+40|0;c[b+52>>2]=m;n=(m>>>5)+1|0;q=b+44|0;p=c[q>>2]|0;m=c[l>>2]|0;o=p-m>>2;if(!(o>>>0<n>>>0)){if(o>>>0>n>>>0?(k=m+(n<<2)|0,(p|0)!=(k|0)):0){p=p+(~((p+ -4+(0-k)|0)>>>2)<<2)|0;c[q>>2]=p}}else{$d(l,n-o|0);p=c[q>>2]|0;m=c[l>>2]|0}k=p-m|0;if((k|0)>0){q=k>>2;p=0-q|0;ww(m|0,0,(((p|0)>-1?p:1073741823)+q<<2)+4|0)|0}c[b+8>>2]=c[g>>2];a[h>>0]=1}else{j=b+64|0}g=c[b+60>>2]|0;k=(c[j>>2]|0)-g>>2;a:do{if((k|0)!=0?(c[g+(d<<2)>>2]|0)!=(d|0):0){h=0;do{j=(h+k|0)>>>1;l=c[g+(j<<2)>>2]|0;if((l|0)==(d|0)){d=j;break a}q=l>>>0<d>>>0;h=q?j+1|0:h;k=q?k:j}while(h>>>0<k>>>0);i=e;return}else{f=23}}while(0);if((f|0)==23){if((d|0)==-1){i=e;return}}g=(c[b+40>>2]|0)+(d>>>5<<2)|0;f=c[g>>2]|0;d=1<<(d&31);if((f&d|0)!=0){i=e;return}c[g>>2]=f|d;q=b+56|0;c[q>>2]=(c[q>>2]|0)+1;i=e;return}function Wd(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0;d=i;f=c[a+60>>2]|0;h=(c[a+64>>2]|0)-f>>2;a:do{if((h|0)!=0?(c[f+(b<<2)>>2]|0)!=(b|0):0){g=0;while(1){j=(g+h|0)>>>1;k=c[f+(j<<2)>>2]|0;if((k|0)==(b|0)){b=j;break a}k=k>>>0<b>>>0;g=k?j+1|0:g;h=k?h:j;if(!(g>>>0<h>>>0)){a=0;break}}i=d;return a|0}else{e=5}}while(0);if((e|0)==5){if((b|0)==-1){k=0;i=d;return k|0}}k=c[(c[a+72>>2]|0)+(b<<2)>>2]|0;i=d;return k|0}function Xd(b,d,e,f,h,j){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0;k=i;i=i+64|0;p=k+56|0;l=k+28|0;m=k;if((c[d+4>>2]|0)!=(c[b+20>>2]|0)){Wa(736,760,230,808)}r=c[d>>2]|0;if((c[e>>2]|0)>>>0<r>>>0){Wa(824,760,231,808)}if((c[f>>2]|0)>>>0<r>>>0){Wa(856,760,232,808)}if((c[e+4>>2]|0)>>>0<h>>>0){Wa(888,760,233,808)}if((c[f+4>>2]|0)>>>0<h>>>0){Wa(912,760,234,808)}if((c[j+16>>2]|0)==1){n=l+8|0;q=l+20|0;p=l+16|0;m=l+12|0;c[l>>2]=1136;c[l+24>>2]=h;o=l+4|0;c[q>>2]=0;c[m>>2]=p;c[p>>2]=0;g[n>>2]=3.4028234663852886e+38;a[o>>0]=0;a:do{if((r|0)>0){v=l+12|0;r=l+16|0;t=d+16|0;s=d+8|0;w=e+16|0;e=e+8|0;x=f+16|0;A=f+8|0;f=b+36|0;y=b+60|0;C=0;B=0;z=0;while(1){Be(v,C);c[q>>2]=0;c[v>>2]=p;c[p>>2]=0;g[n>>2]=3.4028234663852886e+38;a[o>>0]=0;J=(c[t>>2]|0)+(fa(c[s>>2]|0,z)|0)|0;u=0;Qa(c[(c[b>>2]|0)+64>>2]|0,b|0,l|0,J|0,j|0);J=u;u=0;if(J&1){break}D=c[q>>2]|0;C=D>>>0>h>>>0?h:D;D=(C|0)<0?D:C;J=c[m>>2]|0;if((J|0)!=(p|0)&(D|0)>0){F=fa(c[A>>2]|0,z)|0;G=fa(c[e>>2]|0,z)|0;E=c[w>>2]|0;F=(c[x>>2]|0)+F|0;G=E+G|0;H=0;while(1){c[G>>2]=c[J+20>>2];g[F>>2]=+g[J+16>>2];I=c[J+4>>2]|0;if((I|0)==0){while(1){I=c[J+8>>2]|0;if((c[I>>2]|0)==(J|0)){break}else{J=I}}}else{while(1){J=c[I>>2]|0;if((J|0)==0){break}else{I=J}}}H=H+1|0;if(!((I|0)!=(p|0)&(H|0)<(D|0))){break}else{F=F+4|0;G=G+4|0;J=I}}}else{E=c[w>>2]|0}F=E+(fa(c[e>>2]|0,z)|0)|0;if(!((a[f>>0]|0)==0|(C|0)==0)){E=c[y>>2]|0;D=0;do{J=F+(D<<2)|0;c[J>>2]=c[E+(c[J>>2]<<2)>>2];D=D+1|0}while((D|0)!=(C|0))}B=C+B|0;z=z+1|0;C=c[r>>2]|0;if((z|0)>=(c[d>>2]|0)){break a}}J=qb(-1,-1)|0;c[l>>2]=1056;Be(l+12|0,c[r>>2]|0);vb(J|0)}else{C=0;B=0}}while(0);c[l>>2]=1056;Be(l+12|0,C);J=B;i=k;return J|0}c[m>>2]=944;o=m+4|0;c[o>>2]=h;q=m+16|0;c[q>>2]=0;l=m+20|0;c[l>>2]=0;c[m+24>>2]=0;g[p>>2]=3.4028234663852886e+38;c[p+4>>2]=-1;do{if((h|0)==0){z=0;q=-1;B=0}else{u=0;Na(49,q|0,h|0,p|0);J=u;u=0;if(!(J&1)){B=c[o>>2]|0;z=c[m+16>>2]|0;q=B+ -1|0;r=c[d>>2]|0;break}k=qb(-1,-1)|0;d=c[q>>2]|0;if((d|0)==0){vb(k|0)}h=c[l>>2]|0;if((h|0)!=(d|0)){c[l>>2]=h+(~((h+ -8+(0-d)|0)>>>3)<<3)}Hv(d);vb(k|0)}}while(0);p=m+12|0;g[p>>2]=3.4028234663852886e+38;g[z+(q<<3)>>2]=3.4028234663852886e+38;q=m+8|0;c[q>>2]=0;do{if((r|0)>0){r=m+16|0;t=d+16|0;v=d+8|0;s=e+16|0;x=e+8|0;y=b+36|0;e=b+60|0;w=f+8|0;f=f+16|0;C=z;z=0;A=0;while(1){g[p>>2]=3.4028234663852886e+38;g[C+(B+ -1<<3)>>2]=3.4028234663852886e+38;c[q>>2]=0;J=(c[t>>2]|0)+(fa(c[v>>2]|0,A)|0)|0;u=0;Qa(c[(c[b>>2]|0)+64>>2]|0,b|0,m|0,J|0,j|0);J=u;u=0;if(J&1){break}F=c[q>>2]|0;B=F>>>0>h>>>0?h:F;C=(B|0)==0;if(!C){H=fa(c[w>>2]|0,A)|0;I=fa(c[x>>2]|0,A)|0;D=c[s>>2]|0;E=c[r>>2]|0;F=~F;G=~B;G=~(F>>>0>G>>>0?F:G);F=(c[f>>2]|0)+H|0;I=D+I|0;H=0;while(1){c[I>>2]=c[E+(H<<3)+4>>2];g[F>>2]=+g[E+(H<<3)>>2];H=H+1|0;if((H|0)==(G|0)){break}else{F=F+4|0;I=I+4|0}}D=D+(fa(c[x>>2]|0,A)|0)|0;if(!((a[y>>0]|0)==0|C)){E=c[e>>2]|0;C=0;do{J=D+(C<<2)|0;c[J>>2]=c[E+(c[J>>2]<<2)>>2];C=C+1|0}while((C|0)!=(B|0))}}z=B+z|0;A=A+1|0;if((A|0)>=(c[d>>2]|0)){n=52;break}B=c[o>>2]|0;C=c[r>>2]|0}if((n|0)==52){d=c[r>>2]|0;break}k=qb(-1,-1)|0;c[m>>2]=944;d=c[r>>2]|0;if((d|0)==0){J=k;vb(J|0)}h=c[l>>2]|0;if((h|0)!=(d|0)){c[l>>2]=h+(~((h+ -8+(0-d)|0)>>>3)<<3)}Hv(d);J=k;vb(J|0)}else{d=z;z=0}}while(0);c[m>>2]=944;if((d|0)==0){J=z;i=k;return J|0}h=c[l>>2]|0;if((h|0)!=(d|0)){c[l>>2]=h+(~((h+ -8+(0-d)|0)>>>3)<<3)}Hv(d);J=z;i=k;return J|0}function Yd(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;if((c[a+88>>2]|0)==(c[a+92>>2]|0)){return}else{ee(0,0)|0}}function Zd(a){a=a|0;return}function _d(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;f=i;i=i+64|0;d=f;m=a+88|0;e=a+100|0;p=c[e>>2]|0;k=a+92|0;n=c[k>>2]|0;q=c[m>>2]|0;o=(n-q|0)/60|0;a:do{if(!(o>>>0<p>>>0)){if(o>>>0>p>>>0?(l=q+(p*60|0)|0,(n|0)!=(l|0)):0){while(1){s=n+ -60|0;c[k>>2]=s;u=0;na(187,s|0);s=u;u=0;if(s&1){break}n=c[k>>2]|0;if((n|0)==(l|0)){break a}}s=qb(-1,-1)|0;xb(s|0)}}else{ne(m,p-o|0)}}while(0);k=a+76|0;l=c[k>>2]|0;a=a+72|0;n=c[a>>2]|0;o=l-n|0;m=o>>2;do{if((m|0)==0){o=0;p=0}else{u=0;p=qa(119,o<<1|0)|0;s=u;u=0;if(!(s&1)){o=p+(m<<3)|0;break}s=qb(-1,-1)|0;vb(s|0)}}while(0);b:do{if((l|0)!=(n|0)){m=p;l=0;while(1){n=c[n+(l<<2)>>2]|0;if((p|0)==(o|0)){o=p-m|0;r=o>>3;p=r+1|0;if(p>>>0>536870911){break}if(r>>>0<268435455){s=o>>2;s=s>>>0<p>>>0?p:s;if((s|0)==0){s=0;q=0}else{b=22}}else{s=536870911;b=22}if((b|0)==22){b=0;u=0;q=qa(119,s<<3|0)|0;t=u;u=0;if(t&1){b=35;break}}r=q+(r<<3)|0;s=q+(s<<3)|0;if((r|0)!=0){t=r;c[t>>2]=l;c[t+4>>2]=n}n=q+(p<<3)|0;tw(q|0,m|0,o|0)|0;if((m|0)==0){o=s;m=q;p=n}else{Hv(m);o=s;m=q;p=n}}else{if((p|0)==0){p=0}else{t=p;c[t>>2]=l;c[t+4>>2]=n}p=p+8|0}l=l+1|0;n=c[a>>2]|0;if(!(l>>>0<(c[k>>2]|0)-n>>2>>>0)){j=m;b=29;break b}}if((b|0)==35){g=qb(-1,-1)|0;j=m;break}u=0;na(189,0);t=u;u=0;if(t&1){j=m;b=36}}else{j=p;b=29}}while(0);do{if((b|0)==29){if((c[e>>2]|0)!=0?(u=0,Na(50,d|0,0,0),t=u,u=0,t&1):0){b=36;break}if((j|0)==0){i=f;return}Hv(j);i=f;return}}while(0);if((b|0)==36){g=qb(-1,-1)|0}if((j|0)==0){t=g;vb(t|0)}Hv(j);t=g;vb(t|0)}function $d(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0;e=i;f=a+8|0;d=a+4|0;g=c[d>>2]|0;m=c[f>>2]|0;j=g;if(!(m-j>>2>>>0<b>>>0)){f=b;a=g;while(1){if((a|0)!=0){c[a>>2]=0}f=f+ -1|0;if((f|0)==0){break}else{a=a+4|0}}c[d>>2]=g+(b<<2);i=e;return}g=c[a>>2]|0;n=g;j=j-n|0;l=j>>2;k=l+b|0;if(k>>>0>1073741823){ss(0)}m=m-n|0;if(m>>2>>>0<536870911){n=m>>1;n=n>>>0<k>>>0?k:n;if((n|0)==0){m=0;n=0}else{h=10}}else{n=1073741823;h=10}if((h|0)==10){m=n;n=Fv(n<<2)|0}h=n+(l<<2)|0;while(1){if((h|0)!=0){c[h>>2]=0}b=b+ -1|0;if((b|0)==0){break}else{h=h+4|0}}tw(n|0,g|0,j|0)|0;c[a>>2]=n;c[d>>2]=n+(k<<2);c[f>>2]=n+(m<<2);if((g|0)==0){i=e;return}Hv(g);i=e;return}function ae(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;d=i;if((b|0)==0){i=d;return}ae(a,c[b>>2]|0);ae(a,c[b+4>>2]|0);a=c[b+20>>2]|0;if((a|0)!=0){e=b+24|0;f=c[e>>2]|0;if((f|0)!=(a|0)){c[e>>2]=f+(~((f+ -4+(0-a)|0)>>>2)<<2)}Hv(a)}Hv(b);i=d;return}function be(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0;e=i;f=b;h=d-f>>2;g=a+8|0;m=c[g>>2]|0;k=c[a>>2]|0;l=k;if(!(h>>>0>m-l>>2>>>0)){g=a+4|0;j=(c[g>>2]|0)-l|0;a=j>>2;if(!(h>>>0>a>>>0)){d=d-f|0;vw(k|0,b|0,d|0)|0;b=k+(d>>2<<2)|0;d=c[g>>2]|0;if((d|0)==(b|0)){i=e;return}c[g>>2]=d+(~((d+ -4+(0-b)|0)>>>2)<<2);i=e;return}f=b+(a<<2)|0;vw(k|0,b|0,j|0)|0;if((f|0)==(d|0)){i=e;return}h=c[g>>2]|0;b=(d+ -4+(0-f)|0)>>>2;j=h;while(1){if((j|0)!=0){c[j>>2]=c[f>>2]}f=f+4|0;if((f|0)==(d|0)){break}else{j=j+4|0}}c[g>>2]=h+(b+1<<2);i=e;return}if((k|0)!=0){n=a+4|0;m=c[n>>2]|0;if((m|0)!=(k|0)){c[n>>2]=m+(~((m+ -4+(0-l)|0)>>>2)<<2)}Hv(k);c[g>>2]=0;c[n>>2]=0;c[a>>2]=0;m=0}if(h>>>0>1073741823){ss(0)}if(m>>2>>>0<536870911){n=m>>1;h=n>>>0<h>>>0?h:n;if(h>>>0>1073741823){ss(0)}else{j=h}}else{j=1073741823}k=Fv(j<<2)|0;h=a+4|0;c[h>>2]=k;c[a>>2]=k;c[g>>2]=k+(j<<2);if((b|0)==(d|0)){i=e;return}f=(d+ -4+(0-f)|0)>>>2;g=k;while(1){if((g|0)!=0){c[g>>2]=c[b>>2]}b=b+4|0;if((b|0)==(d|0)){break}else{g=g+4|0}}c[h>>2]=k+(f+1<<2);i=e;return}function ce(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0;d=i;f=a+8|0;e=a+4|0;k=c[e>>2]|0;h=c[f>>2]|0;j=k;if(!(((h-j|0)/12|0)>>>0<b>>>0)){do{if((k|0)==0){f=0}else{c[k>>2]=0;c[k+4>>2]=0;c[k+8>>2]=0;f=c[e>>2]|0}k=f+12|0;c[e>>2]=k;b=b+ -1|0}while((b|0)!=0);i=d;return}l=c[a>>2]|0;j=(j-l|0)/12|0;k=j+b|0;if(k>>>0>357913941){ss(0)}h=(h-l|0)/12|0;if(h>>>0<178956970){h=h<<1;h=h>>>0<k>>>0?k:h;if((h|0)==0){k=0;h=0}else{g=9}}else{h=357913941;g=9}if((g|0)==9){k=h;h=Fv(h*12|0)|0}j=h+(j*12|0)|0;l=b;b=j;do{if((b|0)==0){b=0}else{c[b>>2]=0;c[b+4>>2]=0;c[b+8>>2]=0}b=b+12|0;l=l+ -1|0}while((l|0)!=0);k=h+(k*12|0)|0;m=c[a>>2]|0;n=c[e>>2]|0;a:do{if((n|0)==(m|0)){c[a>>2]=j;c[e>>2]=b;c[f>>2]=k;g=m}else{while(1){l=j+ -12|0;n=n+ -12|0;u=0;oa(83,l|0,n|0);o=u;u=0;if(o&1){break}if((n|0)==(m|0)){g=18;break}else{j=l}}if((g|0)==18){g=c[a>>2]|0;h=c[e>>2]|0;c[a>>2]=l;c[e>>2]=b;c[f>>2]=k;if((h|0)==(g|0)){break}while(1){f=h;h=h+ -12|0;e=c[h>>2]|0;if((e|0)!=0){f=f+ -8|0;a=c[f>>2]|0;if((a|0)!=(e|0)){c[f>>2]=a+(~((a+ -4+(0-e)|0)>>>2)<<2)}Hv(e)}if((h|0)==(g|0)){break a}}}d=qb(-1,-1)|0;if((b|0)!=(j|0)){do{f=b;b=b+ -12|0;e=c[b>>2]|0;if((e|0)!=0){f=f+ -8|0;a=c[f>>2]|0;if((a|0)!=(e|0)){c[f>>2]=a+(~((a+ -4+(0-e)|0)>>>2)<<2)}Hv(e)}}while((b|0)!=(j|0))}if((h|0)==0){vb(d|0)}Hv(h);vb(d|0)}}while(0);if((g|0)==0){i=d;return}Hv(g);i=d;return}function de(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0;e=i;c[a>>2]=0;d=a+4|0;c[d>>2]=0;h=a+8|0;c[h>>2]=0;g=b+4|0;f=(c[g>>2]|0)-(c[b>>2]|0)|0;j=f>>2;if((j|0)==0){i=e;return}if(j>>>0>1073741823){u=0;na(189,0);j=u;u=0}else{u=0;f=qa(119,f|0)|0;k=u;u=0;if(!(k&1)){c[d>>2]=f;c[a>>2]=f;c[h>>2]=f+(j<<2);h=c[b>>2]|0;a=c[g>>2]|0;if((h|0)==(a|0)){i=e;return}g=(a+ -4+(0-h)|0)>>>2;b=f;while(1){if((b|0)!=0){c[b>>2]=c[h>>2]}h=h+4|0;if((h|0)==(a|0)){break}else{b=b+4|0}}c[d>>2]=f+(g+1<<2);i=e;return}}e=qb(-1,-1)|0;f=c[a>>2]|0;if((f|0)==0){vb(e|0)}a=c[d>>2]|0;if((a|0)!=(f|0)){c[d>>2]=a+(~((a+ -4+(0-f)|0)>>>2)<<2)}Hv(f);vb(e|0)}function ee(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;a=i;i=i+16|0;b=he(11728,696)|0;ln(a,b+(c[(c[b>>2]|0)+ -12>>2]|0)|0);u=0;e=Ha(35,a|0,16352)|0;f=u;u=0;if(!(f&1)?(u=0,d=Ha(c[(c[e>>2]|0)+28>>2]|0,e|0,10)|0,f=u,u=0,!(f&1)):0){As(a);lo(b,d)|0;Un(b)|0;lb()}d=qb(-1,-1)|0;u=0;na(184,a|0);f=u;u=0;if(f&1){f=qb(-1,-1,0)|0;jd(f)}else{vb(d|0)}return 0}function fe(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0;e=i;i=i+16|0;g=e;d=a+4|0;f=c[d>>2]|0;do{if((f|0)!=0){h=c[b>>2]|0;while(1){j=c[f+16>>2]|0;if(h>>>0<j>>>0){j=c[f>>2]|0;if((j|0)==0){h=5;break}else{f=j;continue}}if(!(j>>>0<h>>>0)){h=9;break}j=f+4|0;k=c[j>>2]|0;if((k|0)==0){h=8;break}else{f=k}}if((h|0)==5){c[g>>2]=f;g=f;break}else if((h|0)==8){c[g>>2]=f;g=j;break}else if((h|0)==9){c[g>>2]=f;break}}else{f=a+4|0;c[g>>2]=f;g=f}}while(0);h=c[g>>2]|0;if((h|0)!=0){k=h;k=k+20|0;i=e;return k|0}h=Fv(32)|0;c[h+16>>2]=c[b>>2];c[h+20>>2]=0;c[h+24>>2]=0;c[h+28>>2]=0;c[h>>2]=0;c[h+4>>2]=0;c[h+8>>2]=f;c[g>>2]=h;b=c[c[a>>2]>>2]|0;if((b|0)==0){b=h}else{c[a>>2]=b;b=c[g>>2]|0}ge(c[d>>2]|0,b);k=a+8|0;c[k>>2]=(c[k>>2]|0)+1;k=h;k=k+20|0;i=e;return k|0}function ge(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0;e=i;l=(d|0)==(b|0);a[d+12>>0]=l&1;if(l){i=e;return}while(1){j=d+8|0;f=c[j>>2]|0;k=f+12|0;if((a[k>>0]|0)!=0){b=37;break}g=f+8|0;h=c[g>>2]|0;l=c[h>>2]|0;if((l|0)==(f|0)){j=c[h+4>>2]|0;if((j|0)==0){b=7;break}j=j+12|0;if((a[j>>0]|0)!=0){b=7;break}a[k>>0]=1;a[h+12>>0]=(h|0)==(b|0)&1;a[j>>0]=1}else{if((l|0)==0){b=24;break}l=l+12|0;if((a[l>>0]|0)!=0){b=24;break}a[k>>0]=1;a[h+12>>0]=(h|0)==(b|0)&1;a[l>>0]=1}if((h|0)==(b|0)){b=37;break}else{d=h}}if((b|0)==7){if((c[f>>2]|0)==(d|0)){d=f}else{l=f+4|0;d=c[l>>2]|0;j=c[d>>2]|0;c[l>>2]=j;if((j|0)!=0){c[j+8>>2]=f;h=c[g>>2]|0}j=d+8|0;c[j>>2]=h;h=c[g>>2]|0;if((c[h>>2]|0)==(f|0)){c[h>>2]=d}else{c[h+4>>2]=d}c[d>>2]=f;c[g>>2]=d;f=c[j>>2]|0;h=f;f=c[f>>2]|0}a[d+12>>0]=1;a[h+12>>0]=0;g=f+4|0;d=c[g>>2]|0;c[h>>2]=d;if((d|0)!=0){c[d+8>>2]=h}d=h+8|0;c[f+8>>2]=c[d>>2];j=c[d>>2]|0;if((c[j>>2]|0)==(h|0)){c[j>>2]=f}else{c[j+4>>2]=f}c[g>>2]=h;c[d>>2]=f;i=e;return}else if((b|0)==24){if((c[f>>2]|0)==(d|0)){b=d+4|0;k=c[b>>2]|0;c[f>>2]=k;if((k|0)!=0){c[k+8>>2]=f;h=c[g>>2]|0}c[j>>2]=h;h=c[g>>2]|0;if((c[h>>2]|0)==(f|0)){c[h>>2]=d}else{c[h+4>>2]=d}c[b>>2]=f;c[g>>2]=d;f=d;h=c[j>>2]|0}a[f+12>>0]=1;a[h+12>>0]=0;l=h+4|0;f=c[l>>2]|0;g=c[f>>2]|0;c[l>>2]=g;if((g|0)!=0){c[g+8>>2]=h}g=h+8|0;c[f+8>>2]=c[g>>2];d=c[g>>2]|0;if((c[d>>2]|0)==(h|0)){c[d>>2]=f}else{c[d+4>>2]=f}c[f>>2]=h;c[g>>2]=f;i=e;return}else if((b|0)==37){i=e;return}}function he(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;j=i;i=i+32|0;h=j+16|0;e=j+8|0;l=j+4|0;k=j;a[e>>0]=0;c[e+4>>2]=b;r=c[(c[b>>2]|0)+ -12>>2]|0;do{if((c[b+(r+16)>>2]|0)==0){o=c[b+(r+72)>>2]|0;if((o|0)!=0){u=0;qa(120,o|0)|0;s=u;u=0;if(s&1){g=19;break}r=c[(c[b>>2]|0)+ -12>>2]|0}a[e>>0]=1;o=sw(d|0)|0;c[l>>2]=c[b+(r+24)>>2];if((c[b+(r+4)>>2]&176|0)==32){p=d+o|0}else{p=d}q=b+r|0;r=b+(r+76)|0;s=c[r>>2]|0;do{if((s|0)==-1){u=0;oa(84,h|0,q|0);s=u;u=0;if(!(s&1)){u=0;s=Ha(35,h|0,16352)|0;t=u;u=0;if(!(t&1)?(u=0,n=Ha(c[(c[s>>2]|0)+28>>2]|0,s|0,32)|0,t=u,u=0,!(t&1)):0){u=0;na(184,h|0);t=u;u=0;if(t&1){g=20;break}s=n<<24>>24;c[r>>2]=s;g=16;break}k=qb(-1,-1,0)|0;u=0;na(184,h|0);t=u;u=0;if(t&1){t=qb(-1,-1,0)|0;jd(t)}else{m=k}}else{g=20}}else{g=16}}while(0);if((g|0)==16){t=s&255;s=d+o|0;u=0;c[h+0>>2]=c[l+0>>2];Da(39,k|0,h|0,d|0,p|0,s|0,q|0,t|0);t=u;u=0;if(!(t&1)){if((c[k>>2]|0)!=0){g=22;break}t=c[(c[b>>2]|0)+ -12>>2]|0;u=0;oa(85,b+t|0,c[b+(t+16)>>2]|5|0);t=u;u=0;if(!(t&1)){g=22;break}else{g=20}}else{g=20}}if((g|0)==20){m=qb(-1,-1,0)|0}u=0;na(190,e|0);t=u;u=0;if(t&1){t=qb(-1,-1,0)|0;jd(t)}else{f=m}}else{g=22}}while(0);if((g|0)==22){u=0;na(190,e|0);t=u;u=0;if(t&1){g=19}else{i=j;return b|0}}if((g|0)==19){f=qb(-1,-1,0)|0}$a(f|0)|0;u=0;na(191,b+(c[(c[b>>2]|0)+ -12>>2]|0)|0);t=u;u=0;if(!(t&1)){Ob();i=j;return b|0}b=qb(-1,-1)|0;u=0;Oa(2);t=u;u=0;if(t&1){t=qb(-1,-1,0)|0;jd(t)}else{vb(b|0)}return 0}function ie(b,d,e,f,g,h,j){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0;m=i;i=i+16|0;k=m;l=c[d>>2]|0;if((l|0)==0){c[b>>2]=0;i=m;return}p=e;n=g-p|0;h=h+12|0;o=c[h>>2]|0;n=(o|0)>(n|0)?o-n|0:0;o=f;p=o-p|0;if((p|0)>0?(Fc[c[(c[l>>2]|0)+48>>2]&63](l,e,p)|0)!=(p|0):0){c[d>>2]=0;c[b>>2]=0;i=m;return}do{if((n|0)>0){if(n>>>0<11){p=n<<1&255;a[k>>0]=p;e=k;q=k+1|0}else{p=n+16&-16;q=Fv(p)|0;c[k+8>>2]=q;p=p|1;c[k>>2]=p;c[k+4>>2]=n;e=k;p=p&255}ww(q|0,j|0,n|0)|0;a[q+n>>0]=0;if((p&1)==0){j=k+1|0}else{j=c[k+8>>2]|0}u=0;j=ua(c[(c[l>>2]|0)+48>>2]|0,l|0,j|0,n|0)|0;q=u;u=0;if(q&1){b=qb(-1,-1)|0;if((a[e>>0]&1)==0){vb(b|0)}Hv(c[k+8>>2]|0);vb(b|0)}if((j|0)==(n|0)){if((a[e>>0]&1)==0){break}Hv(c[k+8>>2]|0);break}c[d>>2]=0;c[b>>2]=0;if((a[e>>0]&1)==0){i=m;return}Hv(c[k+8>>2]|0);i=m;return}}while(0);k=g-o|0;if((k|0)>0?(Fc[c[(c[l>>2]|0)+48>>2]&63](l,f,k)|0)!=(k|0):0){c[d>>2]=0;c[b>>2]=0;i=m;return}c[h>>2]=0;c[b>>2]=l;i=m;return}function je(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0;b=i;d=c[a+48>>2]|0;if((d|0)!=0){f=a+52|0;e=c[f>>2]|0;if((e|0)!=(d|0)){c[f>>2]=e+(~((e+ -4+(0-d)|0)>>>2)<<2)}Hv(d)}d=c[a+28>>2]|0;if((d|0)!=0){e=a+32|0;f=c[e>>2]|0;if((f|0)!=(d|0)){c[e>>2]=f+(~((f+ -4+(0-d)|0)>>>2)<<2)}Hv(d)}ae(a+12|0,c[a+16>>2]|0);e=c[a>>2]|0;if((e|0)==0){i=b;return}d=a+4|0;g=c[d>>2]|0;if((g|0)!=(e|0)){do{h=g+ -12|0;c[d>>2]=h;f=c[h>>2]|0;if((f|0)==0){g=h}else{h=g+ -8|0;g=c[h>>2]|0;if((g|0)!=(f|0)){c[h>>2]=g+(~((g+ -4+(0-f)|0)>>>2)<<2)}Hv(f);g=c[d>>2]|0}}while((g|0)!=(e|0));e=c[a>>2]|0}Hv(e);i=b;return}function ke(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;l=i;i=i+16|0;c[a>>2]=0;b=a+4|0;c[b>>2]=0;c[a+8>>2]=0;d=a+12|0;f=a+16|0;c[f>>2]=0;c[a+20>>2]=0;c[d>>2]=a+16;g=a+28|0;c[g+0>>2]=0;c[g+4>>2]=0;c[g+8>>2]=0;c[g+12>>2]=0;m=a+48|0;c[m>>2]=0;h=a+52|0;c[h>>2]=0;c[a+56>>2]=0;u=0;o=Ha(32,11728,696)|0;n=u;u=0;do{if(!(n&1)?(u=0,oa(84,l|0,o+(c[(c[o>>2]|0)+ -12>>2]|0)|0),n=u,u=0,!(n&1)):0){u=0;n=Ha(35,l|0,16352)|0;p=u;u=0;if(!(p&1)?(u=0,k=Ha(c[(c[n>>2]|0)+28>>2]|0,n|0,10)|0,p=u,u=0,!(p&1)):0){u=0;na(184,l|0);p=u;u=0;if(p&1){j=11;break}u=0;Ha(36,o|0,k|0)|0;p=u;u=0;if(p&1){j=11;break}u=0;qa(120,o|0)|0;p=u;u=0;if(p&1){j=11;break}u=0;Oa(3);p=u;u=0;if(p&1){j=11;break}}k=qb(-1,-1)|0;u=0;na(184,l|0);p=u;u=0;if(p&1){p=qb(-1,-1,0)|0;jd(p)}else{e=k}}else{j=11}}while(0);if((j|0)==11){e=qb(-1,-1)|0}k=c[m>>2]|0;if((k|0)!=0){j=c[h>>2]|0;if((j|0)!=(k|0)){c[h>>2]=j+(~((j+ -4+(0-k)|0)>>>2)<<2)}Hv(k)}g=c[g>>2]|0;if((g|0)!=0){h=a+32|0;j=c[h>>2]|0;if((j|0)!=(g|0)){c[h>>2]=j+(~((j+ -4+(0-g)|0)>>>2)<<2)}Hv(g)}ae(d,c[f>>2]|0);d=c[a>>2]|0;if((d|0)==0){vb(e|0)}g=c[b>>2]|0;if((g|0)!=(d|0)){do{h=g+ -12|0;c[b>>2]=h;f=c[h>>2]|0;if((f|0)==0){g=h}else{h=g+ -8|0;g=c[h>>2]|0;if((g|0)!=(f|0)){c[h>>2]=g+(~((g+ -4+(0-f)|0)>>>2)<<2)}Hv(f);g=c[b>>2]|0}}while((g|0)!=(d|0));d=c[a>>2]|0}Hv(d);vb(e|0)}function le(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0;f=i;i=i+16|0;h=f+8|0;g=f+4|0;j=f;c[j>>2]=c[d>>2];c[h+0>>2]=c[j+0>>2];h=me(b,h,g,e)|0;d=c[h>>2]|0;if((d|0)!=0){j=d;c[a>>2]=j;i=f;return}d=Fv(32)|0;j=d+16|0;c[j>>2]=c[e>>2];u=0;oa(83,d+20|0,e+4|0);k=u;u=0;if(k&1){a=qb(-1,-1)|0;if((d|0)==0){vb(a|0)}Hv(d);vb(a|0)}else{c[j>>2]=c[e>>2];g=c[g>>2]|0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=g;c[h>>2]=d;g=c[c[b>>2]>>2]|0;if((g|0)==0){g=d}else{c[b>>2]=g;g=c[h>>2]|0}ge(c[b+4>>2]|0,g);k=b+8|0;c[k>>2]=(c[k>>2]|0)+1;k=d;c[a>>2]=k;i=f;return}}function me(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0;f=i;g=a+4|0;b=c[b>>2]|0;if((b|0)!=(g|0)?(h=c[e>>2]|0,j=c[b+16>>2]|0,!(h>>>0<j>>>0)):0){if(!(j>>>0<h>>>0)){c[d>>2]=b;l=d;i=f;return l|0}e=b+4|0;k=c[e>>2]|0;j=(k|0)==0;if(j){l=b;while(1){k=c[l+8>>2]|0;if((c[k>>2]|0)==(l|0)){break}else{l=k}}}else{while(1){l=c[k>>2]|0;if((l|0)==0){break}else{k=l}}}if((k|0)!=(g|0)?!(h>>>0<(c[k+16>>2]|0)>>>0):0){b=c[a+4>>2]|0;if((b|0)==0){c[d>>2]=g;l=g;i=f;return l|0}while(1){g=c[b+16>>2]|0;if(h>>>0<g>>>0){g=c[b>>2]|0;if((g|0)==0){g=34;break}else{b=g;continue}}if(!(g>>>0<h>>>0)){g=38;break}a=b+4|0;g=c[a>>2]|0;if((g|0)==0){g=37;break}else{b=g}}if((g|0)==34){c[d>>2]=b;l=b;i=f;return l|0}else if((g|0)==37){c[d>>2]=b;l=a;i=f;return l|0}else if((g|0)==38){c[d>>2]=b;l=d;i=f;return l|0}}if(j){c[d>>2]=b;l=e;i=f;return l|0}else{c[d>>2]=k;l=k;i=f;return l|0}}h=c[b>>2]|0;if((b|0)!=(c[a>>2]|0)){if((h|0)==0){k=b;while(1){j=c[k+8>>2]|0;if((c[j>>2]|0)==(k|0)){k=j}else{break}}}else{k=h;while(1){j=c[k+4>>2]|0;if((j|0)==0){j=k;break}else{k=j}}}e=c[e>>2]|0;if(!((c[j+16>>2]|0)>>>0<e>>>0)){b=c[a+4>>2]|0;if((b|0)==0){c[d>>2]=g;l=g;i=f;return l|0}while(1){g=c[b+16>>2]|0;if(e>>>0<g>>>0){g=c[b>>2]|0;if((g|0)==0){g=15;break}else{b=g;continue}}if(!(g>>>0<e>>>0)){g=19;break}a=b+4|0;g=c[a>>2]|0;if((g|0)==0){g=18;break}else{b=g}}if((g|0)==15){c[d>>2]=b;l=b;i=f;return l|0}else if((g|0)==18){c[d>>2]=b;l=a;i=f;return l|0}else if((g|0)==19){c[d>>2]=b;l=d;i=f;return l|0}}}else{j=b}if((h|0)==0){c[d>>2]=b;l=b;i=f;return l|0}else{c[d>>2]=j;l=j+4|0;i=f;return l|0}return 0}function ne(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0;d=i;g=a+8|0;e=a+4|0;j=c[e>>2]|0;h=c[g>>2]|0;k=j;if(!(((h-k|0)/60|0)>>>0<b>>>0)){do{if((j|0)==0){f=0}else{c[j>>2]=0;c[j+4>>2]=0;c[j+8>>2]=0;c[j+16>>2]=0;c[j+20>>2]=0;c[j+12>>2]=j+16;f=j+28|0;c[f+0>>2]=0;c[f+4>>2]=0;c[f+8>>2]=0;c[f+12>>2]=0;c[j+48>>2]=0;c[j+52>>2]=0;c[j+56>>2]=0;f=c[e>>2]|0}j=f+60|0;c[e>>2]=j;b=b+ -1|0}while((b|0)!=0);i=d;return}l=c[a>>2]|0;j=(k-l|0)/60|0;k=j+b|0;if(k>>>0>71582788){ss(0)}h=(h-l|0)/60|0;if(h>>>0<35791394){h=h<<1;h=h>>>0<k>>>0?k:h;if((h|0)==0){l=0;h=0}else{f=9}}else{h=71582788;f=9}if((f|0)==9){l=h;h=Fv(h*60|0)|0}k=h+(j*60|0)|0;j=b;b=k;do{if((b|0)==0){b=0}else{c[b>>2]=0;c[b+4>>2]=0;c[b+8>>2]=0;c[b+16>>2]=0;c[b+20>>2]=0;c[b+12>>2]=b+16;n=b+28|0;c[n+0>>2]=0;c[n+4>>2]=0;c[n+8>>2]=0;c[n+12>>2]=0;c[b+48>>2]=0;c[b+52>>2]=0;c[b+56>>2]=0}b=b+60|0;j=j+ -1|0}while((j|0)!=0);j=h+(l*60|0)|0;l=c[a>>2]|0;n=c[e>>2]|0;do{if((n|0)==(l|0)){h=l}else{m=k;while(1){k=m+ -60|0;n=n+ -60|0;u=0;oa(86,k|0,n|0);o=u;u=0;if(o&1){break}if((n|0)==(l|0)){f=17;break}else{m=k}}if((f|0)==17){h=c[a>>2]|0;l=c[e>>2]|0;break}d=qb(-1,-1)|0;while(1){if((b|0)==(m|0)){break}b=b+ -60|0;u=0;na(187,b|0);o=u;u=0;if(o&1){f=27;break}}if((f|0)==27){o=qb(-1,-1)|0;xb(o|0)}if((h|0)==0){vb(d|0)}Hv(h);vb(d|0)}}while(0);c[a>>2]=k;c[e>>2]=b;c[g>>2]=j;while(1){if((l|0)==(h|0)){break}l=l+ -60|0;u=0;na(187,l|0);o=u;u=0;if(o&1){f=21;break}}if((f|0)==21){o=qb(-1,-1)|0;xb(o|0)}if((h|0)==0){i=d;return}Hv(h);i=d;return}function oe(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;h=i;i=i+32|0;p=h+24|0;j=h+20|0;n=h+16|0;m=h;pe(a,b);e=a+12|0;d=a+16|0;c[d>>2]=0;c[a+20>>2]=0;k=a+16|0;c[e>>2]=k;q=c[b+12>>2]|0;l=b+16|0;a:do{if((q|0)==(l|0)){j=19}else{o=m+4|0;g=m+4|0;f=m+8|0;while(1){c[n>>2]=k;r=q+16|0;c[m>>2]=c[r>>2];u=0;oa(83,o|0,q+20|0);s=u;u=0;if(s&1){j=18;break}c[m>>2]=c[r>>2];u=0;c[p+0>>2]=c[n+0>>2];Qa(25,j|0,e|0,p|0,m|0);s=u;u=0;if(s&1){j=9;break}r=c[g>>2]|0;if((r|0)!=0){s=c[f>>2]|0;if((s|0)!=(r|0)){c[f>>2]=s+(~((s+ -4+(0-r)|0)>>>2)<<2)}Hv(r)}r=c[q+4>>2]|0;if((r|0)==0){while(1){r=c[q+8>>2]|0;if((c[r>>2]|0)==(q|0)){q=r;break}else{q=r}}}else{q=r;while(1){r=c[q>>2]|0;if((r|0)==0){break}else{q=r}}}if((q|0)==(l|0)){j=19;break a}}if((j|0)==9){b=qb(-1,-1)|0;h=c[g>>2]|0;if((h|0)!=0){g=c[f>>2]|0;if((g|0)!=(h|0)){c[f>>2]=g+(~((g+ -4+(0-h)|0)>>>2)<<2)}Hv(h)}}else if((j|0)==18){b=qb(-1,-1)|0}ae(e,c[d>>2]|0);d=b}}while(0);if((j|0)==19){c[a+24>>2]=c[b+24>>2];g=a+28|0;u=0;oa(83,g|0,b+28|0);s=u;u=0;if(!(s&1)){c[a+40>>2]=c[b+40>>2];c[a+44>>2]=c[b+44>>2];u=0;oa(83,a+48|0,b+48|0);s=u;u=0;if(!(s&1)){i=h;return}f=qb(-1,-1)|0;b=c[g>>2]|0;if((b|0)!=0){g=a+32|0;h=c[g>>2]|0;if((h|0)!=(b|0)){c[g>>2]=h+(~((h+ -4+(0-b)|0)>>>2)<<2)}Hv(b)}}else{f=qb(-1,-1)|0}ae(e,c[d>>2]|0);d=f}e=c[a>>2]|0;if((e|0)==0){vb(d|0)}f=a+4|0;h=c[f>>2]|0;if((h|0)!=(e|0)){while(1){g=h+ -12|0;c[f>>2]=g;b=c[g>>2]|0;if((b|0)!=0){g=h+ -8|0;h=c[g>>2]|0;if((h|0)!=(b|0)){c[g>>2]=h+(~((h+ -4+(0-b)|0)>>>2)<<2)}Hv(b);g=c[f>>2]|0}if((g|0)==(e|0)){break}else{h=g}}e=c[a>>2]|0}Hv(e);vb(d|0)}function pe(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0;f=i;c[a>>2]=0;d=a+4|0;c[d>>2]=0;j=a+8|0;c[j>>2]=0;g=b+4|0;n=c[g>>2]|0;m=c[b>>2]|0;k=n-m|0;h=(k|0)/12|0;if((n|0)==(m|0)){i=f;return}do{if(h>>>0>357913941){u=0;na(189,0);n=u;u=0;if(n&1){l=12}}else{u=0;e=qa(119,k|0)|0;n=u;u=0;if(!(n&1)){c[d>>2]=e;c[a>>2]=e;c[j>>2]=e+(h*12|0);h=c[b>>2]|0;g=c[g>>2]|0;if((h|0)==(g|0)){i=f;return}while(1){if((e|0)==0){e=0}else{u=0;oa(83,e|0,h|0);n=u;u=0;if(n&1){l=11;break}e=c[d>>2]|0}e=e+12|0;c[d>>2]=e;h=h+12|0;if((h|0)==(g|0)){l=22;break}}if((l|0)==11){e=qb(-1,-1)|0;break}else if((l|0)==22){i=f;return}}else{l=12}}}while(0);if((l|0)==12){e=qb(-1,-1)|0}f=c[a>>2]|0;if((f|0)==0){vb(e|0)}j=c[d>>2]|0;if((j|0)!=(f|0)){while(1){h=j+ -12|0;c[d>>2]=h;g=c[h>>2]|0;if((g|0)!=0){j=j+ -8|0;h=c[j>>2]|0;if((h|0)!=(g|0)){c[j>>2]=h+(~((h+ -4+(0-g)|0)>>>2)<<2)}Hv(g);h=c[d>>2]|0}if((h|0)==(f|0)){break}else{j=h}}f=c[a>>2]|0}Hv(f);vb(e|0)}function qe(a){a=a|0;var b=0;b=i;c[a>>2]=1056;Be(a+12|0,c[a+16>>2]|0);i=b;return}function re(a){a=a|0;var b=0,d=0,e=0;b=i;c[a>>2]=944;d=c[a+16>>2]|0;if((d|0)==0){i=b;return}a=a+20|0;e=c[a>>2]|0;if((e|0)!=(d|0)){c[a>>2]=e+(~((e+ -8+(0-d)|0)>>>3)<<3)}Hv(d);i=b;return}function se(a){a=a|0;var b=0,d=0,e=0,f=0;b=i;c[a>>2]=944;d=c[a+16>>2]|0;if((d|0)==0){Hv(a);i=b;return}e=a+20|0;f=c[e>>2]|0;if((f|0)!=(d|0)){c[e>>2]=f+(~((f+ -8+(0-d)|0)>>>3)<<3)}Hv(d);Hv(a);i=b;return}function te(a){a=a|0;return(c[a+8>>2]|0)==(c[a+4>>2]|0)|0}function ue(a,b,d){a=a|0;b=+b;d=d|0;var e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0.0,p=0;f=i;e=a+12|0;if(+g[e>>2]<=b){i=f;return}l=a+8|0;k=c[l>>2]|0;h=a+16|0;j=k;while(1){if((j|0)==0){j=0;break}p=j+ -1|0;n=c[h>>2]|0;o=+g[n+(p<<3)>>2];if(!(o<=b)){j=p}else{m=5;break}}a:do{if((m|0)==5){if(o==b){while(1){if((c[n+(p<<3)+4>>2]|0)==(d|0)){break}p=p+ -1|0;if(!(+g[n+(p<<3)>>2]==b)){break a}}i=f;return}}}while(0);a=a+4|0;if(k>>>0<(c[a>>2]|0)>>>0){k=k+1|0;c[l>>2]=k}m=k+ -1|0;l=c[h>>2]|0;if(m>>>0>j>>>0){while(1){n=l+(k+ -2<<3)|0;p=c[n+4>>2]|0;k=l+(m<<3)|0;c[k>>2]=c[n>>2];c[k+4>>2]=p;k=m+ -1|0;l=c[h>>2]|0;if(k>>>0>j>>>0){p=m;m=k;k=p}else{break}}}g[l+(j<<3)>>2]=b;c[l+(j<<3)+4>>2]=d;g[e>>2]=+g[l+((c[a>>2]|0)+ -1<<3)>>2];i=f;return}function ve(a){a=a|0;return+(+g[a+12>>2])}function we(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0;f=i;g=a+8|0;e=a+4|0;l=c[e>>2]|0;k=c[g>>2]|0;h=l;if(!(k-h>>3>>>0<b>>>0)){do{if((l|0)==0){g=0}else{k=d;m=c[k+4>>2]|0;g=l;c[g>>2]=c[k>>2];c[g+4>>2]=m;g=c[e>>2]|0}l=g+8|0;c[e>>2]=l;b=b+ -1|0}while((b|0)!=0);i=f;return}m=c[a>>2]|0;h=h-m>>3;l=h+b|0;if(l>>>0>536870911){ss(0)}k=k-m|0;if(k>>3>>>0<268435455){m=k>>2;l=m>>>0<l>>>0?l:m;if((l|0)==0){k=0;l=0}else{j=10}}else{l=536870911;j=10}if((j|0)==10){k=l;l=Fv(l<<3)|0}j=l+(h<<3)|0;do{if((j|0)==0){j=0}else{o=d;n=c[o+4>>2]|0;m=j;c[m>>2]=c[o>>2];c[m+4>>2]=n}j=j+8|0;b=b+ -1|0}while((b|0)!=0);d=c[a>>2]|0;n=(c[e>>2]|0)-d|0;o=l+(h-(n>>3)<<3)|0;tw(o|0,d|0,n|0)|0;c[a>>2]=o;c[e>>2]=j;c[g>>2]=l+(k<<3);if((d|0)==0){i=f;return}Hv(d);i=f;return}function xe(a){a=a|0;var b=0;b=i;c[a>>2]=1056;Be(a+12|0,c[a+16>>2]|0);i=b;return}function ye(a){a=a|0;var b=0;b=i;c[a>>2]=1056;Be(a+12|0,c[a+16>>2]|0);Hv(a);i=b;return}function ze(b){b=b|0;return(a[b+4>>0]|0)!=0|0}function Ae(a){a=a|0;return+(+g[a+8>>2])}function Be(a,b){a=a|0;b=b|0;var d=0;d=i;if((b|0)==0){i=d;return}else{Be(a,c[b>>2]|0);Be(a,c[b+4>>2]|0);Hv(b);i=d;return}}function Ce(a){a=a|0;var b=0;b=i;c[a>>2]=1056;Be(a+12|0,c[a+16>>2]|0);Hv(a);i=b;return}function De(b,d,e){b=b|0;d=+d;e=e|0;var f=0,h=0,j=0,k=0,l=0;f=i;i=i+16|0;j=f;h=b+8|0;if(+g[h>>2]<=d){i=f;return}g[j>>2]=d;c[j+4>>2]=e;e=b+12|0;Ge(f+8|0,e,j);j=b+4|0;k=c[b+20>>2]|0;l=c[b+24>>2]|0;if((a[j>>0]|0)==0){if((k|0)!=(l|0)){i=f;return}a[j>>0]=1;e=b+16|0;b=c[e>>2]|0;if((b|0)==0){while(1){b=c[e+8>>2]|0;if((c[b>>2]|0)==(e|0)){e=b}else{break}}}else{while(1){e=c[b+4>>2]|0;if((e|0)==0){break}else{b=e}}}g[h>>2]=+g[b+16>>2];i=f;return}if(!(k>>>0>l>>>0)){i=f;return}b=b+16|0;k=c[b>>2]|0;if((k|0)==0){j=b;while(1){k=c[j+8>>2]|0;if((c[k>>2]|0)==(j|0)){j=k}else{break}}}else{while(1){j=c[k+4>>2]|0;if((j|0)==0){break}else{k=j}}}Ee(e,k+16|0)|0;e=c[b>>2]|0;if((e|0)==0){while(1){e=c[b+8>>2]|0;if((c[e>>2]|0)==(b|0)){b=e}else{break}}}else{while(1){b=c[e+4>>2]|0;if((b|0)==0){break}else{e=b}}}g[h>>2]=+g[e+16>>2];i=f;return}function Ee(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,h=0.0,j=0,k=0,l=0,m=0,n=0.0;d=i;e=c[a+4>>2]|0;j=a+4|0;if((e|0)==0){m=0;i=d;return m|0}f=b;k=c[f+4>>2]|0;h=+g[f>>2];f=j;m=e;a:while(1){l=m;while(1){n=+g[l+16>>2];if(!(n<h)){if(!(n==h)){break}if(!((c[l+20>>2]|0)>>>0<k>>>0)){break}}l=c[l+4>>2]|0;if((l|0)==0){break a}}m=c[l>>2]|0;if((m|0)==0){f=l;break}else{f=l}}if((f|0)==(j|0)){m=0;i=d;return m|0}j=f+16|0;n=+g[j>>2];if(h<n){m=0;i=d;return m|0}if(h==n?(c[b+4>>2]|0)>>>0<(c[j+4>>2]|0)>>>0:0){m=0;i=d;return m|0}b=c[f+4>>2]|0;if((b|0)==0){b=f;while(1){j=c[b+8>>2]|0;if((c[j>>2]|0)==(b|0)){b=j;break}else{b=j}}}else{while(1){j=c[b>>2]|0;if((j|0)==0){break}else{b=j}}}if((c[a>>2]|0)==(f|0)){c[a>>2]=b}m=a+8|0;c[m>>2]=(c[m>>2]|0)+ -1;Fe(e,f);Hv(f);m=1;i=d;return m|0}function Fe(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;e=i;g=c[d>>2]|0;if((g|0)!=0){f=c[d+4>>2]|0;if((f|0)==0){f=d;h=g}else{while(1){g=c[f>>2]|0;if((g|0)==0){h=0;break}else{f=g}}}}else{f=d;h=0}g=f+4|0;h=c[((h|0)==0?g:f)>>2]|0;j=(h|0)==0;k=f+8|0;if(!j){c[h+8>>2]=c[k>>2]}l=c[k>>2]|0;if((c[l>>2]|0)==(f|0)){c[l>>2]=h;if((f|0)==(b|0)){m=h;b=0}else{m=b;b=c[(c[k>>2]|0)+4>>2]|0}}else{c[l+4>>2]=h;m=b;b=c[c[k>>2]>>2]|0}n=f+12|0;l=(a[n>>0]|0)==0;if((f|0)==(d|0)){f=m}else{p=d+8|0;o=c[p>>2]|0;c[k>>2]=o;if((c[c[p>>2]>>2]|0)==(d|0)){c[o>>2]=f}else{c[o+4>>2]=f}k=c[d>>2]|0;c[f>>2]=k;c[k+8>>2]=f;k=c[d+4>>2]|0;c[g>>2]=k;if((k|0)!=0){c[k+8>>2]=f}a[n>>0]=a[d+12>>0]|0;f=(m|0)==(d|0)?f:m}if(l|(f|0)==0){i=e;return}if(j){d=b}else{a[h+12>>0]=1;i=e;return}while(1){h=d+8|0;g=c[h>>2]|0;j=d+12|0;b=(a[j>>0]|0)!=0;if((c[g>>2]|0)==(d|0)){if(!b){a[j>>0]=1;a[g+12>>0]=0;j=d+4|0;b=c[j>>2]|0;c[g>>2]=b;if((b|0)!=0){c[b+8>>2]=g}b=g+8|0;c[h>>2]=c[b>>2];h=c[b>>2]|0;if((c[h>>2]|0)==(g|0)){c[h>>2]=d}else{c[h+4>>2]=d}c[j>>2]=g;c[b>>2]=d;p=c[j>>2]|0;f=(f|0)==(p|0)?d:f;d=c[p>>2]|0}h=c[d>>2]|0;j=(h|0)==0;if(!j?(a[h+12>>0]|0)==0:0){g=66;break}p=c[d+4>>2]|0;if((p|0)!=0?(a[p+12>>0]|0)==0:0){g=65;break}a[d+12>>0]=0;g=c[d+8>>2]|0;d=g+12|0;if((a[d>>0]|0)==0|(g|0)==(f|0)){g=62;break}d=c[g+8>>2]|0;d=(c[d>>2]|0)==(g|0)?d+4|0:d}else{if(!b){a[j>>0]=1;a[g+12>>0]=0;p=g+4|0;h=c[p>>2]|0;j=c[h>>2]|0;c[p>>2]=j;if((j|0)!=0){c[j+8>>2]=g}b=g+8|0;c[h+8>>2]=c[b>>2];j=c[b>>2]|0;if((c[j>>2]|0)==(g|0)){c[j>>2]=h}else{c[j+4>>2]=h}c[h>>2]=g;c[b>>2]=h;p=c[d>>2]|0;f=(f|0)==(p|0)?d:f;d=c[p+4>>2]|0}h=c[d>>2]|0;if((h|0)!=0?(a[h+12>>0]|0)==0:0){g=36;break}j=c[d+4>>2]|0;if((j|0)!=0?(a[j+12>>0]|0)==0:0){g=37;break}a[d+12>>0]=0;d=c[d+8>>2]|0;if((d|0)==(f|0)){g=34;break}if((a[d+12>>0]|0)==0){f=d;g=34;break}p=c[d+8>>2]|0;d=(c[p>>2]|0)==(d|0)?p+4|0:p}d=c[d>>2]|0}if((g|0)==34){a[f+12>>0]=1;i=e;return}else if((g|0)==36){j=c[d+4>>2]|0;if((j|0)==0){g=38}else{g=37}}else if((g|0)==62){a[d>>0]=1;i=e;return}else if((g|0)==65){if(j){g=67}else{g=66}}if((g|0)==37){if((a[j+12>>0]|0)==0){g=44}else{g=38}}else if((g|0)==66){if((a[h+12>>0]|0)==0){g=73}else{g=67}}if((g|0)==38){a[h+12>>0]=1;a[d+12>>0]=0;f=h+4|0;g=c[f>>2]|0;c[d>>2]=g;if((g|0)!=0){c[g+8>>2]=d}g=d+8|0;c[h+8>>2]=c[g>>2];j=c[g>>2]|0;if((c[j>>2]|0)==(d|0)){c[j>>2]=h}else{c[j+4>>2]=h}c[f>>2]=d;c[g>>2]=h;j=c[f>>2]|0;d=h;g=44}else if((g|0)==67){p=d+4|0;f=c[p>>2]|0;a[f+12>>0]=1;a[d+12>>0]=0;g=c[f>>2]|0;c[p>>2]=g;if((g|0)!=0){c[g+8>>2]=d}g=d+8|0;c[f+8>>2]=c[g>>2];h=c[g>>2]|0;if((c[h>>2]|0)==(d|0)){c[h>>2]=f}else{c[h+4>>2]=f}c[f>>2]=d;c[g>>2]=f;h=c[f>>2]|0;d=f;g=73}if((g|0)==44){f=c[d+8>>2]|0;p=f+12|0;a[d+12>>0]=a[p>>0]|0;a[p>>0]=1;a[j+12>>0]=1;p=f+4|0;d=c[p>>2]|0;g=c[d>>2]|0;c[p>>2]=g;if((g|0)!=0){c[g+8>>2]=f}h=f+8|0;c[d+8>>2]=c[h>>2];g=c[h>>2]|0;if((c[g>>2]|0)==(f|0)){c[g>>2]=d}else{c[g+4>>2]=d}c[d>>2]=f;c[h>>2]=d;i=e;return}else if((g|0)==73){f=c[d+8>>2]|0;g=f+12|0;a[d+12>>0]=a[g>>0]|0;a[g>>0]=1;a[h+12>>0]=1;g=c[f>>2]|0;d=g+4|0;h=c[d>>2]|0;c[f>>2]=h;if((h|0)!=0){c[h+8>>2]=f}j=f+8|0;c[g+8>>2]=c[j>>2];h=c[j>>2]|0;if((c[h>>2]|0)==(f|0)){c[h>>2]=g}else{c[h+4>>2]=g}c[d>>2]=f;c[j>>2]=g;i=e;return}}function Ge(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0,k=0,l=0.0,m=0,n=0.0,o=0,p=0.0,q=0;h=i;i=i+16|0;j=h;f=d+4|0;k=c[f>>2]|0;do{if((k|0)!=0){l=+g[e>>2];m=e+4|0;a:while(1){q=k+16|0;o=c[q+4>>2]|0;n=+g[q>>2];do{if(!(l<n)){if(l==n?(c[m>>2]|0)>>>0<o>>>0:0){break}q=e;o=c[q+4>>2]|0;p=+g[q>>2];if(!(n<p)){if(!(n==p)){m=13;break a}if(!((c[k+20>>2]|0)>>>0<o>>>0)){m=13;break a}}o=k+4|0;q=c[o>>2]|0;if((q|0)==0){m=12;break a}else{k=q;continue a}}}while(0);o=c[k>>2]|0;if((o|0)==0){m=7;break}else{k=o}}if((m|0)==7){c[j>>2]=k;j=k;break}else if((m|0)==12){c[j>>2]=k;j=o;break}else if((m|0)==13){c[j>>2]=k;break}}else{k=d+4|0;c[j>>2]=k;j=k}}while(0);m=c[j>>2]|0;if((m|0)!=0){o=0;q=m;c[b>>2]=q;q=b+4|0;a[q>>0]=o;i=h;return}m=Fv(24)|0;o=e;q=c[o+4>>2]|0;e=m+16|0;c[e>>2]=c[o>>2];c[e+4>>2]=q;c[m>>2]=0;c[m+4>>2]=0;c[m+8>>2]=k;c[j>>2]=m;e=c[c[d>>2]>>2]|0;if((e|0)==0){e=m}else{c[d>>2]=e;e=c[j>>2]|0}ge(c[f>>2]|0,e);o=d+8|0;c[o>>2]=(c[o>>2]|0)+1;o=1;q=m;c[b>>2]=q;q=b+4|0;a[q>>0]=o;i=h;return}function He(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;e=i;f=b+12|0;g=(c[d>>2]|0)+(c[f>>2]|0)|0;h=b+36|0;do{if((a[h>>0]|0)!=0){r=b+40|0;c[b+52>>2]=g;p=(g>>>5)+1|0;n=b+44|0;m=c[n>>2]|0;o=c[r>>2]|0;l=m-o>>2;if(!(l>>>0<p>>>0)){if(l>>>0>p>>>0?(q=o+(p<<2)|0,(m|0)!=(q|0)):0){c[n>>2]=m+(~((m+ -4+(0-q)|0)>>>2)<<2)}}else{$d(r,p-l|0)}l=b+60|0;m=b+64|0;p=c[m>>2]|0;n=c[l>>2]|0;o=p-n>>2;if(o>>>0<g>>>0){$d(l,g-o|0);break}if(o>>>0>g>>>0?(k=n+(g<<2)|0,(p|0)!=(k|0)):0){c[m>>2]=p+(~((p+ -4+(0-k)|0)>>>2)<<2)}}}while(0);k=b+72|0;l=b+76|0;m=c[l>>2]|0;o=c[k>>2]|0;n=m-o>>2;if(!(n>>>0<g>>>0)){if(n>>>0>g>>>0?(j=o+(g<<2)|0,(m|0)!=(j|0)):0){c[l>>2]=m+(~((m+ -4+(0-j)|0)>>>2)<<2)}}else{Ie(k,g-n|0)}l=c[f>>2]|0;if(!(l>>>0<g>>>0)){c[f>>2]=g;i=e;return}j=d+16|0;m=d+8|0;d=b+8|0;n=b+60|0;b=b+40|0;if((a[h>>0]|0)==0){b=c[m>>2]|0;h=l;do{r=(c[j>>2]|0)+(fa(b,h-l|0)|0)|0;c[(c[k>>2]|0)+(h<<2)>>2]=r;h=h+1|0}while((h|0)!=(g|0));c[f>>2]=g;i=e;return}else{h=l;while(1){r=(c[j>>2]|0)+(fa(c[m>>2]|0,l-h|0)|0)|0;c[(c[k>>2]|0)+(l<<2)>>2]=r;r=c[d>>2]|0;c[d>>2]=r+1;c[(c[n>>2]|0)+(l<<2)>>2]=r;r=(c[b>>2]|0)+(l>>>5<<2)|0;c[r>>2]=c[r>>2]&~(1<<(l&31));l=l+1|0;if((l|0)==(g|0)){break}h=c[f>>2]|0}c[f>>2]=g;i=e;return}}function Ie(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0;e=i;f=a+8|0;d=a+4|0;k=c[d>>2]|0;j=c[f>>2]|0;g=k;if(!(j-g>>2>>>0<b>>>0)){do{if((k|0)==0){f=0}else{c[k>>2]=0;f=c[d>>2]|0}k=f+4|0;c[d>>2]=k;b=b+ -1|0}while((b|0)!=0);i=e;return}l=c[a>>2]|0;g=g-l>>2;k=g+b|0;if(k>>>0>1073741823){ss(0)}j=j-l|0;if(j>>2>>>0<536870911){l=j>>1;k=l>>>0<k>>>0?k:l;if((k|0)==0){j=0;k=0}else{h=9}}else{k=1073741823;h=9}if((h|0)==9){j=k;k=Fv(k<<2)|0}h=k+(g<<2)|0;do{if((h|0)==0){h=0}else{c[h>>2]=0}h=h+4|0;b=b+ -1|0}while((b|0)!=0);b=c[a>>2]|0;m=(c[d>>2]|0)-b|0;l=k+(g-(m>>2)<<2)|0;tw(l|0,b|0,m|0)|0;c[a>>2]=l;c[d>>2]=h;c[f>>2]=k+(j<<2);if((b|0)==0){i=e;return}Hv(b);i=e;return}function Je(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;f=i;if((a[b+36>>0]|0)==0){i=f;return}e=b+12|0;p=c[e>>2]|0;if((p|0)==0){j=0}else{m=b+40|0;k=b+72|0;l=b+60|0;o=c[m>>2]|0;n=0;j=0;do{if((c[o+(n>>>5<<2)>>2]&1<<(n&31)|0)==0){o=c[k>>2]|0;c[o+(j<<2)>>2]=c[o+(n<<2)>>2];o=c[l>>2]|0;c[o+(j<<2)>>2]=c[o+(n<<2)>>2];o=c[m>>2]|0;p=o+(j>>>5<<2)|0;c[p>>2]=c[p>>2]&~(1<<(j&31));p=c[e>>2]|0;j=j+1|0}n=n+1|0}while(n>>>0<p>>>0)}m=b+72|0;o=b+76|0;n=c[o>>2]|0;k=c[m>>2]|0;l=n-k>>2;if(!(l>>>0<j>>>0)){if(l>>>0>j>>>0?(h=k+(j<<2)|0,(n|0)!=(h|0)):0){c[o>>2]=n+(~((n+ -4+(0-h)|0)>>>2)<<2)}}else{Ie(m,j-l|0)}m=b+60|0;h=b+64|0;n=c[h>>2]|0;k=c[m>>2]|0;l=n-k>>2;if(!(l>>>0<j>>>0)){if(l>>>0>j>>>0?(g=k+(j<<2)|0,(n|0)!=(g|0)):0){c[h>>2]=n+(~((n+ -4+(0-g)|0)>>>2)<<2)}}else{$d(m,j-l|0)}n=b+40|0;c[b+52>>2]=j;l=(j>>>5)+1|0;h=b+44|0;g=c[h>>2]|0;k=c[n>>2]|0;m=g-k>>2;if(!(m>>>0<l>>>0)){if(m>>>0>l>>>0?(d=k+(l<<2)|0,(g|0)!=(d|0)):0){c[h>>2]=g+(~((g+ -4+(0-d)|0)>>>2)<<2)}}else{$d(n,l-m|0)}c[e>>2]=j;c[b+56>>2]=0;i=f;return}function Ke(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0;f=i;Le(a,b);c[a>>2]=448;e=a+88|0;u=0;oa(87,e|0,b+88|0);j=u;u=0;do{if(!(j&1)){c[a+100>>2]=c[b+100>>2];c[a+104>>2]=c[b+104>>2];c[a+108>>2]=c[b+108>>2];u=0;oa(83,a+112|0,b+112|0);j=u;u=0;if(!(j&1)){i=f;return}f=qb(-1,-1)|0;h=J;j=c[e>>2]|0;if((j|0)!=0){g=a+92|0;while(1){b=c[g>>2]|0;if((b|0)==(j|0)){b=10;break}b=b+ -60|0;c[g>>2]=b;u=0;na(187,b|0);b=u;u=0;if(b&1){b=9;break}}if((b|0)==9){j=qb(-1,-1)|0;xb(j|0)}else if((b|0)==10){Hv(c[e>>2]|0);d=f;break}}else{d=f}}else{d=qb(-1,-1)|0}}while(0);u=0;na(186,a|0);j=u;u=0;if(j&1){j=qb(-1,-1,0)|0;jd(j)}else{vb(d|0)}}function Le(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0;g=i;i=i+32|0;r=g+28|0;s=g+24|0;q=g+20|0;l=g;c[b>>2]=1256;c[b+8>>2]=c[d+8>>2];j=b+12|0;c[j>>2]=c[d+12>>2];c[b+16>>2]=c[d+16>>2];h=b+20|0;c[h>>2]=c[d+20>>2];e=b+24|0;f=b+28|0;c[f>>2]=0;c[b+32>>2]=0;t=b+28|0;c[e>>2]=t;y=c[d+24>>2]|0;w=d+28|0;a:do{if((y|0)!=(w|0)){o=l+12|0;p=l+16|0;m=l+8|0;while(1){c[q>>2]=t;u=0;oa(77,l|0,y+16|0);x=u;u=0;if(x&1){k=21;break}u=0;c[r+0>>2]=c[q+0>>2];Qa(18,s|0,e|0,r|0,l|0);x=u;u=0;if(x&1){k=10;break}x=c[o>>2]|0;u=0;oa(c[c[x>>2]>>2]|0,x|0,p|0);x=u;u=0;if(x&1){k=8;break}if(!((a[l>>0]&1)==0)){Hv(c[m>>2]|0)}x=c[y+4>>2]|0;if((x|0)==0){while(1){x=c[y+8>>2]|0;if((c[x>>2]|0)==(y|0)){break}else{y=x}}}else{while(1){y=c[x>>2]|0;if((y|0)==0){break}else{x=y}}}if((x|0)==(w|0)){break a}else{y=x}}do{if((k|0)==8){n=qb(-1,-1)|0;if(!((a[l>>0]&1)==0)){Hv(c[m>>2]|0)}}else if((k|0)==10){b=qb(-1,-1)|0;y=c[o>>2]|0;u=0;oa(c[c[y>>2]>>2]|0,y|0,p|0);y=u;u=0;if(!(y&1)){if((a[l>>0]&1)==0){n=b;break}Hv(c[m>>2]|0);n=b;break}b=qb(-1,-1,0)|0;if((a[l>>0]&1)==0){jd(b)}Hv(c[m>>2]|0);jd(b)}else if((k|0)==21){n=qb(-1,-1)|0}}while(0);Bd(e,c[f>>2]|0);y=n;vb(y|0)}}while(0);a[b+36>>0]=a[d+36>>0]|0;l=b+40|0;u=0;oa(83,l|0,d+40|0);y=u;u=0;if(!(y&1)){c[b+52>>2]=c[d+52>>2];c[b+56>>2]=c[d+56>>2];m=b+60|0;u=0;oa(83,m|0,d+60|0);y=u;u=0;if(!(y&1)){o=b+72|0;c[o>>2]=0;n=b+76|0;c[n>>2]=0;t=b+80|0;c[t>>2]=0;q=d+76|0;r=d+72|0;p=(c[q>>2]|0)-(c[r>>2]|0)|0;s=p>>2;b:do{if((s|0)==0){p=0;k=37}else{if(s>>>0>1073741823){u=0;na(189,0);y=u;u=0}else{u=0;p=qa(119,p|0)|0;y=u;u=0;if(!(y&1)){c[n>>2]=p;c[o>>2]=p;c[t>>2]=p+(s<<2);r=c[r>>2]|0;k=c[q>>2]|0;if((r|0)==(k|0)){k=37;break}else{q=r}while(1){if((p|0)==0){p=0}else{c[p>>2]=c[q>>2];p=c[n>>2]|0}p=p+4|0;c[n>>2]=p;q=q+4|0;if((q|0)==(k|0)){k=37;break b}}}}g=qb(-1,-1)|0;h=c[o>>2]|0;if((h|0)!=0){j=c[n>>2]|0;if((j|0)!=(h|0)){c[n>>2]=j+(~((j+ -4+(0-h)|0)>>>2)<<2)}Hv(h)}}}while(0);do{if((k|0)==37){k=b+84|0;c[k>>2]=0;d=d+84|0;if((c[d>>2]|0)==0){i=g;return}j=c[j>>2]|0;h=c[h>>2]|0;q=fa(h,j)|0;u=0;q=qa(121,(q>>>0>1073741823?-1:q<<2)|0)|0;y=u;u=0;if(y&1){g=qb(-1,-1)|0;h=c[o>>2]|0;if((h|0)==0){break}if((p|0)!=(h|0)){c[n>>2]=p+(~((p+ -4+(0-h)|0)>>>2)<<2)}Hv(h);break}c[k>>2]=q;vw(q|0,c[d>>2]|0,fa(j<<2,h)|0)|0;if((j|0)==0){i=g;return}else{e=0}while(1){y=q+((fa(h,e)|0)<<2)|0;c[(c[o>>2]|0)+(e<<2)>>2]=y;e=e+1|0;if(!(e>>>0<j>>>0)){break}q=c[k>>2]|0}i=g;return}}while(0);h=c[m>>2]|0;if((h|0)!=0){d=b+64|0;j=c[d>>2]|0;if((j|0)!=(h|0)){c[d>>2]=j+(~((j+ -4+(0-h)|0)>>>2)<<2)}Hv(h)}}else{g=qb(-1,-1)|0}h=c[l>>2]|0;if((h|0)!=0){b=b+44|0;j=c[b>>2]|0;if((j|0)!=(h|0)){c[b>>2]=j+(~((j+ -4+(0-h)|0)>>>2)<<2)}Hv(h)}}else{g=qb(-1,-1)|0}Bd(e,c[f>>2]|0);y=g;vb(y|0)}function Me(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0;e=i;c[a>>2]=0;d=a+4|0;c[d>>2]=0;k=a+8|0;c[k>>2]=0;g=b+4|0;n=c[g>>2]|0;m=c[b>>2]|0;l=n-m|0;j=(l|0)/60|0;if((n|0)==(m|0)){i=e;return}do{if(j>>>0>71582788){u=0;na(189,0);n=u;u=0;if(n&1){h=12}}else{u=0;f=qa(119,l|0)|0;n=u;u=0;if(!(n&1)){c[d>>2]=f;c[a>>2]=f;c[k>>2]=f+(j*60|0);h=c[b>>2]|0;g=c[g>>2]|0;if((h|0)==(g|0)){i=e;return}while(1){if((f|0)==0){f=0}else{u=0;oa(86,f|0,h|0);n=u;u=0;if(n&1){h=11;break}f=c[d>>2]|0}f=f+60|0;c[d>>2]=f;h=h+60|0;if((h|0)==(g|0)){h=18;break}}if((h|0)==11){f=qb(-1,-1)|0;break}else if((h|0)==18){i=e;return}}else{h=12}}}while(0);if((h|0)==12){f=qb(-1,-1)|0}e=c[a>>2]|0;if((e|0)==0){vb(f|0)}while(1){g=c[d>>2]|0;if((g|0)==(e|0)){break}n=g+ -60|0;c[d>>2]=n;u=0;na(187,n|0);n=u;u=0;if(n&1){h=16;break}}if((h|0)==16){n=qb(-1,-1)|0;xb(n|0)}Hv(c[a>>2]|0);vb(f|0)}function Ne(a){a=a|0;var b=0;b=i;Hd(a);i=b;return}function Oe(a){a=a|0;var b=0,c=0;b=i;u=0;na(186,a|0);c=u;u=0;if(c&1){c=qb(-1,-1)|0;Hv(a);vb(c|0)}else{Hv(a);i=b;return}}function Pe(a,b,d){a=a|0;b=b|0;d=+d;a=Jb(8)|0;u=0;oa(75,a|0,1576);b=u;u=0;if(b&1){b=qb(-1,-1)|0;pb(a|0);vb(b|0)}else{c[a>>2]=288;qc(a|0,264,1)}}function Qe(b,d,e,f,h,j){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0;k=i;i=i+96|0;n=k+8|0;r=k+88|0;s=k+84|0;t=k+80|0;v=k+76|0;p=k+72|0;q=k;m=k+44|0;l=k+16|0;N=c[d+4>>2]|0;if((N|0)!=(Bc[c[(c[b>>2]|0)+8>>2]&255](b)|0)){Wa(1336,1368,307,808)}y=c[d>>2]|0;if((c[e>>2]|0)>>>0<y>>>0){Wa(824,1368,308,808)}if((c[f>>2]|0)>>>0<y>>>0){Wa(856,1368,309,808)}if((c[e+4>>2]|0)>>>0<h>>>0){Wa(888,1368,310,808)}if((c[f+4>>2]|0)>>>0<h>>>0){Wa(912,1368,311,808)}N=c[j+16>>2]|0;if((N|0)==2?h>>>0>250:(N|0)==1){c[m>>2]=1504;c[m+4>>2]=h;o=m+12|0;c[o>>2]=0;l=m+16|0;c[l>>2]=0;w=m+20|0;c[w>>2]=0;if((h|0)==0){F=0}else{F=Fv(h<<3)|0;c[o>>2]=F;c[l>>2]=F;c[w>>2]=F+(h<<3)}w=m+8|0;g[w>>2]=3.4028234663852886e+38;x=m+24|0;a[x>>0]=0;a:do{if((y|0)>0){z=d+16|0;y=d+8|0;A=e+16|0;B=e+8|0;e=f+16|0;C=f+8|0;f=j+8|0;D=b+36|0;E=b+60|0;J=F;I=F;G=0;F=0;while(1){if((J|0)!=(I|0)){c[l>>2]=J+(~((J+ -8+(0-I)|0)>>>3)<<3)}g[w>>2]=3.4028234663852886e+38;a[x>>0]=0;N=(c[z>>2]|0)+(fa(c[y>>2]|0,F)|0)|0;u=0;Qa(c[(c[b>>2]|0)+64>>2]|0,b|0,m|0,N|0,j|0);N=u;u=0;if(N&1){break}J=c[l>>2]|0;M=c[o>>2]|0;H=J-M>>3;I=H>>>0>h>>>0;H=I?h:H;K=(c[A>>2]|0)+(fa(c[B>>2]|0,F)|0)|0;L=(c[e>>2]|0)+(fa(c[C>>2]|0,F)|0)|0;if((a[f>>0]|0)==0){if(I){c[t>>2]=M;c[v>>2]=M+(H<<3);c[p>>2]=J;c[s+0>>2]=c[t+0>>2];c[r+0>>2]=c[v+0>>2];c[n+0>>2]=c[p+0>>2];af(s,r,n,q)}}else{cf(M,J,n)}J=c[l>>2]|0;I=c[o>>2]|0;M=J-I>>3;if(((M>>>0>H>>>0?H:M)|0)!=0){N=~M;M=~H;M=~(N>>>0>M>>>0?N:M);N=0;while(1){c[K>>2]=c[I+(N<<3)+4>>2];g[L>>2]=+g[I+(N<<3)>>2];N=N+1|0;if((N|0)==(M|0)){break}else{L=L+4|0;K=K+4|0}}}K=(c[A>>2]|0)+(fa(c[B>>2]|0,F)|0)|0;if(!((a[D>>0]|0)==0|(H|0)==0)){M=c[E>>2]|0;L=0;do{N=K+(L<<2)|0;c[N>>2]=c[M+(c[N>>2]<<2)>>2];L=L+1|0}while((L|0)!=(H|0))}G=H+G|0;F=F+1|0;if((F|0)>=(c[d>>2]|0)){break a}}k=qb(-1,-1)|0;c[m>>2]=1504;j=c[o>>2]|0;if((j|0)==0){N=k;vb(N|0)}d=c[l>>2]|0;if((d|0)!=(j|0)){c[l>>2]=d+(~((d+ -8+(0-j)|0)>>>3)<<3)}Hv(j);N=k;vb(N|0)}else{I=F;J=F;G=0}}while(0);c[m>>2]=1504;if((I|0)==0){N=G;i=k;return N|0}if((J|0)!=(I|0)){c[l>>2]=J+(~((J+ -8+(0-I)|0)>>>3)<<3)}Hv(I);N=G;i=k;return N|0}c[l>>2]=1424;p=l+4|0;c[p>>2]=h;q=l+16|0;c[q>>2]=0;m=l+20|0;c[m>>2]=0;c[l+24>>2]=0;g[n>>2]=3.4028234663852886e+38;c[n+4>>2]=-1;do{if((h|0)==0){B=0;q=-1;C=0}else{u=0;Na(49,q|0,h|0,n|0);N=u;u=0;if(!(N&1)){C=c[p>>2]|0;B=c[l+16>>2]|0;q=C+ -1|0;y=c[d>>2]|0;break}k=qb(-1,-1)|0;j=c[q>>2]|0;if((j|0)==0){vb(k|0)}d=c[m>>2]|0;if((d|0)!=(j|0)){c[m>>2]=d+(~((d+ -8+(0-j)|0)>>>3)<<3)}Hv(j);vb(k|0)}}while(0);n=l+12|0;g[n>>2]=3.4028234663852886e+38;g[B+(q<<3)>>2]=3.4028234663852886e+38;q=l+8|0;c[q>>2]=0;do{if((y|0)>0){r=l+16|0;v=d+16|0;t=d+8|0;s=e+16|0;z=e+8|0;w=b+36|0;y=b+60|0;x=f+8|0;A=f+16|0;f=C;C=B;e=0;B=0;while(1){g[n>>2]=3.4028234663852886e+38;g[C+(f+ -1<<3)>>2]=3.4028234663852886e+38;c[q>>2]=0;N=(c[v>>2]|0)+(fa(c[t>>2]|0,B)|0)|0;u=0;Qa(c[(c[b>>2]|0)+64>>2]|0,b|0,l|0,N|0,j|0);N=u;u=0;if(N&1){break}F=c[q>>2]|0;f=F>>>0>h>>>0?h:F;C=(f|0)==0;if(!C){G=fa(c[x>>2]|0,B)|0;H=fa(c[z>>2]|0,B)|0;D=c[s>>2]|0;E=c[r>>2]|0;I=~F;F=~f;F=~(I>>>0>F>>>0?I:F);G=(c[A>>2]|0)+G|0;H=D+H|0;I=0;while(1){c[H>>2]=c[E+(I<<3)+4>>2];g[G>>2]=+g[E+(I<<3)>>2];I=I+1|0;if((I|0)==(F|0)){break}else{G=G+4|0;H=H+4|0}}D=D+(fa(c[z>>2]|0,B)|0)|0;if(!((a[w>>0]|0)==0|C)){C=c[y>>2]|0;E=0;do{N=D+(E<<2)|0;c[N>>2]=c[C+(c[N>>2]<<2)>>2];E=E+1|0}while((E|0)!=(f|0))}}e=f+e|0;B=B+1|0;if((B|0)>=(c[d>>2]|0)){o=61;break}f=c[p>>2]|0;C=c[r>>2]|0}if((o|0)==61){B=c[r>>2]|0;break}k=qb(-1,-1)|0;c[l>>2]=1424;d=c[r>>2]|0;if((d|0)==0){N=k;vb(N|0)}j=c[m>>2]|0;if((j|0)!=(d|0)){c[m>>2]=j+(~((j+ -8+(0-d)|0)>>>3)<<3)}Hv(d);N=k;vb(N|0)}else{e=0}}while(0);c[l>>2]=1424;if((B|0)==0){N=e;i=k;return N|0}d=c[m>>2]|0;if((d|0)!=(B|0)){c[m>>2]=d+(~((d+ -8+(0-B)|0)>>>3)<<3)}Hv(B);N=e;i=k;return N|0}function Re(a){a=a|0;var b=0,d=0,e=0;b=i;c[a>>2]=1504;d=c[a+12>>2]|0;if((d|0)==0){i=b;return}a=a+16|0;e=c[a>>2]|0;if((e|0)!=(d|0)){c[a>>2]=e+(~((e+ -8+(0-d)|0)>>>3)<<3)}Hv(d);i=b;return}function Se(a){a=a|0;var b=0,d=0,e=0;b=i;c[a>>2]=1424;d=c[a+16>>2]|0;if((d|0)==0){i=b;return}a=a+20|0;e=c[a>>2]|0;if((e|0)!=(d|0)){c[a>>2]=e+(~((e+ -8+(0-d)|0)>>>3)<<3)}Hv(d);i=b;return}function Te(a){a=a|0;var b=0,d=0,e=0,f=0;b=i;c[a>>2]=1424;d=c[a+16>>2]|0;if((d|0)==0){Hv(a);i=b;return}e=a+20|0;f=c[e>>2]|0;if((f|0)!=(d|0)){c[e>>2]=f+(~((f+ -8+(0-d)|0)>>>3)<<3)}Hv(d);Hv(a);i=b;return}function Ue(a){a=a|0;return(c[a+8>>2]|0)==(c[a+4>>2]|0)|0}function Ve(a,b,d){a=a|0;b=+b;d=d|0;var e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0;h=i;f=a+12|0;if(+g[f>>2]<=b){i=h;return}j=a+8|0;k=c[j>>2]|0;e=a+4|0;if(k>>>0<(c[e>>2]|0)>>>0){k=k+1|0;c[j>>2]=k}j=k+ -1|0;a=a+16|0;a:do{if((j|0)==0){j=0}else{while(1){l=c[a>>2]|0;k=l+(k+ -2<<3)|0;if(!(+g[k>>2]>b)){break a}n=k;m=c[n+4>>2]|0;k=l+(j<<3)|0;c[k>>2]=c[n>>2];c[k+4>>2]=m;k=j+ -1|0;if((k|0)==0){j=0;break}else{n=j;j=k;k=n}}}}while(0);n=c[a>>2]|0;g[n+(j<<3)>>2]=b;c[n+(j<<3)+4>>2]=d;g[f>>2]=+g[n+((c[e>>2]|0)+ -1<<3)>>2];i=h;return}function We(a){a=a|0;return+(+g[a+12>>2])}function Xe(a){a=a|0;var b=0,d=0,e=0,f=0;b=i;c[a>>2]=1504;d=c[a+12>>2]|0;if((d|0)==0){Hv(a);i=b;return}e=a+16|0;f=c[e>>2]|0;if((f|0)!=(d|0)){c[e>>2]=f+(~((f+ -8+(0-d)|0)>>>3)<<3)}Hv(d);Hv(a);i=b;return}function Ye(b){b=b|0;return(a[b+24>>0]|0)!=0|0}function Ze(b,d,e){b=b|0;d=+d;e=e|0;var f=0,h=0,j=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0.0,A=0,B=0,C=0,D=0;f=i;i=i+16|0;t=f+12|0;s=f+8|0;x=f+4|0;w=f;h=b+8|0;if(+g[h>>2]<=d){i=f;return}n=b+16|0;y=c[n>>2]|0;j=b+12|0;u=c[j>>2]|0;r=y-u|0;v=r>>3;m=b+4|0;if((v|0)==(c[m>>2]|0)){if((r|0)>8){y=y+ -8|0;A=u;B=c[A>>2]|0;A=c[A+4>>2]|0;D=y;C=c[D+4>>2]|0;r=u;c[r>>2]=c[D>>2];c[r+4>>2]=C;r=y;c[r>>2]=B;c[r+4>>2]=A;c[x>>2]=u;c[w>>2]=y;y=v+ -1|0;c[s+0>>2]=c[x+0>>2];c[t+0>>2]=c[w+0>>2];$e(s,t,0,y);y=c[n>>2]|0}y=y+(~((y+ -8+(0-(y+ -8))|0)>>>3)<<3)|0;c[n>>2]=y}r=b+20|0;if((y|0)==(c[r>>2]|0)){s=c[j>>2]|0;t=y-s|0;v=t>>3;u=v+1|0;if(u>>>0>536870911){ss(0)}if(v>>>0<268435455){x=t>>2;x=x>>>0<u>>>0?u:x;if((x|0)==0){w=0;x=0}else{l=14}}else{x=536870911;l=14}if((l|0)==14){w=x;x=Fv(x<<3)|0}v=x+(v<<3)|0;if((v|0)!=0){D=v;g[D>>2]=d;c[D+4>>2]=e}tw(x|0,s|0,t|0)|0;c[j>>2]=x;c[n>>2]=x+(u<<3);c[r>>2]=x+(w<<3);if((s|0)!=0){Hv(s)}}else{if((y|0)==0){e=0}else{D=y;g[D>>2]=d;c[D+4>>2]=e;e=c[n>>2]|0}c[n>>2]=e+8}b=b+24|0;do{if((a[b>>0]|0)!=0?(o=c[j>>2]|0,q=c[n>>2]|0,D=q-o|0,p=D>>3,(D|0)>8):0){s=(p+ -2|0)/2|0;r=o+(s<<3)|0;t=q+ -8|0;z=+g[r>>2];d=+g[t>>2];if(!(z<d)){if(!(z==d)){break}if(!((c[o+(s<<3)+4>>2]|0)>>>0<(c[q+ -4>>2]|0)>>>0)){break}}e=t;q=c[e>>2]|0;e=c[e+4>>2]|0;d=(c[k>>2]=q,+g[k>>2]);B=r;C=c[B+4>>2]|0;D=t;c[D>>2]=c[B>>2];c[D+4>>2]=C;a:do{if(!((p+ -1|0)>>>0<3)){while(1){t=s;s=(s+ -1|0)/2|0;p=o+(s<<3)|0;z=+g[p>>2];if(!(z<d)){if(!(z==d)){break a}if(!((c[o+(s<<3)+4>>2]|0)>>>0<e>>>0)){break a}}B=p;C=c[B+4>>2]|0;D=r;c[D>>2]=c[B>>2];c[D+4>>2]=C;if(t>>>0<3){r=p;break}else{r=p}}}}while(0);D=r;c[D>>2]=q;c[D+4>>2]=e}}while(0);o=c[j>>2]|0;p=(c[n>>2]|0)-o|0;n=p>>3;if((n|0)!=(c[m>>2]|0)){i=f;return}if((a[b>>0]|0)==0){if((p|0)>8){m=o;p=1;do{q=m;m=m+8|0;r=(p+ -1|0)/2|0;s=o+(r<<3)|0;z=+g[s>>2];d=+g[m>>2];if(!(z<d)){if(z==d?(c[o+(r<<3)+4>>2]|0)>>>0<(c[q+12>>2]|0)>>>0:0){l=37}}else{l=37}if((l|0)==37){l=0;e=m;q=c[e>>2]|0;e=c[e+4>>2]|0;d=(c[k>>2]=q,+g[k>>2]);B=s;C=c[B+4>>2]|0;D=m;c[D>>2]=c[B>>2];c[D+4>>2]=C;b:do{if(!(p>>>0<3)){while(1){t=r;r=(r+ -1|0)/2|0;u=o+(r<<3)|0;z=+g[u>>2];if(!(z<d)){if(!(z==d)){break b}if(!((c[o+(r<<3)+4>>2]|0)>>>0<e>>>0)){break b}}B=u;C=c[B+4>>2]|0;D=s;c[D>>2]=c[B>>2];c[D+4>>2]=C;if(t>>>0<3){s=u;break}else{s=u}}}}while(0);D=s;c[D>>2]=q;c[D+4>>2]=e}p=p+1|0}while((p|0)<(n|0));o=c[j>>2]|0}a[b>>0]=1}g[h>>2]=+g[o>>2];i=f;return}function _e(a){a=a|0;return+(+g[a+8>>2])}function $e(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0.0,h=0,j=0.0,l=0,m=0.0,n=0,o=0,p=0,q=0.0,r=0,s=0,t=0;b=i;if((e|0)<=1){i=b;return}a=c[a>>2]|0;p=a+16|0;if((e|0)!=2){m=+g[p>>2];q=+g[a+8>>2];if(!(m<q)){if(m==q?(c[a+20>>2]|0)>>>0<(c[a+12>>2]|0)>>>0:0){m=q;h=7}else{s=4}}else{m=q;h=7}}else{m=+g[a+8>>2];h=7}if((h|0)==7){p=a+8|0;s=2}q=+g[a>>2];if(!(q<m)){if(!(q==m)){i=b;return}if(!((c[a+4>>2]|0)>>>0<(c[p+4>>2]|0)>>>0)){i=b;return}}d=a;l=c[d>>2]|0;d=c[d+4>>2]|0;m=(c[k>>2]=l,+g[k>>2]);n=p;r=c[n+4>>2]|0;o=a;c[o>>2]=c[n>>2];c[o+4>>2]=r;o=s+2|0;a:do{if((o|0)<=(e|0)){n=p;while(1){r=a+(o<<3)|0;s=s|1;if((o|0)!=(e|0)?(j=+g[r>>2],f=+g[a+(s<<3)>>2],!(j<f)):0){if(j==f?(c[a+(o<<3)+4>>2]|0)>>>0<(c[a+(s<<3)+4>>2]|0)>>>0:0){h=16}else{q=j}}else{h=16}if((h|0)==16){h=0;r=a+(s<<3)|0;q=+g[r>>2];o=s}if(!(m<q)){if(!(m==q)){break a}if(!(d>>>0<(c[r+4>>2]|0)>>>0)){break a}}t=r;p=c[t+4>>2]|0;s=n;c[s>>2]=c[t>>2];c[s+4>>2]=p;s=o<<1;o=s+2|0;if((o|0)>(e|0)){p=r;break}else{n=r;p=r}}}}while(0);t=p;c[t>>2]=l;c[t+4>>2]=d;i=b;return}function af(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0.0,z=0,A=0,B=0,C=0.0,D=0,E=0.0,F=0,G=0,H=0;e=i;i=i+48|0;o=e+32|0;q=e+28|0;k=e+24|0;n=e+20|0;p=e+16|0;r=e+12|0;l=e+8|0;s=e+4|0;m=e;t=c[b>>2]|0;u=c[d>>2]|0;if((t|0)==(u|0)){i=e;return}b=u;j=c[a>>2]|0;a:while(1){w=b-j|0;v=w>>3;if((v|0)==1|(v|0)==0){f=91;break}else if((v|0)==3){f=8;break}else if((v|0)==2){f=4;break}if((w|0)<64){f=10;break}w=(v|0)/2|0;x=j+(w<<3)|0;c[l>>2]=j;c[s>>2]=x;v=b+ -8|0;c[m>>2]=v;c[k+0>>2]=c[l+0>>2];c[q+0>>2]=c[s+0>>2];c[o+0>>2]=c[m+0>>2];z=bf(k,q,o,0)|0;y=+g[j>>2];C=+g[x>>2];b:do{if(y<C){B=v;f=56}else{if(y==C?(c[j+4>>2]|0)>>>0<(c[j+(w<<3)+4>>2]|0)>>>0:0){B=v;f=56;break}B=b+ -16|0;c:do{if((j|0)!=(B|0)){w=j+(w<<3)+4|0;A=v;while(1){E=+g[B>>2];if(E<C){break}if(E==C?(c[A+ -4>>2]|0)>>>0<(c[w>>2]|0)>>>0:0){break}A=B+ -8|0;if((j|0)==(A|0)){break c}else{D=B;B=A;A=D}}D=j;A=c[D>>2]|0;D=c[D+4>>2]|0;v=B;w=c[v+4>>2]|0;f=j;c[f>>2]=c[v>>2];c[f+4>>2]=w;f=B;c[f>>2]=A;c[f+4>>2]=D;z=z+1|0;f=56;break b}}while(0);x=j+8|0;C=+g[v>>2];do{if(!(y<C)){if(y==C?(c[j+4>>2]|0)>>>0<(c[b+ -4>>2]|0)>>>0:0){break}if((x|0)==(v|0)){f=91;break a}w=j+4|0;while(1){C=+g[x>>2];if(y<C){break}if(y==C?(c[w>>2]|0)>>>0<(c[x+4>>2]|0)>>>0:0){break}x=x+8|0;if((x|0)==(v|0)){f=91;break a}}B=x;A=c[B>>2]|0;B=c[B+4>>2]|0;w=v;z=c[w+4>>2]|0;D=x;c[D>>2]=c[w>>2];c[D+4>>2]=z;D=v;c[D>>2]=A;c[D+4>>2]=B;x=x+8|0}}while(0);if((x|0)==(v|0)){f=91;break a}w=j+4|0;while(1){y=+g[j>>2];C=+g[x>>2];d:do{if(!(y<C)){do{if(y==C?(c[w>>2]|0)>>>0<(c[x+4>>2]|0)>>>0:0){break d}x=x+8|0;C=+g[x>>2]}while(!(y<C))}}while(0);while(1){z=v;v=v+ -8|0;C=+g[v>>2];if(y<C){continue}if(!(y==C)){break}if(!((c[w>>2]|0)>>>0<(c[z+ -4>>2]|0)>>>0)){break}}if(!(x>>>0<v>>>0)){break}B=x;A=c[B>>2]|0;B=c[B+4>>2]|0;F=v;z=c[F+4>>2]|0;D=x;c[D>>2]=c[F>>2];c[D+4>>2]=z;D=v;c[D>>2]=A;c[D+4>>2]=B;x=x+8|0}if(t>>>0<x>>>0){f=91;break a}c[a>>2]=x;j=x}}while(0);do{if((f|0)==56){f=0;v=j+8|0;e:do{if(v>>>0<B>>>0){w=v;while(1){y=+g[x>>2];A=x+4|0;while(1){C=+g[w>>2];if(!(C<y)){if(!(C==y)){break}if(!((c[w+4>>2]|0)>>>0<(c[A>>2]|0)>>>0)){break}}w=w+8|0}D=B+ -8|0;C=+g[D>>2];f:do{if(C<y){B=D}else{while(1){if(C==y?(c[B+ -4>>2]|0)>>>0<(c[A>>2]|0)>>>0:0){B=D;break f}B=D+ -8|0;C=+g[B>>2];if(C<y){break}else{F=D;D=B;B=F}}}}while(0);if(!(w>>>0<B>>>0)){break e}D=w;A=c[D>>2]|0;D=c[D+4>>2]|0;H=B;G=c[H+4>>2]|0;F=w;c[F>>2]=c[H>>2];c[F+4>>2]=G;F=B;c[F>>2]=A;c[F+4>>2]=D;x=(x|0)==(w|0)?B:x;w=w+8|0;z=z+1|0}}else{w=v}}while(0);do{if((w|0)!=(x|0)){C=+g[x>>2];y=+g[w>>2];if(!(C<y)){if(!(C==y)){break}if(!((c[x+4>>2]|0)>>>0<(c[w+4>>2]|0)>>>0)){break}}G=w;F=c[G>>2]|0;G=c[G+4>>2]|0;B=x;D=c[B+4>>2]|0;H=w;c[H>>2]=c[B>>2];c[H+4>>2]=D;H=x;c[H>>2]=F;c[H+4>>2]=G;z=z+1|0}}while(0);if((t|0)==(w|0)){f=91;break a}g:do{if((z|0)==0){if(t>>>0<w>>>0){if((v|0)==(w|0)){f=91;break a}y=+g[j>>2];x=j;while(1){C=y;y=+g[v>>2];if(y<C){break g}if(y==C?(c[x+12>>2]|0)>>>0<(c[x+4>>2]|0)>>>0:0){break g}x=v+8|0;if((x|0)==(w|0)){f=91;break a}else{H=v;v=x;x=H}}}else{v=w+8|0;if((v|0)==(b|0)){f=91;break a}y=+g[w>>2];x=w;while(1){C=y;y=+g[v>>2];if(y<C){break g}if(y==C?(c[x+12>>2]|0)>>>0<(c[x+4>>2]|0)>>>0:0){break g}x=v+8|0;if((x|0)==(b|0)){f=91;break a}else{H=v;v=x;x=H}}}}}while(0);if(t>>>0<w>>>0){c[d>>2]=w;b=w;u=w;break}else{j=w+8|0;c[a>>2]=j;break}}}while(0);if((t|0)==(b|0)){f=91;break}}if((f|0)==4){f=b+ -8|0;c[d>>2]=f;y=+g[f>>2];C=+g[j>>2];if(!(y<C)){if(!(y==C)){i=e;return}if(!((c[b+ -4>>2]|0)>>>0<(c[j+4>>2]|0)>>>0)){i=e;return}}G=j;F=c[G>>2]|0;G=c[G+4>>2]|0;B=f;D=c[B+4>>2]|0;H=j;c[H>>2]=c[B>>2];c[H+4>>2]=D;H=f;c[H>>2]=F;c[H+4>>2]=G;i=e;return}else if((f|0)==8){c[n>>2]=j;c[p>>2]=j+8;H=u+ -8|0;c[d>>2]=H;c[r>>2]=H;c[k+0>>2]=c[n+0>>2];c[q+0>>2]=c[p+0>>2];c[o+0>>2]=c[r+0>>2];bf(k,q,o,0)|0;i=e;return}else if((f|0)==10){d=b+ -8|0;if((j|0)==(d|0)){i=e;return}do{if((j|0)!=(b|0)){a=j+8|0;if((a|0)!=(b|0)){h=j;k=j;while(1){y=+g[a>>2];C=+g[h>>2];if(!(y<C)){if(y==C?(c[k+12>>2]|0)>>>0<(c[h+4>>2]|0)>>>0:0){f=16}}else{f=16}if((f|0)==16){f=0;h=a}k=a+8|0;if((k|0)==(b|0)){f=18;break}else{H=a;a=k;k=H}}}}else{h=b;f=18}if((f|0)==18?(f=0,(h|0)!=(j|0)):0){G=j;F=c[G>>2]|0;G=c[G+4>>2]|0;B=h;D=c[B+4>>2]|0;H=j;c[H>>2]=c[B>>2];c[H+4>>2]=D;H=h;c[H>>2]=F;c[H+4>>2]=G}j=j+8|0}while((j|0)!=(d|0));i=e;return}else if((f|0)==91){i=e;return}}function bf(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0.0,l=0,m=0.0,n=0,o=0;e=i;b=c[b>>2]|0;a=c[a>>2]|0;j=+g[b>>2];m=+g[a>>2];if(!(j<m)){if(j==m){f=(c[b+4>>2]|0)>>>0<(c[a+4>>2]|0)>>>0}else{f=0}}else{f=1}d=c[d>>2]|0;m=+g[d>>2];if(!(m<j)){if(m==j){l=(c[d+4>>2]|0)>>>0<(c[b+4>>2]|0)>>>0}else{l=0}}else{l=1}if(!f){if(!l){l=0;i=e;return l|0}h=b;f=c[h>>2]|0;h=c[h+4>>2]|0;o=d;n=c[o+4>>2]|0;l=b;c[l>>2]=c[o>>2];c[l+4>>2]=n;l=d;c[l>>2]=f;c[l+4>>2]=h;m=+g[b>>2];j=+g[a>>2];if(!(m<j)){if(!(m==j)){o=1;i=e;return o|0}if(!((c[b+4>>2]|0)>>>0<(c[a+4>>2]|0)>>>0)){o=1;i=e;return o|0}}n=a;l=c[n>>2]|0;n=c[n+4>>2]|0;f=b;h=c[f+4>>2]|0;o=a;c[o>>2]=c[f>>2];c[o+4>>2]=h;o=b;c[o>>2]=l;c[o+4>>2]=n;o=2;i=e;return o|0}h=a;f=c[h>>2]|0;h=c[h+4>>2]|0;if(l){l=d;n=c[l+4>>2]|0;o=a;c[o>>2]=c[l>>2];c[o+4>>2]=n;o=d;c[o>>2]=f;c[o+4>>2]=h;o=1;i=e;return o|0}l=b;n=c[l+4>>2]|0;o=a;c[o>>2]=c[l>>2];c[o+4>>2]=n;o=b;c[o>>2]=f;c[o+4>>2]=h;m=+g[d>>2];j=(c[k>>2]=f,+g[k>>2]);if(!(m<j)){if(!(m==j)){o=1;i=e;return o|0}if(!((c[d+4>>2]|0)>>>0<h>>>0)){o=1;i=e;return o|0}}l=d;n=c[l+4>>2]|0;o=b;c[o>>2]=c[l>>2];c[o+4>>2]=n;o=d;c[o>>2]=f;c[o+4>>2]=h;o=2;i=e;return o|0}function cf(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,h=0,j=0,l=0,m=0,n=0,o=0,p=0.0,q=0,r=0,s=0,t=0,u=0.0,v=0.0,w=0,x=0,y=0;e=i;a:while(1){j=b;f=b+ -8|0;l=b+ -16|0;h=b+ -4|0;b:while(1){m=a;r=j-m|0;o=r>>3;switch(o|0){case 1:case 0:{j=91;break a};case 4:{j=9;break a};case 3:{j=8;break a};case 5:{j=19;break a};case 2:{j=4;break a};default:{}}if((r|0)<248){j=21;break a}q=(o|0)/2|0;n=a+(q<<3)|0;if((r|0)>7992){o=(o|0)/4|0;o=ef(a,a+(o<<3)|0,n,a+(o+q<<3)|0,f,0)|0}else{o=df(a,n,f,0)|0}p=+g[a>>2];u=+g[n>>2];c:do{if(p<u){q=f}else{if(p==u?(c[a+4>>2]|0)>>>0<(c[a+(q<<3)+4>>2]|0)>>>0:0){q=f;break}d:do{if((a|0)!=(l|0)){r=a+(q<<3)+4|0;q=l;s=f;while(1){v=+g[q>>2];if(v<u){break}if(v==u?(c[s+ -4>>2]|0)>>>0<(c[r>>2]|0)>>>0:0){break}s=q+ -8|0;if((a|0)==(s|0)){break d}else{t=q;q=s;s=t}}s=a;r=c[s>>2]|0;s=c[s+4>>2]|0;x=q;w=c[x+4>>2]|0;t=a;c[t>>2]=c[x>>2];c[t+4>>2]=w;t=q;c[t>>2]=r;c[t+4>>2]=s;o=o+1|0;break c}}while(0);o=a+8|0;u=+g[f>>2];do{if(!(p<u)){if(p==u?(c[a+4>>2]|0)>>>0<(c[h>>2]|0)>>>0:0){break}if((o|0)==(f|0)){j=91;break a}m=a+4|0;while(1){u=+g[o>>2];if(p<u){break}if(p==u?(c[m>>2]|0)>>>0<(c[o+4>>2]|0)>>>0:0){break}o=o+8|0;if((o|0)==(f|0)){j=91;break a}}w=o;t=c[w>>2]|0;w=c[w+4>>2]|0;r=f;s=c[r+4>>2]|0;x=o;c[x>>2]=c[r>>2];c[x+4>>2]=s;x=f;c[x>>2]=t;c[x+4>>2]=w;o=o+8|0}}while(0);if((o|0)==(f|0)){j=91;break a}m=a+4|0;n=f;while(1){p=+g[a>>2];u=+g[o>>2];e:do{if(!(p<u)){do{if(p==u?(c[m>>2]|0)>>>0<(c[o+4>>2]|0)>>>0:0){break e}o=o+8|0;u=+g[o>>2]}while(!(p<u))}}while(0);while(1){q=n;n=n+ -8|0;u=+g[n>>2];if(p<u){continue}if(!(p==u)){break}if(!((c[m>>2]|0)>>>0<(c[q+ -4>>2]|0)>>>0)){break}}if(!(o>>>0<n>>>0)){a=o;continue b}w=o;t=c[w>>2]|0;w=c[w+4>>2]|0;r=n;s=c[r+4>>2]|0;x=o;c[x>>2]=c[r>>2];c[x+4>>2]=s;x=n;c[x>>2]=t;c[x+4>>2]=w;o=o+8|0}}}while(0);r=a+8|0;f:do{if(r>>>0<q>>>0){t=r;while(1){p=+g[n>>2];s=n+4|0;r=t;while(1){u=+g[r>>2];if(!(u<p)){if(!(u==p)){break}if(!((c[r+4>>2]|0)>>>0<(c[s>>2]|0)>>>0)){break}}r=r+8|0}t=q+ -8|0;u=+g[t>>2];g:do{if(u<p){s=t}else{while(1){if(u==p?(c[q+ -4>>2]|0)>>>0<(c[s>>2]|0)>>>0:0){s=t;break g}q=t+ -8|0;u=+g[q>>2];if(u<p){s=q;break}else{x=t;t=q;q=x}}}}while(0);if(r>>>0>s>>>0){break f}q=r;x=c[q>>2]|0;q=c[q+4>>2]|0;y=s;w=c[y+4>>2]|0;t=r;c[t>>2]=c[y>>2];c[t+4>>2]=w;t=s;c[t>>2]=x;c[t+4>>2]=q;t=r+8|0;q=s;n=(n|0)==(r|0)?s:n;o=o+1|0}}}while(0);do{if((r|0)!=(n|0)){p=+g[n>>2];u=+g[r>>2];if(!(p<u)){if(!(p==u)){break}if(!((c[n+4>>2]|0)>>>0<(c[r+4>>2]|0)>>>0)){break}}x=r;w=c[x>>2]|0;x=c[x+4>>2]|0;s=n;t=c[s+4>>2]|0;y=r;c[y>>2]=c[s>>2];c[y+4>>2]=t;y=n;c[y>>2]=w;c[y+4>>2]=x;o=o+1|0}}while(0);if((o|0)==0){n=ff(a,r,0)|0;o=r+8|0;if(ff(o,b,0)|0){j=86;break}if(n){a=o;continue}}y=r;if((y-m|0)>=(j-y|0)){j=90;break}cf(a,r,d);a=r+8|0}if((j|0)==86){if(n){j=91;break}else{b=r;continue}}else if((j|0)==90){cf(r+8|0,b,d);b=r;continue}}if((j|0)==4){p=+g[f>>2];u=+g[a>>2];if(!(p<u)){if(!(p==u)){i=e;return}if(!((c[h>>2]|0)>>>0<(c[a+4>>2]|0)>>>0)){i=e;return}}x=a;w=c[x>>2]|0;x=c[x+4>>2]|0;s=f;t=c[s+4>>2]|0;y=a;c[y>>2]=c[s>>2];c[y+4>>2]=t;y=f;c[y>>2]=w;c[y+4>>2]=x;i=e;return}else if((j|0)==8){df(a,a+8|0,f,0)|0;i=e;return}else if((j|0)==9){b=a+8|0;d=a+16|0;df(a,b,d,0)|0;p=+g[f>>2];u=+g[d>>2];if(!(p<u)){if(!(p==u)){i=e;return}if(!((c[h>>2]|0)>>>0<(c[a+20>>2]|0)>>>0)){i=e;return}}x=d;w=c[x>>2]|0;x=c[x+4>>2]|0;s=f;t=c[s+4>>2]|0;y=d;c[y>>2]=c[s>>2];c[y+4>>2]=t;y=f;c[y>>2]=w;c[y+4>>2]=x;u=+g[d>>2];p=+g[b>>2];if(!(u<p)){if(!(u==p)){i=e;return}if(!((c[a+20>>2]|0)>>>0<(c[a+12>>2]|0)>>>0)){i=e;return}}x=b;w=c[x>>2]|0;x=c[x+4>>2]|0;f=d;h=c[f>>2]|0;f=c[f+4>>2]|0;y=b;c[y>>2]=h;c[y+4>>2]=f;y=d;c[y>>2]=w;c[y+4>>2]=x;u=(c[k>>2]=h,+g[k>>2]);p=+g[a>>2];if(!(u<p)){if(!(u==p)){i=e;return}if(!(f>>>0<(c[a+4>>2]|0)>>>0)){i=e;return}}x=a;w=c[x>>2]|0;x=c[x+4>>2]|0;y=a;c[y>>2]=h;c[y+4>>2]=f;y=b;c[y>>2]=w;c[y+4>>2]=x;i=e;return}else if((j|0)==19){ef(a,a+8|0,a+16|0,a+24|0,f,0)|0;i=e;return}else if((j|0)==21){l=a+16|0;df(a,a+8|0,l,0)|0;f=a+24|0;if((f|0)==(b|0)){i=e;return}while(1){u=+g[f>>2];p=+g[l>>2];if(!(u<p)){if(u==p?(c[f+4>>2]|0)>>>0<(c[l+4>>2]|0)>>>0:0){j=25}}else{j=25}if((j|0)==25){j=0;h=f;d=c[h>>2]|0;h=c[h+4>>2]|0;p=(c[k>>2]=d,+g[k>>2]);w=l;x=c[w+4>>2]|0;y=f;c[y>>2]=c[w>>2];c[y+4>>2]=x;h:do{if((l|0)!=(a|0)){m=l;while(1){l=m+ -8|0;u=+g[l>>2];if(!(p<u)){if(!(p==u)){l=m;break h}if(!(h>>>0<(c[m+ -4>>2]|0)>>>0)){l=m;break h}}w=l;x=c[w+4>>2]|0;y=m;c[y>>2]=c[w>>2];c[y+4>>2]=x;if((l|0)==(a|0)){break}else{m=l}}}}while(0);y=l;c[y>>2]=d;c[y+4>>2]=h}h=f+8|0;if((h|0)==(b|0)){break}else{l=f;f=h}}i=e;return}else if((j|0)==91){i=e;return}}function df(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0.0,l=0,m=0.0,n=0,o=0;e=i;j=+g[b>>2];m=+g[a>>2];if(!(j<m)){if(j==m){f=(c[b+4>>2]|0)>>>0<(c[a+4>>2]|0)>>>0}else{f=0}}else{f=1}m=+g[d>>2];if(!(m<j)){if(m==j){l=(c[d+4>>2]|0)>>>0<(c[b+4>>2]|0)>>>0}else{l=0}}else{l=1}if(!f){if(!l){l=0;i=e;return l|0}h=b;f=c[h>>2]|0;h=c[h+4>>2]|0;o=d;n=c[o+4>>2]|0;l=b;c[l>>2]=c[o>>2];c[l+4>>2]=n;l=d;c[l>>2]=f;c[l+4>>2]=h;m=+g[b>>2];j=+g[a>>2];if(!(m<j)){if(!(m==j)){o=1;i=e;return o|0}if(!((c[b+4>>2]|0)>>>0<(c[a+4>>2]|0)>>>0)){o=1;i=e;return o|0}}n=a;l=c[n>>2]|0;n=c[n+4>>2]|0;f=b;h=c[f+4>>2]|0;o=a;c[o>>2]=c[f>>2];c[o+4>>2]=h;o=b;c[o>>2]=l;c[o+4>>2]=n;o=2;i=e;return o|0}h=a;f=c[h>>2]|0;h=c[h+4>>2]|0;if(l){l=d;n=c[l+4>>2]|0;o=a;c[o>>2]=c[l>>2];c[o+4>>2]=n;o=d;c[o>>2]=f;c[o+4>>2]=h;o=1;i=e;return o|0}l=b;n=c[l+4>>2]|0;o=a;c[o>>2]=c[l>>2];c[o+4>>2]=n;o=b;c[o>>2]=f;c[o+4>>2]=h;m=+g[d>>2];j=(c[k>>2]=f,+g[k>>2]);if(!(m<j)){if(!(m==j)){o=1;i=e;return o|0}if(!((c[d+4>>2]|0)>>>0<h>>>0)){o=1;i=e;return o|0}}l=d;n=c[l+4>>2]|0;o=b;c[o>>2]=c[l>>2];c[o+4>>2]=n;o=d;c[o>>2]=f;c[o+4>>2]=h;o=2;i=e;return o|0}function ef(a,b,d,e,f,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var j=0,k=0,l=0.0,m=0.0,n=0,o=0,p=0,q=0;h=i;j=df(a,b,d,0)|0;m=+g[e>>2];l=+g[d>>2];if(!(m<l)){if(m==l?(c[e+4>>2]|0)>>>0<(c[d+4>>2]|0)>>>0:0){k=4}}else{k=4}do{if((k|0)==4){n=d;o=c[n>>2]|0;n=c[n+4>>2]|0;q=e;p=c[q+4>>2]|0;k=d;c[k>>2]=c[q>>2];c[k+4>>2]=p;k=e;c[k>>2]=o;c[k+4>>2]=n;k=j+1|0;m=+g[d>>2];l=+g[b>>2];if(!(m<l)){if(!(m==l)){j=k;break}if(!((c[d+4>>2]|0)>>>0<(c[b+4>>2]|0)>>>0)){j=k;break}}q=b;p=c[q>>2]|0;q=c[q+4>>2]|0;n=d;o=c[n+4>>2]|0;k=b;c[k>>2]=c[n>>2];c[k+4>>2]=o;k=d;c[k>>2]=p;c[k+4>>2]=q;k=j+2|0;l=+g[b>>2];m=+g[a>>2];if(!(l<m)){if(!(l==m)){j=k;break}if(!((c[b+4>>2]|0)>>>0<(c[a+4>>2]|0)>>>0)){j=k;break}}p=a;o=c[p>>2]|0;p=c[p+4>>2]|0;k=b;n=c[k+4>>2]|0;q=a;c[q>>2]=c[k>>2];c[q+4>>2]=n;q=b;c[q>>2]=o;c[q+4>>2]=p;j=j+3|0}}while(0);l=+g[f>>2];m=+g[e>>2];if(!(l<m)){if(!(l==m)){q=j;i=h;return q|0}if(!((c[f+4>>2]|0)>>>0<(c[e+4>>2]|0)>>>0)){q=j;i=h;return q|0}}q=e;p=c[q>>2]|0;q=c[q+4>>2]|0;k=f;n=c[k+4>>2]|0;o=e;c[o>>2]=c[k>>2];c[o+4>>2]=n;c[f>>2]=p;c[f+4>>2]=q;f=j+1|0;m=+g[e>>2];l=+g[d>>2];if(!(m<l)){if(!(m==l)){q=f;i=h;return q|0}if(!((c[e+4>>2]|0)>>>0<(c[d+4>>2]|0)>>>0)){q=f;i=h;return q|0}}q=d;p=c[q>>2]|0;q=c[q+4>>2]|0;k=e;n=c[k+4>>2]|0;o=d;c[o>>2]=c[k>>2];c[o+4>>2]=n;c[e>>2]=p;c[e+4>>2]=q;e=j+2|0;l=+g[d>>2];m=+g[b>>2];if(!(l<m)){if(!(l==m)){q=e;i=h;return q|0}if(!((c[d+4>>2]|0)>>>0<(c[b+4>>2]|0)>>>0)){q=e;i=h;return q|0}}q=b;p=c[q>>2]|0;q=c[q+4>>2]|0;k=d;n=c[k+4>>2]|0;o=b;c[o>>2]=c[k>>2];c[o+4>>2]=n;c[d>>2]=p;c[d+4>>2]=q;d=j+3|0;m=+g[b>>2];l=+g[a>>2];if(!(m<l)){if(!(m==l)){q=d;i=h;return q|0}if(!((c[b+4>>2]|0)>>>0<(c[a+4>>2]|0)>>>0)){q=d;i=h;return q|0}}p=a;o=c[p>>2]|0;p=c[p+4>>2]|0;k=b;n=c[k+4>>2]|0;q=a;c[q>>2]=c[k>>2];c[q+4>>2]=n;q=b;c[q>>2]=o;c[q+4>>2]=p;q=j+4|0;i=h;return q|0}function ff(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,h=0,j=0,l=0,m=0.0,n=0,o=0,p=0.0,q=0,r=0,s=0;d=i;switch(b-a>>3|0){case 2:{e=b+ -8|0;m=+g[e>>2];p=+g[a>>2];if(!(m<p)){if(!(m==p)){o=1;i=d;return o|0}if(!((c[b+ -4>>2]|0)>>>0<(c[a+4>>2]|0)>>>0)){o=1;i=d;return o|0}}n=a;l=c[n>>2]|0;n=c[n+4>>2]|0;h=e;j=c[h+4>>2]|0;o=a;c[o>>2]=c[h>>2];c[o+4>>2]=j;o=e;c[o>>2]=l;c[o+4>>2]=n;o=1;i=d;return o|0};case 5:{ef(a,a+8|0,a+16|0,a+24|0,b+ -8|0,0)|0;o=1;i=d;return o|0};case 4:{e=a+8|0;f=a+16|0;h=b+ -8|0;df(a,e,f,0)|0;m=+g[h>>2];p=+g[f>>2];if(!(m<p)){if(!(m==p)){o=1;i=d;return o|0}if(!((c[b+ -4>>2]|0)>>>0<(c[a+20>>2]|0)>>>0)){o=1;i=d;return o|0}}n=f;l=c[n>>2]|0;n=c[n+4>>2]|0;b=h;j=c[b+4>>2]|0;o=f;c[o>>2]=c[b>>2];c[o+4>>2]=j;o=h;c[o>>2]=l;c[o+4>>2]=n;m=+g[f>>2];p=+g[e>>2];if(!(m<p)){if(!(m==p)){o=1;i=d;return o|0}if(!((c[a+20>>2]|0)>>>0<(c[a+12>>2]|0)>>>0)){o=1;i=d;return o|0}}n=e;l=c[n>>2]|0;n=c[n+4>>2]|0;b=f;h=c[b>>2]|0;b=c[b+4>>2]|0;o=e;c[o>>2]=h;c[o+4>>2]=b;o=f;c[o>>2]=l;c[o+4>>2]=n;m=(c[k>>2]=h,+g[k>>2]);p=+g[a>>2];if(!(m<p)){if(!(m==p)){o=1;i=d;return o|0}if(!(b>>>0<(c[a+4>>2]|0)>>>0)){o=1;i=d;return o|0}}n=a;l=c[n>>2]|0;n=c[n+4>>2]|0;o=a;c[o>>2]=h;c[o+4>>2]=b;o=e;c[o>>2]=l;c[o+4>>2]=n;o=1;i=d;return o|0};case 3:{df(a,a+8|0,b+ -8|0,0)|0;o=1;i=d;return o|0};case 1:case 0:{o=1;i=d;return o|0};default:{n=a+16|0;df(a,a+8|0,n,0)|0;f=a+24|0;if((f|0)==(b|0)){o=1;i=d;return o|0}else{h=0}while(1){m=+g[f>>2];p=+g[n>>2];if(!(m<p)){if(m==p?(c[f+4>>2]|0)>>>0<(c[n+4>>2]|0)>>>0:0){e=22}}else{e=22}if((e|0)==22){e=0;l=f;j=c[l>>2]|0;l=c[l+4>>2]|0;m=(c[k>>2]=j,+g[k>>2]);r=n;q=c[r+4>>2]|0;o=f;c[o>>2]=c[r>>2];c[o+4>>2]=q;a:do{if((n|0)!=(a|0)){while(1){o=n+ -8|0;p=+g[o>>2];if(!(m<p)){if(!(m==p)){break a}if(!(l>>>0<(c[n+ -4>>2]|0)>>>0)){break a}}s=o;q=c[s+4>>2]|0;r=n;c[r>>2]=c[s>>2];c[r+4>>2]=q;if((o|0)==(a|0)){n=o;break}else{n=o}}}}while(0);s=n;c[s>>2]=j;c[s+4>>2]=l;h=h+1|0;if((h|0)==8){break}}j=f+8|0;if((j|0)==(b|0)){a=1;e=30;break}else{n=f;f=j}}if((e|0)==30){i=d;return a|0}s=(f+8|0)==(b|0);i=d;return s|0}}return 0}function gf(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0;d=i;i=i+16|0;e=d;c[b>>2]=a;lf(a,b);f=b+4|0;zb(a+100|0,4,1,c[f>>2]|0)|0;zb(a+104|0,4,1,c[f>>2]|0)|0;zb(a+108|0,4,1,c[f>>2]|0)|0;g=a+116|0;h=a+112|0;c[e>>2]=(c[g>>2]|0)-(c[h>>2]|0)>>2;zb(e|0,4,1,c[f>>2]|0)|0;k=c[h>>2]|0;if((c[g>>2]|0)!=(k|0)){j=0;do{zb(k+(j<<2)|0,4,1,c[f>>2]|0)|0;j=j+1|0;k=c[h>>2]|0}while(j>>>0<(c[g>>2]|0)-k>>2>>>0)}g=a+92|0;a=a+88|0;c[e>>2]=((c[g>>2]|0)-(c[a>>2]|0)|0)/60|0;zb(e|0,4,1,c[f>>2]|0)|0;e=c[a>>2]|0;if((c[g>>2]|0)==(e|0)){i=d;return}else{f=0}do{hf(e+(f*60|0)|0,b);f=f+1|0;e=c[a>>2]|0}while(f>>>0<(((c[g>>2]|0)-e|0)/60|0)>>>0);i=d;return}function hf(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0;e=i;i=i+16|0;f=e+4|0;j=e;g=a+24|0;c[j>>2]=c[g>>2];d=b+4|0;zb(j|0,4,1,c[d>>2]|0)|0;zb(a+44|0,4,1,c[d>>2]|0)|0;j=a+52|0;h=a+48|0;c[f>>2]=(c[j>>2]|0)-(c[h>>2]|0)>>2;zb(f|0,4,1,c[d>>2]|0)|0;l=c[h>>2]|0;if((c[j>>2]|0)!=(l|0)){k=0;do{zb(l+(k<<2)|0,4,1,c[d>>2]|0)|0;k=k+1|0;l=c[h>>2]|0}while(k>>>0<(c[j>>2]|0)-l>>2>>>0)}h=c[g>>2]|0;if((h|0)==0){kf(b,a);h=c[g>>2]|0}if(!((h+ -1|0)>>>0<2)){i=e;return}jf(b,a+12|0);if((c[g>>2]|0)!=1){i=e;return}zb(a+40|0,4,1,c[d>>2]|0)|0;g=a+32|0;a=a+28|0;c[f>>2]=(c[g>>2]|0)-(c[a>>2]|0)>>2;zb(f|0,4,1,c[d>>2]|0)|0;f=c[a>>2]|0;if((c[g>>2]|0)==(f|0)){i=e;return}else{b=0}do{zb(f+(b<<2)|0,4,1,c[d>>2]|0)|0;b=b+1|0;f=c[a>>2]|0}while(b>>>0<(c[g>>2]|0)-f>>2>>>0);i=e;return}function jf(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0;e=i;i=i+16|0;d=e+4|0;f=e;c[f>>2]=c[b+8>>2];a=a+4|0;zb(f|0,4,1,c[a>>2]|0)|0;f=c[b>>2]|0;b=b+4|0;if((f|0)==(b|0)){i=e;return}do{zb(f+16|0,4,1,c[a>>2]|0)|0;g=f+24|0;h=f+20|0;c[d>>2]=(c[g>>2]|0)-(c[h>>2]|0)>>2;zb(d|0,4,1,c[a>>2]|0)|0;k=c[h>>2]|0;if((c[g>>2]|0)!=(k|0)){j=0;do{zb(k+(j<<2)|0,4,1,c[a>>2]|0)|0;j=j+1|0;k=c[h>>2]|0}while(j>>>0<(c[g>>2]|0)-k>>2>>>0)}g=c[f+4>>2]|0;if((g|0)==0){while(1){g=c[f+8>>2]|0;if((c[g>>2]|0)==(f|0)){f=g;break}else{f=g}}}else{f=g;while(1){g=c[f>>2]|0;if((g|0)==0){break}else{f=g}}}}while((f|0)!=(b|0));i=e;return}function kf(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0;f=i;i=i+16|0;e=f+4|0;j=f;d=b+4|0;c[j>>2]=((c[d>>2]|0)-(c[b>>2]|0)|0)/12|0;a=a+4|0;zb(j|0,4,1,c[a>>2]|0)|0;j=c[b>>2]|0;if((c[d>>2]|0)==(j|0)){i=f;return}h=0;do{g=j+(h*12|0)+4|0;j=j+(h*12|0)|0;c[e>>2]=(c[g>>2]|0)-(c[j>>2]|0)>>2;zb(e|0,4,1,c[a>>2]|0)|0;l=c[j>>2]|0;if((c[g>>2]|0)!=(l|0)){k=0;do{zb(l+(k<<2)|0,4,1,c[a>>2]|0)|0;k=k+1|0;l=c[j>>2]|0}while(k>>>0<(c[g>>2]|0)-l>>2>>>0)}h=h+1|0;j=c[b>>2]|0}while(h>>>0<(((c[d>>2]|0)-j|0)/12|0)>>>0);i=f;return}function lf(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;e=i;i=i+80|0;f=e+64|0;m=e+12|0;j=e;k=e+68|0;c[m+0>>2]=0;c[m+4>>2]=0;c[m+8>>2]=0;c[m+12>>2]=0;l=m+0|0;o=1816|0;n=l+12|0;do{a[l>>0]=a[o>>0]|0;l=l+1|0;o=o+1|0}while((l|0)<(n|0));n=m+16|0;c[n+0>>2]=0;c[n+4>>2]=0;c[n+8>>2]=0;c[n+12>>2]=0;a[n+0>>0]=a[1832>>0]|0;a[n+1>>0]=a[1833>>0]|0;a[n+2>>0]=a[1834>>0]|0;a[n+3>>0]=a[1835>>0]|0;a[n+4>>0]=a[1836>>0]|0;a[n+5>>0]=a[1837>>0]|0;o=m+32|0;c[o>>2]=8;g=Bc[c[(c[b>>2]|0)+16>>2]&255](b)|0;l=m+36|0;c[l>>2]=g;g=b+12|0;p=m+44|0;c[p>>2]=c[g>>2];h=b+20|0;q=m+48|0;c[q>>2]=c[h>>2];d=d+4|0;zb(m|0,16,1,c[d>>2]|0)|0;zb(n|0,16,1,c[d>>2]|0)|0;c[f>>2]=c[o>>2];zb(f|0,4,1,c[d>>2]|0)|0;c[f>>2]=c[l>>2];zb(f|0,4,1,c[d>>2]|0)|0;zb(p|0,4,1,c[d>>2]|0)|0;zb(q|0,4,1,c[d>>2]|0)|0;zb(g|0,4,1,c[d>>2]|0)|0;zb(h|0,4,1,c[d>>2]|0)|0;zb(b+16|0,4,1,c[d>>2]|0)|0;q=b+24|0;p=Fv(16)|0;m=j+8|0;c[m>>2]=p;c[j>>2]=17;c[j+4>>2]=12;l=p+0|0;o=1624|0;n=l+12|0;do{a[l>>0]=a[o>>0]|0;l=l+1|0;o=o+1|0}while((l|0)<(n|0));a[p+12>>0]=0;a[k>>0]=0;u=0;k=ua(27,q|0,j|0,k|0)|0;q=u;u=0;if(q&1){b=qb(-1,-1)|0;if((a[j>>0]&1)==0){q=b;vb(q|0)}Hv(c[m>>2]|0);q=b;vb(q|0)}if(!((a[j>>0]&1)==0)){Hv(c[m>>2]|0)}pc(k&1|0,c[d>>2]|0)|0;if(k){if((c[g>>2]|0)!=0){j=b+72|0;k=0;do{zb(c[(c[j>>2]|0)+(k<<2)>>2]|0,c[h>>2]<<2|0,1,c[d>>2]|0)|0;k=k+1|0}while(k>>>0<(c[g>>2]|0)>>>0)}}else{if(((c[b+76>>2]|0)-(c[b+72>>2]|0)>>2|0)!=(c[g>>2]|0)){b=Jb(8)|0;u=0;oa(75,b|0,1640);q=u;u=0;if(!(q&1)){c[b>>2]=288;qc(b|0,264,1)}q=qb(-1,-1)|0;pb(b|0);vb(q|0)}}zb(b+8|0,4,1,c[d>>2]|0)|0;h=b+64|0;g=b+60|0;c[f>>2]=(c[h>>2]|0)-(c[g>>2]|0)>>2;zb(f|0,4,1,c[d>>2]|0)|0;k=c[g>>2]|0;if((c[h>>2]|0)!=(k|0)){j=0;do{zb(k+(j<<2)|0,4,1,c[d>>2]|0)|0;j=j+1|0;k=c[g>>2]|0}while(j>>>0<(c[h>>2]|0)-k>>2>>>0)}q=b+36|0;pc(a[q>>0]|0,c[d>>2]|0)|0;if((a[q>>0]|0)==0){p=b+56|0;q=c[d>>2]|0;zb(p|0,4,1,q|0)|0;i=e;return}zb(b+52|0,4,1,c[d>>2]|0)|0;g=b+44|0;h=b+40|0;c[f>>2]=(c[g>>2]|0)-(c[h>>2]|0)>>2;zb(f|0,4,1,c[d>>2]|0)|0;f=c[h>>2]|0;if((c[g>>2]|0)==(f|0)){p=b+56|0;q=c[d>>2]|0;zb(p|0,4,1,q|0)|0;i=e;return}else{j=0}do{zb(f+(j<<2)|0,4,1,c[d>>2]|0)|0;j=j+1|0;f=c[h>>2]|0}while(j>>>0<(c[g>>2]|0)-f>>2>>>0);p=b+56|0;q=c[d>>2]|0;zb(p|0,4,1,q|0)|0;i=e;return}function mf(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0;f=i;i=i+16|0;g=f+4|0;h=f;pf(h,b,d);d=c[h>>2]|0;if((d|0)==(b+4|0)){h=e;h=a[h>>0]|0;h=h<<24>>24!=0;i=f;return h|0}e=d+28|0;h=c[e>>2]|0;h=(Bc[c[(c[h>>2]|0)+24>>2]&255](h)|0)+4|0;if((c[h>>2]|0)==(c[24580>>2]|0)){c[g>>2]=c[d+32>>2];h=c[e>>2]|0;h=Sc[c[(c[h>>2]|0)+16>>2]&63](h,g)|0;h=a[h>>0]|0;h=h<<24>>24!=0;i=f;return h|0}f=Jb(8)|0;u=0;oa(75,f|0,1760);h=u;u=0;if(h&1){h=qb(-1,-1)|0;pb(f|0);vb(h|0)}else{c[f>>2]=1800;qc(f|0,1744,22)}return 0}function nf(a){a=a|0;var b=0;b=i;ym(a);i=b;return}function of(a){a=a|0;var b=0;b=i;ym(a);Hv(a);i=b;return}function pf(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;f=i;m=c[d+4>>2]|0;d=d+4|0;if((m|0)!=0){k=a[e>>0]|0;j=(k&1)==0;k=(k&255)>>>1;g=e+1|0;h=e+8|0;e=e+4|0;l=d;n=m;a:while(1){m=n;while(1){p=m+16|0;n=a[p>>0]|0;q=(n&1)==0;if(q){n=(n&255)>>>1}else{n=c[m+20>>2]|0}if(j){o=k}else{o=c[e>>2]|0}if(q){q=p+1|0}else{q=c[m+24>>2]|0}if(j){r=g}else{r=c[h>>2]|0}p=o>>>0<n>>>0;q=kw(q,r,p?o:n)|0;if((q|0)==0){q=n>>>0<o>>>0?-1:p&1}if((q|0)>=0){break}m=c[m+4>>2]|0;if((m|0)==0){break a}}n=c[m>>2]|0;if((n|0)==0){l=m;break}else{l=m}}if((l|0)!=(d|0)){m=l+16|0;if(!j){k=c[e>>2]|0}e=a[m>>0]|0;n=(e&1)==0;if(n){e=(e&255)>>>1}else{e=c[l+20>>2]|0}if(!j){g=c[h>>2]|0}if(n){j=m+1|0}else{j=c[l+24>>2]|0}h=e>>>0<k>>>0;g=kw(g,j,h?e:k)|0;if((g|0)==0){g=k>>>0<e>>>0?-1:h&1}if((g|0)>=0){c[b>>2]=l;i=f;return}}}c[b>>2]=d;i=f;return}function qf(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0;g=i;i=i+128|0;j=g+112|0;h=g+100|0;p=g+96|0;o=g+84|0;w=g+80|0;v=g+68|0;E=g+64|0;D=g+52|0;y=g+40|0;C=g+36|0;q=g+24|0;l=g+12|0;e=g;c[d>>2]=b;Vf(b,d);s=b+100|0;k=d+4|0;if((Sa(s|0,4,1,c[k>>2]|0)|0)!=1){e=Jb(8)|0;u=0;oa(75,e|0,2592);H=u;u=0;if(H&1){H=qb(-1,-1)|0;pb(e|0);vb(H|0)}else{c[e>>2]=288;qc(e|0,264,1)}}m=b+104|0;if((Sa(m|0,4,1,c[k>>2]|0)|0)!=1){e=Jb(8)|0;u=0;oa(75,e|0,2592);H=u;u=0;if(H&1){H=qb(-1,-1)|0;pb(e|0);vb(H|0)}else{c[e>>2]=288;qc(e|0,264,1)}}f=b+108|0;if((Sa(f|0,4,1,c[k>>2]|0)|0)!=1){e=Jb(8)|0;u=0;oa(75,e|0,2592);H=u;u=0;if(H&1){H=qb(-1,-1)|0;pb(e|0);vb(H|0)}else{c[e>>2]=288;qc(e|0,264,1)}}Uf(d,b+112|0);Rf(d,b+88|0);k=b+24|0;a[y>>0]=18;H=y+1|0;G=320|0;d=H+9|0;do{a[H>>0]=a[G>>0]|0;H=H+1|0;G=G+1|0}while((H|0)<(d|0));a[y+10>>0]=0;d=Pf(k,E,y)|0;G=c[d>>2]|0;if((G|0)==0){u=0;Na(43,D|0,k|0,y|0);H=u;u=0;if(!(H&1)){F=c[D>>2]|0;c[D>>2]=0;n=c[E>>2]|0;c[F>>2]=0;c[F+4>>2]=0;c[F+8>>2]=n;c[d>>2]=F;n=c[c[k>>2]>>2]|0;if((n|0)==0){n=F}else{c[k>>2]=n;n=c[d>>2]|0}ge(c[b+28>>2]|0,n);n=b+32|0;c[n>>2]=(c[n>>2]|0)+1;n=18}}else{F=G;n=18}if(((n|0)==18?(u=0,A=qa(c[(c[b>>2]|0)+16>>2]|0,b|0)|0,H=u,u=0,!(H&1)):0)?(c[C>>2]=A,B=F+28|0,H=c[B>>2]|0,z=F+32|0,u=0,oa(c[c[H>>2]>>2]|0,H|0,z|0),H=u,u=0,!(H&1)):0){if((a[2072]|0)==0?(Ua(2072)|0)!=0:0){c[516]=2088;rb(2072)}c[B>>2]=2064;if((a[2336]|0)==0?(Ua(2336)|0)!=0:0){c[582]=2352;rb(2336)}c[B>>2]=2328;u=0;Na(c[(c[582]|0)+4>>2]|0,2328,C|0,z|0);H=u;u=0;if(!(H&1)){if(!((a[y>>0]&1)==0)){Hv(c[y+8>>2]|0)}z=Fv(16)|0;y=q+8|0;c[y>>2]=z;c[q>>2]=17;c[q+4>>2]=12;H=z+0|0;G=528|0;d=H+12|0;do{a[H>>0]=a[G>>0]|0;H=H+1|0;G=G+1|0}while((H|0)<(d|0));a[z+12>>0]=0;z=Pf(k,w,q)|0;A=c[z>>2]|0;if((A|0)==0){u=0;Na(43,v|0,k|0,q|0);H=u;u=0;if(!(H&1)){x=c[v>>2]|0;c[v>>2]=0;n=c[w>>2]|0;c[x>>2]=0;c[x+4>>2]=0;c[x+8>>2]=n;c[z>>2]=x;n=c[c[k>>2]>>2]|0;if((n|0)==0){n=x}else{c[k>>2]=n;n=c[z>>2]|0}ge(c[b+28>>2]|0,n);n=b+32|0;c[n>>2]=(c[n>>2]|0)+1;n=34}}else{x=A;n=34}if((n|0)==34?(t=x+28|0,H=c[t>>2]|0,r=x+32|0,u=0,oa(c[c[H>>2]>>2]|0,H|0,r|0),H=u,u=0,!(H&1)):0){if((a[2072]|0)==0?(Ua(2072)|0)!=0:0){c[516]=2088;rb(2072)}c[t>>2]=2064;if((a[1848]|0)==0?(Ua(1848)|0)!=0:0){c[460]=1864;rb(1848)}c[t>>2]=1840;u=0;Na(c[(c[460]|0)+4>>2]|0,1840,s|0,r|0);H=u;u=0;if(!(H&1)){if(!((a[q>>0]&1)==0)){Hv(c[y>>2]|0)}a[l>>0]=16;q=l+1|0;r=q;a[r>>0]=1601791339;a[r+1>>0]=6256997;a[r+2>>0]=24441;a[r+3>>0]=95;q=q+4|0;a[q>>0]=1702521203;a[q+1>>0]=6650473;a[q+2>>0]=25978;a[q+3>>0]=101;a[l+9>>0]=0;q=Pf(k,p,l)|0;r=c[q>>2]|0;do{if((r|0)==0){u=0;Na(43,o|0,k|0,l|0);H=u;u=0;if(H&1){break}n=c[o>>2]|0;c[o>>2]=0;o=c[p>>2]|0;c[n>>2]=0;c[n+4>>2]=0;c[n+8>>2]=o;c[q>>2]=n;o=c[c[k>>2]>>2]|0;if((o|0)==0){o=n}else{c[k>>2]=o;o=c[q>>2]|0}ge(c[b+28>>2]|0,o);r=b+32|0;c[r>>2]=(c[r>>2]|0)+1;r=n;n=49}else{n=49}}while(0);do{if((n|0)==49){o=r+28|0;H=c[o>>2]|0;p=r+32|0;u=0;oa(c[c[H>>2]>>2]|0,H|0,p|0);H=u;u=0;if(H&1){break}do{if((a[2072]|0)==0){if((Ua(2072)|0)==0){break}c[516]=2088;rb(2072)}}while(0);c[o>>2]=2064;do{if((a[1848]|0)==0){if((Ua(1848)|0)==0){break}c[460]=1864;rb(1848)}}while(0);c[o>>2]=1840;u=0;Na(c[(c[460]|0)+4>>2]|0,1840,m|0,p|0);H=u;u=0;if(H&1){break}if(!((a[l>>0]&1)==0)){Hv(c[l+8>>2]|0)}m=Fv(32)|0;l=e+8|0;c[l>>2]=m;c[e>>2]=33;c[e+4>>2]=17;H=m+0|0;G=544|0;d=H+17|0;do{a[H>>0]=a[G>>0]|0;H=H+1|0;G=G+1|0}while((H|0)<(d|0));a[m+17>>0]=0;m=Pf(k,j,e)|0;o=c[m>>2]|0;do{if((o|0)==0){u=0;Na(43,h|0,k|0,e|0);H=u;u=0;if(H&1){break}n=c[h>>2]|0;c[h>>2]=0;h=c[j>>2]|0;c[n>>2]=0;c[n+4>>2]=0;c[n+8>>2]=h;c[m>>2]=n;h=c[c[k>>2]>>2]|0;if((h|0)==0){h=n}else{c[k>>2]=h;h=c[m>>2]|0}ge(c[b+28>>2]|0,h);o=b+32|0;c[o>>2]=(c[o>>2]|0)+1;o=n;n=64}else{n=64}}while(0);do{if((n|0)==64){b=o+28|0;H=c[b>>2]|0;h=o+32|0;u=0;oa(c[c[H>>2]>>2]|0,H|0,h|0);H=u;u=0;if(H&1){break}do{if((a[2072]|0)==0){if((Ua(2072)|0)==0){break}c[516]=2088;rb(2072)}}while(0);c[b>>2]=2064;do{if((a[1848]|0)==0){if((Ua(1848)|0)==0){break}c[460]=1864;rb(1848)}}while(0);c[b>>2]=1840;u=0;Na(c[(c[460]|0)+4>>2]|0,1840,f|0,h|0);H=u;u=0;if(H&1){break}if((a[e>>0]&1)==0){i=g;return}Hv(c[l>>2]|0);i=g;return}}while(0);f=qb(-1,-1)|0;if((a[e>>0]&1)==0){H=f;vb(H|0)}Hv(c[l>>2]|0);H=f;vb(H|0)}}while(0);e=qb(-1,-1)|0;if((a[l>>0]&1)==0){H=e;vb(H|0)}Hv(c[l+8>>2]|0);H=e;vb(H|0)}}e=qb(-1,-1)|0;if((a[q>>0]&1)==0){H=e;vb(H|0)}Hv(c[y>>2]|0);H=e;vb(H|0)}}e=qb(-1,-1)|0;if((a[y>>0]&1)==0){H=e;vb(H|0)}Hv(c[y+8>>2]|0);H=e;vb(H|0)}function rf(a,b){a=a|0;b=b|0;return}function sf(a,b,d){a=a|0;b=b|0;d=d|0;if((d|0)!=0){c[d>>2]=c[b>>2]}return}function tf(a,b,d){a=a|0;b=b|0;d=d|0;c[d>>2]=c[b>>2];return}function uf(a,b,d){a=a|0;b=b|0;d=d|0;c[d>>2]=c[b>>2];return}function vf(a,b){a=a|0;b=b|0;return b|0}function wf(a){a=a|0;return 4}function xf(a){a=a|0;return 24608}function yf(a,b,d){a=a|0;b=b|0;d=d|0;a=i;jo(b,c[d>>2]|0)|0;i=a;return}function zf(a,b){a=a|0;b=b|0;var d=0;a=i;d=c[b>>2]|0;if((d|0)!=0){Hv(d)}c[b>>2]=0;i=a;return}function Af(a,b,d){a=a|0;b=b|0;d=d|0;b=i;a=Fv(1)|0;c[d>>2]=a;i=b;return}function Bf(a,b,d){a=a|0;b=b|0;d=d|0;b=i;a=Fv(1)|0;c[d>>2]=a;i=b;return}function Cf(a,b,c){a=a|0;b=b|0;c=c|0;return}function Df(a,b){a=a|0;b=b|0;return c[b>>2]|0}function Ef(a){a=a|0;return 1}function Ff(a){a=a|0;return 2320}function Gf(a,b,c){a=a|0;b=b|0;c=c|0;c=i;he(b,2272)|0;i=c;return}function Hf(a,b){a=a|0;b=b|0;return}function If(a,b,d){a=a|0;b=b|0;d=d|0;if((d|0)!=0){c[d>>2]=c[b>>2]}return}function Jf(a,b,d){a=a|0;b=b|0;d=d|0;c[d>>2]=c[b>>2];return}function Kf(a,b,d){a=a|0;b=b|0;d=d|0;c[d>>2]=c[b>>2];return}function Lf(a,b){a=a|0;b=b|0;return b|0}function Mf(a){a=a|0;return 4}function Nf(a){a=a|0;return 2584}function Of(a,b,d){a=a|0;b=b|0;d=d|0;a=i;io(b,c[d>>2]|0)|0;i=a;return}function Pf(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0;f=i;g=c[b+4>>2]|0;if((g|0)==0){o=b+4|0;c[d>>2]=o;i=f;return o|0}o=a[e>>0]|0;h=(o&255)>>>1;j=e+1|0;b=e+8|0;e=e+4|0;a:do{if((o&1)==0){while(1){b=g+16|0;e=a[b>>0]|0;k=(e&1)==0;if(k){m=(e&255)>>>1;n=b+1|0}else{m=c[g+20>>2]|0;n=c[g+24>>2]|0}l=m>>>0<h>>>0;n=kw(j,n,l?m:h)|0;if((n|0)==0){n=h>>>0<m>>>0?-1:l&1}if((n|0)<0){b=c[g>>2]|0;if((b|0)==0){e=g;b=24;break}else{g=b;continue}}if(k){e=(e&255)>>>1;k=b+1|0}else{e=c[g+20>>2]|0;k=c[g+24>>2]|0}b=h>>>0<e>>>0;k=kw(k,j,b?h:e)|0;if((k|0)==0){k=e>>>0<h>>>0?-1:b&1}if((k|0)>=0){b=33;break a}e=g+4|0;b=c[e>>2]|0;if((b|0)==0){b=32;break}else{g=b}}}else{while(1){h=g+16|0;m=c[e>>2]|0;k=a[h>>0]|0;j=(k&1)==0;if(j){l=(k&255)>>>1;o=h+1|0}else{l=c[g+20>>2]|0;o=c[g+24>>2]|0}n=l>>>0<m>>>0;o=kw(c[b>>2]|0,o,n?l:m)|0;if((o|0)==0){o=m>>>0<l>>>0?-1:n&1}if((o|0)<0){h=c[g>>2]|0;if((h|0)==0){e=g;b=24;break}else{g=h;continue}}if(j){j=(k&255)>>>1;l=h+1|0}else{j=c[g+20>>2]|0;l=c[g+24>>2]|0}k=c[e>>2]|0;h=k>>>0<j>>>0;l=kw(l,c[b>>2]|0,h?k:j)|0;if((l|0)==0){l=j>>>0<k>>>0?-1:h&1}if((l|0)>=0){b=33;break a}h=g+4|0;j=c[h>>2]|0;if((j|0)==0){e=h;b=32;break}else{g=j}}}}while(0);if((b|0)==24){c[d>>2]=g;o=e;i=f;return o|0}else if((b|0)==32){c[d>>2]=g;o=e;i=f;return o|0}else if((b|0)==33){c[d>>2]=g;o=d;i=f;return o|0}return 0}function Qf(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0;g=i;f=Fv(36)|0;d=d+4|0;j=f+16|0;a:do{if((a[e>>0]&1)==0){c[j+0>>2]=c[e+0>>2];c[j+4>>2]=c[e+4>>2];c[j+8>>2]=c[e+8>>2]}else{h=c[e+8>>2]|0;e=c[e+4>>2]|0;do{if(e>>>0>4294967279){u=0;na(183,0);l=u;u=0}else{if(e>>>0<11){a[j>>0]=e<<1;k=f+17|0}else{l=e+16&-16;u=0;k=qa(119,l|0)|0;m=u;u=0;if(m&1){break}c[f+24>>2]=k;c[j>>2]=l|1;c[f+20>>2]=e}tw(k|0,h|0,e|0)|0;a[k+e>>0]=0;break a}}while(0);b=qb(-1,-1)|0;if((f|0)==0){vb(b|0)}Hv(f);vb(b|0)}}while(0);h=f+28|0;if((a[2072]|0)==0?(Ua(2072)|0)!=0:0){c[516]=2088;rb(2072)}c[h>>2]=2064;c[f+32>>2]=0;c[b>>2]=f;m=b+4|0;c[m>>2]=d;c[m+4>>2]=257;i=g;return}function Rf(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0;d=i;i=i+16|0;f=d;if((Sa(f|0,4,1,c[a+4>>2]|0)|0)!=1){d=Jb(8)|0;u=0;oa(75,d|0,2592);k=u;u=0;if(k&1){k=qb(-1,-1)|0;pb(d|0);vb(k|0)}else{c[d>>2]=288;qc(d|0,264,1)}}f=c[f>>2]|0;g=b+4|0;h=c[g>>2]|0;j=c[b>>2]|0;k=(h-j|0)/60|0;a:do{if(!(k>>>0<f>>>0)){if(k>>>0>f>>>0?(e=j+(f*60|0)|0,(h|0)!=(e|0)):0){while(1){k=h+ -60|0;c[g>>2]=k;u=0;na(187,k|0);k=u;u=0;if(k&1){break}h=c[g>>2]|0;if((h|0)==(e|0)){break a}}k=qb(-1,-1)|0;xb(k|0)}}else{ne(b,f-k|0)}}while(0);if((f|0)==0){i=d;return}else{e=0}do{Sf((c[b>>2]|0)+(e*60|0)|0,a);e=e+1|0}while(e>>>0<f>>>0);i=d;return}function Sf(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0;e=i;i=i+16|0;h=e+4|0;j=e;d=b+4|0;if((Sa(j|0,4,1,c[d>>2]|0)|0)!=1){d=Jb(8)|0;u=0;oa(75,d|0,2592);m=u;u=0;if(m&1){m=qb(-1,-1)|0;pb(d|0);vb(m|0)}else{c[d>>2]=288;qc(d|0,264,1)}}f=a+24|0;c[f>>2]=c[j>>2];if((Sa(a+44|0,4,1,c[d>>2]|0)|0)!=1){d=Jb(8)|0;u=0;oa(75,d|0,2592);m=u;u=0;if(m&1){m=qb(-1,-1)|0;pb(d|0);vb(m|0)}else{c[d>>2]=288;qc(d|0,264,1)}}Uf(b,a+48|0);if((c[f>>2]|0)==0){if((Sa(h|0,4,1,c[d>>2]|0)|0)!=1){d=Jb(8)|0;u=0;oa(75,d|0,2592);m=u;u=0;if(m&1){m=qb(-1,-1)|0;pb(d|0);vb(m|0)}else{c[d>>2]=288;qc(d|0,264,1)}}h=c[h>>2]|0;j=a+4|0;k=c[j>>2]|0;l=c[a>>2]|0;m=(k-l|0)/12|0;if(!(m>>>0<h>>>0)){if(m>>>0>h>>>0?(g=l+(h*12|0)|0,(k|0)!=(g|0)):0){m=k;while(1){l=m+ -12|0;c[j>>2]=l;k=c[l>>2]|0;if((k|0)!=0){m=m+ -8|0;l=c[m>>2]|0;if((l|0)!=(k|0)){c[m>>2]=l+(~((l+ -4+(0-k)|0)>>>2)<<2)}Hv(k);l=c[j>>2]|0}if((l|0)==(g|0)){break}else{m=l}}}}else{ce(a,h-m|0)}if((h|0)!=0){g=0;do{Uf(b,(c[a>>2]|0)+(g*12|0)|0);g=g+1|0}while((g|0)!=(h|0))}}if(!(((c[f>>2]|0)+ -1|0)>>>0<2)){i=e;return}Tf(b,a+12|0);if((c[f>>2]|0)!=1){i=e;return}if((Sa(a+40|0,4,1,c[d>>2]|0)|0)==1){Uf(b,a+28|0);i=e;return}d=Jb(8)|0;u=0;oa(75,d|0,2592);m=u;u=0;if(m&1){m=qb(-1,-1)|0;pb(d|0);vb(m|0)}else{c[d>>2]=288;qc(d|0,264,1)}}function Tf(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0;f=i;i=i+32|0;d=f+16|0;g=f+12|0;e=f;h=a+4|0;if((Sa(d|0,4,1,c[h>>2]|0)|0)!=1){d=Jb(8)|0;u=0;oa(75,d|0,2592);n=u;u=0;if(n&1){n=qb(-1,-1)|0;pb(d|0);vb(n|0)}else{c[d>>2]=288;qc(d|0,264,1)}}j=c[d>>2]|0;if((j|0)==0){i=f;return}d=e+4|0;l=e+8|0;k=0;while(1){if((Sa(g|0,4,1,c[h>>2]|0)|0)!=1){b=8;break}c[e>>2]=0;c[d>>2]=0;c[l>>2]=0;u=0;oa(88,a|0,e|0);n=u;u=0;if(n&1){b=20;break}u=0;m=Ha(37,b|0,g|0)|0;n=u;u=0;if(n&1){b=20;break}if((m|0)!=(e|0)?(u=0,Na(51,m|0,c[e>>2]|0,c[d>>2]|0),n=u,u=0,n&1):0){b=20;break}m=c[e>>2]|0;if((m|0)!=0){n=c[d>>2]|0;if((n|0)!=(m|0)){c[d>>2]=n+(~((n+ -4+(0-m)|0)>>>2)<<2)}Hv(m)}k=k+1|0;if(!(k>>>0<j>>>0)){b=24;break}}if((b|0)==8){d=Jb(8)|0;u=0;oa(75,d|0,2592);n=u;u=0;if(n&1){n=qb(-1,-1)|0;pb(d|0);vb(n|0)}else{c[d>>2]=288;qc(d|0,264,1)}}else if((b|0)==20){f=qb(-1,-1)|0;e=c[e>>2]|0;if((e|0)==0){vb(f|0)}b=c[d>>2]|0;if((b|0)!=(e|0)){c[d>>2]=b+(~((b+ -4+(0-e)|0)>>>2)<<2)}Hv(e);vb(f|0)}else if((b|0)==24){i=f;return}}function Uf(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0;d=i;i=i+16|0;g=d;a=a+4|0;if((Sa(g|0,4,1,c[a>>2]|0)|0)!=1){b=Jb(8)|0;u=0;oa(75,b|0,2592);l=u;u=0;if(l&1){l=qb(-1,-1)|0;pb(b|0);vb(l|0)}else{c[b>>2]=288;qc(b|0,264,1)}}g=c[g>>2]|0;j=b+4|0;h=c[j>>2]|0;k=c[b>>2]|0;l=h-k>>2;if(!(l>>>0<g>>>0)){if(l>>>0>g>>>0?(f=k+(g<<2)|0,(h|0)!=(f|0)):0){c[j>>2]=h+(~((h+ -4+(0-f)|0)>>>2)<<2)}}else{$d(b,g-l|0)}if((g|0)==0){i=d;return}else{f=0}while(1){if((Sa((c[b>>2]|0)+(f<<2)|0,4,1,c[a>>2]|0)|0)!=1){break}f=f+1|0;if(!(f>>>0<g>>>0)){e=16;break}}if((e|0)==16){i=d;return}b=Jb(8)|0;u=0;oa(75,b|0,2592);l=u;u=0;if(l&1){l=qb(-1,-1)|0;pb(b|0);vb(l|0)}else{c[b>>2]=288;qc(b|0,264,1)}}function Vf(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;e=i;i=i+64|0;g=e;k=e+52|0;c[g+0>>2]=0;c[g+4>>2]=0;c[g+8>>2]=0;c[g+12>>2]=0;l=g+0|0;f=1816|0;h=l+12|0;do{a[l>>0]=a[f>>0]|0;l=l+1|0;f=f+1|0}while((l|0)<(h|0));q=g+16|0;c[q+0>>2]=0;c[q+4>>2]=0;c[q+8>>2]=0;c[q+12>>2]=0;a[q+0>>0]=a[1832>>0]|0;a[q+1>>0]=a[1833>>0]|0;a[q+2>>0]=a[1834>>0]|0;a[q+3>>0]=a[1835>>0]|0;a[q+4>>0]=a[1836>>0]|0;a[q+5>>0]=a[1837>>0]|0;Wf(g,d);if((lw(g,1816)|0)!=0){d=Jb(8)|0;u=0;oa(75,d|0,2616);q=u;u=0;if(!(q&1)){c[d>>2]=288;qc(d|0,264,1)}q=qb(-1,-1)|0;pb(d|0);vb(q|0)}if((c[g+32>>2]|0)!=8){d=Jb(8)|0;u=0;oa(75,d|0,2656);q=u;u=0;if(!(q&1)){c[d>>2]=288;qc(d|0,264,1)}q=qb(-1,-1)|0;pb(d|0);vb(q|0)}q=c[g+36>>2]|0;if((q|0)!=(Bc[c[(c[b>>2]|0)+16>>2]&255](b)|0)){d=Jb(8)|0;u=0;oa(75,d|0,2728);q=u;u=0;if(!(q&1)){c[d>>2]=288;qc(d|0,264,1)}q=qb(-1,-1)|0;pb(d|0);vb(q|0)}h=b+12|0;f=d+4|0;if((Sa(h|0,4,1,c[f>>2]|0)|0)!=1){d=Jb(8)|0;u=0;oa(75,d|0,2592);q=u;u=0;if(q&1){q=qb(-1,-1)|0;pb(d|0);vb(q|0)}else{c[d>>2]=288;qc(d|0,264,1)}}g=b+20|0;if((Sa(g|0,4,1,c[f>>2]|0)|0)!=1){d=Jb(8)|0;u=0;oa(75,d|0,2592);q=u;u=0;if(q&1){q=qb(-1,-1)|0;pb(d|0);vb(q|0)}else{c[d>>2]=288;qc(d|0,264,1)}}if((Sa(b+16|0,4,1,c[f>>2]|0)|0)!=1){d=Jb(8)|0;u=0;oa(75,d|0,2592);q=u;u=0;if(q&1){q=qb(-1,-1)|0;pb(d|0);vb(q|0)}else{c[d>>2]=288;qc(d|0,264,1)}}if((Sa(k|0,1,1,c[f>>2]|0)|0)!=1){d=Jb(8)|0;u=0;oa(75,d|0,2592);q=u;u=0;if(q&1){q=qb(-1,-1)|0;pb(d|0);vb(q|0)}else{c[d>>2]=288;qc(d|0,264,1)}}a:do{if((a[k>>0]|0)==0){if(((c[b+76>>2]|0)-(c[b+72>>2]|0)>>2|0)!=(c[h>>2]|0)){d=Jb(8)|0;u=0;oa(75,d|0,1640);q=u;u=0;if(!(q&1)){c[d>>2]=288;qc(d|0,264,1)}q=qb(-1,-1)|0;pb(d|0);vb(q|0)}}else{k=b+84|0;l=c[k>>2]|0;if((l|0)!=0){Iv(l)}m=c[h>>2]|0;l=fa(c[g>>2]|0,m)|0;l=Gv(l>>>0>1073741823?-1:l<<2)|0;c[k>>2]=l;l=b+72|0;q=b+76|0;n=c[q>>2]|0;p=c[l>>2]|0;o=n-p>>2;if(!(o>>>0<m>>>0)){if(o>>>0>m>>>0?(j=p+(m<<2)|0,(n|0)!=(j|0)):0){c[q>>2]=n+(~((n+ -4+(0-j)|0)>>>2)<<2)}}else{Ie(l,m-o|0);m=c[h>>2]|0}if((m|0)!=0){j=c[g>>2]|0;n=0;do{q=(c[k>>2]|0)+((fa(j,n)|0)<<2)|0;c[(c[l>>2]|0)+(n<<2)>>2]=q;n=n+1|0}while(n>>>0<m>>>0);if((m|0)!=0){j=0;while(1){if((Sa(c[(c[l>>2]|0)+(j<<2)>>2]|0,c[g>>2]<<2|0,1,c[f>>2]|0)|0)!=1){break}j=j+1|0;if(!(j>>>0<(c[h>>2]|0)>>>0)){break a}}d=Jb(8)|0;u=0;oa(75,d|0,2592);q=u;u=0;if(q&1){q=qb(-1,-1)|0;pb(d|0);vb(q|0)}else{c[d>>2]=288;qc(d|0,264,1)}}}}}while(0);if((Sa(b+8|0,4,1,c[f>>2]|0)|0)!=1){d=Jb(8)|0;u=0;oa(75,d|0,2592);q=u;u=0;if(q&1){q=qb(-1,-1)|0;pb(d|0);vb(q|0)}else{c[d>>2]=288;qc(d|0,264,1)}}Uf(d,b+60|0);g=b+36|0;if((Sa(g|0,1,1,c[f>>2]|0)|0)!=1){d=Jb(8)|0;u=0;oa(75,d|0,2592);q=u;u=0;if(q&1){q=qb(-1,-1)|0;pb(d|0);vb(q|0)}else{c[d>>2]=288;qc(d|0,264,1)}}do{if((a[g>>0]|0)!=0){if((Sa(b+52|0,4,1,c[f>>2]|0)|0)==1){Uf(d,b+40|0);break}d=Jb(8)|0;u=0;oa(75,d|0,2592);q=u;u=0;if(q&1){q=qb(-1,-1)|0;pb(d|0);vb(q|0)}else{c[d>>2]=288;qc(d|0,264,1)}}}while(0);if((Sa(b+56|0,4,1,c[f>>2]|0)|0)==1){i=e;return}d=Jb(8)|0;u=0;oa(75,d|0,2592);q=u;u=0;if(q&1){q=qb(-1,-1)|0;pb(d|0);vb(q|0)}else{c[d>>2]=288;qc(d|0,264,1)}}function Wf(a,b){a=a|0;b=b|0;var d=0,e=0;e=i;i=i+16|0;d=e;b=b+4|0;if((Sa(a|0,16,1,c[b>>2]|0)|0)!=1){a=Jb(8)|0;u=0;oa(75,a|0,2592);b=u;u=0;if(b&1){b=qb(-1,-1)|0;pb(a|0);vb(b|0)}else{c[a>>2]=288;qc(a|0,264,1)}}if((Sa(a+16|0,16,1,c[b>>2]|0)|0)!=1){a=Jb(8)|0;u=0;oa(75,a|0,2592);b=u;u=0;if(b&1){b=qb(-1,-1)|0;pb(a|0);vb(b|0)}else{c[a>>2]=288;qc(a|0,264,1)}}if((Sa(d|0,4,1,c[b>>2]|0)|0)!=1){a=Jb(8)|0;u=0;oa(75,a|0,2592);b=u;u=0;if(b&1){b=qb(-1,-1)|0;pb(a|0);vb(b|0)}else{c[a>>2]=288;qc(a|0,264,1)}}c[a+32>>2]=c[d>>2];if((Sa(d|0,4,1,c[b>>2]|0)|0)!=1){a=Jb(8)|0;u=0;oa(75,a|0,2592);b=u;u=0;if(b&1){b=qb(-1,-1)|0;pb(a|0);vb(b|0)}else{c[a>>2]=288;qc(a|0,264,1)}}c[a+36>>2]=c[d>>2];if((Sa(a+44|0,4,1,c[b>>2]|0)|0)!=1){a=Jb(8)|0;u=0;oa(75,a|0,2592);b=u;u=0;if(b&1){b=qb(-1,-1)|0;pb(a|0);vb(b|0)}else{c[a>>2]=288;qc(a|0,264,1)}}if((Sa(a+48|0,4,1,c[b>>2]|0)|0)==1){i=e;return}a=Jb(8)|0;u=0;oa(75,a|0,2592);b=u;u=0;if(b&1){b=qb(-1,-1)|0;pb(a|0);vb(b|0)}else{c[a>>2]=288;qc(a|0,264,1)}}function Xf(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0;b=i;c[a>>2]=448;e=c[a+112>>2]|0;if((e|0)!=0){f=a+116|0;g=c[f>>2]|0;if((g|0)!=(e|0)){c[f>>2]=g+(~((g+ -4+(0-e)|0)>>>2)<<2)}Hv(e)}e=a+88|0;f=c[e>>2]|0;if((f|0)==0){Hd(a);i=b;return}g=a+92|0;while(1){h=c[g>>2]|0;if((h|0)==(f|0)){break}h=h+ -60|0;c[g>>2]=h;u=0;na(187,h|0);h=u;u=0;if(h&1){d=9;break}}if((d|0)==9){h=qb(-1,-1)|0;xb(h|0)}Hv(c[e>>2]|0);Hd(a);i=b;return}function Yf(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0;m=i;i=i+80|0;f=m+65|0;k=m+64|0;x=m+52|0;y=m+48|0;q=m+36|0;s=m+32|0;p=m+20|0;r=m+16|0;l=m+4|0;n=m;a[f+0>>0]=a[k+0>>0]|0;Dd(b,e,f);c[b>>2]=2800;f=b+88|0;c[f>>2]=0;e=b+92|0;c[e>>2]=0;c[b+96>>2]=0;c[b+112>>2]=8192;k=b+100|0;c[k>>2]=0;h=b+104|0;c[h>>2]=0;j=b+116|0;c[j>>2]=0;g=b+120|0;c[g>>2]=0;c[b+124>>2]=0;o=b+24|0;a[x>>0]=18;v=x+1|0;t=2880|0;w=v+9|0;do{a[v>>0]=a[t>>0]|0;v=v+1|0;t=t+1|0}while((v|0)<(w|0));a[x+10>>0]=0;c[y>>2]=32;u=0;t=ua(28,o|0,x|0,y|0)|0;y=u;u=0;do{if(y&1){d=qb(-1,-1)|0;if(!((a[x>>0]&1)==0)){Hv(c[x+8>>2]|0)}}else{c[b+128>>2]=t;if(!((a[x>>0]&1)==0)){Hv(c[x+8>>2]|0)}u=0;y=qa(119,16)|0;x=u;u=0;if(!(x&1)){x=q+8|0;c[x>>2]=y;c[q>>2]=17;c[q+4>>2]=12;v=y+0|0;t=2896|0;w=v+12|0;do{a[v>>0]=a[t>>0]|0;v=v+1|0;t=t+1|0}while((v|0)<(w|0));a[y+12>>0]=0;c[s>>2]=0;u=0;s=ua(29,o|0,q|0,s|0)|0;y=u;u=0;if(y&1){d=qb(-1,-1)|0;if((a[q>>0]&1)==0){break}Hv(c[x>>2]|0);break}c[b+136>>2]=s;if(!((a[q>>0]&1)==0)){Hv(c[x>>2]|0)}a[p>>0]=10;q=p+1|0;a[q+0>>0]=a[2912>>0]|0;a[q+1>>0]=a[2913>>0]|0;a[q+2>>0]=a[2914>>0]|0;a[q+3>>0]=a[2915>>0]|0;a[q+4>>0]=a[2916>>0]|0;a[p+6>>0]=0;c[r>>2]=4;u=0;q=ua(28,o|0,p|0,r|0)|0;y=u;u=0;if(y&1){d=qb(-1,-1)|0;if((a[p>>0]&1)==0){break}Hv(c[p+8>>2]|0);break}c[b+132>>2]=q;if(!((a[p>>0]&1)==0)){Hv(c[p+8>>2]|0)}u=0;q=qa(119,16)|0;y=u;u=0;if(!(y&1)){p=l+8|0;c[p>>2]=q;c[l>>2]=17;c[l+4>>2]=13;v=q+0|0;t=2920|0;w=v+13|0;do{a[v>>0]=a[t>>0]|0;v=v+1|0;t=t+1|0}while((v|0)<(w|0));a[q+13>>0]=0;c[n>>2]=100;u=0;n=ua(28,o|0,l|0,n|0)|0;y=u;u=0;if(y&1){d=qb(-1,-1)|0;if((a[l>>0]&1)==0){break}Hv(c[p>>2]|0);break}c[b+140>>2]=n;if(!((a[l>>0]&1)==0)){Hv(c[p>>2]|0)}u=0;na(192,b|0);y=u;u=0;if(!(y&1)){y=(c[b+144>>2]|0)+4|0;c[y+0>>2]=c[d+0>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];c[y+12>>2]=c[d+12>>2];c[y+16>>2]=c[d+16>>2];u=0;oa(79,b|0,d|0);y=u;u=0;if(!(y&1)){i=m;return}}}}d=qb(-1,-1)|0}}while(0);l=c[h>>2]|0;if((l|0)!=0){do{y=l;l=c[l>>2]|0;Bv(y);c[h>>2]=l}while((l|0)!=0)}c[h>>2]=0;c[k>>2]=0;c[j>>2]=0;c[g>>2]=0;f=c[f>>2]|0;if((f|0)!=0){g=c[e>>2]|0;if((g|0)!=(f|0)){c[e>>2]=g+(~((g+ -4+(0-f)|0)>>>2)<<2)}Hv(f)}u=0;na(186,b|0);y=u;u=0;if(y&1){y=qb(-1,-1,0)|0;jd(y)}else{vb(d|0)}}function Zf(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0;e=i;i=i+16|0;f=e+4|0;g=e;pf(g,a,b);b=c[g>>2]|0;if((b|0)==(a+4|0)){g=d;g=c[g>>2]|0;i=e;return g|0}d=b+28|0;g=c[d>>2]|0;g=(Bc[c[(c[g>>2]|0)+24>>2]&255](g)|0)+4|0;if((c[g>>2]|0)==(c[24596>>2]|0)){c[f>>2]=c[b+32>>2];g=c[d>>2]|0;g=Sc[c[(c[g>>2]|0)+16>>2]&63](g,f)|0;g=c[g>>2]|0;i=e;return g|0}e=Jb(8)|0;u=0;oa(75,e|0,1760);g=u;u=0;if(g&1){g=qb(-1,-1)|0;pb(e|0);vb(g|0)}else{c[e>>2]=1800;qc(e|0,1744,22)}return 0}function _f(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0;e=i;i=i+16|0;f=e+4|0;g=e;pf(g,a,b);b=c[g>>2]|0;if((b|0)==(a+4|0)){g=d;g=c[g>>2]|0;i=e;return g|0}d=b+28|0;g=c[d>>2]|0;g=(Bc[c[(c[g>>2]|0)+24>>2]&255](g)|0)+4|0;if((c[g>>2]|0)==3392){c[f>>2]=c[b+32>>2];g=c[d>>2]|0;g=Sc[c[(c[g>>2]|0)+16>>2]&63](g,f)|0;g=c[g>>2]|0;i=e;return g|0}e=Jb(8)|0;u=0;oa(75,e|0,1760);g=u;u=0;if(g&1){g=qb(-1,-1)|0;pb(e|0);vb(g|0)}else{c[e>>2]=1800;qc(e|0,1744,22)}return 0}function $f(a){a=a|0;var b=0,d=0;b=i;d=c[a+136>>2]|0;if((d|0)==0){d=Fv(28)|0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;c[d+16>>2]=-1;c[d+20>>2]=0;c[d>>2]=4008;c[a+144>>2]=d;i=b;return}else if((d|0)==2){d=Fv(28)|0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;c[d+16>>2]=-1;c[d+20>>2]=0;c[d>>2]=3664;c[a+144>>2]=d;i=b;return}else if((d|0)!=1){a=Jb(8)|0;u=0;oa(75,a|0,3608);d=u;u=0;if(d&1){d=qb(-1,-1)|0;pb(a|0);vb(d|0)}else{c[a>>2]=288;qc(a|0,264,1)}}else{d=Fv(28)|0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;c[d+16>>2]=-1;c[d+20>>2]=0;c[d>>2]=3896;c[a+144>>2]=d;i=b;return}}function ag(a){a=a|0;var b=0;b=i;Vg(a);i=b;return}function bg(a){a=a|0;var b=0,c=0;b=i;u=0;na(193,a|0);c=u;u=0;if(c&1){c=qb(-1,-1)|0;Hv(a);vb(c|0)}else{Hv(a);i=b;return}}function cg(a){a=a|0;return 5}function dg(a){a=a|0;return(c[a+120>>2]|0)+(c[a+116>>2]|0)+(c[a+124>>2]|0)|0}function eg(b,d){b=b|0;d=d|0;var e=0,f=0,g=0;f=i;i=i+16|0;g=f;e=g+4|0;c[e>>2]=d;d=g+8|0;a[d>>0]=0;u=0;oa(89,b|0,g|0);b=u;u=0;if(b&1){b=qb(-1,-1)|0;if((a[d>>0]|0)==0){vb(b|0)}Rb(c[e>>2]|0)|0;vb(b|0)}else{if((a[d>>0]|0)==0){i=f;return}Rb(c[e>>2]|0)|0;i=f;return}}function fg(b,d){b=b|0;d=d|0;var e=0,f=0,g=0;f=i;i=i+16|0;g=f;e=g+4|0;c[e>>2]=d;d=g+8|0;a[d>>0]=0;u=0;oa(90,b|0,g|0);b=u;u=0;if(b&1){b=qb(-1,-1)|0;if((a[d>>0]|0)==0){vb(b|0)}Rb(c[e>>2]|0)|0;vb(b|0)}else{if((a[d>>0]|0)==0){i=f;return}Rb(c[e>>2]|0)|0;i=f;return}}function gg(a){a=a|0;var b=0,c=0;c=i;b=Fv(148)|0;u=0;oa(91,b|0,a|0);a=u;u=0;if(a&1){c=qb(-1,-1)|0;Hv(b);vb(c|0)}else{i=c;return b|0}return 0}function hg(a,b,d){a=a|0;b=b|0;d=+d;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0;e=i;if((c[b+4>>2]|0)!=(c[a+20>>2]|0)){Wa(1208,3080,203,1232)}m=a+12|0;f=c[m>>2]|0;He(a,b);if(d>1.0?+((c[a+16>>2]|0)>>>0)*d<+((c[m>>2]|0)>>>0):0){yc[c[(c[a>>2]|0)+40>>2]&255](a);i=e;return}l=c[b>>2]|0;if((l|0)==0){i=e;return}g=a+132|0;h=a+88|0;k=c[g>>2]|0;j=0;do{if((k|0)>0){l=j+f|0;m=0;do{wg(a,c[(c[h>>2]|0)+(m<<2)>>2]|0,l);m=m+1|0;k=c[g>>2]|0}while((m|0)<(k|0));l=c[b>>2]|0}j=j+1|0}while(j>>>0<l>>>0);i=e;return}function ig(b,c,d,e){b=b|0;c=c|0;d=d|0;e=e|0;var f=0;f=i;if((a[b+36>>0]|0)==0){rg(b,c,d,e);i=f;return}else{qg(b,c,d,e);i=f;return}}function jg(a){a=a|0;var b=0,d=0,e=0,f=0,g=0;b=i;e=a+92|0;d=a+88|0;g=c[d>>2]|0;if((c[e>>2]|0)!=(g|0)){f=0;do{pg(c[g+(f<<2)>>2]|0);f=f+1|0;g=c[d>>2]|0}while(f>>>0<(c[e>>2]|0)-g>>2>>>0)}d=a+104|0;e=c[d>>2]|0;if((e|0)!=0){do{g=e;e=c[e>>2]|0;Bv(g);c[d>>2]=e}while((e|0)!=0)}c[d>>2]=0;c[a+100>>2]=0;c[a+116>>2]=0;c[a+120>>2]=0;i=b;return}function kg(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,s=0;f=i;if((c[a+128>>2]|0)<2){b=Jb(8)|0;u=0;oa(75,b|0,3008);s=u;u=0;if(!(s&1)){c[b>>2]=288;qc(b|0,264,1)}s=qb(-1,-1)|0;pb(b|0);vb(s|0)}d=a+88|0;e=a+132|0;j=c[e>>2]|0;l=a+92|0;m=c[l>>2]|0;k=c[d>>2]|0;h=m-k>>2;if(!(h>>>0<j>>>0)){if(h>>>0>j>>>0?(g=k+(j<<2)|0,(m|0)!=(g|0)):0){c[l>>2]=m+(~((m+ -4+(0-g)|0)>>>2)<<2)}}else{og(d,j-h|0)}g=a+12|0;j=c[g>>2]|0;if((j|0)==0){h=0}else{if(j>>>0>1073741823){ss(0)}h=Fv(j<<2)|0;k=h;while(1){if((k|0)!=0){c[k>>2]=0}j=j+ -1|0;if((j|0)==0){break}else{k=k+4|0}}}a:do{if((c[e>>2]|0)>0){n=a+100|0;p=a+120|0;j=c[r>>2]|0;k=a+104|0;l=a+108|0;m=a+116|0;o=0;while(1){s=c[g>>2]|0;if((s|0)!=0){q=0;do{c[h+(q<<2)>>2]=q;q=q+1|0}while(q>>>0<s>>>0)}s=c[n>>2]|0;do{if((s|0)<32){c[p>>2]=(c[p>>2]|0)+s;q=Av(8192)|0;if((q|0)==0){zb(3048,27,1,j|0)|0;q=0;break}else{c[q>>2]=c[k>>2];c[k>>2]=q;c[n>>2]=8188;q=q+4|0;c[l>>2]=q;s=8156;b=28;break}}else{q=c[l>>2]|0;s=s+ -32|0;b=28}}while(0);if((b|0)==28){b=0;c[l>>2]=q+32;c[n>>2]=s;c[m>>2]=(c[m>>2]|0)+32}c[q+0>>2]=0;c[q+4>>2]=0;c[q+8>>2]=0;c[q+12>>2]=0;c[q+16>>2]=0;c[q+20>>2]=0;c[q+24>>2]=0;c[q+28>>2]=0;c[(c[d>>2]|0)+(o<<2)>>2]=q;u=0;Qa(26,a|0,c[(c[d>>2]|0)+(o<<2)>>2]|0,h|0,c[g>>2]|0);s=u;u=0;if(s&1){break}o=o+1|0;if((o|0)>=(c[e>>2]|0)){break a}}b=qb(-1,-1)|0;if((h|0)==0){s=b;vb(s|0)}Hv(h);s=b;vb(s|0)}}while(0);if((h|0)==0){i=f;return}Hv(h);i=f;return}function lg(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0;f=i;i=i+16|0;o=f+4|0;n=f;if((c[a+140>>2]|0)>(e|0)){h=b+20|0;k=b+24|0;j=c[k>>2]|0;l=c[h>>2]|0;m=j-l>>3;if(!(m>>>0<e>>>0)){if(m>>>0>e>>>0?(g=l+(e<<3)|0,(j|0)!=(g|0)):0){c[k>>2]=j+(~((j+ -8+(0-g)|0)>>>3)<<3)}}else{ng(h,e-m|0)}if((e|0)>0){g=a+72|0;a=0;do{A=d+(a<<2)|0;B=c[h>>2]|0;c[B+(a<<3)>>2]=c[A>>2];c[B+(a<<3)+4>>2]=c[(c[g>>2]|0)+(c[A>>2]<<2)>>2];a=a+1|0}while((a|0)!=(e|0))}d=c[b+8>>2]|0;a=b+12|0;e=c[a>>2]|0;if((e|0)==(d|0)){i=f;return}c[a>>2]=e+(~((e+ -4+(0-d)|0)>>>2)<<2);i=f;return}k=a+128|0;h=c[k>>2]|0;if((h|0)==0){g=0}else{if(h>>>0>1073741823){ss(0)}g=Fv(h<<2)|0;p=g;while(1){if((p|0)!=0){c[p>>2]=0}h=h+ -1|0;if((h|0)==0){break}else{p=p+4|0}}}a:do{if((e|0)==0){h=0;j=28}else{if(e>>>0>1073741823){u=0;na(189,0);B=u;u=0}else{u=0;h=qa(119,e<<2|0)|0;B=u;u=0;if(!(B&1)){j=e;p=h;while(1){if((p|0)!=0){c[p>>2]=0}j=j+ -1|0;if((j|0)==0){j=28;break a}else{p=p+4|0}}}}f=qb(-1,-1)|0}}while(0);if((j|0)==28){B=c[a+144>>2]|0;u=0;ya(c[(c[B>>2]|0)+8>>2]|0,B|0,c[k>>2]|0,d|0,e|0,g|0,o|0);B=u;u=0;b:do{if(B&1){j=40}else{o=c[o>>2]|0;c:do{if((o|0)<(c[k>>2]|0)){j=b+20|0;m=b+24|0;n=c[m>>2]|0;o=c[j>>2]|0;k=n-o>>3;if(k>>>0<e>>>0){u=0;oa(92,j|0,e-k|0);B=u;u=0;if(B&1){j=40;break b}}else{if(k>>>0>e>>>0?(l=o+(e<<3)|0,(n|0)!=(l|0)):0){c[m>>2]=n+(~((n+ -8+(0-l)|0)>>>3)<<3)}}if((e|0)>0){a=a+72|0;k=0;do{A=d+(k<<2)|0;B=c[j>>2]|0;c[B+(k<<3)>>2]=c[A>>2];c[B+(k<<3)+4>>2]=c[(c[a>>2]|0)+(c[A>>2]<<2)>>2];k=k+1|0}while((k|0)!=(e|0))}d=c[b+8>>2]|0;e=b+12|0;a=c[e>>2]|0;if((a|0)!=(d|0)){c[e>>2]=a+(~((a+ -4+(0-d)|0)>>>2)<<2)}}else{mg(a,d,e,g,o,h,n);l=b+8|0;n=c[k>>2]|0;q=b+12|0;p=c[q>>2]|0;b=c[l>>2]|0;o=p-b>>2;if(!(o>>>0<n>>>0)){if(o>>>0>n>>>0?(m=b+(n<<2)|0,(p|0)!=(m|0)):0){c[q>>2]=p+(~((p+ -4+(0-m)|0)>>>2)<<2)}}else{u=0;oa(93,l|0,n-o|0);B=u;u=0;if(B&1){j=40;break b}n=c[k>>2]|0}if((n|0)>0){t=(e|0)>0;p=a+100|0;s=a+120|0;n=c[r>>2]|0;o=a+104|0;q=a+108|0;m=a+72|0;w=a+116|0;v=0;b=0;while(1){if(t){x=b;y=0;do{z=h+(y<<2)|0;if((c[z>>2]|0)==(v|0)){C=d+(y<<2)|0;B=d+(x<<2)|0;A=c[C>>2]|0;c[C>>2]=c[B>>2];c[B>>2]=A;B=h+(x<<2)|0;c[z>>2]=c[B>>2];c[B>>2]=v;x=x+1|0}y=y+1|0}while((y|0)!=(e|0))}else{x=b}z=c[p>>2]|0;do{if((z|0)<32){c[s>>2]=(c[s>>2]|0)+z;y=Av(8192)|0;if((y|0)==0){zb(3048,27,1,n|0)|0;y=0;break}else{c[y>>2]=c[o>>2];c[o>>2]=y;c[p>>2]=8188;y=y+4|0;c[q>>2]=y;z=8156;j=62;break}}else{y=c[q>>2]|0;z=z+ -32|0;j=62}}while(0);if((j|0)==62){j=0;c[q>>2]=y+32;c[p>>2]=z;c[w>>2]=(c[w>>2]|0)+32}c[y+0>>2]=0;c[y+4>>2]=0;c[y+8>>2]=0;c[y+12>>2]=0;c[y+16>>2]=0;c[y+20>>2]=0;c[y+24>>2]=0;c[y+28>>2]=0;c[(c[l>>2]|0)+(v<<2)>>2]=y;B=g+(v<<2)|0;A=c[(c[l>>2]|0)+(v<<2)>>2]|0;c[A+4>>2]=c[B>>2];c[A>>2]=c[(c[m>>2]|0)+(c[B>>2]<<2)>>2];A=c[(c[l>>2]|0)+(v<<2)>>2]|0;B=c[A+20>>2]|0;y=A+24|0;z=c[y>>2]|0;if((z|0)!=(B|0)){c[y>>2]=z+(~((z+ -8+(0-B)|0)>>>3)<<3);A=c[(c[l>>2]|0)+(v<<2)>>2]|0}u=0;Qa(26,a|0,A|0,d+(b<<2)|0,x-b|0);C=u;u=0;if(C&1){break}v=v+1|0;if((v|0)>=(c[k>>2]|0)){break c}else{b=x}}f=qb(-1,-1)|0;break b}}}while(0);if((h|0)!=0){Hv(h)}if((g|0)==0){i=f;return}Hv(g);i=f;return}}while(0);if((j|0)==40){f=qb(-1,-1)|0}if((h|0)!=0){Hv(h)}}if((g|0)==0){vb(f|0)}Hv(g);vb(f|0)}



function dj(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0.0,R=0.0,S=0,T=0,U=0.0,V=0.0,W=0.0,X=0.0;j=i;i=i+16|0;m=j;c[b+12>>2]=e;if((e|0)<(f|0)){f=b+28|0;m=b+32|0;l=c[m>>2]|0;n=c[f>>2]|0;o=l-n>>3;if(!(o>>>0<e>>>0)){if(o>>>0>e>>>0?(k=n+(e<<3)|0,(l|0)!=(k|0)):0){c[m>>2]=l+(~((l+ -8+(0-k)|0)>>>3)<<3)}}else{fj(f,e-o|0)}if((e|0)>0){k=a+72|0;a=0;do{S=d+(a<<2)|0;T=c[f>>2]|0;c[T+(a<<3)>>2]=c[S>>2];c[T+(a<<3)+4>>2]=c[(c[k>>2]|0)+(c[S>>2]<<2)>>2];a=a+1|0}while((a|0)!=(e|0))}d=c[b+16>>2]|0;e=b+20|0;k=c[e>>2]|0;if((k|0)==(d|0)){i=j;return}c[e>>2]=k+(~((k+ -4+(0-d)|0)>>>2)<<2);i=j;return}t=(f|0)==0;if(t){k=0}else{if(f>>>0>1073741823){ss(0)}k=Fv(f<<2)|0;n=f;o=k;while(1){if((o|0)!=0){c[o>>2]=0}n=n+ -1|0;if((n|0)==0){break}else{o=o+4|0}}}T=c[a+136>>2]|0;u=0;ya(c[(c[T>>2]|0)+8>>2]|0,T|0,f|0,d|0,e|0,k|0,m|0);T=u;u=0;a:do{if(T&1){q=29}else{n=c[m>>2]|0;b:do{if((n|0)<(f|0)){f=b+28|0;o=b+32|0;p=c[o>>2]|0;n=c[f>>2]|0;m=p-n>>3;if(m>>>0<e>>>0){u=0;oa(112,f|0,e-m|0);T=u;u=0;if(T&1){q=29;break a}}else{if(m>>>0>e>>>0?(l=n+(e<<3)|0,(p|0)!=(l|0)):0){c[o>>2]=p+(~((p+ -8+(0-l)|0)>>>3)<<3)}}if((e|0)>0){a=a+72|0;l=0;do{S=d+(l<<2)|0;T=c[f>>2]|0;c[T+(l<<3)>>2]=c[S>>2];c[T+(l<<3)+4>>2]=c[(c[a>>2]|0)+(c[S>>2]<<2)>>2];l=l+1|0}while((l|0)!=(e|0))}d=c[b+16>>2]|0;a=b+20|0;e=c[a>>2]|0;if((e|0)!=(d|0)){c[a>>2]=e+(~((e+ -4+(0-d)|0)>>>2)<<2)}}else{l=a+20|0;v=c[l>>2]|0;m=fa(v,f)|0;u=0;m=qa(121,(m>>>0>536870911?-1:m<<3)|0)|0;T=u;u=0;if(T&1){q=29;break a}s=v<<3;if((n|0)>0){w=c[a+72>>2]|0;o=(v|0)==0;A=0;do{z=c[w+(c[k+(A<<2)>>2]<<2)>>2]|0;if(!o){y=m+(fa(A,s)|0)|0;x=0;do{h[y+(x<<3)>>3]=+g[z+(x<<2)>>2];x=x+1|0}while(x>>>0<v>>>0)}A=A+1|0}while((A|0)<(n|0))}c:do{if(t){n=0;o=0;q=55}else{if(f>>>0>1073741823){u=0;na(189,0);T=u;u=0}else{o=f<<2;u=0;n=qa(119,o|0)|0;T=u;u=0;if(!(T&1)){w=f;v=n;while(1){if((v|0)!=0){g[v>>2]=0.0}w=w+ -1|0;if((w|0)==0){break}else{v=v+4|0}}u=0;o=qa(119,o|0)|0;T=u;u=0;if(T&1){j=qb(-1,-1)|0;break}v=f;q=o;while(1){if((q|0)!=0){c[q>>2]=0}v=v+ -1|0;if((v|0)==0){q=55;break c}else{q=q+4|0}}}}j=qb(-1,-1)|0;q=30;break a}}while(0);if((q|0)==55){d:do{if((e|0)==0){x=0;v=0;q=65}else{if(e>>>0>1073741823){u=0;na(189,0);T=u;u=0}else{u=0;z=qa(119,e<<2|0)|0;T=u;u=0;if(!(T&1)){v=e;q=z;while(1){if((q|0)!=0){c[q>>2]=0}v=v+ -1|0;if((v|0)==0){break}else{q=q+4|0}}y=(e|0)>0;if(!y){x=z;v=z;q=65;break}w=a+72|0;A=c[w>>2]|0;v=c[l>>2]|0;B=v+ -3|0;q=(f|0)>1;x=0;while(1){E=c[A+(c[d+(x<<2)>>2]<<2)>>2]|0;D=E+(v<<2)|0;C=E+(B<<2)|0;F=(B|0)>0;if(F){H=E;G=m;Q=0.0;do{W=+g[H>>2]- +h[G>>3];V=+g[H+4>>2]- +h[G+8>>3];U=+g[H+8>>2]- +h[G+16>>3];R=+g[H+12>>2]- +h[G+24>>3];Q=Q+(W*W+V*V+U*U+R*R);H=H+16|0;G=G+32|0}while(H>>>0<C>>>0)}else{H=E;G=m;Q=0.0}e:do{if(H>>>0<D>>>0){while(1){I=H+4|0;W=+g[H>>2]- +h[G>>3];Q=Q+W*W;if(!(I>>>0<D>>>0)){break e}G=G+8|0;H=I}}}while(0);G=z+(x<<2)|0;c[G>>2]=0;if(q){I=0;H=1;do{K=m+(fa(H,s)|0)|0;if(F){J=E;R=0.0;do{X=+g[J>>2]- +h[K>>3];U=+g[J+4>>2]- +h[K+8>>3];V=+g[J+8>>2]- +h[K+16>>3];W=+g[J+12>>2]- +h[K+24>>3];R=R+(X*X+U*U+V*V+W*W);J=J+16|0;K=K+32|0}while(J>>>0<C>>>0)}else{J=E;R=0.0}if(J>>>0<D>>>0){while(1){X=+g[J>>2]- +h[K>>3];J=J+4|0;R=R+X*X;if(!(J>>>0<D>>>0)){break}else{K=K+8|0}}}if(Q>R){c[G>>2]=H;I=H;Q=R}H=H+1|0}while((H|0)!=(f|0))}else{I=0}C=n+(I<<2)|0;if(Q>+g[C>>2]){g[C>>2]=Q}T=o+(I<<2)|0;c[T>>2]=(c[T>>2]|0)+1;x=x+1|0;if((x|0)==(e|0)){A=m;v=z;x=z;q=67;break d}}}}j=qb(-1,-1)|0}}while(0);if((q|0)==65){A=m;w=a+72|0;y=0;q=67}if((q|0)==67){B=c[a+92>>2]|0;z=(f|0)>0;C=(f|0)>1;E=f<<2;D=0;do{if((D|0)>=(B|0)){break}D=D+1|0;if(z){G=c[l>>2]<<3;ww(n|0,0,E|0)|0;F=0;do{ww(m+(fa(F,s)|0)|0,0,G|0)|0;F=F+1|0}while((F|0)!=(f|0))}if(y){G=c[w>>2]|0;F=c[l>>2]|0;H=(F|0)==0;I=0;do{K=c[G+(c[d+(I<<2)>>2]<<2)>>2]|0;J=m+(fa(c[v+(I<<2)>>2]|0,s)|0)|0;if(!H){L=0;do{T=J+(L<<3)|0;h[T>>3]=+h[T>>3]+ +g[K+(L<<2)>>2];L=L+1|0}while(L>>>0<F>>>0)}I=I+1|0}while((I|0)!=(e|0))}if(z){H=c[l>>2]|0;G=(H|0)==0;F=0;do{Q=1.0/+(c[o+(F<<2)>>2]|0);if(!G){J=m+(fa(F,s)|0)|0;I=0;do{T=J+(I<<3)|0;h[T>>3]=Q*+h[T>>3];I=I+1|0}while(I>>>0<H>>>0)}F=F+1|0}while((F|0)!=(f|0))}if(y){F=c[w>>2]|0;G=c[l>>2]|0;I=G+ -3|0;J=1;H=0;do{N=c[F+(c[d+(H<<2)>>2]<<2)>>2]|0;L=N+(G<<2)|0;M=N+(I<<2)|0;K=(I|0)>0;if(K){P=N;O=A;Q=0.0;do{U=+g[P>>2]- +h[O>>3];V=+g[P+4>>2]- +h[O+8>>3];W=+g[P+8>>2]- +h[O+16>>3];X=+g[P+12>>2]- +h[O+24>>3];Q=Q+(U*U+V*V+W*W+X*X);P=P+16|0;O=O+32|0}while(P>>>0<M>>>0)}else{P=N;O=A;Q=0.0}f:do{if(P>>>0<L>>>0){while(1){S=P+4|0;X=+g[P>>2]- +h[O>>3];Q=Q+X*X;if(!(S>>>0<L>>>0)){break f}O=O+8|0;P=S}}}while(0);if(C){O=1;P=0;do{T=m+(fa(O,s)|0)|0;if(K){S=N;R=0.0;do{U=+g[S>>2]- +h[T>>3];V=+g[S+4>>2]- +h[T+8>>3];W=+g[S+8>>2]- +h[T+16>>3];X=+g[S+12>>2]- +h[T+24>>3];R=R+(U*U+V*V+W*W+X*X);S=S+16|0;T=T+32|0}while(S>>>0<M>>>0)}else{S=N;R=0.0}if(S>>>0<L>>>0){while(1){X=+g[S>>2]- +h[T>>3];S=S+4|0;R=R+X*X;if(!(S>>>0<L>>>0)){break}else{T=T+8|0}}}T=Q>R;Q=T?R:Q;P=T?O:P;O=O+1|0}while((O|0)!=(f|0))}else{P=0}K=n+(P<<2)|0;if(Q>+g[K>>2]){g[K>>2]=Q}K=v+(H<<2)|0;L=c[K>>2]|0;if((P|0)!=(L|0)){J=o+(L<<2)|0;c[J>>2]=(c[J>>2]|0)+ -1;J=o+(P<<2)|0;c[J>>2]=(c[J>>2]|0)+1;c[K>>2]=P;J=0}H=H+1|0}while((H|0)!=(e|0))}else{J=1}if(z){F=0;do{G=o+(F<<2)|0;g:do{if((c[G>>2]|0)==0){I=F;do{I=(I+1|0)%(f|0)|0;L=o+(I<<2)|0;H=c[L>>2]|0}while((H|0)<2);if(y){K=0}else{J=0;break}while(1){J=v+(K<<2)|0;K=K+1|0;if((c[J>>2]|0)==(I|0)){break}if((K|0)>=(e|0)){J=0;break g}}c[J>>2]=F;c[L>>2]=H+ -1;c[G>>2]=(c[G>>2]|0)+1;J=0}}while(0);F=F+1|0}while((F|0)!=(f|0))}}while((J&1)==0);h:do{if(t){t=0;q=138}else{if(f>>>0>1073741823){u=0;na(189,0);T=u;u=0}else{u=0;t=qa(119,f<<2|0)|0;T=u;u=0;if(!(T&1)){q=f;A=t;while(1){if((A|0)==0){A=0}else{c[A>>2]=0}q=q+ -1|0;if((q|0)==0){q=138;break h}else{A=A+4|0}}}}j=qb(-1,-1)|0}}while(0);if((q|0)==138){i:do{if(z){B=a+132|0;A=c[l>>2]|0;E=A;C=0;while(1){u=0;D=qa(121,(E>>>0>1073741823?-1:E<<2)|0)|0;T=u;u=0;if(T&1){break}c[t+(C<<2)>>2]=D;c[B>>2]=(c[B>>2]|0)+(E<<2);if((E|0)==0){E=0}else{E=m+(fa(C,s)|0)|0;F=0;do{g[D+(F<<2)>>2]=+h[E+(F<<3)>>3];F=F+1|0}while(F>>>0<A>>>0);E=A}C=C+1|0;if((C|0)>=(f|0)){q=150;break i}}j=qb(-1,-1)|0}else{q=150}}while(0);j:do{if((q|0)==150){s=b+16|0;C=b+20|0;B=c[C>>2]|0;b=c[s>>2]|0;A=B-b>>2;if(A>>>0<f>>>0){u=0;oa(113,s|0,f-A|0);T=u;u=0;if(T&1){j=qb(-1,-1)|0;break}}else{if(A>>>0>f>>>0?(p=b+(f<<2)|0,(B|0)!=(p|0)):0){c[C>>2]=B+(~((B+ -4+(0-p)|0)>>>2)<<2)}}k:do{if(z){z=a+108|0;A=a+128|0;C=c[r>>2]|0;D=a+112|0;B=a+116|0;p=a+124|0;E=0;b=0;while(1){F=c[o+(E<<2)>>2]|0;if(y){H=t+(E<<2)|0;I=b;G=0;Q=0.0;do{J=v+(G<<2)|0;if((c[J>>2]|0)==(E|0)){O=c[H>>2]|0;L=d+(G<<2)|0;K=c[L>>2]|0;P=c[(c[w>>2]|0)+(K<<2)>>2]|0;T=c[l>>2]|0;M=O+(T<<2)|0;T=T+ -3|0;N=O+(T<<2)|0;if((T|0)>0){R=0.0;do{U=+g[O>>2]- +g[P>>2];V=+g[O+4>>2]- +g[P+4>>2];W=+g[O+8>>2]- +g[P+8>>2];X=+g[O+12>>2]- +g[P+12>>2];R=R+(U*U+V*V+W*W+X*X);O=O+16|0;P=P+16|0}while(O>>>0<N>>>0);N=O;O=P}else{N=O;O=P;R=0.0}if(N>>>0<M>>>0){while(1){X=+g[N>>2]- +g[O>>2];N=N+4|0;R=R+X*X;if(!(N>>>0<M>>>0)){break}else{O=O+4|0}}}T=d+(I<<2)|0;c[L>>2]=c[T>>2];c[T>>2]=K;T=v+(I<<2)|0;c[J>>2]=c[T>>2];c[T>>2]=E;I=I+1|0;Q=Q+R}G=G+1|0}while((G|0)!=(e|0))}else{I=b;Q=0.0}Q=Q/+(F|0);F=c[z>>2]|0;do{if((F|0)<48){c[A>>2]=(c[A>>2]|0)+F;F=Av(8192)|0;if((F|0)==0){zb(3048,27,1,C|0)|0;G=0;break}else{c[F>>2]=c[D>>2];c[D>>2]=F;c[z>>2]=8188;G=F+4|0;c[B>>2]=G;F=8140;q=171;break}}else{G=c[B>>2]|0;F=F+ -48|0;q=171}}while(0);if((q|0)==171){q=0;c[B>>2]=G+48;c[z>>2]=F;c[p>>2]=(c[p>>2]|0)+48}H=G+0|0;F=H+40|0;do{c[H>>2]=0;H=H+4|0}while((H|0)<(F|0));c[(c[s>>2]|0)+(E<<2)>>2]=G;T=c[(c[s>>2]|0)+(E<<2)>>2]|0;g[T+4>>2]=+g[n+(E<<2)>>2];c[T>>2]=c[t+(E<<2)>>2];T=c[(c[s>>2]|0)+(E<<2)>>2]|0;g[T+8>>2]=Q;u=0;ma(5,a|0,T|0,d+(b<<2)|0,I-b|0,f|0);T=u;u=0;if(T&1){break}E=E+1|0;if((E|0)>=(f|0)){break k}else{b=I}}j=qb(-1,-1)|0;break j}}while(0);if((m|0)!=0){Iv(m)}if((t|0)!=0){Hv(t)}if((v|0)!=0){Hv(x)}if((o|0)!=0){Hv(o)}if((n|0)==0){break b}Hv(n);break b}}while(0);if((t|0)!=0){Hv(t)}}if((v|0)!=0){Hv(x)}}if((o|0)!=0){Hv(o)}}if((n|0)==0){break a}Hv(n);break a}}while(0);if((k|0)==0){i=j;return}Hv(k);i=j;return}}while(0);if((q|0)==29){j=qb(-1,-1)|0;q=30}if((k|0)==0){vb(j|0)}Hv(k);vb(j|0)}function ej(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0;e=i;f=a+8|0;d=a+4|0;k=c[d>>2]|0;j=c[f>>2]|0;g=k;if(!(j-g>>2>>>0<b>>>0)){do{if((k|0)==0){f=0}else{c[k>>2]=0;f=c[d>>2]|0}k=f+4|0;c[d>>2]=k;b=b+ -1|0}while((b|0)!=0);i=e;return}l=c[a>>2]|0;g=g-l>>2;k=g+b|0;if(k>>>0>1073741823){ss(0)}j=j-l|0;if(j>>2>>>0<536870911){l=j>>1;k=l>>>0<k>>>0?k:l;if((k|0)==0){j=0;k=0}else{h=9}}else{k=1073741823;h=9}if((h|0)==9){j=k;k=Fv(k<<2)|0}h=k+(g<<2)|0;do{if((h|0)==0){h=0}else{c[h>>2]=0}h=h+4|0;b=b+ -1|0}while((b|0)!=0);b=c[a>>2]|0;m=(c[d>>2]|0)-b|0;l=k+(g-(m>>2)<<2)|0;tw(l|0,b|0,m|0)|0;c[a>>2]=l;c[d>>2]=h;c[f>>2]=k+(j<<2);if((b|0)==0){i=e;return}Hv(b);i=e;return}function fj(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0;e=i;f=a+8|0;d=a+4|0;k=c[d>>2]|0;j=c[f>>2]|0;g=k;if(!(j-g>>3>>>0<b>>>0)){do{if((k|0)==0){f=0}else{f=k;c[f>>2]=0;c[f+4>>2]=0;f=c[d>>2]|0}k=f+8|0;c[d>>2]=k;b=b+ -1|0}while((b|0)!=0);i=e;return}l=c[a>>2]|0;g=g-l>>3;k=g+b|0;if(k>>>0>536870911){ss(0)}j=j-l|0;if(j>>3>>>0<268435455){l=j>>2;k=l>>>0<k>>>0?k:l;if((k|0)==0){j=0;k=0}else{h=9}}else{k=536870911;h=9}if((h|0)==9){j=k;k=Fv(k<<3)|0}h=k+(g<<3)|0;do{if((h|0)==0){h=0}else{l=h;c[l>>2]=0;c[l+4>>2]=0}h=h+8|0;b=b+ -1|0}while((b|0)!=0);b=c[a>>2]|0;m=(c[d>>2]|0)-b|0;l=k+(g-(m>>3)<<3)|0;tw(l|0,b|0,m|0)|0;c[a>>2]=l;c[d>>2]=h;c[f>>2]=k+(j<<3);if((b|0)==0){i=e;return}Hv(b);i=e;return}function gj(a){a=a|0;var b=0,d=0,e=0,f=0,g=0;e=i;b=c[a>>2]|0;if((b|0)!=0){Iv(b)}d=a+16|0;g=c[d>>2]|0;b=a+20|0;a:do{if((g|0)!=(c[b>>2]|0)){f=0;while(1){u=0;na(200,c[g+(f<<2)>>2]|0);g=u;u=0;if(g&1){break}f=f+1|0;g=c[d>>2]|0;if(!(f>>>0<(c[b>>2]|0)-g>>2>>>0)){break a}}e=qb(-1,-1)|0;f=c[a+28>>2]|0;if((f|0)!=0){a=a+32|0;g=c[a>>2]|0;if((g|0)!=(f|0)){c[a>>2]=g+(~((g+ -8+(0-f)|0)>>>3)<<3)}Hv(f)}a=c[d>>2]|0;if((a|0)==0){vb(e|0)}d=c[b>>2]|0;if((d|0)!=(a|0)){c[b>>2]=d+(~((d+ -4+(0-a)|0)>>>2)<<2)}Hv(a);vb(e|0)}}while(0);f=c[a+28>>2]|0;if((f|0)!=0){g=a+32|0;a=c[g>>2]|0;if((a|0)!=(f|0)){c[g>>2]=a+(~((a+ -8+(0-f)|0)>>>3)<<3)}Hv(f);g=c[d>>2]|0}if((g|0)==0){i=e;return}d=c[b>>2]|0;if((d|0)!=(g|0)){c[b>>2]=d+(~((d+ -4+(0-g)|0)>>>2)<<2)}Hv(g);i=e;return}function hj(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0;f=i;i=i+16|0;j=f+8|0;h=f;k=c[e>>2]|0;if((k|0)==-1){pj(a,c[a+104>>2]|0,b,d);i=f;return}g=Fv(20)|0;m=c[a+12>>2]|0;c[g>>2]=0;e=g+4|0;c[e>>2]=0;l=g+8|0;c[l>>2]=0;c[g+12>>2]=m;do{if((m|0)!=0){u=0;n=qa(119,m<<3|0)|0;o=u;u=0;if(o&1){o=qb(-1,-1)|0;Hv(g);vb(o|0)}else{c[g>>2]=n;c[e>>2]=n;c[l>>2]=n+(m<<3);break}}}while(0);c[g+16>>2]=0;c[j>>2]=0;qj(a,c[a+104>>2]|0,b,d,j,k,g);a:do{if(lj(g,h)|0){do{if((c[j>>2]|0)>=(k|0)?Bc[c[(c[b>>2]|0)+8>>2]&255](b)|0:0){break a}qj(a,c[h>>2]|0,b,d,j,k,g)}while(lj(g,h)|0)}}while(0);if((g|0)==0){i=f;return}h=c[g>>2]|0;if((h|0)!=0){b=c[e>>2]|0;if((b|0)!=(h|0)){c[e>>2]=b+(~((b+ -8+(0-h)|0)>>>3)<<3)}Hv(h)}Hv(g);i=f;return}function ij(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0;f=i;i=i+16|0;j=f+8|0;h=f;k=c[e>>2]|0;if((k|0)==-1){jj(a,c[a+104>>2]|0,b,d);i=f;return}g=Fv(20)|0;m=c[a+12>>2]|0;c[g>>2]=0;e=g+4|0;c[e>>2]=0;l=g+8|0;c[l>>2]=0;c[g+12>>2]=m;do{if((m|0)!=0){u=0;n=qa(119,m<<3|0)|0;o=u;u=0;if(o&1){o=qb(-1,-1)|0;Hv(g);vb(o|0)}else{c[g>>2]=n;c[e>>2]=n;c[l>>2]=n+(m<<3);break}}}while(0);c[g+16>>2]=0;c[j>>2]=0;kj(a,c[a+104>>2]|0,b,d,j,k,g);a:do{if(lj(g,h)|0){do{if((c[j>>2]|0)>=(k|0)?Bc[c[(c[b>>2]|0)+8>>2]&255](b)|0:0){break a}kj(a,c[h>>2]|0,b,d,j,k,g)}while(lj(g,h)|0)}}while(0);if((g|0)==0){i=f;return}h=c[g>>2]|0;if((h|0)!=0){b=c[e>>2]|0;if((b|0)!=(h|0)){c[e>>2]=b+(~((b+ -8+(0-h)|0)>>>3)<<3)}Hv(h)}Hv(g);i=f;return}function jj(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0,k=0,l=0,m=0.0,n=0,o=0,p=0,q=0.0,r=0.0,s=0.0,t=0.0,v=0;f=i;i=i+16|0;j=f;o=c[b>>2]|0;h=a+20|0;p=c[h>>2]|0;k=e+(p<<2)|0;p=p+ -3|0;l=e+(p<<2)|0;if((p|0)>0){n=e;m=0.0;do{t=+g[n>>2]- +g[o>>2];s=+g[n+4>>2]- +g[o+4>>2];r=+g[n+8>>2]- +g[o+8>>2];q=+g[n+12>>2]- +g[o+12>>2];m=m+(t*t+s*s+r*r+q*q);n=n+16|0;o=o+16|0}while(n>>>0<l>>>0)}else{n=e;m=0.0}if(n>>>0<k>>>0){while(1){t=+g[n>>2]- +g[o>>2];n=n+4|0;m=m+t*t;if(!(n>>>0<k>>>0)){break}else{o=o+4|0}}}s=+g[b+4>>2];t=+Kc[c[(c[d>>2]|0)+16>>2]&7](d);r=m-s-t;if(r>0.0?r*r-s*4.0*t>0.0:0){i=f;return}k=b+16|0;if((c[k>>2]|0)==(c[b+20>>2]|0)){a=b+12|0;if((c[a>>2]|0)<=0){i=f;return}k=b+28|0;b=0;do{p=c[k>>2]|0;j=c[p+(b<<3)>>2]|0;p=c[p+(b<<3)+4>>2]|0;o=c[h>>2]|0;l=p+(o<<2)|0;o=o+ -3|0;n=p+(o<<2)|0;if((o|0)>0){o=e;m=0.0;do{q=+g[p>>2]- +g[o>>2];r=+g[p+4>>2]- +g[o+4>>2];s=+g[p+8>>2]- +g[o+8>>2];t=+g[p+12>>2]- +g[o+12>>2];m=m+(q*q+r*r+s*s+t*t);p=p+16|0;o=o+16|0}while(p>>>0<n>>>0)}else{o=e;m=0.0}if(p>>>0<l>>>0){while(1){t=+g[p>>2]- +g[o>>2];p=p+4|0;m=m+t*t;if(!(p>>>0<l>>>0)){break}else{o=o+4|0}}}Ec[c[(c[d>>2]|0)+12>>2]&7](d,m,j);b=b+1|0}while((b|0)<(c[a>>2]|0));i=f;return}l=a+88|0;p=c[l>>2]|0;c[j>>2]=0;h=j+4|0;c[h>>2]=0;o=j+8|0;c[o>>2]=0;if((p|0)!=0){if(p>>>0>1073741823){ss(0)}v=Fv(p<<2)|0;c[h>>2]=v;c[j>>2]=v;n=v+(p<<2)|0;c[o>>2]=n;o=p;p=v;while(1){if((p|0)!=0){c[p>>2]=0}o=o+ -1|0;if((o|0)==0){break}else{p=p+4|0}}c[h>>2]=n}u=0;Qa(28,a|0,b|0,e|0,j|0);v=u;u=0;a:do{if(v&1){d=qb(-1,-1)|0;b=c[j>>2]|0}else{b=c[j>>2]|0;b:do{if((c[l>>2]|0)>0){j=0;while(1){u=0;Qa(29,a|0,c[(c[k>>2]|0)+(c[b+(j<<2)>>2]<<2)>>2]|0,d|0,e|0);v=u;u=0;if(v&1){break}j=j+1|0;if((j|0)>=(c[l>>2]|0)){break b}}d=qb(-1,-1)|0;break a}}while(0);if((b|0)==0){i=f;return}d=c[h>>2]|0;if((d|0)!=(b|0)){c[h>>2]=d+(~((d+ -4+(0-b)|0)>>>2)<<2)}Hv(b);i=f;return}}while(0);if((b|0)==0){vb(d|0)}f=c[h>>2]|0;if((f|0)!=(b|0)){c[h>>2]=f+(~((f+ -4+(0-b)|0)>>>2)<<2)}Hv(b);vb(d|0)}function kj(a,b,d,e,f,h,j){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,o=0.0,p=0,q=0,r=0,s=0.0,t=0.0,u=0.0,v=0.0;k=i;l=a+20|0;while(1){r=c[b>>2]|0;q=c[l>>2]|0;n=e+(q<<2)|0;q=q+ -3|0;p=e+(q<<2)|0;if((q|0)>0){q=e;o=0.0;do{v=+g[q>>2]- +g[r>>2];u=+g[q+4>>2]- +g[r+4>>2];t=+g[q+8>>2]- +g[r+8>>2];s=+g[q+12>>2]- +g[r+12>>2];o=o+(v*v+u*u+t*t+s*s);q=q+16|0;r=r+16|0}while(q>>>0<p>>>0);p=q}else{p=e;o=0.0}if(p>>>0<n>>>0){while(1){v=+g[p>>2]- +g[r>>2];p=p+4|0;o=o+v*v;if(!(p>>>0<n>>>0)){break}else{r=r+4|0}}}u=+g[b+4>>2];v=+Kc[c[(c[d>>2]|0)+16>>2]&7](d);t=o-u-v;if(t>0.0?t*t-u*4.0*v>0.0:0){m=19;break}n=b+16|0;if((c[n>>2]|0)==(c[b+20>>2]|0)){break}r=mj(a,b,e,j)|0;b=c[(c[n>>2]|0)+(r<<2)>>2]|0}if((m|0)==19){i=k;return}if((c[f>>2]|0)>=(h|0)?Bc[c[(c[d>>2]|0)+8>>2]&255](d)|0:0){i=k;return}j=b+12|0;if((c[j>>2]|0)<=0){i=k;return}m=b+28|0;b=0;do{q=c[m>>2]|0;a=c[q+(b<<3)>>2]|0;q=c[q+(b<<3)+4>>2]|0;r=c[l>>2]|0;h=q+(r<<2)|0;r=r+ -3|0;n=q+(r<<2)|0;if((r|0)>0){p=e;o=0.0;do{s=+g[q>>2]- +g[p>>2];t=+g[q+4>>2]- +g[p+4>>2];u=+g[q+8>>2]- +g[p+8>>2];v=+g[q+12>>2]- +g[p+12>>2];o=o+(s*s+t*t+u*u+v*v);q=q+16|0;p=p+16|0}while(q>>>0<n>>>0);n=q}else{n=q;p=e;o=0.0}if(n>>>0<h>>>0){while(1){v=+g[n>>2]- +g[p>>2];n=n+4|0;o=o+v*v;if(!(n>>>0<h>>>0)){break}else{p=p+4|0}}}Ec[c[(c[d>>2]|0)+12>>2]&7](d,o,a);c[f>>2]=(c[f>>2]|0)+1;b=b+1|0}while((b|0)<(c[j>>2]|0));i=k;return}function lj(a,b){a=a|0;b=b|0;var d=0.0,e=0,f=0,h=0,j=0.0,l=0,m=0,n=0,o=0.0,p=0,q=0,r=0,s=0;h=i;e=a+16|0;if((c[e>>2]|0)==0){q=0;i=h;return q|0}l=c[a>>2]|0;m=c[l+4>>2]|0;c[b>>2]=c[l>>2];c[b+4>>2]=m;b=c[a>>2]|0;a=a+4|0;m=c[a>>2]|0;l=m-b|0;if((l|0)>8?(f=m+ -8|0,q=b,p=c[q>>2]|0,q=c[q+4>>2]|0,r=f,m=c[r+4>>2]|0,n=b,c[n>>2]=c[r>>2],c[n+4>>2]=m,f,c[f>>2]=p,c[f+4>>2]=q,f=(l>>3)+ -1|0,(f|0)>1):0){if((f|0)!=2?!(+g[b+12>>2]<+g[b+20>>2]):0){n=b+16|0;p=2}else{n=b+8|0;p=1}if(+g[n+4>>2]<+g[b+4>>2]){l=b;m=c[l>>2]|0;l=c[l+4>>2]|0;j=(c[k>>2]=l,+g[k>>2]);q=b;while(1){s=n;r=c[s+4>>2]|0;c[q>>2]=c[s>>2];c[q+4>>2]=r;q=p<<1;p=q+2|0;if((p|0)>(f|0)){break}q=q|1;o=+g[b+(q<<3)+4>>2];if((p|0)!=(f|0)?(d=+g[b+(p<<3)+4>>2],!(o<d)):0){o=d}else{p=q}if(o<j){q=n;n=b+(p<<3)|0}else{break}}s=n;c[s>>2]=m;c[s+4>>2]=l}}s=c[a>>2]|0;c[a>>2]=s+(~((s+ -8+(0-(s+ -8))|0)>>>3)<<3);c[e>>2]=(c[e>>2]|0)+ -1;s=1;i=h;return s|0}function mj(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0.0,v=0,w=0.0,x=0.0,y=0.0,z=0.0;f=i;i=i+16|0;h=f;j=a+88|0;l=c[j>>2]|0;if((l|0)==0){k=0}else{if(l>>>0>1073741823){ss(0)}k=Fv(l<<2)|0;n=l;m=k;while(1){if((m|0)!=0){g[m>>2]=0.0}n=n+ -1|0;if((n|0)==0){break}else{m=m+4|0}}}b=b+16|0;p=c[b>>2]|0;r=c[c[p>>2]>>2]|0;n=c[a+20>>2]|0;o=d+(n<<2)|0;n=n+ -3|0;m=d+(n<<2)|0;n=(n|0)>0;if(n){q=d;t=0.0;do{z=+g[q>>2]- +g[r>>2];y=+g[q+4>>2]- +g[r+4>>2];x=+g[q+8>>2]- +g[r+8>>2];w=+g[q+12>>2]- +g[r+12>>2];t=t+(z*z+y*y+x*x+w*w);q=q+16|0;r=r+16|0}while(q>>>0<m>>>0)}else{q=d;t=0.0}if(q>>>0<o>>>0){while(1){z=+g[q>>2]- +g[r>>2];q=q+4|0;t=t+z*z;if(!(q>>>0<o>>>0)){break}else{r=r+4|0}}}g[k>>2]=t;if((l|0)>1){r=0;q=1;do{v=c[c[p+(q<<2)>>2]>>2]|0;if(n){s=d;t=0.0;do{w=+g[s>>2]- +g[v>>2];x=+g[s+4>>2]- +g[v+4>>2];y=+g[s+8>>2]- +g[v+8>>2];z=+g[s+12>>2]- +g[v+12>>2];t=t+(w*w+x*x+y*y+z*z);s=s+16|0;v=v+16|0}while(s>>>0<m>>>0)}else{s=d;t=0.0}if(s>>>0<o>>>0){while(1){z=+g[s>>2]- +g[v>>2];s=s+4|0;t=t+z*z;if(!(s>>>0<o>>>0)){break}else{v=v+4|0}}}g[k+(q<<2)>>2]=t;r=t<+g[k+(r<<2)>>2]?q:r;q=q+1|0}while((q|0)<(l|0))}else{r=0}a:do{if((l|0)>0){d=a+100|0;a=h+4|0;m=0;while(1){if((m|0)!=(r|0)){v=c[(c[b>>2]|0)+(m<<2)>>2]|0;s=k+(m<<2)|0;z=+g[s>>2]- +g[d>>2]*+g[v+8>>2];g[s>>2]=z;c[h>>2]=v;g[a>>2]=z;u=0;oa(114,e|0,h|0);v=u;u=0;if(v&1){break}l=c[j>>2]|0}m=m+1|0;if((m|0)>=(l|0)){break a}}f=qb(-1,-1)|0;if((k|0)==0){vb(f|0)}Hv(k);vb(f|0)}}while(0);if((k|0)==0){i=f;return r|0}Hv(k);i=f;return r|0}function nj(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,h=0,j=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0.0,u=0;d=i;e=a+16|0;if((c[e>>2]|0)==(c[a+12>>2]|0)){i=d;return}j=a+4|0;n=c[j>>2]|0;m=a+8|0;if((n|0)==(c[m>>2]|0)){l=c[a>>2]|0;n=n-l|0;s=n>>3;q=s+1|0;if(q>>>0>536870911){ss(0)}if(s>>>0<268435455){r=n>>2;r=r>>>0<q>>>0?q:r;if((r|0)==0){p=0;r=0}else{o=10}}else{r=536870911;o=10}if((o|0)==10){p=r;r=Fv(r<<3)|0}o=r+(s<<3)|0;if((o|0)!=0){u=b;b=c[u+4>>2]|0;s=o;c[s>>2]=c[u>>2];c[s+4>>2]=b}b=r+(q<<3)|0;tw(r|0,l|0,n|0)|0;c[a>>2]=r;c[j>>2]=b;c[m>>2]=r+(p<<3);if((l|0)!=0){Hv(l);b=c[j>>2]|0}}else{if((n|0)==0){l=0}else{s=b;u=c[s+4>>2]|0;l=n;c[l>>2]=c[s>>2];c[l+4>>2]=u;l=c[j>>2]|0}b=l+8|0;c[j>>2]=b}j=c[a>>2]|0;a=b-j|0;if((a|0)>8?(h=((a>>3)+ -2|0)/2|0,f=b+ -8|0,+g[b+ -4>>2]<+g[j+(h<<3)+4>>2]):0){l=f;a=c[l>>2]|0;l=c[l+4>>2]|0;t=(c[k>>2]=l,+g[k>>2]);do{u=f;f=j+(h<<3)|0;r=f;s=c[r+4>>2]|0;c[u>>2]=c[r>>2];c[u+4>>2]=s;if((h|0)==0){break}h=(h+ -1|0)/2|0}while(t<+g[j+(h<<3)+4>>2]);u=f;c[u>>2]=a;c[u+4>>2]=l}c[e>>2]=(c[e>>2]|0)+1;i=d;return}function oj(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0,k=0,l=0,m=0.0,n=0,o=0,p=0,q=0.0,r=0.0,s=0.0,t=0.0;f=i;h=a+88|0;l=c[h>>2]|0;if((l|0)==0){i=f;return}if(l>>>0>1073741823){ss(0)}j=Fv(l<<2)|0;k=l;n=j;while(1){if((n|0)!=0){g[n>>2]=0.0}k=k+ -1|0;if((k|0)==0){break}else{n=n+4|0}}if((l|0)>0){k=c[b+16>>2]|0;a=a+20|0;l=c[e>>2]|0;e=0;do{p=c[c[k+(e<<2)>>2]>>2]|0;o=c[a>>2]|0;b=d+(o<<2)|0;o=o+ -3|0;n=d+(o<<2)|0;if((o|0)>0){o=d;m=0.0;do{t=+g[o>>2]- +g[p>>2];s=+g[o+4>>2]- +g[p+4>>2];r=+g[o+8>>2]- +g[p+8>>2];q=+g[o+12>>2]- +g[p+12>>2];m=m+(t*t+s*s+r*r+q*q);o=o+16|0;p=p+16|0}while(o>>>0<n>>>0);n=o}else{n=d;m=0.0}if(n>>>0<b>>>0){while(1){t=+g[n>>2]- +g[p>>2];n=n+4|0;m=m+t*t;if(!(n>>>0<b>>>0)){break}else{p=p+4|0}}}b=0;while(1){n=j+(b<<2)|0;o=(b|0)<(e|0);if(!(+g[n>>2]<m&o)){break}b=b+1|0}if(o){o=e;do{p=o;o=o+ -1|0;g[j+(p<<2)>>2]=+g[j+(o<<2)>>2];c[l+(p<<2)>>2]=c[l+(o<<2)>>2]}while((o|0)>(b|0))}g[n>>2]=m;c[l+(b<<2)>>2]=e;e=e+1|0}while((e|0)<(c[h>>2]|0))}if((j|0)==0){i=f;return}Hv(j);i=f;return}function pj(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0,k=0,l=0,m=0,n=0.0,o=0,p=0,q=0,r=0.0,s=0.0,t=0.0,v=0.0;f=i;i=i+16|0;j=f;o=c[b>>2]|0;h=a+20|0;q=c[h>>2]|0;k=e+(q<<2)|0;q=q+ -3|0;l=e+(q<<2)|0;if((q|0)>0){m=e;n=0.0;do{v=+g[m>>2]- +g[o>>2];t=+g[m+4>>2]- +g[o+4>>2];s=+g[m+8>>2]- +g[o+8>>2];r=+g[m+12>>2]- +g[o+12>>2];n=n+(v*v+t*t+s*s+r*r);m=m+16|0;o=o+16|0}while(m>>>0<l>>>0);l=m}else{l=e;n=0.0}if(l>>>0<k>>>0){while(1){v=+g[l>>2]- +g[o>>2];l=l+4|0;n=n+v*v;if(!(l>>>0<k>>>0)){break}else{o=o+4|0}}}t=+g[b+4>>2];v=+Kc[c[(c[d>>2]|0)+16>>2]&7](d);s=n-t-v;if(s>0.0?s*s-t*4.0*v>0.0:0){i=f;return}k=b+16|0;if((c[k>>2]|0)==(c[b+20>>2]|0)){j=b+12|0;m=c[j>>2]|0;if((m|0)<=0){i=f;return}b=b+28|0;a=a+40|0;k=0;do{o=c[b>>2]|0;l=c[o+(k<<3)>>2]|0;if((c[(c[a>>2]|0)+(l>>>5<<2)>>2]&1<<(l&31)|0)==0){p=c[o+(k<<3)+4>>2]|0;q=c[h>>2]|0;m=p+(q<<2)|0;q=q+ -3|0;o=p+(q<<2)|0;if((q|0)>0){q=e;n=0.0;do{r=+g[p>>2]- +g[q>>2];s=+g[p+4>>2]- +g[q+4>>2];t=+g[p+8>>2]- +g[q+8>>2];v=+g[p+12>>2]- +g[q+12>>2];n=n+(r*r+s*s+t*t+v*v);p=p+16|0;q=q+16|0}while(p>>>0<o>>>0);o=p}else{o=p;q=e;n=0.0}if(o>>>0<m>>>0){while(1){v=+g[o>>2]- +g[q>>2];o=o+4|0;n=n+v*v;if(!(o>>>0<m>>>0)){break}else{q=q+4|0}}}Ec[c[(c[d>>2]|0)+12>>2]&7](d,n,l);m=c[j>>2]|0}k=k+1|0}while((k|0)<(m|0));i=f;return}l=a+88|0;p=c[l>>2]|0;c[j>>2]=0;h=j+4|0;c[h>>2]=0;o=j+8|0;c[o>>2]=0;if((p|0)!=0){if(p>>>0>1073741823){ss(0)}q=Fv(p<<2)|0;c[h>>2]=q;c[j>>2]=q;m=q+(p<<2)|0;c[o>>2]=m;o=q;while(1){if((o|0)!=0){c[o>>2]=0}p=p+ -1|0;if((p|0)==0){break}else{o=o+4|0}}c[h>>2]=m}u=0;Qa(28,a|0,b|0,e|0,j|0);q=u;u=0;a:do{if(q&1){f=qb(-1,-1)|0;b=c[j>>2]|0}else{b=c[j>>2]|0;b:do{if((c[l>>2]|0)>0){j=0;while(1){u=0;Qa(30,a|0,c[(c[k>>2]|0)+(c[b+(j<<2)>>2]<<2)>>2]|0,d|0,e|0);q=u;u=0;if(q&1){break}j=j+1|0;if((j|0)>=(c[l>>2]|0)){break b}}f=qb(-1,-1)|0;break a}}while(0);if((b|0)==0){i=f;return}e=c[h>>2]|0;if((e|0)!=(b|0)){c[h>>2]=e+(~((e+ -4+(0-b)|0)>>>2)<<2)}Hv(b);i=f;return}}while(0);if((b|0)==0){vb(f|0)}e=c[h>>2]|0;if((e|0)!=(b|0)){c[h>>2]=e+(~((e+ -4+(0-b)|0)>>>2)<<2)}Hv(b);vb(f|0)}function qj(a,b,d,e,f,h,j){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0.0,q=0,r=0,s=0.0,t=0.0,u=0.0,v=0.0;l=i;k=a+20|0;while(1){r=c[b>>2]|0;q=c[k>>2]|0;n=e+(q<<2)|0;q=q+ -3|0;o=e+(q<<2)|0;if((q|0)>0){q=e;p=0.0;do{v=+g[q>>2]- +g[r>>2];u=+g[q+4>>2]- +g[r+4>>2];t=+g[q+8>>2]- +g[r+8>>2];s=+g[q+12>>2]- +g[r+12>>2];p=p+(v*v+u*u+t*t+s*s);q=q+16|0;r=r+16|0}while(q>>>0<o>>>0);o=r}else{q=e;o=r;p=0.0}if(q>>>0<n>>>0){while(1){v=+g[q>>2]- +g[o>>2];q=q+4|0;p=p+v*v;if(!(q>>>0<n>>>0)){break}else{o=o+4|0}}}u=+g[b+4>>2];v=+Kc[c[(c[d>>2]|0)+16>>2]&7](d);t=p-u-v;if(t>0.0?t*t-u*4.0*v>0.0:0){m=21;break}n=b+16|0;if((c[n>>2]|0)==(c[b+20>>2]|0)){break}r=mj(a,b,e,j)|0;b=c[(c[n>>2]|0)+(r<<2)>>2]|0}if((m|0)==21){i=l;return}if((c[f>>2]|0)>=(h|0)?Bc[c[(c[d>>2]|0)+8>>2]&255](d)|0:0){i=l;return}m=b+12|0;o=c[m>>2]|0;if((o|0)<=0){i=l;return}b=b+28|0;a=a+40|0;h=0;do{n=c[b>>2]|0;j=c[n+(h<<3)>>2]|0;if((c[(c[a>>2]|0)+(j>>>5<<2)>>2]&1<<(j&31)|0)==0){q=c[n+(h<<3)+4>>2]|0;r=c[k>>2]|0;n=q+(r<<2)|0;r=r+ -3|0;o=q+(r<<2)|0;if((r|0)>0){r=e;p=0.0;do{s=+g[q>>2]- +g[r>>2];t=+g[q+4>>2]- +g[r+4>>2];u=+g[q+8>>2]- +g[r+8>>2];v=+g[q+12>>2]- +g[r+12>>2];p=p+(s*s+t*t+u*u+v*v);q=q+16|0;r=r+16|0}while(q>>>0<o>>>0);o=r}else{o=e;p=0.0}if(q>>>0<n>>>0){while(1){v=+g[q>>2]- +g[o>>2];q=q+4|0;p=p+v*v;if(!(q>>>0<n>>>0)){break}else{o=o+4|0}}}Ec[c[(c[d>>2]|0)+12>>2]&7](d,p,j);c[f>>2]=(c[f>>2]|0)+1;o=c[m>>2]|0}h=h+1|0}while((h|0)<(o|0));i=l;return}function rj(a,b,d,e){a=a|0;b=b|0;d=d|0;e=+e;var f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0.0,r=0,s=0,t=0,v=0,w=0.0,x=0.0,y=0.0,z=0.0;f=i;i=i+16|0;k=f;h=c[(c[a+72>>2]|0)+(d<<2)>>2]|0;j=b+4|0;if(+g[j>>2]<e){g[j>>2]=e}j=b+12|0;s=c[j>>2]|0;t=b+8|0;v=s+1|0;g[t>>2]=(+(s|0)*+g[t>>2]+e)/+(v|0);c[j>>2]=v;j=c[b+16>>2]|0;if((j|0)!=(c[b+20>>2]|0)){n=c[j>>2]|0;p=c[n>>2]|0;b=c[a+20>>2]|0;m=p+(b<<2)|0;k=b+ -3|0;o=p+(k<<2)|0;l=(k|0)>0;if(l){r=h;e=0.0;do{y=+g[p>>2]- +g[r>>2];x=+g[p+4>>2]- +g[r+4>>2];w=+g[p+8>>2]- +g[r+8>>2];q=+g[p+12>>2]- +g[r+12>>2];e=e+(y*y+x*x+w*w+q*q);p=p+16|0;r=r+16|0}while(p>>>0<o>>>0);o=p;p=r}else{o=p;p=h;e=0.0}if(o>>>0<m>>>0){while(1){y=+g[o>>2]- +g[p>>2];o=o+4|0;e=e+y*y;if(!(o>>>0<m>>>0)){break}else{p=p+4|0}}}m=c[a+88>>2]|0;if(m>>>0>1){n=0;o=1;do{t=c[c[j+(o<<2)>>2]>>2]|0;p=t+(b<<2)|0;r=t+(k<<2)|0;if(l){s=h;q=0.0;do{z=+g[t>>2]- +g[s>>2];w=+g[t+4>>2]- +g[s+4>>2];x=+g[t+8>>2]- +g[s+8>>2];y=+g[t+12>>2]- +g[s+12>>2];q=q+(z*z+w*w+x*x+y*y);t=t+16|0;s=s+16|0}while(t>>>0<r>>>0)}else{s=h;q=0.0}if(t>>>0<p>>>0){while(1){z=+g[t>>2]- +g[s>>2];t=t+4|0;q=q+z*z;if(!(t>>>0<p>>>0)){break}else{s=s+4|0}}}v=q<e;n=v?o:n;e=v?q:e;o=o+1|0}while(o>>>0<m>>>0);n=c[j+(n<<2)>>2]|0}rj(a,n,d,e);i=f;return}l=b+28|0;j=b+32|0;p=c[j>>2]|0;n=b+36|0;if((p|0)==(c[n>>2]|0)){o=c[l>>2]|0;p=p-o|0;t=p>>3;s=t+1|0;if(s>>>0>536870911){ss(0)}if(t>>>0<268435455){v=p>>2;v=v>>>0<s>>>0?s:v;if((v|0)==0){r=0;v=0}else{m=12}}else{v=536870911;m=12}if((m|0)==12){r=v;v=Fv(v<<3)|0}m=v+(t<<3)|0;if((m|0)!=0){t=m;c[t>>2]=d;c[t+4>>2]=h}m=v+(s<<3)|0;tw(v|0,o|0,p|0)|0;c[l>>2]=v;c[j>>2]=m;c[n>>2]=v+(r<<3);if((o|0)!=0){Hv(o);m=c[j>>2]|0}}else{if((p|0)==0){d=0}else{v=p;c[v>>2]=d;c[v+4>>2]=h;d=c[j>>2]|0}m=d+8|0;c[j>>2]=m}j=c[l>>2]|0;l=m-j|0;h=l>>3;c[k>>2]=0;d=k+4|0;c[d>>2]=0;o=k+8|0;c[o>>2]=0;if((h|0)==0){l=0}else{if(h>>>0>1073741823){ss(0)}l=Fv(l>>1)|0;c[d>>2]=l;c[k>>2]=l;n=l+(h<<2)|0;c[o>>2]=n;p=h;o=l;while(1){if((o|0)!=0){c[o>>2]=0}p=p+ -1|0;if((p|0)==0){break}else{o=o+4|0}}c[d>>2]=n}if((m|0)!=(j|0)){m=0;do{c[l+(m<<2)>>2]=c[j+(m<<3)>>2];m=m+1|0}while(m>>>0<h>>>0)}u=0;Na(53,a|0,b|0,k|0);v=u;u=0;do{if(!(v&1)){h=c[d>>2]|0;m=c[k>>2]|0;n=m;j=h-n>>2;l=c[a+88>>2]|0;if(!(j>>>0<l>>>0)?(u=0,ma(5,a|0,b|0,m|0,j|0,l|0),v=u,u=0,v&1):0){break}if((m|0)==0){i=f;return}if((h|0)!=(m|0)){c[d>>2]=h+(~((h+ -4+(0-n)|0)>>>2)<<2)}Hv(m);i=f;return}}while(0);a=qb(-1,-1)|0;f=c[k>>2]|0;if((f|0)==0){vb(a|0)}h=c[d>>2]|0;if((h|0)!=(f|0)){c[d>>2]=h+(~((h+ -4+(0-f)|0)>>>2)<<2)}Hv(f);vb(a|0)}function sj(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,h=0,j=0,k=0;j=i;Le(a,b);c[a>>2]=6584;c[a+88>>2]=c[b+88>>2];c[a+92>>2]=c[b+92>>2];c[a+96>>2]=c[b+96>>2];g[a+100>>2]=+g[b+100>>2];c[a+120>>2]=8192;e=a+108|0;c[e>>2]=0;d=a+112|0;c[d>>2]=0;f=a+124|0;c[f>>2]=0;h=a+128|0;c[h>>2]=0;c[a+132>>2]=c[b+132>>2];u=0;na(201,a|0);k=u;u=0;if(!(k&1)?(u=0,Na(54,a|0,a+104|0,b+104|0),k=u,u=0,!(k&1)):0){i=j;return}j=qb(-1,-1)|0;b=c[d>>2]|0;if((b|0)!=0){do{k=b;b=c[b>>2]|0;Bv(k);c[d>>2]=b}while((b|0)!=0)}c[d>>2]=0;c[e>>2]=0;c[f>>2]=0;c[h>>2]=0;u=0;na(186,a|0);k=u;u=0;if(k&1){k=qb(-1,-1,0)|0;jd(k)}else{vb(j|0)}}function tj(a){a=a|0;var b=0,d=0;b=i;d=c[a+96>>2]|0;if((d|0)==1){d=Fv(28)|0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;c[d+16>>2]=-1;c[d+20>>2]=0;c[d>>2]=3896;c[a+136>>2]=d;i=b;return}else if((d|0)==2){d=Fv(28)|0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;c[d+16>>2]=-1;c[d+20>>2]=0;c[d>>2]=3664;c[a+136>>2]=d;i=b;return}else if((d|0)!=0){a=Jb(8)|0;u=0;oa(75,a|0,3608);d=u;u=0;if(d&1){d=qb(-1,-1)|0;pb(a|0);vb(d|0)}else{c[a>>2]=288;qc(a|0,264,1)}}else{d=Fv(28)|0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;c[d+16>>2]=-1;c[d+20>>2]=0;c[d>>2]=4008;c[a+136>>2]=d;i=b;return}}function uj(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0;e=i;j=a+108|0;l=c[j>>2]|0;do{if((l|0)<48){k=a+128|0;c[k>>2]=(c[k>>2]|0)+l;k=Av(8192)|0;if((k|0)==0){zb(3048,27,1,c[r>>2]|0)|0;k=0;break}else{l=a+112|0;c[k>>2]=c[l>>2];c[l>>2]=k;c[j>>2]=8188;k=k+4|0;c[a+116>>2]=k;l=8140;h=6;break}}else{k=c[a+116>>2]|0;l=l+ -48|0;h=6}}while(0);if((h|0)==6){c[a+116>>2]=k+48;c[j>>2]=l;n=a+124|0;c[n>>2]=(c[n>>2]|0)+48}j=k+0|0;h=j+40|0;do{c[j>>2]=0;j=j+4|0}while((j|0)<(h|0));c[b>>2]=k;j=c[a+20>>2]|0;h=Gv(j>>>0>1073741823?-1:j<<2)|0;c[k>>2]=h;vw(c[c[b>>2]>>2]|0,c[c[d>>2]>>2]|0,j<<2|0)|0;j=c[d>>2]|0;k=c[b>>2]|0;g[k+4>>2]=+g[j+4>>2];g[k+8>>2]=+g[j+8>>2];c[k+12>>2]=c[j+12>>2];h=(c[j+20>>2]|0)-(c[j+16>>2]|0)>>2;if((h|0)==0){if((k|0)==(j|0)){i=e;return}vj(k+28|0,c[j+28>>2]|0,c[j+32>>2]|0);i=e;return}j=k+16|0;l=k+20|0;k=c[l>>2]|0;m=c[j>>2]|0;n=k-m>>2;if(!(n>>>0<h>>>0)){if(n>>>0>h>>>0?(f=m+(h<<2)|0,(k|0)!=(f|0)):0){c[l>>2]=k+(~((k+ -4+(0-f)|0)>>>2)<<2)}}else{ej(j,h-n|0)}n=c[d>>2]|0;h=c[n+16>>2]|0;if((c[n+20>>2]|0)==(h|0)){i=e;return}else{f=0}do{uj(a,(c[(c[b>>2]|0)+16>>2]|0)+(f<<2)|0,h+(f<<2)|0);f=f+1|0;n=c[d>>2]|0;h=c[n+16>>2]|0}while(f>>>0<(c[n+20>>2]|0)-h>>2>>>0);i=e;return}function vj(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0;e=i;k=b;h=d-k>>3;f=a+8|0;m=c[f>>2]|0;j=c[a>>2]|0;l=j;if(!(h>>>0>m-l>>3>>>0)){a=a+4|0;f=(c[a>>2]|0)-l|0;g=f>>3;if(!(h>>>0>g>>>0)){d=d-k|0;vw(j|0,b|0,d|0)|0;b=j+(d>>3<<3)|0;d=c[a>>2]|0;if((d|0)==(b|0)){i=e;return}c[a>>2]=d+(~((d+ -8+(0-b)|0)>>>3)<<3);i=e;return}g=b+(g<<3)|0;vw(j|0,b|0,f|0)|0;if((g|0)==(d|0)){i=e;return}b=c[a>>2]|0;do{if((b|0)==0){b=0}else{l=g;m=c[l+4>>2]|0;c[b>>2]=c[l>>2];c[b+4>>2]=m;b=c[a>>2]|0}b=b+8|0;c[a>>2]=b;g=g+8|0}while((g|0)!=(d|0));i=e;return}if((j|0)!=0){m=a+4|0;k=c[m>>2]|0;if((k|0)!=(j|0)){c[m>>2]=k+(~((k+ -8+(0-l)|0)>>>3)<<3)}Hv(j);c[f>>2]=0;c[m>>2]=0;c[a>>2]=0;m=0}if(h>>>0>536870911){ss(0)}if(m>>3>>>0<268435455){m=m>>2;h=m>>>0<h>>>0?h:m;if(h>>>0>536870911){ss(0)}else{g=h}}else{g=536870911}j=Fv(g<<3)|0;h=a+4|0;c[h>>2]=j;c[a>>2]=j;c[f>>2]=j+(g<<3);if((b|0)==(d|0)){i=e;return}do{if((j|0)==0){a=0}else{l=b;m=c[l+4>>2]|0;a=j;c[a>>2]=c[l>>2];c[a+4>>2]=m;a=c[h>>2]|0}j=a+8|0;c[h>>2]=j;b=b+8|0}while((b|0)!=(d|0));i=e;return}function wj(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0;d=i;i=i+16|0;f=d+4|0;h=d;e=b+4|0;zb(c[a>>2]|0,c[(c[b>>2]|0)+20>>2]<<2|0,1,c[e>>2]|0)|0;zb(a+4|0,4,1,c[e>>2]|0)|0;zb(a+8|0,4,1,c[e>>2]|0)|0;zb(a+12|0,4,1,c[e>>2]|0)|0;g=a+16|0;c[h>>2]=(c[a+20>>2]|0)-(c[g>>2]|0)>>2;zb(h|0,4,1,c[e>>2]|0)|0;h=c[h>>2]|0;if((h|0)!=0){e=0;do{wj(c[(c[g>>2]|0)+(e<<2)>>2]|0,b);e=e+1|0}while(e>>>0<h>>>0);i=d;return}g=a+32|0;a=a+28|0;c[f>>2]=(c[g>>2]|0)-(c[a>>2]|0)>>3;zb(f|0,4,1,c[e>>2]|0)|0;f=c[a>>2]|0;if((c[g>>2]|0)==(f|0)){i=d;return}else{h=0}do{zb(f+(h<<3)|0,4,1,c[e>>2]|0)|0;h=h+1|0;f=c[a>>2]|0}while(h>>>0<(c[g>>2]|0)-f>>3>>>0);i=d;return}function xj(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0;g=i;i=i+144|0;h=g+140|0;j=g+128|0;m=g+124|0;n=g+112|0;s=g+108|0;t=g+96|0;A=g+92|0;z=g+80|0;H=g+76|0;I=g+64|0;C=g+52|0;F=g+48|0;v=g+36|0;o=g+24|0;k=g+12|0;e=g;c[d>>2]=b;Vf(b,d);w=b+88|0;K=d+4|0;if((Sa(w|0,4,1,c[K>>2]|0)|0)!=1){e=Jb(8)|0;u=0;oa(75,e|0,2592);N=u;u=0;if(N&1){N=qb(-1,-1)|0;pb(e|0);vb(N|0)}else{c[e>>2]=288;qc(e|0,264,1)}}q=b+92|0;if((Sa(q|0,4,1,c[K>>2]|0)|0)!=1){e=Jb(8)|0;u=0;oa(75,e|0,2592);N=u;u=0;if(N&1){N=qb(-1,-1)|0;pb(e|0);vb(N|0)}else{c[e>>2]=288;qc(e|0,264,1)}}if((Sa(b+132|0,4,1,c[K>>2]|0)|0)!=1){e=Jb(8)|0;u=0;oa(75,e|0,2592);N=u;u=0;if(N&1){N=qb(-1,-1)|0;pb(e|0);vb(N|0)}else{c[e>>2]=288;qc(e|0,264,1)}}f=b+100|0;if((Sa(f|0,4,1,c[K>>2]|0)|0)!=1){e=Jb(8)|0;u=0;oa(75,e|0,2592);N=u;u=0;if(N&1){N=qb(-1,-1)|0;pb(e|0);vb(N|0)}else{c[e>>2]=288;qc(e|0,264,1)}}l=b+96|0;if((Sa(h|0,4,1,c[K>>2]|0)|0)!=1){e=Jb(8)|0;u=0;oa(75,e|0,2592);N=u;u=0;if(N&1){N=qb(-1,-1)|0;pb(e|0);vb(N|0)}else{c[e>>2]=288;qc(e|0,264,1)}}c[l>>2]=c[h>>2];K=b+108|0;M=c[K>>2]|0;do{if((M|0)<48){L=b+128|0;c[L>>2]=(c[L>>2]|0)+M;L=Av(8192)|0;if((L|0)==0){zb(3048,27,1,c[r>>2]|0)|0;N=0;break}else{M=b+112|0;c[L>>2]=c[M>>2];c[M>>2]=L;c[K>>2]=8188;L=L+4|0;c[b+116>>2]=L;M=8140;p=26;break}}else{L=c[b+116>>2]|0;M=M+ -48|0;p=26}}while(0);if((p|0)==26){c[b+116>>2]=L+48;c[K>>2]=M;N=b+124|0;c[N>>2]=(c[N>>2]|0)+48;N=L}M=b+104|0;K=N+0|0;L=K+40|0;do{c[K>>2]=0;K=K+4|0}while((K|0)<(L|0));c[M>>2]=N;yj(N,d);d=b+24|0;a[C>>0]=18;K=C+1|0;M=320|0;L=K+9|0;do{a[K>>0]=a[M>>0]|0;K=K+1|0;M=M+1|0}while((K|0)<(L|0));a[C+10>>0]=0;K=Pf(d,H,C)|0;L=c[K>>2]|0;if((L|0)==0){u=0;Na(43,I|0,d|0,C|0);N=u;u=0;if(!(N&1)){J=c[I>>2]|0;c[I>>2]=0;p=c[H>>2]|0;c[J>>2]=0;c[J+4>>2]=0;c[J+8>>2]=p;c[K>>2]=J;p=c[c[d>>2]>>2]|0;if((p|0)==0){p=J}else{c[d>>2]=p;p=c[K>>2]|0}ge(c[b+28>>2]|0,p);p=b+32|0;c[p>>2]=(c[p>>2]|0)+1;p=32}}else{J=L;p=32}if(((p|0)==32?(u=0,E=qa(c[(c[b>>2]|0)+16>>2]|0,b|0)|0,N=u,u=0,!(N&1)):0)?(c[F>>2]=E,D=J+28|0,N=c[D>>2]|0,G=J+32|0,u=0,oa(c[c[N>>2]>>2]|0,N|0,G|0),N=u,u=0,!(N&1)):0){if((a[2072]|0)==0?(Ua(2072)|0)!=0:0){c[516]=2088;rb(2072)}c[D>>2]=2064;if((a[2336]|0)==0?(Ua(2336)|0)!=0:0){c[582]=2352;rb(2336)}c[D>>2]=2328;u=0;Na(c[(c[582]|0)+4>>2]|0,2328,F|0,G|0);N=u;u=0;if(!(N&1)){if(!((a[C>>0]&1)==0)){Hv(c[C+8>>2]|0)}a[v>>0]=18;K=v+1|0;M=2880|0;L=K+9|0;do{a[K>>0]=a[M>>0]|0;K=K+1|0;M=M+1|0}while((K|0)<(L|0));a[v+10>>0]=0;C=Pf(d,A,v)|0;D=c[C>>2]|0;if((D|0)==0){u=0;Na(43,z|0,d|0,v|0);N=u;u=0;if(!(N&1)){B=c[z>>2]|0;c[z>>2]=0;p=c[A>>2]|0;c[B>>2]=0;c[B+4>>2]=0;c[B+8>>2]=p;c[C>>2]=B;p=c[c[d>>2]>>2]|0;if((p|0)==0){p=B}else{c[d>>2]=p;p=c[C>>2]|0}ge(c[b+28>>2]|0,p);p=b+32|0;c[p>>2]=(c[p>>2]|0)+1;p=48}}else{B=D;p=48}if((p|0)==48?(y=B+28|0,N=c[y>>2]|0,x=B+32|0,u=0,oa(c[c[N>>2]>>2]|0,N|0,x|0),N=u,u=0,!(N&1)):0){if((a[2072]|0)==0?(Ua(2072)|0)!=0:0){c[516]=2088;rb(2072)}c[y>>2]=2064;do{if((a[3440]|0)==0){if((Ua(3440)|0)==0){break}c[858]=3456;rb(3440)}}while(0);c[y>>2]=3432;u=0;Na(c[(c[858]|0)+4>>2]|0,3432,w|0,x|0);N=u;u=0;if(!(N&1)){if(!((a[v>>0]&1)==0)){Hv(c[v+8>>2]|0)}a[o>>0]=20;K=o+1|0;M=6432|0;L=K+10|0;do{a[K>>0]=a[M>>0]|0;K=K+1|0;M=M+1|0}while((K|0)<(L|0));a[o+11>>0]=0;v=Pf(d,s,o)|0;w=c[v>>2]|0;do{if((w|0)==0){u=0;Na(43,t|0,d|0,o|0);N=u;u=0;if(N&1){break}p=c[t>>2]|0;c[t>>2]=0;s=c[s>>2]|0;c[p>>2]=0;c[p+4>>2]=0;c[p+8>>2]=s;c[v>>2]=p;s=c[c[d>>2]>>2]|0;if((s|0)==0){s=p}else{c[d>>2]=s;s=c[v>>2]|0}ge(c[b+28>>2]|0,s);w=b+32|0;c[w>>2]=(c[w>>2]|0)+1;w=p;p=63}else{p=63}}while(0);do{if((p|0)==63){s=w+28|0;N=c[s>>2]|0;t=w+32|0;u=0;oa(c[c[N>>2]>>2]|0,N|0,t|0);N=u;u=0;if(N&1){break}do{if((a[2072]|0)==0){if((Ua(2072)|0)==0){break}c[516]=2088;rb(2072)}}while(0);c[s>>2]=2064;do{if((a[3440]|0)==0){if((Ua(3440)|0)==0){break}c[858]=3456;rb(3440)}}while(0);c[s>>2]=3432;u=0;Na(c[(c[858]|0)+4>>2]|0,3432,q|0,t|0);N=u;u=0;if(N&1){break}if(!((a[o>>0]&1)==0)){Hv(c[o+8>>2]|0)}q=Fv(16)|0;o=k+8|0;c[o>>2]=q;c[k>>2]=17;c[k+4>>2]=12;K=q+0|0;M=2896|0;L=K+12|0;do{a[K>>0]=a[M>>0]|0;K=K+1|0;M=M+1|0}while((K|0)<(L|0));a[q+12>>0]=0;q=Pf(d,m,k)|0;s=c[q>>2]|0;do{if((s|0)==0){u=0;Na(43,n|0,d|0,k|0);N=u;u=0;if(N&1){break}p=c[n>>2]|0;c[n>>2]=0;m=c[m>>2]|0;c[p>>2]=0;c[p+4>>2]=0;c[p+8>>2]=m;c[q>>2]=p;m=c[c[d>>2]>>2]|0;if((m|0)==0){m=p}else{c[d>>2]=m;m=c[q>>2]|0}ge(c[b+28>>2]|0,m);s=b+32|0;c[s>>2]=(c[s>>2]|0)+1;s=p;p=78}else{p=78}}while(0);do{if((p|0)==78){m=s+28|0;N=c[m>>2]|0;n=s+32|0;u=0;oa(c[c[N>>2]>>2]|0,N|0,n|0);N=u;u=0;if(N&1){break}do{if((a[2072]|0)==0){if((Ua(2072)|0)==0){break}c[516]=2088;rb(2072)}}while(0);c[m>>2]=2064;do{if((a[3176]|0)==0){if((Ua(3176)|0)==0){break}c[792]=3192;rb(3176)}}while(0);c[m>>2]=3168;u=0;Na(c[(c[792]|0)+4>>2]|0,3168,l|0,n|0);N=u;u=0;if(N&1){break}if(!((a[k>>0]&1)==0)){Hv(c[o>>2]|0)}a[e>>0]=16;k=e+1|0;l=k;a[l>>0]=1767858787;a[l+1>>0]=6905698;a[l+2>>0]=26975;a[l+3>>0]=105;k=k+4|0;a[k>>0]=2019910766;a[k+1>>0]=7890276;a[k+2>>0]=30821;a[k+3>>0]=120;a[e+9>>0]=0;k=Pf(d,h,e)|0;l=c[k>>2]|0;do{if((l|0)==0){u=0;Na(43,j|0,d|0,e|0);N=u;u=0;if(N&1){break}l=c[j>>2]|0;c[j>>2]=0;h=c[h>>2]|0;c[l>>2]=0;c[l+4>>2]=0;c[l+8>>2]=h;c[k>>2]=l;h=c[c[d>>2]>>2]|0;if((h|0)==0){h=l}else{c[d>>2]=h;h=c[k>>2]|0}ge(c[b+28>>2]|0,h);p=b+32|0;c[p>>2]=(c[p>>2]|0)+1;p=93}else{p=93}}while(0);do{if((p|0)==93){b=l+28|0;N=c[b>>2]|0;h=l+32|0;u=0;oa(c[c[N>>2]>>2]|0,N|0,h|0);N=u;u=0;if(N&1){break}do{if((a[2072]|0)==0){if((Ua(2072)|0)==0){break}c[516]=2088;rb(2072)}}while(0);c[b>>2]=2064;do{if((a[4520]|0)==0){if((Ua(4520)|0)==0){break}c[1128]=4536;rb(4520)}}while(0);c[b>>2]=4512;u=0;Na(c[(c[1128]|0)+4>>2]|0,4512,f|0,h|0);N=u;u=0;if(N&1){break}if((a[e>>0]&1)==0){i=g;return}Hv(c[e+8>>2]|0);i=g;return}}while(0);f=qb(-1,-1)|0;if((a[e>>0]&1)==0){N=f;vb(N|0)}Hv(c[e+8>>2]|0);N=f;vb(N|0)}}while(0);e=qb(-1,-1)|0;if((a[k>>0]&1)==0){N=e;vb(N|0)}Hv(c[o>>2]|0);N=e;vb(N|0)}}while(0);e=qb(-1,-1)|0;if((a[o>>0]&1)==0){N=e;vb(N|0)}Hv(c[o+8>>2]|0);N=e;vb(N|0)}}e=qb(-1,-1)|0;if((a[v>>0]&1)==0){N=e;vb(N|0)}Hv(c[v+8>>2]|0);N=e;vb(N|0)}}e=qb(-1,-1)|0;if((a[C>>0]&1)==0){N=e;vb(N|0)}Hv(c[C+8>>2]|0);N=e;vb(N|0)}function yj(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;d=i;i=i+16|0;g=d;m=c[b>>2]|0;q=m+20|0;p=c[q>>2]|0;p=Gv(p>>>0>1073741823?-1:p<<2)|0;c[a>>2]=p;f=b+4|0;if((Sa(p|0,c[q>>2]<<2|0,1,c[f>>2]|0)|0)!=1){b=Jb(8)|0;u=0;oa(75,b|0,2592);q=u;u=0;if(q&1){q=qb(-1,-1)|0;pb(b|0);vb(q|0)}else{c[b>>2]=288;qc(b|0,264,1)}}if((Sa(a+4|0,4,1,c[f>>2]|0)|0)!=1){b=Jb(8)|0;u=0;oa(75,b|0,2592);q=u;u=0;if(q&1){q=qb(-1,-1)|0;pb(b|0);vb(q|0)}else{c[b>>2]=288;qc(b|0,264,1)}}if((Sa(a+8|0,4,1,c[f>>2]|0)|0)!=1){b=Jb(8)|0;u=0;oa(75,b|0,2592);q=u;u=0;if(q&1){q=qb(-1,-1)|0;pb(b|0);vb(q|0)}else{c[b>>2]=288;qc(b|0,264,1)}}if((Sa(a+12|0,4,1,c[f>>2]|0)|0)!=1){b=Jb(8)|0;u=0;oa(75,b|0,2592);q=u;u=0;if(q&1){q=qb(-1,-1)|0;pb(b|0);vb(q|0)}else{c[b>>2]=288;qc(b|0,264,1)}}if((Sa(g|0,4,1,c[f>>2]|0)|0)!=1){b=Jb(8)|0;u=0;oa(75,b|0,2592);q=u;u=0;if(q&1){q=qb(-1,-1)|0;pb(b|0);vb(q|0)}else{c[b>>2]=288;qc(b|0,264,1)}}f=c[g>>2]|0;if((f|0)==0){zj(b,a+28|0);i=d;return}g=a+16|0;l=a+20|0;a=c[l>>2]|0;j=c[g>>2]|0;k=a-j>>2;if(!(k>>>0<f>>>0)){if(k>>>0>f>>>0?(h=j+(f<<2)|0,(a|0)!=(h|0)):0){c[l>>2]=a+(~((a+ -4+(0-h)|0)>>>2)<<2)}}else{ej(g,f-k|0)}l=m+108|0;h=m+128|0;k=c[r>>2]|0;j=m+112|0;a=m+116|0;m=m+124|0;n=0;do{p=c[l>>2]|0;do{if((p|0)<48){c[h>>2]=(c[h>>2]|0)+p;o=Av(8192)|0;if((o|0)==0){zb(3048,27,1,k|0)|0;o=0;break}else{c[o>>2]=c[j>>2];c[j>>2]=o;c[l>>2]=8188;o=o+4|0;c[a>>2]=o;p=8140;e=34;break}}else{o=c[a>>2]|0;p=p+ -48|0;e=34}}while(0);if((e|0)==34){e=0;c[a>>2]=o+48;c[l>>2]=p;c[m>>2]=(c[m>>2]|0)+48}p=o+0|0;q=p+40|0;do{c[p>>2]=0;p=p+4|0}while((p|0)<(q|0));c[(c[g>>2]|0)+(n<<2)>>2]=o;yj(c[(c[g>>2]|0)+(n<<2)>>2]|0,b);n=n+1|0}while(n>>>0<f>>>0);i=d;return}function zj(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0;f=i;i=i+16|0;g=f;d=a+4|0;if((Sa(g|0,4,1,c[d>>2]|0)|0)!=1){b=Jb(8)|0;u=0;oa(75,b|0,2592);m=u;u=0;if(m&1){m=qb(-1,-1)|0;pb(b|0);vb(m|0)}else{c[b>>2]=288;qc(b|0,264,1)}}g=c[g>>2]|0;l=b+4|0;k=c[l>>2]|0;m=c[b>>2]|0;j=k-m>>3;if(!(j>>>0<g>>>0)){if(j>>>0>g>>>0?(h=m+(g<<3)|0,(k|0)!=(h|0)):0){c[l>>2]=k+(~((k+ -8+(0-h)|0)>>>3)<<3)}}else{fj(b,g-j|0)}if((g|0)==0){i=f;return}h=0;while(1){l=c[b>>2]|0;k=l+(h<<3)|0;j=c[a>>2]|0;if((Sa(k|0,4,1,c[d>>2]|0)|0)!=1){break}c[l+(h<<3)+4>>2]=c[(c[j+72>>2]|0)+(c[k>>2]<<2)>>2];h=h+1|0;if(!(h>>>0<g>>>0)){e=17;break}}if((e|0)==17){i=f;return}b=Jb(8)|0;u=0;oa(75,b|0,2592);m=u;u=0;if(m&1){m=qb(-1,-1)|0;pb(b|0);vb(m|0)}else{c[b>>2]=288;qc(b|0,264,1)}}function Aj(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0.0;n=i;i=i+80|0;k=n+65|0;h=n+64|0;v=n+52|0;x=n+48|0;q=n+36|0;w=n+32|0;m=n+20|0;p=n+16|0;l=n+4|0;o=n;a[k+0>>0]=a[h+0>>0]|0;Dd(b,e,k);c[b>>2]=6584;c[b+104>>2]=0;c[b+120>>2]=8192;k=b+108|0;c[k>>2]=0;h=b+112|0;c[h>>2]=0;j=b+124|0;c[j>>2]=0;f=b+128|0;c[f>>2]=0;c[b+132>>2]=0;a[v>>0]=18;s=v+1|0;r=2880|0;t=s+9|0;do{a[s>>0]=a[r>>0]|0;s=s+1|0;r=r+1|0}while((s|0)<(t|0));a[v+10>>0]=0;c[x>>2]=32;u=0;r=ua(28,e|0,v|0,x|0)|0;x=u;u=0;do{if(x&1){d=qb(-1,-1)|0;if(!((a[v>>0]&1)==0)){Hv(c[v+8>>2]|0)}}else{c[b+88>>2]=r;if(!((a[v>>0]&1)==0)){Hv(c[v+8>>2]|0)}a[q>>0]=20;s=q+1|0;r=6432|0;t=s+10|0;do{a[s>>0]=a[r>>0]|0;s=s+1|0;r=r+1|0}while((s|0)<(t|0));a[q+11>>0]=0;c[w>>2]=11;u=0;s=ua(28,e|0,q|0,w|0)|0;x=u;u=0;if(x&1){d=qb(-1,-1)|0;if((a[q>>0]&1)==0){break}Hv(c[q+8>>2]|0);break}r=b+92|0;c[r>>2]=s;if(!((a[q>>0]&1)==0)){Hv(c[q+8>>2]|0);s=c[r>>2]|0}if((s|0)<0){c[r>>2]=2147483647}u=0;v=qa(119,16)|0;x=u;u=0;if(!(x&1)){q=m+8|0;c[q>>2]=v;c[m>>2]=17;c[m+4>>2]=12;s=v+0|0;r=2896|0;t=s+12|0;do{a[s>>0]=a[r>>0]|0;s=s+1|0;r=r+1|0}while((s|0)<(t|0));a[v+12>>0]=0;c[p>>2]=0;u=0;p=ua(29,e|0,m|0,p|0)|0;x=u;u=0;if(x&1){d=qb(-1,-1)|0;if((a[m>>0]&1)==0){break}Hv(c[q>>2]|0);break}c[b+96>>2]=p;if(!((a[m>>0]&1)==0)){Hv(c[q>>2]|0)}a[l>>0]=16;x=l+1|0;w=x;a[w>>0]=1767858787;a[w+1>>0]=6905698;a[w+2>>0]=26975;a[w+3>>0]=105;x=x+4|0;a[x>>0]=2019910766;a[x+1>>0]=7890276;a[x+2>>0]=30821;a[x+3>>0]=120;a[l+9>>0]=0;g[o>>2]=.4000000059604645;u=0;y=+Ja(1,e|0,l|0,o|0);x=u;u=0;if(x&1){d=qb(-1,-1)|0;if((a[l>>0]&1)==0){break}Hv(c[l+8>>2]|0);break}g[b+100>>2]=y;if(!((a[l>>0]&1)==0)){Hv(c[l+8>>2]|0)}u=0;na(201,b|0);x=u;u=0;if(!(x&1)){x=(c[b+136>>2]|0)+4|0;c[x+0>>2]=c[d+0>>2];c[x+4>>2]=c[d+4>>2];c[x+8>>2]=c[d+8>>2];c[x+12>>2]=c[d+12>>2];c[x+16>>2]=c[d+16>>2];u=0;oa(79,b|0,d|0);x=u;u=0;if(!(x&1)){i=n;return}}}d=qb(-1,-1)|0}}while(0);l=c[h>>2]|0;if((l|0)!=0){do{x=l;l=c[l>>2]|0;Bv(x);c[h>>2]=l}while((l|0)!=0)}c[h>>2]=0;c[k>>2]=0;c[j>>2]=0;c[f>>2]=0;u=0;na(186,b|0);x=u;u=0;if(x&1){x=qb(-1,-1,0)|0;jd(x)}else{vb(d|0)}}function Bj(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;j=i;i=i+32|0;k=j+28|0;l=j+24|0;n=j+20|0;g=j;c[b+0>>2]=c[d+0>>2];c[b+4>>2]=c[d+4>>2];c[b+8>>2]=c[d+8>>2];c[b+12>>2]=c[d+12>>2];e=b+16|0;f=b+20|0;c[f>>2]=0;c[b+24>>2]=0;o=b+20|0;c[e>>2]=o;q=c[d+16>>2]|0;p=d+20|0;if((q|0)==(p|0)){i=j;return}b=g+12|0;m=g+16|0;d=g+8|0;while(1){c[n>>2]=o;u=0;oa(77,g|0,q+16|0);r=u;u=0;if(r&1){k=21;break}u=0;c[k+0>>2]=c[n+0>>2];Qa(18,l|0,e|0,k|0,g|0);r=u;u=0;if(r&1){k=10;break}r=c[b>>2]|0;u=0;oa(c[c[r>>2]>>2]|0,r|0,m|0);r=u;u=0;if(r&1){k=8;break}if(!((a[g>>0]&1)==0)){Hv(c[d>>2]|0)}r=c[q+4>>2]|0;if((r|0)==0){while(1){r=c[q+8>>2]|0;if((c[r>>2]|0)==(q|0)){q=r;break}else{q=r}}}else{q=r;while(1){r=c[q>>2]|0;if((r|0)==0){break}else{q=r}}}if((q|0)==(p|0)){k=23;break}}do{if((k|0)==8){h=qb(-1,-1)|0;if(!((a[g>>0]&1)==0)){Hv(c[d>>2]|0)}}else if((k|0)==10){j=qb(-1,-1)|0;r=c[b>>2]|0;u=0;oa(c[c[r>>2]>>2]|0,r|0,m|0);r=u;u=0;if(!(r&1)){if((a[g>>0]&1)==0){h=j;break}Hv(c[d>>2]|0);h=j;break}j=qb(-1,-1,0)|0;if((a[g>>0]&1)==0){jd(j)}Hv(c[d>>2]|0);jd(j)}else if((k|0)==21){h=qb(-1,-1)|0}else if((k|0)==23){i=j;return}}while(0);Bd(e,c[f>>2]|0);vb(h|0)}function Cj(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0;d=i;e=a+4|0;m=c[e>>2]|0;l=c[a>>2]|0;h=l;j=(m-h|0)/28|0;k=j+1|0;if(k>>>0>153391689){ss(0)}f=a+8|0;h=((c[f>>2]|0)-h|0)/28|0;if(h>>>0<76695844){h=h<<1;h=h>>>0<k>>>0?k:h;if((h|0)==0){o=0;h=0}else{g=5}}else{h=153391689;g=5}if((g|0)==5){o=h;h=Fv(h*28|0)|0}n=h+(j*28|0)|0;j=h+(o*28|0)|0;do{if((n|0)!=0){u=0;oa(99,n|0,b|0);o=u;u=0;if(o&1){d=qb(-1,-1)|0;break}else{m=c[e>>2]|0;l=c[a>>2]|0;g=10;break}}else{g=10}}while(0);a:do{if((g|0)==10){k=h+(k*28|0)|0;do{if((m|0)!=(l|0)){while(1){b=n+ -28|0;m=m+ -28|0;u=0;oa(99,b|0,m|0);o=u;u=0;if(o&1){g=19;break}if((m|0)==(l|0)){g=14;break}else{n=b}}if((g|0)==14){m=c[a>>2]|0;g=c[e>>2]|0;c[a>>2]=b;c[e>>2]=k;c[f>>2]=j;if((g|0)==(m|0)){break}do{Bd(g+ -12|0,c[g+ -8>>2]|0);g=g+ -28|0}while((g|0)!=(m|0))}else if((g|0)==19){d=qb(-1,-1)|0;e=J;if((k|0)==(n|0)){break a}while(1){Bd(k+ -12|0,c[k+ -8>>2]|0);k=k+ -28|0;if((k|0)==(n|0)){break a}}}}else{c[a>>2]=n;c[e>>2]=k;c[f>>2]=j}}while(0);if((m|0)==0){i=d;return}Hv(m);i=d;return}}while(0);if((h|0)==0){vb(d|0)}Hv(h);vb(d|0)}function Dj(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;k=i;i=i+32|0;m=k+28|0;l=k+16|0;e=k+4|0;g=k;d=b+4|0;c[d>>2]=0;h=b+8|0;c[h>>2]=0;c[b>>2]=b+4;a[e>>0]=18;q=e+1|0;r=320|0;p=q+9|0;do{a[q>>0]=a[r>>0]|0;q=q+1|0;r=r+1|0}while((q|0)<(p|0));a[e+10>>0]=0;p=Pf(b,m,e)|0;q=c[p>>2]|0;if((q|0)==0){u=0;Na(43,l|0,b|0,e|0);r=u;u=0;if(!(r&1)){o=c[l>>2]|0;c[l>>2]=0;l=c[m>>2]|0;c[o>>2]=0;c[o+4>>2]=0;c[o+8>>2]=l;c[p>>2]=o;l=c[c[b>>2]>>2]|0;if((l|0)==0){l=o}else{c[b>>2]=l;l=c[p>>2]|0}ge(c[d>>2]|0,l);c[h>>2]=(c[h>>2]|0)+1;n=6}}else{o=q;n=6}if((n|0)==6?(c[g>>2]=0,f=o+28|0,r=c[f>>2]|0,j=o+32|0,u=0,oa(c[c[r>>2]>>2]|0,r|0,j|0),r=u,u=0,!(r&1)):0){if((a[2072]|0)==0?(Ua(2072)|0)!=0:0){c[516]=2088;rb(2072)}c[f>>2]=2064;if((a[2336]|0)==0?(Ua(2336)|0)!=0:0){c[582]=2352;rb(2336)}c[f>>2]=2328;u=0;Na(c[(c[582]|0)+4>>2]|0,2328,g|0,j|0);r=u;u=0;if(!(r&1)){if((a[e>>0]&1)==0){i=k;return}Hv(c[e+8>>2]|0);i=k;return}}f=qb(-1,-1)|0;if((a[e>>0]&1)==0){r=c[d>>2]|0;Bd(b,r);vb(f|0)}Hv(c[e+8>>2]|0);r=c[d>>2]|0;Bd(b,r);vb(f|0)}function Ej(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0;f=i;i=i+16|0;h=f+8|0;g=f+4|0;j=f;c[j>>2]=c[d>>2];c[h+0>>2]=c[j+0>>2];h=Gj(b,h,g,e)|0;d=c[h>>2]|0;if((d|0)!=0){j=d;c[a>>2]=j;i=f;return}d=Fv(36)|0;u=0;oa(77,d+16|0,e|0);j=u;u=0;if(j&1){a=qb(-1,-1)|0;if((d|0)==0){vb(a|0)}Hv(d);vb(a|0)}else{g=c[g>>2]|0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=g;c[h>>2]=d;g=c[c[b>>2]>>2]|0;if((g|0)==0){g=d}else{c[b>>2]=g;g=c[h>>2]|0}ge(c[b+4>>2]|0,g);j=b+8|0;c[j>>2]=(c[j>>2]|0)+1;j=d;c[a>>2]=j;i=f;return}}function Fj(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0;e=i;if((a[d>>0]&1)==0){c[b+0>>2]=c[d+0>>2];c[b+4>>2]=c[d+4>>2];c[b+8>>2]=c[d+8>>2]}else{f=c[d+8>>2]|0;g=c[d+4>>2]|0;if(g>>>0>4294967279){Mm(0)}if(g>>>0<11){a[b>>0]=g<<1;h=b+1|0}else{j=g+16&-16;h=Fv(j)|0;c[b+8>>2]=h;c[b>>2]=j|1;c[b+4>>2]=g}tw(h|0,f|0,g|0)|0;a[h+g>>0]=0}f=b+12|0;if((a[2072]|0)==0?(Ua(2072)|0)!=0:0){c[516]=2088;rb(2072)}c[f>>2]=2064;g=b+16|0;c[g>>2]=0;u=0;oa(c[c[516]>>2]|0,2064,g|0);j=u;u=0;if(!(j&1)){if((a[2072]|0)==0?(Ua(2072)|0)!=0:0){c[516]=2088;rb(2072)}c[f>>2]=2064;j=c[d+12>>2]|0;c[f>>2]=j;u=0;Na(c[(c[j>>2]|0)+8>>2]|0,j|0,d+16|0,g|0);j=u;u=0;if(!(j&1)){i=e;return}}d=qb(-1,-1)|0;if((a[b>>0]&1)==0){vb(d|0)}Hv(c[b+8>>2]|0);vb(d|0)}function Gj(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;g=i;k=b+4|0;d=c[d>>2]|0;if((d|0)!=(k|0)){l=d+16|0;j=a[f>>0]|0;h=(j&1)==0;if(h){p=(j&255)>>>1}else{p=c[f+4>>2]|0}n=a[l>>0]|0;m=(n&1)==0;if(m){o=(n&255)>>>1}else{o=c[d+20>>2]|0}if(h){r=f+1|0}else{r=c[f+8>>2]|0}if(m){s=l+1|0}else{s=c[d+24>>2]|0}q=o>>>0<p>>>0;r=kw(r,s,q?o:p)|0;if((r|0)==0){r=p>>>0<o>>>0?-1:q&1}if((r|0)>=0){if(m){n=(n&255)>>>1}else{n=c[d+20>>2]|0}if(h){o=(j&255)>>>1}else{o=c[f+4>>2]|0}if(m){m=l+1|0}else{m=c[d+24>>2]|0}if(h){p=f+1|0}else{p=c[f+8>>2]|0}l=o>>>0<n>>>0;m=kw(m,p,l?o:n)|0;if((m|0)==0){m=n>>>0<o>>>0?-1:l&1}if((m|0)>=0){c[e>>2]=d;s=e;i=g;return s|0}l=d+4|0;n=c[l>>2]|0;m=(n|0)==0;if(m){o=d;while(1){n=c[o+8>>2]|0;if((c[n>>2]|0)==(o|0)){break}else{o=n}}}else{while(1){o=c[n>>2]|0;if((o|0)==0){break}else{n=o}}}do{if((n|0)!=(k|0)){o=n+16|0;if(h){j=(j&255)>>>1}else{j=c[f+4>>2]|0}k=a[o>>0]|0;p=(k&1)==0;if(p){k=(k&255)>>>1}else{k=c[n+20>>2]|0}if(h){h=f+1|0}else{h=c[f+8>>2]|0}if(p){p=o+1|0}else{p=c[n+24>>2]|0}o=k>>>0<j>>>0;h=kw(h,p,o?k:j)|0;if((h|0)==0){h=j>>>0<k>>>0?-1:o&1}if((h|0)<0){break}s=Hj(b,e,f)|0;i=g;return s|0}}while(0);if(m){c[e>>2]=d;s=l;i=g;return s|0}else{c[e>>2]=n;s=n;i=g;return s|0}}}h=c[d>>2]|0;if((d|0)!=(c[b>>2]|0)){if((h|0)==0){k=d;while(1){j=c[k+8>>2]|0;if((c[j>>2]|0)==(k|0)){k=j}else{break}}}else{j=h;while(1){k=c[j+4>>2]|0;if((k|0)==0){break}else{j=k}}}n=j+16|0;k=a[n>>0]|0;o=(k&1)==0;if(o){k=(k&255)>>>1}else{k=c[j+20>>2]|0}l=a[f>>0]|0;m=(l&1)==0;if(m){l=(l&255)>>>1}else{l=c[f+4>>2]|0}if(o){n=n+1|0}else{n=c[j+24>>2]|0}if(m){o=f+1|0}else{o=c[f+8>>2]|0}m=l>>>0<k>>>0;n=kw(n,o,m?l:k)|0;if((n|0)==0){n=k>>>0<l>>>0?-1:m&1}if((n|0)>=0){s=Hj(b,e,f)|0;i=g;return s|0}}else{j=d}if((h|0)==0){c[e>>2]=d;s=d;i=g;return s|0}else{c[e>>2]=j;s=j+4|0;i=g;return s|0}return 0}function Hj(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;f=i;k=c[b+4>>2]|0;if((k|0)==0){s=b+4|0;c[d>>2]=s;i=f;return s|0}b=a[e>>0]|0;j=(b&1)==0;b=(b&255)>>>1;g=e+1|0;h=e+8|0;e=e+4|0;while(1){m=k+16|0;if(j){o=b}else{o=c[e>>2]|0}n=a[m>>0]|0;l=(n&1)==0;if(l){p=(n&255)>>>1}else{p=c[k+20>>2]|0}if(j){s=g}else{s=c[h>>2]|0}if(l){r=m+1|0}else{r=c[k+24>>2]|0}q=p>>>0<o>>>0;r=kw(s,r,q?p:o)|0;if((r|0)==0){r=o>>>0<p>>>0?-1:q&1}if((r|0)<0){l=c[k>>2]|0;if((l|0)==0){b=17;break}else{k=l;continue}}if(l){n=(n&255)>>>1}else{n=c[k+20>>2]|0}if(j){o=b}else{o=c[e>>2]|0}if(l){p=m+1|0}else{p=c[k+24>>2]|0}if(j){m=g}else{m=c[h>>2]|0}l=o>>>0<n>>>0;m=kw(p,m,l?o:n)|0;if((m|0)==0){m=n>>>0<o>>>0?-1:l&1}if((m|0)>=0){b=33;break}l=k+4|0;m=c[l>>2]|0;if((m|0)==0){b=32;break}else{k=m}}if((b|0)==17){c[d>>2]=k;s=k;i=f;return s|0}else if((b|0)==32){c[d>>2]=k;s=l;i=f;return s|0}else if((b|0)==33){c[d>>2]=k;s=d;i=f;return s|0}return 0}function Ij(b,d){b=b|0;d=d|0;var e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0;l=i;i=i+32|0;r=l+28|0;t=l+24|0;q=l+20|0;j=l;Le(b,d);c[b>>2]=4096;e=b+92|0;f=b+96|0;c[f>>2]=0;c[b+100>>2]=0;o=b+96|0;c[e>>2]=o;v=c[d+92>>2]|0;s=d+96|0;a:do{if((v|0)==(s|0)){o=22}else{n=j+12|0;m=j+16|0;h=j+8|0;while(1){c[q>>2]=o;u=0;oa(77,j|0,v+16|0);w=u;u=0;if(w&1){o=21;break}u=0;c[r+0>>2]=c[q+0>>2];Qa(18,t|0,e|0,r|0,j|0);w=u;u=0;if(w&1){o=10;break}w=c[n>>2]|0;u=0;oa(c[c[w>>2]>>2]|0,w|0,m|0);w=u;u=0;if(w&1){o=8;break}if(!((a[j>>0]&1)==0)){Hv(c[h>>2]|0)}w=c[v+4>>2]|0;if((w|0)==0){while(1){w=c[v+8>>2]|0;if((c[w>>2]|0)==(v|0)){v=w;break}else{v=w}}}else{while(1){v=c[w>>2]|0;if((v|0)==0){v=w;break}else{w=v}}}if((v|0)==(s|0)){o=22;break a}}do{if((o|0)==8){k=qb(-1,-1)|0;if(!((a[j>>0]&1)==0)){Hv(c[h>>2]|0)}}else if((o|0)==10){l=qb(-1,-1)|0;w=c[n>>2]|0;u=0;oa(c[c[w>>2]>>2]|0,w|0,m|0);w=u;u=0;if(!(w&1)){if((a[j>>0]&1)==0){k=l;break}Hv(c[h>>2]|0);k=l;break}l=qb(-1,-1,0)|0;if((a[j>>0]&1)==0){jd(l)}Hv(c[h>>2]|0);jd(l)}else if((o|0)==21){k=qb(-1,-1)|0}}while(0);Bd(e,c[f>>2]|0)}}while(0);do{if((o|0)==22){h=b+104|0;w=d+104|0;c[h+0>>2]=c[w+0>>2];c[h+4>>2]=c[w+4>>2];c[h+8>>2]=c[w+8>>2];c[h+12>>2]=c[w+12>>2];c[h+16>>2]=c[w+16>>2];c[h+20>>2]=c[w+20>>2];c[h+24>>2]=c[w+24>>2];c[b+132>>2]=0;c[b+136>>2]=0;c[b+140>>2]=0;c[b+144>>2]=-1;h=b+148|0;w=b+164|0;c[h+0>>2]=0;c[h+4>>2]=0;c[h+8>>2]=0;c[h+12>>2]=0;c[w>>2]=-1;w=b+168|0;h=b+184|0;c[w+0>>2]=0;c[w+4>>2]=0;c[w+8>>2]=0;c[w+12>>2]=0;c[h>>2]=-1;c[b+188>>2]=0;g[b+192>>2]=+g[d+192>>2];h=b+196|0;w=d+196|0;c[h+0>>2]=c[w+0>>2];c[h+4>>2]=c[w+4>>2];c[h+8>>2]=c[w+8>>2];c[h+12>>2]=c[w+12>>2];c[h+16>>2]=c[w+16>>2];g[b+216>>2]=+g[d+216>>2];g[b+220>>2]=+g[d+220>>2];g[b+224>>2]=+g[d+224>>2];g[b+228>>2]=+g[d+228>>2];h=c[d+88>>2]|0;u=0;h=qa(c[(c[h>>2]|0)+36>>2]|0,h|0)|0;w=u;u=0;if(w&1){k=qb(-1,-1)|0;Bd(e,c[f>>2]|0);break}else{c[b+88>>2]=h;i=l;return}}}while(0);u=0;na(186,b|0);w=u;u=0;if(w&1){w=qb(-1,-1,0)|0;jd(w)}else{vb(k|0)}}function Jj(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0;f=i;i=i+16|0;g=f+12|0;e=f;c[d>>2]=b;lf(b,d);d=d+4|0;zb(b+216|0,4,1,c[d>>2]|0)|0;zb(b+220|0,4,1,c[d>>2]|0)|0;zb(b+224|0,4,1,c[d>>2]|0)|0;zb(b+228|0,4,1,c[d>>2]|0)|0;h=b+92|0;a[e>>0]=18;l=e+1|0;k=320|0;j=l+9|0;do{a[l>>0]=a[k>>0]|0;l=l+1|0;k=k+1|0}while((l|0)<(j|0));a[e+10>>0]=0;u=0;h=Ha(34,h|0,e|0)|0;l=u;u=0;if(l&1){f=qb(-1,-1)|0;if((a[e>>0]&1)==0){vb(f|0)}Hv(c[e+8>>2]|0);vb(f|0)}else{if((a[e>>0]&1)==0){c[g>>2]=h;k=c[d>>2]|0;zb(g|0,4,1,k|0)|0;k=b+104|0;l=c[d>>2]|0;zb(k|0,4,1,l|0)|0;i=f;return}Hv(c[e+8>>2]|0);c[g>>2]=h;k=c[d>>2]|0;zb(g|0,4,1,k|0)|0;k=b+104|0;l=c[d>>2]|0;zb(k|0,4,1,l|0)|0;i=f;return}}function Kj(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0;f=i;i=i+176|0;g=f+172|0;h=f+160|0;m=f+156|0;l=f+144|0;r=f+140|0;s=f+128|0;x=f+124|0;w=f+112|0;D=f+108|0;E=f+96|0;N=f+92|0;M=f+80|0;K=f+76|0;n=f+64|0;y=f+52|0;C=f+48|0;t=f+36|0;o=f+24|0;j=f+12|0;e=f;c[d>>2]=b;Vf(b,d);v=b+216|0;G=d+4|0;if((Sa(v|0,4,1,c[G>>2]|0)|0)!=1){e=Jb(8)|0;u=0;oa(75,e|0,2592);P=u;u=0;if(P&1){P=qb(-1,-1)|0;pb(e|0);vb(P|0)}else{c[e>>2]=288;qc(e|0,264,1)}}q=b+220|0;if((Sa(q|0,4,1,c[G>>2]|0)|0)!=1){e=Jb(8)|0;u=0;oa(75,e|0,2592);P=u;u=0;if(P&1){P=qb(-1,-1)|0;pb(e|0);vb(P|0)}else{c[e>>2]=288;qc(e|0,264,1)}}k=b+224|0;if((Sa(k|0,4,1,c[G>>2]|0)|0)!=1){e=Jb(8)|0;u=0;oa(75,e|0,2592);P=u;u=0;if(P&1){P=qb(-1,-1)|0;pb(e|0);vb(P|0)}else{c[e>>2]=288;qc(e|0,264,1)}}d=b+228|0;if((Sa(d|0,4,1,c[G>>2]|0)|0)!=1){e=Jb(8)|0;u=0;oa(75,e|0,2592);P=u;u=0;if(P&1){P=qb(-1,-1)|0;pb(e|0);vb(P|0)}else{c[e>>2]=288;qc(e|0,264,1)}}if((Sa(g|0,4,1,c[G>>2]|0)|0)!=1){e=Jb(8)|0;u=0;oa(75,e|0,2592);P=u;u=0;if(P&1){P=qb(-1,-1)|0;pb(e|0);vb(P|0)}else{c[e>>2]=288;qc(e|0,264,1)}}c[K>>2]=c[g>>2];if((Sa(b+104|0,4,1,c[G>>2]|0)|0)!=1){e=Jb(8)|0;u=0;oa(75,e|0,2592);P=u;u=0;if(P&1){P=qb(-1,-1)|0;pb(e|0);vb(P|0)}else{c[e>>2]=288;qc(e|0,264,1)}}P=b+92|0;a[n>>0]=18;I=n+1|0;H=320|0;G=I+9|0;do{a[I>>0]=a[H>>0]|0;I=I+1|0;H=H+1|0}while((I|0)<(G|0));a[n+10>>0]=0;G=Pf(P,N,n)|0;H=c[G>>2]|0;if((H|0)==0){u=0;Na(43,M|0,P|0,n|0);I=u;u=0;if(!(I&1)){O=c[M>>2]|0;c[M>>2]=0;p=c[N>>2]|0;c[O>>2]=0;c[O+4>>2]=0;c[O+8>>2]=p;c[G>>2]=O;p=c[c[P>>2]>>2]|0;if((p|0)==0){p=O}else{c[P>>2]=p;p=c[G>>2]|0}ge(c[b+96>>2]|0,p);p=b+100|0;c[p>>2]=(c[p>>2]|0)+1;p=30}}else{O=H;p=30}if((p|0)==30?(J=O+28|0,P=c[J>>2]|0,L=O+32|0,u=0,oa(c[c[P>>2]>>2]|0,P|0,L|0),P=u,u=0,!(P&1)):0){if((a[2072]|0)==0?(Ua(2072)|0)!=0:0){c[516]=2088;rb(2072)}c[J>>2]=2064;if((a[2336]|0)==0?(Ua(2336)|0)!=0:0){c[582]=2352;rb(2336)}c[J>>2]=2328;u=0;Na(c[(c[582]|0)+4>>2]|0,2328,K|0,L|0);P=u;u=0;if(!(P&1)){if(!((a[n>>0]&1)==0)){Hv(c[n+8>>2]|0)}n=b+24|0;a[y>>0]=18;I=y+1|0;H=320|0;G=I+9|0;do{a[I>>0]=a[H>>0]|0;I=I+1|0;H=H+1|0}while((I|0)<(G|0));a[y+10>>0]=0;G=Pf(n,D,y)|0;H=c[G>>2]|0;if((H|0)==0){u=0;Na(43,E|0,n|0,y|0);P=u;u=0;if(!(P&1)){F=c[E>>2]|0;c[E>>2]=0;p=c[D>>2]|0;c[F>>2]=0;c[F+4>>2]=0;c[F+8>>2]=p;c[G>>2]=F;p=c[c[n>>2]>>2]|0;if((p|0)==0){p=F}else{c[n>>2]=p;p=c[G>>2]|0}ge(c[b+28>>2]|0,p);p=b+32|0;c[p>>2]=(c[p>>2]|0)+1;p=45}}else{F=H;p=45}if(((p|0)==45?(u=0,z=qa(c[(c[b>>2]|0)+16>>2]|0,b|0)|0,P=u,u=0,!(P&1)):0)?(c[C>>2]=z,B=F+28|0,P=c[B>>2]|0,A=F+32|0,u=0,oa(c[c[P>>2]>>2]|0,P|0,A|0),P=u,u=0,!(P&1)):0){if((a[2072]|0)==0?(Ua(2072)|0)!=0:0){c[516]=2088;rb(2072)}c[B>>2]=2064;do{if((a[2336]|0)==0){if((Ua(2336)|0)==0){break}c[582]=2352;rb(2336)}}while(0);c[B>>2]=2328;u=0;Na(c[(c[582]|0)+4>>2]|0,2328,C|0,A|0);P=u;u=0;if(!(P&1)){if(!((a[y>>0]&1)==0)){Hv(c[y+8>>2]|0)}z=Fv(32)|0;y=t+8|0;c[y>>2]=z;c[t>>2]=33;c[t+4>>2]=17;I=z+0|0;H=6776|0;G=I+17|0;do{a[I>>0]=a[H>>0]|0;I=I+1|0;H=H+1|0}while((I|0)<(G|0));a[z+17>>0]=0;z=Pf(n,x,t)|0;A=c[z>>2]|0;do{if((A|0)==0){u=0;Na(43,w|0,n|0,t|0);P=u;u=0;if(P&1){break}p=c[w>>2]|0;c[w>>2]=0;w=c[x>>2]|0;c[p>>2]=0;c[p+4>>2]=0;c[p+8>>2]=w;c[z>>2]=p;w=c[c[n>>2]>>2]|0;if((w|0)==0){w=p}else{c[n>>2]=w;w=c[z>>2]|0}ge(c[b+28>>2]|0,w);A=b+32|0;c[A>>2]=(c[A>>2]|0)+1;A=p;p=61}else{p=61}}while(0);do{if((p|0)==61){w=A+28|0;P=c[w>>2]|0;x=A+32|0;u=0;oa(c[c[P>>2]>>2]|0,P|0,x|0);P=u;u=0;if(P&1){break}do{if((a[2072]|0)==0){if((Ua(2072)|0)==0){break}c[516]=2088;rb(2072)}}while(0);c[w>>2]=2064;do{if((a[4520]|0)==0){if((Ua(4520)|0)==0){break}c[1128]=4536;rb(4520)}}while(0);c[w>>2]=4512;u=0;Na(c[(c[1128]|0)+4>>2]|0,4512,v|0,x|0);P=u;u=0;if(P&1){break}if(!((a[t>>0]&1)==0)){Hv(c[y>>2]|0)}v=Fv(16)|0;t=o+8|0;c[t>>2]=v;c[o>>2]=17;c[o+4>>2]=13;I=v+0|0;H=6800|0;G=I+13|0;do{a[I>>0]=a[H>>0]|0;I=I+1|0;H=H+1|0}while((I|0)<(G|0));a[v+13>>0]=0;v=Pf(n,r,o)|0;w=c[v>>2]|0;do{if((w|0)==0){u=0;Na(43,s|0,n|0,o|0);P=u;u=0;if(P&1){break}p=c[s>>2]|0;c[s>>2]=0;r=c[r>>2]|0;c[p>>2]=0;c[p+4>>2]=0;c[p+8>>2]=r;c[v>>2]=p;r=c[c[n>>2]>>2]|0;if((r|0)==0){r=p}else{c[n>>2]=r;r=c[v>>2]|0}ge(c[b+28>>2]|0,r);w=b+32|0;c[w>>2]=(c[w>>2]|0)+1;w=p;p=76}else{p=76}}while(0);do{if((p|0)==76){r=w+28|0;P=c[r>>2]|0;s=w+32|0;u=0;oa(c[c[P>>2]>>2]|0,P|0,s|0);P=u;u=0;if(P&1){break}do{if((a[2072]|0)==0){if((Ua(2072)|0)==0){break}c[516]=2088;rb(2072)}}while(0);c[r>>2]=2064;do{if((a[4520]|0)==0){if((Ua(4520)|0)==0){break}c[1128]=4536;rb(4520)}}while(0);c[r>>2]=4512;u=0;Na(c[(c[1128]|0)+4>>2]|0,4512,q|0,s|0);P=u;u=0;if(P&1){break}if(!((a[o>>0]&1)==0)){Hv(c[t>>2]|0)}q=Fv(16)|0;o=j+8|0;c[o>>2]=q;c[j>>2]=17;c[j+4>>2]=14;I=q+0|0;H=6816|0;G=I+14|0;do{a[I>>0]=a[H>>0]|0;I=I+1|0;H=H+1|0}while((I|0)<(G|0));a[q+14>>0]=0;q=Pf(n,m,j)|0;r=c[q>>2]|0;do{if((r|0)==0){u=0;Na(43,l|0,n|0,j|0);P=u;u=0;if(P&1){break}p=c[l>>2]|0;c[l>>2]=0;l=c[m>>2]|0;c[p>>2]=0;c[p+4>>2]=0;c[p+8>>2]=l;c[q>>2]=p;l=c[c[n>>2]>>2]|0;if((l|0)==0){l=p}else{c[n>>2]=l;l=c[q>>2]|0}ge(c[b+28>>2]|0,l);r=b+32|0;c[r>>2]=(c[r>>2]|0)+1;r=p;p=91}else{p=91}}while(0);do{if((p|0)==91){l=r+28|0;P=c[l>>2]|0;m=r+32|0;u=0;oa(c[c[P>>2]>>2]|0,P|0,m|0);P=u;u=0;if(P&1){break}do{if((a[2072]|0)==0){if((Ua(2072)|0)==0){break}c[516]=2088;rb(2072)}}while(0);c[l>>2]=2064;do{if((a[4520]|0)==0){if((Ua(4520)|0)==0){break}c[1128]=4536;rb(4520)}}while(0);c[l>>2]=4512;u=0;Na(c[(c[1128]|0)+4>>2]|0,4512,k|0,m|0);P=u;u=0;if(P&1){break}if(!((a[j>>0]&1)==0)){Hv(c[o>>2]|0)}k=Fv(32)|0;j=e+8|0;c[j>>2]=k;c[e>>2]=33;c[e+4>>2]=16;I=k+0|0;H=6832|0;G=I+16|0;do{a[I>>0]=a[H>>0]|0;I=I+1|0;H=H+1|0}while((I|0)<(G|0));a[k+16>>0]=0;k=Pf(n,g,e)|0;l=c[k>>2]|0;do{if((l|0)==0){u=0;Na(43,h|0,n|0,e|0);P=u;u=0;if(P&1){break}l=c[h>>2]|0;c[h>>2]=0;g=c[g>>2]|0;c[l>>2]=0;c[l+4>>2]=0;c[l+8>>2]=g;c[k>>2]=l;g=c[c[n>>2]>>2]|0;if((g|0)==0){g=l}else{c[n>>2]=g;g=c[k>>2]|0}ge(c[b+28>>2]|0,g);p=b+32|0;c[p>>2]=(c[p>>2]|0)+1;p=106}else{p=106}}while(0);do{if((p|0)==106){b=l+28|0;P=c[b>>2]|0;g=l+32|0;u=0;oa(c[c[P>>2]>>2]|0,P|0,g|0);P=u;u=0;if(P&1){break}do{if((a[2072]|0)==0){if((Ua(2072)|0)==0){break}c[516]=2088;rb(2072)}}while(0);c[b>>2]=2064;do{if((a[4520]|0)==0){if((Ua(4520)|0)==0){break}c[1128]=4536;rb(4520)}}while(0);c[b>>2]=4512;u=0;Na(c[(c[1128]|0)+4>>2]|0,4512,d|0,g|0);P=u;u=0;if(P&1){break}if((a[e>>0]&1)==0){i=f;return}Hv(c[j>>2]|0);i=f;return}}while(0);f=qb(-1,-1)|0;if((a[e>>0]&1)==0){P=f;vb(P|0)}Hv(c[j>>2]|0);P=f;vb(P|0)}}while(0);e=qb(-1,-1)|0;if((a[j>>0]&1)==0){P=e;vb(P|0)}Hv(c[o>>2]|0);P=e;vb(P|0)}}while(0);e=qb(-1,-1)|0;if((a[o>>0]&1)==0){P=e;vb(P|0)}Hv(c[t>>2]|0);P=e;vb(P|0)}}while(0);e=qb(-1,-1)|0;if((a[t>>0]&1)==0){P=e;vb(P|0)}Hv(c[y>>2]|0);P=e;vb(P|0)}}e=qb(-1,-1)|0;if((a[y>>0]&1)==0){P=e;vb(P|0)}Hv(c[y+8>>2]|0);P=e;vb(P|0)}}e=qb(-1,-1)|0;if((a[n>>0]&1)==0){P=e;vb(P|0)}Hv(c[n+8>>2]|0);P=e;vb(P|0)}function Lj(a){a=a|0;var b=0,d=0;b=i;c[a>>2]=6864;d=c[a+92>>2]|0;if(!((d|0)!=0?(u=0,na(c[(c[d>>2]|0)+4>>2]|0,d|0),d=u,u=0,d&1):0)){d=c[a+88>>2]|0;if((d|0)==0){Hd(a);i=b;return}u=0;na(c[(c[d>>2]|0)+4>>2]|0,d|0);d=u;u=0;if(!(d&1)){Hd(a);i=b;return}}b=qb(-1,-1)|0;u=0;na(186,a|0);d=u;u=0;if(d&1){d=qb(-1,-1,0)|0;jd(d)}else{vb(b|0)}}function Mj(a){a=a|0;var b=0,d=0,e=0;b=i;c[a>>2]=6864;d=c[a+92>>2]|0;if(!((d|0)!=0?(u=0,na(c[(c[d>>2]|0)+4>>2]|0,d|0),d=u,u=0,d&1):0)){e=3}do{if((e|0)==3){d=c[a+88>>2]|0;if((d|0)!=0?(u=0,na(c[(c[d>>2]|0)+4>>2]|0,d|0),e=u,u=0,e&1):0){break}u=0;na(186,a|0);e=u;u=0;if(!(e&1)){Hv(a);i=b;return}e=qb(-1,-1)|0;Hv(a);vb(e|0)}}while(0);b=qb(-1,-1)|0;u=0;na(186,a|0);e=u;u=0;if(e&1){e=qb(-1,-1,0)|0;jd(e)}else{e=b;Hv(a);vb(e|0)}}function Nj(a){a=a|0;var b=0;b=i;a=c[a+92>>2]|0;a=Bc[c[(c[a>>2]|0)+8>>2]&255](a)|0;i=b;return a|0}function Oj(a){a=a|0;var b=0;b=i;a=c[a+92>>2]|0;a=Bc[c[(c[a>>2]|0)+12>>2]&255](a)|0;i=b;return a|0}function Pj(a){a=a|0;return 3}function Qj(a){a=a|0;var b=0,d=0;b=i;d=c[a+88>>2]|0;d=Bc[c[(c[d>>2]|0)+20>>2]&255](d)|0;a=c[a+92>>2]|0;a=(Bc[c[(c[a>>2]|0)+20>>2]&255](a)|0)+d|0;i=b;return a|0}function Rj(a,b){a=a|0;b=b|0;var d=0,e=0;d=i;e=c[a+88>>2]|0;zc[c[(c[e>>2]|0)+28>>2]&127](e,b);a=c[a+92>>2]|0;zc[c[(c[a>>2]|0)+28>>2]&127](a,b);i=d;return}function Sj(a,b){a=a|0;b=b|0;var d=0,e=0;d=i;e=c[a+88>>2]|0;zc[c[(c[e>>2]|0)+32>>2]&127](e,b);a=c[a+92>>2]|0;zc[c[(c[a>>2]|0)+32>>2]&127](a,b);i=d;return}function Tj(a){a=a|0;var b=0,d=0,e=0;d=i;b=Fv(96)|0;u=0;oa(115,b|0,a|0);e=u;u=0;if(e&1){e=qb(-1,-1)|0;Hv(b);vb(e|0)}else{c[b>>2]=6864;c[b+88>>2]=c[a+88>>2];c[b+92>>2]=c[a+92>>2];i=d;return b|0}return 0}function Uj(a){a=a|0;var b=0,d=0,e=0;b=i;i=i+16|0;d=b;Ah(7e3,d)|0;e=c[a+88>>2]|0;yc[c[(c[e>>2]|0)+40>>2]&255](e);Ah(7032,d)|0;a=c[a+92>>2]|0;yc[c[(c[a>>2]|0)+40>>2]&255](a);i=b;return}function Vj(a,b,d){a=a|0;b=b|0;d=+d;var e=0,f=0;e=i;f=c[a+88>>2]|0;_c[c[(c[f>>2]|0)+48>>2]&15](f,b,d);a=c[a+92>>2]|0;_c[c[(c[a>>2]|0)+48>>2]&15](a,b,d);i=e;return}function Wj(a,b){a=a|0;b=b|0;var d=0,e=0;d=i;e=c[a+88>>2]|0;zc[c[(c[e>>2]|0)+52>>2]&127](e,b);a=c[a+92>>2]|0;zc[c[(c[a>>2]|0)+52>>2]&127](a,b);i=d;return}function Xj(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0;f=i;g=c[a+88>>2]|0;$c[c[(c[g>>2]|0)+64>>2]&31](g,b,d,e);a=c[a+92>>2]|0;$c[c[(c[a>>2]|0)+64>>2]&31](a,b,d,e);i=f;return}function Yj(a){a=a|0;return}function Zj(a){a=a|0;return}function _j(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0;q=i;i=i+32|0;g=q+30|0;f=q+29|0;s=q+16|0;v=q+12|0;p=q;r=q+28|0;a[g+0>>0]=a[f+0>>0]|0;Dd(b,e,g);c[b>>2]=7072;g=b+96|0;f=b+100|0;k=b+120|0;c[g+0>>2]=0;c[g+4>>2]=0;c[g+8>>2]=0;c[g+12>>2]=0;c[g+16>>2]=0;c[g+20>>2]=0;c[k>>2]=-1;k=b+124|0;l=b+132|0;h=b+136|0;j=b+156|0;c[k+0>>2]=0;c[k+4>>2]=0;c[k+8>>2]=0;c[k+12>>2]=0;c[k+16>>2]=0;c[j>>2]=8192;j=b+144|0;c[j>>2]=0;k=b+148|0;c[k>>2]=0;m=b+160|0;c[m>>2]=0;n=b+164|0;c[n>>2]=0;u=0;w=qa(119,16)|0;z=u;u=0;do{if(!(z&1)){t=s+8|0;c[t>>2]=w;c[s>>2]=17;c[s+4>>2]=13;z=w+0|0;y=2920|0;x=z+13|0;do{a[z>>0]=a[y>>0]|0;z=z+1|0;y=y+1|0}while((z|0)<(x|0));a[w+13>>0]=0;c[v>>2]=10;u=0;v=ua(28,e|0,s|0,v|0)|0;z=u;u=0;if(z&1){p=qb(-1,-1)|0;if((a[s>>0]&1)==0){break}Hv(c[t>>2]|0);break}c[b+88>>2]=v;if(!((a[s>>0]&1)==0)){Hv(c[t>>2]|0)}a[p>>0]=14;s=p+1|0;a[s+0>>0]=a[7152>>0]|0;a[s+1>>0]=a[7153>>0]|0;a[s+2>>0]=a[7154>>0]|0;a[s+3>>0]=a[7155>>0]|0;a[s+4>>0]=a[7156>>0]|0;a[s+5>>0]=a[7157>>0]|0;a[s+6>>0]=a[7158>>0]|0;s=p+8|0;a[s>>0]=0;a[r>>0]=1;u=0;e=ua(27,e|0,p|0,r|0)|0;z=u;u=0;if(z&1){d=qb(-1,-1)|0;if((a[p>>0]&1)==0){p=d;break}Hv(c[s>>2]|0);p=d;break}a[b+92>>0]=e&1;if(!((a[p>>0]&1)==0)){Hv(c[s>>2]|0)}u=0;oa(79,b|0,d|0);z=u;u=0;if(!(z&1)){i=q;return}else{o=10}}else{o=10}}while(0);if((o|0)==10){p=qb(-1,-1)|0}o=c[k>>2]|0;if((o|0)!=0){do{z=o;o=c[o>>2]|0;Bv(z);c[k>>2]=o}while((o|0)!=0)}c[k>>2]=0;c[j>>2]=0;c[m>>2]=0;c[n>>2]=0;j=c[l>>2]|0;if((j|0)!=0){k=c[h>>2]|0;if((k|0)!=(j|0)){c[h>>2]=k+(~((k+ -8+(0-j)|0)>>>3)<<3)}Hv(j)}g=c[g>>2]|0;if((g|0)!=0){h=c[f>>2]|0;if((h|0)!=(g|0)){c[f>>2]=h+(~((h+ -4+(0-g)|0)>>>2)<<2)}Hv(g)}u=0;na(186,b|0);z=u;u=0;if(z&1){z=qb(-1,-1,0)|0;jd(z)}else{vb(p|0)}}function $j(a){a=a|0;var b=0;b=i;Lk(a);i=b;return}function ak(a){a=a|0;var b=0,c=0;b=i;u=0;na(202,a|0);c=u;u=0;if(c&1){c=qb(-1,-1)|0;Hv(a);vb(c|0)}else{Hv(a);i=b;return}}function bk(a){a=a|0;return 4}function ck(a){a=a|0;return(c[a+164>>2]|0)+(c[a+160>>2]|0)+(c[a+12>>2]<<2)|0}function dk(b,d){b=b|0;d=d|0;var e=0,f=0,g=0;f=i;i=i+16|0;g=f;yc[c[(c[b>>2]|0)+68>>2]&255](b);e=g+4|0;c[e>>2]=d;d=g+8|0;a[d>>0]=0;u=0;oa(116,b|0,g|0);b=u;u=0;if(b&1){b=qb(-1,-1)|0;if((a[d>>0]|0)==0){vb(b|0)}Rb(c[e>>2]|0)|0;vb(b|0)}else{if((a[d>>0]|0)==0){i=f;return}Rb(c[e>>2]|0)|0;i=f;return}}function ek(b,d){b=b|0;d=d|0;var e=0,f=0,g=0;f=i;i=i+16|0;g=f;e=g+4|0;c[e>>2]=d;d=g+8|0;a[d>>0]=0;u=0;oa(117,b|0,g|0);b=u;u=0;if(b&1){b=qb(-1,-1)|0;if((a[d>>0]|0)==0){vb(b|0)}Rb(c[e>>2]|0)|0;vb(b|0)}else{if((a[d>>0]|0)==0){i=f;return}Rb(c[e>>2]|0)|0;i=f;return}}function fk(a){a=a|0;var b=0,c=0;c=i;b=Fv(168)|0;u=0;oa(118,b|0,a|0);a=u;u=0;if(a&1){c=qb(-1,-1)|0;Hv(b);vb(c|0)}else{i=c;return b|0}return 0}function gk(a,b,d){a=a|0;b=b|0;d=+d;var e=0;e=i;if((c[b+4>>2]|0)==(c[a+20>>2]|0)){He(a,b);yc[c[(c[a>>2]|0)+40>>2]&255](a);i=e;return}else{Wa(1208,7248,145,1232)}}function hk(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0,j=0,k=0.0,l=0,m=0,n=0,o=0,p=0.0,q=0.0,r=0.0,s=0,t=0;h=i;i=i+16|0;j=h;k=+g[f+4>>2]+1.0;l=c[b+20>>2]|0;c[j>>2]=0;f=j+4|0;c[f>>2]=0;s=j+8|0;c[s>>2]=0;o=(l|0)==0;a:do{if(o){r=0.0}else{if(l>>>0>1073741823){u=0;na(189,0);t=u;u=0}else{u=0;m=qa(119,l<<2|0)|0;t=u;u=0;if(!(t&1)){c[f>>2]=m;c[j>>2]=m;n=m+(l<<2)|0;c[s>>2]=n;s=l;t=m;while(1){if((t|0)!=0){g[t>>2]=0.0}s=s+ -1|0;if((s|0)==0){break}else{t=t+4|0}}c[f>>2]=n;if(o){r=0.0;break}n=c[b+132>>2]|0;r=0.0;o=0;while(1){p=+g[e+(o<<2)>>2];q=+g[n+(o<<3)>>2];if(p<q){q=p-q;q=q*q;g[m+(o<<2)>>2]=q;r=r+q}q=+g[n+(o<<3)+4>>2];if(p>q){q=p-q;q=q*q;g[m+(o<<2)>>2]=q;r=r+q}o=o+1|0;if((o|0)==(l|0)){break a}}}}h=qb(-1,-1)|0;b=c[j>>2]|0;if((b|0)==0){vb(h|0)}j=c[f>>2]|0;if((j|0)!=(b|0)){c[f>>2]=j+(~((j+ -4+(0-b)|0)>>>2)<<2)}Hv(b);vb(h|0)}}while(0);l=c[b+128>>2]|0;if((a[b+36>>0]|0)==0){u=0;Aa(2,b|0,d|0,e|0,l|0,+r,j|0,+k);t=u;u=0;if(t&1){b=24}else{b=29}}else{u=0;Aa(1,b|0,d|0,e|0,l|0,+r,j|0,+k);t=u;u=0;if(t&1){b=24}else{b=29}}if((b|0)==24){h=qb(-1,-1)|0;j=c[j>>2]|0;if((j|0)==0){vb(h|0)}b=c[f>>2]|0;if((b|0)!=(j|0)){c[f>>2]=b+(~((b+ -4+(0-j)|0)>>>2)<<2)}Hv(j);vb(h|0)}else if((b|0)==29){j=c[j>>2]|0;if((j|0)==0){i=h;return}b=c[f>>2]|0;if((b|0)!=(j|0)){c[f>>2]=b+(~((b+ -4+(0-j)|0)>>>2)<<2)}Hv(j);i=h;return}}function ik(a){a=a|0;var b=0,d=0,e=0,f=0;b=i;d=a+124|0;e=c[d>>2]|0;if((e|0)!=0){Iv(e);c[a+108>>2]=0;c[a+112>>2]=0;c[a+116>>2]=0;c[a+120>>2]=-1;c[d>>2]=0}d=a+148|0;e=c[d>>2]|0;if((e|0)!=0){do{f=e;e=c[e>>2]|0;Bv(f);c[d>>2]=e}while((e|0)!=0)}c[d>>2]=0;c[a+144>>2]=0;c[a+160>>2]=0;c[a+164>>2]=0;i=b;return}function jk(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0;d=i;f=b+96|0;e=b+12|0;k=c[e>>2]|0;l=b+100|0;m=c[l>>2]|0;j=c[f>>2]|0;h=m-j>>2;if(!(h>>>0<k>>>0)){if(h>>>0>k>>>0?(g=j+(k<<2)|0,(m|0)!=(g|0)):0){c[l>>2]=m+(~((m+ -4+(0-g)|0)>>>2)<<2)}}else{eh(f,k-h|0);k=c[e>>2]|0}if((k|0)!=0){g=c[f>>2]|0;h=0;do{c[g+(h<<2)>>2]=h;h=h+1|0}while(h>>>0<(c[e>>2]|0)>>>0)}n=b+132|0;kk(b,n);n=lk(b,0,c[e>>2]|0,n)|0;c[b+128>>2]=n;if((a[b+92>>0]|0)==0){i=d;return}n=c[e>>2]|0;h=b+20|0;l=c[h>>2]|0;m=fa(l,n)|0;m=Gv(m>>>0>1073741823?-1:m<<2)|0;k=l<<2;c[b+108>>2]=n;c[b+112>>2]=l;g=b+116|0;c[g>>2]=k;c[b+120>>2]=8;j=b+124|0;c[j>>2]=m;if((n|0)==0){i=d;return}b=b+72|0;n=0;while(1){vw(m+(fa(k,n)|0)|0,c[(c[b>>2]|0)+(c[(c[f>>2]|0)+(n<<2)>>2]<<2)>>2]|0,l<<2|0)|0;n=n+1|0;if(!(n>>>0<(c[e>>2]|0)>>>0)){break}k=c[g>>2]|0;m=c[j>>2]|0;l=c[h>>2]|0}i=d;return}function kk(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0.0,o=0,p=0;d=i;j=a+20|0;f=c[j>>2]|0;l=b+4|0;m=c[l>>2]|0;k=c[b>>2]|0;e=m-k>>3;if(!(e>>>0<f>>>0)){if(e>>>0>f>>>0?(h=k+(f<<3)|0,(m|0)!=(h|0)):0){c[l>>2]=m+(~((m+ -8+(0-h)|0)>>>3)<<3)}}else{ok(b,f-e|0);f=c[j>>2]|0}if((f|0)==0){f=0}else{e=c[c[a+72>>2]>>2]|0;j=c[b>>2]|0;h=0;do{p=e+(h<<2)|0;g[j+(h<<3)>>2]=+g[p>>2];g[j+(h<<3)+4>>2]=+g[p>>2];h=h+1|0}while(h>>>0<f>>>0)}h=c[a+12>>2]|0;if(!(h>>>0>1)){i=d;return}e=(f|0)==0;l=a+72|0;j=1;do{if(!e){a=c[(c[l>>2]|0)+(j<<2)>>2]|0;m=c[b>>2]|0;k=0;do{o=a+(k<<2)|0;n=+g[o>>2];p=m+(k<<3)|0;if(n<+g[p>>2]){g[p>>2]=n;n=+g[o>>2]}o=m+(k<<3)+4|0;if(n>+g[o>>2]){g[o>>2]=n}k=k+1|0}while(k>>>0<f>>>0)}j=j+1|0}while(j>>>0<h>>>0);i=d;return}function lk(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,s=0.0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0.0;f=i;i=i+48|0;n=f+32|0;o=f+28|0;q=f+24|0;k=f+12|0;m=f;j=a+144|0;p=c[j>>2]|0;do{if((p|0)<32){h=a+164|0;c[h>>2]=(c[h>>2]|0)+p;h=Av(8192)|0;if((h|0)==0){zb(3048,27,1,c[r>>2]|0)|0;h=0;break}else{p=a+148|0;c[h>>2]=c[p>>2];c[p>>2]=h;c[j>>2]=8188;h=h+4|0;c[a+152>>2]=h;p=8156;l=6;break}}else{h=c[a+152>>2]|0;p=p+ -32|0;l=6}}while(0);if((l|0)==6){c[a+152>>2]=h+32;c[j>>2]=p;y=a+160|0;c[y>>2]=(c[y>>2]|0)+32}c[h+0>>2]=0;c[h+4>>2]=0;c[h+8>>2]=0;c[h+12>>2]=0;c[h+16>>2]=0;c[h+20>>2]=0;c[h+24>>2]=0;j=d-b|0;if((j|0)<=(c[a+88>>2]|0)){c[h+24>>2]=0;c[h+20>>2]=0;c[h>>2]=b;c[h+4>>2]=d;j=c[a+20>>2]|0;if((j|0)==0){j=0}else{l=c[(c[a+72>>2]|0)+(c[(c[a+96>>2]|0)+(b<<2)>>2]<<2)>>2]|0;m=c[e>>2]|0;k=0;do{y=l+(k<<2)|0;g[m+(k<<3)>>2]=+g[y>>2];g[m+(k<<3)+4>>2]=+g[y>>2];k=k+1|0}while(k>>>0<j>>>0)}o=b+1|0;if((o|0)>=(d|0)){i=f;return h|0}l=(j|0)==0;k=a+96|0;a=a+72|0;do{if(!l){n=c[e>>2]|0;b=c[(c[a>>2]|0)+(c[(c[k>>2]|0)+(o<<2)>>2]<<2)>>2]|0;m=0;do{q=n+(m<<3)|0;p=b+(m<<2)|0;s=+g[p>>2];if(+g[q>>2]>s){g[q>>2]=s;s=+g[p>>2]}p=n+(m<<3)+4|0;if(+g[p>>2]<s){g[p>>2]=s}m=m+1|0}while(m>>>0<j>>>0)}o=o+1|0}while((o|0)!=(d|0));i=f;return h|0}mk(a,(c[a+96>>2]|0)+(b<<2)|0,j,n,o,q,e);c[h+8>>2]=c[o>>2];c[k>>2]=0;j=k+4|0;c[j>>2]=0;x=k+8|0;c[x>>2]=0;p=e+4|0;v=c[p>>2]|0;w=c[e>>2]|0;t=v-w|0;y=t>>3;if(y>>>0>536870911){ss(0)}t=Fv(t)|0;c[j>>2]=t;c[k>>2]=t;c[x>>2]=t+(y<<3);if((w|0)!=(v|0)){x=t;do{if((x|0)==0){x=0}else{A=w;z=c[A+4>>2]|0;y=x;c[y>>2]=c[A>>2];c[y+4>>2]=z}x=x+8|0;c[j>>2]=x;w=w+8|0}while((w|0)!=(v|0))}s=+g[q>>2];o=c[o>>2]|0;g[t+(o<<3)+4>>2]=s;n=(c[n>>2]|0)+b|0;u=0;b=Ma(8,a|0,b|0,n|0,k|0)|0;A=u;u=0;do{if(A&1){f=qb(-1,-1)|0;l=42}else{c[h+20>>2]=b;c[m>>2]=0;b=m+4|0;c[b>>2]=0;t=m+8|0;c[t>>2]=0;p=c[p>>2]|0;v=c[e>>2]|0;q=p-v|0;w=q>>3;if(w>>>0>536870911){u=0;na(189,0);A=u;u=0}else{u=0;q=qa(119,q|0)|0;A=u;u=0;if(!(A&1)){c[b>>2]=q;c[m>>2]=q;c[t>>2]=q+(w<<3);if((v|0)!=(p|0)){t=q;do{if((t|0)==0){t=0}else{y=v;z=c[y+4>>2]|0;A=t;c[A>>2]=c[y>>2];c[A+4>>2]=z}t=t+8|0;c[b>>2]=t;v=v+8|0}while((v|0)!=(p|0))}g[q+(o<<3)>>2]=s;u=0;d=Ma(8,a|0,n|0,d|0,m|0)|0;A=u;u=0;if(A&1){f=qb(-1,-1)|0;e=c[m>>2]|0;if((e|0)==0){break}h=c[b>>2]|0;if((h|0)!=(e|0)){c[b>>2]=h+(~((h+ -8+(0-e)|0)>>>3)<<3)}Hv(e);break}c[h+24>>2]=d;d=c[k>>2]|0;g[h+12>>2]=+g[d+(o<<3)+4>>2];k=c[m>>2]|0;g[h+16>>2]=+g[k+(o<<3)>>2];a=c[a+20>>2]|0;if((a|0)!=0){e=c[e>>2]|0;l=0;do{B=+g[k+(l<<3)>>2];s=+g[d+(l<<3)>>2];g[e+(l<<3)>>2]=B<s?B:s;s=+g[d+(l<<3)+4>>2];B=+g[k+(l<<3)+4>>2];g[e+(l<<3)+4>>2]=s<B?B:s;l=l+1|0}while(l>>>0<a>>>0)}if((k|0)!=0){e=c[b>>2]|0;if((e|0)!=(k|0)){c[b>>2]=e+(~((e+ -8+(0-k)|0)>>>3)<<3)}Hv(k)}if((d|0)==0){i=f;return h|0}e=c[j>>2]|0;if((e|0)!=(d|0)){c[j>>2]=e+(~((e+ -8+(0-d)|0)>>>3)<<3)}Hv(d);i=f;return h|0}}f=qb(-1,-1)|0;l=42}}while(0);h=c[k>>2]|0;if((h|0)==0){vb(f|0)}e=c[j>>2]|0;if((e|0)!=(h|0)){c[j>>2]=e+(~((e+ -8+(0-h)|0)>>>3)<<3)}Hv(h);vb(f|0);return 0}function mk(a,b,d,e,f,h,j){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0.0,v=0.0,w=0.0,x=0.0,y=0,z=0.0,A=0.0,B=0;k=i;i=i+16|0;m=k+4|0;l=k;j=c[j>>2]|0;u=+g[j+4>>2];v=+g[j>>2];c[f>>2]=0;g[h>>2]=(u+v)*.5;n=a+20|0;s=c[n>>2]|0;if(s>>>0>1){o=0;p=1;u=u-v;do{w=+g[j+(p<<3)+4>>2];x=+g[j+(p<<3)>>2];v=w-x;if(v>u){c[f>>2]=p;g[h>>2]=(w+x)*.5;o=p;s=c[n>>2]|0;u=v}p=p+1|0}while(p>>>0<s>>>0)}else{o=0}p=c[a+72>>2]|0;w=+g[(c[p+(c[b>>2]<<2)>>2]|0)+(o<<2)>>2];q=(d|0)>1;if(q){v=w;u=w;x=w;r=1;while(1){w=+g[(c[p+(c[b+(r<<2)>>2]<<2)>>2]|0)+(o<<2)>>2];t=w<v;v=t?w:v;x=t?u:x;t=w>x;u=t?w:u;r=r+1|0;if((r|0)==(d|0)){w=u;break}else{x=t?w:x}}}else{v=w}u=(v+w)*.5;g[h>>2]=u;if((s|0)!=0){t=o;r=0;v=w-v;do{if((r|0)!=(o|0)?+g[j+(r<<3)+4>>2]- +g[j+(r<<3)>>2]>v:0){w=+g[(c[p+(c[b>>2]<<2)>>2]|0)+(r<<2)>>2];if(q){z=w;x=w;A=w;y=1;while(1){w=+g[(c[p+(c[b+(y<<2)>>2]<<2)>>2]|0)+(r<<2)>>2];B=w<z;z=B?w:z;A=B?x:A;B=w>A;x=B?w:x;y=y+1|0;if((y|0)==(d|0)){break}else{A=B?w:A}}}else{x=w;z=w}w=x-z;if(w>v){c[f>>2]=r;u=(z+x)*.5;g[h>>2]=u;t=r;s=c[n>>2]|0;v=w}}r=r+1|0}while(r>>>0<s>>>0);o=t}nk(a,b,d,o,u,m,l);a=c[m>>2]|0;m=(d|0)/2|0;do{if((a|0)<=(m|0)){l=c[l>>2]|0;if((l|0)<(m|0)){c[e>>2]=l;m=l;break}else{c[e>>2]=m;break}}else{c[e>>2]=a;m=a}}while(0);if((m|0)>0&(m|0)<(d|0)){i=k;return}else{Wa(7216,7248,492,7312)}}function nk(a,b,d,e,f,h,j){a=a|0;b=b|0;d=d|0;e=e|0;f=+f;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0;k=i;d=d+ -1|0;a=a+72|0;m=0;l=d;a:while(1){b:do{if((m|0)<=(l|0)){n=c[a>>2]|0;while(1){o=m+1|0;if(!(+g[(c[n+(c[b+(m<<2)>>2]<<2)>>2]|0)+(e<<2)>>2]<f)){break b}if((m|0)<(l|0)){m=o}else{m=o;break}}}}while(0);if((m|0)>(l|0)){break}n=c[a>>2]|0;while(1){o=b+(l<<2)|0;p=c[o>>2]|0;l=l+ -1|0;if(!(+g[(c[n+(p<<2)>>2]|0)+(e<<2)>>2]>=f)){break}if((m|0)>(l|0)){break a}}q=b+(m<<2)|0;n=c[q>>2]|0;c[q>>2]=p;c[o>>2]=n;m=m+1|0}c[h>>2]=m;c:while(1){d:do{if((m|0)<=(d|0)){h=c[a>>2]|0;while(1){l=m+1|0;if(!(+g[(c[h+(c[b+(m<<2)>>2]<<2)>>2]|0)+(e<<2)>>2]<=f)){break d}if((m|0)<(d|0)){m=l}else{m=l;break}}}}while(0);if((m|0)>(d|0)){b=21;break}h=c[a>>2]|0;while(1){n=b+(d<<2)|0;l=c[n>>2]|0;d=d+ -1|0;if(!(+g[(c[h+(l<<2)>>2]|0)+(e<<2)>>2]>f)){break}if((m|0)>(d|0)){b=21;break c}}p=b+(m<<2)|0;q=c[p>>2]|0;c[p>>2]=l;c[n>>2]=q;m=m+1|0}if((b|0)==21){c[j>>2]=m;i=k;return}}function ok(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0;e=i;f=a+8|0;d=a+4|0;k=c[d>>2]|0;j=c[f>>2]|0;g=k;if(!(j-g>>3>>>0<b>>>0)){do{if((k|0)==0){f=0}else{f=k;c[f>>2]=0;c[f+4>>2]=0;f=c[d>>2]|0}k=f+8|0;c[d>>2]=k;b=b+ -1|0}while((b|0)!=0);i=e;return}l=c[a>>2]|0;g=g-l>>3;k=g+b|0;if(k>>>0>536870911){ss(0)}j=j-l|0;if(j>>3>>>0<268435455){l=j>>2;k=l>>>0<k>>>0?k:l;if((k|0)==0){j=0;k=0}else{h=9}}else{k=536870911;h=9}if((h|0)==9){j=k;k=Fv(k<<3)|0}h=k+(g<<3)|0;do{if((h|0)==0){h=0}else{l=h;c[l>>2]=0;c[l+4>>2]=0}h=h+8|0;b=b+ -1|0}while((b|0)!=0);b=c[a>>2]|0;m=(c[d>>2]|0)-b|0;l=k+(g-(m>>3)<<3)|0;tw(l|0,b|0,m|0)|0;c[a>>2]=l;c[d>>2]=h;c[f>>2]=k+(j<<3);if((b|0)==0){i=e;return}Hv(b);i=e;return}function pk(a){a=a|0;return}function qk(b,d,e,f,h,j,k){b=b|0;d=d|0;e=e|0;f=f|0;h=+h;j=j|0;k=+k;var l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0.0,B=0.0,C=0.0,D=0.0;l=i;p=f+20|0;n=c[p>>2]|0;o=f+24|0;if((n|0)==0?(c[o>>2]|0)==0:0){k=+Kc[c[(c[d>>2]|0)+16>>2]&7](d);t=c[f>>2]|0;s=f+4|0;u=c[s>>2]|0;if((t|0)>=(u|0)){i=l;return}n=b+96|0;j=b+40|0;r=b+92|0;f=b+72|0;p=b+20|0;q=k>0.0;o=b+124|0;b=b+116|0;do{v=c[(c[n>>2]|0)+(t<<2)>>2]|0;if((c[(c[j>>2]|0)+(v>>>5<<2)>>2]&1<<(v&31)|0)==0){if((a[r>>0]|0)==0){y=c[(c[f>>2]|0)+(v<<2)>>2]|0}else{y=(c[o>>2]|0)+(fa(c[b>>2]|0,t)|0)|0}z=c[p>>2]|0;w=e+(z<<2)|0;z=e+(z+ -3<<2)|0;x=e;h=0.0;while(1){if(!(x>>>0<z>>>0)){m=11;break}D=+g[x>>2]- +g[y>>2];C=+g[x+4>>2]- +g[y+4>>2];A=+g[x+8>>2]- +g[y+8>>2];B=+g[x+12>>2]- +g[y+12>>2];h=h+(D*D+C*C+A*A+B*B);if(q&h>k){break}else{x=x+16|0;y=y+16|0}}if((m|0)==11){m=0;if(x>>>0<w>>>0){while(1){D=+g[x>>2]- +g[y>>2];x=x+4|0;h=h+D*D;if(!(x>>>0<w>>>0)){break}else{y=y+4|0}}}}if(h<k){Ec[c[(c[d>>2]|0)+12>>2]&7](d,h,v);u=c[s>>2]|0}}t=t+1|0}while((t|0)<(u|0));i=l;return}m=c[f+8>>2]|0;B=+g[e+(m<<2)>>2];A=B- +g[f+12>>2];B=B- +g[f+16>>2];if(A+B<0.0){A=B*B;n=c[o>>2]|0}else{p=o;A=A*A}qk(b,d,e,c[p>>2]|0,h,j,k);z=(c[j>>2]|0)+(m<<2)|0;B=+g[z>>2];h=A+h-B;g[z>>2]=A;if(h*k<=+Kc[c[(c[d>>2]|0)+16>>2]&7](d)){qk(b,d,e,n,h,j,k)}g[(c[j>>2]|0)+(m<<2)>>2]=B;i=l;return}function rk(b,d,e,f,h,j,k){b=b|0;d=d|0;e=e|0;f=f|0;h=+h;j=j|0;k=+k;var l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0.0,z=0.0,A=0.0,B=0.0;l=i;p=f+20|0;o=c[p>>2]|0;n=f+24|0;if((o|0)==0?(c[n>>2]|0)==0:0){k=+Kc[c[(c[d>>2]|0)+16>>2]&7](d);s=c[f>>2]|0;r=f+4|0;t=c[r>>2]|0;if((s|0)>=(t|0)){i=l;return}j=b+92|0;p=b+96|0;q=b+72|0;o=b+20|0;f=k>0.0;n=b+124|0;b=b+116|0;do{if((a[j>>0]|0)==0){x=c[(c[q>>2]|0)+(c[(c[p>>2]|0)+(s<<2)>>2]<<2)>>2]|0}else{x=(c[n>>2]|0)+(fa(c[b>>2]|0,s)|0)|0}w=c[o>>2]|0;u=e+(w<<2)|0;w=e+(w+ -3<<2)|0;v=e;h=0.0;while(1){if(!(v>>>0<w>>>0)){m=10;break}B=+g[v>>2]- +g[x>>2];A=+g[v+4>>2]- +g[x+4>>2];y=+g[v+8>>2]- +g[x+8>>2];z=+g[v+12>>2]- +g[x+12>>2];h=h+(B*B+A*A+y*y+z*z);if(f&h>k){break}else{v=v+16|0;x=x+16|0}}if((m|0)==10){m=0;if(v>>>0<u>>>0){w=x;while(1){B=+g[v>>2]- +g[w>>2];v=v+4|0;h=h+B*B;if(!(v>>>0<u>>>0)){break}else{w=w+4|0}}}}if(h<k){Ec[c[(c[d>>2]|0)+12>>2]&7](d,h,c[(c[p>>2]|0)+(s<<2)>>2]|0);t=c[r>>2]|0}s=s+1|0}while((s|0)<(t|0));i=l;return}m=c[f+8>>2]|0;z=+g[e+(m<<2)>>2];y=z- +g[f+12>>2];z=z- +g[f+16>>2];if(y+z<0.0){y=z*z;o=c[n>>2]|0}else{p=n;y=y*y}rk(b,d,e,c[p>>2]|0,h,j,k);x=(c[j>>2]|0)+(m<<2)|0;z=+g[x>>2];h=y+h-z;g[x>>2]=y;if(h*k<=+Kc[c[(c[d>>2]|0)+16>>2]&7](d)){rk(b,d,e,o,h,j,k)}g[(c[j>>2]|0)+(m<<2)>>2]=z;i=l;return}function sk(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0;k=i;Le(b,d);c[b>>2]=7072;c[b+88>>2]=c[d+88>>2];o=b+92|0;a[o>>0]=a[d+92>>0]|0;e=b+96|0;u=0;oa(119,e|0,d+96|0);w=u;u=0;if(!(w&1)){m=b+108|0;c[m>>2]=0;j=b+112|0;c[j>>2]=0;n=b+116|0;c[n>>2]=0;h=b+120|0;c[h>>2]=-1;l=b+124|0;c[l>>2]=0;g=b+132|0;c[g>>2]=0;f=b+136|0;c[f>>2]=0;t=b+140|0;c[t>>2]=0;r=d+136|0;v=d+132|0;q=(c[r>>2]|0)-(c[v>>2]|0)|0;s=q>>3;a:do{if((s|0)==0){p=15}else{if(s>>>0>536870911){u=0;na(189,0);w=u;u=0}else{u=0;q=qa(119,q|0)|0;w=u;u=0;if(!(w&1)){c[f>>2]=q;c[g>>2]=q;c[t>>2]=q+(s<<3);s=c[v>>2]|0;p=c[r>>2]|0;if((s|0)==(p|0)){p=15;break}else{r=s}while(1){if((q|0)==0){q=0}else{v=r;w=c[v+4>>2]|0;c[q>>2]=c[v>>2];c[q+4>>2]=w;q=c[f>>2]|0}q=q+8|0;c[f>>2]=q;r=r+8|0;if((r|0)==(p|0)){p=15;break a}}}}h=qb(-1,-1)|0;j=c[g>>2]|0;if((j|0)!=0){g=c[f>>2]|0;if((g|0)!=(j|0)){c[f>>2]=g+(~((g+ -8+(0-j)|0)>>>3)<<3)}Hv(j)}}}while(0);if((p|0)==15){c[b+156>>2]=8192;p=b+144|0;c[p>>2]=0;q=b+148|0;c[q>>2]=0;s=b+160|0;c[s>>2]=0;r=b+164|0;c[r>>2]=0;if((a[o>>0]|0)==0){v=b+128|0;w=d+128|0;tk(b,v,w);i=k;return}o=c[b+12>>2]|0;t=c[b+20>>2]|0;v=fa(t,o)|0;u=0;w=qa(121,(v>>>0>1073741823?-1:v<<2)|0)|0;x=u;u=0;if(!(x&1)){c[m>>2]=o;c[j>>2]=t;c[n>>2]=t<<2;c[h>>2]=8;c[l>>2]=w;x=c[d+124>>2]|0;vw(w|0,x|0,x+(v<<2)-x|0)|0;w=b+128|0;x=d+128|0;tk(b,w,x);i=k;return}h=qb(-1,-1)|0;c[q>>2]=0;c[p>>2]=0;c[s>>2]=0;c[r>>2]=0;g=c[g>>2]|0;if((g|0)!=0){j=c[f>>2]|0;if((j|0)!=(g|0)){c[f>>2]=j+(~((j+ -8+(0-g)|0)>>>3)<<3)}Hv(g)}}e=c[e>>2]|0;if((e|0)!=0){f=b+100|0;g=c[f>>2]|0;if((g|0)!=(e|0)){c[f>>2]=g+(~((g+ -4+(0-e)|0)>>>2)<<2)}Hv(e)}}else{h=qb(-1,-1)|0}u=0;na(186,b|0);x=u;u=0;if(x&1){x=qb(-1,-1,0)|0;jd(x)}else{vb(h|0)}}function tk(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0;m=i;h=a+144|0;k=a+164|0;f=c[r>>2]|0;g=a+148|0;j=a+152|0;l=a+160|0;while(1){o=c[h>>2]|0;do{if((o|0)<32){c[k>>2]=(c[k>>2]|0)+o;n=Av(8192)|0;if((n|0)==0){zb(3048,27,1,f|0)|0;n=0;break}else{c[n>>2]=c[g>>2];c[g>>2]=n;c[h>>2]=8188;n=n+4|0;c[j>>2]=n;o=8156;e=7;break}}else{n=c[j>>2]|0;o=o+ -32|0;e=7}}while(0);if((e|0)==7){e=0;c[j>>2]=n+32;c[h>>2]=o;c[l>>2]=(c[l>>2]|0)+32}c[n+0>>2]=0;c[n+4>>2]=0;c[n+8>>2]=0;c[n+12>>2]=0;c[n+16>>2]=0;c[n+20>>2]=0;c[n+24>>2]=0;c[b>>2]=n;o=c[d>>2]|0;c[n+0>>2]=c[o+0>>2];c[n+4>>2]=c[o+4>>2];c[n+8>>2]=c[o+8>>2];c[n+12>>2]=c[o+12>>2];c[n+16>>2]=c[o+16>>2];c[n+20>>2]=c[o+20>>2];c[n+24>>2]=c[o+24>>2];n=c[d>>2]|0;o=n+20|0;if((c[o>>2]|0)==0){e=11;break}if((c[n+24>>2]|0)==0){e=11;break}tk(a,(c[b>>2]|0)+20|0,o);b=(c[b>>2]|0)+24|0;d=(c[d>>2]|0)+24|0}if((e|0)==11){i=m;return}}function uk(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0;e=i;c[a>>2]=0;d=a+4|0;c[d>>2]=0;h=a+8|0;c[h>>2]=0;g=b+4|0;f=(c[g>>2]|0)-(c[b>>2]|0)|0;j=f>>2;if((j|0)==0){i=e;return}if(j>>>0>1073741823){u=0;na(189,0);j=u;u=0}else{u=0;f=qa(119,f|0)|0;k=u;u=0;if(!(k&1)){c[d>>2]=f;c[a>>2]=f;c[h>>2]=f+(j<<2);h=c[b>>2]|0;a=c[g>>2]|0;if((h|0)==(a|0)){i=e;return}g=(a+ -4+(0-h)|0)>>>2;b=f;while(1){if((b|0)!=0){c[b>>2]=c[h>>2]}h=h+4|0;if((h|0)==(a|0)){break}else{b=b+4|0}}c[d>>2]=f+(g+1<<2);i=e;return}}e=qb(-1,-1)|0;f=c[a>>2]|0;if((f|0)==0){vb(e|0)}a=c[d>>2]|0;if((a|0)!=(f|0)){c[d>>2]=a+(~((a+ -4+(0-f)|0)>>>2)<<2)}Hv(f);vb(e|0)}function vk(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0;g=i;i=i+32|0;e=g+24|0;o=g+12|0;h=g;m=g+28|0;c[d>>2]=b;f=b+92|0;do{if((a[f>>0]|0)!=0){n=b+24|0;s=Fv(16)|0;j=h+8|0;c[j>>2]=s;c[h>>2]=17;c[h+4>>2]=12;v=s+0|0;r=1624|0;t=v+12|0;do{a[v>>0]=a[r>>0]|0;v=v+1|0;r=r+1|0}while((v|0)<(t|0));a[s+12>>0]=0;r=Pf(n,e,h)|0;s=c[r>>2]|0;if((s|0)==0){u=0;Na(43,o|0,n|0,h|0);v=u;u=0;if(!(v&1)){q=c[o>>2]|0;c[o>>2]=0;o=c[e>>2]|0;c[q>>2]=0;c[q+4>>2]=0;c[q+8>>2]=o;c[r>>2]=q;o=c[c[n>>2]>>2]|0;if((o|0)==0){n=q}else{c[n>>2]=o;n=c[r>>2]|0}ge(c[b+28>>2]|0,n);p=b+32|0;c[p>>2]=(c[p>>2]|0)+1;p=7}}else{q=s;p=7}if((p|0)==7?(a[m>>0]=0,k=q+28|0,v=c[k>>2]|0,l=q+32|0,u=0,oa(c[c[v>>2]>>2]|0,v|0,l|0),v=u,u=0,!(v&1)):0){if((a[2072]|0)==0?(Ua(2072)|0)!=0:0){c[516]=2088;rb(2072)}c[k>>2]=2064;if((a[7336]|0)==0?(Ua(7336)|0)!=0:0){c[1832]=7352;rb(7336)}c[k>>2]=7328;u=0;Na(c[(c[1832]|0)+4>>2]|0,7328,m|0,l|0);v=u;u=0;if(!(v&1)){if((a[h>>0]&1)==0){break}Hv(c[j>>2]|0);break}}e=qb(-1,-1)|0;if((a[h>>0]&1)==0){vb(e|0)}Hv(c[j>>2]|0);vb(e|0)}}while(0);lf(b,d);h=d+4|0;pc(a[f>>0]|0,c[h>>2]|0)|0;zb(b+88|0,4,1,c[h>>2]|0)|0;k=b+136|0;j=b+132|0;c[e>>2]=(c[k>>2]|0)-(c[j>>2]|0)>>3;zb(e|0,4,1,c[h>>2]|0)|0;l=c[j>>2]|0;if((c[k>>2]|0)!=(l|0)){m=0;do{zb(l+(m<<3)|0,4,1,c[h>>2]|0)|0;zb(l+(m<<3)+4|0,4,1,c[h>>2]|0)|0;m=m+1|0;l=c[j>>2]|0}while(m>>>0<(c[k>>2]|0)-l>>3>>>0)}k=b+100|0;j=b+96|0;c[e>>2]=(c[k>>2]|0)-(c[j>>2]|0)>>2;zb(e|0,4,1,c[h>>2]|0)|0;l=c[j>>2]|0;if((c[k>>2]|0)!=(l|0)){m=0;do{zb(l+(m<<2)|0,4,1,c[h>>2]|0)|0;m=m+1|0;l=c[j>>2]|0}while(m>>>0<(c[k>>2]|0)-l>>2>>>0)}if((a[f>>0]|0)==0){v=b+128|0;v=c[v>>2]|0;wk(v,d);i=g;return}v=b+108|0;zb(v|0,4,1,c[h>>2]|0)|0;zb(b+112|0,4,1,c[h>>2]|0)|0;t=b+116|0;zb(t|0,4,1,c[h>>2]|0)|0;c[e>>2]=c[b+120>>2];zb(e|0,4,1,c[h>>2]|0)|0;v=fa(c[t>>2]|0,c[v>>2]|0)|0;zb(c[b+124>>2]|0,v|0,1,c[h>>2]|0)|0;v=b+128|0;v=c[v>>2]|0;wk(v,d);i=g;return}function wk(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;d=i;e=b+4|0;while(1){zb(a|0,4,1,c[e>>2]|0)|0;zb(a+4|0,4,1,c[e>>2]|0)|0;zb(a+8|0,4,1,c[e>>2]|0)|0;zb(a+12|0,4,1,c[e>>2]|0)|0;zb(a+16|0,4,1,c[e>>2]|0)|0;f=a+20|0;if((c[f>>2]|0)==0){g=(c[a+24>>2]|0)==0&1}else{g=0}pc(g&255|0,c[e>>2]|0)|0;if(!(g<<24>>24==0)){break}wk(c[f>>2]|0,b);a=c[a+24>>2]|0}i=d;return}function xk(a,b){a=a|0;b=b|0;return}function yk(b,c,d){b=b|0;c=c|0;d=d|0;if((d|0)!=0){a[d>>0]=a[c>>0]|0}return}function zk(a,b,d){a=a|0;b=b|0;d=d|0;c[d>>2]=c[b>>2];return}function Ak(a,b,d){a=a|0;b=b|0;d=d|0;c[d>>2]=c[b>>2];return}function Bk(a,b){a=a|0;b=b|0;return b|0}function Ck(a){a=a|0;return 1}function Dk(a){a=a|0;return 24576}function Ek(b,c,d){b=b|0;c=c|0;d=d|0;b=i;ho(c,(a[d>>0]|0)!=0)|0;i=b;return}function Fk(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0;g=i;i=i+128|0;h=g+112|0;j=g+100|0;n=g+96|0;o=g+84|0;z=g+80|0;y=g+68|0;L=g+64|0;K=g+52|0;B=g+40|0;D=g+116|0;s=g+28|0;t=g+24|0;k=g+12|0;e=g;c[d>>2]=b;f=b+92|0;do{if((a[f>>0]|0)!=0){H=b+24|0;N=Fv(16)|0;C=B+8|0;c[C>>2]=N;c[B>>2]=17;c[B+4>>2]=12;J=N+0|0;I=1624|0;G=J+12|0;do{a[J>>0]=a[I>>0]|0;J=J+1|0;I=I+1|0}while((J|0)<(G|0));a[N+12>>0]=0;G=Pf(H,L,B)|0;I=c[G>>2]|0;if((I|0)==0){u=0;Na(43,K|0,H|0,B|0);N=u;u=0;if(!(N&1)){M=c[K>>2]|0;c[K>>2]=0;q=c[L>>2]|0;c[M>>2]=0;c[M+4>>2]=0;c[M+8>>2]=q;c[G>>2]=M;q=c[c[H>>2]>>2]|0;if((q|0)==0){q=M}else{c[H>>2]=q;q=c[G>>2]|0}ge(c[b+28>>2]|0,q);q=b+32|0;c[q>>2]=(c[q>>2]|0)+1;q=7}}else{M=I;q=7}if((q|0)==7?(a[D>>0]=0,E=M+28|0,N=c[E>>2]|0,F=M+32|0,u=0,oa(c[c[N>>2]>>2]|0,N|0,F|0),N=u,u=0,!(N&1)):0){if((a[2072]|0)==0?(Ua(2072)|0)!=0:0){c[516]=2088;rb(2072)}c[E>>2]=2064;if((a[7336]|0)==0?(Ua(7336)|0)!=0:0){c[1832]=7352;rb(7336)}c[E>>2]=7328;u=0;Na(c[(c[1832]|0)+4>>2]|0,7328,D|0,F|0);N=u;u=0;if(!(N&1)){if((a[B>>0]&1)==0){break}Hv(c[C>>2]|0);break}}e=qb(-1,-1)|0;if((a[B>>0]&1)==0){N=e;vb(N|0)}Hv(c[C>>2]|0);N=e;vb(N|0)}}while(0);Vf(b,d);C=d+4|0;if((Sa(f|0,1,1,c[C>>2]|0)|0)!=1){e=Jb(8)|0;u=0;oa(75,e|0,2592);N=u;u=0;if(N&1){N=qb(-1,-1)|0;pb(e|0);vb(N|0)}else{c[e>>2]=288;qc(e|0,264,1)}}B=b+88|0;if((Sa(B|0,4,1,c[C>>2]|0)|0)!=1){e=Jb(8)|0;u=0;oa(75,e|0,2592);N=u;u=0;if(N&1){N=qb(-1,-1)|0;pb(e|0);vb(N|0)}else{c[e>>2]=288;qc(e|0,264,1)}}Jk(d,b+132|0);Ik(d,b+96|0);if((a[f>>0]|0)!=0){Hk(b+108|0,d)}C=b+144|0;E=c[C>>2]|0;do{if((E|0)<32){D=b+164|0;c[D>>2]=(c[D>>2]|0)+E;D=Av(8192)|0;if((D|0)==0){zb(3048,27,1,c[r>>2]|0)|0;D=0;break}else{E=b+148|0;c[D>>2]=c[E>>2];c[E>>2]=D;c[C>>2]=8188;D=D+4|0;c[b+152>>2]=D;E=8156;q=34;break}}else{D=c[b+152>>2]|0;E=E+ -32|0;q=34}}while(0);if((q|0)==34){c[b+152>>2]=D+32;c[C>>2]=E;N=b+160|0;c[N>>2]=(c[N>>2]|0)+32}c[D+0>>2]=0;c[D+4>>2]=0;c[D+8>>2]=0;c[D+12>>2]=0;c[D+16>>2]=0;c[D+20>>2]=0;c[D+24>>2]=0;c[b+128>>2]=D;Gk(D,d);d=b+24|0;a[s>>0]=18;J=s+1|0;I=320|0;G=J+9|0;do{a[J>>0]=a[I>>0]|0;J=J+1|0;I=I+1|0}while((J|0)<(G|0));a[s+10>>0]=0;C=Pf(d,z,s)|0;D=c[C>>2]|0;if((D|0)==0){u=0;Na(43,y|0,d|0,s|0);N=u;u=0;if(!(N&1)){A=c[y>>2]|0;c[y>>2]=0;q=c[z>>2]|0;c[A>>2]=0;c[A+4>>2]=0;c[A+8>>2]=q;c[C>>2]=A;q=c[c[d>>2]>>2]|0;if((q|0)==0){q=A}else{c[d>>2]=q;q=c[C>>2]|0}ge(c[b+28>>2]|0,q);q=b+32|0;c[q>>2]=(c[q>>2]|0)+1;q=40}}else{A=D;q=40}if(((q|0)==40?(u=0,x=qa(c[(c[b>>2]|0)+16>>2]|0,b|0)|0,N=u,u=0,!(N&1)):0)?(c[t>>2]=x,w=A+28|0,N=c[w>>2]|0,v=A+32|0,u=0,oa(c[c[N>>2]>>2]|0,N|0,v|0),N=u,u=0,!(N&1)):0){if((a[2072]|0)==0?(Ua(2072)|0)!=0:0){c[516]=2088;rb(2072)}c[w>>2]=2064;if((a[2336]|0)==0?(Ua(2336)|0)!=0:0){c[582]=2352;rb(2336)}c[w>>2]=2328;u=0;Na(c[(c[582]|0)+4>>2]|0,2328,t|0,v|0);N=u;u=0;if(!(N&1)){if(!((a[s>>0]&1)==0)){Hv(c[s+8>>2]|0)}t=Fv(16)|0;s=k+8|0;c[s>>2]=t;c[k>>2]=17;c[k+4>>2]=13;J=t+0|0;I=2920|0;G=J+13|0;do{a[J>>0]=a[I>>0]|0;J=J+1|0;I=I+1|0}while((J|0)<(G|0));a[t+13>>0]=0;t=Pf(d,n,k)|0;v=c[t>>2]|0;if((v|0)==0){u=0;Na(43,o|0,d|0,k|0);N=u;u=0;if(!(N&1)){p=c[o>>2]|0;c[o>>2]=0;n=c[n>>2]|0;c[p>>2]=0;c[p+4>>2]=0;c[p+8>>2]=n;c[t>>2]=p;n=c[c[d>>2]>>2]|0;if((n|0)==0){n=p}else{c[d>>2]=n;n=c[t>>2]|0}ge(c[b+28>>2]|0,n);q=b+32|0;c[q>>2]=(c[q>>2]|0)+1;q=56}}else{p=v;q=56}if((q|0)==56?(l=p+28|0,N=c[l>>2]|0,m=p+32|0,u=0,oa(c[c[N>>2]>>2]|0,N|0,m|0),N=u,u=0,!(N&1)):0){if((a[2072]|0)==0?(Ua(2072)|0)!=0:0){c[516]=2088;rb(2072)}c[l>>2]=2064;if((a[3440]|0)==0?(Ua(3440)|0)!=0:0){c[858]=3456;rb(3440)}c[l>>2]=3432;u=0;Na(c[(c[858]|0)+4>>2]|0,3432,B|0,m|0);N=u;u=0;if(!(N&1)){if(!((a[k>>0]&1)==0)){Hv(c[s>>2]|0)}a[e>>0]=14;k=e+1|0;a[k+0>>0]=a[7152>>0]|0;a[k+1>>0]=a[7153>>0]|0;a[k+2>>0]=a[7154>>0]|0;a[k+3>>0]=a[7155>>0]|0;a[k+4>>0]=a[7156>>0]|0;a[k+5>>0]=a[7157>>0]|0;a[k+6>>0]=a[7158>>0]|0;k=e+8|0;a[k>>0]=0;l=Pf(d,h,e)|0;m=c[l>>2]|0;do{if((m|0)==0){u=0;Na(43,j|0,d|0,e|0);N=u;u=0;if(N&1){break}m=c[j>>2]|0;c[j>>2]=0;h=c[h>>2]|0;c[m>>2]=0;c[m+4>>2]=0;c[m+8>>2]=h;c[l>>2]=m;h=c[c[d>>2]>>2]|0;if((h|0)==0){h=m}else{c[d>>2]=h;h=c[l>>2]|0}ge(c[b+28>>2]|0,h);q=b+32|0;c[q>>2]=(c[q>>2]|0)+1;q=71}else{q=71}}while(0);do{if((q|0)==71){b=m+28|0;N=c[b>>2]|0;h=m+32|0;u=0;oa(c[c[N>>2]>>2]|0,N|0,h|0);N=u;u=0;if(N&1){break}do{if((a[2072]|0)==0){if((Ua(2072)|0)==0){break}c[516]=2088;rb(2072)}}while(0);c[b>>2]=2064;do{if((a[7336]|0)==0){if((Ua(7336)|0)==0){break}c[1832]=7352;rb(7336)}}while(0);c[b>>2]=7328;u=0;Na(c[(c[1832]|0)+4>>2]|0,7328,f|0,h|0);N=u;u=0;if(N&1){break}if((a[e>>0]&1)==0){i=g;return}Hv(c[k>>2]|0);i=g;return}}while(0);f=qb(-1,-1)|0;if((a[e>>0]&1)==0){N=f;vb(N|0)}Hv(c[k>>2]|0);N=f;vb(N|0)}}e=qb(-1,-1)|0;if((a[k>>0]&1)==0){N=e;vb(N|0)}Hv(c[s>>2]|0);N=e;vb(N|0)}}e=qb(-1,-1)|0;if((a[s>>0]&1)==0){N=e;vb(N|0)}Hv(c[s+8>>2]|0);N=e;vb(N|0)}function Gk(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0;f=i;i=i+16|0;j=f;g=c[d>>2]|0;h=d+4|0;if((Sa(b|0,4,1,c[h>>2]|0)|0)!=1){b=Jb(8)|0;u=0;oa(75,b|0,2592);l=u;u=0;if(l&1){l=qb(-1,-1)|0;pb(b|0);vb(l|0)}else{c[b>>2]=288;qc(b|0,264,1)}}if((Sa(b+4|0,4,1,c[h>>2]|0)|0)!=1){b=Jb(8)|0;u=0;oa(75,b|0,2592);l=u;u=0;if(l&1){l=qb(-1,-1)|0;pb(b|0);vb(l|0)}else{c[b>>2]=288;qc(b|0,264,1)}}if((Sa(b+8|0,4,1,c[h>>2]|0)|0)!=1){b=Jb(8)|0;u=0;oa(75,b|0,2592);l=u;u=0;if(l&1){l=qb(-1,-1)|0;pb(b|0);vb(l|0)}else{c[b>>2]=288;qc(b|0,264,1)}}if((Sa(b+12|0,4,1,c[h>>2]|0)|0)!=1){b=Jb(8)|0;u=0;oa(75,b|0,2592);l=u;u=0;if(l&1){l=qb(-1,-1)|0;pb(b|0);vb(l|0)}else{c[b>>2]=288;qc(b|0,264,1)}}if((Sa(b+16|0,4,1,c[h>>2]|0)|0)!=1){b=Jb(8)|0;u=0;oa(75,b|0,2592);l=u;u=0;if(l&1){l=qb(-1,-1)|0;pb(b|0);vb(l|0)}else{c[b>>2]=288;qc(b|0,264,1)}}a[j>>0]=0;if((Sa(j|0,1,1,c[h>>2]|0)|0)!=1){b=Jb(8)|0;u=0;oa(75,b|0,2592);l=u;u=0;if(l&1){l=qb(-1,-1)|0;pb(b|0);vb(l|0)}else{c[b>>2]=288;qc(b|0,264,1)}}if((a[j>>0]|0)!=0){i=f;return}h=g+144|0;k=c[h>>2]|0;do{if((k|0)<32){j=g+164|0;c[j>>2]=(c[j>>2]|0)+k;j=Av(8192)|0;if((j|0)==0){zb(3048,27,1,c[r>>2]|0)|0;k=0;break}else{k=g+148|0;c[j>>2]=c[k>>2];c[k>>2]=j;c[h>>2]=8188;j=j+4|0;c[g+152>>2]=j;k=8156;e=31;break}}else{j=c[g+152>>2]|0;k=k+ -32|0;e=31}}while(0);if((e|0)==31){c[g+152>>2]=j+32;c[h>>2]=k;k=g+160|0;c[k>>2]=(c[k>>2]|0)+32;k=j}c[k+0>>2]=0;c[k+4>>2]=0;c[k+8>>2]=0;c[k+12>>2]=0;c[k+16>>2]=0;c[k+20>>2]=0;c[k+24>>2]=0;j=b+20|0;c[j>>2]=k;l=c[h>>2]|0;do{if((l|0)<32){k=g+164|0;c[k>>2]=(c[k>>2]|0)+l;k=Av(8192)|0;if((k|0)==0){zb(3048,27,1,c[r>>2]|0)|0;k=0;break}else{l=g+148|0;c[k>>2]=c[l>>2];c[l>>2]=k;c[h>>2]=8188;k=k+4|0;c[g+152>>2]=k;l=8156;e=37;break}}else{k=c[g+152>>2]|0;l=l+ -32|0;e=37}}while(0);if((e|0)==37){c[g+152>>2]=k+32;c[h>>2]=l;l=g+160|0;c[l>>2]=(c[l>>2]|0)+32}c[k+0>>2]=0;c[k+4>>2]=0;c[k+8>>2]=0;c[k+12>>2]=0;c[k+16>>2]=0;c[k+20>>2]=0;c[k+24>>2]=0;l=b+24|0;c[l>>2]=k;Gk(c[j>>2]|0,d);Gk(c[l>>2]|0,d);i=f;return}function Hk(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;e=i;i=i+16|0;d=e;b=b+4|0;if((Sa(a|0,4,1,c[b>>2]|0)|0)!=1){a=Jb(8)|0;u=0;oa(75,a|0,2592);f=u;u=0;if(f&1){f=qb(-1,-1)|0;pb(a|0);vb(f|0)}else{c[a>>2]=288;qc(a|0,264,1)}}if((Sa(a+4|0,4,1,c[b>>2]|0)|0)!=1){a=Jb(8)|0;u=0;oa(75,a|0,2592);f=u;u=0;if(f&1){f=qb(-1,-1)|0;pb(a|0);vb(f|0)}else{c[a>>2]=288;qc(a|0,264,1)}}f=a+8|0;if((Sa(f|0,4,1,c[b>>2]|0)|0)!=1){a=Jb(8)|0;u=0;oa(75,a|0,2592);f=u;u=0;if(f&1){f=qb(-1,-1)|0;pb(a|0);vb(f|0)}else{c[a>>2]=288;qc(a|0,264,1)}}if((Sa(d|0,4,1,c[b>>2]|0)|0)!=1){a=Jb(8)|0;u=0;oa(75,a|0,2592);f=u;u=0;if(f&1){f=qb(-1,-1)|0;pb(a|0);vb(f|0)}else{c[a>>2]=288;qc(a|0,264,1)}}c[a+12>>2]=c[d>>2];f=fa(c[f>>2]|0,c[a>>2]|0)|0;d=Gv(f)|0;c[a+16>>2]=d;if((Sa(d|0,f|0,1,c[b>>2]|0)|0)==1){i=e;return}a=Jb(8)|0;u=0;oa(75,a|0,2592);f=u;u=0;if(f&1){f=qb(-1,-1)|0;pb(a|0);vb(f|0)}else{c[a>>2]=288;qc(a|0,264,1)}}function Ik(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0;d=i;i=i+16|0;g=d;a=a+4|0;if((Sa(g|0,4,1,c[a>>2]|0)|0)!=1){b=Jb(8)|0;u=0;oa(75,b|0,2592);l=u;u=0;if(l&1){l=qb(-1,-1)|0;pb(b|0);vb(l|0)}else{c[b>>2]=288;qc(b|0,264,1)}}g=c[g>>2]|0;j=b+4|0;h=c[j>>2]|0;k=c[b>>2]|0;l=h-k>>2;if(!(l>>>0<g>>>0)){if(l>>>0>g>>>0?(f=k+(g<<2)|0,(h|0)!=(f|0)):0){c[j>>2]=h+(~((h+ -4+(0-f)|0)>>>2)<<2)}}else{eh(b,g-l|0)}if((g|0)==0){i=d;return}else{f=0}while(1){if((Sa((c[b>>2]|0)+(f<<2)|0,4,1,c[a>>2]|0)|0)!=1){break}f=f+1|0;if(!(f>>>0<g>>>0)){e=16;break}}if((e|0)==16){i=d;return}b=Jb(8)|0;u=0;oa(75,b|0,2592);l=u;u=0;if(l&1){l=qb(-1,-1)|0;pb(b|0);vb(l|0)}else{c[b>>2]=288;qc(b|0,264,1)}}function Jk(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0;d=i;i=i+16|0;f=d;if((Sa(f|0,4,1,c[a+4>>2]|0)|0)!=1){b=Jb(8)|0;u=0;oa(75,b|0,2592);k=u;u=0;if(k&1){k=qb(-1,-1)|0;pb(b|0);vb(k|0)}else{c[b>>2]=288;qc(b|0,264,1)}}f=c[f>>2]|0;j=b+4|0;g=c[j>>2]|0;k=c[b>>2]|0;h=g-k>>3;if(!(h>>>0<f>>>0)){if(h>>>0>f>>>0?(e=k+(f<<3)|0,(g|0)!=(e|0)):0){c[j>>2]=g+(~((g+ -8+(0-e)|0)>>>3)<<3)}}else{ok(b,f-h|0)}if((f|0)==0){i=d;return}else{e=0}do{Kk((c[b>>2]|0)+(e<<3)|0,a);e=e+1|0}while(e>>>0<f>>>0);i=d;return}function Kk(a,b){a=a|0;b=b|0;var d=0;d=i;b=b+4|0;if((Sa(a|0,4,1,c[b>>2]|0)|0)!=1){a=Jb(8)|0;u=0;oa(75,a|0,2592);b=u;u=0;if(b&1){b=qb(-1,-1)|0;pb(a|0);vb(b|0)}else{c[a>>2]=288;qc(a|0,264,1)}}if((Sa(a+4|0,4,1,c[b>>2]|0)|0)==1){i=d;return}a=Jb(8)|0;u=0;oa(75,a|0,2592);b=u;u=0;if(b&1){b=qb(-1,-1)|0;pb(a|0);vb(b|0)}else{c[a>>2]=288;qc(a|0,264,1)}}function Lk(a){a=a|0;var b=0,d=0,e=0,f=0,g=0;b=i;c[a>>2]=7072;d=a+124|0;e=c[d>>2]|0;if((e|0)!=0){Iv(e);c[a+108>>2]=0;c[a+112>>2]=0;c[a+116>>2]=0;c[a+120>>2]=-1;c[d>>2]=0}d=c[a+128>>2]|0;do{if((d|0)!=0){if(!((c[d+20>>2]|0)!=0?(u=0,g=u,u=0,g&1):0)){if((c[d+24>>2]|0)==0){break}u=0;g=u;u=0;if(!(g&1)){break}}d=qb(-1,-1)|0;e=a+148|0;f=c[e>>2]|0;if((f|0)!=0){do{g=f;f=c[f>>2]|0;Bv(g);c[e>>2]=f}while((f|0)!=0)}c[e>>2]=0;c[a+144>>2]=0;c[a+160>>2]=0;c[a+164>>2]=0;g=c[a+132>>2]|0;if((g|0)!=0){f=a+136|0;e=c[f>>2]|0;if((e|0)!=(g|0)){c[f>>2]=e+(~((e+ -8+(0-g)|0)>>>3)<<3)}Hv(g)}f=c[a+96>>2]|0;if((f|0)!=0){e=a+100|0;g=c[e>>2]|0;if((g|0)!=(f|0)){c[e>>2]=g+(~((g+ -4+(0-f)|0)>>>2)<<2)}Hv(f)}u=0;na(186,a|0);g=u;u=0;if(g&1){g=qb(-1,-1,0)|0;jd(g)}else{vb(d|0)}}}while(0);d=a+148|0;e=c[d>>2]|0;if((e|0)!=0){do{g=e;e=c[e>>2]|0;Bv(g);c[d>>2]=e}while((e|0)!=0)}c[d>>2]=0;c[a+144>>2]=0;c[a+160>>2]=0;c[a+164>>2]=0;f=c[a+132>>2]|0;if((f|0)!=0){e=a+136|0;d=c[e>>2]|0;if((d|0)!=(f|0)){c[e>>2]=d+(~((d+ -8+(0-f)|0)>>>3)<<3)}Hv(f)}f=c[a+96>>2]|0;if((f|0)==0){Hd(a);i=b;return}e=a+100|0;d=c[e>>2]|0;if((d|0)!=(f|0)){c[e>>2]=d+(~((d+ -4+(0-f)|0)>>>2)<<2)}Hv(f);Hd(a);i=b;return}function Mk(a){a=a|0;var b=0;b=i;Hd(a);i=b;return}function Nk(a){a=a|0;var b=0,c=0;b=i;u=0;na(186,a|0);c=u;u=0;if(c&1){c=qb(-1,-1)|0;Hv(a);vb(c|0)}else{Hv(a);i=b;return}}function Ok(a){a=a|0;return 0}function Pk(a){a=a|0;return 0}function Qk(b,d){b=b|0;d=d|0;var e=0,f=0,g=0;f=i;i=i+16|0;g=f;e=g+4|0;c[e>>2]=d;d=g+8|0;a[d>>0]=0;u=0;oa(120,b|0,g|0);b=u;u=0;if(b&1){b=qb(-1,-1)|0;if((a[d>>0]|0)==0){vb(b|0)}Rb(c[e>>2]|0)|0;vb(b|0)}else{if((a[d>>0]|0)==0){i=f;return}Rb(c[e>>2]|0)|0;i=f;return}}function Rk(b,d){b=b|0;d=d|0;var e=0,f=0,g=0;f=i;i=i+16|0;g=f;e=g+4|0;c[e>>2]=d;d=g+8|0;a[d>>0]=0;c[g>>2]=b;u=0;oa(106,b|0,g|0);b=u;u=0;if(b&1){b=qb(-1,-1)|0;if((a[d>>0]|0)==0){vb(b|0)}Rb(c[e>>2]|0)|0;vb(b|0)}else{if((a[d>>0]|0)==0){i=f;return}Rb(c[e>>2]|0)|0;i=f;return}}function Sk(a){a=a|0;var b=0,d=0;d=i;b=Fv(88)|0;u=0;oa(115,b|0,a|0);a=u;u=0;if(a&1){d=qb(-1,-1)|0;Hv(b);vb(d|0)}else{c[b>>2]=7512;i=d;return b|0}return 0}function Tk(a,b,d){a=a|0;b=b|0;d=+d;var e=0;e=i;if((c[b+4>>2]|0)==(c[a+20>>2]|0)){He(a,b);i=e;return}else{Wa(1208,7648,90,1232)}}function Uk(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0,j=0,k=0,l=0,m=0,n=0.0,o=0,p=0,q=0,r=0.0,s=0.0,t=0.0,u=0.0;h=i;f=b+76|0;m=c[f>>2]|0;j=b+72|0;l=c[j>>2]|0;k=(m|0)==(l|0);if((a[b+36>>0]|0)==0){if(k){i=h;return}k=b+20|0;b=0;do{p=c[l+(b<<2)>>2]|0;q=c[k>>2]|0;l=p+(q<<2)|0;q=q+ -3|0;m=p+(q<<2)|0;if((q|0)>0){o=e;n=0.0;do{u=+g[p>>2]- +g[o>>2];t=+g[p+4>>2]- +g[o+4>>2];s=+g[p+8>>2]- +g[o+8>>2];r=+g[p+12>>2]- +g[o+12>>2];n=n+(u*u+t*t+s*s+r*r);p=p+16|0;o=o+16|0}while(p>>>0<m>>>0);m=p}else{m=p;o=e;n=0.0}if(m>>>0<l>>>0){while(1){u=+g[m>>2]- +g[o>>2];m=m+4|0;n=n+u*u;if(!(m>>>0<l>>>0)){break}else{o=o+4|0}}}Ec[c[(c[d>>2]|0)+12>>2]&7](d,n,b);b=b+1|0;l=c[j>>2]|0}while(b>>>0<(c[f>>2]|0)-l>>2>>>0);i=h;return}if(k){i=h;return}k=b+40|0;b=b+20|0;o=l;l=0;do{if((c[(c[k>>2]|0)+(l>>>5<<2)>>2]&1<<(l&31)|0)==0){q=c[o+(l<<2)>>2]|0;p=c[b>>2]|0;m=q+(p<<2)|0;p=p+ -3|0;o=q+(p<<2)|0;if((p|0)>0){p=e;n=0.0;do{r=+g[q>>2]- +g[p>>2];s=+g[q+4>>2]- +g[p+4>>2];t=+g[q+8>>2]- +g[p+8>>2];u=+g[q+12>>2]- +g[p+12>>2];n=n+(r*r+s*s+t*t+u*u);q=q+16|0;p=p+16|0}while(q>>>0<o>>>0);o=q}else{o=q;p=e;n=0.0}if(o>>>0<m>>>0){while(1){u=+g[o>>2]- +g[p>>2];o=o+4|0;n=n+u*u;if(!(o>>>0<m>>>0)){break}else{p=p+4|0}}}Ec[c[(c[d>>2]|0)+12>>2]&7](d,n,l);m=c[f>>2]|0;o=c[j>>2]|0}l=l+1|0}while(l>>>0<m-o>>2>>>0);i=h;return}function Vk(a){a=a|0;return}function Wk(a){a=a|0;return}function Xk(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;h=i;i=i+32|0;l=h+28|0;m=h+16|0;e=h+4|0;g=h;c[d>>2]=b;Vf(b,d);d=b+24|0;a[e>>0]=18;q=e+1|0;r=320|0;p=q+9|0;do{a[q>>0]=a[r>>0]|0;q=q+1|0;r=r+1|0}while((q|0)<(p|0));a[e+10>>0]=0;p=Pf(d,l,e)|0;q=c[p>>2]|0;if((q|0)==0){u=0;Na(43,m|0,d|0,e|0);r=u;u=0;if(!(r&1)){o=c[m>>2]|0;c[m>>2]=0;l=c[l>>2]|0;c[o>>2]=0;c[o+4>>2]=0;c[o+8>>2]=l;c[p>>2]=o;l=c[c[d>>2]>>2]|0;if((l|0)==0){d=o}else{c[d>>2]=l;d=c[p>>2]|0}ge(c[b+28>>2]|0,d);n=b+32|0;c[n>>2]=(c[n>>2]|0)+1;n=6}}else{o=q;n=6}if(((n|0)==6?(u=0,f=qa(c[(c[b>>2]|0)+16>>2]|0,b|0)|0,r=u,u=0,!(r&1)):0)?(c[g>>2]=f,k=o+28|0,r=c[k>>2]|0,j=o+32|0,u=0,oa(c[c[r>>2]>>2]|0,r|0,j|0),r=u,u=0,!(r&1)):0){if((a[2072]|0)==0?(Ua(2072)|0)!=0:0){c[516]=2088;rb(2072)}c[k>>2]=2064;if((a[2336]|0)==0?(Ua(2336)|0)!=0:0){c[582]=2352;rb(2336)}c[k>>2]=2328;u=0;Na(c[(c[582]|0)+4>>2]|0,2328,g|0,j|0);r=u;u=0;if(!(r&1)){if((a[e>>0]&1)==0){i=h;return}Hv(c[e+8>>2]|0);i=h;return}}f=qb(-1,-1)|0;if((a[e>>0]&1)==0){vb(f|0)}Hv(c[e+8>>2]|0);vb(f|0)}function Yk(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0;f=i;c[b+0>>2]=0;c[b+4>>2]=0;c[b+8>>2]=0;c[b+12>>2]=0;h=b+0|0;g=1816|0;e=h+12|0;do{a[h>>0]=a[g>>0]|0;h=h+1|0;g=g+1|0}while((h|0)<(e|0));h=b+16|0;c[h+0>>2]=0;c[h+4>>2]=0;c[h+8>>2]=0;c[h+12>>2]=0;a[h+0>>0]=a[1832>>0]|0;a[h+1>>0]=a[1833>>0]|0;a[h+2>>0]=a[1834>>0]|0;a[h+3>>0]=a[1835>>0]|0;a[h+4>>0]=a[1836>>0]|0;a[h+5>>0]=a[1837>>0]|0;if((Sa(b|0,52,1,d|0)|0)!=1){b=Jb(8)|0;u=0;oa(75,b|0,7848);d=u;u=0;if(!(d&1)){c[b>>2]=288;qc(b|0,264,1)}d=qb(-1,-1)|0;pb(b|0);vb(d|0)}if((lw(b,1816)|0)==0){i=f;return}b=Jb(8)|0;u=0;oa(75,b|0,2616);d=u;u=0;if(!(d&1)){c[b>>2]=288;qc(b|0,264,1)}d=qb(-1,-1)|0;pb(b|0);vb(d|0)}function Zk(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0;j=i;i=i+96|0;n=j+76|0;z=j+72|0;x=j+68|0;q=j+48|0;o=j+36|0;m=j+24|0;k=j+12|0;p=j+80|0;l=j;c[b>>2]=312;h=b+12|0;g=b+16|0;c[g>>2]=0;c[b+20>>2]=0;y=b+16|0;c[h>>2]=y;A=c[e>>2]|0;w=e+4|0;a:do{if((A|0)!=(w|0)){t=q+12|0;v=q+16|0;r=q+8|0;while(1){c[x>>2]=y;u=0;oa(77,q|0,A+16|0);B=u;u=0;if(B&1){j=21;break}u=0;c[n+0>>2]=c[x+0>>2];Qa(18,z|0,h|0,n|0,q|0);B=u;u=0;if(B&1){j=10;break}B=c[t>>2]|0;u=0;oa(c[c[B>>2]>>2]|0,B|0,v|0);B=u;u=0;if(B&1){j=8;break}if(!((a[q>>0]&1)==0)){Hv(c[r>>2]|0)}B=c[A+4>>2]|0;if((B|0)==0){B=A;while(1){A=c[B+8>>2]|0;if((c[A>>2]|0)==(B|0)){break}else{B=A}}}else{while(1){A=c[B>>2]|0;if((A|0)==0){A=B;break}else{B=A}}}if((A|0)==(w|0)){break a}}do{if((j|0)==8){s=qb(-1,-1)|0;if(!((a[q>>0]&1)==0)){Hv(c[r>>2]|0)}}else if((j|0)==10){j=qb(-1,-1)|0;B=c[t>>2]|0;u=0;oa(c[c[B>>2]>>2]|0,B|0,v|0);B=u;u=0;if(!(B&1)){if((a[q>>0]&1)==0){s=j;break}Hv(c[r>>2]|0);s=j;break}j=qb(-1,-1,0)|0;if((a[q>>0]&1)==0){jd(j)}Hv(c[r>>2]|0);jd(j)}else if((j|0)==21){s=qb(-1,-1)|0}}while(0);Bd(h,c[g>>2]|0);vb(s|0)}}while(0);a[o>>0]=18;s=o+1|0;q=320|0;r=s+9|0;do{a[s>>0]=a[q>>0]|0;s=s+1|0;q=q+1|0}while((s|0)<(r|0));a[o+10>>0]=0;u=0;q=Ha(34,e|0,o|0)|0;B=u;u=0;do{if(B&1){j=qb(-1,-1)|0;if(!((a[o>>0]&1)==0)){Hv(c[o+8>>2]|0)}}else{if(!((a[o>>0]&1)==0)){Hv(c[o+8>>2]|0)}o=b+8|0;a[o>>0]=0;if((q|0)!=254){a[l>>0]=18;s=l+1|0;q=320|0;r=s+9|0;do{a[s>>0]=a[q>>0]|0;s=s+1|0;q=q+1|0}while((s|0)<(r|0));a[l+10>>0]=0;u=0;k=Ha(34,e|0,l|0)|0;B=u;u=0;if(B&1){j=qb(-1,-1)|0;if((a[l>>0]&1)==0){break}Hv(c[l+8>>2]|0);break}if(!((a[l>>0]&1)==0)){Hv(c[l+8>>2]|0)}u=0;k=Ma(7,k|0,d|0,e|0,f|0)|0;B=u;u=0;if(B&1){j=qb(-1,-1)|0;break}c[b+4>>2]=k;i=j;return}a[k>>0]=16;B=k+1|0;A=B;a[A>>0]=1701603686;a[A+1>>0]=6646889;a[A+2>>0]=25964;a[A+3>>0]=101;B=B+4|0;a[B>>0]=1701667182;a[B+1>>0]=6647137;a[B+2>>0]=25965;a[B+3>>0]=101;a[k+9>>0]=0;u=0;Na(46,m|0,e|0,k|0);B=u;u=0;do{if(B&1){j=qb(-1,-1)|0}else{u=0;a[n+0>>0]=a[p+0>>0]|0;l=Ma(6,0,d|0,m|0,n|0)|0;B=u;u=0;if(B&1){j=qb(-1,-1)|0;if((a[m>>0]&1)==0){break}Hv(c[m+8>>2]|0);break}c[b+4>>2]=l;if(!((a[m>>0]&1)==0)){Hv(c[m+8>>2]|0)}if(!((a[k>>0]&1)==0)){Hv(c[k+8>>2]|0)}a[o>>0]=1;i=j;return}}while(0);if(!((a[k>>0]&1)==0)){Hv(c[k+8>>2]|0)}}}while(0);Bd(h,c[g>>2]|0);vb(j|0)}function _k(b){b=b|0;var d=0,e=0;d=i;c[b>>2]=7908;c[b+56>>2]=7928;e=b+4|0;c[e>>2]=8072;if(!((a[b+36>>0]&1)==0)){Hv(c[b+44>>2]|0)}c[e>>2]=13624;u=0;na(184,b+8|0);e=u;u=0;if(!(e&1)){kn(b+56|0);i=d;return}d=qb(-1,-1)|0;u=0;na(108,b+56|0);e=u;u=0;if(e&1){e=qb(-1,-1,0)|0;jd(e)}else{vb(d|0)}}function $k(b){b=b|0;var d=0,e=0,f=0,g=0;e=i;g=c[(c[b>>2]|0)+ -12>>2]|0;c[b+g>>2]=7908;d=b+(g+56)|0;c[d>>2]=7928;f=b+(g+4)|0;c[f>>2]=8072;if(!((a[b+(g+36)>>0]&1)==0)){Hv(c[b+(g+44)>>2]|0)}c[f>>2]=13624;u=0;na(184,b+(g+8)|0);g=u;u=0;if(!(g&1)){kn(d);i=e;return}b=qb(-1,-1)|0;u=0;na(108,d|0);g=u;u=0;if(g&1){g=qb(-1,-1,0)|0;jd(g)}else{vb(b|0)}}function al(b){b=b|0;var d=0,e=0,f=0;d=i;c[b>>2]=7908;c[b+56>>2]=7928;e=b+4|0;c[e>>2]=8072;if(!((a[b+36>>0]&1)==0)){Hv(c[b+44>>2]|0)}c[e>>2]=13624;u=0;na(184,b+8|0);e=u;u=0;if(e&1){e=qb(-1,-1)|0;u=0;na(108,b+56|0);f=u;u=0;if(f&1){f=qb(-1,-1,0)|0;jd(f)}else{f=e;Hv(b);vb(f|0)}}u=0;na(108,b+56|0);f=u;u=0;if(!(f&1)){Hv(b);i=d;return}f=qb(-1,-1)|0;Hv(b);vb(f|0)}function bl(b){b=b|0;var d=0,e=0,f=0,g=0,h=0;f=i;h=c[(c[b>>2]|0)+ -12>>2]|0;e=b+h|0;c[e>>2]=7908;d=b+(h+56)|0;c[d>>2]=7928;g=b+(h+4)|0;c[g>>2]=8072;if(!((a[b+(h+36)>>0]&1)==0)){Hv(c[b+(h+44)>>2]|0)}c[g>>2]=13624;u=0;na(184,b+(h+8)|0);h=u;u=0;if(h&1){b=qb(-1,-1)|0;u=0;na(108,d|0);h=u;u=0;if(h&1){h=qb(-1,-1,0)|0;jd(h)}else{h=b;Hv(e);vb(h|0)}}u=0;na(108,d|0);h=u;u=0;if(!(h&1)){Hv(e);i=f;return}h=qb(-1,-1)|0;Hv(e);vb(h|0)}function cl(b){b=b|0;var d=0;d=i;c[b>>2]=8072;if(!((a[b+32>>0]&1)==0)){Hv(c[b+40>>2]|0)}c[b>>2]=13624;As(b+4|0);i=d;return}function dl(b){b=b|0;var d=0,e=0;d=i;c[b>>2]=8072;if(!((a[b+32>>0]&1)==0)){Hv(c[b+40>>2]|0)}c[b>>2]=13624;u=0;na(184,b+4|0);e=u;u=0;if(e&1){e=qb(-1,-1)|0;Hv(b);vb(e|0)}else{Hv(b);i=d;return}}function el(b,d,e,f,g,h){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,o=0;l=i;o=d+44|0;m=c[o>>2]|0;k=d+24|0;j=c[k>>2]|0;if(m>>>0<j>>>0){c[o>>2]=j;m=j}o=h&24;do{if((o|0)==0){o=b;c[o>>2]=0;c[o+4>>2]=0;o=b+8|0;c[o>>2]=-1;c[o+4>>2]=-1;i=l;return}else if((o|0)!=24){if((g|0)==2){n=11;break}else if((g|0)==0){g=0;o=0;break}else if((g|0)!=1){n=15;break}if((h&8|0)==0){o=j-(c[d+20>>2]|0)|0;g=o;o=((o|0)<0)<<31>>31;break}else{o=(c[d+12>>2]|0)-(c[d+8>>2]|0)|0;g=o;o=((o|0)<0)<<31>>31;break}}else{if((g|0)==2){n=11;break}else if((g|0)==0){g=0;o=0;break}else if((g|0)!=1){n=15;break}o=b;c[o>>2]=0;c[o+4>>2]=0;o=b+8|0;c[o>>2]=-1;c[o+4>>2]=-1;i=l;return}}while(0);if((n|0)==15){o=b;c[o>>2]=0;c[o+4>>2]=0;o=b+8|0;c[o>>2]=-1;c[o+4>>2]=-1;i=l;return}if((n|0)==11){n=d+32|0;if((a[n>>0]&1)==0){n=n+1|0}else{n=c[d+40>>2]|0}o=m-n|0;g=o;o=((o|0)<0)<<31>>31}f=qw(g|0,o|0,e|0,f|0)|0;e=J;if((e|0)>=0){n=d+32|0;if((a[n>>0]&1)==0){n=n+1|0}else{n=c[d+40>>2]|0}o=m-n|0;g=((o|0)<0)<<31>>31;if(!((g|0)<(e|0)|(g|0)==(e|0)&o>>>0<f>>>0)){n=h&8;if(!((f|0)==0&(e|0)==0)){if((n|0)!=0?(c[d+12>>2]|0)==0:0){o=b;c[o>>2]=0;c[o+4>>2]=0;o=b+8|0;c[o>>2]=-1;c[o+4>>2]=-1;i=l;return}if((h&16|0)!=0&(j|0)==0){o=b;c[o>>2]=0;c[o+4>>2]=0;o=b+8|0;c[o>>2]=-1;c[o+4>>2]=-1;i=l;return}}if((n|0)!=0){c[d+12>>2]=(c[d+8>>2]|0)+f;c[d+16>>2]=m}if((h&16|0)!=0){c[k>>2]=(c[d+20>>2]|0)+f}o=b;c[o>>2]=0;c[o+4>>2]=0;o=b+8|0;c[o>>2]=f;c[o+4>>2]=e;i=l;return}}o=b;c[o>>2]=0;c[o+4>>2]=0;o=b+8|0;c[o>>2]=-1;c[o+4>>2]=-1;i=l;return}function fl(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0;f=i;d=d+8|0;Jc[c[(c[b>>2]|0)+16>>2]&31](a,b,c[d>>2]|0,c[d+4>>2]|0,0,e);i=f;return}function gl(a){a=a|0;var b=0,e=0,f=0,g=0;b=i;f=a+44|0;g=c[f>>2]|0;e=c[a+24>>2]|0;if(g>>>0<e>>>0){c[f>>2]=e}else{e=g}if((c[a+48>>2]&8|0)==0){g=-1;i=b;return g|0}f=a+16|0;g=c[f>>2]|0;a=c[a+12>>2]|0;if(g>>>0<e>>>0){c[f>>2]=e}else{e=g}if(!(a>>>0<e>>>0)){g=-1;i=b;return g|0}g=d[a>>0]|0;i=b;return g|0}function hl(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0;e=i;g=b+44|0;f=c[g>>2]|0;j=c[b+24>>2]|0;if(f>>>0<j>>>0){c[g>>2]=j}else{j=f}f=b+8|0;g=c[f>>2]|0;h=b+12|0;l=c[h>>2]|0;if(!(g>>>0<l>>>0)){l=-1;i=e;return l|0}if((d|0)==-1){c[f>>2]=g;c[h>>2]=l+ -1;c[b+16>>2]=j;l=0;i=e;return l|0}if((c[b+48>>2]&16|0)==0){k=d&255;l=l+ -1|0;if(!(k<<24>>24==(a[l>>0]|0))){l=-1;i=e;return l|0}}else{k=d&255;l=l+ -1|0}c[f>>2]=g;c[h>>2]=l;c[b+16>>2]=j;a[l>>0]=k;l=d;i=e;return l|0}function il(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0;j=i;if((d|0)==-1){v=0;i=j;return v|0}g=b+12|0;e=b+8|0;f=(c[g>>2]|0)-(c[e>>2]|0)|0;h=b+24|0;n=c[h>>2]|0;k=b+28|0;l=c[k>>2]|0;a:do{if((n|0)==(l|0)){m=b+48|0;if((c[m>>2]&16|0)==0){v=-1;i=j;return v|0}l=b+20|0;q=c[l>>2]|0;o=n-q|0;p=b+44|0;n=(c[p>>2]|0)-q|0;q=b+32|0;s=a[q>>0]|0;v=(s&1)!=0;if(v){t=(c[q>>2]&-2)+ -1|0;s=c[b+36>>2]|0}else{t=10;s=(s&255)>>>1}if((s|0)==(t|0)){u=0;Da(40,q|0,t|0,1,t|0,t|0,0,0);v=u;u=0;if(!(v&1)){if((a[q>>0]&1)==0){r=12}else{r=13}}}else{if(v){r=13}else{r=12}}if((r|0)==12){a[q>>0]=(s<<1)+2;t=q+1|0;v=s+1|0;r=14}else if((r|0)==13){t=c[b+40>>2]|0;v=s+1|0;c[b+36>>2]=v;r=14}b:do{if((r|0)==14){a[t+s>>0]=0;a[t+v>>0]=0;t=a[q>>0]|0;if((t&1)==0){r=10}else{r=c[q>>2]|0;t=r&255;r=(r&-2)+ -1|0}s=(t&1)==0;if(s){t=(t&255)>>>1}else{t=c[b+36>>2]|0}do{if(t>>>0<r>>>0){u=0;ua(32,q|0,r-t|0,0)|0;v=u;u=0;if(v&1){break b}}else{if(s){a[q+r+1>>0]=0;a[q>>0]=r<<1;break}else{a[(c[b+40>>2]|0)+r>>0]=0;c[b+36>>2]=r;break}}}while(0);r=a[q>>0]|0;if((r&1)==0){q=q+1|0;r=(r&255)>>>1}else{q=c[b+40>>2]|0;r=c[b+36>>2]|0}t=q+r|0;c[l>>2]=q;c[k>>2]=t;v=q+o|0;c[h>>2]=v;o=q+n|0;c[p>>2]=o;k=t;n=v;break a}}while(0);v=qb(-1,-1,0)|0;$a(v|0)|0;Ob();v=-1;i=j;return v|0}else{m=b+48|0;k=l;o=c[b+44>>2]|0}}while(0);l=n+1|0;o=l>>>0<o>>>0?o:l;c[b+44>>2]=o;if((c[m>>2]&8|0)!=0){m=b+32|0;if((a[m>>0]&1)==0){m=m+1|0}else{m=c[b+40>>2]|0}c[e>>2]=m;c[g>>2]=m+f;c[b+16>>2]=o}if((n|0)==(k|0)){v=Sc[c[(c[b>>2]|0)+52>>2]&63](b,d&255)|0;i=j;return v|0}else{c[h>>2]=l;a[n>>0]=d;v=d&255;i=j;return v|0}return 0}function jl(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0;e=i;f=c[d+48>>2]|0;if((f&16|0)!=0){h=d+44|0;g=c[h>>2]|0;f=c[d+24>>2]|0;if(g>>>0<f>>>0){c[h>>2]=f}else{f=g}g=c[d+20>>2]|0;d=g;h=f-d|0;if(h>>>0>4294967279){Mm(0)}if(h>>>0<11){a[b>>0]=h<<1;b=b+1|0}else{k=h+16&-16;j=Fv(k)|0;c[b+8>>2]=j;c[b>>2]=k|1;c[b+4>>2]=h;b=j}if((g|0)!=(f|0)){h=b;while(1){a[h>>0]=a[g>>0]|0;g=g+1|0;if((g|0)==(f|0)){break}else{h=h+1|0}}b=b+(f+(0-d))|0}a[b>>0]=0;i=e;return}if((f&8|0)==0){c[b+0>>2]=0;c[b+4>>2]=0;c[b+8>>2]=0;i=e;return}g=c[d+8>>2]|0;d=c[d+16>>2]|0;f=g;h=d-f|0;if(h>>>0>4294967279){Mm(0)}if(h>>>0<11){a[b>>0]=h<<1;b=b+1|0}else{j=h+16&-16;k=Fv(j)|0;c[b+8>>2]=k;c[b>>2]=j|1;c[b+4>>2]=h;b=k}if((g|0)!=(d|0)){h=b;while(1){a[h>>0]=a[g>>0]|0;g=g+1|0;if((g|0)==(d|0)){break}else{h=h+1|0}}b=b+(d+(0-f))|0}a[b>>0]=0;i=e;return}function kl(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0;e=i;f=b+32|0;Sm(f,d)|0;g=b+44|0;c[g>>2]=0;d=b+48|0;h=c[d>>2]|0;if((h&8|0)!=0){j=a[f>>0]|0;if((j&1)==0){l=f+((j&255)>>>1)+1|0;c[g>>2]=l;k=f+1|0;j=f+1|0}else{l=(c[b+40>>2]|0)+(c[b+36>>2]|0)|0;c[g>>2]=l;j=c[b+40>>2]|0;k=j}c[b+8>>2]=k;c[b+12>>2]=j;c[b+16>>2]=l}if((h&16|0)==0){i=e;return}k=a[f>>0]|0;if((k&1)==0){l=(k&255)>>>1;c[g>>2]=f+l+1;h=10;g=l}else{l=c[b+36>>2]|0;c[g>>2]=(c[b+40>>2]|0)+l;h=c[f>>2]|0;k=h&255;h=(h&-2)+ -1|0;g=l}j=(k&1)==0;if(j){k=(k&255)>>>1}else{k=c[b+36>>2]|0}do{if(!(k>>>0<h>>>0)){if(j){a[f+h+1>>0]=0;a[f>>0]=h<<1;break}else{a[(c[b+40>>2]|0)+h>>0]=0;c[b+36>>2]=h;break}}else{Vm(f,h-k|0,0)|0}}while(0);j=a[f>>0]|0;if((j&1)==0){h=f+1|0;j=(j&255)>>>1;k=f+1|0}else{k=c[b+40>>2]|0;h=k;j=c[b+36>>2]|0}f=b+24|0;c[f>>2]=k;c[b+20>>2]=k;c[b+28>>2]=h+j;if((c[d>>2]&3|0)==0){i=e;return}c[f>>2]=k+g;i=e;return}function ll(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0;j=i;i=i+64|0;l=j+56|0;m=j+44|0;v=j+40|0;t=j+28|0;o=j+16|0;q=j+12|0;f=j;e=b+4|0;c[e>>2]=0;h=b+8|0;c[h>>2]=0;c[b>>2]=b+4;a[o>>0]=18;y=o+1|0;z=320|0;x=y+9|0;do{a[y>>0]=a[z>>0]|0;y=y+1|0;z=z+1|0}while((y|0)<(x|0));a[o+10>>0]=0;x=Pf(b,v,o)|0;y=c[x>>2]|0;if((y|0)==0){u=0;Na(43,t|0,b|0,o|0);z=u;u=0;if(!(z&1)){w=c[t>>2]|0;c[t>>2]=0;s=c[v>>2]|0;c[w>>2]=0;c[w+4>>2]=0;c[w+8>>2]=s;c[x>>2]=w;s=c[c[b>>2]>>2]|0;if((s|0)==0){s=w}else{c[b>>2]=s;s=c[x>>2]|0}ge(c[e>>2]|0,s);c[h>>2]=(c[h>>2]|0)+1;s=6}}else{w=y;s=6}if((s|0)==6?(c[q>>2]=254,r=w+28|0,z=c[r>>2]|0,p=w+32|0,u=0,oa(c[c[z>>2]>>2]|0,z|0,p|0),z=u,u=0,!(z&1)):0){if((a[2072]|0)==0?(Ua(2072)|0)!=0:0){c[516]=2088;rb(2072)}c[r>>2]=2064;if((a[2336]|0)==0?(Ua(2336)|0)!=0:0){c[582]=2352;rb(2336)}c[r>>2]=2328;u=0;Na(c[(c[582]|0)+4>>2]|0,2328,q|0,p|0);z=u;u=0;if(!(z&1)){if(!((a[o>>0]&1)==0)){Hv(c[o+8>>2]|0)}a[f>>0]=16;o=f+1|0;p=o;a[p>>0]=1701603686;a[p+1>>0]=6646889;a[p+2>>0]=25964;a[p+3>>0]=101;o=o+4|0;a[o>>0]=1701667182;a[o+1>>0]=6647137;a[o+2>>0]=25965;a[o+3>>0]=101;a[f+9>>0]=0;o=Pf(b,l,f)|0;p=c[o>>2]|0;if((p|0)==0){u=0;Na(43,m|0,b|0,f|0);z=u;u=0;if(!(z&1)){n=c[m>>2]|0;c[m>>2]=0;l=c[l>>2]|0;c[n>>2]=0;c[n+4>>2]=0;c[n+8>>2]=l;c[o>>2]=n;l=c[c[b>>2]>>2]|0;if((l|0)==0){l=n}else{c[b>>2]=l;l=c[o>>2]|0}ge(c[e>>2]|0,l);c[h>>2]=(c[h>>2]|0)+1;s=21}}else{n=p;s=21}if((s|0)==21?(k=n+28|0,z=c[k>>2]|0,g=n+32|0,u=0,oa(c[c[z>>2]>>2]|0,z|0,g|0),z=u,u=0,!(z&1)):0){if((a[2072]|0)==0?(Ua(2072)|0)!=0:0){c[516]=2088;rb(2072)}c[k>>2]=2064;if((a[8224]|0)==0?(Ua(8224)|0)!=0:0){c[2054]=8240;rb(8224)}c[k>>2]=8216;u=0;Na(c[(c[2054]|0)+4>>2]|0,8216,d|0,g|0);z=u;u=0;if(!(z&1)){if((a[f>>0]&1)==0){i=j;return}Hv(c[f+8>>2]|0);i=j;return}}d=qb(-1,-1)|0;if((a[f>>0]&1)==0){z=d;y=c[e>>2]|0;Bd(b,y);vb(z|0)}Hv(c[f+8>>2]|0);z=d;y=c[e>>2]|0;Bd(b,y);vb(z|0)}}f=qb(-1,-1)|0;if((a[o>>0]&1)==0){z=f;y=c[e>>2]|0;Bd(b,y);vb(z|0)}Hv(c[o+8>>2]|0);z=f;y=c[e>>2]|0;Bd(b,y);vb(z|0)}function ml(b,d){b=b|0;d=d|0;var e=0;b=i;e=c[d>>2]|0;if((e|0)==0){c[d>>2]=0;i=b;return}if(!((a[e>>0]&1)==0)){Hv(c[e+8>>2]|0)}Hv(e);c[d>>2]=0;i=b;return}function nl(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0;b=i;f=Fv(12)|0;if((a[d>>0]&1)==0){c[f+0>>2]=c[d+0>>2];c[f+4>>2]=c[d+4>>2];c[f+8>>2]=c[d+8>>2];c[e>>2]=f;i=b;return}g=c[d+8>>2]|0;d=c[d+4>>2]|0;if(d>>>0>4294967279){u=0;na(183,0);j=u;u=0;if(j&1){j=qb(-1,-1)|0;Hv(f);vb(j|0)}}do{if(!(d>>>0<11)){j=d+16&-16;u=0;h=qa(119,j|0)|0;k=u;u=0;if(k&1){k=qb(-1,-1)|0;Hv(f);vb(k|0)}else{c[f+8>>2]=h;c[f>>2]=j|1;c[f+4>>2]=d;break}}else{a[f>>0]=d<<1;h=f+1|0}}while(0);tw(h|0,g|0,d|0)|0;a[h+d>>0]=0;c[e>>2]=f;i=b;return}function ol(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0;f=i;b=Fv(12)|0;g=c[d>>2]|0;if((a[g>>0]&1)==0){c[b+0>>2]=c[g+0>>2];c[b+4>>2]=c[g+4>>2];c[b+8>>2]=c[g+8>>2];c[e>>2]=b;i=f;return}d=c[g+8>>2]|0;g=c[g+4>>2]|0;if(g>>>0>4294967279){u=0;na(183,0);j=u;u=0;if(j&1){j=qb(-1,-1)|0;Hv(b);vb(j|0)}}do{if(!(g>>>0<11)){j=g+16&-16;u=0;h=qa(119,j|0)|0;k=u;u=0;if(k&1){k=qb(-1,-1)|0;Hv(b);vb(k|0)}else{c[b+8>>2]=h;c[b>>2]=j|1;c[b+4>>2]=g;break}}else{a[b>>0]=g<<1;h=b+1|0}}while(0);tw(h|0,d|0,g|0)|0;a[h+g>>0]=0;c[e>>2]=b;i=f;return}function pl(b,d,e){b=b|0;d=d|0;e=e|0;var f=0;b=i;f=c[e>>2]|0;if(!((a[f>>0]&1)==0)){Hv(c[f+8>>2]|0);f=c[e>>2]|0}Sm(f,c[d>>2]|0)|0;i=b;return}function ql(a,b){a=a|0;b=b|0;return c[b>>2]|0}function rl(a){a=a|0;return 12}function sl(a){a=a|0;return 7816}function tl(a,b,d){a=a|0;b=b|0;d=d|0;a=i;$h(b,c[d>>2]|0)|0;i=a;return}function ul(e,f){e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;g=i;i=i+16|0;h=g+4|0;j=g;u=0;Na(55,h|0,e|0,0);s=u;u=0;a:do{if(!(s&1)){if((a[h>>0]|0)==0){s=c[(c[e>>2]|0)+ -12>>2]|0;u=0;oa(85,e+s|0,c[e+(s+16)>>2]|4|0);s=u;u=0;if(s&1){n=8;break}i=g;return e|0}if((a[f>>0]&1)==0){a[f+1>>0]=0;a[f>>0]=0}else{a[c[f+8>>2]>>0]=0;c[f+4>>2]=0}s=c[(c[e>>2]|0)+ -12>>2]|0;h=c[e+(s+12)>>2]|0;h=(h|0)<1?2147483647:h;u=0;oa(84,j|0,e+s|0);s=u;u=0;if(!(s&1)){u=0;k=Ha(35,j|0,16352)|0;s=u;u=0;if(s&1){l=qb(-1,-1,0)|0;u=0;na(184,j|0);s=u;u=0;if(!(s&1)){h=l;j=e;f=e;break}s=qb(-1,-1,0)|0;jd(s)}u=0;na(184,j|0);s=u;u=0;if(!(s&1)){b:do{if((h|0)>0){m=k+8|0;l=f+4|0;k=f+1|0;j=f+8|0;o=0;while(1){n=c[e+((c[(c[e>>2]|0)+ -12>>2]|0)+24)>>2]|0;p=c[n+12>>2]|0;if((p|0)==(c[n+16>>2]|0)){u=0;n=qa(c[(c[n>>2]|0)+36>>2]|0,n|0)|0;s=u;u=0;if(s&1){break}if((n|0)==-1){f=2;break b}}else{n=d[p>>0]|0}p=n&255;if(p<<24>>24>-1?!((b[(c[m>>2]|0)+(n<<24>>24<<1)>>1]&8192)==0):0){f=0;break b}q=a[f>>0]|0;n=(q&1)!=0;if(n){r=(c[f>>2]&-2)+ -1|0;q=c[l>>2]|0}else{r=10;q=(q&255)>>>1}if((q|0)==(r|0)){u=0;Da(40,f|0,r|0,1,r|0,r|0,0,0);s=u;u=0;if(s&1){break}if((a[f>>0]&1)==0){n=31}else{n=32}}else{if(n){n=32}else{n=31}}if((n|0)==31){a[f>>0]=(q<<1)+2;r=k;s=q+1|0}else if((n|0)==32){r=c[j>>2]|0;s=q+1|0;c[l>>2]=s}a[r+q>>0]=p;a[r+s>>0]=0;n=c[e+((c[(c[e>>2]|0)+ -12>>2]|0)+24)>>2]|0;o=o+1|0;q=n+12|0;p=c[q>>2]|0;if((p|0)==(c[n+16>>2]|0)){u=0;qa(c[(c[n>>2]|0)+40>>2]|0,n|0)|0;s=u;u=0;if(s&1){break}}else{c[q>>2]=p+1}if((o|0)>=(h|0)){f=0;break b}}h=qb(-1,-1,0)|0;f=e;j=e;n=9;break a}else{o=0;f=0}}while(0);c[e+((c[(c[e>>2]|0)+ -12>>2]|0)+12)>>2]=0;s=c[(c[e>>2]|0)+ -12>>2]|0;u=0;oa(85,e+s|0,c[e+(s+16)>>2]|((o|0)==0?f|4:f)|0);s=u;u=0;if(!(s&1)){i=g;return e|0}else{n=8}}else{n=8}}else{n=8}}else{n=8}}while(0);if((n|0)==8){h=qb(-1,-1,0)|0;f=e;j=e;n=9}$a(h|0)|0;u=0;na(191,j+(c[(c[f>>2]|0)+ -12>>2]|0)|0);s=u;u=0;if(!(s&1)){Ob();i=g;return e|0}e=qb(-1,-1)|0;u=0;Oa(2);s=u;u=0;if(s&1){s=qb(-1,-1,0)|0;jd(s)}else{vb(e|0)}return 0}function vl(b){b=b|0;var d=0,e=0;d=i;c[b>>2]=8564;c[b+60>>2]=8584;e=b+8|0;c[e>>2]=8072;if(!((a[b+40>>0]&1)==0)){Hv(c[b+48>>2]|0)}c[e>>2]=13624;u=0;na(184,b+12|0);e=u;u=0;if(!(e&1)){kn(b+60|0);i=d;return}d=qb(-1,-1)|0;u=0;na(108,b+60|0);e=u;u=0;if(e&1){e=qb(-1,-1,0)|0;jd(e)}else{vb(d|0)}}function wl(b){b=b|0;var d=0,e=0,f=0,g=0;e=i;g=c[(c[b>>2]|0)+ -12>>2]|0;c[b+g>>2]=8564;d=b+(g+60)|0;c[d>>2]=8584;f=b+(g+8)|0;c[f>>2]=8072;if(!((a[b+(g+40)>>0]&1)==0)){Hv(c[b+(g+48)>>2]|0)}c[f>>2]=13624;u=0;na(184,b+(g+12)|0);g=u;u=0;if(!(g&1)){kn(d);i=e;return}b=qb(-1,-1)|0;u=0;na(108,d|0);g=u;u=0;if(g&1){g=qb(-1,-1,0)|0;jd(g)}else{vb(b|0)}}function xl(b){b=b|0;var d=0,e=0,f=0;d=i;c[b>>2]=8564;c[b+60>>2]=8584;e=b+8|0;c[e>>2]=8072;if(!((a[b+40>>0]&1)==0)){Hv(c[b+48>>2]|0)}c[e>>2]=13624;u=0;na(184,b+12|0);e=u;u=0;if(e&1){e=qb(-1,-1)|0;u=0;na(108,b+60|0);f=u;u=0;if(f&1){f=qb(-1,-1,0)|0;jd(f)}else{f=e;Hv(b);vb(f|0)}}u=0;na(108,b+60|0);f=u;u=0;if(!(f&1)){Hv(b);i=d;return}f=qb(-1,-1)|0;Hv(b);vb(f|0)}function yl(b){b=b|0;var d=0,e=0,f=0,g=0,h=0;f=i;h=c[(c[b>>2]|0)+ -12>>2]|0;e=b+h|0;c[e>>2]=8564;d=b+(h+60)|0;c[d>>2]=8584;g=b+(h+8)|0;c[g>>2]=8072;if(!((a[b+(h+40)>>0]&1)==0)){Hv(c[b+(h+48)>>2]|0)}c[g>>2]=13624;u=0;na(184,b+(h+12)|0);h=u;u=0;if(h&1){b=qb(-1,-1)|0;u=0;na(108,d|0);h=u;u=0;if(h&1){h=qb(-1,-1,0)|0;jd(h)}else{h=b;Hv(e);vb(h|0)}}u=0;na(108,d|0);h=u;u=0;if(!(h&1)){Hv(e);i=f;return}h=qb(-1,-1)|0;Hv(e);vb(h|0)}function zl(a,b){a=a|0;b=b|0;return}function Al(a,b,d){a=a|0;b=b|0;d=d|0;if((d|0)!=0){c[d>>2]=c[b>>2]}return}function Bl(a,b,d){a=a|0;b=b|0;d=d|0;c[d>>2]=c[b>>2];return}function Cl(a,b,d){a=a|0;b=b|0;d=d|0;c[d>>2]=c[b>>2];return}function Dl(a,b){a=a|0;b=b|0;return b|0}function El(a){a=a|0;return 4}function Fl(a){a=a|0;return 9e3}function Gl(a,b,d){a=a|0;b=b|0;d=d|0;a=i;io(b,c[d>>2]|0)|0;i=a;return}function Hl(b,d,e,f,h){b=b|0;d=+d;e=+e;f=+f;h=+h;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0;l=i;i=i+160|0;n=l+156|0;o=l+144|0;s=l+140|0;t=l+128|0;A=l+124|0;B=l+112|0;H=l+108|0;I=l+96|0;v=l+92|0;P=l+80|0;E=l+76|0;y=l+72|0;r=l+68|0;m=l+64|0;K=l+52|0;L=l+48|0;D=l+36|0;w=l+24|0;q=l+12|0;k=l;g[E>>2]=d;g[y>>2]=e;g[r>>2]=f;g[m>>2]=h;j=b+4|0;c[j>>2]=0;p=b+8|0;c[p>>2]=0;c[b>>2]=b+4;a[K>>0]=18;O=K+1|0;N=320|0;M=O+9|0;do{a[O>>0]=a[N>>0]|0;O=O+1|0;N=N+1|0}while((O|0)<(M|0));a[K+10>>0]=0;M=Pf(b,v,K)|0;N=c[M>>2]|0;if((N|0)==0){u=0;Na(43,P|0,b|0,K|0);O=u;u=0;if(O&1){v=82}else{N=c[P>>2]|0;c[P>>2]=0;v=c[v>>2]|0;c[N>>2]=0;c[N+4>>2]=0;c[N+8>>2]=v;c[M>>2]=N;v=c[c[b>>2]>>2]|0;if((v|0)==0){v=N}else{c[b>>2]=v;v=c[M>>2]|0}ge(c[j>>2]|0,v);c[p>>2]=(c[p>>2]|0)+1;v=6}}else{v=6}a:do{if((v|0)==6){c[L>>2]=255;M=N+28|0;P=c[M>>2]|0;N=N+32|0;u=0;oa(c[c[P>>2]>>2]|0,P|0,N|0);P=u;u=0;if(!(P&1)){if((a[2072]|0)==0?(Ua(2072)|0)!=0:0){c[516]=2088;rb(2072)}c[M>>2]=2064;if((a[2336]|0)==0?(Ua(2336)|0)!=0:0){c[582]=2352;rb(2336)}c[M>>2]=2328;u=0;Na(c[(c[582]|0)+4>>2]|0,2328,L|0,N|0);P=u;u=0;if(!(P&1)){if(!((a[K>>0]&1)==0)){Hv(c[K+8>>2]|0)}u=0;L=qa(119,32)|0;P=u;u=0;b:do{if(!(P&1)){K=D+8|0;c[K>>2]=L;c[D>>2]=33;c[D+4>>2]=16;O=L+0|0;N=4176|0;M=O+16|0;do{a[O>>0]=a[N>>0]|0;O=O+1|0;N=N+1|0}while((O|0)<(M|0));a[L+16>>0]=0;L=Pf(b,H,D)|0;M=c[L>>2]|0;if((M|0)==0){u=0;Na(43,I|0,b|0,D|0);P=u;u=0;if(!(P&1)){J=c[I>>2]|0;c[I>>2]=0;v=c[H>>2]|0;c[J>>2]=0;c[J+4>>2]=0;c[J+8>>2]=v;c[L>>2]=J;v=c[c[b>>2]>>2]|0;if((v|0)==0){v=J}else{c[b>>2]=v;v=c[L>>2]|0}ge(c[j>>2]|0,v);c[p>>2]=(c[p>>2]|0)+1;v=22}}else{J=M;v=22}if((v|0)==22?(G=J+28|0,P=c[G>>2]|0,F=J+32|0,u=0,oa(c[c[P>>2]>>2]|0,P|0,F|0),P=u,u=0,!(P&1)):0){if((a[2072]|0)==0?(Ua(2072)|0)!=0:0){c[516]=2088;rb(2072)}c[G>>2]=2064;if((a[4520]|0)==0?(Ua(4520)|0)!=0:0){c[1128]=4536;rb(4520)}c[G>>2]=4512;u=0;Na(c[(c[1128]|0)+4>>2]|0,4512,E|0,F|0);P=u;u=0;if(!(P&1)){if(!((a[D>>0]&1)==0)){Hv(c[K>>2]|0)}u=0;E=qa(119,16)|0;P=u;u=0;if(P&1){break}D=w+8|0;c[D>>2]=E;c[w>>2]=17;c[w+4>>2]=12;O=E+0|0;N=4200|0;M=O+12|0;do{a[O>>0]=a[N>>0]|0;O=O+1|0;N=N+1|0}while((O|0)<(M|0));a[E+12>>0]=0;E=Pf(b,A,w)|0;F=c[E>>2]|0;if((F|0)==0){u=0;Na(43,B|0,b|0,w|0);P=u;u=0;if(!(P&1)){C=c[B>>2]|0;c[B>>2]=0;v=c[A>>2]|0;c[C>>2]=0;c[C+4>>2]=0;c[C+8>>2]=v;c[E>>2]=C;v=c[c[b>>2]>>2]|0;if((v|0)==0){v=C}else{c[b>>2]=v;v=c[E>>2]|0}ge(c[j>>2]|0,v);c[p>>2]=(c[p>>2]|0)+1;v=38}}else{C=F;v=38}do{if((v|0)==38?(z=C+28|0,P=c[z>>2]|0,x=C+32|0,u=0,oa(c[c[P>>2]>>2]|0,P|0,x|0),P=u,u=0,!(P&1)):0){do{if((a[2072]|0)==0){if((Ua(2072)|0)==0){break}c[516]=2088;rb(2072)}}while(0);c[z>>2]=2064;do{if((a[4520]|0)==0){if((Ua(4520)|0)==0){break}c[1128]=4536;rb(4520)}}while(0);c[z>>2]=4512;u=0;Na(c[(c[1128]|0)+4>>2]|0,4512,y|0,x|0);P=u;u=0;if(P&1){break}if(!((a[w>>0]&1)==0)){Hv(c[D>>2]|0)}u=0;x=qa(119,16)|0;P=u;u=0;if(P&1){break b}w=q+8|0;c[w>>2]=x;c[q>>2]=17;c[q+4>>2]=13;O=x+0|0;N=4216|0;M=O+13|0;do{a[O>>0]=a[N>>0]|0;O=O+1|0;N=N+1|0}while((O|0)<(M|0));a[x+13>>0]=0;x=Pf(b,s,q)|0;y=c[x>>2]|0;do{if((y|0)==0){u=0;Na(43,t|0,b|0,q|0);P=u;u=0;if(P&1){break}v=c[t>>2]|0;c[t>>2]=0;s=c[s>>2]|0;c[v>>2]=0;c[v+4>>2]=0;c[v+8>>2]=s;c[x>>2]=v;s=c[c[b>>2]>>2]|0;if((s|0)==0){s=v}else{c[b>>2]=s;s=c[x>>2]|0}ge(c[j>>2]|0,s);c[p>>2]=(c[p>>2]|0)+1;y=v;v=54}else{v=54}}while(0);do{if((v|0)==54){s=y+28|0;P=c[s>>2]|0;t=y+32|0;u=0;oa(c[c[P>>2]>>2]|0,P|0,t|0);P=u;u=0;if(P&1){break}do{if((a[2072]|0)==0){if((Ua(2072)|0)==0){break}c[516]=2088;rb(2072)}}while(0);c[s>>2]=2064;do{if((a[4520]|0)==0){if((Ua(4520)|0)==0){break}c[1128]=4536;rb(4520)}}while(0);c[s>>2]=4512;u=0;Na(c[(c[1128]|0)+4>>2]|0,4512,r|0,t|0);P=u;u=0;if(P&1){break}if(!((a[q>>0]&1)==0)){Hv(c[w>>2]|0)}u=0;r=qa(119,16)|0;P=u;u=0;if(P&1){break b}q=k+8|0;c[q>>2]=r;c[k>>2]=17;c[k+4>>2]=15;O=r+0|0;N=4232|0;M=O+15|0;do{a[O>>0]=a[N>>0]|0;O=O+1|0;N=N+1|0}while((O|0)<(M|0));a[r+15>>0]=0;r=Pf(b,n,k)|0;s=c[r>>2]|0;do{if((s|0)==0){u=0;Na(43,o|0,b|0,k|0);P=u;u=0;if(P&1){break}s=c[o>>2]|0;c[o>>2]=0;n=c[n>>2]|0;c[s>>2]=0;c[s+4>>2]=0;c[s+8>>2]=n;c[r>>2]=s;n=c[c[b>>2]>>2]|0;if((n|0)==0){n=s}else{c[b>>2]=n;n=c[r>>2]|0}ge(c[j>>2]|0,n);c[p>>2]=(c[p>>2]|0)+1;v=70}else{v=70}}while(0);do{if((v|0)==70){n=s+28|0;P=c[n>>2]|0;o=s+32|0;u=0;oa(c[c[P>>2]>>2]|0,P|0,o|0);P=u;u=0;if(P&1){break}do{if((a[2072]|0)==0){if((Ua(2072)|0)==0){break}c[516]=2088;rb(2072)}}while(0);c[n>>2]=2064;do{if((a[4520]|0)==0){if((Ua(4520)|0)==0){break}c[1128]=4536;rb(4520)}}while(0);c[n>>2]=4512;u=0;Na(c[(c[1128]|0)+4>>2]|0,4512,m|0,o|0);P=u;u=0;if(P&1){break}if((a[k>>0]&1)==0){i=l;return}Hv(c[q>>2]|0);i=l;return}}while(0);l=qb(-1,-1)|0;if((a[k>>0]&1)==0){k=l;break a}Hv(c[q>>2]|0);k=l;break a}}while(0);k=qb(-1,-1)|0;if((a[q>>0]&1)==0){break a}Hv(c[w>>2]|0);break a}}while(0);k=qb(-1,-1)|0;if((a[w>>0]&1)==0){break a}Hv(c[D>>2]|0);break a}}k=qb(-1,-1)|0;if((a[D>>0]&1)==0){break a}Hv(c[K>>2]|0);break a}}while(0);k=qb(-1,-1)|0}else{v=82}}else{v=82}}}while(0);if((v|0)==82){k=qb(-1,-1)|0;if(!((a[K>>0]&1)==0)){Hv(c[K+8>>2]|0)}}Bd(b,c[j>>2]|0);vb(k|0)}function Il(a){a=a|0;var b=0;a=i;b=(c[2252]|0)+ -1|0;c[2252]=b;if((b|0)!=0){i=a;return}u=0;qa(123,9016)|0;b=u;u=0;if(b&1){b=qb(-1,-1,0)|0;jd(b)}else{i=a;return}}function Jl(b){b=b|0;var d=0,e=0,f=0,g=0;b=i;if((a[11544]|0)==0?(Ua(11544)|0)!=0:0){c[2260]=5489;e=5489;d=1;do{e=(fa(e>>>30^e,1812433253)|0)+d|0;c[9040+(d<<2)>>2]=e;d=d+1|0}while((d|0)!=624);c[11536>>2]=0;rb(11544)}g=c[11536>>2]|0;d=((g+1|0)>>>0)%624|0;e=9040+(g<<2)|0;f=c[9040+(d<<2)>>2]|0;c[e>>2]=0-(f&1)&-1727483681^c[9040+((((g+397|0)>>>0)%624|0)<<2)>>2]^(f&2147483646|c[e>>2]&-2147483648)>>>1;e=c[9040+(c[11536>>2]<<2)>>2]|0;e=e>>>11^e;c[11536>>2]=d;e=e<<7&-1658038656^e;e=e<<15&-272236544^e;i=b;return e>>>18^e|0}function Kl(a){a=a|0;a=i;bc(9016)|0;c[2252]=1;i=a;return}function Ll(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0;d=i;i=i+16|0;b=d;e=c[s>>2]|0;fm(12264,e,12320);c[2888]=13756;c[11560>>2]=13776;c[11556>>2]=0;u=0;oa(72,11560|0,12264);h=u;u=0;if(h&1){h=qb(-1,-1)|0;kn(11560|0);vb(h|0)}c[11632>>2]=0;c[11636>>2]=-1;f=c[t>>2]|0;c[3092]=13624;ys(12372|0);c[12376>>2]=0;c[12380>>2]=0;c[12384>>2]=0;c[12388>>2]=0;c[12392>>2]=0;c[12396>>2]=0;c[3092]=12880;c[12400>>2]=f;zs(b,12372|0);u=0;g=Ha(35,b|0,16416)|0;h=u;u=0;if(h&1){h=qb(-1,-1)|0;As(b);c[3092]=13624;As(12372|0);vb(h|0)}As(b);c[12404>>2]=g;c[12408>>2]=12328;h=(Bc[c[(c[g>>2]|0)+28>>2]&255](g)|0)&1;a[12412>>0]=h;c[2910]=13836;c[11644>>2]=13856;u=0;oa(72,11644|0,12368);h=u;u=0;if(h&1){h=qb(-1,-1)|0;kn(11644|0);vb(h|0)}c[11716>>2]=0;c[11720>>2]=-1;g=c[r>>2]|0;c[3104]=13624;ys(12420|0);c[12424>>2]=0;c[12428>>2]=0;c[12432>>2]=0;c[12436>>2]=0;c[12440>>2]=0;c[12444>>2]=0;c[3104]=12880;c[12448>>2]=g;zs(b,12420|0);u=0;h=Ha(35,b|0,16416)|0;j=u;u=0;if(j&1){j=qb(-1,-1)|0;As(b);c[3104]=13624;As(12420|0);vb(j|0)}As(b);c[12452>>2]=h;c[12456>>2]=12336;j=(Bc[c[(c[h>>2]|0)+28>>2]&255](h)|0)&1;a[12460>>0]=j;c[2932]=13836;c[11732>>2]=13856;u=0;oa(72,11732|0,12416);j=u;u=0;if(j&1){j=qb(-1,-1)|0;kn(11732|0);vb(j|0)}c[11804>>2]=0;c[11808>>2]=-1;j=c[(c[(c[2932]|0)+ -12>>2]|0)+11752>>2]|0;c[2954]=13836;c[11820>>2]=13856;u=0;oa(72,11820|0,j|0);j=u;u=0;if(j&1){j=qb(-1,-1)|0;kn(11820|0);vb(j|0)}c[11892>>2]=0;c[11896>>2]=-1;c[(c[(c[2888]|0)+ -12>>2]|0)+11624>>2]=11640;j=(c[(c[2932]|0)+ -12>>2]|0)+11732|0;c[j>>2]=c[j>>2]|8192;c[(c[(c[2932]|0)+ -12>>2]|0)+11800>>2]=11640;Tl(12464,e,12344|0);c[2976]=13796;c[11912>>2]=13816;c[11908>>2]=0;u=0;oa(72,11912|0,12464);j=u;u=0;if(j&1){j=qb(-1,-1)|0;kn(11912|0);vb(j|0)}c[11984>>2]=0;c[11988>>2]=-1;c[3130]=13688;ys(12524|0);c[12528>>2]=0;c[12532>>2]=0;c[12536>>2]=0;c[12540>>2]=0;c[12544>>2]=0;c[12548>>2]=0;c[3130]=12624;c[12552>>2]=f;zs(b,12524|0);u=0;e=Ha(35,b|0,16424)|0;j=u;u=0;if(j&1){j=qb(-1,-1)|0;As(b);c[3130]=13688;As(12524|0);vb(j|0)}As(b);c[12556>>2]=e;c[12560>>2]=12352;j=(Bc[c[(c[e>>2]|0)+28>>2]&255](e)|0)&1;a[12564>>0]=j;c[2998]=13876;c[11996>>2]=13896;u=0;oa(72,11996|0,12520);j=u;u=0;if(j&1){j=qb(-1,-1)|0;kn(11996|0);vb(j|0)}c[12068>>2]=0;c[12072>>2]=-1;c[3142]=13688;ys(12572|0);c[12576>>2]=0;c[12580>>2]=0;c[12584>>2]=0;c[12588>>2]=0;c[12592>>2]=0;c[12596>>2]=0;c[3142]=12624;c[12600>>2]=g;zs(b,12572|0);u=0;e=Ha(35,b|0,16424)|0;j=u;u=0;if(j&1){j=qb(-1,-1)|0;As(b);c[3142]=13688;As(12572|0);vb(j|0)}As(b);c[12604>>2]=e;c[12608>>2]=12360;j=(Bc[c[(c[e>>2]|0)+28>>2]&255](e)|0)&1;a[12612>>0]=j;c[3020]=13876;c[12084>>2]=13896;u=0;oa(72,12084|0,12568);j=u;u=0;if(j&1){j=qb(-1,-1)|0;kn(12084|0);vb(j|0)}c[12156>>2]=0;c[12160>>2]=-1;j=c[(c[(c[3020]|0)+ -12>>2]|0)+12104>>2]|0;c[3042]=13876;c[12172>>2]=13896;u=0;oa(72,12172|0,j|0);j=u;u=0;if(j&1){j=qb(-1,-1)|0;kn(12172|0);vb(j|0)}else{c[12244>>2]=0;c[12248>>2]=-1;c[(c[(c[2976]|0)+ -12>>2]|0)+11976>>2]=11992;j=(c[(c[3020]|0)+ -12>>2]|0)+12084|0;c[j>>2]=c[j>>2]|8192;c[(c[(c[3020]|0)+ -12>>2]|0)+12152>>2]=11992;i=d;return}}function Ml(a){a=a|0;var b=0;a=i;u=0;qa(120,11640)|0;b=u;u=0;if(((!(b&1)?(u=0,qa(120,11816)|0,b=u,u=0,!(b&1)):0)?(u=0,qa(124,11992)|0,b=u,u=0,!(b&1)):0)?(u=0,qa(124,12168)|0,b=u,u=0,!(b&1)):0){i=a;return}b=qb(-1,-1,0)|0;jd(b)}function Nl(a){a=a|0;var b=0;b=i;c[a>>2]=13688;As(a+4|0);i=b;return}function Ol(a){a=a|0;var b=0;b=i;c[a>>2]=13688;As(a+4|0);Hv(a);i=b;return}function Pl(b,d){b=b|0;d=d|0;var e=0;e=i;Bc[c[(c[b>>2]|0)+24>>2]&255](b)|0;d=Bs(d,16424)|0;c[b+36>>2]=d;d=(Bc[c[(c[d>>2]|0)+28>>2]&255](d)|0)&1;a[b+44>>0]=d;i=e;return}function Ql(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0;b=i;i=i+16|0;g=b+8|0;d=b;e=a+36|0;f=a+40|0;h=g+8|0;j=g;a=a+32|0;while(1){k=c[e>>2]|0;k=Tc[c[(c[k>>2]|0)+20>>2]&15](k,c[f>>2]|0,g,h,d)|0;l=(c[d>>2]|0)-j|0;if((zb(g|0,1,l|0,c[a>>2]|0)|0)!=(l|0)){e=-1;d=5;break}if((k|0)==2){e=-1;d=5;break}else if((k|0)!=1){d=4;break}}if((d|0)==4){l=(($b(c[a>>2]|0)|0)!=0)<<31>>31;i=b;return l|0}else if((d|0)==5){i=b;return e|0}return 0}function Rl(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0;f=i;if((a[b+44>>0]|0)!=0){g=zb(d|0,4,e|0,c[b+32>>2]|0)|0;i=f;return g|0}if((e|0)>0){g=0}else{g=0;i=f;return g|0}while(1){if((Sc[c[(c[b>>2]|0)+52>>2]&63](b,c[d>>2]|0)|0)==-1){e=6;break}g=g+1|0;if((g|0)<(e|0)){d=d+4|0}else{e=6;break}}if((e|0)==6){i=f;return g|0}return 0}function Sl(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;e=i;i=i+32|0;k=e+16|0;p=e+8|0;j=e+4|0;h=e;f=(d|0)==-1;a:do{if(!f){c[p>>2]=d;if((a[b+44>>0]|0)!=0){if((zb(p|0,4,1,c[b+32>>2]|0)|0)==1){break}else{d=-1}i=e;return d|0}c[j>>2]=k;l=p+4|0;n=b+36|0;o=b+40|0;g=k+8|0;m=k;b=b+32|0;while(1){q=c[n>>2]|0;q=Nc[c[(c[q>>2]|0)+12>>2]&15](q,c[o>>2]|0,p,l,h,k,g,j)|0;if((c[h>>2]|0)==(p|0)){d=-1;g=12;break}if((q|0)==3){g=7;break}r=(q|0)==1;if(!(q>>>0<2)){d=-1;g=12;break}q=(c[j>>2]|0)-m|0;if((zb(k|0,1,q|0,c[b>>2]|0)|0)!=(q|0)){d=-1;g=12;break}if(r){p=r?c[h>>2]|0:p}else{break a}}if((g|0)==7){if((zb(p|0,1,1,c[b>>2]|0)|0)==1){break}else{d=-1}i=e;return d|0}else if((g|0)==12){i=e;return d|0}}}while(0);r=f?0:d;i=e;return r|0}function Tl(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0;h=i;i=i+16|0;g=h;c[b>>2]=13688;f=b+4|0;ys(f);j=b+8|0;c[j+0>>2]=0;c[j+4>>2]=0;c[j+8>>2]=0;c[j+12>>2]=0;c[j+16>>2]=0;c[j+20>>2]=0;c[b>>2]=12736;c[b+32>>2]=d;c[b+40>>2]=e;c[b+48>>2]=-1;a[b+52>>0]=0;zs(g,f);u=0;e=Ha(35,g|0,16424)|0;d=u;u=0;if(d&1){j=qb(-1,-1)|0;As(g);c[b>>2]=13688;As(f);vb(j|0)}d=b+36|0;c[d>>2]=e;e=Bc[c[(c[e>>2]|0)+24>>2]&255](e)|0;j=b+44|0;c[j>>2]=e;d=c[d>>2]|0;d=(Bc[c[(c[d>>2]|0)+28>>2]&255](d)|0)&1;a[b+53>>0]=d;if((c[j>>2]|0)<=8){As(g);i=h;return}u=0;na(203,12832);j=u;u=0;if(j&1){j=qb(-1,-1)|0;As(g);c[b>>2]=13688;As(f);vb(j|0)}else{As(g);i=h;return}}function Ul(a){a=a|0;var b=0;b=i;c[a>>2]=13688;As(a+4|0);i=b;return}function Vl(a){a=a|0;var b=0;b=i;c[a>>2]=13688;As(a+4|0);Hv(a);i=b;return}function Wl(b,d){b=b|0;d=d|0;var e=0,f=0,g=0;e=i;g=Bs(d,16424)|0;f=b+36|0;c[f>>2]=g;g=Bc[c[(c[g>>2]|0)+24>>2]&255](g)|0;d=b+44|0;c[d>>2]=g;f=c[f>>2]|0;f=(Bc[c[(c[f>>2]|0)+28>>2]&255](f)|0)&1;a[b+53>>0]=f;if((c[d>>2]|0)<=8){i=e;return}Lr(12832);i=e;return}function Xl(a){a=a|0;var b=0;b=i;a=_l(a,0)|0;i=b;return a|0}function Yl(a){a=a|0;var b=0;b=i;a=_l(a,1)|0;i=b;return a|0}function Zl(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0;e=i;i=i+32|0;j=e+16|0;f=e+8|0;l=e+4|0;k=e;g=b+52|0;m=(a[g>>0]|0)!=0;if((d|0)==-1){if(m){m=-1;i=e;return m|0}m=c[b+48>>2]|0;a[g>>0]=(m|0)!=-1&1;i=e;return m|0}h=b+48|0;a:do{if(m){c[l>>2]=c[h>>2];m=c[b+36>>2]|0;k=Nc[c[(c[m>>2]|0)+12>>2]&15](m,c[b+40>>2]|0,l,l+4|0,k,j,j+8|0,f)|0;if((k|0)==3){a[j>>0]=c[h>>2];c[f>>2]=j+1}else if((k|0)==1|(k|0)==2){m=-1;i=e;return m|0}b=b+32|0;while(1){k=c[f>>2]|0;if(!(k>>>0>j>>>0)){break a}m=k+ -1|0;c[f>>2]=m;if((_b(a[m>>0]|0,c[b>>2]|0)|0)==-1){f=-1;break}}i=e;return f|0}}while(0);c[h>>2]=d;a[g>>0]=1;m=d;i=e;return m|0}function _l(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0;e=i;i=i+32|0;g=e+16|0;j=e+8|0;m=e+4|0;l=e;n=b+52|0;if((a[n>>0]|0)!=0){f=b+48|0;g=c[f>>2]|0;if(!d){v=g;i=e;return v|0}c[f>>2]=-1;a[n>>0]=0;v=g;i=e;return v|0}s=c[b+44>>2]|0;s=(s|0)>1?s:1;a:do{if((s|0)>0){p=b+32|0;n=0;while(1){o=mc(c[p>>2]|0)|0;if((o|0)==-1){h=-1;break}a[g+n>>0]=o;n=n+1|0;if((n|0)>=(s|0)){break a}}i=e;return h|0}}while(0);b:do{if((a[b+53>>0]|0)==0){p=b+40|0;q=b+36|0;n=j+4|0;o=b+32|0;while(1){v=c[p>>2]|0;u=v;t=c[u>>2]|0;u=c[u+4>>2]|0;w=c[q>>2]|0;r=g+s|0;v=Nc[c[(c[w>>2]|0)+16>>2]&15](w,v,g,r,m,j,n,l)|0;if((v|0)==2){h=-1;f=22;break}else if((v|0)==3){f=14;break}else if((v|0)!=1){k=s;break b}w=c[p>>2]|0;c[w>>2]=t;c[w+4>>2]=u;if((s|0)==8){h=-1;f=22;break}t=mc(c[o>>2]|0)|0;if((t|0)==-1){h=-1;f=22;break}a[r>>0]=t;s=s+1|0}if((f|0)==14){c[j>>2]=a[g>>0]|0;k=s;break}else if((f|0)==22){i=e;return h|0}}else{c[j>>2]=a[g>>0]|0;k=s}}while(0);if(d){w=c[j>>2]|0;c[b+48>>2]=w;i=e;return w|0}d=b+32|0;while(1){if((k|0)<=0){break}k=k+ -1|0;if((_b(a[g+k>>0]|0,c[d>>2]|0)|0)==-1){h=-1;f=22;break}}if((f|0)==22){i=e;return h|0}w=c[j>>2]|0;i=e;return w|0}function $l(a){a=a|0;var b=0;b=i;c[a>>2]=13624;As(a+4|0);i=b;return}function am(a){a=a|0;var b=0;b=i;c[a>>2]=13624;As(a+4|0);Hv(a);i=b;return}function bm(b,d){b=b|0;d=d|0;var e=0;e=i;Bc[c[(c[b>>2]|0)+24>>2]&255](b)|0;d=Bs(d,16416)|0;c[b+36>>2]=d;d=(Bc[c[(c[d>>2]|0)+28>>2]&255](d)|0)&1;a[b+44>>0]=d;i=e;return}function cm(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0;b=i;i=i+16|0;g=b+8|0;d=b;e=a+36|0;f=a+40|0;h=g+8|0;j=g;a=a+32|0;while(1){k=c[e>>2]|0;k=Tc[c[(c[k>>2]|0)+20>>2]&15](k,c[f>>2]|0,g,h,d)|0;l=(c[d>>2]|0)-j|0;if((zb(g|0,1,l|0,c[a>>2]|0)|0)!=(l|0)){e=-1;d=5;break}if((k|0)==2){e=-1;d=5;break}else if((k|0)!=1){d=4;break}}if((d|0)==4){l=(($b(c[a>>2]|0)|0)!=0)<<31>>31;i=b;return l|0}else if((d|0)==5){i=b;return e|0}return 0}function dm(b,e,f){b=b|0;e=e|0;f=f|0;var g=0,h=0;g=i;if((a[b+44>>0]|0)!=0){h=zb(e|0,1,f|0,c[b+32>>2]|0)|0;i=g;return h|0}if((f|0)>0){h=0}else{h=0;i=g;return h|0}while(1){if((Sc[c[(c[b>>2]|0)+52>>2]&63](b,d[e>>0]|0)|0)==-1){f=6;break}h=h+1|0;if((h|0)<(f|0)){e=e+1|0}else{f=6;break}}if((f|0)==6){i=g;return h|0}return 0}function em(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;e=i;i=i+32|0;k=e+16|0;p=e+8|0;j=e+4|0;h=e;f=(d|0)==-1;a:do{if(!f){a[p>>0]=d;if((a[b+44>>0]|0)!=0){if((zb(p|0,1,1,c[b+32>>2]|0)|0)==1){break}else{d=-1}i=e;return d|0}c[j>>2]=k;l=p+1|0;n=b+36|0;o=b+40|0;g=k+8|0;m=k;b=b+32|0;while(1){q=c[n>>2]|0;q=Nc[c[(c[q>>2]|0)+12>>2]&15](q,c[o>>2]|0,p,l,h,k,g,j)|0;if((c[h>>2]|0)==(p|0)){d=-1;g=12;break}if((q|0)==3){g=7;break}r=(q|0)==1;if(!(q>>>0<2)){d=-1;g=12;break}q=(c[j>>2]|0)-m|0;if((zb(k|0,1,q|0,c[b>>2]|0)|0)!=(q|0)){d=-1;g=12;break}if(r){p=r?c[h>>2]|0:p}else{break a}}if((g|0)==7){if((zb(p|0,1,1,c[b>>2]|0)|0)==1){break}else{d=-1}i=e;return d|0}else if((g|0)==12){i=e;return d|0}}}while(0);r=f?0:d;i=e;return r|0}function fm(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0;h=i;i=i+16|0;g=h;c[b>>2]=13624;f=b+4|0;ys(f);j=b+8|0;c[j+0>>2]=0;c[j+4>>2]=0;c[j+8>>2]=0;c[j+12>>2]=0;c[j+16>>2]=0;c[j+20>>2]=0;c[b>>2]=12992;c[b+32>>2]=d;c[b+40>>2]=e;c[b+48>>2]=-1;a[b+52>>0]=0;zs(g,f);u=0;e=Ha(35,g|0,16416)|0;d=u;u=0;if(d&1){j=qb(-1,-1)|0;As(g);c[b>>2]=13624;As(f);vb(j|0)}d=b+36|0;c[d>>2]=e;e=Bc[c[(c[e>>2]|0)+24>>2]&255](e)|0;j=b+44|0;c[j>>2]=e;d=c[d>>2]|0;d=(Bc[c[(c[d>>2]|0)+28>>2]&255](d)|0)&1;a[b+53>>0]=d;if((c[j>>2]|0)<=8){As(g);i=h;return}u=0;na(203,12832);j=u;u=0;if(j&1){j=qb(-1,-1)|0;As(g);c[b>>2]=13624;As(f);vb(j|0)}else{As(g);i=h;return}}function gm(a){a=a|0;var b=0;b=i;c[a>>2]=13624;As(a+4|0);i=b;return}function hm(a){a=a|0;var b=0;b=i;c[a>>2]=13624;As(a+4|0);Hv(a);i=b;return}function im(b,d){b=b|0;d=d|0;var e=0,f=0,g=0;e=i;g=Bs(d,16416)|0;f=b+36|0;c[f>>2]=g;g=Bc[c[(c[g>>2]|0)+24>>2]&255](g)|0;d=b+44|0;c[d>>2]=g;f=c[f>>2]|0;f=(Bc[c[(c[f>>2]|0)+28>>2]&255](f)|0)&1;a[b+53>>0]=f;if((c[d>>2]|0)<=8){i=e;return}Lr(12832);i=e;return}function jm(a){a=a|0;var b=0;b=i;a=mm(a,0)|0;i=b;return a|0}function km(a){a=a|0;var b=0;b=i;a=mm(a,1)|0;i=b;return a|0}function lm(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0;e=i;i=i+32|0;j=e+16|0;f=e+4|0;l=e+8|0;k=e;g=b+52|0;m=(a[g>>0]|0)!=0;if((d|0)==-1){if(m){m=-1;i=e;return m|0}m=c[b+48>>2]|0;a[g>>0]=(m|0)!=-1&1;i=e;return m|0}h=b+48|0;a:do{if(m){a[l>>0]=c[h>>2];m=c[b+36>>2]|0;k=Nc[c[(c[m>>2]|0)+12>>2]&15](m,c[b+40>>2]|0,l,l+1|0,k,j,j+8|0,f)|0;if((k|0)==3){a[j>>0]=c[h>>2];c[f>>2]=j+1}else if((k|0)==1|(k|0)==2){m=-1;i=e;return m|0}b=b+32|0;while(1){k=c[f>>2]|0;if(!(k>>>0>j>>>0)){break a}m=k+ -1|0;c[f>>2]=m;if((_b(a[m>>0]|0,c[b>>2]|0)|0)==-1){f=-1;break}}i=e;return f|0}}while(0);c[h>>2]=d;a[g>>0]=1;m=d;i=e;return m|0}function mm(b,e){b=b|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0;f=i;i=i+32|0;h=f+16|0;j=f+8|0;n=f+4|0;m=f;o=b+52|0;if((a[o>>0]|0)!=0){g=b+48|0;h=c[g>>2]|0;if(!e){w=h;i=f;return w|0}c[g>>2]=-1;a[o>>0]=0;w=h;i=f;return w|0}p=c[b+44>>2]|0;p=(p|0)>1?p:1;a:do{if((p|0)>0){r=b+32|0;o=0;while(1){q=mc(c[r>>2]|0)|0;if((q|0)==-1){k=-1;break}a[h+o>>0]=q;o=o+1|0;if((o|0)>=(p|0)){break a}}i=f;return k|0}}while(0);b:do{if((a[b+53>>0]|0)==0){r=b+40|0;s=b+36|0;o=j+1|0;q=b+32|0;while(1){w=c[r>>2]|0;v=w;u=c[v>>2]|0;v=c[v+4>>2]|0;x=c[s>>2]|0;t=h+p|0;w=Nc[c[(c[x>>2]|0)+16>>2]&15](x,w,h,t,n,j,o,m)|0;if((w|0)==3){m=14;break}else if((w|0)==2){k=-1;m=23;break}else if((w|0)!=1){l=p;break b}x=c[r>>2]|0;c[x>>2]=u;c[x+4>>2]=v;if((p|0)==8){k=-1;m=23;break}u=mc(c[q>>2]|0)|0;if((u|0)==-1){k=-1;m=23;break}a[t>>0]=u;p=p+1|0}if((m|0)==14){a[j>>0]=a[h>>0]|0;l=p;break}else if((m|0)==23){i=f;return k|0}}else{a[j>>0]=a[h>>0]|0;l=p}}while(0);do{if(!e){e=b+32|0;while(1){if((l|0)<=0){m=21;break}l=l+ -1|0;if((_b(d[h+l>>0]|0,c[e>>2]|0)|0)==-1){k=-1;m=23;break}}if((m|0)==21){g=a[j>>0]|0;break}else if((m|0)==23){i=f;return k|0}}else{g=a[j>>0]|0;c[b+48>>2]=g&255}}while(0);x=g&255;i=f;return x|0}function nm(){var a=0;a=i;Ll(0);jb(204,12256,q|0)|0;i=a;return}function om(a){a=a|0;return}function pm(a){a=a|0;a=a+4|0;c[a>>2]=(c[a>>2]|0)+1;return}function qm(a){a=a|0;var b=0,d=0,e=0;b=i;e=a+4|0;d=c[e>>2]|0;c[e>>2]=d+ -1;if((d|0)!=0){e=0;i=b;return e|0}yc[c[(c[a>>2]|0)+8>>2]&255](a);e=1;i=b;return e|0}function rm(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;d=i;c[a>>2]=13136;e=sw(b|0)|0;u=0;f=qa(121,e+13|0)|0;g=u;u=0;if(g&1){g=qb(-1,-1)|0;ib(a|0);vb(g|0)}else{c[f+4>>2]=e;c[f>>2]=e;g=f+12|0;c[a+4>>2]=g;c[f+8>>2]=0;tw(g|0,b|0,e+1|0)|0;i=d;return}}function sm(a){a=a|0;var b=0,d=0,e=0,f=0;b=i;c[a>>2]=13136;d=a+4|0;f=(c[d>>2]|0)+ -4|0;e=c[f>>2]|0;c[f>>2]=e+ -1;if((e+ -1|0)<0){Iv((c[d>>2]|0)+ -12|0)}ib(a|0);Hv(a);i=b;return}function tm(a){a=a|0;var b=0,d=0,e=0,f=0;b=i;c[a>>2]=13136;d=a+4|0;f=(c[d>>2]|0)+ -4|0;e=c[f>>2]|0;c[f>>2]=e+ -1;if((e+ -1|0)>=0){ib(a|0);i=b;return}Iv((c[d>>2]|0)+ -12|0);ib(a|0);i=b;return}function um(a){a=a|0;return c[a+4>>2]|0}function vm(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0;e=i;c[b>>2]=13160;if((a[d>>0]&1)==0){d=d+1|0}else{d=c[d+8>>2]|0}f=sw(d|0)|0;u=0;g=qa(121,f+13|0)|0;h=u;u=0;if(h&1){h=qb(-1,-1)|0;ib(b|0);vb(h|0)}else{c[g+4>>2]=f;c[g>>2]=f;h=g+12|0;c[b+4>>2]=h;c[g+8>>2]=0;tw(h|0,d|0,f+1|0)|0;i=e;return}}function wm(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;d=i;c[a>>2]=13160;e=sw(b|0)|0;u=0;f=qa(121,e+13|0)|0;g=u;u=0;if(g&1){g=qb(-1,-1)|0;ib(a|0);vb(g|0)}else{c[f+4>>2]=e;c[f>>2]=e;g=f+12|0;c[a+4>>2]=g;c[f+8>>2]=0;tw(g|0,b|0,e+1|0)|0;i=d;return}}function xm(a){a=a|0;var b=0,d=0,e=0,f=0;b=i;c[a>>2]=13160;d=a+4|0;f=(c[d>>2]|0)+ -4|0;e=c[f>>2]|0;c[f>>2]=e+ -1;if((e+ -1|0)<0){Iv((c[d>>2]|0)+ -12|0)}ib(a|0);Hv(a);i=b;return}function ym(a){a=a|0;var b=0,d=0,e=0,f=0;b=i;c[a>>2]=13160;d=a+4|0;f=(c[d>>2]|0)+ -4|0;e=c[f>>2]|0;c[f>>2]=e+ -1;if((e+ -1|0)>=0){ib(a|0);i=b;return}Iv((c[d>>2]|0)+ -12|0);ib(a|0);i=b;return}function zm(a){a=a|0;return c[a+4>>2]|0}function Am(a){a=a|0;var b=0,d=0,e=0,f=0;b=i;c[a>>2]=13136;d=a+4|0;f=(c[d>>2]|0)+ -4|0;e=c[f>>2]|0;c[f>>2]=e+ -1;if((e+ -1|0)<0){Iv((c[d>>2]|0)+ -12|0)}ib(a|0);Hv(a);i=b;return}function Bm(a){a=a|0;var b=0,d=0,e=0,f=0;b=i;c[a>>2]=13136;d=a+4|0;f=(c[d>>2]|0)+ -4|0;e=c[f>>2]|0;c[f>>2]=e+ -1;if((e+ -1|0)<0){Iv((c[d>>2]|0)+ -12|0)}ib(a|0);Hv(a);i=b;return}function Cm(a){a=a|0;return}function Dm(a,b,d){a=a|0;b=b|0;d=d|0;c[a>>2]=d;c[a+4>>2]=b;return}function Em(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e;Yc[c[(c[a>>2]|0)+12>>2]&63](f,a,b);if((c[f+4>>2]|0)!=(c[d+4>>2]|0)){a=0;i=e;return a|0}a=(c[f>>2]|0)==(c[d>>2]|0);i=e;return a|0}function Fm(a,b,d){a=a|0;b=b|0;d=d|0;var e=0;e=i;if((c[b+4>>2]|0)!=(a|0)){a=0;i=e;return a|0}a=(c[b>>2]|0)==(d|0);i=e;return a|0}function Gm(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0;d=i;f=sc(e|0)|0;e=sw(f|0)|0;if(e>>>0>4294967279){Mm(0)}if(e>>>0<11){a[b>>0]=e<<1;b=b+1|0;tw(b|0,f|0,e|0)|0;f=b+e|0;a[f>>0]=0;i=d;return}else{h=e+16&-16;g=Fv(h)|0;c[b+8>>2]=g;c[b>>2]=h|1;c[b+4>>2]=e;b=g;tw(b|0,f|0,e|0)|0;f=b+e|0;a[f>>0]=0;i=d;return}}



function Hm(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0;g=i;i=i+16|0;f=g;h=c[d>>2]|0;do{if((h|0)!=0){j=a[e>>0]|0;if((j&1)==0){j=(j&255)>>>1}else{j=c[e+4>>2]|0}if((j|0)!=0){Ym(e,13376,2)|0;h=c[d>>2]|0}j=c[d+4>>2]|0;Yc[c[(c[j>>2]|0)+24>>2]&63](f,j,h);h=a[f>>0]|0;if((h&1)==0){d=f+1|0;h=(h&255)>>>1}else{d=c[f+8>>2]|0;h=c[f+4>>2]|0}u=0;ua(31,e|0,d|0,h|0)|0;j=u;u=0;if(!(j&1)){if((a[f>>0]&1)==0){break}Hv(c[f+8>>2]|0);break}e=qb(-1,-1)|0;if((a[f>>0]&1)==0){vb(e|0)}Hv(c[f+8>>2]|0);vb(e|0)}}while(0);c[b+0>>2]=c[e+0>>2];c[b+4>>2]=c[e+4>>2];c[b+8>>2]=c[e+8>>2];c[e+0>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;i=g;return}function Im(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0;h=i;i=i+32|0;g=h+12|0;f=h;j=sw(e|0)|0;if(j>>>0>4294967279){Mm(0)}if(j>>>0<11){a[f>>0]=j<<1;k=f+1|0}else{l=j+16&-16;k=Fv(l)|0;c[f+8>>2]=k;c[f>>2]=l|1;c[f+4>>2]=j}tw(k|0,e|0,j|0)|0;a[k+j>>0]=0;u=0;Na(56,g|0,d|0,f|0);l=u;u=0;do{if(l&1){b=qb(-1,-1)|0}else{u=0;oa(78,b|0,g|0);l=u;u=0;if(l&1){b=qb(-1,-1)|0;if((a[g>>0]&1)==0){break}Hv(c[g+8>>2]|0);break}if(!((a[g>>0]&1)==0)){Hv(c[g+8>>2]|0)}if((a[f>>0]&1)==0){c[b>>2]=13392;l=b+8|0;k=d;d=k;d=c[d>>2]|0;k=k+4|0;k=c[k>>2]|0;e=l;c[e>>2]=d;l=l+4|0;c[l>>2]=k;i=h;return}Hv(c[f+8>>2]|0);c[b>>2]=13392;l=b+8|0;k=d;d=k;d=c[d>>2]|0;k=k+4|0;k=c[k>>2]|0;e=l;c[e>>2]=d;l=l+4|0;c[l>>2]=k;i=h;return}}while(0);if((a[f>>0]&1)==0){vb(b|0)}Hv(c[f+8>>2]|0);vb(b|0)}function Jm(a){a=a|0;var b=0;b=i;ym(a);Hv(a);i=b;return}function Km(a){a=a|0;var b=0;b=i;ym(a);i=b;return}function Lm(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;e=i;bc(13528)|0;if((c[a>>2]|0)==1){do{Yb(13552,13528)|0}while((c[a>>2]|0)==1)}if((c[a>>2]|0)!=0){jc(13528)|0;i=e;return}c[a>>2]=1;u=0;qa(123,13528)|0;f=u;u=0;if((((!(f&1)?(u=0,na(d|0,b|0),f=u,u=0,!(f&1)):0)?(u=0,qa(125,13528)|0,f=u,u=0,!(f&1)):0)?(c[a>>2]=-1,u=0,qa(123,13528)|0,f=u,u=0,!(f&1)):0)?(u=0,qa(126,13552)|0,f=u,u=0,!(f&1)):0){i=e;return}f=qb(-1,-1,0)|0;$a(f|0)|0;u=0;qa(125,13528)|0;f=u;u=0;((!(f&1)?(c[a>>2]=0,u=0,qa(123,13528)|0,f=u,u=0,!(f&1)):0)?(u=0,qa(126,13552)|0,f=u,u=0,!(f&1)):0)?(u=0,Oa(3),f=u,u=0,!(f&1)):0;a=qb(-1,-1)|0;u=0;Oa(2);f=u;u=0;if(f&1){f=qb(-1,-1,0)|0;jd(f)}else{vb(a|0)}}function Mm(a){a=a|0;var b=0;a=Jb(8)|0;u=0;oa(121,a|0,13600);b=u;u=0;if(b&1){b=qb(-1,-1)|0;pb(a|0);vb(b|0)}else{c[a>>2]=13216;qc(a|0,13256,86)}}function Nm(a){a=a|0;var b=0;a=Jb(8)|0;u=0;oa(121,a|0,13600);b=u;u=0;if(b&1){b=qb(-1,-1)|0;pb(a|0);vb(b|0)}else{c[a>>2]=13280;qc(a|0,13320,86)}}function Om(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0;e=i;if((a[d>>0]&1)==0){c[b+0>>2]=c[d+0>>2];c[b+4>>2]=c[d+4>>2];c[b+8>>2]=c[d+8>>2];i=e;return}f=c[d+8>>2]|0;d=c[d+4>>2]|0;if(d>>>0>4294967279){Mm(0)}if(d>>>0<11){a[b>>0]=d<<1;b=b+1|0}else{h=d+16&-16;g=Fv(h)|0;c[b+8>>2]=g;c[b>>2]=h|1;c[b+4>>2]=d;b=g}tw(b|0,f|0,d|0)|0;a[b+d>>0]=0;i=e;return}function Pm(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0;f=i;if(e>>>0>4294967279){Mm(0)}if(e>>>0<11){a[b>>0]=e<<1;b=b+1|0}else{h=e+16&-16;g=Fv(h)|0;c[b+8>>2]=g;c[b>>2]=h|1;c[b+4>>2]=e;b=g}tw(b|0,d|0,e|0)|0;a[b+e>>0]=0;i=f;return}function Qm(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0;f=i;if(d>>>0>4294967279){Mm(0)}if(d>>>0<11){a[b>>0]=d<<1;b=b+1|0}else{h=d+16&-16;g=Fv(h)|0;c[b+8>>2]=g;c[b>>2]=h|1;c[b+4>>2]=d;b=g}ww(b|0,e|0,d|0)|0;a[b+d>>0]=0;i=f;return}function Rm(b){b=b|0;var d=0;d=i;if((a[b>>0]&1)==0){i=d;return}Hv(c[b+8>>2]|0);i=d;return}function Sm(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0;e=i;if((b|0)==(d|0)){i=e;return b|0}f=a[d>>0]|0;if((f&1)==0){f=(f&255)>>>1;d=d+1|0}else{f=c[d+4>>2]|0;d=c[d+8>>2]|0}j=a[b>>0]|0;if((j&1)==0){g=10}else{j=c[b>>2]|0;g=(j&-2)+ -1|0;j=j&255}h=(j&1)==0;if(g>>>0<f>>>0){if(h){h=(j&255)>>>1}else{h=c[b+4>>2]|0}Zm(b,g,f-g|0,h,0,h,f,d);i=e;return b|0}if(h){g=b+1|0}else{g=c[b+8>>2]|0}vw(g|0,d|0,f|0)|0;a[g+f>>0]=0;if((a[b>>0]&1)==0){a[b>>0]=f<<1;i=e;return b|0}else{c[b+4>>2]=f;i=e;return b|0}return 0}function Tm(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0;f=i;e=sw(d|0)|0;h=a[b>>0]|0;if((h&1)==0){g=10}else{g=c[b>>2]|0;h=g&255;g=(g&-2)+ -1|0}j=(h&1)==0;if(g>>>0<e>>>0){if(j){h=(h&255)>>>1}else{h=c[b+4>>2]|0}Zm(b,g,e-g|0,h,0,h,e,d);i=f;return b|0}if(j){g=b+1|0}else{g=c[b+8>>2]|0}vw(g|0,d|0,e|0)|0;a[g+e>>0]=0;if((a[b>>0]&1)==0){a[b>>0]=e<<1;i=f;return b|0}else{c[b+4>>2]=e;i=f;return b|0}return 0}function Um(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0;f=i;h=a[b>>0]|0;g=(h&1)==0;if(g){h=(h&255)>>>1}else{h=c[b+4>>2]|0}if(h>>>0<d>>>0){Vm(b,d-h|0,e)|0;i=f;return}if(g){a[b+d+1>>0]=0;a[b>>0]=d<<1;i=f;return}else{a[(c[b+8>>2]|0)+d>>0]=0;c[b+4>>2]=d;i=f;return}}function Vm(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0;f=i;if((d|0)==0){i=f;return b|0}j=a[b>>0]|0;if((j&1)==0){h=10}else{j=c[b>>2]|0;h=(j&-2)+ -1|0;j=j&255}if((j&1)==0){g=(j&255)>>>1}else{g=c[b+4>>2]|0}if((h-g|0)>>>0<d>>>0){_m(b,h,d-h+g|0,g,g,0,0);j=a[b>>0]|0}if((j&1)==0){h=b+1|0}else{h=c[b+8>>2]|0}ww(h+g|0,e|0,d|0)|0;e=g+d|0;if((a[b>>0]&1)==0){a[b>>0]=e<<1}else{c[b+4>>2]=e}a[h+e>>0]=0;i=f;return b|0}function Wm(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0;e=i;if(d>>>0>4294967279){Mm(0)}g=a[b>>0]|0;if((g&1)==0){h=10}else{g=c[b>>2]|0;h=(g&-2)+ -1|0;g=g&255}if((g&1)==0){f=(g&255)>>>1}else{f=c[b+4>>2]|0}d=f>>>0>d>>>0?f:d;if(d>>>0<11){d=10}else{d=(d+16&-16)+ -1|0}if((d|0)==(h|0)){i=e;return}do{if((d|0)!=10){j=d+1|0;if(!(d>>>0>h>>>0)){u=0;k=qa(119,j|0)|0;l=u;u=0;if(l&1){l=qb(-1,-1,0)|0;$a(l|0)|0;Ob();i=e;return}}else{k=Fv(j)|0}if((g&1)==0){l=1;j=b+1|0;h=0;break}else{l=1;j=c[b+8>>2]|0;h=1;break}}else{k=b+1|0;l=0;j=c[b+8>>2]|0;h=1}}while(0);if((g&1)==0){g=(g&255)>>>1}else{g=c[b+4>>2]|0}tw(k|0,j|0,g+1|0)|0;if(h){Hv(j)}if(l){c[b>>2]=d+1|1;c[b+4>>2]=f;c[b+8>>2]=k;i=e;return}else{a[b>>0]=f<<1;i=e;return}}function Xm(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0;e=i;g=a[b>>0]|0;f=(g&1)!=0;if(f){h=(c[b>>2]&-2)+ -1|0;g=c[b+4>>2]|0}else{h=10;g=(g&255)>>>1}if((g|0)==(h|0)){_m(b,h,1,h,h,0,0);if((a[b>>0]&1)==0){f=7}else{f=8}}else{if(f){f=8}else{f=7}}if((f|0)==7){a[b>>0]=(g<<1)+2;f=b+1|0;h=g+1|0;g=f+g|0;a[g>>0]=d;h=f+h|0;a[h>>0]=0;i=e;return}else if((f|0)==8){f=c[b+8>>2]|0;h=g+1|0;c[b+4>>2]=h;g=f+g|0;a[g>>0]=d;h=f+h|0;a[h>>0]=0;i=e;return}}function Ym(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0;f=i;j=a[b>>0]|0;if((j&1)==0){g=10}else{j=c[b>>2]|0;g=(j&-2)+ -1|0;j=j&255}if((j&1)==0){h=(j&255)>>>1}else{h=c[b+4>>2]|0}if((g-h|0)>>>0<e>>>0){Zm(b,g,e-g+h|0,h,h,0,e,d);i=f;return b|0}if((e|0)==0){i=f;return b|0}if((j&1)==0){g=b+1|0}else{g=c[b+8>>2]|0}tw(g+h|0,d|0,e|0)|0;e=h+e|0;if((a[b>>0]&1)==0){a[b>>0]=e<<1}else{c[b+4>>2]=e}a[g+e>>0]=0;i=f;return b|0}function Zm(b,d,e,f,g,h,j,k){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;var l=0,m=0,n=0;l=i;if((-18-d|0)>>>0<e>>>0){Mm(0)}if((a[b>>0]&1)==0){m=b+1|0}else{m=c[b+8>>2]|0}if(d>>>0<2147483623){e=e+d|0;n=d<<1;e=e>>>0<n>>>0?n:e;if(e>>>0<11){e=11}else{e=e+16&-16}}else{e=-17}n=Fv(e)|0;if((g|0)!=0){tw(n|0,m|0,g|0)|0}if((j|0)!=0){tw(n+g|0,k|0,j|0)|0}k=f-h|0;if((k|0)!=(g|0)){tw(n+(j+g)|0,m+(h+g)|0,k-g|0)|0}if((d|0)==10){f=b+8|0;c[f>>2]=n;e=e|1;c[b>>2]=e;e=k+j|0;f=b+4|0;c[f>>2]=e;n=n+e|0;a[n>>0]=0;i=l;return}Hv(m);f=b+8|0;c[f>>2]=n;e=e|1;c[b>>2]=e;e=k+j|0;f=b+4|0;c[f>>2]=e;n=n+e|0;a[n>>0]=0;i=l;return}function _m(b,d,e,f,g,h,j){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0,l=0,m=0;k=i;if((-17-d|0)>>>0<e>>>0){Mm(0)}if((a[b>>0]&1)==0){l=b+1|0}else{l=c[b+8>>2]|0}if(d>>>0<2147483623){e=e+d|0;m=d<<1;e=e>>>0<m>>>0?m:e;if(e>>>0<11){m=11}else{m=e+16&-16}}else{m=-17}e=Fv(m)|0;if((g|0)!=0){tw(e|0,l|0,g|0)|0}f=f-h|0;if((f|0)!=(g|0)){tw(e+(j+g)|0,l+(h+g)|0,f-g|0)|0}if((d|0)==10){f=b+8|0;c[f>>2]=e;m=m|1;c[b>>2]=m;i=k;return}Hv(l);f=b+8|0;c[f>>2]=e;m=m|1;c[b>>2]=m;i=k;return}function $m(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0;f=i;if(e>>>0>1073741807){Mm(0)}if(e>>>0<2){a[b>>0]=e<<1;b=b+4|0}else{h=e+4&-4;g=Fv(h<<2)|0;c[b+8>>2]=g;c[b>>2]=h|1;c[b+4>>2]=e;b=g}Zu(b,d,e)|0;c[b+(e<<2)>>2]=0;i=f;return}function an(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0;f=i;if(d>>>0>1073741807){Mm(0)}if(d>>>0<2){a[b>>0]=d<<1;b=b+4|0}else{h=d+4&-4;g=Fv(h<<2)|0;c[b+8>>2]=g;c[b>>2]=h|1;c[b+4>>2]=d;b=g}$u(b,e,d)|0;c[b+(d<<2)>>2]=0;i=f;return}function bn(b){b=b|0;var d=0;d=i;if((a[b>>0]&1)==0){i=d;return}Hv(c[b+8>>2]|0);i=d;return}function cn(a,b){a=a|0;b=b|0;var c=0;c=i;a=dn(a,b,Yu(b)|0)|0;i=c;return a|0}function dn(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0;f=i;h=a[b>>0]|0;if((h&1)==0){g=1}else{h=c[b>>2]|0;g=(h&-2)+ -1|0;h=h&255}j=(h&1)==0;if(g>>>0<e>>>0){if(j){h=(h&255)>>>1}else{h=c[b+4>>2]|0}gn(b,g,e-g|0,h,0,h,e,d);i=f;return b|0}if(j){g=b+4|0}else{g=c[b+8>>2]|0}_u(g,d,e)|0;c[g+(e<<2)>>2]=0;if((a[b>>0]&1)==0){a[b>>0]=e<<1;i=f;return b|0}else{c[b+4>>2]=e;i=f;return b|0}return 0}function en(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0;e=i;if(d>>>0>1073741807){Mm(0)}g=a[b>>0]|0;if((g&1)==0){h=1}else{g=c[b>>2]|0;h=(g&-2)+ -1|0;g=g&255}if((g&1)==0){f=(g&255)>>>1}else{f=c[b+4>>2]|0}d=f>>>0>d>>>0?f:d;if(d>>>0<2){d=1}else{d=(d+4&-4)+ -1|0}if((d|0)==(h|0)){i=e;return}do{if((d|0)!=1){j=(d<<2)+4|0;if(!(d>>>0>h>>>0)){u=0;k=qa(119,j|0)|0;l=u;u=0;if(l&1){l=qb(-1,-1,0)|0;$a(l|0)|0;Ob();i=e;return}}else{k=Fv(j)|0}if((g&1)==0){l=1;j=b+4|0;h=0;break}else{l=1;j=c[b+8>>2]|0;h=1;break}}else{k=b+4|0;l=0;j=c[b+8>>2]|0;h=1}}while(0);if((g&1)==0){g=(g&255)>>>1}else{g=c[b+4>>2]|0}Zu(k,j,g+1|0)|0;if(h){Hv(j)}if(l){c[b>>2]=d+1|1;c[b+4>>2]=f;c[b+8>>2]=k;i=e;return}else{a[b>>0]=f<<1;i=e;return}}function fn(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0;e=i;g=a[b>>0]|0;f=(g&1)!=0;if(f){h=(c[b>>2]&-2)+ -1|0;g=c[b+4>>2]|0}else{h=1;g=(g&255)>>>1}if((g|0)==(h|0)){hn(b,h,1,h,h,0,0);if((a[b>>0]&1)==0){f=7}else{f=8}}else{if(f){f=8}else{f=7}}if((f|0)==7){a[b>>0]=(g<<1)+2;f=b+4|0;h=g+1|0;g=f+(g<<2)|0;c[g>>2]=d;h=f+(h<<2)|0;c[h>>2]=0;i=e;return}else if((f|0)==8){f=c[b+8>>2]|0;h=g+1|0;c[b+4>>2]=h;g=f+(g<<2)|0;c[g>>2]=d;h=f+(h<<2)|0;c[h>>2]=0;i=e;return}}function gn(b,d,e,f,g,h,j,k){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;var l=0,m=0,n=0;l=i;if((1073741806-d|0)>>>0<e>>>0){Mm(0)}if((a[b>>0]&1)==0){m=b+4|0}else{m=c[b+8>>2]|0}if(d>>>0<536870887){e=e+d|0;n=d<<1;e=e>>>0<n>>>0?n:e;if(e>>>0<2){e=2}else{e=e+4&-4}}else{e=1073741807}n=Fv(e<<2)|0;if((g|0)!=0){Zu(n,m,g)|0}if((j|0)!=0){Zu(n+(g<<2)|0,k,j)|0}k=f-h|0;if((k|0)!=(g|0)){Zu(n+(j+g<<2)|0,m+(h+g<<2)|0,k-g|0)|0}if((d|0)==1){f=b+8|0;c[f>>2]=n;e=e|1;c[b>>2]=e;e=k+j|0;f=b+4|0;c[f>>2]=e;n=n+(e<<2)|0;c[n>>2]=0;i=l;return}Hv(m);f=b+8|0;c[f>>2]=n;e=e|1;c[b>>2]=e;e=k+j|0;f=b+4|0;c[f>>2]=e;n=n+(e<<2)|0;c[n>>2]=0;i=l;return}function hn(b,d,e,f,g,h,j){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0,l=0,m=0;k=i;if((1073741807-d|0)>>>0<e>>>0){Mm(0)}if((a[b>>0]&1)==0){l=b+4|0}else{l=c[b+8>>2]|0}if(d>>>0<536870887){e=e+d|0;m=d<<1;e=e>>>0<m>>>0?m:e;if(e>>>0<2){m=2}else{m=e+4&-4}}else{m=1073741807}e=Fv(m<<2)|0;if((g|0)!=0){Zu(e,l,g)|0}f=f-h|0;if((f|0)!=(g|0)){Zu(e+(j+g<<2)|0,l+(h+g<<2)|0,f-g|0)|0}if((d|0)==1){f=b+8|0;c[f>>2]=e;m=m|1;c[b>>2]=m;i=k;return}Hv(l);f=b+8|0;c[f>>2]=e;m=m|1;c[b>>2]=m;i=k;return}function jn(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0;g=i;i=i+16|0;f=g+8|0;e=g;h=(c[b+24>>2]|0)==0;if(h){c[b+16>>2]=d|1}else{c[b+16>>2]=d}if(((h&1|d)&c[b+20>>2]|0)==0){i=g;return}d=Jb(16)|0;if((a[13968]|0)==0?(Ua(13968)|0)!=0:0){c[3490]=14664;jb(110,13960,q|0)|0;rb(13968)}b=e;c[b>>2]=1;c[b+4>>2]=13960;u=0;c[f+0>>2]=c[e+0>>2];c[f+4>>2]=c[e+4>>2];Na(57,d|0,f|0,14016);b=u;u=0;if(b&1){b=qb(-1,-1)|0;pb(d|0);vb(b|0)}else{c[d>>2]=13984;qc(d|0,14064,106)}}function kn(a){a=a|0;var b=0,d=0,e=0,f=0,g=0;e=i;c[a>>2]=14008;f=c[a+40>>2]|0;b=a+32|0;d=a+36|0;a:do{if((f|0)!=0){while(1){f=f+ -1|0;u=0;Na(c[(c[b>>2]|0)+(f<<2)>>2]|0,0,a|0,c[(c[d>>2]|0)+(f<<2)>>2]|0);g=u;u=0;if(g&1){break}if((f|0)==0){break a}}g=qb(-1,-1,0)|0;jd(g)}}while(0);As(a+28|0);Bv(c[b>>2]|0);Bv(c[d>>2]|0);Bv(c[a+48>>2]|0);Bv(c[a+60>>2]|0);i=e;return}function ln(a,b){a=a|0;b=b|0;var c=0;c=i;zs(a,b+28|0);i=c;return}function mn(a,b){a=a|0;b=b|0;var d=0,e=0;d=i;c[a+24>>2]=b;c[a+16>>2]=(b|0)==0&1;c[a+20>>2]=0;c[a+4>>2]=4098;c[a+12>>2]=0;c[a+8>>2]=6;b=a+28|0;e=a+32|0;a=e+40|0;do{c[e>>2]=0;e=e+4|0}while((e|0)<(a|0));ys(b);i=d;return}function nn(a){a=a|0;var b=0;b=i;c[a>>2]=13624;As(a+4|0);Hv(a);i=b;return}function on(a){a=a|0;var b=0;b=i;c[a>>2]=13624;As(a+4|0);i=b;return}function pn(a,b){a=a|0;b=b|0;return}function qn(a,b,c){a=a|0;b=b|0;c=c|0;return a|0}function rn(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;g=a;c[g>>2]=0;c[g+4>>2]=0;g=a+8|0;c[g>>2]=-1;c[g+4>>2]=-1;return}function sn(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;e=a;c[e>>2]=0;c[e+4>>2]=0;e=a+8|0;c[e>>2]=-1;c[e+4>>2]=-1;return}function tn(a){a=a|0;return 0}function un(a){a=a|0;return 0}function vn(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0;f=i;if((e|0)<=0){k=0;i=f;return k|0}g=b+12|0;h=b+16|0;j=0;while(1){k=c[g>>2]|0;if(k>>>0<(c[h>>2]|0)>>>0){c[g>>2]=k+1;k=a[k>>0]|0}else{k=Bc[c[(c[b>>2]|0)+40>>2]&255](b)|0;if((k|0)==-1){e=8;break}k=k&255}a[d>>0]=k;j=j+1|0;if((j|0)<(e|0)){d=d+1|0}else{e=8;break}}if((e|0)==8){i=f;return j|0}return 0}function wn(a){a=a|0;return-1}function xn(a){a=a|0;var b=0,e=0;b=i;if((Bc[c[(c[a>>2]|0)+36>>2]&255](a)|0)==-1){a=-1;i=b;return a|0}e=a+12|0;a=c[e>>2]|0;c[e>>2]=a+1;a=d[a>>0]|0;i=b;return a|0}function yn(a,b){a=a|0;b=b|0;return-1}function zn(b,e,f){b=b|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0;g=i;if((f|0)<=0){l=0;i=g;return l|0}j=b+24|0;h=b+28|0;k=0;while(1){l=c[j>>2]|0;if(!(l>>>0<(c[h>>2]|0)>>>0)){if((Sc[c[(c[b>>2]|0)+52>>2]&63](b,d[e>>0]|0)|0)==-1){h=7;break}}else{m=a[e>>0]|0;c[j>>2]=l+1;a[l>>0]=m}k=k+1|0;if((k|0)<(f|0)){e=e+1|0}else{h=7;break}}if((h|0)==7){i=g;return k|0}return 0}function An(a,b){a=a|0;b=b|0;return-1}function Bn(a){a=a|0;var b=0;b=i;c[a>>2]=13688;As(a+4|0);Hv(a);i=b;return}function Cn(a){a=a|0;var b=0;b=i;c[a>>2]=13688;As(a+4|0);i=b;return}function Dn(a,b){a=a|0;b=b|0;return}function En(a,b,c){a=a|0;b=b|0;c=c|0;return a|0}function Fn(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;g=a;c[g>>2]=0;c[g+4>>2]=0;g=a+8|0;c[g>>2]=-1;c[g+4>>2]=-1;return}function Gn(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;e=a;c[e>>2]=0;c[e+4>>2]=0;e=a+8|0;c[e>>2]=-1;c[e+4>>2]=-1;return}function Hn(a){a=a|0;return 0}function In(a){a=a|0;return 0}function Jn(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0;e=i;if((d|0)<=0){j=0;i=e;return j|0}g=a+12|0;f=a+16|0;h=0;while(1){j=c[g>>2]|0;if(!(j>>>0<(c[f>>2]|0)>>>0)){j=Bc[c[(c[a>>2]|0)+40>>2]&255](a)|0;if((j|0)==-1){a=8;break}}else{c[g>>2]=j+4;j=c[j>>2]|0}c[b>>2]=j;h=h+1|0;if((h|0)>=(d|0)){a=8;break}b=b+4|0}if((a|0)==8){i=e;return h|0}return 0}function Kn(a){a=a|0;return-1}function Ln(a){a=a|0;var b=0,d=0;b=i;if((Bc[c[(c[a>>2]|0)+36>>2]&255](a)|0)==-1){a=-1;i=b;return a|0}d=a+12|0;a=c[d>>2]|0;c[d>>2]=a+4;a=c[a>>2]|0;i=b;return a|0}function Mn(a,b){a=a|0;b=b|0;return-1}function Nn(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0;e=i;if((d|0)<=0){j=0;i=e;return j|0}g=a+24|0;f=a+28|0;h=0;while(1){j=c[g>>2]|0;if(!(j>>>0<(c[f>>2]|0)>>>0)){if((Sc[c[(c[a>>2]|0)+52>>2]&63](a,c[b>>2]|0)|0)==-1){f=8;break}}else{k=c[b>>2]|0;c[g>>2]=j+4;c[j>>2]=k}h=h+1|0;if((h|0)>=(d|0)){f=8;break}b=b+4|0}if((f|0)==8){i=e;return h|0}return 0}function On(a,b){a=a|0;b=b|0;return-1}function Pn(a){a=a|0;var b=0;b=i;kn(a+8|0);Hv(a);i=b;return}function Qn(a){a=a|0;var b=0;b=i;kn(a+8|0);i=b;return}function Rn(a){a=a|0;var b=0,d=0;b=i;d=c[(c[a>>2]|0)+ -12>>2]|0;kn(a+(d+8)|0);Hv(a+d|0);i=b;return}function Sn(a){a=a|0;var b=0;b=i;kn(a+((c[(c[a>>2]|0)+ -12>>2]|0)+8)|0);i=b;return}function Tn(e,f,g){e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0,n=0,o=0;h=i;i=i+16|0;l=h;a[e>>0]=0;o=c[(c[f>>2]|0)+ -12>>2]|0;n=c[f+(o+16)>>2]|0;if((n|0)!=0){jn(f+o|0,n|4);i=h;return}n=c[f+(o+72)>>2]|0;if((n|0)!=0){Un(n)|0}do{if(!g?(m=c[(c[f>>2]|0)+ -12>>2]|0,(c[f+(m+4)>>2]&4096|0)!=0):0){zs(l,f+(m+28)|0);u=0;m=Ha(35,l|0,16352)|0;o=u;u=0;if(o&1){o=qb(-1,-1)|0;As(l);vb(o|0)}As(l);l=m+8|0;m=c[f+((c[(c[f>>2]|0)+ -12>>2]|0)+24)>>2]|0;while(1){if((m|0)==0){break}if((c[m+12>>2]|0)==(c[m+16>>2]|0)){o=(Bc[c[(c[m>>2]|0)+36>>2]&255](m)|0)==-1;m=o?0:m;if((m|0)==0){break}else{j=m}}else{j=m}g=j+12|0;n=c[g>>2]|0;m=j+16|0;if((n|0)==(c[m>>2]|0)){n=Bc[c[(c[j>>2]|0)+36>>2]&255](j)|0}else{n=d[n>>0]|0}if(!((n&255)<<24>>24>-1)){k=20;break}if((b[(c[l>>2]|0)+(n<<24>>24<<1)>>1]&8192)==0){k=20;break}n=c[g>>2]|0;if((n|0)==(c[m>>2]|0)){Bc[c[(c[j>>2]|0)+40>>2]&255](j)|0;m=j;continue}else{c[g>>2]=n+1;m=j;continue}}if((k|0)==20?(j|0)!=0:0){if((c[j+12>>2]|0)!=(c[j+16>>2]|0)){break}if(!((Bc[c[(c[j>>2]|0)+36>>2]&255](j)|0)==-1|(j|0)==0)){break}}o=c[(c[f>>2]|0)+ -12>>2]|0;jn(f+o|0,c[f+(o+16)>>2]|6)}}while(0);a[e>>0]=(c[f+((c[(c[f>>2]|0)+ -12>>2]|0)+16)>>2]|0)==0&1;i=h;return}function Un(b){b=b|0;var d=0,e=0,f=0,g=0,h=0;d=i;i=i+16|0;e=d;g=c[(c[b>>2]|0)+ -12>>2]|0;if((c[b+(g+24)>>2]|0)==0){i=d;return b|0}a[e>>0]=0;c[e+4>>2]=b;do{if((c[b+(g+16)>>2]|0)==0){h=c[b+(g+72)>>2]|0;do{if((h|0)!=0){u=0;qa(120,h|0)|0;h=u;u=0;if(h&1){g=qb(-1,-1,0)|0;break}else{g=c[(c[b>>2]|0)+ -12>>2]|0;f=6;break}}else{f=6}}while(0);if((f|0)==6){a[e>>0]=1;f=c[b+(g+24)>>2]|0;u=0;f=qa(c[(c[f>>2]|0)+24>>2]|0,f|0)|0;h=u;u=0;if(!(h&1)){if(!((f|0)==-1)){break}h=c[(c[b>>2]|0)+ -12>>2]|0;u=0;oa(85,b+h|0,c[b+(h+16)>>2]|1|0);h=u;u=0;if(!(h&1)){break}}g=qb(-1,-1,0)|0;go(e)}$a(g|0)|0;h=c[(c[b>>2]|0)+ -12>>2]|0;g=b+(h+16)|0;c[g>>2]=c[g>>2]|1;if((c[b+(h+20)>>2]&1|0)==0){Ob();i=d;return b|0}u=0;Oa(3);h=u;u=0;f=qb(-1,-1)|0;u=0;Oa(2);h=u;u=0;if(h&1){h=qb(-1,-1,0)|0;jd(h)}else{vb(f|0)}}}while(0);go(e);i=d;return b|0}function Vn(a){a=a|0;var b=0;b=a+16|0;c[b>>2]=c[b>>2]|1;if((c[a+20>>2]&1|0)==0){return}else{lb()}}function Wn(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;e=i;i=i+48|0;m=e+28|0;l=e+24|0;j=e+20|0;k=e+16|0;p=e+32|0;h=e+12|0;g=e+8|0;o=e+4|0;n=e;u=0;Na(55,p|0,b|0,0);q=u;u=0;do{if(q&1){f=6}else{if((a[p>>0]|0)==0){i=e;return b|0}c[h>>2]=0;zs(o,b+((c[(c[b>>2]|0)+ -12>>2]|0)+28)|0);u=0;p=Ha(35,o|0,14888)|0;q=u;u=0;if(!(q&1)){s=c[(c[b>>2]|0)+ -12>>2]|0;q=b+s|0;r=c[(c[p>>2]|0)+16>>2]|0;c[j>>2]=c[b+(s+24)>>2];c[k>>2]=0;u=0;c[l+0>>2]=c[j+0>>2];c[m+0>>2]=c[k+0>>2];Da(r|0,n|0,p|0,l|0,m|0,q|0,h|0,g|0);q=u;u=0;if(!(q&1)){As(o);c[d>>2]=c[g>>2];s=c[(c[b>>2]|0)+ -12>>2]|0;u=0;oa(85,b+s|0,c[b+(s+16)>>2]|c[h>>2]|0);s=u;u=0;if(s&1){f=6;break}i=e;return b|0}}g=qb(-1,-1,0)|0;As(o);j=b;h=b}}while(0);if((f|0)==6){g=qb(-1,-1,0)|0;j=b;h=b}$a(g|0)|0;s=c[(c[h>>2]|0)+ -12>>2]|0;r=j+(s+16)|0;c[r>>2]=c[r>>2]|1;if((c[j+(s+20)>>2]&1|0)==0){Ob();i=e;return b|0}u=0;Oa(3);s=u;u=0;b=qb(-1,-1)|0;u=0;Oa(2);s=u;u=0;if(s&1){s=qb(-1,-1,0)|0;jd(s)}else{vb(b|0)}return 0}function Xn(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;e=i;i=i+32|0;l=e+24|0;k=e+20|0;h=e+16|0;j=e+12|0;o=e+28|0;g=e+8|0;n=e+4|0;m=e;u=0;Na(55,o|0,b|0,0);p=u;u=0;do{if(p&1){f=6}else{if((a[o>>0]|0)==0){i=e;return b|0}c[g>>2]=0;zs(n,b+((c[(c[b>>2]|0)+ -12>>2]|0)+28)|0);u=0;o=Ha(35,n|0,14888)|0;p=u;u=0;if(!(p&1)){r=c[(c[b>>2]|0)+ -12>>2]|0;p=b+r|0;q=c[(c[o>>2]|0)+40>>2]|0;c[h>>2]=c[b+(r+24)>>2];c[j>>2]=0;u=0;c[k+0>>2]=c[h+0>>2];c[l+0>>2]=c[j+0>>2];Da(q|0,m|0,o|0,k|0,l|0,p|0,g|0,d|0);p=u;u=0;if(!(p&1)){As(n);r=c[(c[b>>2]|0)+ -12>>2]|0;u=0;oa(85,b+r|0,c[b+(r+16)>>2]|c[g>>2]|0);r=u;u=0;if(r&1){f=6;break}i=e;return b|0}}g=qb(-1,-1,0)|0;As(n);j=b;h=b}}while(0);if((f|0)==6){g=qb(-1,-1,0)|0;j=b;h=b}$a(g|0)|0;r=c[(c[h>>2]|0)+ -12>>2]|0;q=j+(r+16)|0;c[q>>2]=c[q>>2]|1;if((c[j+(r+20)>>2]&1|0)==0){Ob();i=e;return b|0}u=0;Oa(3);r=u;u=0;b=qb(-1,-1)|0;u=0;Oa(2);r=u;u=0;if(r&1){r=qb(-1,-1,0)|0;jd(r)}else{vb(b|0)}return 0}function Yn(a){a=a|0;var b=0;b=i;kn(a+8|0);Hv(a);i=b;return}function Zn(a){a=a|0;var b=0;b=i;kn(a+8|0);i=b;return}function _n(a){a=a|0;var b=0,d=0;b=i;d=c[(c[a>>2]|0)+ -12>>2]|0;kn(a+(d+8)|0);Hv(a+d|0);i=b;return}function $n(a){a=a|0;var b=0;b=i;kn(a+((c[(c[a>>2]|0)+ -12>>2]|0)+8)|0);i=b;return}function ao(b){b=b|0;var d=0,e=0,f=0,g=0,h=0;d=i;i=i+16|0;e=d;g=c[(c[b>>2]|0)+ -12>>2]|0;if((c[b+(g+24)>>2]|0)==0){i=d;return b|0}a[e>>0]=0;c[e+4>>2]=b;do{if((c[b+(g+16)>>2]|0)==0){h=c[b+(g+72)>>2]|0;do{if((h|0)!=0){u=0;qa(124,h|0)|0;h=u;u=0;if(h&1){g=qb(-1,-1,0)|0;break}else{g=c[(c[b>>2]|0)+ -12>>2]|0;f=6;break}}else{f=6}}while(0);if((f|0)==6){a[e>>0]=1;f=c[b+(g+24)>>2]|0;u=0;f=qa(c[(c[f>>2]|0)+24>>2]|0,f|0)|0;h=u;u=0;if(!(h&1)){if(!((f|0)==-1)){break}h=c[(c[b>>2]|0)+ -12>>2]|0;u=0;oa(85,b+h|0,c[b+(h+16)>>2]|1|0);h=u;u=0;if(!(h&1)){break}}g=qb(-1,-1,0)|0;qo(e)}$a(g|0)|0;h=c[(c[b>>2]|0)+ -12>>2]|0;g=b+(h+16)|0;c[g>>2]=c[g>>2]|1;if((c[b+(h+20)>>2]&1|0)==0){Ob();i=d;return b|0}u=0;Oa(3);h=u;u=0;f=qb(-1,-1)|0;u=0;Oa(2);h=u;u=0;if(h&1){h=qb(-1,-1,0)|0;jd(h)}else{vb(f|0)}}}while(0);qo(e);i=d;return b|0}function bo(a){a=a|0;var b=0;b=i;kn(a+4|0);Hv(a);i=b;return}function co(a){a=a|0;var b=0;b=i;kn(a+4|0);i=b;return}function eo(a){a=a|0;var b=0,d=0;b=i;d=c[(c[a>>2]|0)+ -12>>2]|0;kn(a+(d+4)|0);Hv(a+d|0);i=b;return}function fo(a){a=a|0;var b=0;b=i;kn(a+((c[(c[a>>2]|0)+ -12>>2]|0)+4)|0);i=b;return}function go(a){a=a|0;var b=0,d=0,e=0;b=i;a=a+4|0;d=c[a>>2]|0;e=c[(c[d>>2]|0)+ -12>>2]|0;if((c[d+(e+24)>>2]|0)==0){i=b;return}if((c[d+(e+16)>>2]|0)!=0){i=b;return}if((c[d+(e+4)>>2]&8192|0)==0){i=b;return}if(Xa()|0){i=b;return}d=c[a>>2]|0;d=c[d+((c[(c[d>>2]|0)+ -12>>2]|0)+24)>>2]|0;u=0;d=qa(c[(c[d>>2]|0)+24>>2]|0,d|0)|0;e=u;u=0;if(!(e&1)){if(!((d|0)==-1)){i=b;return}d=c[a>>2]|0;e=c[(c[d>>2]|0)+ -12>>2]|0;u=0;oa(85,d+e|0,c[d+(e+16)>>2]|1|0);e=u;u=0;if(!(e&1)){i=b;return}}e=qb(-1,-1,0)|0;$a(e|0)|0;u=0;Oa(2);e=u;u=0;if(e&1){e=qb(-1,-1,0)|0;jd(e)}else{i=b;return}}function ho(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;e=i;i=i+32|0;k=e+20|0;j=e+16|0;f=e+8|0;n=e+4|0;h=e;a[f>>0]=0;c[f+4>>2]=b;m=c[(c[b>>2]|0)+ -12>>2]|0;do{if((c[b+(m+16)>>2]|0)==0){o=c[b+(m+72)>>2]|0;do{if((o|0)!=0){u=0;qa(120,o|0)|0;r=u;u=0;if(r&1){d=qb(-1,-1,0)|0;break}else{m=c[(c[b>>2]|0)+ -12>>2]|0;g=5;break}}else{g=5}}while(0);if((g|0)==5){a[f>>0]=1;zs(n,b+(m+28)|0);u=0;m=Ha(35,n|0,15072)|0;r=u;u=0;if(r&1){d=qb(-1,-1,0)|0;As(n)}else{As(n);r=c[(c[b>>2]|0)+ -12>>2]|0;n=c[b+(r+24)>>2]|0;o=b+r|0;p=b+(r+76)|0;q=c[p>>2]|0;do{if((q|0)==-1){zs(k,b+(r+28)|0);u=0;q=Ha(35,k|0,16352)|0;r=u;u=0;if(!(r&1)?(u=0,l=Ha(c[(c[q>>2]|0)+28>>2]|0,q|0,32)|0,r=u,u=0,!(r&1)):0){As(k);q=l<<24>>24;c[p>>2]=q;g=11;break}d=qb(-1,-1,0)|0;As(k)}else{g=11}}while(0);if((g|0)==11){r=q&255;q=c[(c[m>>2]|0)+12>>2]|0;c[j>>2]=n;u=0;c[k+0>>2]=c[j+0>>2];ya(q|0,h|0,m|0,k|0,o|0,r|0,d|0);r=u;u=0;if(!(r&1)){if((c[h>>2]|0)!=0){break}r=c[(c[b>>2]|0)+ -12>>2]|0;u=0;oa(85,b+r|0,c[b+(r+16)>>2]|5|0);r=u;u=0;if(!(r&1)){break}}d=qb(-1,-1,0)|0}}go(f)}$a(d|0)|0;r=c[(c[b>>2]|0)+ -12>>2]|0;q=b+(r+16)|0;c[q>>2]=c[q>>2]|1;if((c[b+(r+20)>>2]&1|0)==0){Ob();i=e;return b|0}u=0;Oa(3);r=u;u=0;g=qb(-1,-1)|0;u=0;Oa(2);r=u;u=0;if(r&1){r=qb(-1,-1,0)|0;jd(r)}else{vb(g|0)}}}while(0);go(f);i=e;return b|0}function io(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;e=i;i=i+32|0;k=e+20|0;j=e+16|0;f=e+8|0;n=e+4|0;h=e;a[f>>0]=0;c[f+4>>2]=b;m=c[(c[b>>2]|0)+ -12>>2]|0;do{if((c[b+(m+16)>>2]|0)==0){o=c[b+(m+72)>>2]|0;do{if((o|0)!=0){u=0;qa(120,o|0)|0;r=u;u=0;if(r&1){d=qb(-1,-1,0)|0;break}else{m=c[(c[b>>2]|0)+ -12>>2]|0;g=5;break}}else{g=5}}while(0);if((g|0)==5){a[f>>0]=1;zs(n,b+(m+28)|0);u=0;m=Ha(35,n|0,15072)|0;r=u;u=0;if(r&1){d=qb(-1,-1,0)|0;As(n)}else{As(n);r=c[(c[b>>2]|0)+ -12>>2]|0;n=c[b+(r+24)>>2]|0;o=b+r|0;p=b+(r+76)|0;q=c[p>>2]|0;do{if((q|0)==-1){zs(k,b+(r+28)|0);u=0;q=Ha(35,k|0,16352)|0;r=u;u=0;if(!(r&1)?(u=0,l=Ha(c[(c[q>>2]|0)+28>>2]|0,q|0,32)|0,r=u,u=0,!(r&1)):0){As(k);q=l<<24>>24;c[p>>2]=q;g=11;break}d=qb(-1,-1,0)|0;As(k)}else{g=11}}while(0);if((g|0)==11){r=q&255;q=c[(c[m>>2]|0)+16>>2]|0;c[j>>2]=n;u=0;c[k+0>>2]=c[j+0>>2];ya(q|0,h|0,m|0,k|0,o|0,r|0,d|0);r=u;u=0;if(!(r&1)){if((c[h>>2]|0)!=0){break}r=c[(c[b>>2]|0)+ -12>>2]|0;u=0;oa(85,b+r|0,c[b+(r+16)>>2]|5|0);r=u;u=0;if(!(r&1)){break}}d=qb(-1,-1,0)|0}}go(f)}$a(d|0)|0;r=c[(c[b>>2]|0)+ -12>>2]|0;q=b+(r+16)|0;c[q>>2]=c[q>>2]|1;if((c[b+(r+20)>>2]&1|0)==0){Ob();i=e;return b|0}u=0;Oa(3);r=u;u=0;g=qb(-1,-1)|0;u=0;Oa(2);r=u;u=0;if(r&1){r=qb(-1,-1,0)|0;jd(r)}else{vb(g|0)}}}while(0);go(f);i=e;return b|0}function jo(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;e=i;i=i+32|0;k=e+20|0;j=e+16|0;f=e+8|0;n=e+4|0;h=e;a[f>>0]=0;c[f+4>>2]=b;m=c[(c[b>>2]|0)+ -12>>2]|0;do{if((c[b+(m+16)>>2]|0)==0){o=c[b+(m+72)>>2]|0;do{if((o|0)!=0){u=0;qa(120,o|0)|0;r=u;u=0;if(r&1){d=qb(-1,-1,0)|0;break}else{m=c[(c[b>>2]|0)+ -12>>2]|0;g=5;break}}else{g=5}}while(0);if((g|0)==5){a[f>>0]=1;zs(n,b+(m+28)|0);u=0;m=Ha(35,n|0,15072)|0;r=u;u=0;if(r&1){d=qb(-1,-1,0)|0;As(n)}else{As(n);r=c[(c[b>>2]|0)+ -12>>2]|0;n=c[b+(r+24)>>2]|0;o=b+r|0;p=b+(r+76)|0;q=c[p>>2]|0;do{if((q|0)==-1){zs(k,b+(r+28)|0);u=0;q=Ha(35,k|0,16352)|0;r=u;u=0;if(!(r&1)?(u=0,l=Ha(c[(c[q>>2]|0)+28>>2]|0,q|0,32)|0,r=u,u=0,!(r&1)):0){As(k);q=l<<24>>24;c[p>>2]=q;g=11;break}d=qb(-1,-1,0)|0;As(k)}else{g=11}}while(0);if((g|0)==11){r=q&255;q=c[(c[m>>2]|0)+24>>2]|0;c[j>>2]=n;u=0;c[k+0>>2]=c[j+0>>2];ya(q|0,h|0,m|0,k|0,o|0,r|0,d|0);r=u;u=0;if(!(r&1)){if((c[h>>2]|0)!=0){break}r=c[(c[b>>2]|0)+ -12>>2]|0;u=0;oa(85,b+r|0,c[b+(r+16)>>2]|5|0);r=u;u=0;if(!(r&1)){break}}d=qb(-1,-1,0)|0}}go(f)}$a(d|0)|0;r=c[(c[b>>2]|0)+ -12>>2]|0;q=b+(r+16)|0;c[q>>2]=c[q>>2]|1;if((c[b+(r+20)>>2]&1|0)==0){Ob();i=e;return b|0}u=0;Oa(3);r=u;u=0;g=qb(-1,-1)|0;u=0;Oa(2);r=u;u=0;if(r&1){r=qb(-1,-1,0)|0;jd(r)}else{vb(g|0)}}}while(0);go(f);i=e;return b|0}function ko(b,d){b=b|0;d=+d;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;e=i;i=i+32|0;k=e+20|0;j=e+16|0;f=e+8|0;n=e+4|0;h=e;a[f>>0]=0;c[f+4>>2]=b;m=c[(c[b>>2]|0)+ -12>>2]|0;do{if((c[b+(m+16)>>2]|0)==0){o=c[b+(m+72)>>2]|0;do{if((o|0)!=0){u=0;qa(120,o|0)|0;r=u;u=0;if(r&1){h=qb(-1,-1,0)|0;break}else{m=c[(c[b>>2]|0)+ -12>>2]|0;g=5;break}}else{g=5}}while(0);if((g|0)==5){a[f>>0]=1;zs(n,b+(m+28)|0);u=0;m=Ha(35,n|0,15072)|0;r=u;u=0;if(r&1){h=qb(-1,-1,0)|0;As(n)}else{As(n);r=c[(c[b>>2]|0)+ -12>>2]|0;n=c[b+(r+24)>>2]|0;o=b+r|0;p=b+(r+76)|0;q=c[p>>2]|0;do{if((q|0)==-1){zs(k,b+(r+28)|0);u=0;q=Ha(35,k|0,16352)|0;r=u;u=0;if(!(r&1)?(u=0,l=Ha(c[(c[q>>2]|0)+28>>2]|0,q|0,32)|0,r=u,u=0,!(r&1)):0){As(k);q=l<<24>>24;c[p>>2]=q;g=11;break}h=qb(-1,-1,0)|0;As(k)}else{g=11}}while(0);if((g|0)==11){r=q&255;q=c[(c[m>>2]|0)+32>>2]|0;c[j>>2]=n;u=0;c[k+0>>2]=c[j+0>>2];wa(q|0,h|0,m|0,k|0,o|0,r|0,+d);r=u;u=0;if(!(r&1)){if((c[h>>2]|0)!=0){break}r=c[(c[b>>2]|0)+ -12>>2]|0;u=0;oa(85,b+r|0,c[b+(r+16)>>2]|5|0);r=u;u=0;if(!(r&1)){break}}h=qb(-1,-1,0)|0}}go(f)}$a(h|0)|0;r=c[(c[b>>2]|0)+ -12>>2]|0;q=b+(r+16)|0;c[q>>2]=c[q>>2]|1;if((c[b+(r+20)>>2]&1|0)==0){Ob();i=e;return b|0}u=0;Oa(3);r=u;u=0;g=qb(-1,-1)|0;u=0;Oa(2);r=u;u=0;if(r&1){r=qb(-1,-1,0)|0;jd(r)}else{vb(g|0)}}}while(0);go(f);i=e;return b|0}function lo(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0;f=i;i=i+16|0;e=f;a[e>>0]=0;c[e+4>>2]=b;k=c[b>>2]|0;j=c[k+ -12>>2]|0;do{if((c[b+(j+16)>>2]|0)==0){l=c[b+(j+72)>>2]|0;do{if((l|0)!=0){u=0;qa(120,l|0)|0;l=u;u=0;if(l&1){h=qb(-1,-1,0)|0;break}else{j=c[b>>2]|0;k=j;j=c[j+ -12>>2]|0;g=5;break}}else{g=5}}while(0);if((g|0)==5){a[e>>0]=1;j=c[b+(j+24)>>2]|0;if((j|0)!=0){k=j+24|0;l=c[k>>2]|0;if((l|0)!=(c[j+28>>2]|0)){c[k>>2]=l+1;a[l>>0]=d;break}u=0;d=Ha(c[(c[j>>2]|0)+52>>2]|0,j|0,d&255|0)|0;l=u;u=0;if(!(l&1)){if(!((d|0)==-1)){break}h=c[b>>2]|0;g=11}}else{h=k;g=11}if((g|0)==11?(l=c[h+ -12>>2]|0,u=0,oa(85,b+l|0,c[b+(l+16)>>2]|1|0),l=u,u=0,!(l&1)):0){break}h=qb(-1,-1,0)|0;go(e)}$a(h|0)|0;l=c[(c[b>>2]|0)+ -12>>2]|0;k=b+(l+16)|0;c[k>>2]=c[k>>2]|1;if((c[b+(l+20)>>2]&1|0)==0){Ob();i=f;return b|0}u=0;Oa(3);l=u;u=0;g=qb(-1,-1)|0;u=0;Oa(2);l=u;u=0;if(l&1){l=qb(-1,-1,0)|0;jd(l)}else{vb(g|0)}}}while(0);go(e);i=f;return b|0}function mo(a){a=a|0;var b=0;b=i;kn(a+4|0);Hv(a);i=b;return}function no(a){a=a|0;var b=0;b=i;kn(a+4|0);i=b;return}function oo(a){a=a|0;var b=0,d=0;b=i;d=c[(c[a>>2]|0)+ -12>>2]|0;kn(a+(d+4)|0);Hv(a+d|0);i=b;return}function po(a){a=a|0;var b=0;b=i;kn(a+((c[(c[a>>2]|0)+ -12>>2]|0)+4)|0);i=b;return}function qo(a){a=a|0;var b=0,d=0,e=0;b=i;a=a+4|0;d=c[a>>2]|0;e=c[(c[d>>2]|0)+ -12>>2]|0;if((c[d+(e+24)>>2]|0)==0){i=b;return}if((c[d+(e+16)>>2]|0)!=0){i=b;return}if((c[d+(e+4)>>2]&8192|0)==0){i=b;return}if(Xa()|0){i=b;return}d=c[a>>2]|0;d=c[d+((c[(c[d>>2]|0)+ -12>>2]|0)+24)>>2]|0;u=0;d=qa(c[(c[d>>2]|0)+24>>2]|0,d|0)|0;e=u;u=0;if(!(e&1)){if(!((d|0)==-1)){i=b;return}d=c[a>>2]|0;e=c[(c[d>>2]|0)+ -12>>2]|0;u=0;oa(85,d+e|0,c[d+(e+16)>>2]|1|0);e=u;u=0;if(!(e&1)){i=b;return}}e=qb(-1,-1,0)|0;$a(e|0)|0;u=0;Oa(2);e=u;u=0;if(e&1){e=qb(-1,-1,0)|0;jd(e)}else{i=b;return}}function ro(a){a=a|0;return 13904}function so(a,b,c){a=a|0;b=b|0;c=c|0;var d=0;d=i;if((c|0)==1){Pm(a,13920,35);i=d;return}else{Gm(a,b,c);i=d;return}}function to(a){a=a|0;return}function uo(a){a=a|0;var b=0;b=i;Km(a);Hv(a);i=b;return}function vo(a){a=a|0;var b=0;b=i;Km(a);i=b;return}function wo(a){a=a|0;var b=0;b=i;kn(a);Hv(a);i=b;return}function xo(a){a=a|0;var b=0;b=i;Hv(a);i=b;return}function yo(a){a=a|0;var b=0;b=i;Hv(a);i=b;return}function zo(a){a=a|0;return}function Ao(a){a=a|0;return}function Bo(b,c,d,e,f){b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0;b=i;a:do{if((e|0)==(f|0)){g=6}else{while(1){if((c|0)==(d|0)){d=-1;break a}h=a[c>>0]|0;j=a[e>>0]|0;if(h<<24>>24<j<<24>>24){d=-1;break a}if(j<<24>>24<h<<24>>24){d=1;break a}c=c+1|0;e=e+1|0;if((e|0)==(f|0)){g=6;break}}}}while(0);if((g|0)==6){d=(c|0)!=(d|0)&1}i=b;return d|0}function Co(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0;d=i;g=e;h=f-g|0;if(h>>>0>4294967279){Mm(b)}if(h>>>0<11){a[b>>0]=h<<1;b=b+1|0}else{k=h+16&-16;j=Fv(k)|0;c[b+8>>2]=j;c[b>>2]=k|1;c[b+4>>2]=h;b=j}if((e|0)==(f|0)){k=b;a[k>>0]=0;i=d;return}else{h=b}while(1){a[h>>0]=a[e>>0]|0;e=e+1|0;if((e|0)==(f|0)){break}else{h=h+1|0}}k=b+(f+(0-g))|0;a[k>>0]=0;i=d;return}function Do(b,c,d){b=b|0;c=c|0;d=d|0;var e=0,f=0;b=i;if((c|0)==(d|0)){e=0;i=b;return e|0}else{e=0}do{e=(a[c>>0]|0)+(e<<4)|0;f=e&-268435456;e=(f>>>24|f)^e;c=c+1|0}while((c|0)!=(d|0));i=b;return e|0}function Eo(a){a=a|0;var b=0;b=i;Hv(a);i=b;return}function Fo(a){a=a|0;return}function Go(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0;a=i;a:do{if((e|0)==(f|0)){g=6}else{while(1){if((b|0)==(d|0)){d=-1;break a}h=c[b>>2]|0;j=c[e>>2]|0;if((h|0)<(j|0)){d=-1;break a}if((j|0)<(h|0)){d=1;break a}b=b+4|0;e=e+4|0;if((e|0)==(f|0)){g=6;break}}}}while(0);if((g|0)==6){d=(b|0)!=(d|0)&1}i=a;return d|0}function Ho(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0;d=i;g=e;j=f-g|0;h=j>>2;if(h>>>0>1073741807){Mm(b)}if(h>>>0<2){a[b>>0]=j>>>1;b=b+4|0}else{k=h+4&-4;j=Fv(k<<2)|0;c[b+8>>2]=j;c[b>>2]=k|1;c[b+4>>2]=h;b=j}if((e|0)==(f|0)){k=b;c[k>>2]=0;i=d;return}g=f+ -4+(0-g)|0;h=b;while(1){c[h>>2]=c[e>>2];e=e+4|0;if((e|0)==(f|0)){break}else{h=h+4|0}}k=b+((g>>>2)+1<<2)|0;c[k>>2]=0;i=d;return}function Io(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;a=i;if((b|0)==(d|0)){e=0;i=a;return e|0}else{e=0}do{e=(c[b>>2]|0)+(e<<4)|0;f=e&-268435456;e=(f>>>24|f)^e;b=b+4|0}while((b|0)!=(d|0));i=a;return e|0}function Jo(a){a=a|0;var b=0;b=i;Hv(a);i=b;return}function Ko(a){a=a|0;return}function Lo(b,d,e,f,g,h,j){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0;l=i;i=i+80|0;n=l+16|0;s=l;t=l+76|0;w=l+72|0;x=l+68|0;v=l+64|0;r=l+60|0;q=l+56|0;k=l+32|0;o=l+28|0;if((c[g+4>>2]&1|0)==0){c[t>>2]=-1;k=c[(c[d>>2]|0)+16>>2]|0;c[x>>2]=c[e>>2];c[v>>2]=c[f>>2];c[s+0>>2]=c[x+0>>2];c[n+0>>2]=c[v+0>>2];Oc[k&63](w,d,s,n,g,h,t);k=c[w>>2]|0;c[e>>2]=k;e=c[t>>2]|0;if((e|0)==0){a[j>>0]=0}else if((e|0)==1){a[j>>0]=1}else{a[j>>0]=1;c[h>>2]=4}c[b>>2]=k;i=l;return}ln(r,g);t=c[r>>2]|0;if(!(!((c[4088]|0)==-1)?(c[s>>2]=16352,c[s+4>>2]=205,c[s+8>>2]=0,u=0,Na(58,16352,s|0,206),x=u,u=0,x&1):0)){s=(c[16356>>2]|0)+ -1|0;d=c[t+8>>2]|0;if((c[t+12>>2]|0)-d>>2>>>0>s>>>0?(m=c[d+(s<<2)>>2]|0,(m|0)!=0):0){qm(c[r>>2]|0)|0;ln(q,g);r=c[q>>2]|0;if(!(!((c[4124]|0)==-1)?(c[n>>2]=16496,c[n+4>>2]=205,c[n+8>>2]=0,u=0,Na(58,16496,n|0,206),x=u,u=0,x&1):0)){g=(c[16500>>2]|0)+ -1|0;s=c[r+8>>2]|0;if((c[r+12>>2]|0)-s>>2>>>0>g>>>0?(p=c[s+(g<<2)>>2]|0,(p|0)!=0):0){qm(c[q>>2]|0)|0;u=0;oa(c[(c[p>>2]|0)+24>>2]|0,k|0,p|0);x=u;u=0;if(!(x&1)){q=k+12|0;u=0;oa(c[(c[p>>2]|0)+28>>2]|0,q|0,p|0);x=u;u=0;if(!(x&1)){c[o>>2]=c[f>>2];x=k+24|0;u=0;c[n+0>>2]=c[o+0>>2];h=la(1,e|0,n|0,k|0,x|0,m|0,h|0,1)|0;x=u;u=0;if(x&1){x=qb(-1,-1)|0;Rm(k+12|0);Rm(k);vb(x|0)}else{a[j>>0]=(h|0)==(k|0)&1;c[b>>2]=c[e>>2];Rm(k+12|0);Rm(k);i=l;return}}}else{q=k}b=qb(-1,-1)|0;j=J;if((k|0)==(q|0)){x=b;vb(x|0)}do{q=q+ -12|0;Rm(q)}while((q|0)!=(k|0));vb(b|0)}x=Jb(4)|0;bv(x);u=0;Na(45,x|0,24312,171);x=u;u=0}x=qb(-1,-1)|0;qm(c[q>>2]|0)|0;vb(x|0)}x=Jb(4)|0;bv(x);u=0;Na(45,x|0,24312,171);x=u;u=0}x=qb(-1,-1)|0;qm(c[r>>2]|0)|0;vb(x|0)}function Mo(b,e,f,g,h,j,k){b=b|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;var l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0;m=i;i=i+112|0;n=m;s=(g-f|0)/12|0;if(s>>>0>100){n=Av(s)|0;if((n|0)==0){u=0;Oa(4);A=u;u=0;if(A&1){A=qb(-1,-1)|0;vb(A|0)}else{l=0;n=0}}else{l=n}}else{l=0}o=(f|0)==(g|0);if(o){t=0}else{p=f;t=0;q=n;while(1){r=a[p>>0]|0;if((r&1)==0){r=(r&255)>>>1}else{r=c[p+4>>2]|0}if((r|0)==0){a[q>>0]=2;t=t+1|0;s=s+ -1|0}else{a[q>>0]=1}p=p+12|0;if((p|0)==(g|0)){break}else{q=q+1|0}}}p=0;a:while(1){q=c[b>>2]|0;do{if((q|0)!=0){if((c[q+12>>2]|0)==(c[q+16>>2]|0)){u=0;q=qa(c[(c[q>>2]|0)+36>>2]|0,q|0)|0;A=u;u=0;if(A&1){h=6;break a}if((q|0)==-1){c[b>>2]=0;q=0;break}else{q=c[b>>2]|0;break}}}else{q=0}}while(0);w=(q|0)==0;q=c[e>>2]|0;if((q|0)!=0){if((c[q+12>>2]|0)==(c[q+16>>2]|0)){u=0;r=qa(c[(c[q>>2]|0)+36>>2]|0,q|0)|0;A=u;u=0;if(A&1){h=6;break}if((r|0)==-1){c[e>>2]=0;q=0}}}else{q=0}r=(q|0)==0;v=c[b>>2]|0;if(!((w^r)&(s|0)!=0)){h=79;break}q=c[v+12>>2]|0;if((q|0)==(c[v+16>>2]|0)){u=0;q=qa(c[(c[v>>2]|0)+36>>2]|0,v|0)|0;A=u;u=0;if(A&1){h=6;break}}else{q=d[q>>0]|0}r=q&255;if(!k){u=0;r=Ha(c[(c[h>>2]|0)+12>>2]|0,h|0,r|0)|0;A=u;u=0;if(A&1){h=6;break}}q=p+1|0;if(o){p=q;continue}b:do{if(k){w=0;v=f;x=n;while(1){do{if((a[x>>0]|0)==1){A=a[v>>0]|0;z=(A&1)==0;if(z){y=v+1|0}else{y=c[v+8>>2]|0}if(!(r<<24>>24==(a[y+p>>0]|0))){a[x>>0]=0;s=s+ -1|0;break}if(z){w=(A&255)>>>1}else{w=c[v+4>>2]|0}if((w|0)==(q|0)){a[x>>0]=2;w=1;t=t+1|0;s=s+ -1|0}else{w=1}}}while(0);v=v+12|0;if((v|0)==(g|0)){break b}x=x+1|0}}else{x=0;v=f;w=n;while(1){do{if((a[w>>0]|0)==1){if((a[v>>0]&1)==0){y=v+1|0}else{y=c[v+8>>2]|0}u=0;y=Ha(c[(c[h>>2]|0)+12>>2]|0,h|0,a[y+p>>0]|0)|0;A=u;u=0;if(A&1){h=5;break a}if(!(r<<24>>24==y<<24>>24)){a[w>>0]=0;s=s+ -1|0;break}x=a[v>>0]|0;if((x&1)==0){x=(x&255)>>>1}else{x=c[v+4>>2]|0}if((x|0)==(q|0)){a[w>>0]=2;x=1;t=t+1|0;s=s+ -1|0}else{x=1}}}while(0);v=v+12|0;if((v|0)==(g|0)){w=x;break b}w=w+1|0}}}while(0);if(!w){p=q;continue}v=c[b>>2]|0;r=v+12|0;p=c[r>>2]|0;if((p|0)==(c[v+16>>2]|0)){u=0;qa(c[(c[v>>2]|0)+40>>2]|0,v|0)|0;A=u;u=0;if(A&1){h=6;break}}else{c[r>>2]=p+1}if((s+t|0)>>>0<2){p=q;continue}else{p=f;r=n}while(1){if((a[r>>0]|0)==2){v=a[p>>0]|0;if((v&1)==0){v=(v&255)>>>1}else{v=c[p+4>>2]|0}if((v|0)!=(q|0)){a[r>>0]=0;t=t+ -1|0}}p=p+12|0;if((p|0)==(g|0)){p=q;continue a}else{r=r+1|0}}}if((h|0)==5){m=qb(-1,-1)|0}else if((h|0)==6){m=qb(-1,-1)|0}else if((h|0)==79){do{if((v|0)!=0){if((c[v+12>>2]|0)==(c[v+16>>2]|0)){u=0;k=qa(c[(c[v>>2]|0)+36>>2]|0,v|0)|0;A=u;u=0;if(!(A&1)){if((k|0)==-1){c[b>>2]=0;v=0;h=85;break}else{v=c[b>>2]|0;h=85;break}}}else{h=85}}else{v=0;h=85}}while(0);c:do{if((h|0)==85){b=(v|0)==0;do{if(!r){if((c[q+12>>2]|0)!=(c[q+16>>2]|0)){if(b){break}else{h=93;break}}u=0;k=qa(c[(c[q>>2]|0)+36>>2]|0,q|0)|0;A=u;u=0;if(A&1){break c}if(!((k|0)==-1)){if(b){break}else{h=93;break}}else{c[e>>2]=0;h=91;break}}else{h=91}}while(0);if((h|0)==91?b:0){h=93}if((h|0)==93){c[j>>2]=c[j>>2]|2}d:do{if(!o){if((a[n>>0]|0)==2){g=f}else{while(1){f=f+12|0;n=n+1|0;if((f|0)==(g|0)){h=98;break d}if((a[n>>0]|0)==2){g=f;break}}}}else{h=98}}while(0);if((h|0)==98){c[j>>2]=c[j>>2]|4}if((l|0)==0){i=m;return g|0}u=0;na(207,l|0);A=u;u=0;if(A&1){A=qb(-1,-1,0)|0;jd(A)}else{i=m;return g|0}}}while(0);m=qb(-1,-1)|0}if((l|0)==0){A=m;vb(A|0)}u=0;na(207,l|0);A=u;u=0;if(A&1){A=qb(-1,-1,0)|0;jd(A)}else{A=m;vb(A|0)}return 0}function No(a,b,d,e,f,g,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0;b=i;i=i+16|0;j=b+12|0;k=b+8|0;m=b+4|0;l=b;c[m>>2]=c[d>>2];c[l>>2]=c[e>>2];c[k+0>>2]=c[m+0>>2];c[j+0>>2]=c[l+0>>2];Oo(a,0,k,j,f,g,h);i=b;return}function Oo(b,e,f,g,h,j,k){b=b|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;var l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0;m=i;i=i+224|0;v=m+198|0;w=m+196|0;e=m+184|0;n=m+172|0;s=m+168|0;p=m+8|0;o=m+4|0;r=m;t=c[h+4>>2]&74;if((t|0)==8){t=16}else if((t|0)==64){t=8}else if((t|0)==0){t=0}else{t=10}Ep(e,h,v,w);c[n+0>>2]=0;c[n+4>>2]=0;c[n+8>>2]=0;u=0;Na(59,n|0,10,0);E=u;u=0;a:do{if(!(E&1)){if((a[n>>0]&1)==0){B=n+1|0;y=B;h=n+8|0}else{B=n+8|0;y=n+1|0;h=B;B=c[B>>2]|0}c[s>>2]=B;c[o>>2]=p;c[r>>2]=0;x=n+4|0;z=a[w>>0]|0;w=c[f>>2]|0;b:while(1){if((w|0)!=0){if((c[w+12>>2]|0)==(c[w+16>>2]|0)){u=0;A=qa(c[(c[w>>2]|0)+36>>2]|0,w|0)|0;E=u;u=0;if(E&1){l=37;break}if((A|0)==-1){c[f>>2]=0;w=0}}}else{w=0}D=(w|0)==0;A=c[g>>2]|0;do{if((A|0)!=0){if((c[A+12>>2]|0)!=(c[A+16>>2]|0)){if(D){break}else{break b}}u=0;C=qa(c[(c[A>>2]|0)+36>>2]|0,A|0)|0;E=u;u=0;if(E&1){l=37;break b}if(!((C|0)==-1)){if(D){break}else{break b}}else{c[g>>2]=0;l=21;break}}else{l=21}}while(0);if((l|0)==21){l=0;if(D){A=0;break}else{A=0}}C=a[n>>0]|0;E=(C&1)==0;if(E){D=(C&255)>>>1}else{D=c[x>>2]|0}if(((c[s>>2]|0)-B|0)==(D|0)){if(E){B=(C&255)>>>1;C=(C&255)>>>1}else{C=c[x>>2]|0;B=C}u=0;Na(59,n|0,B<<1|0,0);E=u;u=0;if(E&1){l=37;break}if((a[n>>0]&1)==0){B=10}else{B=(c[n>>2]&-2)+ -1|0}u=0;Na(59,n|0,B|0,0);E=u;u=0;if(E&1){l=37;break}if((a[n>>0]&1)==0){B=y}else{B=c[h>>2]|0}c[s>>2]=B+C}D=w+12|0;E=c[D>>2]|0;C=w+16|0;if((E|0)==(c[C>>2]|0)){u=0;E=qa(c[(c[w>>2]|0)+36>>2]|0,w|0)|0;F=u;u=0;if(F&1){l=37;break}}else{E=d[E>>0]|0}if((ep(E&255,t,B,s,r,z,e,p,o,v)|0)!=0){break}A=c[D>>2]|0;if((A|0)==(c[C>>2]|0)){u=0;qa(c[(c[w>>2]|0)+40>>2]|0,w|0)|0;F=u;u=0;if(F&1){l=37;break}else{continue}}else{c[D>>2]=A+1;continue}}if((l|0)==37){F=qb(-1,-1)|0;Rm(n);Rm(e);vb(F|0)}v=a[e>>0]|0;if((v&1)==0){v=(v&255)>>>1}else{v=c[e+4>>2]|0}if((v|0)!=0?(q=c[o>>2]|0,(q-p|0)<160):0){F=c[r>>2]|0;c[o>>2]=q+4;c[q>>2]=F}u=0;q=Ma(9,B|0,c[s>>2]|0,j|0,t|0)|0;F=u;u=0;if(!(F&1)){c[k>>2]=q;Pr(e,p,c[o>>2]|0,j);if((w|0)!=0){if((c[w+12>>2]|0)==(c[w+16>>2]|0)){u=0;k=qa(c[(c[w>>2]|0)+36>>2]|0,w|0)|0;F=u;u=0;if(F&1){break}if((k|0)==-1){c[f>>2]=0;w=0}}}else{w=0}f=(w|0)==0;do{if((A|0)!=0){if((c[A+12>>2]|0)!=(c[A+16>>2]|0)){if(!f){break}c[b>>2]=w;Rm(n);Rm(e);i=m;return}u=0;k=qa(c[(c[A>>2]|0)+36>>2]|0,A|0)|0;F=u;u=0;if(F&1){break a}if((k|0)==-1){c[g>>2]=0;l=65;break}if(f^(A|0)==0){c[b>>2]=w;Rm(n);Rm(e);i=m;return}}else{l=65}}while(0);if((l|0)==65?!f:0){c[b>>2]=w;Rm(n);Rm(e);i=m;return}c[j>>2]=c[j>>2]|2;c[b>>2]=w;Rm(n);Rm(e);i=m;return}}}while(0);F=qb(-1,-1)|0;Rm(n);Rm(e);vb(F|0)}function Po(a,b,d,e,f,g,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0;b=i;i=i+16|0;j=b+12|0;k=b+8|0;m=b+4|0;l=b;c[m>>2]=c[d>>2];c[l>>2]=c[e>>2];c[k+0>>2]=c[m+0>>2];c[j+0>>2]=c[l+0>>2];Qo(a,0,k,j,f,g,h);i=b;return}function Qo(b,e,f,g,h,j,k){b=b|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;var l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0;e=i;i=i+224|0;w=e+198|0;v=e+196|0;m=e+184|0;n=e+172|0;r=e+168|0;p=e+8|0;o=e+4|0;s=e;t=c[h+4>>2]&74;if((t|0)==0){t=0}else if((t|0)==64){t=8}else if((t|0)==8){t=16}else{t=10}Ep(m,h,w,v);c[n+0>>2]=0;c[n+4>>2]=0;c[n+8>>2]=0;u=0;Na(59,n|0,10,0);E=u;u=0;a:do{if(!(E&1)){if((a[n>>0]&1)==0){B=n+1|0;y=B;h=n+8|0}else{B=n+8|0;y=n+1|0;h=B;B=c[B>>2]|0}c[r>>2]=B;c[o>>2]=p;c[s>>2]=0;x=n+4|0;z=a[v>>0]|0;v=c[f>>2]|0;b:while(1){if((v|0)!=0){if((c[v+12>>2]|0)==(c[v+16>>2]|0)){u=0;A=qa(c[(c[v>>2]|0)+36>>2]|0,v|0)|0;E=u;u=0;if(E&1){l=37;break}if((A|0)==-1){c[f>>2]=0;v=0}}}else{v=0}D=(v|0)==0;A=c[g>>2]|0;do{if((A|0)!=0){if((c[A+12>>2]|0)!=(c[A+16>>2]|0)){if(D){break}else{break b}}u=0;C=qa(c[(c[A>>2]|0)+36>>2]|0,A|0)|0;E=u;u=0;if(E&1){l=37;break b}if(!((C|0)==-1)){if(D){break}else{break b}}else{c[g>>2]=0;l=21;break}}else{l=21}}while(0);if((l|0)==21){l=0;if(D){A=0;break}else{A=0}}C=a[n>>0]|0;D=(C&1)==0;if(D){E=(C&255)>>>1}else{E=c[x>>2]|0}if(((c[r>>2]|0)-B|0)==(E|0)){if(D){B=(C&255)>>>1;C=(C&255)>>>1}else{C=c[x>>2]|0;B=C}u=0;Na(59,n|0,B<<1|0,0);E=u;u=0;if(E&1){l=37;break}if((a[n>>0]&1)==0){B=10}else{B=(c[n>>2]&-2)+ -1|0}u=0;Na(59,n|0,B|0,0);E=u;u=0;if(E&1){l=37;break}if((a[n>>0]&1)==0){B=y}else{B=c[h>>2]|0}c[r>>2]=B+C}D=v+12|0;E=c[D>>2]|0;C=v+16|0;if((E|0)==(c[C>>2]|0)){u=0;E=qa(c[(c[v>>2]|0)+36>>2]|0,v|0)|0;F=u;u=0;if(F&1){l=37;break}}else{E=d[E>>0]|0}if((ep(E&255,t,B,r,s,z,m,p,o,w)|0)!=0){break}A=c[D>>2]|0;if((A|0)==(c[C>>2]|0)){u=0;qa(c[(c[v>>2]|0)+40>>2]|0,v|0)|0;F=u;u=0;if(F&1){l=37;break}else{continue}}else{c[D>>2]=A+1;continue}}if((l|0)==37){F=qb(-1,-1)|0;Rm(n);Rm(m);vb(F|0)}w=a[m>>0]|0;if((w&1)==0){w=(w&255)>>>1}else{w=c[m+4>>2]|0}if((w|0)!=0?(q=c[o>>2]|0,(q-p|0)<160):0){F=c[s>>2]|0;c[o>>2]=q+4;c[q>>2]=F}u=0;r=Ma(10,B|0,c[r>>2]|0,j|0,t|0)|0;q=J;F=u;u=0;if(!(F&1)){F=k;c[F>>2]=r;c[F+4>>2]=q;Pr(m,p,c[o>>2]|0,j);if((v|0)!=0){if((c[v+12>>2]|0)==(c[v+16>>2]|0)){u=0;k=qa(c[(c[v>>2]|0)+36>>2]|0,v|0)|0;F=u;u=0;if(F&1){break}if((k|0)==-1){c[f>>2]=0;v=0}}}else{v=0}f=(v|0)==0;do{if((A|0)!=0){if((c[A+12>>2]|0)!=(c[A+16>>2]|0)){if(!f){break}c[b>>2]=v;Rm(n);Rm(m);i=e;return}u=0;k=qa(c[(c[A>>2]|0)+36>>2]|0,A|0)|0;F=u;u=0;if(F&1){break a}if((k|0)==-1){c[g>>2]=0;l=65;break}if(f^(A|0)==0){c[b>>2]=v;Rm(n);Rm(m);i=e;return}}else{l=65}}while(0);if((l|0)==65?!f:0){c[b>>2]=v;Rm(n);Rm(m);i=e;return}c[j>>2]=c[j>>2]|2;c[b>>2]=v;Rm(n);Rm(m);i=e;return}}}while(0);F=qb(-1,-1)|0;Rm(n);Rm(m);vb(F|0)}function Ro(a,b,d,e,f,g,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0;b=i;i=i+16|0;j=b+12|0;k=b+8|0;m=b+4|0;l=b;c[m>>2]=c[d>>2];c[l>>2]=c[e>>2];c[k+0>>2]=c[m+0>>2];c[j+0>>2]=c[l+0>>2];So(a,0,k,j,f,g,h);i=b;return}function So(e,f,g,h,j,k,l){e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;l=l|0;var m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0;n=i;i=i+224|0;w=n+198|0;x=n+196|0;f=n+184|0;o=n+172|0;t=n+168|0;q=n+8|0;p=n+4|0;s=n;v=c[j+4>>2]&74;if((v|0)==64){v=8}else if((v|0)==0){v=0}else if((v|0)==8){v=16}else{v=10}Ep(f,j,w,x);c[o+0>>2]=0;c[o+4>>2]=0;c[o+8>>2]=0;u=0;Na(59,o|0,10,0);F=u;u=0;a:do{if(!(F&1)){if((a[o>>0]&1)==0){C=o+1|0;z=C;j=o+8|0}else{C=o+8|0;z=o+1|0;j=C;C=c[C>>2]|0}c[t>>2]=C;c[p>>2]=q;c[s>>2]=0;y=o+4|0;A=a[x>>0]|0;x=c[g>>2]|0;b:while(1){if((x|0)!=0){if((c[x+12>>2]|0)==(c[x+16>>2]|0)){u=0;B=qa(c[(c[x>>2]|0)+36>>2]|0,x|0)|0;F=u;u=0;if(F&1){m=37;break}if((B|0)==-1){c[g>>2]=0;x=0}}}else{x=0}E=(x|0)==0;B=c[h>>2]|0;do{if((B|0)!=0){if((c[B+12>>2]|0)!=(c[B+16>>2]|0)){if(E){break}else{break b}}u=0;D=qa(c[(c[B>>2]|0)+36>>2]|0,B|0)|0;F=u;u=0;if(F&1){m=37;break b}if(!((D|0)==-1)){if(E){break}else{break b}}else{c[h>>2]=0;m=21;break}}else{m=21}}while(0);if((m|0)==21){m=0;if(E){B=0;break}else{B=0}}D=a[o>>0]|0;F=(D&1)==0;if(F){E=(D&255)>>>1}else{E=c[y>>2]|0}if(((c[t>>2]|0)-C|0)==(E|0)){if(F){C=(D&255)>>>1;D=(D&255)>>>1}else{D=c[y>>2]|0;C=D}u=0;Na(59,o|0,C<<1|0,0);F=u;u=0;if(F&1){m=37;break}if((a[o>>0]&1)==0){C=10}else{C=(c[o>>2]&-2)+ -1|0}u=0;Na(59,o|0,C|0,0);F=u;u=0;if(F&1){m=37;break}if((a[o>>0]&1)==0){C=z}else{C=c[j>>2]|0}c[t>>2]=C+D}E=x+12|0;F=c[E>>2]|0;D=x+16|0;if((F|0)==(c[D>>2]|0)){u=0;F=qa(c[(c[x>>2]|0)+36>>2]|0,x|0)|0;G=u;u=0;if(G&1){m=37;break}}else{F=d[F>>0]|0}if((ep(F&255,v,C,t,s,A,f,q,p,w)|0)!=0){break}B=c[E>>2]|0;if((B|0)==(c[D>>2]|0)){u=0;qa(c[(c[x>>2]|0)+40>>2]|0,x|0)|0;G=u;u=0;if(G&1){m=37;break}else{continue}}else{c[E>>2]=B+1;continue}}if((m|0)==37){G=qb(-1,-1)|0;Rm(o);Rm(f);vb(G|0)}w=a[f>>0]|0;if((w&1)==0){w=(w&255)>>>1}else{w=c[f+4>>2]|0}if((w|0)!=0?(r=c[p>>2]|0,(r-q|0)<160):0){G=c[s>>2]|0;c[p>>2]=r+4;c[r>>2]=G}u=0;r=Ma(11,C|0,c[t>>2]|0,k|0,v|0)|0;G=u;u=0;if(!(G&1)){b[l>>1]=r;Pr(f,q,c[p>>2]|0,k);if((x|0)!=0){if((c[x+12>>2]|0)==(c[x+16>>2]|0)){u=0;l=qa(c[(c[x>>2]|0)+36>>2]|0,x|0)|0;G=u;u=0;if(G&1){break}if((l|0)==-1){c[g>>2]=0;x=0}}}else{x=0}g=(x|0)==0;do{if((B|0)!=0){if((c[B+12>>2]|0)!=(c[B+16>>2]|0)){if(!g){break}c[e>>2]=x;Rm(o);Rm(f);i=n;return}u=0;l=qa(c[(c[B>>2]|0)+36>>2]|0,B|0)|0;G=u;u=0;if(G&1){break a}if((l|0)==-1){c[h>>2]=0;m=65;break}if(g^(B|0)==0){c[e>>2]=x;Rm(o);Rm(f);i=n;return}}else{m=65}}while(0);if((m|0)==65?!g:0){c[e>>2]=x;Rm(o);Rm(f);i=n;return}c[k>>2]=c[k>>2]|2;c[e>>2]=x;Rm(o);Rm(f);i=n;return}}}while(0);G=qb(-1,-1)|0;Rm(o);Rm(f);vb(G|0)}function To(a,b,d,e,f,g,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0;b=i;i=i+16|0;j=b+12|0;k=b+8|0;m=b+4|0;l=b;c[m>>2]=c[d>>2];c[l>>2]=c[e>>2];c[k+0>>2]=c[m+0>>2];c[j+0>>2]=c[l+0>>2];Uo(a,0,k,j,f,g,h);i=b;return}function Uo(b,e,f,g,h,j,k){b=b|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;var l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0;m=i;i=i+224|0;v=m+198|0;w=m+196|0;e=m+184|0;n=m+172|0;s=m+168|0;p=m+8|0;o=m+4|0;r=m;t=c[h+4>>2]&74;if((t|0)==64){t=8}else if((t|0)==8){t=16}else if((t|0)==0){t=0}else{t=10}Ep(e,h,v,w);c[n+0>>2]=0;c[n+4>>2]=0;c[n+8>>2]=0;u=0;Na(59,n|0,10,0);E=u;u=0;a:do{if(!(E&1)){if((a[n>>0]&1)==0){B=n+1|0;y=B;h=n+8|0}else{B=n+8|0;y=n+1|0;h=B;B=c[B>>2]|0}c[s>>2]=B;c[o>>2]=p;c[r>>2]=0;x=n+4|0;z=a[w>>0]|0;w=c[f>>2]|0;b:while(1){if((w|0)!=0){if((c[w+12>>2]|0)==(c[w+16>>2]|0)){u=0;A=qa(c[(c[w>>2]|0)+36>>2]|0,w|0)|0;E=u;u=0;if(E&1){l=37;break}if((A|0)==-1){c[f>>2]=0;w=0}}}else{w=0}D=(w|0)==0;A=c[g>>2]|0;do{if((A|0)!=0){if((c[A+12>>2]|0)!=(c[A+16>>2]|0)){if(D){break}else{break b}}u=0;C=qa(c[(c[A>>2]|0)+36>>2]|0,A|0)|0;E=u;u=0;if(E&1){l=37;break b}if(!((C|0)==-1)){if(D){break}else{break b}}else{c[g>>2]=0;l=21;break}}else{l=21}}while(0);if((l|0)==21){l=0;if(D){A=0;break}else{A=0}}C=a[n>>0]|0;E=(C&1)==0;if(E){D=(C&255)>>>1}else{D=c[x>>2]|0}if(((c[s>>2]|0)-B|0)==(D|0)){if(E){B=(C&255)>>>1;C=(C&255)>>>1}else{C=c[x>>2]|0;B=C}u=0;Na(59,n|0,B<<1|0,0);E=u;u=0;if(E&1){l=37;break}if((a[n>>0]&1)==0){B=10}else{B=(c[n>>2]&-2)+ -1|0}u=0;Na(59,n|0,B|0,0);E=u;u=0;if(E&1){l=37;break}if((a[n>>0]&1)==0){B=y}else{B=c[h>>2]|0}c[s>>2]=B+C}D=w+12|0;E=c[D>>2]|0;C=w+16|0;if((E|0)==(c[C>>2]|0)){u=0;E=qa(c[(c[w>>2]|0)+36>>2]|0,w|0)|0;F=u;u=0;if(F&1){l=37;break}}else{E=d[E>>0]|0}if((ep(E&255,t,B,s,r,z,e,p,o,v)|0)!=0){break}A=c[D>>2]|0;if((A|0)==(c[C>>2]|0)){u=0;qa(c[(c[w>>2]|0)+40>>2]|0,w|0)|0;F=u;u=0;if(F&1){l=37;break}else{continue}}else{c[D>>2]=A+1;continue}}if((l|0)==37){F=qb(-1,-1)|0;Rm(n);Rm(e);vb(F|0)}v=a[e>>0]|0;if((v&1)==0){v=(v&255)>>>1}else{v=c[e+4>>2]|0}if((v|0)!=0?(q=c[o>>2]|0,(q-p|0)<160):0){F=c[r>>2]|0;c[o>>2]=q+4;c[q>>2]=F}u=0;q=Ma(12,B|0,c[s>>2]|0,j|0,t|0)|0;F=u;u=0;if(!(F&1)){c[k>>2]=q;Pr(e,p,c[o>>2]|0,j);if((w|0)!=0){if((c[w+12>>2]|0)==(c[w+16>>2]|0)){u=0;k=qa(c[(c[w>>2]|0)+36>>2]|0,w|0)|0;F=u;u=0;if(F&1){break}if((k|0)==-1){c[f>>2]=0;w=0}}}else{w=0}f=(w|0)==0;do{if((A|0)!=0){if((c[A+12>>2]|0)!=(c[A+16>>2]|0)){if(!f){break}c[b>>2]=w;Rm(n);Rm(e);i=m;return}u=0;k=qa(c[(c[A>>2]|0)+36>>2]|0,A|0)|0;F=u;u=0;if(F&1){break a}if((k|0)==-1){c[g>>2]=0;l=65;break}if(f^(A|0)==0){c[b>>2]=w;Rm(n);Rm(e);i=m;return}}else{l=65}}while(0);if((l|0)==65?!f:0){c[b>>2]=w;Rm(n);Rm(e);i=m;return}c[j>>2]=c[j>>2]|2;c[b>>2]=w;Rm(n);Rm(e);i=m;return}}}while(0);F=qb(-1,-1)|0;Rm(n);Rm(e);vb(F|0)}function Vo(a,b,d,e,f,g,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0;b=i;i=i+16|0;j=b+12|0;k=b+8|0;m=b+4|0;l=b;c[m>>2]=c[d>>2];c[l>>2]=c[e>>2];c[k+0>>2]=c[m+0>>2];c[j+0>>2]=c[l+0>>2];Wo(a,0,k,j,f,g,h);i=b;return}function Wo(b,e,f,g,h,j,k){b=b|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;var l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0;m=i;i=i+224|0;v=m+198|0;w=m+196|0;e=m+184|0;n=m+172|0;s=m+168|0;p=m+8|0;o=m+4|0;r=m;t=c[h+4>>2]&74;if((t|0)==0){t=0}else if((t|0)==64){t=8}else if((t|0)==8){t=16}else{t=10}Ep(e,h,v,w);c[n+0>>2]=0;c[n+4>>2]=0;c[n+8>>2]=0;u=0;Na(59,n|0,10,0);E=u;u=0;a:do{if(!(E&1)){if((a[n>>0]&1)==0){B=n+1|0;y=B;h=n+8|0}else{B=n+8|0;y=n+1|0;h=B;B=c[B>>2]|0}c[s>>2]=B;c[o>>2]=p;c[r>>2]=0;x=n+4|0;z=a[w>>0]|0;w=c[f>>2]|0;b:while(1){if((w|0)!=0){if((c[w+12>>2]|0)==(c[w+16>>2]|0)){u=0;A=qa(c[(c[w>>2]|0)+36>>2]|0,w|0)|0;E=u;u=0;if(E&1){l=37;break}if((A|0)==-1){c[f>>2]=0;w=0}}}else{w=0}D=(w|0)==0;A=c[g>>2]|0;do{if((A|0)!=0){if((c[A+12>>2]|0)!=(c[A+16>>2]|0)){if(D){break}else{break b}}u=0;C=qa(c[(c[A>>2]|0)+36>>2]|0,A|0)|0;E=u;u=0;if(E&1){l=37;break b}if(!((C|0)==-1)){if(D){break}else{break b}}else{c[g>>2]=0;l=21;break}}else{l=21}}while(0);if((l|0)==21){l=0;if(D){A=0;break}else{A=0}}C=a[n>>0]|0;E=(C&1)==0;if(E){D=(C&255)>>>1}else{D=c[x>>2]|0}if(((c[s>>2]|0)-B|0)==(D|0)){if(E){B=(C&255)>>>1;C=(C&255)>>>1}else{C=c[x>>2]|0;B=C}u=0;Na(59,n|0,B<<1|0,0);E=u;u=0;if(E&1){l=37;break}if((a[n>>0]&1)==0){B=10}else{B=(c[n>>2]&-2)+ -1|0}u=0;Na(59,n|0,B|0,0);E=u;u=0;if(E&1){l=37;break}if((a[n>>0]&1)==0){B=y}else{B=c[h>>2]|0}c[s>>2]=B+C}D=w+12|0;E=c[D>>2]|0;C=w+16|0;if((E|0)==(c[C>>2]|0)){u=0;E=qa(c[(c[w>>2]|0)+36>>2]|0,w|0)|0;F=u;u=0;if(F&1){l=37;break}}else{E=d[E>>0]|0}if((ep(E&255,t,B,s,r,z,e,p,o,v)|0)!=0){break}A=c[D>>2]|0;if((A|0)==(c[C>>2]|0)){u=0;qa(c[(c[w>>2]|0)+40>>2]|0,w|0)|0;F=u;u=0;if(F&1){l=37;break}else{continue}}else{c[D>>2]=A+1;continue}}if((l|0)==37){F=qb(-1,-1)|0;Rm(n);Rm(e);vb(F|0)}v=a[e>>0]|0;if((v&1)==0){v=(v&255)>>>1}else{v=c[e+4>>2]|0}if((v|0)!=0?(q=c[o>>2]|0,(q-p|0)<160):0){F=c[r>>2]|0;c[o>>2]=q+4;c[q>>2]=F}u=0;q=Ma(13,B|0,c[s>>2]|0,j|0,t|0)|0;F=u;u=0;if(!(F&1)){c[k>>2]=q;Pr(e,p,c[o>>2]|0,j);if((w|0)!=0){if((c[w+12>>2]|0)==(c[w+16>>2]|0)){u=0;k=qa(c[(c[w>>2]|0)+36>>2]|0,w|0)|0;F=u;u=0;if(F&1){break}if((k|0)==-1){c[f>>2]=0;w=0}}}else{w=0}f=(w|0)==0;do{if((A|0)!=0){if((c[A+12>>2]|0)!=(c[A+16>>2]|0)){if(!f){break}c[b>>2]=w;Rm(n);Rm(e);i=m;return}u=0;k=qa(c[(c[A>>2]|0)+36>>2]|0,A|0)|0;F=u;u=0;if(F&1){break a}if((k|0)==-1){c[g>>2]=0;l=65;break}if(f^(A|0)==0){c[b>>2]=w;Rm(n);Rm(e);i=m;return}}else{l=65}}while(0);if((l|0)==65?!f:0){c[b>>2]=w;Rm(n);Rm(e);i=m;return}c[j>>2]=c[j>>2]|2;c[b>>2]=w;Rm(n);Rm(e);i=m;return}}}while(0);F=qb(-1,-1)|0;Rm(n);Rm(e);vb(F|0)}function Xo(a,b,d,e,f,g,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0;b=i;i=i+16|0;j=b+12|0;k=b+8|0;m=b+4|0;l=b;c[m>>2]=c[d>>2];c[l>>2]=c[e>>2];c[k+0>>2]=c[m+0>>2];c[j+0>>2]=c[l+0>>2];Yo(a,0,k,j,f,g,h);i=b;return}function Yo(b,e,f,g,h,j,k){b=b|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;var l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0;e=i;i=i+224|0;w=e+198|0;v=e+196|0;m=e+184|0;n=e+172|0;r=e+168|0;p=e+8|0;o=e+4|0;s=e;t=c[h+4>>2]&74;if((t|0)==8){t=16}else if((t|0)==0){t=0}else if((t|0)==64){t=8}else{t=10}Ep(m,h,w,v);c[n+0>>2]=0;c[n+4>>2]=0;c[n+8>>2]=0;u=0;Na(59,n|0,10,0);E=u;u=0;a:do{if(!(E&1)){if((a[n>>0]&1)==0){B=n+1|0;y=B;h=n+8|0}else{B=n+8|0;y=n+1|0;h=B;B=c[B>>2]|0}c[r>>2]=B;c[o>>2]=p;c[s>>2]=0;x=n+4|0;z=a[v>>0]|0;v=c[f>>2]|0;b:while(1){if((v|0)!=0){if((c[v+12>>2]|0)==(c[v+16>>2]|0)){u=0;A=qa(c[(c[v>>2]|0)+36>>2]|0,v|0)|0;E=u;u=0;if(E&1){l=37;break}if((A|0)==-1){c[f>>2]=0;v=0}}}else{v=0}D=(v|0)==0;A=c[g>>2]|0;do{if((A|0)!=0){if((c[A+12>>2]|0)!=(c[A+16>>2]|0)){if(D){break}else{break b}}u=0;C=qa(c[(c[A>>2]|0)+36>>2]|0,A|0)|0;E=u;u=0;if(E&1){l=37;break b}if(!((C|0)==-1)){if(D){break}else{break b}}else{c[g>>2]=0;l=21;break}}else{l=21}}while(0);if((l|0)==21){l=0;if(D){A=0;break}else{A=0}}C=a[n>>0]|0;D=(C&1)==0;if(D){E=(C&255)>>>1}else{E=c[x>>2]|0}if(((c[r>>2]|0)-B|0)==(E|0)){if(D){B=(C&255)>>>1;C=(C&255)>>>1}else{C=c[x>>2]|0;B=C}u=0;Na(59,n|0,B<<1|0,0);E=u;u=0;if(E&1){l=37;break}if((a[n>>0]&1)==0){B=10}else{B=(c[n>>2]&-2)+ -1|0}u=0;Na(59,n|0,B|0,0);E=u;u=0;if(E&1){l=37;break}if((a[n>>0]&1)==0){B=y}else{B=c[h>>2]|0}c[r>>2]=B+C}D=v+12|0;E=c[D>>2]|0;C=v+16|0;if((E|0)==(c[C>>2]|0)){u=0;E=qa(c[(c[v>>2]|0)+36>>2]|0,v|0)|0;F=u;u=0;if(F&1){l=37;break}}else{E=d[E>>0]|0}if((ep(E&255,t,B,r,s,z,m,p,o,w)|0)!=0){break}A=c[D>>2]|0;if((A|0)==(c[C>>2]|0)){u=0;qa(c[(c[v>>2]|0)+40>>2]|0,v|0)|0;F=u;u=0;if(F&1){l=37;break}else{continue}}else{c[D>>2]=A+1;continue}}if((l|0)==37){F=qb(-1,-1)|0;Rm(n);Rm(m);vb(F|0)}w=a[m>>0]|0;if((w&1)==0){w=(w&255)>>>1}else{w=c[m+4>>2]|0}if((w|0)!=0?(q=c[o>>2]|0,(q-p|0)<160):0){F=c[s>>2]|0;c[o>>2]=q+4;c[q>>2]=F}u=0;r=Ma(14,B|0,c[r>>2]|0,j|0,t|0)|0;q=J;F=u;u=0;if(!(F&1)){F=k;c[F>>2]=r;c[F+4>>2]=q;Pr(m,p,c[o>>2]|0,j);if((v|0)!=0){if((c[v+12>>2]|0)==(c[v+16>>2]|0)){u=0;k=qa(c[(c[v>>2]|0)+36>>2]|0,v|0)|0;F=u;u=0;if(F&1){break}if((k|0)==-1){c[f>>2]=0;v=0}}}else{v=0}f=(v|0)==0;do{if((A|0)!=0){if((c[A+12>>2]|0)!=(c[A+16>>2]|0)){if(!f){break}c[b>>2]=v;Rm(n);Rm(m);i=e;return}u=0;k=qa(c[(c[A>>2]|0)+36>>2]|0,A|0)|0;F=u;u=0;if(F&1){break a}if((k|0)==-1){c[g>>2]=0;l=65;break}if(f^(A|0)==0){c[b>>2]=v;Rm(n);Rm(m);i=e;return}}else{l=65}}while(0);if((l|0)==65?!f:0){c[b>>2]=v;Rm(n);Rm(m);i=e;return}c[j>>2]=c[j>>2]|2;c[b>>2]=v;Rm(n);Rm(m);i=e;return}}}while(0);F=qb(-1,-1)|0;Rm(n);Rm(m);vb(F|0)}function Zo(a,b,d,e,f,g,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0;b=i;i=i+16|0;j=b+12|0;k=b+8|0;m=b+4|0;l=b;c[m>>2]=c[d>>2];c[l>>2]=c[e>>2];c[k+0>>2]=c[m+0>>2];c[j+0>>2]=c[l+0>>2];_o(a,0,k,j,f,g,h);i=b;return}function _o(b,e,f,h,j,k,l){b=b|0;e=e|0;f=f|0;h=h|0;j=j|0;k=k|0;l=l|0;var m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0.0,J=0;n=i;i=i+240|0;w=n+200|0;B=n+199|0;x=n+198|0;o=n+184|0;e=n+172|0;s=n+168|0;r=n+8|0;q=n+4|0;t=n;v=n+197|0;y=n+196|0;Fp(o,j,w,B,x);c[e+0>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;u=0;Na(59,e|0,10,0);H=u;u=0;a:do{if(!(H&1)){if((a[e>>0]&1)==0){E=e+1|0;j=E;z=e+8|0}else{E=e+8|0;j=e+1|0;z=E;E=c[E>>2]|0}c[s>>2]=E;c[q>>2]=r;c[t>>2]=0;a[v>>0]=1;a[y>>0]=69;A=e+4|0;B=a[B>>0]|0;C=a[x>>0]|0;x=c[f>>2]|0;b:while(1){if((x|0)!=0){if((c[x+12>>2]|0)==(c[x+16>>2]|0)){u=0;D=qa(c[(c[x>>2]|0)+36>>2]|0,x|0)|0;H=u;u=0;if(H&1){m=33;break}if((D|0)==-1){c[f>>2]=0;x=0}}}else{x=0}G=(x|0)==0;D=c[h>>2]|0;do{if((D|0)!=0){if((c[D+12>>2]|0)!=(c[D+16>>2]|0)){if(G){break}else{break b}}u=0;F=qa(c[(c[D>>2]|0)+36>>2]|0,D|0)|0;H=u;u=0;if(H&1){m=33;break b}if(!((F|0)==-1)){if(G){break}else{break b}}else{c[h>>2]=0;m=17;break}}else{m=17}}while(0);if((m|0)==17){m=0;if(G){D=0;break}else{D=0}}F=a[e>>0]|0;G=(F&1)==0;if(G){H=(F&255)>>>1}else{H=c[A>>2]|0}if(((c[s>>2]|0)-E|0)==(H|0)){if(G){E=(F&255)>>>1;F=(F&255)>>>1}else{F=c[A>>2]|0;E=F}u=0;Na(59,e|0,E<<1|0,0);H=u;u=0;if(H&1){m=33;break}if((a[e>>0]&1)==0){E=10}else{E=(c[e>>2]&-2)+ -1|0}u=0;Na(59,e|0,E|0,0);H=u;u=0;if(H&1){m=33;break}if((a[e>>0]&1)==0){E=j}else{E=c[z>>2]|0}c[s>>2]=E+F}F=x+12|0;H=c[F>>2]|0;G=x+16|0;if((H|0)==(c[G>>2]|0)){u=0;H=qa(c[(c[x>>2]|0)+36>>2]|0,x|0)|0;J=u;u=0;if(J&1){m=33;break}}else{H=d[H>>0]|0}if((Gp(H&255,v,y,E,s,B,C,o,r,q,t,w)|0)!=0){break}D=c[F>>2]|0;if((D|0)==(c[G>>2]|0)){u=0;qa(c[(c[x>>2]|0)+40>>2]|0,x|0)|0;J=u;u=0;if(J&1){m=33;break}else{continue}}else{c[F>>2]=D+1;continue}}if((m|0)==33){J=qb(-1,-1)|0;Rm(e);Rm(o);vb(J|0)}w=a[o>>0]|0;if((w&1)==0){w=(w&255)>>>1}else{w=c[o+4>>2]|0}if(((w|0)!=0?(a[v>>0]|0)!=0:0)?(p=c[q>>2]|0,(p-r|0)<160):0){J=c[t>>2]|0;c[q>>2]=p+4;c[p>>2]=J}u=0;I=+Ja(2,E|0,c[s>>2]|0,k|0);J=u;u=0;if(!(J&1)){g[l>>2]=I;Pr(o,r,c[q>>2]|0,k);if((x|0)!=0){if((c[x+12>>2]|0)==(c[x+16>>2]|0)){u=0;l=qa(c[(c[x>>2]|0)+36>>2]|0,x|0)|0;J=u;u=0;if(J&1){break}if((l|0)==-1){c[f>>2]=0;x=0}}}else{x=0}f=(x|0)==0;do{if((D|0)!=0){if((c[D+12>>2]|0)!=(c[D+16>>2]|0)){if(!f){break}c[b>>2]=x;Rm(e);Rm(o);i=n;return}u=0;l=qa(c[(c[D>>2]|0)+36>>2]|0,D|0)|0;J=u;u=0;if(J&1){break a}if((l|0)==-1){c[h>>2]=0;m=62;break}if(f^(D|0)==0){c[b>>2]=x;Rm(e);Rm(o);i=n;return}}else{m=62}}while(0);if((m|0)==62?!f:0){c[b>>2]=x;Rm(e);Rm(o);i=n;return}c[k>>2]=c[k>>2]|2;c[b>>2]=x;Rm(e);Rm(o);i=n;return}}}while(0);J=qb(-1,-1)|0;Rm(e);Rm(o);vb(J|0)}function $o(a,b,d,e,f,g,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0;b=i;i=i+16|0;j=b+12|0;k=b+8|0;m=b+4|0;l=b;c[m>>2]=c[d>>2];c[l>>2]=c[e>>2];c[k+0>>2]=c[m+0>>2];c[j+0>>2]=c[l+0>>2];ap(a,0,k,j,f,g,h);i=b;return}function ap(b,e,f,g,j,k,l){b=b|0;e=e|0;f=f|0;g=g|0;j=j|0;k=k|0;l=l|0;var m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0.0,J=0;n=i;i=i+240|0;w=n+200|0;B=n+199|0;x=n+198|0;o=n+184|0;e=n+172|0;s=n+168|0;r=n+8|0;q=n+4|0;t=n;v=n+197|0;y=n+196|0;Fp(o,j,w,B,x);c[e+0>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;u=0;Na(59,e|0,10,0);H=u;u=0;a:do{if(!(H&1)){if((a[e>>0]&1)==0){E=e+1|0;j=E;z=e+8|0}else{E=e+8|0;j=e+1|0;z=E;E=c[E>>2]|0}c[s>>2]=E;c[q>>2]=r;c[t>>2]=0;a[v>>0]=1;a[y>>0]=69;A=e+4|0;B=a[B>>0]|0;C=a[x>>0]|0;x=c[f>>2]|0;b:while(1){if((x|0)!=0){if((c[x+12>>2]|0)==(c[x+16>>2]|0)){u=0;D=qa(c[(c[x>>2]|0)+36>>2]|0,x|0)|0;H=u;u=0;if(H&1){m=33;break}if((D|0)==-1){c[f>>2]=0;x=0}}}else{x=0}G=(x|0)==0;D=c[g>>2]|0;do{if((D|0)!=0){if((c[D+12>>2]|0)!=(c[D+16>>2]|0)){if(G){break}else{break b}}u=0;F=qa(c[(c[D>>2]|0)+36>>2]|0,D|0)|0;H=u;u=0;if(H&1){m=33;break b}if(!((F|0)==-1)){if(G){break}else{break b}}else{c[g>>2]=0;m=17;break}}else{m=17}}while(0);if((m|0)==17){m=0;if(G){D=0;break}else{D=0}}F=a[e>>0]|0;G=(F&1)==0;if(G){H=(F&255)>>>1}else{H=c[A>>2]|0}if(((c[s>>2]|0)-E|0)==(H|0)){if(G){E=(F&255)>>>1;F=(F&255)>>>1}else{F=c[A>>2]|0;E=F}u=0;Na(59,e|0,E<<1|0,0);H=u;u=0;if(H&1){m=33;break}if((a[e>>0]&1)==0){E=10}else{E=(c[e>>2]&-2)+ -1|0}u=0;Na(59,e|0,E|0,0);H=u;u=0;if(H&1){m=33;break}if((a[e>>0]&1)==0){E=j}else{E=c[z>>2]|0}c[s>>2]=E+F}F=x+12|0;H=c[F>>2]|0;G=x+16|0;if((H|0)==(c[G>>2]|0)){u=0;H=qa(c[(c[x>>2]|0)+36>>2]|0,x|0)|0;J=u;u=0;if(J&1){m=33;break}}else{H=d[H>>0]|0}if((Gp(H&255,v,y,E,s,B,C,o,r,q,t,w)|0)!=0){break}D=c[F>>2]|0;if((D|0)==(c[G>>2]|0)){u=0;qa(c[(c[x>>2]|0)+40>>2]|0,x|0)|0;J=u;u=0;if(J&1){m=33;break}else{continue}}else{c[F>>2]=D+1;continue}}if((m|0)==33){J=qb(-1,-1)|0;Rm(e);Rm(o);vb(J|0)}w=a[o>>0]|0;if((w&1)==0){w=(w&255)>>>1}else{w=c[o+4>>2]|0}if(((w|0)!=0?(a[v>>0]|0)!=0:0)?(p=c[q>>2]|0,(p-r|0)<160):0){J=c[t>>2]|0;c[q>>2]=p+4;c[p>>2]=J}u=0;I=+Ja(3,E|0,c[s>>2]|0,k|0);J=u;u=0;if(!(J&1)){h[l>>3]=I;Pr(o,r,c[q>>2]|0,k);if((x|0)!=0){if((c[x+12>>2]|0)==(c[x+16>>2]|0)){u=0;l=qa(c[(c[x>>2]|0)+36>>2]|0,x|0)|0;J=u;u=0;if(J&1){break}if((l|0)==-1){c[f>>2]=0;x=0}}}else{x=0}f=(x|0)==0;do{if((D|0)!=0){if((c[D+12>>2]|0)!=(c[D+16>>2]|0)){if(!f){break}c[b>>2]=x;Rm(e);Rm(o);i=n;return}u=0;l=qa(c[(c[D>>2]|0)+36>>2]|0,D|0)|0;J=u;u=0;if(J&1){break a}if((l|0)==-1){c[g>>2]=0;m=62;break}if(f^(D|0)==0){c[b>>2]=x;Rm(e);Rm(o);i=n;return}}else{m=62}}while(0);if((m|0)==62?!f:0){c[b>>2]=x;Rm(e);Rm(o);i=n;return}c[k>>2]=c[k>>2]|2;c[b>>2]=x;Rm(e);Rm(o);i=n;return}}}while(0);J=qb(-1,-1)|0;Rm(e);Rm(o);vb(J|0)}function bp(a,b,d,e,f,g,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0;b=i;i=i+16|0;j=b+12|0;k=b+8|0;m=b+4|0;l=b;c[m>>2]=c[d>>2];c[l>>2]=c[e>>2];c[k+0>>2]=c[m+0>>2];c[j+0>>2]=c[l+0>>2];cp(a,0,k,j,f,g,h);i=b;return}function cp(b,e,f,g,j,k,l){b=b|0;e=e|0;f=f|0;g=g|0;j=j|0;k=k|0;l=l|0;var m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0.0,J=0;n=i;i=i+240|0;w=n+200|0;B=n+199|0;x=n+198|0;o=n+184|0;e=n+172|0;s=n+168|0;r=n+8|0;q=n+4|0;t=n;v=n+197|0;y=n+196|0;Fp(o,j,w,B,x);c[e+0>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;u=0;Na(59,e|0,10,0);H=u;u=0;a:do{if(!(H&1)){if((a[e>>0]&1)==0){E=e+1|0;j=E;z=e+8|0}else{E=e+8|0;j=e+1|0;z=E;E=c[E>>2]|0}c[s>>2]=E;c[q>>2]=r;c[t>>2]=0;a[v>>0]=1;a[y>>0]=69;A=e+4|0;B=a[B>>0]|0;C=a[x>>0]|0;x=c[f>>2]|0;b:while(1){if((x|0)!=0){if((c[x+12>>2]|0)==(c[x+16>>2]|0)){u=0;D=qa(c[(c[x>>2]|0)+36>>2]|0,x|0)|0;H=u;u=0;if(H&1){m=33;break}if((D|0)==-1){c[f>>2]=0;x=0}}}else{x=0}G=(x|0)==0;D=c[g>>2]|0;do{if((D|0)!=0){if((c[D+12>>2]|0)!=(c[D+16>>2]|0)){if(G){break}else{break b}}u=0;F=qa(c[(c[D>>2]|0)+36>>2]|0,D|0)|0;H=u;u=0;if(H&1){m=33;break b}if(!((F|0)==-1)){if(G){break}else{break b}}else{c[g>>2]=0;m=17;break}}else{m=17}}while(0);if((m|0)==17){m=0;if(G){D=0;break}else{D=0}}F=a[e>>0]|0;G=(F&1)==0;if(G){H=(F&255)>>>1}else{H=c[A>>2]|0}if(((c[s>>2]|0)-E|0)==(H|0)){if(G){E=(F&255)>>>1;F=(F&255)>>>1}else{F=c[A>>2]|0;E=F}u=0;Na(59,e|0,E<<1|0,0);H=u;u=0;if(H&1){m=33;break}if((a[e>>0]&1)==0){E=10}else{E=(c[e>>2]&-2)+ -1|0}u=0;Na(59,e|0,E|0,0);H=u;u=0;if(H&1){m=33;break}if((a[e>>0]&1)==0){E=j}else{E=c[z>>2]|0}c[s>>2]=E+F}F=x+12|0;H=c[F>>2]|0;G=x+16|0;if((H|0)==(c[G>>2]|0)){u=0;H=qa(c[(c[x>>2]|0)+36>>2]|0,x|0)|0;J=u;u=0;if(J&1){m=33;break}}else{H=d[H>>0]|0}if((Gp(H&255,v,y,E,s,B,C,o,r,q,t,w)|0)!=0){break}D=c[F>>2]|0;if((D|0)==(c[G>>2]|0)){u=0;qa(c[(c[x>>2]|0)+40>>2]|0,x|0)|0;J=u;u=0;if(J&1){m=33;break}else{continue}}else{c[F>>2]=D+1;continue}}if((m|0)==33){J=qb(-1,-1)|0;Rm(e);Rm(o);vb(J|0)}w=a[o>>0]|0;if((w&1)==0){w=(w&255)>>>1}else{w=c[o+4>>2]|0}if(((w|0)!=0?(a[v>>0]|0)!=0:0)?(p=c[q>>2]|0,(p-r|0)<160):0){J=c[t>>2]|0;c[q>>2]=p+4;c[p>>2]=J}u=0;I=+Ja(4,E|0,c[s>>2]|0,k|0);J=u;u=0;if(!(J&1)){h[l>>3]=I;Pr(o,r,c[q>>2]|0,k);if((x|0)!=0){if((c[x+12>>2]|0)==(c[x+16>>2]|0)){u=0;l=qa(c[(c[x>>2]|0)+36>>2]|0,x|0)|0;J=u;u=0;if(J&1){break}if((l|0)==-1){c[f>>2]=0;x=0}}}else{x=0}f=(x|0)==0;do{if((D|0)!=0){if((c[D+12>>2]|0)!=(c[D+16>>2]|0)){if(!f){break}c[b>>2]=x;Rm(e);Rm(o);i=n;return}u=0;l=qa(c[(c[D>>2]|0)+36>>2]|0,D|0)|0;J=u;u=0;if(J&1){break a}if((l|0)==-1){c[g>>2]=0;m=62;break}if(f^(D|0)==0){c[b>>2]=x;Rm(e);Rm(o);i=n;return}}else{m=62}}while(0);if((m|0)==62?!f:0){c[b>>2]=x;Rm(e);Rm(o);i=n;return}c[k>>2]=c[k>>2]|2;c[b>>2]=x;Rm(e);Rm(o);i=n;return}}}while(0);J=qb(-1,-1)|0;Rm(e);Rm(o);vb(J|0)}function dp(b,e,f,g,h,j,k){b=b|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;var l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0;n=i;i=i+240|0;o=n;p=n+204|0;e=n+192|0;r=n+188|0;m=n+176|0;z=n+16|0;c[e+0>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;u=0;oa(84,r|0,h|0);G=u;u=0;if(G&1){G=qb(-1,-1)|0;Rm(e);vb(G|0)}h=c[r>>2]|0;if(!(!((c[4088]|0)==-1)?(c[o>>2]=16352,c[o+4>>2]=205,c[o+8>>2]=0,u=0,Na(58,16352,o|0,206),G=u,u=0,G&1):0)){l=4}do{if((l|0)==4){s=(c[16356>>2]|0)+ -1|0;t=c[h+8>>2]|0;if((c[h+12>>2]|0)-t>>2>>>0>s>>>0?(q=c[t+(s<<2)>>2]|0,(q|0)!=0):0){u=0;Ma(c[(c[q>>2]|0)+32>>2]|0,q|0,14896,14922|0,p|0)|0;G=u;u=0;if(G&1){break}qm(c[r>>2]|0)|0;c[m+0>>2]=0;c[m+4>>2]=0;c[m+8>>2]=0;u=0;Na(59,m|0,10,0);G=u;u=0;a:do{if(!(G&1)){if((a[m>>0]&1)==0){B=m+1|0;w=B;x=m+8|0}else{B=m+8|0;w=m+1|0;x=B;B=c[B>>2]|0}v=m+4|0;q=p+24|0;t=p+25|0;s=z;r=p+26|0;h=p;y=e+4|0;D=c[f>>2]|0;A=z;z=0;C=B;b:while(1){if((D|0)!=0){if((c[D+12>>2]|0)==(c[D+16>>2]|0)){u=0;E=qa(c[(c[D>>2]|0)+36>>2]|0,D|0)|0;G=u;u=0;if(G&1){l=43;break}if((E|0)==-1){c[f>>2]=0;D=0}}}else{D=0}E=(D|0)==0;F=c[g>>2]|0;do{if((F|0)!=0){if((c[F+12>>2]|0)!=(c[F+16>>2]|0)){if(E){break}else{break b}}u=0;F=qa(c[(c[F>>2]|0)+36>>2]|0,F|0)|0;G=u;u=0;if(G&1){l=43;break b}if(!((F|0)==-1)){if(E){break}else{break b}}else{c[g>>2]=0;l=25;break}}else{l=25}}while(0);if((l|0)==25?(l=0,E):0){break}E=a[m>>0]|0;F=(E&1)==0;if(F){G=(E&255)>>>1}else{G=c[v>>2]|0}if((C-B|0)==(G|0)){if(F){C=(E&255)>>>1;B=(E&255)>>>1}else{B=c[v>>2]|0;C=B}u=0;Na(59,m|0,B<<1|0,0);G=u;u=0;if(G&1){l=43;break}if((a[m>>0]&1)==0){B=10}else{B=(c[m>>2]&-2)+ -1|0}u=0;Na(59,m|0,B|0,0);G=u;u=0;if(G&1){l=43;break}if((a[m>>0]&1)==0){B=w}else{B=c[x>>2]|0}C=B+C|0}E=c[D+12>>2]|0;if((E|0)==(c[D+16>>2]|0)){u=0;D=qa(c[(c[D>>2]|0)+36>>2]|0,D|0)|0;G=u;u=0;if(G&1){l=43;break}}else{D=d[E>>0]|0}E=D&255;D=(C|0)==(B|0);do{if(D){F=(a[q>>0]|0)==E<<24>>24;if(!F?!((a[t>>0]|0)==E<<24>>24):0){l=53;break}a[C>>0]=F?43:45;C=C+1|0;z=0}else{l=53}}while(0);do{if((l|0)==53){l=0;F=a[e>>0]|0;if((F&1)==0){F=(F&255)>>>1}else{F=c[y>>2]|0}if((F|0)!=0&E<<24>>24==0){if((A-s|0)>=160){break}c[A>>2]=z;A=A+4|0;z=0;break}else{F=p}while(1){if((a[F>>0]|0)==E<<24>>24){break}F=F+1|0;if((F|0)==(r|0)){F=r;break}}E=F-h|0;if((E|0)>23){break b}if((E|0)<22){a[C>>0]=a[14896+E>>0]|0;C=C+1|0;z=z+1|0;break}if(D){B=C;break b}if((C-B|0)>=3){break b}if((a[C+ -1>>0]|0)!=48){break b}a[C>>0]=a[14896+E>>0]|0;C=C+1|0;z=0}}while(0);D=c[f>>2]|0;E=D+12|0;F=c[E>>2]|0;if((F|0)==(c[D+16>>2]|0)){u=0;qa(c[(c[D>>2]|0)+40>>2]|0,D|0)|0;G=u;u=0;if(G&1){l=43;break}else{continue}}else{c[E>>2]=F+1;continue}}if((l|0)==43){b=qb(-1,-1)|0;break}a[B+3>>0]=0;do{if((a[16248]|0)==0?(Ua(16248)|0)!=0:0){u=0;p=ua(33,2147483647,16256,0)|0;G=u;u=0;if(G&1){b=qb(-1,-1)|0;Eb(16248);break a}else{c[4060]=p;rb(16248);break}}}while(0);G=c[4060]|0;u=0;c[o>>2]=k;k=Ma(15,B|0,G|0,14936,o|0)|0;G=u;u=0;if(!(G&1)){if((k|0)!=1){c[j>>2]=4}p=c[f>>2]|0;if((p|0)!=0){if((c[p+12>>2]|0)==(c[p+16>>2]|0)){u=0;k=qa(c[(c[p>>2]|0)+36>>2]|0,p|0)|0;G=u;u=0;if(G&1){l=44;break}if((k|0)==-1){c[f>>2]=0;p=0}}}else{p=0}k=(p|0)==0;o=c[g>>2]|0;do{if((o|0)!=0){if((c[o+12>>2]|0)!=(c[o+16>>2]|0)){if(!k){break}c[b>>2]=p;Rm(m);Rm(e);i=n;return}u=0;f=qa(c[(c[o>>2]|0)+36>>2]|0,o|0)|0;G=u;u=0;if(G&1){l=44;break a}if((f|0)==-1){c[g>>2]=0;l=90;break}if(k^(o|0)==0){c[b>>2]=p;Rm(m);Rm(e);i=n;return}}else{l=90}}while(0);if((l|0)==90?!k:0){c[b>>2]=p;Rm(m);Rm(e);i=n;return}c[j>>2]=c[j>>2]|2;c[b>>2]=p;Rm(m);Rm(e);i=n;return}else{l=44}}else{l=44}}while(0);if((l|0)==44){b=qb(-1,-1)|0}Rm(m);G=b;Rm(e);vb(G|0)}G=Jb(4)|0;bv(G);u=0;Na(45,G|0,24312,171);G=u;u=0}}while(0);G=qb(-1,-1)|0;qm(c[r>>2]|0)|0;Rm(e);vb(G|0)}function ep(b,d,e,f,g,h,j,k,l,m){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;l=l|0;m=m|0;var n=0,o=0,p=0,q=0;n=i;p=c[f>>2]|0;o=(p|0)==(e|0);do{if(o){q=(a[m+24>>0]|0)==b<<24>>24;if(!q?!((a[m+25>>0]|0)==b<<24>>24):0){break}c[f>>2]=e+1;a[e>>0]=q?43:45;c[g>>2]=0;q=0;i=n;return q|0}}while(0);q=a[j>>0]|0;if((q&1)==0){j=(q&255)>>>1}else{j=c[j+4>>2]|0}if((j|0)!=0?b<<24>>24==h<<24>>24:0){o=c[l>>2]|0;if((o-k|0)>=160){q=0;i=n;return q|0}q=c[g>>2]|0;c[l>>2]=o+4;c[o>>2]=q;c[g>>2]=0;q=0;i=n;return q|0}l=m+26|0;k=m;while(1){if((a[k>>0]|0)==b<<24>>24){break}k=k+1|0;if((k|0)==(l|0)){k=l;break}}m=k-m|0;if((m|0)>23){q=-1;i=n;return q|0}if((d|0)==16){if((m|0)>=22){if(o){q=-1;i=n;return q|0}if((p-e|0)>=3){q=-1;i=n;return q|0}if((a[p+ -1>>0]|0)!=48){q=-1;i=n;return q|0}c[g>>2]=0;q=a[14896+m>>0]|0;c[f>>2]=p+1;a[p>>0]=q;q=0;i=n;return q|0}}else if((d|0)==10|(d|0)==8?(m|0)>=(d|0):0){q=-1;i=n;return q|0}q=a[14896+m>>0]|0;c[f>>2]=p+1;a[p>>0]=q;c[g>>2]=(c[g>>2]|0)+1;q=0;i=n;return q|0}function fp(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0;f=i;i=i+16|0;g=f;c[g>>2]=e;b=Nb(b|0)|0;d=Wu(a,d,g)|0;if((b|0)==0){i=f;return d|0}u=0;qa(127,b|0)|0;g=u;u=0;if(g&1){g=qb(-1,-1,0)|0;jd(g)}else{i=f;return d|0}return 0}function gp(a){a=a|0;var b=0;b=i;Hv(a);i=b;return}function hp(a){a=a|0;return}function ip(b,d,e,f,g,h,j){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0;l=i;i=i+80|0;n=l+16|0;s=l;t=l+76|0;w=l+72|0;x=l+68|0;v=l+64|0;r=l+60|0;q=l+56|0;k=l+32|0;o=l+28|0;if((c[g+4>>2]&1|0)==0){c[t>>2]=-1;k=c[(c[d>>2]|0)+16>>2]|0;c[x>>2]=c[e>>2];c[v>>2]=c[f>>2];c[s+0>>2]=c[x+0>>2];c[n+0>>2]=c[v+0>>2];Oc[k&63](w,d,s,n,g,h,t);k=c[w>>2]|0;c[e>>2]=k;e=c[t>>2]|0;if((e|0)==0){a[j>>0]=0}else if((e|0)==1){a[j>>0]=1}else{a[j>>0]=1;c[h>>2]=4}c[b>>2]=k;i=l;return}ln(r,g);t=c[r>>2]|0;if(!(!((c[4086]|0)==-1)?(c[s>>2]=16344,c[s+4>>2]=205,c[s+8>>2]=0,u=0,Na(58,16344,s|0,206),x=u,u=0,x&1):0)){s=(c[16348>>2]|0)+ -1|0;d=c[t+8>>2]|0;if((c[t+12>>2]|0)-d>>2>>>0>s>>>0?(m=c[d+(s<<2)>>2]|0,(m|0)!=0):0){qm(c[r>>2]|0)|0;ln(q,g);r=c[q>>2]|0;if(!(!((c[4126]|0)==-1)?(c[n>>2]=16504,c[n+4>>2]=205,c[n+8>>2]=0,u=0,Na(58,16504,n|0,206),x=u,u=0,x&1):0)){g=(c[16508>>2]|0)+ -1|0;s=c[r+8>>2]|0;if((c[r+12>>2]|0)-s>>2>>>0>g>>>0?(p=c[s+(g<<2)>>2]|0,(p|0)!=0):0){qm(c[q>>2]|0)|0;u=0;oa(c[(c[p>>2]|0)+24>>2]|0,k|0,p|0);x=u;u=0;if(!(x&1)){q=k+12|0;u=0;oa(c[(c[p>>2]|0)+28>>2]|0,q|0,p|0);x=u;u=0;if(!(x&1)){c[o>>2]=c[f>>2];x=k+24|0;u=0;c[n+0>>2]=c[o+0>>2];h=la(2,e|0,n|0,k|0,x|0,m|0,h|0,1)|0;x=u;u=0;if(x&1){x=qb(-1,-1)|0;bn(k+12|0);bn(k);vb(x|0)}else{a[j>>0]=(h|0)==(k|0)&1;c[b>>2]=c[e>>2];bn(k+12|0);bn(k);i=l;return}}}else{q=k}b=qb(-1,-1)|0;j=J;if((k|0)==(q|0)){x=b;vb(x|0)}do{q=q+ -12|0;bn(q)}while((q|0)!=(k|0));vb(b|0)}x=Jb(4)|0;bv(x);u=0;Na(45,x|0,24312,171);x=u;u=0}x=qb(-1,-1)|0;qm(c[q>>2]|0)|0;vb(x|0)}x=Jb(4)|0;bv(x);u=0;Na(45,x|0,24312,171);x=u;u=0}x=qb(-1,-1)|0;qm(c[r>>2]|0)|0;vb(x|0)}function jp(b,d,e,f,g,h,j){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0;l=i;i=i+112|0;m=l;s=(f-e|0)/12|0;if(s>>>0>100){m=Av(s)|0;if((m|0)==0){u=0;Oa(4);z=u;u=0;if(z&1){z=qb(-1,-1)|0;vb(z|0)}else{k=0;m=0}}else{k=m}}else{k=0}n=(e|0)==(f|0);if(n){r=0}else{o=e;r=0;p=m;while(1){q=a[o>>0]|0;if((q&1)==0){q=(q&255)>>>1}else{q=c[o+4>>2]|0}if((q|0)==0){a[p>>0]=2;r=r+1|0;s=s+ -1|0}else{a[p>>0]=1}o=o+12|0;if((o|0)==(f|0)){break}else{p=p+1|0}}}o=0;a:while(1){p=c[b>>2]|0;do{if((p|0)!=0){q=c[p+12>>2]|0;if((q|0)==(c[p+16>>2]|0)){u=0;p=qa(c[(c[p>>2]|0)+36>>2]|0,p|0)|0;z=u;u=0;if(z&1){g=6;break a}}else{p=c[q>>2]|0}if((p|0)==-1){c[b>>2]=0;q=1;break}else{q=(c[b>>2]|0)==0;break}}else{q=1}}while(0);p=c[d>>2]|0;if((p|0)!=0){t=c[p+12>>2]|0;if((t|0)==(c[p+16>>2]|0)){u=0;t=qa(c[(c[p>>2]|0)+36>>2]|0,p|0)|0;z=u;u=0;if(z&1){g=6;break}}else{t=c[t>>2]|0}if((t|0)==-1){c[d>>2]=0;p=0;v=1}else{v=0}}else{p=0;v=1}t=c[b>>2]|0;if(!((q^v)&(s|0)!=0)){g=81;break}p=c[t+12>>2]|0;if((p|0)==(c[t+16>>2]|0)){u=0;q=qa(c[(c[t>>2]|0)+36>>2]|0,t|0)|0;z=u;u=0;if(z&1){g=6;break}}else{q=c[p>>2]|0}if(!j){u=0;q=Ha(c[(c[g>>2]|0)+28>>2]|0,g|0,q|0)|0;z=u;u=0;if(z&1){g=6;break}}p=o+1|0;if(n){o=p;continue}b:do{if(j){w=0;t=e;v=m;while(1){do{if((a[v>>0]|0)==1){z=a[t>>0]|0;y=(z&1)==0;if(y){x=t+4|0}else{x=c[t+8>>2]|0}if((q|0)!=(c[x+(o<<2)>>2]|0)){a[v>>0]=0;s=s+ -1|0;break}if(y){w=(z&255)>>>1}else{w=c[t+4>>2]|0}if((w|0)==(p|0)){a[v>>0]=2;w=1;r=r+1|0;s=s+ -1|0}else{w=1}}}while(0);t=t+12|0;if((t|0)==(f|0)){break b}v=v+1|0}}else{w=0;t=e;v=m;while(1){do{if((a[v>>0]|0)==1){if((a[t>>0]&1)==0){x=t+4|0}else{x=c[t+8>>2]|0}u=0;x=Ha(c[(c[g>>2]|0)+28>>2]|0,g|0,c[x+(o<<2)>>2]|0)|0;z=u;u=0;if(z&1){g=5;break a}if((q|0)!=(x|0)){a[v>>0]=0;s=s+ -1|0;break}w=a[t>>0]|0;if((w&1)==0){w=(w&255)>>>1}else{w=c[t+4>>2]|0}if((w|0)==(p|0)){a[v>>0]=2;w=1;r=r+1|0;s=s+ -1|0}else{w=1}}}while(0);t=t+12|0;if((t|0)==(f|0)){break b}v=v+1|0}}}while(0);if(!w){o=p;continue}t=c[b>>2]|0;q=t+12|0;o=c[q>>2]|0;if((o|0)==(c[t+16>>2]|0)){u=0;qa(c[(c[t>>2]|0)+40>>2]|0,t|0)|0;z=u;u=0;if(z&1){g=6;break}}else{c[q>>2]=o+4}if((s+r|0)>>>0<2){o=p;continue}else{o=e;q=m}while(1){if((a[q>>0]|0)==2){t=a[o>>0]|0;if((t&1)==0){t=(t&255)>>>1}else{t=c[o+4>>2]|0}if((t|0)!=(p|0)){a[q>>0]=0;r=r+ -1|0}}o=o+12|0;if((o|0)==(f|0)){o=p;continue a}else{q=q+1|0}}}if((g|0)==5){l=qb(-1,-1)|0}else if((g|0)==6){l=qb(-1,-1)|0}else if((g|0)==81){do{if((t|0)!=0){j=c[t+12>>2]|0;if((j|0)==(c[t+16>>2]|0)){u=0;j=qa(c[(c[t>>2]|0)+36>>2]|0,t|0)|0;z=u;u=0;if(z&1){break}}else{j=c[j>>2]|0}if((j|0)==-1){c[b>>2]=0;b=1;g=88;break}else{b=(c[b>>2]|0)==0;g=88;break}}else{b=1;g=88}}while(0);c:do{if((g|0)==88){do{if((p|0)!=0){j=c[p+12>>2]|0;if((j|0)==(c[p+16>>2]|0)){u=0;j=qa(c[(c[p>>2]|0)+36>>2]|0,p|0)|0;z=u;u=0;if(z&1){break c}}else{j=c[j>>2]|0}if(!((j|0)==-1)){if(b){break}else{g=96;break}}else{c[d>>2]=0;g=94;break}}else{g=94}}while(0);if((g|0)==94?b:0){g=96}if((g|0)==96){c[h>>2]=c[h>>2]|2}d:do{if(!n){if((a[m>>0]|0)==2){f=e}else{while(1){e=e+12|0;m=m+1|0;if((e|0)==(f|0)){g=101;break d}if((a[m>>0]|0)==2){f=e;break}}}}else{g=101}}while(0);if((g|0)==101){c[h>>2]=c[h>>2]|4}if((k|0)==0){i=l;return f|0}u=0;na(207,k|0);z=u;u=0;if(z&1){z=qb(-1,-1,0)|0;jd(z)}else{i=l;return f|0}}}while(0);l=qb(-1,-1)|0}if((k|0)==0){z=l;vb(z|0)}u=0;na(207,k|0);z=u;u=0;if(z&1){z=qb(-1,-1,0)|0;jd(z)}else{z=l;vb(z|0)}return 0}function kp(a,b,d,e,f,g,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0;b=i;i=i+16|0;j=b+12|0;k=b+8|0;m=b+4|0;l=b;c[m>>2]=c[d>>2];c[l>>2]=c[e>>2];c[k+0>>2]=c[m+0>>2];c[j+0>>2]=c[l+0>>2];lp(a,0,k,j,f,g,h);i=b;return}function lp(b,d,e,f,g,h,j){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0;m=i;i=i+304|0;v=m+200|0;t=m+196|0;d=m+184|0;l=m+172|0;r=m+168|0;p=m+8|0;o=m+4|0;q=m;s=c[g+4>>2]&74;if((s|0)==64){s=8}else if((s|0)==0){s=0}else if((s|0)==8){s=16}else{s=10}Hp(d,g,v,t);c[l+0>>2]=0;c[l+4>>2]=0;c[l+8>>2]=0;u=0;Na(59,l|0,10,0);D=u;u=0;a:do{if(!(D&1)){if((a[l>>0]&1)==0){A=l+1|0;g=A;x=l+8|0}else{A=l+8|0;g=l+1|0;x=A;A=c[A>>2]|0}c[r>>2]=A;c[o>>2]=p;c[q>>2]=0;w=l+4|0;y=c[t>>2]|0;t=c[e>>2]|0;b:while(1){if((t|0)!=0){z=c[t+12>>2]|0;if((z|0)==(c[t+16>>2]|0)){u=0;z=qa(c[(c[t>>2]|0)+36>>2]|0,t|0)|0;D=u;u=0;if(D&1){k=38;break}}else{z=c[z>>2]|0}if((z|0)==-1){c[e>>2]=0;B=1;t=0}else{B=0}}else{B=1;t=0}z=c[f>>2]|0;do{if((z|0)!=0){C=c[z+12>>2]|0;if((C|0)==(c[z+16>>2]|0)){u=0;C=qa(c[(c[z>>2]|0)+36>>2]|0,z|0)|0;D=u;u=0;if(D&1){k=38;break b}}else{C=c[C>>2]|0}if(!((C|0)==-1)){if(B){break}else{break b}}else{c[f>>2]=0;k=22;break}}else{k=22}}while(0);if((k|0)==22){k=0;if(B){z=0;break}else{z=0}}B=a[l>>0]|0;D=(B&1)==0;if(D){C=(B&255)>>>1}else{C=c[w>>2]|0}if(((c[r>>2]|0)-A|0)==(C|0)){if(D){A=(B&255)>>>1;B=(B&255)>>>1}else{B=c[w>>2]|0;A=B}u=0;Na(59,l|0,A<<1|0,0);D=u;u=0;if(D&1){k=38;break}if((a[l>>0]&1)==0){A=10}else{A=(c[l>>2]&-2)+ -1|0}u=0;Na(59,l|0,A|0,0);D=u;u=0;if(D&1){k=38;break}if((a[l>>0]&1)==0){A=g}else{A=c[x>>2]|0}c[r>>2]=A+B}B=t+12|0;D=c[B>>2]|0;C=t+16|0;if((D|0)==(c[C>>2]|0)){u=0;D=qa(c[(c[t>>2]|0)+36>>2]|0,t|0)|0;E=u;u=0;if(E&1){k=38;break}}else{D=c[D>>2]|0}if((Dp(D,s,A,r,q,y,d,p,o,v)|0)!=0){break}z=c[B>>2]|0;if((z|0)==(c[C>>2]|0)){u=0;qa(c[(c[t>>2]|0)+40>>2]|0,t|0)|0;E=u;u=0;if(E&1){k=38;break}else{continue}}else{c[B>>2]=z+4;continue}}if((k|0)==38){E=qb(-1,-1)|0;Rm(l);Rm(d);vb(E|0)}v=a[d>>0]|0;if((v&1)==0){v=(v&255)>>>1}else{v=c[d+4>>2]|0}if((v|0)!=0?(n=c[o>>2]|0,(n-p|0)<160):0){E=c[q>>2]|0;c[o>>2]=n+4;c[n>>2]=E}u=0;n=Ma(9,A|0,c[r>>2]|0,h|0,s|0)|0;E=u;u=0;if(!(E&1)){c[j>>2]=n;Pr(d,p,c[o>>2]|0,h);if((t|0)!=0){j=c[t+12>>2]|0;if((j|0)==(c[t+16>>2]|0)){u=0;j=qa(c[(c[t>>2]|0)+36>>2]|0,t|0)|0;E=u;u=0;if(E&1){break}}else{j=c[j>>2]|0}if((j|0)==-1){c[e>>2]=0;t=0;e=1}else{e=0}}else{t=0;e=1}do{if((z|0)!=0){j=c[z+12>>2]|0;if((j|0)==(c[z+16>>2]|0)){u=0;j=qa(c[(c[z>>2]|0)+36>>2]|0,z|0)|0;E=u;u=0;if(E&1){break a}}else{j=c[j>>2]|0}if((j|0)==-1){c[f>>2]=0;k=67;break}if(e){c[b>>2]=t;Rm(l);Rm(d);i=m;return}}else{k=67}}while(0);if((k|0)==67?!e:0){c[b>>2]=t;Rm(l);Rm(d);i=m;return}c[h>>2]=c[h>>2]|2;c[b>>2]=t;Rm(l);Rm(d);i=m;return}}}while(0);E=qb(-1,-1)|0;Rm(l);Rm(d);vb(E|0)}function mp(a,b,d,e,f,g,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0;b=i;i=i+16|0;j=b+12|0;k=b+8|0;m=b+4|0;l=b;c[m>>2]=c[d>>2];c[l>>2]=c[e>>2];c[k+0>>2]=c[m+0>>2];c[j+0>>2]=c[l+0>>2];np(a,0,k,j,f,g,h);i=b;return}function np(b,d,e,f,g,h,j){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0;m=i;i=i+304|0;v=m+200|0;t=m+196|0;d=m+184|0;l=m+172|0;r=m+168|0;o=m+8|0;n=m+4|0;q=m;s=c[g+4>>2]&74;if((s|0)==0){s=0}else if((s|0)==8){s=16}else if((s|0)==64){s=8}else{s=10}Hp(d,g,v,t);c[l+0>>2]=0;c[l+4>>2]=0;c[l+8>>2]=0;u=0;Na(59,l|0,10,0);D=u;u=0;a:do{if(!(D&1)){if((a[l>>0]&1)==0){A=l+1|0;x=A;g=l+8|0}else{A=l+8|0;x=l+1|0;g=A;A=c[A>>2]|0}c[r>>2]=A;c[n>>2]=o;c[q>>2]=0;w=l+4|0;y=c[t>>2]|0;t=c[e>>2]|0;b:while(1){if((t|0)!=0){z=c[t+12>>2]|0;if((z|0)==(c[t+16>>2]|0)){u=0;z=qa(c[(c[t>>2]|0)+36>>2]|0,t|0)|0;D=u;u=0;if(D&1){k=38;break}}else{z=c[z>>2]|0}if((z|0)==-1){c[e>>2]=0;B=1;t=0}else{B=0}}else{B=1;t=0}z=c[f>>2]|0;do{if((z|0)!=0){C=c[z+12>>2]|0;if((C|0)==(c[z+16>>2]|0)){u=0;C=qa(c[(c[z>>2]|0)+36>>2]|0,z|0)|0;D=u;u=0;if(D&1){k=38;break b}}else{C=c[C>>2]|0}if(!((C|0)==-1)){if(B){break}else{break b}}else{c[f>>2]=0;k=22;break}}else{k=22}}while(0);if((k|0)==22){k=0;if(B){z=0;break}else{z=0}}B=a[l>>0]|0;D=(B&1)==0;if(D){C=(B&255)>>>1}else{C=c[w>>2]|0}if(((c[r>>2]|0)-A|0)==(C|0)){if(D){A=(B&255)>>>1;B=(B&255)>>>1}else{B=c[w>>2]|0;A=B}u=0;Na(59,l|0,A<<1|0,0);D=u;u=0;if(D&1){k=38;break}if((a[l>>0]&1)==0){A=10}else{A=(c[l>>2]&-2)+ -1|0}u=0;Na(59,l|0,A|0,0);D=u;u=0;if(D&1){k=38;break}if((a[l>>0]&1)==0){A=x}else{A=c[g>>2]|0}c[r>>2]=A+B}C=t+12|0;D=c[C>>2]|0;B=t+16|0;if((D|0)==(c[B>>2]|0)){u=0;D=qa(c[(c[t>>2]|0)+36>>2]|0,t|0)|0;E=u;u=0;if(E&1){k=38;break}}else{D=c[D>>2]|0}if((Dp(D,s,A,r,q,y,d,o,n,v)|0)!=0){break}z=c[C>>2]|0;if((z|0)==(c[B>>2]|0)){u=0;qa(c[(c[t>>2]|0)+40>>2]|0,t|0)|0;E=u;u=0;if(E&1){k=38;break}else{continue}}else{c[C>>2]=z+4;continue}}if((k|0)==38){E=qb(-1,-1)|0;Rm(l);Rm(d);vb(E|0)}v=a[d>>0]|0;if((v&1)==0){v=(v&255)>>>1}else{v=c[d+4>>2]|0}if((v|0)!=0?(p=c[n>>2]|0,(p-o|0)<160):0){E=c[q>>2]|0;c[n>>2]=p+4;c[p>>2]=E}u=0;q=Ma(10,A|0,c[r>>2]|0,h|0,s|0)|0;p=J;E=u;u=0;if(!(E&1)){E=j;c[E>>2]=q;c[E+4>>2]=p;Pr(d,o,c[n>>2]|0,h);if((t|0)!=0){j=c[t+12>>2]|0;if((j|0)==(c[t+16>>2]|0)){u=0;j=qa(c[(c[t>>2]|0)+36>>2]|0,t|0)|0;E=u;u=0;if(E&1){break}}else{j=c[j>>2]|0}if((j|0)==-1){c[e>>2]=0;t=0;e=1}else{e=0}}else{t=0;e=1}do{if((z|0)!=0){j=c[z+12>>2]|0;if((j|0)==(c[z+16>>2]|0)){u=0;j=qa(c[(c[z>>2]|0)+36>>2]|0,z|0)|0;E=u;u=0;if(E&1){break a}}else{j=c[j>>2]|0}if((j|0)==-1){c[f>>2]=0;k=67;break}if(e){c[b>>2]=t;Rm(l);Rm(d);i=m;return}}else{k=67}}while(0);if((k|0)==67?!e:0){c[b>>2]=t;Rm(l);Rm(d);i=m;return}c[h>>2]=c[h>>2]|2;c[b>>2]=t;Rm(l);Rm(d);i=m;return}}}while(0);E=qb(-1,-1)|0;Rm(l);Rm(d);vb(E|0)}function op(a,b,d,e,f,g,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0;b=i;i=i+16|0;j=b+12|0;k=b+8|0;m=b+4|0;l=b;c[m>>2]=c[d>>2];c[l>>2]=c[e>>2];c[k+0>>2]=c[m+0>>2];c[j+0>>2]=c[l+0>>2];pp(a,0,k,j,f,g,h);i=b;return}function pp(d,e,f,g,h,j,k){d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;var l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0;n=i;i=i+304|0;w=n+200|0;v=n+196|0;e=n+184|0;m=n+172|0;s=n+168|0;q=n+8|0;p=n+4|0;r=n;t=c[h+4>>2]&74;if((t|0)==8){t=16}else if((t|0)==64){t=8}else if((t|0)==0){t=0}else{t=10}Hp(e,h,w,v);c[m+0>>2]=0;c[m+4>>2]=0;c[m+8>>2]=0;u=0;Na(59,m|0,10,0);E=u;u=0;a:do{if(!(E&1)){if((a[m>>0]&1)==0){B=m+1|0;h=B;y=m+8|0}else{B=m+8|0;h=m+1|0;y=B;B=c[B>>2]|0}c[s>>2]=B;c[p>>2]=q;c[r>>2]=0;x=m+4|0;z=c[v>>2]|0;v=c[f>>2]|0;b:while(1){if((v|0)!=0){A=c[v+12>>2]|0;if((A|0)==(c[v+16>>2]|0)){u=0;A=qa(c[(c[v>>2]|0)+36>>2]|0,v|0)|0;E=u;u=0;if(E&1){l=38;break}}else{A=c[A>>2]|0}if((A|0)==-1){c[f>>2]=0;C=1;v=0}else{C=0}}else{C=1;v=0}A=c[g>>2]|0;do{if((A|0)!=0){D=c[A+12>>2]|0;if((D|0)==(c[A+16>>2]|0)){u=0;D=qa(c[(c[A>>2]|0)+36>>2]|0,A|0)|0;E=u;u=0;if(E&1){l=38;break b}}else{D=c[D>>2]|0}if(!((D|0)==-1)){if(C){break}else{break b}}else{c[g>>2]=0;l=22;break}}else{l=22}}while(0);if((l|0)==22){l=0;if(C){A=0;break}else{A=0}}C=a[m>>0]|0;E=(C&1)==0;if(E){D=(C&255)>>>1}else{D=c[x>>2]|0}if(((c[s>>2]|0)-B|0)==(D|0)){if(E){B=(C&255)>>>1;C=(C&255)>>>1}else{C=c[x>>2]|0;B=C}u=0;Na(59,m|0,B<<1|0,0);E=u;u=0;if(E&1){l=38;break}if((a[m>>0]&1)==0){B=10}else{B=(c[m>>2]&-2)+ -1|0}u=0;Na(59,m|0,B|0,0);E=u;u=0;if(E&1){l=38;break}if((a[m>>0]&1)==0){B=h}else{B=c[y>>2]|0}c[s>>2]=B+C}C=v+12|0;E=c[C>>2]|0;D=v+16|0;if((E|0)==(c[D>>2]|0)){u=0;E=qa(c[(c[v>>2]|0)+36>>2]|0,v|0)|0;F=u;u=0;if(F&1){l=38;break}}else{E=c[E>>2]|0}if((Dp(E,t,B,s,r,z,e,q,p,w)|0)!=0){break}A=c[C>>2]|0;if((A|0)==(c[D>>2]|0)){u=0;qa(c[(c[v>>2]|0)+40>>2]|0,v|0)|0;F=u;u=0;if(F&1){l=38;break}else{continue}}else{c[C>>2]=A+4;continue}}if((l|0)==38){F=qb(-1,-1)|0;Rm(m);Rm(e);vb(F|0)}w=a[e>>0]|0;if((w&1)==0){w=(w&255)>>>1}else{w=c[e+4>>2]|0}if((w|0)!=0?(o=c[p>>2]|0,(o-q|0)<160):0){F=c[r>>2]|0;c[p>>2]=o+4;c[o>>2]=F}u=0;o=Ma(11,B|0,c[s>>2]|0,j|0,t|0)|0;F=u;u=0;if(!(F&1)){b[k>>1]=o;Pr(e,q,c[p>>2]|0,j);if((v|0)!=0){k=c[v+12>>2]|0;if((k|0)==(c[v+16>>2]|0)){u=0;k=qa(c[(c[v>>2]|0)+36>>2]|0,v|0)|0;F=u;u=0;if(F&1){break}}else{k=c[k>>2]|0}if((k|0)==-1){c[f>>2]=0;v=0;f=1}else{f=0}}else{v=0;f=1}do{if((A|0)!=0){k=c[A+12>>2]|0;if((k|0)==(c[A+16>>2]|0)){u=0;k=qa(c[(c[A>>2]|0)+36>>2]|0,A|0)|0;F=u;u=0;if(F&1){break a}}else{k=c[k>>2]|0}if((k|0)==-1){c[g>>2]=0;l=67;break}if(f){c[d>>2]=v;Rm(m);Rm(e);i=n;return}}else{l=67}}while(0);if((l|0)==67?!f:0){c[d>>2]=v;Rm(m);Rm(e);i=n;return}c[j>>2]=c[j>>2]|2;c[d>>2]=v;Rm(m);Rm(e);i=n;return}}}while(0);F=qb(-1,-1)|0;Rm(m);Rm(e);vb(F|0)}function qp(a,b,d,e,f,g,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0;b=i;i=i+16|0;j=b+12|0;k=b+8|0;m=b+4|0;l=b;c[m>>2]=c[d>>2];c[l>>2]=c[e>>2];c[k+0>>2]=c[m+0>>2];c[j+0>>2]=c[l+0>>2];rp(a,0,k,j,f,g,h);i=b;return}function rp(b,d,e,f,g,h,j){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0;m=i;i=i+304|0;v=m+200|0;t=m+196|0;d=m+184|0;l=m+172|0;r=m+168|0;p=m+8|0;o=m+4|0;q=m;s=c[g+4>>2]&74;if((s|0)==64){s=8}else if((s|0)==8){s=16}else if((s|0)==0){s=0}else{s=10}Hp(d,g,v,t);c[l+0>>2]=0;c[l+4>>2]=0;c[l+8>>2]=0;u=0;Na(59,l|0,10,0);D=u;u=0;a:do{if(!(D&1)){if((a[l>>0]&1)==0){A=l+1|0;g=A;x=l+8|0}else{A=l+8|0;g=l+1|0;x=A;A=c[A>>2]|0}c[r>>2]=A;c[o>>2]=p;c[q>>2]=0;w=l+4|0;y=c[t>>2]|0;t=c[e>>2]|0;b:while(1){if((t|0)!=0){z=c[t+12>>2]|0;if((z|0)==(c[t+16>>2]|0)){u=0;z=qa(c[(c[t>>2]|0)+36>>2]|0,t|0)|0;D=u;u=0;if(D&1){k=38;break}}else{z=c[z>>2]|0}if((z|0)==-1){c[e>>2]=0;B=1;t=0}else{B=0}}else{B=1;t=0}z=c[f>>2]|0;do{if((z|0)!=0){C=c[z+12>>2]|0;if((C|0)==(c[z+16>>2]|0)){u=0;C=qa(c[(c[z>>2]|0)+36>>2]|0,z|0)|0;D=u;u=0;if(D&1){k=38;break b}}else{C=c[C>>2]|0}if(!((C|0)==-1)){if(B){break}else{break b}}else{c[f>>2]=0;k=22;break}}else{k=22}}while(0);if((k|0)==22){k=0;if(B){z=0;break}else{z=0}}B=a[l>>0]|0;D=(B&1)==0;if(D){C=(B&255)>>>1}else{C=c[w>>2]|0}if(((c[r>>2]|0)-A|0)==(C|0)){if(D){A=(B&255)>>>1;B=(B&255)>>>1}else{B=c[w>>2]|0;A=B}u=0;Na(59,l|0,A<<1|0,0);D=u;u=0;if(D&1){k=38;break}if((a[l>>0]&1)==0){A=10}else{A=(c[l>>2]&-2)+ -1|0}u=0;Na(59,l|0,A|0,0);D=u;u=0;if(D&1){k=38;break}if((a[l>>0]&1)==0){A=g}else{A=c[x>>2]|0}c[r>>2]=A+B}B=t+12|0;D=c[B>>2]|0;C=t+16|0;if((D|0)==(c[C>>2]|0)){u=0;D=qa(c[(c[t>>2]|0)+36>>2]|0,t|0)|0;E=u;u=0;if(E&1){k=38;break}}else{D=c[D>>2]|0}if((Dp(D,s,A,r,q,y,d,p,o,v)|0)!=0){break}z=c[B>>2]|0;if((z|0)==(c[C>>2]|0)){u=0;qa(c[(c[t>>2]|0)+40>>2]|0,t|0)|0;E=u;u=0;if(E&1){k=38;break}else{continue}}else{c[B>>2]=z+4;continue}}if((k|0)==38){E=qb(-1,-1)|0;Rm(l);Rm(d);vb(E|0)}v=a[d>>0]|0;if((v&1)==0){v=(v&255)>>>1}else{v=c[d+4>>2]|0}if((v|0)!=0?(n=c[o>>2]|0,(n-p|0)<160):0){E=c[q>>2]|0;c[o>>2]=n+4;c[n>>2]=E}u=0;n=Ma(12,A|0,c[r>>2]|0,h|0,s|0)|0;E=u;u=0;if(!(E&1)){c[j>>2]=n;Pr(d,p,c[o>>2]|0,h);if((t|0)!=0){j=c[t+12>>2]|0;if((j|0)==(c[t+16>>2]|0)){u=0;j=qa(c[(c[t>>2]|0)+36>>2]|0,t|0)|0;E=u;u=0;if(E&1){break}}else{j=c[j>>2]|0}if((j|0)==-1){c[e>>2]=0;t=0;e=1}else{e=0}}else{t=0;e=1}do{if((z|0)!=0){j=c[z+12>>2]|0;if((j|0)==(c[z+16>>2]|0)){u=0;j=qa(c[(c[z>>2]|0)+36>>2]|0,z|0)|0;E=u;u=0;if(E&1){break a}}else{j=c[j>>2]|0}if((j|0)==-1){c[f>>2]=0;k=67;break}if(e){c[b>>2]=t;Rm(l);Rm(d);i=m;return}}else{k=67}}while(0);if((k|0)==67?!e:0){c[b>>2]=t;Rm(l);Rm(d);i=m;return}c[h>>2]=c[h>>2]|2;c[b>>2]=t;Rm(l);Rm(d);i=m;return}}}while(0);E=qb(-1,-1)|0;Rm(l);Rm(d);vb(E|0)}function sp(a,b,d,e,f,g,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0;b=i;i=i+16|0;j=b+12|0;k=b+8|0;m=b+4|0;l=b;c[m>>2]=c[d>>2];c[l>>2]=c[e>>2];c[k+0>>2]=c[m+0>>2];c[j+0>>2]=c[l+0>>2];tp(a,0,k,j,f,g,h);i=b;return}function tp(b,d,e,f,g,h,j){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0;m=i;i=i+304|0;v=m+200|0;t=m+196|0;d=m+184|0;l=m+172|0;r=m+168|0;p=m+8|0;o=m+4|0;q=m;s=c[g+4>>2]&74;if((s|0)==0){s=0}else if((s|0)==8){s=16}else if((s|0)==64){s=8}else{s=10}Hp(d,g,v,t);c[l+0>>2]=0;c[l+4>>2]=0;c[l+8>>2]=0;u=0;Na(59,l|0,10,0);D=u;u=0;a:do{if(!(D&1)){if((a[l>>0]&1)==0){A=l+1|0;g=A;x=l+8|0}else{A=l+8|0;g=l+1|0;x=A;A=c[A>>2]|0}c[r>>2]=A;c[o>>2]=p;c[q>>2]=0;w=l+4|0;y=c[t>>2]|0;t=c[e>>2]|0;b:while(1){if((t|0)!=0){z=c[t+12>>2]|0;if((z|0)==(c[t+16>>2]|0)){u=0;z=qa(c[(c[t>>2]|0)+36>>2]|0,t|0)|0;D=u;u=0;if(D&1){k=38;break}}else{z=c[z>>2]|0}if((z|0)==-1){c[e>>2]=0;B=1;t=0}else{B=0}}else{B=1;t=0}z=c[f>>2]|0;do{if((z|0)!=0){C=c[z+12>>2]|0;if((C|0)==(c[z+16>>2]|0)){u=0;C=qa(c[(c[z>>2]|0)+36>>2]|0,z|0)|0;D=u;u=0;if(D&1){k=38;break b}}else{C=c[C>>2]|0}if(!((C|0)==-1)){if(B){break}else{break b}}else{c[f>>2]=0;k=22;break}}else{k=22}}while(0);if((k|0)==22){k=0;if(B){z=0;break}else{z=0}}B=a[l>>0]|0;D=(B&1)==0;if(D){C=(B&255)>>>1}else{C=c[w>>2]|0}if(((c[r>>2]|0)-A|0)==(C|0)){if(D){A=(B&255)>>>1;B=(B&255)>>>1}else{B=c[w>>2]|0;A=B}u=0;Na(59,l|0,A<<1|0,0);D=u;u=0;if(D&1){k=38;break}if((a[l>>0]&1)==0){A=10}else{A=(c[l>>2]&-2)+ -1|0}u=0;Na(59,l|0,A|0,0);D=u;u=0;if(D&1){k=38;break}if((a[l>>0]&1)==0){A=g}else{A=c[x>>2]|0}c[r>>2]=A+B}B=t+12|0;D=c[B>>2]|0;C=t+16|0;if((D|0)==(c[C>>2]|0)){u=0;D=qa(c[(c[t>>2]|0)+36>>2]|0,t|0)|0;E=u;u=0;if(E&1){k=38;break}}else{D=c[D>>2]|0}if((Dp(D,s,A,r,q,y,d,p,o,v)|0)!=0){break}z=c[B>>2]|0;if((z|0)==(c[C>>2]|0)){u=0;qa(c[(c[t>>2]|0)+40>>2]|0,t|0)|0;E=u;u=0;if(E&1){k=38;break}else{continue}}else{c[B>>2]=z+4;continue}}if((k|0)==38){E=qb(-1,-1)|0;Rm(l);Rm(d);vb(E|0)}v=a[d>>0]|0;if((v&1)==0){v=(v&255)>>>1}else{v=c[d+4>>2]|0}if((v|0)!=0?(n=c[o>>2]|0,(n-p|0)<160):0){E=c[q>>2]|0;c[o>>2]=n+4;c[n>>2]=E}u=0;n=Ma(13,A|0,c[r>>2]|0,h|0,s|0)|0;E=u;u=0;if(!(E&1)){c[j>>2]=n;Pr(d,p,c[o>>2]|0,h);if((t|0)!=0){j=c[t+12>>2]|0;if((j|0)==(c[t+16>>2]|0)){u=0;j=qa(c[(c[t>>2]|0)+36>>2]|0,t|0)|0;E=u;u=0;if(E&1){break}}else{j=c[j>>2]|0}if((j|0)==-1){c[e>>2]=0;t=0;e=1}else{e=0}}else{t=0;e=1}do{if((z|0)!=0){j=c[z+12>>2]|0;if((j|0)==(c[z+16>>2]|0)){u=0;j=qa(c[(c[z>>2]|0)+36>>2]|0,z|0)|0;E=u;u=0;if(E&1){break a}}else{j=c[j>>2]|0}if((j|0)==-1){c[f>>2]=0;k=67;break}if(e){c[b>>2]=t;Rm(l);Rm(d);i=m;return}}else{k=67}}while(0);if((k|0)==67?!e:0){c[b>>2]=t;Rm(l);Rm(d);i=m;return}c[h>>2]=c[h>>2]|2;c[b>>2]=t;Rm(l);Rm(d);i=m;return}}}while(0);E=qb(-1,-1)|0;Rm(l);Rm(d);vb(E|0)}function up(a,b,d,e,f,g,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0;b=i;i=i+16|0;j=b+12|0;k=b+8|0;m=b+4|0;l=b;c[m>>2]=c[d>>2];c[l>>2]=c[e>>2];c[k+0>>2]=c[m+0>>2];c[j+0>>2]=c[l+0>>2];vp(a,0,k,j,f,g,h);i=b;return}function vp(b,d,e,f,g,h,j){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0;m=i;i=i+304|0;v=m+200|0;t=m+196|0;d=m+184|0;l=m+172|0;r=m+168|0;o=m+8|0;n=m+4|0;q=m;s=c[g+4>>2]&74;if((s|0)==64){s=8}else if((s|0)==0){s=0}else if((s|0)==8){s=16}else{s=10}Hp(d,g,v,t);c[l+0>>2]=0;c[l+4>>2]=0;c[l+8>>2]=0;u=0;Na(59,l|0,10,0);D=u;u=0;a:do{if(!(D&1)){if((a[l>>0]&1)==0){A=l+1|0;x=A;g=l+8|0}else{A=l+8|0;x=l+1|0;g=A;A=c[A>>2]|0}c[r>>2]=A;c[n>>2]=o;c[q>>2]=0;w=l+4|0;y=c[t>>2]|0;t=c[e>>2]|0;b:while(1){if((t|0)!=0){z=c[t+12>>2]|0;if((z|0)==(c[t+16>>2]|0)){u=0;z=qa(c[(c[t>>2]|0)+36>>2]|0,t|0)|0;D=u;u=0;if(D&1){k=38;break}}else{z=c[z>>2]|0}if((z|0)==-1){c[e>>2]=0;B=1;t=0}else{B=0}}else{B=1;t=0}z=c[f>>2]|0;do{if((z|0)!=0){C=c[z+12>>2]|0;if((C|0)==(c[z+16>>2]|0)){u=0;C=qa(c[(c[z>>2]|0)+36>>2]|0,z|0)|0;D=u;u=0;if(D&1){k=38;break b}}else{C=c[C>>2]|0}if(!((C|0)==-1)){if(B){break}else{break b}}else{c[f>>2]=0;k=22;break}}else{k=22}}while(0);if((k|0)==22){k=0;if(B){z=0;break}else{z=0}}B=a[l>>0]|0;D=(B&1)==0;if(D){C=(B&255)>>>1}else{C=c[w>>2]|0}if(((c[r>>2]|0)-A|0)==(C|0)){if(D){A=(B&255)>>>1;B=(B&255)>>>1}else{B=c[w>>2]|0;A=B}u=0;Na(59,l|0,A<<1|0,0);D=u;u=0;if(D&1){k=38;break}if((a[l>>0]&1)==0){A=10}else{A=(c[l>>2]&-2)+ -1|0}u=0;Na(59,l|0,A|0,0);D=u;u=0;if(D&1){k=38;break}if((a[l>>0]&1)==0){A=x}else{A=c[g>>2]|0}c[r>>2]=A+B}C=t+12|0;D=c[C>>2]|0;B=t+16|0;if((D|0)==(c[B>>2]|0)){u=0;D=qa(c[(c[t>>2]|0)+36>>2]|0,t|0)|0;E=u;u=0;if(E&1){k=38;break}}else{D=c[D>>2]|0}if((Dp(D,s,A,r,q,y,d,o,n,v)|0)!=0){break}z=c[C>>2]|0;if((z|0)==(c[B>>2]|0)){u=0;qa(c[(c[t>>2]|0)+40>>2]|0,t|0)|0;E=u;u=0;if(E&1){k=38;break}else{continue}}else{c[C>>2]=z+4;continue}}if((k|0)==38){E=qb(-1,-1)|0;Rm(l);Rm(d);vb(E|0)}v=a[d>>0]|0;if((v&1)==0){v=(v&255)>>>1}else{v=c[d+4>>2]|0}if((v|0)!=0?(p=c[n>>2]|0,(p-o|0)<160):0){E=c[q>>2]|0;c[n>>2]=p+4;c[p>>2]=E}u=0;q=Ma(14,A|0,c[r>>2]|0,h|0,s|0)|0;p=J;E=u;u=0;if(!(E&1)){E=j;c[E>>2]=q;c[E+4>>2]=p;Pr(d,o,c[n>>2]|0,h);if((t|0)!=0){j=c[t+12>>2]|0;if((j|0)==(c[t+16>>2]|0)){u=0;j=qa(c[(c[t>>2]|0)+36>>2]|0,t|0)|0;E=u;u=0;if(E&1){break}}else{j=c[j>>2]|0}if((j|0)==-1){c[e>>2]=0;t=0;e=1}else{e=0}}else{t=0;e=1}do{if((z|0)!=0){j=c[z+12>>2]|0;if((j|0)==(c[z+16>>2]|0)){u=0;j=qa(c[(c[z>>2]|0)+36>>2]|0,z|0)|0;E=u;u=0;if(E&1){break a}}else{j=c[j>>2]|0}if((j|0)==-1){c[f>>2]=0;k=67;break}if(e){c[b>>2]=t;Rm(l);Rm(d);i=m;return}}else{k=67}}while(0);if((k|0)==67?!e:0){c[b>>2]=t;Rm(l);Rm(d);i=m;return}c[h>>2]=c[h>>2]|2;c[b>>2]=t;Rm(l);Rm(d);i=m;return}}}while(0);E=qb(-1,-1)|0;Rm(l);Rm(d);vb(E|0)}function wp(a,b,d,e,f,g,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0;b=i;i=i+16|0;j=b+12|0;k=b+8|0;m=b+4|0;l=b;c[m>>2]=c[d>>2];c[l>>2]=c[e>>2];c[k+0>>2]=c[m+0>>2];c[j+0>>2]=c[l+0>>2];xp(a,0,k,j,f,g,h);i=b;return}function xp(b,d,e,f,h,j,k){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;k=k|0;var l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0.0,I=0;n=i;i=i+352|0;w=n+208|0;A=n+200|0;v=n+196|0;d=n+184|0;m=n+172|0;t=n+168|0;q=n+8|0;o=n+4|0;r=n;s=n+337|0;x=n+336|0;Ip(d,h,w,A,v);c[m+0>>2]=0;c[m+4>>2]=0;c[m+8>>2]=0;u=0;Na(59,m|0,10,0);G=u;u=0;a:do{if(!(G&1)){if((a[m>>0]&1)==0){D=m+1|0;y=D;z=m+8|0}else{D=m+8|0;y=m+1|0;z=D;D=c[D>>2]|0}c[t>>2]=D;c[o>>2]=q;c[r>>2]=0;a[s>>0]=1;a[x>>0]=69;h=m+4|0;A=c[A>>2]|0;B=c[v>>2]|0;v=c[e>>2]|0;b:while(1){if((v|0)!=0){C=c[v+12>>2]|0;if((C|0)==(c[v+16>>2]|0)){u=0;C=qa(c[(c[v>>2]|0)+36>>2]|0,v|0)|0;G=u;u=0;if(G&1){l=34;break}}else{C=c[C>>2]|0}if((C|0)==-1){c[e>>2]=0;E=1;v=0}else{E=0}}else{E=1;v=0}C=c[f>>2]|0;do{if((C|0)!=0){F=c[C+12>>2]|0;if((F|0)==(c[C+16>>2]|0)){u=0;F=qa(c[(c[C>>2]|0)+36>>2]|0,C|0)|0;G=u;u=0;if(G&1){l=34;break b}}else{F=c[F>>2]|0}if(!((F|0)==-1)){if(E){break}else{break b}}else{c[f>>2]=0;l=18;break}}else{l=18}}while(0);if((l|0)==18){l=0;if(E){C=0;break}else{C=0}}E=a[m>>0]|0;G=(E&1)==0;if(G){F=(E&255)>>>1}else{F=c[h>>2]|0}if(((c[t>>2]|0)-D|0)==(F|0)){if(G){D=(E&255)>>>1;E=(E&255)>>>1}else{E=c[h>>2]|0;D=E}u=0;Na(59,m|0,D<<1|0,0);G=u;u=0;if(G&1){l=34;break}if((a[m>>0]&1)==0){D=10}else{D=(c[m>>2]&-2)+ -1|0}u=0;Na(59,m|0,D|0,0);G=u;u=0;if(G&1){l=34;break}if((a[m>>0]&1)==0){D=y}else{D=c[z>>2]|0}c[t>>2]=D+E}F=v+12|0;G=c[F>>2]|0;E=v+16|0;if((G|0)==(c[E>>2]|0)){u=0;G=qa(c[(c[v>>2]|0)+36>>2]|0,v|0)|0;I=u;u=0;if(I&1){l=34;break}}else{G=c[G>>2]|0}if((Jp(G,s,x,D,t,A,B,d,q,o,r,w)|0)!=0){break}C=c[F>>2]|0;if((C|0)==(c[E>>2]|0)){u=0;qa(c[(c[v>>2]|0)+40>>2]|0,v|0)|0;I=u;u=0;if(I&1){l=34;break}else{continue}}else{c[F>>2]=C+4;continue}}if((l|0)==34){I=qb(-1,-1)|0;Rm(m);Rm(d);vb(I|0)}w=a[d>>0]|0;if((w&1)==0){w=(w&255)>>>1}else{w=c[d+4>>2]|0}if(((w|0)!=0?(a[s>>0]|0)!=0:0)?(p=c[o>>2]|0,(p-q|0)<160):0){I=c[r>>2]|0;c[o>>2]=p+4;c[p>>2]=I}u=0;H=+Ja(2,D|0,c[t>>2]|0,j|0);I=u;u=0;if(!(I&1)){g[k>>2]=H;Pr(d,q,c[o>>2]|0,j);if((v|0)!=0){k=c[v+12>>2]|0;if((k|0)==(c[v+16>>2]|0)){u=0;k=qa(c[(c[v>>2]|0)+36>>2]|0,v|0)|0;I=u;u=0;if(I&1){break}}else{k=c[k>>2]|0}if((k|0)==-1){c[e>>2]=0;v=0;e=1}else{e=0}}else{v=0;e=1}do{if((C|0)!=0){k=c[C+12>>2]|0;if((k|0)==(c[C+16>>2]|0)){u=0;k=qa(c[(c[C>>2]|0)+36>>2]|0,C|0)|0;I=u;u=0;if(I&1){break a}}else{k=c[k>>2]|0}if((k|0)==-1){c[f>>2]=0;l=64;break}if(e){c[b>>2]=v;Rm(m);Rm(d);i=n;return}}else{l=64}}while(0);if((l|0)==64?!e:0){c[b>>2]=v;Rm(m);Rm(d);i=n;return}c[j>>2]=c[j>>2]|2;c[b>>2]=v;Rm(m);Rm(d);i=n;return}}}while(0);I=qb(-1,-1)|0;Rm(m);Rm(d);vb(I|0)}function yp(a,b,d,e,f,g,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0;b=i;i=i+16|0;j=b+12|0;k=b+8|0;m=b+4|0;l=b;c[m>>2]=c[d>>2];c[l>>2]=c[e>>2];c[k+0>>2]=c[m+0>>2];c[j+0>>2]=c[l+0>>2];zp(a,0,k,j,f,g,h);i=b;return}function zp(b,d,e,f,g,j,k){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;j=j|0;k=k|0;var l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0.0,I=0;n=i;i=i+352|0;w=n+208|0;A=n+200|0;v=n+196|0;d=n+184|0;m=n+172|0;t=n+168|0;q=n+8|0;o=n+4|0;r=n;s=n+337|0;x=n+336|0;Ip(d,g,w,A,v);c[m+0>>2]=0;c[m+4>>2]=0;c[m+8>>2]=0;u=0;Na(59,m|0,10,0);G=u;u=0;a:do{if(!(G&1)){if((a[m>>0]&1)==0){D=m+1|0;y=D;z=m+8|0}else{D=m+8|0;y=m+1|0;z=D;D=c[D>>2]|0}c[t>>2]=D;c[o>>2]=q;c[r>>2]=0;a[s>>0]=1;a[x>>0]=69;g=m+4|0;A=c[A>>2]|0;B=c[v>>2]|0;v=c[e>>2]|0;b:while(1){if((v|0)!=0){C=c[v+12>>2]|0;if((C|0)==(c[v+16>>2]|0)){u=0;C=qa(c[(c[v>>2]|0)+36>>2]|0,v|0)|0;G=u;u=0;if(G&1){l=34;break}}else{C=c[C>>2]|0}if((C|0)==-1){c[e>>2]=0;E=1;v=0}else{E=0}}else{E=1;v=0}C=c[f>>2]|0;do{if((C|0)!=0){F=c[C+12>>2]|0;if((F|0)==(c[C+16>>2]|0)){u=0;F=qa(c[(c[C>>2]|0)+36>>2]|0,C|0)|0;G=u;u=0;if(G&1){l=34;break b}}else{F=c[F>>2]|0}if(!((F|0)==-1)){if(E){break}else{break b}}else{c[f>>2]=0;l=18;break}}else{l=18}}while(0);if((l|0)==18){l=0;if(E){C=0;break}else{C=0}}E=a[m>>0]|0;G=(E&1)==0;if(G){F=(E&255)>>>1}else{F=c[g>>2]|0}if(((c[t>>2]|0)-D|0)==(F|0)){if(G){D=(E&255)>>>1;E=(E&255)>>>1}else{E=c[g>>2]|0;D=E}u=0;Na(59,m|0,D<<1|0,0);G=u;u=0;if(G&1){l=34;break}if((a[m>>0]&1)==0){D=10}else{D=(c[m>>2]&-2)+ -1|0}u=0;Na(59,m|0,D|0,0);G=u;u=0;if(G&1){l=34;break}if((a[m>>0]&1)==0){D=y}else{D=c[z>>2]|0}c[t>>2]=D+E}F=v+12|0;G=c[F>>2]|0;E=v+16|0;if((G|0)==(c[E>>2]|0)){u=0;G=qa(c[(c[v>>2]|0)+36>>2]|0,v|0)|0;I=u;u=0;if(I&1){l=34;break}}else{G=c[G>>2]|0}if((Jp(G,s,x,D,t,A,B,d,q,o,r,w)|0)!=0){break}C=c[F>>2]|0;if((C|0)==(c[E>>2]|0)){u=0;qa(c[(c[v>>2]|0)+40>>2]|0,v|0)|0;I=u;u=0;if(I&1){l=34;break}else{continue}}else{c[F>>2]=C+4;continue}}if((l|0)==34){I=qb(-1,-1)|0;Rm(m);Rm(d);vb(I|0)}w=a[d>>0]|0;if((w&1)==0){w=(w&255)>>>1}else{w=c[d+4>>2]|0}if(((w|0)!=0?(a[s>>0]|0)!=0:0)?(p=c[o>>2]|0,(p-q|0)<160):0){I=c[r>>2]|0;c[o>>2]=p+4;c[p>>2]=I}u=0;H=+Ja(3,D|0,c[t>>2]|0,j|0);I=u;u=0;if(!(I&1)){h[k>>3]=H;Pr(d,q,c[o>>2]|0,j);if((v|0)!=0){k=c[v+12>>2]|0;if((k|0)==(c[v+16>>2]|0)){u=0;k=qa(c[(c[v>>2]|0)+36>>2]|0,v|0)|0;I=u;u=0;if(I&1){break}}else{k=c[k>>2]|0}if((k|0)==-1){c[e>>2]=0;v=0;e=1}else{e=0}}else{v=0;e=1}do{if((C|0)!=0){k=c[C+12>>2]|0;if((k|0)==(c[C+16>>2]|0)){u=0;k=qa(c[(c[C>>2]|0)+36>>2]|0,C|0)|0;I=u;u=0;if(I&1){break a}}else{k=c[k>>2]|0}if((k|0)==-1){c[f>>2]=0;l=64;break}if(e){c[b>>2]=v;Rm(m);Rm(d);i=n;return}}else{l=64}}while(0);if((l|0)==64?!e:0){c[b>>2]=v;Rm(m);Rm(d);i=n;return}c[j>>2]=c[j>>2]|2;c[b>>2]=v;Rm(m);Rm(d);i=n;return}}}while(0);I=qb(-1,-1)|0;Rm(m);Rm(d);vb(I|0)}function Ap(a,b,d,e,f,g,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0;b=i;i=i+16|0;j=b+12|0;k=b+8|0;m=b+4|0;l=b;c[m>>2]=c[d>>2];c[l>>2]=c[e>>2];c[k+0>>2]=c[m+0>>2];c[j+0>>2]=c[l+0>>2];Bp(a,0,k,j,f,g,h);i=b;return}function Bp(b,d,e,f,g,j,k){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;j=j|0;k=k|0;var l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0.0,I=0;n=i;i=i+352|0;w=n+208|0;A=n+200|0;v=n+196|0;d=n+184|0;m=n+172|0;t=n+168|0;q=n+8|0;o=n+4|0;r=n;s=n+337|0;x=n+336|0;Ip(d,g,w,A,v);c[m+0>>2]=0;c[m+4>>2]=0;c[m+8>>2]=0;u=0;Na(59,m|0,10,0);G=u;u=0;a:do{if(!(G&1)){if((a[m>>0]&1)==0){D=m+1|0;y=D;z=m+8|0}else{D=m+8|0;y=m+1|0;z=D;D=c[D>>2]|0}c[t>>2]=D;c[o>>2]=q;c[r>>2]=0;a[s>>0]=1;a[x>>0]=69;g=m+4|0;A=c[A>>2]|0;B=c[v>>2]|0;v=c[e>>2]|0;b:while(1){if((v|0)!=0){C=c[v+12>>2]|0;if((C|0)==(c[v+16>>2]|0)){u=0;C=qa(c[(c[v>>2]|0)+36>>2]|0,v|0)|0;G=u;u=0;if(G&1){l=34;break}}else{C=c[C>>2]|0}if((C|0)==-1){c[e>>2]=0;E=1;v=0}else{E=0}}else{E=1;v=0}C=c[f>>2]|0;do{if((C|0)!=0){F=c[C+12>>2]|0;if((F|0)==(c[C+16>>2]|0)){u=0;F=qa(c[(c[C>>2]|0)+36>>2]|0,C|0)|0;G=u;u=0;if(G&1){l=34;break b}}else{F=c[F>>2]|0}if(!((F|0)==-1)){if(E){break}else{break b}}else{c[f>>2]=0;l=18;break}}else{l=18}}while(0);if((l|0)==18){l=0;if(E){C=0;break}else{C=0}}E=a[m>>0]|0;G=(E&1)==0;if(G){F=(E&255)>>>1}else{F=c[g>>2]|0}if(((c[t>>2]|0)-D|0)==(F|0)){if(G){D=(E&255)>>>1;E=(E&255)>>>1}else{E=c[g>>2]|0;D=E}u=0;Na(59,m|0,D<<1|0,0);G=u;u=0;if(G&1){l=34;break}if((a[m>>0]&1)==0){D=10}else{D=(c[m>>2]&-2)+ -1|0}u=0;Na(59,m|0,D|0,0);G=u;u=0;if(G&1){l=34;break}if((a[m>>0]&1)==0){D=y}else{D=c[z>>2]|0}c[t>>2]=D+E}F=v+12|0;G=c[F>>2]|0;E=v+16|0;if((G|0)==(c[E>>2]|0)){u=0;G=qa(c[(c[v>>2]|0)+36>>2]|0,v|0)|0;I=u;u=0;if(I&1){l=34;break}}else{G=c[G>>2]|0}if((Jp(G,s,x,D,t,A,B,d,q,o,r,w)|0)!=0){break}C=c[F>>2]|0;if((C|0)==(c[E>>2]|0)){u=0;qa(c[(c[v>>2]|0)+40>>2]|0,v|0)|0;I=u;u=0;if(I&1){l=34;break}else{continue}}else{c[F>>2]=C+4;continue}}if((l|0)==34){I=qb(-1,-1)|0;Rm(m);Rm(d);vb(I|0)}w=a[d>>0]|0;if((w&1)==0){w=(w&255)>>>1}else{w=c[d+4>>2]|0}if(((w|0)!=0?(a[s>>0]|0)!=0:0)?(p=c[o>>2]|0,(p-q|0)<160):0){I=c[r>>2]|0;c[o>>2]=p+4;c[p>>2]=I}u=0;H=+Ja(4,D|0,c[t>>2]|0,j|0);I=u;u=0;if(!(I&1)){h[k>>3]=H;Pr(d,q,c[o>>2]|0,j);if((v|0)!=0){k=c[v+12>>2]|0;if((k|0)==(c[v+16>>2]|0)){u=0;k=qa(c[(c[v>>2]|0)+36>>2]|0,v|0)|0;I=u;u=0;if(I&1){break}}else{k=c[k>>2]|0}if((k|0)==-1){c[e>>2]=0;v=0;e=1}else{e=0}}else{v=0;e=1}do{if((C|0)!=0){k=c[C+12>>2]|0;if((k|0)==(c[C+16>>2]|0)){u=0;k=qa(c[(c[C>>2]|0)+36>>2]|0,C|0)|0;I=u;u=0;if(I&1){break a}}else{k=c[k>>2]|0}if((k|0)==-1){c[f>>2]=0;l=64;break}if(e){c[b>>2]=v;Rm(m);Rm(d);i=n;return}}else{l=64}}while(0);if((l|0)==64?!e:0){c[b>>2]=v;Rm(m);Rm(d);i=n;return}c[j>>2]=c[j>>2]|2;c[b>>2]=v;Rm(m);Rm(d);i=n;return}}}while(0);I=qb(-1,-1)|0;Rm(m);Rm(d);vb(I|0)}function Cp(b,d,e,f,g,h,j){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0;m=i;i=i+320|0;n=m;o=m+208|0;d=m+192|0;q=m+188|0;l=m+176|0;y=m+16|0;c[d+0>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;u=0;oa(84,q|0,g|0);F=u;u=0;if(F&1){F=qb(-1,-1)|0;Rm(d);vb(F|0)}s=c[q>>2]|0;if(!(!((c[4086]|0)==-1)?(c[n>>2]=16344,c[n+4>>2]=205,c[n+8>>2]=0,u=0,Na(58,16344,n|0,206),F=u,u=0,F&1):0)){k=4}do{if((k|0)==4){g=(c[16348>>2]|0)+ -1|0;r=c[s+8>>2]|0;if((c[s+12>>2]|0)-r>>2>>>0>g>>>0?(p=c[r+(g<<2)>>2]|0,(p|0)!=0):0){u=0;Ma(c[(c[p>>2]|0)+48>>2]|0,p|0,14896,14922|0,o|0)|0;F=u;u=0;if(F&1){break}qm(c[q>>2]|0)|0;c[l+0>>2]=0;c[l+4>>2]=0;c[l+8>>2]=0;u=0;Na(59,l|0,10,0);F=u;u=0;a:do{if(!(F&1)){if((a[l>>0]&1)==0){A=l+1|0;v=A;w=l+8|0}else{A=l+8|0;v=l+1|0;w=A;A=c[A>>2]|0}g=l+4|0;x=o+96|0;q=o+100|0;t=y;r=o+104|0;s=o;p=d+4|0;B=c[e>>2]|0;z=0;C=A;b:while(1){if((B|0)!=0){D=c[B+12>>2]|0;if((D|0)==(c[B+16>>2]|0)){u=0;D=qa(c[(c[B>>2]|0)+36>>2]|0,B|0)|0;F=u;u=0;if(F&1){k=44;break}}else{D=c[D>>2]|0}if((D|0)==-1){c[e>>2]=0;B=0;D=1}else{D=0}}else{B=0;D=1}E=c[f>>2]|0;do{if((E|0)!=0){F=c[E+12>>2]|0;if((F|0)==(c[E+16>>2]|0)){u=0;E=qa(c[(c[E>>2]|0)+36>>2]|0,E|0)|0;F=u;u=0;if(F&1){k=44;break b}}else{E=c[F>>2]|0}if(!((E|0)==-1)){if(D){break}else{break b}}else{c[f>>2]=0;k=26;break}}else{k=26}}while(0);if((k|0)==26?(k=0,D):0){break}D=a[l>>0]|0;E=(D&1)==0;if(E){F=(D&255)>>>1}else{F=c[g>>2]|0}if((C-A|0)==(F|0)){if(E){C=(D&255)>>>1;A=(D&255)>>>1}else{A=c[g>>2]|0;C=A}u=0;Na(59,l|0,A<<1|0,0);F=u;u=0;if(F&1){k=44;break}if((a[l>>0]&1)==0){A=10}else{A=(c[l>>2]&-2)+ -1|0}u=0;Na(59,l|0,A|0,0);F=u;u=0;if(F&1){k=44;break}if((a[l>>0]&1)==0){A=v}else{A=c[w>>2]|0}C=A+C|0}D=c[B+12>>2]|0;if((D|0)==(c[B+16>>2]|0)){u=0;D=qa(c[(c[B>>2]|0)+36>>2]|0,B|0)|0;F=u;u=0;if(F&1){k=44;break}}else{D=c[D>>2]|0}B=(C|0)==(A|0);do{if(B){E=(c[x>>2]|0)==(D|0);if(!E?(c[q>>2]|0)!=(D|0):0){k=54;break}a[C>>0]=E?43:45;C=C+1|0;z=0}else{k=54}}while(0);do{if((k|0)==54){k=0;E=a[d>>0]|0;if((E&1)==0){E=(E&255)>>>1}else{E=c[p>>2]|0}if((E|0)!=0&(D|0)==0){if((y-t|0)>=160){break}c[y>>2]=z;y=y+4|0;z=0;break}else{E=o}while(1){if((c[E>>2]|0)==(D|0)){break}E=E+4|0;if((E|0)==(r|0)){E=r;break}}E=E-s|0;D=E>>2;if((E|0)>92){break b}if((E|0)<88){a[C>>0]=a[14896+D>>0]|0;C=C+1|0;z=z+1|0;break}if(B){A=C;break b}if((C-A|0)>=3){break b}if((a[C+ -1>>0]|0)!=48){break b}a[C>>0]=a[14896+D>>0]|0;C=C+1|0;z=0}}while(0);B=c[e>>2]|0;E=B+12|0;D=c[E>>2]|0;if((D|0)==(c[B+16>>2]|0)){u=0;qa(c[(c[B>>2]|0)+40>>2]|0,B|0)|0;F=u;u=0;if(F&1){k=44;break}else{continue}}else{c[E>>2]=D+4;continue}}if((k|0)==44){f=qb(-1,-1)|0;break}a[A+3>>0]=0;do{if((a[16248]|0)==0?(Ua(16248)|0)!=0:0){u=0;o=ua(33,2147483647,16256,0)|0;F=u;u=0;if(F&1){f=qb(-1,-1)|0;Eb(16248);break a}else{c[4060]=o;rb(16248);break}}}while(0);F=c[4060]|0;u=0;c[n>>2]=j;j=Ma(15,A|0,F|0,14936,n|0)|0;F=u;u=0;if(!(F&1)){if((j|0)!=1){c[h>>2]=4}j=c[e>>2]|0;if((j|0)!=0){n=c[j+12>>2]|0;if((n|0)==(c[j+16>>2]|0)){u=0;n=qa(c[(c[j>>2]|0)+36>>2]|0,j|0)|0;F=u;u=0;if(F&1){k=45;break}}else{n=c[n>>2]|0}if((n|0)==-1){c[e>>2]=0;e=0;j=1}else{e=j;j=0}}else{e=0;j=1}o=c[f>>2]|0;do{if((o|0)!=0){n=c[o+12>>2]|0;if((n|0)==(c[o+16>>2]|0)){u=0;n=qa(c[(c[o>>2]|0)+36>>2]|0,o|0)|0;F=u;u=0;if(F&1){k=45;break a}}else{n=c[n>>2]|0}if((n|0)==-1){c[f>>2]=0;k=92;break}if(j){c[b>>2]=e;Rm(l);Rm(d);i=m;return}}else{k=92}}while(0);if((k|0)==92?!j:0){c[b>>2]=e;Rm(l);Rm(d);i=m;return}c[h>>2]=c[h>>2]|2;c[b>>2]=e;Rm(l);Rm(d);i=m;return}else{k=45}}else{k=45}}while(0);if((k|0)==45){f=qb(-1,-1)|0}Rm(l);F=f;Rm(d);vb(F|0)}F=Jb(4)|0;bv(F);u=0;Na(45,F|0,24312,171);F=u;u=0}}while(0);F=qb(-1,-1)|0;qm(c[q>>2]|0)|0;Rm(d);vb(F|0)}function Dp(b,d,e,f,g,h,j,k,l,m){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;l=l|0;m=m|0;var n=0,o=0,p=0,q=0;n=i;p=c[f>>2]|0;o=(p|0)==(e|0);do{if(o){q=(c[m+96>>2]|0)==(b|0);if(!q?(c[m+100>>2]|0)!=(b|0):0){break}c[f>>2]=e+1;a[e>>0]=q?43:45;c[g>>2]=0;q=0;i=n;return q|0}}while(0);q=a[j>>0]|0;if((q&1)==0){j=(q&255)>>>1}else{j=c[j+4>>2]|0}if((j|0)!=0&(b|0)==(h|0)){o=c[l>>2]|0;if((o-k|0)>=160){q=0;i=n;return q|0}q=c[g>>2]|0;c[l>>2]=o+4;c[o>>2]=q;c[g>>2]=0;q=0;i=n;return q|0}l=m+104|0;k=m;while(1){if((c[k>>2]|0)==(b|0)){break}k=k+4|0;if((k|0)==(l|0)){k=l;break}}b=k-m|0;m=b>>2;if((b|0)>92){q=-1;i=n;return q|0}if((d|0)==16){if((b|0)>=88){if(o){q=-1;i=n;return q|0}if((p-e|0)>=3){q=-1;i=n;return q|0}if((a[p+ -1>>0]|0)!=48){q=-1;i=n;return q|0}c[g>>2]=0;q=a[14896+m>>0]|0;c[f>>2]=p+1;a[p>>0]=q;q=0;i=n;return q|0}}else if((d|0)==10|(d|0)==8?(m|0)>=(d|0):0){q=-1;i=n;return q|0}q=a[14896+m>>0]|0;c[f>>2]=p+1;a[p>>0]=q;c[g>>2]=(c[g>>2]|0)+1;q=0;i=n;return q|0}function Ep(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0;g=i;i=i+32|0;k=g+16|0;m=g;j=g+28|0;ln(j,d);d=c[j>>2]|0;if(!(!((c[4088]|0)==-1)?(c[m>>2]=16352,c[m+4>>2]=205,c[m+8>>2]=0,u=0,Na(58,16352,m|0,206),m=u,u=0,m&1):0)){n=3}do{if((n|0)==3){m=(c[16356>>2]|0)+ -1|0;n=c[d+8>>2]|0;if((c[d+12>>2]|0)-n>>2>>>0>m>>>0?(l=c[n+(m<<2)>>2]|0,(l|0)!=0):0){u=0;Ma(c[(c[l>>2]|0)+32>>2]|0,l|0,14896,14922|0,e|0)|0;n=u;u=0;if(n&1){break}e=c[j>>2]|0;if(!((c[4124]|0)==-1)?(c[k>>2]=16496,c[k+4>>2]=205,c[k+8>>2]=0,u=0,Na(58,16496,k|0,206),n=u,u=0,n&1):0){break}k=(c[16500>>2]|0)+ -1|0;l=c[e+8>>2]|0;if((c[e+12>>2]|0)-l>>2>>>0>k>>>0?(h=c[l+(k<<2)>>2]|0,(h|0)!=0):0){u=0;k=qa(c[(c[h>>2]|0)+16>>2]|0,h|0)|0;n=u;u=0;if(n&1){break}a[f>>0]=k;u=0;oa(c[(c[h>>2]|0)+20>>2]|0,b|0,h|0);n=u;u=0;if(n&1){break}qm(c[j>>2]|0)|0;i=g;return}n=Jb(4)|0;bv(n);u=0;Na(45,n|0,24312,171);n=u;u=0;if(n&1){break}}n=Jb(4)|0;bv(n);u=0;Na(45,n|0,24312,171);n=u;u=0}}while(0);n=qb(-1,-1)|0;qm(c[j>>2]|0)|0;vb(n|0)}function Fp(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0,n=0,o=0;h=i;i=i+32|0;l=h+16|0;o=h;k=h+28|0;ln(k,d);d=c[k>>2]|0;if(!(!((c[4088]|0)==-1)?(c[o>>2]=16352,c[o+4>>2]=205,c[o+8>>2]=0,u=0,Na(58,16352,o|0,206),o=u,u=0,o&1):0)){n=3}do{if((n|0)==3){n=(c[16356>>2]|0)+ -1|0;o=c[d+8>>2]|0;if((c[d+12>>2]|0)-o>>2>>>0>n>>>0?(m=c[o+(n<<2)>>2]|0,(m|0)!=0):0){u=0;Ma(c[(c[m>>2]|0)+32>>2]|0,m|0,14896,14928|0,e|0)|0;o=u;u=0;if(o&1){break}e=c[k>>2]|0;if(!((c[4124]|0)==-1)?(c[l>>2]=16496,c[l+4>>2]=205,c[l+8>>2]=0,u=0,Na(58,16496,l|0,206),o=u,u=0,o&1):0){break}l=(c[16500>>2]|0)+ -1|0;m=c[e+8>>2]|0;if((c[e+12>>2]|0)-m>>2>>>0>l>>>0?(j=c[m+(l<<2)>>2]|0,(j|0)!=0):0){u=0;l=qa(c[(c[j>>2]|0)+12>>2]|0,j|0)|0;o=u;u=0;if(o&1){break}a[f>>0]=l;u=0;f=qa(c[(c[j>>2]|0)+16>>2]|0,j|0)|0;o=u;u=0;if(o&1){break}a[g>>0]=f;u=0;oa(c[(c[j>>2]|0)+20>>2]|0,b|0,j|0);o=u;u=0;if(o&1){break}qm(c[k>>2]|0)|0;i=h;return}o=Jb(4)|0;bv(o);u=0;Na(45,o|0,24312,171);o=u;u=0;if(o&1){break}}o=Jb(4)|0;bv(o);u=0;Na(45,o|0,24312,171);o=u;u=0}}while(0);o=qb(-1,-1)|0;qm(c[k>>2]|0)|0;vb(o|0)}function Gp(b,d,e,f,g,h,j,k,l,m,n,o){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;l=l|0;m=m|0;n=n|0;o=o|0;var p=0,q=0;p=i;if(b<<24>>24==h<<24>>24){if((a[d>>0]|0)==0){j=-1;i=p;return j|0}a[d>>0]=0;j=c[g>>2]|0;c[g>>2]=j+1;a[j>>0]=46;g=a[k>>0]|0;if((g&1)==0){g=(g&255)>>>1}else{g=c[k+4>>2]|0}if((g|0)==0){j=0;i=p;return j|0}g=c[m>>2]|0;if((g-l|0)>=160){j=0;i=p;return j|0}j=c[n>>2]|0;c[m>>2]=g+4;c[g>>2]=j;j=0;i=p;return j|0}if(b<<24>>24==j<<24>>24){h=a[k>>0]|0;if((h&1)==0){h=(h&255)>>>1}else{h=c[k+4>>2]|0}if((h|0)!=0){if((a[d>>0]|0)==0){j=-1;i=p;return j|0}g=c[m>>2]|0;if((g-l|0)>=160){j=0;i=p;return j|0}j=c[n>>2]|0;c[m>>2]=g+4;c[g>>2]=j;c[n>>2]=0;j=0;i=p;return j|0}}h=o+32|0;j=o;do{if((a[j>>0]|0)==b<<24>>24){h=j;break}j=j+1|0}while((j|0)!=(h|0));b=h-o|0;if((b|0)>31){j=-1;i=p;return j|0}o=a[14896+b>>0]|0;if((b|0)==23|(b|0)==22){a[e>>0]=80;j=c[g>>2]|0;c[g>>2]=j+1;a[j>>0]=o;j=0;i=p;return j|0}else if((b|0)==24|(b|0)==25){n=c[g>>2]|0;if((n|0)!=(f|0)?(a[n+ -1>>0]&95|0)!=(a[e>>0]&127|0):0){j=-1;i=p;return j|0}c[g>>2]=n+1;a[n>>0]=o;j=0;i=p;return j|0}else{f=o&95;if((f|0)==(a[e>>0]|0)?(a[e>>0]=f|128,(a[d>>0]|0)!=0):0){a[d>>0]=0;e=a[k>>0]|0;if((e&1)==0){k=(e&255)>>>1}else{k=c[k+4>>2]|0}if((k|0)!=0?(q=c[m>>2]|0,(q-l|0)<160):0){j=c[n>>2]|0;c[m>>2]=q+4;c[q>>2]=j}}j=c[g>>2]|0;c[g>>2]=j+1;a[j>>0]=o;if((b|0)>21){j=0;i=p;return j|0}c[n>>2]=(c[n>>2]|0)+1;j=0;i=p;return j|0}return 0}function Hp(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0;f=i;i=i+32|0;j=f+16|0;l=f;h=f+28|0;ln(h,b);b=c[h>>2]|0;if(!(!((c[4086]|0)==-1)?(c[l>>2]=16344,c[l+4>>2]=205,c[l+8>>2]=0,u=0,Na(58,16344,l|0,206),l=u,u=0,l&1):0)){m=3}do{if((m|0)==3){l=(c[16348>>2]|0)+ -1|0;m=c[b+8>>2]|0;if((c[b+12>>2]|0)-m>>2>>>0>l>>>0?(k=c[m+(l<<2)>>2]|0,(k|0)!=0):0){u=0;Ma(c[(c[k>>2]|0)+48>>2]|0,k|0,14896,14922|0,d|0)|0;m=u;u=0;if(m&1){break}d=c[h>>2]|0;if(!((c[4126]|0)==-1)?(c[j>>2]=16504,c[j+4>>2]=205,c[j+8>>2]=0,u=0,Na(58,16504,j|0,206),m=u,u=0,m&1):0){break}j=(c[16508>>2]|0)+ -1|0;k=c[d+8>>2]|0;if((c[d+12>>2]|0)-k>>2>>>0>j>>>0?(g=c[k+(j<<2)>>2]|0,(g|0)!=0):0){u=0;j=qa(c[(c[g>>2]|0)+16>>2]|0,g|0)|0;m=u;u=0;if(m&1){break}c[e>>2]=j;u=0;oa(c[(c[g>>2]|0)+20>>2]|0,a|0,g|0);m=u;u=0;if(m&1){break}qm(c[h>>2]|0)|0;i=f;return}m=Jb(4)|0;bv(m);u=0;Na(45,m|0,24312,171);m=u;u=0;if(m&1){break}}m=Jb(4)|0;bv(m);u=0;Na(45,m|0,24312,171);m=u;u=0}}while(0);m=qb(-1,-1)|0;qm(c[h>>2]|0)|0;vb(m|0)}function Ip(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0;g=i;i=i+32|0;k=g+16|0;n=g;j=g+28|0;ln(j,b);b=c[j>>2]|0;if(!(!((c[4086]|0)==-1)?(c[n>>2]=16344,c[n+4>>2]=205,c[n+8>>2]=0,u=0,Na(58,16344,n|0,206),n=u,u=0,n&1):0)){m=3}do{if((m|0)==3){m=(c[16348>>2]|0)+ -1|0;n=c[b+8>>2]|0;if((c[b+12>>2]|0)-n>>2>>>0>m>>>0?(l=c[n+(m<<2)>>2]|0,(l|0)!=0):0){u=0;Ma(c[(c[l>>2]|0)+48>>2]|0,l|0,14896,14928|0,d|0)|0;n=u;u=0;if(n&1){break}d=c[j>>2]|0;if(!((c[4126]|0)==-1)?(c[k>>2]=16504,c[k+4>>2]=205,c[k+8>>2]=0,u=0,Na(58,16504,k|0,206),n=u,u=0,n&1):0){break}k=(c[16508>>2]|0)+ -1|0;l=c[d+8>>2]|0;if((c[d+12>>2]|0)-l>>2>>>0>k>>>0?(h=c[l+(k<<2)>>2]|0,(h|0)!=0):0){u=0;k=qa(c[(c[h>>2]|0)+12>>2]|0,h|0)|0;n=u;u=0;if(n&1){break}c[e>>2]=k;u=0;e=qa(c[(c[h>>2]|0)+16>>2]|0,h|0)|0;n=u;u=0;if(n&1){break}c[f>>2]=e;u=0;oa(c[(c[h>>2]|0)+20>>2]|0,a|0,h|0);n=u;u=0;if(n&1){break}qm(c[j>>2]|0)|0;i=g;return}n=Jb(4)|0;bv(n);u=0;Na(45,n|0,24312,171);n=u;u=0;if(n&1){break}}n=Jb(4)|0;bv(n);u=0;Na(45,n|0,24312,171);n=u;u=0}}while(0);n=qb(-1,-1)|0;qm(c[j>>2]|0)|0;vb(n|0)}function Jp(b,d,e,f,g,h,j,k,l,m,n,o){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;l=l|0;m=m|0;n=n|0;o=o|0;var p=0,q=0;p=i;if((b|0)==(h|0)){if((a[d>>0]|0)==0){j=-1;i=p;return j|0}a[d>>0]=0;j=c[g>>2]|0;c[g>>2]=j+1;a[j>>0]=46;g=a[k>>0]|0;if((g&1)==0){g=(g&255)>>>1}else{g=c[k+4>>2]|0}if((g|0)==0){j=0;i=p;return j|0}g=c[m>>2]|0;if((g-l|0)>=160){j=0;i=p;return j|0}j=c[n>>2]|0;c[m>>2]=g+4;c[g>>2]=j;j=0;i=p;return j|0}if((b|0)==(j|0)){h=a[k>>0]|0;if((h&1)==0){h=(h&255)>>>1}else{h=c[k+4>>2]|0}if((h|0)!=0){if((a[d>>0]|0)==0){j=-1;i=p;return j|0}g=c[m>>2]|0;if((g-l|0)>=160){j=0;i=p;return j|0}j=c[n>>2]|0;c[m>>2]=g+4;c[g>>2]=j;c[n>>2]=0;j=0;i=p;return j|0}}h=o+128|0;j=o;do{if((c[j>>2]|0)==(b|0)){h=j;break}j=j+4|0}while((j|0)!=(h|0));b=h-o|0;h=b>>2;if((b|0)>124){j=-1;i=p;return j|0}o=a[14896+h>>0]|0;if((h|0)==24|(h|0)==25){n=c[g>>2]|0;if((n|0)!=(f|0)?(a[n+ -1>>0]&95|0)!=(a[e>>0]&127|0):0){j=-1;i=p;return j|0}c[g>>2]=n+1;a[n>>0]=o;j=0;i=p;return j|0}else if(!((h|0)==23|(h|0)==22)){f=o&95;if((f|0)==(a[e>>0]|0)?(a[e>>0]=f|128,(a[d>>0]|0)!=0):0){a[d>>0]=0;e=a[k>>0]|0;if((e&1)==0){k=(e&255)>>>1}else{k=c[k+4>>2]|0}if((k|0)!=0?(q=c[m>>2]|0,(q-l|0)<160):0){j=c[n>>2]|0;c[m>>2]=q+4;c[q>>2]=j}}}else{a[e>>0]=80}j=c[g>>2]|0;c[g>>2]=j+1;a[j>>0]=o;if((b|0)>84){j=0;i=p;return j|0}c[n>>2]=(c[n>>2]|0)+1;j=0;i=p;return j|0}function Kp(a){a=a|0;var b=0;b=i;Hv(a);i=b;return}function Lp(a){a=a|0;return}function Mp(b,d,e,f,g,h){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,o=0;k=i;i=i+32|0;n=k;o=k+28|0;m=k+24|0;j=k+12|0;if((c[f+4>>2]&1|0)==0){m=c[(c[d>>2]|0)+24>>2]|0;c[o>>2]=c[e>>2];h=h&1;c[n+0>>2]=c[o+0>>2];Jc[m&31](b,d,n,f,g,h);i=k;return}ln(m,f);g=c[m>>2]|0;if(!(!((c[4124]|0)==-1)?(c[n>>2]=16496,c[n+4>>2]=205,c[n+8>>2]=0,u=0,Na(58,16496,n|0,206),d=u,u=0,d&1):0)){n=(c[16500>>2]|0)+ -1|0;o=c[g+8>>2]|0;if((c[g+12>>2]|0)-o>>2>>>0>n>>>0?(l=c[o+(n<<2)>>2]|0,(l|0)!=0):0){qm(c[m>>2]|0)|0;m=c[l>>2]|0;if(h){zc[c[m+24>>2]&127](j,l)}else{zc[c[m+28>>2]&127](j,l)}g=a[j>>0]|0;if((g&1)==0){m=j+1|0;n=m;h=j+8|0}else{h=j+8|0;n=c[h>>2]|0;m=j+1|0}l=j+4|0;a:while(1){if((g&1)==0){o=m;g=(g&255)>>>1}else{o=c[h>>2]|0;g=c[l>>2]|0}if((n|0)==(o+g|0)){l=29;break}d=a[n>>0]|0;f=c[e>>2]|0;do{if((f|0)!=0){o=f+24|0;g=c[o>>2]|0;if((g|0)!=(c[f+28>>2]|0)){c[o>>2]=g+1;a[g>>0]=d;break}u=0;g=Ha(c[(c[f>>2]|0)+52>>2]|0,f|0,d&255|0)|0;d=u;u=0;if(d&1){l=28;break a}if((g|0)==-1){c[e>>2]=0}}}while(0);g=a[j>>0]|0;n=n+1|0}if((l|0)==28){d=qb(-1,-1)|0;Rm(j);vb(d|0)}else if((l|0)==29){c[b>>2]=c[e>>2];Rm(j);i=k;return}}d=Jb(4)|0;bv(d);u=0;Na(45,d|0,24312,171);d=u;u=0}d=qb(-1,-1)|0;qm(c[m>>2]|0)|0;vb(d|0)}function Np(b,d,e,f,g,h){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0;p=i;i=i+64|0;q=p;s=p+56|0;d=p+44|0;n=p+20|0;l=p+16|0;m=p+12|0;k=p+8|0;o=p+4|0;a[s+0>>0]=a[15144>>0]|0;a[s+1>>0]=a[15145>>0]|0;a[s+2>>0]=a[15146>>0]|0;a[s+3>>0]=a[15147>>0]|0;a[s+4>>0]=a[15148>>0]|0;a[s+5>>0]=a[15149>>0]|0;v=s+1|0;r=f+4|0;t=c[r>>2]|0;if((t&2048|0)!=0){a[v>>0]=43;v=s+2|0}if((t&512|0)!=0){a[v>>0]=35;v=v+1|0}a[v>>0]=108;v=v+1|0;w=t&74;do{if((w|0)==8){if((t&16384|0)==0){a[v>>0]=120;break}else{a[v>>0]=88;break}}else if((w|0)==64){a[v>>0]=111}else{a[v>>0]=100}}while(0);do{if((a[16248]|0)==0?(Ua(16248)|0)!=0:0){u=0;t=ua(33,2147483647,16256,0)|0;w=u;u=0;if(w&1){w=qb(-1,-1)|0;Eb(16248);vb(w|0)}else{c[4060]=t;rb(16248);break}}}while(0);w=c[4060]|0;c[q>>2]=h;s=Op(d,12,w,s,q)|0;h=d+s|0;r=c[r>>2]&176;do{if((r|0)==32){r=h}else if((r|0)==16){r=a[d>>0]|0;if(r<<24>>24==43|r<<24>>24==45){r=d+1|0;break}if((s|0)>1&r<<24>>24==48?(w=a[d+1>>0]|0,w<<24>>24==88|w<<24>>24==120):0){r=d+2|0}else{j=22}}else{j=22}}while(0);if((j|0)==22){r=d}ln(k,f);u=0;Da(41,d|0,r|0,h|0,n|0,l|0,m|0,k|0);w=u;u=0;if(w&1){w=qb(-1,-1)|0;qm(c[k>>2]|0)|0;vb(w|0)}else{qm(c[k>>2]|0)|0;c[o>>2]=c[e>>2];v=c[l>>2]|0;w=c[m>>2]|0;c[q+0>>2]=c[o+0>>2];ie(b,q,n,v,w,f,g);i=p;return}}function Op(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0;g=i;i=i+16|0;h=g;c[h>>2]=f;d=Nb(d|0)|0;e=ew(a,b,e,h)|0;if((d|0)==0){i=g;return e|0}u=0;qa(127,d|0)|0;h=u;u=0;if(h&1){h=qb(-1,-1,0)|0;jd(h)}else{i=g;return e|0}return 0}function Pp(b,d,e,f,g,h,j){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0;m=i;i=i+32|0;r=m;k=m+12|0;o=c[j>>2]|0;if(!((c[4088]|0)==-1)){c[r>>2]=16352;c[r+4>>2]=205;c[r+8>>2]=0;Lm(16352,r,206)}s=(c[16356>>2]|0)+ -1|0;t=c[o+8>>2]|0;if(!((c[o+12>>2]|0)-t>>2>>>0>s>>>0)){x=Jb(4)|0;bv(x);qc(x|0,24312,171)}o=c[t+(s<<2)>>2]|0;if((o|0)==0){x=Jb(4)|0;bv(x);qc(x|0,24312,171)}j=c[j>>2]|0;if(!((c[4124]|0)==-1)){c[r>>2]=16496;c[r+4>>2]=205;c[r+8>>2]=0;Lm(16496,r,206)}s=(c[16500>>2]|0)+ -1|0;r=c[j+8>>2]|0;if(!((c[j+12>>2]|0)-r>>2>>>0>s>>>0)){x=Jb(4)|0;bv(x);qc(x|0,24312,171)}r=c[r+(s<<2)>>2]|0;if((r|0)==0){x=Jb(4)|0;bv(x);qc(x|0,24312,171)}zc[c[(c[r>>2]|0)+20>>2]&127](k,r);j=a[k>>0]|0;if((j&1)==0){j=(j&255)>>>1}else{j=c[k+4>>2]|0}do{if((j|0)==0){u=0;Ma(c[(c[o>>2]|0)+32>>2]|0,o|0,b|0,e|0,f|0)|0;x=u;u=0;if(x&1){l=18}else{c[h>>2]=f+(e-b)}}else{c[h>>2]=f;j=a[b>>0]|0;if(j<<24>>24==43|j<<24>>24==45){u=0;j=Ha(c[(c[o>>2]|0)+28>>2]|0,o|0,j|0)|0;x=u;u=0;if(x&1){l=18;break}x=c[h>>2]|0;c[h>>2]=x+1;a[x>>0]=j;j=b+1|0}else{j=b}if(((e-j|0)>1?(a[j>>0]|0)==48:0)?(q=j+1|0,x=a[q>>0]|0,x<<24>>24==88|x<<24>>24==120):0){u=0;s=Ha(c[(c[o>>2]|0)+28>>2]|0,o|0,48)|0;x=u;u=0;if(x&1){l=18;break}x=c[h>>2]|0;c[h>>2]=x+1;a[x>>0]=s;u=0;q=Ha(c[(c[o>>2]|0)+28>>2]|0,o|0,a[q>>0]|0)|0;x=u;u=0;if(x&1){l=18;break}x=c[h>>2]|0;c[h>>2]=x+1;a[x>>0]=q;q=j+2|0}else{q=j}if((q|0)!=(e|0)?(p=e+ -1|0,p>>>0>q>>>0):0){j=q;do{x=a[j>>0]|0;a[j>>0]=a[p>>0]|0;a[p>>0]=x;j=j+1|0;p=p+ -1|0}while(j>>>0<p>>>0)}u=0;t=qa(c[(c[r>>2]|0)+16>>2]|0,r|0)|0;x=u;u=0;if(!(x&1)){a:do{if(q>>>0<e>>>0){j=k+1|0;s=k+4|0;r=k+8|0;v=0;w=0;p=q;while(1){x=(a[k>>0]&1)==0;if((a[(x?j:c[r>>2]|0)+w>>0]|0)!=0?(v|0)==(a[(x?j:c[r>>2]|0)+w>>0]|0):0){v=c[h>>2]|0;c[h>>2]=v+1;a[v>>0]=t;v=a[k>>0]|0;if((v&1)==0){x=(v&255)>>>1}else{x=c[s>>2]|0}v=0;w=(w>>>0<(x+ -1|0)>>>0&1)+w|0}u=0;x=Ha(c[(c[o>>2]|0)+28>>2]|0,o|0,a[p>>0]|0)|0;y=u;u=0;if(y&1){break}y=c[h>>2]|0;c[h>>2]=y+1;a[y>>0]=x;p=p+1|0;if(!(p>>>0<e>>>0)){break a}else{v=v+1|0}}y=qb(-1,-1)|0;Rm(k);vb(y|0)}}while(0);p=f+(q-b)|0;o=c[h>>2]|0;if((p|0)!=(o|0)?(n=o+ -1|0,n>>>0>p>>>0):0){do{y=a[p>>0]|0;a[p>>0]=a[n>>0]|0;a[n>>0]=y;p=p+1|0;n=n+ -1|0}while(p>>>0<n>>>0)}}else{l=18}}}while(0);if((l|0)==18){y=qb(-1,-1)|0;Rm(k);vb(y|0)}if((d|0)==(e|0)){y=c[h>>2]|0;c[g>>2]=y;Rm(k);i=m;return}else{y=f+(d-b)|0;c[g>>2]=y;Rm(k);i=m;return}}function Qp(b,d,e,f,g,h,j){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0;o=i;i=i+96|0;d=o+8|0;t=o;m=o+74|0;p=o+32|0;q=o+28|0;r=o+24|0;l=o+20|0;n=o+16|0;x=t;c[x>>2]=37;c[x+4>>2]=0;x=t+1|0;s=f+4|0;v=c[s>>2]|0;if((v&2048|0)!=0){a[x>>0]=43;x=t+2|0}if((v&512|0)!=0){a[x>>0]=35;x=x+1|0}w=x+2|0;a[x>>0]=108;a[x+1>>0]=108;x=v&74;do{if((x|0)==64){a[w>>0]=111}else if((x|0)==8){if((v&16384|0)==0){a[w>>0]=120;break}else{a[w>>0]=88;break}}else{a[w>>0]=100}}while(0);do{if((a[16248]|0)==0?(Ua(16248)|0)!=0:0){u=0;v=ua(33,2147483647,16256,0)|0;x=u;u=0;if(x&1){x=qb(-1,-1)|0;Eb(16248);vb(x|0)}else{c[4060]=v;rb(16248);break}}}while(0);x=c[4060]|0;w=d;c[w>>2]=h;c[w+4>>2]=j;j=Op(m,22,x,t,d)|0;h=m+j|0;s=c[s>>2]&176;do{if((s|0)==32){s=h}else if((s|0)==16){s=a[m>>0]|0;if(s<<24>>24==43|s<<24>>24==45){s=m+1|0;break}if((j|0)>1&s<<24>>24==48?(x=a[m+1>>0]|0,x<<24>>24==88|x<<24>>24==120):0){s=m+2|0}else{k=22}}else{k=22}}while(0);if((k|0)==22){s=m}ln(l,f);u=0;Da(41,m|0,s|0,h|0,p|0,q|0,r|0,l|0);x=u;u=0;if(x&1){x=qb(-1,-1)|0;qm(c[l>>2]|0)|0;vb(x|0)}else{qm(c[l>>2]|0)|0;c[n>>2]=c[e>>2];w=c[q>>2]|0;x=c[r>>2]|0;c[d+0>>2]=c[n+0>>2];ie(b,d,p,w,x,f,g);i=o;return}}function Rp(b,d,e,f,g,h){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0;p=i;i=i+64|0;d=p;s=p+56|0;q=p+44|0;n=p+20|0;l=p+16|0;m=p+12|0;k=p+8|0;o=p+4|0;a[s+0>>0]=a[15144>>0]|0;a[s+1>>0]=a[15145>>0]|0;a[s+2>>0]=a[15146>>0]|0;a[s+3>>0]=a[15147>>0]|0;a[s+4>>0]=a[15148>>0]|0;a[s+5>>0]=a[15149>>0]|0;v=s+1|0;r=f+4|0;t=c[r>>2]|0;if((t&2048|0)!=0){a[v>>0]=43;v=s+2|0}if((t&512|0)!=0){a[v>>0]=35;v=v+1|0}a[v>>0]=108;v=v+1|0;w=t&74;do{if((w|0)==8){if((t&16384|0)==0){a[v>>0]=120;break}else{a[v>>0]=88;break}}else if((w|0)==64){a[v>>0]=111}else{a[v>>0]=117}}while(0);do{if((a[16248]|0)==0?(Ua(16248)|0)!=0:0){u=0;t=ua(33,2147483647,16256,0)|0;w=u;u=0;if(w&1){w=qb(-1,-1)|0;Eb(16248);vb(w|0)}else{c[4060]=t;rb(16248);break}}}while(0);w=c[4060]|0;c[d>>2]=h;s=Op(q,12,w,s,d)|0;h=q+s|0;r=c[r>>2]&176;do{if((r|0)==16){r=a[q>>0]|0;if(r<<24>>24==43|r<<24>>24==45){r=q+1|0;break}if((s|0)>1&r<<24>>24==48?(w=a[q+1>>0]|0,w<<24>>24==88|w<<24>>24==120):0){r=q+2|0}else{j=22}}else if((r|0)==32){r=h}else{j=22}}while(0);if((j|0)==22){r=q}ln(k,f);u=0;Da(41,q|0,r|0,h|0,n|0,l|0,m|0,k|0);w=u;u=0;if(w&1){w=qb(-1,-1)|0;qm(c[k>>2]|0)|0;vb(w|0)}else{qm(c[k>>2]|0)|0;c[o>>2]=c[e>>2];v=c[l>>2]|0;w=c[m>>2]|0;c[d+0>>2]=c[o+0>>2];ie(b,d,n,v,w,f,g);i=p;return}}function Sp(b,d,e,f,g,h,j){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0;d=i;i=i+112|0;r=d+8|0;t=d;n=d+75|0;q=d+32|0;p=d+28|0;m=d+24|0;l=d+20|0;o=d+16|0;x=t;c[x>>2]=37;c[x+4>>2]=0;x=t+1|0;s=f+4|0;v=c[s>>2]|0;if((v&2048|0)!=0){a[x>>0]=43;x=t+2|0}if((v&512|0)!=0){a[x>>0]=35;x=x+1|0}w=x+2|0;a[x>>0]=108;a[x+1>>0]=108;x=v&74;do{if((x|0)==8){if((v&16384|0)==0){a[w>>0]=120;break}else{a[w>>0]=88;break}}else if((x|0)==64){a[w>>0]=111}else{a[w>>0]=117}}while(0);do{if((a[16248]|0)==0?(Ua(16248)|0)!=0:0){u=0;v=ua(33,2147483647,16256,0)|0;x=u;u=0;if(x&1){x=qb(-1,-1)|0;Eb(16248);vb(x|0)}else{c[4060]=v;rb(16248);break}}}while(0);x=c[4060]|0;w=r;c[w>>2]=h;c[w+4>>2]=j;h=Op(n,23,x,t,r)|0;j=n+h|0;s=c[s>>2]&176;do{if((s|0)==32){s=j}else if((s|0)==16){s=a[n>>0]|0;if(s<<24>>24==43|s<<24>>24==45){s=n+1|0;break}if((h|0)>1&s<<24>>24==48?(x=a[n+1>>0]|0,x<<24>>24==88|x<<24>>24==120):0){s=n+2|0}else{k=22}}else{k=22}}while(0);if((k|0)==22){s=n}ln(l,f);u=0;Da(41,n|0,s|0,j|0,q|0,p|0,m|0,l|0);x=u;u=0;if(x&1){x=qb(-1,-1)|0;qm(c[l>>2]|0)|0;vb(x|0)}else{qm(c[l>>2]|0)|0;c[o>>2]=c[e>>2];w=c[p>>2]|0;x=c[m>>2]|0;c[r+0>>2]=c[o+0>>2];ie(b,r,q,w,x,f,g);i=d;return}}function Tp(b,d,e,f,g,j){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;j=+j;var l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0;s=i;i=i+144|0;q=s+8|0;z=s;x=s+102|0;w=s+40|0;v=s+44|0;d=s+36|0;t=s+32|0;n=s+28|0;p=s+24|0;r=s+20|0;A=z;c[A>>2]=37;c[A+4>>2]=0;A=z+1|0;y=f+4|0;C=c[y>>2]|0;if((C&2048|0)!=0){a[A>>0]=43;A=z+2|0}if((C&1024|0)!=0){a[A>>0]=35;A=A+1|0}B=C&260;D=C>>>14;do{if((B|0)==260){if((D&1|0)==0){a[A>>0]=97;A=0;break}else{a[A>>0]=65;A=0;break}}else{a[A>>0]=46;C=A+2|0;a[A+1>>0]=42;if((B|0)==256){if((D&1|0)==0){a[C>>0]=101;A=1;break}else{a[C>>0]=69;A=1;break}}else if((B|0)==4){if((D&1|0)==0){a[C>>0]=102;A=1;break}else{a[C>>0]=70;A=1;break}}else{if((D&1|0)==0){a[C>>0]=103;A=1;break}else{a[C>>0]=71;A=1;break}}}}while(0);c[w>>2]=x;do{if((a[16248]|0)==0?(Ua(16248)|0)!=0:0){u=0;B=ua(33,2147483647,16256,0)|0;D=u;u=0;if(D&1){D=qb(-1,-1)|0;Eb(16248);vb(D|0)}else{c[4060]=B;rb(16248);break}}}while(0);B=c[4060]|0;if(A){c[q>>2]=c[f+8>>2];C=q+4|0;h[k>>3]=j;c[C>>2]=c[k>>2];c[C+4>>2]=c[k+4>>2];C=Op(x,30,B,z,q)|0}else{h[k>>3]=j;c[q>>2]=c[k>>2];c[q+4>>2]=c[k+4>>2];C=Op(x,30,B,z,q)|0}do{if((C|0)>29){B=(a[16248]|0)==0;a:do{if(A){do{if(B?(Ua(16248)|0)!=0:0){u=0;A=ua(33,2147483647,16256,0)|0;D=u;u=0;if(D&1){l=qb(-1,-1)|0;Eb(16248);break a}else{c[4060]=A;rb(16248);break}}}while(0);C=c[4060]|0;u=0;c[q>>2]=c[f+8>>2];D=q+4|0;h[k>>3]=j;c[D>>2]=c[k>>2];c[D+4>>2]=c[k+4>>2];C=Ma(16,w|0,C|0,z|0,q|0)|0;D=u;u=0;if(D&1){o=36}else{o=44}}else{do{if(B?(Ua(16248)|0)!=0:0){u=0;A=ua(33,2147483647,16256,0)|0;D=u;u=0;if(D&1){l=qb(-1,-1)|0;Eb(16248);break a}else{c[4060]=A;rb(16248);break}}}while(0);C=c[4060]|0;u=0;c[q>>2]=c[f+8>>2];D=q+4|0;h[k>>3]=j;c[D>>2]=c[k>>2];c[D+4>>2]=c[k+4>>2];C=Ma(16,w|0,C|0,z|0,q|0)|0;D=u;u=0;if(D&1){o=36}else{o=44}}}while(0);if((o|0)==44){A=c[w>>2]|0;if((A|0)!=0){z=A;break}u=0;Oa(4);D=u;u=0;if(D&1){o=36}else{A=c[w>>2]|0;z=A;break}}if((o|0)==36){l=qb(-1,-1)|0}D=l;vb(D|0)}else{z=0;A=c[w>>2]|0}}while(0);B=A+C|0;y=c[y>>2]&176;do{if((y|0)==16){y=a[A>>0]|0;if(y<<24>>24==43|y<<24>>24==45){y=A+1|0;break}if((C|0)>1&y<<24>>24==48?(D=a[A+1>>0]|0,D<<24>>24==88|D<<24>>24==120):0){y=A+2|0}else{o=53}}else if((y|0)==32){y=B}else{o=53}}while(0);if((o|0)==53){y=A}if((A|0)!=(x|0)){o=Av(C<<1)|0;if((o|0)==0){u=0;Oa(4);D=u;u=0;if(D&1){m=0;o=58}else{C=0;x=c[w>>2]|0;v=0;o=59}}else{C=o;x=A;v=o;o=59}}else{C=0;o=59}do{if((o|0)==59){u=0;oa(84,n|0,f|0);D=u;u=0;if(!(D&1)){u=0;Da(42,x|0,y|0,B|0,v|0,d|0,t|0,n|0);D=u;u=0;if(D&1){l=qb(-1,-1)|0;qm(c[n>>2]|0)|0;m=C;break}qm(c[n>>2]|0)|0;c[r>>2]=c[e>>2];B=c[d>>2]|0;D=c[t>>2]|0;u=0;c[q+0>>2]=c[r+0>>2];Da(39,p|0,q|0,v|0,B|0,D|0,f|0,g|0);D=u;u=0;if(!(D&1)){D=c[p>>2]|0;c[e>>2]=D;c[b>>2]=D;if((C|0)!=0?(u=0,na(207,C|0),D=u,u=0,D&1):0){D=qb(-1,-1,0)|0;jd(D)}if((z|0)==0){i=s;return}u=0;na(207,z|0);D=u;u=0;if(D&1){D=qb(-1,-1,0)|0;jd(D)}else{i=s;return}}else{m=C;o=58}}else{m=C;o=58}}}while(0);if((o|0)==58){l=qb(-1,-1)|0}if((m|0)!=0?(u=0,na(207,m|0),D=u,u=0,D&1):0){D=qb(-1,-1,0)|0;jd(D)}if((z|0)==0){D=l;vb(D|0)}u=0;na(207,z|0);D=u;u=0;if(D&1){D=qb(-1,-1,0)|0;jd(D)}else{D=l;vb(D|0)}}function Up(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0;f=i;i=i+16|0;g=f;c[g>>2]=e;b=Nb(b|0)|0;u=0;d=ua(34,a|0,d|0,g|0)|0;e=u;u=0;if(e&1){f=qb(-1,-1)|0;if((b|0)==0){vb(f|0)}u=0;qa(127,b|0)|0;g=u;u=0;if(g&1){g=qb(-1,-1,0)|0;jd(g)}else{vb(f|0)}}else{if((b|0)==0){i=f;return d|0}u=0;qa(127,b|0)|0;g=u;u=0;if(g&1){g=qb(-1,-1,0)|0;jd(g)}else{i=f;return d|0}}return 0}function Vp(b,d,e,f,g,h,j){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0;k=i;i=i+32|0;o=k;l=k+12|0;m=c[j>>2]|0;if(!((c[4088]|0)==-1)){c[o>>2]=16352;c[o+4>>2]=205;c[o+8>>2]=0;Lm(16352,o,206)}t=(c[16356>>2]|0)+ -1|0;s=c[m+8>>2]|0;if(!((c[m+12>>2]|0)-s>>2>>>0>t>>>0)){z=Jb(4)|0;bv(z);qc(z|0,24312,171)}m=c[s+(t<<2)>>2]|0;if((m|0)==0){z=Jb(4)|0;bv(z);qc(z|0,24312,171)}j=c[j>>2]|0;if(!((c[4124]|0)==-1)){c[o>>2]=16496;c[o+4>>2]=205;c[o+8>>2]=0;Lm(16496,o,206)}s=(c[16500>>2]|0)+ -1|0;o=c[j+8>>2]|0;if(!((c[j+12>>2]|0)-o>>2>>>0>s>>>0)){z=Jb(4)|0;bv(z);qc(z|0,24312,171)}j=c[o+(s<<2)>>2]|0;if((j|0)==0){z=Jb(4)|0;bv(z);qc(z|0,24312,171)}zc[c[(c[j>>2]|0)+20>>2]&127](l,j);c[h>>2]=f;o=a[b>>0]|0;if(o<<24>>24==43|o<<24>>24==45){u=0;o=Ha(c[(c[m>>2]|0)+28>>2]|0,m|0,o|0)|0;z=u;u=0;if(!(z&1)){t=c[h>>2]|0;c[h>>2]=t+1;a[t>>0]=o;t=b+1|0;q=20}}else{t=b;q=20}a:do{if((q|0)==20){o=e;b:do{if(((o-t|0)>1?(a[t>>0]|0)==48:0)?(r=t+1|0,z=a[r>>0]|0,z<<24>>24==88|z<<24>>24==120):0){u=0;s=Ha(c[(c[m>>2]|0)+28>>2]|0,m|0,48)|0;z=u;u=0;if(z&1){break a}z=c[h>>2]|0;c[h>>2]=z+1;a[z>>0]=s;t=t+2|0;u=0;r=Ha(c[(c[m>>2]|0)+28>>2]|0,m|0,a[r>>0]|0)|0;z=u;u=0;if(z&1){break a}z=c[h>>2]|0;c[h>>2]=z+1;a[z>>0]=r;if(t>>>0<e>>>0){s=t;while(1){r=a[s>>0]|0;if((a[16248]|0)==0?(Ua(16248)|0)!=0:0){u=0;v=ua(33,2147483647,16256,0)|0;z=u;u=0;if(z&1){q=32;break}c[4060]=v;rb(16248)}u=0;r=Ha(39,r<<24>>24|0,c[4060]|0)|0;z=u;u=0;if(z&1){q=17;break}v=s+1|0;if((r|0)==0){r=t;break b}if(v>>>0<e>>>0){s=v}else{r=t;s=v;break b}}if((q|0)==17){z=qb(-1,-1)|0;Rm(l);vb(z|0)}else if((q|0)==32){z=qb(-1,-1)|0;Eb(16248);Rm(l);vb(z|0)}}else{r=t;s=t}}else{q=21}}while(0);c:do{if((q|0)==21){if(t>>>0<e>>>0){s=t;while(1){q=a[s>>0]|0;if((a[16248]|0)==0?(Ua(16248)|0)!=0:0){u=0;r=ua(33,2147483647,16256,0)|0;z=u;u=0;if(z&1){q=40;break}c[4060]=r;rb(16248)}u=0;r=Ha(40,q<<24>>24|0,c[4060]|0)|0;z=u;u=0;if(z&1){q=16;break}q=s+1|0;if((r|0)==0){r=t;break c}if(q>>>0<e>>>0){s=q}else{r=t;s=q;break c}}if((q|0)==16){z=qb(-1,-1)|0;Rm(l);vb(z|0)}else if((q|0)==40){z=qb(-1,-1)|0;Eb(16248);Rm(l);vb(z|0)}}else{r=t;s=t}}}while(0);q=a[l>>0]|0;if((q&1)==0){q=(q&255)>>>1}else{q=c[l+4>>2]|0}if((q|0)!=0){if((r|0)!=(s|0)?(p=s+ -1|0,p>>>0>r>>>0):0){q=r;do{z=a[q>>0]|0;a[q>>0]=a[p>>0]|0;a[p>>0]=z;q=q+1|0;p=p+ -1|0}while(q>>>0<p>>>0)}u=0;t=qa(c[(c[j>>2]|0)+16>>2]|0,j|0)|0;z=u;u=0;if(z&1){break}d:do{if(r>>>0<s>>>0){p=l+1|0;v=l+4|0;q=l+8|0;x=0;y=0;w=r;while(1){z=(a[l>>0]&1)==0;if((a[(z?p:c[q>>2]|0)+y>>0]|0)>0?(x|0)==(a[(z?p:c[q>>2]|0)+y>>0]|0):0){x=c[h>>2]|0;c[h>>2]=x+1;a[x>>0]=t;x=a[l>>0]|0;if((x&1)==0){z=(x&255)>>>1}else{z=c[v>>2]|0}x=0;y=(y>>>0<(z+ -1|0)>>>0&1)+y|0}u=0;z=Ha(c[(c[m>>2]|0)+28>>2]|0,m|0,a[w>>0]|0)|0;A=u;u=0;if(A&1){break}A=c[h>>2]|0;c[h>>2]=A+1;a[A>>0]=z;w=w+1|0;if(!(w>>>0<s>>>0)){break d}else{x=x+1|0}}A=qb(-1,-1)|0;Rm(l);vb(A|0)}}while(0);p=f+(r-b)|0;q=c[h>>2]|0;if((p|0)!=(q|0)?(n=q+ -1|0,n>>>0>p>>>0):0){do{A=a[p>>0]|0;a[p>>0]=a[n>>0]|0;a[n>>0]=A;p=p+1|0;n=n+ -1|0}while(p>>>0<n>>>0)}}else{u=0;Ma(c[(c[m>>2]|0)+32>>2]|0,m|0,r|0,s|0,c[h>>2]|0)|0;A=u;u=0;if(A&1){break}c[h>>2]=(c[h>>2]|0)+(s-r)}e:do{if(s>>>0<e>>>0){while(1){n=a[s>>0]|0;if(n<<24>>24==46){q=69;break}u=0;n=Ha(c[(c[m>>2]|0)+28>>2]|0,m|0,n|0)|0;A=u;u=0;if(A&1){q=14;break}A=c[h>>2]|0;c[h>>2]=A+1;a[A>>0]=n;s=s+1|0;if(!(s>>>0<e>>>0)){break e}}if((q|0)==14){A=qb(-1,-1)|0;Rm(l);vb(A|0)}else if((q|0)==69){u=0;n=qa(c[(c[j>>2]|0)+12>>2]|0,j|0)|0;A=u;u=0;if(A&1){break a}A=c[h>>2]|0;c[h>>2]=A+1;a[A>>0]=n;s=s+1|0;break}}}while(0);u=0;Ma(c[(c[m>>2]|0)+32>>2]|0,m|0,s|0,e|0,c[h>>2]|0)|0;A=u;u=0;if(!(A&1)){m=(c[h>>2]|0)+(o-s)|0;c[h>>2]=m;if((d|0)==(e|0)){A=m;c[g>>2]=A;Rm(l);i=k;return}A=f+(d-b)|0;c[g>>2]=A;Rm(l);i=k;return}}}while(0);A=qb(-1,-1)|0;Rm(l);vb(A|0)}function Wp(b,d,e,f,g,j){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;j=+j;var l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0;r=i;i=i+144|0;d=r+8|0;x=r;v=r+102|0;t=r+40|0;s=r+44|0;o=r+36|0;p=r+32|0;q=r+28|0;m=r+24|0;n=r+20|0;A=x;c[A>>2]=37;c[A+4>>2]=0;A=x+1|0;w=f+4|0;z=c[w>>2]|0;if((z&2048|0)!=0){a[A>>0]=43;A=x+2|0}if((z&1024|0)!=0){a[A>>0]=35;A=A+1|0}y=z&260;z=z>>>14;do{if((y|0)==260){a[A>>0]=76;y=A+1|0;if((z&1|0)==0){a[y>>0]=97;y=0;break}else{a[y>>0]=65;y=0;break}}else{a[A>>0]=46;a[A+1>>0]=42;a[A+2>>0]=76;A=A+3|0;if((y|0)==4){if((z&1|0)==0){a[A>>0]=102;y=1;break}else{a[A>>0]=70;y=1;break}}else if((y|0)==256){if((z&1|0)==0){a[A>>0]=101;y=1;break}else{a[A>>0]=69;y=1;break}}else{if((z&1|0)==0){a[A>>0]=103;y=1;break}else{a[A>>0]=71;y=1;break}}}}while(0);c[t>>2]=v;do{if((a[16248]|0)==0?(Ua(16248)|0)!=0:0){u=0;z=ua(33,2147483647,16256,0)|0;A=u;u=0;if(A&1){A=qb(-1,-1)|0;Eb(16248);vb(A|0)}else{c[4060]=z;rb(16248);break}}}while(0);z=c[4060]|0;if(y){c[d>>2]=c[f+8>>2];A=d+4|0;h[k>>3]=j;c[A>>2]=c[k>>2];c[A+4>>2]=c[k+4>>2];A=Op(v,30,z,x,d)|0}else{h[k>>3]=j;c[d>>2]=c[k>>2];c[d+4>>2]=c[k+4>>2];A=Op(v,30,z,x,d)|0}do{if((A|0)>29){z=(a[16248]|0)==0;a:do{if(y){do{if(z?(Ua(16248)|0)!=0:0){u=0;y=ua(33,2147483647,16256,0)|0;A=u;u=0;if(A&1){e=qb(-1,-1)|0;Eb(16248);break a}else{c[4060]=y;rb(16248);break}}}while(0);A=c[4060]|0;u=0;c[d>>2]=c[f+8>>2];z=d+4|0;h[k>>3]=j;c[z>>2]=c[k>>2];c[z+4>>2]=c[k+4>>2];A=Ma(16,t|0,A|0,x|0,d|0)|0;z=u;u=0;if(z&1){l=36}else{l=44}}else{do{if(z?(Ua(16248)|0)!=0:0){u=0;y=ua(33,2147483647,16256,0)|0;A=u;u=0;if(A&1){e=qb(-1,-1)|0;Eb(16248);break a}else{c[4060]=y;rb(16248);break}}}while(0);A=c[4060]|0;u=0;h[k>>3]=j;c[d>>2]=c[k>>2];c[d+4>>2]=c[k+4>>2];A=Ma(16,t|0,A|0,x|0,d|0)|0;z=u;u=0;if(z&1){l=36}else{l=44}}}while(0);if((l|0)==44){y=c[t>>2]|0;if((y|0)!=0){x=y;break}u=0;Oa(4);z=u;u=0;if(z&1){l=36}else{y=c[t>>2]|0;x=y;break}}if((l|0)==36){e=qb(-1,-1)|0}A=e;vb(A|0)}else{x=0;y=c[t>>2]|0}}while(0);z=y+A|0;w=c[w>>2]&176;do{if((w|0)==32){w=z}else if((w|0)==16){w=a[y>>0]|0;if(w<<24>>24==43|w<<24>>24==45){w=y+1|0;break}if((A|0)>1&w<<24>>24==48?(w=a[y+1>>0]|0,w<<24>>24==88|w<<24>>24==120):0){w=y+2|0}else{l=53}}else{l=53}}while(0);if((l|0)==53){w=y}if((y|0)!=(v|0)){l=Av(A<<1)|0;if((l|0)==0){u=0;Oa(4);A=u;u=0;if(A&1){A=0;l=58}else{A=0;v=c[t>>2]|0;s=0;l=59}}else{A=l;v=y;s=l;l=59}}else{A=0;l=59}do{if((l|0)==59){u=0;oa(84,q|0,f|0);y=u;u=0;if(!(y&1)){u=0;Da(42,v|0,w|0,z|0,s|0,o|0,p|0,q|0);z=u;u=0;if(z&1){e=qb(-1,-1)|0;qm(c[q>>2]|0)|0;break}qm(c[q>>2]|0)|0;c[n>>2]=c[e>>2];y=c[o>>2]|0;z=c[p>>2]|0;u=0;c[d+0>>2]=c[n+0>>2];Da(39,m|0,d|0,s|0,y|0,z|0,f|0,g|0);z=u;u=0;if(!(z&1)){z=c[m>>2]|0;c[e>>2]=z;c[b>>2]=z;if((A|0)!=0){Bv(A)}if((x|0)==0){i=r;return}Bv(x);i=r;return}else{l=58}}else{l=58}}}while(0);if((l|0)==58){e=qb(-1,-1)|0}if((A|0)!=0){Bv(A)}if((x|0)==0){A=e;vb(A|0)}Bv(x);A=e;vb(A|0)}function Xp(b,d,e,f,g,h){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;n=i;i=i+96|0;d=n;r=n+80|0;m=n+60|0;j=n+20|0;o=n+16|0;k=n+12|0;a[r+0>>0]=a[15152>>0]|0;a[r+1>>0]=a[15153>>0]|0;a[r+2>>0]=a[15154>>0]|0;a[r+3>>0]=a[15155>>0]|0;a[r+4>>0]=a[15156>>0]|0;a[r+5>>0]=a[15157>>0]|0;do{if((a[16248]|0)==0?(Ua(16248)|0)!=0:0){u=0;q=ua(33,2147483647,16256,0)|0;t=u;u=0;if(t&1){t=qb(-1,-1)|0;Eb(16248);vb(t|0)}else{c[4060]=q;rb(16248);break}}}while(0);q=c[4060]|0;c[d>>2]=h;q=Op(m,20,q,r,d)|0;h=m+q|0;r=c[f+4>>2]&176;do{if((r|0)==16){r=a[m>>0]|0;if(r<<24>>24==43|r<<24>>24==45){r=m+1|0;break}if((q|0)>1&r<<24>>24==48?(t=a[m+1>>0]|0,t<<24>>24==88|t<<24>>24==120):0){r=m+2|0}else{p=12}}else if((r|0)==32){r=h}else{p=12}}while(0);if((p|0)==12){r=m}ln(o,f);s=c[o>>2]|0;if(!((c[4088]|0)==-1)?(c[d>>2]=16352,c[d+4>>2]=205,c[d+8>>2]=0,u=0,Na(58,16352,d|0,206),t=u,u=0,t&1):0){t=qb(-1,-1)|0;s=c[o>>2]|0;qm(s)|0;vb(t|0)}p=(c[16356>>2]|0)+ -1|0;t=c[s+8>>2]|0;if((c[s+12>>2]|0)-t>>2>>>0>p>>>0?(l=c[t+(p<<2)>>2]|0,(l|0)!=0):0){qm(c[o>>2]|0)|0;Xc[c[(c[l>>2]|0)+32>>2]&31](l,m,h,j)|0;l=j+q|0;if((r|0)==(h|0)){t=l;s=c[e>>2]|0;c[k>>2]=s;c[d+0>>2]=c[k+0>>2];ie(b,d,j,t,l,f,g);i=n;return}t=j+(r-m)|0;s=c[e>>2]|0;c[k>>2]=s;c[d+0>>2]=c[k+0>>2];ie(b,d,j,t,l,f,g);i=n;return}t=Jb(4)|0;bv(t);u=0;Na(45,t|0,24312,171);t=u;u=0;if(t&1){t=qb(-1,-1)|0;s=c[o>>2]|0;qm(s)|0;vb(t|0)}}function Yp(a){a=a|0;var b=0;b=i;Hv(a);i=b;return}function Zp(a){a=a|0;return}function _p(b,d,e,f,g,h){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,o=0;k=i;i=i+32|0;n=k;o=k+28|0;l=k+24|0;j=k+12|0;if((c[f+4>>2]&1|0)==0){l=c[(c[d>>2]|0)+24>>2]|0;c[o>>2]=c[e>>2];m=h&1;c[n+0>>2]=c[o+0>>2];Jc[l&31](b,d,n,f,g,m);i=k;return}ln(l,f);o=c[l>>2]|0;if(!(!((c[4126]|0)==-1)?(c[n>>2]=16504,c[n+4>>2]=205,c[n+8>>2]=0,u=0,Na(58,16504,n|0,206),g=u,u=0,g&1):0)){n=(c[16508>>2]|0)+ -1|0;d=c[o+8>>2]|0;if((c[o+12>>2]|0)-d>>2>>>0>n>>>0?(m=c[d+(n<<2)>>2]|0,(m|0)!=0):0){qm(c[l>>2]|0)|0;l=c[m>>2]|0;if(h){zc[c[l+24>>2]&127](j,m)}else{zc[c[l+28>>2]&127](j,m)}o=a[j>>0]|0;if((o&1)==0){l=j+4|0;m=l;h=j+8|0}else{h=j+8|0;m=c[h>>2]|0;l=j+4|0}while(1){if((o&1)==0){n=l;o=(o&255)>>>1}else{n=c[h>>2]|0;o=c[l>>2]|0}if((m|0)==(n+(o<<2)|0)){h=29;break}d=c[m>>2]|0;f=c[e>>2]|0;if((f|0)!=0){o=f+24|0;n=c[o>>2]|0;if((n|0)==(c[f+28>>2]|0)){u=0;d=Ha(c[(c[f>>2]|0)+52>>2]|0,f|0,d|0)|0;g=u;u=0;if(g&1){h=28;break}}else{c[o>>2]=n+4;c[n>>2]=d}if((d|0)==-1){c[e>>2]=0}}o=a[j>>0]|0;m=m+4|0}if((h|0)==28){g=qb(-1,-1)|0;bn(j);vb(g|0)}else if((h|0)==29){c[b>>2]=c[e>>2];bn(j);i=k;return}}g=Jb(4)|0;bv(g);u=0;Na(45,g|0,24312,171);g=u;u=0}g=qb(-1,-1)|0;qm(c[l>>2]|0)|0;vb(g|0)}function $p(b,d,e,f,g,h){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0;n=i;i=i+128|0;d=n;s=n+116|0;l=n+104|0;o=n+20|0;p=n+16|0;q=n+12|0;k=n+8|0;m=n+4|0;a[s+0>>0]=a[15144>>0]|0;a[s+1>>0]=a[15145>>0]|0;a[s+2>>0]=a[15146>>0]|0;a[s+3>>0]=a[15147>>0]|0;a[s+4>>0]=a[15148>>0]|0;a[s+5>>0]=a[15149>>0]|0;v=s+1|0;r=f+4|0;t=c[r>>2]|0;if((t&2048|0)!=0){a[v>>0]=43;v=s+2|0}if((t&512|0)!=0){a[v>>0]=35;v=v+1|0}a[v>>0]=108;w=v+1|0;v=t&74;do{if((v|0)==64){a[w>>0]=111}else if((v|0)==8){if((t&16384|0)==0){a[w>>0]=120;break}else{a[w>>0]=88;break}}else{a[w>>0]=100}}while(0);do{if((a[16248]|0)==0?(Ua(16248)|0)!=0:0){u=0;t=ua(33,2147483647,16256,0)|0;w=u;u=0;if(w&1){w=qb(-1,-1)|0;Eb(16248);vb(w|0)}else{c[4060]=t;rb(16248);break}}}while(0);w=c[4060]|0;c[d>>2]=h;s=Op(l,12,w,s,d)|0;h=l+s|0;r=c[r>>2]&176;do{if((r|0)==32){r=h}else if((r|0)==16){r=a[l>>0]|0;if(r<<24>>24==43|r<<24>>24==45){r=l+1|0;break}if((s|0)>1&r<<24>>24==48?(w=a[l+1>>0]|0,w<<24>>24==88|w<<24>>24==120):0){r=l+2|0}else{j=22}}else{j=22}}while(0);if((j|0)==22){r=l}ln(k,f);u=0;Da(43,l|0,r|0,h|0,o|0,p|0,q|0,k|0);w=u;u=0;if(w&1){w=qb(-1,-1)|0;qm(c[k>>2]|0)|0;vb(w|0)}else{qm(c[k>>2]|0)|0;c[m>>2]=c[e>>2];v=c[p>>2]|0;w=c[q>>2]|0;c[d+0>>2]=c[m+0>>2];bq(b,d,o,v,w,f,g);i=n;return}}



function aq(b,d,e,f,g,h,j){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0;l=i;i=i+32|0;q=l;m=l+12|0;t=c[j>>2]|0;if(!((c[4086]|0)==-1)){c[q>>2]=16344;c[q+4>>2]=205;c[q+8>>2]=0;Lm(16344,q,206)}o=(c[16348>>2]|0)+ -1|0;s=c[t+8>>2]|0;if(!((c[t+12>>2]|0)-s>>2>>>0>o>>>0)){y=Jb(4)|0;bv(y);qc(y|0,24312,171)}o=c[s+(o<<2)>>2]|0;if((o|0)==0){y=Jb(4)|0;bv(y);qc(y|0,24312,171)}j=c[j>>2]|0;if(!((c[4126]|0)==-1)){c[q>>2]=16504;c[q+4>>2]=205;c[q+8>>2]=0;Lm(16504,q,206)}s=(c[16508>>2]|0)+ -1|0;q=c[j+8>>2]|0;if(!((c[j+12>>2]|0)-q>>2>>>0>s>>>0)){y=Jb(4)|0;bv(y);qc(y|0,24312,171)}j=c[q+(s<<2)>>2]|0;if((j|0)==0){y=Jb(4)|0;bv(y);qc(y|0,24312,171)}zc[c[(c[j>>2]|0)+20>>2]&127](m,j);q=a[m>>0]|0;if((q&1)==0){q=(q&255)>>>1}else{q=c[m+4>>2]|0}do{if((q|0)==0){u=0;Ma(c[(c[o>>2]|0)+48>>2]|0,o|0,b|0,e|0,f|0)|0;y=u;u=0;if(y&1){k=18}else{x=f+(e-b<<2)|0;c[h>>2]=x}}else{c[h>>2]=f;q=a[b>>0]|0;if(q<<24>>24==43|q<<24>>24==45){u=0;q=Ha(c[(c[o>>2]|0)+44>>2]|0,o|0,q|0)|0;y=u;u=0;if(y&1){k=18;break}y=c[h>>2]|0;c[h>>2]=y+4;c[y>>2]=q;q=b+1|0}else{q=b}if(((e-q|0)>1?(a[q>>0]|0)==48:0)?(r=q+1|0,y=a[r>>0]|0,y<<24>>24==88|y<<24>>24==120):0){u=0;s=Ha(c[(c[o>>2]|0)+44>>2]|0,o|0,48)|0;y=u;u=0;if(y&1){k=18;break}y=c[h>>2]|0;c[h>>2]=y+4;c[y>>2]=s;u=0;r=Ha(c[(c[o>>2]|0)+44>>2]|0,o|0,a[r>>0]|0)|0;y=u;u=0;if(y&1){k=18;break}y=c[h>>2]|0;c[h>>2]=y+4;c[y>>2]=r;q=q+2|0}if((q|0)!=(e|0)?(p=e+ -1|0,p>>>0>q>>>0):0){r=q;do{y=a[r>>0]|0;a[r>>0]=a[p>>0]|0;a[p>>0]=y;r=r+1|0;p=p+ -1|0}while(r>>>0<p>>>0)}u=0;r=qa(c[(c[j>>2]|0)+16>>2]|0,j|0)|0;y=u;u=0;if(!(y&1)){a:do{if(q>>>0<e>>>0){p=m+1|0;t=m+4|0;j=m+8|0;v=0;w=0;s=q;while(1){y=(a[m>>0]&1)==0;if((a[(y?p:c[j>>2]|0)+w>>0]|0)!=0?(v|0)==(a[(y?p:c[j>>2]|0)+w>>0]|0):0){v=c[h>>2]|0;c[h>>2]=v+4;c[v>>2]=r;v=a[m>>0]|0;if((v&1)==0){x=(v&255)>>>1}else{x=c[t>>2]|0}v=0;w=(w>>>0<(x+ -1|0)>>>0&1)+w|0}u=0;y=Ha(c[(c[o>>2]|0)+44>>2]|0,o|0,a[s>>0]|0)|0;x=u;u=0;if(x&1){break}z=c[h>>2]|0;x=z+4|0;c[h>>2]=x;c[z>>2]=y;s=s+1|0;if(!(s>>>0<e>>>0)){break a}else{v=v+1|0}}z=qb(-1,-1)|0;Rm(m);vb(z|0)}else{x=c[h>>2]|0}}while(0);h=f+(q-b<<2)|0;if((h|0)!=(x|0)?(n=x+ -4|0,n>>>0>h>>>0):0){do{z=c[h>>2]|0;c[h>>2]=c[n>>2];c[n>>2]=z;h=h+4|0;n=n+ -4|0}while(h>>>0<n>>>0)}}else{k=18}}}while(0);if((k|0)==18){z=qb(-1,-1)|0;Rm(m);vb(z|0)}if((d|0)==(e|0)){z=x;c[g>>2]=z;Rm(m);i=l;return}z=f+(d-b<<2)|0;c[g>>2]=z;Rm(m);i=l;return}function bq(b,d,e,f,g,h,j){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0;l=i;i=i+16|0;m=l;k=c[d>>2]|0;if((k|0)==0){c[b>>2]=0;i=l;return}q=e;o=g-q>>2;h=h+12|0;n=c[h>>2]|0;o=(n|0)>(o|0)?n-o|0:0;n=f;q=n-q|0;p=q>>2;if((q|0)>0?(Fc[c[(c[k>>2]|0)+48>>2]&63](k,e,p)|0)!=(p|0):0){c[d>>2]=0;c[b>>2]=0;i=l;return}do{if((o|0)>0){an(m,o,j);if((a[m>>0]&1)==0){e=m+4|0}else{e=c[m+8>>2]|0}u=0;e=ua(c[(c[k>>2]|0)+48>>2]|0,k|0,e|0,o|0)|0;q=u;u=0;if(q&1){q=qb(-1,-1)|0;bn(m);vb(q|0)}if((e|0)==(o|0)){bn(m);break}c[d>>2]=0;c[b>>2]=0;bn(m);i=l;return}}while(0);q=g-n|0;m=q>>2;if((q|0)>0?(Fc[c[(c[k>>2]|0)+48>>2]&63](k,f,m)|0)!=(m|0):0){c[d>>2]=0;c[b>>2]=0;i=l;return}c[h>>2]=0;c[b>>2]=k;i=l;return}function cq(b,d,e,f,g,h,j){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0;d=i;i=i+224|0;n=d+8|0;t=d;r=d+196|0;q=d+32|0;p=d+28|0;m=d+24|0;l=d+20|0;o=d+16|0;x=t;c[x>>2]=37;c[x+4>>2]=0;x=t+1|0;s=f+4|0;v=c[s>>2]|0;if((v&2048|0)!=0){a[x>>0]=43;x=t+2|0}if((v&512|0)!=0){a[x>>0]=35;x=x+1|0}w=x+2|0;a[x>>0]=108;a[x+1>>0]=108;x=v&74;do{if((x|0)==8){if((v&16384|0)==0){a[w>>0]=120;break}else{a[w>>0]=88;break}}else if((x|0)==64){a[w>>0]=111}else{a[w>>0]=100}}while(0);do{if((a[16248]|0)==0?(Ua(16248)|0)!=0:0){u=0;v=ua(33,2147483647,16256,0)|0;x=u;u=0;if(x&1){x=qb(-1,-1)|0;Eb(16248);vb(x|0)}else{c[4060]=v;rb(16248);break}}}while(0);x=c[4060]|0;w=n;c[w>>2]=h;c[w+4>>2]=j;h=Op(r,22,x,t,n)|0;j=r+h|0;s=c[s>>2]&176;do{if((s|0)==16){s=a[r>>0]|0;if(s<<24>>24==43|s<<24>>24==45){s=r+1|0;break}if((h|0)>1&s<<24>>24==48?(x=a[r+1>>0]|0,x<<24>>24==88|x<<24>>24==120):0){s=r+2|0}else{k=22}}else if((s|0)==32){s=j}else{k=22}}while(0);if((k|0)==22){s=r}ln(l,f);u=0;Da(43,r|0,s|0,j|0,q|0,p|0,m|0,l|0);x=u;u=0;if(x&1){x=qb(-1,-1)|0;qm(c[l>>2]|0)|0;vb(x|0)}else{qm(c[l>>2]|0)|0;c[o>>2]=c[e>>2];w=c[p>>2]|0;x=c[m>>2]|0;c[n+0>>2]=c[o+0>>2];bq(b,n,q,w,x,f,g);i=d;return}}function dq(b,d,e,f,g,h){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0;p=i;i=i+128|0;d=p;s=p+116|0;q=p+104|0;n=p+20|0;l=p+16|0;m=p+12|0;k=p+8|0;o=p+4|0;a[s+0>>0]=a[15144>>0]|0;a[s+1>>0]=a[15145>>0]|0;a[s+2>>0]=a[15146>>0]|0;a[s+3>>0]=a[15147>>0]|0;a[s+4>>0]=a[15148>>0]|0;a[s+5>>0]=a[15149>>0]|0;v=s+1|0;r=f+4|0;t=c[r>>2]|0;if((t&2048|0)!=0){a[v>>0]=43;v=s+2|0}if((t&512|0)!=0){a[v>>0]=35;v=v+1|0}a[v>>0]=108;v=v+1|0;w=t&74;do{if((w|0)==8){if((t&16384|0)==0){a[v>>0]=120;break}else{a[v>>0]=88;break}}else if((w|0)==64){a[v>>0]=111}else{a[v>>0]=117}}while(0);do{if((a[16248]|0)==0?(Ua(16248)|0)!=0:0){u=0;t=ua(33,2147483647,16256,0)|0;w=u;u=0;if(w&1){w=qb(-1,-1)|0;Eb(16248);vb(w|0)}else{c[4060]=t;rb(16248);break}}}while(0);w=c[4060]|0;c[d>>2]=h;s=Op(q,12,w,s,d)|0;h=q+s|0;r=c[r>>2]&176;do{if((r|0)==16){r=a[q>>0]|0;if(r<<24>>24==43|r<<24>>24==45){r=q+1|0;break}if((s|0)>1&r<<24>>24==48?(w=a[q+1>>0]|0,w<<24>>24==88|w<<24>>24==120):0){r=q+2|0}else{j=22}}else if((r|0)==32){r=h}else{j=22}}while(0);if((j|0)==22){r=q}ln(k,f);u=0;Da(43,q|0,r|0,h|0,n|0,l|0,m|0,k|0);w=u;u=0;if(w&1){w=qb(-1,-1)|0;qm(c[k>>2]|0)|0;vb(w|0)}else{qm(c[k>>2]|0)|0;c[o>>2]=c[e>>2];v=c[l>>2]|0;w=c[m>>2]|0;c[d+0>>2]=c[o+0>>2];bq(b,d,n,v,w,f,g);i=p;return}}function eq(b,d,e,f,g,h,j){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0;d=i;i=i+240|0;r=d+8|0;t=d;n=d+204|0;q=d+32|0;p=d+28|0;m=d+24|0;l=d+20|0;o=d+16|0;x=t;c[x>>2]=37;c[x+4>>2]=0;x=t+1|0;s=f+4|0;v=c[s>>2]|0;if((v&2048|0)!=0){a[x>>0]=43;x=t+2|0}if((v&512|0)!=0){a[x>>0]=35;x=x+1|0}w=x+2|0;a[x>>0]=108;a[x+1>>0]=108;x=v&74;do{if((x|0)==8){if((v&16384|0)==0){a[w>>0]=120;break}else{a[w>>0]=88;break}}else if((x|0)==64){a[w>>0]=111}else{a[w>>0]=117}}while(0);do{if((a[16248]|0)==0?(Ua(16248)|0)!=0:0){u=0;v=ua(33,2147483647,16256,0)|0;x=u;u=0;if(x&1){x=qb(-1,-1)|0;Eb(16248);vb(x|0)}else{c[4060]=v;rb(16248);break}}}while(0);x=c[4060]|0;w=r;c[w>>2]=h;c[w+4>>2]=j;h=Op(n,23,x,t,r)|0;j=n+h|0;s=c[s>>2]&176;do{if((s|0)==32){s=j}else if((s|0)==16){s=a[n>>0]|0;if(s<<24>>24==43|s<<24>>24==45){s=n+1|0;break}if((h|0)>1&s<<24>>24==48?(x=a[n+1>>0]|0,x<<24>>24==88|x<<24>>24==120):0){s=n+2|0}else{k=22}}else{k=22}}while(0);if((k|0)==22){s=n}ln(l,f);u=0;Da(43,n|0,s|0,j|0,q|0,p|0,m|0,l|0);x=u;u=0;if(x&1){x=qb(-1,-1)|0;qm(c[l>>2]|0)|0;vb(x|0)}else{qm(c[l>>2]|0)|0;c[o>>2]=c[e>>2];w=c[p>>2]|0;x=c[m>>2]|0;c[r+0>>2]=c[o+0>>2];bq(b,r,q,w,x,f,g);i=d;return}}function fq(b,d,e,f,g,j){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;j=+j;var l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0;d=i;i=i+304|0;q=d+8|0;x=d;v=d+272|0;t=d+268|0;s=d+40|0;o=d+36|0;p=d+32|0;r=d+28|0;m=d+24|0;n=d+20|0;A=x;c[A>>2]=37;c[A+4>>2]=0;A=x+1|0;w=f+4|0;z=c[w>>2]|0;if((z&2048|0)!=0){a[A>>0]=43;A=x+2|0}if((z&1024|0)!=0){a[A>>0]=35;A=A+1|0}y=z&260;B=z>>>14;do{if((y|0)==260){if((B&1|0)==0){a[A>>0]=97;y=0;break}else{a[A>>0]=65;y=0;break}}else{a[A>>0]=46;z=A+2|0;a[A+1>>0]=42;if((y|0)==256){if((B&1|0)==0){a[z>>0]=101;y=1;break}else{a[z>>0]=69;y=1;break}}else if((y|0)==4){if((B&1|0)==0){a[z>>0]=102;y=1;break}else{a[z>>0]=70;y=1;break}}else{if((B&1|0)==0){a[z>>0]=103;y=1;break}else{a[z>>0]=71;y=1;break}}}}while(0);c[t>>2]=v;do{if((a[16248]|0)==0?(Ua(16248)|0)!=0:0){u=0;z=ua(33,2147483647,16256,0)|0;B=u;u=0;if(B&1){B=qb(-1,-1)|0;Eb(16248);vb(B|0)}else{c[4060]=z;rb(16248);break}}}while(0);z=c[4060]|0;if(y){c[q>>2]=c[f+8>>2];A=q+4|0;h[k>>3]=j;c[A>>2]=c[k>>2];c[A+4>>2]=c[k+4>>2];A=Op(v,30,z,x,q)|0}else{h[k>>3]=j;c[q>>2]=c[k>>2];c[q+4>>2]=c[k+4>>2];A=Op(v,30,z,x,q)|0}do{if((A|0)>29){z=(a[16248]|0)==0;a:do{if(y){do{if(z?(Ua(16248)|0)!=0:0){u=0;y=ua(33,2147483647,16256,0)|0;B=u;u=0;if(B&1){f=qb(-1,-1)|0;Eb(16248);break a}else{c[4060]=y;rb(16248);break}}}while(0);A=c[4060]|0;u=0;c[q>>2]=c[f+8>>2];B=q+4|0;h[k>>3]=j;c[B>>2]=c[k>>2];c[B+4>>2]=c[k+4>>2];A=Ma(16,t|0,A|0,x|0,q|0)|0;B=u;u=0;if(B&1){l=36}else{l=44}}else{do{if(z?(Ua(16248)|0)!=0:0){u=0;y=ua(33,2147483647,16256,0)|0;B=u;u=0;if(B&1){f=qb(-1,-1)|0;Eb(16248);break a}else{c[4060]=y;rb(16248);break}}}while(0);A=c[4060]|0;u=0;c[q>>2]=c[f+8>>2];B=q+4|0;h[k>>3]=j;c[B>>2]=c[k>>2];c[B+4>>2]=c[k+4>>2];A=Ma(16,t|0,A|0,x|0,q|0)|0;B=u;u=0;if(B&1){l=36}else{l=44}}}while(0);if((l|0)==44){y=c[t>>2]|0;if((y|0)!=0){x=y;break}u=0;Oa(4);B=u;u=0;if(B&1){l=36}else{y=c[t>>2]|0;x=y;break}}if((l|0)==36){f=qb(-1,-1)|0}B=f;vb(B|0)}else{x=0;y=c[t>>2]|0}}while(0);z=y+A|0;w=c[w>>2]&176;do{if((w|0)==32){w=z}else if((w|0)==16){w=a[y>>0]|0;if(w<<24>>24==43|w<<24>>24==45){w=y+1|0;break}if((A|0)>1&w<<24>>24==48?(B=a[y+1>>0]|0,B<<24>>24==88|B<<24>>24==120):0){w=y+2|0}else{l=53}}else{l=53}}while(0);if((l|0)==53){w=y}if((y|0)!=(v|0)){l=Av(A<<3)|0;if((l|0)==0){u=0;Oa(4);B=u;u=0;if(B&1){A=0;l=58}else{A=l;v=c[t>>2]|0;s=l;l=59}}else{A=l;v=y;s=l;l=59}}else{A=0;l=59}do{if((l|0)==59){u=0;oa(84,r|0,f|0);B=u;u=0;if(!(B&1)){u=0;Da(44,v|0,w|0,z|0,s|0,o|0,p|0,r|0);B=u;u=0;if(B&1){f=qb(-1,-1)|0;qm(c[r>>2]|0)|0;break}qm(c[r>>2]|0)|0;c[n>>2]=c[e>>2];z=c[o>>2]|0;B=c[p>>2]|0;u=0;c[q+0>>2]=c[n+0>>2];Da(45,m|0,q|0,s|0,z|0,B|0,f|0,g|0);B=u;u=0;if(!(B&1)){B=c[m>>2]|0;c[e>>2]=B;c[b>>2]=B;if((A|0)!=0){Bv(A)}if((x|0)==0){i=d;return}Bv(x);i=d;return}else{l=58}}else{l=58}}}while(0);if((l|0)==58){f=qb(-1,-1)|0}if((A|0)!=0){Bv(A)}if((x|0)==0){B=f;vb(B|0)}Bv(x);B=f;vb(B|0)}function gq(b,d,e,f,g,h,j){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0;l=i;i=i+32|0;n=l;k=l+12|0;t=c[j>>2]|0;if(!((c[4086]|0)==-1)){c[n>>2]=16344;c[n+4>>2]=205;c[n+8>>2]=0;Lm(16344,n,206)}m=(c[16348>>2]|0)+ -1|0;s=c[t+8>>2]|0;if(!((c[t+12>>2]|0)-s>>2>>>0>m>>>0)){A=Jb(4)|0;bv(A);qc(A|0,24312,171)}m=c[s+(m<<2)>>2]|0;if((m|0)==0){A=Jb(4)|0;bv(A);qc(A|0,24312,171)}j=c[j>>2]|0;if(!((c[4126]|0)==-1)){c[n>>2]=16504;c[n+4>>2]=205;c[n+8>>2]=0;Lm(16504,n,206)}n=(c[16508>>2]|0)+ -1|0;s=c[j+8>>2]|0;if(!((c[j+12>>2]|0)-s>>2>>>0>n>>>0)){A=Jb(4)|0;bv(A);qc(A|0,24312,171)}j=c[s+(n<<2)>>2]|0;if((j|0)==0){A=Jb(4)|0;bv(A);qc(A|0,24312,171)}zc[c[(c[j>>2]|0)+20>>2]&127](k,j);c[h>>2]=f;n=a[b>>0]|0;if(n<<24>>24==43|n<<24>>24==45){u=0;n=Ha(c[(c[m>>2]|0)+44>>2]|0,m|0,n|0)|0;A=u;u=0;if(!(A&1)){t=c[h>>2]|0;c[h>>2]=t+4;c[t>>2]=n;t=b+1|0;r=20}}else{t=b;r=20}a:do{if((r|0)==20){n=e;b:do{if(((n-t|0)>1?(a[t>>0]|0)==48:0)?(q=t+1|0,A=a[q>>0]|0,A<<24>>24==88|A<<24>>24==120):0){u=0;s=Ha(c[(c[m>>2]|0)+44>>2]|0,m|0,48)|0;A=u;u=0;if(A&1){break a}A=c[h>>2]|0;c[h>>2]=A+4;c[A>>2]=s;t=t+2|0;u=0;q=Ha(c[(c[m>>2]|0)+44>>2]|0,m|0,a[q>>0]|0)|0;A=u;u=0;if(A&1){break a}A=c[h>>2]|0;c[h>>2]=A+4;c[A>>2]=q;if(t>>>0<e>>>0){s=t;while(1){q=a[s>>0]|0;if((a[16248]|0)==0?(Ua(16248)|0)!=0:0){u=0;v=ua(33,2147483647,16256,0)|0;A=u;u=0;if(A&1){r=32;break}c[4060]=v;rb(16248)}u=0;q=Ha(39,q<<24>>24|0,c[4060]|0)|0;A=u;u=0;if(A&1){r=17;break}v=s+1|0;if((q|0)==0){q=t;break b}if(v>>>0<e>>>0){s=v}else{q=t;s=v;break b}}if((r|0)==17){A=qb(-1,-1)|0;Rm(k);vb(A|0)}else if((r|0)==32){A=qb(-1,-1)|0;Eb(16248);Rm(k);vb(A|0)}}else{q=t;s=t}}else{r=21}}while(0);c:do{if((r|0)==21){if(t>>>0<e>>>0){s=t;while(1){r=a[s>>0]|0;if((a[16248]|0)==0?(Ua(16248)|0)!=0:0){u=0;q=ua(33,2147483647,16256,0)|0;A=u;u=0;if(A&1){r=40;break}c[4060]=q;rb(16248)}u=0;q=Ha(40,r<<24>>24|0,c[4060]|0)|0;A=u;u=0;if(A&1){r=16;break}r=s+1|0;if((q|0)==0){q=t;break c}if(r>>>0<e>>>0){s=r}else{q=t;s=r;break c}}if((r|0)==16){A=qb(-1,-1)|0;Rm(k);vb(A|0)}else if((r|0)==40){A=qb(-1,-1)|0;Eb(16248);Rm(k);vb(A|0)}}else{q=t;s=t}}}while(0);r=a[k>>0]|0;if((r&1)==0){r=(r&255)>>>1}else{r=c[k+4>>2]|0}if((r|0)!=0){if((q|0)!=(s|0)?(p=s+ -1|0,p>>>0>q>>>0):0){r=q;do{A=a[r>>0]|0;a[r>>0]=a[p>>0]|0;a[p>>0]=A;r=r+1|0;p=p+ -1|0}while(r>>>0<p>>>0)}u=0;t=qa(c[(c[j>>2]|0)+16>>2]|0,j|0)|0;A=u;u=0;if(A&1){break}d:do{if(q>>>0<s>>>0){v=k+1|0;w=k+4|0;r=k+8|0;x=0;y=0;p=q;while(1){A=(a[k>>0]&1)==0;if((a[(A?v:c[r>>2]|0)+y>>0]|0)>0?(x|0)==(a[(A?v:c[r>>2]|0)+y>>0]|0):0){x=c[h>>2]|0;c[h>>2]=x+4;c[x>>2]=t;x=a[k>>0]|0;if((x&1)==0){z=(x&255)>>>1}else{z=c[w>>2]|0}x=0;y=(y>>>0<(z+ -1|0)>>>0&1)+y|0}u=0;A=Ha(c[(c[m>>2]|0)+44>>2]|0,m|0,a[p>>0]|0)|0;z=u;u=0;if(z&1){break}B=c[h>>2]|0;z=B+4|0;c[h>>2]=z;c[B>>2]=A;p=p+1|0;if(!(p>>>0<s>>>0)){break d}else{x=x+1|0}}B=qb(-1,-1)|0;Rm(k);vb(B|0)}else{z=c[h>>2]|0}}while(0);p=f+(q-b<<2)|0;if((p|0)!=(z|0)?(o=z+ -4|0,o>>>0>p>>>0):0){do{B=c[p>>2]|0;c[p>>2]=c[o>>2];c[o>>2]=B;p=p+4|0;o=o+ -4|0}while(p>>>0<o>>>0)}}else{u=0;Ma(c[(c[m>>2]|0)+48>>2]|0,m|0,q|0,s|0,c[h>>2]|0)|0;B=u;u=0;if(B&1){break}z=(c[h>>2]|0)+(s-q<<2)|0;c[h>>2]=z}e:do{if(s>>>0<e>>>0){while(1){o=a[s>>0]|0;if(o<<24>>24==46){r=70;break}u=0;o=Ha(c[(c[m>>2]|0)+44>>2]|0,m|0,o|0)|0;B=u;u=0;if(B&1){r=14;break}B=c[h>>2]|0;z=B+4|0;c[h>>2]=z;c[B>>2]=o;s=s+1|0;if(!(s>>>0<e>>>0)){break e}}if((r|0)==14){B=qb(-1,-1)|0;Rm(k);vb(B|0)}else if((r|0)==70){u=0;o=qa(c[(c[j>>2]|0)+12>>2]|0,j|0)|0;B=u;u=0;if(B&1){break a}B=c[h>>2]|0;z=B+4|0;c[h>>2]=z;c[B>>2]=o;s=s+1|0;break}}}while(0);u=0;Ma(c[(c[m>>2]|0)+48>>2]|0,m|0,s|0,e|0,z|0)|0;B=u;u=0;if(!(B&1)){m=(c[h>>2]|0)+(n-s<<2)|0;c[h>>2]=m;if((d|0)==(e|0)){B=m;c[g>>2]=B;Rm(k);i=l;return}B=f+(d-b<<2)|0;c[g>>2]=B;Rm(k);i=l;return}}}while(0);B=qb(-1,-1)|0;Rm(k);vb(B|0)}function hq(b,d,e,f,g,j){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;j=+j;var l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0;r=i;i=i+304|0;d=r+8|0;x=r;v=r+272|0;t=r+268|0;s=r+40|0;o=r+36|0;p=r+32|0;q=r+28|0;m=r+24|0;n=r+20|0;A=x;c[A>>2]=37;c[A+4>>2]=0;A=x+1|0;w=f+4|0;z=c[w>>2]|0;if((z&2048|0)!=0){a[A>>0]=43;A=x+2|0}if((z&1024|0)!=0){a[A>>0]=35;A=A+1|0}y=z&260;z=z>>>14;do{if((y|0)==260){a[A>>0]=76;y=A+1|0;if((z&1|0)==0){a[y>>0]=97;y=0;break}else{a[y>>0]=65;y=0;break}}else{a[A>>0]=46;a[A+1>>0]=42;a[A+2>>0]=76;A=A+3|0;if((y|0)==256){if((z&1|0)==0){a[A>>0]=101;y=1;break}else{a[A>>0]=69;y=1;break}}else if((y|0)==4){if((z&1|0)==0){a[A>>0]=102;y=1;break}else{a[A>>0]=70;y=1;break}}else{if((z&1|0)==0){a[A>>0]=103;y=1;break}else{a[A>>0]=71;y=1;break}}}}while(0);c[t>>2]=v;do{if((a[16248]|0)==0?(Ua(16248)|0)!=0:0){u=0;z=ua(33,2147483647,16256,0)|0;A=u;u=0;if(A&1){A=qb(-1,-1)|0;Eb(16248);vb(A|0)}else{c[4060]=z;rb(16248);break}}}while(0);z=c[4060]|0;if(y){c[d>>2]=c[f+8>>2];A=d+4|0;h[k>>3]=j;c[A>>2]=c[k>>2];c[A+4>>2]=c[k+4>>2];A=Op(v,30,z,x,d)|0}else{h[k>>3]=j;c[d>>2]=c[k>>2];c[d+4>>2]=c[k+4>>2];A=Op(v,30,z,x,d)|0}do{if((A|0)>29){z=(a[16248]|0)==0;a:do{if(y){do{if(z?(Ua(16248)|0)!=0:0){u=0;y=ua(33,2147483647,16256,0)|0;A=u;u=0;if(A&1){e=qb(-1,-1)|0;Eb(16248);break a}else{c[4060]=y;rb(16248);break}}}while(0);A=c[4060]|0;u=0;c[d>>2]=c[f+8>>2];z=d+4|0;h[k>>3]=j;c[z>>2]=c[k>>2];c[z+4>>2]=c[k+4>>2];A=Ma(16,t|0,A|0,x|0,d|0)|0;z=u;u=0;if(z&1){l=36}else{l=44}}else{do{if(z?(Ua(16248)|0)!=0:0){u=0;y=ua(33,2147483647,16256,0)|0;A=u;u=0;if(A&1){e=qb(-1,-1)|0;Eb(16248);break a}else{c[4060]=y;rb(16248);break}}}while(0);A=c[4060]|0;u=0;h[k>>3]=j;c[d>>2]=c[k>>2];c[d+4>>2]=c[k+4>>2];A=Ma(16,t|0,A|0,x|0,d|0)|0;z=u;u=0;if(z&1){l=36}else{l=44}}}while(0);if((l|0)==44){y=c[t>>2]|0;if((y|0)!=0){x=y;break}u=0;Oa(4);z=u;u=0;if(z&1){l=36}else{y=c[t>>2]|0;x=y;break}}if((l|0)==36){e=qb(-1,-1)|0}A=e;vb(A|0)}else{x=0;y=c[t>>2]|0}}while(0);z=y+A|0;w=c[w>>2]&176;do{if((w|0)==32){w=z}else if((w|0)==16){w=a[y>>0]|0;if(w<<24>>24==43|w<<24>>24==45){w=y+1|0;break}if((A|0)>1&w<<24>>24==48?(w=a[y+1>>0]|0,w<<24>>24==88|w<<24>>24==120):0){w=y+2|0}else{l=53}}else{l=53}}while(0);if((l|0)==53){w=y}if((y|0)!=(v|0)){l=Av(A<<3)|0;if((l|0)==0){u=0;Oa(4);A=u;u=0;if(A&1){A=0;l=58}else{A=l;v=c[t>>2]|0;s=l;l=59}}else{A=l;v=y;s=l;l=59}}else{A=0;l=59}do{if((l|0)==59){u=0;oa(84,q|0,f|0);y=u;u=0;if(!(y&1)){u=0;Da(44,v|0,w|0,z|0,s|0,o|0,p|0,q|0);z=u;u=0;if(z&1){e=qb(-1,-1)|0;qm(c[q>>2]|0)|0;break}qm(c[q>>2]|0)|0;c[n>>2]=c[e>>2];y=c[o>>2]|0;z=c[p>>2]|0;u=0;c[d+0>>2]=c[n+0>>2];Da(45,m|0,d|0,s|0,y|0,z|0,f|0,g|0);z=u;u=0;if(!(z&1)){z=c[m>>2]|0;c[e>>2]=z;c[b>>2]=z;if((A|0)!=0){Bv(A)}if((x|0)==0){i=r;return}Bv(x);i=r;return}else{l=58}}else{l=58}}}while(0);if((l|0)==58){e=qb(-1,-1)|0}if((A|0)!=0){Bv(A)}if((x|0)==0){A=e;vb(A|0)}Bv(x);A=e;vb(A|0)}function iq(b,d,e,f,g,h){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;l=i;i=i+208|0;d=l;q=l+188|0;m=l+168|0;n=l+20|0;o=l+16|0;k=l+12|0;a[q+0>>0]=a[15152>>0]|0;a[q+1>>0]=a[15153>>0]|0;a[q+2>>0]=a[15154>>0]|0;a[q+3>>0]=a[15155>>0]|0;a[q+4>>0]=a[15156>>0]|0;a[q+5>>0]=a[15157>>0]|0;do{if((a[16248]|0)==0?(Ua(16248)|0)!=0:0){u=0;r=ua(33,2147483647,16256,0)|0;t=u;u=0;if(t&1){t=qb(-1,-1)|0;Eb(16248);vb(t|0)}else{c[4060]=r;rb(16248);break}}}while(0);r=c[4060]|0;c[d>>2]=h;q=Op(m,20,r,q,d)|0;h=m+q|0;r=c[f+4>>2]&176;do{if((r|0)==32){r=h}else if((r|0)==16){r=a[m>>0]|0;if(r<<24>>24==43|r<<24>>24==45){r=m+1|0;break}if((q|0)>1&r<<24>>24==48?(t=a[m+1>>0]|0,t<<24>>24==88|t<<24>>24==120):0){r=m+2|0}else{p=12}}else{p=12}}while(0);if((p|0)==12){r=m}ln(o,f);s=c[o>>2]|0;if(!((c[4086]|0)==-1)?(c[d>>2]=16344,c[d+4>>2]=205,c[d+8>>2]=0,u=0,Na(58,16344,d|0,206),t=u,u=0,t&1):0){t=qb(-1,-1)|0;s=c[o>>2]|0;qm(s)|0;vb(t|0)}t=(c[16348>>2]|0)+ -1|0;p=c[s+8>>2]|0;if((c[s+12>>2]|0)-p>>2>>>0>t>>>0?(j=c[p+(t<<2)>>2]|0,(j|0)!=0):0){qm(c[o>>2]|0)|0;Xc[c[(c[j>>2]|0)+48>>2]&31](j,m,h,n)|0;j=n+(q<<2)|0;if((r|0)==(h|0)){t=j;s=c[e>>2]|0;c[k>>2]=s;c[d+0>>2]=c[k+0>>2];bq(b,d,n,t,j,f,g);i=l;return}t=n+(r-m<<2)|0;s=c[e>>2]|0;c[k>>2]=s;c[d+0>>2]=c[k+0>>2];bq(b,d,n,t,j,f,g);i=l;return}t=Jb(4)|0;bv(t);u=0;Na(45,t|0,24312,171);t=u;u=0;if(t&1){t=qb(-1,-1)|0;s=c[o>>2]|0;qm(s)|0;vb(t|0)}}function jq(e,f,g,h,j,k,l,m,n){e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;l=l|0;m=m|0;n=n|0;var o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0;p=i;i=i+32|0;r=p;q=p+28|0;A=p+24|0;t=p+20|0;v=p+16|0;s=p+12|0;ln(A,j);z=c[A>>2]|0;if(!((c[4088]|0)==-1)?(c[r>>2]=16352,c[r+4>>2]=205,c[r+8>>2]=0,u=0,Na(58,16352,r|0,206),E=u,u=0,E&1):0){E=qb(-1,-1)|0;D=c[A>>2]|0;qm(D)|0;vb(E|0)}y=(c[16356>>2]|0)+ -1|0;B=c[z+8>>2]|0;if((c[z+12>>2]|0)-B>>2>>>0>y>>>0?(x=c[B+(y<<2)>>2]|0,(x|0)!=0):0){qm(c[A>>2]|0)|0;c[k>>2]=0;a:do{if((m|0)!=(n|0)){y=x+8|0;z=0;b:while(1){while(1){if((z|0)!=0){o=67;break a}z=c[g>>2]|0;if((z|0)!=0){if((c[z+12>>2]|0)==(c[z+16>>2]|0)?(Bc[c[(c[z>>2]|0)+36>>2]&255](z)|0)==-1:0){c[g>>2]=0;z=0}}else{z=0}B=(z|0)==0;A=c[h>>2]|0;do{if((A|0)!=0){if((c[A+12>>2]|0)==(c[A+16>>2]|0)?(Bc[c[(c[A>>2]|0)+36>>2]&255](A)|0)==-1:0){c[h>>2]=0;o=20;break}if(!B){o=21;break b}}else{o=20}}while(0);if((o|0)==20){o=0;if(B){o=21;break b}else{A=0}}if((Fc[c[(c[x>>2]|0)+36>>2]&63](x,a[m>>0]|0,0)|0)<<24>>24==37){o=24;break}B=a[m>>0]|0;if(B<<24>>24>-1?(w=c[y>>2]|0,!((b[w+(B<<24>>24<<1)>>1]&8192)==0)):0){o=35;break}A=z+12|0;C=c[A>>2]|0;B=z+16|0;if((C|0)==(c[B>>2]|0)){C=Bc[c[(c[z>>2]|0)+36>>2]&255](z)|0}else{C=d[C>>0]|0}E=Sc[c[(c[x>>2]|0)+12>>2]&63](x,C&255)|0;if(E<<24>>24==(Sc[c[(c[x>>2]|0)+12>>2]&63](x,a[m>>0]|0)|0)<<24>>24){o=62;break}c[k>>2]=4;z=4}c:do{if((o|0)==24){o=0;C=m+1|0;if((C|0)==(n|0)){o=25;break b}B=Fc[c[(c[x>>2]|0)+36>>2]&63](x,a[C>>0]|0,0)|0;if(B<<24>>24==48|B<<24>>24==69){C=m+2|0;if((C|0)==(n|0)){o=28;break b}m=C;C=Fc[c[(c[x>>2]|0)+36>>2]&63](x,a[C>>0]|0,0)|0}else{m=C;C=B;B=0}E=c[(c[f>>2]|0)+36>>2]|0;c[v>>2]=z;c[s>>2]=A;c[q+0>>2]=c[v+0>>2];c[r+0>>2]=c[s+0>>2];Qc[E&3](t,f,q,r,j,k,l,C,B);c[g>>2]=c[t>>2];m=m+1|0}else if((o|0)==35){while(1){o=0;m=m+1|0;if((m|0)==(n|0)){m=n;break}B=a[m>>0]|0;if(!(B<<24>>24>-1)){break}if((b[w+(B<<24>>24<<1)>>1]&8192)==0){break}else{o=35}}C=A;B=A;while(1){if((z|0)!=0){if((c[z+12>>2]|0)==(c[z+16>>2]|0)?(Bc[c[(c[z>>2]|0)+36>>2]&255](z)|0)==-1:0){c[g>>2]=0;z=0}}else{z=0}D=(z|0)==0;do{if((B|0)!=0){if((c[B+12>>2]|0)!=(c[B+16>>2]|0)){if(D){A=C;break}else{break c}}if(!((Bc[c[(c[B>>2]|0)+36>>2]&255](B)|0)==-1)){if(D^(C|0)==0){A=C;B=C;break}else{break c}}else{c[h>>2]=0;A=0;o=48;break}}else{A=C;o=48}}while(0);if((o|0)==48){o=0;if(D){break c}else{B=0}}D=z+12|0;E=c[D>>2]|0;C=z+16|0;if((E|0)==(c[C>>2]|0)){E=Bc[c[(c[z>>2]|0)+36>>2]&255](z)|0}else{E=d[E>>0]|0}if(!((E&255)<<24>>24>-1)){break c}if((b[(c[y>>2]|0)+(E<<24>>24<<1)>>1]&8192)==0){break c}E=c[D>>2]|0;if((E|0)==(c[C>>2]|0)){Bc[c[(c[z>>2]|0)+40>>2]&255](z)|0;C=A;continue}else{c[D>>2]=E+1;C=A;continue}}}else if((o|0)==62){o=0;C=c[A>>2]|0;if((C|0)==(c[B>>2]|0)){Bc[c[(c[z>>2]|0)+40>>2]&255](z)|0}else{c[A>>2]=C+1}m=m+1|0}}while(0);if((m|0)==(n|0)){o=67;break a}z=c[k>>2]|0}if((o|0)==21){c[k>>2]=4;break}else if((o|0)==25){c[k>>2]=4;break}else if((o|0)==28){c[k>>2]=4;break}}else{o=67}}while(0);if((o|0)==67){z=c[g>>2]|0}if((z|0)!=0){if((c[z+12>>2]|0)==(c[z+16>>2]|0)?(Bc[c[(c[z>>2]|0)+36>>2]&255](z)|0)==-1:0){c[g>>2]=0;z=0}}else{z=0}j=(z|0)==0;g=c[h>>2]|0;do{if((g|0)!=0){if((c[g+12>>2]|0)==(c[g+16>>2]|0)?(Bc[c[(c[g>>2]|0)+36>>2]&255](g)|0)==-1:0){c[h>>2]=0;o=77;break}if(j){c[e>>2]=z;i=p;return}}else{o=77}}while(0);if((o|0)==77?!j:0){c[e>>2]=z;i=p;return}c[k>>2]=c[k>>2]|2;c[e>>2]=z;i=p;return}E=Jb(4)|0;bv(E);u=0;Na(45,E|0,24312,171);E=u;u=0;if(E&1){E=qb(-1,-1)|0;D=c[A>>2]|0;qm(D)|0;vb(E|0)}}function kq(a){a=a|0;var b=0;b=i;Hv(a);i=b;return}function lq(a){a=a|0;return}function mq(a){a=a|0;return 2}function nq(a,b,d,e,f,g,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0,n=0;j=i;i=i+16|0;k=j+12|0;l=j+8|0;n=j+4|0;m=j;c[n>>2]=c[d>>2];c[m>>2]=c[e>>2];c[l+0>>2]=c[n+0>>2];c[k+0>>2]=c[m+0>>2];jq(a,b,l,k,f,g,h,15256,15264|0);i=j;return}function oq(b,d,e,f,g,h,j){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0;o=i;i=i+16|0;k=o+12|0;l=o+8|0;n=o+4|0;m=o;p=d+8|0;p=Bc[c[(c[p>>2]|0)+20>>2]&255](p)|0;c[n>>2]=c[e>>2];c[m>>2]=c[f>>2];e=a[p>>0]|0;if((e&1)==0){f=p+1|0;e=(e&255)>>>1;p=p+1|0}else{q=c[p+8>>2]|0;f=q;e=c[p+4>>2]|0;p=q}q=f+e|0;c[l+0>>2]=c[n+0>>2];c[k+0>>2]=c[m+0>>2];jq(b,d,l,k,g,h,j,p,q);i=o;return}function pq(a,b,d,e,f,g,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0;j=i;i=i+32|0;k=j;m=j+16|0;n=j+12|0;ln(n,f);f=c[n>>2]|0;if(!((c[4088]|0)==-1)?(c[k>>2]=16352,c[k+4>>2]=205,c[k+8>>2]=0,u=0,Na(58,16352,k|0,206),p=u,u=0,p&1):0){p=qb(-1,-1)|0;o=c[n>>2]|0;qm(o)|0;vb(p|0)}o=(c[16356>>2]|0)+ -1|0;p=c[f+8>>2]|0;if((c[f+12>>2]|0)-p>>2>>>0>o>>>0?(l=c[p+(o<<2)>>2]|0,(l|0)!=0):0){qm(c[n>>2]|0)|0;o=c[e>>2]|0;p=b+8|0;p=Bc[c[c[p>>2]>>2]&255](p)|0;c[m>>2]=o;o=p+168|0;c[k+0>>2]=c[m+0>>2];k=(Mo(d,k,p,o,l,g,0)|0)-p|0;if((k|0)>=168){p=c[d>>2]|0;c[a>>2]=p;i=j;return}c[h+24>>2]=((k|0)/12|0|0)%7|0;p=c[d>>2]|0;c[a>>2]=p;i=j;return}p=Jb(4)|0;bv(p);u=0;Na(45,p|0,24312,171);p=u;u=0;if(p&1){p=qb(-1,-1)|0;o=c[n>>2]|0;qm(o)|0;vb(p|0)}}function qq(a,b,d,e,f,g,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0;j=i;i=i+32|0;k=j;m=j+16|0;n=j+12|0;ln(n,f);f=c[n>>2]|0;if(!((c[4088]|0)==-1)?(c[k>>2]=16352,c[k+4>>2]=205,c[k+8>>2]=0,u=0,Na(58,16352,k|0,206),p=u,u=0,p&1):0){p=qb(-1,-1)|0;o=c[n>>2]|0;qm(o)|0;vb(p|0)}o=(c[16356>>2]|0)+ -1|0;p=c[f+8>>2]|0;if((c[f+12>>2]|0)-p>>2>>>0>o>>>0?(l=c[p+(o<<2)>>2]|0,(l|0)!=0):0){qm(c[n>>2]|0)|0;o=c[e>>2]|0;p=b+8|0;p=Bc[c[(c[p>>2]|0)+4>>2]&255](p)|0;c[m>>2]=o;o=p+288|0;c[k+0>>2]=c[m+0>>2];k=(Mo(d,k,p,o,l,g,0)|0)-p|0;if((k|0)>=288){p=c[d>>2]|0;c[a>>2]=p;i=j;return}c[h+16>>2]=((k|0)/12|0|0)%12|0;p=c[d>>2]|0;c[a>>2]=p;i=j;return}p=Jb(4)|0;bv(p);u=0;Na(45,p|0,24312,171);p=u;u=0;if(p&1){p=qb(-1,-1)|0;o=c[n>>2]|0;qm(o)|0;vb(p|0)}}function rq(a,b,d,e,f,g,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,o=0;b=i;i=i+32|0;k=b;l=b+16|0;m=b+12|0;ln(m,f);f=c[m>>2]|0;if(!((c[4088]|0)==-1)?(c[k>>2]=16352,c[k+4>>2]=205,c[k+8>>2]=0,u=0,Na(58,16352,k|0,206),o=u,u=0,o&1):0){o=qb(-1,-1)|0;n=c[m>>2]|0;qm(n)|0;vb(o|0)}o=(c[16356>>2]|0)+ -1|0;n=c[f+8>>2]|0;if((c[f+12>>2]|0)-n>>2>>>0>o>>>0?(j=c[n+(o<<2)>>2]|0,(j|0)!=0):0){qm(c[m>>2]|0)|0;h=h+20|0;c[l>>2]=c[e>>2];c[k+0>>2]=c[l+0>>2];e=vq(d,k,g,j,4)|0;if((c[g>>2]&4|0)!=0){o=c[d>>2]|0;c[a>>2]=o;i=b;return}if((e|0)<69){g=e+2e3|0}else{g=(e+ -69|0)>>>0<31?e+1900|0:e}c[h>>2]=g+ -1900;o=c[d>>2]|0;c[a>>2]=o;i=b;return}o=Jb(4)|0;bv(o);u=0;Na(45,o|0,24312,171);o=u;u=0;if(o&1){o=qb(-1,-1)|0;n=c[m>>2]|0;qm(n)|0;vb(o|0)}}function sq(b,d,e,f,g,h,j,k,l){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;l=l|0;var m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,da=0;l=i;i=i+176|0;m=l;o=l+164|0;z=l+160|0;N=l+156|0;V=l+152|0;q=l+148|0;E=l+144|0;ba=l+140|0;M=l+136|0;A=l+132|0;C=l+128|0;y=l+124|0;T=l+120|0;aa=l+116|0;_=l+112|0;v=l+108|0;s=l+104|0;t=l+100|0;S=l+96|0;Q=l+92|0;R=l+88|0;K=l+84|0;da=l+80|0;D=l+76|0;P=l+72|0;H=l+68|0;F=l+64|0;G=l+60|0;L=l+56|0;X=l+52|0;W=l+48|0;$=l+44|0;Y=l+40|0;Z=l+36|0;I=l+32|0;J=l+28|0;x=l+24|0;w=l+20|0;r=l+16|0;O=l+12|0;c[h>>2]=0;ln(_,g);U=c[_>>2]|0;if(!((c[4088]|0)==-1)?(c[m>>2]=16352,c[m+4>>2]=205,c[m+8>>2]=0,u=0,Na(58,16352,m|0,206),ca=u,u=0,ca&1):0){da=qb(-1,-1)|0;ca=c[_>>2]|0;qm(ca)|0;vb(da|0)}B=(c[16356>>2]|0)+ -1|0;ca=c[U+8>>2]|0;if((c[U+12>>2]|0)-ca>>2>>>0>B>>>0?(n=c[ca+(B<<2)>>2]|0,(n|0)!=0):0){qm(c[_>>2]|0)|0;a:do{switch(k<<24>>24|0){case 109:{c[ba>>2]=c[f>>2];c[m+0>>2]=c[ba+0>>2];m=vq(e,m,h,n,2)|0;d=c[h>>2]|0;if((d&4|0)==0&(m|0)<13){c[j+16>>2]=m+ -1;break a}else{c[h>>2]=d|4;break a}};case 121:{j=j+20|0;c[z>>2]=c[f>>2];c[m+0>>2]=c[z+0>>2];m=vq(e,m,h,n,4)|0;if((c[h>>2]&4|0)==0){if((m|0)<69){h=m+2e3|0}else{h=(m+ -69|0)>>>0<31?m+1900|0:m}c[j>>2]=h+ -1900}break};case 82:{c[X>>2]=c[e>>2];c[W>>2]=c[f>>2];c[o+0>>2]=c[X+0>>2];c[m+0>>2]=c[W+0>>2];jq(L,d,o,m,g,h,j,15296,15301|0);c[e>>2]=c[L>>2];break};case 70:{c[da>>2]=c[e>>2];c[D>>2]=c[f>>2];c[o+0>>2]=c[da+0>>2];c[m+0>>2]=c[D+0>>2];jq(K,d,o,m,g,h,j,15272,15280|0);c[e>>2]=c[K>>2];break};case 101:case 100:{j=j+12|0;c[y>>2]=c[f>>2];c[m+0>>2]=c[y+0>>2];d=vq(e,m,h,n,2)|0;m=c[h>>2]|0;if((m&4|0)==0?(d+ -1|0)>>>0<31:0){c[j>>2]=d;break a}c[h>>2]=m|4;break};case 99:{n=d+8|0;n=Bc[c[(c[n>>2]|0)+12>>2]&255](n)|0;c[s>>2]=c[e>>2];c[t>>2]=c[f>>2];q=a[n>>0]|0;if((q&1)==0){p=n+1|0;q=(q&255)>>>1;n=n+1|0}else{da=c[n+8>>2]|0;p=da;q=c[n+4>>2]|0;n=da}c[o+0>>2]=c[s+0>>2];c[m+0>>2]=c[t+0>>2];jq(v,d,o,m,g,h,j,n,p+q|0);c[e>>2]=c[v>>2];break};case 106:{c[M>>2]=c[f>>2];c[m+0>>2]=c[M+0>>2];d=vq(e,m,h,n,3)|0;m=c[h>>2]|0;if((m&4|0)==0&(d|0)<366){c[j+28>>2]=d;break a}else{c[h>>2]=m|4;break a}};case 89:{c[o>>2]=c[f>>2];c[m+0>>2]=c[o+0>>2];m=vq(e,m,h,n,4)|0;if((c[h>>2]&4|0)==0){c[j+20>>2]=m+ -1900}break};case 37:{c[O>>2]=c[f>>2];c[m+0>>2]=c[O+0>>2];uq(0,e,m,h,n);break};case 83:{c[V>>2]=c[f>>2];c[m+0>>2]=c[V+0>>2];m=vq(e,m,h,n,2)|0;d=c[h>>2]|0;if((d&4|0)==0&(m|0)<61){c[j>>2]=m;break a}else{c[h>>2]=d|4;break a}};case 84:{c[Y>>2]=c[e>>2];c[Z>>2]=c[f>>2];c[o+0>>2]=c[Y+0>>2];c[m+0>>2]=c[Z+0>>2];jq($,d,o,m,g,h,j,15304,15312|0);c[e>>2]=c[$>>2];break};case 65:case 97:{ca=c[f>>2]|0;da=d+8|0;da=Bc[c[c[da>>2]>>2]&255](da)|0;c[aa>>2]=ca;c[m+0>>2]=c[aa+0>>2];h=(Mo(e,m,da,da+168|0,n,h,0)|0)-da|0;if((h|0)<168){c[j+24>>2]=((h|0)/12|0|0)%7|0}break};case 72:{c[C>>2]=c[f>>2];c[m+0>>2]=c[C+0>>2];d=vq(e,m,h,n,2)|0;m=c[h>>2]|0;if((m&4|0)==0&(d|0)<24){c[j+8>>2]=d;break a}else{c[h>>2]=m|4;break a}};case 112:{j=j+8|0;g=c[f>>2]|0;d=d+8|0;d=Bc[c[(c[d>>2]|0)+8>>2]&255](d)|0;o=a[d>>0]|0;if((o&1)==0){o=(o&255)>>>1}else{o=c[d+4>>2]|0}f=a[d+12>>0]|0;if((f&1)==0){f=(f&255)>>>1}else{f=c[d+16>>2]|0}if((o|0)==(0-f|0)){c[h>>2]=c[h>>2]|4;break a}c[q>>2]=g;c[m+0>>2]=c[q+0>>2];da=Mo(e,m,d,d+24|0,n,h,0)|0;h=da-d|0;if((da|0)==(d|0)?(c[j>>2]|0)==12:0){c[j>>2]=0;break a}if((h|0)==12?(p=c[j>>2]|0,(p|0)<12):0){c[j>>2]=p+12}break};case 77:{c[E>>2]=c[f>>2];c[m+0>>2]=c[E+0>>2];m=vq(e,m,h,n,2)|0;d=c[h>>2]|0;if((d&4|0)==0&(m|0)<60){c[j+4>>2]=m;break a}else{c[h>>2]=d|4;break a}};case 114:{c[F>>2]=c[e>>2];c[G>>2]=c[f>>2];c[o+0>>2]=c[F+0>>2];c[m+0>>2]=c[G+0>>2];jq(H,d,o,m,g,h,j,15280,15291|0);c[e>>2]=c[H>>2];break};case 120:{da=c[(c[d>>2]|0)+20>>2]|0;c[I>>2]=c[e>>2];c[J>>2]=c[f>>2];c[o+0>>2]=c[I+0>>2];c[m+0>>2]=c[J+0>>2];Oc[da&63](b,d,o,m,g,h,j);i=l;return};case 88:{n=d+8|0;n=Bc[c[(c[n>>2]|0)+24>>2]&255](n)|0;c[w>>2]=c[e>>2];c[r>>2]=c[f>>2];q=a[n>>0]|0;if((q&1)==0){p=n+1|0;q=(q&255)>>>1;n=n+1|0}else{da=c[n+8>>2]|0;p=da;q=c[n+4>>2]|0;n=da}c[o+0>>2]=c[w+0>>2];c[m+0>>2]=c[r+0>>2];jq(x,d,o,m,g,h,j,n,p+q|0);c[e>>2]=c[x>>2];break};case 119:{c[N>>2]=c[f>>2];c[m+0>>2]=c[N+0>>2];m=vq(e,m,h,n,1)|0;d=c[h>>2]|0;if((d&4|0)==0&(m|0)<7){c[j+24>>2]=m;break a}else{c[h>>2]=d|4;break a}};case 73:{j=j+8|0;c[A>>2]=c[f>>2];c[m+0>>2]=c[A+0>>2];m=vq(e,m,h,n,2)|0;d=c[h>>2]|0;if((d&4|0)==0?(m+ -1|0)>>>0<12:0){c[j>>2]=m;break a}c[h>>2]=d|4;break};case 116:case 110:{c[P>>2]=c[f>>2];c[m+0>>2]=c[P+0>>2];tq(0,e,m,h,n);break};case 68:{c[Q>>2]=c[e>>2];c[R>>2]=c[f>>2];c[o+0>>2]=c[Q+0>>2];c[m+0>>2]=c[R+0>>2];jq(S,d,o,m,g,h,j,15264,15272|0);c[e>>2]=c[S>>2];break};case 104:case 66:case 98:{ca=c[f>>2]|0;da=d+8|0;da=Bc[c[(c[da>>2]|0)+4>>2]&255](da)|0;c[T>>2]=ca;c[m+0>>2]=c[T+0>>2];h=(Mo(e,m,da,da+288|0,n,h,0)|0)-da|0;if((h|0)<288){c[j+16>>2]=((h|0)/12|0|0)%12|0}break};default:{c[h>>2]=c[h>>2]|4}}}while(0);c[b>>2]=c[e>>2];i=l;return}da=Jb(4)|0;bv(da);u=0;Na(45,da|0,24312,171);da=u;u=0;if(da&1){da=qb(-1,-1)|0;ca=c[_>>2]|0;qm(ca)|0;vb(da|0)}}function tq(a,e,f,g,h){a=a|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0;a=i;h=h+8|0;a:while(1){k=c[e>>2]|0;do{if((k|0)!=0){if((c[k+12>>2]|0)==(c[k+16>>2]|0)){if((Bc[c[(c[k>>2]|0)+36>>2]&255](k)|0)==-1){c[e>>2]=0;k=0;break}else{k=c[e>>2]|0;break}}}else{k=0}}while(0);l=(k|0)==0;k=c[f>>2]|0;do{if((k|0)!=0){if((c[k+12>>2]|0)!=(c[k+16>>2]|0)){if(l){break}else{break a}}if(!((Bc[c[(c[k>>2]|0)+36>>2]&255](k)|0)==-1)){if(l){break}else{break a}}else{c[f>>2]=0;j=12;break}}else{j=12}}while(0);if((j|0)==12){j=0;if(l){k=0;break}else{k=0}}m=c[e>>2]|0;l=c[m+12>>2]|0;if((l|0)==(c[m+16>>2]|0)){l=Bc[c[(c[m>>2]|0)+36>>2]&255](m)|0}else{l=d[l>>0]|0}if(!((l&255)<<24>>24>-1)){break}if((b[(c[h>>2]|0)+(l<<24>>24<<1)>>1]&8192)==0){break}k=c[e>>2]|0;m=k+12|0;l=c[m>>2]|0;if((l|0)==(c[k+16>>2]|0)){Bc[c[(c[k>>2]|0)+40>>2]&255](k)|0;continue}else{c[m>>2]=l+1;continue}}h=c[e>>2]|0;do{if((h|0)!=0){if((c[h+12>>2]|0)==(c[h+16>>2]|0)){if((Bc[c[(c[h>>2]|0)+36>>2]&255](h)|0)==-1){c[e>>2]=0;h=0;break}else{h=c[e>>2]|0;break}}}else{h=0}}while(0);e=(h|0)==0;do{if((k|0)!=0){if((c[k+12>>2]|0)==(c[k+16>>2]|0)?(Bc[c[(c[k>>2]|0)+36>>2]&255](k)|0)==-1:0){c[f>>2]=0;j=32;break}if(e){i=a;return}}else{j=32}}while(0);if((j|0)==32?!e:0){i=a;return}c[g>>2]=c[g>>2]|2;i=a;return}function uq(a,b,e,f,g){a=a|0;b=b|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0;a=i;j=c[b>>2]|0;do{if((j|0)!=0){if((c[j+12>>2]|0)==(c[j+16>>2]|0)){if((Bc[c[(c[j>>2]|0)+36>>2]&255](j)|0)==-1){c[b>>2]=0;j=0;break}else{j=c[b>>2]|0;break}}}else{j=0}}while(0);k=(j|0)==0;j=c[e>>2]|0;do{if((j|0)!=0){if((c[j+12>>2]|0)==(c[j+16>>2]|0)?(Bc[c[(c[j>>2]|0)+36>>2]&255](j)|0)==-1:0){c[e>>2]=0;h=11;break}if(!k){h=12}}else{h=11}}while(0);if((h|0)==11){if(k){h=12}else{j=0}}if((h|0)==12){c[f>>2]=c[f>>2]|6;i=a;return}l=c[b>>2]|0;k=c[l+12>>2]|0;if((k|0)==(c[l+16>>2]|0)){k=Bc[c[(c[l>>2]|0)+36>>2]&255](l)|0}else{k=d[k>>0]|0}if(!((Fc[c[(c[g>>2]|0)+36>>2]&63](g,k&255,0)|0)<<24>>24==37)){c[f>>2]=c[f>>2]|4;i=a;return}l=c[b>>2]|0;k=l+12|0;g=c[k>>2]|0;if((g|0)==(c[l+16>>2]|0)){Bc[c[(c[l>>2]|0)+40>>2]&255](l)|0}else{c[k>>2]=g+1}g=c[b>>2]|0;do{if((g|0)!=0){if((c[g+12>>2]|0)==(c[g+16>>2]|0)){if((Bc[c[(c[g>>2]|0)+36>>2]&255](g)|0)==-1){c[b>>2]=0;g=0;break}else{g=c[b>>2]|0;break}}}else{g=0}}while(0);b=(g|0)==0;do{if((j|0)!=0){if((c[j+12>>2]|0)==(c[j+16>>2]|0)?(Bc[c[(c[j>>2]|0)+36>>2]&255](j)|0)==-1:0){c[e>>2]=0;h=31;break}if(b){i=a;return}}else{h=31}}while(0);if((h|0)==31?!b:0){i=a;return}c[f>>2]=c[f>>2]|2;i=a;return}function vq(a,e,f,g,h){a=a|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;j=i;l=c[a>>2]|0;do{if((l|0)!=0){if((c[l+12>>2]|0)==(c[l+16>>2]|0)){if((Bc[c[(c[l>>2]|0)+36>>2]&255](l)|0)==-1){c[a>>2]=0;l=0;break}else{l=c[a>>2]|0;break}}}else{l=0}}while(0);m=(l|0)==0;l=c[e>>2]|0;do{if((l|0)!=0){if((c[l+12>>2]|0)==(c[l+16>>2]|0)?(Bc[c[(c[l>>2]|0)+36>>2]&255](l)|0)==-1:0){c[e>>2]=0;n=11;break}if(!m){n=12}}else{n=11}}while(0);if((n|0)==11){if(m){n=12}else{l=0}}if((n|0)==12){c[f>>2]=c[f>>2]|6;q=0;i=j;return q|0}n=c[a>>2]|0;m=c[n+12>>2]|0;if((m|0)==(c[n+16>>2]|0)){n=Bc[c[(c[n>>2]|0)+36>>2]&255](n)|0}else{n=d[m>>0]|0}m=n&255;if(m<<24>>24>-1?(k=g+8|0,!((b[(c[k>>2]|0)+(n<<24>>24<<1)>>1]&2048)==0)):0){m=(Fc[c[(c[g>>2]|0)+36>>2]&63](g,m,0)|0)<<24>>24;p=c[a>>2]|0;n=p+12|0;o=c[n>>2]|0;if((o|0)==(c[p+16>>2]|0)){Bc[c[(c[p>>2]|0)+40>>2]&255](p)|0;o=l;n=l}else{c[n>>2]=o+1;o=l;n=l}while(1){m=m+ -48|0;h=h+ -1|0;l=c[a>>2]|0;do{if((l|0)!=0){if((c[l+12>>2]|0)==(c[l+16>>2]|0)){if((Bc[c[(c[l>>2]|0)+36>>2]&255](l)|0)==-1){c[a>>2]=0;l=0;break}else{l=c[a>>2]|0;break}}}else{l=0}}while(0);p=(l|0)==0;if((n|0)!=0){if((c[n+12>>2]|0)==(c[n+16>>2]|0)){if((Bc[c[(c[n>>2]|0)+36>>2]&255](n)|0)==-1){c[e>>2]=0;l=0;n=0}else{l=o;n=o}}else{l=o}}else{l=o;n=0}o=c[a>>2]|0;if(!((p^(n|0)==0)&(h|0)>0)){n=40;break}p=c[o+12>>2]|0;if((p|0)==(c[o+16>>2]|0)){o=Bc[c[(c[o>>2]|0)+36>>2]&255](o)|0}else{o=d[p>>0]|0}p=o&255;if(!(p<<24>>24>-1)){n=52;break}if((b[(c[k>>2]|0)+(o<<24>>24<<1)>>1]&2048)==0){n=52;break}m=((Fc[c[(c[g>>2]|0)+36>>2]&63](g,p,0)|0)<<24>>24)+(m*10|0)|0;p=c[a>>2]|0;q=p+12|0;o=c[q>>2]|0;if((o|0)==(c[p+16>>2]|0)){Bc[c[(c[p>>2]|0)+40>>2]&255](p)|0;o=l;continue}else{c[q>>2]=o+1;o=l;continue}}if((n|0)==40){do{if((o|0)!=0){if((c[o+12>>2]|0)==(c[o+16>>2]|0)){if((Bc[c[(c[o>>2]|0)+36>>2]&255](o)|0)==-1){c[a>>2]=0;o=0;break}else{o=c[a>>2]|0;break}}}else{o=0}}while(0);g=(o|0)==0;do{if((l|0)!=0){if((c[l+12>>2]|0)==(c[l+16>>2]|0)?(Bc[c[(c[l>>2]|0)+36>>2]&255](l)|0)==-1:0){c[e>>2]=0;n=50;break}if(g){q=m;i=j;return q|0}}else{n=50}}while(0);if((n|0)==50?!g:0){q=m;i=j;return q|0}c[f>>2]=c[f>>2]|2;q=m;i=j;return q|0}else if((n|0)==52){i=j;return m|0}}c[f>>2]=c[f>>2]|4;q=0;i=j;return q|0}function wq(a,b,d,e,f,g,h,j,k){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;var l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0;m=i;i=i+32|0;s=m;r=m+28|0;t=m+24|0;n=m+20|0;p=m+16|0;q=m+12|0;ln(t,f);w=c[t>>2]|0;if(!((c[4086]|0)==-1)?(c[s>>2]=16344,c[s+4>>2]=205,c[s+8>>2]=0,u=0,Na(58,16344,s|0,206),z=u,u=0,z&1):0){z=qb(-1,-1)|0;y=c[t>>2]|0;qm(y)|0;vb(z|0)}x=(c[16348>>2]|0)+ -1|0;v=c[w+8>>2]|0;if((c[w+12>>2]|0)-v>>2>>>0>x>>>0?(o=c[v+(x<<2)>>2]|0,(o|0)!=0):0){qm(c[t>>2]|0)|0;c[g>>2]=0;a:do{if((j|0)!=(k|0)){t=0;b:while(1){while(1){if((t|0)!=0){l=71;break a}t=c[d>>2]|0;if((t|0)!=0){v=c[t+12>>2]|0;if((v|0)==(c[t+16>>2]|0)){v=Bc[c[(c[t>>2]|0)+36>>2]&255](t)|0}else{v=c[v>>2]|0}if((v|0)==-1){c[d>>2]=0;w=1;t=0}else{w=0}}else{w=1;t=0}v=c[e>>2]|0;do{if((v|0)!=0){x=c[v+12>>2]|0;if((x|0)==(c[v+16>>2]|0)){x=Bc[c[(c[v>>2]|0)+36>>2]&255](v)|0}else{x=c[x>>2]|0}if(!((x|0)==-1)){if(w){break}else{l=25;break b}}else{c[e>>2]=0;l=23;break}}else{l=23}}while(0);if((l|0)==23){l=0;if(w){l=25;break b}else{v=0}}if((Fc[c[(c[o>>2]|0)+52>>2]&63](o,c[j>>2]|0,0)|0)<<24>>24==37){l=28;break}if(Fc[c[(c[o>>2]|0)+12>>2]&63](o,8192,c[j>>2]|0)|0){l=38;break}v=t+12|0;x=c[v>>2]|0;w=t+16|0;if((x|0)==(c[w>>2]|0)){x=Bc[c[(c[t>>2]|0)+36>>2]&255](t)|0}else{x=c[x>>2]|0}z=Sc[c[(c[o>>2]|0)+28>>2]&63](o,x)|0;if((z|0)==(Sc[c[(c[o>>2]|0)+28>>2]&63](o,c[j>>2]|0)|0)){l=66;break}c[g>>2]=4;t=4}c:do{if((l|0)==28){l=0;x=j+4|0;if((x|0)==(k|0)){l=29;break b}w=Fc[c[(c[o>>2]|0)+52>>2]&63](o,c[x>>2]|0,0)|0;if(w<<24>>24==48|w<<24>>24==69){x=j+8|0;if((x|0)==(k|0)){l=32;break b}j=x;x=Fc[c[(c[o>>2]|0)+52>>2]&63](o,c[x>>2]|0,0)|0}else{j=x;x=w;w=0}z=c[(c[b>>2]|0)+36>>2]|0;c[p>>2]=t;c[q>>2]=v;c[r+0>>2]=c[p+0>>2];c[s+0>>2]=c[q+0>>2];Qc[z&3](n,b,r,s,f,g,h,x,w);c[d>>2]=c[n>>2];j=j+4|0}else if((l|0)==38){while(1){l=0;j=j+4|0;if((j|0)==(k|0)){j=k;break}if(Fc[c[(c[o>>2]|0)+12>>2]&63](o,8192,c[j>>2]|0)|0){l=38}else{break}}w=v;while(1){if((t|0)!=0){x=c[t+12>>2]|0;if((x|0)==(c[t+16>>2]|0)){x=Bc[c[(c[t>>2]|0)+36>>2]&255](t)|0}else{x=c[x>>2]|0}if((x|0)==-1){c[d>>2]=0;x=1;t=0}else{x=0}}else{x=1;t=0}do{if((v|0)!=0){y=c[v+12>>2]|0;if((y|0)==(c[v+16>>2]|0)){v=Bc[c[(c[v>>2]|0)+36>>2]&255](v)|0}else{v=c[y>>2]|0}if(!((v|0)==-1)){if(x^(w|0)==0){x=w;v=w;break}else{break c}}else{c[e>>2]=0;w=0;l=53;break}}else{l=53}}while(0);if((l|0)==53){l=0;if(x){break c}else{x=w;v=0}}y=t+12|0;z=c[y>>2]|0;w=t+16|0;if((z|0)==(c[w>>2]|0)){z=Bc[c[(c[t>>2]|0)+36>>2]&255](t)|0}else{z=c[z>>2]|0}if(!(Fc[c[(c[o>>2]|0)+12>>2]&63](o,8192,z)|0)){break c}z=c[y>>2]|0;if((z|0)==(c[w>>2]|0)){Bc[c[(c[t>>2]|0)+40>>2]&255](t)|0;w=x;continue}else{c[y>>2]=z+4;w=x;continue}}}else if((l|0)==66){l=0;x=c[v>>2]|0;if((x|0)==(c[w>>2]|0)){Bc[c[(c[t>>2]|0)+40>>2]&255](t)|0}else{c[v>>2]=x+4}j=j+4|0}}while(0);if((j|0)==(k|0)){l=71;break a}t=c[g>>2]|0}if((l|0)==25){c[g>>2]=4;break}else if((l|0)==29){c[g>>2]=4;break}else if((l|0)==32){c[g>>2]=4;break}}else{l=71}}while(0);if((l|0)==71){t=c[d>>2]|0}if((t|0)!=0){n=c[t+12>>2]|0;if((n|0)==(c[t+16>>2]|0)){n=Bc[c[(c[t>>2]|0)+36>>2]&255](t)|0}else{n=c[n>>2]|0}if((n|0)==-1){c[d>>2]=0;t=0;d=1}else{d=0}}else{t=0;d=1}n=c[e>>2]|0;do{if((n|0)!=0){o=c[n+12>>2]|0;if((o|0)==(c[n+16>>2]|0)){n=Bc[c[(c[n>>2]|0)+36>>2]&255](n)|0}else{n=c[o>>2]|0}if((n|0)==-1){c[e>>2]=0;l=84;break}if(d){c[a>>2]=t;i=m;return}}else{l=84}}while(0);if((l|0)==84?!d:0){c[a>>2]=t;i=m;return}c[g>>2]=c[g>>2]|2;c[a>>2]=t;i=m;return}z=Jb(4)|0;bv(z);u=0;Na(45,z|0,24312,171);z=u;u=0;if(z&1){z=qb(-1,-1)|0;y=c[t>>2]|0;qm(y)|0;vb(z|0)}}function xq(a){a=a|0;var b=0;b=i;Hv(a);i=b;return}function yq(a){a=a|0;return}function zq(a){a=a|0;return 2}function Aq(a,b,d,e,f,g,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0,n=0;j=i;i=i+16|0;k=j+12|0;l=j+8|0;n=j+4|0;m=j;c[n>>2]=c[d>>2];c[m>>2]=c[e>>2];c[l+0>>2]=c[n+0>>2];c[k+0>>2]=c[m+0>>2];wq(a,b,l,k,f,g,h,15408,15440|0);i=j;return}function Bq(b,d,e,f,g,h,j){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0;o=i;i=i+16|0;k=o+12|0;l=o+8|0;n=o+4|0;m=o;p=d+8|0;p=Bc[c[(c[p>>2]|0)+20>>2]&255](p)|0;c[n>>2]=c[e>>2];c[m>>2]=c[f>>2];e=a[p>>0]|0;if((e&1)==0){f=p+4|0;e=(e&255)>>>1;p=p+4|0}else{q=c[p+8>>2]|0;f=q;e=c[p+4>>2]|0;p=q}q=f+(e<<2)|0;c[l+0>>2]=c[n+0>>2];c[k+0>>2]=c[m+0>>2];wq(b,d,l,k,g,h,j,p,q);i=o;return}function Cq(a,b,d,e,f,g,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0;j=i;i=i+32|0;k=j;m=j+16|0;n=j+12|0;ln(n,f);f=c[n>>2]|0;if(!((c[4086]|0)==-1)?(c[k>>2]=16344,c[k+4>>2]=205,c[k+8>>2]=0,u=0,Na(58,16344,k|0,206),p=u,u=0,p&1):0){p=qb(-1,-1)|0;o=c[n>>2]|0;qm(o)|0;vb(p|0)}o=(c[16348>>2]|0)+ -1|0;p=c[f+8>>2]|0;if((c[f+12>>2]|0)-p>>2>>>0>o>>>0?(l=c[p+(o<<2)>>2]|0,(l|0)!=0):0){qm(c[n>>2]|0)|0;o=c[e>>2]|0;p=b+8|0;p=Bc[c[c[p>>2]>>2]&255](p)|0;c[m>>2]=o;o=p+168|0;c[k+0>>2]=c[m+0>>2];k=(jp(d,k,p,o,l,g,0)|0)-p|0;if((k|0)>=168){p=c[d>>2]|0;c[a>>2]=p;i=j;return}c[h+24>>2]=((k|0)/12|0|0)%7|0;p=c[d>>2]|0;c[a>>2]=p;i=j;return}p=Jb(4)|0;bv(p);u=0;Na(45,p|0,24312,171);p=u;u=0;if(p&1){p=qb(-1,-1)|0;o=c[n>>2]|0;qm(o)|0;vb(p|0)}}function Dq(a,b,d,e,f,g,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0;j=i;i=i+32|0;k=j;m=j+16|0;n=j+12|0;ln(n,f);f=c[n>>2]|0;if(!((c[4086]|0)==-1)?(c[k>>2]=16344,c[k+4>>2]=205,c[k+8>>2]=0,u=0,Na(58,16344,k|0,206),p=u,u=0,p&1):0){p=qb(-1,-1)|0;o=c[n>>2]|0;qm(o)|0;vb(p|0)}o=(c[16348>>2]|0)+ -1|0;p=c[f+8>>2]|0;if((c[f+12>>2]|0)-p>>2>>>0>o>>>0?(l=c[p+(o<<2)>>2]|0,(l|0)!=0):0){qm(c[n>>2]|0)|0;o=c[e>>2]|0;p=b+8|0;p=Bc[c[(c[p>>2]|0)+4>>2]&255](p)|0;c[m>>2]=o;o=p+288|0;c[k+0>>2]=c[m+0>>2];k=(jp(d,k,p,o,l,g,0)|0)-p|0;if((k|0)>=288){p=c[d>>2]|0;c[a>>2]=p;i=j;return}c[h+16>>2]=((k|0)/12|0|0)%12|0;p=c[d>>2]|0;c[a>>2]=p;i=j;return}p=Jb(4)|0;bv(p);u=0;Na(45,p|0,24312,171);p=u;u=0;if(p&1){p=qb(-1,-1)|0;o=c[n>>2]|0;qm(o)|0;vb(p|0)}}function Eq(a,b,d,e,f,g,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,o=0;b=i;i=i+32|0;k=b;l=b+16|0;m=b+12|0;ln(m,f);f=c[m>>2]|0;if(!((c[4086]|0)==-1)?(c[k>>2]=16344,c[k+4>>2]=205,c[k+8>>2]=0,u=0,Na(58,16344,k|0,206),o=u,u=0,o&1):0){o=qb(-1,-1)|0;n=c[m>>2]|0;qm(n)|0;vb(o|0)}o=(c[16348>>2]|0)+ -1|0;n=c[f+8>>2]|0;if((c[f+12>>2]|0)-n>>2>>>0>o>>>0?(j=c[n+(o<<2)>>2]|0,(j|0)!=0):0){qm(c[m>>2]|0)|0;h=h+20|0;c[l>>2]=c[e>>2];c[k+0>>2]=c[l+0>>2];e=Iq(d,k,g,j,4)|0;if((c[g>>2]&4|0)!=0){o=c[d>>2]|0;c[a>>2]=o;i=b;return}if((e|0)<69){g=e+2e3|0}else{g=(e+ -69|0)>>>0<31?e+1900|0:e}c[h>>2]=g+ -1900;o=c[d>>2]|0;c[a>>2]=o;i=b;return}o=Jb(4)|0;bv(o);u=0;Na(45,o|0,24312,171);o=u;u=0;if(o&1){o=qb(-1,-1)|0;n=c[m>>2]|0;qm(n)|0;vb(o|0)}}function Fq(b,d,e,f,g,h,j,k,l){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;l=l|0;var m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,da=0;l=i;i=i+176|0;m=l;o=l+164|0;z=l+160|0;C=l+156|0;H=l+152|0;q=l+148|0;T=l+144|0;K=l+140|0;P=l+136|0;A=l+132|0;J=l+128|0;y=l+124|0;I=l+120|0;ba=l+116|0;_=l+112|0;v=l+108|0;x=l+104|0;t=l+100|0;O=l+96|0;V=l+92|0;L=l+88|0;aa=l+84|0;X=l+80|0;$=l+76|0;Z=l+72|0;S=l+68|0;da=l+64|0;R=l+60|0;F=l+56|0;D=l+52|0;E=l+48|0;Q=l+44|0;Y=l+40|0;W=l+36|0;M=l+32|0;N=l+28|0;w=l+24|0;r=l+20|0;s=l+16|0;G=l+12|0;c[h>>2]=0;ln(_,g);U=c[_>>2]|0;if(!((c[4086]|0)==-1)?(c[m>>2]=16344,c[m+4>>2]=205,c[m+8>>2]=0,u=0,Na(58,16344,m|0,206),ca=u,u=0,ca&1):0){da=qb(-1,-1)|0;ca=c[_>>2]|0;qm(ca)|0;vb(da|0)}B=(c[16348>>2]|0)+ -1|0;ca=c[U+8>>2]|0;if((c[U+12>>2]|0)-ca>>2>>>0>B>>>0?(n=c[ca+(B<<2)>>2]|0,(n|0)!=0):0){qm(c[_>>2]|0)|0;a:do{switch(k<<24>>24|0){case 65:case 97:{ca=c[f>>2]|0;da=d+8|0;da=Bc[c[c[da>>2]>>2]&255](da)|0;c[ba>>2]=ca;c[m+0>>2]=c[ba+0>>2];h=(jp(e,m,da,da+168|0,n,h,0)|0)-da|0;if((h|0)<168){c[j+24>>2]=((h|0)/12|0|0)%7|0}break};case 116:case 110:{c[Z>>2]=c[f>>2];c[m+0>>2]=c[Z+0>>2];Gq(0,e,m,h,n);break};case 84:{c[Y>>2]=c[e>>2];c[W>>2]=c[f>>2];c[o+0>>2]=c[Y+0>>2];c[m+0>>2]=c[W+0>>2];wq(Q,d,o,m,g,h,j,15576,15608|0);c[e>>2]=c[Q>>2];break};case 114:{c[da>>2]=c[e>>2];c[R>>2]=c[f>>2];c[o+0>>2]=c[da+0>>2];c[m+0>>2]=c[R+0>>2];wq(S,d,o,m,g,h,j,15504,15548|0);c[e>>2]=c[S>>2];break};case 68:{c[V>>2]=c[e>>2];c[L>>2]=c[f>>2];c[o+0>>2]=c[V+0>>2];c[m+0>>2]=c[L+0>>2];wq(O,d,o,m,g,h,j,15440,15472|0);c[e>>2]=c[O>>2];break};case 106:{c[P>>2]=c[f>>2];c[m+0>>2]=c[P+0>>2];d=Iq(e,m,h,n,3)|0;m=c[h>>2]|0;if((m&4|0)==0&(d|0)<366){c[j+28>>2]=d;break a}else{c[h>>2]=m|4;break a}};case 88:{n=d+8|0;n=Bc[c[(c[n>>2]|0)+24>>2]&255](n)|0;c[r>>2]=c[e>>2];c[s>>2]=c[f>>2];q=a[n>>0]|0;if((q&1)==0){p=n+4|0;q=(q&255)>>>1;n=n+4|0}else{da=c[n+8>>2]|0;p=da;q=c[n+4>>2]|0;n=da}c[o+0>>2]=c[r+0>>2];c[m+0>>2]=c[s+0>>2];wq(w,d,o,m,g,h,j,n,p+(q<<2)|0);c[e>>2]=c[w>>2];break};case 73:{j=j+8|0;c[A>>2]=c[f>>2];c[m+0>>2]=c[A+0>>2];d=Iq(e,m,h,n,2)|0;m=c[h>>2]|0;if((m&4|0)==0?(d+ -1|0)>>>0<12:0){c[j>>2]=d;break a}c[h>>2]=m|4;break};case 70:{c[X>>2]=c[e>>2];c[$>>2]=c[f>>2];c[o+0>>2]=c[X+0>>2];c[m+0>>2]=c[$+0>>2];wq(aa,d,o,m,g,h,j,15472,15504|0);c[e>>2]=c[aa>>2];break};case 119:{c[C>>2]=c[f>>2];c[m+0>>2]=c[C+0>>2];m=Iq(e,m,h,n,1)|0;d=c[h>>2]|0;if((d&4|0)==0&(m|0)<7){c[j+24>>2]=m;break a}else{c[h>>2]=d|4;break a}};case 89:{c[o>>2]=c[f>>2];c[m+0>>2]=c[o+0>>2];m=Iq(e,m,h,n,4)|0;if((c[h>>2]&4|0)==0){c[j+20>>2]=m+ -1900}break};case 82:{c[D>>2]=c[e>>2];c[E>>2]=c[f>>2];c[o+0>>2]=c[D+0>>2];c[m+0>>2]=c[E+0>>2];wq(F,d,o,m,g,h,j,15552,15572|0);c[e>>2]=c[F>>2];break};case 37:{c[G>>2]=c[f>>2];c[m+0>>2]=c[G+0>>2];Hq(0,e,m,h,n);break};case 83:{c[H>>2]=c[f>>2];c[m+0>>2]=c[H+0>>2];d=Iq(e,m,h,n,2)|0;m=c[h>>2]|0;if((m&4|0)==0&(d|0)<61){c[j>>2]=d;break a}else{c[h>>2]=m|4;break a}};case 104:case 66:case 98:{ca=c[f>>2]|0;da=d+8|0;da=Bc[c[(c[da>>2]|0)+4>>2]&255](da)|0;c[I>>2]=ca;c[m+0>>2]=c[I+0>>2];h=(jp(e,m,da,da+288|0,n,h,0)|0)-da|0;if((h|0)<288){c[j+16>>2]=((h|0)/12|0|0)%12|0}break};case 72:{c[J>>2]=c[f>>2];c[m+0>>2]=c[J+0>>2];m=Iq(e,m,h,n,2)|0;d=c[h>>2]|0;if((d&4|0)==0&(m|0)<24){c[j+8>>2]=m;break a}else{c[h>>2]=d|4;break a}};case 109:{c[K>>2]=c[f>>2];c[m+0>>2]=c[K+0>>2];m=Iq(e,m,h,n,2)|0;d=c[h>>2]|0;if((d&4|0)==0&(m|0)<13){c[j+16>>2]=m+ -1;break a}else{c[h>>2]=d|4;break a}};case 112:{j=j+8|0;g=c[f>>2]|0;d=d+8|0;d=Bc[c[(c[d>>2]|0)+8>>2]&255](d)|0;o=a[d>>0]|0;if((o&1)==0){o=(o&255)>>>1}else{o=c[d+4>>2]|0}f=a[d+12>>0]|0;if((f&1)==0){f=(f&255)>>>1}else{f=c[d+16>>2]|0}if((o|0)==(0-f|0)){c[h>>2]=c[h>>2]|4;break a}c[q>>2]=g;c[m+0>>2]=c[q+0>>2];da=jp(e,m,d,d+24|0,n,h,0)|0;h=da-d|0;if((da|0)==(d|0)?(c[j>>2]|0)==12:0){c[j>>2]=0;break a}if((h|0)==12?(p=c[j>>2]|0,(p|0)<12):0){c[j>>2]=p+12}break};case 120:{da=c[(c[d>>2]|0)+20>>2]|0;c[M>>2]=c[e>>2];c[N>>2]=c[f>>2];c[o+0>>2]=c[M+0>>2];c[m+0>>2]=c[N+0>>2];Oc[da&63](b,d,o,m,g,h,j);i=l;return};case 121:{j=j+20|0;c[z>>2]=c[f>>2];c[m+0>>2]=c[z+0>>2];m=Iq(e,m,h,n,4)|0;if((c[h>>2]&4|0)==0){if((m|0)<69){h=m+2e3|0}else{h=(m+ -69|0)>>>0<31?m+1900|0:m}c[j>>2]=h+ -1900}break};case 101:case 100:{j=j+12|0;c[y>>2]=c[f>>2];c[m+0>>2]=c[y+0>>2];m=Iq(e,m,h,n,2)|0;d=c[h>>2]|0;if((d&4|0)==0?(m+ -1|0)>>>0<31:0){c[j>>2]=m;break a}c[h>>2]=d|4;break};case 99:{p=d+8|0;p=Bc[c[(c[p>>2]|0)+12>>2]&255](p)|0;c[x>>2]=c[e>>2];c[t>>2]=c[f>>2];q=a[p>>0]|0;if((q&1)==0){n=p+4|0;q=(q&255)>>>1;p=p+4|0}else{da=c[p+8>>2]|0;n=da;q=c[p+4>>2]|0;p=da}c[o+0>>2]=c[x+0>>2];c[m+0>>2]=c[t+0>>2];wq(v,d,o,m,g,h,j,p,n+(q<<2)|0);c[e>>2]=c[v>>2];break};case 77:{c[T>>2]=c[f>>2];c[m+0>>2]=c[T+0>>2];m=Iq(e,m,h,n,2)|0;d=c[h>>2]|0;if((d&4|0)==0&(m|0)<60){c[j+4>>2]=m;break a}else{c[h>>2]=d|4;break a}};default:{c[h>>2]=c[h>>2]|4}}}while(0);c[b>>2]=c[e>>2];i=l;return}da=Jb(4)|0;bv(da);u=0;Na(45,da|0,24312,171);da=u;u=0;if(da&1){da=qb(-1,-1)|0;ca=c[_>>2]|0;qm(ca)|0;vb(da|0)}}function Gq(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0;a=i;a:while(1){h=c[b>>2]|0;do{if((h|0)!=0){j=c[h+12>>2]|0;if((j|0)==(c[h+16>>2]|0)){h=Bc[c[(c[h>>2]|0)+36>>2]&255](h)|0}else{h=c[j>>2]|0}if((h|0)==-1){c[b>>2]=0;h=1;break}else{h=(c[b>>2]|0)==0;break}}else{h=1}}while(0);j=c[d>>2]|0;do{if((j|0)!=0){k=c[j+12>>2]|0;if((k|0)==(c[j+16>>2]|0)){k=Bc[c[(c[j>>2]|0)+36>>2]&255](j)|0}else{k=c[k>>2]|0}if(!((k|0)==-1)){if(h){break}else{f=j;break a}}else{c[d>>2]=0;g=15;break}}else{g=15}}while(0);if((g|0)==15){g=0;if(h){f=0;break}else{j=0}}h=c[b>>2]|0;k=c[h+12>>2]|0;if((k|0)==(c[h+16>>2]|0)){h=Bc[c[(c[h>>2]|0)+36>>2]&255](h)|0}else{h=c[k>>2]|0}if(!(Fc[c[(c[f>>2]|0)+12>>2]&63](f,8192,h)|0)){f=j;break}h=c[b>>2]|0;j=h+12|0;k=c[j>>2]|0;if((k|0)==(c[h+16>>2]|0)){Bc[c[(c[h>>2]|0)+40>>2]&255](h)|0;continue}else{c[j>>2]=k+4;continue}}h=c[b>>2]|0;do{if((h|0)!=0){j=c[h+12>>2]|0;if((j|0)==(c[h+16>>2]|0)){h=Bc[c[(c[h>>2]|0)+36>>2]&255](h)|0}else{h=c[j>>2]|0}if((h|0)==-1){c[b>>2]=0;b=1;break}else{b=(c[b>>2]|0)==0;break}}else{b=1}}while(0);do{if((f|0)!=0){h=c[f+12>>2]|0;if((h|0)==(c[f+16>>2]|0)){f=Bc[c[(c[f>>2]|0)+36>>2]&255](f)|0}else{f=c[h>>2]|0}if((f|0)==-1){c[d>>2]=0;g=37;break}if(b){i=a;return}}else{g=37}}while(0);if((g|0)==37?!b:0){i=a;return}c[e>>2]=c[e>>2]|2;i=a;return}function Hq(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0;a=i;j=c[b>>2]|0;do{if((j|0)!=0){h=c[j+12>>2]|0;if((h|0)==(c[j+16>>2]|0)){h=Bc[c[(c[j>>2]|0)+36>>2]&255](j)|0}else{h=c[h>>2]|0}if((h|0)==-1){c[b>>2]=0;j=1;break}else{j=(c[b>>2]|0)==0;break}}else{j=1}}while(0);h=c[d>>2]|0;do{if((h|0)!=0){k=c[h+12>>2]|0;if((k|0)==(c[h+16>>2]|0)){k=Bc[c[(c[h>>2]|0)+36>>2]&255](h)|0}else{k=c[k>>2]|0}if(!((k|0)==-1)){if(j){break}else{g=16;break}}else{c[d>>2]=0;g=14;break}}else{g=14}}while(0);if((g|0)==14){if(j){g=16}else{h=0}}if((g|0)==16){c[e>>2]=c[e>>2]|6;i=a;return}k=c[b>>2]|0;j=c[k+12>>2]|0;if((j|0)==(c[k+16>>2]|0)){j=Bc[c[(c[k>>2]|0)+36>>2]&255](k)|0}else{j=c[j>>2]|0}if(!((Fc[c[(c[f>>2]|0)+52>>2]&63](f,j,0)|0)<<24>>24==37)){c[e>>2]=c[e>>2]|4;i=a;return}j=c[b>>2]|0;k=j+12|0;f=c[k>>2]|0;if((f|0)==(c[j+16>>2]|0)){Bc[c[(c[j>>2]|0)+40>>2]&255](j)|0}else{c[k>>2]=f+4}f=c[b>>2]|0;do{if((f|0)!=0){j=c[f+12>>2]|0;if((j|0)==(c[f+16>>2]|0)){f=Bc[c[(c[f>>2]|0)+36>>2]&255](f)|0}else{f=c[j>>2]|0}if((f|0)==-1){c[b>>2]=0;b=1;break}else{b=(c[b>>2]|0)==0;break}}else{b=1}}while(0);do{if((h|0)!=0){f=c[h+12>>2]|0;if((f|0)==(c[h+16>>2]|0)){f=Bc[c[(c[h>>2]|0)+36>>2]&255](h)|0}else{f=c[f>>2]|0}if((f|0)==-1){c[d>>2]=0;g=38;break}if(b){i=a;return}}else{g=38}}while(0);if((g|0)==38?!b:0){i=a;return}c[e>>2]=c[e>>2]|2;i=a;return}function Iq(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0;h=i;j=c[a>>2]|0;do{if((j|0)!=0){k=c[j+12>>2]|0;if((k|0)==(c[j+16>>2]|0)){j=Bc[c[(c[j>>2]|0)+36>>2]&255](j)|0}else{j=c[k>>2]|0}if((j|0)==-1){c[a>>2]=0;k=1;break}else{k=(c[a>>2]|0)==0;break}}else{k=1}}while(0);j=c[b>>2]|0;do{if((j|0)!=0){l=c[j+12>>2]|0;if((l|0)==(c[j+16>>2]|0)){l=Bc[c[(c[j>>2]|0)+36>>2]&255](j)|0}else{l=c[l>>2]|0}if(!((l|0)==-1)){if(k){break}else{g=16;break}}else{c[b>>2]=0;g=14;break}}else{g=14}}while(0);if((g|0)==14){if(k){g=16}else{j=0}}if((g|0)==16){c[d>>2]=c[d>>2]|6;o=0;i=h;return o|0}k=c[a>>2]|0;l=c[k+12>>2]|0;if((l|0)==(c[k+16>>2]|0)){k=Bc[c[(c[k>>2]|0)+36>>2]&255](k)|0}else{k=c[l>>2]|0}if(!(Fc[c[(c[e>>2]|0)+12>>2]&63](e,2048,k)|0)){c[d>>2]=c[d>>2]|4;o=0;i=h;return o|0}k=(Fc[c[(c[e>>2]|0)+52>>2]&63](e,k,0)|0)<<24>>24;m=c[a>>2]|0;l=m+12|0;n=c[l>>2]|0;if((n|0)==(c[m+16>>2]|0)){Bc[c[(c[m>>2]|0)+40>>2]&255](m)|0;l=j;m=j;j=k}else{c[l>>2]=n+4;l=j;m=j;j=k}while(1){j=j+ -48|0;f=f+ -1|0;n=c[a>>2]|0;do{if((n|0)!=0){k=c[n+12>>2]|0;if((k|0)==(c[n+16>>2]|0)){k=Bc[c[(c[n>>2]|0)+36>>2]&255](n)|0}else{k=c[k>>2]|0}if((k|0)==-1){c[a>>2]=0;n=1;break}else{n=(c[a>>2]|0)==0;break}}else{n=1}}while(0);do{if((m|0)!=0){k=c[m+12>>2]|0;if((k|0)==(c[m+16>>2]|0)){k=Bc[c[(c[m>>2]|0)+36>>2]&255](m)|0}else{k=c[k>>2]|0}if((k|0)==-1){c[b>>2]=0;k=0;m=0;o=1;break}else{k=l;m=l;o=(l|0)==0;break}}else{k=l;m=0;o=1}}while(0);l=c[a>>2]|0;if(!((n^o)&(f|0)>0)){break}n=c[l+12>>2]|0;if((n|0)==(c[l+16>>2]|0)){l=Bc[c[(c[l>>2]|0)+36>>2]&255](l)|0}else{l=c[n>>2]|0}if(!(Fc[c[(c[e>>2]|0)+12>>2]&63](e,2048,l)|0)){g=63;break}j=((Fc[c[(c[e>>2]|0)+52>>2]&63](e,l,0)|0)<<24>>24)+(j*10|0)|0;o=c[a>>2]|0;n=o+12|0;l=c[n>>2]|0;if((l|0)==(c[o+16>>2]|0)){Bc[c[(c[o>>2]|0)+40>>2]&255](o)|0;l=k;continue}else{c[n>>2]=l+4;l=k;continue}}if((g|0)==63){i=h;return j|0}do{if((l|0)!=0){e=c[l+12>>2]|0;if((e|0)==(c[l+16>>2]|0)){e=Bc[c[(c[l>>2]|0)+36>>2]&255](l)|0}else{e=c[e>>2]|0}if((e|0)==-1){c[a>>2]=0;a=1;break}else{a=(c[a>>2]|0)==0;break}}else{a=1}}while(0);do{if((k|0)!=0){e=c[k+12>>2]|0;if((e|0)==(c[k+16>>2]|0)){e=Bc[c[(c[k>>2]|0)+36>>2]&255](k)|0}else{e=c[e>>2]|0}if((e|0)==-1){c[b>>2]=0;g=60;break}if(a){o=j;i=h;return o|0}}else{g=60}}while(0);if((g|0)==60?!a:0){o=j;i=h;return o|0}c[d>>2]=c[d>>2]|2;o=j;i=h;return o|0}function Jq(b){b=b|0;var d=0,e=0,f=0,g=0,h=0;d=i;f=b+8|0;e=c[f>>2]|0;do{if((a[16248]|0)==0?(Ua(16248)|0)!=0:0){u=0;g=ua(33,2147483647,16256,0)|0;h=u;u=0;if(!(h&1)){c[4060]=g;rb(16248);break}h=qb(-1,-1,0)|0;Eb(16248);jd(h)}}while(0);if((e|0)==(c[4060]|0)){Hv(b);i=d;return}u=0;na(208,c[f>>2]|0);h=u;u=0;if(!(h&1)){Hv(b);i=d;return}h=qb(-1,-1,0)|0;jd(h)}function Kq(b){b=b|0;var d=0,e=0,f=0,g=0;d=i;b=b+8|0;e=c[b>>2]|0;do{if((a[16248]|0)==0?(Ua(16248)|0)!=0:0){u=0;f=ua(33,2147483647,16256,0)|0;g=u;u=0;if(!(g&1)){c[4060]=f;rb(16248);break}g=qb(-1,-1,0)|0;Eb(16248);jd(g)}}while(0);if((e|0)==(c[4060]|0)){i=d;return}u=0;na(208,c[b>>2]|0);g=u;u=0;if(!(g&1)){i=d;return}g=qb(-1,-1,0)|0;jd(g)}function Lq(b,d,e,f,g,h,j,k){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;var l=0,m=0,n=0;f=i;i=i+112|0;n=f+100|0;g=f;a[n>>0]=37;l=n+1|0;a[l>>0]=j;m=n+2|0;a[m>>0]=k;a[n+3>>0]=0;if(!(k<<24>>24==0)){a[l>>0]=k;a[m>>0]=j}n=ac(g|0,100,n|0,h|0,c[d+8>>2]|0)|0;h=g+n|0;d=c[e>>2]|0;if((n|0)==0){n=d;c[b>>2]=n;i=f;return}else{e=d;l=d}do{j=a[g>>0]|0;do{if((e|0)!=0){k=e+24|0;d=c[k>>2]|0;if((d|0)==(c[e+28>>2]|0)){n=(Sc[c[(c[e>>2]|0)+52>>2]&63](e,j&255)|0)==-1;l=n?0:l;e=n?0:e;break}else{c[k>>2]=d+1;a[d>>0]=j;break}}else{e=0}}while(0);g=g+1|0}while((g|0)!=(h|0));c[b>>2]=l;i=f;return}function Mq(b){b=b|0;var d=0,e=0,f=0,g=0,h=0;d=i;f=b+8|0;e=c[f>>2]|0;do{if((a[16248]|0)==0?(Ua(16248)|0)!=0:0){u=0;g=ua(33,2147483647,16256,0)|0;h=u;u=0;if(!(h&1)){c[4060]=g;rb(16248);break}h=qb(-1,-1,0)|0;Eb(16248);jd(h)}}while(0);if((e|0)==(c[4060]|0)){Hv(b);i=d;return}u=0;na(208,c[f>>2]|0);h=u;u=0;if(!(h&1)){Hv(b);i=d;return}h=qb(-1,-1,0)|0;jd(h)}function Nq(b){b=b|0;var d=0,e=0,f=0,g=0;d=i;b=b+8|0;e=c[b>>2]|0;do{if((a[16248]|0)==0?(Ua(16248)|0)!=0:0){u=0;f=ua(33,2147483647,16256,0)|0;g=u;u=0;if(!(g&1)){c[4060]=f;rb(16248);break}g=qb(-1,-1,0)|0;Eb(16248);jd(g)}}while(0);if((e|0)==(c[4060]|0)){i=d;return}u=0;na(208,c[b>>2]|0);g=u;u=0;if(!(g&1)){i=d;return}g=qb(-1,-1,0)|0;jd(g)}function Oq(a,b,d,e,f,g,h,j){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0;f=i;i=i+416|0;e=f+8|0;k=f;c[k>>2]=e+400;Pq(b+8|0,e,k,g,h,j);b=c[k>>2]|0;g=c[d>>2]|0;if((e|0)==(b|0)){k=g;c[a>>2]=k;i=f;return}else{d=g}do{h=c[e>>2]|0;if((g|0)==0){g=0}else{j=g+24|0;k=c[j>>2]|0;if((k|0)==(c[g+28>>2]|0)){h=Sc[c[(c[g>>2]|0)+52>>2]&63](g,h)|0}else{c[j>>2]=k+4;c[k>>2]=h}k=(h|0)==-1;d=k?0:d;g=k?0:g}e=e+4|0}while((e|0)!=(b|0));c[a>>2]=d;i=f;return}function Pq(b,d,e,f,g,h){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0;j=i;i=i+128|0;p=j+112|0;o=j+12|0;l=j;k=j+8|0;a[p>>0]=37;n=p+1|0;a[n>>0]=g;m=p+2|0;a[m>>0]=h;a[p+3>>0]=0;if(!(h<<24>>24==0)){a[n>>0]=h;a[m>>0]=g}ac(o|0,100,p|0,f|0,c[b>>2]|0)|0;g=l;c[g>>2]=0;c[g+4>>2]=0;c[k>>2]=o;g=(c[e>>2]|0)-d>>2;f=Nb(c[b>>2]|0)|0;u=0;k=Ma(17,d|0,k|0,g|0,l|0)|0;g=u;u=0;if(g&1){l=qb(-1,-1)|0;if((f|0)==0){vb(l|0)}u=0;qa(127,f|0)|0;g=u;u=0;if(g&1){g=qb(-1,-1,0)|0;jd(g)}else{vb(l|0)}}if((f|0)!=0?(u=0,qa(127,f|0)|0,g=u,u=0,g&1):0){g=qb(-1,-1,0)|0;jd(g)}if((k|0)==-1){Lr(17232)}else{c[e>>2]=d+(k<<2);i=j;return}}function Qq(a){a=a|0;var b=0;b=i;Hv(a);i=b;return}function Rq(a){a=a|0;return}function Sq(a){a=a|0;return 127}function Tq(a){a=a|0;return 127}function Uq(a,b){a=a|0;b=b|0;b=i;c[a+0>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;i=b;return}function Vq(a,b){a=a|0;b=b|0;b=i;c[a+0>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;i=b;return}function Wq(a,b){a=a|0;b=b|0;b=i;c[a+0>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;i=b;return}function Xq(a,b){a=a|0;b=b|0;b=i;Qm(a,1,45);i=b;return}function Yq(a){a=a|0;return 0}function Zq(b,c){b=b|0;c=c|0;a[b>>0]=67109634;a[b+1>>0]=262147;a[b+2>>0]=1024;a[b+3>>0]=4;return}function _q(b,c){b=b|0;c=c|0;a[b>>0]=67109634;a[b+1>>0]=262147;a[b+2>>0]=1024;a[b+3>>0]=4;return}function $q(a){a=a|0;var b=0;b=i;Hv(a);i=b;return}function ar(a){a=a|0;return}function br(a){a=a|0;return 127}function cr(a){a=a|0;return 127}function dr(a,b){a=a|0;b=b|0;b=i;c[a+0>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;i=b;return}function er(a,b){a=a|0;b=b|0;b=i;c[a+0>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;i=b;return}function fr(a,b){a=a|0;b=b|0;b=i;c[a+0>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;i=b;return}function gr(a,b){a=a|0;b=b|0;b=i;Qm(a,1,45);i=b;return}function hr(a){a=a|0;return 0}function ir(b,c){b=b|0;c=c|0;a[b>>0]=67109634;a[b+1>>0]=262147;a[b+2>>0]=1024;a[b+3>>0]=4;return}function jr(b,c){b=b|0;c=c|0;a[b>>0]=67109634;a[b+1>>0]=262147;a[b+2>>0]=1024;a[b+3>>0]=4;return}function kr(a){a=a|0;var b=0;b=i;Hv(a);i=b;return}function lr(a){a=a|0;return}function mr(a){a=a|0;return 2147483647}function nr(a){a=a|0;return 2147483647}function or(a,b){a=a|0;b=b|0;b=i;c[a+0>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;i=b;return}function pr(a,b){a=a|0;b=b|0;b=i;c[a+0>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;i=b;return}function qr(a,b){a=a|0;b=b|0;b=i;c[a+0>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;i=b;return}function rr(a,b){a=a|0;b=b|0;b=i;an(a,1,45);i=b;return}function sr(a){a=a|0;return 0}function tr(b,c){b=b|0;c=c|0;a[b>>0]=67109634;a[b+1>>0]=262147;a[b+2>>0]=1024;a[b+3>>0]=4;return}function ur(b,c){b=b|0;c=c|0;a[b>>0]=67109634;a[b+1>>0]=262147;a[b+2>>0]=1024;a[b+3>>0]=4;return}function vr(a){a=a|0;var b=0;b=i;Hv(a);i=b;return}function wr(a){a=a|0;return}function xr(a){a=a|0;return 2147483647}function yr(a){a=a|0;return 2147483647}function zr(a,b){a=a|0;b=b|0;b=i;c[a+0>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;i=b;return}function Ar(a,b){a=a|0;b=b|0;b=i;c[a+0>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;i=b;return}function Br(a,b){a=a|0;b=b|0;b=i;c[a+0>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;i=b;return}function Cr(a,b){a=a|0;b=b|0;b=i;an(a,1,45);i=b;return}function Dr(a){a=a|0;return 0}function Er(b,c){b=b|0;c=c|0;a[b>>0]=67109634;a[b+1>>0]=262147;a[b+2>>0]=1024;a[b+3>>0]=4;return}function Fr(b,c){b=b|0;c=c|0;a[b>>0]=67109634;a[b+1>>0]=262147;a[b+2>>0]=1024;a[b+3>>0]=4;return}function Gr(a){a=a|0;var b=0;b=i;Hv(a);i=b;return}function Hr(a){a=a|0;return}function Ir(b,d,e,f,g,h,j,k){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;var l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0;o=i;i=i+256|0;v=o;p=o+144|0;l=o+24|0;x=o+20|0;m=o+16|0;z=o+142|0;C=o+12|0;y=o+132|0;s=o+32|0;c[l>>2]=p;d=l+4|0;c[d>>2]=209;B=p+100|0;u=0;oa(84,m|0,h|0);F=u;u=0;do{if(!(F&1)){D=c[m>>2]|0;if(!((c[4088]|0)==-1)?(c[v>>2]=16352,c[v+4>>2]=205,c[v+8>>2]=0,u=0,Na(58,16352,v|0,206),F=u,u=0,F&1):0){p=15}else{p=4}a:do{if((p|0)==4){E=(c[16356>>2]|0)+ -1|0;F=c[D+8>>2]|0;if((c[D+12>>2]|0)-F>>2>>>0>E>>>0?(A=c[F+(E<<2)>>2]|0,(A|0)!=0):0){a[z>>0]=0;c[C>>2]=c[f>>2];h=c[h+4>>2]|0;u=0;c[v+0>>2]=c[C+0>>2];h=sa(1,e|0,v|0,g|0,m|0,h|0,j|0,z|0,A|0,l|0,x|0,B|0)|0;F=u;u=0;if(F&1){p=15;break}b:do{if(h){u=0;Ma(c[(c[A>>2]|0)+32>>2]|0,A|0,15968,15978|0,y|0)|0;F=u;u=0;if(F&1){p=15;break a}g=c[x>>2]|0;h=c[l>>2]|0;p=g-h|0;if((p|0)>98){p=Av(p+2|0)|0;if((p|0)==0){u=0;Oa(4);F=u;u=0;if(F&1){r=0;p=16}else{A=0;B=0;p=19}}else{A=p;B=p;p=19}}else{A=0;B=s;p=19}do{if((p|0)==19){if((a[z>>0]|0)!=0){a[B>>0]=45;B=B+1|0}if(h>>>0<g>>>0){z=y+10|0;g=y;do{C=a[h>>0]|0;D=y;while(1){if((a[D>>0]|0)==C<<24>>24){break}D=D+1|0;if((D|0)==(z|0)){D=z;break}}a[B>>0]=a[15968+(D-g)>>0]|0;h=h+1|0;B=B+1|0}while(h>>>0<(c[x>>2]|0)>>>0)}a[B>>0]=0;c[v>>2]=k;if((Tu(s,15984,v)|0)==1){if((A|0)==0){break b}Bv(A);break b}n=Jb(8)|0;u=0;oa(75,n|0,15992);F=u;u=0;if(F&1){q=qb(-1,-1)|0;pb(n|0);r=A;break}u=0;Na(45,n|0,13360,88);F=u;u=0;if(F&1){r=A;p=16}}}while(0);if((p|0)==16){q=qb(-1,-1)|0}if((r|0)==0){n=q;break a}Bv(r);n=q;break a}}while(0);q=c[e>>2]|0;if((q|0)!=0){if((c[q+12>>2]|0)==(c[q+16>>2]|0)){u=0;r=qa(c[(c[q>>2]|0)+36>>2]|0,q|0)|0;F=u;u=0;if(F&1){p=15;break}if((r|0)==-1){c[e>>2]=0;q=0}}}else{q=0}e=(q|0)==0;r=c[f>>2]|0;do{if((r|0)!=0){if((c[r+12>>2]|0)!=(c[r+16>>2]|0)){if(e){break}else{p=47;break}}u=0;r=qa(c[(c[r>>2]|0)+36>>2]|0,r|0)|0;F=u;u=0;if(F&1){p=15;break a}if(!((r|0)==-1)){if(e){break}else{p=47;break}}else{c[f>>2]=0;p=45;break}}else{p=45}}while(0);if((p|0)==45?e:0){p=47}if((p|0)==47){c[j>>2]=c[j>>2]|2}c[b>>2]=q;qm(c[m>>2]|0)|0;b=c[l>>2]|0;c[l>>2]=0;if((b|0)==0){i=o;return}u=0;na(c[d>>2]|0,b|0);F=u;u=0;if(F&1){F=qb(-1,-1,0)|0;jd(F)}else{i=o;return}}F=Jb(4)|0;bv(F);u=0;Na(45,F|0,24312,171);F=u;u=0;if(F&1){p=15}}}while(0);if((p|0)==15){n=qb(-1,-1)|0}qm(c[m>>2]|0)|0;p=c[l>>2]|0;c[l>>2]=0;if((p|0)==0){F=n;vb(F|0)}else{d=c[d>>2]|0;break}}else{n=qb(-1,-1)|0;c[l>>2]=0;d=209}}while(0);u=0;na(d|0,p|0);F=u;u=0;if(F&1){F=qb(-1,-1,0)|0;jd(F)}else{F=n;vb(F|0)}}function Jr(a){a=a|0;return}function Kr(e,f,g,h,j,k,l,m,n,o,p){e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;l=l|0;m=m|0;n=n|0;o=o|0;p=p|0;var q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,da=0,ea=0,fa=0,ga=0,ha=0,ia=0;x=i;i=i+480|0;W=x+72|0;H=x+68|0;E=x+473|0;I=x+472|0;r=x+56|0;v=x+44|0;t=x+32|0;q=x+20|0;s=x+8|0;F=x+4|0;y=x;c[H>>2]=0;c[r+0>>2]=0;c[r+4>>2]=0;c[r+8>>2]=0;c[v+0>>2]=0;c[v+4>>2]=0;c[v+8>>2]=0;c[t+0>>2]=0;c[t+4>>2]=0;c[t+8>>2]=0;c[q+0>>2]=0;c[q+4>>2]=0;c[q+8>>2]=0;c[s+0>>2]=0;c[s+4>>2]=0;c[s+8>>2]=0;u=0;Ga(1,g|0,h|0,H|0,E|0,I|0,r|0,v|0,t|0,q|0,F|0);ha=u;u=0;a:do{if(!(ha&1)){c[o>>2]=c[n>>2];M=m+8|0;h=q+1|0;L=q+4|0;g=q+8|0;J=t+1|0;m=t+4|0;K=t+8|0;R=(j&512|0)!=0;S=v+1|0;T=v+8|0;U=v+4|0;Q=s+1|0;P=s+8|0;O=s+4|0;N=H+3|0;j=n+4|0;V=r+4|0;Z=W+400|0;_=W;$=W;X=0;W=0;Y=209;b:while(1){aa=c[e>>2]|0;do{if((aa|0)!=0){if((c[aa+12>>2]|0)==(c[aa+16>>2]|0)){u=0;aa=qa(c[(c[aa>>2]|0)+36>>2]|0,aa|0)|0;ha=u;u=0;if(ha&1){w=$;z=Y;B=23;break b}if((aa|0)==-1){c[e>>2]=0;aa=0;break}else{aa=c[e>>2]|0;break}}}else{aa=0}}while(0);ba=(aa|0)==0;aa=c[f>>2]|0;do{if((aa|0)!=0){if((c[aa+12>>2]|0)!=(c[aa+16>>2]|0)){if(ba){break}else{D=_;G=Y;B=301;break b}}u=0;ca=qa(c[(c[aa>>2]|0)+36>>2]|0,aa|0)|0;ha=u;u=0;if(ha&1){w=$;z=Y;B=23;break b}if(!((ca|0)==-1)){if(ba){break}else{D=_;G=Y;B=301;break b}}else{c[f>>2]=0;B=15;break}}else{B=15}}while(0);if((B|0)==15){B=0;if(ba){D=_;G=Y;B=301;break}else{aa=0}}c:do{switch(a[H+X>>0]|0){case 0:{B=40;break};case 3:{aa=a[t>>0]|0;ca=(aa&1)==0;if(ca){fa=(aa&255)>>>1}else{fa=c[m>>2]|0}ba=a[q>>0]|0;da=(ba&1)==0;if(da){ea=(ba&255)>>>1}else{ea=c[L>>2]|0}if((fa|0)!=(0-ea|0)){if(ca){ea=(aa&255)>>>1}else{ea=c[m>>2]|0}if((ea|0)!=0){if(da){da=(ba&255)>>>1}else{da=c[L>>2]|0}if((da|0)!=0){ca=c[e>>2]|0;ea=c[ca+12>>2]|0;da=c[ca+16>>2]|0;if((ea|0)==(da|0)){u=0;ba=qa(c[(c[ca>>2]|0)+36>>2]|0,ca|0)|0;ha=u;u=0;if(ha&1){w=$;z=Y;B=23;break b}da=c[e>>2]|0;aa=a[t>>0]|0;ca=da;ea=c[da+12>>2]|0;da=c[da+16>>2]|0}else{ba=d[ea>>0]|0}fa=ca+12|0;da=(ea|0)==(da|0);if((ba&255)<<24>>24==(a[((aa&1)==0?J:c[K>>2]|0)>>0]|0)){if(da){u=0;qa(c[(c[ca>>2]|0)+40>>2]|0,ca|0)|0;ha=u;u=0;if(ha&1){w=$;z=Y;B=23;break b}}else{c[fa>>2]=ea+1}aa=a[t>>0]|0;if((aa&1)==0){aa=(aa&255)>>>1}else{aa=c[m>>2]|0}W=aa>>>0>1?t:W;break c}if(da){u=0;aa=qa(c[(c[ca>>2]|0)+36>>2]|0,ca|0)|0;ha=u;u=0;if(ha&1){w=$;z=Y;B=23;break b}}else{aa=d[ea>>0]|0}if(!((aa&255)<<24>>24==(a[((a[q>>0]&1)==0?h:c[g>>2]|0)>>0]|0))){B=131;break b}ba=c[e>>2]|0;ca=ba+12|0;aa=c[ca>>2]|0;if((aa|0)==(c[ba+16>>2]|0)){u=0;qa(c[(c[ba>>2]|0)+40>>2]|0,ba|0)|0;ha=u;u=0;if(ha&1){w=$;z=Y;B=23;break b}}else{c[ca>>2]=aa+1}a[l>>0]=1;aa=a[q>>0]|0;if((aa&1)==0){aa=(aa&255)>>>1}else{aa=c[L>>2]|0}W=aa>>>0>1?q:W;break c}}if(ca){ca=(aa&255)>>>1}else{ca=c[m>>2]|0}da=c[e>>2]|0;ea=c[da+12>>2]|0;fa=(ea|0)==(c[da+16>>2]|0);if((ca|0)==0){if(fa){u=0;aa=qa(c[(c[da>>2]|0)+36>>2]|0,da|0)|0;ha=u;u=0;if(ha&1){w=$;z=Y;B=23;break b}ba=a[q>>0]|0}else{aa=d[ea>>0]|0}if(!((aa&255)<<24>>24==(a[((ba&1)==0?h:c[g>>2]|0)>>0]|0))){break c}aa=c[e>>2]|0;ba=aa+12|0;ca=c[ba>>2]|0;if((ca|0)==(c[aa+16>>2]|0)){u=0;qa(c[(c[aa>>2]|0)+40>>2]|0,aa|0)|0;ha=u;u=0;if(ha&1){w=$;z=Y;B=23;break b}}else{c[ba>>2]=ca+1}a[l>>0]=1;aa=a[q>>0]|0;if((aa&1)==0){aa=(aa&255)>>>1}else{aa=c[L>>2]|0}W=aa>>>0>1?q:W;break c}if(fa){u=0;ba=qa(c[(c[da>>2]|0)+36>>2]|0,da|0)|0;ha=u;u=0;if(ha&1){w=$;z=Y;B=23;break b}aa=a[t>>0]|0}else{ba=d[ea>>0]|0}if(!((ba&255)<<24>>24==(a[((aa&1)==0?J:c[K>>2]|0)>>0]|0))){a[l>>0]=1;break c}ca=c[e>>2]|0;ba=ca+12|0;aa=c[ba>>2]|0;if((aa|0)==(c[ca+16>>2]|0)){u=0;qa(c[(c[ca>>2]|0)+40>>2]|0,ca|0)|0;ha=u;u=0;if(ha&1){w=$;z=Y;B=23;break b}}else{c[ba>>2]=aa+1}aa=a[t>>0]|0;if((aa&1)==0){aa=(aa&255)>>>1}else{aa=c[m>>2]|0}W=aa>>>0>1?t:W}break};case 1:{if((X|0)==3){D=_;G=Y;B=301;break b}ba=c[e>>2]|0;B=c[ba+12>>2]|0;if((B|0)==(c[ba+16>>2]|0)){u=0;B=qa(c[(c[ba>>2]|0)+36>>2]|0,ba|0)|0;ha=u;u=0;if(ha&1){w=$;z=Y;B=23;break b}}else{B=d[B>>0]|0}if(!((B&255)<<24>>24>-1)){B=39;break b}if((b[(c[M>>2]|0)+(B<<24>>24<<1)>>1]&8192)==0){B=39;break b}ca=c[e>>2]|0;B=ca+12|0;ba=c[B>>2]|0;if((ba|0)==(c[ca+16>>2]|0)){u=0;B=qa(c[(c[ca>>2]|0)+40>>2]|0,ca|0)|0;ha=u;u=0;if(ha&1){w=$;z=Y;B=23;break b}}else{c[B>>2]=ba+1;B=d[ba>>0]|0}u=0;oa(122,s|0,B&255|0);ha=u;u=0;if(ha&1){w=$;z=Y;B=23;break b}else{B=40}break};case 2:{if(!((W|0)!=0|X>>>0<2)){if((X|0)==2){ba=(a[N>>0]|0)!=0}else{ba=0}if(!(R|ba)){W=0;break c}}ca=a[v>>0]|0;da=(ca&1)==0;ba=da?S:c[T>>2]|0;d:do{if((X|0)!=0?(d[H+(X+ -1)>>0]|0)<2:0){ea=ba+(da?(ca&255)>>>1:c[U>>2]|0)|0;da=ba;while(1){if((da|0)==(ea|0)){break}fa=a[da>>0]|0;if(!(fa<<24>>24>-1)){ea=da;break}if((b[(c[M>>2]|0)+(fa<<24>>24<<1)>>1]&8192)==0){ea=da;break}else{da=da+1|0}}da=ea-ba|0;ga=a[s>>0]|0;ha=(ga&1)==0;if(ha){fa=(ga&255)>>>1}else{fa=c[O>>2]|0}if(!(da>>>0>fa>>>0)){if(ha){ha=(ga&255)>>>1;fa=Q;ga=ha;ha=s+(ha-da)+1|0}else{ia=c[P>>2]|0;ha=c[O>>2]|0;fa=ia;ga=ha;ha=ia+(ha-da)|0}da=fa+ga|0;if((ha|0)==(da|0)){da=aa;ba=ea;ea=aa}else{fa=ba;while(1){if((a[ha>>0]|0)!=(a[fa>>0]|0)){da=aa;ea=aa;break d}ha=ha+1|0;if((ha|0)==(da|0)){da=aa;ba=ea;ea=aa;break}else{fa=fa+1|0}}}}else{da=aa;ea=aa}}else{da=aa;ea=aa}}while(0);e:while(1){if((ca&1)==0){aa=S;ca=(ca&255)>>>1}else{aa=c[T>>2]|0;ca=c[U>>2]|0}if((ba|0)==(aa+ca|0)){break}aa=c[e>>2]|0;do{if((aa|0)!=0){if((c[aa+12>>2]|0)==(c[aa+16>>2]|0)){u=0;aa=qa(c[(c[aa>>2]|0)+36>>2]|0,aa|0)|0;ia=u;u=0;if(ia&1){B=21;break b}if((aa|0)==-1){c[e>>2]=0;aa=0;break}else{aa=c[e>>2]|0;break}}}else{aa=0}}while(0);aa=(aa|0)==0;do{if((ea|0)!=0){if((c[ea+12>>2]|0)!=(c[ea+16>>2]|0)){if(aa){aa=da;break}else{break e}}u=0;ca=qa(c[(c[ea>>2]|0)+36>>2]|0,ea|0)|0;ia=u;u=0;if(ia&1){B=21;break b}if(!((ca|0)==-1)){if(aa^(da|0)==0){aa=da;ea=da;break}else{break e}}else{c[f>>2]=0;da=0;B=168;break}}else{B=168}}while(0);if((B|0)==168){B=0;if(aa){break}else{aa=da;ea=0}}da=c[e>>2]|0;ca=c[da+12>>2]|0;if((ca|0)==(c[da+16>>2]|0)){u=0;ca=qa(c[(c[da>>2]|0)+36>>2]|0,da|0)|0;ia=u;u=0;if(ia&1){B=21;break b}}else{ca=d[ca>>0]|0}if(!((ca&255)<<24>>24==(a[ba>>0]|0))){break}ca=c[e>>2]|0;da=ca+12|0;fa=c[da>>2]|0;if((fa|0)==(c[ca+16>>2]|0)){u=0;qa(c[(c[ca>>2]|0)+40>>2]|0,ca|0)|0;ia=u;u=0;if(ia&1){B=21;break b}}else{c[da>>2]=fa+1}da=aa;ca=a[v>>0]|0;ba=ba+1|0}if(R){ca=a[v>>0]|0;if((ca&1)==0){aa=S;ca=(ca&255)>>>1}else{aa=c[T>>2]|0;ca=c[U>>2]|0}if((ba|0)!=(aa+ca|0)){B=183;break b}}break};case 4:{aa=0;f:while(1){ba=c[e>>2]|0;do{if((ba|0)!=0){if((c[ba+12>>2]|0)==(c[ba+16>>2]|0)){u=0;ba=qa(c[(c[ba>>2]|0)+36>>2]|0,ba|0)|0;ia=u;u=0;if(ia&1){w=$;z=Y;B=19;break b}if((ba|0)==-1){c[e>>2]=0;ba=0;break}else{ba=c[e>>2]|0;break}}}else{ba=0}}while(0);ba=(ba|0)==0;ca=c[f>>2]|0;do{if((ca|0)!=0){if((c[ca+12>>2]|0)!=(c[ca+16>>2]|0)){if(ba){break}else{break f}}u=0;ca=qa(c[(c[ca>>2]|0)+36>>2]|0,ca|0)|0;ia=u;u=0;if(ia&1){w=$;z=Y;B=19;break b}if(!((ca|0)==-1)){if(ba){break}else{break f}}else{c[f>>2]=0;B=196;break}}else{B=196}}while(0);if((B|0)==196?(B=0,ba):0){break}ca=c[e>>2]|0;ba=c[ca+12>>2]|0;if((ba|0)==(c[ca+16>>2]|0)){u=0;ca=qa(c[(c[ca>>2]|0)+36>>2]|0,ca|0)|0;ia=u;u=0;if(ia&1){w=$;z=Y;B=19;break b}}else{ca=d[ba>>0]|0}ba=ca&255;if(ba<<24>>24>-1?!((b[(c[M>>2]|0)+(ca<<24>>24<<1)>>1]&2048)==0):0){ca=c[o>>2]|0;if((ca|0)==(p|0)){da=(c[j>>2]|0)!=209;ea=c[n>>2]|0;ca=p-ea|0;p=ca>>>0<2147483647?ca<<1:-1;ea=Cv(da?ea:0,p)|0;if((ea|0)==0?(u=0,Oa(4),ia=u,u=0,ia&1):0){w=$;z=Y;B=19;break b}if(!da){da=c[n>>2]|0;c[n>>2]=ea;if((da|0)!=0){u=0;na(c[j>>2]|0,da|0);ia=u;u=0;if(ia&1){B=211;break b}ea=c[n>>2]|0}}else{c[n>>2]=ea}c[j>>2]=207;ca=ea+ca|0;c[o>>2]=ca;p=(c[n>>2]|0)+p|0}c[o>>2]=ca+1;a[ca>>0]=ba;aa=aa+1|0}else{ca=a[r>>0]|0;if((ca&1)==0){ca=(ca&255)>>>1}else{ca=c[V>>2]|0}if((ca|0)==0|(aa|0)==0){break}if(!(ba<<24>>24==(a[I>>0]|0))){break}if((_|0)==(Z|0)){_=_-$|0;Z=_>>>0<2147483647?_<<1:-1;_=_>>2;if((Y|0)==209){ba=0}else{ba=$}ba=Cv(ba,Z)|0;if((ba|0)==0?(u=0,Oa(4),ia=u,u=0,ia&1):0){w=$;z=Y;B=19;break b}_=ba+(_<<2)|0;$=ba;Z=ba+(Z>>>2<<2)|0;Y=207}c[_>>2]=aa;_=_+4|0;aa=0}ba=c[e>>2]|0;ca=ba+12|0;da=c[ca>>2]|0;if((da|0)==(c[ba+16>>2]|0)){u=0;qa(c[(c[ba>>2]|0)+40>>2]|0,ba|0)|0;ia=u;u=0;if(ia&1){w=$;z=Y;B=19;break b}else{continue}}else{c[ca>>2]=da+1;continue}}if(!(($|0)==(_|0)|(aa|0)==0)){if((_|0)==(Z|0)){_=_-$|0;Z=_>>>0<2147483647?_<<1:-1;_=_>>2;if((Y|0)==209){ba=0}else{ba=$}ba=Cv(ba,Z)|0;if((ba|0)==0?(u=0,Oa(4),ia=u,u=0,ia&1):0){w=$;z=Y;B=23;break b}_=ba+(_<<2)|0;$=ba;Z=ba+(Z>>>2<<2)|0;Y=207}c[_>>2]=aa;_=_+4|0}aa=c[F>>2]|0;if((aa|0)>0){ba=c[e>>2]|0;do{if((ba|0)!=0){if((c[ba+12>>2]|0)==(c[ba+16>>2]|0)){u=0;ba=qa(c[(c[ba>>2]|0)+36>>2]|0,ba|0)|0;ia=u;u=0;if(ia&1){w=$;z=Y;B=23;break b}if((ba|0)==-1){c[e>>2]=0;ba=0;break}else{ba=c[e>>2]|0;break}}}else{ba=0}}while(0);ca=(ba|0)==0;ba=c[f>>2]|0;do{if((ba|0)!=0){if((c[ba+12>>2]|0)!=(c[ba+16>>2]|0)){if(ca){break}else{B=256;break b}}u=0;da=qa(c[(c[ba>>2]|0)+36>>2]|0,ba|0)|0;ia=u;u=0;if(ia&1){w=$;z=Y;B=23;break b}if(!((da|0)==-1)){if(ca){break}else{B=256;break b}}else{c[f>>2]=0;B=250;break}}else{B=250}}while(0);if((B|0)==250){B=0;if(ca){B=256;break b}else{ba=0}}da=c[e>>2]|0;ca=c[da+12>>2]|0;if((ca|0)==(c[da+16>>2]|0)){u=0;ca=qa(c[(c[da>>2]|0)+36>>2]|0,da|0)|0;ia=u;u=0;if(ia&1){w=$;z=Y;B=23;break b}}else{ca=d[ca>>0]|0}if(!((ca&255)<<24>>24==(a[E>>0]|0))){B=256;break b}da=c[e>>2]|0;ca=da+12|0;ea=c[ca>>2]|0;if((ea|0)==(c[da+16>>2]|0)){u=0;qa(c[(c[da>>2]|0)+40>>2]|0,da|0)|0;ia=u;u=0;if(ia&1){w=$;z=Y;B=23;break b}else{da=ba;ca=ba}}else{c[ca>>2]=ea+1;da=ba;ca=ba}while(1){ba=c[e>>2]|0;do{if((ba|0)!=0){if((c[ba+12>>2]|0)==(c[ba+16>>2]|0)){u=0;ba=qa(c[(c[ba>>2]|0)+36>>2]|0,ba|0)|0;ia=u;u=0;if(ia&1){B=20;break b}if((ba|0)==-1){c[e>>2]=0;ba=0;break}else{ba=c[e>>2]|0;break}}}else{ba=0}}while(0);ea=(ba|0)==0;do{if((ca|0)!=0){if((c[ca+12>>2]|0)!=(c[ca+16>>2]|0)){if(ea){ba=da;break}else{B=279;break b}}u=0;ba=qa(c[(c[ca>>2]|0)+36>>2]|0,ca|0)|0;ia=u;u=0;if(ia&1){B=20;break b}if(!((ba|0)==-1)){if(ea^(da|0)==0){ba=da;ca=da;break}else{B=279;break b}}else{c[f>>2]=0;ba=0;B=272;break}}else{ba=da;B=272}}while(0);if((B|0)==272){B=0;if(ea){B=279;break b}else{ca=0}}da=c[e>>2]|0;ea=c[da+12>>2]|0;if((ea|0)==(c[da+16>>2]|0)){u=0;da=qa(c[(c[da>>2]|0)+36>>2]|0,da|0)|0;ia=u;u=0;if(ia&1){B=20;break b}}else{da=d[ea>>0]|0}if(!((da&255)<<24>>24>-1)){B=279;break b}if((b[(c[M>>2]|0)+(da<<24>>24<<1)>>1]&2048)==0){B=279;break b}da=c[o>>2]|0;if((da|0)==(p|0)){fa=(c[j>>2]|0)!=209;ea=c[n>>2]|0;da=p-ea|0;p=da>>>0<2147483647?da<<1:-1;ea=Cv(fa?ea:0,p)|0;if((ea|0)==0?(u=0,Oa(4),ia=u,u=0,ia&1):0){B=20;break b}do{if(fa){c[n>>2]=ea}else{fa=c[n>>2]|0;c[n>>2]=ea;if((fa|0)==0){break}u=0;na(c[j>>2]|0,fa|0);ia=u;u=0;if(ia&1){B=288;break b}ea=c[n>>2]|0}}while(0);c[j>>2]=207;da=ea+da|0;c[o>>2]=da;p=(c[n>>2]|0)+p|0}ea=c[e>>2]|0;fa=c[ea+12>>2]|0;if((fa|0)==(c[ea+16>>2]|0)){u=0;ea=qa(c[(c[ea>>2]|0)+36>>2]|0,ea|0)|0;ia=u;u=0;if(ia&1){B=20;break b}da=c[o>>2]|0}else{ea=d[fa>>0]|0}c[o>>2]=da+1;a[da>>0]=ea;aa=aa+ -1|0;c[F>>2]=aa;da=c[e>>2]|0;fa=da+12|0;ea=c[fa>>2]|0;if((ea|0)==(c[da+16>>2]|0)){u=0;qa(c[(c[da>>2]|0)+40>>2]|0,da|0)|0;ia=u;u=0;if(ia&1){B=20;break b}}else{c[fa>>2]=ea+1}if((aa|0)<=0){break}else{da=ba}}}if((c[o>>2]|0)==(c[n>>2]|0)){B=299;break b}break};default:{}}}while(0);g:do{if((B|0)==40){B=0;if((X|0)==3){D=_;G=Y;B=301;break b}else{ca=aa;ba=aa}while(1){aa=c[e>>2]|0;do{if((aa|0)!=0){if((c[aa+12>>2]|0)==(c[aa+16>>2]|0)){u=0;aa=qa(c[(c[aa>>2]|0)+36>>2]|0,aa|0)|0;ia=u;u=0;if(ia&1){B=22;break b}if((aa|0)==-1){c[e>>2]=0;aa=0;break}else{aa=c[e>>2]|0;break}}}else{aa=0}}while(0);da=(aa|0)==0;do{if((ba|0)!=0){if((c[ba+12>>2]|0)!=(c[ba+16>>2]|0)){if(da){aa=ca;break}else{break g}}u=0;aa=qa(c[(c[ba>>2]|0)+36>>2]|0,ba|0)|0;ia=u;u=0;if(ia&1){B=22;break b}if(!((aa|0)==-1)){if(da^(ca|0)==0){aa=ca;ba=ca;break}else{break g}}else{c[f>>2]=0;aa=0;B=53;break}}else{aa=ca;B=53}}while(0);if((B|0)==53){B=0;if(da){break g}else{ba=0}}da=c[e>>2]|0;ca=c[da+12>>2]|0;if((ca|0)==(c[da+16>>2]|0)){u=0;ca=qa(c[(c[da>>2]|0)+36>>2]|0,da|0)|0;ia=u;u=0;if(ia&1){B=22;break b}}else{ca=d[ca>>0]|0}if(!((ca&255)<<24>>24>-1)){break g}if((b[(c[M>>2]|0)+(ca<<24>>24<<1)>>1]&8192)==0){break g}ca=c[e>>2]|0;ea=ca+12|0;da=c[ea>>2]|0;if((da|0)==(c[ca+16>>2]|0)){u=0;ca=qa(c[(c[ca>>2]|0)+40>>2]|0,ca|0)|0;ia=u;u=0;if(ia&1){B=22;break b}}else{c[ea>>2]=da+1;ca=d[da>>0]|0}u=0;oa(122,s|0,ca&255|0);ia=u;u=0;if(ia&1){B=22;break b}else{ca=aa}}}}while(0);X=X+1|0;if(!(X>>>0<4)){D=_;G=Y;B=301;break}}h:switch(B|0){case 19:{A=qb(-1,-1)|0;break a};case 20:{w=$;z=Y;A=qb(-1,-1)|0;break a};case 21:{w=$;z=Y;A=qb(-1,-1)|0;break a};case 22:{w=$;z=Y;A=qb(-1,-1)|0;break a};case 23:{A=qb(-1,-1)|0;break a};case 39:{c[k>>2]=c[k>>2]|4;C=0;D=$;G=Y;break};case 131:{c[k>>2]=c[k>>2]|4;C=0;D=$;G=Y;break};case 183:{c[k>>2]=c[k>>2]|4;C=0;D=$;G=Y;break};case 211:{jd(qb(-1,-1,0)|0);break};case 256:{c[k>>2]=c[k>>2]|4;C=0;D=$;G=Y;break};case 279:{c[k>>2]=c[k>>2]|4;C=0;D=$;G=Y;break};case 288:{jd(qb(-1,-1,0)|0);break};case 299:{c[k>>2]=c[k>>2]|4;C=0;D=$;G=Y;break};case 301:{i:do{if((W|0)!=0){C=W+1|0;o=W+8|0;E=W+4|0;F=1;j:while(1){n=a[W>>0]|0;if((n&1)==0){n=(n&255)>>>1}else{n=c[E>>2]|0}if(!(F>>>0<n>>>0)){break i}n=c[e>>2]|0;do{if((n|0)!=0){if((c[n+12>>2]|0)==(c[n+16>>2]|0)){u=0;n=qa(c[(c[n>>2]|0)+36>>2]|0,n|0)|0;ia=u;u=0;if(ia&1){B=18;break j}if((n|0)==-1){c[e>>2]=0;n=0;break}else{n=c[e>>2]|0;break}}}else{n=0}}while(0);n=(n|0)==0;H=c[f>>2]|0;do{if((H|0)!=0){if((c[H+12>>2]|0)!=(c[H+16>>2]|0)){if(n){break}else{B=327;break j}}u=0;H=qa(c[(c[H>>2]|0)+36>>2]|0,H|0)|0;ia=u;u=0;if(ia&1){B=18;break j}if(!((H|0)==-1)){if(n){break}else{B=327;break j}}else{c[f>>2]=0;B=319;break}}else{B=319}}while(0);if((B|0)==319?(B=0,n):0){B=327;break}H=c[e>>2]|0;n=c[H+12>>2]|0;if((n|0)==(c[H+16>>2]|0)){u=0;H=qa(c[(c[H>>2]|0)+36>>2]|0,H|0)|0;ia=u;u=0;if(ia&1){B=18;break}}else{H=d[n>>0]|0}if((a[W>>0]&1)==0){n=C}else{n=c[o>>2]|0}if(!((H&255)<<24>>24==(a[n+F>>0]|0))){B=327;break}F=F+1|0;n=c[e>>2]|0;l=n+12|0;H=c[l>>2]|0;if((H|0)==(c[n+16>>2]|0)){u=0;qa(c[(c[n>>2]|0)+40>>2]|0,n|0)|0;ia=u;u=0;if(ia&1){B=18;break}else{continue}}else{c[l>>2]=H+1;continue}}if((B|0)==18){A=qb(-1,-1)|0;w=$;z=G;break a}else if((B|0)==327){c[k>>2]=c[k>>2]|4;C=0;D=$;break h}}}while(0);if(($|0)!=(D|0)){c[y>>2]=0;Pr(r,$,D,y);if((c[y>>2]|0)==0){C=1;D=$}else{c[k>>2]=c[k>>2]|4;C=0;D=$}}else{C=1}break}}Rm(s);Rm(q);Rm(t);Rm(v);Rm(r);if((D|0)==0){i=x;return C|0}u=0;na(G|0,D|0);ia=u;u=0;if(ia&1){ia=qb(-1,-1,0)|0;jd(ia)}else{i=x;return C|0}}else{A=qb(-1,-1)|0;w=W;z=209}}while(0);Rm(s);Rm(q);Rm(t);Rm(v);Rm(r);if((w|0)==0){vb(A|0)}u=0;na(z|0,w|0);ia=u;u=0;if(ia&1){ia=qb(-1,-1,0)|0;jd(ia)}else{vb(A|0)}return 0}function Lr(a){a=a|0;var b=0;b=Jb(8)|0;u=0;oa(75,b|0,a|0);a=u;u=0;if(a&1){a=qb(-1,-1)|0;pb(b|0);vb(a|0)}else{qc(b|0,13360,88)}}function Mr(b,d,e,f,g,h,j,k){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;var l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0;n=i;i=i+144|0;t=n;p=n+36|0;l=n+24|0;q=n+20|0;m=n+16|0;s=n+32|0;v=n+12|0;c[l>>2]=p;d=l+4|0;c[d>>2]=209;w=p+100|0;u=0;oa(84,m|0,h|0);y=u;u=0;if(!(y&1)){p=c[m>>2]|0;if(!(!((c[4088]|0)==-1)?(c[t>>2]=16352,c[t+4>>2]=205,c[t+8>>2]=0,u=0,Na(58,16352,t|0,206),y=u,u=0,y&1):0)){o=4}a:do{if((o|0)==4){y=(c[16356>>2]|0)+ -1|0;x=c[p+8>>2]|0;if((c[p+12>>2]|0)-x>>2>>>0>y>>>0?(r=c[x+(y<<2)>>2]|0,(r|0)!=0):0){a[s>>0]=0;p=c[f>>2]|0;c[v>>2]=p;y=c[h+4>>2]|0;u=0;c[t+0>>2]=c[v+0>>2];g=sa(1,e|0,t|0,g|0,m|0,y|0,j|0,s|0,r|0,l|0,q|0,w|0)|0;y=u;u=0;if(y&1){break}if(g){if((a[k>>0]&1)==0){a[k+1>>0]=0;a[k>>0]=0}else{a[c[k+8>>2]>>0]=0;c[k+4>>2]=0}if((a[s>>0]|0)!=0){u=0;g=Ha(c[(c[r>>2]|0)+28>>2]|0,r|0,45)|0;y=u;u=0;if(y&1){break}u=0;oa(122,k|0,g|0);y=u;u=0;if(y&1){break}}u=0;r=Ha(c[(c[r>>2]|0)+28>>2]|0,r|0,48)|0;y=u;u=0;if(y&1){break}s=c[l>>2]|0;q=c[q>>2]|0;g=q+ -1|0;b:do{if(s>>>0<g>>>0){while(1){h=s+1|0;if(!((a[s>>0]|0)==r<<24>>24)){break b}if(h>>>0<g>>>0){s=h}else{s=h;break}}}}while(0);u=0;ua(35,k|0,s|0,q|0)|0;y=u;u=0;if(y&1){break}}k=c[e>>2]|0;if((k|0)!=0){if((c[k+12>>2]|0)==(c[k+16>>2]|0)){u=0;q=qa(c[(c[k>>2]|0)+36>>2]|0,k|0)|0;y=u;u=0;if(y&1){break}if((q|0)==-1){c[e>>2]=0;q=0}else{q=k}}else{q=k}}else{q=0}k=(q|0)==0;do{if((p|0)!=0){if((c[p+12>>2]|0)!=(c[p+16>>2]|0)){if(k){break}else{o=35;break}}u=0;e=qa(c[(c[p>>2]|0)+36>>2]|0,p|0)|0;y=u;u=0;if(y&1){break a}if(!((e|0)==-1)){if(k^(p|0)==0){break}else{o=35;break}}else{c[f>>2]=0;o=33;break}}else{o=33}}while(0);if((o|0)==33?k:0){o=35}if((o|0)==35){c[j>>2]=c[j>>2]|2}c[b>>2]=q;qm(c[m>>2]|0)|0;j=c[l>>2]|0;c[l>>2]=0;if((j|0)==0){i=n;return}u=0;na(c[d>>2]|0,j|0);y=u;u=0;if(y&1){y=qb(-1,-1,0)|0;jd(y)}else{i=n;return}}y=Jb(4)|0;bv(y);u=0;Na(45,y|0,24312,171);y=u;u=0}}while(0);n=qb(-1,-1)|0;qm(c[m>>2]|0)|0;p=c[l>>2]|0;c[l>>2]=0;if((p|0)==0){y=n;vb(y|0)}}else{n=qb(-1,-1)|0;c[l>>2]=0}u=0;na(c[d>>2]|0,p|0);y=u;u=0;if(y&1){y=qb(-1,-1,0)|0;jd(y)}else{y=n;vb(y|0)}}function Nr(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0;f=i;j=d;l=a[b>>0]|0;if((l&1)==0){k=10;g=(l&255)>>>1}else{l=c[b>>2]|0;k=(l&-2)+ -1|0;g=c[b+4>>2]|0;l=l&255}h=e-j|0;if((e|0)==(d|0)){i=f;return b|0}if((k-g|0)>>>0<h>>>0){_m(b,k,g+h-k|0,g,g,0,0);l=a[b>>0]|0}if((l&1)==0){k=b+1|0}else{k=c[b+8>>2]|0}j=e+(g-j)|0;l=k+g|0;while(1){a[l>>0]=a[d>>0]|0;d=d+1|0;if((d|0)==(e|0)){break}else{l=l+1|0}}a[k+j>>0]=0;e=g+h|0;if((a[b>>0]&1)==0){a[b>>0]=e<<1;i=f;return b|0}else{c[b+4>>2]=e;i=f;return b|0}return 0}function Or(b,d,e,f,g,h,j,k,l,m){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;l=l|0;m=m|0;var n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0;n=i;i=i+128|0;z=n;w=n+112|0;x=n+100|0;y=n+88|0;o=n+76|0;v=n+64|0;r=n+60|0;q=n+48|0;t=n+36|0;p=n+24|0;s=n+12|0;if(b){p=c[d>>2]|0;if(!((c[3948]|0)==-1)){c[z>>2]=15792;c[z+4>>2]=205;c[z+8>>2]=0;Lm(15792,z,206)}r=(c[15796>>2]|0)+ -1|0;q=c[p+8>>2]|0;if(!((c[p+12>>2]|0)-q>>2>>>0>r>>>0)){d=Jb(4)|0;bv(d);qc(d|0,24312,171)}p=c[q+(r<<2)>>2]|0;if((p|0)==0){d=Jb(4)|0;bv(d);qc(d|0,24312,171)}zc[c[(c[p>>2]|0)+44>>2]&127](w,p);d=c[w>>2]|0;a[e>>0]=d;a[e+1>>0]=d>>8;a[e+2>>0]=d>>16;a[e+3>>0]=d>>24;zc[c[(c[p>>2]|0)+32>>2]&127](x,p);if((a[l>>0]&1)==0){a[l+1>>0]=0;a[l>>0]=0}else{a[c[l+8>>2]>>0]=0;c[l+4>>2]=0}u=0;oa(123,l|0,0);d=u;u=0;if(d&1){d=qb(-1,-1,0)|0;jd(d)}c[l+0>>2]=c[x+0>>2];c[l+4>>2]=c[x+4>>2];c[l+8>>2]=c[x+8>>2];c[x+0>>2]=0;c[x+4>>2]=0;c[x+8>>2]=0;Rm(x);zc[c[(c[p>>2]|0)+28>>2]&127](y,p);if((a[k>>0]&1)==0){a[k+1>>0]=0;a[k>>0]=0}else{a[c[k+8>>2]>>0]=0;c[k+4>>2]=0}u=0;oa(123,k|0,0);d=u;u=0;if(d&1){d=qb(-1,-1,0)|0;jd(d)}c[k+0>>2]=c[y+0>>2];c[k+4>>2]=c[y+4>>2];c[k+8>>2]=c[y+8>>2];c[y+0>>2]=0;c[y+4>>2]=0;c[y+8>>2]=0;Rm(y);d=Bc[c[(c[p>>2]|0)+12>>2]&255](p)|0;a[f>>0]=d;d=Bc[c[(c[p>>2]|0)+16>>2]&255](p)|0;a[g>>0]=d;zc[c[(c[p>>2]|0)+20>>2]&127](o,p);if((a[h>>0]&1)==0){a[h+1>>0]=0;a[h>>0]=0}else{a[c[h+8>>2]>>0]=0;c[h+4>>2]=0}u=0;oa(123,h|0,0);d=u;u=0;if(d&1){d=qb(-1,-1,0)|0;jd(d)}c[h+0>>2]=c[o+0>>2];c[h+4>>2]=c[o+4>>2];c[h+8>>2]=c[o+8>>2];c[o+0>>2]=0;c[o+4>>2]=0;c[o+8>>2]=0;Rm(o);zc[c[(c[p>>2]|0)+24>>2]&127](v,p);if((a[j>>0]&1)==0){a[j+1>>0]=0;a[j>>0]=0}else{a[c[j+8>>2]>>0]=0;c[j+4>>2]=0}u=0;oa(123,j|0,0);d=u;u=0;if(d&1){d=qb(-1,-1,0)|0;jd(d)}c[j+0>>2]=c[v+0>>2];c[j+4>>2]=c[v+4>>2];c[j+8>>2]=c[v+8>>2];c[v+0>>2]=0;c[v+4>>2]=0;c[v+8>>2]=0;Rm(v);d=Bc[c[(c[p>>2]|0)+36>>2]&255](p)|0;c[m>>2]=d;i=n;return}else{o=c[d>>2]|0;if(!((c[3932]|0)==-1)){c[z>>2]=15728;c[z+4>>2]=205;c[z+8>>2]=0;Lm(15728,z,206)}v=(c[15732>>2]|0)+ -1|0;w=c[o+8>>2]|0;if(!((c[o+12>>2]|0)-w>>2>>>0>v>>>0)){d=Jb(4)|0;bv(d);qc(d|0,24312,171)}o=c[w+(v<<2)>>2]|0;if((o|0)==0){d=Jb(4)|0;bv(d);qc(d|0,24312,171)}zc[c[(c[o>>2]|0)+44>>2]&127](r,o);d=c[r>>2]|0;a[e>>0]=d;a[e+1>>0]=d>>8;a[e+2>>0]=d>>16;a[e+3>>0]=d>>24;zc[c[(c[o>>2]|0)+32>>2]&127](q,o);if((a[l>>0]&1)==0){a[l+1>>0]=0;a[l>>0]=0}else{a[c[l+8>>2]>>0]=0;c[l+4>>2]=0}u=0;oa(123,l|0,0);d=u;u=0;if(d&1){d=qb(-1,-1,0)|0;jd(d)}c[l+0>>2]=c[q+0>>2];c[l+4>>2]=c[q+4>>2];c[l+8>>2]=c[q+8>>2];c[q+0>>2]=0;c[q+4>>2]=0;c[q+8>>2]=0;Rm(q);zc[c[(c[o>>2]|0)+28>>2]&127](t,o);if((a[k>>0]&1)==0){a[k+1>>0]=0;a[k>>0]=0}else{a[c[k+8>>2]>>0]=0;c[k+4>>2]=0}u=0;oa(123,k|0,0);d=u;u=0;if(d&1){d=qb(-1,-1,0)|0;jd(d)}c[k+0>>2]=c[t+0>>2];c[k+4>>2]=c[t+4>>2];c[k+8>>2]=c[t+8>>2];c[t+0>>2]=0;c[t+4>>2]=0;c[t+8>>2]=0;Rm(t);d=Bc[c[(c[o>>2]|0)+12>>2]&255](o)|0;a[f>>0]=d;d=Bc[c[(c[o>>2]|0)+16>>2]&255](o)|0;a[g>>0]=d;zc[c[(c[o>>2]|0)+20>>2]&127](p,o);if((a[h>>0]&1)==0){a[h+1>>0]=0;a[h>>0]=0}else{a[c[h+8>>2]>>0]=0;c[h+4>>2]=0}u=0;oa(123,h|0,0);d=u;u=0;if(d&1){d=qb(-1,-1,0)|0;jd(d)}c[h+0>>2]=c[p+0>>2];c[h+4>>2]=c[p+4>>2];c[h+8>>2]=c[p+8>>2];c[p+0>>2]=0;c[p+4>>2]=0;c[p+8>>2]=0;Rm(p);zc[c[(c[o>>2]|0)+24>>2]&127](s,o);if((a[j>>0]&1)==0){a[j+1>>0]=0;a[j>>0]=0}else{a[c[j+8>>2]>>0]=0;c[j+4>>2]=0}u=0;oa(123,j|0,0);d=u;u=0;if(d&1){d=qb(-1,-1,0)|0;jd(d)}c[j+0>>2]=c[s+0>>2];c[j+4>>2]=c[s+4>>2];c[j+8>>2]=c[s+8>>2];c[s+0>>2]=0;c[s+4>>2]=0;c[s+8>>2]=0;Rm(s);d=Bc[c[(c[o>>2]|0)+36>>2]&255](o)|0;c[m>>2]=d;i=n;return}}function Pr(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0;g=i;k=a[b>>0]|0;if((k&1)==0){j=(k&255)>>>1}else{j=c[b+4>>2]|0}if((j|0)==0){i=g;return}if((d|0)!=(e|0)?(h=e+ -4|0,h>>>0>d>>>0):0){j=d;do{k=c[j>>2]|0;c[j>>2]=c[h>>2];c[h>>2]=k;j=j+4|0;h=h+ -4|0}while(j>>>0<h>>>0);k=a[b>>0]|0}if((k&1)==0){h=b+1|0;b=(k&255)>>>1}else{h=c[b+8>>2]|0;b=c[b+4>>2]|0}e=e+ -4|0;k=a[h>>0]|0;j=k<<24>>24<1|k<<24>>24==127;a:do{if(e>>>0>d>>>0){b=h+b|0;while(1){if(!j?(k<<24>>24|0)!=(c[d>>2]|0):0){break}h=(b-h|0)>1?h+1|0:h;d=d+4|0;k=a[h>>0]|0;j=k<<24>>24<1|k<<24>>24==127;if(!(d>>>0<e>>>0)){break a}}c[f>>2]=4;i=g;return}}while(0);if(j){i=g;return}j=c[e>>2]|0;if(!(k<<24>>24>>>0<j>>>0|(j|0)==0)){i=g;return}c[f>>2]=4;i=g;return}function Qr(a){a=a|0;var b=0;b=i;Hv(a);i=b;return}function Rr(a){a=a|0;return}function Sr(b,d,e,f,g,h,j,k){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;var l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0;o=i;i=i+592|0;v=o;p=o+80|0;l=o+72|0;x=o+64|0;n=o+60|0;z=o+580|0;B=o+56|0;y=o+16|0;w=o+480|0;c[l>>2]=p;d=l+4|0;c[d>>2]=209;C=p+400|0;u=0;oa(84,n|0,h|0);F=u;u=0;do{if(!(F&1)){D=c[n>>2]|0;if(!((c[4086]|0)==-1)?(c[v>>2]=16344,c[v+4>>2]=205,c[v+8>>2]=0,u=0,Na(58,16344,v|0,206),F=u,u=0,F&1):0){p=15}else{p=4}a:do{if((p|0)==4){E=(c[16348>>2]|0)+ -1|0;F=c[D+8>>2]|0;if((c[D+12>>2]|0)-F>>2>>>0>E>>>0?(A=c[F+(E<<2)>>2]|0,(A|0)!=0):0){a[z>>0]=0;c[B>>2]=c[f>>2];F=c[h+4>>2]|0;u=0;c[v+0>>2]=c[B+0>>2];g=sa(2,e|0,v|0,g|0,n|0,F|0,j|0,z|0,A|0,l|0,x|0,C|0)|0;F=u;u=0;if(F&1){p=15;break}b:do{if(g){u=0;Ma(c[(c[A>>2]|0)+48>>2]|0,A|0,16048,16058|0,y|0)|0;F=u;u=0;if(F&1){p=15;break a}g=c[x>>2]|0;h=c[l>>2]|0;p=g-h|0;if((p|0)>392){p=Av((p>>2)+2|0)|0;if((p|0)==0){u=0;Oa(4);F=u;u=0;if(F&1){r=0;p=16}else{A=0;B=0;p=19}}else{A=p;B=p;p=19}}else{A=0;B=w;p=19}do{if((p|0)==19){if((a[z>>0]|0)!=0){a[B>>0]=45;B=B+1|0}if(h>>>0<g>>>0){z=y+40|0;g=y;do{C=c[h>>2]|0;D=y;while(1){if((c[D>>2]|0)==(C|0)){break}D=D+4|0;if((D|0)==(z|0)){D=z;break}}a[B>>0]=a[16048+(D-g>>2)>>0]|0;h=h+4|0;B=B+1|0}while(h>>>0<(c[x>>2]|0)>>>0)}a[B>>0]=0;c[v>>2]=k;if((Tu(w,15984,v)|0)==1){if((A|0)==0){break b}Bv(A);break b}m=Jb(8)|0;u=0;oa(75,m|0,15992);F=u;u=0;if(F&1){q=qb(-1,-1)|0;pb(m|0);r=A;break}u=0;Na(45,m|0,13360,88);F=u;u=0;if(F&1){r=A;p=16}}}while(0);if((p|0)==16){q=qb(-1,-1)|0}if((r|0)==0){m=q;break a}Bv(r);m=q;break a}}while(0);q=c[e>>2]|0;do{if((q|0)!=0){r=c[q+12>>2]|0;if((r|0)==(c[q+16>>2]|0)){u=0;q=qa(c[(c[q>>2]|0)+36>>2]|0,q|0)|0;F=u;u=0;if(F&1){p=15;break a}}else{q=c[r>>2]|0}if((q|0)==-1){c[e>>2]=0;q=1;break}else{q=(c[e>>2]|0)==0;break}}else{q=1}}while(0);k=c[f>>2]|0;do{if((k|0)!=0){r=c[k+12>>2]|0;if((r|0)==(c[k+16>>2]|0)){u=0;r=qa(c[(c[k>>2]|0)+36>>2]|0,k|0)|0;F=u;u=0;if(F&1){p=15;break a}}else{r=c[r>>2]|0}if(!((r|0)==-1)){if(q){break}else{p=49;break}}else{c[f>>2]=0;p=47;break}}else{p=47}}while(0);if((p|0)==47?q:0){p=49}if((p|0)==49){c[j>>2]=c[j>>2]|2}c[b>>2]=c[e>>2];qm(c[n>>2]|0)|0;j=c[l>>2]|0;c[l>>2]=0;if((j|0)==0){i=o;return}u=0;na(c[d>>2]|0,j|0);F=u;u=0;if(F&1){F=qb(-1,-1,0)|0;jd(F)}else{i=o;return}}F=Jb(4)|0;bv(F);u=0;Na(45,F|0,24312,171);F=u;u=0;if(F&1){p=15}}}while(0);if((p|0)==15){m=qb(-1,-1)|0}qm(c[n>>2]|0)|0;p=c[l>>2]|0;c[l>>2]=0;if((p|0)==0){F=m;vb(F|0)}else{d=c[d>>2]|0;break}}else{m=qb(-1,-1)|0;c[l>>2]=0;d=209}}while(0);u=0;na(d|0,p|0);F=u;u=0;if(F&1){F=qb(-1,-1,0)|0;jd(F)}else{F=m;vb(F|0)}}function Tr(b,e,f,g,h,j,k,l,m,n,o){b=b|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;l=l|0;m=m|0;n=n|0;o=o|0;var p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,da=0;y=i;i=i+480|0;R=y+80|0;D=y+76|0;H=y+72|0;E=y+68|0;r=y+56|0;q=y+44|0;p=y+32|0;s=y+20|0;t=y+8|0;F=y+4|0;z=y;c[D>>2]=0;c[r+0>>2]=0;c[r+4>>2]=0;c[r+8>>2]=0;c[q+0>>2]=0;c[q+4>>2]=0;c[q+8>>2]=0;c[p+0>>2]=0;c[p+4>>2]=0;c[p+8>>2]=0;c[s+0>>2]=0;c[s+4>>2]=0;c[s+8>>2]=0;c[t+0>>2]=0;c[t+4>>2]=0;c[t+8>>2]=0;u=0;Ga(2,f|0,g|0,D|0,H|0,E|0,r|0,q|0,p|0,s|0,F|0);ca=u;u=0;a:do{if(!(ca&1)){c[n>>2]=c[m>>2];g=s+4|0;I=s+8|0;f=p+4|0;J=p+8|0;P=(h&512|0)!=0;Q=q+4|0;h=q+8|0;K=t+4|0;L=t+8|0;M=D+3|0;O=m+4|0;N=r+4|0;U=R+400|0;V=R;W=R;S=0;R=0;T=209;b:while(1){X=c[b>>2]|0;do{if((X|0)!=0){Y=c[X+12>>2]|0;if((Y|0)==(c[X+16>>2]|0)){u=0;X=qa(c[(c[X>>2]|0)+36>>2]|0,X|0)|0;ca=u;u=0;if(ca&1){v=W;w=T;A=25;break b}}else{X=c[Y>>2]|0}if((X|0)==-1){c[b>>2]=0;Y=1;break}else{Y=(c[b>>2]|0)==0;break}}else{Y=1}}while(0);X=c[e>>2]|0;do{if((X|0)!=0){Z=c[X+12>>2]|0;if((Z|0)==(c[X+16>>2]|0)){u=0;Z=qa(c[(c[X>>2]|0)+36>>2]|0,X|0)|0;ca=u;u=0;if(ca&1){v=W;w=T;A=25;break b}}else{Z=c[Z>>2]|0}if(!((Z|0)==-1)){if(Y){break}else{C=V;G=T;A=322;break b}}else{c[e>>2]=0;A=16;break}}else{A=16}}while(0);if((A|0)==16){A=0;if(Y){C=V;G=T;A=322;break}else{X=0}}c:do{switch(a[D+S>>0]|0){case 0:{A=42;break};case 2:{if(!((R|0)!=0|S>>>0<2)){if((S|0)==2){Y=(a[M>>0]|0)!=0}else{Y=0}if(!(P|Y)){R=0;break c}}$=a[q>>0]|0;Y=($&1)==0?Q:c[h>>2]|0;d:do{if((S|0)!=0?(d[D+(S+ -1)>>0]|0)<2:0){while(1){if(($&1)==0){_=Q;Z=($&255)>>>1}else{_=c[h>>2]|0;Z=c[Q>>2]|0}if((Y|0)==(_+(Z<<2)|0)){break}u=0;Z=ua(c[(c[l>>2]|0)+12>>2]|0,l|0,8192,c[Y>>2]|0)|0;ca=u;u=0;if(ca&1){A=22;break b}if(!Z){A=148;break}$=a[q>>0]|0;Y=Y+4|0}if((A|0)==148){A=0;$=a[q>>0]|0}_=($&1)==0;aa=Y-(_?Q:c[h>>2]|0)>>2;Z=a[t>>0]|0;ba=(Z&1)==0;if(ba){ca=(Z&255)>>>1}else{ca=c[K>>2]|0}e:do{if(!(aa>>>0>ca>>>0)){if(ba){ca=K;ba=(Z&255)>>>1;aa=K+(((Z&255)>>>1)-aa<<2)|0}else{da=c[L>>2]|0;Z=c[K>>2]|0;ca=da;ba=Z;aa=da+(Z-aa<<2)|0}Z=ca+(ba<<2)|0;if((aa|0)==(Z|0)){Z=X;break d}else{ba=aa;aa=_?Q:c[h>>2]|0}while(1){if((c[ba>>2]|0)!=(c[aa>>2]|0)){break e}ba=ba+4|0;if((ba|0)==(Z|0)){Z=X;break d}aa=aa+4|0}}}while(0);Z=X;Y=_?Q:c[h>>2]|0}else{Z=X}}while(0);f:while(1){if(($&1)==0){_=Q;$=($&255)>>>1}else{_=c[h>>2]|0;$=c[Q>>2]|0}if((Y|0)==(_+($<<2)|0)){break}$=c[b>>2]|0;do{if(($|0)!=0){_=c[$+12>>2]|0;if((_|0)==(c[$+16>>2]|0)){u=0;_=qa(c[(c[$>>2]|0)+36>>2]|0,$|0)|0;da=u;u=0;if(da&1){A=23;break b}}else{_=c[_>>2]|0}if((_|0)==-1){c[b>>2]=0;_=1;break}else{_=(c[b>>2]|0)==0;break}}else{_=1}}while(0);do{if((X|0)!=0){$=c[X+12>>2]|0;if(($|0)==(c[X+16>>2]|0)){u=0;X=qa(c[(c[X>>2]|0)+36>>2]|0,X|0)|0;da=u;u=0;if(da&1){A=23;break b}}else{X=c[$>>2]|0}if(!((X|0)==-1)){if(_^(Z|0)==0){_=Z;X=Z;break}else{break f}}else{c[e>>2]=0;Z=0;A=178;break}}else{A=178}}while(0);if((A|0)==178){A=0;if(_){break}else{_=Z;X=0}}Z=c[b>>2]|0;$=c[Z+12>>2]|0;if(($|0)==(c[Z+16>>2]|0)){u=0;Z=qa(c[(c[Z>>2]|0)+36>>2]|0,Z|0)|0;da=u;u=0;if(da&1){A=23;break b}}else{Z=c[$>>2]|0}if((Z|0)!=(c[Y>>2]|0)){break}aa=c[b>>2]|0;$=aa+12|0;Z=c[$>>2]|0;if((Z|0)==(c[aa+16>>2]|0)){u=0;qa(c[(c[aa>>2]|0)+40>>2]|0,aa|0)|0;da=u;u=0;if(da&1){A=23;break b}}else{c[$>>2]=Z+4}Z=_;$=a[q>>0]|0;Y=Y+4|0}if(P){Z=a[q>>0]|0;if((Z&1)==0){X=Q;Z=(Z&255)>>>1}else{X=c[h>>2]|0;Z=c[Q>>2]|0}if((Y|0)!=(X+(Z<<2)|0)){A=193;break b}}break};case 1:{if((S|0)==3){C=V;G=T;A=322;break b}A=c[b>>2]|0;Y=c[A+12>>2]|0;if((Y|0)==(c[A+16>>2]|0)){u=0;A=qa(c[(c[A>>2]|0)+36>>2]|0,A|0)|0;da=u;u=0;if(da&1){v=W;w=T;A=25;break b}}else{A=c[Y>>2]|0}u=0;A=ua(c[(c[l>>2]|0)+12>>2]|0,l|0,8192,A|0)|0;da=u;u=0;if(da&1){v=W;w=T;A=25;break b}if(!A){A=41;break b}Z=c[b>>2]|0;A=Z+12|0;Y=c[A>>2]|0;if((Y|0)==(c[Z+16>>2]|0)){u=0;A=qa(c[(c[Z>>2]|0)+40>>2]|0,Z|0)|0;da=u;u=0;if(da&1){v=W;w=T;A=25;break b}}else{c[A>>2]=Y+4;A=c[Y>>2]|0}u=0;oa(124,t|0,A|0);da=u;u=0;if(da&1){v=W;w=T;A=25;break b}else{A=42}break};case 3:{X=a[p>>0]|0;Z=(X&1)==0;if(Z){aa=(X&255)>>>1}else{aa=c[f>>2]|0}Y=a[s>>0]|0;_=(Y&1)==0;if(_){$=(Y&255)>>>1}else{$=c[g>>2]|0}if((aa|0)!=(0-$|0)){if(Z){$=(X&255)>>>1}else{$=c[f>>2]|0}if(($|0)!=0){if(_){_=(Y&255)>>>1}else{_=c[g>>2]|0}if((_|0)!=0){Z=c[b>>2]|0;Y=c[Z+12>>2]|0;if((Y|0)==(c[Z+16>>2]|0)){u=0;Y=qa(c[(c[Z>>2]|0)+36>>2]|0,Z|0)|0;da=u;u=0;if(da&1){v=W;w=T;A=25;break b}X=a[p>>0]|0}else{Y=c[Y>>2]|0}Z=c[b>>2]|0;$=Z+12|0;_=c[$>>2]|0;aa=(_|0)==(c[Z+16>>2]|0);if((Y|0)==(c[((X&1)==0?f:c[J>>2]|0)>>2]|0)){if(aa){u=0;qa(c[(c[Z>>2]|0)+40>>2]|0,Z|0)|0;da=u;u=0;if(da&1){v=W;w=T;A=25;break b}}else{c[$>>2]=_+4}X=a[p>>0]|0;if((X&1)==0){X=(X&255)>>>1}else{X=c[f>>2]|0}R=X>>>0>1?p:R;break c}if(aa){u=0;X=qa(c[(c[Z>>2]|0)+36>>2]|0,Z|0)|0;da=u;u=0;if(da&1){v=W;w=T;A=25;break b}}else{X=c[_>>2]|0}if((X|0)!=(c[((a[s>>0]&1)==0?g:c[I>>2]|0)>>2]|0)){A=134;break b}Z=c[b>>2]|0;Y=Z+12|0;X=c[Y>>2]|0;if((X|0)==(c[Z+16>>2]|0)){u=0;qa(c[(c[Z>>2]|0)+40>>2]|0,Z|0)|0;da=u;u=0;if(da&1){v=W;w=T;A=25;break b}}else{c[Y>>2]=X+4}a[k>>0]=1;X=a[s>>0]|0;if((X&1)==0){X=(X&255)>>>1}else{X=c[g>>2]|0}R=X>>>0>1?s:R;break c}}if(Z){_=(X&255)>>>1}else{_=c[f>>2]|0}Z=c[b>>2]|0;$=c[Z+12>>2]|0;aa=($|0)==(c[Z+16>>2]|0);if((_|0)==0){if(aa){u=0;X=qa(c[(c[Z>>2]|0)+36>>2]|0,Z|0)|0;da=u;u=0;if(da&1){v=W;w=T;A=25;break b}Y=a[s>>0]|0}else{X=c[$>>2]|0}if((X|0)!=(c[((Y&1)==0?g:c[I>>2]|0)>>2]|0)){break c}Z=c[b>>2]|0;Y=Z+12|0;X=c[Y>>2]|0;if((X|0)==(c[Z+16>>2]|0)){u=0;qa(c[(c[Z>>2]|0)+40>>2]|0,Z|0)|0;da=u;u=0;if(da&1){v=W;w=T;A=25;break b}}else{c[Y>>2]=X+4}a[k>>0]=1;X=a[s>>0]|0;if((X&1)==0){X=(X&255)>>>1}else{X=c[g>>2]|0}R=X>>>0>1?s:R;break c}if(aa){u=0;Y=qa(c[(c[Z>>2]|0)+36>>2]|0,Z|0)|0;da=u;u=0;if(da&1){v=W;w=T;A=25;break b}X=a[p>>0]|0}else{Y=c[$>>2]|0}if((Y|0)!=(c[((X&1)==0?f:c[J>>2]|0)>>2]|0)){a[k>>0]=1;break c}Z=c[b>>2]|0;Y=Z+12|0;X=c[Y>>2]|0;if((X|0)==(c[Z+16>>2]|0)){u=0;qa(c[(c[Z>>2]|0)+40>>2]|0,Z|0)|0;da=u;u=0;if(da&1){v=W;w=T;A=25;break b}}else{c[Y>>2]=X+4}X=a[p>>0]|0;if((X&1)==0){X=(X&255)>>>1}else{X=c[f>>2]|0}R=X>>>0>1?p:R}break};case 4:{X=0;g:while(1){Z=c[b>>2]|0;do{if((Z|0)!=0){Y=c[Z+12>>2]|0;if((Y|0)==(c[Z+16>>2]|0)){u=0;Y=qa(c[(c[Z>>2]|0)+36>>2]|0,Z|0)|0;da=u;u=0;if(da&1){v=W;w=T;A=20;break b}}else{Y=c[Y>>2]|0}if((Y|0)==-1){c[b>>2]=0;Y=1;break}else{Y=(c[b>>2]|0)==0;break}}else{Y=1}}while(0);_=c[e>>2]|0;do{if((_|0)!=0){Z=c[_+12>>2]|0;if((Z|0)==(c[_+16>>2]|0)){u=0;Z=qa(c[(c[_>>2]|0)+36>>2]|0,_|0)|0;da=u;u=0;if(da&1){v=W;w=T;A=20;break b}}else{Z=c[Z>>2]|0}if(!((Z|0)==-1)){if(Y){break}else{break g}}else{c[e>>2]=0;A=207;break}}else{A=207}}while(0);if((A|0)==207?(A=0,Y):0){break}Z=c[b>>2]|0;Y=c[Z+12>>2]|0;if((Y|0)==(c[Z+16>>2]|0)){u=0;Y=qa(c[(c[Z>>2]|0)+36>>2]|0,Z|0)|0;da=u;u=0;if(da&1){v=W;w=T;A=20;break b}}else{Y=c[Y>>2]|0}u=0;Z=ua(c[(c[l>>2]|0)+12>>2]|0,l|0,2048,Y|0)|0;da=u;u=0;if(da&1){v=W;w=T;A=20;break b}if(Z){Z=c[n>>2]|0;if((Z|0)==(o|0)){_=(c[O>>2]|0)!=209;$=c[m>>2]|0;Z=o-$|0;o=Z>>>0<2147483647?Z<<1:-1;Z=Z>>2;if(!_){$=0}$=Cv($,o)|0;if(($|0)==0?(u=0,Oa(4),da=u,u=0,da&1):0){v=W;w=T;A=20;break b}if(!_){_=c[m>>2]|0;c[m>>2]=$;if((_|0)!=0){u=0;na(c[O>>2]|0,_|0);da=u;u=0;if(da&1){A=224;break b}$=c[m>>2]|0}}else{c[m>>2]=$}c[O>>2]=207;Z=$+(Z<<2)|0;c[n>>2]=Z;o=(c[m>>2]|0)+(o>>>2<<2)|0}c[n>>2]=Z+4;c[Z>>2]=Y;X=X+1|0}else{Z=a[r>>0]|0;if((Z&1)==0){Z=(Z&255)>>>1}else{Z=c[N>>2]|0}if((Z|0)==0|(X|0)==0){break}if((Y|0)!=(c[E>>2]|0)){break}if((V|0)==(U|0)){Z=(T|0)!=209;V=V-W|0;U=V>>>0<2147483647?V<<1:-1;V=V>>2;if(Z){Y=W}else{Y=0}Y=Cv(Y,U)|0;if((Y|0)==0?(u=0,Oa(4),da=u,u=0,da&1):0){v=W;w=T;A=20;break b}V=Y+(V<<2)|0;W=Y;U=Y+(U>>>2<<2)|0;T=207}c[V>>2]=X;V=V+4|0;X=0}_=c[b>>2]|0;Y=_+12|0;Z=c[Y>>2]|0;if((Z|0)==(c[_+16>>2]|0)){u=0;qa(c[(c[_>>2]|0)+40>>2]|0,_|0)|0;da=u;u=0;if(da&1){v=W;w=T;A=20;break b}else{continue}}else{c[Y>>2]=Z+4;continue}}if(!((W|0)==(V|0)|(X|0)==0)){if((V|0)==(U|0)){Y=(T|0)!=209;V=V-W|0;U=V>>>0<2147483647?V<<1:-1;V=V>>2;if(Y){Z=W}else{Z=0}Z=Cv(Z,U)|0;if((Z|0)==0?(u=0,Oa(4),da=u,u=0,da&1):0){v=W;w=T;A=25;break b}V=Z+(V<<2)|0;W=Z;U=Z+(U>>>2<<2)|0;T=207}c[V>>2]=X;V=V+4|0}X=c[F>>2]|0;if((X|0)>0){Y=c[b>>2]|0;do{if((Y|0)!=0){Z=c[Y+12>>2]|0;if((Z|0)==(c[Y+16>>2]|0)){u=0;Y=qa(c[(c[Y>>2]|0)+36>>2]|0,Y|0)|0;da=u;u=0;if(da&1){v=W;w=T;A=25;break b}}else{Y=c[Z>>2]|0}if((Y|0)==-1){c[b>>2]=0;Z=1;break}else{Z=(c[b>>2]|0)==0;break}}else{Z=1}}while(0);Y=c[e>>2]|0;do{if((Y|0)!=0){_=c[Y+12>>2]|0;if((_|0)==(c[Y+16>>2]|0)){u=0;_=qa(c[(c[Y>>2]|0)+36>>2]|0,Y|0)|0;da=u;u=0;if(da&1){v=W;w=T;A=25;break b}}else{_=c[_>>2]|0}if(!((_|0)==-1)){if(Z){break}else{A=274;break b}}else{c[e>>2]=0;A=268;break}}else{A=268}}while(0);if((A|0)==268){A=0;if(Z){A=274;break b}else{Y=0}}Z=c[b>>2]|0;_=c[Z+12>>2]|0;if((_|0)==(c[Z+16>>2]|0)){u=0;Z=qa(c[(c[Z>>2]|0)+36>>2]|0,Z|0)|0;da=u;u=0;if(da&1){v=W;w=T;A=25;break b}}else{Z=c[_>>2]|0}if((Z|0)!=(c[H>>2]|0)){A=274;break b}$=c[b>>2]|0;_=$+12|0;Z=c[_>>2]|0;if((Z|0)==(c[$+16>>2]|0)){u=0;qa(c[(c[$>>2]|0)+40>>2]|0,$|0)|0;da=u;u=0;if(da&1){v=W;w=T;A=25;break b}else{_=Y;Z=Y}}else{c[_>>2]=Z+4;_=Y;Z=Y}while(1){$=c[b>>2]|0;do{if(($|0)!=0){Y=c[$+12>>2]|0;if((Y|0)==(c[$+16>>2]|0)){u=0;Y=qa(c[(c[$>>2]|0)+36>>2]|0,$|0)|0;da=u;u=0;if(da&1){A=21;break b}}else{Y=c[Y>>2]|0}if((Y|0)==-1){c[b>>2]=0;$=1;break}else{$=(c[b>>2]|0)==0;break}}else{$=1}}while(0);do{if((Z|0)!=0){Y=c[Z+12>>2]|0;if((Y|0)==(c[Z+16>>2]|0)){u=0;Y=qa(c[(c[Z>>2]|0)+36>>2]|0,Z|0)|0;da=u;u=0;if(da&1){A=21;break b}}else{Y=c[Y>>2]|0}if(!((Y|0)==-1)){if($^(_|0)==0){Y=_;Z=_;break}else{A=298;break b}}else{c[e>>2]=0;Y=0;A=291;break}}else{Y=_;A=291}}while(0);if((A|0)==291){A=0;if($){A=298;break b}else{Z=0}}$=c[b>>2]|0;_=c[$+12>>2]|0;if((_|0)==(c[$+16>>2]|0)){u=0;_=qa(c[(c[$>>2]|0)+36>>2]|0,$|0)|0;da=u;u=0;if(da&1){A=21;break b}}else{_=c[_>>2]|0}u=0;_=ua(c[(c[l>>2]|0)+12>>2]|0,l|0,2048,_|0)|0;da=u;u=0;if(da&1){A=21;break b}if(!_){A=298;break b}_=c[n>>2]|0;if((_|0)==(o|0)){$=(c[O>>2]|0)!=209;aa=c[m>>2]|0;_=o-aa|0;o=_>>>0<2147483647?_<<1:-1;_=_>>2;if(!$){aa=0}aa=Cv(aa,o)|0;if((aa|0)==0?(u=0,Oa(4),da=u,u=0,da&1):0){A=21;break b}do{if($){c[m>>2]=aa}else{$=c[m>>2]|0;c[m>>2]=aa;if(($|0)==0){break}u=0;na(c[O>>2]|0,$|0);da=u;u=0;if(da&1){A=309;break b}aa=c[m>>2]|0}}while(0);c[O>>2]=207;_=aa+(_<<2)|0;c[n>>2]=_;o=(c[m>>2]|0)+(o>>>2<<2)|0}aa=c[b>>2]|0;$=c[aa+12>>2]|0;if(($|0)==(c[aa+16>>2]|0)){u=0;$=qa(c[(c[aa>>2]|0)+36>>2]|0,aa|0)|0;da=u;u=0;if(da&1){A=21;break b}_=c[n>>2]|0}else{$=c[$>>2]|0}c[n>>2]=_+4;c[_>>2]=$;X=X+ -1|0;c[F>>2]=X;$=c[b>>2]|0;aa=$+12|0;_=c[aa>>2]|0;if((_|0)==(c[$+16>>2]|0)){u=0;qa(c[(c[$>>2]|0)+40>>2]|0,$|0)|0;da=u;u=0;if(da&1){A=21;break b}}else{c[aa>>2]=_+4}if((X|0)<=0){break}else{_=Y}}}if((c[n>>2]|0)==(c[m>>2]|0)){A=320;break b}break};default:{}}}while(0);h:do{if((A|0)==42){A=0;if((S|0)==3){C=V;G=T;A=322;break b}else{Y=X;Z=X}while(1){_=c[b>>2]|0;do{if((_|0)!=0){X=c[_+12>>2]|0;if((X|0)==(c[_+16>>2]|0)){u=0;X=qa(c[(c[_>>2]|0)+36>>2]|0,_|0)|0;da=u;u=0;if(da&1){A=24;break b}}else{X=c[X>>2]|0}if((X|0)==-1){c[b>>2]=0;X=1;break}else{X=(c[b>>2]|0)==0;break}}else{X=1}}while(0);do{if((Z|0)!=0){_=c[Z+12>>2]|0;if((_|0)==(c[Z+16>>2]|0)){u=0;Z=qa(c[(c[Z>>2]|0)+36>>2]|0,Z|0)|0;da=u;u=0;if(da&1){A=24;break b}}else{Z=c[_>>2]|0}if(!((Z|0)==-1)){if(X^(Y|0)==0){X=Y;Z=Y;break}else{break h}}else{c[e>>2]=0;Y=0;A=56;break}}else{A=56}}while(0);if((A|0)==56){A=0;if(X){break h}else{X=Y;Z=0}}_=c[b>>2]|0;Y=c[_+12>>2]|0;if((Y|0)==(c[_+16>>2]|0)){u=0;Y=qa(c[(c[_>>2]|0)+36>>2]|0,_|0)|0;da=u;u=0;if(da&1){A=24;break b}}else{Y=c[Y>>2]|0}u=0;Y=ua(c[(c[l>>2]|0)+12>>2]|0,l|0,8192,Y|0)|0;da=u;u=0;if(da&1){A=24;break b}if(!Y){break h}$=c[b>>2]|0;Y=$+12|0;_=c[Y>>2]|0;if((_|0)==(c[$+16>>2]|0)){u=0;Y=qa(c[(c[$>>2]|0)+40>>2]|0,$|0)|0;da=u;u=0;if(da&1){A=24;break b}}else{c[Y>>2]=_+4;Y=c[_>>2]|0}u=0;oa(124,t|0,Y|0);da=u;u=0;if(da&1){A=24;break b}else{Y=X}}}}while(0);S=S+1|0;if(!(S>>>0<4)){C=V;G=T;A=322;break}}i:switch(A|0){case 20:{x=qb(-1,-1)|0;break a};case 21:{v=W;w=T;x=qb(-1,-1)|0;break a};case 22:{v=W;w=T;x=qb(-1,-1)|0;break a};case 23:{v=W;w=T;x=qb(-1,-1)|0;break a};case 24:{v=W;w=T;x=qb(-1,-1)|0;break a};case 25:{x=qb(-1,-1)|0;break a};case 41:{c[j>>2]=c[j>>2]|4;B=0;C=W;G=T;break};case 134:{c[j>>2]=c[j>>2]|4;B=0;C=W;G=T;break};case 193:{c[j>>2]=c[j>>2]|4;B=0;C=W;G=T;break};case 224:{jd(qb(-1,-1,0)|0);break};case 274:{c[j>>2]=c[j>>2]|4;B=0;C=W;G=T;break};case 298:{c[j>>2]=c[j>>2]|4;B=0;C=W;G=T;break};case 309:{jd(qb(-1,-1,0)|0);break};case 320:{c[j>>2]=c[j>>2]|4;B=0;C=W;G=T;break};case 322:{j:do{if((R|0)!=0){D=R+4|0;B=R+8|0;E=1;k:while(1){F=a[R>>0]|0;if((F&1)==0){F=(F&255)>>>1}else{F=c[D>>2]|0}if(!(E>>>0<F>>>0)){break j}F=c[b>>2]|0;do{if((F|0)!=0){l=c[F+12>>2]|0;if((l|0)==(c[F+16>>2]|0)){u=0;F=qa(c[(c[F>>2]|0)+36>>2]|0,F|0)|0;da=u;u=0;if(da&1){A=19;break k}}else{F=c[l>>2]|0}if((F|0)==-1){c[b>>2]=0;F=1;break}else{F=(c[b>>2]|0)==0;break}}else{F=1}}while(0);k=c[e>>2]|0;do{if((k|0)!=0){l=c[k+12>>2]|0;if((l|0)==(c[k+16>>2]|0)){u=0;l=qa(c[(c[k>>2]|0)+36>>2]|0,k|0)|0;da=u;u=0;if(da&1){A=19;break k}}else{l=c[l>>2]|0}if(!((l|0)==-1)){if(F){break}else{A=349;break k}}else{c[e>>2]=0;A=341;break}}else{A=341}}while(0);if((A|0)==341?(A=0,F):0){A=349;break}F=c[b>>2]|0;l=c[F+12>>2]|0;if((l|0)==(c[F+16>>2]|0)){u=0;l=qa(c[(c[F>>2]|0)+36>>2]|0,F|0)|0;da=u;u=0;if(da&1){A=19;break}}else{l=c[l>>2]|0}if((a[R>>0]&1)==0){F=D}else{F=c[B>>2]|0}if((l|0)!=(c[F+(E<<2)>>2]|0)){A=349;break}E=E+1|0;k=c[b>>2]|0;l=k+12|0;F=c[l>>2]|0;if((F|0)==(c[k+16>>2]|0)){u=0;qa(c[(c[k>>2]|0)+40>>2]|0,k|0)|0;da=u;u=0;if(da&1){A=19;break}else{continue}}else{c[l>>2]=F+4;continue}}if((A|0)==19){x=qb(-1,-1)|0;v=W;w=G;break a}else if((A|0)==349){c[j>>2]=c[j>>2]|4;B=0;C=W;break i}}}while(0);if((W|0)!=(C|0)){c[z>>2]=0;Pr(r,W,C,z);if((c[z>>2]|0)==0){B=1;C=W}else{c[j>>2]=c[j>>2]|4;B=0;C=W}}else{B=1}break}}bn(t);bn(s);bn(p);bn(q);Rm(r);if((C|0)==0){i=y;return B|0}u=0;na(G|0,C|0);da=u;u=0;if(da&1){da=qb(-1,-1,0)|0;jd(da)}else{i=y;return B|0}}else{x=qb(-1,-1)|0;v=R;w=209}}while(0);bn(t);bn(s);bn(p);bn(q);Rm(r);if((v|0)==0){vb(x|0)}u=0;na(w|0,v|0);da=u;u=0;if(da&1){da=qb(-1,-1,0)|0;jd(da)}else{vb(x|0)}return 0}function Ur(b,d,e,f,g,h,j,k){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;var l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0;o=i;i=i+448|0;v=o;p=o+32|0;l=o+24|0;q=o+20|0;m=o+16|0;s=o+432|0;w=o+12|0;c[l>>2]=p;d=l+4|0;c[d>>2]=209;t=p+400|0;u=0;oa(84,m|0,h|0);y=u;u=0;if(!(y&1)){x=c[m>>2]|0;if(!(!((c[4086]|0)==-1)?(c[v>>2]=16344,c[v+4>>2]=205,c[v+8>>2]=0,u=0,Na(58,16344,v|0,206),y=u,u=0,y&1):0)){n=4}a:do{if((n|0)==4){y=(c[16348>>2]|0)+ -1|0;p=c[x+8>>2]|0;if((c[x+12>>2]|0)-p>>2>>>0>y>>>0?(r=c[p+(y<<2)>>2]|0,(r|0)!=0):0){a[s>>0]=0;p=c[f>>2]|0;c[w>>2]=p;h=c[h+4>>2]|0;u=0;c[v+0>>2]=c[w+0>>2];h=sa(2,e|0,v|0,g|0,m|0,h|0,j|0,s|0,r|0,l|0,q|0,t|0)|0;y=u;u=0;if(y&1){break}if(h){if((a[k>>0]&1)==0){c[k+4>>2]=0;a[k>>0]=0}else{c[c[k+8>>2]>>2]=0;c[k+4>>2]=0}if((a[s>>0]|0)!=0){u=0;h=Ha(c[(c[r>>2]|0)+44>>2]|0,r|0,45)|0;y=u;u=0;if(y&1){break}u=0;oa(124,k|0,h|0);y=u;u=0;if(y&1){break}}u=0;r=Ha(c[(c[r>>2]|0)+44>>2]|0,r|0,48)|0;y=u;u=0;if(y&1){break}s=c[l>>2]|0;q=c[q>>2]|0;h=q+ -4|0;b:do{if(s>>>0<h>>>0){while(1){g=s+4|0;if((c[s>>2]|0)!=(r|0)){break b}if(g>>>0<h>>>0){s=g}else{s=g;break}}}}while(0);u=0;ua(36,k|0,s|0,q|0)|0;y=u;u=0;if(y&1){break}}k=c[e>>2]|0;do{if((k|0)!=0){q=c[k+12>>2]|0;if((q|0)==(c[k+16>>2]|0)){u=0;k=qa(c[(c[k>>2]|0)+36>>2]|0,k|0)|0;y=u;u=0;if(y&1){break a}}else{k=c[q>>2]|0}if((k|0)==-1){c[e>>2]=0;k=1;break}else{k=(c[e>>2]|0)==0;break}}else{k=1}}while(0);do{if((p|0)!=0){q=c[p+12>>2]|0;if((q|0)==(c[p+16>>2]|0)){u=0;p=qa(c[(c[p>>2]|0)+36>>2]|0,p|0)|0;y=u;u=0;if(y&1){break a}}else{p=c[q>>2]|0}if(!((p|0)==-1)){if(k){break}else{n=37;break}}else{c[f>>2]=0;n=35;break}}else{n=35}}while(0);if((n|0)==35?k:0){n=37}if((n|0)==37){c[j>>2]=c[j>>2]|2}c[b>>2]=c[e>>2];qm(c[m>>2]|0)|0;n=c[l>>2]|0;c[l>>2]=0;if((n|0)==0){i=o;return}u=0;na(c[d>>2]|0,n|0);y=u;u=0;if(y&1){y=qb(-1,-1,0)|0;jd(y)}else{i=o;return}}y=Jb(4)|0;bv(y);u=0;Na(45,y|0,24312,171);y=u;u=0}}while(0);n=qb(-1,-1)|0;qm(c[m>>2]|0)|0;p=c[l>>2]|0;c[l>>2]=0;if((p|0)==0){y=n;vb(y|0)}else{l=n}}else{y=qb(-1,-1)|0;c[l>>2]=0;l=y}u=0;na(c[d>>2]|0,p|0);y=u;u=0;if(y&1){y=qb(-1,-1,0)|0;jd(y)}else{y=l;vb(y|0)}}function Vr(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0;f=i;j=d;l=a[b>>0]|0;if((l&1)==0){k=1;g=(l&255)>>>1}else{l=c[b>>2]|0;k=(l&-2)+ -1|0;g=c[b+4>>2]|0;l=l&255}h=e-j>>2;if((h|0)==0){i=f;return b|0}if((k-g|0)>>>0<h>>>0){hn(b,k,g+h-k|0,g,g,0,0);l=a[b>>0]|0}if((l&1)==0){k=b+4|0}else{k=c[b+8>>2]|0}l=k+(g<<2)|0;if((d|0)!=(e|0)){j=g+((e+ -4+(0-j)|0)>>>2)+1|0;while(1){c[l>>2]=c[d>>2];d=d+4|0;if((d|0)==(e|0)){break}else{l=l+4|0}}l=k+(j<<2)|0}c[l>>2]=0;g=g+h|0;if((a[b>>0]&1)==0){a[b>>0]=g<<1;i=f;return b|0}else{c[b+4>>2]=g;i=f;return b|0}return 0}function Wr(b,d,e,f,g,h,j,k,l,m){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;l=l|0;m=m|0;var n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0;n=i;i=i+128|0;z=n;w=n+112|0;x=n+100|0;y=n+88|0;o=n+76|0;v=n+64|0;r=n+60|0;q=n+48|0;t=n+36|0;p=n+24|0;s=n+12|0;if(b){p=c[d>>2]|0;if(!((c[3980]|0)==-1)){c[z>>2]=15920;c[z+4>>2]=205;c[z+8>>2]=0;Lm(15920,z,206)}r=(c[15924>>2]|0)+ -1|0;q=c[p+8>>2]|0;if(!((c[p+12>>2]|0)-q>>2>>>0>r>>>0)){d=Jb(4)|0;bv(d);qc(d|0,24312,171)}p=c[q+(r<<2)>>2]|0;if((p|0)==0){d=Jb(4)|0;bv(d);qc(d|0,24312,171)}zc[c[(c[p>>2]|0)+44>>2]&127](w,p);d=c[w>>2]|0;a[e>>0]=d;a[e+1>>0]=d>>8;a[e+2>>0]=d>>16;a[e+3>>0]=d>>24;zc[c[(c[p>>2]|0)+32>>2]&127](x,p);if((a[l>>0]&1)==0){c[l+4>>2]=0;a[l>>0]=0}else{c[c[l+8>>2]>>2]=0;c[l+4>>2]=0}u=0;oa(125,l|0,0);d=u;u=0;if(d&1){d=qb(-1,-1,0)|0;jd(d)}c[l+0>>2]=c[x+0>>2];c[l+4>>2]=c[x+4>>2];c[l+8>>2]=c[x+8>>2];c[x+0>>2]=0;c[x+4>>2]=0;c[x+8>>2]=0;bn(x);zc[c[(c[p>>2]|0)+28>>2]&127](y,p);if((a[k>>0]&1)==0){c[k+4>>2]=0;a[k>>0]=0}else{c[c[k+8>>2]>>2]=0;c[k+4>>2]=0}u=0;oa(125,k|0,0);d=u;u=0;if(d&1){d=qb(-1,-1,0)|0;jd(d)}c[k+0>>2]=c[y+0>>2];c[k+4>>2]=c[y+4>>2];c[k+8>>2]=c[y+8>>2];c[y+0>>2]=0;c[y+4>>2]=0;c[y+8>>2]=0;bn(y);d=Bc[c[(c[p>>2]|0)+12>>2]&255](p)|0;c[f>>2]=d;d=Bc[c[(c[p>>2]|0)+16>>2]&255](p)|0;c[g>>2]=d;zc[c[(c[p>>2]|0)+20>>2]&127](o,p);if((a[h>>0]&1)==0){a[h+1>>0]=0;a[h>>0]=0}else{a[c[h+8>>2]>>0]=0;c[h+4>>2]=0}u=0;oa(123,h|0,0);d=u;u=0;if(d&1){d=qb(-1,-1,0)|0;jd(d)}c[h+0>>2]=c[o+0>>2];c[h+4>>2]=c[o+4>>2];c[h+8>>2]=c[o+8>>2];c[o+0>>2]=0;c[o+4>>2]=0;c[o+8>>2]=0;Rm(o);zc[c[(c[p>>2]|0)+24>>2]&127](v,p);if((a[j>>0]&1)==0){c[j+4>>2]=0;a[j>>0]=0}else{c[c[j+8>>2]>>2]=0;c[j+4>>2]=0}u=0;oa(125,j|0,0);d=u;u=0;if(d&1){d=qb(-1,-1,0)|0;jd(d)}c[j+0>>2]=c[v+0>>2];c[j+4>>2]=c[v+4>>2];c[j+8>>2]=c[v+8>>2];c[v+0>>2]=0;c[v+4>>2]=0;c[v+8>>2]=0;bn(v);d=Bc[c[(c[p>>2]|0)+36>>2]&255](p)|0;c[m>>2]=d;i=n;return}else{o=c[d>>2]|0;if(!((c[3964]|0)==-1)){c[z>>2]=15856;c[z+4>>2]=205;c[z+8>>2]=0;Lm(15856,z,206)}v=(c[15860>>2]|0)+ -1|0;w=c[o+8>>2]|0;if(!((c[o+12>>2]|0)-w>>2>>>0>v>>>0)){d=Jb(4)|0;bv(d);qc(d|0,24312,171)}o=c[w+(v<<2)>>2]|0;if((o|0)==0){d=Jb(4)|0;bv(d);qc(d|0,24312,171)}zc[c[(c[o>>2]|0)+44>>2]&127](r,o);d=c[r>>2]|0;a[e>>0]=d;a[e+1>>0]=d>>8;a[e+2>>0]=d>>16;a[e+3>>0]=d>>24;zc[c[(c[o>>2]|0)+32>>2]&127](q,o);if((a[l>>0]&1)==0){c[l+4>>2]=0;a[l>>0]=0}else{c[c[l+8>>2]>>2]=0;c[l+4>>2]=0}u=0;oa(125,l|0,0);d=u;u=0;if(d&1){d=qb(-1,-1,0)|0;jd(d)}c[l+0>>2]=c[q+0>>2];c[l+4>>2]=c[q+4>>2];c[l+8>>2]=c[q+8>>2];c[q+0>>2]=0;c[q+4>>2]=0;c[q+8>>2]=0;bn(q);zc[c[(c[o>>2]|0)+28>>2]&127](t,o);if((a[k>>0]&1)==0){c[k+4>>2]=0;a[k>>0]=0}else{c[c[k+8>>2]>>2]=0;c[k+4>>2]=0}u=0;oa(125,k|0,0);d=u;u=0;if(d&1){d=qb(-1,-1,0)|0;jd(d)}c[k+0>>2]=c[t+0>>2];c[k+4>>2]=c[t+4>>2];c[k+8>>2]=c[t+8>>2];c[t+0>>2]=0;c[t+4>>2]=0;c[t+8>>2]=0;bn(t);d=Bc[c[(c[o>>2]|0)+12>>2]&255](o)|0;c[f>>2]=d;d=Bc[c[(c[o>>2]|0)+16>>2]&255](o)|0;c[g>>2]=d;zc[c[(c[o>>2]|0)+20>>2]&127](p,o);if((a[h>>0]&1)==0){a[h+1>>0]=0;a[h>>0]=0}else{a[c[h+8>>2]>>0]=0;c[h+4>>2]=0}u=0;oa(123,h|0,0);d=u;u=0;if(d&1){d=qb(-1,-1,0)|0;jd(d)}c[h+0>>2]=c[p+0>>2];c[h+4>>2]=c[p+4>>2];c[h+8>>2]=c[p+8>>2];c[p+0>>2]=0;c[p+4>>2]=0;c[p+8>>2]=0;Rm(p);zc[c[(c[o>>2]|0)+24>>2]&127](s,o);if((a[j>>0]&1)==0){c[j+4>>2]=0;a[j>>0]=0}else{c[c[j+8>>2]>>2]=0;c[j+4>>2]=0}u=0;oa(125,j|0,0);d=u;u=0;if(d&1){d=qb(-1,-1,0)|0;jd(d)}c[j+0>>2]=c[s+0>>2];c[j+4>>2]=c[s+4>>2];c[j+8>>2]=c[s+8>>2];c[s+0>>2]=0;c[s+4>>2]=0;c[s+8>>2]=0;bn(s);d=Bc[c[(c[o>>2]|0)+36>>2]&255](o)|0;c[m>>2]=d;i=n;return}}function Xr(a){a=a|0;var b=0;b=i;Hv(a);i=b;return}function Yr(a){a=a|0;return}function Zr(b,d,e,f,g,j,l){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;j=j|0;l=+l;var m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0;s=i;i=i+384|0;x=s;E=s+280|0;H=s+72|0;D=s+180|0;o=s+68|0;w=s+64|0;t=s+177|0;B=s+176|0;m=s+52|0;d=s+40|0;p=s+28|0;G=s+24|0;C=s+76|0;z=s+20|0;y=s+16|0;A=s+12|0;c[H>>2]=E;h[k>>3]=l;c[x>>2]=c[k>>2];c[x+4>>2]=c[k+4>>2];E=bw(E,100,16104,x)|0;a:do{if(E>>>0>99){do{if((a[16248]|0)==0?(Ua(16248)|0)!=0:0){u=0;n=ua(33,2147483647,16256,0)|0;K=u;u=0;if(K&1){F=qb(-1,-1)|0;Eb(16248);v=0;r=0;n=12;break a}else{c[4060]=n;rb(16248);break}}}while(0);E=c[4060]|0;u=0;h[k>>3]=l;c[x>>2]=c[k>>2];c[x+4>>2]=c[k+4>>2];E=Ma(16,H|0,E|0,16104,x|0)|0;K=u;u=0;if(!(K&1)){v=c[H>>2]|0;if((v|0)==0){u=0;Oa(4);K=u;u=0;if(K&1){v=0;r=0;n=11;break}v=c[H>>2]|0}n=Av(E)|0;if((n|0)==0){u=0;Oa(4);K=u;u=0;if(K&1){r=0;n=11}else{r=0;D=0;n=15}}else{r=n;D=n;n=15}}else{v=0;r=0;n=11}}else{r=0;v=0;n=15}}while(0);if((n|0)==15){u=0;oa(84,o|0,g|0);K=u;u=0;if(K&1){n=11}else{K=c[o>>2]|0;if(!((c[4088]|0)==-1)?(c[x>>2]=16352,c[x+4>>2]=205,c[x+8>>2]=0,u=0,Na(58,16352,x|0,206),J=u,u=0,J&1):0){n=45}else{n=18}do{if((n|0)==18){J=(c[16356>>2]|0)+ -1|0;I=c[K+8>>2]|0;if((c[K+12>>2]|0)-I>>2>>>0>J>>>0?(q=c[I+(J<<2)>>2]|0,(q|0)!=0):0){K=c[H>>2]|0;u=0;Ma(c[(c[q>>2]|0)+32>>2]|0,q|0,K|0,K+E|0,D|0)|0;K=u;u=0;if(K&1){n=45;break}if((E|0)==0){F=0}else{F=(a[c[H>>2]>>0]|0)==45}c[w>>2]=0;c[m+0>>2]=0;c[m+4>>2]=0;c[m+8>>2]=0;c[d+0>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[p+0>>2]=0;c[p+4>>2]=0;c[p+8>>2]=0;u=0;Ga(3,f|0,F|0,o|0,w|0,t|0,B|0,m|0,d|0,p|0,G|0);K=u;u=0;do{if(!(K&1)){f=c[G>>2]|0;if((E|0)>(f|0)){G=a[p>>0]|0;if((G&1)==0){G=(G&255)>>>1}else{G=c[p+4>>2]|0}H=a[d>>0]|0;if((H&1)==0){H=(H&255)>>>1}else{H=c[d+4>>2]|0}G=G+(E-f<<1|1)+H|0}else{G=a[p>>0]|0;if((G&1)==0){G=(G&255)>>>1}else{G=c[p+4>>2]|0}H=a[d>>0]|0;if((H&1)==0){H=(H&255)>>>1}else{H=c[d+4>>2]|0}G=G+2+H|0}G=G+f|0;if(G>>>0>100){C=Av(G)|0;if((C|0)==0){u=0;Oa(4);K=u;u=0;if(K&1){F=qb(-1,-1)|0;break}else{G=0;C=0}}else{G=C}}else{G=0}u=0;va(1,C|0,z|0,y|0,c[g+4>>2]|0,D|0,D+E|0,q|0,F|0,w|0,a[t>>0]|0,a[B>>0]|0,m|0,d|0,p|0,f|0);K=u;u=0;if(!(K&1)){c[A>>2]=c[e>>2];J=c[z>>2]|0;K=c[y>>2]|0;u=0;c[x+0>>2]=c[A+0>>2];Da(39,b|0,x|0,C|0,J|0,K|0,g|0,j|0);K=u;u=0;if(!(K&1)){if((G|0)!=0){Bv(G)}Rm(p);Rm(d);Rm(m);qm(c[o>>2]|0)|0;if((r|0)!=0){Bv(r)}if((v|0)==0){i=s;return}Bv(v);i=s;return}}F=qb(-1,-1)|0;if((G|0)!=0){Bv(G)}}else{F=qb(-1,-1)|0}}while(0);Rm(p);Rm(d);Rm(m);break}K=Jb(4)|0;bv(K);u=0;Na(45,K|0,24312,171);K=u;u=0;if(K&1){n=45}}}while(0);if((n|0)==45){F=qb(-1,-1)|0}qm(c[o>>2]|0)|0}}if((n|0)==11){F=qb(-1,-1)|0;n=12}if((r|0)!=0){Bv(r)}if((v|0)==0){vb(F|0)}Bv(v);vb(F|0)}function _r(b,d,e,f,g,h,j,k,l,m){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;l=l|0;m=m|0;var n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0;n=i;i=i+128|0;B=n;z=n+120|0;p=n+108|0;x=n+104|0;y=n+92|0;o=n+80|0;A=n+68|0;r=n+64|0;q=n+52|0;t=n+48|0;s=n+36|0;w=n+24|0;v=n+12|0;e=c[e>>2]|0;if(b){if(!((c[3948]|0)==-1)){c[B>>2]=15792;c[B+4>>2]=205;c[B+8>>2]=0;Lm(15792,B,206)}r=(c[15796>>2]|0)+ -1|0;q=c[e+8>>2]|0;if(!((c[e+12>>2]|0)-q>>2>>>0>r>>>0)){b=Jb(4)|0;bv(b);qc(b|0,24312,171)}q=c[q+(r<<2)>>2]|0;if((q|0)==0){b=Jb(4)|0;bv(b);qc(b|0,24312,171)}r=c[q>>2]|0;do{if(d){zc[c[r+44>>2]&127](z,q);b=c[z>>2]|0;a[f>>0]=b;a[f+1>>0]=b>>8;a[f+2>>0]=b>>16;a[f+3>>0]=b>>24;zc[c[(c[q>>2]|0)+32>>2]&127](p,q);if((a[l>>0]&1)==0){a[l+1>>0]=0;a[l>>0]=0}else{a[c[l+8>>2]>>0]=0;c[l+4>>2]=0}u=0;oa(123,l|0,0);b=u;u=0;if(b&1){b=qb(-1,-1,0)|0;jd(b)}else{c[l+0>>2]=c[p+0>>2];c[l+4>>2]=c[p+4>>2];c[l+8>>2]=c[p+8>>2];c[p+0>>2]=0;c[p+4>>2]=0;c[p+8>>2]=0;Rm(p);break}}else{zc[c[r+40>>2]&127](x,q);b=c[x>>2]|0;a[f>>0]=b;a[f+1>>0]=b>>8;a[f+2>>0]=b>>16;a[f+3>>0]=b>>24;zc[c[(c[q>>2]|0)+28>>2]&127](y,q);if((a[l>>0]&1)==0){a[l+1>>0]=0;a[l>>0]=0}else{a[c[l+8>>2]>>0]=0;c[l+4>>2]=0}u=0;oa(123,l|0,0);b=u;u=0;if(b&1){b=qb(-1,-1,0)|0;jd(b)}else{c[l+0>>2]=c[y+0>>2];c[l+4>>2]=c[y+4>>2];c[l+8>>2]=c[y+8>>2];c[y+0>>2]=0;c[y+4>>2]=0;c[y+8>>2]=0;Rm(y);break}}}while(0);b=Bc[c[(c[q>>2]|0)+12>>2]&255](q)|0;a[g>>0]=b;b=Bc[c[(c[q>>2]|0)+16>>2]&255](q)|0;a[h>>0]=b;zc[c[(c[q>>2]|0)+20>>2]&127](o,q);if((a[j>>0]&1)==0){a[j+1>>0]=0;a[j>>0]=0}else{a[c[j+8>>2]>>0]=0;c[j+4>>2]=0}u=0;oa(123,j|0,0);b=u;u=0;if(b&1){b=qb(-1,-1,0)|0;jd(b)}c[j+0>>2]=c[o+0>>2];c[j+4>>2]=c[o+4>>2];c[j+8>>2]=c[o+8>>2];c[o+0>>2]=0;c[o+4>>2]=0;c[o+8>>2]=0;Rm(o);zc[c[(c[q>>2]|0)+24>>2]&127](A,q);if((a[k>>0]&1)==0){a[k+1>>0]=0;a[k>>0]=0}else{a[c[k+8>>2]>>0]=0;c[k+4>>2]=0}u=0;oa(123,k|0,0);b=u;u=0;if(b&1){b=qb(-1,-1,0)|0;jd(b)}c[k+0>>2]=c[A+0>>2];c[k+4>>2]=c[A+4>>2];c[k+8>>2]=c[A+8>>2];c[A+0>>2]=0;c[A+4>>2]=0;c[A+8>>2]=0;Rm(A);b=Bc[c[(c[q>>2]|0)+36>>2]&255](q)|0;c[m>>2]=b;i=n;return}else{if(!((c[3932]|0)==-1)){c[B>>2]=15728;c[B+4>>2]=205;c[B+8>>2]=0;Lm(15728,B,206)}p=(c[15732>>2]|0)+ -1|0;o=c[e+8>>2]|0;if(!((c[e+12>>2]|0)-o>>2>>>0>p>>>0)){b=Jb(4)|0;bv(b);qc(b|0,24312,171)}o=c[o+(p<<2)>>2]|0;if((o|0)==0){b=Jb(4)|0;bv(b);qc(b|0,24312,171)}p=c[o>>2]|0;do{if(d){zc[c[p+44>>2]&127](r,o);b=c[r>>2]|0;a[f>>0]=b;a[f+1>>0]=b>>8;a[f+2>>0]=b>>16;a[f+3>>0]=b>>24;zc[c[(c[o>>2]|0)+32>>2]&127](q,o);if((a[l>>0]&1)==0){a[l+1>>0]=0;a[l>>0]=0}else{a[c[l+8>>2]>>0]=0;c[l+4>>2]=0}u=0;oa(123,l|0,0);b=u;u=0;if(b&1){b=qb(-1,-1,0)|0;jd(b)}else{c[l+0>>2]=c[q+0>>2];c[l+4>>2]=c[q+4>>2];c[l+8>>2]=c[q+8>>2];c[q+0>>2]=0;c[q+4>>2]=0;c[q+8>>2]=0;Rm(q);break}}else{zc[c[p+40>>2]&127](t,o);b=c[t>>2]|0;a[f>>0]=b;a[f+1>>0]=b>>8;a[f+2>>0]=b>>16;a[f+3>>0]=b>>24;zc[c[(c[o>>2]|0)+28>>2]&127](s,o);if((a[l>>0]&1)==0){a[l+1>>0]=0;a[l>>0]=0}else{a[c[l+8>>2]>>0]=0;c[l+4>>2]=0}u=0;oa(123,l|0,0);b=u;u=0;if(b&1){b=qb(-1,-1,0)|0;jd(b)}else{c[l+0>>2]=c[s+0>>2];c[l+4>>2]=c[s+4>>2];c[l+8>>2]=c[s+8>>2];c[s+0>>2]=0;c[s+4>>2]=0;c[s+8>>2]=0;Rm(s);break}}}while(0);b=Bc[c[(c[o>>2]|0)+12>>2]&255](o)|0;a[g>>0]=b;b=Bc[c[(c[o>>2]|0)+16>>2]&255](o)|0;a[h>>0]=b;zc[c[(c[o>>2]|0)+20>>2]&127](w,o);if((a[j>>0]&1)==0){a[j+1>>0]=0;a[j>>0]=0}else{a[c[j+8>>2]>>0]=0;c[j+4>>2]=0}u=0;oa(123,j|0,0);b=u;u=0;if(b&1){b=qb(-1,-1,0)|0;jd(b)}c[j+0>>2]=c[w+0>>2];c[j+4>>2]=c[w+4>>2];c[j+8>>2]=c[w+8>>2];c[w+0>>2]=0;c[w+4>>2]=0;c[w+8>>2]=0;Rm(w);zc[c[(c[o>>2]|0)+24>>2]&127](v,o);if((a[k>>0]&1)==0){a[k+1>>0]=0;a[k>>0]=0}else{a[c[k+8>>2]>>0]=0;c[k+4>>2]=0}u=0;oa(123,k|0,0);b=u;u=0;if(b&1){b=qb(-1,-1,0)|0;jd(b)}c[k+0>>2]=c[v+0>>2];c[k+4>>2]=c[v+4>>2];c[k+8>>2]=c[v+8>>2];c[v+0>>2]=0;c[v+4>>2]=0;c[v+8>>2]=0;Rm(v);b=Bc[c[(c[o>>2]|0)+36>>2]&255](o)|0;c[m>>2]=b;i=n;return}}function $r(d,e,f,g,h,j,k,l,m,n,o,p,q,r,s){d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;l=l|0;m=m|0;n=n|0;o=o|0;p=p|0;q=q|0;r=r|0;s=s|0;var t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0;t=i;c[f>>2]=d;v=r+1|0;w=r+8|0;u=r+4|0;B=(g&512|0)==0;y=q+1|0;z=q+8|0;A=q+4|0;D=(s|0)>0;F=p+1|0;I=p+8|0;x=p+4|0;E=k+8|0;C=0-s|0;J=0;do{switch(a[m+J>>0]|0){case 4:{K=c[f>>2]|0;h=l?h+1|0:h;a:do{if(h>>>0<j>>>0){L=h;while(1){M=a[L>>0]|0;if(!(M<<24>>24>-1)){break a}N=L+1|0;if((b[(c[E>>2]|0)+(M<<24>>24<<1)>>1]&2048)==0){break a}if(N>>>0<j>>>0){L=N}else{L=N;break}}}else{L=h}}while(0);M=L;if(D){if(L>>>0>h>>>0){N=h+(0-M)|0;N=N>>>0<C>>>0?C:N;M=N+s|0;P=K;Q=L;O=s;while(1){Q=Q+ -1|0;R=a[Q>>0]|0;c[f>>2]=P+1;a[P>>0]=R;O=O+ -1|0;P=(O|0)>0;if(!(Q>>>0>h>>>0&P)){break}P=c[f>>2]|0}L=L+N|0;if(P){G=32}else{N=0}}else{M=s;G=32}if((G|0)==32){G=0;N=Sc[c[(c[k>>2]|0)+28>>2]&63](k,48)|0}O=c[f>>2]|0;c[f>>2]=O+1;if((M|0)>0){do{a[O>>0]=N;M=M+ -1|0;O=c[f>>2]|0;c[f>>2]=O+1}while((M|0)>0)}a[O>>0]=n}if((L|0)==(h|0)){Q=Sc[c[(c[k>>2]|0)+28>>2]&63](k,48)|0;R=c[f>>2]|0;c[f>>2]=R+1;a[R>>0]=Q}else{N=a[p>>0]|0;M=(N&1)==0;if(M){N=(N&255)>>>1}else{N=c[x>>2]|0}if((N|0)==0){M=-1;N=0;O=0}else{if(M){M=F}else{M=c[I>>2]|0}M=a[M>>0]|0;N=0;O=0}while(1){if((O|0)==(M|0)){P=c[f>>2]|0;c[f>>2]=P+1;a[P>>0]=o;N=N+1|0;P=a[p>>0]|0;O=(P&1)==0;if(O){P=(P&255)>>>1}else{P=c[x>>2]|0}if(N>>>0<P>>>0){if(O){M=F}else{M=c[I>>2]|0}if((a[M+N>>0]|0)==127){M=-1;O=0}else{if(O){M=F}else{M=c[I>>2]|0}M=a[M+N>>0]|0;O=0}}else{O=0}}L=L+ -1|0;Q=a[L>>0]|0;R=c[f>>2]|0;c[f>>2]=R+1;a[R>>0]=Q;if((L|0)==(h|0)){break}else{O=O+1|0}}}L=c[f>>2]|0;if((K|0)!=(L|0)?(H=L+ -1|0,H>>>0>K>>>0):0){L=H;do{R=a[K>>0]|0;a[K>>0]=a[L>>0]|0;a[L>>0]=R;K=K+1|0;L=L+ -1|0}while(K>>>0<L>>>0)}break};case 3:{L=a[r>>0]|0;K=(L&1)==0;if(K){L=(L&255)>>>1}else{L=c[u>>2]|0}if((L|0)!=0){if(K){K=v}else{K=c[w>>2]|0}Q=a[K>>0]|0;R=c[f>>2]|0;c[f>>2]=R+1;a[R>>0]=Q}break};case 0:{c[e>>2]=c[f>>2];break};case 1:{c[e>>2]=c[f>>2];Q=Sc[c[(c[k>>2]|0)+28>>2]&63](k,32)|0;R=c[f>>2]|0;c[f>>2]=R+1;a[R>>0]=Q;break};case 2:{K=a[q>>0]|0;L=(K&1)==0;if(L){M=(K&255)>>>1}else{M=c[A>>2]|0}if(!((M|0)==0|B)){if(L){L=y;M=(K&255)>>>1;K=y}else{K=c[z>>2]|0;L=K;M=c[A>>2]|0}L=L+M|0;M=c[f>>2]|0;if((K|0)!=(L|0)){do{a[M>>0]=a[K>>0]|0;K=K+1|0;M=M+1|0}while((K|0)!=(L|0))}c[f>>2]=M}break};default:{}}J=J+1|0}while((J|0)!=4);o=a[r>>0]|0;y=(o&1)==0;if(y){x=(o&255)>>>1}else{x=c[u>>2]|0}if(x>>>0>1){if(y){w=v;o=(o&255)>>>1}else{v=c[w>>2]|0;w=v;o=c[u>>2]|0}u=w+1|0;v=v+o|0;w=c[f>>2]|0;if((u|0)!=(v|0)){do{a[w>>0]=a[u>>0]|0;u=u+1|0;w=w+1|0}while((u|0)!=(v|0))}c[f>>2]=w}g=g&176;if((g|0)==32){c[e>>2]=c[f>>2];i=t;return}else if((g|0)==16){i=t;return}else{c[e>>2]=d;i=t;return}}function as(b,d,e,f,g,h,j){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0;o=i;i=i+176|0;w=o;k=o+68|0;r=o+64|0;s=o+173|0;t=o+172|0;m=o+52|0;d=o+40|0;l=o+28|0;z=o+24|0;x=o+72|0;p=o+20|0;q=o+16|0;v=o+12|0;ln(k,g);y=c[k>>2]|0;if(!(!((c[4088]|0)==-1)?(c[w>>2]=16352,c[w+4>>2]=205,c[w+8>>2]=0,u=0,Na(58,16352,w|0,206),C=u,u=0,C&1):0)){A=3}do{if((A|0)==3){B=(c[16356>>2]|0)+ -1|0;A=c[y+8>>2]|0;if((c[y+12>>2]|0)-A>>2>>>0>B>>>0?(n=c[A+(B<<2)>>2]|0,(n|0)!=0):0){A=a[j>>0]|0;y=(A&1)==0;if(y){A=(A&255)>>>1}else{A=c[j+4>>2]|0}if((A|0)==0){y=0}else{if(y){y=j+1|0}else{y=c[j+8>>2]|0}y=a[y>>0]|0;u=0;A=Ha(c[(c[n>>2]|0)+28>>2]|0,n|0,45)|0;C=u;u=0;if(C&1){break}y=y<<24>>24==A<<24>>24}c[r>>2]=0;c[m+0>>2]=0;c[m+4>>2]=0;c[m+8>>2]=0;c[d+0>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[l+0>>2]=0;c[l+4>>2]=0;c[l+8>>2]=0;u=0;Ga(3,f|0,y|0,k|0,r|0,s|0,t|0,m|0,d|0,l|0,z|0);C=u;u=0;a:do{if(!(C&1)){f=a[j>>0]|0;A=(f&1)==0;if(A){B=(f&255)>>>1}else{B=c[j+4>>2]|0}z=c[z>>2]|0;if((B|0)>(z|0)){if(A){A=(f&255)>>>1}else{A=c[j+4>>2]|0}B=a[l>>0]|0;if((B&1)==0){B=(B&255)>>>1}else{B=c[l+4>>2]|0}C=a[d>>0]|0;if((C&1)==0){C=(C&255)>>>1}else{C=c[d+4>>2]|0}A=B+(A-z<<1|1)+C|0}else{A=a[l>>0]|0;if((A&1)==0){A=(A&255)>>>1}else{A=c[l+4>>2]|0}B=a[d>>0]|0;if((B&1)==0){B=(B&255)>>>1}else{B=c[d+4>>2]|0}A=A+2+B|0}A=A+z|0;do{if(A>>>0>100){x=Av(A)|0;if((x|0)==0){u=0;Oa(4);C=u;u=0;if(C&1){g=qb(-1,-1)|0;break a}else{A=0;f=a[j>>0]|0;x=0;break}}else{A=x}}else{A=0}}while(0);if((f&1)==0){B=j+1|0;j=(f&255)>>>1}else{B=c[j+8>>2]|0;j=c[j+4>>2]|0}u=0;va(1,x|0,p|0,q|0,c[g+4>>2]|0,B|0,B+j|0,n|0,y|0,r|0,a[s>>0]|0,a[t>>0]|0,m|0,d|0,l|0,z|0);C=u;u=0;if(!(C&1)){c[v>>2]=c[e>>2];B=c[p>>2]|0;C=c[q>>2]|0;u=0;c[w+0>>2]=c[v+0>>2];Da(39,b|0,w|0,x|0,B|0,C|0,g|0,h|0);C=u;u=0;if(!(C&1)){if((A|0)==0){Rm(l);Rm(d);Rm(m);C=c[k>>2]|0;qm(C)|0;i=o;return}Bv(A);Rm(l);Rm(d);Rm(m);C=c[k>>2]|0;qm(C)|0;i=o;return}}g=qb(-1,-1)|0;if((A|0)!=0){Bv(A)}}else{g=qb(-1,-1)|0}}while(0);Rm(l);Rm(d);Rm(m);C=g;B=c[k>>2]|0;qm(B)|0;vb(C|0)}C=Jb(4)|0;bv(C);u=0;Na(45,C|0,24312,171);C=u;u=0}}while(0);C=qb(-1,-1)|0;B=c[k>>2]|0;qm(B)|0;vb(C|0)}function bs(a){a=a|0;var b=0;b=i;Hv(a);i=b;return}function cs(a){a=a|0;return}function ds(b,d,e,f,g,j,l){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;j=j|0;l=+l;var m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0;s=i;i=i+992|0;x=s;E=s+884|0;H=s+880|0;D=s+480|0;o=s+476|0;w=s+472|0;t=s+468|0;B=s+464|0;m=s+452|0;d=s+440|0;p=s+428|0;G=s+424|0;C=s+24|0;z=s+20|0;y=s+16|0;A=s+12|0;c[H>>2]=E;h[k>>3]=l;c[x>>2]=c[k>>2];c[x+4>>2]=c[k+4>>2];E=bw(E,100,16104,x)|0;a:do{if(E>>>0>99){do{if((a[16248]|0)==0?(Ua(16248)|0)!=0:0){u=0;n=ua(33,2147483647,16256,0)|0;K=u;u=0;if(K&1){F=qb(-1,-1)|0;Eb(16248);v=0;r=0;n=12;break a}else{c[4060]=n;rb(16248);break}}}while(0);E=c[4060]|0;u=0;h[k>>3]=l;c[x>>2]=c[k>>2];c[x+4>>2]=c[k+4>>2];E=Ma(16,H|0,E|0,16104,x|0)|0;K=u;u=0;if(!(K&1)){v=c[H>>2]|0;if((v|0)==0){u=0;Oa(4);K=u;u=0;if(K&1){v=0;r=0;n=11;break}v=c[H>>2]|0}n=Av(E<<2)|0;if((n|0)==0){u=0;Oa(4);K=u;u=0;if(K&1){r=0;n=11}else{r=0;D=0;n=15}}else{r=n;D=n;n=15}}else{v=0;r=0;n=11}}else{r=0;v=0;n=15}}while(0);if((n|0)==15){u=0;oa(84,o|0,g|0);K=u;u=0;if(K&1){n=11}else{K=c[o>>2]|0;if(!((c[4086]|0)==-1)?(c[x>>2]=16344,c[x+4>>2]=205,c[x+8>>2]=0,u=0,Na(58,16344,x|0,206),J=u,u=0,J&1):0){n=45}else{n=18}do{if((n|0)==18){J=(c[16348>>2]|0)+ -1|0;I=c[K+8>>2]|0;if((c[K+12>>2]|0)-I>>2>>>0>J>>>0?(q=c[I+(J<<2)>>2]|0,(q|0)!=0):0){K=c[H>>2]|0;u=0;Ma(c[(c[q>>2]|0)+48>>2]|0,q|0,K|0,K+E|0,D|0)|0;K=u;u=0;if(K&1){n=45;break}if((E|0)==0){F=0}else{F=(a[c[H>>2]>>0]|0)==45}c[w>>2]=0;c[m+0>>2]=0;c[m+4>>2]=0;c[m+8>>2]=0;c[d+0>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[p+0>>2]=0;c[p+4>>2]=0;c[p+8>>2]=0;u=0;Ga(4,f|0,F|0,o|0,w|0,t|0,B|0,m|0,d|0,p|0,G|0);K=u;u=0;do{if(!(K&1)){f=c[G>>2]|0;if((E|0)>(f|0)){G=a[p>>0]|0;if((G&1)==0){G=(G&255)>>>1}else{G=c[p+4>>2]|0}H=a[d>>0]|0;if((H&1)==0){H=(H&255)>>>1}else{H=c[d+4>>2]|0}G=G+(E-f<<1|1)+H|0}else{G=a[p>>0]|0;if((G&1)==0){G=(G&255)>>>1}else{G=c[p+4>>2]|0}H=a[d>>0]|0;if((H&1)==0){H=(H&255)>>>1}else{H=c[d+4>>2]|0}G=G+2+H|0}G=G+f|0;if(G>>>0>100){C=Av(G<<2)|0;if((C|0)==0){u=0;Oa(4);K=u;u=0;if(K&1){F=qb(-1,-1)|0;break}else{G=0;C=0}}else{G=C}}else{G=0}u=0;va(2,C|0,z|0,y|0,c[g+4>>2]|0,D|0,D+(E<<2)|0,q|0,F|0,w|0,c[t>>2]|0,c[B>>2]|0,m|0,d|0,p|0,f|0);K=u;u=0;if(!(K&1)){c[A>>2]=c[e>>2];J=c[z>>2]|0;K=c[y>>2]|0;u=0;c[x+0>>2]=c[A+0>>2];Da(45,b|0,x|0,C|0,J|0,K|0,g|0,j|0);K=u;u=0;if(!(K&1)){if((G|0)!=0){Bv(G)}bn(p);bn(d);Rm(m);qm(c[o>>2]|0)|0;if((r|0)!=0){Bv(r)}if((v|0)==0){i=s;return}Bv(v);i=s;return}}F=qb(-1,-1)|0;if((G|0)!=0){Bv(G)}}else{F=qb(-1,-1)|0}}while(0);bn(p);bn(d);Rm(m);break}K=Jb(4)|0;bv(K);u=0;Na(45,K|0,24312,171);K=u;u=0;if(K&1){n=45}}}while(0);if((n|0)==45){F=qb(-1,-1)|0}qm(c[o>>2]|0)|0}}if((n|0)==11){F=qb(-1,-1)|0;n=12}if((r|0)!=0){Bv(r)}if((v|0)==0){vb(F|0)}Bv(v);vb(F|0)}function es(b,d,e,f,g,h,j,k,l,m){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;l=l|0;m=m|0;var n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0;n=i;i=i+128|0;B=n;z=n+120|0;p=n+108|0;x=n+104|0;y=n+92|0;o=n+80|0;A=n+68|0;r=n+64|0;q=n+52|0;t=n+48|0;s=n+36|0;w=n+24|0;v=n+12|0;e=c[e>>2]|0;if(b){if(!((c[3980]|0)==-1)){c[B>>2]=15920;c[B+4>>2]=205;c[B+8>>2]=0;Lm(15920,B,206)}r=(c[15924>>2]|0)+ -1|0;q=c[e+8>>2]|0;if(!((c[e+12>>2]|0)-q>>2>>>0>r>>>0)){b=Jb(4)|0;bv(b);qc(b|0,24312,171)}q=c[q+(r<<2)>>2]|0;if((q|0)==0){b=Jb(4)|0;bv(b);qc(b|0,24312,171)}r=c[q>>2]|0;do{if(d){zc[c[r+44>>2]&127](z,q);b=c[z>>2]|0;a[f>>0]=b;a[f+1>>0]=b>>8;a[f+2>>0]=b>>16;a[f+3>>0]=b>>24;zc[c[(c[q>>2]|0)+32>>2]&127](p,q);if((a[l>>0]&1)==0){c[l+4>>2]=0;a[l>>0]=0}else{c[c[l+8>>2]>>2]=0;c[l+4>>2]=0}u=0;oa(125,l|0,0);b=u;u=0;if(b&1){b=qb(-1,-1,0)|0;jd(b)}else{c[l+0>>2]=c[p+0>>2];c[l+4>>2]=c[p+4>>2];c[l+8>>2]=c[p+8>>2];c[p+0>>2]=0;c[p+4>>2]=0;c[p+8>>2]=0;bn(p);break}}else{zc[c[r+40>>2]&127](x,q);b=c[x>>2]|0;a[f>>0]=b;a[f+1>>0]=b>>8;a[f+2>>0]=b>>16;a[f+3>>0]=b>>24;zc[c[(c[q>>2]|0)+28>>2]&127](y,q);if((a[l>>0]&1)==0){c[l+4>>2]=0;a[l>>0]=0}else{c[c[l+8>>2]>>2]=0;c[l+4>>2]=0}u=0;oa(125,l|0,0);b=u;u=0;if(b&1){b=qb(-1,-1,0)|0;jd(b)}else{c[l+0>>2]=c[y+0>>2];c[l+4>>2]=c[y+4>>2];c[l+8>>2]=c[y+8>>2];c[y+0>>2]=0;c[y+4>>2]=0;c[y+8>>2]=0;bn(y);break}}}while(0);b=Bc[c[(c[q>>2]|0)+12>>2]&255](q)|0;c[g>>2]=b;b=Bc[c[(c[q>>2]|0)+16>>2]&255](q)|0;c[h>>2]=b;zc[c[(c[q>>2]|0)+20>>2]&127](o,q);if((a[j>>0]&1)==0){a[j+1>>0]=0;a[j>>0]=0}else{a[c[j+8>>2]>>0]=0;c[j+4>>2]=0}u=0;oa(123,j|0,0);b=u;u=0;if(b&1){b=qb(-1,-1,0)|0;jd(b)}c[j+0>>2]=c[o+0>>2];c[j+4>>2]=c[o+4>>2];c[j+8>>2]=c[o+8>>2];c[o+0>>2]=0;c[o+4>>2]=0;c[o+8>>2]=0;Rm(o);zc[c[(c[q>>2]|0)+24>>2]&127](A,q);if((a[k>>0]&1)==0){c[k+4>>2]=0;a[k>>0]=0}else{c[c[k+8>>2]>>2]=0;c[k+4>>2]=0}u=0;oa(125,k|0,0);b=u;u=0;if(b&1){b=qb(-1,-1,0)|0;jd(b)}c[k+0>>2]=c[A+0>>2];c[k+4>>2]=c[A+4>>2];c[k+8>>2]=c[A+8>>2];c[A+0>>2]=0;c[A+4>>2]=0;c[A+8>>2]=0;bn(A);b=Bc[c[(c[q>>2]|0)+36>>2]&255](q)|0;c[m>>2]=b;i=n;return}else{if(!((c[3964]|0)==-1)){c[B>>2]=15856;c[B+4>>2]=205;c[B+8>>2]=0;Lm(15856,B,206)}p=(c[15860>>2]|0)+ -1|0;o=c[e+8>>2]|0;if(!((c[e+12>>2]|0)-o>>2>>>0>p>>>0)){b=Jb(4)|0;bv(b);qc(b|0,24312,171)}o=c[o+(p<<2)>>2]|0;if((o|0)==0){b=Jb(4)|0;bv(b);qc(b|0,24312,171)}p=c[o>>2]|0;do{if(d){zc[c[p+44>>2]&127](r,o);b=c[r>>2]|0;a[f>>0]=b;a[f+1>>0]=b>>8;a[f+2>>0]=b>>16;a[f+3>>0]=b>>24;zc[c[(c[o>>2]|0)+32>>2]&127](q,o);if((a[l>>0]&1)==0){c[l+4>>2]=0;a[l>>0]=0}else{c[c[l+8>>2]>>2]=0;c[l+4>>2]=0}u=0;oa(125,l|0,0);b=u;u=0;if(b&1){b=qb(-1,-1,0)|0;jd(b)}else{c[l+0>>2]=c[q+0>>2];c[l+4>>2]=c[q+4>>2];c[l+8>>2]=c[q+8>>2];c[q+0>>2]=0;c[q+4>>2]=0;c[q+8>>2]=0;bn(q);break}}else{zc[c[p+40>>2]&127](t,o);b=c[t>>2]|0;a[f>>0]=b;a[f+1>>0]=b>>8;a[f+2>>0]=b>>16;a[f+3>>0]=b>>24;zc[c[(c[o>>2]|0)+28>>2]&127](s,o);if((a[l>>0]&1)==0){c[l+4>>2]=0;a[l>>0]=0}else{c[c[l+8>>2]>>2]=0;c[l+4>>2]=0}u=0;oa(125,l|0,0);b=u;u=0;if(b&1){b=qb(-1,-1,0)|0;jd(b)}else{c[l+0>>2]=c[s+0>>2];c[l+4>>2]=c[s+4>>2];c[l+8>>2]=c[s+8>>2];c[s+0>>2]=0;c[s+4>>2]=0;c[s+8>>2]=0;bn(s);break}}}while(0);b=Bc[c[(c[o>>2]|0)+12>>2]&255](o)|0;c[g>>2]=b;b=Bc[c[(c[o>>2]|0)+16>>2]&255](o)|0;c[h>>2]=b;zc[c[(c[o>>2]|0)+20>>2]&127](w,o);if((a[j>>0]&1)==0){a[j+1>>0]=0;a[j>>0]=0}else{a[c[j+8>>2]>>0]=0;c[j+4>>2]=0}u=0;oa(123,j|0,0);b=u;u=0;if(b&1){b=qb(-1,-1,0)|0;jd(b)}c[j+0>>2]=c[w+0>>2];c[j+4>>2]=c[w+4>>2];c[j+8>>2]=c[w+8>>2];c[w+0>>2]=0;c[w+4>>2]=0;c[w+8>>2]=0;Rm(w);zc[c[(c[o>>2]|0)+24>>2]&127](v,o);if((a[k>>0]&1)==0){c[k+4>>2]=0;a[k>>0]=0}else{c[c[k+8>>2]>>2]=0;c[k+4>>2]=0}u=0;oa(125,k|0,0);b=u;u=0;if(b&1){b=qb(-1,-1,0)|0;jd(b)}c[k+0>>2]=c[v+0>>2];c[k+4>>2]=c[v+4>>2];c[k+8>>2]=c[v+8>>2];c[v+0>>2]=0;c[v+4>>2]=0;c[v+8>>2]=0;bn(v);b=Bc[c[(c[o>>2]|0)+36>>2]&255](o)|0;c[m>>2]=b;i=n;return}}function fs(b,d,e,f,g,h,j,k,l,m,n,o,p,q,r){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;l=l|0;m=m|0;n=n|0;o=o|0;p=p|0;q=q|0;r=r|0;var s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0;s=i;c[e>>2]=b;t=q+4|0;u=q+8|0;C=(f&512|0)==0;y=p+4|0;B=p+8|0;x=(r|0)>0;A=o+1|0;v=o+8|0;w=o+4|0;E=0;do{switch(a[l+E>>0]|0){case 4:{F=c[e>>2]|0;g=k?g+4|0:g;a:do{if(g>>>0<h>>>0){G=g;while(1){H=G+4|0;if(!(Fc[c[(c[j>>2]|0)+12>>2]&63](j,2048,c[G>>2]|0)|0)){break a}if(H>>>0<h>>>0){G=H}else{G=H;break}}}else{G=g}}while(0);if(x){if(G>>>0>g>>>0){H=c[e>>2]|0;K=r;do{G=G+ -4|0;I=H;H=H+4|0;c[I>>2]=c[G>>2];K=K+ -1|0;I=(K|0)>0}while(G>>>0>g>>>0&I);c[e>>2]=H;if(I){z=34}else{J=c[e>>2]|0;c[e>>2]=J+4}}else{K=r;z=34}if((z|0)==34){z=0;I=Sc[c[(c[j>>2]|0)+44>>2]&63](j,48)|0;J=c[e>>2]|0;M=J+4|0;c[e>>2]=M;if((K|0)>0){H=J;L=K;while(1){c[H>>2]=I;L=L+ -1|0;if((L|0)<=0){break}else{H=M;M=M+4|0}}c[e>>2]=J+(K+1<<2);J=J+(K<<2)|0}}c[J>>2]=m}if((G|0)==(g|0)){K=Sc[c[(c[j>>2]|0)+44>>2]&63](j,48)|0;M=c[e>>2]|0;L=M+4|0;c[e>>2]=L;c[M>>2]=K}else{I=a[o>>0]|0;H=(I&1)==0;if(H){I=(I&255)>>>1}else{I=c[w>>2]|0}if((I|0)==0){H=-1;I=0;K=0}else{if(H){H=A}else{H=c[v>>2]|0}H=a[H>>0]|0;I=0;K=0}while(1){J=c[e>>2]|0;if((K|0)==(H|0)){K=J+4|0;c[e>>2]=K;c[J>>2]=n;I=I+1|0;L=a[o>>0]|0;J=(L&1)==0;if(J){L=(L&255)>>>1}else{L=c[w>>2]|0}if(I>>>0<L>>>0){if(J){H=A}else{H=c[v>>2]|0}if((a[H+I>>0]|0)==127){J=K;H=-1;K=0}else{if(J){H=A}else{H=c[v>>2]|0}J=K;H=a[H+I>>0]|0;K=0}}else{J=K;K=0}}G=G+ -4|0;M=c[G>>2]|0;L=J+4|0;c[e>>2]=L;c[J>>2]=M;if((G|0)==(g|0)){break}else{K=K+1|0}}}if((F|0)!=(L|0)?(D=L+ -4|0,D>>>0>F>>>0):0){G=D;do{M=c[F>>2]|0;c[F>>2]=c[G>>2];c[G>>2]=M;F=F+4|0;G=G+ -4|0}while(F>>>0<G>>>0)}break};case 0:{c[d>>2]=c[e>>2];break};case 2:{F=a[p>>0]|0;G=(F&1)==0;if(G){H=(F&255)>>>1}else{H=c[y>>2]|0}if(!((H|0)==0|C)){if(G){H=y;J=(F&255)>>>1;I=y}else{I=c[B>>2]|0;H=I;J=c[y>>2]|0}G=H+(J<<2)|0;F=c[e>>2]|0;if((I|0)!=(G|0)){H=(H+(J+ -1<<2)+(0-I)|0)>>>2;J=F;while(1){c[J>>2]=c[I>>2];I=I+4|0;if((I|0)==(G|0)){break}J=J+4|0}F=F+(H+1<<2)|0}c[e>>2]=F}break};case 1:{c[d>>2]=c[e>>2];L=Sc[c[(c[j>>2]|0)+44>>2]&63](j,32)|0;M=c[e>>2]|0;c[e>>2]=M+4;c[M>>2]=L;break};case 3:{G=a[q>>0]|0;F=(G&1)==0;if(F){G=(G&255)>>>1}else{G=c[t>>2]|0}if((G|0)!=0){if(F){F=t}else{F=c[u>>2]|0}L=c[F>>2]|0;M=c[e>>2]|0;c[e>>2]=M+4;c[M>>2]=L}break};default:{}}E=E+1|0}while((E|0)!=4);h=a[q>>0]|0;q=(h&1)==0;if(q){v=(h&255)>>>1}else{v=c[t>>2]|0}if(v>>>0>1){if(q){q=t;u=t;v=(h&255)>>>1}else{u=c[u>>2]|0;q=u;v=c[t>>2]|0}q=q+4|0;h=u+(v<<2)|0;t=c[e>>2]|0;if((q|0)!=(h|0)){v=(u+(v+ -1<<2)+(0-q)|0)>>>2;u=t;while(1){c[u>>2]=c[q>>2];q=q+4|0;if((q|0)==(h|0)){break}else{u=u+4|0}}t=t+(v+1<<2)|0}c[e>>2]=t}f=f&176;if((f|0)==32){c[d>>2]=c[e>>2];i=s;return}else if((f|0)==16){i=s;return}else{c[d>>2]=b;i=s;return}}function gs(b,d,e,f,g,h,j){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0;o=i;i=i+480|0;w=o;k=o+476|0;r=o+472|0;s=o+468|0;t=o+464|0;m=o+452|0;d=o+440|0;l=o+428|0;z=o+424|0;x=o+24|0;p=o+20|0;q=o+16|0;v=o+12|0;ln(k,g);y=c[k>>2]|0;if(!(!((c[4086]|0)==-1)?(c[w>>2]=16344,c[w+4>>2]=205,c[w+8>>2]=0,u=0,Na(58,16344,w|0,206),C=u,u=0,C&1):0)){A=3}do{if((A|0)==3){B=(c[16348>>2]|0)+ -1|0;A=c[y+8>>2]|0;if((c[y+12>>2]|0)-A>>2>>>0>B>>>0?(n=c[A+(B<<2)>>2]|0,(n|0)!=0):0){A=a[j>>0]|0;y=(A&1)==0;if(y){A=(A&255)>>>1}else{A=c[j+4>>2]|0}if((A|0)==0){y=0}else{if(y){y=j+4|0}else{y=c[j+8>>2]|0}y=c[y>>2]|0;u=0;A=Ha(c[(c[n>>2]|0)+44>>2]|0,n|0,45)|0;C=u;u=0;if(C&1){break}y=(y|0)==(A|0)}c[r>>2]=0;c[m+0>>2]=0;c[m+4>>2]=0;c[m+8>>2]=0;c[d+0>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[l+0>>2]=0;c[l+4>>2]=0;c[l+8>>2]=0;u=0;Ga(4,f|0,y|0,k|0,r|0,s|0,t|0,m|0,d|0,l|0,z|0);C=u;u=0;a:do{if(!(C&1)){f=a[j>>0]|0;A=(f&1)==0;if(A){B=(f&255)>>>1}else{B=c[j+4>>2]|0}z=c[z>>2]|0;if((B|0)>(z|0)){if(A){A=(f&255)>>>1}else{A=c[j+4>>2]|0}B=a[l>>0]|0;if((B&1)==0){B=(B&255)>>>1}else{B=c[l+4>>2]|0}C=a[d>>0]|0;if((C&1)==0){C=(C&255)>>>1}else{C=c[d+4>>2]|0}A=B+(A-z<<1|1)+C|0}else{A=a[l>>0]|0;if((A&1)==0){A=(A&255)>>>1}else{A=c[l+4>>2]|0}B=a[d>>0]|0;if((B&1)==0){B=(B&255)>>>1}else{B=c[d+4>>2]|0}A=A+2+B|0}A=A+z|0;do{if(A>>>0>100){x=Av(A<<2)|0;if((x|0)==0){u=0;Oa(4);C=u;u=0;if(C&1){g=qb(-1,-1)|0;break a}else{A=0;f=a[j>>0]|0;x=0;break}}else{A=x}}else{A=0}}while(0);if((f&1)==0){B=j+4|0;j=(f&255)>>>1}else{B=c[j+8>>2]|0;j=c[j+4>>2]|0}u=0;va(2,x|0,p|0,q|0,c[g+4>>2]|0,B|0,B+(j<<2)|0,n|0,y|0,r|0,c[s>>2]|0,c[t>>2]|0,m|0,d|0,l|0,z|0);C=u;u=0;if(!(C&1)){c[v>>2]=c[e>>2];B=c[p>>2]|0;C=c[q>>2]|0;u=0;c[w+0>>2]=c[v+0>>2];Da(45,b|0,w|0,x|0,B|0,C|0,g|0,h|0);C=u;u=0;if(!(C&1)){if((A|0)==0){bn(l);bn(d);Rm(m);C=c[k>>2]|0;qm(C)|0;i=o;return}Bv(A);bn(l);bn(d);Rm(m);C=c[k>>2]|0;qm(C)|0;i=o;return}}g=qb(-1,-1)|0;if((A|0)!=0){Bv(A)}}else{g=qb(-1,-1)|0}}while(0);bn(l);bn(d);Rm(m);C=g;B=c[k>>2]|0;qm(B)|0;vb(C|0)}C=Jb(4)|0;bv(C);u=0;Na(45,C|0,24312,171);C=u;u=0}}while(0);C=qb(-1,-1)|0;B=c[k>>2]|0;qm(B)|0;vb(C|0)}function hs(a){a=a|0;var b=0;b=i;Hv(a);i=b;return}function is(a){a=a|0;return}function js(b,d,e){b=b|0;d=d|0;e=e|0;b=i;if((a[d>>0]&1)==0){d=d+1|0}else{d=c[d+8>>2]|0}e=Cb(d|0,1)|0;i=b;return e>>>((e|0)!=(-1|0)&1)|0}function ks(b,d,e,f,g,h){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0,n=0;k=i;i=i+16|0;d=k;c[d+0>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;m=a[h>>0]|0;if((m&1)==0){l=h+1|0;m=(m&255)>>>1;h=h+1|0}else{n=c[h+8>>2]|0;l=n;m=c[h+4>>2]|0;h=n}l=l+m|0;do{if(h>>>0<l>>>0){do{u=0;oa(122,d|0,a[h>>0]|0);n=u;u=0;if(n&1){j=12;break}h=h+1|0}while((h|0)!=(l|0));if((j|0)==12){b=qb(-1,-1)|0;break}l=(e|0)==-1?-1:e<<1;if((a[d>>0]&1)==0){j=10}else{e=c[d+8>>2]|0;j=11}}else{l=(e|0)==-1?-1:e<<1;j=10}}while(0);if((j|0)==10){e=d+1|0;j=11}do{if((j|0)==11){u=0;g=Ma(18,l|0,f|0,g|0,e|0)|0;n=u;u=0;if(n&1){b=qb(-1,-1)|0;break}c[b+0>>2]=0;c[b+4>>2]=0;c[b+8>>2]=0;n=sw(g|0)|0;f=g+n|0;if((n|0)<=0){Rm(d);i=k;return}while(1){u=0;oa(122,b|0,a[g>>0]|0);n=u;u=0;if(n&1){break}g=g+1|0;if((g|0)==(f|0)){j=19;break}}if((j|0)==19){Rm(d);i=k;return}n=qb(-1,-1)|0;Rm(b);Rm(d);vb(n|0)}}while(0);n=b;Rm(d);vb(n|0)}function ls(a,b){a=a|0;b=b|0;a=i;mb(((b|0)==-1?-1:b<<1)|0)|0;i=a;return}function ms(a){a=a|0;var b=0;b=i;Hv(a);i=b;return}function ns(a){a=a|0;return}function os(b,d,e){b=b|0;d=d|0;e=e|0;b=i;if((a[d>>0]&1)==0){d=d+1|0}else{d=c[d+8>>2]|0}e=Cb(d|0,1)|0;i=b;return e>>>((e|0)!=(-1|0)&1)|0}function ps(b,d,e,f,g,h){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0;l=i;i=i+224|0;t=l+8|0;y=l+192|0;x=l+188|0;w=l+184|0;p=l;n=l+56|0;m=l+48|0;q=l+44|0;d=l+32|0;v=l+24|0;o=l+16|0;c[d+0>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[v+4>>2]=0;c[v>>2]=18008;A=a[h>>0]|0;if((A&1)==0){z=h+4|0;B=(A&255)>>>1;A=h+4|0}else{A=c[h+8>>2]|0;z=A;B=c[h+4>>2]|0}z=z+(B<<2)|0;C=t;c[C>>2]=0;c[C+4>>2]=0;a:do{if(A>>>0<z>>>0){h=y+32|0;B=18008|0;b:while(1){c[w>>2]=A;u=0;C=Ca(c[B+12>>2]|0,v|0,t|0,A|0,z|0,w|0,y|0,h|0,x|0)|0;B=u;u=0;if(B&1){k=22;break}B=c[w>>2]|0;if((C|0)==2|(B|0)==(A|0)){k=9;break}if(y>>>0<(c[x>>2]|0)>>>0){A=y;do{u=0;oa(122,d|0,a[A>>0]|0);C=u;u=0;if(C&1){k=21;break b}A=A+1|0}while(A>>>0<(c[x>>2]|0)>>>0);A=c[w>>2]|0}else{A=B}if(!(A>>>0<z>>>0)){break a}B=c[v>>2]|0}do{if((k|0)==9){u=0;na(203,17232);C=u;u=0;if(C&1){r=qb(-1,-1)|0;break}}else if((k|0)==21){r=qb(-1,-1)|0}else if((k|0)==22){r=qb(-1,-1)|0}}while(0);C=r;Rm(d);vb(C|0)}}while(0);if((a[d>>0]&1)==0){r=d+1|0}else{r=c[d+8>>2]|0}u=0;f=Ma(18,((e|0)==-1?-1:e<<1)|0,f|0,g|0,r|0)|0;C=u;u=0;if(C&1){C=qb(-1,-1)|0;Rm(d);vb(C|0)}c[b+0>>2]=0;c[b+4>>2]=0;c[b+8>>2]=0;c[o+4>>2]=0;c[o>>2]=18112;C=sw(f|0)|0;e=f+C|0;B=p;c[B>>2]=0;c[B+4>>2]=0;if((C|0)<=0){Rm(d);i=l;return}g=e;r=n+128|0;s=18112|0;c:while(1){c[q>>2]=f;u=0;s=Ca(c[s+16>>2]|0,o|0,p|0,f|0,((g-f|0)>32?f+32|0:e)|0,q|0,n|0,r|0,m|0)|0;C=u;u=0;if(C&1){k=39;break}t=c[q>>2]|0;if((s|0)==2|(t|0)==(f|0)){k=30;break}if(n>>>0<(c[m>>2]|0)>>>0){f=n;do{u=0;oa(124,b|0,c[f>>2]|0);C=u;u=0;if(C&1){k=38;break c}f=f+4|0}while(f>>>0<(c[m>>2]|0)>>>0);f=c[q>>2]|0}else{f=t}if(!(f>>>0<e>>>0)){k=37;break}s=c[o>>2]|0}do{if((k|0)==30){u=0;na(203,17232);C=u;u=0;if(C&1){j=qb(-1,-1)|0;break}}else if((k|0)==37){Rm(d);i=l;return}else if((k|0)==38){j=qb(-1,-1)|0}else if((k|0)==39){j=qb(-1,-1)|0}}while(0);bn(b);C=j;Rm(d);vb(C|0)}function qs(a,b){a=a|0;b=b|0;a=i;mb(((b|0)==-1?-1:b<<1)|0)|0;i=a;return}function rs(b){b=b|0;var d=0,e=0,f=0,g=0;d=i;c[b>>2]=16440;b=b+8|0;e=c[b>>2]|0;do{if((a[16248]|0)==0?(Ua(16248)|0)!=0:0){u=0;f=ua(33,2147483647,16256,0)|0;g=u;u=0;if(!(g&1)){c[4060]=f;rb(16248);break}qb(-1,-1,0)|0;Eb(16248);Ta()}}while(0);if((e|0)==(c[4060]|0)){i=d;return}u=0;na(208,c[b>>2]|0);g=u;u=0;if(!(g&1)){i=d;return}qb(-1,-1,0)|0;Ta()}function ss(a){a=a|0;var b=0;a=Jb(8)|0;u=0;oa(121,a|0,16232);b=u;u=0;if(b&1){b=qb(-1,-1)|0;pb(a|0);vb(b|0)}else{c[a>>2]=13216;qc(a|0,13256,86)}}



function ts(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0;h=i;i=i+448|0;k=h+432|0;l=h+416|0;m=h+400|0;n=h+384|0;o=h+368|0;p=h+352|0;q=h+336|0;r=h+320|0;s=h+304|0;t=h+288|0;v=h+272|0;w=h+256|0;x=h+240|0;y=h+224|0;z=h+208|0;A=h+192|0;B=h+176|0;C=h+160|0;D=h+144|0;E=h+128|0;F=h+112|0;G=h+96|0;H=h+80|0;K=h+64|0;J=h+48|0;L=h+32|0;M=h+16|0;j=h;c[b+4>>2]=d+ -1;c[b>>2]=16272;g=b+8|0;e=b+12|0;f=b+136|0;d=b+24|0;a[f>>0]=1;c[e>>2]=d;c[g>>2]=d;c[b+16>>2]=f;I=28;N=d;do{if((N|0)==0){N=0}else{c[N>>2]=0;N=c[e>>2]|0}N=N+4|0;c[e>>2]=N;I=I+ -1|0}while((I|0)!=0);I=b+144|0;u=0;Na(60,I|0,16256,1);O=u;u=0;if(O&1){b=qb(-1,-1)|0}else{N=c[g>>2]|0;O=c[e>>2]|0;if((O|0)!=(N|0)){c[e>>2]=O+(~((O+ -4+(0-N)|0)>>>2)<<2)}c[21164>>2]=0;c[5290]=14752;if(!((c[3694]|0)==-1)?(c[M>>2]=14776,c[M+4>>2]=205,c[M+8>>2]=0,u=0,Na(58,14776,M|0,206),O=u,u=0,O&1):0){M=111}else{M=10}a:do{if((M|0)==10){u=0;Na(61,b|0,21160,(c[14780>>2]|0)+ -1|0);O=u;u=0;if(!(O&1)){c[21156>>2]=0;c[5288]=14792;if(!((c[3704]|0)==-1)?(c[L>>2]=14816,c[L+4>>2]=205,c[L+8>>2]=0,u=0,Na(58,14816,L|0,206),O=u,u=0,O&1):0){M=111;break}u=0;Na(61,b|0,21152,(c[14820>>2]|0)+ -1|0);O=u;u=0;if(!(O&1)){c[21140>>2]=0;c[5284]=16368;c[21144>>2]=0;a[21148>>0]=0;u=0;L=Ka(3)|0;O=u;u=0;if(O&1){O=qb(-1,-1,0)|0;jd(O)}c[21144>>2]=c[L>>2];if(!((c[4088]|0)==-1)?(c[J>>2]=16352,c[J+4>>2]=205,c[J+8>>2]=0,u=0,Na(58,16352,J|0,206),O=u,u=0,O&1):0){M=111;break}u=0;Na(61,b|0,21136,(c[16356>>2]|0)+ -1|0);O=u;u=0;if(!(O&1)){c[21132>>2]=0;c[5282]=17328;if(!((c[4086]|0)==-1)?(c[K>>2]=16344,c[K+4>>2]=205,c[K+8>>2]=0,u=0,Na(58,16344,K|0,206),O=u,u=0,O&1):0){M=111;break}u=0;Na(61,b|0,21128,(c[16348>>2]|0)+ -1|0);O=u;u=0;if(!(O&1)){c[21124>>2]=0;c[5280]=17544;if(!((c[4104]|0)==-1)?(c[H>>2]=16416,c[H+4>>2]=205,c[H+8>>2]=0,u=0,Na(58,16416,H|0,206),O=u,u=0,O&1):0){M=111;break}u=0;Na(61,b|0,21120,(c[16420>>2]|0)+ -1|0);O=u;u=0;if(!(O&1)){c[21108>>2]=0;c[5276]=16440;do{if((a[16248]|0)==0?(Ua(16248)|0)!=0:0){u=0;H=ua(33,2147483647,16256,0)|0;O=u;u=0;if(O&1){b=qb(-1,-1)|0;Eb(16248);break a}else{c[4060]=H;rb(16248);break}}}while(0);c[21112>>2]=c[4060];if(!((c[4106]|0)==-1)?(c[G>>2]=16424,c[G+4>>2]=205,c[G+8>>2]=0,u=0,Na(58,16424,G|0,206),O=u,u=0,O&1):0){M=111;break}u=0;Na(61,b|0,21104,(c[16428>>2]|0)+ -1|0);O=u;u=0;if(!(O&1)){c[21100>>2]=0;c[5274]=17768;if(!((c[4120]|0)==-1)?(c[F>>2]=16480,c[F+4>>2]=205,c[F+8>>2]=0,u=0,Na(58,16480,F|0,206),O=u,u=0,O&1):0){M=111;break}u=0;Na(61,b|0,21096,(c[16484>>2]|0)+ -1|0);O=u;u=0;if(!(O&1)){c[21092>>2]=0;c[5272]=17888;if(!((c[4122]|0)==-1)?(c[E>>2]=16488,c[E+4>>2]=205,c[E+8>>2]=0,u=0,Na(58,16488,E|0,206),O=u,u=0,O&1):0){M=111;break}u=0;Na(61,b|0,21088,(c[16492>>2]|0)+ -1|0);O=u;u=0;if(O&1){M=111;break}c[21068>>2]=0;c[5266]=16520;a[21072>>0]=46;a[21073>>0]=44;c[21076>>2]=0;c[21080>>2]=0;c[21084>>2]=0;if(!((c[4124]|0)==-1)?(c[D>>2]=16496,c[D+4>>2]=205,c[D+8>>2]=0,u=0,Na(58,16496,D|0,206),O=u,u=0,O&1):0){M=111;break}u=0;Na(61,b|0,21064,(c[16500>>2]|0)+ -1|0);O=u;u=0;if(O&1){M=111;break}c[21036>>2]=0;c[5258]=16560;c[21040>>2]=46;c[21044>>2]=44;c[21048>>2]=0;c[21052>>2]=0;c[21056>>2]=0;if(!((c[4126]|0)==-1)?(c[C>>2]=16504,c[C+4>>2]=205,c[C+8>>2]=0,u=0,Na(58,16504,C|0,206),O=u,u=0,O&1):0){M=111;break}u=0;Na(61,b|0,21032,(c[16508>>2]|0)+ -1|0);O=u;u=0;if(O&1){M=111;break}c[21028>>2]=0;c[5256]=14832;if(!((c[3722]|0)==-1)?(c[B>>2]=14888,c[B+4>>2]=205,c[B+8>>2]=0,u=0,Na(58,14888,B|0,206),O=u,u=0,O&1):0){M=111;break}u=0;Na(61,b|0,21024,(c[14892>>2]|0)+ -1|0);O=u;u=0;if(O&1){M=111;break}c[21020>>2]=0;c[5254]=14952;if(!((c[3752]|0)==-1)?(c[A>>2]=15008,c[A+4>>2]=205,c[A+8>>2]=0,u=0,Na(58,15008,A|0,206),O=u,u=0,O&1):0){M=111;break}u=0;Na(61,b|0,21016,(c[15012>>2]|0)+ -1|0);O=u;u=0;if(O&1){M=111;break}c[21012>>2]=0;c[5252]=15024;if(!((c[3768]|0)==-1)?(c[z>>2]=15072,c[z+4>>2]=205,c[z+8>>2]=0,u=0,Na(58,15072,z|0,206),O=u,u=0,O&1):0){M=111;break}u=0;Na(61,b|0,21008,(c[15076>>2]|0)+ -1|0);O=u;u=0;if(O&1){M=111;break}c[21004>>2]=0;c[5250]=15088;if(!((c[3784]|0)==-1)?(c[y>>2]=15136,c[y+4>>2]=205,c[y+8>>2]=0,u=0,Na(58,15136,y|0,206),O=u,u=0,O&1):0){M=111;break}u=0;Na(61,b|0,21e3,(c[15140>>2]|0)+ -1|0);O=u;u=0;if(O&1){M=111;break}c[20996>>2]=0;c[5248]=15680;if(!((c[3932]|0)==-1)?(c[x>>2]=15728,c[x+4>>2]=205,c[x+8>>2]=0,u=0,Na(58,15728,x|0,206),O=u,u=0,O&1):0){M=111;break}u=0;Na(61,b|0,20992,(c[15732>>2]|0)+ -1|0);O=u;u=0;if(O&1){M=111;break}c[20988>>2]=0;c[5246]=15744;if(!((c[3948]|0)==-1)?(c[w>>2]=15792,c[w+4>>2]=205,c[w+8>>2]=0,u=0,Na(58,15792,w|0,206),O=u,u=0,O&1):0){M=111;break}u=0;Na(61,b|0,20984,(c[15796>>2]|0)+ -1|0);O=u;u=0;if(O&1){M=111;break}c[20980>>2]=0;c[5244]=15808;if(!((c[3964]|0)==-1)?(c[v>>2]=15856,c[v+4>>2]=205,c[v+8>>2]=0,u=0,Na(58,15856,v|0,206),O=u,u=0,O&1):0){M=111;break}u=0;Na(61,b|0,20976,(c[15860>>2]|0)+ -1|0);O=u;u=0;if(O&1){M=111;break}c[20972>>2]=0;c[5242]=15872;if(!((c[3980]|0)==-1)?(c[t>>2]=15920,c[t+4>>2]=205,c[t+8>>2]=0,u=0,Na(58,15920,t|0,206),O=u,u=0,O&1):0){M=111;break}u=0;Na(61,b|0,20968,(c[15924>>2]|0)+ -1|0);O=u;u=0;if(O&1){M=111;break}c[20964>>2]=0;c[5240]=15936;if(!((c[3990]|0)==-1)?(c[s>>2]=15960,c[s+4>>2]=205,c[s+8>>2]=0,u=0,Na(58,15960,s|0,206),O=u,u=0,O&1):0){M=111;break}u=0;Na(61,b|0,20960,(c[15964>>2]|0)+ -1|0);O=u;u=0;if(O&1){M=111;break}c[20956>>2]=0;c[5238]=16016;if(!((c[4010]|0)==-1)?(c[r>>2]=16040,c[r+4>>2]=205,c[r+8>>2]=0,u=0,Na(58,16040,r|0,206),O=u,u=0,O&1):0){M=111;break}u=0;Na(61,b|0,20952,(c[16044>>2]|0)+ -1|0);O=u;u=0;if(O&1){M=111;break}c[20948>>2]=0;c[5236]=16072;if(!((c[4024]|0)==-1)?(c[q>>2]=16096,c[q+4>>2]=205,c[q+8>>2]=0,u=0,Na(58,16096,q|0,206),O=u,u=0,O&1):0){M=111;break}u=0;Na(61,b|0,20944,(c[16100>>2]|0)+ -1|0);O=u;u=0;if(O&1){M=111;break}c[20940>>2]=0;c[5234]=16120;if(!((c[4036]|0)==-1)?(c[p>>2]=16144,c[p+4>>2]=205,c[p+8>>2]=0,u=0,Na(58,16144,p|0,206),O=u,u=0,O&1):0){M=111;break}u=0;Na(61,b|0,20936,(c[16148>>2]|0)+ -1|0);O=u;u=0;if(O&1){M=111;break}c[20924>>2]=0;c[5230]=15168;c[20928>>2]=15216;if(!((c[3812]|0)==-1)?(c[o>>2]=15248,c[o+4>>2]=205,c[o+8>>2]=0,u=0,Na(58,15248,o|0,206),O=u,u=0,O&1):0){M=111;break}u=0;Na(61,b|0,20920,(c[15252>>2]|0)+ -1|0);O=u;u=0;if(O&1){M=111;break}c[20908>>2]=0;c[5226]=15320;c[20912>>2]=15368;if(!((c[3850]|0)==-1)?(c[n>>2]=15400,c[n+4>>2]=205,c[n+8>>2]=0,u=0,Na(58,15400,n|0,206),O=u,u=0,O&1):0){M=111;break}u=0;Na(61,b|0,20904,(c[15404>>2]|0)+ -1|0);O=u;u=0;if(O&1){M=111;break}c[20892>>2]=0;c[5222]=17264;do{if((a[16248]|0)==0){if((Ua(16248)|0)==0){break}u=0;n=ua(33,2147483647,16256,0)|0;O=u;u=0;if(O&1){b=qb(-1,-1)|0;Eb(16248);break a}else{c[4060]=n;rb(16248);break}}}while(0);c[20896>>2]=c[4060];c[5222]=15616;if(!((c[3908]|0)==-1)?(c[m>>2]=15632,c[m+4>>2]=205,c[m+8>>2]=0,u=0,Na(58,15632,m|0,206),O=u,u=0,O&1):0){M=111;break}u=0;Na(61,b|0,20888,(c[15636>>2]|0)+ -1|0);O=u;u=0;if(O&1){M=111;break}c[20876>>2]=0;c[5218]=17264;do{if((a[16248]|0)==0){if((Ua(16248)|0)==0){break}u=0;m=ua(33,2147483647,16256,0)|0;O=u;u=0;if(O&1){b=qb(-1,-1)|0;Eb(16248);break a}else{c[4060]=m;rb(16248);break}}}while(0);c[20880>>2]=c[4060];c[5218]=15648;if(!((c[3916]|0)==-1)?(c[l>>2]=15664,c[l+4>>2]=205,c[l+8>>2]=0,u=0,Na(58,15664,l|0,206),O=u,u=0,O&1):0){M=111;break}u=0;Na(61,b|0,20872,(c[15668>>2]|0)+ -1|0);O=u;u=0;if(O&1){M=111;break}c[20868>>2]=0;c[5216]=16160;if(!((c[4046]|0)==-1)?(c[k>>2]=16184,c[k+4>>2]=205,c[k+8>>2]=0,u=0,Na(58,16184,k|0,206),O=u,u=0,O&1):0){M=111;break}u=0;Na(61,b|0,20864,(c[16188>>2]|0)+ -1|0);O=u;u=0;if(O&1){M=111;break}c[20860>>2]=0;c[5214]=16200;if(!((c[4056]|0)==-1)?(c[j>>2]=16224,c[j+4>>2]=205,c[j+8>>2]=0,u=0,Na(58,16224,j|0,206),O=u,u=0,O&1):0){M=111;break}u=0;Na(61,b|0,20856,(c[16228>>2]|0)+ -1|0);O=u;u=0;if(O&1){M=111;break}i=h;return}else{M=111}}else{M=111}}else{M=111}}else{M=111}}else{M=111}}else{M=111}}else{M=111}}}while(0);if((M|0)==111){b=qb(-1,-1)|0}Rm(I)}g=c[g>>2]|0;if((g|0)==0){vb(b|0)}h=c[e>>2]|0;if((h|0)!=(g|0)){c[e>>2]=h+(~((h+ -4+(0-g)|0)>>>2)<<2)}if((d|0)==(g|0)){a[f>>0]=0;vb(b|0)}else{Hv(g);vb(b|0)}}function us(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0;f=i;pm(b);e=a+8|0;g=a+12|0;a=c[g>>2]|0;h=c[e>>2]|0;j=a-h>>2;do{if(!(j>>>0>d>>>0)){k=d+1|0;if(!(j>>>0<k>>>0)){if(!(j>>>0>k>>>0)){break}j=h+(k<<2)|0;if((a|0)==(j|0)){break}c[g>>2]=a+(~((a+ -4+(0-j)|0)>>>2)<<2);break}u=0;oa(126,e|0,k-j|0);k=u;u=0;if(!(k&1)){h=c[e>>2]|0;break}d=qb(-1,-1)|0;if((b|0)==0){vb(d|0)}qm(b)|0;vb(d|0)}}while(0);a=c[h+(d<<2)>>2]|0;if((a|0)==0){k=h;k=k+(d<<2)|0;c[k>>2]=b;i=f;return}qm(a)|0;k=c[e>>2]|0;k=k+(d<<2)|0;c[k>>2]=b;i=f;return}function vs(a){a=a|0;var b=0;b=i;ws(a);Hv(a);i=b;return}function ws(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0;e=i;c[b>>2]=16272;d=b+12|0;g=c[d>>2]|0;f=b+8|0;j=c[f>>2]|0;if((g|0)!=(j|0)){h=0;do{k=c[j+(h<<2)>>2]|0;if((k|0)!=0){qm(k)|0;g=c[d>>2]|0;j=c[f>>2]|0}h=h+1|0}while(h>>>0<g-j>>2>>>0)}Rm(b+144|0);f=c[f>>2]|0;if((f|0)==0){i=e;return}g=c[d>>2]|0;if((g|0)!=(f|0)){c[d>>2]=g+(~((g+ -4+(0-f)|0)>>>2)<<2)}if((b+24|0)==(f|0)){a[b+136>>0]=0;i=e;return}else{Hv(f);i=e;return}}function xs(){var b=0,d=0;b=i;if((a[16328]|0)!=0){d=c[4080]|0;i=b;return d|0}if((Ua(16328)|0)==0){d=c[4080]|0;i=b;return d|0}do{if((a[16304]|0)==0?(Ua(16304)|0)!=0:0){u=0;oa(127,20696,1);d=u;u=0;if(d&1){d=qb(-1,-1)|0;Eb(16304);Eb(16328);vb(d|0)}else{c[4072]=20696;c[4074]=16288;rb(16304);break}}}while(0);d=c[c[4074]>>2]|0;c[4078]=d;pm(d);c[4080]=16312;rb(16328);d=c[4080]|0;i=b;return d|0}function ys(a){a=a|0;var b=0,d=0,e=0;b=i;u=0;d=Ka(4)|0;e=u;u=0;if(e&1){e=qb(-1,-1,0)|0;jd(e)}else{e=c[d>>2]|0;c[a>>2]=e;pm(e);i=b;return}}function zs(a,b){a=a|0;b=b|0;var d=0;d=i;b=c[b>>2]|0;c[a>>2]=b;pm(b);i=d;return}function As(a){a=a|0;var b=0;b=i;qm(c[a>>2]|0)|0;i=b;return}function Bs(a,b){a=a|0;b=b|0;var d=0,e=0;d=i;i=i+16|0;e=d;a=c[a>>2]|0;if(!((c[b>>2]|0)==-1)){c[e>>2]=b;c[e+4>>2]=205;c[e+8>>2]=0;Lm(b,e,206)}e=(c[b+4>>2]|0)+ -1|0;b=c[a+8>>2]|0;if(!((c[a+12>>2]|0)-b>>2>>>0>e>>>0)){e=Jb(4)|0;bv(e);qc(e|0,24312,171)}a=c[b+(e<<2)>>2]|0;if((a|0)==0){e=Jb(4)|0;bv(e);qc(e|0,24312,171)}else{i=d;return a|0}return 0}function Cs(a){a=a|0;var b=0;b=i;Hv(a);i=b;return}function Ds(a){a=a|0;var b=0;b=i;if((a|0)==0){i=b;return}yc[c[(c[a>>2]|0)+4>>2]&255](a);i=b;return}function Es(a){a=a|0;var b=0;b=c[4084]|0;c[4084]=b+1;c[a+4>>2]=b+1;return}function Fs(a){a=a|0;var b=0;b=i;Hv(a);i=b;return}function Gs(a,d,e){a=a|0;d=d|0;e=e|0;var f=0,g=0;a=i;if(!(e>>>0<128)){f=0;i=a;return f|0}u=0;f=Ka(3)|0;g=u;u=0;if(g&1){g=qb(-1,-1,0)|0;jd(g)}g=(b[(c[f>>2]|0)+(e<<1)>>1]&d)<<16>>16!=0;i=a;return g|0}function Hs(a,d,e,f){a=a|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0;a=i;if((d|0)==(e|0)){h=d;i=a;return h|0}while(1){g=c[d>>2]|0;if(g>>>0<128){u=0;h=Ka(3)|0;j=u;u=0;if(j&1){d=4;break}g=b[(c[h>>2]|0)+(g<<1)>>1]|0}else{g=0}b[f>>1]=g;d=d+4|0;if((d|0)==(e|0)){d=7;break}else{f=f+2|0}}if((d|0)==4){j=qb(-1,-1,0)|0;jd(j)}else if((d|0)==7){i=a;return e|0}return 0}function Is(a,d,e,f){a=a|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0;a=i;if((e|0)==(f|0)){h=e;i=a;return h|0}while(1){g=c[e>>2]|0;if(g>>>0<128){u=0;h=Ka(3)|0;j=u;u=0;if(j&1){d=4;break}if(!((b[(c[h>>2]|0)+(g<<1)>>1]&d)<<16>>16==0)){f=e;d=7;break}}e=e+4|0;if((e|0)==(f|0)){d=7;break}}if((d|0)==4){j=qb(-1,-1,0)|0;jd(j)}else if((d|0)==7){i=a;return f|0}return 0}function Js(a,d,e,f){a=a|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0;a=i;a:do{if((e|0)==(f|0)){g=e}else{while(1){h=c[e>>2]|0;if(!(h>>>0<128)){g=e;break a}u=0;j=Ka(3)|0;k=u;u=0;if(k&1){break}if((b[(c[j>>2]|0)+(h<<1)>>1]&d)<<16>>16==0){g=e;break a}e=e+4|0;if((e|0)==(f|0)){g=f;break a}}k=qb(-1,-1,0)|0;jd(k)}}while(0);i=a;return g|0}function Ks(a,b){a=a|0;b=b|0;var d=0,e=0;a=i;if(!(b>>>0<128)){d=b;i=a;return d|0}u=0;d=Ka(5)|0;e=u;u=0;if(e&1){e=qb(-1,-1,0)|0;jd(e)}e=c[(c[d>>2]|0)+(b<<2)>>2]|0;i=a;return e|0}function Ls(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0;a=i;if((b|0)==(d|0)){f=b;i=a;return f|0}while(1){e=c[b>>2]|0;if(e>>>0<128){u=0;f=Ka(5)|0;g=u;u=0;if(g&1){b=4;break}e=c[(c[f>>2]|0)+(e<<2)>>2]|0}c[b>>2]=e;b=b+4|0;if((b|0)==(d|0)){b=7;break}}if((b|0)==4){g=qb(-1,-1,0)|0;jd(g)}else if((b|0)==7){i=a;return d|0}return 0}function Ms(a,b){a=a|0;b=b|0;var d=0,e=0;a=i;if(!(b>>>0<128)){d=b;i=a;return d|0}u=0;d=Ka(6)|0;e=u;u=0;if(e&1){e=qb(-1,-1,0)|0;jd(e)}e=c[(c[d>>2]|0)+(b<<2)>>2]|0;i=a;return e|0}function Ns(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0;a=i;if((b|0)==(d|0)){f=b;i=a;return f|0}while(1){e=c[b>>2]|0;if(e>>>0<128){u=0;f=Ka(6)|0;g=u;u=0;if(g&1){b=4;break}e=c[(c[f>>2]|0)+(e<<2)>>2]|0}c[b>>2]=e;b=b+4|0;if((b|0)==(d|0)){b=7;break}}if((b|0)==4){g=qb(-1,-1,0)|0;jd(g)}else if((b|0)==7){i=a;return d|0}return 0}function Os(a,b){a=a|0;b=b|0;return b<<24>>24|0}function Ps(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;b=i;if((d|0)==(e|0)){i=b;return d|0}while(1){c[f>>2]=a[d>>0]|0;d=d+1|0;if((d|0)==(e|0)){break}else{f=f+4|0}}i=b;return e|0}function Qs(a,b,c){a=a|0;b=b|0;c=c|0;return(b>>>0<128?b&255:c)|0}function Rs(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0;b=i;if((d|0)==(e|0)){j=d;i=b;return j|0}h=((e+ -4+(0-d)|0)>>>2)+1|0;j=d;while(1){k=c[j>>2]|0;a[g>>0]=k>>>0<128?k&255:f;j=j+4|0;if((j|0)==(e|0)){break}else{g=g+1|0}}k=d+(h<<2)|0;i=b;return k|0}function Ss(b){b=b|0;var d=0,e=0;d=i;c[b>>2]=16368;e=c[b+8>>2]|0;if((e|0)!=0?(a[b+12>>0]|0)!=0:0){Iv(e)}Hv(b);i=d;return}function Ts(b){b=b|0;var d=0,e=0;d=i;c[b>>2]=16368;e=c[b+8>>2]|0;if((e|0)!=0?(a[b+12>>0]|0)!=0:0){Iv(e)}i=d;return}function Us(a,b){a=a|0;b=b|0;var d=0,e=0;a=i;if(!(b<<24>>24>-1)){d=b;i=a;return d|0}u=0;d=Ka(5)|0;e=u;u=0;if(e&1){e=qb(-1,-1,0)|0;jd(e)}e=c[(c[d>>2]|0)+((b&255)<<2)>>2]&255;i=a;return e|0}function Vs(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0;b=i;if((d|0)==(e|0)){g=d;i=b;return g|0}while(1){f=a[d>>0]|0;if(f<<24>>24>-1){u=0;g=Ka(5)|0;h=u;u=0;if(h&1){d=4;break}f=c[(c[g>>2]|0)+(f<<24>>24<<2)>>2]&255}a[d>>0]=f;d=d+1|0;if((d|0)==(e|0)){d=7;break}}if((d|0)==4){h=qb(-1,-1,0)|0;jd(h)}else if((d|0)==7){i=b;return e|0}return 0}function Ws(a,b){a=a|0;b=b|0;var d=0,e=0;a=i;if(!(b<<24>>24>-1)){d=b;i=a;return d|0}u=0;d=Ka(6)|0;e=u;u=0;if(e&1){e=qb(-1,-1,0)|0;jd(e)}e=c[(c[d>>2]|0)+(b<<24>>24<<2)>>2]&255;i=a;return e|0}function Xs(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0;b=i;if((d|0)==(e|0)){g=d;i=b;return g|0}while(1){f=a[d>>0]|0;if(f<<24>>24>-1){u=0;g=Ka(6)|0;h=u;u=0;if(h&1){d=4;break}f=c[(c[g>>2]|0)+(f<<24>>24<<2)>>2]&255}a[d>>0]=f;d=d+1|0;if((d|0)==(e|0)){d=7;break}}if((d|0)==4){h=qb(-1,-1,0)|0;jd(h)}else if((d|0)==7){i=b;return e|0}return 0}function Ys(a,b){a=a|0;b=b|0;return b|0}function Zs(b,c,d,e){b=b|0;c=c|0;d=d|0;e=e|0;b=i;if((c|0)==(d|0)){d=c}else{while(1){a[e>>0]=a[c>>0]|0;c=c+1|0;if((c|0)==(d|0)){break}else{e=e+1|0}}}i=b;return d|0}function _s(a,b,c){a=a|0;b=b|0;c=c|0;return(b<<24>>24>-1?b:c)|0}function $s(b,c,d,e,f){b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;var g=0;b=i;if((c|0)==(d|0)){i=b;return c|0}while(1){g=a[c>>0]|0;a[f>>0]=g<<24>>24>-1?g:e;c=c+1|0;if((c|0)==(d|0)){break}else{f=f+1|0}}i=b;return d|0}function at(a){a=a|0;var b=0;b=i;Hv(a);i=b;return}function bt(a,b,d,e,f,g,h,i){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;c[f>>2]=d;c[i>>2]=g;return 3}function ct(a,b,d,e,f,g,h,i){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;c[f>>2]=d;c[i>>2]=g;return 3}function dt(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;c[f>>2]=d;return 3}function et(a){a=a|0;return 1}function ft(a){a=a|0;return 1}function gt(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;b=d-c|0;return(b>>>0<e>>>0?b:e)|0}function ht(a){a=a|0;return 1}function it(a){a=a|0;var b=0;b=i;rs(a);Hv(a);i=b;return}function jt(b,d,e,f,g,h,j,k){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;var l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0;l=i;i=i+16|0;n=l;p=l+8|0;q=(e|0)==(f|0);a:do{if(!q){r=e;while(1){if((c[r>>2]|0)==0){break}r=r+4|0;if((r|0)==(f|0)){r=f;break}}c[k>>2]=h;c[g>>2]=e;if(!(q|(h|0)==(j|0))){q=j;b=b+8|0;s=r;while(1){v=d;t=c[v+4>>2]|0;r=n;c[r>>2]=c[v>>2];c[r+4>>2]=t;r=Nb(c[b>>2]|0)|0;u=0;t=Ia(13,h|0,g|0,s-e>>2|0,q-h|0,d|0)|0;v=u;u=0;if(v&1){j=11;break}if((r|0)!=0?(u=0,qa(127,r|0)|0,v=u,u=0,v&1):0){j=10;break}if((t|0)==-1){j=16;break}else if((t|0)==0){m=1;j=51;break}h=(c[k>>2]|0)+t|0;c[k>>2]=h;if((h|0)==(j|0)){j=49;break}if((s|0)==(f|0)){e=c[g>>2]|0;s=f}else{e=Nb(c[b>>2]|0)|0;u=0;h=ua(37,p|0,0,d|0)|0;v=u;u=0;if(v&1){j=35;break}if((e|0)!=0?(u=0,qa(127,e|0)|0,v=u,u=0,v&1):0){j=34;break}if((h|0)==-1){m=2;j=51;break}e=c[k>>2]|0;if(h>>>0>(q-e|0)>>>0){m=1;j=51;break}b:do{if((h|0)!=0){r=p;while(1){v=a[r>>0]|0;c[k>>2]=e+1;a[e>>0]=v;h=h+ -1|0;if((h|0)==0){break b}e=c[k>>2]|0;r=r+1|0}}}while(0);e=(c[g>>2]|0)+4|0;c[g>>2]=e;c:do{if((e|0)==(f|0)){s=f}else{s=e;while(1){if((c[s>>2]|0)==0){break c}s=s+4|0;if((s|0)==(f|0)){s=f;break}}}}while(0);h=c[k>>2]|0}if((e|0)==(f|0)|(h|0)==(j|0)){o=e;break a}}if((j|0)==10){v=qb(-1,-1,0)|0;jd(v)}else if((j|0)==11){m=qb(-1,-1)|0;if((r|0)==0){vb(m|0)}u=0;qa(127,r|0)|0;v=u;u=0;if(v&1){v=qb(-1,-1,0)|0;jd(v)}else{vb(m|0)}}else if((j|0)==16){c[k>>2]=h;d:do{if((e|0)!=(c[g>>2]|0)){while(1){f=c[e>>2]|0;o=Nb(c[b>>2]|0)|0;u=0;f=ua(37,h|0,f|0,n|0)|0;v=u;u=0;if(v&1){break}if((o|0)!=0?(u=0,qa(127,o|0)|0,v=u,u=0,v&1):0){j=20;break}if((f|0)==-1){m=e;break d}h=(c[k>>2]|0)+f|0;c[k>>2]=h;e=e+4|0;if((e|0)==(c[g>>2]|0)){m=e;break d}}if((j|0)==20){v=qb(-1,-1,0)|0;jd(v)}k=qb(-1,-1)|0;if((o|0)==0){vb(k|0)}u=0;qa(127,o|0)|0;v=u;u=0;if(v&1){v=qb(-1,-1,0)|0;jd(v)}else{vb(k|0)}}else{m=e}}while(0);c[g>>2]=m;v=2;i=l;return v|0}else if((j|0)==34){v=qb(-1,-1,0)|0;jd(v)}else if((j|0)==35){m=qb(-1,-1)|0;if((e|0)==0){vb(m|0)}u=0;qa(127,e|0)|0;v=u;u=0;if(v&1){v=qb(-1,-1,0)|0;jd(v)}else{vb(m|0)}}else if((j|0)==49){o=c[g>>2]|0;break}else if((j|0)==51){i=l;return m|0}}else{o=e}}else{c[k>>2]=h;c[g>>2]=e;o=e}}while(0);v=(o|0)!=(f|0)&1;i=l;return v|0}function kt(b,d,e,f,g,h,j,k){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;var l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0;l=i;i=i+16|0;n=l;p=(e|0)==(f|0);a:do{if(!p){r=e;while(1){if((a[r>>0]|0)==0){break}r=r+1|0;if((r|0)==(f|0)){r=f;break}}c[k>>2]=h;c[g>>2]=e;if(!(p|(h|0)==(j|0))){p=j;b=b+8|0;while(1){t=d;s=c[t+4>>2]|0;q=n;c[q>>2]=c[t>>2];c[q+4>>2]=s;q=r;s=Nb(c[b>>2]|0)|0;u=0;t=Ia(14,h|0,g|0,q-e|0,p-h>>2|0,d|0)|0;v=u;u=0;if(v&1){j=11;break}if((s|0)!=0?(u=0,qa(127,s|0)|0,v=u,u=0,v&1):0){j=10;break}if((t|0)==-1){j=16;break}else if((t|0)==0){f=2;j=50;break}h=(c[k>>2]|0)+(t<<2)|0;c[k>>2]=h;if((h|0)==(j|0)){j=48;break}e=c[g>>2]|0;if((r|0)==(f|0)){r=f}else{q=Nb(c[b>>2]|0)|0;u=0;e=Ma(19,h|0,e|0,1,d|0)|0;v=u;u=0;if(v&1){j=38;break}if((q|0)!=0?(u=0,qa(127,q|0)|0,v=u,u=0,v&1):0){j=37;break}if((e|0)!=0){f=2;j=50;break}c[k>>2]=(c[k>>2]|0)+4;e=(c[g>>2]|0)+1|0;c[g>>2]=e;b:do{if((e|0)==(f|0)){r=f}else{r=e;while(1){if((a[r>>0]|0)==0){break b}r=r+1|0;if((r|0)==(f|0)){r=f;break}}}}while(0);h=c[k>>2]|0}if((e|0)==(f|0)|(h|0)==(j|0)){o=e;break a}}if((j|0)==10){v=qb(-1,-1,0)|0;jd(v)}else if((j|0)==11){g=qb(-1,-1)|0;if((s|0)==0){vb(g|0)}u=0;qa(127,s|0)|0;v=u;u=0;if(v&1){v=qb(-1,-1,0)|0;jd(v)}else{vb(g|0)}}else if((j|0)==16){c[k>>2]=h;c:do{if((e|0)!=(c[g>>2]|0)){while(1){o=Nb(c[b>>2]|0)|0;u=0;j=Ma(19,h|0,e|0,q-e|0,n|0)|0;v=u;u=0;if(v&1){j=21;break}if((o|0)!=0?(u=0,qa(127,o|0)|0,v=u,u=0,v&1):0){j=20;break}if((j|0)==-2){j=28;break}else if((j|0)==0){e=e+1|0}else if((j|0)==-1){j=27;break}else{e=e+j|0}h=(c[k>>2]|0)+4|0;c[k>>2]=h;if((e|0)==(c[g>>2]|0)){m=e;break c}}if((j|0)==20){v=qb(-1,-1,0)|0;jd(v)}else if((j|0)==21){n=qb(-1,-1)|0;if((o|0)==0){vb(n|0)}u=0;qa(127,o|0)|0;v=u;u=0;if(v&1){v=qb(-1,-1,0)|0;jd(v)}else{vb(n|0)}}else if((j|0)==27){c[g>>2]=e;v=2;i=l;return v|0}else if((j|0)==28){c[g>>2]=e;v=1;i=l;return v|0}}else{m=e}}while(0);c[g>>2]=m;v=(m|0)!=(f|0)&1;i=l;return v|0}else if((j|0)==37){v=qb(-1,-1,0)|0;jd(v)}else if((j|0)==38){g=qb(-1,-1)|0;if((q|0)==0){vb(g|0)}u=0;qa(127,q|0)|0;v=u;u=0;if(v&1){v=qb(-1,-1,0)|0;jd(v)}else{vb(g|0)}}else if((j|0)==48){o=c[g>>2]|0;break}else if((j|0)==50){i=l;return f|0}}else{o=e}}else{c[k>>2]=h;c[g>>2]=e;o=e}}while(0);v=(o|0)!=(f|0)&1;i=l;return v|0}function lt(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0;h=i;i=i+16|0;j=h;c[g>>2]=e;b=Nb(c[b+8>>2]|0)|0;u=0;d=ua(37,j|0,0,d|0)|0;e=u;u=0;if(e&1){e=qb(-1,-1)|0;if((b|0)==0){vb(e|0)}u=0;qa(127,b|0)|0;k=u;u=0;if(k&1){k=qb(-1,-1,0)|0;jd(k)}else{vb(e|0)}}if((b|0)!=0?(u=0,qa(127,b|0)|0,k=u,u=0,k&1):0){k=qb(-1,-1,0)|0;jd(k)}if((d|0)==0|(d|0)==-1){k=2;i=h;return k|0}b=d+ -1|0;d=c[g>>2]|0;if(b>>>0>(f-d|0)>>>0){k=1;i=h;return k|0}if((b|0)==0){k=0;i=h;return k|0}else{f=d}while(1){k=a[j>>0]|0;c[g>>2]=f+1;a[f>>0]=k;b=b+ -1|0;if((b|0)==0){g=0;break}f=c[g>>2]|0;j=j+1|0}i=h;return g|0}function mt(a){a=a|0;var b=0,d=0,e=0,f=0,g=0;b=i;e=a+8|0;u=0;d=qa(127,c[e>>2]|0)|0;f=u;u=0;if(!(f&1)){u=0;a=ua(38,0,0,4)|0;f=u;u=0;if(f&1){f=qb(-1,-1,0)|0;if((d|0)==0){g=f;jd(g)}u=0;qa(127,d|0)|0;g=u;u=0;if(g&1){g=qb(-1,-1,0)|0;jd(g)}else{g=f;jd(g)}}if((d|0)!=0?(u=0,qa(127,d|0)|0,g=u,u=0,g&1):0){g=qb(-1,-1,0)|0;jd(g)}if((a|0)!=0){g=-1;i=b;return g|0}a=c[e>>2]|0;if((a|0)==0){g=1;i=b;return g|0}u=0;a=qa(127,a|0)|0;g=u;u=0;if(!(g&1)){if((a|0)==0){g=0;i=b;return g|0}u=0;qa(127,a|0)|0;g=u;u=0;if(g&1){g=qb(-1,-1,0)|0;jd(g)}else{g=0;i=b;return g|0}}}g=qb(-1,-1,0)|0;jd(g);return 0}function nt(a){a=a|0;return 0}function ot(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0;g=i;if((f|0)==0|(d|0)==(e|0)){m=0;i=g;return m|0}h=e;a=a+8|0;k=0;j=0;while(1){l=Nb(c[a>>2]|0)|0;u=0;m=ua(39,d|0,h-d|0,b|0)|0;n=u;u=0;if(n&1){f=7;break}if((l|0)!=0?(u=0,qa(127,l|0)|0,n=u,u=0,n&1):0){f=6;break}if((m|0)==-2|(m|0)==-1){f=15;break}else if((m|0)==0){d=d+1|0;m=1}else{d=d+m|0}k=m+k|0;j=j+1|0;if(j>>>0>=f>>>0|(d|0)==(e|0)){f=15;break}}if((f|0)==6){n=qb(-1,-1,0)|0;jd(n)}else if((f|0)==7){g=qb(-1,-1)|0;if((l|0)==0){vb(g|0)}u=0;qa(127,l|0)|0;n=u;u=0;if(n&1){n=qb(-1,-1,0)|0;jd(n)}else{vb(g|0)}}else if((f|0)==15){i=g;return k|0}return 0}function pt(a){a=a|0;var b=0,d=0;b=i;a=c[a+8>>2]|0;if((a|0)==0){a=1;i=b;return a|0}u=0;a=qa(127,a|0)|0;d=u;u=0;if(d&1){d=qb(-1,-1,0)|0;jd(d)}if((a|0)==0){d=4;i=b;return d|0}u=0;qa(127,a|0)|0;d=u;u=0;if(d&1){d=qb(-1,-1,0)|0;jd(d)}else{d=4;i=b;return d|0}return 0}function qt(a){a=a|0;var b=0;b=i;Hv(a);i=b;return}function rt(a,b,d,e,f,g,h,j){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0,l=0;a=i;i=i+16|0;l=a+4|0;k=a;c[l>>2]=d;c[k>>2]=g;b=st(d,e,l,g,h,k,1114111,0)|0;c[f>>2]=d+((c[l>>2]|0)-d>>1<<1);c[j>>2]=g+((c[k>>2]|0)-g);i=a;return b|0}function st(d,f,g,h,j,k,l,m){d=d|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;l=l|0;m=m|0;var n=0,o=0,p=0;n=i;c[g>>2]=d;c[k>>2]=h;do{if((m&2|0)!=0){if((j-h|0)<3){p=1;i=n;return p|0}else{c[k>>2]=h+1;a[h>>0]=-17;p=c[k>>2]|0;c[k>>2]=p+1;a[p>>0]=-69;p=c[k>>2]|0;c[k>>2]=p+1;a[p>>0]=-65;break}}}while(0);h=f;o=c[g>>2]|0;if(!(o>>>0<f>>>0)){p=0;i=n;return p|0}a:while(1){d=b[o>>1]|0;m=d&65535;if(m>>>0>l>>>0){l=2;f=26;break}do{if((d&65535)<128){m=c[k>>2]|0;if((j-m|0)<1){l=1;f=26;break a}c[k>>2]=m+1;a[m>>0]=d}else{if((d&65535)<2048){d=c[k>>2]|0;if((j-d|0)<2){l=1;f=26;break a}c[k>>2]=d+1;a[d>>0]=m>>>6|192;p=c[k>>2]|0;c[k>>2]=p+1;a[p>>0]=m&63|128;break}if((d&65535)<55296){d=c[k>>2]|0;if((j-d|0)<3){l=1;f=26;break a}c[k>>2]=d+1;a[d>>0]=m>>>12|224;p=c[k>>2]|0;c[k>>2]=p+1;a[p>>0]=m>>>6&63|128;p=c[k>>2]|0;c[k>>2]=p+1;a[p>>0]=m&63|128;break}if(!((d&65535)<56320)){if((d&65535)<57344){l=2;f=26;break a}d=c[k>>2]|0;if((j-d|0)<3){l=1;f=26;break a}c[k>>2]=d+1;a[d>>0]=m>>>12|224;p=c[k>>2]|0;c[k>>2]=p+1;a[p>>0]=m>>>6&63|128;p=c[k>>2]|0;c[k>>2]=p+1;a[p>>0]=m&63|128;break}if((h-o|0)<4){l=1;f=26;break a}p=o+2|0;d=e[p>>1]|0;if((d&64512|0)!=56320){l=2;f=26;break a}if((j-(c[k>>2]|0)|0)<4){l=1;f=26;break a}o=m&960;if(((o<<10)+65536|m<<10&64512|d&1023)>>>0>l>>>0){l=2;f=26;break a}c[g>>2]=p;o=(o>>>6)+1|0;p=c[k>>2]|0;c[k>>2]=p+1;a[p>>0]=o>>>2|240;p=c[k>>2]|0;c[k>>2]=p+1;a[p>>0]=m>>>2&15|o<<4&48|128;p=c[k>>2]|0;c[k>>2]=p+1;a[p>>0]=m<<4&48|d>>>6&15|128;p=c[k>>2]|0;c[k>>2]=p+1;a[p>>0]=d&63|128}}while(0);o=(c[g>>2]|0)+2|0;c[g>>2]=o;if(!(o>>>0<f>>>0)){l=0;f=26;break}}if((f|0)==26){i=n;return l|0}return 0}function tt(a,b,d,e,f,g,h,j){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0,l=0;a=i;i=i+16|0;l=a+4|0;k=a;c[l>>2]=d;c[k>>2]=g;b=ut(d,e,l,g,h,k,1114111,0)|0;c[f>>2]=d+((c[l>>2]|0)-d);c[j>>2]=g+((c[k>>2]|0)-g>>1<<1);i=a;return b|0}function ut(e,f,g,h,j,k,l,m){e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;l=l|0;m=m|0;var n=0,o=0,p=0,q=0,r=0,s=0;n=i;c[g>>2]=e;c[k>>2]=h;p=c[g>>2]|0;if(((((m&4|0)!=0?(f-p|0)>2:0)?(a[p>>0]|0)==-17:0)?(a[p+1>>0]|0)==-69:0)?(a[p+2>>0]|0)==-65:0){p=p+3|0;c[g>>2]=p}a:do{if(p>>>0<f>>>0){e=f;h=j;m=c[k>>2]|0;b:while(1){if(!(m>>>0<j>>>0)){break a}q=a[p>>0]|0;o=q&255;if(o>>>0>l>>>0){f=2;g=41;break}do{if(q<<24>>24>-1){b[m>>1]=q&255;c[g>>2]=p+1}else{if((q&255)<194){f=2;g=41;break b}if((q&255)<224){if((e-p|0)<2){f=1;g=41;break b}q=d[p+1>>0]|0;if((q&192|0)!=128){f=2;g=41;break b}o=q&63|o<<6&1984;if(o>>>0>l>>>0){f=2;g=41;break b}b[m>>1]=o;c[g>>2]=p+2;break}if((q&255)<240){if((e-p|0)<3){f=1;g=41;break b}q=a[p+1>>0]|0;r=a[p+2>>0]|0;if((o|0)==237){if(!((q&-32)<<24>>24==-128)){f=2;g=41;break b}}else if((o|0)==224){if(!((q&-32)<<24>>24==-96)){f=2;g=41;break b}}else{if(!((q&-64)<<24>>24==-128)){f=2;g=41;break b}}r=r&255;if((r&192|0)!=128){f=2;g=41;break b}o=(q&255)<<6&4032|o<<12|r&63;if((o&65535)>>>0>l>>>0){f=2;g=41;break b}b[m>>1]=o;c[g>>2]=p+3;break}if(!((q&255)<245)){f=2;g=41;break b}if((e-p|0)<4){f=1;g=41;break b}q=a[p+1>>0]|0;r=a[p+2>>0]|0;s=a[p+3>>0]|0;if((o|0)==240){if(!((q+112<<24>>24&255)<48)){f=2;g=41;break b}}else if((o|0)==244){if(!((q&-16)<<24>>24==-128)){f=2;g=41;break b}}else{if(!((q&-64)<<24>>24==-128)){f=2;g=41;break b}}p=r&255;if((p&192|0)!=128){f=2;g=41;break b}r=s&255;if((r&192|0)!=128){f=2;g=41;break b}if((h-m|0)<4){f=1;g=41;break b}o=o&7;s=q&255;q=p<<6;r=r&63;if((s<<12&258048|o<<18|q&4032|r)>>>0>l>>>0){f=2;g=41;break b}b[m>>1]=s<<2&60|p>>>4&3|((s>>>4&3|o<<2)<<6)+16320|55296;s=m+2|0;c[k>>2]=s;b[s>>1]=r|q&960|56320;c[g>>2]=(c[g>>2]|0)+4}}while(0);m=(c[k>>2]|0)+2|0;c[k>>2]=m;p=c[g>>2]|0;if(!(p>>>0<f>>>0)){break a}}if((g|0)==41){i=n;return f|0}}}while(0);s=p>>>0<f>>>0&1;i=n;return s|0}function vt(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;c[f>>2]=d;return 3}function wt(a){a=a|0;return 0}function xt(a){a=a|0;return 0}function yt(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;a=i;b=zt(c,d,e,1114111,0)|0;i=a;return b|0}function zt(b,c,e,f,g){b=b|0;c=c|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;h=i;if((((g&4|0)!=0?(c-b|0)>2:0)?(a[b>>0]|0)==-17:0)?(a[b+1>>0]|0)==-69:0){k=(a[b+2>>0]|0)==-65?b+3|0:b}else{k=b}a:do{if(k>>>0<c>>>0&(e|0)!=0){g=c;j=0;b:while(1){m=a[k>>0]|0;l=m&255;if(l>>>0>f>>>0){break a}do{if(m<<24>>24>-1){k=k+1|0}else{if((m&255)<194){break a}if((m&255)<224){if((g-k|0)<2){break a}m=d[k+1>>0]|0;if((m&192|0)!=128){break a}if((m&63|l<<6&1984)>>>0>f>>>0){break a}k=k+2|0;break}if((m&255)<240){n=k;if((g-n|0)<3){break a}m=a[k+1>>0]|0;o=a[k+2>>0]|0;if((l|0)==224){if(!((m&-32)<<24>>24==-96)){f=21;break b}}else if((l|0)==237){if(!((m&-32)<<24>>24==-128)){f=23;break b}}else{if(!((m&-64)<<24>>24==-128)){f=25;break b}}n=o&255;if((n&192|0)!=128){break a}if(((m&255)<<6&4032|l<<12&61440|n&63)>>>0>f>>>0){break a}k=k+3|0;break}if(!((m&255)<245)){break a}o=k;if((g-o|0)<4){break a}if((e-j|0)>>>0<2){break a}m=a[k+1>>0]|0;p=a[k+2>>0]|0;n=a[k+3>>0]|0;if((l|0)==240){if(!((m+112<<24>>24&255)<48)){f=34;break b}}else if((l|0)==244){if(!((m&-16)<<24>>24==-128)){f=36;break b}}else{if(!((m&-64)<<24>>24==-128)){f=38;break b}}o=p&255;if((o&192|0)!=128){break a}n=n&255;if((n&192|0)!=128){break a}if(((m&255)<<12&258048|l<<18&1835008|o<<6&4032|n&63)>>>0>f>>>0){break a}k=k+4|0;j=j+1|0}}while(0);j=j+1|0;if(!(k>>>0<c>>>0&j>>>0<e>>>0)){break a}}if((f|0)==21){p=n-b|0;i=h;return p|0}else if((f|0)==23){p=n-b|0;i=h;return p|0}else if((f|0)==25){p=n-b|0;i=h;return p|0}else if((f|0)==34){p=o-b|0;i=h;return p|0}else if((f|0)==36){p=o-b|0;i=h;return p|0}else if((f|0)==38){p=o-b|0;i=h;return p|0}}}while(0);p=k-b|0;i=h;return p|0}function At(a){a=a|0;return 4}function Bt(a){a=a|0;var b=0;b=i;Hv(a);i=b;return}function Ct(a,b,d,e,f,g,h,j){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0,l=0;a=i;i=i+16|0;l=a+4|0;k=a;c[l>>2]=d;c[k>>2]=g;b=Dt(d,e,l,g,h,k,1114111,0)|0;c[f>>2]=d+((c[l>>2]|0)-d>>2<<2);c[j>>2]=g+((c[k>>2]|0)-g);i=a;return b|0}function Dt(b,d,e,f,g,h,j,k){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;var l=0;l=i;c[e>>2]=b;c[h>>2]=f;do{if((k&2|0)!=0){if((g-f|0)<3){k=1;i=l;return k|0}else{c[h>>2]=f+1;a[f>>0]=-17;k=c[h>>2]|0;c[h>>2]=k+1;a[k>>0]=-69;k=c[h>>2]|0;c[h>>2]=k+1;a[k>>0]=-65;break}}}while(0);b=c[e>>2]|0;if(!(b>>>0<d>>>0)){k=0;i=l;return k|0}a:while(1){b=c[b>>2]|0;if((b&-2048|0)==55296|b>>>0>j>>>0){e=2;j=19;break}do{if(!(b>>>0<128)){if(b>>>0<2048){f=c[h>>2]|0;if((g-f|0)<2){e=1;j=19;break a}c[h>>2]=f+1;a[f>>0]=b>>>6|192;k=c[h>>2]|0;c[h>>2]=k+1;a[k>>0]=b&63|128;break}k=c[h>>2]|0;f=g-k|0;if(b>>>0<65536){if((f|0)<3){e=1;j=19;break a}c[h>>2]=k+1;a[k>>0]=b>>>12|224;k=c[h>>2]|0;c[h>>2]=k+1;a[k>>0]=b>>>6&63|128;k=c[h>>2]|0;c[h>>2]=k+1;a[k>>0]=b&63|128;break}else{if((f|0)<4){e=1;j=19;break a}c[h>>2]=k+1;a[k>>0]=b>>>18|240;k=c[h>>2]|0;c[h>>2]=k+1;a[k>>0]=b>>>12&63|128;k=c[h>>2]|0;c[h>>2]=k+1;a[k>>0]=b>>>6&63|128;k=c[h>>2]|0;c[h>>2]=k+1;a[k>>0]=b&63|128;break}}else{f=c[h>>2]|0;if((g-f|0)<1){e=1;j=19;break a}c[h>>2]=f+1;a[f>>0]=b}}while(0);b=(c[e>>2]|0)+4|0;c[e>>2]=b;if(!(b>>>0<d>>>0)){e=0;j=19;break}}if((j|0)==19){i=l;return e|0}return 0}function Et(a,b,d,e,f,g,h,j){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0,l=0;a=i;i=i+16|0;l=a+4|0;k=a;c[l>>2]=d;c[k>>2]=g;b=Ft(d,e,l,g,h,k,1114111,0)|0;c[f>>2]=d+((c[l>>2]|0)-d);c[j>>2]=g+((c[k>>2]|0)-g>>2<<2);i=a;return b|0}function Ft(b,e,f,g,h,j,k,l){b=b|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;l=l|0;var m=0,n=0,o=0,p=0,q=0,r=0;n=i;c[f>>2]=b;c[j>>2]=g;g=c[f>>2]|0;if(((((l&4|0)!=0?(e-g|0)>2:0)?(a[g>>0]|0)==-17:0)?(a[g+1>>0]|0)==-69:0)?(a[g+2>>0]|0)==-65:0){g=g+3|0;c[f>>2]=g}a:do{if(g>>>0<e>>>0){b=e;l=c[j>>2]|0;while(1){if(!(l>>>0<h>>>0)){m=39;break a}p=a[g>>0]|0;o=p&255;do{if(p<<24>>24>-1){if(o>>>0>k>>>0){e=2;break a}c[l>>2]=o;c[f>>2]=g+1}else{if((p&255)<194){e=2;break a}if((p&255)<224){if((b-g|0)<2){e=1;break a}p=d[g+1>>0]|0;if((p&192|0)!=128){e=2;break a}o=p&63|o<<6&1984;if(o>>>0>k>>>0){e=2;break a}c[l>>2]=o;c[f>>2]=g+2;break}if((p&255)<240){if((b-g|0)<3){e=1;break a}p=a[g+1>>0]|0;q=a[g+2>>0]|0;if((o|0)==224){if(!((p&-32)<<24>>24==-96)){e=2;break a}}else if((o|0)==237){if(!((p&-32)<<24>>24==-128)){e=2;break a}}else{if(!((p&-64)<<24>>24==-128)){e=2;break a}}q=q&255;if((q&192|0)!=128){e=2;break a}o=(p&255)<<6&4032|o<<12&61440|q&63;if(o>>>0>k>>>0){e=2;break a}c[l>>2]=o;c[f>>2]=g+3;break}if(!((p&255)<245)){e=2;break a}if((b-g|0)<4){e=1;break a}p=a[g+1>>0]|0;r=a[g+2>>0]|0;q=a[g+3>>0]|0;if((o|0)==240){if(!((p+112<<24>>24&255)<48)){e=2;break a}}else if((o|0)==244){if(!((p&-16)<<24>>24==-128)){e=2;break a}}else{if(!((p&-64)<<24>>24==-128)){e=2;break a}}r=r&255;if((r&192|0)!=128){e=2;break a}q=q&255;if((q&192|0)!=128){e=2;break a}o=(p&255)<<12&258048|o<<18&1835008|r<<6&4032|q&63;if(o>>>0>k>>>0){e=2;break a}c[l>>2]=o;c[f>>2]=g+4}}while(0);l=(c[j>>2]|0)+4|0;c[j>>2]=l;g=c[f>>2]|0;if(!(g>>>0<e>>>0)){m=39;break}}}else{m=39}}while(0);if((m|0)==39){e=g>>>0<e>>>0&1}i=n;return e|0}function Gt(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;c[f>>2]=d;return 3}function Ht(a){a=a|0;return 0}function It(a){a=a|0;return 0}function Jt(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;a=i;b=Kt(c,d,e,1114111,0)|0;i=a;return b|0}function Kt(b,c,e,f,g){b=b|0;c=c|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;h=i;if((((g&4|0)!=0?(c-b|0)>2:0)?(a[b>>0]|0)==-17:0)?(a[b+1>>0]|0)==-69:0){k=(a[b+2>>0]|0)==-65?b+3|0:b}else{k=b}a:do{if(k>>>0<c>>>0&(e|0)!=0){g=c;j=1;b:while(1){m=a[k>>0]|0;l=m&255;do{if(m<<24>>24>-1){if(l>>>0>f>>>0){break a}k=k+1|0}else{if((m&255)<194){break a}if((m&255)<224){if((g-k|0)<2){break a}m=d[k+1>>0]|0;if((m&192|0)!=128){break a}if((m&63|l<<6&1984)>>>0>f>>>0){break a}k=k+2|0;break}if((m&255)<240){m=k;if((g-m|0)<3){break a}n=a[k+1>>0]|0;o=a[k+2>>0]|0;if((l|0)==237){if(!((n&-32)<<24>>24==-128)){f=23;break b}}else if((l|0)==224){if(!((n&-32)<<24>>24==-96)){f=21;break b}}else{if(!((n&-64)<<24>>24==-128)){f=25;break b}}m=o&255;if((m&192|0)!=128){break a}if(((n&255)<<6&4032|l<<12&61440|m&63)>>>0>f>>>0){break a}k=k+3|0;break}if(!((m&255)<245)){break a}o=k;if((g-o|0)<4){break a}m=a[k+1>>0]|0;p=a[k+2>>0]|0;n=a[k+3>>0]|0;if((l|0)==244){if(!((m&-16)<<24>>24==-128)){f=35;break b}}else if((l|0)==240){if(!((m+112<<24>>24&255)<48)){f=33;break b}}else{if(!((m&-64)<<24>>24==-128)){f=37;break b}}o=p&255;if((o&192|0)!=128){break a}n=n&255;if((n&192|0)!=128){break a}if(((m&255)<<12&258048|l<<18&1835008|o<<6&4032|n&63)>>>0>f>>>0){break a}k=k+4|0}}while(0);if(!(k>>>0<c>>>0&j>>>0<e>>>0)){break a}j=j+1|0}if((f|0)==21){p=m-b|0;i=h;return p|0}else if((f|0)==23){p=m-b|0;i=h;return p|0}else if((f|0)==25){p=m-b|0;i=h;return p|0}else if((f|0)==33){p=o-b|0;i=h;return p|0}else if((f|0)==35){p=o-b|0;i=h;return p|0}else if((f|0)==37){p=o-b|0;i=h;return p|0}}}while(0);p=k-b|0;i=h;return p|0}function Lt(a){a=a|0;return 4}function Mt(a){a=a|0;var b=0;b=i;Hv(a);i=b;return}function Nt(a){a=a|0;var b=0;b=i;Hv(a);i=b;return}function Ot(a){a=a|0;var b=0;b=i;c[a>>2]=16520;Rm(a+12|0);Hv(a);i=b;return}function Pt(a){a=a|0;var b=0;b=i;c[a>>2]=16520;Rm(a+12|0);i=b;return}function Qt(a){a=a|0;var b=0;b=i;c[a>>2]=16560;Rm(a+16|0);Hv(a);i=b;return}function Rt(a){a=a|0;var b=0;b=i;c[a>>2]=16560;Rm(a+16|0);i=b;return}function St(b){b=b|0;return a[b+8>>0]|0}function Tt(a){a=a|0;return c[a+8>>2]|0}function Ut(b){b=b|0;return a[b+9>>0]|0}function Vt(a){a=a|0;return c[a+12>>2]|0}function Wt(a,b){a=a|0;b=b|0;var c=0;c=i;Om(a,b+12|0);i=c;return}function Xt(a,b){a=a|0;b=b|0;var c=0;c=i;Om(a,b+16|0);i=c;return}function Yt(a,b){a=a|0;b=b|0;b=i;Pm(a,16592,4);i=b;return}function Zt(a,b){a=a|0;b=b|0;b=i;$m(a,16600,Yu(16600)|0);i=b;return}function _t(a,b){a=a|0;b=b|0;b=i;Pm(a,16624,5);i=b;return}function $t(a,b){a=a|0;b=b|0;b=i;$m(a,16632,Yu(16632)|0);i=b;return}function au(b){b=b|0;var d=0;b=i;if((a[16664]|0)!=0){d=c[4164]|0;i=b;return d|0}if((Ua(16664)|0)==0){d=c[4164]|0;i=b;return d|0}if((a[23864]|0)==0?(Ua(23864)|0)!=0:0){ww(23696,0,168)|0;jb(210,0,q|0)|0;rb(23864)}u=0;Ha(41,23696,23872)|0;d=u;u=0;if(((((((((((((!(d&1)?(u=0,Ha(41,23708|0,23880)|0,d=u,u=0,!(d&1)):0)?(u=0,Ha(41,23720|0,23888)|0,d=u,u=0,!(d&1)):0)?(u=0,Ha(41,23732|0,23896)|0,d=u,u=0,!(d&1)):0)?(u=0,Ha(41,23744|0,23912)|0,d=u,u=0,!(d&1)):0)?(u=0,Ha(41,23756|0,23928)|0,d=u,u=0,!(d&1)):0)?(u=0,Ha(41,23768|0,23936)|0,d=u,u=0,!(d&1)):0)?(u=0,Ha(41,23780|0,23952)|0,d=u,u=0,!(d&1)):0)?(u=0,Ha(41,23792|0,23960)|0,d=u,u=0,!(d&1)):0)?(u=0,Ha(41,23804|0,23968)|0,d=u,u=0,!(d&1)):0)?(u=0,Ha(41,23816|0,23976)|0,d=u,u=0,!(d&1)):0)?(u=0,Ha(41,23828|0,23984)|0,d=u,u=0,!(d&1)):0)?(u=0,Ha(41,23840|0,23992)|0,d=u,u=0,!(d&1)):0)?(u=0,Ha(41,23852|0,24e3)|0,d=u,u=0,!(d&1)):0){c[4164]=23696;rb(16664);d=c[4164]|0;i=b;return d|0}d=qb(-1,-1)|0;Eb(16664);vb(d|0);return 0}function bu(b){b=b|0;var d=0;b=i;if((a[16680]|0)!=0){d=c[4168]|0;i=b;return d|0}if((Ua(16680)|0)==0){d=c[4168]|0;i=b;return d|0}if((a[23328]|0)==0?(Ua(23328)|0)!=0:0){ww(23160,0,168)|0;jb(211,0,q|0)|0;rb(23328)}u=0;Ha(42,23160,23336)|0;d=u;u=0;if(((((((((((((!(d&1)?(u=0,Ha(42,23172|0,23368)|0,d=u,u=0,!(d&1)):0)?(u=0,Ha(42,23184|0,23400)|0,d=u,u=0,!(d&1)):0)?(u=0,Ha(42,23196|0,23432)|0,d=u,u=0,!(d&1)):0)?(u=0,Ha(42,23208|0,23472)|0,d=u,u=0,!(d&1)):0)?(u=0,Ha(42,23220|0,23512)|0,d=u,u=0,!(d&1)):0)?(u=0,Ha(42,23232|0,23544)|0,d=u,u=0,!(d&1)):0)?(u=0,Ha(42,23244|0,23584)|0,d=u,u=0,!(d&1)):0)?(u=0,Ha(42,23256|0,23600)|0,d=u,u=0,!(d&1)):0)?(u=0,Ha(42,23268|0,23616)|0,d=u,u=0,!(d&1)):0)?(u=0,Ha(42,23280|0,23632)|0,d=u,u=0,!(d&1)):0)?(u=0,Ha(42,23292|0,23648)|0,d=u,u=0,!(d&1)):0)?(u=0,Ha(42,23304|0,23664)|0,d=u,u=0,!(d&1)):0)?(u=0,Ha(42,23316|0,23680)|0,d=u,u=0,!(d&1)):0){c[4168]=23160;rb(16680);d=c[4168]|0;i=b;return d|0}d=qb(-1,-1)|0;Eb(16680);vb(d|0);return 0}function cu(b){b=b|0;var d=0;b=i;if((a[16696]|0)!=0){d=c[4172]|0;i=b;return d|0}if((Ua(16696)|0)==0){d=c[4172]|0;i=b;return d|0}if((a[22936]|0)==0?(Ua(22936)|0)!=0:0){ww(22648,0,288)|0;jb(212,0,q|0)|0;rb(22936)}u=0;Ha(41,22648,22944)|0;d=u;u=0;do{if(((((((((((((((!(d&1)?(u=0,Ha(41,22660|0,22952)|0,d=u,u=0,!(d&1)):0)?(u=0,Ha(41,22672|0,22968)|0,d=u,u=0,!(d&1)):0)?(u=0,Ha(41,22684|0,22976)|0,d=u,u=0,!(d&1)):0)?(u=0,Ha(41,22696|0,22984)|0,d=u,u=0,!(d&1)):0)?(u=0,Ha(41,22708|0,22992)|0,d=u,u=0,!(d&1)):0)?(u=0,Ha(41,22720|0,23e3)|0,d=u,u=0,!(d&1)):0)?(u=0,Ha(41,22732|0,23008)|0,d=u,u=0,!(d&1)):0)?(u=0,Ha(41,22744|0,23016)|0,d=u,u=0,!(d&1)):0)?(u=0,Ha(41,22756|0,23032)|0,d=u,u=0,!(d&1)):0)?(u=0,Ha(41,22768|0,23040)|0,d=u,u=0,!(d&1)):0)?(u=0,Ha(41,22780|0,23056)|0,d=u,u=0,!(d&1)):0)?(u=0,Ha(41,22792|0,23072)|0,d=u,u=0,!(d&1)):0)?(u=0,Ha(41,22804|0,23080)|0,d=u,u=0,!(d&1)):0)?(u=0,Ha(41,22816|0,23088)|0,d=u,u=0,!(d&1)):0)?(u=0,Ha(41,22828|0,23096)|0,d=u,u=0,!(d&1)):0){u=0;Ha(41,22840|0,22984)|0;d=u;u=0;if(d&1){break}u=0;Ha(41,22852|0,23104)|0;d=u;u=0;if(d&1){break}u=0;Ha(41,22864|0,23112)|0;d=u;u=0;if(d&1){break}u=0;Ha(41,22876|0,23120)|0;d=u;u=0;if(d&1){break}u=0;Ha(41,22888|0,23128)|0;d=u;u=0;if(d&1){break}u=0;Ha(41,22900|0,23136)|0;d=u;u=0;if(d&1){break}u=0;Ha(41,22912|0,23144)|0;d=u;u=0;if(d&1){break}u=0;Ha(41,22924|0,23152)|0;d=u;u=0;if(d&1){break}c[4172]=22648;rb(16696);d=c[4172]|0;i=b;return d|0}}while(0);d=qb(-1,-1)|0;Eb(16696);vb(d|0);return 0}function du(b){b=b|0;var d=0;b=i;if((a[16712]|0)!=0){d=c[4176]|0;i=b;return d|0}if((Ua(16712)|0)==0){d=c[4176]|0;i=b;return d|0}if((a[22096]|0)==0?(Ua(22096)|0)!=0:0){ww(21808,0,288)|0;jb(213,0,q|0)|0;rb(22096)}u=0;Ha(42,21808,22104)|0;d=u;u=0;do{if(((((((((((((((!(d&1)?(u=0,Ha(42,21820|0,22136)|0,d=u,u=0,!(d&1)):0)?(u=0,Ha(42,21832|0,22176)|0,d=u,u=0,!(d&1)):0)?(u=0,Ha(42,21844|0,22200)|0,d=u,u=0,!(d&1)):0)?(u=0,Ha(42,21856|0,22520)|0,d=u,u=0,!(d&1)):0)?(u=0,Ha(42,21868|0,22224)|0,d=u,u=0,!(d&1)):0)?(u=0,Ha(42,21880|0,22248)|0,d=u,u=0,!(d&1)):0)?(u=0,Ha(42,21892|0,22272)|0,d=u,u=0,!(d&1)):0)?(u=0,Ha(42,21904|0,22304)|0,d=u,u=0,!(d&1)):0)?(u=0,Ha(42,21916|0,22344)|0,d=u,u=0,!(d&1)):0)?(u=0,Ha(42,21928|0,22376)|0,d=u,u=0,!(d&1)):0)?(u=0,Ha(42,21940|0,22416)|0,d=u,u=0,!(d&1)):0)?(u=0,Ha(42,21952|0,22456)|0,d=u,u=0,!(d&1)):0)?(u=0,Ha(42,21964|0,22472)|0,d=u,u=0,!(d&1)):0)?(u=0,Ha(42,21976|0,22488)|0,d=u,u=0,!(d&1)):0)?(u=0,Ha(42,21988|0,22504)|0,d=u,u=0,!(d&1)):0){u=0;Ha(42,22e3|0,22520)|0;d=u;u=0;if(d&1){break}u=0;Ha(42,22012|0,22536)|0;d=u;u=0;if(d&1){break}u=0;Ha(42,22024|0,22552)|0;d=u;u=0;if(d&1){break}u=0;Ha(42,22036|0,22568)|0;d=u;u=0;if(d&1){break}u=0;Ha(42,22048|0,22584)|0;d=u;u=0;if(d&1){break}u=0;Ha(42,22060|0,22600)|0;d=u;u=0;if(d&1){break}u=0;Ha(42,22072|0,22616)|0;d=u;u=0;if(d&1){break}u=0;Ha(42,22084|0,22632)|0;d=u;u=0;if(d&1){break}c[4176]=21808;rb(16712);d=c[4176]|0;i=b;return d|0}}while(0);d=qb(-1,-1)|0;Eb(16712);vb(d|0);return 0}function eu(b){b=b|0;var d=0;b=i;if((a[16728]|0)!=0){d=c[4180]|0;i=b;return d|0}if((Ua(16728)|0)==0){d=c[4180]|0;i=b;return d|0}if((a[21784]|0)==0?(Ua(21784)|0)!=0:0){ww(21496,0,288)|0;jb(214,0,q|0)|0;rb(21784)}u=0;Ha(41,21496,21792)|0;d=u;u=0;if(d&1){d=qb(-1,-1)|0;Eb(16728);vb(d|0)}u=0;Ha(41,21508|0,21800)|0;d=u;u=0;if(d&1){d=qb(-1,-1)|0;Eb(16728);vb(d|0)}c[4180]=21496;rb(16728);d=c[4180]|0;i=b;return d|0}function fu(b){b=b|0;var d=0;b=i;if((a[16744]|0)!=0){d=c[4184]|0;i=b;return d|0}if((Ua(16744)|0)==0){d=c[4184]|0;i=b;return d|0}if((a[21456]|0)==0?(Ua(21456)|0)!=0:0){ww(21168,0,288)|0;jb(215,0,q|0)|0;rb(21456)}u=0;Ha(42,21168,21464)|0;d=u;u=0;if(d&1){d=qb(-1,-1)|0;Eb(16744);vb(d|0)}u=0;Ha(42,21180|0,21480)|0;d=u;u=0;if(d&1){d=qb(-1,-1)|0;Eb(16744);vb(d|0)}c[4184]=21168;rb(16744);d=c[4184]|0;i=b;return d|0}function gu(b){b=b|0;var c=0;b=i;if((a[16768]|0)!=0){i=b;return 16752}if((Ua(16768)|0)==0){i=b;return 16752}u=0;Na(60,16752,16776,8);c=u;u=0;if(c&1){c=qb(-1,-1)|0;Eb(16768);vb(c|0)}jb(216,16752,q|0)|0;rb(16768);i=b;return 16752}function hu(b){b=b|0;var c=0,d=0;b=i;if((a[16808]|0)!=0){i=b;return 16792}if((Ua(16808)|0)==0){i=b;return 16792}u=0;c=qa(128,16816)|0;d=u;u=0;if(!(d&1)?(u=0,Na(62,16792,16816,c|0),d=u,u=0,!(d&1)):0){jb(217,16792,q|0)|0;rb(16808);i=b;return 16792}d=qb(-1,-1)|0;Eb(16808);vb(d|0);return 0}function iu(b){b=b|0;var c=0;b=i;if((a[16872]|0)!=0){i=b;return 16856}if((Ua(16872)|0)==0){i=b;return 16856}u=0;Na(60,16856,16880,8);c=u;u=0;if(c&1){c=qb(-1,-1)|0;Eb(16872);vb(c|0)}jb(216,16856,q|0)|0;rb(16872);i=b;return 16856}function ju(b){b=b|0;var c=0,d=0;b=i;if((a[16912]|0)!=0){i=b;return 16896}if((Ua(16912)|0)==0){i=b;return 16896}u=0;c=qa(128,16920)|0;d=u;u=0;if(!(d&1)?(u=0,Na(62,16896,16920,c|0),d=u,u=0,!(d&1)):0){jb(217,16896,q|0)|0;rb(16912);i=b;return 16896}d=qb(-1,-1)|0;Eb(16912);vb(d|0);return 0}function ku(b){b=b|0;var c=0;b=i;if((a[16976]|0)!=0){i=b;return 16960}if((Ua(16976)|0)==0){i=b;return 16960}u=0;Na(60,16960,16984,20);c=u;u=0;if(c&1){c=qb(-1,-1)|0;Eb(16976);vb(c|0)}jb(216,16960,q|0)|0;rb(16976);i=b;return 16960}function lu(b){b=b|0;var c=0,d=0;b=i;if((a[17024]|0)!=0){i=b;return 17008}if((Ua(17024)|0)==0){i=b;return 17008}u=0;c=qa(128,17032)|0;d=u;u=0;if(!(d&1)?(u=0,Na(62,17008,17032,c|0),d=u,u=0,!(d&1)):0){jb(217,17008,q|0)|0;rb(17024);i=b;return 17008}d=qb(-1,-1)|0;Eb(17024);vb(d|0);return 0}function mu(b){b=b|0;var c=0;b=i;if((a[17136]|0)!=0){i=b;return 17120}if((Ua(17136)|0)==0){i=b;return 17120}u=0;Na(60,17120,17144,11);c=u;u=0;if(c&1){c=qb(-1,-1)|0;Eb(17136);vb(c|0)}jb(216,17120,q|0)|0;rb(17136);i=b;return 17120}function nu(b){b=b|0;var c=0,d=0;b=i;if((a[17176]|0)!=0){i=b;return 17160}if((Ua(17176)|0)==0){i=b;return 17160}u=0;c=qa(128,17184)|0;d=u;u=0;if(!(d&1)?(u=0,Na(62,17160,17184,c|0),d=u,u=0,!(d&1)):0){jb(217,17160,q|0)|0;rb(17176);i=b;return 17160}d=qb(-1,-1)|0;Eb(17176);vb(d|0);return 0}function ou(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0.0,l=0,m=0;f=i;i=i+16|0;g=f;if((b|0)==(d|0)){c[e>>2]=4;k=0.0;i=f;return+k}j=nc()|0;h=c[j>>2]|0;c[j>>2]=0;do{if((a[16248]|0)==0?(Ua(16248)|0)!=0:0){u=0;l=ua(33,2147483647,16256,0)|0;m=u;u=0;if(m&1){m=qb(-1,-1)|0;Eb(16248);vb(m|0)}else{c[4060]=l;rb(16248);break}}}while(0);k=+gw(b,g,c[4060]|0);b=c[j>>2]|0;if((b|0)==0){c[j>>2]=h}if((c[g>>2]|0)!=(d|0)){c[e>>2]=4;k=0.0;i=f;return+k}if((b|0)!=34){i=f;return+k}c[e>>2]=4;i=f;return+k}function pu(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0.0,l=0,m=0;f=i;i=i+16|0;g=f;if((b|0)==(d|0)){c[e>>2]=4;k=0.0;i=f;return+k}j=nc()|0;h=c[j>>2]|0;c[j>>2]=0;do{if((a[16248]|0)==0?(Ua(16248)|0)!=0:0){u=0;l=ua(33,2147483647,16256,0)|0;m=u;u=0;if(m&1){m=qb(-1,-1)|0;Eb(16248);vb(m|0)}else{c[4060]=l;rb(16248);break}}}while(0);k=+gw(b,g,c[4060]|0);b=c[j>>2]|0;if((b|0)==0){c[j>>2]=h}if((c[g>>2]|0)!=(d|0)){c[e>>2]=4;k=0.0;i=f;return+k}if((b|0)!=34){i=f;return+k}c[e>>2]=4;i=f;return+k}function qu(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0.0,l=0,m=0;f=i;i=i+16|0;g=f;if((b|0)==(d|0)){c[e>>2]=4;k=0.0;i=f;return+k}j=nc()|0;h=c[j>>2]|0;c[j>>2]=0;do{if((a[16248]|0)==0?(Ua(16248)|0)!=0:0){u=0;l=ua(33,2147483647,16256,0)|0;m=u;u=0;if(m&1){m=qb(-1,-1)|0;Eb(16248);vb(m|0)}else{c[4060]=l;rb(16248);break}}}while(0);k=+gw(b,g,c[4060]|0);b=c[j>>2]|0;if((b|0)==0){c[j>>2]=h}if((c[g>>2]|0)!=(d|0)){c[e>>2]=4;k=0.0;i=f;return+k}if((b|0)==34){c[e>>2]=4}i=f;return+k}function ru(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0;k=i;i=i+16|0;h=k;if((b|0)==(d|0)){c[e>>2]=4;b=0;l=0;J=b;i=k;return l|0}if((a[b>>0]|0)==45){c[e>>2]=4;b=0;l=0;J=b;i=k;return l|0}j=nc()|0;g=c[j>>2]|0;c[j>>2]=0;do{if((a[16248]|0)==0?(Ua(16248)|0)!=0:0){u=0;l=ua(33,2147483647,16256,0)|0;m=u;u=0;if(m&1){m=qb(-1,-1)|0;Eb(16248);vb(m|0)}else{c[4060]=l;rb(16248);break}}}while(0);b=Fu(b,h,f,c[4060]|0)|0;f=J;l=c[j>>2]|0;if((l|0)==0){c[j>>2]=g}if((c[h>>2]|0)!=(d|0)){c[e>>2]=4;l=0;m=0;J=l;i=k;return m|0}if((l|0)!=34){l=f;m=b;J=l;i=k;return m|0}c[e>>2]=4;l=-1;m=-1;J=l;i=k;return m|0}function su(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0;k=i;i=i+16|0;h=k;if((b|0)==(d|0)){c[e>>2]=4;l=0;i=k;return l|0}if((a[b>>0]|0)==45){c[e>>2]=4;l=0;i=k;return l|0}j=nc()|0;g=c[j>>2]|0;c[j>>2]=0;do{if((a[16248]|0)==0?(Ua(16248)|0)!=0:0){u=0;l=ua(33,2147483647,16256,0)|0;m=u;u=0;if(m&1){m=qb(-1,-1)|0;Eb(16248);vb(m|0)}else{c[4060]=l;rb(16248);break}}}while(0);l=Fu(b,h,f,c[4060]|0)|0;b=J;f=c[j>>2]|0;if((f|0)==0){c[j>>2]=g}if((c[h>>2]|0)!=(d|0)){c[e>>2]=4;m=0;i=k;return m|0}if((f|0)==34|(b>>>0>0|(b|0)==0&l>>>0>4294967295)){c[e>>2]=4;m=-1;i=k;return m|0}else{m=l;i=k;return m|0}return 0}function tu(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0;k=i;i=i+16|0;h=k;if((b|0)==(d|0)){c[e>>2]=4;l=0;i=k;return l|0}if((a[b>>0]|0)==45){c[e>>2]=4;l=0;i=k;return l|0}j=nc()|0;g=c[j>>2]|0;c[j>>2]=0;do{if((a[16248]|0)==0?(Ua(16248)|0)!=0:0){u=0;l=ua(33,2147483647,16256,0)|0;m=u;u=0;if(m&1){m=qb(-1,-1)|0;Eb(16248);vb(m|0)}else{c[4060]=l;rb(16248);break}}}while(0);l=Fu(b,h,f,c[4060]|0)|0;b=J;f=c[j>>2]|0;if((f|0)==0){c[j>>2]=g}if((c[h>>2]|0)!=(d|0)){c[e>>2]=4;m=0;i=k;return m|0}if((f|0)==34|(b>>>0>0|(b|0)==0&l>>>0>4294967295)){c[e>>2]=4;m=-1;i=k;return m|0}else{m=l;i=k;return m|0}return 0}function uu(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0;k=i;i=i+16|0;h=k;if((b|0)==(d|0)){c[e>>2]=4;l=0;i=k;return l|0}if((a[b>>0]|0)==45){c[e>>2]=4;l=0;i=k;return l|0}j=nc()|0;g=c[j>>2]|0;c[j>>2]=0;do{if((a[16248]|0)==0?(Ua(16248)|0)!=0:0){u=0;l=ua(33,2147483647,16256,0)|0;m=u;u=0;if(m&1){m=qb(-1,-1)|0;Eb(16248);vb(m|0)}else{c[4060]=l;rb(16248);break}}}while(0);l=Fu(b,h,f,c[4060]|0)|0;b=J;f=c[j>>2]|0;if((f|0)==0){c[j>>2]=g}if((c[h>>2]|0)!=(d|0)){c[e>>2]=4;m=0;i=k;return m|0}if((f|0)==34|(b>>>0>0|(b|0)==0&l>>>0>65535)){c[e>>2]=4;m=-1;i=k;return m|0}else{m=l&65535;i=k;return m|0}return 0}function vu(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0;k=i;i=i+16|0;h=k;if((b|0)==(d|0)){c[e>>2]=4;b=0;l=0;J=b;i=k;return l|0}j=nc()|0;g=c[j>>2]|0;c[j>>2]=0;do{if((a[16248]|0)==0?(Ua(16248)|0)!=0:0){u=0;l=ua(33,2147483647,16256,0)|0;m=u;u=0;if(m&1){m=qb(-1,-1)|0;Eb(16248);vb(m|0)}else{c[4060]=l;rb(16248);break}}}while(0);b=Gu(b,h,f,c[4060]|0)|0;f=J;l=c[j>>2]|0;if((l|0)==0){c[j>>2]=g}if((c[h>>2]|0)!=(d|0)){c[e>>2]=4;l=0;m=0;J=l;i=k;return m|0}if((l|0)==34){c[e>>2]=4;m=(f|0)>0|(f|0)==0&b>>>0>0;J=m?2147483647:-2147483648;i=k;return(m?-1:0)|0}else{l=f;m=b;J=l;i=k;return m|0}return 0}function wu(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0;k=i;i=i+16|0;h=k;if((b|0)==(d|0)){c[e>>2]=4;l=0;i=k;return l|0}j=nc()|0;g=c[j>>2]|0;c[j>>2]=0;do{if((a[16248]|0)==0?(Ua(16248)|0)!=0:0){u=0;l=ua(33,2147483647,16256,0)|0;m=u;u=0;if(m&1){m=qb(-1,-1)|0;Eb(16248);vb(m|0)}else{c[4060]=l;rb(16248);break}}}while(0);b=Gu(b,h,f,c[4060]|0)|0;f=J;l=c[j>>2]|0;if((l|0)==0){c[j>>2]=g}if((c[h>>2]|0)!=(d|0)){c[e>>2]=4;m=0;i=k;return m|0}do{if((l|0)==34){c[e>>2]=4;if((f|0)>0|(f|0)==0&b>>>0>0){m=2147483647;i=k;return m|0}}else{if((f|0)<-1|(f|0)==-1&b>>>0<2147483648){c[e>>2]=4;break}if((f|0)>0|(f|0)==0&b>>>0>2147483647){c[e>>2]=4;m=2147483647;i=k;return m|0}else{m=b;i=k;return m|0}}}while(0);m=-2147483648;i=k;return m|0}function xu(a){a=a|0;var b=0,e=0,f=0;b=i;f=a+4|0;e=d[f>>0]|d[f+1>>0]<<8|d[f+2>>0]<<16|d[f+3>>0]<<24;f=f+4|0;f=d[f>>0]|d[f+1>>0]<<8|d[f+2>>0]<<16|d[f+3>>0]<<24;a=(c[a>>2]|0)+(f>>1)|0;if((f&1|0)==0){f=e;yc[f&255](a);i=b;return}else{f=c[(c[a>>2]|0)+e>>2]|0;yc[f&255](a);i=b;return}}function yu(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0;e=i;g=b+8|0;f=b+4|0;h=c[f>>2]|0;l=c[g>>2]|0;j=h;if(!(l-j>>2>>>0<d>>>0)){do{if((h|0)==0){g=0}else{c[h>>2]=0;g=c[f>>2]|0}h=g+4|0;c[f>>2]=h;d=d+ -1|0}while((d|0)!=0);i=e;return}h=b+16|0;m=c[b>>2]|0;j=j-m>>2;n=j+d|0;if(n>>>0>1073741823){ss(0)}l=l-m|0;if(l>>2>>>0<536870911){l=l>>1;l=l>>>0<n>>>0?n:l;if((l|0)!=0){m=b+128|0;if((a[m>>0]|0)==0&l>>>0<29){a[m>>0]=1;m=h}else{m=l;k=11}}else{l=0;m=0}}else{m=1073741823;k=11}if((k|0)==11){l=m;m=Fv(m<<2)|0}k=m+(j<<2)|0;do{if((k|0)==0){k=0}else{c[k>>2]=0}k=k+4|0;d=d+ -1|0}while((d|0)!=0);d=c[b>>2]|0;o=(c[f>>2]|0)-d|0;n=m+(j-(o>>2)<<2)|0;tw(n|0,d|0,o|0)|0;c[b>>2]=n;c[f>>2]=k;c[g>>2]=m+(l<<2);if((d|0)==0){i=e;return}if((h|0)==(d|0)){a[b+128>>0]=0;i=e;return}else{Hv(d);i=e;return}}function zu(a){a=a|0;a=i;bn(21444|0);bn(21432|0);bn(21420|0);bn(21408|0);bn(21396|0);bn(21384|0);bn(21372|0);bn(21360|0);bn(21348|0);bn(21336|0);bn(21324|0);bn(21312|0);bn(21300|0);bn(21288|0);bn(21276|0);bn(21264|0);bn(21252|0);bn(21240|0);bn(21228|0);bn(21216|0);bn(21204|0);bn(21192|0);bn(21180|0);bn(21168);i=a;return}function Au(a){a=a|0;a=i;Rm(21772|0);Rm(21760|0);Rm(21748|0);Rm(21736|0);Rm(21724|0);Rm(21712|0);Rm(21700|0);Rm(21688|0);Rm(21676|0);Rm(21664|0);Rm(21652|0);Rm(21640|0);Rm(21628|0);Rm(21616|0);Rm(21604|0);Rm(21592|0);Rm(21580|0);Rm(21568|0);Rm(21556|0);Rm(21544|0);Rm(21532|0);Rm(21520|0);Rm(21508|0);Rm(21496);i=a;return}function Bu(a){a=a|0;a=i;bn(22084|0);bn(22072|0);bn(22060|0);bn(22048|0);bn(22036|0);bn(22024|0);bn(22012|0);bn(22e3|0);bn(21988|0);bn(21976|0);bn(21964|0);bn(21952|0);bn(21940|0);bn(21928|0);bn(21916|0);bn(21904|0);bn(21892|0);bn(21880|0);bn(21868|0);bn(21856|0);bn(21844|0);bn(21832|0);bn(21820|0);bn(21808);i=a;return}function Cu(a){a=a|0;a=i;Rm(22924|0);Rm(22912|0);Rm(22900|0);Rm(22888|0);Rm(22876|0);Rm(22864|0);Rm(22852|0);Rm(22840|0);Rm(22828|0);Rm(22816|0);Rm(22804|0);Rm(22792|0);Rm(22780|0);Rm(22768|0);Rm(22756|0);Rm(22744|0);Rm(22732|0);Rm(22720|0);Rm(22708|0);Rm(22696|0);Rm(22684|0);Rm(22672|0);Rm(22660|0);Rm(22648);i=a;return}function Du(a){a=a|0;a=i;bn(23316|0);bn(23304|0);bn(23292|0);bn(23280|0);bn(23268|0);bn(23256|0);bn(23244|0);bn(23232|0);bn(23220|0);bn(23208|0);bn(23196|0);bn(23184|0);bn(23172|0);bn(23160);i=a;return}function Eu(a){a=a|0;a=i;Rm(23852|0);Rm(23840|0);Rm(23828|0);Rm(23816|0);Rm(23804|0);Rm(23792|0);Rm(23780|0);Rm(23768|0);Rm(23756|0);Rm(23744|0);Rm(23732|0);Rm(23720|0);Rm(23708|0);Rm(23696);i=a;return}function Fu(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0;e=i;d=hw(a,b,c)|0;i=e;return d|0}function Gu(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0;e=i;d=iw(a,b,c)|0;i=e;return d|0}function Hu(a){a=a|0;if((a+ -48|0)>>>0<10){a=1}else{a=((a|32)+ -97|0)>>>0<6}return a&1|0}function Iu(a,b){a=a|0;b=b|0;return(a+ -48|0)>>>0<10|0}function Ju(a,b){a=a|0;b=b|0;var c=0;c=i;b=Hu(a)|0;i=c;return b|0}function Ku(a,b,c){a=a|0;b=b|0;c=c|0;var d=0;d=i;a=Lu(0,a,b,(c|0)!=0?c:24216)|0;i=d;return a|0}function Lu(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0;g=i;i=i+16|0;h=g;c[h>>2]=b;f=(f|0)==0?24224:f;j=c[f>>2]|0;a:do{if((d|0)==0){if((j|0)==0){k=0;i=g;return k|0}}else{if((b|0)==0){c[h>>2]=h}else{h=b}if((e|0)==0){k=-2;i=g;return k|0}do{if((j|0)==0){b=a[d>>0]|0;j=b&255;if(b<<24>>24>-1){c[h>>2]=j;k=b<<24>>24!=0&1;i=g;return k|0}else{j=j+ -194|0;if(j>>>0>50){break a}b=e+ -1|0;j=c[24008+(j<<2)>>2]|0;d=d+1|0;break}}else{b=e}}while(0);b:do{if((b|0)!=0){k=a[d>>0]|0;l=(k&255)>>>3;if((l+ -16|l+(j>>26))>>>0>7){break a}while(1){d=d+1|0;j=(k&255)+ -128|j<<6;b=b+ -1|0;if((j|0)>=0){break}if((b|0)==0){break b}k=a[d>>0]|0;if(((k&255)+ -128|0)>>>0>63){break a}}c[f>>2]=0;c[h>>2]=j;l=e-b|0;i=g;return l|0}}while(0);c[f>>2]=j;l=-2;i=g;return l|0}}while(0);c[f>>2]=0;l=nc()|0;c[l>>2]=84;l=-1;i=g;return l|0}function Mu(a){a=a|0;if((a|0)==0){a=1}else{a=(c[a>>2]|0)==0}return a&1|0}function Nu(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0;h=i;i=i+1040|0;k=h+8|0;g=h;m=c[b>>2]|0;c[g>>2]=m;j=(a|0)!=0;e=j?e:256;l=j?a:k;a:do{if((m|0)==0|(e|0)==0){k=d;a=0}else{a=0;while(1){n=d>>>2;o=n>>>0>=e>>>0;if(!(o|d>>>0>131)){k=d;break a}m=o?e:n;d=d-m|0;m=Ou(l,g,m,f)|0;if((m|0)==-1){break}if((l|0)==(k|0)){l=k}else{e=e-m|0;l=l+(m<<2)|0}a=m+a|0;m=c[g>>2]|0;if((m|0)==0|(e|0)==0){k=d;break a}}k=d;e=0;m=c[g>>2]|0;a=-1}}while(0);b:do{if((m|0)!=0?!((e|0)==0|(k|0)==0):0){while(1){d=Lu(l,m,k,f)|0;if((d+2|0)>>>0<3){break}m=(c[g>>2]|0)+d|0;c[g>>2]=m;e=e+ -1|0;a=a+1|0;if((e|0)==0|(k|0)==(d|0)){break b}else{k=k-d|0;l=l+4|0}}if((d|0)==-1){a=-1;break}else if((d|0)==0){c[g>>2]=0;break}else{c[f>>2]=0;break}}}while(0);if(!j){i=h;return a|0}c[b>>2]=c[g>>2];i=h;return a|0}function Ou(b,e,f,g){b=b|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0;h=i;k=c[e>>2]|0;if((g|0)!=0?(l=c[g>>2]|0,(l|0)!=0):0){if((b|0)==0){j=f;g=16}else{c[g>>2]=0;j=f;g=36}}else{if((b|0)==0){j=f;g=7}else{j=f;g=6}}a:while(1){if((g|0)==6){if((j|0)==0){g=53;break}while(1){m=a[k>>0]|0;do{if(((m&255)+ -1|0)>>>0<127?(k&3|0)==0&j>>>0>3:0){while(1){l=c[k>>2]|0;if(((l+ -16843009|l)&-2139062144|0)!=0){g=30;break}c[b>>2]=l&255;c[b+4>>2]=d[k+1>>0]|0;c[b+8>>2]=d[k+2>>0]|0;l=k+4|0;m=b+16|0;c[b+12>>2]=d[k+3>>0]|0;j=j+ -4|0;if(j>>>0>3){b=m;k=l}else{g=31;break}}if((g|0)==30){m=l&255;break}else if((g|0)==31){b=m;m=a[l>>0]|0;k=l;break}}}while(0);g=m&255;if(!((g+ -1|0)>>>0<127)){break}c[b>>2]=g;j=j+ -1|0;if((j|0)==0){g=53;break a}else{b=b+4|0;k=k+1|0}}g=g+ -194|0;if(g>>>0>50){g=47;break}l=c[24008+(g<<2)>>2]|0;k=k+1|0;g=36;continue}else if((g|0)==7){g=a[k>>0]|0;if(((g&255)+ -1|0)>>>0<127?(k&3|0)==0:0){g=c[k>>2]|0;if(((g+ -16843009|g)&-2139062144|0)==0){do{k=k+4|0;j=j+ -4|0;g=c[k>>2]|0}while(((g+ -16843009|g)&-2139062144|0)==0)}g=g&255}g=g&255;if((g+ -1|0)>>>0<127){j=j+ -1|0;k=k+1|0;g=7;continue}g=g+ -194|0;if(g>>>0>50){g=47;break}l=c[24008+(g<<2)>>2]|0;k=k+1|0;g=16;continue}else if((g|0)==16){m=(d[k>>0]|0)>>>3;if((m+ -16|m+(l>>26))>>>0>7){g=17;break}g=k+1|0;if((l&33554432|0)!=0){if(((d[g>>0]|0)+ -128|0)>>>0>63){g=20;break}g=k+2|0;if((l&524288|0)==0){k=g}else{if(((d[g>>0]|0)+ -128|0)>>>0>63){g=23;break}k=k+3|0}}else{k=g}j=j+ -1|0;g=7;continue}else if((g|0)==36){m=d[k>>0]|0;g=m>>>3;if((g+ -16|g+(l>>26))>>>0>7){g=37;break}g=k+1|0;l=m+ -128|l<<6;if((l|0)<0){m=(d[g>>0]|0)+ -128|0;if(m>>>0>63){g=40;break}g=k+2|0;l=m|l<<6;if((l|0)<0){g=(d[g>>0]|0)+ -128|0;if(g>>>0>63){g=43;break}l=g|l<<6;k=k+3|0}else{k=g}}else{k=g}c[b>>2]=l;b=b+4|0;j=j+ -1|0;g=6;continue}}if((g|0)==17){k=k+ -1|0;g=46}else if((g|0)==20){k=k+ -1|0;g=46}else if((g|0)==23){k=k+ -1|0;g=46}else if((g|0)==37){k=k+ -1|0;g=46}else if((g|0)==40){k=k+ -1|0;g=46}else if((g|0)==43){k=k+ -1|0;g=46}else if((g|0)==53){i=h;return f|0}if((g|0)==46){if((l|0)==0){g=47}}if((g|0)==47){if((a[k>>0]|0)==0){if((b|0)!=0){c[b>>2]=0;c[e>>2]=0}m=f-j|0;i=h;return m|0}}m=nc()|0;c[m>>2]=84;if((b|0)==0){m=-1;i=h;return m|0}c[e>>2]=k;m=-1;i=h;return m|0}function Pu(b,e,f){b=b|0;e=e|0;f=f|0;var g=0,h=0,j=0;g=i;i=i+16|0;h=g;c[h>>2]=b;if((e|0)==0){j=0;i=g;return j|0}do{if((f|0)!=0){if((b|0)==0){c[h>>2]=h}else{h=b}b=a[e>>0]|0;j=b&255;if(b<<24>>24>-1){c[h>>2]=j;j=b<<24>>24!=0&1;i=g;return j|0}j=j+ -194|0;if(!(j>>>0>50)){b=e+1|0;j=c[24008+(j<<2)>>2]|0;if(f>>>0<4?(j&-2147483648>>>((f*6|0)+ -6|0)|0)!=0:0){break}f=d[b>>0]|0;b=f>>>3;if(!((b+ -16|b+(j>>26))>>>0>7)){f=f+ -128|j<<6;if((f|0)>=0){c[h>>2]=f;j=2;i=g;return j|0}b=(d[e+2>>0]|0)+ -128|0;if(!(b>>>0>63)){f=b|f<<6;if((f|0)>=0){c[h>>2]=f;j=3;i=g;return j|0}e=(d[e+3>>0]|0)+ -128|0;if(!(e>>>0>63)){c[h>>2]=e|f<<6;j=4;i=g;return j|0}}}}}}while(0);j=nc()|0;c[j>>2]=84;j=-1;i=g;return j|0}function Qu(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0;h=i;i=i+272|0;j=h+8|0;g=h;l=c[b>>2]|0;c[g>>2]=l;f=(a|0)!=0;k=f?e:256;e=f?a:j;a:do{if((l|0)==0|(k|0)==0){j=d;d=l;a=0}else{a=0;while(1){m=d>>>0>=k>>>0;if(!(m|d>>>0>32)){j=d;d=l;break a}l=m?k:d;d=d-l|0;l=Ru(e,g,l,0)|0;if((l|0)==-1){break}if((e|0)==(j|0)){e=j}else{k=k-l|0;e=e+l|0}a=l+a|0;l=c[g>>2]|0;if((l|0)==0|(k|0)==0){j=d;d=l;break a}}j=d;k=0;d=c[g>>2]|0;a=-1}}while(0);b:do{if((d|0)!=0?!((k|0)==0|(j|0)==0):0){while(1){l=Yv(e,c[d>>2]|0,0)|0;if((l+1|0)>>>0<2){break}d=(c[g>>2]|0)+4|0;c[g>>2]=d;j=j+ -1|0;a=a+1|0;if((k|0)==(l|0)|(j|0)==0){break b}else{k=k-l|0;e=e+l|0}}if((l|0)==0){c[g>>2]=0}else{a=-1}}}while(0);if(!f){i=h;return a|0}c[b>>2]=c[g>>2];i=h;return a|0}function Ru(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0;f=i;i=i+16|0;h=f;if((b|0)==0){k=c[d>>2]|0;l=c[k>>2]|0;if((l|0)==0){m=0;i=f;return m|0}else{j=0}while(1){if(l>>>0>127){l=Yv(h,l,0)|0;if((l|0)==-1){j=-1;l=26;break}}else{l=1}j=l+j|0;k=k+4|0;l=c[k>>2]|0;if((l|0)==0){l=26;break}}if((l|0)==26){i=f;return j|0}}a:do{if(e>>>0>3){k=e;l=c[d>>2]|0;while(1){m=c[l>>2]|0;if((m|0)==0){break a}if(m>>>0>127){m=Yv(b,m,0)|0;if((m|0)==-1){j=-1;break}b=b+m|0;k=k-m|0}else{a[b>>0]=m;b=b+1|0;k=k+ -1|0;l=c[d>>2]|0}l=l+4|0;c[d>>2]=l;if(!(k>>>0>3)){break a}}i=f;return j|0}else{k=e}}while(0);b:do{if((k|0)!=0){l=c[d>>2]|0;while(1){m=c[l>>2]|0;if((m|0)==0){l=24;break}if(m>>>0>127){m=Yv(h,m,0)|0;if((m|0)==-1){j=-1;l=26;break}if(m>>>0>k>>>0){l=20;break}Yv(b,c[l>>2]|0,0)|0;b=b+m|0;k=k-m|0}else{a[b>>0]=m;b=b+1|0;k=k+ -1|0;l=c[d>>2]|0}l=l+4|0;c[d>>2]=l;if((k|0)==0){g=0;break b}}if((l|0)==20){m=e-k|0;i=f;return m|0}else if((l|0)==24){a[b>>0]=0;g=k;break}else if((l|0)==26){i=f;return j|0}}else{g=0}}while(0);c[d>>2]=0;m=e-g|0;i=f;return m|0}function Su(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0;e=i;f=a+84|0;g=c[f>>2]|0;h=d+256|0;j=jw(g,0,h)|0;if((j|0)!=0){h=j-g|0}j=h>>>0<d>>>0?h:d;tw(b|0,g|0,j|0)|0;c[a+4>>2]=g+j;h=g+h|0;c[a+8>>2]=h;c[f>>2]=h;i=e;return j|0}function Tu(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e;c[f>>2]=d;d=Wu(a,b,f)|0;i=e;return d|0}function Uu(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0;e=i;i=i+16|0;j=e;f=Av(240)|0;do{if((f|0)!=0){c[j>>2]=c[d>>2];j=ew(f,240,b,j)|0;if(j>>>0<240){h=Cv(f,j+1|0)|0;c[a>>2]=(h|0)!=0?h:f;break}Bv(f);if((j|0)>=0?(h=j+1|0,g=Av(h)|0,c[a>>2]=g,(g|0)!=0):0){j=ew(g,h,b,d)|0}else{j=-1}}else{j=-1}}while(0);i=e;return j|0}function Vu(e,f,j){e=e|0;f=f|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,K=0,L=0,M=0,N=0,O=0.0;k=i;i=i+304|0;p=k+16|0;x=k+8|0;q=k+33|0;o=k;r=k+32|0;B=a[f>>0]|0;if(B<<24>>24==0){N=0;i=k;return N|0}s=e+4|0;t=e+100|0;z=e+108|0;A=e+8|0;w=q+10|0;v=q+33|0;u=x+4|0;y=q+46|0;n=q+94|0;m=0;D=0;F=0;E=0;a:while(1){b:do{if((Nv(B&255)|0)==0){B=(a[f>>0]|0)==37;c:do{if(B){C=f+1|0;G=a[C>>0]|0;do{if(G<<24>>24==37){break c}else if(G<<24>>24==42){B=0;f=f+2|0}else{B=(G&255)+ -48|0;if(B>>>0<10?(a[f+2>>0]|0)==36:0){c[p>>2]=c[j>>2];C=B;while(1){N=c[p>>2]|0;B=c[N>>2]|0;c[p>>2]=N+4;if(C>>>0>1){C=C+ -1|0}else{break}}f=f+3|0;break}f=c[j>>2]|0;B=c[f>>2]|0;c[j>>2]=f+4;f=C}}while(0);H=a[f>>0]|0;C=H&255;if((C+ -48|0)>>>0<10){G=0;do{G=(G*10|0)+ -48+C|0;f=f+1|0;H=a[f>>0]|0;C=H&255}while((C+ -48|0)>>>0<10)}else{G=0}if(H<<24>>24==109){I=f+1|0;H=a[I>>0]|0;C=(B|0)!=0&1}else{C=0;I=f}f=I+1|0;switch(H&255|0){case 106:{H=3;break};case 116:case 122:{H=1;break};case 104:{H=(a[f>>0]|0)==104;f=H?I+2|0:f;H=H?-2:-1;break};case 76:{H=2;break};case 110:case 112:case 67:case 83:case 91:case 99:case 115:case 88:case 71:case 70:case 69:case 65:case 103:case 102:case 101:case 97:case 120:case 117:case 111:case 105:case 100:{f=I;H=0;break};case 108:{H=(a[f>>0]|0)==108;f=H?I+2|0:f;H=H?3:1;break};default:{l=162;break a}}K=d[f>>0]|0;I=(K&47|0)==3;K=I?K|32:K;I=I?1:H;if((K|0)==99){G=(G|0)<1?1:G}else if((K|0)!=91)if((K|0)==110){if((B|0)==0){break b}switch(I|0){case 1:{c[B>>2]=D;break b};case 3:{N=B;c[N>>2]=D;c[N+4>>2]=((D|0)<0)<<31>>31;break b};case-2:{a[B>>0]=D;break b};case 0:{c[B>>2]=D;break b};case-1:{b[B>>1]=D;break b};default:{break b}}}else{Rv(e,0);do{H=c[s>>2]|0;if(H>>>0<(c[t>>2]|0)>>>0){c[s>>2]=H+1;H=d[H>>0]|0}else{H=Sv(e)|0}}while((Nv(H)|0)!=0);H=c[s>>2]|0;if((c[t>>2]|0)!=0){H=H+ -1|0;c[s>>2]=H}D=(c[z>>2]|0)+D+H-(c[A>>2]|0)|0}Rv(e,G);H=c[s>>2]|0;L=c[t>>2]|0;if(H>>>0<L>>>0){c[s>>2]=H+1}else{if((Sv(e)|0)<0){l=162;break a}L=c[t>>2]|0}if((L|0)!=0){c[s>>2]=(c[s>>2]|0)+ -1}d:do{switch(K|0){case 91:case 99:case 115:{H=(K|0)==99;e:do{if((K&239|0)==99){ww(q|0,-1,257)|0;a[q>>0]=0;if((K|0)==115){a[v>>0]=0;a[w+0>>0]=0;a[w+1>>0]=0;a[w+2>>0]=0;a[w+3>>0]=0;a[w+4>>0]=0}}else{N=f+1|0;M=(a[N>>0]|0)==94;K=M&1;f=M?f+2|0:N;ww(q|0,M&1|0,257)|0;a[q>>0]=0;M=a[f>>0]|0;if(M<<24>>24==93){K=(K^1)&255;a[n>>0]=K;f=f+1|0}else if(M<<24>>24==45){K=(K^1)&255;a[y>>0]=K;f=f+1|0}else{K=(K^1)&255}while(1){N=a[f>>0]|0;if(N<<24>>24==45){M=f+1|0;N=a[M>>0]|0;if(!(N<<24>>24==93|N<<24>>24==0)){f=a[f+ -1>>0]|0;if((f&255)<(N&255)){f=f&255;do{f=f+1|0;a[q+f>>0]=K;N=a[M>>0]|0}while((f|0)<(N&255|0));f=M}else{f=M}}else{N=45}}else if(N<<24>>24==93){break e}else if(N<<24>>24==0){l=162;break a}a[q+((N&255)+1)>>0]=K;f=f+1|0}}}while(0);M=H?G+1|0:31;I=(I|0)==1;K=(C|0)!=0;f:do{if(I){if(K){E=Av(M<<2)|0;if((E|0)==0){F=0;l=162;break a}}else{E=B}c[x>>2]=0;c[u>>2]=0;L=0;F=M;g:while(1){if((E|0)==0){while(1){M=c[s>>2]|0;if(M>>>0<(c[t>>2]|0)>>>0){c[s>>2]=M+1;M=d[M>>0]|0}else{M=Sv(e)|0}if((a[q+(M+1)>>0]|0)==0){E=0;break g}a[r>>0]=M;M=Lu(o,r,1,x)|0;if((M|0)==-1){F=0;E=0;l=162;break a}else if((M|0)==-2){continue}if(K&(L|0)==(F|0)){break}}}else{if(!K){l=98;break}while(1){while(1){M=c[s>>2]|0;if(M>>>0<(c[t>>2]|0)>>>0){c[s>>2]=M+1;M=d[M>>0]|0}else{M=Sv(e)|0}if((a[q+(M+1)>>0]|0)==0){break g}a[r>>0]=M;M=Lu(o,r,1,x)|0;if((M|0)==-1){F=0;l=162;break a}else if(!((M|0)==-2)){break}}c[E+(L<<2)>>2]=c[o>>2];L=L+1|0;if((L|0)==(F|0)){L=F;break}}}F=F<<1|1;M=Cv(E,F<<2)|0;if((M|0)==0){F=0;l=162;break a}E=M}h:do{if((l|0)==98){while(1){l=0;while(1){F=c[s>>2]|0;if(F>>>0<(c[t>>2]|0)>>>0){c[s>>2]=F+1;F=d[F>>0]|0}else{F=Sv(e)|0}if((a[q+(F+1)>>0]|0)==0){break h}a[r>>0]=F;F=Lu(o,r,1,x)|0;if((F|0)==-1){C=0;F=0;l=162;break a}else if(!((F|0)==-2)){break}}c[E+(L<<2)>>2]=c[o>>2];L=L+1|0;l=98}}}while(0);if((Mu(x)|0)==0){F=0;l=162;break a}else{F=0}}else{if(K){F=Av(M)|0;if((F|0)==0){F=0;E=0;l=162;break a}else{L=0;E=M}while(1){do{M=c[s>>2]|0;if(M>>>0<(c[t>>2]|0)>>>0){c[s>>2]=M+1;M=d[M>>0]|0}else{M=Sv(e)|0}if((a[q+(M+1)>>0]|0)==0){E=0;break f}a[F+L>>0]=M;L=L+1|0}while((L|0)!=(E|0));M=E<<1|1;L=Cv(F,M)|0;if((L|0)==0){E=0;l=162;break a}else{N=E;E=M;F=L;L=N}}}if((B|0)==0){while(1){E=c[s>>2]|0;if(E>>>0<L>>>0){c[s>>2]=E+1;E=d[E>>0]|0}else{E=Sv(e)|0}if((a[q+(E+1)>>0]|0)==0){L=0;F=0;E=0;break f}L=c[t>>2]|0}}else{E=0;while(1){F=c[s>>2]|0;if(F>>>0<L>>>0){c[s>>2]=F+1;F=d[F>>0]|0}else{F=Sv(e)|0}if((a[q+(F+1)>>0]|0)==0){L=E;F=B;E=0;break f}a[B+E>>0]=F;L=c[t>>2]|0;E=E+1|0}}}}while(0);M=c[s>>2]|0;if((c[t>>2]|0)!=0){M=M+ -1|0;c[s>>2]=M}M=M-(c[A>>2]|0)+(c[z>>2]|0)|0;if((M|0)==0){break a}if(!((M|0)==(G|0)|H^1)){break a}do{if(K){if(I){c[B>>2]=E;break}else{c[B>>2]=F;break}}}while(0);if(!H){if((E|0)!=0){c[E+(L<<2)>>2]=0}if((F|0)==0){F=0}else{a[F+L>>0]=0}}break};case 71:case 103:case 70:case 102:case 69:case 101:case 65:case 97:{O=+Pv(e,I,0);if((c[z>>2]|0)==((c[A>>2]|0)-(c[s>>2]|0)|0)){break a}if((B|0)!=0){if((I|0)==0){g[B>>2]=O;break d}else if((I|0)==1){h[B>>3]=O;break d}else if((I|0)==2){h[B>>3]=O;break d}else{break d}}break};case 111:{G=8;l=144;break};case 117:case 100:{G=10;l=144;break};case 105:{G=0;l=144;break};case 120:case 88:case 112:{G=16;l=144;break};default:{}}}while(0);i:do{if((l|0)==144){l=0;G=Ov(e,G,0,-1,-1)|0;if((c[z>>2]|0)==((c[A>>2]|0)-(c[s>>2]|0)|0)){break a}C=(B|0)==0;if(!((K|0)!=112|C)){c[B>>2]=G;break}if(!C){switch(I|0){case-1:{b[B>>1]=G;break i};case 0:{c[B>>2]=G;break i};case 1:{c[B>>2]=G;break i};case 3:{N=B;c[N>>2]=G;c[N+4>>2]=J;break i};case-2:{a[B>>0]=G;break i};default:{break i}}}}}while(0);m=((B|0)!=0&1)+m|0;D=(c[z>>2]|0)+D+(c[s>>2]|0)-(c[A>>2]|0)|0;break b}}while(0);f=f+(B&1)|0;Rv(e,0);B=c[s>>2]|0;if(B>>>0<(c[t>>2]|0)>>>0){c[s>>2]=B+1;B=d[B>>0]|0}else{B=Sv(e)|0}if((B|0)!=(d[f>>0]|0)){l=19;break a}D=D+1|0}else{while(1){B=f+1|0;if((Nv(d[B>>0]|0)|0)==0){break}else{f=B}}Rv(e,0);do{B=c[s>>2]|0;if(B>>>0<(c[t>>2]|0)>>>0){c[s>>2]=B+1;B=d[B>>0]|0}else{B=Sv(e)|0}}while((Nv(B)|0)!=0);B=c[s>>2]|0;if((c[t>>2]|0)!=0){B=B+ -1|0;c[s>>2]=B}D=(c[z>>2]|0)+D+B-(c[A>>2]|0)|0}}while(0);f=f+1|0;B=a[f>>0]|0;if(B<<24>>24==0){l=165;break}}if((l|0)==165){i=k;return m|0}if((l|0)==19){if((c[t>>2]|0)!=0){c[s>>2]=(c[s>>2]|0)+ -1}if((B|0)<0){C=0;l=162}else{N=m;i=k;return N|0}}if((l|0)==162){m=(((m|0)==0)<<31>>31)+m|0}if((C|0)==0){N=m;i=k;return N|0}Bv(F);Bv(E);N=m;i=k;return N|0}function Wu(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0;g=i;i=i+112|0;f=g;h=f+0|0;e=h+112|0;do{c[h>>2]=0;h=h+4|0}while((h|0)<(e|0));c[f+32>>2]=40;c[f+44>>2]=a;c[f+76>>2]=-1;c[f+84>>2]=a;d=Vu(f,b,d)|0;i=g;return d|0}function Xu(a,b,c){a=a|0;b=b|0;c=c|0;var d=0;d=i;a=Su(a,b,c)|0;i=d;return a|0}function Yu(a){a=a|0;var b=0,d=0;b=i;d=a;while(1){if((c[d>>2]|0)==0){break}else{d=d+4|0}}i=b;return d-a>>2|0}function Zu(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;e=i;if((d|0)==0){i=e;return a|0}else{f=a}while(1){d=d+ -1|0;c[f>>2]=c[b>>2];if((d|0)==0){break}else{b=b+4|0;f=f+4|0}}i=e;return a|0}function _u(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;e=i;f=(d|0)==0;if(a-b>>2>>>0<d>>>0){if(!f){do{d=d+ -1|0;c[a+(d<<2)>>2]=c[b+(d<<2)>>2]}while((d|0)!=0)}}else{if(!f){f=a;while(1){d=d+ -1|0;c[f>>2]=c[b>>2];if((d|0)==0){break}else{b=b+4|0;f=f+4|0}}}}i=e;return a|0}function $u(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;e=i;if((d|0)!=0){f=a;while(1){d=d+ -1|0;c[f>>2]=b;if((d|0)==0){break}else{f=f+4|0}}}i=e;return a|0}function av(a){a=a|0;return}function bv(a){a=a|0;c[a>>2]=24240;return}function cv(a){a=a|0;var b=0;b=i;ib(a|0);Hv(a);i=b;return}function dv(a){a=a|0;var b=0;b=i;ib(a|0);i=b;return}function ev(a){a=a|0;return 24256}function fv(a){a=a|0;return}function gv(a){a=a|0;return}function hv(a){a=a|0;return}function iv(a){a=a|0;var b=0;b=i;Hv(a);i=b;return}function jv(a){a=a|0;var b=0;b=i;Hv(a);i=b;return}function kv(a){a=a|0;var b=0;b=i;Hv(a);i=b;return}function lv(a){a=a|0;var b=0;b=i;Hv(a);i=b;return}function mv(a){a=a|0;var b=0;b=i;Hv(a);i=b;return}function nv(a,b,c){a=a|0;b=b|0;c=c|0;return(a|0)==(b|0)|0}function ov(a,b,c){a=a|0;b=b|0;c=c|0;return(a|0)==(b|0)|0}function pv(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0;e=i;i=i+64|0;f=e;if((a|0)==(b|0)){h=1;i=e;return h|0}if((b|0)==0){h=0;i=e;return h|0}b=tv(b,24368,24424,0)|0;if((b|0)==0){h=0;i=e;return h|0}h=f+0|0;g=h+56|0;do{c[h>>2]=0;h=h+4|0}while((h|0)<(g|0));c[f>>2]=b;c[f+8>>2]=a;c[f+12>>2]=-1;c[f+48>>2]=1;$c[c[(c[b>>2]|0)+28>>2]&31](b,f,c[d>>2]|0,1);if((c[f+24>>2]|0)!=1){h=0;i=e;return h|0}c[d>>2]=c[f+16>>2];h=1;i=e;return h|0}function qv(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0;g=i;if((c[d+8>>2]|0)!=(b|0)){i=g;return}b=d+16|0;h=c[b>>2]|0;if((h|0)==0){c[b>>2]=e;c[d+24>>2]=f;c[d+36>>2]=1;i=g;return}if((h|0)!=(e|0)){h=d+36|0;c[h>>2]=(c[h>>2]|0)+1;c[d+24>>2]=2;a[d+54>>0]=1;i=g;return}e=d+24|0;if((c[e>>2]|0)!=2){i=g;return}c[e>>2]=f;i=g;return}function rv(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0;g=i;if((b|0)!=(c[d+8>>2]|0)){h=c[b+8>>2]|0;$c[c[(c[h>>2]|0)+28>>2]&31](h,d,e,f);i=g;return}b=d+16|0;h=c[b>>2]|0;if((h|0)==0){c[b>>2]=e;c[d+24>>2]=f;c[d+36>>2]=1;i=g;return}if((h|0)!=(e|0)){h=d+36|0;c[h>>2]=(c[h>>2]|0)+1;c[d+24>>2]=2;a[d+54>>0]=1;i=g;return}e=d+24|0;if((c[e>>2]|0)!=2){i=g;return}c[e>>2]=f;i=g;return}function sv(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0;g=i;if((b|0)==(c[d+8>>2]|0)){b=d+16|0;h=c[b>>2]|0;if((h|0)==0){c[b>>2]=e;c[d+24>>2]=f;c[d+36>>2]=1;i=g;return}if((h|0)!=(e|0)){l=d+36|0;c[l>>2]=(c[l>>2]|0)+1;c[d+24>>2]=2;a[d+54>>0]=1;i=g;return}e=d+24|0;if((c[e>>2]|0)!=2){i=g;return}c[e>>2]=f;i=g;return}j=c[b+12>>2]|0;h=b+(j<<3)+16|0;k=c[b+20>>2]|0;l=k>>8;if((k&1|0)!=0){l=c[(c[e>>2]|0)+l>>2]|0}m=c[b+16>>2]|0;$c[c[(c[m>>2]|0)+28>>2]&31](m,d,e+l|0,(k&2|0)!=0?f:2);if((j|0)<=1){i=g;return}j=d+54|0;k=b+24|0;while(1){b=c[k+4>>2]|0;l=b>>8;if((b&1|0)!=0){l=c[(c[e>>2]|0)+l>>2]|0}m=c[k>>2]|0;$c[c[(c[m>>2]|0)+28>>2]&31](m,d,e+l|0,(b&2|0)!=0?f:2);if((a[j>>0]|0)!=0){f=16;break}k=k+8|0;if(!(k>>>0<h>>>0)){f=16;break}}if((f|0)==16){i=g;return}}function tv(d,e,f,g){d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;h=i;i=i+64|0;j=h;k=c[d>>2]|0;l=d+(c[k+ -8>>2]|0)|0;k=c[k+ -4>>2]|0;c[j>>2]=f;c[j+4>>2]=d;c[j+8>>2]=e;c[j+12>>2]=g;n=j+16|0;o=j+20|0;e=j+24|0;m=j+28|0;g=j+32|0;d=j+40|0;p=(k|0)==(f|0);q=n+0|0;f=q+36|0;do{c[q>>2]=0;q=q+4|0}while((q|0)<(f|0));b[n+36>>1]=0;a[n+38>>0]=0;if(p){c[j+48>>2]=1;Jc[c[(c[k>>2]|0)+20>>2]&31](k,j,l,l,1,0);q=(c[e>>2]|0)==1?l:0;i=h;return q|0}xc[c[(c[k>>2]|0)+24>>2]&7](k,j,l,1,0);j=c[j+36>>2]|0;if((j|0)==1){if((c[e>>2]|0)!=1){if((c[d>>2]|0)!=0){q=0;i=h;return q|0}if((c[m>>2]|0)!=1){q=0;i=h;return q|0}if((c[g>>2]|0)!=1){q=0;i=h;return q|0}}q=c[n>>2]|0;i=h;return q|0}else if((j|0)==0){if((c[d>>2]|0)!=1){q=0;i=h;return q|0}if((c[m>>2]|0)!=1){q=0;i=h;return q|0}q=(c[g>>2]|0)==1?c[o>>2]|0:0;i=h;return q|0}else{q=0;i=h;return q|0}return 0}function uv(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0;h=i;if((b|0)==(c[d+8>>2]|0)){if((c[d+4>>2]|0)!=(e|0)){i=h;return}e=d+28|0;if((c[e>>2]|0)==1){i=h;return}c[e>>2]=f;i=h;return}if((b|0)==(c[d>>2]|0)){if((c[d+16>>2]|0)!=(e|0)?(l=d+20|0,(c[l>>2]|0)!=(e|0)):0){c[d+32>>2]=f;k=d+44|0;if((c[k>>2]|0)==4){i=h;return}w=c[b+12>>2]|0;p=b+(w<<3)+16|0;a:do{if((w|0)>0){n=d+52|0;q=d+53|0;o=d+54|0;t=b+8|0;r=d+24|0;u=0;s=0;b=b+16|0;b:do{a[n>>0]=0;a[q>>0]=0;v=c[b+4>>2]|0;w=v>>8;if((v&1|0)!=0){w=c[(c[e>>2]|0)+w>>2]|0}x=c[b>>2]|0;Jc[c[(c[x>>2]|0)+20>>2]&31](x,d,e,e+w|0,2-(v>>>1&1)|0,g);if((a[o>>0]|0)!=0){break}do{if((a[q>>0]|0)!=0){if((a[n>>0]|0)==0){if((c[t>>2]&1|0)==0){s=1;break b}else{s=1;break}}if((c[r>>2]|0)==1){b=27;break a}if((c[t>>2]&2|0)==0){b=27;break a}else{u=1;s=1}}}while(0);b=b+8|0}while(b>>>0<p>>>0);if(u){j=s;b=26}else{m=s;b=23}}else{m=0;b=23}}while(0);if((b|0)==23){c[l>>2]=e;x=d+40|0;c[x>>2]=(c[x>>2]|0)+1;if((c[d+36>>2]|0)==1?(c[d+24>>2]|0)==2:0){a[d+54>>0]=1;if(m){b=27}else{b=28}}else{j=m;b=26}}if((b|0)==26){if(j){b=27}else{b=28}}if((b|0)==27){c[k>>2]=3;i=h;return}else if((b|0)==28){c[k>>2]=4;i=h;return}}if((f|0)!=1){i=h;return}c[d+32>>2]=1;i=h;return}m=c[b+12>>2]|0;j=b+(m<<3)+16|0;l=c[b+20>>2]|0;n=l>>8;if((l&1|0)!=0){n=c[(c[e>>2]|0)+n>>2]|0}x=c[b+16>>2]|0;xc[c[(c[x>>2]|0)+24>>2]&7](x,d,e+n|0,(l&2|0)!=0?f:2,g);l=b+24|0;if((m|0)<=1){i=h;return}m=c[b+8>>2]|0;if((m&2|0)==0?(k=d+36|0,(c[k>>2]|0)!=1):0){if((m&1|0)==0){m=d+54|0;b=l;while(1){if((a[m>>0]|0)!=0){b=53;break}if((c[k>>2]|0)==1){b=53;break}n=c[b+4>>2]|0;o=n>>8;if((n&1|0)!=0){o=c[(c[e>>2]|0)+o>>2]|0}x=c[b>>2]|0;xc[c[(c[x>>2]|0)+24>>2]&7](x,d,e+o|0,(n&2|0)!=0?f:2,g);b=b+8|0;if(!(b>>>0<j>>>0)){b=53;break}}if((b|0)==53){i=h;return}}n=d+24|0;o=d+54|0;b=l;while(1){if((a[o>>0]|0)!=0){b=53;break}if((c[k>>2]|0)==1?(c[n>>2]|0)==1:0){b=53;break}m=c[b+4>>2]|0;p=m>>8;if((m&1|0)!=0){p=c[(c[e>>2]|0)+p>>2]|0}x=c[b>>2]|0;xc[c[(c[x>>2]|0)+24>>2]&7](x,d,e+p|0,(m&2|0)!=0?f:2,g);b=b+8|0;if(!(b>>>0<j>>>0)){b=53;break}}if((b|0)==53){i=h;return}}k=d+54|0;while(1){if((a[k>>0]|0)!=0){b=53;break}m=c[l+4>>2]|0;b=m>>8;if((m&1|0)!=0){b=c[(c[e>>2]|0)+b>>2]|0}x=c[l>>2]|0;xc[c[(c[x>>2]|0)+24>>2]&7](x,d,e+b|0,(m&2|0)!=0?f:2,g);l=l+8|0;if(!(l>>>0<j>>>0)){b=53;break}}if((b|0)==53){i=h;return}}function vv(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0;h=i;if((b|0)==(c[d+8>>2]|0)){if((c[d+4>>2]|0)!=(e|0)){i=h;return}j=d+28|0;if((c[j>>2]|0)==1){i=h;return}c[j>>2]=f;i=h;return}if((b|0)!=(c[d>>2]|0)){l=c[b+8>>2]|0;xc[c[(c[l>>2]|0)+24>>2]&7](l,d,e,f,g);i=h;return}if((c[d+16>>2]|0)!=(e|0)?(k=d+20|0,(c[k>>2]|0)!=(e|0)):0){c[d+32>>2]=f;f=d+44|0;if((c[f>>2]|0)==4){i=h;return}l=d+52|0;a[l>>0]=0;m=d+53|0;a[m>>0]=0;b=c[b+8>>2]|0;Jc[c[(c[b>>2]|0)+20>>2]&31](b,d,e,e,1,g);if((a[m>>0]|0)!=0){if((a[l>>0]|0)==0){b=1;j=13}}else{b=0;j=13}do{if((j|0)==13){c[k>>2]=e;m=d+40|0;c[m>>2]=(c[m>>2]|0)+1;if((c[d+36>>2]|0)==1?(c[d+24>>2]|0)==2:0){a[d+54>>0]=1;if(b){break}}else{j=16}if((j|0)==16?b:0){break}c[f>>2]=4;i=h;return}}while(0);c[f>>2]=3;i=h;return}if((f|0)!=1){i=h;return}c[d+32>>2]=1;i=h;return}function wv(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0;g=i;if((c[d+8>>2]|0)==(b|0)){if((c[d+4>>2]|0)!=(e|0)){i=g;return}d=d+28|0;if((c[d>>2]|0)==1){i=g;return}c[d>>2]=f;i=g;return}if((c[d>>2]|0)!=(b|0)){i=g;return}if((c[d+16>>2]|0)!=(e|0)?(h=d+20|0,(c[h>>2]|0)!=(e|0)):0){c[d+32>>2]=f;c[h>>2]=e;b=d+40|0;c[b>>2]=(c[b>>2]|0)+1;if((c[d+36>>2]|0)==1?(c[d+24>>2]|0)==2:0){a[d+54>>0]=1}c[d+44>>2]=4;i=g;return}if((f|0)!=1){i=g;return}c[d+32>>2]=1;i=g;return}function xv(b,d,e,f,g,h){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0;j=i;if((b|0)!=(c[d+8>>2]|0)){m=d+52|0;l=a[m>>0]|0;o=d+53|0;n=a[o>>0]|0;q=c[b+12>>2]|0;k=b+(q<<3)+16|0;a[m>>0]=0;a[o>>0]=0;p=c[b+20>>2]|0;r=p>>8;if((p&1|0)!=0){r=c[(c[f>>2]|0)+r>>2]|0}t=c[b+16>>2]|0;Jc[c[(c[t>>2]|0)+20>>2]&31](t,d,e,f+r|0,(p&2|0)!=0?g:2,h);a:do{if((q|0)>1){q=d+24|0;p=b+8|0;r=d+54|0;b=b+24|0;do{if((a[r>>0]|0)!=0){break a}if((a[m>>0]|0)==0){if((a[o>>0]|0)!=0?(c[p>>2]&1|0)==0:0){break a}}else{if((c[q>>2]|0)==1){break a}if((c[p>>2]&2|0)==0){break a}}a[m>>0]=0;a[o>>0]=0;s=c[b+4>>2]|0;t=s>>8;if((s&1|0)!=0){t=c[(c[f>>2]|0)+t>>2]|0}u=c[b>>2]|0;Jc[c[(c[u>>2]|0)+20>>2]&31](u,d,e,f+t|0,(s&2|0)!=0?g:2,h);b=b+8|0}while(b>>>0<k>>>0)}}while(0);a[m>>0]=l;a[o>>0]=n;i=j;return}a[d+53>>0]=1;if((c[d+4>>2]|0)!=(f|0)){i=j;return}a[d+52>>0]=1;k=d+16|0;f=c[k>>2]|0;if((f|0)==0){c[k>>2]=e;c[d+24>>2]=g;c[d+36>>2]=1;if(!((g|0)==1?(c[d+48>>2]|0)==1:0)){i=j;return}a[d+54>>0]=1;i=j;return}if((f|0)!=(e|0)){u=d+36|0;c[u>>2]=(c[u>>2]|0)+1;a[d+54>>0]=1;i=j;return}e=d+24|0;k=c[e>>2]|0;if((k|0)==2){c[e>>2]=g}else{g=k}if(!((g|0)==1?(c[d+48>>2]|0)==1:0)){i=j;return}a[d+54>>0]=1;i=j;return}function yv(b,d,e,f,g,h){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0;j=i;if((b|0)!=(c[d+8>>2]|0)){b=c[b+8>>2]|0;Jc[c[(c[b>>2]|0)+20>>2]&31](b,d,e,f,g,h);i=j;return}a[d+53>>0]=1;if((c[d+4>>2]|0)!=(f|0)){i=j;return}a[d+52>>0]=1;b=d+16|0;f=c[b>>2]|0;if((f|0)==0){c[b>>2]=e;c[d+24>>2]=g;c[d+36>>2]=1;if(!((g|0)==1?(c[d+48>>2]|0)==1:0)){i=j;return}a[d+54>>0]=1;i=j;return}if((f|0)!=(e|0)){h=d+36|0;c[h>>2]=(c[h>>2]|0)+1;a[d+54>>0]=1;i=j;return}e=d+24|0;b=c[e>>2]|0;if((b|0)==2){c[e>>2]=g}else{g=b}if(!((g|0)==1?(c[d+48>>2]|0)==1:0)){i=j;return}a[d+54>>0]=1;i=j;return}function zv(b,d,e,f,g,h){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;h=i;if((c[d+8>>2]|0)!=(b|0)){i=h;return}a[d+53>>0]=1;if((c[d+4>>2]|0)!=(f|0)){i=h;return}a[d+52>>0]=1;f=d+16|0;b=c[f>>2]|0;if((b|0)==0){c[f>>2]=e;c[d+24>>2]=g;c[d+36>>2]=1;if(!((g|0)==1?(c[d+48>>2]|0)==1:0)){i=h;return}a[d+54>>0]=1;i=h;return}if((b|0)!=(e|0)){b=d+36|0;c[b>>2]=(c[b>>2]|0)+1;a[d+54>>0]=1;i=h;return}e=d+24|0;f=c[e>>2]|0;if((f|0)==2){c[e>>2]=g}else{g=f}if(!((g|0)==1?(c[d+48>>2]|0)==1:0)){i=h;return}a[d+54>>0]=1;i=h;return}function Av(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0;b=i;do{if(a>>>0<245){if(a>>>0<11){a=16}else{a=a+11&-8}v=a>>>3;p=c[6228]|0;w=p>>>v;if((w&3|0)!=0){h=(w&1^1)+v|0;g=h<<1;e=24952+(g<<2)|0;g=24952+(g+2<<2)|0;j=c[g>>2]|0;d=j+8|0;f=c[d>>2]|0;do{if((e|0)!=(f|0)){if(f>>>0<(c[24928>>2]|0)>>>0){Vb()}k=f+12|0;if((c[k>>2]|0)==(j|0)){c[k>>2]=e;c[g>>2]=f;break}else{Vb()}}else{c[6228]=p&~(1<<h)}}while(0);H=h<<3;c[j+4>>2]=H|3;H=j+(H|4)|0;c[H>>2]=c[H>>2]|1;H=d;i=b;return H|0}if(a>>>0>(c[24920>>2]|0)>>>0){if((w|0)!=0){h=2<<v;h=w<<v&(h|0-h);h=(h&0-h)+ -1|0;d=h>>>12&16;h=h>>>d;f=h>>>5&8;h=h>>>f;g=h>>>2&4;h=h>>>g;e=h>>>1&2;h=h>>>e;j=h>>>1&1;j=(f|d|g|e|j)+(h>>>j)|0;h=j<<1;e=24952+(h<<2)|0;h=24952+(h+2<<2)|0;g=c[h>>2]|0;d=g+8|0;f=c[d>>2]|0;do{if((e|0)!=(f|0)){if(f>>>0<(c[24928>>2]|0)>>>0){Vb()}k=f+12|0;if((c[k>>2]|0)==(g|0)){c[k>>2]=e;c[h>>2]=f;break}else{Vb()}}else{c[6228]=p&~(1<<j)}}while(0);h=j<<3;f=h-a|0;c[g+4>>2]=a|3;e=g+a|0;c[g+(a|4)>>2]=f|1;c[g+h>>2]=f;h=c[24920>>2]|0;if((h|0)!=0){g=c[24932>>2]|0;k=h>>>3;j=k<<1;h=24952+(j<<2)|0;l=c[6228]|0;k=1<<k;if((l&k|0)!=0){j=24952+(j+2<<2)|0;k=c[j>>2]|0;if(k>>>0<(c[24928>>2]|0)>>>0){Vb()}else{D=j;C=k}}else{c[6228]=l|k;D=24952+(j+2<<2)|0;C=h}c[D>>2]=g;c[C+12>>2]=g;c[g+8>>2]=C;c[g+12>>2]=h}c[24920>>2]=f;c[24932>>2]=e;H=d;i=b;return H|0}p=c[24916>>2]|0;if((p|0)!=0){e=(p&0-p)+ -1|0;G=e>>>12&16;e=e>>>G;F=e>>>5&8;e=e>>>F;H=e>>>2&4;e=e>>>H;f=e>>>1&2;e=e>>>f;d=e>>>1&1;d=c[25216+((F|G|H|f|d)+(e>>>d)<<2)>>2]|0;e=(c[d+4>>2]&-8)-a|0;f=d;while(1){g=c[f+16>>2]|0;if((g|0)==0){g=c[f+20>>2]|0;if((g|0)==0){break}}f=(c[g+4>>2]&-8)-a|0;H=f>>>0<e>>>0;e=H?f:e;f=g;d=H?g:d}h=c[24928>>2]|0;if(d>>>0<h>>>0){Vb()}f=d+a|0;if(!(d>>>0<f>>>0)){Vb()}g=c[d+24>>2]|0;k=c[d+12>>2]|0;do{if((k|0)==(d|0)){k=d+20|0;j=c[k>>2]|0;if((j|0)==0){k=d+16|0;j=c[k>>2]|0;if((j|0)==0){B=0;break}}while(1){l=j+20|0;m=c[l>>2]|0;if((m|0)!=0){j=m;k=l;continue}m=j+16|0;l=c[m>>2]|0;if((l|0)==0){break}else{j=l;k=m}}if(k>>>0<h>>>0){Vb()}else{c[k>>2]=0;B=j;break}}else{j=c[d+8>>2]|0;if(j>>>0<h>>>0){Vb()}h=j+12|0;if((c[h>>2]|0)!=(d|0)){Vb()}l=k+8|0;if((c[l>>2]|0)==(d|0)){c[h>>2]=k;c[l>>2]=j;B=k;break}else{Vb()}}}while(0);do{if((g|0)!=0){h=c[d+28>>2]|0;j=25216+(h<<2)|0;if((d|0)==(c[j>>2]|0)){c[j>>2]=B;if((B|0)==0){c[24916>>2]=c[24916>>2]&~(1<<h);break}}else{if(g>>>0<(c[24928>>2]|0)>>>0){Vb()}h=g+16|0;if((c[h>>2]|0)==(d|0)){c[h>>2]=B}else{c[g+20>>2]=B}if((B|0)==0){break}}if(B>>>0<(c[24928>>2]|0)>>>0){Vb()}c[B+24>>2]=g;g=c[d+16>>2]|0;do{if((g|0)!=0){if(g>>>0<(c[24928>>2]|0)>>>0){Vb()}else{c[B+16>>2]=g;c[g+24>>2]=B;break}}}while(0);g=c[d+20>>2]|0;if((g|0)!=0){if(g>>>0<(c[24928>>2]|0)>>>0){Vb()}else{c[B+20>>2]=g;c[g+24>>2]=B;break}}}}while(0);if(e>>>0<16){H=e+a|0;c[d+4>>2]=H|3;H=d+(H+4)|0;c[H>>2]=c[H>>2]|1}else{c[d+4>>2]=a|3;c[d+(a|4)>>2]=e|1;c[d+(e+a)>>2]=e;h=c[24920>>2]|0;if((h|0)!=0){g=c[24932>>2]|0;l=h>>>3;j=l<<1;h=24952+(j<<2)|0;k=c[6228]|0;l=1<<l;if((k&l|0)!=0){j=24952+(j+2<<2)|0;k=c[j>>2]|0;if(k>>>0<(c[24928>>2]|0)>>>0){Vb()}else{A=j;z=k}}else{c[6228]=k|l;A=24952+(j+2<<2)|0;z=h}c[A>>2]=g;c[z+12>>2]=g;c[g+8>>2]=z;c[g+12>>2]=h}c[24920>>2]=e;c[24932>>2]=f}H=d+8|0;i=b;return H|0}}}else{if(!(a>>>0>4294967231)){z=a+11|0;a=z&-8;B=c[24916>>2]|0;if((B|0)!=0){A=0-a|0;z=z>>>8;if((z|0)!=0){if(a>>>0>16777215){C=31}else{G=(z+1048320|0)>>>16&8;H=z<<G;F=(H+520192|0)>>>16&4;H=H<<F;C=(H+245760|0)>>>16&2;C=14-(F|G|C)+(H<<C>>>15)|0;C=a>>>(C+7|0)&1|C<<1}}else{C=0}D=c[25216+(C<<2)>>2]|0;a:do{if((D|0)==0){F=0;z=0}else{if((C|0)==31){z=0}else{z=25-(C>>>1)|0}F=0;E=a<<z;z=0;while(1){H=c[D+4>>2]&-8;G=H-a|0;if(G>>>0<A>>>0){if((H|0)==(a|0)){A=G;F=D;z=D;break a}else{A=G;z=D}}H=c[D+20>>2]|0;D=c[D+(E>>>31<<2)+16>>2]|0;F=(H|0)==0|(H|0)==(D|0)?F:H;if((D|0)==0){break}else{E=E<<1}}}}while(0);if((F|0)==0&(z|0)==0){H=2<<C;B=B&(H|0-H);if((B|0)==0){break}H=(B&0-B)+ -1|0;D=H>>>12&16;H=H>>>D;C=H>>>5&8;H=H>>>C;E=H>>>2&4;H=H>>>E;G=H>>>1&2;H=H>>>G;F=H>>>1&1;F=c[25216+((C|D|E|G|F)+(H>>>F)<<2)>>2]|0}if((F|0)!=0){while(1){H=(c[F+4>>2]&-8)-a|0;B=H>>>0<A>>>0;A=B?H:A;z=B?F:z;B=c[F+16>>2]|0;if((B|0)!=0){F=B;continue}F=c[F+20>>2]|0;if((F|0)==0){break}}}if((z|0)!=0?A>>>0<((c[24920>>2]|0)-a|0)>>>0:0){f=c[24928>>2]|0;if(z>>>0<f>>>0){Vb()}d=z+a|0;if(!(z>>>0<d>>>0)){Vb()}e=c[z+24>>2]|0;h=c[z+12>>2]|0;do{if((h|0)==(z|0)){h=z+20|0;g=c[h>>2]|0;if((g|0)==0){h=z+16|0;g=c[h>>2]|0;if((g|0)==0){x=0;break}}while(1){j=g+20|0;k=c[j>>2]|0;if((k|0)!=0){g=k;h=j;continue}j=g+16|0;k=c[j>>2]|0;if((k|0)==0){break}else{g=k;h=j}}if(h>>>0<f>>>0){Vb()}else{c[h>>2]=0;x=g;break}}else{g=c[z+8>>2]|0;if(g>>>0<f>>>0){Vb()}f=g+12|0;if((c[f>>2]|0)!=(z|0)){Vb()}j=h+8|0;if((c[j>>2]|0)==(z|0)){c[f>>2]=h;c[j>>2]=g;x=h;break}else{Vb()}}}while(0);do{if((e|0)!=0){g=c[z+28>>2]|0;f=25216+(g<<2)|0;if((z|0)==(c[f>>2]|0)){c[f>>2]=x;if((x|0)==0){c[24916>>2]=c[24916>>2]&~(1<<g);break}}else{if(e>>>0<(c[24928>>2]|0)>>>0){Vb()}f=e+16|0;if((c[f>>2]|0)==(z|0)){c[f>>2]=x}else{c[e+20>>2]=x}if((x|0)==0){break}}if(x>>>0<(c[24928>>2]|0)>>>0){Vb()}c[x+24>>2]=e;e=c[z+16>>2]|0;do{if((e|0)!=0){if(e>>>0<(c[24928>>2]|0)>>>0){Vb()}else{c[x+16>>2]=e;c[e+24>>2]=x;break}}}while(0);e=c[z+20>>2]|0;if((e|0)!=0){if(e>>>0<(c[24928>>2]|0)>>>0){Vb()}else{c[x+20>>2]=e;c[e+24>>2]=x;break}}}}while(0);b:do{if(!(A>>>0<16)){c[z+4>>2]=a|3;c[z+(a|4)>>2]=A|1;c[z+(A+a)>>2]=A;f=A>>>3;if(A>>>0<256){h=f<<1;e=24952+(h<<2)|0;g=c[6228]|0;f=1<<f;do{if((g&f|0)==0){c[6228]=g|f;w=24952+(h+2<<2)|0;v=e}else{f=24952+(h+2<<2)|0;g=c[f>>2]|0;if(!(g>>>0<(c[24928>>2]|0)>>>0)){w=f;v=g;break}Vb()}}while(0);c[w>>2]=d;c[v+12>>2]=d;c[z+(a+8)>>2]=v;c[z+(a+12)>>2]=e;break}e=A>>>8;if((e|0)!=0){if(A>>>0>16777215){e=31}else{G=(e+1048320|0)>>>16&8;H=e<<G;F=(H+520192|0)>>>16&4;H=H<<F;e=(H+245760|0)>>>16&2;e=14-(F|G|e)+(H<<e>>>15)|0;e=A>>>(e+7|0)&1|e<<1}}else{e=0}f=25216+(e<<2)|0;c[z+(a+28)>>2]=e;c[z+(a+20)>>2]=0;c[z+(a+16)>>2]=0;h=c[24916>>2]|0;g=1<<e;if((h&g|0)==0){c[24916>>2]=h|g;c[f>>2]=d;c[z+(a+24)>>2]=f;c[z+(a+12)>>2]=d;c[z+(a+8)>>2]=d;break}f=c[f>>2]|0;if((e|0)==31){e=0}else{e=25-(e>>>1)|0}c:do{if((c[f+4>>2]&-8|0)!=(A|0)){e=A<<e;while(1){g=f+(e>>>31<<2)+16|0;h=c[g>>2]|0;if((h|0)==0){break}if((c[h+4>>2]&-8|0)==(A|0)){p=h;break c}else{e=e<<1;f=h}}if(g>>>0<(c[24928>>2]|0)>>>0){Vb()}else{c[g>>2]=d;c[z+(a+24)>>2]=f;c[z+(a+12)>>2]=d;c[z+(a+8)>>2]=d;break b}}else{p=f}}while(0);f=p+8|0;e=c[f>>2]|0;g=c[24928>>2]|0;if(p>>>0<g>>>0){Vb()}if(e>>>0<g>>>0){Vb()}else{c[e+12>>2]=d;c[f>>2]=d;c[z+(a+8)>>2]=e;c[z+(a+12)>>2]=p;c[z+(a+24)>>2]=0;break}}else{H=A+a|0;c[z+4>>2]=H|3;H=z+(H+4)|0;c[H>>2]=c[H>>2]|1}}while(0);H=z+8|0;i=b;return H|0}}}else{a=-1}}}while(0);p=c[24920>>2]|0;if(!(a>>>0>p>>>0)){e=p-a|0;d=c[24932>>2]|0;if(e>>>0>15){c[24932>>2]=d+a;c[24920>>2]=e;c[d+(a+4)>>2]=e|1;c[d+p>>2]=e;c[d+4>>2]=a|3}else{c[24920>>2]=0;c[24932>>2]=0;c[d+4>>2]=p|3;H=d+(p+4)|0;c[H>>2]=c[H>>2]|1}H=d+8|0;i=b;return H|0}p=c[24924>>2]|0;if(a>>>0<p>>>0){G=p-a|0;c[24924>>2]=G;H=c[24936>>2]|0;c[24936>>2]=H+a;c[H+(a+4)>>2]=G|1;c[H+4>>2]=a|3;H=H+8|0;i=b;return H|0}do{if((c[6346]|0)==0){p=bb(30)|0;if((p+ -1&p|0)==0){c[25392>>2]=p;c[25388>>2]=p;c[25396>>2]=-1;c[25400>>2]=-1;c[25404>>2]=0;c[25356>>2]=0;H=(Ab(0)|0)&-16^1431655768;c[6346]=H;break}else{Vb()}}}while(0);w=a+48|0;p=c[25392>>2]|0;x=a+47|0;z=p+x|0;p=0-p|0;v=z&p;if(!(v>>>0>a>>>0)){H=0;i=b;return H|0}A=c[25352>>2]|0;if((A|0)!=0?(G=c[25344>>2]|0,H=G+v|0,H>>>0<=G>>>0|H>>>0>A>>>0):0){H=0;i=b;return H|0}d:do{if((c[25356>>2]&4|0)==0){B=c[24936>>2]|0;e:do{if((B|0)!=0){A=25360|0;while(1){C=c[A>>2]|0;if(!(C>>>0>B>>>0)?(y=A+4|0,(C+(c[y>>2]|0)|0)>>>0>B>>>0):0){break}A=c[A+8>>2]|0;if((A|0)==0){o=182;break e}}if((A|0)!=0){B=z-(c[24924>>2]|0)&p;if(B>>>0<2147483647){p=_a(B|0)|0;A=(p|0)==((c[A>>2]|0)+(c[y>>2]|0)|0);y=p;z=B;p=A?p:-1;A=A?B:0;o=191}else{A=0}}else{o=182}}else{o=182}}while(0);do{if((o|0)==182){p=_a(0)|0;if((p|0)!=(-1|0)){z=p;A=c[25388>>2]|0;y=A+ -1|0;if((y&z|0)==0){A=v}else{A=v-z+(y+z&0-A)|0}y=c[25344>>2]|0;z=y+A|0;if(A>>>0>a>>>0&A>>>0<2147483647){H=c[25352>>2]|0;if((H|0)!=0?z>>>0<=y>>>0|z>>>0>H>>>0:0){A=0;break}y=_a(A|0)|0;o=(y|0)==(p|0);z=A;p=o?p:-1;A=o?A:0;o=191}else{A=0}}else{A=0}}}while(0);f:do{if((o|0)==191){o=0-z|0;if((p|0)!=(-1|0)){q=A;o=202;break d}do{if((y|0)!=(-1|0)&z>>>0<2147483647&z>>>0<w>>>0?(u=c[25392>>2]|0,u=x-z+u&0-u,u>>>0<2147483647):0){if((_a(u|0)|0)==(-1|0)){_a(o|0)|0;break f}else{z=u+z|0;break}}}while(0);if((y|0)!=(-1|0)){p=y;q=z;o=202;break d}}}while(0);c[25356>>2]=c[25356>>2]|4;o=199}else{A=0;o=199}}while(0);if((((o|0)==199?v>>>0<2147483647:0)?(t=_a(v|0)|0,s=_a(0)|0,(s|0)!=(-1|0)&(t|0)!=(-1|0)&t>>>0<s>>>0):0)?(r=s-t|0,q=r>>>0>(a+40|0)>>>0,q):0){p=t;q=q?r:A;o=202}if((o|0)==202){r=(c[25344>>2]|0)+q|0;c[25344>>2]=r;if(r>>>0>(c[25348>>2]|0)>>>0){c[25348>>2]=r}r=c[24936>>2]|0;g:do{if((r|0)!=0){v=25360|0;while(1){t=c[v>>2]|0;u=v+4|0;s=c[u>>2]|0;if((p|0)==(t+s|0)){o=214;break}w=c[v+8>>2]|0;if((w|0)==0){break}else{v=w}}if(((o|0)==214?(c[v+12>>2]&8|0)==0:0)?r>>>0>=t>>>0&r>>>0<p>>>0:0){c[u>>2]=s+q;d=(c[24924>>2]|0)+q|0;e=r+8|0;if((e&7|0)==0){e=0}else{e=0-e&7}H=d-e|0;c[24936>>2]=r+e;c[24924>>2]=H;c[r+(e+4)>>2]=H|1;c[r+(d+4)>>2]=40;c[24940>>2]=c[25400>>2];break}if(p>>>0<(c[24928>>2]|0)>>>0){c[24928>>2]=p}t=p+q|0;s=25360|0;while(1){if((c[s>>2]|0)==(t|0)){o=224;break}u=c[s+8>>2]|0;if((u|0)==0){break}else{s=u}}if((o|0)==224?(c[s+12>>2]&8|0)==0:0){c[s>>2]=p;h=s+4|0;c[h>>2]=(c[h>>2]|0)+q;h=p+8|0;if((h&7|0)==0){h=0}else{h=0-h&7}j=p+(q+8)|0;if((j&7|0)==0){n=0}else{n=0-j&7}o=p+(n+q)|0;j=h+a|0;k=p+j|0;m=o-(p+h)-a|0;c[p+(h+4)>>2]=a|3;h:do{if((o|0)!=(c[24936>>2]|0)){if((o|0)==(c[24932>>2]|0)){H=(c[24920>>2]|0)+m|0;c[24920>>2]=H;c[24932>>2]=k;c[p+(j+4)>>2]=H|1;c[p+(H+j)>>2]=H;break}r=q+4|0;t=c[p+(r+n)>>2]|0;if((t&3|0)==1){a=t&-8;s=t>>>3;i:do{if(!(t>>>0<256)){l=c[p+((n|24)+q)>>2]|0;u=c[p+(q+12+n)>>2]|0;do{if((u|0)==(o|0)){u=n|16;t=p+(r+u)|0;s=c[t>>2]|0;if((s|0)==0){t=p+(u+q)|0;s=c[t>>2]|0;if((s|0)==0){g=0;break}}while(1){u=s+20|0;v=c[u>>2]|0;if((v|0)!=0){s=v;t=u;continue}u=s+16|0;v=c[u>>2]|0;if((v|0)==0){break}else{s=v;t=u}}if(t>>>0<(c[24928>>2]|0)>>>0){Vb()}else{c[t>>2]=0;g=s;break}}else{t=c[p+((n|8)+q)>>2]|0;if(t>>>0<(c[24928>>2]|0)>>>0){Vb()}v=t+12|0;if((c[v>>2]|0)!=(o|0)){Vb()}s=u+8|0;if((c[s>>2]|0)==(o|0)){c[v>>2]=u;c[s>>2]=t;g=u;break}else{Vb()}}}while(0);if((l|0)==0){break}t=c[p+(q+28+n)>>2]|0;s=25216+(t<<2)|0;do{if((o|0)!=(c[s>>2]|0)){if(l>>>0<(c[24928>>2]|0)>>>0){Vb()}s=l+16|0;if((c[s>>2]|0)==(o|0)){c[s>>2]=g}else{c[l+20>>2]=g}if((g|0)==0){break i}}else{c[s>>2]=g;if((g|0)!=0){break}c[24916>>2]=c[24916>>2]&~(1<<t);break i}}while(0);if(g>>>0<(c[24928>>2]|0)>>>0){Vb()}c[g+24>>2]=l;l=n|16;o=c[p+(l+q)>>2]|0;do{if((o|0)!=0){if(o>>>0<(c[24928>>2]|0)>>>0){Vb()}else{c[g+16>>2]=o;c[o+24>>2]=g;break}}}while(0);l=c[p+(r+l)>>2]|0;if((l|0)==0){break}if(l>>>0<(c[24928>>2]|0)>>>0){Vb()}else{c[g+20>>2]=l;c[l+24>>2]=g;break}}else{r=c[p+((n|8)+q)>>2]|0;g=c[p+(q+12+n)>>2]|0;t=24952+(s<<1<<2)|0;do{if((r|0)!=(t|0)){if(r>>>0<(c[24928>>2]|0)>>>0){Vb()}if((c[r+12>>2]|0)==(o|0)){break}Vb()}}while(0);if((g|0)==(r|0)){c[6228]=c[6228]&~(1<<s);break}do{if((g|0)==(t|0)){l=g+8|0}else{if(g>>>0<(c[24928>>2]|0)>>>0){Vb()}s=g+8|0;if((c[s>>2]|0)==(o|0)){l=s;break}Vb()}}while(0);c[r+12>>2]=g;c[l>>2]=r}}while(0);o=p+((a|n)+q)|0;m=a+m|0}g=o+4|0;c[g>>2]=c[g>>2]&-2;c[p+(j+4)>>2]=m|1;c[p+(m+j)>>2]=m;g=m>>>3;if(m>>>0<256){m=g<<1;d=24952+(m<<2)|0;l=c[6228]|0;g=1<<g;do{if((l&g|0)==0){c[6228]=l|g;f=24952+(m+2<<2)|0;e=d}else{l=24952+(m+2<<2)|0;g=c[l>>2]|0;if(!(g>>>0<(c[24928>>2]|0)>>>0)){f=l;e=g;break}Vb()}}while(0);c[f>>2]=k;c[e+12>>2]=k;c[p+(j+8)>>2]=e;c[p+(j+12)>>2]=d;break}e=m>>>8;do{if((e|0)==0){e=0}else{if(m>>>0>16777215){e=31;break}G=(e+1048320|0)>>>16&8;H=e<<G;F=(H+520192|0)>>>16&4;H=H<<F;e=(H+245760|0)>>>16&2;e=14-(F|G|e)+(H<<e>>>15)|0;e=m>>>(e+7|0)&1|e<<1}}while(0);l=25216+(e<<2)|0;c[p+(j+28)>>2]=e;c[p+(j+20)>>2]=0;c[p+(j+16)>>2]=0;f=c[24916>>2]|0;g=1<<e;if((f&g|0)==0){c[24916>>2]=f|g;c[l>>2]=k;c[p+(j+24)>>2]=l;c[p+(j+12)>>2]=k;c[p+(j+8)>>2]=k;break}l=c[l>>2]|0;if((e|0)==31){e=0}else{e=25-(e>>>1)|0}j:do{if((c[l+4>>2]&-8|0)!=(m|0)){e=m<<e;while(1){g=l+(e>>>31<<2)+16|0;f=c[g>>2]|0;if((f|0)==0){break}if((c[f+4>>2]&-8|0)==(m|0)){d=f;break j}else{e=e<<1;l=f}}if(g>>>0<(c[24928>>2]|0)>>>0){Vb()}else{c[g>>2]=k;c[p+(j+24)>>2]=l;c[p+(j+12)>>2]=k;c[p+(j+8)>>2]=k;break h}}else{d=l}}while(0);f=d+8|0;e=c[f>>2]|0;g=c[24928>>2]|0;if(d>>>0<g>>>0){Vb()}if(e>>>0<g>>>0){Vb()}else{c[e+12>>2]=k;c[f>>2]=k;c[p+(j+8)>>2]=e;c[p+(j+12)>>2]=d;c[p+(j+24)>>2]=0;break}}else{H=(c[24924>>2]|0)+m|0;c[24924>>2]=H;c[24936>>2]=k;c[p+(j+4)>>2]=H|1}}while(0);H=p+(h|8)|0;i=b;return H|0}e=25360|0;while(1){d=c[e>>2]|0;if(!(d>>>0>r>>>0)?(n=c[e+4>>2]|0,m=d+n|0,m>>>0>r>>>0):0){break}e=c[e+8>>2]|0}e=d+(n+ -39)|0;if((e&7|0)==0){e=0}else{e=0-e&7}d=d+(n+ -47+e)|0;d=d>>>0<(r+16|0)>>>0?r:d;e=d+8|0;f=p+8|0;if((f&7|0)==0){f=0}else{f=0-f&7}H=q+ -40-f|0;c[24936>>2]=p+f;c[24924>>2]=H;c[p+(f+4)>>2]=H|1;c[p+(q+ -36)>>2]=40;c[24940>>2]=c[25400>>2];c[d+4>>2]=27;c[e+0>>2]=c[25360>>2];c[e+4>>2]=c[25364>>2];c[e+8>>2]=c[25368>>2];c[e+12>>2]=c[25372>>2];c[25360>>2]=p;c[25364>>2]=q;c[25372>>2]=0;c[25368>>2]=e;e=d+28|0;c[e>>2]=7;if((d+32|0)>>>0<m>>>0){do{H=e;e=e+4|0;c[e>>2]=7}while((H+8|0)>>>0<m>>>0)}if((d|0)!=(r|0)){d=d-r|0;e=r+(d+4)|0;c[e>>2]=c[e>>2]&-2;c[r+4>>2]=d|1;c[r+d>>2]=d;e=d>>>3;if(d>>>0<256){g=e<<1;d=24952+(g<<2)|0;f=c[6228]|0;e=1<<e;do{if((f&e|0)==0){c[6228]=f|e;k=24952+(g+2<<2)|0;j=d}else{f=24952+(g+2<<2)|0;e=c[f>>2]|0;if(!(e>>>0<(c[24928>>2]|0)>>>0)){k=f;j=e;break}Vb()}}while(0);c[k>>2]=r;c[j+12>>2]=r;c[r+8>>2]=j;c[r+12>>2]=d;break}e=d>>>8;if((e|0)!=0){if(d>>>0>16777215){e=31}else{G=(e+1048320|0)>>>16&8;H=e<<G;F=(H+520192|0)>>>16&4;H=H<<F;e=(H+245760|0)>>>16&2;e=14-(F|G|e)+(H<<e>>>15)|0;e=d>>>(e+7|0)&1|e<<1}}else{e=0}j=25216+(e<<2)|0;c[r+28>>2]=e;c[r+20>>2]=0;c[r+16>>2]=0;f=c[24916>>2]|0;g=1<<e;if((f&g|0)==0){c[24916>>2]=f|g;c[j>>2]=r;c[r+24>>2]=j;c[r+12>>2]=r;c[r+8>>2]=r;break}f=c[j>>2]|0;if((e|0)==31){e=0}else{e=25-(e>>>1)|0}k:do{if((c[f+4>>2]&-8|0)!=(d|0)){e=d<<e;while(1){j=f+(e>>>31<<2)+16|0;g=c[j>>2]|0;if((g|0)==0){break}if((c[g+4>>2]&-8|0)==(d|0)){h=g;break k}else{e=e<<1;f=g}}if(j>>>0<(c[24928>>2]|0)>>>0){Vb()}else{c[j>>2]=r;c[r+24>>2]=f;c[r+12>>2]=r;c[r+8>>2]=r;break g}}else{h=f}}while(0);f=h+8|0;e=c[f>>2]|0;d=c[24928>>2]|0;if(h>>>0<d>>>0){Vb()}if(e>>>0<d>>>0){Vb()}else{c[e+12>>2]=r;c[f>>2]=r;c[r+8>>2]=e;c[r+12>>2]=h;c[r+24>>2]=0;break}}}else{H=c[24928>>2]|0;if((H|0)==0|p>>>0<H>>>0){c[24928>>2]=p}c[25360>>2]=p;c[25364>>2]=q;c[25372>>2]=0;c[24948>>2]=c[6346];c[24944>>2]=-1;d=0;do{H=d<<1;G=24952+(H<<2)|0;c[24952+(H+3<<2)>>2]=G;c[24952+(H+2<<2)>>2]=G;d=d+1|0}while((d|0)!=32);d=p+8|0;if((d&7|0)==0){d=0}else{d=0-d&7}H=q+ -40-d|0;c[24936>>2]=p+d;c[24924>>2]=H;c[p+(d+4)>>2]=H|1;c[p+(q+ -36)>>2]=40;c[24940>>2]=c[25400>>2]}}while(0);d=c[24924>>2]|0;if(d>>>0>a>>>0){G=d-a|0;c[24924>>2]=G;H=c[24936>>2]|0;c[24936>>2]=H+a;c[H+(a+4)>>2]=G|1;c[H+4>>2]=a|3;H=H+8|0;i=b;return H|0}}H=nc()|0;c[H>>2]=12;H=0;i=b;return H|0}function Bv(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0;b=i;if((a|0)==0){i=b;return}q=a+ -8|0;r=c[24928>>2]|0;if(q>>>0<r>>>0){Vb()}o=c[a+ -4>>2]|0;n=o&3;if((n|0)==1){Vb()}j=o&-8;h=a+(j+ -8)|0;do{if((o&1|0)==0){u=c[q>>2]|0;if((n|0)==0){i=b;return}q=-8-u|0;o=a+q|0;n=u+j|0;if(o>>>0<r>>>0){Vb()}if((o|0)==(c[24932>>2]|0)){d=a+(j+ -4)|0;if((c[d>>2]&3|0)!=3){d=o;m=n;break}c[24920>>2]=n;c[d>>2]=c[d>>2]&-2;c[a+(q+4)>>2]=n|1;c[h>>2]=n;i=b;return}t=u>>>3;if(u>>>0<256){d=c[a+(q+8)>>2]|0;m=c[a+(q+12)>>2]|0;p=24952+(t<<1<<2)|0;if((d|0)!=(p|0)){if(d>>>0<r>>>0){Vb()}if((c[d+12>>2]|0)!=(o|0)){Vb()}}if((m|0)==(d|0)){c[6228]=c[6228]&~(1<<t);d=o;m=n;break}if((m|0)!=(p|0)){if(m>>>0<r>>>0){Vb()}p=m+8|0;if((c[p>>2]|0)==(o|0)){s=p}else{Vb()}}else{s=m+8|0}c[d+12>>2]=m;c[s>>2]=d;d=o;m=n;break}s=c[a+(q+24)>>2]|0;t=c[a+(q+12)>>2]|0;do{if((t|0)==(o|0)){u=a+(q+20)|0;t=c[u>>2]|0;if((t|0)==0){u=a+(q+16)|0;t=c[u>>2]|0;if((t|0)==0){p=0;break}}while(1){w=t+20|0;v=c[w>>2]|0;if((v|0)!=0){t=v;u=w;continue}v=t+16|0;w=c[v>>2]|0;if((w|0)==0){break}else{t=w;u=v}}if(u>>>0<r>>>0){Vb()}else{c[u>>2]=0;p=t;break}}else{u=c[a+(q+8)>>2]|0;if(u>>>0<r>>>0){Vb()}r=u+12|0;if((c[r>>2]|0)!=(o|0)){Vb()}v=t+8|0;if((c[v>>2]|0)==(o|0)){c[r>>2]=t;c[v>>2]=u;p=t;break}else{Vb()}}}while(0);if((s|0)!=0){t=c[a+(q+28)>>2]|0;r=25216+(t<<2)|0;if((o|0)==(c[r>>2]|0)){c[r>>2]=p;if((p|0)==0){c[24916>>2]=c[24916>>2]&~(1<<t);d=o;m=n;break}}else{if(s>>>0<(c[24928>>2]|0)>>>0){Vb()}r=s+16|0;if((c[r>>2]|0)==(o|0)){c[r>>2]=p}else{c[s+20>>2]=p}if((p|0)==0){d=o;m=n;break}}if(p>>>0<(c[24928>>2]|0)>>>0){Vb()}c[p+24>>2]=s;r=c[a+(q+16)>>2]|0;do{if((r|0)!=0){if(r>>>0<(c[24928>>2]|0)>>>0){Vb()}else{c[p+16>>2]=r;c[r+24>>2]=p;break}}}while(0);q=c[a+(q+20)>>2]|0;if((q|0)!=0){if(q>>>0<(c[24928>>2]|0)>>>0){Vb()}else{c[p+20>>2]=q;c[q+24>>2]=p;d=o;m=n;break}}else{d=o;m=n}}else{d=o;m=n}}else{d=q;m=j}}while(0);if(!(d>>>0<h>>>0)){Vb()}n=a+(j+ -4)|0;o=c[n>>2]|0;if((o&1|0)==0){Vb()}if((o&2|0)==0){if((h|0)==(c[24936>>2]|0)){w=(c[24924>>2]|0)+m|0;c[24924>>2]=w;c[24936>>2]=d;c[d+4>>2]=w|1;if((d|0)!=(c[24932>>2]|0)){i=b;return}c[24932>>2]=0;c[24920>>2]=0;i=b;return}if((h|0)==(c[24932>>2]|0)){w=(c[24920>>2]|0)+m|0;c[24920>>2]=w;c[24932>>2]=d;c[d+4>>2]=w|1;c[d+w>>2]=w;i=b;return}m=(o&-8)+m|0;n=o>>>3;do{if(!(o>>>0<256)){l=c[a+(j+16)>>2]|0;q=c[a+(j|4)>>2]|0;do{if((q|0)==(h|0)){o=a+(j+12)|0;n=c[o>>2]|0;if((n|0)==0){o=a+(j+8)|0;n=c[o>>2]|0;if((n|0)==0){k=0;break}}while(1){p=n+20|0;q=c[p>>2]|0;if((q|0)!=0){n=q;o=p;continue}p=n+16|0;q=c[p>>2]|0;if((q|0)==0){break}else{n=q;o=p}}if(o>>>0<(c[24928>>2]|0)>>>0){Vb()}else{c[o>>2]=0;k=n;break}}else{o=c[a+j>>2]|0;if(o>>>0<(c[24928>>2]|0)>>>0){Vb()}p=o+12|0;if((c[p>>2]|0)!=(h|0)){Vb()}n=q+8|0;if((c[n>>2]|0)==(h|0)){c[p>>2]=q;c[n>>2]=o;k=q;break}else{Vb()}}}while(0);if((l|0)!=0){n=c[a+(j+20)>>2]|0;o=25216+(n<<2)|0;if((h|0)==(c[o>>2]|0)){c[o>>2]=k;if((k|0)==0){c[24916>>2]=c[24916>>2]&~(1<<n);break}}else{if(l>>>0<(c[24928>>2]|0)>>>0){Vb()}n=l+16|0;if((c[n>>2]|0)==(h|0)){c[n>>2]=k}else{c[l+20>>2]=k}if((k|0)==0){break}}if(k>>>0<(c[24928>>2]|0)>>>0){Vb()}c[k+24>>2]=l;h=c[a+(j+8)>>2]|0;do{if((h|0)!=0){if(h>>>0<(c[24928>>2]|0)>>>0){Vb()}else{c[k+16>>2]=h;c[h+24>>2]=k;break}}}while(0);h=c[a+(j+12)>>2]|0;if((h|0)!=0){if(h>>>0<(c[24928>>2]|0)>>>0){Vb()}else{c[k+20>>2]=h;c[h+24>>2]=k;break}}}}else{k=c[a+j>>2]|0;a=c[a+(j|4)>>2]|0;j=24952+(n<<1<<2)|0;if((k|0)!=(j|0)){if(k>>>0<(c[24928>>2]|0)>>>0){Vb()}if((c[k+12>>2]|0)!=(h|0)){Vb()}}if((a|0)==(k|0)){c[6228]=c[6228]&~(1<<n);break}if((a|0)!=(j|0)){if(a>>>0<(c[24928>>2]|0)>>>0){Vb()}j=a+8|0;if((c[j>>2]|0)==(h|0)){l=j}else{Vb()}}else{l=a+8|0}c[k+12>>2]=a;c[l>>2]=k}}while(0);c[d+4>>2]=m|1;c[d+m>>2]=m;if((d|0)==(c[24932>>2]|0)){c[24920>>2]=m;i=b;return}}else{c[n>>2]=o&-2;c[d+4>>2]=m|1;c[d+m>>2]=m}h=m>>>3;if(m>>>0<256){a=h<<1;e=24952+(a<<2)|0;j=c[6228]|0;h=1<<h;if((j&h|0)!=0){h=24952+(a+2<<2)|0;a=c[h>>2]|0;if(a>>>0<(c[24928>>2]|0)>>>0){Vb()}else{f=h;g=a}}else{c[6228]=j|h;f=24952+(a+2<<2)|0;g=e}c[f>>2]=d;c[g+12>>2]=d;c[d+8>>2]=g;c[d+12>>2]=e;i=b;return}f=m>>>8;if((f|0)!=0){if(m>>>0>16777215){f=31}else{v=(f+1048320|0)>>>16&8;w=f<<v;u=(w+520192|0)>>>16&4;w=w<<u;f=(w+245760|0)>>>16&2;f=14-(u|v|f)+(w<<f>>>15)|0;f=m>>>(f+7|0)&1|f<<1}}else{f=0}g=25216+(f<<2)|0;c[d+28>>2]=f;c[d+20>>2]=0;c[d+16>>2]=0;a=c[24916>>2]|0;h=1<<f;a:do{if((a&h|0)!=0){g=c[g>>2]|0;if((f|0)==31){f=0}else{f=25-(f>>>1)|0}b:do{if((c[g+4>>2]&-8|0)!=(m|0)){f=m<<f;a=g;while(1){h=a+(f>>>31<<2)+16|0;g=c[h>>2]|0;if((g|0)==0){break}if((c[g+4>>2]&-8|0)==(m|0)){e=g;break b}else{f=f<<1;a=g}}if(h>>>0<(c[24928>>2]|0)>>>0){Vb()}else{c[h>>2]=d;c[d+24>>2]=a;c[d+12>>2]=d;c[d+8>>2]=d;break a}}else{e=g}}while(0);g=e+8|0;f=c[g>>2]|0;h=c[24928>>2]|0;if(e>>>0<h>>>0){Vb()}if(f>>>0<h>>>0){Vb()}else{c[f+12>>2]=d;c[g>>2]=d;c[d+8>>2]=f;c[d+12>>2]=e;c[d+24>>2]=0;break}}else{c[24916>>2]=a|h;c[g>>2]=d;c[d+24>>2]=g;c[d+12>>2]=d;c[d+8>>2]=d}}while(0);w=(c[24944>>2]|0)+ -1|0;c[24944>>2]=w;if((w|0)==0){d=25368|0}else{i=b;return}while(1){d=c[d>>2]|0;if((d|0)==0){break}else{d=d+8|0}}c[24944>>2]=-1;i=b;return}function Cv(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;d=i;do{if((a|0)!=0){if(b>>>0>4294967231){e=nc()|0;c[e>>2]=12;e=0;break}if(b>>>0<11){e=16}else{e=b+11&-8}e=Dv(a+ -8|0,e)|0;if((e|0)!=0){e=e+8|0;break}e=Av(b)|0;if((e|0)==0){e=0}else{f=c[a+ -4>>2]|0;f=(f&-8)-((f&3|0)==0?8:4)|0;tw(e|0,a|0,(f>>>0<b>>>0?f:b)|0)|0;Bv(a)}}else{e=Av(b)|0}}while(0);i=d;return e|0}function Dv(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;d=i;e=a+4|0;g=c[e>>2]|0;j=g&-8;f=a+j|0;l=c[24928>>2]|0;if(a>>>0<l>>>0){Vb()}n=g&3;if(!((n|0)!=1&a>>>0<f>>>0)){Vb()}h=a+(j|4)|0;o=c[h>>2]|0;if((o&1|0)==0){Vb()}if((n|0)==0){if(b>>>0<256){q=0;i=d;return q|0}if(!(j>>>0<(b+4|0)>>>0)?!((j-b|0)>>>0>c[25392>>2]<<1>>>0):0){q=a;i=d;return q|0}q=0;i=d;return q|0}if(!(j>>>0<b>>>0)){f=j-b|0;if(!(f>>>0>15)){q=a;i=d;return q|0}c[e>>2]=g&1|b|2;c[a+(b+4)>>2]=f|3;c[h>>2]=c[h>>2]|1;Ev(a+b|0,f);q=a;i=d;return q|0}if((f|0)==(c[24936>>2]|0)){f=(c[24924>>2]|0)+j|0;if(!(f>>>0>b>>>0)){q=0;i=d;return q|0}q=f-b|0;c[e>>2]=g&1|b|2;c[a+(b+4)>>2]=q|1;c[24936>>2]=a+b;c[24924>>2]=q;q=a;i=d;return q|0}if((f|0)==(c[24932>>2]|0)){h=(c[24920>>2]|0)+j|0;if(h>>>0<b>>>0){q=0;i=d;return q|0}f=h-b|0;if(f>>>0>15){c[e>>2]=g&1|b|2;c[a+(b+4)>>2]=f|1;c[a+h>>2]=f;q=a+(h+4)|0;c[q>>2]=c[q>>2]&-2;b=a+b|0}else{c[e>>2]=g&1|h|2;b=a+(h+4)|0;c[b>>2]=c[b>>2]|1;b=0;f=0}c[24920>>2]=f;c[24932>>2]=b;q=a;i=d;return q|0}if((o&2|0)!=0){q=0;i=d;return q|0}h=(o&-8)+j|0;if(h>>>0<b>>>0){q=0;i=d;return q|0}g=h-b|0;n=o>>>3;do{if(!(o>>>0<256)){m=c[a+(j+24)>>2]|0;o=c[a+(j+12)>>2]|0;do{if((o|0)==(f|0)){o=a+(j+20)|0;n=c[o>>2]|0;if((n|0)==0){o=a+(j+16)|0;n=c[o>>2]|0;if((n|0)==0){k=0;break}}while(1){q=n+20|0;p=c[q>>2]|0;if((p|0)!=0){n=p;o=q;continue}q=n+16|0;p=c[q>>2]|0;if((p|0)==0){break}else{n=p;o=q}}if(o>>>0<l>>>0){Vb()}else{c[o>>2]=0;k=n;break}}else{n=c[a+(j+8)>>2]|0;if(n>>>0<l>>>0){Vb()}p=n+12|0;if((c[p>>2]|0)!=(f|0)){Vb()}l=o+8|0;if((c[l>>2]|0)==(f|0)){c[p>>2]=o;c[l>>2]=n;k=o;break}else{Vb()}}}while(0);if((m|0)!=0){l=c[a+(j+28)>>2]|0;n=25216+(l<<2)|0;if((f|0)==(c[n>>2]|0)){c[n>>2]=k;if((k|0)==0){c[24916>>2]=c[24916>>2]&~(1<<l);break}}else{if(m>>>0<(c[24928>>2]|0)>>>0){Vb()}l=m+16|0;if((c[l>>2]|0)==(f|0)){c[l>>2]=k}else{c[m+20>>2]=k}if((k|0)==0){break}}if(k>>>0<(c[24928>>2]|0)>>>0){Vb()}c[k+24>>2]=m;f=c[a+(j+16)>>2]|0;do{if((f|0)!=0){if(f>>>0<(c[24928>>2]|0)>>>0){Vb()}else{c[k+16>>2]=f;c[f+24>>2]=k;break}}}while(0);f=c[a+(j+20)>>2]|0;if((f|0)!=0){if(f>>>0<(c[24928>>2]|0)>>>0){Vb()}else{c[k+20>>2]=f;c[f+24>>2]=k;break}}}}else{k=c[a+(j+8)>>2]|0;j=c[a+(j+12)>>2]|0;o=24952+(n<<1<<2)|0;if((k|0)!=(o|0)){if(k>>>0<l>>>0){Vb()}if((c[k+12>>2]|0)!=(f|0)){Vb()}}if((j|0)==(k|0)){c[6228]=c[6228]&~(1<<n);break}if((j|0)!=(o|0)){if(j>>>0<l>>>0){Vb()}l=j+8|0;if((c[l>>2]|0)==(f|0)){m=l}else{Vb()}}else{m=j+8|0}c[k+12>>2]=j;c[m>>2]=k}}while(0);if(g>>>0<16){c[e>>2]=h|c[e>>2]&1|2;q=a+(h|4)|0;c[q>>2]=c[q>>2]|1;q=a;i=d;return q|0}else{c[e>>2]=c[e>>2]&1|b|2;c[a+(b+4)>>2]=g|3;q=a+(h|4)|0;c[q>>2]=c[q>>2]|1;Ev(a+b|0,g);q=a;i=d;return q|0}return 0}function Ev(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0;d=i;h=a+b|0;l=c[a+4>>2]|0;do{if((l&1|0)==0){p=c[a>>2]|0;if((l&3|0)==0){i=d;return}l=a+(0-p)|0;m=p+b|0;q=c[24928>>2]|0;if(l>>>0<q>>>0){Vb()}if((l|0)==(c[24932>>2]|0)){e=a+(b+4)|0;if((c[e>>2]&3|0)!=3){e=l;n=m;break}c[24920>>2]=m;c[e>>2]=c[e>>2]&-2;c[a+(4-p)>>2]=m|1;c[h>>2]=m;i=d;return}s=p>>>3;if(p>>>0<256){e=c[a+(8-p)>>2]|0;n=c[a+(12-p)>>2]|0;o=24952+(s<<1<<2)|0;if((e|0)!=(o|0)){if(e>>>0<q>>>0){Vb()}if((c[e+12>>2]|0)!=(l|0)){Vb()}}if((n|0)==(e|0)){c[6228]=c[6228]&~(1<<s);e=l;n=m;break}if((n|0)!=(o|0)){if(n>>>0<q>>>0){Vb()}o=n+8|0;if((c[o>>2]|0)==(l|0)){r=o}else{Vb()}}else{r=n+8|0}c[e+12>>2]=n;c[r>>2]=e;e=l;n=m;break}r=c[a+(24-p)>>2]|0;t=c[a+(12-p)>>2]|0;do{if((t|0)==(l|0)){u=16-p|0;t=a+(u+4)|0;s=c[t>>2]|0;if((s|0)==0){t=a+u|0;s=c[t>>2]|0;if((s|0)==0){o=0;break}}while(1){u=s+20|0;v=c[u>>2]|0;if((v|0)!=0){s=v;t=u;continue}v=s+16|0;u=c[v>>2]|0;if((u|0)==0){break}else{s=u;t=v}}if(t>>>0<q>>>0){Vb()}else{c[t>>2]=0;o=s;break}}else{s=c[a+(8-p)>>2]|0;if(s>>>0<q>>>0){Vb()}u=s+12|0;if((c[u>>2]|0)!=(l|0)){Vb()}q=t+8|0;if((c[q>>2]|0)==(l|0)){c[u>>2]=t;c[q>>2]=s;o=t;break}else{Vb()}}}while(0);if((r|0)!=0){q=c[a+(28-p)>>2]|0;s=25216+(q<<2)|0;if((l|0)==(c[s>>2]|0)){c[s>>2]=o;if((o|0)==0){c[24916>>2]=c[24916>>2]&~(1<<q);e=l;n=m;break}}else{if(r>>>0<(c[24928>>2]|0)>>>0){Vb()}q=r+16|0;if((c[q>>2]|0)==(l|0)){c[q>>2]=o}else{c[r+20>>2]=o}if((o|0)==0){e=l;n=m;break}}if(o>>>0<(c[24928>>2]|0)>>>0){Vb()}c[o+24>>2]=r;p=16-p|0;q=c[a+p>>2]|0;do{if((q|0)!=0){if(q>>>0<(c[24928>>2]|0)>>>0){Vb()}else{c[o+16>>2]=q;c[q+24>>2]=o;break}}}while(0);p=c[a+(p+4)>>2]|0;if((p|0)!=0){if(p>>>0<(c[24928>>2]|0)>>>0){Vb()}else{c[o+20>>2]=p;c[p+24>>2]=o;e=l;n=m;break}}else{e=l;n=m}}else{e=l;n=m}}else{e=a;n=b}}while(0);l=c[24928>>2]|0;if(h>>>0<l>>>0){Vb()}m=a+(b+4)|0;o=c[m>>2]|0;if((o&2|0)==0){if((h|0)==(c[24936>>2]|0)){v=(c[24924>>2]|0)+n|0;c[24924>>2]=v;c[24936>>2]=e;c[e+4>>2]=v|1;if((e|0)!=(c[24932>>2]|0)){i=d;return}c[24932>>2]=0;c[24920>>2]=0;i=d;return}if((h|0)==(c[24932>>2]|0)){v=(c[24920>>2]|0)+n|0;c[24920>>2]=v;c[24932>>2]=e;c[e+4>>2]=v|1;c[e+v>>2]=v;i=d;return}n=(o&-8)+n|0;m=o>>>3;do{if(!(o>>>0<256)){k=c[a+(b+24)>>2]|0;m=c[a+(b+12)>>2]|0;do{if((m|0)==(h|0)){o=a+(b+20)|0;m=c[o>>2]|0;if((m|0)==0){o=a+(b+16)|0;m=c[o>>2]|0;if((m|0)==0){j=0;break}}while(1){q=m+20|0;p=c[q>>2]|0;if((p|0)!=0){m=p;o=q;continue}p=m+16|0;q=c[p>>2]|0;if((q|0)==0){break}else{m=q;o=p}}if(o>>>0<l>>>0){Vb()}else{c[o>>2]=0;j=m;break}}else{o=c[a+(b+8)>>2]|0;if(o>>>0<l>>>0){Vb()}l=o+12|0;if((c[l>>2]|0)!=(h|0)){Vb()}p=m+8|0;if((c[p>>2]|0)==(h|0)){c[l>>2]=m;c[p>>2]=o;j=m;break}else{Vb()}}}while(0);if((k|0)!=0){l=c[a+(b+28)>>2]|0;m=25216+(l<<2)|0;if((h|0)==(c[m>>2]|0)){c[m>>2]=j;if((j|0)==0){c[24916>>2]=c[24916>>2]&~(1<<l);break}}else{if(k>>>0<(c[24928>>2]|0)>>>0){Vb()}l=k+16|0;if((c[l>>2]|0)==(h|0)){c[l>>2]=j}else{c[k+20>>2]=j}if((j|0)==0){break}}if(j>>>0<(c[24928>>2]|0)>>>0){Vb()}c[j+24>>2]=k;h=c[a+(b+16)>>2]|0;do{if((h|0)!=0){if(h>>>0<(c[24928>>2]|0)>>>0){Vb()}else{c[j+16>>2]=h;c[h+24>>2]=j;break}}}while(0);h=c[a+(b+20)>>2]|0;if((h|0)!=0){if(h>>>0<(c[24928>>2]|0)>>>0){Vb()}else{c[j+20>>2]=h;c[h+24>>2]=j;break}}}}else{j=c[a+(b+8)>>2]|0;a=c[a+(b+12)>>2]|0;b=24952+(m<<1<<2)|0;if((j|0)!=(b|0)){if(j>>>0<l>>>0){Vb()}if((c[j+12>>2]|0)!=(h|0)){Vb()}}if((a|0)==(j|0)){c[6228]=c[6228]&~(1<<m);break}if((a|0)!=(b|0)){if(a>>>0<l>>>0){Vb()}b=a+8|0;if((c[b>>2]|0)==(h|0)){k=b}else{Vb()}}else{k=a+8|0}c[j+12>>2]=a;c[k>>2]=j}}while(0);c[e+4>>2]=n|1;c[e+n>>2]=n;if((e|0)==(c[24932>>2]|0)){c[24920>>2]=n;i=d;return}}else{c[m>>2]=o&-2;c[e+4>>2]=n|1;c[e+n>>2]=n}a=n>>>3;if(n>>>0<256){b=a<<1;h=24952+(b<<2)|0;j=c[6228]|0;a=1<<a;if((j&a|0)!=0){b=24952+(b+2<<2)|0;a=c[b>>2]|0;if(a>>>0<(c[24928>>2]|0)>>>0){Vb()}else{g=b;f=a}}else{c[6228]=j|a;g=24952+(b+2<<2)|0;f=h}c[g>>2]=e;c[f+12>>2]=e;c[e+8>>2]=f;c[e+12>>2]=h;i=d;return}f=n>>>8;if((f|0)!=0){if(n>>>0>16777215){f=31}else{u=(f+1048320|0)>>>16&8;v=f<<u;t=(v+520192|0)>>>16&4;v=v<<t;f=(v+245760|0)>>>16&2;f=14-(t|u|f)+(v<<f>>>15)|0;f=n>>>(f+7|0)&1|f<<1}}else{f=0}a=25216+(f<<2)|0;c[e+28>>2]=f;c[e+20>>2]=0;c[e+16>>2]=0;h=c[24916>>2]|0;g=1<<f;if((h&g|0)==0){c[24916>>2]=h|g;c[a>>2]=e;c[e+24>>2]=a;c[e+12>>2]=e;c[e+8>>2]=e;i=d;return}g=c[a>>2]|0;if((f|0)==31){f=0}else{f=25-(f>>>1)|0}a:do{if((c[g+4>>2]&-8|0)!=(n|0)){f=n<<f;a=g;while(1){h=a+(f>>>31<<2)+16|0;g=c[h>>2]|0;if((g|0)==0){break}if((c[g+4>>2]&-8|0)==(n|0)){break a}else{f=f<<1;a=g}}if(h>>>0<(c[24928>>2]|0)>>>0){Vb()}c[h>>2]=e;c[e+24>>2]=a;c[e+12>>2]=e;c[e+8>>2]=e;i=d;return}}while(0);f=g+8|0;a=c[f>>2]|0;h=c[24928>>2]|0;if(g>>>0<h>>>0){Vb()}if(a>>>0<h>>>0){Vb()}c[a+12>>2]=e;c[f>>2]=e;c[e+8>>2]=a;c[e+12>>2]=g;c[e+24>>2]=0;i=d;return}function Fv(a){a=a|0;var b=0,d=0,e=0,f=0;d=i;a=(a|0)==0?1:a;while(1){f=Av(a)|0;if((f|0)!=0){a=10;break}f=c[6352]|0;c[6352]=f+0;if((f|0)==0){a=9;break}u=0;Oa(f|0);f=u;u=0;if(f&1){a=5;break}}do{if((a|0)==5){b=qb(-1,-1,25472)|0;e=J}else if((a|0)==9){f=Jb(4)|0;c[f>>2]=25424;u=0;Na(45,f|0,25472,181);f=u;u=0;if(f&1){b=qb(-1,-1,25472)|0;e=J;break}}else if((a|0)==10){i=d;return f|0}}while(0);if((e|0)<0){xb(b|0)}else{vb(b|0)}return 0}function Gv(a){a=a|0;var b=0,c=0;b=i;u=0;a=qa(119,a|0)|0;c=u;u=0;if(!(c&1)){i=b;return a|0}b=qb(-1,-1,25472)|0;if((J|0)<0){xb(b|0)}else{vb(b|0)}return 0}function Hv(a){a=a|0;var b=0;b=i;if((a|0)!=0){Bv(a)}i=b;return}function Iv(a){a=a|0;var b=0;b=i;Hv(a);i=b;return}function Jv(a){a=a|0;var b=0;b=i;ib(a|0);Hv(a);i=b;return}function Kv(a){a=a|0;var b=0;b=i;ib(a|0);i=b;return}function Lv(a){a=a|0;return 25440}function Mv(){var a=0;a=Jb(4)|0;c[a>>2]=25424;qc(a|0,25472,181)}function Nv(a){a=a|0;if((a|0)==32){a=1}else{a=(a+ -9|0)>>>0<5}return a&1|0}function Ov(b,e,f,g,h){b=b|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;j=i;if(e>>>0>36){s=nc()|0;c[s>>2]=22;s=0;t=0;J=s;i=j;return t|0}k=b+4|0;l=b+100|0;do{m=c[k>>2]|0;if(m>>>0<(c[l>>2]|0)>>>0){c[k>>2]=m+1;o=d[m>>0]|0}else{o=Sv(b)|0}}while((Nv(o)|0)!=0);do{if((o|0)==43|(o|0)==45){m=((o|0)==45)<<31>>31;n=c[k>>2]|0;if(n>>>0<(c[l>>2]|0)>>>0){c[k>>2]=n+1;o=d[n>>0]|0;break}else{o=Sv(b)|0;break}}else{m=0}}while(0);n=(e|0)==0;do{if((e&-17|0)==0&(o|0)==48){o=c[k>>2]|0;if(o>>>0<(c[l>>2]|0)>>>0){c[k>>2]=o+1;o=d[o>>0]|0}else{o=Sv(b)|0}if((o|32|0)!=120){f=n?8:e;e=32;break}e=c[k>>2]|0;if(e>>>0<(c[l>>2]|0)>>>0){c[k>>2]=e+1;o=d[e>>0]|0}else{o=Sv(b)|0}if((d[o+25489>>0]|0)>15){l=(c[l>>2]|0)==0;if(!l){c[k>>2]=(c[k>>2]|0)+ -1}if((f|0)==0){Rv(b,0);s=0;t=0;J=s;i=j;return t|0}if(l){s=0;t=0;J=s;i=j;return t|0}c[k>>2]=(c[k>>2]|0)+ -1;s=0;t=0;J=s;i=j;return t|0}else{f=16;e=47}}else{f=n?10:e;if((d[o+25489>>0]|0)>>>0<f>>>0){e=32}else{if((c[l>>2]|0)!=0){c[k>>2]=(c[k>>2]|0)+ -1}Rv(b,0);s=nc()|0;c[s>>2]=22;s=0;t=0;J=s;i=j;return t|0}}}while(0);if((e|0)==32){if((f|0)==10){f=o+ -48|0;if(f>>>0<10){n=0;while(1){n=n+f|0;f=c[k>>2]|0;if(f>>>0<(c[l>>2]|0)>>>0){c[k>>2]=f+1;o=d[f>>0]|0}else{o=Sv(b)|0}f=o+ -48|0;if(!(f>>>0<10&n>>>0<429496729)){break}n=n*10|0}p=0}else{n=0;p=0}f=o+ -48|0;if(f>>>0<10){do{q=Ew(n|0,p|0,10,0)|0;s=J;r=((f|0)<0)<<31>>31;t=~r;if(s>>>0>t>>>0|(s|0)==(t|0)&q>>>0>~f>>>0){break}n=qw(q|0,s|0,f|0,r|0)|0;p=J;f=c[k>>2]|0;if(f>>>0<(c[l>>2]|0)>>>0){c[k>>2]=f+1;o=d[f>>0]|0}else{o=Sv(b)|0}f=o+ -48|0}while(f>>>0<10&(p>>>0<429496729|(p|0)==429496729&n>>>0<2576980378));if(!(f>>>0>9)){f=10;e=73}}}else{e=47}}a:do{if((e|0)==47){if((f+ -1&f|0)==0){e=a[25752+((f*23|0)>>>5&7)>>0]|0;r=a[o+25489>>0]|0;n=r&255;if(n>>>0<f>>>0){o=n;n=0;do{n=o|n<<e;o=c[k>>2]|0;if(o>>>0<(c[l>>2]|0)>>>0){c[k>>2]=o+1;s=d[o>>0]|0}else{s=Sv(b)|0}r=a[s+25489>>0]|0;o=r&255}while(o>>>0<f>>>0&n>>>0<134217728);p=0}else{p=0;n=0;s=o}o=rw(-1,-1,e|0)|0;q=J;if((r&255)>>>0>=f>>>0|(p>>>0>q>>>0|(p|0)==(q|0)&n>>>0>o>>>0)){o=s;e=73;break}while(1){n=uw(n|0,p|0,e|0)|0;p=J;n=r&255|n;r=c[k>>2]|0;if(r>>>0<(c[l>>2]|0)>>>0){c[k>>2]=r+1;s=d[r>>0]|0}else{s=Sv(b)|0}r=a[s+25489>>0]|0;if((r&255)>>>0>=f>>>0|(p>>>0>q>>>0|(p|0)==(q|0)&n>>>0>o>>>0)){o=s;e=73;break a}}}r=a[o+25489>>0]|0;e=r&255;if(e>>>0<f>>>0){n=0;do{n=e+(fa(n,f)|0)|0;e=c[k>>2]|0;if(e>>>0<(c[l>>2]|0)>>>0){c[k>>2]=e+1;q=d[e>>0]|0}else{q=Sv(b)|0}r=a[q+25489>>0]|0;e=r&255}while(e>>>0<f>>>0&n>>>0<119304647);p=0}else{n=0;p=0;q=o}if((r&255)>>>0<f>>>0){o=Fw(-1,-1,f|0,0)|0;e=J;while(1){if(p>>>0>e>>>0|(p|0)==(e|0)&n>>>0>o>>>0){o=q;e=73;break a}s=Ew(n|0,p|0,f|0,0)|0;t=J;r=r&255;if(t>>>0>4294967295|(t|0)==-1&s>>>0>~r>>>0){o=q;e=73;break a}n=qw(r|0,0,s|0,t|0)|0;p=J;q=c[k>>2]|0;if(q>>>0<(c[l>>2]|0)>>>0){c[k>>2]=q+1;q=d[q>>0]|0}else{q=Sv(b)|0}r=a[q+25489>>0]|0;if(!((r&255)>>>0<f>>>0)){o=q;e=73;break}}}else{o=q;e=73}}}while(0);if((e|0)==73){if((d[o+25489>>0]|0)>>>0<f>>>0){do{e=c[k>>2]|0;if(e>>>0<(c[l>>2]|0)>>>0){c[k>>2]=e+1;e=d[e>>0]|0}else{e=Sv(b)|0}}while((d[e+25489>>0]|0)>>>0<f>>>0);p=nc()|0;c[p>>2]=34;p=h;n=g}}if((c[l>>2]|0)!=0){c[k>>2]=(c[k>>2]|0)+ -1}if(!(p>>>0<h>>>0|(p|0)==(h|0)&n>>>0<g>>>0)){if((g&1|0)==0&0==0&(m|0)==0){t=nc()|0;c[t>>2]=34;t=qw(g|0,h|0,-1,-1)|0;s=J;J=s;i=j;return t|0}if(p>>>0>h>>>0|(p|0)==(h|0)&n>>>0>g>>>0){s=nc()|0;c[s>>2]=34;s=h;t=g;J=s;i=j;return t|0}}t=((m|0)<0)<<31>>31;t=pw(n^m|0,p^t|0,m|0,t|0)|0;s=J;J=s;i=j;return t|0}function Pv(b,e,f){b=b|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0.0,s=0,t=0,u=0,v=0,w=0,x=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0.0,I=0,K=0.0,L=0.0,M=0.0,N=0.0;g=i;i=i+512|0;k=g;if((e|0)==2){e=53;h=-1074}else if((e|0)==1){e=53;h=-1074}else if((e|0)==0){e=24;h=-149}else{L=0.0;i=g;return+L}n=b+4|0;o=b+100|0;do{j=c[n>>2]|0;if(j>>>0<(c[o>>2]|0)>>>0){c[n>>2]=j+1;w=d[j>>0]|0}else{w=Sv(b)|0}}while((Nv(w)|0)!=0);do{if((w|0)==43|(w|0)==45){j=1-(((w|0)==45&1)<<1)|0;m=c[n>>2]|0;if(m>>>0<(c[o>>2]|0)>>>0){c[n>>2]=m+1;w=d[m>>0]|0;break}else{w=Sv(b)|0;break}}else{j=1}}while(0);m=0;do{if((w|32|0)!=(a[25768+m>>0]|0)){break}do{if(m>>>0<7){p=c[n>>2]|0;if(p>>>0<(c[o>>2]|0)>>>0){c[n>>2]=p+1;w=d[p>>0]|0;break}else{w=Sv(b)|0;break}}}while(0);m=m+1|0}while(m>>>0<8);do{if((m|0)==3){q=23}else if((m|0)!=8){p=(f|0)==0;if(!(m>>>0<4|p)){if((m|0)==8){break}else{q=23;break}}a:do{if((m|0)==0){m=0;do{if((w|32|0)!=(a[25784+m>>0]|0)){break a}do{if(m>>>0<2){s=c[n>>2]|0;if(s>>>0<(c[o>>2]|0)>>>0){c[n>>2]=s+1;w=d[s>>0]|0;break}else{w=Sv(b)|0;break}}}while(0);m=m+1|0}while(m>>>0<3)}}while(0);if((m|0)==3){e=c[n>>2]|0;if(e>>>0<(c[o>>2]|0)>>>0){c[n>>2]=e+1;e=d[e>>0]|0}else{e=Sv(b)|0}if((e|0)==40){e=1}else{if((c[o>>2]|0)==0){L=y;i=g;return+L}c[n>>2]=(c[n>>2]|0)+ -1;L=y;i=g;return+L}while(1){h=c[n>>2]|0;if(h>>>0<(c[o>>2]|0)>>>0){c[n>>2]=h+1;h=d[h>>0]|0}else{h=Sv(b)|0}if(!((h+ -48|0)>>>0<10|(h+ -65|0)>>>0<26)?!((h+ -97|0)>>>0<26|(h|0)==95):0){break}e=e+1|0}if((h|0)==41){L=y;i=g;return+L}h=(c[o>>2]|0)==0;if(!h){c[n>>2]=(c[n>>2]|0)+ -1}if(p){I=nc()|0;c[I>>2]=22;Rv(b,0);L=0.0;i=g;return+L}if((e|0)==0|h){L=y;i=g;return+L}do{e=e+ -1|0;c[n>>2]=(c[n>>2]|0)+ -1}while((e|0)!=0);r=y;i=g;return+r}else if((m|0)==0){do{if((w|0)==48){m=c[n>>2]|0;if(m>>>0<(c[o>>2]|0)>>>0){c[n>>2]=m+1;m=d[m>>0]|0}else{m=Sv(b)|0}if((m|32|0)!=120){if((c[o>>2]|0)==0){w=48;break}c[n>>2]=(c[n>>2]|0)+ -1;w=48;break}k=c[n>>2]|0;if(k>>>0<(c[o>>2]|0)>>>0){c[n>>2]=k+1;A=d[k>>0]|0;w=0}else{A=Sv(b)|0;w=0}while(1){if((A|0)==46){q=70;break}else if((A|0)!=48){k=0;m=0;t=0;s=0;v=0;x=0;H=1.0;u=0;r=0.0;break}k=c[n>>2]|0;if(k>>>0<(c[o>>2]|0)>>>0){c[n>>2]=k+1;A=d[k>>0]|0;w=1;continue}else{A=Sv(b)|0;w=1;continue}}b:do{if((q|0)==70){k=c[n>>2]|0;if(k>>>0<(c[o>>2]|0)>>>0){c[n>>2]=k+1;A=d[k>>0]|0}else{A=Sv(b)|0}if((A|0)==48){t=-1;s=-1;while(1){k=c[n>>2]|0;if(k>>>0<(c[o>>2]|0)>>>0){c[n>>2]=k+1;A=d[k>>0]|0}else{A=Sv(b)|0}if((A|0)!=48){k=0;m=0;w=1;v=1;x=0;H=1.0;u=0;r=0.0;break b}I=qw(t|0,s|0,-1,-1)|0;t=I;s=J}}else{k=0;m=0;t=0;s=0;v=1;x=0;H=1.0;u=0;r=0.0}}}while(0);c:while(1){B=A+ -48|0;do{if(!(B>>>0<10)){C=A|32;D=(A|0)==46;if(!((C+ -97|0)>>>0<6|D)){break c}if(D){if((v|0)==0){t=m;s=k;v=1;break}else{A=46;break c}}else{B=(A|0)>57?C+ -87|0:B;q=84;break}}else{q=84}}while(0);if((q|0)==84){q=0;do{if(!((k|0)<0|(k|0)==0&m>>>0<8)){if((k|0)<0|(k|0)==0&m>>>0<14){L=H*.0625;K=L;r=r+L*+(B|0);break}if((B|0)!=0&(x|0)==0){x=1;K=H;r=r+H*.5}else{K=H}}else{K=H;u=B+(u<<4)|0}}while(0);m=qw(m|0,k|0,1,0)|0;k=J;w=1;H=K}A=c[n>>2]|0;if(A>>>0<(c[o>>2]|0)>>>0){c[n>>2]=A+1;A=d[A>>0]|0;continue}else{A=Sv(b)|0;continue}}if((w|0)==0){e=(c[o>>2]|0)==0;if(!e){c[n>>2]=(c[n>>2]|0)+ -1}if(!p){if(!e?(l=c[n>>2]|0,c[n>>2]=l+ -1,(v|0)!=0):0){c[n>>2]=l+ -2}}else{Rv(b,0)}L=+(j|0)*0.0;i=g;return+L}q=(v|0)==0;l=q?m:t;q=q?k:s;if((k|0)<0|(k|0)==0&m>>>0<8){do{u=u<<4;m=qw(m|0,k|0,1,0)|0;k=J}while((k|0)<0|(k|0)==0&m>>>0<8)}do{if((A|32|0)==112){m=Qv(b,f)|0;k=J;if((m|0)==0&(k|0)==-2147483648){if(p){Rv(b,0);L=0.0;i=g;return+L}else{if((c[o>>2]|0)==0){m=0;k=0;break}c[n>>2]=(c[n>>2]|0)+ -1;m=0;k=0;break}}}else{if((c[o>>2]|0)==0){m=0;k=0}else{c[n>>2]=(c[n>>2]|0)+ -1;m=0;k=0}}}while(0);l=uw(l|0,q|0,2)|0;l=qw(l|0,J|0,-32,-1)|0;k=qw(l|0,J|0,m|0,k|0)|0;l=J;if((u|0)==0){L=+(j|0)*0.0;i=g;return+L}if((l|0)>0|(l|0)==0&k>>>0>(0-h|0)>>>0){I=nc()|0;c[I>>2]=34;L=+(j|0)*1.7976931348623157e+308*1.7976931348623157e+308;i=g;return+L}I=h+ -106|0;G=((I|0)<0)<<31>>31;if((l|0)<(G|0)|(l|0)==(G|0)&k>>>0<I>>>0){I=nc()|0;c[I>>2]=34;L=+(j|0)*2.2250738585072014e-308*2.2250738585072014e-308;i=g;return+L}if((u|0)>-1){do{u=u<<1;if(!(r>=.5)){H=r}else{H=r+-1.0;u=u|1}r=r+H;k=qw(k|0,l|0,-1,-1)|0;l=J}while((u|0)>-1)}h=pw(32,0,h|0,((h|0)<0)<<31>>31|0)|0;h=qw(k|0,l|0,h|0,J|0)|0;I=J;if(0>(I|0)|0==(I|0)&e>>>0>h>>>0){e=(h|0)<0?0:h}do{if((e|0)<53){H=+(j|0);K=+rc(+(+Vv(1.0,84-e|0)),+H);if(!((e|0)<32&r!=0.0)){break}I=u&1;u=(I^1)+u|0;r=(I|0)==0?0.0:r}else{H=+(j|0);K=0.0}}while(0);r=H*r+(K+H*+(u>>>0))-K;if(!(r!=0.0)){I=nc()|0;c[I>>2]=34}L=+Wv(r,k);i=g;return+L}}while(0);m=h+e|0;l=0-m|0;E=0;while(1){if((w|0)==46){q=139;break}else if((w|0)!=48){G=0;C=0;A=0;break}s=c[n>>2]|0;if(s>>>0<(c[o>>2]|0)>>>0){c[n>>2]=s+1;w=d[s>>0]|0;E=1;continue}else{w=Sv(b)|0;E=1;continue}}d:do{if((q|0)==139){s=c[n>>2]|0;if(s>>>0<(c[o>>2]|0)>>>0){c[n>>2]=s+1;w=d[s>>0]|0}else{w=Sv(b)|0}if((w|0)==48){G=-1;C=-1;while(1){s=c[n>>2]|0;if(s>>>0<(c[o>>2]|0)>>>0){c[n>>2]=s+1;w=d[s>>0]|0}else{w=Sv(b)|0}if((w|0)!=48){E=1;A=1;break d}I=qw(G|0,C|0,-1,-1)|0;G=I;C=J}}else{G=0;C=0;A=1}}}while(0);c[k>>2]=0;B=w+ -48|0;F=(w|0)==46;e:do{if(B>>>0<10|F){s=k+496|0;D=0;x=0;v=0;u=0;t=0;while(1){do{if(F){if((A|0)==0){G=D;C=x;A=1}else{s=G;break e}}else{I=qw(D|0,x|0,1,0)|0;x=J;F=(w|0)!=48;if((u|0)>=125){if(!F){D=I;break}c[s>>2]=c[s>>2]|1;D=I;break}D=k+(u<<2)|0;if((v|0)!=0){B=w+ -48+((c[D>>2]|0)*10|0)|0}c[D>>2]=B;v=v+1|0;B=(v|0)==9;D=I;E=1;v=B?0:v;u=(B&1)+u|0;t=F?I:t}}while(0);w=c[n>>2]|0;if(w>>>0<(c[o>>2]|0)>>>0){c[n>>2]=w+1;w=d[w>>0]|0}else{w=Sv(b)|0}B=w+ -48|0;F=(w|0)==46;if(!(B>>>0<10|F)){q=162;break}}}else{D=0;x=0;v=0;u=0;t=0;q=162}}while(0);if((q|0)==162){I=(A|0)==0;s=I?D:G;C=I?x:C}q=(E|0)!=0;if(q?(w|32|0)==101:0){w=Qv(b,f)|0;f=J;do{if((w|0)==0&(f|0)==-2147483648){if(p){Rv(b,0);L=0.0;i=g;return+L}else{if((c[o>>2]|0)==0){w=0;f=0;break}c[n>>2]=(c[n>>2]|0)+ -1;w=0;f=0;break}}}while(0);s=qw(w|0,f|0,s|0,C|0)|0;C=J}else{if((w|0)>-1?(c[o>>2]|0)!=0:0){c[n>>2]=(c[n>>2]|0)+ -1}}if(!q){I=nc()|0;c[I>>2]=22;Rv(b,0);L=0.0;i=g;return+L}b=c[k>>2]|0;if((b|0)==0){L=+(j|0)*0.0;i=g;return+L}do{if((s|0)==(D|0)&(C|0)==(x|0)&((x|0)<0|(x|0)==0&D>>>0<10)){if(!(e>>>0>30)?(b>>>e|0)!=0:0){break}L=+(j|0)*+(b>>>0);i=g;return+L}}while(0);I=(h|0)/-2|0;G=((I|0)<0)<<31>>31;if((C|0)>(G|0)|(C|0)==(G|0)&s>>>0>I>>>0){I=nc()|0;c[I>>2]=34;L=+(j|0)*1.7976931348623157e+308*1.7976931348623157e+308;i=g;return+L}I=h+ -106|0;G=((I|0)<0)<<31>>31;if((C|0)<(G|0)|(C|0)==(G|0)&s>>>0<I>>>0){I=nc()|0;c[I>>2]=34;L=+(j|0)*2.2250738585072014e-308*2.2250738585072014e-308;i=g;return+L}if((v|0)!=0){if((v|0)<9){n=k+(u<<2)|0;b=c[n>>2]|0;do{b=b*10|0;v=v+1|0}while((v|0)!=9);c[n>>2]=b}u=u+1|0}do{if((t|0)<9?(t|0)<=(s|0)&(s|0)<18:0){if((s|0)==9){L=+(j|0)*+((c[k>>2]|0)>>>0);i=g;return+L}if((s|0)<9){L=+(j|0)*+((c[k>>2]|0)>>>0)/+(c[25800+(8-s<<2)>>2]|0);i=g;return+L}I=e+27+(fa(s,-3)|0)|0;b=c[k>>2]|0;if((I|0)<=30?(b>>>I|0)!=0:0){break}L=+(j|0)*+(b>>>0)*+(c[25800+(s+ -10<<2)>>2]|0);i=g;return+L}}while(0);b=(s|0)%9|0;if((b|0)==0){n=0;o=0;b=s}else{b=(s|0)>-1?b:b+9|0;p=c[25800+(8-b<<2)>>2]|0;if((u|0)!=0){q=1e9/(p|0)|0;n=0;o=0;f=0;do{F=k+(f<<2)|0;G=c[F>>2]|0;I=((G>>>0)/(p>>>0)|0)+o|0;c[F>>2]=I;o=fa((G>>>0)%(p>>>0)|0,q)|0;G=f;f=f+1|0;if((G|0)==(n|0)&(I|0)==0){n=f&127;s=s+ -9|0}}while((f|0)!=(u|0));if((o|0)!=0){c[k+(u<<2)>>2]=o;u=u+1|0}}else{n=0;u=0}o=0;b=9-b+s|0}f:while(1){f=k+(n<<2)|0;if((b|0)<18){do{q=0;f=u+127|0;while(1){f=f&127;p=k+(f<<2)|0;s=uw(c[p>>2]|0,0,29)|0;s=qw(s|0,J|0,q|0,0)|0;q=J;if(q>>>0>0|(q|0)==0&s>>>0>1e9){I=Fw(s|0,q|0,1e9,0)|0;s=Gw(s|0,q|0,1e9,0)|0;q=I}else{q=0}c[p>>2]=s;p=(f|0)==(n|0);if(!((f|0)!=(u+127&127|0)|p)){u=(s|0)==0?f:u}if(p){break}else{f=f+ -1|0}}o=o+ -29|0}while((q|0)==0)}else{if((b|0)!=18){break}do{if(!((c[f>>2]|0)>>>0<9007199)){b=18;break f}q=0;p=u+127|0;while(1){p=p&127;s=k+(p<<2)|0;t=uw(c[s>>2]|0,0,29)|0;t=qw(t|0,J|0,q|0,0)|0;q=J;if(q>>>0>0|(q|0)==0&t>>>0>1e9){I=Fw(t|0,q|0,1e9,0)|0;t=Gw(t|0,q|0,1e9,0)|0;q=I}else{q=0}c[s>>2]=t;s=(p|0)==(n|0);if(!((p|0)!=(u+127&127|0)|s)){u=(t|0)==0?p:u}if(s){break}else{p=p+ -1|0}}o=o+ -29|0}while((q|0)==0)}n=n+127&127;if((n|0)==(u|0)){I=u+127&127;u=k+((u+126&127)<<2)|0;c[u>>2]=c[u>>2]|c[k+(I<<2)>>2];u=I}c[k+(n<<2)>>2]=q;b=b+9|0}g:while(1){f=u+1&127;p=k+((u+127&127)<<2)|0;while(1){s=(b|0)==18;q=(b|0)>27?9:1;while(1){t=0;while(1){v=t+n&127;if((v|0)==(u|0)){t=2;break}v=c[k+(v<<2)>>2]|0;x=c[25792+(t<<2)>>2]|0;if(v>>>0<x>>>0){t=2;break}w=t+1|0;if(v>>>0>x>>>0){break}if((w|0)<2){t=w}else{t=w;break}}if((t|0)==2&s){break g}o=q+o|0;if((n|0)==(u|0)){n=u}else{break}}v=(1<<q)+ -1|0;w=1e9>>>q;t=n;s=0;do{F=k+(n<<2)|0;G=c[F>>2]|0;I=(G>>>q)+s|0;c[F>>2]=I;s=fa(G&v,w)|0;I=(n|0)==(t|0)&(I|0)==0;n=n+1&127;b=I?b+ -9|0:b;t=I?n:t}while((n|0)!=(u|0));if((s|0)==0){n=t;continue}if((f|0)!=(t|0)){break}c[p>>2]=c[p>>2]|1;n=t}c[k+(u<<2)>>2]=s;n=t;u=f}b=n&127;if((b|0)==(u|0)){c[k+(f+ -1<<2)>>2]=0;u=f}H=+((c[k+(b<<2)>>2]|0)>>>0);b=n+1&127;if((b|0)==(u|0)){u=u+1&127;c[k+(u+ -1<<2)>>2]=0}r=+(j|0);K=r*(H*1.0e9+ +((c[k+(b<<2)>>2]|0)>>>0));j=o+53|0;h=j-h|0;if((h|0)<(e|0)){e=(h|0)<0?0:h;b=1}else{b=0}if((e|0)<53){N=+rc(+(+Vv(1.0,105-e|0)),+K);M=+Va(+K,+(+Vv(1.0,53-e|0)));H=N;L=M;K=N+(K-M)}else{H=0.0;L=0.0}f=n+2&127;do{if((f|0)!=(u|0)){k=c[k+(f<<2)>>2]|0;do{if(!(k>>>0<5e8)){if(k>>>0>5e8){L=r*.75+L;break}if((n+3&127|0)==(u|0)){L=r*.5+L;break}else{L=r*.75+L;break}}else{if((k|0)==0?(n+3&127|0)==(u|0):0){break}L=r*.25+L}}while(0);if((53-e|0)<=1){break}if(+Va(+L,1.0)!=0.0){break}L=L+1.0}}while(0);r=K+L-H;do{if((j&2147483647|0)>(-2-m|0)){if(+U(+r)>=9007199254740992.0){b=(b|0)!=0&(e|0)==(h|0)?0:b;o=o+1|0;r=r*.5}if((o+50|0)<=(l|0)?!((b|0)!=0&L!=0.0):0){break}I=nc()|0;c[I>>2]=34}}while(0);N=+Wv(r,o);i=g;return+N}else{if((c[o>>2]|0)!=0){c[n>>2]=(c[n>>2]|0)+ -1}I=nc()|0;c[I>>2]=22;Rv(b,0);N=0.0;i=g;return+N}}}while(0);if((q|0)==23){e=(c[o>>2]|0)==0;if(!e){c[n>>2]=(c[n>>2]|0)+ -1}if(!(m>>>0<4|(f|0)==0|e)){do{c[n>>2]=(c[n>>2]|0)+ -1;m=m+ -1|0}while(m>>>0>3)}}N=+(j|0)*z;i=g;return+N}function Qv(a,b){a=a|0;b=b|0;var e=0,f=0,g=0,h=0,j=0,k=0;e=i;g=a+4|0;h=c[g>>2]|0;f=a+100|0;if(h>>>0<(c[f>>2]|0)>>>0){c[g>>2]=h+1;j=d[h>>0]|0}else{j=Sv(a)|0}if((j|0)==43|(j|0)==45){h=(j|0)==45&1;j=c[g>>2]|0;if(j>>>0<(c[f>>2]|0)>>>0){c[g>>2]=j+1;j=d[j>>0]|0}else{j=Sv(a)|0}if(!((j+ -48|0)>>>0<10|(b|0)==0)?(c[f>>2]|0)!=0:0){c[g>>2]=(c[g>>2]|0)+ -1}}else{h=0}if((j+ -48|0)>>>0>9){if((c[f>>2]|0)==0){j=-2147483648;k=0;J=j;i=e;return k|0}c[g>>2]=(c[g>>2]|0)+ -1;j=-2147483648;k=0;J=j;i=e;return k|0}else{b=0}while(1){b=j+ -48+b|0;j=c[g>>2]|0;if(j>>>0<(c[f>>2]|0)>>>0){c[g>>2]=j+1;j=d[j>>0]|0}else{j=Sv(a)|0}if(!((j+ -48|0)>>>0<10&(b|0)<214748364)){break}b=b*10|0}k=((b|0)<0)<<31>>31;if((j+ -48|0)>>>0<10){do{k=Ew(b|0,k|0,10,0)|0;b=J;j=qw(j|0,((j|0)<0)<<31>>31|0,-48,-1)|0;b=qw(j|0,J|0,k|0,b|0)|0;k=J;j=c[g>>2]|0;if(j>>>0<(c[f>>2]|0)>>>0){c[g>>2]=j+1;j=d[j>>0]|0}else{j=Sv(a)|0}}while((j+ -48|0)>>>0<10&((k|0)<21474836|(k|0)==21474836&b>>>0<2061584302))}if((j+ -48|0)>>>0<10){do{j=c[g>>2]|0;if(j>>>0<(c[f>>2]|0)>>>0){c[g>>2]=j+1;j=d[j>>0]|0}else{j=Sv(a)|0}}while((j+ -48|0)>>>0<10)}if((c[f>>2]|0)!=0){c[g>>2]=(c[g>>2]|0)+ -1}g=(h|0)!=0;h=pw(0,0,b|0,k|0)|0;j=g?J:k;k=g?h:b;J=j;i=e;return k|0}function Rv(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;d=i;c[a+104>>2]=b;f=c[a+8>>2]|0;e=c[a+4>>2]|0;g=f-e|0;c[a+108>>2]=g;if((b|0)!=0&(g|0)>(b|0)){c[a+100>>2]=e+b;i=d;return}else{c[a+100>>2]=f;i=d;return}}function Sv(b){b=b|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0;f=i;j=b+104|0;l=c[j>>2]|0;if(!((l|0)!=0?(c[b+108>>2]|0)>=(l|0):0)){k=3}if((k|0)==3?(e=$v(b)|0,(e|0)>=0):0){k=c[j>>2]|0;j=c[b+8>>2]|0;if((k|0)!=0?(g=c[b+4>>2]|0,h=k-(c[b+108>>2]|0)+ -1|0,(j-g|0)>(h|0)):0){c[b+100>>2]=g+h}else{c[b+100>>2]=j}g=c[b+4>>2]|0;if((j|0)!=0){l=b+108|0;c[l>>2]=j+1-g+(c[l>>2]|0)}b=g+ -1|0;if((d[b>>0]|0|0)==(e|0)){l=e;i=f;return l|0}a[b>>0]=e;l=e;i=f;return l|0}c[b+100>>2]=0;l=-1;i=f;return l|0}function Tv(a,b){a=+a;b=b|0;var d=0,e=0,f=0,g=0;d=i;h[k>>3]=a;f=c[k>>2]|0;e=c[k+4>>2]|0;g=rw(f|0,e|0,52)|0;g=g&2047;if((g|0)==0){if(a!=0.0){a=+Tv(a*18446744073709552000.0,b);e=(c[b>>2]|0)+ -64|0}else{e=0}c[b>>2]=e;i=d;return+a}else if((g|0)==2047){i=d;return+a}else{c[b>>2]=g+ -1022;c[k>>2]=f;c[k+4>>2]=e&-2146435073|1071644672;a=+h[k>>3];i=d;return+a}return 0.0}function Uv(a,b){a=+a;b=b|0;var c=0;c=i;a=+Tv(a,b);i=c;return+a}function Vv(a,b){a=+a;b=b|0;var d=0,e=0;d=i;if((b|0)>1023){a=a*8.98846567431158e+307;e=b+ -1023|0;if((e|0)>1023){b=b+ -2046|0;b=(b|0)>1023?1023:b;a=a*8.98846567431158e+307}else{b=e}}else{if((b|0)<-1022){a=a*2.2250738585072014e-308;e=b+1022|0;if((e|0)<-1022){b=b+2044|0;b=(b|0)<-1022?-1022:b;a=a*2.2250738585072014e-308}else{b=e}}}b=uw(b+1023|0,0,52)|0;e=J;c[k>>2]=b;c[k+4>>2]=e;a=a*+h[k>>3];i=d;return+a}function Wv(a,b){a=+a;b=b|0;var c=0;c=i;a=+Vv(a,b);i=c;return+a}function Xv(a,b){a=a|0;b=b|0;var c=0;c=i;if((a|0)==0){a=0}else{a=Yv(a,b,0)|0}i=c;return a|0}function Yv(b,d,e){b=b|0;d=d|0;e=e|0;e=i;if((b|0)==0){b=1;i=e;return b|0}if(d>>>0<128){a[b>>0]=d;b=1;i=e;return b|0}if(d>>>0<2048){a[b>>0]=d>>>6|192;a[b+1>>0]=d&63|128;b=2;i=e;return b|0}if(d>>>0<55296|(d+ -57344|0)>>>0<8192){a[b>>0]=d>>>12|224;a[b+1>>0]=d>>>6&63|128;a[b+2>>0]=d&63|128;b=3;i=e;return b|0}if((d+ -65536|0)>>>0<1048576){a[b>>0]=d>>>18|240;a[b+1>>0]=d>>>12&63|128;a[b+2>>0]=d>>>6&63|128;a[b+3>>0]=d&63|128;b=4;i=e;return b|0}else{b=nc()|0;c[b>>2]=84;b=-1;i=e;return b|0}return 0}function Zv(b){b=b|0;var d=0,e=0,f=0;e=i;f=b+74|0;d=a[f>>0]|0;a[f>>0]=d+255|d;f=b+20|0;d=b+44|0;if((c[f>>2]|0)>>>0>(c[d>>2]|0)>>>0){Fc[c[b+36>>2]&63](b,0,0)|0}c[b+16>>2]=0;c[b+28>>2]=0;c[f>>2]=0;f=c[b>>2]|0;if((f&20|0)==0){f=c[d>>2]|0;c[b+8>>2]=f;c[b+4>>2]=f;f=0;i=e;return f|0}if((f&4|0)==0){f=-1;i=e;return f|0}c[b>>2]=f|32;f=-1;i=e;return f|0}function _v(b){b=b|0;var d=0,e=0,f=0;d=i;e=b+74|0;f=a[e>>0]|0;a[e>>0]=f+255|f;e=c[b>>2]|0;if((e&8|0)==0){c[b+8>>2]=0;c[b+4>>2]=0;f=c[b+44>>2]|0;c[b+28>>2]=f;c[b+20>>2]=f;c[b+16>>2]=f+(c[b+48>>2]|0);f=0;i=d;return f|0}else{c[b>>2]=e|32;f=-1;i=d;return f|0}return 0}function $v(a){a=a|0;var b=0,e=0;b=i;i=i+16|0;e=b;if((c[a+8>>2]|0)==0?(Zv(a)|0)!=0:0){a=-1}else{if((Fc[c[a+32>>2]&63](a,e,1)|0)==1){a=d[e>>0]|0}else{a=-1}}i=b;return a|0}function aw(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0;f=i;g=e+16|0;j=c[g>>2]|0;do{if((j|0)==0){if((_v(e)|0)==0){j=c[g>>2]|0;break}else{k=0;i=f;return k|0}}}while(0);g=e+20|0;h=c[g>>2]|0;if((j-h|0)>>>0<d>>>0){k=Fc[c[e+36>>2]&63](e,b,d)|0;i=f;return k|0}a:do{if((a[e+75>>0]|0)>-1){j=d;while(1){if((j|0)==0){j=0;break a}k=j+ -1|0;if((a[b+k>>0]|0)==10){break}else{j=k}}if((Fc[c[e+36>>2]&63](e,b,j)|0)>>>0<j>>>0){k=j;i=f;return k|0}else{d=d-j|0;b=b+j|0;h=c[g>>2]|0;break}}else{j=0}}while(0);tw(h|0,b|0,d|0)|0;c[g>>2]=(c[g>>2]|0)+d;k=j+d|0;i=f;return k|0}function bw(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0;f=i;i=i+16|0;g=f;c[g>>2]=e;e=ew(a,b,d,g)|0;i=f;return e|0}function cw(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0;e=i;i=i+224|0;j=e+120|0;g=e+80|0;f=e;h=e+136|0;k=g+0|0;l=k+40|0;do{c[k>>2]=0;k=k+4|0}while((k|0)<(l|0));c[j>>2]=c[d>>2];if((dw(0,b,j,f,g)|0)<0){o=-1;i=e;return o|0}k=a+48|0;if((c[k>>2]|0)==0){o=a+44|0;d=c[o>>2]|0;c[o>>2]=h;m=a+28|0;c[m>>2]=h;l=a+20|0;c[l>>2]=h;c[k>>2]=80;n=a+16|0;c[n>>2]=h+80;f=dw(a,b,j,f,g)|0;if((d|0)!=0){Fc[c[a+36>>2]&63](a,0,0)|0;f=(c[l>>2]|0)==0?-1:f;c[o>>2]=d;c[k>>2]=0;c[n>>2]=0;c[m>>2]=0;c[l>>2]=0}}else{f=dw(a,b,j,f,g)|0}o=f;i=e;return o|0}



function mg(a,b,d,e,f,h,j){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;var k=0,l=0,m=0.0,n=0,o=0,p=0,q=0,r=0,s=0.0,t=0,u=0,v=0.0,w=0,x=0,y=0.0,z=0.0,A=0.0,B=0.0;k=i;g[j>>2]=0.0;if((d|0)<=0){i=k;return}l=c[a+72>>2]|0;o=a+20|0;a=(f|0)>1;m=0.0;n=0;do{p=c[l+(c[b+(n<<2)>>2]<<2)>>2]|0;u=c[l+(c[e>>2]<<2)>>2]|0;x=c[o>>2]|0;q=p+(x<<2)|0;x=x+ -3|0;r=p+(x<<2)|0;if((x|0)>0){t=p;s=0.0;do{A=+g[t>>2]- +g[u>>2];z=+g[t+4>>2]- +g[u+4>>2];y=+g[t+8>>2]- +g[u+8>>2];v=+g[t+12>>2]- +g[u+12>>2];s=s+(A*A+z*z+y*y+v*v);t=t+16|0;u=u+16|0}while(t>>>0<r>>>0);r=t;t=u}else{r=p;t=u;s=0.0}if(r>>>0<q>>>0){while(1){A=+g[r>>2]- +g[t>>2];r=r+4|0;s=s+A*A;if(!(r>>>0<q>>>0)){break}else{t=t+4|0}}}q=h+(n<<2)|0;c[q>>2]=0;if(a){r=1;do{x=c[l+(c[e+(r<<2)>>2]<<2)>>2]|0;w=c[o>>2]|0;t=p+(w<<2)|0;w=w+ -3|0;u=p+(w<<2)|0;if((w|0)>0){w=p;v=0.0;do{B=+g[w>>2]- +g[x>>2];y=+g[w+4>>2]- +g[x+4>>2];z=+g[w+8>>2]- +g[x+8>>2];A=+g[w+12>>2]- +g[x+12>>2];v=v+(B*B+y*y+z*z+A*A);w=w+16|0;x=x+16|0}while(w>>>0<u>>>0)}else{w=p;v=0.0}if(w>>>0<t>>>0){while(1){B=+g[w>>2]- +g[x>>2];w=w+4|0;v=v+B*B;if(!(w>>>0<t>>>0)){break}else{x=x+4|0}}}if(s>v){c[q>>2]=r;s=v}r=r+1|0}while((r|0)!=(f|0))}m=s+m;g[j>>2]=m;n=n+1|0}while((n|0)!=(d|0));i=k;return}function ng(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0;e=i;f=a+8|0;d=a+4|0;k=c[d>>2]|0;j=c[f>>2]|0;g=k;if(!(j-g>>3>>>0<b>>>0)){do{if((k|0)==0){f=0}else{f=k;c[f>>2]=0;c[f+4>>2]=0;f=c[d>>2]|0}k=f+8|0;c[d>>2]=k;b=b+ -1|0}while((b|0)!=0);i=e;return}l=c[a>>2]|0;g=g-l>>3;k=g+b|0;if(k>>>0>536870911){ss(0)}j=j-l|0;if(j>>3>>>0<268435455){l=j>>2;k=l>>>0<k>>>0?k:l;if((k|0)==0){j=0;k=0}else{h=9}}else{k=536870911;h=9}if((h|0)==9){j=k;k=Fv(k<<3)|0}h=k+(g<<3)|0;do{if((h|0)==0){h=0}else{l=h;c[l>>2]=0;c[l+4>>2]=0}h=h+8|0;b=b+ -1|0}while((b|0)!=0);b=c[a>>2]|0;m=(c[d>>2]|0)-b|0;l=k+(g-(m>>3)<<3)|0;tw(l|0,b|0,m|0)|0;c[a>>2]=l;c[d>>2]=h;c[f>>2]=k+(j<<3);if((b|0)==0){i=e;return}Hv(b);i=e;return}function og(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0;e=i;f=a+8|0;d=a+4|0;k=c[d>>2]|0;j=c[f>>2]|0;g=k;if(!(j-g>>2>>>0<b>>>0)){do{if((k|0)==0){f=0}else{c[k>>2]=0;f=c[d>>2]|0}k=f+4|0;c[d>>2]=k;b=b+ -1|0}while((b|0)!=0);i=e;return}l=c[a>>2]|0;g=g-l>>2;k=g+b|0;if(k>>>0>1073741823){ss(0)}j=j-l|0;if(j>>2>>>0<536870911){l=j>>1;k=l>>>0<k>>>0?k:l;if((k|0)==0){j=0;k=0}else{h=9}}else{k=1073741823;h=9}if((h|0)==9){j=k;k=Fv(k<<2)|0}h=k+(g<<2)|0;do{if((h|0)==0){h=0}else{c[h>>2]=0}h=h+4|0;b=b+ -1|0}while((b|0)!=0);b=c[a>>2]|0;m=(c[d>>2]|0)-b|0;l=k+(g-(m>>2)<<2)|0;tw(l|0,b|0,m|0)|0;c[a>>2]=l;c[d>>2]=h;c[f>>2]=k+(j<<2);if((b|0)==0){i=e;return}Hv(b);i=e;return}function pg(a){a=a|0;var b=0,d=0,e=0,f=0,g=0;e=i;b=a+12|0;f=c[b>>2]|0;d=a+8|0;g=c[d>>2]|0;a:do{if((f|0)==(g|0)){g=f}else{f=0;while(1){u=0;na(194,c[g+(f<<2)>>2]|0);g=u;u=0;if(g&1){break}f=f+1|0;g=c[d>>2]|0;if(!(f>>>0<(c[b>>2]|0)-g>>2>>>0)){break a}}e=qb(-1,-1)|0;f=c[a+20>>2]|0;if((f|0)!=0){a=a+24|0;g=c[a>>2]|0;if((g|0)!=(f|0)){c[a>>2]=g+(~((g+ -8+(0-f)|0)>>>3)<<3)}Hv(f)}a=c[d>>2]|0;if((a|0)==0){vb(e|0)}d=c[b>>2]|0;if((d|0)!=(a|0)){c[b>>2]=d+(~((d+ -4+(0-a)|0)>>>2)<<2)}Hv(a);vb(e|0)}}while(0);f=c[a+20>>2]|0;if((f|0)!=0){g=a+24|0;a=c[g>>2]|0;if((a|0)!=(f|0)){c[g>>2]=a+(~((a+ -8+(0-f)|0)>>>3)<<3)}Hv(f);g=c[d>>2]|0}if((g|0)==0){i=e;return}d=c[b>>2]|0;if((d|0)!=(g|0)){c[b>>2]=d+(~((d+ -4+(0-g)|0)>>>2)<<2)}Hv(g);i=e;return}function qg(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;f=i;i=i+32|0;g=f+16|0;m=f+8|0;l=f;n=c[e>>2]|0;j=Fv(20)|0;o=c[a+12>>2]|0;c[j>>2]=0;k=j+4|0;c[k>>2]=0;e=j+8|0;c[e>>2]=0;c[j+12>>2]=o;do{if((o|0)!=0){u=0;p=qa(119,o<<3|0)|0;q=u;u=0;if(!(q&1)){c[j>>2]=p;c[k>>2]=p;c[e>>2]=p+(o<<3);break}q=qb(-1,-1)|0;Hv(j);vb(q|0)}}while(0);c[j+16>>2]=0;c[g>>2]=0;e=g+4|0;c[e>>2]=0;c[g+8>>2]=0;c[g+12>>2]=o;u=0;oa(94,g|0,(o>>>5)+1|0);q=u;u=0;if(q&1){f=qb(-1,-1)|0;h=c[g>>2]|0;if((h|0)==0){vb(f|0)}g=c[e>>2]|0;if((g|0)!=(h|0)){c[e>>2]=g+(~((g+ -4+(0-h)|0)>>>2)<<2)}Hv(h);vb(f|0)}o=c[g>>2]|0;p=(c[e>>2]|0)-o|0;if((p|0)>0){q=p>>2;p=0-q|0;ww(o|0,0,(((p|0)>-1?p:1073741823)+q<<2)+4|0)|0}c[m>>2]=0;q=a+132|0;a:do{if((c[q>>2]|0)>0){p=a+88|0;o=0;while(1){u=0;xa(7,a|0,c[(c[p>>2]|0)+(o<<2)>>2]|0,b|0,d|0,m|0,n|0,j|0,g|0);r=u;u=0;if(r&1){break}o=o+1|0;if((o|0)>=(c[q>>2]|0)){h=14;break a}}f=qb(-1,-1)|0}else{h=14}}while(0);do{if((h|0)==14){while(1){if(!(tg(j,l)|0)){break}if((c[m>>2]|0)>=(n|0)){u=0;o=qa(c[(c[b>>2]|0)+8>>2]|0,b|0)|0;r=u;u=0;if(r&1){h=34;break}if(o){break}}u=0;xa(7,a|0,c[l>>2]|0,b|0,d|0,m|0,n|0,j|0,g|0);r=u;u=0;if(r&1){h=34;break}}if((h|0)==34){f=qb(-1,-1)|0;break}if((j|0)!=0){h=c[j>>2]|0;if((h|0)!=0){d=c[k>>2]|0;if((d|0)!=(h|0)){c[k>>2]=d+(~((d+ -8+(0-h)|0)>>>3)<<3)}Hv(h)}Hv(j)}g=c[g>>2]|0;if((g|0)==0){i=f;return}h=c[e>>2]|0;if((h|0)!=(g|0)){c[e>>2]=h+(~((h+ -4+(0-g)|0)>>>2)<<2)}Hv(g);i=f;return}}while(0);g=c[g>>2]|0;if((g|0)==0){r=f;vb(r|0)}h=c[e>>2]|0;if((h|0)!=(g|0)){c[e>>2]=h+(~((h+ -4+(0-g)|0)>>>2)<<2)}Hv(g);r=f;vb(r|0)}function rg(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;f=i;i=i+32|0;g=f+16|0;m=f+8|0;l=f;n=c[e>>2]|0;j=Fv(20)|0;o=c[a+12>>2]|0;c[j>>2]=0;k=j+4|0;c[k>>2]=0;e=j+8|0;c[e>>2]=0;c[j+12>>2]=o;do{if((o|0)!=0){u=0;p=qa(119,o<<3|0)|0;q=u;u=0;if(!(q&1)){c[j>>2]=p;c[k>>2]=p;c[e>>2]=p+(o<<3);break}q=qb(-1,-1)|0;Hv(j);vb(q|0)}}while(0);c[j+16>>2]=0;c[g>>2]=0;e=g+4|0;c[e>>2]=0;c[g+8>>2]=0;c[g+12>>2]=o;u=0;oa(94,g|0,(o>>>5)+1|0);q=u;u=0;if(q&1){f=qb(-1,-1)|0;h=c[g>>2]|0;if((h|0)==0){vb(f|0)}g=c[e>>2]|0;if((g|0)!=(h|0)){c[e>>2]=g+(~((g+ -4+(0-h)|0)>>>2)<<2)}Hv(h);vb(f|0)}o=c[g>>2]|0;p=(c[e>>2]|0)-o|0;if((p|0)>0){q=p>>2;p=0-q|0;ww(o|0,0,(((p|0)>-1?p:1073741823)+q<<2)+4|0)|0}c[m>>2]=0;q=a+132|0;a:do{if((c[q>>2]|0)>0){p=a+88|0;o=0;while(1){u=0;xa(8,a|0,c[(c[p>>2]|0)+(o<<2)>>2]|0,b|0,d|0,m|0,n|0,j|0,g|0);r=u;u=0;if(r&1){break}o=o+1|0;if((o|0)>=(c[q>>2]|0)){h=14;break a}}f=qb(-1,-1)|0}else{h=14}}while(0);do{if((h|0)==14){while(1){if(!(tg(j,l)|0)){break}if((c[m>>2]|0)>=(n|0)){u=0;o=qa(c[(c[b>>2]|0)+8>>2]|0,b|0)|0;r=u;u=0;if(r&1){h=34;break}if(o){break}}u=0;xa(8,a|0,c[l>>2]|0,b|0,d|0,m|0,n|0,j|0,g|0);r=u;u=0;if(r&1){h=34;break}}if((h|0)==34){f=qb(-1,-1)|0;break}if((j|0)!=0){h=c[j>>2]|0;if((h|0)!=0){d=c[k>>2]|0;if((d|0)!=(h|0)){c[k>>2]=d+(~((d+ -8+(0-h)|0)>>>3)<<3)}Hv(h)}Hv(j)}g=c[g>>2]|0;if((g|0)==0){i=f;return}h=c[e>>2]|0;if((h|0)!=(g|0)){c[e>>2]=h+(~((h+ -4+(0-g)|0)>>>2)<<2)}Hv(g);i=f;return}}while(0);g=c[g>>2]|0;if((g|0)==0){r=f;vb(r|0)}h=c[e>>2]|0;if((h|0)!=(g|0)){c[e>>2]=h+(~((h+ -4+(0-g)|0)>>>2)<<2)}Hv(g);r=f;vb(r|0)}function sg(a,b,d,e,f,h,j,k){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;k=k|0;var l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0.0,x=0,y=0,z=0.0,A=0.0,B=0.0,C=0.0;l=i;i=i+16|0;n=l;m=b+8|0;q=c[m>>2]|0;if((q|0)==(c[b+12>>2]|0)){if((c[f>>2]|0)>=(h|0)?Bc[c[(c[d>>2]|0)+8>>2]&255](d)|0:0){i=l;return}h=b+24|0;p=c[h>>2]|0;m=b+20|0;o=c[m>>2]|0;if((p|0)==(o|0)){i=l;return}a=a+20|0;q=c[k>>2]|0;n=0;do{j=o+(n<<3)|0;b=c[j>>2]|0;if((c[q+(b>>>5<<2)>>2]&1<<(b&31)|0)==0){q=c[o+(n<<3)+4>>2]|0;y=c[a>>2]|0;o=q+(y<<2)|0;y=y+ -3|0;p=q+(y<<2)|0;if((y|0)>0){r=e;w=0.0;do{C=+g[q>>2]- +g[r>>2];B=+g[q+4>>2]- +g[r+4>>2];A=+g[q+8>>2]- +g[r+8>>2];z=+g[q+12>>2]- +g[r+12>>2];w=w+(C*C+B*B+A*A+z*z);q=q+16|0;r=r+16|0}while(q>>>0<p>>>0);p=r}else{p=e;w=0.0}if(q>>>0<o>>>0){while(1){C=+g[q>>2]- +g[p>>2];q=q+4|0;w=w+C*C;if(!(q>>>0<o>>>0)){break}else{p=p+4|0}}}Ec[c[(c[d>>2]|0)+12>>2]&7](d,w,b);o=c[j>>2]|0;q=c[k>>2]|0;p=q+(o>>>5<<2)|0;c[p>>2]=c[p>>2]|1<<(o&31);c[f>>2]=(c[f>>2]|0)+1;p=c[h>>2]|0;o=c[m>>2]|0}n=n+1|0}while(n>>>0<p-o>>3>>>0);i=l;return}o=a+128|0;p=c[o>>2]|0;b=Gv(p>>>0>1073741823?-1:p<<2)|0;v=c[c[q>>2]>>2]|0;t=c[a+20>>2]|0;r=e+(t<<2)|0;t=t+ -3|0;s=e+(t<<2)|0;t=(t|0)>0;if(t){u=e;w=0.0;do{z=+g[u>>2]- +g[v>>2];A=+g[u+4>>2]- +g[v+4>>2];B=+g[u+8>>2]- +g[v+8>>2];C=+g[u+12>>2]- +g[v+12>>2];w=w+(z*z+A*A+B*B+C*C);u=u+16|0;v=v+16|0}while(u>>>0<s>>>0)}else{u=e;w=0.0}if(u>>>0<r>>>0){while(1){C=+g[u>>2]- +g[v>>2];u=u+4|0;w=w+C*C;if(!(u>>>0<r>>>0)){break}else{v=v+4|0}}}g[b>>2]=w;if((p|0)>1){v=0;u=1;do{y=c[c[q+(u<<2)>>2]>>2]|0;if(t){x=e;w=0.0;do{z=+g[x>>2]- +g[y>>2];A=+g[x+4>>2]- +g[y+4>>2];B=+g[x+8>>2]- +g[y+8>>2];C=+g[x+12>>2]- +g[y+12>>2];w=w+(z*z+A*A+B*B+C*C);x=x+16|0;y=y+16|0}while(x>>>0<s>>>0)}else{x=e;w=0.0}if(x>>>0<r>>>0){while(1){C=+g[x>>2]- +g[y>>2];x=x+4|0;w=w+C*C;if(!(x>>>0<r>>>0)){break}else{y=y+4|0}}}g[b+(u<<2)>>2]=w;v=w<+g[b+(v<<2)>>2]?u:v;u=u+1|0}while((u|0)<(p|0))}else{v=0}if((p|0)>0){q=n+4|0;r=0;do{if((r|0)!=(v|0)){C=+g[b+(r<<2)>>2];c[n>>2]=c[(c[m>>2]|0)+(r<<2)>>2];g[q>>2]=C;ug(j,n);p=c[o>>2]|0}r=r+1|0}while((r|0)<(p|0))}if((b|0)!=0){Iv(b)}sg(a,c[(c[m>>2]|0)+(v<<2)>>2]|0,d,e,f,h,j,k);i=l;return}function tg(a,b){a=a|0;b=b|0;var d=0.0,e=0,f=0,h=0,j=0.0,l=0,m=0,n=0,o=0.0,p=0,q=0,r=0,s=0;h=i;e=a+16|0;if((c[e>>2]|0)==0){q=0;i=h;return q|0}l=c[a>>2]|0;m=c[l+4>>2]|0;c[b>>2]=c[l>>2];c[b+4>>2]=m;b=c[a>>2]|0;a=a+4|0;m=c[a>>2]|0;l=m-b|0;if((l|0)>8?(f=m+ -8|0,q=b,p=c[q>>2]|0,q=c[q+4>>2]|0,r=f,m=c[r+4>>2]|0,n=b,c[n>>2]=c[r>>2],c[n+4>>2]=m,f,c[f>>2]=p,c[f+4>>2]=q,f=(l>>3)+ -1|0,(f|0)>1):0){if((f|0)!=2?!(+g[b+12>>2]<+g[b+20>>2]):0){n=b+16|0;p=2}else{n=b+8|0;p=1}if(+g[n+4>>2]<+g[b+4>>2]){l=b;m=c[l>>2]|0;l=c[l+4>>2]|0;j=(c[k>>2]=l,+g[k>>2]);q=b;while(1){s=n;r=c[s+4>>2]|0;c[q>>2]=c[s>>2];c[q+4>>2]=r;q=p<<1;p=q+2|0;if((p|0)>(f|0)){break}q=q|1;o=+g[b+(q<<3)+4>>2];if((p|0)!=(f|0)?(d=+g[b+(p<<3)+4>>2],!(o<d)):0){o=d}else{p=q}if(o<j){q=n;n=b+(p<<3)|0}else{break}}s=n;c[s>>2]=m;c[s+4>>2]=l}}s=c[a>>2]|0;c[a>>2]=s+(~((s+ -8+(0-(s+ -8))|0)>>>3)<<3);c[e>>2]=(c[e>>2]|0)+ -1;s=1;i=h;return s|0}function ug(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,h=0,j=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0.0,u=0;d=i;e=a+16|0;if((c[e>>2]|0)==(c[a+12>>2]|0)){i=d;return}j=a+4|0;n=c[j>>2]|0;m=a+8|0;if((n|0)==(c[m>>2]|0)){l=c[a>>2]|0;n=n-l|0;s=n>>3;q=s+1|0;if(q>>>0>536870911){ss(0)}if(s>>>0<268435455){r=n>>2;r=r>>>0<q>>>0?q:r;if((r|0)==0){p=0;r=0}else{o=10}}else{r=536870911;o=10}if((o|0)==10){p=r;r=Fv(r<<3)|0}o=r+(s<<3)|0;if((o|0)!=0){u=b;b=c[u+4>>2]|0;s=o;c[s>>2]=c[u>>2];c[s+4>>2]=b}b=r+(q<<3)|0;tw(r|0,l|0,n|0)|0;c[a>>2]=r;c[j>>2]=b;c[m>>2]=r+(p<<3);if((l|0)!=0){Hv(l);b=c[j>>2]|0}}else{if((n|0)==0){l=0}else{s=b;u=c[s+4>>2]|0;l=n;c[l>>2]=c[s>>2];c[l+4>>2]=u;l=c[j>>2]|0}b=l+8|0;c[j>>2]=b}j=c[a>>2]|0;a=b-j|0;if((a|0)>8?(h=((a>>3)+ -2|0)/2|0,f=b+ -8|0,+g[b+ -4>>2]<+g[j+(h<<3)+4>>2]):0){l=f;a=c[l>>2]|0;l=c[l+4>>2]|0;t=(c[k>>2]=l,+g[k>>2]);do{u=f;f=j+(h<<3)|0;r=f;s=c[r+4>>2]|0;c[u>>2]=c[r>>2];c[u+4>>2]=s;if((h|0)==0){break}h=(h+ -1|0)/2|0}while(t<+g[j+(h<<3)+4>>2]);u=f;c[u>>2]=a;c[u+4>>2]=l}c[e>>2]=(c[e>>2]|0)+1;i=d;return}function vg(a,b,d,e,f,h,j,k){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;k=k|0;var l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0.0,y=0,z=0.0,A=0.0,B=0.0,C=0.0;l=i;i=i+16|0;n=l;m=b+8|0;q=c[m>>2]|0;if((q|0)==(c[b+12>>2]|0)){if((c[f>>2]|0)>=(h|0)?Bc[c[(c[d>>2]|0)+8>>2]&255](d)|0:0){i=l;return}m=b+24|0;h=c[m>>2]|0;j=b+20|0;p=c[j>>2]|0;if((h|0)==(p|0)){i=l;return}n=a+40|0;a=a+20|0;q=h;h=0;do{o=p+(h<<3)|0;b=c[o>>2]|0;w=b>>>5;y=1<<(b&31);if((c[(c[n>>2]|0)+(w<<2)>>2]&y|0)==0?(c[(c[k>>2]|0)+(w<<2)>>2]&y|0)==0:0){r=c[p+(h<<3)+4>>2]|0;y=c[a>>2]|0;p=r+(y<<2)|0;y=y+ -3|0;q=r+(y<<2)|0;if((y|0)>0){s=e;x=0.0;do{C=+g[r>>2]- +g[s>>2];B=+g[r+4>>2]- +g[s+4>>2];A=+g[r+8>>2]- +g[s+8>>2];z=+g[r+12>>2]- +g[s+12>>2];x=x+(C*C+B*B+A*A+z*z);r=r+16|0;s=s+16|0}while(r>>>0<q>>>0)}else{s=e;x=0.0}if(r>>>0<p>>>0){while(1){C=+g[r>>2]- +g[s>>2];r=r+4|0;x=x+C*C;if(!(r>>>0<p>>>0)){break}else{s=s+4|0}}}Ec[c[(c[d>>2]|0)+12>>2]&7](d,x,b);p=c[o>>2]|0;q=(c[k>>2]|0)+(p>>>5<<2)|0;c[q>>2]=c[q>>2]|1<<(p&31);c[f>>2]=(c[f>>2]|0)+1;q=c[m>>2]|0;p=c[j>>2]|0}h=h+1|0}while(h>>>0<q-p>>3>>>0);i=l;return}o=a+128|0;p=c[o>>2]|0;b=Gv(p>>>0>1073741823?-1:p<<2)|0;v=c[c[q>>2]>>2]|0;t=c[a+20>>2]|0;s=e+(t<<2)|0;t=t+ -3|0;r=e+(t<<2)|0;t=(t|0)>0;if(t){u=e;x=0.0;do{z=+g[u>>2]- +g[v>>2];A=+g[u+4>>2]- +g[v+4>>2];B=+g[u+8>>2]- +g[v+8>>2];C=+g[u+12>>2]- +g[v+12>>2];x=x+(z*z+A*A+B*B+C*C);u=u+16|0;v=v+16|0}while(u>>>0<r>>>0)}else{u=e;x=0.0}if(u>>>0<s>>>0){while(1){C=+g[u>>2]- +g[v>>2];u=u+4|0;x=x+C*C;if(!(u>>>0<s>>>0)){break}else{v=v+4|0}}}g[b>>2]=x;if((p|0)>1){v=0;u=1;do{y=c[c[q+(u<<2)>>2]>>2]|0;if(t){w=e;x=0.0;do{z=+g[w>>2]- +g[y>>2];A=+g[w+4>>2]- +g[y+4>>2];B=+g[w+8>>2]- +g[y+8>>2];C=+g[w+12>>2]- +g[y+12>>2];x=x+(z*z+A*A+B*B+C*C);w=w+16|0;y=y+16|0}while(w>>>0<r>>>0)}else{w=e;x=0.0}if(w>>>0<s>>>0){while(1){C=+g[w>>2]- +g[y>>2];w=w+4|0;x=x+C*C;if(!(w>>>0<s>>>0)){break}else{y=y+4|0}}}g[b+(u<<2)>>2]=x;v=x<+g[b+(v<<2)>>2]?u:v;u=u+1|0}while((u|0)<(p|0))}else{v=0}if((p|0)>0){q=n+4|0;r=0;do{if((r|0)!=(v|0)){C=+g[b+(r<<2)>>2];c[n>>2]=c[(c[m>>2]|0)+(r<<2)>>2];g[q>>2]=C;ug(j,n);p=c[o>>2]|0}r=r+1|0}while((r|0)<(p|0))}if((b|0)!=0){Iv(b)}vg(a,c[(c[m>>2]|0)+(v<<2)>>2]|0,d,e,f,h,j,k);i=l;return}function wg(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0.0,r=0,s=0,t=0.0,v=0,w=0,x=0.0,y=0.0,z=0.0,A=0.0;e=i;f=c[(c[a+72>>2]|0)+(d<<2)>>2]|0;m=c[b+8>>2]|0;if((m|0)!=(c[b+12>>2]|0)){j=c[a+20>>2]|0;k=j+ -3|0;b=c[a+128>>2]|0;l=b>>>0>1;do{o=c[m>>2]|0;v=c[o>>2]|0;p=v+(j<<2)|0;r=v+(k<<2)|0;n=(k|0)>0;if(n){s=f;q=0.0;do{z=+g[v>>2]- +g[s>>2];y=+g[v+4>>2]- +g[s+4>>2];x=+g[v+8>>2]- +g[s+8>>2];t=+g[v+12>>2]- +g[s+12>>2];q=q+(z*z+y*y+x*x+t*t);v=v+16|0;s=s+16|0}while(v>>>0<r>>>0)}else{s=f;q=0.0}if(v>>>0<p>>>0){while(1){z=+g[v>>2]- +g[s>>2];v=v+4|0;q=q+z*z;if(!(v>>>0<p>>>0)){break}else{s=s+4|0}}}if(l){o=0;p=1;while(1){w=c[c[m+(p<<2)>>2]>>2]|0;r=w+(j<<2)|0;s=w+(k<<2)|0;if(n){v=f;t=0.0;do{A=+g[w>>2]- +g[v>>2];x=+g[w+4>>2]- +g[v+4>>2];y=+g[w+8>>2]- +g[v+8>>2];z=+g[w+12>>2]- +g[v+12>>2];t=t+(A*A+x*x+y*y+z*z);w=w+16|0;v=v+16|0}while(w>>>0<s>>>0);s=w}else{s=w;v=f;t=0.0}if(s>>>0<r>>>0){while(1){A=+g[s>>2]- +g[v>>2];s=s+4|0;t=t+A*A;if(!(s>>>0<r>>>0)){break}else{v=v+4|0}}}r=t<q;o=r?p:o;p=p+1|0;if(!(p>>>0<b>>>0)){break}else{q=r?t:q}}o=c[m+(o<<2)>>2]|0}m=c[o+8>>2]|0}while((m|0)!=(c[o+12>>2]|0));b=o}k=b+20|0;j=b+24|0;n=c[j>>2]|0;m=b+28|0;if((n|0)==(c[m>>2]|0)){l=c[k>>2]|0;n=n-l|0;r=n>>3;o=r+1|0;if(o>>>0>536870911){ss(0)}if(r>>>0<268435455){s=n>>2;s=s>>>0<o>>>0?o:s;if((s|0)==0){p=0;s=0}else{h=11}}else{s=536870911;h=11}if((h|0)==11){p=s;s=Fv(s<<3)|0}h=s+(r<<3)|0;if((h|0)!=0){w=h;c[w>>2]=d;c[w+4>>2]=f}d=s+(o<<3)|0;tw(s|0,l|0,n|0)|0;c[k>>2]=s;c[j>>2]=d;c[m>>2]=s+(p<<3);if((l|0)==0){l=d}else{Hv(l);l=c[j>>2]|0}}else{if((n|0)==0){d=0}else{w=n;c[w>>2]=d;c[w+4>>2]=f;d=c[j>>2]|0}l=d+8|0;c[j>>2]=l}f=c[k>>2]|0;h=l-f|0;d=h>>3;if(d>>>0<(c[a+128>>2]|0)>>>0){i=e;return}if((d|0)==0){j=f;h=0;d=0}else{if(d>>>0>1073741823){ss(0)}f=Fv(h>>1)|0;l=d;h=f;while(1){if((h|0)!=0){c[h>>2]=0}l=l+ -1|0;if((l|0)==0){break}else{h=h+4|0}}l=c[j>>2]|0;j=c[k>>2]|0;h=f;d=f+(d<<2)|0}if((l|0)!=(j|0)){k=l-j>>3;f=0;do{c[h+(f<<2)>>2]=c[j+(f<<3)>>2];f=f+1|0}while(f>>>0<k>>>0)}u=0;Qa(26,a|0,b|0,h|0,d-h>>2|0);w=u;u=0;if(w&1){a=qb(-1,-1)|0;if((h|0)==0){vb(a|0)}Hv(h);vb(a|0)}else{if((h|0)==0){i=e;return}Hv(h);i=e;return}}function xg(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;k=i;Le(a,b);c[a>>2]=2800;j=a+88|0;c[j>>2]=0;d=a+92|0;c[d>>2]=0;c[a+96>>2]=0;c[a+112>>2]=8192;f=a+100|0;c[f>>2]=0;e=a+104|0;c[e>>2]=0;g=a+116|0;c[g>>2]=0;h=a+120|0;c[h>>2]=0;c[a+124>>2]=c[b+124>>2];c[a+128>>2]=c[b+128>>2];c[a+132>>2]=c[b+132>>2];c[a+136>>2]=c[b+136>>2];c[a+140>>2]=c[b+140>>2];u=0;na(192,a|0);p=u;u=0;do{if(!(p&1)){l=b+88|0;o=(c[b+92>>2]|0)-(c[l>>2]|0)>>2;n=c[d>>2]|0;b=c[j>>2]|0;p=n-b>>2;if(!(p>>>0<o>>>0)){if(p>>>0>o>>>0?(m=b+(o<<2)|0,(n|0)!=(m|0)):0){n=n+(~((n+ -4+(0-m)|0)>>>2)<<2)|0;c[d>>2]=n}}else{u=0;oa(93,j|0,o-p|0);p=u;u=0;if(p&1){l=12;break}n=c[d>>2]|0;b=c[j>>2]|0}if((n|0)==(b|0)){i=k;return}else{m=0}while(1){u=0;Na(52,a|0,b+(m<<2)|0,(c[l>>2]|0)+(m<<2)|0);p=u;u=0;if(p&1){l=11;break}m=m+1|0;b=c[j>>2]|0;if(!(m>>>0<(c[d>>2]|0)-b>>2>>>0)){l=15;break}}if((l|0)==11){k=qb(-1,-1)|0;break}else if((l|0)==15){i=k;return}}else{l=12}}while(0);if((l|0)==12){k=qb(-1,-1)|0}l=c[e>>2]|0;if((l|0)!=0){do{p=l;l=c[l>>2]|0;Bv(p);c[e>>2]=l}while((l|0)!=0)}c[e>>2]=0;c[f>>2]=0;c[g>>2]=0;c[h>>2]=0;e=c[j>>2]|0;if((e|0)!=0){f=c[d>>2]|0;if((f|0)!=(e|0)){c[d>>2]=f+(~((f+ -4+(0-e)|0)>>>2)<<2)}Hv(e)}u=0;na(186,a|0);p=u;u=0;if(p&1){p=qb(-1,-1,0)|0;jd(p)}else{vb(k|0)}}function yg(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0;e=i;h=a+100|0;k=c[h>>2]|0;do{if((k|0)<32){j=a+120|0;c[j>>2]=(c[j>>2]|0)+k;j=Av(8192)|0;if((j|0)==0){zb(3048,27,1,c[r>>2]|0)|0;j=0;break}else{k=a+104|0;c[j>>2]=c[k>>2];c[k>>2]=j;c[h>>2]=8188;j=j+4|0;c[a+108>>2]=j;k=8156;g=6;break}}else{j=c[a+108>>2]|0;k=k+ -32|0;g=6}}while(0);if((g|0)==6){c[a+108>>2]=j+32;c[h>>2]=k;m=a+116|0;c[m>>2]=(c[m>>2]|0)+32}c[j+0>>2]=0;c[j+4>>2]=0;c[j+8>>2]=0;c[j+12>>2]=0;c[j+16>>2]=0;c[j+20>>2]=0;c[j+24>>2]=0;c[j+28>>2]=0;c[b>>2]=j;h=c[(c[d>>2]|0)+4>>2]|0;c[j+4>>2]=h;c[j>>2]=c[(c[a+72>>2]|0)+(h<<2)>>2];h=c[d>>2]|0;g=(c[h+12>>2]|0)-(c[h+8>>2]|0)>>2;j=c[b>>2]|0;if((g|0)==0){if((j|0)==(h|0)){i=e;return}zg(j+20|0,c[h+20>>2]|0,c[h+24>>2]|0);i=e;return}h=j+8|0;k=j+12|0;j=c[k>>2]|0;l=c[h>>2]|0;m=j-l>>2;if(!(m>>>0<g>>>0)){if(m>>>0>g>>>0?(f=l+(g<<2)|0,(j|0)!=(f|0)):0){c[k>>2]=j+(~((j+ -4+(0-f)|0)>>>2)<<2)}}else{og(h,g-m|0)}m=c[d>>2]|0;g=c[m+8>>2]|0;if((c[m+12>>2]|0)==(g|0)){i=e;return}else{f=0}do{yg(a,(c[(c[b>>2]|0)+8>>2]|0)+(f<<2)|0,g+(f<<2)|0);f=f+1|0;m=c[d>>2]|0;g=c[m+8>>2]|0}while(f>>>0<(c[m+12>>2]|0)-g>>2>>>0);i=e;return}function zg(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0;e=i;k=b;h=d-k>>3;f=a+8|0;m=c[f>>2]|0;j=c[a>>2]|0;l=j;if(!(h>>>0>m-l>>3>>>0)){a=a+4|0;f=(c[a>>2]|0)-l|0;g=f>>3;if(!(h>>>0>g>>>0)){d=d-k|0;vw(j|0,b|0,d|0)|0;b=j+(d>>3<<3)|0;d=c[a>>2]|0;if((d|0)==(b|0)){i=e;return}c[a>>2]=d+(~((d+ -8+(0-b)|0)>>>3)<<3);i=e;return}g=b+(g<<3)|0;vw(j|0,b|0,f|0)|0;if((g|0)==(d|0)){i=e;return}b=c[a>>2]|0;do{if((b|0)==0){b=0}else{l=g;m=c[l+4>>2]|0;c[b>>2]=c[l>>2];c[b+4>>2]=m;b=c[a>>2]|0}b=b+8|0;c[a>>2]=b;g=g+8|0}while((g|0)!=(d|0));i=e;return}if((j|0)!=0){m=a+4|0;k=c[m>>2]|0;if((k|0)!=(j|0)){c[m>>2]=k+(~((k+ -8+(0-l)|0)>>>3)<<3)}Hv(j);c[f>>2]=0;c[m>>2]=0;c[a>>2]=0;m=0}if(h>>>0>536870911){ss(0)}if(m>>3>>>0<268435455){m=m>>2;h=m>>>0<h>>>0?h:m;if(h>>>0>536870911){ss(0)}else{g=h}}else{g=536870911}j=Fv(g<<3)|0;h=a+4|0;c[h>>2]=j;c[a>>2]=j;c[f>>2]=j+(g<<3);if((b|0)==(d|0)){i=e;return}do{if((j|0)==0){a=0}else{l=b;m=c[l+4>>2]|0;a=j;c[a>>2]=c[l>>2];c[a+4>>2]=m;a=c[h>>2]|0}j=a+8|0;c[h>>2]=j;b=b+8|0}while((b|0)!=(d|0));i=e;return}function Ag(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;d=i;i=i+16|0;f=d;c[b>>2]=a;lf(a,b);e=b+4|0;zb(a+128|0,4,1,c[e>>2]|0)|0;zb(a+132|0,4,1,c[e>>2]|0)|0;c[f>>2]=c[a+136>>2];zb(f|0,4,1,c[e>>2]|0)|0;zb(a+140|0,4,1,c[e>>2]|0)|0;e=a+92|0;a=a+88|0;f=c[a>>2]|0;if((c[e>>2]|0)==(f|0)){i=d;return}else{g=0}do{Bg(c[f+(g<<2)>>2]|0,b);g=g+1|0;f=c[a>>2]|0}while(g>>>0<(c[e>>2]|0)-f>>2>>>0);i=d;return}function Bg(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0;d=i;i=i+16|0;f=d+4|0;h=d;e=b+4|0;zb(a+4|0,4,1,c[e>>2]|0)|0;g=a+8|0;c[h>>2]=(c[a+12>>2]|0)-(c[g>>2]|0)>>2;zb(h|0,4,1,c[e>>2]|0)|0;h=c[h>>2]|0;if((h|0)!=0){e=0;do{Bg(c[(c[g>>2]|0)+(e<<2)>>2]|0,b);e=e+1|0}while(e>>>0<h>>>0);i=d;return}g=a+24|0;a=a+20|0;c[f>>2]=(c[g>>2]|0)-(c[a>>2]|0)>>3;zb(f|0,4,1,c[e>>2]|0)|0;f=c[a>>2]|0;if((c[g>>2]|0)==(f|0)){i=d;return}else{h=0}do{zb(f+(h<<3)|0,4,1,c[e>>2]|0)|0;h=h+1|0;f=c[a>>2]|0}while(h>>>0<(c[g>>2]|0)-f>>3>>>0);i=d;return}function Cg(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0;f=i;i=i+144|0;j=f+140|0;h=f+128|0;n=f+124|0;m=f+112|0;t=f+108|0;s=f+96|0;z=f+92|0;A=f+80|0;H=f+76|0;I=f+64|0;C=f+52|0;G=f+48|0;v=f+36|0;o=f+24|0;k=f+12|0;e=f;c[d>>2]=b;Vf(b,d);w=b+128|0;K=d+4|0;if((Sa(w|0,4,1,c[K>>2]|0)|0)!=1){e=Jb(8)|0;u=0;oa(75,e|0,2592);U=u;u=0;if(U&1){U=qb(-1,-1)|0;pb(e|0);vb(U|0)}else{c[e>>2]=288;qc(e|0,264,1)}}q=b+132|0;if((Sa(q|0,4,1,c[K>>2]|0)|0)!=1){e=Jb(8)|0;u=0;oa(75,e|0,2592);U=u;u=0;if(U&1){U=qb(-1,-1)|0;pb(e|0);vb(U|0)}else{c[e>>2]=288;qc(e|0,264,1)}}l=b+136|0;if((Sa(j|0,4,1,c[K>>2]|0)|0)!=1){e=Jb(8)|0;u=0;oa(75,e|0,2592);U=u;u=0;if(U&1){U=qb(-1,-1)|0;pb(e|0);vb(U|0)}else{c[e>>2]=288;qc(e|0,264,1)}}c[l>>2]=c[j>>2];g=b+140|0;if((Sa(g|0,4,1,c[K>>2]|0)|0)!=1){e=Jb(8)|0;u=0;oa(75,e|0,2592);U=u;u=0;if(U&1){U=qb(-1,-1)|0;pb(e|0);vb(U|0)}else{c[e>>2]=288;qc(e|0,264,1)}}K=b+88|0;P=c[q>>2]|0;L=b+92|0;Q=c[L>>2]|0;M=c[K>>2]|0;O=Q-M>>2;if(!(O>>>0<P>>>0)){if(O>>>0>P>>>0?(N=M+(P<<2)|0,(Q|0)!=(N|0)):0){Q=Q+(~((Q+ -4+(0-N)|0)>>>2)<<2)|0;c[L>>2]=Q}}else{og(K,P-O|0);Q=c[L>>2]|0;M=c[K>>2]|0}if((Q|0)!=(M|0)){Q=b+100|0;P=b+120|0;S=c[r>>2]|0;R=b+104|0;N=b+108|0;M=b+116|0;O=0;do{U=c[Q>>2]|0;do{if((U|0)<32){c[P>>2]=(c[P>>2]|0)+U;T=Av(8192)|0;if((T|0)==0){zb(3048,27,1,S|0)|0;T=0;break}else{c[T>>2]=c[R>>2];c[R>>2]=T;c[Q>>2]=8188;T=T+4|0;c[N>>2]=T;U=8156;p=29;break}}else{T=c[N>>2]|0;U=U+ -32|0;p=29}}while(0);if((p|0)==29){p=0;c[N>>2]=T+32;c[Q>>2]=U;c[M>>2]=(c[M>>2]|0)+32}c[T+0>>2]=0;c[T+4>>2]=0;c[T+8>>2]=0;c[T+12>>2]=0;c[T+16>>2]=0;c[T+20>>2]=0;c[T+24>>2]=0;c[T+28>>2]=0;c[(c[K>>2]|0)+(O<<2)>>2]=T;Tg(c[(c[K>>2]|0)+(O<<2)>>2]|0,d);O=O+1|0}while(O>>>0<(c[L>>2]|0)-(c[K>>2]|0)>>2>>>0)}d=b+24|0;a[C>>0]=18;M=C+1|0;L=320|0;K=M+9|0;do{a[M>>0]=a[L>>0]|0;M=M+1|0;L=L+1|0}while((M|0)<(K|0));a[C+10>>0]=0;K=Pf(d,H,C)|0;L=c[K>>2]|0;if((L|0)==0){u=0;Na(43,I|0,d|0,C|0);U=u;u=0;if(!(U&1)){J=c[I>>2]|0;c[I>>2]=0;p=c[H>>2]|0;c[J>>2]=0;c[J+4>>2]=0;c[J+8>>2]=p;c[K>>2]=J;p=c[c[d>>2]>>2]|0;if((p|0)==0){p=J}else{c[d>>2]=p;p=c[K>>2]|0}ge(c[b+28>>2]|0,p);p=b+32|0;c[p>>2]=(c[p>>2]|0)+1;p=36}}else{J=L;p=36}if(((p|0)==36?(u=0,D=qa(c[(c[b>>2]|0)+16>>2]|0,b|0)|0,U=u,u=0,!(U&1)):0)?(c[G>>2]=D,F=J+28|0,U=c[F>>2]|0,E=J+32|0,u=0,oa(c[c[U>>2]>>2]|0,U|0,E|0),U=u,u=0,!(U&1)):0){if((a[2072]|0)==0?(Ua(2072)|0)!=0:0){c[516]=2088;rb(2072)}c[F>>2]=2064;if((a[2336]|0)==0?(Ua(2336)|0)!=0:0){c[582]=2352;rb(2336)}c[F>>2]=2328;u=0;Na(c[(c[582]|0)+4>>2]|0,2328,G|0,E|0);U=u;u=0;if(!(U&1)){if(!((a[C>>0]&1)==0)){Hv(c[C+8>>2]|0)}a[v>>0]=18;M=v+1|0;L=2880|0;K=M+9|0;do{a[M>>0]=a[L>>0]|0;M=M+1|0;L=L+1|0}while((M|0)<(K|0));a[v+10>>0]=0;C=Pf(d,z,v)|0;D=c[C>>2]|0;if((D|0)==0){u=0;Na(43,A|0,d|0,v|0);U=u;u=0;if(!(U&1)){B=c[A>>2]|0;c[A>>2]=0;p=c[z>>2]|0;c[B>>2]=0;c[B+4>>2]=0;c[B+8>>2]=p;c[C>>2]=B;p=c[c[d>>2]>>2]|0;if((p|0)==0){p=B}else{c[d>>2]=p;p=c[C>>2]|0}ge(c[b+28>>2]|0,p);p=b+32|0;c[p>>2]=(c[p>>2]|0)+1;p=52}}else{B=D;p=52}if((p|0)==52?(x=B+28|0,U=c[x>>2]|0,y=B+32|0,u=0,oa(c[c[U>>2]>>2]|0,U|0,y|0),U=u,u=0,!(U&1)):0){if((a[2072]|0)==0?(Ua(2072)|0)!=0:0){c[516]=2088;rb(2072)}c[x>>2]=2064;do{if((a[3440]|0)==0){if((Ua(3440)|0)==0){break}c[858]=3456;rb(3440)}}while(0);c[x>>2]=3432;u=0;Na(c[(c[858]|0)+4>>2]|0,3432,w|0,y|0);U=u;u=0;if(!(U&1)){if(!((a[v>>0]&1)==0)){Hv(c[v+8>>2]|0)}a[o>>0]=10;v=o+1|0;a[v+0>>0]=a[2912>>0]|0;a[v+1>>0]=a[2913>>0]|0;a[v+2>>0]=a[2914>>0]|0;a[v+3>>0]=a[2915>>0]|0;a[v+4>>0]=a[2916>>0]|0;a[o+6>>0]=0;v=Pf(d,t,o)|0;w=c[v>>2]|0;do{if((w|0)==0){u=0;Na(43,s|0,d|0,o|0);U=u;u=0;if(U&1){break}p=c[s>>2]|0;c[s>>2]=0;s=c[t>>2]|0;c[p>>2]=0;c[p+4>>2]=0;c[p+8>>2]=s;c[v>>2]=p;s=c[c[d>>2]>>2]|0;if((s|0)==0){s=p}else{c[d>>2]=s;s=c[v>>2]|0}ge(c[b+28>>2]|0,s);w=b+32|0;c[w>>2]=(c[w>>2]|0)+1;w=p;p=67}else{p=67}}while(0);do{if((p|0)==67){s=w+28|0;U=c[s>>2]|0;t=w+32|0;u=0;oa(c[c[U>>2]>>2]|0,U|0,t|0);U=u;u=0;if(U&1){break}do{if((a[2072]|0)==0){if((Ua(2072)|0)==0){break}c[516]=2088;rb(2072)}}while(0);c[s>>2]=2064;do{if((a[3440]|0)==0){if((Ua(3440)|0)==0){break}c[858]=3456;rb(3440)}}while(0);c[s>>2]=3432;u=0;Na(c[(c[858]|0)+4>>2]|0,3432,q|0,t|0);U=u;u=0;if(U&1){break}if(!((a[o>>0]&1)==0)){Hv(c[o+8>>2]|0)}q=Fv(16)|0;o=k+8|0;c[o>>2]=q;c[k>>2]=17;c[k+4>>2]=12;M=q+0|0;L=2896|0;K=M+12|0;do{a[M>>0]=a[L>>0]|0;M=M+1|0;L=L+1|0}while((M|0)<(K|0));a[q+12>>0]=0;q=Pf(d,n,k)|0;s=c[q>>2]|0;do{if((s|0)==0){u=0;Na(43,m|0,d|0,k|0);U=u;u=0;if(U&1){break}p=c[m>>2]|0;c[m>>2]=0;m=c[n>>2]|0;c[p>>2]=0;c[p+4>>2]=0;c[p+8>>2]=m;c[q>>2]=p;m=c[c[d>>2]>>2]|0;if((m|0)==0){m=p}else{c[d>>2]=m;m=c[q>>2]|0}ge(c[b+28>>2]|0,m);s=b+32|0;c[s>>2]=(c[s>>2]|0)+1;s=p;p=82}else{p=82}}while(0);do{if((p|0)==82){m=s+28|0;U=c[m>>2]|0;n=s+32|0;u=0;oa(c[c[U>>2]>>2]|0,U|0,n|0);U=u;u=0;if(U&1){break}do{if((a[2072]|0)==0){if((Ua(2072)|0)==0){break}c[516]=2088;rb(2072)}}while(0);c[m>>2]=2064;do{if((a[3176]|0)==0){if((Ua(3176)|0)==0){break}c[792]=3192;rb(3176)}}while(0);c[m>>2]=3168;u=0;Na(c[(c[792]|0)+4>>2]|0,3168,l|0,n|0);U=u;u=0;if(U&1){break}if(!((a[k>>0]&1)==0)){Hv(c[o>>2]|0)}a[e>>0]=18;M=e+1|0;L=3152|0;K=M+9|0;do{a[M>>0]=a[L>>0]|0;M=M+1|0;L=L+1|0}while((M|0)<(K|0));a[e+10>>0]=0;k=Pf(d,j,e)|0;l=c[k>>2]|0;do{if((l|0)==0){u=0;Na(43,h|0,d|0,e|0);U=u;u=0;if(U&1){break}l=c[h>>2]|0;c[h>>2]=0;h=c[j>>2]|0;c[l>>2]=0;c[l+4>>2]=0;c[l+8>>2]=h;c[k>>2]=l;h=c[c[d>>2]>>2]|0;if((h|0)==0){h=l}else{c[d>>2]=h;h=c[k>>2]|0}ge(c[b+28>>2]|0,h);p=b+32|0;c[p>>2]=(c[p>>2]|0)+1;p=97}else{p=97}}while(0);do{if((p|0)==97){b=l+28|0;U=c[b>>2]|0;h=l+32|0;u=0;oa(c[c[U>>2]>>2]|0,U|0,h|0);U=u;u=0;if(U&1){break}do{if((a[2072]|0)==0){if((Ua(2072)|0)==0){break}c[516]=2088;rb(2072)}}while(0);c[b>>2]=2064;do{if((a[3440]|0)==0){if((Ua(3440)|0)==0){break}c[858]=3456;rb(3440)}}while(0);c[b>>2]=3432;u=0;Na(c[(c[858]|0)+4>>2]|0,3432,g|0,h|0);U=u;u=0;if(U&1){break}if((a[e>>0]&1)==0){i=f;return}Hv(c[e+8>>2]|0);i=f;return}}while(0);f=qb(-1,-1)|0;if((a[e>>0]&1)==0){U=f;vb(U|0)}Hv(c[e+8>>2]|0);U=f;vb(U|0)}}while(0);e=qb(-1,-1)|0;if((a[k>>0]&1)==0){U=e;vb(U|0)}Hv(c[o>>2]|0);U=e;vb(U|0)}}while(0);e=qb(-1,-1)|0;if((a[o>>0]&1)==0){U=e;vb(U|0)}Hv(c[o+8>>2]|0);U=e;vb(U|0)}}e=qb(-1,-1)|0;if((a[v>>0]&1)==0){U=e;vb(U|0)}Hv(c[v+8>>2]|0);U=e;vb(U|0)}}e=qb(-1,-1)|0;if((a[C>>0]&1)==0){U=e;vb(U|0)}Hv(c[C+8>>2]|0);U=e;vb(U|0)}function Dg(a,b){a=a|0;b=b|0;return}function Eg(a,b,d){a=a|0;b=b|0;d=d|0;if((d|0)!=0){c[d>>2]=c[b>>2]}return}function Fg(a,b,d){a=a|0;b=b|0;d=d|0;c[d>>2]=c[b>>2];return}function Gg(a,b,d){a=a|0;b=b|0;d=d|0;c[d>>2]=c[b>>2];return}function Hg(a,b){a=a|0;b=b|0;return b|0}function Ig(a){a=a|0;return 4}function Jg(a){a=a|0;return 3424}function Kg(a,b,d){a=a|0;b=b|0;d=d|0;a=i;io(b,c[d>>2]|0)|0;i=a;return}function Lg(a,b){a=a|0;b=b|0;return}function Mg(a,b,d){a=a|0;b=b|0;d=d|0;if((d|0)!=0){c[d>>2]=c[b>>2]}return}function Ng(a,b,d){a=a|0;b=b|0;d=d|0;c[d>>2]=c[b>>2];return}function Og(a,b,d){a=a|0;b=b|0;d=d|0;c[d>>2]=c[b>>2];return}function Pg(a,b){a=a|0;b=b|0;return b|0}function Qg(a){a=a|0;return 4}function Rg(a){a=a|0;return 24592}function Sg(a,b,d){a=a|0;b=b|0;d=d|0;a=i;io(b,c[d>>2]|0)|0;i=a;return}function Tg(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;d=i;i=i+16|0;g=d;h=c[b>>2]|0;f=a+4|0;k=b+4|0;if((Sa(f|0,4,1,c[k>>2]|0)|0)!=1){b=Jb(8)|0;u=0;oa(75,b|0,2592);p=u;u=0;if(p&1){p=qb(-1,-1)|0;pb(b|0);vb(p|0)}else{c[b>>2]=288;qc(b|0,264,1)}}c[a>>2]=c[(c[h+72>>2]|0)+(c[f>>2]<<2)>>2];if((Sa(g|0,4,1,c[k>>2]|0)|0)!=1){b=Jb(8)|0;u=0;oa(75,b|0,2592);p=u;u=0;if(p&1){p=qb(-1,-1)|0;pb(b|0);vb(p|0)}else{c[b>>2]=288;qc(b|0,264,1)}}g=c[g>>2]|0;if((g|0)==0){Ug(b,a+20|0);i=d;return}f=a+8|0;k=a+12|0;l=c[k>>2]|0;m=c[f>>2]|0;a=l-m>>2;if(!(a>>>0<g>>>0)){if(a>>>0>g>>>0?(j=m+(g<<2)|0,(l|0)!=(j|0)):0){c[k>>2]=l+(~((l+ -4+(0-j)|0)>>>2)<<2)}}else{og(f,g-a|0)}a=h+100|0;m=h+120|0;j=c[r>>2]|0;k=h+104|0;l=h+108|0;h=h+116|0;n=0;do{p=c[a>>2]|0;do{if((p|0)<32){c[m>>2]=(c[m>>2]|0)+p;o=Av(8192)|0;if((o|0)==0){zb(3048,27,1,j|0)|0;o=0;break}else{c[o>>2]=c[k>>2];c[k>>2]=o;c[a>>2]=8188;o=o+4|0;c[l>>2]=o;p=8156;e=22;break}}else{o=c[l>>2]|0;p=p+ -32|0;e=22}}while(0);if((e|0)==22){e=0;c[l>>2]=o+32;c[a>>2]=p;c[h>>2]=(c[h>>2]|0)+32}c[o+0>>2]=0;c[o+4>>2]=0;c[o+8>>2]=0;c[o+12>>2]=0;c[o+16>>2]=0;c[o+20>>2]=0;c[o+24>>2]=0;c[o+28>>2]=0;c[(c[f>>2]|0)+(n<<2)>>2]=o;Tg(c[(c[f>>2]|0)+(n<<2)>>2]|0,b);n=n+1|0}while(n>>>0<g>>>0);i=d;return}function Ug(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0;f=i;i=i+16|0;g=f;d=a+4|0;if((Sa(g|0,4,1,c[d>>2]|0)|0)!=1){b=Jb(8)|0;u=0;oa(75,b|0,2592);m=u;u=0;if(m&1){m=qb(-1,-1)|0;pb(b|0);vb(m|0)}else{c[b>>2]=288;qc(b|0,264,1)}}g=c[g>>2]|0;l=b+4|0;k=c[l>>2]|0;m=c[b>>2]|0;j=k-m>>3;if(!(j>>>0<g>>>0)){if(j>>>0>g>>>0?(h=m+(g<<3)|0,(k|0)!=(h|0)):0){c[l>>2]=k+(~((k+ -8+(0-h)|0)>>>3)<<3)}}else{ng(b,g-j|0)}if((g|0)==0){i=f;return}h=0;while(1){l=c[b>>2]|0;k=l+(h<<3)|0;j=c[a>>2]|0;if((Sa(k|0,4,1,c[d>>2]|0)|0)!=1){break}c[l+(h<<3)+4>>2]=c[(c[j+72>>2]|0)+(c[k>>2]<<2)>>2];h=h+1|0;if(!(h>>>0<g>>>0)){e=17;break}}if((e|0)==17){i=f;return}b=Jb(8)|0;u=0;oa(75,b|0,2592);m=u;u=0;if(m&1){m=qb(-1,-1)|0;pb(b|0);vb(m|0)}else{c[b>>2]=288;qc(b|0,264,1)}}function Vg(a){a=a|0;var b=0,d=0,e=0,f=0;b=i;c[a>>2]=2800;f=c[a+144>>2]|0;if((f|0)!=0){u=0;na(c[(c[f>>2]|0)+4>>2]|0,f|0);f=u;u=0;if(!(f&1)){d=c[a>>2]|0;e=4}}else{d=2800|0;e=4}if((e|0)==4?(u=0,na(c[d+68>>2]|0,a|0),f=u,u=0,!(f&1)):0){d=a+104|0;e=c[d>>2]|0;if((e|0)!=0){do{f=e;e=c[e>>2]|0;Bv(f);c[d>>2]=e}while((e|0)!=0)}c[d>>2]=0;c[a+100>>2]=0;c[a+116>>2]=0;c[a+120>>2]=0;d=c[a+88>>2]|0;if((d|0)==0){Hd(a);i=b;return}e=a+92|0;f=c[e>>2]|0;if((f|0)!=(d|0)){c[e>>2]=f+(~((f+ -4+(0-d)|0)>>>2)<<2)}Hv(d);Hd(a);i=b;return}b=qb(-1,-1)|0;d=a+104|0;e=c[d>>2]|0;if((e|0)!=0){do{f=e;e=c[e>>2]|0;Bv(f);c[d>>2]=e}while((e|0)!=0)}c[d>>2]=0;c[a+100>>2]=0;c[a+116>>2]=0;c[a+120>>2]=0;f=c[a+88>>2]|0;if((f|0)!=0){d=a+92|0;e=c[d>>2]|0;if((e|0)!=(f|0)){c[d>>2]=e+(~((e+ -4+(0-f)|0)>>>2)<<2)}Hv(f)}u=0;na(186,a|0);f=u;u=0;if(f&1){f=qb(-1,-1,0)|0;jd(f)}else{vb(b|0)}}function Wg(a){a=a|0;return}function Xg(a){a=a|0;var b=0;b=i;Hv(a);i=b;return}function Yg(a,b,d,e,f,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0.0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0.0,C=0,D=0,E=0,F=0.0,G=0.0,H=0.0,I=0.0;j=i;k=Gv(e>>>0>1073741823?-1:e<<2)|0;l=~~(+(e|0)*+(ow()|0)*4.656612873077393e-10);if(!((l|0)>-1&(l|0)<(e|0))){Wa(3792,3816,173,3872)}o=d+(l<<2)|0;c[f>>2]=c[o>>2];l=(e|0)>0;if(l){n=c[a+20>>2]|0;m=c[a+12>>2]|0;p=n+(fa(c[o>>2]|0,m)|0)|0;q=c[a+8>>2]|0;o=q+ -3|0;r=0.0;s=0;do{v=n+(fa(m,c[d+(s<<2)>>2]|0)|0)|0;t=v+(q<<2)|0;u=v+(o<<2)|0;if(v>>>0<u>>>0){w=p;B=0.0;do{I=+g[v>>2]- +g[w>>2];H=+g[v+4>>2]- +g[w+4>>2];G=+g[v+8>>2]- +g[w+8>>2];F=+g[v+12>>2]- +g[w+12>>2];B=B+(I*I+H*H+G*G+F*F);v=v+16|0;w=w+16|0}while(v>>>0<u>>>0)}else{w=p;B=0.0}if(v>>>0<t>>>0){while(1){I=+g[v>>2]- +g[w>>2];v=v+4|0;B=B+I*I;if(!(v>>>0<t>>>0)){break}else{w=w+4|0}}}g[k+(s<<2)>>2]=B;r=r+B;s=s+1|0}while((s|0)!=(e|0))}else{r=0.0}if((b|0)>1){n=e+ -1|0;m=(n|0)>0;p=a+20|0;o=a+12|0;a=a+8|0;q=1;do{t=ow()|0;a:do{if(m){s=0;B=r*+(t|0)*4.656612873077393e-10+0.0;while(1){r=+g[k+(s<<2)>>2];if(B<=r){break a}s=s+1|0;if((s|0)<(n|0)){B=B-r}else{break}}}else{s=0}}while(0);if(l){u=c[p>>2]|0;z=c[o>>2]|0;w=c[d+(s<<2)>>2]|0;v=u+(fa(w,z)|0)|0;t=c[a>>2]|0;x=t+ -3|0;y=0;r=0.0;do{D=u+(fa(z,c[d+(y<<2)>>2]|0)|0)|0;A=D+(t<<2)|0;C=D+(x<<2)|0;if(D>>>0<C>>>0){E=v;B=0.0;do{F=+g[D>>2]- +g[E>>2];G=+g[D+4>>2]- +g[E+4>>2];H=+g[D+8>>2]- +g[E+8>>2];I=+g[D+12>>2]- +g[E+12>>2];B=B+(F*F+G*G+H*H+I*I);D=D+16|0;E=E+16|0}while(D>>>0<C>>>0)}else{E=v;B=0.0}if(D>>>0<A>>>0){while(1){I=+g[D>>2]- +g[E>>2];D=D+4|0;B=B+I*I;if(!(D>>>0<A>>>0)){break}else{E=E+4|0}}}I=+g[k+(y<<2)>>2];r=r+(I<B?I:B);y=y+1|0}while((y|0)!=(e|0));c[f+(q<<2)>>2]=w;if(l){t=c[p>>2]|0;u=c[o>>2]|0;x=t+(fa(c[d+(s<<2)>>2]|0,u)|0)|0;v=c[a>>2]|0;s=v+ -3|0;w=0;do{C=t+(fa(u,c[d+(w<<2)>>2]|0)|0)|0;y=C+(v<<2)|0;z=C+(s<<2)|0;if(C>>>0<z>>>0){A=x;B=0.0;do{F=+g[C>>2]- +g[A>>2];G=+g[C+4>>2]- +g[A+4>>2];H=+g[C+8>>2]- +g[A+8>>2];I=+g[C+12>>2]- +g[A+12>>2];B=B+(F*F+G*G+H*H+I*I);C=C+16|0;A=A+16|0}while(C>>>0<z>>>0);z=C}else{z=C;A=x;B=0.0}if(z>>>0<y>>>0){while(1){I=+g[z>>2]- +g[A>>2];z=z+4|0;B=B+I*I;if(!(z>>>0<y>>>0)){break}else{A=A+4|0}}}E=k+(w<<2)|0;I=+g[E>>2];g[E>>2]=I<B?I:B;w=w+1|0}while((w|0)!=(e|0))}}else{c[f+(q<<2)>>2]=c[d+(s<<2)>>2];r=0.0}q=q+1|0}while((q|0)!=(b|0))}else{b=1}c[h>>2]=b;if((k|0)==0){i=j;return}Iv(k);i=j;return}function Zg(a){a=a|0;return}function _g(a){a=a|0;var b=0;b=i;Hv(a);i=b;return}function $g(a,b,d,e,f,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0.0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0.0,D=0,E=0.0,F=0,G=0,H=0,I=0.0,J=0.0,K=0.0,L=0.0;j=i;k=~~(+(e|0)*+(ow()|0)*4.656612873077393e-10);if(!((k|0)>-1&(k|0)<(e|0))){Wa(3976,3816,114,3872)}c[f>>2]=c[d+(k<<2)>>2];if((b|0)<=1){H=1;c[h>>2]=H;i=j;return}m=(e|0)>0;k=a+20|0;l=a+12|0;a=a+8|0;n=1;while(1){if(!m){d=20;break}v=c[k>>2]|0;w=c[l>>2]|0;z=v+(fa(w,c[f>>2]|0)|0)|0;x=c[a>>2]|0;p=z+(x<<2)|0;y=x+ -3|0;q=z+(y<<2)|0;o=z>>>0<q>>>0;r=(n|0)>1;u=-1;s=0.0;t=0;while(1){A=v+(fa(c[d+(t<<2)>>2]|0,w)|0)|0;if(o){D=z;B=A;C=0.0;do{K=+g[D>>2]- +g[B>>2];J=+g[D+4>>2]- +g[B+4>>2];I=+g[D+8>>2]- +g[B+8>>2];E=+g[D+12>>2]- +g[B+12>>2];C=C+(K*K+J*J+I*I+E*E);D=D+16|0;B=B+16|0}while(D>>>0<q>>>0)}else{D=z;B=A;C=0.0}if(D>>>0<p>>>0){while(1){K=+g[D>>2]- +g[B>>2];D=D+4|0;C=C+K*K;if(!(D>>>0<p>>>0)){break}else{B=B+4|0}}}if(r){B=1;do{G=v+(fa(w,c[f+(B<<2)>>2]|0)|0)|0;D=G+(x<<2)|0;F=G+(y<<2)|0;if(G>>>0<F>>>0){H=A;E=0.0;do{L=+g[G>>2]- +g[H>>2];I=+g[G+4>>2]- +g[H+4>>2];J=+g[G+8>>2]- +g[H+8>>2];K=+g[G+12>>2]- +g[H+12>>2];E=E+(L*L+I*I+J*J+K*K);G=G+16|0;H=H+16|0}while(G>>>0<F>>>0);F=H}else{F=A;E=0.0}if(G>>>0<D>>>0){while(1){L=+g[G>>2]- +g[F>>2];G=G+4|0;E=E+L*L;if(!(G>>>0<D>>>0)){break}else{F=F+4|0}}}C=E<C?E:C;B=B+1|0}while((B|0)!=(n|0))}A=C>s;u=A?t:u;t=t+1|0;if((t|0)==(e|0)){break}else{s=A?C:s}}if((u|0)==-1){d=20;break}c[f+(n<<2)>>2]=c[d+(u<<2)>>2];n=n+1|0;if((n|0)>=(b|0)){d=20;break}}if((d|0)==20){c[h>>2]=n;i=j;return}}function ah(a){a=a|0;return}function bh(a){a=a|0;var b=0;b=i;Hv(a);i=b;return}function ch(a,b,d,e,f,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0.0,D=0,E=0,F=0.0,G=0.0,H=0.0,I=0.0;k=i;i=i+32|0;o=k;c[o>>2]=0;j=o+4|0;c[j>>2]=0;c[o+8>>2]=0;u=0;oa(95,o|0,e|0);E=u;u=0;if(E&1){k=qb(-1,-1)|0;b=c[o>>2]|0;if((b|0)==0){vb(k|0)}h=c[j>>2]|0;if((h|0)!=(b|0)){c[j>>2]=h+(~((h+ -4+(0-b)|0)>>>2)<<2)}Hv(b);vb(k|0)}a:do{if((b|0)>0){l=o+16|0;m=c[o>>2]|0;e=a+20|0;n=a+12|0;a=a+8|0;p=c[o+12>>2]|0;q=c[l>>2]|0;o=0;do{s=f+(o<<2)|0;r=(o|0)>0;do{if((q|0)==(p|0)){break a}t=q;q=q+1|0;c[l>>2]=q;t=c[m+(t<<2)>>2]|0;if((t|0)<0){break a}w=c[d+(t<<2)>>2]|0;c[s>>2]=w;if(!r){break}v=c[e>>2]|0;t=c[n>>2]|0;y=v+(fa(t,w)|0)|0;A=c[a>>2]|0;B=y+(A<<2)|0;A=y+(A+ -3<<2)|0;x=y>>>0<A>>>0;w=0;z=0;do{E=v+(fa(c[f+(z<<2)>>2]|0,t)|0)|0;if(x){D=y;C=0.0;do{I=+g[D>>2]- +g[E>>2];H=+g[D+4>>2]- +g[E+4>>2];G=+g[D+8>>2]- +g[E+8>>2];F=+g[D+12>>2]- +g[E+12>>2];C=C+(I*I+H*H+G*G+F*F);D=D+16|0;E=E+16|0}while(D>>>0<A>>>0)}else{D=y;C=0.0}if(D>>>0<B>>>0){while(1){I=+g[D>>2]- +g[E>>2];D=D+4|0;C=C+I*I;if(!(D>>>0<B>>>0)){break}else{E=E+4|0}}}w=C<1.0e-16?1:w;z=z+1|0}while((z|0)!=(o|0))}while(!((w&1)==0));o=o+1|0}while((o|0)<(b|0))}else{m=c[o>>2]|0;o=0}}while(0);c[h>>2]=o;if((m|0)==0){i=k;return}h=c[j>>2]|0;if((h|0)!=(m|0)){c[j>>2]=h+(~((h+ -4+(0-m)|0)>>>2)<<2)}Hv(m);i=k;return}function dh(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0;d=i;e=a+4|0;j=c[e>>2]|0;f=c[a>>2]|0;g=j-f>>2;if(!(g>>>0<b>>>0)){if(g>>>0>b>>>0?(h=f+(b<<2)|0,(j|0)!=(h|0)):0){c[e>>2]=j+(~((j+ -4+(0-h)|0)>>>2)<<2)}}else{eh(a,b-g|0);f=c[a>>2]|0}g=a+12|0;c[g>>2]=b;if((b|0)>0){b=0;do{c[f+(b<<2)>>2]=b;b=b+1|0}while((b|0)<(c[g>>2]|0))}b=c[e>>2]|0;e=b-f|0;if((e|0)<=4){j=a+16|0;c[j>>2]=0;i=d;return}b=b+ -4|0;if(!(f>>>0<b>>>0)){j=a+16|0;c[j>>2]=0;i=d;return}e=e>>2;while(1){j=f+(~~(+(e|0)*+(ow()|0)*4.656612873077393e-10)<<2)|0;h=c[f>>2]|0;c[f>>2]=c[j>>2];c[j>>2]=h;f=f+4|0;if(!(f>>>0<b>>>0)){break}else{e=e+ -1|0}}j=a+16|0;c[j>>2]=0;i=d;return}function eh(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0;e=i;f=a+8|0;d=a+4|0;g=c[d>>2]|0;m=c[f>>2]|0;j=g;if(!(m-j>>2>>>0<b>>>0)){f=b;a=g;while(1){if((a|0)!=0){c[a>>2]=0}f=f+ -1|0;if((f|0)==0){break}else{a=a+4|0}}c[d>>2]=g+(b<<2);i=e;return}g=c[a>>2]|0;n=g;j=j-n|0;l=j>>2;k=l+b|0;if(k>>>0>1073741823){ss(0)}m=m-n|0;if(m>>2>>>0<536870911){n=m>>1;n=n>>>0<k>>>0?k:n;if((n|0)==0){m=0;n=0}else{h=10}}else{n=1073741823;h=10}if((h|0)==10){m=n;n=Fv(n<<2)|0}h=n+(l<<2)|0;while(1){if((h|0)!=0){c[h>>2]=0}b=b+ -1|0;if((b|0)==0){break}else{h=h+4|0}}tw(n|0,g|0,j|0)|0;c[a>>2]=n;c[d>>2]=n+(k<<2);c[f>>2]=n+(m<<2);if((g|0)==0){i=e;return}Hv(g);i=e;return}function fh(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0.0;l=i;i=i+80|0;f=l+65|0;j=l+64|0;t=l+52|0;w=l+48|0;q=l+36|0;s=l+32|0;n=l+20|0;o=l+16|0;k=l+4|0;m=l;a[f+0>>0]=a[j+0>>0]|0;Dd(b,e,f);c[b>>2]=4096;c[b+88>>2]=0;f=b+92|0;j=b+96|0;c[j>>2]=0;c[b+100>>2]=0;c[f>>2]=b+96;c[b+104>>2]=32;g[b+108>>2]=0.0;a[b+112>>0]=1;c[b+116>>2]=-1;c[b+120>>2]=2;c[b+124>>2]=1;a[b+128>>0]=0;c[b+132>>2]=0;c[b+136>>2]=0;c[b+140>>2]=0;c[b+144>>2]=-1;x=b+148|0;v=b+164|0;c[x+0>>2]=0;c[x+4>>2]=0;c[x+8>>2]=0;c[x+12>>2]=0;c[v>>2]=-1;v=b+168|0;x=b+184|0;c[v+0>>2]=0;c[v+4>>2]=0;c[v+8>>2]=0;c[v+12>>2]=0;c[x>>2]=-1;c[b+188>>2]=0;g[b+192>>2]=0.0;x=b+196|0;c[x+0>>2]=c[d+0>>2];c[x+4>>2]=c[d+4>>2];c[x+8>>2]=c[d+8>>2];c[x+12>>2]=c[d+12>>2];c[x+16>>2]=c[d+16>>2];u=0;x=qa(119,32)|0;v=u;u=0;do{if(!(v&1)){v=t+8|0;c[v>>2]=x;c[t>>2]=33;c[t+4>>2]=16;d=x+0|0;p=4176|0;r=d+16|0;do{a[d>>0]=a[p>>0]|0;d=d+1|0;p=p+1|0}while((d|0)<(r|0));a[x+16>>0]=0;g[w>>2]=.800000011920929;u=0;y=+Ja(1,e|0,t|0,w|0);x=u;u=0;if(x&1){k=qb(-1,-1)|0;if((a[t>>0]&1)==0){break}Hv(c[v>>2]|0);break}g[b+216>>2]=y;if(!((a[t>>0]&1)==0)){Hv(c[v>>2]|0)}u=0;v=qa(119,16)|0;x=u;u=0;if(!(x&1)){t=q+8|0;c[t>>2]=v;c[q>>2]=17;c[q+4>>2]=12;d=v+0|0;p=4200|0;r=d+12|0;do{a[d>>0]=a[p>>0]|0;d=d+1|0;p=p+1|0}while((d|0)<(r|0));a[v+12>>0]=0;g[s>>2]=.009999999776482582;u=0;y=+Ja(1,e|0,q|0,s|0);x=u;u=0;if(x&1){k=qb(-1,-1)|0;if((a[q>>0]&1)==0){break}Hv(c[t>>2]|0);break}g[b+220>>2]=y;if(!((a[q>>0]&1)==0)){Hv(c[t>>2]|0)}u=0;s=qa(119,16)|0;x=u;u=0;if(!(x&1)){q=n+8|0;c[q>>2]=s;c[n>>2]=17;c[n+4>>2]=13;d=s+0|0;p=4216|0;r=d+13|0;do{a[d>>0]=a[p>>0]|0;d=d+1|0;p=p+1|0}while((d|0)<(r|0));a[s+13>>0]=0;g[o>>2]=0.0;u=0;y=+Ja(1,e|0,n|0,o|0);x=u;u=0;if(x&1){k=qb(-1,-1)|0;if((a[n>>0]&1)==0){break}Hv(c[q>>2]|0);break}g[b+224>>2]=y;if(!((a[n>>0]&1)==0)){Hv(c[q>>2]|0)}u=0;o=qa(119,16)|0;x=u;u=0;if(!(x&1)){n=k+8|0;c[n>>2]=o;c[k>>2]=17;c[k+4>>2]=15;d=o+0|0;p=4232|0;r=d+15|0;do{a[d>>0]=a[p>>0]|0;d=d+1|0;p=p+1|0}while((d|0)<(r|0));a[o+15>>0]=0;g[m>>2]=.10000000149011612;u=0;y=+Ja(1,e|0,k|0,m|0);x=u;u=0;if(x&1){e=qb(-1,-1)|0;if((a[k>>0]&1)==0){k=e;break}Hv(c[n>>2]|0);k=e;break}g[b+228>>2]=y;if((a[k>>0]&1)==0){i=l;return}Hv(c[n>>2]|0);i=l;return}else{h=18}}else{h=18}}else{h=18}}else{h=18}}while(0);if((h|0)==18){k=qb(-1,-1)|0}Bd(f,c[j>>2]|0);u=0;na(186,b|0);x=u;u=0;if(x&1){x=qb(-1,-1,0)|0;jd(x)}else{vb(k|0)}}function gh(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,h=0,j=0.0;e=i;i=i+16|0;f=e+4|0;h=e;pf(h,a,b);b=c[h>>2]|0;if((b|0)==(a+4|0)){h=d;j=+g[h>>2];i=e;return+j}d=b+28|0;h=c[d>>2]|0;h=(Bc[c[(c[h>>2]|0)+24>>2]&255](h)|0)+4|0;if((c[h>>2]|0)==(c[24628>>2]|0)){c[f>>2]=c[b+32>>2];h=c[d>>2]|0;h=Sc[c[(c[h>>2]|0)+16>>2]&63](h,f)|0;j=+g[h>>2];i=e;return+j}e=Jb(8)|0;u=0;oa(75,e|0,1760);h=u;u=0;if(h&1){h=qb(-1,-1)|0;pb(e|0);vb(h|0)}else{c[e>>2]=1800;qc(e|0,1744,22)}return 0.0}function hh(a){a=a|0;var b=0,d=0,e=0;b=i;c[a>>2]=4096;d=c[a+88>>2]|0;if((d|0)!=0?(u=0,na(c[(c[d>>2]|0)+4>>2]|0,d|0),d=u,u=0,d&1):0){d=qb(-1,-1)|0;Bd(a+92|0,c[a+96>>2]|0);u=0;na(186,a|0);e=u;u=0;if(e&1){e=qb(-1,-1,0)|0;jd(e)}else{vb(d|0)}}Bd(a+92|0,c[a+96>>2]|0);Hd(a);i=b;return}function ih(a){a=a|0;var b=0,d=0,e=0;b=i;c[a>>2]=4096;d=c[a+88>>2]|0;if((d|0)!=0?(u=0,na(c[(c[d>>2]|0)+4>>2]|0,d|0),d=u,u=0,d&1):0){d=qb(-1,-1)|0;Bd(a+92|0,c[a+96>>2]|0);u=0;na(186,a|0);e=u;u=0;if(e&1){e=qb(-1,-1,0)|0;jd(e)}else{e=d;Hv(a);vb(e|0)}}Bd(a+92|0,c[a+96>>2]|0);u=0;na(186,a|0);e=u;u=0;if(!(e&1)){Hv(a);i=b;return}e=qb(-1,-1)|0;Hv(a);vb(e|0)}function jh(a){a=a|0;var b=0;b=i;a=c[a+88>>2]|0;a=Bc[c[(c[a>>2]|0)+8>>2]&255](a)|0;i=b;return a|0}function kh(a){a=a|0;var b=0;b=i;a=c[a+88>>2]|0;a=Bc[c[(c[a>>2]|0)+12>>2]&255](a)|0;i=b;return a|0}function lh(a){a=a|0;return 255}function mh(a){a=a|0;var b=0;b=i;a=c[a+88>>2]|0;a=Bc[c[(c[a>>2]|0)+20>>2]&255](a)|0;i=b;return a|0}function nh(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;h=i;i=i+32|0;n=h+28|0;m=h+24|0;o=h+20|0;f=h;e=b+4|0;c[e>>2]=0;c[b+8>>2]=0;l=b+4|0;c[b>>2]=l;r=c[d+92>>2]|0;p=d+96|0;if((r|0)==(p|0)){i=h;return}j=f+12|0;k=f+16|0;d=f+8|0;while(1){c[o>>2]=l;u=0;oa(77,f|0,r+16|0);q=u;u=0;if(q&1){l=21;break}u=0;c[n+0>>2]=c[o+0>>2];Qa(18,m|0,b|0,n|0,f|0);q=u;u=0;if(q&1){l=10;break}q=c[j>>2]|0;u=0;oa(c[c[q>>2]>>2]|0,q|0,k|0);q=u;u=0;if(q&1){l=8;break}if(!((a[f>>0]&1)==0)){Hv(c[d>>2]|0)}q=c[r+4>>2]|0;if((q|0)==0){while(1){q=c[r+8>>2]|0;if((c[q>>2]|0)==(r|0)){r=q;break}else{r=q}}}else{r=q;while(1){q=c[r>>2]|0;if((q|0)==0){break}else{r=q}}}if((r|0)==(p|0)){l=23;break}}do{if((l|0)==8){g=qb(-1,-1)|0;if(!((a[f>>0]&1)==0)){Hv(c[d>>2]|0)}}else if((l|0)==10){h=qb(-1,-1)|0;r=c[j>>2]|0;u=0;oa(c[c[r>>2]>>2]|0,r|0,k|0);r=u;u=0;if(!(r&1)){if((a[f>>0]&1)==0){g=h;break}Hv(c[d>>2]|0);g=h;break}h=qb(-1,-1,0)|0;if((a[f>>0]&1)==0){jd(h)}Hv(c[d>>2]|0);jd(h)}else if((l|0)==21){g=qb(-1,-1)|0}else if((l|0)==23){i=h;return}}while(0);Bd(b,c[e>>2]|0);vb(g|0)}function oh(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0;k=i;i=i+48|0;n=k+24|0;g=k+12|0;j=k;f=n+4|0;c[f>>2]=d;e=n+8|0;a[e>>0]=0;u=0;oa(96,b|0,n|0);n=u;u=0;if(n&1){b=qb(-1,-1)|0}else{h=g+4|0;c[h>>2]=0;c[g+8>>2]=0;c[g>>2]=g+4;a[j>>0]=18;m=j+1|0;n=320|0;l=m+9|0;do{a[m>>0]=a[n>>0]|0;m=m+1|0;n=n+1|0}while((m|0)<(l|0));a[j+10>>0]=0;u=0;l=Ha(34,b+92|0,j|0)|0;n=u;u=0;if(n&1){b=qb(-1,-1)|0;if(!((a[j>>0]&1)==0)){Hv(c[j+8>>2]|0)}}else{if(!((a[j>>0]&1)==0)){Hv(c[j+8>>2]|0)}u=0;j=Ma(7,l|0,b+196|0,g|0,b+4|0)|0;n=u;u=0;if(!(n&1)?(c[b+88>>2]=j,u=0,oa(c[(c[j>>2]|0)+28>>2]|0,j|0,d|0),n=u,u=0,!(n&1)):0){Bd(g,c[h>>2]|0);if((a[e>>0]|0)==0){i=k;return}Rb(c[f>>2]|0)|0;i=k;return}b=qb(-1,-1)|0}Bd(g,c[h>>2]|0)}if((a[e>>0]|0)==0){vb(b|0)}Rb(c[f>>2]|0)|0;vb(b|0)}function ph(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0;g=i;i=i+16|0;h=g;e=h+4|0;c[e>>2]=d;f=h+8|0;a[f>>0]=0;u=0;oa(97,b|0,h|0);h=u;u=0;if(!(h&1)?(h=c[b+88>>2]|0,u=0,oa(c[(c[h>>2]|0)+32>>2]|0,h|0,d|0),h=u,u=0,!(h&1)):0){if((a[f>>0]|0)==0){i=g;return}Rb(c[e>>2]|0)|0;i=g;return}b=qb(-1,-1)|0;if((a[f>>0]|0)==0){vb(b|0)}Rb(c[e>>2]|0)|0;vb(b|0)}function qh(a){a=a|0;var b=0,c=0;c=i;b=Fv(232)|0;u=0;oa(98,b|0,a|0);a=u;u=0;if(a&1){c=qb(-1,-1)|0;Hv(b);vb(c|0)}else{i=c;return b|0}return 0}function rh(b){b=b|0;var d=0,e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,r=0,s=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0.0;e=i;i=i+112|0;m=e;n=e+96|0;x=e+92|0;w=e+80|0;H=e+76|0;I=e+72|0;B=e+52|0;A=e+40|0;z=e+28|0;p=e+16|0;d=e+4|0;l=b+92|0;zh(A,b);h=b+96|0;Bd(l,c[h>>2]|0);j=b+100|0;c[j>>2]=0;K=b+96|0;c[l>>2]=K;c[K>>2]=0;L=c[A>>2]|0;J=A+4|0;a:do{if((L|0)!=(J|0)){E=B+12|0;F=B+16|0;C=B+8|0;while(1){c[I>>2]=K;u=0;oa(77,B|0,L+16|0);M=u;u=0;if(M&1){v=26;break}u=0;c[m+0>>2]=c[I+0>>2];Qa(18,H|0,l|0,m|0,B|0);M=u;u=0;if(M&1){v=10;break}M=c[E>>2]|0;u=0;oa(c[c[M>>2]>>2]|0,M|0,F|0);M=u;u=0;if(M&1){v=8;break}if(!((a[B>>0]&1)==0)){Hv(c[C>>2]|0)}M=c[L+4>>2]|0;if((M|0)==0){while(1){M=c[L+8>>2]|0;if((c[M>>2]|0)==(L|0)){L=M;break}else{L=M}}}else{L=M;while(1){M=c[L>>2]|0;if((M|0)==0){break}else{L=M}}}if((L|0)==(J|0)){break a}}do{if((v|0)==8){D=qb(-1,-1)|0;if(!((a[B>>0]&1)==0)){Hv(c[C>>2]|0)}}else if((v|0)==10){d=qb(-1,-1)|0;M=c[E>>2]|0;u=0;oa(c[c[M>>2]>>2]|0,M|0,F|0);M=u;u=0;if(!(M&1)){if((a[B>>0]&1)==0){D=d;break}Hv(c[C>>2]|0);D=d;break}d=qb(-1,-1,0)|0;if((a[B>>0]&1)==0){jd(d)}Hv(c[C>>2]|0);jd(d)}else if((v|0)==26){D=qb(-1,-1)|0}}while(0);Bd(A,c[A+4>>2]|0);M=D;vb(M|0)}}while(0);Bd(A,c[A+4>>2]|0);Ah(4384,m)|0;Ah(4440,m)|0;if((a[5584]|0)==0?(Ua(5584)|0)!=0:0){c[1394]=c[t>>2];c[5580>>2]=3;jb(195,5576,q|0)|0;rb(5584)}if((c[5580>>2]|0)>3){Bh(l)}Ah(4384,m)|0;a[z>>0]=18;D=z+1|0;C=320|0;B=D+9|0;do{a[D>>0]=a[C>>0]|0;D=D+1|0;C=C+1|0}while((D|0)<(B|0));a[z+10>>0]=0;u=0;A=Ha(34,l|0,z|0)|0;M=u;u=0;if(M&1){d=qb(-1,-1)|0;if((a[z>>0]&1)==0){M=d;vb(M|0)}Hv(c[z+8>>2]|0);M=d;vb(M|0)}if(!((a[z>>0]&1)==0)){Hv(c[z+8>>2]|0)}A=yd(A,b+196|0,l,b+4|0)|0;c[b+88>>2]=A;yc[c[(c[A>>2]|0)+40>>2]&255](A);A=b+104|0;N=+Ch(b,A);z=b+192|0;g[z>>2]=N;Ah(4384,m)|0;Ah(4464,m)|0;if((a[5584]|0)==0?(Ua(5584)|0)!=0:0){c[1394]=c[t>>2];c[5580>>2]=3;jb(195,5576,q|0)|0;rb(5584)}if((c[5580>>2]|0)>3){Dh(A)}Ah(4384,m)|0;E=Fv(16)|0;b=p+8|0;c[b>>2]=E;c[p>>2]=17;c[p+4>>2]=13;D=E+0|0;C=4488|0;B=D+13|0;do{a[D>>0]=a[C>>0]|0;D=D+1|0;C=C+1|0}while((D|0)<(B|0));a[E+13>>0]=0;B=Pf(l,x,p)|0;C=c[B>>2]|0;if((C|0)==0){u=0;Na(43,w|0,l|0,p|0);M=u;u=0;if(!(M&1)){y=c[w>>2]|0;c[w>>2]=0;v=c[x>>2]|0;c[y>>2]=0;c[y+4>>2]=0;c[y+8>>2]=v;c[B>>2]=y;v=c[c[l>>2]>>2]|0;if((v|0)==0){v=y}else{c[l>>2]=v;v=c[B>>2]|0}ge(c[h>>2]|0,v);c[j>>2]=(c[j>>2]|0)+1;v=43}}else{y=C;v=43}if((v|0)==43?(s=y+28|0,M=c[s>>2]|0,r=y+32|0,u=0,oa(c[c[M>>2]>>2]|0,M|0,r|0),M=u,u=0,!(M&1)):0){if((a[2072]|0)==0?(Ua(2072)|0)!=0:0){c[516]=2088;rb(2072)}c[s>>2]=2064;if((a[4696]|0)==0?(Ua(4696)|0)!=0:0){c[1172]=4712;rb(4696)}c[s>>2]=4688;u=0;Na(c[(c[1172]|0)+4>>2]|0,4688,A|0,r|0);M=u;u=0;if(!(M&1)){if(!((a[p>>0]&1)==0)){Hv(c[b>>2]|0)}a[d>>0]=14;p=d+1|0;a[p+0>>0]=a[4504>>0]|0;a[p+1>>0]=a[4505>>0]|0;a[p+2>>0]=a[4506>>0]|0;a[p+3>>0]=a[4507>>0]|0;a[p+4>>0]=a[4508>>0]|0;a[p+5>>0]=a[4509>>0]|0;a[p+6>>0]=a[4510>>0]|0;p=d+8|0;a[p>>0]=0;r=Pf(l,m,d)|0;s=c[r>>2]|0;if((s|0)==0){u=0;Na(43,n|0,l|0,d|0);M=u;u=0;if(!(M&1)){o=c[n>>2]|0;c[n>>2]=0;m=c[m>>2]|0;c[o>>2]=0;c[o+4>>2]=0;c[o+8>>2]=m;c[r>>2]=o;m=c[c[l>>2]>>2]|0;if((m|0)==0){l=o}else{c[l>>2]=m;l=c[r>>2]|0}ge(c[h>>2]|0,l);c[j>>2]=(c[j>>2]|0)+1;v=58}}else{o=s;v=58}if((v|0)==58?(f=o+28|0,M=c[f>>2]|0,k=o+32|0,u=0,oa(c[c[M>>2]>>2]|0,M|0,k|0),M=u,u=0,!(M&1)):0){if((a[2072]|0)==0?(Ua(2072)|0)!=0:0){c[516]=2088;rb(2072)}c[f>>2]=2064;do{if((a[4520]|0)==0){if((Ua(4520)|0)==0){break}c[1128]=4536;rb(4520)}}while(0);c[f>>2]=4512;u=0;Na(c[(c[1128]|0)+4>>2]|0,4512,z|0,k|0);M=u;u=0;if(!(M&1)){if((a[d>>0]&1)==0){i=e;return}Hv(c[p>>2]|0);i=e;return}}e=qb(-1,-1)|0;if((a[d>>0]&1)==0){M=e;vb(M|0)}Hv(c[p>>2]|0);M=e;vb(M|0)}}d=qb(-1,-1)|0;if((a[p>>0]&1)==0){M=d;vb(M|0)}Hv(c[b>>2]|0);M=d;vb(M|0)}function sh(a,b){a=a|0;b=b|0;var d=0,e=0;d=i;e=a+196|0;c[e+0>>2]=c[b+0>>2];c[e+4>>2]=c[b+4>>2];c[e+8>>2]=c[b+8>>2];c[e+12>>2]=c[b+12>>2];c[e+16>>2]=c[b+16>>2];yc[c[(c[a>>2]|0)+40>>2]&255](a);i=d;return}function th(a,b,d){a=a|0;b=b|0;d=+d;var e=0;e=i;a=c[a+88>>2]|0;if((a|0)==0){i=e;return}_c[c[(c[a>>2]|0)+48>>2]&15](a,b,d);i=e;return}function uh(a,b){a=a|0;b=b|0;var d=0;d=i;a=c[a+88>>2]|0;if((a|0)==0){i=d;return}zc[c[(c[a>>2]|0)+52>>2]&127](a,b);i=d;return}function vh(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0;h=i;j=c[a+88>>2]|0;k=c[(c[j>>2]|0)+60>>2]|0;if((c[g>>2]|0)==-2){g=Ac[k&7](j,b,d,e,f,a+104|0)|0;i=h;return g|0}else{g=Ac[k&7](j,b,d,e,f,g)|0;i=h;return g|0}return 0}function wh(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;Wa(4304,4312,293,4368)}function xh(a){a=a|0;return}function yh(a){a=a|0;return}function zh(b,d){b=b|0;d=d|0;var e=0,f=0,j=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0.0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0.0,K=0,L=0,M=0,N=0,O=0,P=0.0,Q=0.0,R=0,S=0,T=0.0,U=0,V=0,W=0,X=0.0,Y=0,Z=0;j=i;i=i+272|0;l=j;q=j+260|0;r=j+256|0;o=j+236|0;y=j+232|0;x=j+228|0;v=j+208|0;F=j+204|0;D=j+200|0;B=j+180|0;L=j+168|0;M=j+264|0;I=j+164|0;N=j+160|0;t=j+140|0;f=j+128|0;z=j+116|0;U=j+96|0;R=j+76|0;m=j+48|0;G=j+36|0;K=j+32|0;n=j+20|0;c[f>>2]=0;e=f+4|0;c[e>>2]=0;H=f+8|0;c[H>>2]=0;W=d+196|0;Y=c[W>>2]|0;V=~~(+g[d+228>>2]*+(Y>>>0));S=(V|0)/10|0;S=(S|0)>1e3?1e3:S;X=+g[d+216>>2];c[l>>2]=Y;c[l+4>>2]=V;c[l+8>>2]=S;Y=l+12|0;h[k>>3]=X;c[Y>>2]=c[k>>2];c[Y+4>>2]=c[k+4>>2];Ah(5592,l)|0;a:do{if((S|0)<10){Ah(5696,l)|0;u=0;na(196,z|0);Y=u;u=0;if(Y&1){I=27}else{m=b+4|0;c[m>>2]=0;c[b+8>>2]=0;r=b+4|0;c[b>>2]=r;d=c[z>>2]|0;q=z+4|0;b:do{if((d|0)!=(q|0)){p=t+12|0;o=t+16|0;n=t+8|0;while(1){c[N>>2]=r;u=0;oa(77,t|0,d+16|0);Y=u;u=0;if(Y&1){I=23;break}u=0;c[l+0>>2]=c[N+0>>2];Qa(18,I|0,b|0,l|0,t|0);Y=u;u=0;if(Y&1){I=12;break}Y=c[p>>2]|0;u=0;oa(c[c[Y>>2]>>2]|0,Y|0,o|0);Y=u;u=0;if(Y&1){I=10;break}if(!((a[t>>0]&1)==0)){Hv(c[n>>2]|0)}s=c[d+4>>2]|0;if((s|0)==0){while(1){s=c[d+8>>2]|0;if((c[s>>2]|0)==(d|0)){d=s;break}else{d=s}}}else{d=s;while(1){s=c[d>>2]|0;if((s|0)==0){break}else{d=s}}}if((d|0)==(q|0)){break b}}do{if((I|0)==10){A=qb(-1,-1)|0;if(!((a[t>>0]&1)==0)){Hv(c[n>>2]|0)}}else if((I|0)==12){j=qb(-1,-1)|0;Y=c[p>>2]|0;u=0;oa(c[c[Y>>2]>>2]|0,Y|0,o|0);Y=u;u=0;if(!(Y&1)){if((a[t>>0]&1)==0){A=j;break}Hv(c[n>>2]|0);A=j;break}j=qb(-1,-1,0)|0;if((a[t>>0]&1)==0){jd(j)}Hv(c[n>>2]|0);jd(j)}else if((I|0)==23){A=qb(-1,-1)|0}}while(0);Bd(b,c[m>>2]|0);Bd(z,c[z+4>>2]|0);p=A;break a}}while(0);Bd(z,c[z+4>>2]|0);I=151}}else{t=d+132|0;u=0;Qa(27,U|0,W|0,V|0,0);Y=u;u=0;if(!(Y&1)){c[t+0>>2]=c[U+0>>2];c[t+4>>2]=c[U+4>>2];c[t+8>>2]=c[U+8>>2];c[t+12>>2]=c[U+12>>2];c[t+16>>2]=c[U+16>>2];I=d+152|0;u=0;Qa(27,R|0,t|0,S|0,1);Y=u;u=0;if(!(Y&1)){c[I+0>>2]=c[R+0>>2];c[I+4>>2]=c[R+4>>2];c[I+8>>2]=c[R+8>>2];c[I+12>>2]=c[R+12>>2];c[I+16>>2]=c[R+16>>2];Ah(5736,l)|0;z=c[I>>2]|0;u=0;A=qa(121,(z>>>0>1073741823?-1:z<<2)|0)|0;Y=u;u=0;if(!(Y&1)){c[d+172>>2]=z;R=d+176|0;c[R>>2]=1;O=d+180|0;c[O>>2]=4;c[d+184>>2]=6;z=d+188|0;c[z>>2]=A;A=d+168|0;U=d+160|0;J=0.0;N=0;c:while(1){N=N+1|0;u=0;S=Ka(1)|0;Y=u;u=0;if(Y&1){I=26;break}if((c[I>>2]|0)!=0){V=0;do{Z=(c[A>>2]|0)+(fa(c[U>>2]|0,V)|0)|0;W=(c[z>>2]|0)+(fa(c[O>>2]|0,V)|0)|0;Y=c[R>>2]|0;u=0;a[l+0>>0]=a[M+0>>0]|0;ya(20,t|0,Z|0,W|0,Y|0,0,l|0);Y=u;u=0;if(Y&1){I=25;break c}V=V+1|0}while(V>>>0<(c[I>>2]|0)>>>0)}u=0;V=Ka(1)|0;Z=u;u=0;if(Z&1){I=26;break}J=J+(+(V|0)- +(S|0))/1.0e6;if(!(J<.2)){I=40;break}}if((I|0)==25){p=qb(-1,-1)|0;I=28;break}else if((I|0)==26){p=qb(-1,-1)|0;I=28;break}else if((I|0)==40){t=m+20|0;c[t>>2]=0;I=m+24|0;c[I>>2]=0;c[m+16>>2]=m+20;g[m>>2]=J/+(N|0);g[m+4>>2]=0.0;g[m+8>>2]=0.0;a[G>>0]=18;O=G+1|0;N=320|0;M=O+9|0;do{a[O>>0]=a[N>>0]|0;O=O+1|0;N=N+1|0}while((O|0)<(M|0));a[G+10>>0]=0;O=m+16|0;N=Pf(O,l,G)|0;M=c[N>>2]|0;if((M|0)==0){u=0;Na(43,L|0,O|0,G|0);Z=u;u=0;if(Z&1){I=68}else{M=c[L>>2]|0;c[L>>2]=0;L=c[l>>2]|0;c[M>>2]=0;c[M+4>>2]=0;c[M+8>>2]=L;c[N>>2]=M;L=c[c[O>>2]>>2]|0;if((L|0)==0){L=M}else{c[O>>2]=L;L=c[N>>2]|0}ge(c[t>>2]|0,L);c[I>>2]=(c[I>>2]|0)+1;I=45}}else{I=45}d:do{if((I|0)==45){c[K>>2]=0;I=M+28|0;Z=c[I>>2]|0;L=M+32|0;u=0;oa(c[c[Z>>2]>>2]|0,Z|0,L|0);Z=u;u=0;if(!(Z&1)){if((a[2072]|0)==0?(Ua(2072)|0)!=0:0){c[516]=2088;rb(2072)}c[I>>2]=2064;if((a[2336]|0)==0?(Ua(2336)|0)!=0:0){c[582]=2352;rb(2336)}c[I>>2]=2328;u=0;Na(c[(c[582]|0)+4>>2]|0,2328,K|0,L|0);Z=u;u=0;if(!(Z&1)){if(!((a[G>>0]&1)==0)){Hv(c[G+8>>2]|0)}G=c[e>>2]|0;do{if((G|0)==(c[H>>2]|0)){u=0;oa(100,f|0,m|0);Z=u;u=0;if(Z&1){I=66}else{I=61}}else{if((G|0)==0){G=0}else{u=0;oa(99,G|0,m|0);Z=u;u=0;if(Z&1){I=66;break}G=c[e>>2]|0}c[e>>2]=G+28;I=61}}while(0);e:do{if((I|0)==61){Ah(5768,l)|0;u=0;oa(101,d|0,f|0);Z=u;u=0;if(!(Z&1)?(u=0,oa(102,d|0,f|0),Z=u,u=0,!(Z&1)):0){Z=c[f>>2]|0;P=+g[Z+4>>2];I=d+220|0;Q=+g[I>>2];T=+g[Z>>2];J=P*Q+T;f:do{if((c[e>>2]|0)!=(Z|0)){G=1;while(1){X=P*Q+T;h[k>>3]=X;c[l>>2]=c[k>>2];c[l+4>>2]=c[k+4>>2];di(5800,l)|0;J=X<J?X:J;H=c[f>>2]|0;if(!(G>>>0<(((c[e>>2]|0)-H|0)/28|0)>>>0)){break f}P=+g[H+(G*28|0)+4>>2];Q=+g[I>>2];T=+g[H+(G*28|0)>>2];G=G+1|0}}}while(0);h[k>>3]=J;c[l>>2]=c[k>>2];c[l+4>>2]=c[k+4>>2];di(5816,l)|0;O=c[f>>2]|0;G=n+4|0;c[G>>2]=0;K=n+8|0;c[K>>2]=0;H=n+4|0;c[n>>2]=H;S=c[O+16>>2]|0;O=O+20|0;g:do{if((S|0)!=(O|0)){N=B+12|0;M=B+16|0;L=B+8|0;while(1){c[D>>2]=H;u=0;oa(77,B|0,S+16|0);Z=u;u=0;if(Z&1){I=90;break}u=0;c[l+0>>2]=c[D+0>>2];Qa(18,F|0,n|0,l|0,B|0);Z=u;u=0;if(Z&1){I=79;break}Z=c[N>>2]|0;u=0;oa(c[c[Z>>2]>>2]|0,Z|0,M|0);Z=u;u=0;if(Z&1){I=77;break}if(!((a[B>>0]&1)==0)){Hv(c[L>>2]|0)}R=c[S+4>>2]|0;if((R|0)==0){while(1){R=c[S+8>>2]|0;if((c[R>>2]|0)==(S|0)){break}else{S=R}}}else{while(1){S=c[R>>2]|0;if((S|0)==0){break}else{R=S}}}if((R|0)==(O|0)){break g}else{S=R}}do{if((I|0)==77){C=qb(-1,-1)|0;if((a[B>>0]&1)==0){break}Hv(c[L>>2]|0)}else if((I|0)==79){b=qb(-1,-1)|0;Z=c[N>>2]|0;u=0;oa(c[c[Z>>2]>>2]|0,Z|0,M|0);Z=u;u=0;if(!(Z&1)){if((a[B>>0]&1)==0){C=b;break}Hv(c[L>>2]|0);C=b;break}b=qb(-1,-1,0)|0;if((a[B>>0]&1)==0){jd(b)}Hv(c[L>>2]|0);jd(b)}else if((I|0)==90){C=qb(-1,-1)|0}}while(0);Bd(n,c[G>>2]|0);p=C;break e}}while(0);h:do{if(J>0.0){L=c[f>>2]|0;P=+g[L+4>>2];Q=+g[I>>2];T=+g[L>>2];X=(P*Q+T)/J;i:do{if((c[e>>2]|0)!=(L|0)){E=d+224|0;D=v+12|0;C=v+16|0;B=v+8|0;F=0;j:while(1){P=(P*Q+T)/J+ +g[E>>2]*+g[L+(F*28|0)+8>>2];h[k>>3]=P;c[l>>2]=c[k>>2];c[l+4>>2]=c[k+4>>2];di(5840,l)|0;do{if(P<X){L=c[f>>2]|0;Bd(n,c[G>>2]|0);c[K>>2]=0;c[n>>2]=H;c[H>>2]=0;N=c[L+(F*28|0)+16>>2]|0;L=L+(F*28|0)+20|0;if((N|0)==(L|0)){X=P;break}while(1){c[x>>2]=H;u=0;oa(77,v|0,N+16|0);Z=u;u=0;if(Z&1){I=116;break j}u=0;c[l+0>>2]=c[x+0>>2];Qa(18,y|0,n|0,l|0,v|0);Z=u;u=0;if(Z&1){I=105;break j}Z=c[D>>2]|0;u=0;oa(c[c[Z>>2]>>2]|0,Z|0,C|0);Z=u;u=0;if(Z&1){I=103;break j}if(!((a[v>>0]&1)==0)){Hv(c[B>>2]|0)}M=c[N+4>>2]|0;if((M|0)==0){while(1){M=c[N+8>>2]|0;if((c[M>>2]|0)==(N|0)){break}else{N=M}}}else{while(1){N=c[M>>2]|0;if((N|0)==0){break}else{M=N}}}if((M|0)==(L|0)){X=P;break}else{N=M}}}}while(0);F=F+1|0;L=c[f>>2]|0;if(!(F>>>0<(((c[e>>2]|0)-L|0)/28|0)>>>0)){w=X;break i}P=+g[L+(F*28|0)+4>>2];Q=+g[I>>2];T=+g[L+(F*28|0)>>2]}if((I|0)==103){p=qb(-1,-1)|0;if((a[v>>0]&1)==0){break h}Hv(c[B>>2]|0);break h}else if((I|0)==105){x=qb(-1,-1)|0;Z=c[D>>2]|0;u=0;oa(c[c[Z>>2]>>2]|0,Z|0,C|0);Z=u;u=0;if(!(Z&1)){if((a[v>>0]&1)==0){p=x;break h}Hv(c[B>>2]|0);p=x;break h}x=qb(-1,-1,0)|0;if((a[v>>0]&1)==0){jd(x)}Hv(c[B>>2]|0);jd(x)}else if((I|0)==116){p=qb(-1,-1)|0;break h}}else{w=X}}while(0);h[k>>3]=w;c[l>>2]=c[k>>2];c[l+4>>2]=c[k+4>>2];di(5856,l)|0;I=121}else{I=121}}while(0);k:do{if((I|0)==121){v=c[z>>2]|0;if((v|0)!=0){Iv(v)}v=c[A>>2]|0;if((v|0)!=0){Iv(v)}d=c[d+148>>2]|0;if((d|0)!=0){Iv(d)}v=b+4|0;c[v>>2]=0;c[b+8>>2]=0;z=b+4|0;c[b>>2]=z;A=c[n>>2]|0;l:do{if((A|0)!=(H|0)){x=o+12|0;y=o+16|0;d=o+8|0;while(1){c[r>>2]=z;u=0;oa(77,o|0,A+16|0);Z=u;u=0;if(Z&1){I=147;break}u=0;c[l+0>>2]=c[r+0>>2];Qa(18,q|0,b|0,l|0,o|0);Z=u;u=0;if(Z&1){I=136;break}Z=c[x>>2]|0;u=0;oa(c[c[Z>>2]>>2]|0,Z|0,y|0);Z=u;u=0;if(Z&1){I=134;break}if(!((a[o>>0]&1)==0)){Hv(c[d>>2]|0)}B=c[A+4>>2]|0;if((B|0)==0){while(1){B=c[A+8>>2]|0;if((c[B>>2]|0)==(A|0)){A=B;break}else{A=B}}}else{A=B;while(1){B=c[A>>2]|0;if((B|0)==0){break}else{A=B}}}if((A|0)==(H|0)){break l}}do{if((I|0)==134){p=qb(-1,-1)|0;if((a[o>>0]&1)==0){break}Hv(c[d>>2]|0)}else if((I|0)==136){j=qb(-1,-1)|0;Z=c[x>>2]|0;u=0;oa(c[c[Z>>2]>>2]|0,Z|0,y|0);Z=u;u=0;if(!(Z&1)){if((a[o>>0]&1)==0){p=j;break}Hv(c[d>>2]|0);p=j;break}j=qb(-1,-1,0)|0;if((a[o>>0]&1)==0){jd(j)}Hv(c[d>>2]|0);jd(j)}else if((I|0)==147){p=qb(-1,-1)|0}}while(0);Bd(b,c[v>>2]|0);break k}}while(0);Bd(n,c[G>>2]|0);Bd(m+16|0,c[t>>2]|0);I=151;break a}}while(0);Bd(n,c[G>>2]|0);break d}else{I=66}}}while(0);if((I|0)==66){p=qb(-1,-1)|0}}else{I=68}}else{I=68}}}while(0);if((I|0)==68){p=qb(-1,-1)|0;if(!((a[G>>0]&1)==0)){Hv(c[G+8>>2]|0)}}Bd(m+16|0,c[t>>2]|0);break}}else{I=27}}else{I=27}}else{I=27}}}while(0);if((I|0)==27){p=qb(-1,-1)|0;I=28}else if((I|0)==151){b=c[f>>2]|0;if((b|0)==0){i=j;return}l=c[e>>2]|0;if((l|0)!=(b|0)){do{c[e>>2]=l+ -28;Bd(l+ -12|0,c[l+ -8>>2]|0);l=c[e>>2]|0}while((l|0)!=(b|0));b=c[f>>2]|0}Hv(b);i=j;return}b=c[f>>2]|0;if((b|0)==0){vb(p|0)}j=c[e>>2]|0;if((j|0)!=(b|0)){do{c[e>>2]=j+ -28;Bd(j+ -12|0,c[j+ -8>>2]|0);j=c[e>>2]|0}while((j|0)!=(b|0));b=c[f>>2]|0}Hv(b);vb(p|0)}function Ah(b,d){b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e;c[f>>2]=d;if((a[5584]|0)==0?(Ua(5584)|0)!=0:0){c[1394]=c[t>>2];c[5580>>2]=3;jb(195,5576,q|0)|0;rb(5584)}if((c[5580>>2]|0)<4){d=-1;i=e;return d|0}d=Ib(c[1394]|0,b|0,f|0)|0;i=e;return d|0}function Bh(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,j=0;e=i;i=i+16|0;b=e;f=c[a>>2]|0;a=a+4|0;if((f|0)==(a|0)){i=e;return}while(1){g=he($h(11640,f+16|0)|0,5568)|0;h=c[f+28>>2]|0;Yc[c[(c[h>>2]|0)+28>>2]&63](h,g,f+32|0);ln(b,g+(c[(c[g>>2]|0)+ -12>>2]|0)|0);u=0;h=Ha(35,b|0,16352)|0;j=u;u=0;if(j&1){break}u=0;h=Ha(c[(c[h>>2]|0)+28>>2]|0,h|0,10)|0;j=u;u=0;if(j&1){break}As(b);lo(g,h)|0;Un(g)|0;g=c[f+4>>2]|0;if((g|0)==0){while(1){g=c[f+8>>2]|0;if((c[g>>2]|0)==(f|0)){f=g;break}else{f=g}}}else{f=g;while(1){g=c[f>>2]|0;if((g|0)==0){break}else{f=g}}}if((f|0)==(a|0)){d=13;break}}if((d|0)==13){i=e;return}d=qb(-1,-1)|0;u=0;na(184,b|0);j=u;u=0;if(j&1){j=qb(-1,-1,0)|0;jd(j)}else{vb(d|0)}}function Ch(b,d){b=b|0;d=d|0;var e=0,f=0,j=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0.0,z=0.0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0.0,K=0.0,L=0,M=0,N=0.0,O=0.0;e=i;i=i+80|0;j=e;r=e+68|0;x=e+48|0;w=e+28|0;l=e+24|0;o=e+20|0;n=e+8|0;A=b+88|0;if((c[A>>2]|0)==0){Wa(4992,4312,648,5016)}v=b+196|0;f=((c[v>>2]|0)>>>0)/10|0;f=f>>>0>1e3?1e3:f;if((f|0)==0){K=0.0;i=e;return+K}Uh(x,v,f,0);Ah(5040,j)|0;D=c[x>>2]|0;C=Gv(D>>>0>1073741823?-1:D<<2)|0;c[w>>2]=D;c[w+4>>2]=1;c[w+12>>2]=6;m=w+16|0;c[m>>2]=C;c[w+8>>2]=4;E=(D|0)==0;f=x+16|0;H=c[f>>2]|0;B=c[x+8>>2]|0;y=0.0;F=0;do{F=F+1|0;G=db()|0;if(!E){I=0;do{M=H+(fa(B,I)|0)|0;L=C+(I<<2)|0;a[j+0>>0]=a[r+0>>0]|0;_h(v,M,L,1,1,j);I=I+1|0}while(I>>>0<D>>>0)}y=y+(+(db()|0)- +(G|0))/1.0e6}while(y<.2);y=y/+(F|0);Ah(5064,j)|0;M=c[A>>2]|0;do{if((Bc[c[(c[M>>2]|0)+16>>2]&255](M)|0)==2){Ah(5096,j)|0;B=c[A>>2]|0;g[o>>2]=0.0;E=B+100|0;C=b+216|0;D=b+4|0;z=-1.0;J=-1.0;A=-1;K=0.0;do{g[E>>2]=K;O=+Vh(B,v,x,w,+g[C>>2],l,D,1,1);M=O<z|z==-1.0;N=+g[o>>2];z=M?O:z;J=M?N:J;A=M?c[l>>2]|0:A;K=N+.20000000298023224;g[o>>2]=K}while(K<1.100000023841858);g[o>>2]=J;c[l>>2]=A;g[E>>2]=J;h[k>>3]=+g[o>>2];c[j>>2]=c[k>>2];c[j+4>>2]=c[k+4>>2];Ah(5152,j)|0;v=b+92|0;a[n>>0]=16;w=n+1|0;x=w;a[x>>0]=1767858787;a[x+1>>0]=6905698;a[x+2>>0]=26975;a[x+3>>0]=105;w=w+4|0;a[w>>0]=2019910766;a[w+1>>0]=7890276;a[w+2>>0]=30821;a[w+3>>0]=120;a[n+9>>0]=0;w=Pf(v,j,n)|0;x=c[w>>2]|0;if((x|0)==0){u=0;Na(43,r|0,v|0,n|0);M=u;u=0;if(!(M&1)){t=c[r>>2]|0;c[r>>2]=0;r=c[j>>2]|0;c[t>>2]=0;c[t+4>>2]=0;c[t+8>>2]=r;c[w>>2]=t;r=c[c[v>>2]>>2]|0;if((r|0)==0){r=t}else{c[v>>2]=r;r=c[w>>2]|0}ge(c[b+96>>2]|0,r);s=b+100|0;c[s>>2]=(c[s>>2]|0)+1;s=16}}else{t=x;s=16}if((s|0)==16?(p=t+28|0,M=c[p>>2]|0,q=t+32|0,u=0,oa(c[c[M>>2]>>2]|0,M|0,q|0),M=u,u=0,!(M&1)):0){if((a[2072]|0)==0?(Ua(2072)|0)!=0:0){c[516]=2088;rb(2072)}c[p>>2]=2064;if((a[4520]|0)==0?(Ua(4520)|0)!=0:0){c[1128]=4536;rb(4520)}c[p>>2]=4512;u=0;Na(c[(c[1128]|0)+4>>2]|0,4512,o|0,q|0);M=u;u=0;if(!(M&1)){if((a[n>>0]&1)==0){break}Hv(c[n+8>>2]|0);break}}e=qb(-1,-1)|0;if((a[n>>0]&1)==0){vb(e|0)}Hv(c[n+8>>2]|0);vb(e|0)}else{z=+Wh(c[A>>2]|0,v,x,w,+g[b+216>>2],l,b+4|0,1,1)}}while(0);M=c[l>>2]|0;c[j>>2]=M;Ah(5192,j)|0;c[d>>2]=M;y=y/z;j=c[m>>2]|0;if((j|0)!=0){Iv(j)}f=c[f>>2]|0;if((f|0)==0){O=y;i=e;return+O}Iv(f);O=y;i=e;return+O}function Dh(b){b=b|0;var d=0,e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0;f=i;i=i+16|0;d=f;k=he(11640,4928)|0;k=io(k,c[b>>2]|0)|0;ln(d,k+(c[(c[k>>2]|0)+ -12>>2]|0)|0);u=0;l=Ha(35,d|0,16352)|0;n=u;u=0;if(!(n&1)?(u=0,m=Ha(c[(c[l>>2]|0)+28>>2]|0,l|0,10)|0,n=u,u=0,!(n&1)):0){As(d);lo(k,m)|0;Un(k)|0;k=he(11640,4944)|0;k=ko(k,+g[b+4>>2])|0;ln(d,k+(c[(c[k>>2]|0)+ -12>>2]|0)|0);u=0;l=Ha(35,d|0,16352)|0;n=u;u=0;if(!(n&1)?(u=0,j=Ha(c[(c[l>>2]|0)+28>>2]|0,l|0,10)|0,n=u,u=0,!(n&1)):0){As(d);lo(k,j)|0;Un(k)|0;j=he(11640,4952)|0;j=ho(j,(a[b+8>>0]|0)!=0)|0;ln(d,j+(c[(c[j>>2]|0)+ -12>>2]|0)|0);u=0;k=Ha(35,d|0,16352)|0;n=u;u=0;if(!(n&1)?(u=0,h=Ha(c[(c[k>>2]|0)+28>>2]|0,k|0,10)|0,n=u,u=0,!(n&1)):0){As(d);lo(j,h)|0;Un(j)|0;h=he(11640,4968)|0;b=io(h,c[b+12>>2]|0)|0;ln(d,b+(c[(c[b>>2]|0)+ -12>>2]|0)|0);u=0;h=Ha(35,d|0,16352)|0;n=u;u=0;if(!(n&1)?(u=0,e=Ha(c[(c[h>>2]|0)+28>>2]|0,h|0,10)|0,n=u,u=0,!(n&1)):0){As(d);lo(b,e)|0;Un(b)|0;i=f;return}e=qb(-1,-1)|0;u=0;na(184,d|0);n=u;u=0;if(n&1){n=qb(-1,-1,0)|0;jd(n)}else{vb(e|0)}}e=qb(-1,-1)|0;u=0;na(184,d|0);n=u;u=0;if(n&1){n=qb(-1,-1,0)|0;jd(n)}else{vb(e|0)}}e=qb(-1,-1)|0;u=0;na(184,d|0);n=u;u=0;if(n&1){n=qb(-1,-1,0)|0;jd(n)}else{vb(e|0)}}e=qb(-1,-1)|0;u=0;na(184,d|0);n=u;u=0;if(n&1){n=qb(-1,-1,0)|0;jd(n)}else{vb(e|0)}}function Eh(a,b){a=a|0;b=b|0;return}function Fh(a,b,c){a=a|0;b=b|0;c=c|0;if((c|0)!=0){g[c>>2]=+g[b>>2]}return}function Gh(a,b,d){a=a|0;b=b|0;d=d|0;c[d>>2]=c[b>>2];return}function Hh(a,b,d){a=a|0;b=b|0;d=d|0;c[d>>2]=c[b>>2];return}function Ih(a,b){a=a|0;b=b|0;return b|0}function Jh(a){a=a|0;return 4}function Kh(a){a=a|0;return 24624}function Lh(a,b,c){a=a|0;b=b|0;c=c|0;a=i;ko(b,+g[c>>2])|0;i=a;return}function Mh(a,b){a=a|0;b=b|0;var d=0;a=i;d=c[b>>2]|0;if((d|0)!=0){Hv(d)}c[b>>2]=0;i=a;return}function Nh(a,b,d){a=a|0;b=b|0;d=d|0;var e=0;a=i;e=Fv(28)|0;c[e+0>>2]=c[b+0>>2];c[e+4>>2]=c[b+4>>2];c[e+8>>2]=c[b+8>>2];c[e+12>>2]=c[b+12>>2];c[e+16>>2]=c[b+16>>2];c[e+20>>2]=c[b+20>>2];c[e+24>>2]=c[b+24>>2];c[d>>2]=e;i=a;return}function Oh(a,b,d){a=a|0;b=b|0;d=d|0;var e=0;a=i;e=Fv(28)|0;b=c[b>>2]|0;c[e+0>>2]=c[b+0>>2];c[e+4>>2]=c[b+4>>2];c[e+8>>2]=c[b+8>>2];c[e+12>>2]=c[b+12>>2];c[e+16>>2]=c[b+16>>2];c[e+20>>2]=c[b+20>>2];c[e+24>>2]=c[b+24>>2];c[d>>2]=e;i=a;return}function Ph(b,d,e){b=b|0;d=d|0;e=e|0;b=i;e=c[e>>2]|0;d=c[d>>2]|0;c[e+0>>2]=c[d+0>>2];c[e+4>>2]=c[d+4>>2];c[e+8>>2]=c[d+8>>2];c[e+12>>2]=c[d+12>>2];c[e+16>>2]=c[d+16>>2];c[e+20>>2]=c[d+20>>2];a[e+24>>0]=a[d+24>>0]|0;i=b;return}function Qh(a,b){a=a|0;b=b|0;return c[b>>2]|0}function Rh(a){a=a|0;return 28}function Sh(a){a=a|0;return 4920}function Th(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0;f=i;i=i+16|0;b=f;g=c[e>>2]|0;if((a[2072]|0)==0?(Ua(2072)|0)!=0:0){c[516]=2088;rb(2072)}c[b>>2]=2064;e=b+4|0;c[e>>2]=0;zc[c[c[516]>>2]&127](2064,e);if((a[2072]|0)==0?(Ua(2072)|0)!=0:0){c[516]=2088;rb(2072)}c[b>>2]=2064;if((a[4696]|0)==0?(Ua(4696)|0)!=0:0){c[1172]=4712;rb(4696)}c[b>>2]=4688;Yc[c[(c[1172]|0)+4>>2]&63](4688,g,e);g=c[b>>2]|0;u=0;Na(c[(c[g>>2]|0)+28>>2]|0,g|0,d|0,e|0);g=u;u=0;if(!(g&1)){g=c[b>>2]|0;zc[c[c[g>>2]>>2]&127](g,e);i=f;return}d=qb(-1,-1)|0;g=c[b>>2]|0;u=0;oa(c[c[g>>2]>>2]|0,g|0,e|0);g=u;u=0;if(g&1){g=qb(-1,-1,0)|0;jd(g)}else{vb(d|0)}}function Uh(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0;h=i;i=i+32|0;g=h;t=c[b>>2]|0;c[g>>2]=0;f=g+4|0;c[f>>2]=0;c[g+8>>2]=0;u=0;oa(95,g|0,t|0);t=u;u=0;if(t&1){h=qb(-1,-1)|0;g=c[g>>2]|0;if((g|0)==0){vb(h|0)}e=c[f>>2]|0;if((e|0)!=(g|0)){c[f>>2]=e+(~((e+ -4+(0-g)|0)>>>2)<<2)}Hv(g);vb(h|0)}k=b+4|0;l=c[k>>2]|0;j=fa(l,d)|0;u=0;j=qa(121,(j>>>0>1073741823?-1:j<<2)|0)|0;t=u;u=0;a:do{if(t&1){h=qb(-1,-1)|0}else{c[a>>2]=d;c[a+4>>2]=l;c[a+12>>2]=8;c[a+16>>2]=j;l=l<<2;c[a+8>>2]=l;b:do{if((d|0)!=0){a=b+16|0;n=b+8|0;p=g+16|0;o=g+12|0;m=0;while(1){if(!e){q=c[p>>2]|0;if((q|0)==(c[o>>2]|0)){s=-1}else{c[p>>2]=q+1;s=c[(c[g>>2]|0)+(q<<2)>>2]|0}}else{q=c[b>>2]|0;u=0;r=Ka(2)|0;t=u;u=0;if(t&1){break}s=~~(+(q-m|0)*+(r|0)*4.656612873077393e-10)}v=j+(fa(l,m)|0)|0;q=c[a>>2]|0;r=c[n>>2]|0;s=q+(fa(r,s)|0)|0;t=c[k>>2]|0;vw(v|0,s|0,s+(t<<2)-s|0)|0;if(e){v=q+(fa(r,(c[b>>2]|0)+~m|0)|0)|0;vw(s|0,v|0,v+(t<<2)-v|0)|0}m=m+1|0;if(!(m>>>0<d>>>0)){break b}}h=qb(-1,-1)|0;break a}}while(0);if(e){c[b>>2]=(c[b>>2]|0)-d}g=c[g>>2]|0;if((g|0)==0){i=h;return}e=c[f>>2]|0;if((e|0)!=(g|0)){c[f>>2]=e+(~((e+ -4+(0-g)|0)>>>2)<<2)}Hv(g);i=h;return}}while(0);g=c[g>>2]|0;if((g|0)==0){vb(h|0)}e=c[f>>2]|0;if((e|0)!=(g|0)){c[f>>2]=e+(~((e+ -4+(0-g)|0)>>>2)<<2)}Hv(g);vb(h|0)}function Vh(a,b,d,e,f,h,j,k,l){a=a|0;b=b|0;d=d|0;e=e|0;f=+f;h=h|0;j=j|0;k=k|0;l=l|0;var m=0,n=0,o=0,p=0,q=0,r=0,s=0.0,t=0,u=0;n=i;i=i+16|0;o=n;j=n+8|0;p=n+4|0;Ah(5224,o)|0;Ah(5288,o)|0;s=+Zh(a,b,d,e,k,1,j,p,0,l);if(s>f){Ah(5352,o)|0;t=1;c[h>>2]=t;s=+g[j>>2];i=n;return+s}if(s<f){q=1;while(1){r=q<<1;s=+Zh(a,b,d,e,k,r,j,p,0,l);if(s<f){q=r}else{break}}}else{q=1;r=1}if(!(+U(+(s-f))>.0010000000474974513)){Ah(5408,o)|0;t=r;c[h>>2]=t;s=+g[j>>2];i=n;return+s}Ah(5376,o)|0;t=(q+r|0)/2|0;s=+Zh(a,b,d,e,k,t,j,p,0,l);if(!(+U(+(s-f))>.0010000000474974513)){c[h>>2]=t;s=+g[j>>2];i=n;return+s}while(1){u=s<f;r=u?r:t;q=u?t:q;t=(q+r|0)/2|0;if((t|0)==(q|0)){break}s=+Zh(a,b,d,e,k,t,j,p,0,l);if(!(+U(+(s-f))>.0010000000474974513)){m=11;break}}if((m|0)==11){c[h>>2]=t;s=+g[j>>2];i=n;return+s}Ah(5352,o)|0;u=q;c[h>>2]=u;s=+g[j>>2];i=n;return+s}function Wh(a,b,d,e,f,h,j,k,l){a=a|0;b=b|0;d=d|0;e=e|0;f=+f;h=h|0;j=j|0;k=k|0;l=l|0;var m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0.0,u=0,v=0;o=i;i=i+16|0;q=o;n=o+8|0;p=o+4|0;Ah(5224,q)|0;Ah(5288,q)|0;t=+Xh(a,b,d,e,k,1,n,p,j,l);if(t>f){Ah(5352,q)|0;u=1;c[h>>2]=u;t=+g[n>>2];i=o;return+t}if(t<f){s=1;while(1){r=s<<1;t=+Xh(a,b,d,e,k,r,n,p,j,l);if(t<f){s=r}else{break}}}else{s=1;r=1}if(!(+U(+(t-f))>.0010000000474974513)){Ah(5408,q)|0;u=r;c[h>>2]=u;t=+g[n>>2];i=o;return+t}Ah(5376,q)|0;u=(s+r|0)/2|0;t=+Xh(a,b,d,e,k,u,n,p,j,l);if(!(+U(+(t-f))>.0010000000474974513)){c[h>>2]=u;t=+g[n>>2];i=o;return+t}while(1){v=t<f;r=v?r:u;s=v?u:s;u=(s+r|0)/2|0;if((u|0)==(s|0)){break}t=+Xh(a,b,d,e,k,u,n,p,j,l);if(!(+U(+(t-f))>.0010000000474974513)){m=11;break}}if((m|0)==11){c[h>>2]=u;t=+g[n>>2];i=o;return+t}Ah(5352,q)|0;v=s;c[h>>2]=v;t=+g[n>>2];i=o;return+t}function Xh(b,d,e,f,j,l,m,n,o,p){b=b|0;d=d|0;e=e|0;f=f|0;j=j|0;l=l|0;m=m|0;n=n|0;o=o|0;p=p|0;var q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0.0,L=0,M=0,N=0.0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0.0;o=i;i=i+128|0;w=o;r=o+96|0;t=o+76|0;s=o+56|0;v=o+36|0;x=c[f+4>>2]|0;if(x>>>0<j>>>0){c[w>>2]=x;c[w+4>>2]=j;Ah(5440,w)|0;n=Jb(8)|0;u=0;oa(75,n|0,5464);U=u;u=0;if(U&1){U=qb(-1,-1)|0;pb(n|0);vb(U|0)}else{c[n>>2]=288;qc(n|0,264,1)}}c[r>>2]=l;g[r+4>>2]=0.0;a[r+8>>0]=1;c[r+12>>2]=-1;c[r+16>>2]=2;c[r+20>>2]=1;a[r+24>>0]=0;y=p+j|0;A=y>>>0>1073741823?-1:y<<2;B=Gv(A)|0;A=Gv(A)|0;c[t>>2]=1;c[t+4>>2]=y;c[t+12>>2]=6;c[t+16>>2]=B;F=y<<2;c[t+8>>2]=F;c[s>>2]=1;c[s+4>>2]=y;c[s+12>>2]=8;c[s+16>>2]=A;c[s+8>>2]=F;F=B+(p<<2)|0;C=e+16|0;D=e+8|0;E=e+4|0;G=v+4|0;z=v+8|0;x=v+12|0;I=v+16|0;H=f+16|0;f=f+8|0;J=(j|0)>0;K=0.0;L=0;do{L=L+1|0;M=db()|0;if((c[e>>2]|0)==0){V=0.0;N=0.0}else{S=c[D>>2]|0;T=c[C>>2]|0;R=c[E>>2]|0;P=0;N=0.0;O=0;do{Q=c[(c[b>>2]|0)+60>>2]|0;U=T+(fa(S,O)|0)|0;c[v>>2]=1;c[G>>2]=R;c[x>>2]=8;c[I>>2]=U;c[z>>2]=R<<2;Ac[Q&7](b,v,t,s,y,r)|0;Q=(c[H>>2]|0)+(fa(c[f>>2]|0,O)|0)|0;if(J){S=0;R=0;do{U=c[B+(R+p<<2)>>2]|0;T=0;do{if((U|0)==(c[Q+(T<<2)>>2]|0)){q=12;break}T=T+1|0}while((T|0)<(j|0));if((q|0)==12){q=0;S=S+1|0}R=R+1|0}while((R|0)!=(j|0))}else{S=0}P=S+P|0;T=c[C>>2]|0;S=c[D>>2]|0;U=T+(fa(S,O)|0)|0;R=c[E>>2]|0;N=N+ +Yh(d,U,F,Q,R,j,0);O=O+1|0}while(O>>>0<(c[e>>2]|0)>>>0);V=+(P|0)}K=K+(+(db()|0)- +(M|0))/1.0e6}while(K<.2);g[m>>2]=K/+(L|0);if((B|0)!=0){Iv(B)}if((A|0)!=0){Iv(A)}T=c[e>>2]|0;K=+((fa(T,j)|0)>>>0);V=V/K;N=N/K;g[n>>2]=N;K=+g[m>>2];c[w>>2]=l;U=w+4|0;h[k>>3]=V;c[U>>2]=c[k>>2];c[U+4>>2]=c[k+4>>2];U=w+12|0;h[k>>3]=K;c[U>>2]=c[k>>2];c[U+4>>2]=c[k+4>>2];U=w+20|0;h[k>>3]=K*1.0e3/+(T>>>0);c[U>>2]=c[k>>2];c[U+4>>2]=c[k+4>>2];U=w+28|0;h[k>>3]=N;c[U>>2]=c[k>>2];c[U+4>>2]=c[k+4>>2];Ah(5528,w)|0;i=o;return+V}function Yh(a,b,d,e,f,h,j){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0.0,o=0.0,p=0,q=0.0,r=0,s=0,t=0,u=0.0,v=0.0,w=0.0,x=0.0;j=i;if((h|0)<=0){q=0.0;i=j;return+q}k=c[a+16>>2]|0;m=c[a+8>>2]|0;l=f+ -3|0;a=0;n=0.0;do{t=k+(fa(m,c[e+(a<<2)>>2]|0)|0)|0;p=t+(f<<2)|0;r=t+(l<<2)|0;if(t>>>0<r>>>0){s=b;o=0.0;do{w=+g[t>>2]- +g[s>>2];v=+g[t+4>>2]- +g[s+4>>2];u=+g[t+8>>2]- +g[s+8>>2];q=+g[t+12>>2]- +g[s+12>>2];o=o+(w*w+v*v+u*u+q*q);t=t+16|0;s=s+16|0}while(t>>>0<r>>>0)}else{s=b;o=0.0}if(t>>>0<p>>>0){while(1){w=+g[t>>2]- +g[s>>2];t=t+4|0;o=o+w*w;if(!(t>>>0<p>>>0)){break}else{s=s+4|0}}}t=k+(fa(m,c[d+(a<<2)>>2]|0)|0)|0;p=t+(f<<2)|0;r=t+(l<<2)|0;if(t>>>0<r>>>0){s=b;q=0.0;do{x=+g[t>>2]- +g[s>>2];u=+g[t+4>>2]- +g[s+4>>2];v=+g[t+8>>2]- +g[s+8>>2];w=+g[t+12>>2]- +g[s+12>>2];q=q+(x*x+u*u+v*v+w*w);t=t+16|0;s=s+16|0}while(t>>>0<r>>>0);r=t}else{r=t;s=b;q=0.0}if(r>>>0<p>>>0){while(1){x=+g[r>>2]- +g[s>>2];r=r+4|0;q=q+x*x;if(!(r>>>0<p>>>0)){break}else{s=s+4|0}}}if(o==0.0&q==0.0){n=n+1.0}else{n=n+q/o}a=a+1|0}while((a|0)!=(h|0));i=j;return+n}function Zh(b,d,e,f,j,l,m,n,o,p){b=b|0;d=d|0;e=e|0;f=f|0;j=j|0;l=l|0;m=m|0;n=n|0;o=o|0;p=p|0;var q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0.0,L=0,M=0,N=0.0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0.0;o=i;i=i+128|0;w=o;r=o+96|0;t=o+76|0;s=o+56|0;v=o+36|0;x=c[f+4>>2]|0;if(x>>>0<j>>>0){c[w>>2]=x;c[w+4>>2]=j;Ah(5440,w)|0;n=Jb(8)|0;u=0;oa(75,n|0,5464);U=u;u=0;if(U&1){U=qb(-1,-1)|0;pb(n|0);vb(U|0)}else{c[n>>2]=288;qc(n|0,264,1)}}c[r>>2]=l;g[r+4>>2]=0.0;a[r+8>>0]=1;c[r+12>>2]=-1;c[r+16>>2]=2;c[r+20>>2]=1;a[r+24>>0]=0;y=p+j|0;A=y>>>0>1073741823?-1:y<<2;B=Gv(A)|0;A=Gv(A)|0;c[t>>2]=1;c[t+4>>2]=y;c[t+12>>2]=6;c[t+16>>2]=B;F=y<<2;c[t+8>>2]=F;c[s>>2]=1;c[s+4>>2]=y;c[s+12>>2]=8;c[s+16>>2]=A;c[s+8>>2]=F;F=B+(p<<2)|0;C=e+16|0;D=e+8|0;E=e+4|0;G=v+4|0;z=v+8|0;x=v+12|0;I=v+16|0;H=f+16|0;f=f+8|0;J=(j|0)>0;K=0.0;L=0;do{L=L+1|0;M=db()|0;if((c[e>>2]|0)==0){V=0.0;N=0.0}else{S=c[D>>2]|0;T=c[C>>2]|0;R=c[E>>2]|0;P=0;N=0.0;O=0;do{Q=c[(c[b>>2]|0)+60>>2]|0;U=T+(fa(S,O)|0)|0;c[v>>2]=1;c[G>>2]=R;c[x>>2]=8;c[I>>2]=U;c[z>>2]=R<<2;Ac[Q&7](b,v,t,s,y,r)|0;Q=(c[H>>2]|0)+(fa(c[f>>2]|0,O)|0)|0;if(J){S=0;R=0;do{U=c[B+(R+p<<2)>>2]|0;T=0;do{if((U|0)==(c[Q+(T<<2)>>2]|0)){q=12;break}T=T+1|0}while((T|0)<(j|0));if((q|0)==12){q=0;S=S+1|0}R=R+1|0}while((R|0)!=(j|0))}else{S=0}P=S+P|0;T=c[C>>2]|0;S=c[D>>2]|0;U=T+(fa(S,O)|0)|0;R=c[E>>2]|0;N=N+ +Yh(d,U,F,Q,R,j,0);O=O+1|0}while(O>>>0<(c[e>>2]|0)>>>0);V=+(P|0)}K=K+(+(db()|0)- +(M|0))/1.0e6}while(K<.2);g[m>>2]=K/+(L|0);if((B|0)!=0){Iv(B)}if((A|0)!=0){Iv(A)}T=c[e>>2]|0;K=+((fa(T,j)|0)>>>0);V=V/K;N=N/K;g[n>>2]=N;K=+g[m>>2];c[w>>2]=l;U=w+4|0;h[k>>3]=V;c[U>>2]=c[k>>2];c[U+4>>2]=c[k+4>>2];U=w+12|0;h[k>>3]=K;c[U>>2]=c[k>>2];c[U+4>>2]=c[k+4>>2];U=w+20|0;h[k>>3]=K*1.0e3/+(T>>>0);c[U>>2]=c[k>>2];c[U+4>>2]=c[k+4>>2];U=w+28|0;h[k>>3]=N;c[U>>2]=c[k>>2];c[U+4>>2]=c[k+4>>2];Ah(5528,w)|0;i=o;return+V}function _h(a,b,d,e,f,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0.0,v=0,w=0,x=0.0,y=0.0,z=0.0,A=0.0;l=i;k=f+e|0;j=k>>>0>1073741823?-1:k<<2;m=Gv(j)|0;j=Gv(j)|0;n=c[a+16>>2]|0;p=a+8|0;h=c[a+4>>2]|0;q=n+(h<<2)|0;o=h+ -3|0;r=n+(o<<2)|0;if(n>>>0<r>>>0){t=n;s=b;u=0.0;do{A=+g[t>>2]- +g[s>>2];z=+g[t+4>>2]- +g[s+4>>2];y=+g[t+8>>2]- +g[s+8>>2];x=+g[t+12>>2]- +g[s+12>>2];u=u+(A*A+z*z+y*y+x*x);t=t+16|0;s=s+16|0}while(t>>>0<r>>>0)}else{t=n;s=b;u=0.0}if(t>>>0<q>>>0){while(1){A=+g[t>>2]- +g[s>>2];t=t+4|0;u=u+A*A;if(!(t>>>0<q>>>0)){break}else{s=s+4|0}}}g[j>>2]=u;c[m>>2]=0;a=c[a>>2]|0;if(a>>>0>1){p=c[p>>2]|0;r=1;q=1;do{w=n+(fa(p,q)|0)|0;s=w+(h<<2)|0;t=w+(o<<2)|0;if(w>>>0<t>>>0){v=b;u=0.0;do{x=+g[w>>2]- +g[v>>2];y=+g[w+4>>2]- +g[v+4>>2];z=+g[w+8>>2]- +g[v+8>>2];A=+g[w+12>>2]- +g[v+12>>2];u=u+(x*x+y*y+z*z+A*A);w=w+16|0;v=v+16|0}while(w>>>0<t>>>0)}else{v=b;u=0.0}if(w>>>0<s>>>0){while(1){A=+g[w>>2]- +g[v>>2];w=w+4|0;u=u+A*A;if(!(w>>>0<s>>>0)){break}else{v=v+4|0}}}if((r|0)>=(k|0)){s=r+ -1|0;t=j+(s<<2)|0;if(u<+g[t>>2]){g[t>>2]=u;c[m+(s<<2)>>2]=q}}else{c[m+(r<<2)>>2]=q;g[j+(r<<2)>>2]=u;r=r+1|0}s=r+ -1|0;a:do{if((s|0)>0){v=r;while(1){t=j+(s<<2)|0;u=+g[t>>2];w=v+ -2|0;v=j+(w<<2)|0;x=+g[v>>2];if(!(u<x)){break a}g[t>>2]=x;g[v>>2]=u;v=m+(s<<2)|0;t=m+(w<<2)|0;w=c[v>>2]|0;c[v>>2]=c[t>>2];c[t>>2]=w;t=s+ -1|0;if((t|0)>0){v=s;s=t}else{break}}}}while(0);q=q+1|0}while(q>>>0<a>>>0)}if((e|0)!=0){tw(d|0,m+(f<<2)|0,e<<2|0)|0}if((m|0)!=0){Iv(m)}if((j|0)==0){i=l;return}Iv(j);i=l;return}function $h(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0;e=i;i=i+32|0;g=e+16|0;f=e+8|0;l=e+4|0;k=e;a[f>>0]=0;c[f+4>>2]=b;o=c[(c[b>>2]|0)+ -12>>2]|0;do{if((c[b+(o+16)>>2]|0)==0){o=c[b+(o+72)>>2]|0;if((o|0)!=0?(u=0,qa(120,o|0)|0,t=u,u=0,t&1):0){j=26;break}a[f>>0]=1;o=a[d>>0]|0;p=(o&1)==0;if(p){o=(o&255)>>>1}else{o=c[d+4>>2]|0}r=c[(c[b>>2]|0)+ -12>>2]|0;c[l>>2]=c[b+(r+24)>>2];if(p){if((c[b+(r+4)>>2]&176|0)==32){q=d+o+1|0}else{q=d+1|0}p=d+1|0;d=d+1|0}else{q=c[d+8>>2]|0;if((c[b+(r+4)>>2]&176|0)==32){q=q+o|0}p=c[d+8>>2]|0;d=c[d+8>>2]|0}s=b+r|0;t=b+(r+76)|0;r=c[t>>2]|0;do{if((r|0)==-1){u=0;oa(84,g|0,s|0);r=u;u=0;if(!(r&1)){u=0;r=Ha(35,g|0,16352)|0;v=u;u=0;if(!(v&1)?(u=0,n=Ha(c[(c[r>>2]|0)+28>>2]|0,r|0,32)|0,v=u,u=0,!(v&1)):0){u=0;na(184,g|0);v=u;u=0;if(v&1){j=27;break}r=n<<24>>24;c[t>>2]=r;j=23;break}k=qb(-1,-1,0)|0;u=0;na(184,g|0);v=u;u=0;if(v&1){v=qb(-1,-1,0)|0;jd(v)}else{m=k}}else{j=27}}else{j=23}}while(0);if((j|0)==23){v=r&255;t=p+o|0;u=0;c[g+0>>2]=c[l+0>>2];Da(39,k|0,g|0,d|0,q|0,t|0,s|0,v|0);v=u;u=0;if(!(v&1)){if((c[k>>2]|0)!=0){j=29;break}v=c[(c[b>>2]|0)+ -12>>2]|0;u=0;oa(85,b+v|0,c[b+(v+16)>>2]|5|0);v=u;u=0;if(!(v&1)){j=29;break}else{j=27}}else{j=27}}if((j|0)==27){m=qb(-1,-1,0)|0}u=0;na(190,f|0);v=u;u=0;if(v&1){v=qb(-1,-1,0)|0;jd(v)}else{h=m}}else{j=29}}while(0);if((j|0)==29){u=0;na(190,f|0);v=u;u=0;if(v&1){j=26}else{i=e;return b|0}}if((j|0)==26){h=qb(-1,-1,0)|0}$a(h|0)|0;u=0;na(191,b+(c[(c[b>>2]|0)+ -12>>2]|0)|0);v=u;u=0;if(!(v&1)){Ob();i=e;return b|0}b=qb(-1,-1)|0;u=0;Oa(2);v=u;u=0;if(v&1){v=qb(-1,-1,0)|0;jd(v)}else{vb(b|0)}return 0}function ai(a){a=a|0;var b=0;b=i;a=c[a>>2]|0;if((a|0)==0?1:(a|0)==(c[t>>2]|0)){i=b;return}Rb(a|0)|0;i=b;return}function bi(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0;p=i;i=i+192|0;E=p;F=p+176|0;y=p+172|0;z=p+160|0;r=p+156|0;s=p+144|0;v=p+140|0;K=p+128|0;P=p+112|0;G=p+88|0;H=p+60|0;k=p+48|0;Q=p+44|0;g=p+32|0;t=p+28|0;l=p+16|0;o=p+4|0;Ah(6344,E)|0;c[P+0>>2]=c[6392>>2];c[P+4>>2]=c[6396>>2];c[P+8>>2]=c[6400>>2];c[P+12>>2]=c[6404>>2];c[G+0>>2]=c[6408>>2];c[G+4>>2]=c[6412>>2];c[G+8>>2]=c[6416>>2];c[G+12>>2]=c[6420>>2];c[G+16>>2]=c[6424>>2];I=d+4|0;Qi(d,(((c[I>>2]|0)-(c[d>>2]|0)|0)/28|0)+20|0);e=H+20|0;A=H+24|0;M=H+20|0;N=H+16|0;B=H+16|0;O=k+1|0;T=k+10|0;j=g+8|0;q=g+4|0;w=l+1|0;x=l+11|0;C=o+1|0;D=o+10|0;J=d+8|0;f=H+16|0;n=o+8|0;m=l+8|0;h=k+8|0;L=0;a:while(1){R=P+(L<<2)|0;S=0;do{c[e>>2]=0;c[A>>2]=0;c[N>>2]=M;a[k>>0]=18;W=O+0|0;V=320|0;U=W+9|0;do{a[W>>0]=a[V>>0]|0;W=W+1|0;V=V+1|0}while((W|0)<(U|0));a[T>>0]=0;U=Pf(B,v,k)|0;V=c[U>>2]|0;if((V|0)==0){u=0;Na(43,K|0,B|0,k|0);X=u;u=0;if(X&1){q=73;break a}V=c[K>>2]|0;c[K>>2]=0;W=c[v>>2]|0;c[V>>2]=0;c[V+4>>2]=0;c[V+8>>2]=W;c[U>>2]=V;W=c[c[B>>2]>>2]|0;if((W|0)==0){U=V}else{c[B>>2]=W;U=c[U>>2]|0}ge(c[e>>2]|0,U);c[A>>2]=(c[A>>2]|0)+1}c[Q>>2]=2;U=V+28|0;X=c[U>>2]|0;V=V+32|0;u=0;oa(c[c[X>>2]>>2]|0,X|0,V|0);X=u;u=0;if(X&1){q=73;break a}if((a[2072]|0)==0?(Ua(2072)|0)!=0:0){c[516]=2088;rb(2072)}c[U>>2]=2064;if((a[2336]|0)==0?(Ua(2336)|0)!=0:0){c[582]=2352;rb(2336)}c[U>>2]=2328;u=0;Na(c[(c[582]|0)+4>>2]|0,2328,Q|0,V|0);X=u;u=0;if(X&1){q=73;break a}if(!((a[k>>0]&1)==0)){Hv(c[h>>2]|0)}u=0;X=qa(119,16)|0;W=u;u=0;if(W&1){q=72;break a}c[j>>2]=X;c[g>>2]=17;c[q>>2]=12;W=X+0|0;V=2896|0;U=W+12|0;do{a[W>>0]=a[V>>0]|0;W=W+1|0;V=V+1|0}while((W|0)<(U|0));a[X+12>>0]=0;V=Pf(B,r,g)|0;U=c[V>>2]|0;if((U|0)==0){u=0;Na(43,s|0,B|0,g|0);X=u;u=0;if(X&1){q=75;break a}U=c[s>>2]|0;c[s>>2]=0;W=c[r>>2]|0;c[U>>2]=0;c[U+4>>2]=0;c[U+8>>2]=W;c[V>>2]=U;W=c[c[B>>2]>>2]|0;if((W|0)==0){V=U}else{c[B>>2]=W;V=c[V>>2]|0}ge(c[e>>2]|0,V);c[A>>2]=(c[A>>2]|0)+1}c[t>>2]=0;V=U+28|0;X=c[V>>2]|0;U=U+32|0;u=0;oa(c[c[X>>2]>>2]|0,X|0,U|0);X=u;u=0;if(X&1){q=75;break a}if((a[2072]|0)==0?(Ua(2072)|0)!=0:0){c[516]=2088;rb(2072)}c[V>>2]=2064;if((a[3176]|0)==0?(Ua(3176)|0)!=0:0){c[792]=3192;rb(3176)}c[V>>2]=3168;u=0;Na(c[(c[792]|0)+4>>2]|0,3168,t|0,U|0);X=u;u=0;if(X&1){q=75;break a}if(!((a[g>>0]&1)==0)){Hv(c[j>>2]|0)}a[l>>0]=20;W=w+0|0;V=6432|0;U=W+10|0;do{a[W>>0]=a[V>>0]|0;W=W+1|0;V=V+1|0}while((W|0)<(U|0));a[x>>0]=0;V=Pf(B,y,l)|0;U=c[V>>2]|0;if((U|0)==0){u=0;Na(43,z|0,B|0,l|0);X=u;u=0;if(X&1){q=77;break a}U=c[z>>2]|0;c[z>>2]=0;W=c[y>>2]|0;c[U>>2]=0;c[U+4>>2]=0;c[U+8>>2]=W;c[V>>2]=U;W=c[c[B>>2]>>2]|0;if((W|0)==0){V=U}else{c[B>>2]=W;V=c[V>>2]|0}ge(c[e>>2]|0,V);c[A>>2]=(c[A>>2]|0)+1}V=U+28|0;X=c[V>>2]|0;U=U+32|0;u=0;oa(c[c[X>>2]>>2]|0,X|0,U|0);X=u;u=0;if(X&1){q=77;break a}if((a[2072]|0)==0?(Ua(2072)|0)!=0:0){c[516]=2088;rb(2072)}c[V>>2]=2064;do{if((a[3440]|0)==0){if((Ua(3440)|0)==0){break}c[858]=3456;rb(3440)}}while(0);c[V>>2]=3432;u=0;Na(c[(c[858]|0)+4>>2]|0,3432,R|0,U|0);X=u;u=0;if(X&1){q=77;break a}if(!((a[l>>0]&1)==0)){Hv(c[m>>2]|0)}a[o>>0]=18;W=C+0|0;V=2880|0;U=W+9|0;do{a[W>>0]=a[V>>0]|0;W=W+1|0;V=V+1|0}while((W|0)<(U|0));a[D>>0]=0;V=Pf(B,E,o)|0;U=c[V>>2]|0;if((U|0)==0){u=0;Na(43,F|0,B|0,o|0);X=u;u=0;if(X&1){q=79;break a}U=c[F>>2]|0;c[F>>2]=0;W=c[E>>2]|0;c[U>>2]=0;c[U+4>>2]=0;c[U+8>>2]=W;c[V>>2]=U;W=c[c[B>>2]>>2]|0;if((W|0)==0){V=U}else{c[B>>2]=W;V=c[V>>2]|0}ge(c[e>>2]|0,V);c[A>>2]=(c[A>>2]|0)+1}V=G+(S<<2)|0;W=U+28|0;X=c[W>>2]|0;U=U+32|0;u=0;oa(c[c[X>>2]>>2]|0,X|0,U|0);X=u;u=0;if(X&1){q=79;break a}do{if((a[2072]|0)==0){if((Ua(2072)|0)==0){break}c[516]=2088;rb(2072)}}while(0);c[W>>2]=2064;do{if((a[3440]|0)==0){if((Ua(3440)|0)==0){break}c[858]=3456;rb(3440)}}while(0);c[W>>2]=3432;u=0;Na(c[(c[858]|0)+4>>2]|0,3432,V|0,U|0);X=u;u=0;if(X&1){q=79;break a}if(!((a[o>>0]&1)==0)){Hv(c[n>>2]|0)}u=0;oa(103,b|0,H|0);X=u;u=0;if(X&1){q=72;break a}U=c[I>>2]|0;if((U|0)==(c[J>>2]|0)){u=0;oa(100,d|0,H|0);X=u;u=0;if(X&1){q=72;break a}}else{if((U|0)==0){U=0}else{u=0;oa(99,U|0,H|0);X=u;u=0;if(X&1){q=72;break a}U=c[I>>2]|0}c[I>>2]=U+28}Bd(f,c[e>>2]|0);S=S+1|0}while(S>>>0<5);L=L+1|0;if(!(L>>>0<4)){q=82;break}}if((q|0)==72){X=qb(-1,-1)|0;W=c[e>>2]|0;Bd(f,W);vb(X|0)}else if((q|0)==73){g=qb(-1,-1)|0;if((a[k>>0]&1)==0){X=g;W=c[e>>2]|0;Bd(f,W);vb(X|0)}Hv(c[h>>2]|0);X=g;W=c[e>>2]|0;Bd(f,W);vb(X|0)}else if((q|0)==75){h=qb(-1,-1)|0;if((a[g>>0]&1)==0){X=h;W=c[e>>2]|0;Bd(f,W);vb(X|0)}Hv(c[j>>2]|0);X=h;W=c[e>>2]|0;Bd(f,W);vb(X|0)}else if((q|0)==77){g=qb(-1,-1)|0;if((a[l>>0]&1)==0){X=g;W=c[e>>2]|0;Bd(f,W);vb(X|0)}Hv(c[m>>2]|0);X=g;W=c[e>>2]|0;Bd(f,W);vb(X|0)}else if((q|0)==79){g=qb(-1,-1)|0;if((a[o>>0]&1)==0){X=g;W=c[e>>2]|0;Bd(f,W);vb(X|0)}Hv(c[n>>2]|0);X=g;W=c[e>>2]|0;Bd(f,W);vb(X|0)}else if((q|0)==82){i=p;return}}function ci(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0;l=i;i=i+112|0;q=l;r=l+96|0;n=l+92|0;v=l+80|0;s=l+60|0;w=l+32|0;g=l+20|0;z=l+16|0;j=l+4|0;Ah(5872,q)|0;c[s+0>>2]=c[5920>>2];c[s+4>>2]=c[5924>>2];c[s+8>>2]=c[5928>>2];c[s+12>>2]=c[5932>>2];c[s+16>>2]=c[5936>>2];e=w+20|0;m=w+24|0;A=w+20|0;B=w+16|0;D=w+16|0;C=g+1|0;E=g+10|0;o=j+1|0;p=j+6|0;x=d+4|0;y=d+8|0;f=w+16|0;k=j+8|0;h=g+8|0;t=0;while(1){c[e>>2]=0;c[m>>2]=0;c[B>>2]=A;a[g>>0]=18;G=C+0|0;H=320|0;F=G+9|0;do{a[G>>0]=a[H>>0]|0;G=G+1|0;H=H+1|0}while((G|0)<(F|0));a[E>>0]=0;F=Pf(D,n,g)|0;G=c[F>>2]|0;if((G|0)==0){u=0;Na(43,v|0,D|0,g|0);H=u;u=0;if(H&1){d=41;break}G=c[v>>2]|0;c[v>>2]=0;H=c[n>>2]|0;c[G>>2]=0;c[G+4>>2]=0;c[G+8>>2]=H;c[F>>2]=G;H=c[c[D>>2]>>2]|0;if((H|0)==0){F=G}else{c[D>>2]=H;F=c[F>>2]|0}ge(c[e>>2]|0,F);c[m>>2]=(c[m>>2]|0)+1}c[z>>2]=1;F=G+28|0;H=c[F>>2]|0;G=G+32|0;u=0;oa(c[c[H>>2]>>2]|0,H|0,G|0);H=u;u=0;if(H&1){d=41;break}if((a[2072]|0)==0?(Ua(2072)|0)!=0:0){c[516]=2088;rb(2072)}c[F>>2]=2064;if((a[2336]|0)==0?(Ua(2336)|0)!=0:0){c[582]=2352;rb(2336)}c[F>>2]=2328;u=0;Na(c[(c[582]|0)+4>>2]|0,2328,z|0,G|0);H=u;u=0;if(H&1){d=41;break}if(!((a[g>>0]&1)==0)){Hv(c[h>>2]|0)}a[j>>0]=10;a[o+0>>0]=a[2912>>0]|0;a[o+1>>0]=a[2913>>0]|0;a[o+2>>0]=a[2914>>0]|0;a[o+3>>0]=a[2915>>0]|0;a[o+4>>0]=a[2916>>0]|0;a[p>>0]=0;F=Pf(D,q,j)|0;G=c[F>>2]|0;if((G|0)==0){u=0;Na(43,r|0,D|0,j|0);H=u;u=0;if(H&1){d=43;break}G=c[r>>2]|0;c[r>>2]=0;H=c[q>>2]|0;c[G>>2]=0;c[G+4>>2]=0;c[G+8>>2]=H;c[F>>2]=G;H=c[c[D>>2]>>2]|0;if((H|0)==0){F=G}else{c[D>>2]=H;F=c[F>>2]|0}ge(c[e>>2]|0,F);c[m>>2]=(c[m>>2]|0)+1}F=s+(t<<2)|0;H=G+28|0;I=c[H>>2]|0;G=G+32|0;u=0;oa(c[c[I>>2]>>2]|0,I|0,G|0);I=u;u=0;if(I&1){d=43;break}if((a[2072]|0)==0?(Ua(2072)|0)!=0:0){c[516]=2088;rb(2072)}c[H>>2]=2064;if((a[3440]|0)==0?(Ua(3440)|0)!=0:0){c[858]=3456;rb(3440)}c[H>>2]=3432;u=0;Na(c[(c[858]|0)+4>>2]|0,3432,F|0,G|0);I=u;u=0;if(I&1){d=43;break}if(!((a[j>>0]&1)==0)){Hv(c[k>>2]|0)}u=0;oa(104,b|0,w|0);I=u;u=0;if(I&1){d=40;break}F=c[x>>2]|0;if((F|0)==(c[y>>2]|0)){u=0;oa(100,d|0,w|0);I=u;u=0;if(I&1){d=40;break}}else{if((F|0)==0){F=0}else{u=0;oa(99,F|0,w|0);I=u;u=0;if(I&1){d=40;break}F=c[x>>2]|0}c[x>>2]=F+28}Bd(f,c[e>>2]|0);t=t+1|0;if(!(t>>>0<5)){d=45;break}}if((d|0)==40){I=qb(-1,-1)|0;H=c[e>>2]|0;Bd(f,H);vb(I|0)}else if((d|0)==41){j=qb(-1,-1)|0;if((a[g>>0]&1)==0){I=j;H=c[e>>2]|0;Bd(f,H);vb(I|0)}Hv(c[h>>2]|0);I=j;H=c[e>>2]|0;Bd(f,H);vb(I|0)}else if((d|0)==43){g=qb(-1,-1)|0;if((a[j>>0]&1)==0){I=g;H=c[e>>2]|0;Bd(f,H);vb(I|0)}Hv(c[k>>2]|0);I=g;H=c[e>>2]|0;Bd(f,H);vb(I|0)}else if((d|0)==45){i=l;return}}function di(b,d){b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e;c[f>>2]=d;if((a[5584]|0)==0?(Ua(5584)|0)!=0:0){c[1394]=c[t>>2];c[5580>>2]=3;jb(195,5576,q|0)|0;rb(5584)}if((c[5580>>2]|0)<5){d=-1;i=e;return d|0}d=Ib(c[1394]|0,b|0,f|0)|0;i=e;return d|0}function ei(b,d){b=b|0;d=d|0;var e=0,f=0,j=0,l=0,m=0.0,n=0,o=0.0,p=0,q=0,r=0,s=0,t=0,v=0.0;j=i;i=i+176|0;f=j+8|0;q=j;l=j+172|0;p=j+160|0;e=j+24|0;r=d+16|0;a[p>>0]=10;s=p+1|0;a[s+0>>0]=a[2912>>0]|0;a[s+1>>0]=a[2913>>0]|0;a[s+2>>0]=a[2914>>0]|0;a[s+3>>0]=a[2915>>0]|0;a[s+4>>0]=a[2916>>0]|0;a[p+6>>0]=0;u=0;s=Ha(38,r|0,p|0)|0;t=u;u=0;if(t&1){e=qb(-1,-1)|0;if((a[p>>0]&1)==0){t=e;vb(t|0)}Hv(c[p+8>>2]|0);t=e;vb(t|0)}c[f>>2]=s;Ah(5944,f)|0;if(!((a[p>>0]&1)==0)){Hv(c[p+8>>2]|0)}p=b+132|0;a[f+0>>0]=a[q+0>>0]|0;Oi(e,p,r,f);u=0;q=Ka(1)|0;t=u;u=0;if(((!(t&1)?(u=0,na(c[(c[e>>2]|0)+40>>2]|0,e|0),t=u,u=0,!(t&1)):0)?(u=0,n=Ka(1)|0,t=u,u=0,!(t&1)):0)?(m=(+(n|0)- +(q|0))/1.0e6+0.0,u=0,o=+La(1,e|0,p|0,b+152|0,b+172|0,+(+g[b+216>>2]),l|0,b+4|0,1,0),t=u,u=0,!(t&1)):0){v=+((fa(c[p>>2]<<2,c[b+136>>2]|0)|0)>>>0);g[d+8>>2]=(v+ +((c[e+132>>2]|0)+(c[e+128>>2]|0)+(c[e+12>>2]<<2)|0))/v;g[d>>2]=o;g[d+4>>2]=m;h[k>>3]=m;c[f>>2]=c[k>>2];c[f+4>>2]=c[k+4>>2];t=f+8|0;h[k>>3]=o;c[t>>2]=c[k>>2];c[t+4>>2]=c[k+4>>2];Ah(5976,f)|0;ji(e);i=j;return}b=qb(-1,-1)|0;u=0;na(197,e|0);t=u;u=0;if(t&1){t=qb(-1,-1,0)|0;jd(t)}else{t=b;vb(t|0)}}function fi(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0;g=i;i=i+64|0;m=g+52|0;j=g+48|0;l=g+36|0;f=g+24|0;e=g+12|0;h=g;pf(j,b,d);j=c[j>>2]|0;if((j|0)!=(b+4|0)){e=j+28|0;o=c[e>>2]|0;o=(Bc[c[(c[o>>2]|0)+24>>2]&255](o)|0)+4|0;if((c[o>>2]|0)==(c[24596>>2]|0)){c[m>>2]=c[j+32>>2];o=c[e>>2]|0;o=Sc[c[(c[o>>2]|0)+16>>2]&63](o,m)|0;i=g;return c[o>>2]|0}e=Jb(8)|0;u=0;oa(75,e|0,1760);o=u;u=0;if(o&1){o=qb(-1,-1)|0;pb(e|0);vb(o|0)}else{c[e>>2]=1800;qc(e|0,1744,22)}}g=Jb(8)|0;u=0;o=qa(119,32)|0;n=u;u=0;do{if(!(n&1)){j=e+8|0;c[j>>2]=o;c[e>>2]=33;c[e+4>>2]=19;b=o+0|0;m=6288|0;n=b+19|0;do{a[b>>0]=a[m>>0]|0;b=b+1|0;m=m+1|0}while((b|0)<(n|0));a[o+19>>0]=0;u=0;Na(47,f|0,e|0,d|0);o=u;u=0;if(!(o&1)){u=0;o=qa(119,32)|0;n=u;u=0;if(!(n&1)){d=h+8|0;c[d>>2]=o;c[h>>2]=33;c[h+4>>2]=25;b=o+0|0;m=6312|0;n=b+25|0;do{a[b>>0]=a[m>>0]|0;b=b+1|0;m=m+1|0}while((b|0)<(n|0));a[o+25>>0]=0;u=0;Na(47,l|0,f|0,h|0);o=u;u=0;if(!(o&1)){u=0;oa(78,g|0,l|0);o=u;u=0;if(!(o&1)){c[g>>2]=288;u=0;Na(45,g|0,264,1);o=u;u=0;if(o&1){k=0}}else{k=1}m=qb(-1,-1)|0;if(!((a[l>>0]&1)==0)){Hv(c[l+8>>2]|0)}}else{m=qb(-1,-1)|0;k=1}if(!((a[h>>0]&1)==0)){Hv(c[d>>2]|0)}}else{m=qb(-1,-1)|0;k=1}if(!((a[f>>0]&1)==0)){Hv(c[f+8>>2]|0)}}else{m=qb(-1,-1)|0;k=1}if((a[e>>0]&1)==0){if(k){break}vb(m|0)}else{Hv(c[j>>2]|0);if(k){break}vb(m|0)}}else{m=qb(-1,-1)|0}}while(0);pb(g|0);o=m;vb(o|0);return 0}function gi(a,b,d,e,f,h,j,k,l){a=a|0;b=b|0;d=d|0;e=e|0;f=+f;h=h|0;j=j|0;k=k|0;l=l|0;var m=0,n=0,o=0,p=0,q=0,r=0,s=0.0,t=0,u=0;n=i;i=i+16|0;o=n;j=n+8|0;p=n+4|0;Ah(5224,o)|0;Ah(5288,o)|0;s=+Ni(a,b,d,e,k,1,j,p,0,l);if(s>f){Ah(5352,o)|0;t=1;c[h>>2]=t;s=+g[j>>2];i=n;return+s}if(s<f){q=1;while(1){r=q<<1;s=+Ni(a,b,d,e,k,r,j,p,0,l);if(s<f){q=r}else{break}}}else{q=1;r=1}if(!(+U(+(s-f))>.0010000000474974513)){Ah(5408,o)|0;t=r;c[h>>2]=t;s=+g[j>>2];i=n;return+s}Ah(5376,o)|0;t=(q+r|0)/2|0;s=+Ni(a,b,d,e,k,t,j,p,0,l);if(!(+U(+(s-f))>.0010000000474974513)){c[h>>2]=t;s=+g[j>>2];i=n;return+s}while(1){u=s<f;r=u?r:t;q=u?t:q;t=(q+r|0)/2|0;if((t|0)==(q|0)){break}s=+Ni(a,b,d,e,k,t,j,p,0,l);if(!(+U(+(s-f))>.0010000000474974513)){m=11;break}}if((m|0)==11){c[h>>2]=t;s=+g[j>>2];i=n;return+s}Ah(5352,o)|0;u=q;c[h>>2]=u;s=+g[j>>2];i=n;return+s}function hi(a){a=a|0;return(c[a+132>>2]|0)+(c[a+128>>2]|0)+(c[a+12>>2]<<2)|0}function ii(a){a=a|0;var b=0;b=i;ji(a);i=b;return}function ji(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,j=0;b=i;c[a>>2]=6024;d=a+104|0;e=a+100|0;g=c[e>>2]|0;a:do{if((c[d>>2]|0)!=(g|0)){f=0;while(1){g=c[g+(f<<2)>>2]|0;if((g|0)!=0){if((c[g+12>>2]|0)!=0?(u=0,h=u,u=0,h&1):0){break}if((c[g+16>>2]|0)!=0?(u=0,h=u,u=0,h&1):0){break}}f=f+1|0;g=c[e>>2]|0;if(!(f>>>0<(c[d>>2]|0)-g>>2>>>0)){break a}}f=qb(-1,-1)|0;g=a+116|0;h=c[g>>2]|0;if((h|0)!=0){do{j=h;h=c[h>>2]|0;Bv(j);c[g>>2]=h}while((h|0)!=0)}c[g>>2]=0;c[a+112>>2]=0;c[a+128>>2]=0;c[a+132>>2]=0;g=c[e>>2]|0;if((g|0)!=0){h=c[d>>2]|0;if((h|0)!=(g|0)){c[d>>2]=h+(~((h+ -4+(0-g)|0)>>>2)<<2)}Hv(g)}u=0;na(186,a|0);j=u;u=0;if(j&1){j=qb(-1,-1,0)|0;jd(j)}else{vb(f|0)}}}while(0);f=a+116|0;g=c[f>>2]|0;if((g|0)!=0){do{j=g;g=c[g>>2]|0;Bv(j);c[f>>2]=g}while((g|0)!=0)}c[f>>2]=0;c[a+112>>2]=0;c[a+128>>2]=0;c[a+132>>2]=0;e=c[e>>2]|0;if((e|0)==0){Hd(a);i=b;return}f=c[d>>2]|0;if((f|0)!=(e|0)){c[d>>2]=f+(~((f+ -4+(0-e)|0)>>>2)<<2)}Hv(e);Hd(a);i=b;return}function ki(a){a=a|0;var b=0,c=0;b=i;u=0;na(197,a|0);c=u;u=0;if(c&1){c=qb(-1,-1)|0;Hv(a);vb(c|0)}else{Hv(a);i=b;return}}function li(a){a=a|0;return 1}function mi(b,d){b=b|0;d=d|0;var e=0,f=0,g=0;f=i;i=i+16|0;g=f;yc[c[(c[b>>2]|0)+68>>2]&255](b);e=g+4|0;c[e>>2]=d;d=g+8|0;a[d>>0]=0;u=0;oa(105,b|0,g|0);b=u;u=0;if(b&1){b=qb(-1,-1)|0;if((a[d>>0]|0)==0){vb(b|0)}Rb(c[e>>2]|0)|0;vb(b|0)}else{if((a[d>>0]|0)==0){i=f;return}Rb(c[e>>2]|0)|0;i=f;return}}function ni(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0;f=i;i=i+16|0;g=f;e=g+4|0;c[e>>2]=d;d=g+8|0;a[d>>0]=0;c[g>>2]=b;u=0;oa(106,b|0,g|0);k=u;u=0;if(k&1){f=qb(-1,-1)|0;if((a[d>>0]|0)==0){vb(f|0)}Rb(c[e>>2]|0)|0;vb(f|0)}zb(b+88|0,4,1,c[g+4>>2]|0)|0;h=b+104|0;b=b+100|0;j=c[b>>2]|0;if((c[h>>2]|0)!=(j|0)){k=0;do{Ki(c[j+(k<<2)>>2]|0,g);k=k+1|0;j=c[b>>2]|0}while(k>>>0<(c[h>>2]|0)-j>>2>>>0)}if((a[d>>0]|0)==0){i=f;return}Rb(c[e>>2]|0)|0;i=f;return}function oi(a){a=a|0;var b=0,c=0;c=i;b=Fv(136)|0;u=0;oa(107,b|0,a|0);a=u;u=0;if(a&1){c=qb(-1,-1)|0;Hv(b);vb(c|0)}else{i=c;return b|0}return 0}function pi(a,b,d){a=a|0;b=b|0;d=+d;var e=0,f=0,g=0,h=0,j=0,k=0;f=i;if((c[b+4>>2]|0)!=(c[a+20>>2]|0)){Wa(1208,6232,143,1232)}e=a+12|0;h=c[e>>2]|0;He(a,b);if(d>1.0){k=c[e>>2]|0;if(+((c[a+16>>2]|0)>>>0)*d<+(k>>>0)){yc[c[(c[a>>2]|0)+40>>2]&255](a);i=f;return}}else{k=c[e>>2]|0}if(!(h>>>0<k>>>0)){i=f;return}b=a+88|0;g=a+100|0;j=c[b>>2]|0;do{if((j|0)>0){k=0;do{Hi(a,c[(c[g>>2]|0)+(k<<2)>>2]|0,h);k=k+1|0;j=c[b>>2]|0}while((k|0)<(j|0));k=c[e>>2]|0}h=h+1|0}while(h>>>0<k>>>0);i=f;return}function qi(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0,j=0.0,k=0,l=0,m=0;h=i;k=c[f>>2]|0;j=+g[f+4>>2]+1.0;f=(a[b+36>>0]|0)!=0;if(!((k|0)==-1)){if(f){zi(b,d,e,k,j);i=h;return}else{Ai(b,d,e,k,j);i=h;return}}k=b+88|0;l=c[k>>2]|0;m=(l|0)>1;if(f){if(m){zb(6160,68,1,c[r>>2]|0)|0;l=c[k>>2]|0}if((l|0)<=0){i=h;return}Gi(b,d,e,c[c[b+100>>2]>>2]|0,0.0,j);i=h;return}else{if(m){zb(6160,68,1,c[r>>2]|0)|0;l=c[k>>2]|0}if((l|0)<=0){i=h;return}Fi(b,d,e,c[c[b+100>>2]>>2]|0,0.0,j);i=h;return}}function ri(a){a=a|0;var b=0,d=0,e=0,f=0;d=i;b=a+116|0;e=c[b>>2]|0;if((e|0)!=0){do{f=e;e=c[e>>2]|0;Bv(f);c[b>>2]=e}while((e|0)!=0)}c[b>>2]=0;c[a+112>>2]=0;c[a+128>>2]=0;c[a+132>>2]=0;i=d;return}function si(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,v=0,w=0;b=i;i=i+16|0;e=b+12|0;g=b+8|0;f=b+4|0;k=b;j=a+12|0;n=c[j>>2]|0;if((n|0)!=0){if(n>>>0>1073741823){ss(0)}l=Fv(n<<2)|0;o=n;q=l;while(1){if((q|0)!=0){c[q>>2]=0}o=o+ -1|0;if((o|0)==0){break}else{q=q+4|0}}n=l+(n<<2)|0;o=c[j>>2]|0;if((o|0)!=0){q=0;do{c[l+(q<<2)>>2]=q;q=q+1|0}while(q>>>0<o>>>0)}}else{l=0;n=0}o=c[a+20>>2]|0;o=o>>>0>1073741823?-1:o<<2;u=0;q=qa(121,o|0)|0;w=u;u=0;a:do{if(!(w&1)?(h=a+92|0,c[h>>2]=q,u=0,p=qa(121,o|0)|0,w=u,u=0,!(w&1)):0){o=a+96|0;c[o>>2]=p;p=a+100|0;q=a+88|0;w=c[q>>2]|0;v=a+104|0;t=c[v>>2]|0;s=c[p>>2]|0;r=t-s>>2;if(!(r>>>0<w>>>0)){if(r>>>0>w>>>0?(m=s+(w<<2)|0,(t|0)!=(m|0)):0){c[v>>2]=t+(~((t+ -4+(0-m)|0)>>>2)<<2)}}else{u=0;oa(108,p|0,w-r|0);w=u;u=0;if(w&1){d=11;break}w=c[q>>2]|0}b:do{if((w|0)>0){r=0;while(1){c[f>>2]=l;c[k>>2]=n;u=0;c[g+0>>2]=c[f+0>>2];c[e+0>>2]=c[k+0>>2];oa(109,g|0,e|0);w=u;u=0;if(w&1){break}u=0;m=ua(30,a|0,l|0,c[j>>2]|0)|0;w=u;u=0;if(w&1){break}c[(c[p>>2]|0)+(r<<2)>>2]=m;r=r+1|0;if((r|0)>=(c[q>>2]|0)){break b}}b=qb(-1,-1)|0;break a}}while(0);d=c[h>>2]|0;if((d|0)!=0){Iv(d)}d=c[o>>2]|0;if((d|0)!=0){Iv(d)}if((l|0)==0){i=b;return}Hv(l);i=b;return}else{d=11}}while(0);if((d|0)==11){b=qb(-1,-1)|0}if((l|0)==0){vb(b|0)}Hv(l);vb(b|0)}function ti(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0;d=i;i=i+16|0;e=d;f=c[b>>2]|0;g=c[a>>2]|0;h=f-g|0;if((h|0)<=4){i=d;return}Kl(e);f=f+ -4|0;c[b>>2]=f;a:do{if(g>>>0<f>>>0){h=h>>2;b:while(1){b=h;h=h+ -1|0;if((h|0)!=0){if((b|0)==0){u=0;k=qa(122,e|0)|0;j=u;u=0;if(j&1){f=15;break}}else{j=32-(xw(b|0)|0)|0;j=(((-1>>>(33-j|0)&b|0)==0)<<31>>31)+j|0;j=(j>>>0)/((((j&31|0)!=0&1)+(j>>>5)|0)>>>0)|0;if((j|0)==0){j=0}else{j=-1>>>(32-j|0)}do{u=0;k=qa(122,e|0)|0;l=u;u=0;if(l&1){f=14;break b}k=k&j}while(!(k>>>0<b>>>0))}if((k|0)!=0){l=g+(k<<2)|0;k=c[g>>2]|0;c[g>>2]=c[l>>2];c[l>>2]=k}}g=g+4|0;c[a>>2]=g;if(!(g>>>0<f>>>0)){break a}}if((f|0)==14){a=qb(-1,-1)|0}else if((f|0)==15){a=qb(-1,-1)|0}u=0;na(198,e|0);l=u;u=0;if(l&1){l=qb(-1,-1,0)|0;jd(l)}else{vb(a|0)}}}while(0);Il(e);i=d;return}function ui(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0;k=i;i=i+16|0;e=k+8|0;f=k+4|0;h=k;l=a+112|0;n=c[l>>2]|0;do{if((n|0)<32){m=a+132|0;c[m>>2]=(c[m>>2]|0)+n;m=Av(8192)|0;if((m|0)==0){zb(3048,27,1,c[r>>2]|0)|0;m=0;break}else{n=a+116|0;c[m>>2]=c[n>>2];c[n>>2]=m;c[l>>2]=8188;m=m+4|0;c[a+120>>2]=m;n=8156;j=6;break}}else{m=c[a+120>>2]|0;n=n+ -32|0;j=6}}while(0);if((j|0)==6){c[a+120>>2]=m+32;c[l>>2]=n;n=a+128|0;c[n>>2]=(c[n>>2]|0)+32}c[m+0>>2]=0;c[m+4>>2]=0;c[m+8>>2]=0;c[m+12>>2]=0;c[m+16>>2]=0;if((d|0)==1){c[m+16>>2]=0;c[m+12>>2]=0;c[m>>2]=c[b>>2];c[m+8>>2]=c[(c[a+72>>2]|0)+(c[b>>2]<<2)>>2];i=k;return m|0}else{vi(a,b,d,e,f,h);c[m>>2]=c[f>>2];g[m+4>>2]=+g[h>>2];n=c[e>>2]|0;l=ui(a,b,n)|0;c[m+12>>2]=l;n=ui(a,b+(n<<2)|0,d-n|0)|0;c[m+16>>2]=n;i=k;return m|0}return 0}function vi(a,b,d,e,f,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0.0,B=0;k=i;i=i+32|0;m=k+8|0;n=k+4|0;j=k;l=a+92|0;p=a+20|0;ww(c[l>>2]|0,0,c[p>>2]<<2|0)|0;q=a+96|0;ww(c[q>>2]|0,0,c[p>>2]<<2|0)|0;s=(d|0)<101?d:101;r=(s|0)>0;if(r){t=c[a+72>>2]|0;p=c[p>>2]|0;x=(p|0)==0;v=(d|0)<101?d:101;y=0;do{u=c[t+(c[b+(y<<2)>>2]<<2)>>2]|0;if(!x){z=c[l>>2]|0;w=0;do{B=z+(w<<2)|0;g[B>>2]=+g[u+(w<<2)>>2]+ +g[B>>2];w=w+1|0}while(w>>>0<p>>>0)}y=y+1|0}while((y|0)!=(v|0))}else{p=c[p>>2]|0}A=1.0/+(s|0);if((p|0)==0){p=0}else{s=c[l>>2]|0;t=0;do{B=s+(t<<2)|0;g[B>>2]=A*+g[B>>2];t=t+1|0}while(t>>>0<p>>>0)}if(r){s=c[a+72>>2]|0;r=(p|0)==0;y=(d|0)<101?d:101;x=0;do{t=c[s+(c[b+(x<<2)>>2]<<2)>>2]|0;if(!r){u=c[l>>2]|0;v=c[q>>2]|0;w=0;do{A=+g[t+(w<<2)>>2]- +g[u+(w<<2)>>2];B=v+(w<<2)|0;g[B>>2]=+g[B>>2]+A*A;w=w+1|0}while(w>>>0<p>>>0)}x=x+1|0}while((x|0)!=(y|0))}r=c[q>>2]|0;if((p|0)==0){s=0}else{q=0;s=0;do{if((s|0)>=5){t=m+(s+ -1<<2)|0;if(+g[r+(q<<2)>>2]>+g[r+(c[t>>2]<<2)>>2]){c[t>>2]=q;o=22}}else{c[m+(s<<2)>>2]=q;s=s+1|0;o=22}a:do{if((o|0)==22){o=0;t=s+ -1|0;if((t|0)>0){w=s;while(1){v=m+(t<<2)|0;u=c[v>>2]|0;x=m+(w+ -2<<2)|0;w=c[x>>2]|0;if(!(+g[r+(u<<2)>>2]>+g[r+(w<<2)>>2])){break a}c[v>>2]=w;c[x>>2]=u;u=t+ -1|0;if((u|0)>0){w=t;t=u}else{break}}}}}while(0);q=q+1|0}while((q|0)!=(p|0))}B=m+(~~(+(s|0)*+(ow()|0)*4.656612873077393e-10)<<2)|0;B=c[B>>2]|0;c[f>>2]=B;A=+g[(c[l>>2]|0)+(B<<2)>>2];g[h>>2]=A;wi(a,b,d,B,A,n,j);l=c[n>>2]|0;f=(d|0)/2|0;do{if((l|0)<=(f|0)){m=c[j>>2]|0;if((m|0)<(f|0)){c[e>>2]=m;break}else{c[e>>2]=f;break}}else{c[e>>2]=l}}while(0);if((l|0)!=(d|0)?(c[j>>2]|0)!=0:0){i=k;return}c[e>>2]=f;i=k;return}function wi(a,b,d,e,f,h,j){a=a|0;b=b|0;d=d|0;e=e|0;f=+f;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0;k=i;d=d+ -1|0;a=a+72|0;m=0;l=d;a:while(1){b:do{if((m|0)<=(l|0)){n=c[a>>2]|0;while(1){o=m+1|0;if(!(+g[(c[n+(c[b+(m<<2)>>2]<<2)>>2]|0)+(e<<2)>>2]<f)){break b}if((m|0)<(l|0)){m=o}else{m=o;break}}}}while(0);if((m|0)>(l|0)){break}n=c[a>>2]|0;while(1){o=b+(l<<2)|0;p=c[o>>2]|0;l=l+ -1|0;if(!(+g[(c[n+(p<<2)>>2]|0)+(e<<2)>>2]>=f)){break}if((m|0)>(l|0)){break a}}q=b+(m<<2)|0;n=c[q>>2]|0;c[q>>2]=p;c[o>>2]=n;m=m+1|0}c[h>>2]=m;c:while(1){d:do{if((m|0)<=(d|0)){h=c[a>>2]|0;while(1){l=m+1|0;if(!(+g[(c[h+(c[b+(m<<2)>>2]<<2)>>2]|0)+(e<<2)>>2]<=f)){break d}if((m|0)<(d|0)){m=l}else{m=l;break}}}}while(0);if((m|0)>(d|0)){b=21;break}h=c[a>>2]|0;while(1){n=b+(d<<2)|0;l=c[n>>2]|0;d=d+ -1|0;if(!(+g[(c[h+(l<<2)>>2]|0)+(e<<2)>>2]>f)){break}if((m|0)>(d|0)){b=21;break c}}p=b+(m<<2)|0;q=c[p>>2]|0;c[p>>2]=l;c[n>>2]=q;m=m+1|0}if((b|0)==21){c[j>>2]=m;i=k;return}}function xi(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0;e=i;f=a+8|0;d=a+4|0;k=c[d>>2]|0;j=c[f>>2]|0;g=k;if(!(j-g>>2>>>0<b>>>0)){do{if((k|0)==0){f=0}else{c[k>>2]=0;f=c[d>>2]|0}k=f+4|0;c[d>>2]=k;b=b+ -1|0}while((b|0)!=0);i=e;return}l=c[a>>2]|0;g=g-l>>2;k=g+b|0;if(k>>>0>1073741823){ss(0)}j=j-l|0;if(j>>2>>>0<536870911){l=j>>1;k=l>>>0<k>>>0?k:l;if((k|0)==0){j=0;k=0}else{h=9}}else{k=1073741823;h=9}if((h|0)==9){j=k;k=Fv(k<<2)|0}h=k+(g<<2)|0;do{if((h|0)==0){h=0}else{c[h>>2]=0}h=h+4|0;b=b+ -1|0}while((b|0)!=0);b=c[a>>2]|0;m=(c[d>>2]|0)-b|0;l=k+(g-(m>>2)<<2)|0;tw(l|0,b|0,m|0)|0;c[a>>2]=l;c[d>>2]=h;c[f>>2]=k+(j<<2);if((b|0)==0){i=e;return}Hv(b);i=e;return}function yi(a){a=a|0;return}function zi(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=+f;var h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;j=i;i=i+32|0;p=j+24|0;o=j+16|0;k=j;c[o>>2]=0;l=Fv(20)|0;q=c[a+12>>2]|0;c[l>>2]=0;m=l+4|0;c[m>>2]=0;r=l+8|0;c[r>>2]=0;c[l+12>>2]=q;do{if((q|0)!=0){u=0;h=qa(119,q<<3|0)|0;s=u;u=0;if(!(s&1)){c[l>>2]=h;c[m>>2]=h;c[r>>2]=h+(q<<3);break}s=qb(-1,-1)|0;Hv(l);vb(s|0)}}while(0);c[l+16>>2]=0;c[k>>2]=0;h=k+4|0;c[h>>2]=0;c[k+8>>2]=0;c[k+12>>2]=q;u=0;oa(94,k|0,(q>>>5)+1|0);s=u;u=0;if(s&1){j=qb(-1,-1)|0;l=c[k>>2]|0;if((l|0)==0){vb(j|0)}k=c[h>>2]|0;if((k|0)!=(l|0)){c[h>>2]=k+(~((k+ -4+(0-l)|0)>>>2)<<2)}Hv(l);vb(j|0)}q=c[k>>2]|0;r=(c[h>>2]|0)-q|0;if((r|0)>0){s=r>>2;r=0-s|0;ww(q|0,0,(((r|0)>-1?r:1073741823)+s<<2)+4|0)|0}q=a+88|0;a:do{if((c[q>>2]|0)>0){s=a+100|0;r=0;while(1){u=0;ra(1,a|0,b|0,d|0,c[(c[s>>2]|0)+(r<<2)>>2]|0,0.0,o|0,e|0,+f,l|0,k|0);t=u;u=0;if(t&1){break}r=r+1|0;if((r|0)>=(c[q>>2]|0)){n=14;break a}}j=qb(-1,-1)|0}else{n=14}}while(0);do{if((n|0)==14){r=p+4|0;while(1){if(!(Ci(l,p)|0)){break}if((c[o>>2]|0)>=(e|0)){u=0;q=qa(c[(c[b>>2]|0)+8>>2]|0,b|0)|0;t=u;u=0;if(t&1){n=34;break}if(q){break}}u=0;ra(1,a|0,b|0,d|0,c[p>>2]|0,+(+g[r>>2]),o|0,e|0,+f,l|0,k|0);t=u;u=0;if(t&1){n=34;break}}if((n|0)==34){j=qb(-1,-1)|0;break}if((l|0)!=0){n=c[l>>2]|0;if((n|0)!=0){b=c[m>>2]|0;if((b|0)!=(n|0)){c[m>>2]=b+(~((b+ -8+(0-n)|0)>>>3)<<3)}Hv(n)}Hv(l)}k=c[k>>2]|0;if((k|0)==0){i=j;return}l=c[h>>2]|0;if((l|0)!=(k|0)){c[h>>2]=l+(~((l+ -4+(0-k)|0)>>>2)<<2)}Hv(k);i=j;return}}while(0);k=c[k>>2]|0;if((k|0)==0){t=j;vb(t|0)}l=c[h>>2]|0;if((l|0)!=(k|0)){c[h>>2]=l+(~((l+ -4+(0-k)|0)>>>2)<<2)}Hv(k);t=j;vb(t|0)}function Ai(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=+f;var h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;j=i;i=i+32|0;p=j+24|0;o=j+16|0;k=j;c[o>>2]=0;l=Fv(20)|0;q=c[a+12>>2]|0;c[l>>2]=0;m=l+4|0;c[m>>2]=0;r=l+8|0;c[r>>2]=0;c[l+12>>2]=q;do{if((q|0)!=0){u=0;h=qa(119,q<<3|0)|0;s=u;u=0;if(!(s&1)){c[l>>2]=h;c[m>>2]=h;c[r>>2]=h+(q<<3);break}s=qb(-1,-1)|0;Hv(l);vb(s|0)}}while(0);c[l+16>>2]=0;c[k>>2]=0;h=k+4|0;c[h>>2]=0;c[k+8>>2]=0;c[k+12>>2]=q;u=0;oa(94,k|0,(q>>>5)+1|0);s=u;u=0;if(s&1){j=qb(-1,-1)|0;l=c[k>>2]|0;if((l|0)==0){vb(j|0)}k=c[h>>2]|0;if((k|0)!=(l|0)){c[h>>2]=k+(~((k+ -4+(0-l)|0)>>>2)<<2)}Hv(l);vb(j|0)}q=c[k>>2]|0;r=(c[h>>2]|0)-q|0;if((r|0)>0){s=r>>2;r=0-s|0;ww(q|0,0,(((r|0)>-1?r:1073741823)+s<<2)+4|0)|0}q=a+88|0;a:do{if((c[q>>2]|0)>0){s=a+100|0;r=0;while(1){u=0;ra(2,a|0,b|0,d|0,c[(c[s>>2]|0)+(r<<2)>>2]|0,0.0,o|0,e|0,+f,l|0,k|0);t=u;u=0;if(t&1){break}r=r+1|0;if((r|0)>=(c[q>>2]|0)){n=14;break a}}j=qb(-1,-1)|0}else{n=14}}while(0);do{if((n|0)==14){r=p+4|0;while(1){if(!(Ci(l,p)|0)){break}if((c[o>>2]|0)>=(e|0)){u=0;q=qa(c[(c[b>>2]|0)+8>>2]|0,b|0)|0;t=u;u=0;if(t&1){n=34;break}if(q){break}}u=0;ra(2,a|0,b|0,d|0,c[p>>2]|0,+(+g[r>>2]),o|0,e|0,+f,l|0,k|0);t=u;u=0;if(t&1){n=34;break}}if((n|0)==34){j=qb(-1,-1)|0;break}if((l|0)!=0){n=c[l>>2]|0;if((n|0)!=0){b=c[m>>2]|0;if((b|0)!=(n|0)){c[m>>2]=b+(~((b+ -8+(0-n)|0)>>>3)<<3)}Hv(n)}Hv(l)}k=c[k>>2]|0;if((k|0)==0){i=j;return}l=c[h>>2]|0;if((l|0)!=(k|0)){c[h>>2]=l+(~((l+ -4+(0-k)|0)>>>2)<<2)}Hv(k);i=j;return}}while(0);k=c[k>>2]|0;if((k|0)==0){t=j;vb(t|0)}l=c[h>>2]|0;if((l|0)!=(k|0)){c[h>>2]=l+(~((l+ -4+(0-k)|0)>>>2)<<2)}Hv(k);t=j;vb(t|0)}function Bi(a,b,d,e,f,h,j,k,l,m){a=a|0;b=b|0;d=d|0;e=e|0;f=+f;h=h|0;j=j|0;k=+k;l=l|0;m=m|0;var n=0,o=0,p=0,q=0,r=0.0,s=0,t=0.0,u=0.0;n=i;i=i+16|0;o=n;if(+Kc[c[(c[b>>2]|0)+16>>2]&7](b)<f){i=n;return}q=e+12|0;p=e+16|0;if((c[q>>2]|0)==0?(c[p>>2]|0)==0:0){l=c[e>>2]|0;o=l>>>5;s=c[m>>2]|0;q=c[s+(o<<2)>>2]|0;p=1<<(l&31);if((q&p|0)!=0){i=n;return}do{if((c[h>>2]|0)>=(j|0)){if(Bc[c[(c[b>>2]|0)+8>>2]&255](b)|0){i=n;return}else{q=c[m>>2]|0;s=q;q=c[q+(o<<2)>>2]|0;break}}}while(0);c[s+(o<<2)>>2]=q|p;c[h>>2]=(c[h>>2]|0)+1;j=c[e+8>>2]|0;s=c[a+20>>2]|0;a=j+(s<<2)|0;s=s+ -3|0;h=j+(s<<2)|0;if((s|0)>0){k=0.0;do{u=+g[j>>2]- +g[d>>2];t=+g[j+4>>2]- +g[d+4>>2];f=+g[j+8>>2]- +g[d+8>>2];r=+g[j+12>>2]- +g[d+12>>2];k=k+(u*u+t*t+f*f+r*r);j=j+16|0;d=d+16|0}while(j>>>0<h>>>0);h=j}else{h=j;k=0.0}if(h>>>0<a>>>0){while(1){u=+g[h>>2]- +g[d>>2];h=h+4|0;k=k+u*u;if(!(h>>>0<a>>>0)){break}else{d=d+4|0}}}Ec[c[(c[b>>2]|0)+12>>2]&7](b,k,l);i=n;return}r=+g[d+(c[e>>2]<<2)>>2]- +g[e+4>>2];s=r<0.0;e=c[(s?q:p)>>2]|0;p=c[(s?p:q)>>2]|0;r=r*r+f;if(!(!(r*k<+Kc[c[(c[b>>2]|0)+16>>2]&7](b))?Bc[c[(c[b>>2]|0)+8>>2]&255](b)|0:0)){c[o>>2]=p;g[o+4>>2]=r;Di(l,o)}Bi(a,b,d,e,f,h,j,k,l,m);i=n;return}function Ci(a,b){a=a|0;b=b|0;var d=0.0,e=0,f=0,h=0,j=0.0,l=0,m=0,n=0,o=0.0,p=0,q=0,r=0,s=0;h=i;e=a+16|0;if((c[e>>2]|0)==0){q=0;i=h;return q|0}l=c[a>>2]|0;m=c[l+4>>2]|0;c[b>>2]=c[l>>2];c[b+4>>2]=m;b=c[a>>2]|0;a=a+4|0;m=c[a>>2]|0;l=m-b|0;if((l|0)>8?(f=m+ -8|0,q=b,p=c[q>>2]|0,q=c[q+4>>2]|0,r=f,m=c[r+4>>2]|0,n=b,c[n>>2]=c[r>>2],c[n+4>>2]=m,f,c[f>>2]=p,c[f+4>>2]=q,f=(l>>3)+ -1|0,(f|0)>1):0){if((f|0)!=2?!(+g[b+12>>2]<+g[b+20>>2]):0){n=b+16|0;p=2}else{n=b+8|0;p=1}if(+g[n+4>>2]<+g[b+4>>2]){l=b;m=c[l>>2]|0;l=c[l+4>>2]|0;j=(c[k>>2]=l,+g[k>>2]);q=b;while(1){s=n;r=c[s+4>>2]|0;c[q>>2]=c[s>>2];c[q+4>>2]=r;q=p<<1;p=q+2|0;if((p|0)>(f|0)){break}q=q|1;o=+g[b+(q<<3)+4>>2];if((p|0)!=(f|0)?(d=+g[b+(p<<3)+4>>2],!(o<d)):0){o=d}else{p=q}if(o<j){q=n;n=b+(p<<3)|0}else{break}}s=n;c[s>>2]=m;c[s+4>>2]=l}}s=c[a>>2]|0;c[a>>2]=s+(~((s+ -8+(0-(s+ -8))|0)>>>3)<<3);c[e>>2]=(c[e>>2]|0)+ -1;s=1;i=h;return s|0}function Di(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,h=0,j=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0.0,u=0;d=i;e=a+16|0;if((c[e>>2]|0)==(c[a+12>>2]|0)){i=d;return}j=a+4|0;n=c[j>>2]|0;m=a+8|0;if((n|0)==(c[m>>2]|0)){l=c[a>>2]|0;n=n-l|0;s=n>>3;q=s+1|0;if(q>>>0>536870911){ss(0)}if(s>>>0<268435455){r=n>>2;r=r>>>0<q>>>0?q:r;if((r|0)==0){p=0;r=0}else{o=10}}else{r=536870911;o=10}if((o|0)==10){p=r;r=Fv(r<<3)|0}o=r+(s<<3)|0;if((o|0)!=0){u=b;b=c[u+4>>2]|0;s=o;c[s>>2]=c[u>>2];c[s+4>>2]=b}b=r+(q<<3)|0;tw(r|0,l|0,n|0)|0;c[a>>2]=r;c[j>>2]=b;c[m>>2]=r+(p<<3);if((l|0)!=0){Hv(l);b=c[j>>2]|0}}else{if((n|0)==0){l=0}else{s=b;u=c[s+4>>2]|0;l=n;c[l>>2]=c[s>>2];c[l+4>>2]=u;l=c[j>>2]|0}b=l+8|0;c[j>>2]=b}j=c[a>>2]|0;a=b-j|0;if((a|0)>8?(h=((a>>3)+ -2|0)/2|0,f=b+ -8|0,+g[b+ -4>>2]<+g[j+(h<<3)+4>>2]):0){l=f;a=c[l>>2]|0;l=c[l+4>>2]|0;t=(c[k>>2]=l,+g[k>>2]);do{u=f;f=j+(h<<3)|0;r=f;s=c[r+4>>2]|0;c[u>>2]=c[r>>2];c[u+4>>2]=s;if((h|0)==0){break}h=(h+ -1|0)/2|0}while(t<+g[j+(h<<3)+4>>2]);u=f;c[u>>2]=a;c[u+4>>2]=l}c[e>>2]=(c[e>>2]|0)+1;i=d;return}function Ei(a,b,d,e,f,h,j,k,l,m){a=a|0;b=b|0;d=d|0;e=e|0;f=+f;h=h|0;j=j|0;k=+k;l=l|0;m=m|0;var n=0,o=0,p=0,q=0,r=0.0,s=0,t=0.0,u=0.0;n=i;i=i+16|0;o=n;if(+Kc[c[(c[b>>2]|0)+16>>2]&7](b)<f){i=n;return}q=e+12|0;p=e+16|0;if((c[q>>2]|0)==0?(c[p>>2]|0)==0:0){l=c[e>>2]|0;o=l>>>5;p=1<<(l&31);if((c[(c[a+40>>2]|0)+(o<<2)>>2]&p|0)!=0){i=n;return}s=c[m>>2]|0;q=c[s+(o<<2)>>2]|0;if((q&p|0)!=0){i=n;return}do{if((c[h>>2]|0)>=(j|0)){if(Bc[c[(c[b>>2]|0)+8>>2]&255](b)|0){i=n;return}else{q=c[m>>2]|0;s=q;q=c[q+(o<<2)>>2]|0;break}}}while(0);c[s+(o<<2)>>2]=q|p;c[h>>2]=(c[h>>2]|0)+1;m=c[e+8>>2]|0;s=c[a+20>>2]|0;a=m+(s<<2)|0;s=s+ -3|0;h=m+(s<<2)|0;if((s|0)>0){k=0.0;do{u=+g[m>>2]- +g[d>>2];t=+g[m+4>>2]- +g[d+4>>2];f=+g[m+8>>2]- +g[d+8>>2];r=+g[m+12>>2]- +g[d+12>>2];k=k+(u*u+t*t+f*f+r*r);m=m+16|0;d=d+16|0}while(m>>>0<h>>>0)}else{k=0.0}if(m>>>0<a>>>0){while(1){u=+g[m>>2]- +g[d>>2];m=m+4|0;k=k+u*u;if(!(m>>>0<a>>>0)){break}else{d=d+4|0}}}Ec[c[(c[b>>2]|0)+12>>2]&7](b,k,l);i=n;return}r=+g[d+(c[e>>2]<<2)>>2]- +g[e+4>>2];s=r<0.0;e=c[(s?q:p)>>2]|0;p=c[(s?p:q)>>2]|0;r=r*r+f;if(!(!(r*k<+Kc[c[(c[b>>2]|0)+16>>2]&7](b))?Bc[c[(c[b>>2]|0)+8>>2]&255](b)|0:0)){c[o>>2]=p;g[o+4>>2]=r;Di(l,o)}Ei(a,b,d,e,f,h,j,k,l,m);i=n;return}function Fi(a,b,d,e,f,h){a=a|0;b=b|0;d=d|0;e=e|0;f=+f;h=+h;var j=0,k=0,l=0,m=0,n=0.0,o=0,p=0.0,q=0.0;j=i;while(1){l=e+12|0;m=e+16|0;if((c[l>>2]|0)==0?(c[m>>2]|0)==0:0){break}n=+g[d+(c[e>>2]<<2)>>2]- +g[e+4>>2];o=n<0.0;e=c[(o?m:l)>>2]|0;Fi(a,b,d,c[(o?l:m)>>2]|0,f,h);if(!(f*h<=+Kc[c[(c[b>>2]|0)+16>>2]&7](b))){k=11;break}f=f+n*n}if((k|0)==11){i=j;return}k=c[e>>2]|0;m=c[e+8>>2]|0;o=c[a+20>>2]|0;a=m+(o<<2)|0;o=o+ -3|0;l=m+(o<<2)|0;if((o|0)>0){h=0.0;do{q=+g[m>>2]- +g[d>>2];p=+g[m+4>>2]- +g[d+4>>2];f=+g[m+8>>2]- +g[d+8>>2];n=+g[m+12>>2]- +g[d+12>>2];h=h+(q*q+p*p+f*f+n*n);m=m+16|0;d=d+16|0}while(m>>>0<l>>>0)}else{h=0.0}if(m>>>0<a>>>0){while(1){q=+g[m>>2]- +g[d>>2];m=m+4|0;h=h+q*q;if(!(m>>>0<a>>>0)){break}else{d=d+4|0}}}Ec[c[(c[b>>2]|0)+12>>2]&7](b,h,k);i=j;return}function Gi(a,b,d,e,f,h){a=a|0;b=b|0;d=d|0;e=e|0;f=+f;h=+h;var j=0,k=0,l=0,m=0,n=0.0,o=0,p=0.0,q=0.0;j=i;while(1){l=e+12|0;m=e+16|0;if((c[l>>2]|0)==0?(c[m>>2]|0)==0:0){break}n=+g[d+(c[e>>2]<<2)>>2]- +g[e+4>>2];o=n<0.0;e=c[(o?m:l)>>2]|0;Gi(a,b,d,c[(o?l:m)>>2]|0,f,h);if(!(f*h<=+Kc[c[(c[b>>2]|0)+16>>2]&7](b))){k=12;break}f=f+n*n}if((k|0)==12){i=j;return}k=c[e>>2]|0;if((c[(c[a+40>>2]|0)+(k>>>5<<2)>>2]&1<<(k&31)|0)!=0){i=j;return}m=c[e+8>>2]|0;o=c[a+20>>2]|0;a=m+(o<<2)|0;o=o+ -3|0;l=m+(o<<2)|0;if((o|0)>0){h=0.0;do{q=+g[m>>2]- +g[d>>2];p=+g[m+4>>2]- +g[d+4>>2];f=+g[m+8>>2]- +g[d+8>>2];n=+g[m+12>>2]- +g[d+12>>2];h=h+(q*q+p*p+f*f+n*n);m=m+16|0;d=d+16|0}while(m>>>0<l>>>0)}else{h=0.0}if(m>>>0<a>>>0){while(1){q=+g[m>>2]- +g[d>>2];m=m+4|0;h=h+q*q;if(!(m>>>0<a>>>0)){break}else{d=d+4|0}}}Ec[c[(c[b>>2]|0)+12>>2]&7](b,h,k);i=j;return}function Hi(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0.0,s=0,t=0.0,u=0;f=i;h=c[(c[a+72>>2]|0)+(d<<2)>>2]|0;while(1){j=b+12|0;if((c[j>>2]|0)==0?(e=b+16|0,(c[e>>2]|0)==0):0){break}b=c[(+g[h+(c[b>>2]<<2)>>2]<+g[b+4>>2]?j:b+16|0)>>2]|0}k=b+8|0;m=c[k>>2]|0;o=c[a+20>>2]|0;if((o|0)==0){n=0}else{n=0;p=0;q=0.0;while(1){s=~~(+g[h+(p<<2)>>2]- +g[m+(p<<2)>>2]);t=+(((s|0)>-1?s:0-s|0)|0);s=t>q;n=s?p:n;p=p+1|0;if(!(p>>>0<o>>>0)){break}else{q=s?t:q}}}o=a+112|0;s=c[o>>2]|0;do{if((s|0)<32){p=a+132|0;c[p>>2]=(c[p>>2]|0)+s;p=Av(8192)|0;if((p|0)==0){zb(3048,27,1,c[r>>2]|0)|0;p=0;break}else{s=a+116|0;c[p>>2]=c[s>>2];c[s>>2]=p;c[o>>2]=8188;p=p+4|0;c[a+120>>2]=p;s=8156;l=11;break}}else{p=c[a+120>>2]|0;s=s+ -32|0;l=11}}while(0);if((l|0)==11){c[a+120>>2]=p+32;c[o>>2]=s;u=a+128|0;c[u>>2]=(c[u>>2]|0)+32}c[p+0>>2]=0;c[p+4>>2]=0;c[p+8>>2]=0;c[p+12>>2]=0;c[p+16>>2]=0;u=c[o>>2]|0;do{if((u|0)<32){s=a+132|0;c[s>>2]=(c[s>>2]|0)+u;s=Av(8192)|0;if((s|0)==0){zb(3048,27,1,c[r>>2]|0)|0;s=0;break}else{u=a+116|0;c[s>>2]=c[u>>2];c[u>>2]=s;c[o>>2]=8188;s=s+4|0;c[a+120>>2]=s;u=8156;l=17;break}}else{s=c[a+120>>2]|0;u=u+ -32|0;l=17}}while(0);if((l|0)==17){c[a+120>>2]=s+32;c[o>>2]=u;u=a+128|0;c[u>>2]=(c[u>>2]|0)+32}u=h+(n<<2)|0;c[s+0>>2]=0;c[s+4>>2]=0;c[s+8>>2]=0;c[s+12>>2]=0;c[s+16>>2]=0;q=+g[u>>2];t=+g[m+(n<<2)>>2];if(q<t){c[p>>2]=d;c[p+8>>2]=h;c[s>>2]=c[b>>2];c[s+8>>2]=c[k>>2];c[b>>2]=n;t=q+t;t=t*.5;u=b+4|0;g[u>>2]=t;c[j>>2]=p;c[e>>2]=s;i=f;return}else{c[p>>2]=c[b>>2];c[p+8>>2]=c[k>>2];c[s>>2]=d;c[s+8>>2]=h;c[b>>2]=n;t=q+t;t=t*.5;u=b+4|0;g[u>>2]=t;c[j>>2]=p;c[e>>2]=s;i=f;return}}function Ii(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0;l=i;Le(a,b);c[a>>2]=6024;c[a+88>>2]=c[b+88>>2];e=a+100|0;c[e>>2]=0;d=a+104|0;c[d>>2]=0;c[a+108>>2]=0;c[a+124>>2]=8192;h=a+112|0;c[h>>2]=0;g=a+116|0;c[g>>2]=0;j=a+128|0;c[j>>2]=0;k=a+132|0;c[k>>2]=0;f=b+100|0;b=(c[b+104>>2]|0)-(c[f>>2]|0)>>2;if((b|0)==0){i=l;return}u=0;oa(108,e|0,b|0);b=u;u=0;if(!(b&1)){g=c[e>>2]|0;if((c[d>>2]|0)==(g|0)){i=l;return}else{h=0}do{Ji(a,g+(h<<2)|0,(c[f>>2]|0)+(h<<2)|0);h=h+1|0;g=c[e>>2]|0}while(h>>>0<(c[d>>2]|0)-g>>2>>>0);i=l;return}f=qb(-1,-1)|0;l=c[g>>2]|0;if((l|0)!=0){do{b=l;l=c[l>>2]|0;Bv(b);c[g>>2]=l}while((l|0)!=0)}c[g>>2]=0;c[h>>2]=0;c[j>>2]=0;c[k>>2]=0;e=c[e>>2]|0;if((e|0)!=0){g=c[d>>2]|0;if((g|0)!=(e|0)){c[d>>2]=g+(~((g+ -4+(0-e)|0)>>>2)<<2)}Hv(e)}u=0;na(186,a|0);b=u;u=0;if(b&1){b=qb(-1,-1,0)|0;jd(b)}else{vb(f|0)}}function Ji(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,s=0;f=i;k=a+112|0;m=a+132|0;h=c[r>>2]|0;j=a+116|0;l=a+120|0;n=a+128|0;while(1){p=c[k>>2]|0;do{if((p|0)<32){c[m>>2]=(c[m>>2]|0)+p;o=Av(8192)|0;if((o|0)==0){zb(3048,27,1,h|0)|0;o=0;break}else{c[o>>2]=c[j>>2];c[j>>2]=o;c[k>>2]=8188;o=o+4|0;c[l>>2]=o;p=8156;e=7;break}}else{o=c[l>>2]|0;p=p+ -32|0;e=7}}while(0);if((e|0)==7){e=0;c[l>>2]=o+32;c[k>>2]=p;c[n>>2]=(c[n>>2]|0)+32}c[o+0>>2]=0;c[o+4>>2]=0;c[o+8>>2]=0;c[o+12>>2]=0;c[o+16>>2]=0;c[b>>2]=o;s=c[d>>2]|0;p=c[s>>2]|0;c[o>>2]=p;g[o+4>>2]=+g[s+4>>2];q=s+12|0;if((c[q>>2]|0)==0?(c[s+16>>2]|0)==0:0){break}Ji(a,o+12|0,q);b=(c[b>>2]|0)+16|0;d=(c[d>>2]|0)+16|0}c[o+8>>2]=c[(c[a+72>>2]|0)+(p<<2)>>2];c[(c[b>>2]|0)+12>>2]=0;c[(c[b>>2]|0)+16>>2]=0;i=f;return}function Ki(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;d=i;e=b+4|0;while(1){zb(a|0,4,1,c[e>>2]|0)|0;zb(a+4|0,4,1,c[e>>2]|0)|0;f=a+12|0;if((c[f>>2]|0)==0){g=(c[a+16>>2]|0)==0&1}else{g=0}pc(g&255|0,c[e>>2]|0)|0;if(!(g<<24>>24==0)){break}Ki(c[f>>2]|0,b);a=c[a+16>>2]|0}i=d;return}function Li(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0;h=i;i=i+64|0;l=h+56|0;k=h+44|0;w=h+40|0;v=h+28|0;n=h+16|0;o=h+12|0;e=h;c[d>>2]=b;Vf(b,d);j=b+88|0;if((Sa(j|0,4,1,c[d+4>>2]|0)|0)!=1){e=Jb(8)|0;u=0;oa(75,e|0,2592);I=u;u=0;if(I&1){I=qb(-1,-1)|0;pb(e|0);vb(I|0)}else{c[e>>2]=288;qc(e|0,264,1)}}y=b+100|0;D=c[j>>2]|0;z=b+104|0;E=c[z>>2]|0;A=c[y>>2]|0;C=E-A>>2;if(!(C>>>0<D>>>0)){if(C>>>0>D>>>0?(B=A+(D<<2)|0,(E|0)!=(B|0)):0){E=E+(~((E+ -4+(0-B)|0)>>>2)<<2)|0;c[z>>2]=E}}else{xi(y,D-C|0);E=c[z>>2]|0;A=c[y>>2]|0}if((E|0)!=(A|0)){A=b+112|0;F=b+132|0;D=c[r>>2]|0;E=b+116|0;G=b+120|0;C=b+128|0;B=0;do{I=c[A>>2]|0;do{if((I|0)<32){c[F>>2]=(c[F>>2]|0)+I;H=Av(8192)|0;if((H|0)==0){zb(3048,27,1,D|0)|0;H=0;break}else{c[H>>2]=c[E>>2];c[E>>2]=H;c[A>>2]=8188;H=H+4|0;c[G>>2]=H;I=8156;t=17;break}}else{H=c[G>>2]|0;I=I+ -32|0;t=17}}while(0);if((t|0)==17){t=0;c[G>>2]=H+32;c[A>>2]=I;c[C>>2]=(c[C>>2]|0)+32}c[H+0>>2]=0;c[H+4>>2]=0;c[H+8>>2]=0;c[H+12>>2]=0;c[H+16>>2]=0;c[(c[y>>2]|0)+(B<<2)>>2]=H;Mi(c[(c[y>>2]|0)+(B<<2)>>2]|0,d);B=B+1|0}while(B>>>0<(c[z>>2]|0)-(c[y>>2]|0)>>2>>>0)}d=b+24|0;a[n>>0]=18;y=n+1|0;A=320|0;z=y+9|0;do{a[y>>0]=a[A>>0]|0;y=y+1|0;A=A+1|0}while((y|0)<(z|0));a[n+10>>0]=0;y=Pf(d,w,n)|0;z=c[y>>2]|0;if((z|0)==0){u=0;Na(43,v|0,d|0,n|0);I=u;u=0;if(!(I&1)){x=c[v>>2]|0;c[v>>2]=0;t=c[w>>2]|0;c[x>>2]=0;c[x+4>>2]=0;c[x+8>>2]=t;c[y>>2]=x;t=c[c[d>>2]>>2]|0;if((t|0)==0){t=x}else{c[d>>2]=t;t=c[y>>2]|0}ge(c[b+28>>2]|0,t);t=b+32|0;c[t>>2]=(c[t>>2]|0)+1;t=24}}else{x=z;t=24}if(((t|0)==24?(u=0,s=qa(c[(c[b>>2]|0)+16>>2]|0,b|0)|0,I=u,u=0,!(I&1)):0)?(c[o>>2]=s,p=x+28|0,I=c[p>>2]|0,q=x+32|0,u=0,oa(c[c[I>>2]>>2]|0,I|0,q|0),I=u,u=0,!(I&1)):0){if((a[2072]|0)==0?(Ua(2072)|0)!=0:0){c[516]=2088;rb(2072)}c[p>>2]=2064;if((a[2336]|0)==0?(Ua(2336)|0)!=0:0){c[582]=2352;rb(2336)}c[p>>2]=2328;u=0;Na(c[(c[582]|0)+4>>2]|0,2328,o|0,q|0);I=u;u=0;if(!(I&1)){if(!((a[n>>0]&1)==0)){Hv(c[n+8>>2]|0)}a[e>>0]=10;n=e+1|0;a[n+0>>0]=a[2912>>0]|0;a[n+1>>0]=a[2913>>0]|0;a[n+2>>0]=a[2914>>0]|0;a[n+3>>0]=a[2915>>0]|0;a[n+4>>0]=a[2916>>0]|0;a[e+6>>0]=0;n=Pf(d,l,e)|0;o=c[n>>2]|0;if((o|0)==0){u=0;Na(43,k|0,d|0,e|0);I=u;u=0;if(!(I&1)){m=c[k>>2]|0;c[k>>2]=0;k=c[l>>2]|0;c[m>>2]=0;c[m+4>>2]=0;c[m+8>>2]=k;c[n>>2]=m;k=c[c[d>>2]>>2]|0;if((k|0)==0){k=m}else{c[d>>2]=k;k=c[n>>2]|0}ge(c[b+28>>2]|0,k);t=b+32|0;c[t>>2]=(c[t>>2]|0)+1;t=40}}else{m=o;t=40}if((t|0)==40?(f=m+28|0,I=c[f>>2]|0,g=m+32|0,u=0,oa(c[c[I>>2]>>2]|0,I|0,g|0),I=u,u=0,!(I&1)):0){if((a[2072]|0)==0?(Ua(2072)|0)!=0:0){c[516]=2088;rb(2072)}c[f>>2]=2064;if((a[3440]|0)==0?(Ua(3440)|0)!=0:0){c[858]=3456;rb(3440)}c[f>>2]=3432;u=0;Na(c[(c[858]|0)+4>>2]|0,3432,j|0,g|0);I=u;u=0;if(!(I&1)){if((a[e>>0]&1)==0){i=h;return}Hv(c[e+8>>2]|0);i=h;return}}b=qb(-1,-1)|0;if((a[e>>0]&1)==0){I=b;vb(I|0)}Hv(c[e+8>>2]|0);I=b;vb(I|0)}}e=qb(-1,-1)|0;if((a[n>>0]&1)==0){I=e;vb(I|0)}Hv(c[n+8>>2]|0);I=e;vb(I|0)}function Mi(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0;e=i;i=i+16|0;j=e;g=c[d>>2]|0;h=d+4|0;if((Sa(b|0,4,1,c[h>>2]|0)|0)!=1){b=Jb(8)|0;u=0;oa(75,b|0,2592);l=u;u=0;if(l&1){l=qb(-1,-1)|0;pb(b|0);vb(l|0)}else{c[b>>2]=288;qc(b|0,264,1)}}if((Sa(b+4|0,4,1,c[h>>2]|0)|0)!=1){b=Jb(8)|0;u=0;oa(75,b|0,2592);l=u;u=0;if(l&1){l=qb(-1,-1)|0;pb(b|0);vb(l|0)}else{c[b>>2]=288;qc(b|0,264,1)}}a[j>>0]=0;if((Sa(j|0,1,1,c[h>>2]|0)|0)!=1){b=Jb(8)|0;u=0;oa(75,b|0,2592);l=u;u=0;if(l&1){l=qb(-1,-1)|0;pb(b|0);vb(l|0)}else{c[b>>2]=288;qc(b|0,264,1)}}if((a[j>>0]|0)!=0){c[b+8>>2]=c[(c[g+72>>2]|0)+(c[b>>2]<<2)>>2];i=e;return}h=g+112|0;k=c[h>>2]|0;do{if((k|0)<32){j=g+132|0;c[j>>2]=(c[j>>2]|0)+k;j=Av(8192)|0;if((j|0)==0){zb(3048,27,1,c[r>>2]|0)|0;k=0;break}else{k=g+116|0;c[j>>2]=c[k>>2];c[k>>2]=j;c[h>>2]=8188;j=j+4|0;c[g+120>>2]=j;k=8156;f=20;break}}else{j=c[g+120>>2]|0;k=k+ -32|0;f=20}}while(0);if((f|0)==20){c[g+120>>2]=j+32;c[h>>2]=k;k=g+128|0;c[k>>2]=(c[k>>2]|0)+32;k=j}c[k+0>>2]=0;c[k+4>>2]=0;c[k+8>>2]=0;c[k+12>>2]=0;c[k+16>>2]=0;j=b+12|0;c[j>>2]=k;l=c[h>>2]|0;do{if((l|0)<32){k=g+132|0;c[k>>2]=(c[k>>2]|0)+l;k=Av(8192)|0;if((k|0)==0){zb(3048,27,1,c[r>>2]|0)|0;k=0;break}else{l=g+116|0;c[k>>2]=c[l>>2];c[l>>2]=k;c[h>>2]=8188;k=k+4|0;c[g+120>>2]=k;l=8156;f=26;break}}else{k=c[g+120>>2]|0;l=l+ -32|0;f=26}}while(0);if((f|0)==26){c[g+120>>2]=k+32;c[h>>2]=l;l=g+128|0;c[l>>2]=(c[l>>2]|0)+32}c[k+0>>2]=0;c[k+4>>2]=0;c[k+8>>2]=0;c[k+12>>2]=0;c[k+16>>2]=0;l=b+16|0;c[l>>2]=k;Mi(c[j>>2]|0,d);Mi(c[l>>2]|0,d);i=e;return}function Ni(b,d,e,f,j,l,m,n,o,p){b=b|0;d=d|0;e=e|0;f=f|0;j=j|0;l=l|0;m=m|0;n=n|0;o=o|0;p=p|0;var q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0.0,L=0,M=0,N=0.0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0.0;o=i;i=i+128|0;w=o;r=o+96|0;t=o+76|0;s=o+56|0;v=o+36|0;x=c[f+4>>2]|0;if(x>>>0<j>>>0){c[w>>2]=x;c[w+4>>2]=j;Ah(5440,w)|0;n=Jb(8)|0;u=0;oa(75,n|0,5464);U=u;u=0;if(U&1){U=qb(-1,-1)|0;pb(n|0);vb(U|0)}else{c[n>>2]=288;qc(n|0,264,1)}}c[r>>2]=l;g[r+4>>2]=0.0;a[r+8>>0]=1;c[r+12>>2]=-1;c[r+16>>2]=2;c[r+20>>2]=1;a[r+24>>0]=0;y=p+j|0;A=y>>>0>1073741823?-1:y<<2;B=Gv(A)|0;A=Gv(A)|0;c[t>>2]=1;c[t+4>>2]=y;c[t+12>>2]=6;c[t+16>>2]=B;F=y<<2;c[t+8>>2]=F;c[s>>2]=1;c[s+4>>2]=y;c[s+12>>2]=8;c[s+16>>2]=A;c[s+8>>2]=F;F=B+(p<<2)|0;C=e+16|0;D=e+8|0;E=e+4|0;G=v+4|0;z=v+8|0;x=v+12|0;I=v+16|0;H=f+16|0;f=f+8|0;J=(j|0)>0;K=0.0;L=0;do{L=L+1|0;M=db()|0;if((c[e>>2]|0)==0){V=0.0;N=0.0}else{S=c[D>>2]|0;T=c[C>>2]|0;R=c[E>>2]|0;P=0;N=0.0;O=0;do{Q=c[(c[b>>2]|0)+60>>2]|0;U=T+(fa(S,O)|0)|0;c[v>>2]=1;c[G>>2]=R;c[x>>2]=8;c[I>>2]=U;c[z>>2]=R<<2;Ac[Q&7](b,v,t,s,y,r)|0;Q=(c[H>>2]|0)+(fa(c[f>>2]|0,O)|0)|0;if(J){S=0;R=0;do{U=c[B+(R+p<<2)>>2]|0;T=0;do{if((U|0)==(c[Q+(T<<2)>>2]|0)){q=12;break}T=T+1|0}while((T|0)<(j|0));if((q|0)==12){q=0;S=S+1|0}R=R+1|0}while((R|0)!=(j|0))}else{S=0}P=S+P|0;T=c[C>>2]|0;S=c[D>>2]|0;U=T+(fa(S,O)|0)|0;R=c[E>>2]|0;N=N+ +Yh(d,U,F,Q,R,j,0);O=O+1|0}while(O>>>0<(c[e>>2]|0)>>>0);V=+(P|0)}K=K+(+(db()|0)- +(M|0))/1.0e6}while(K<.2);g[m>>2]=K/+(L|0);if((B|0)!=0){Iv(B)}if((A|0)!=0){Iv(A)}T=c[e>>2]|0;K=+((fa(T,j)|0)>>>0);V=V/K;N=N/K;g[n>>2]=N;K=+g[m>>2];c[w>>2]=l;U=w+4|0;h[k>>3]=V;c[U>>2]=c[k>>2];c[U+4>>2]=c[k+4>>2];U=w+12|0;h[k>>3]=K;c[U>>2]=c[k>>2];c[U+4>>2]=c[k+4>>2];U=w+20|0;h[k>>3]=K*1.0e3/+(T>>>0);c[U>>2]=c[k>>2];c[U+4>>2]=c[k+4>>2];U=w+28|0;h[k>>3]=N;c[U>>2]=c[k>>2];c[U+4>>2]=c[k+4>>2];Ah(5528,w)|0;i=o;return+V}function Oi(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0;m=i;i=i+32|0;j=m+17|0;k=m+16|0;l=m+4|0;n=m;a[j+0>>0]=a[k+0>>0]|0;Dd(b,e,j);c[b>>2]=6024;j=b+92|0;k=b+100|0;e=b+104|0;f=b+124|0;c[j+0>>2]=0;c[j+4>>2]=0;c[j+8>>2]=0;c[j+12>>2]=0;c[j+16>>2]=0;c[f>>2]=8192;f=b+112|0;c[f>>2]=0;j=b+116|0;c[j>>2]=0;g=b+128|0;c[g>>2]=0;h=b+132|0;c[h>>2]=0;a[l>>0]=10;o=l+1|0;a[o+0>>0]=a[2912>>0]|0;a[o+1>>0]=a[2913>>0]|0;a[o+2>>0]=a[2914>>0]|0;a[o+3>>0]=a[2915>>0]|0;a[o+4>>0]=a[2916>>0]|0;a[l+6>>0]=0;c[n>>2]=4;u=0;n=ua(28,b+24|0,l|0,n|0)|0;o=u;u=0;do{if(o&1){d=qb(-1,-1)|0;if((a[l>>0]&1)==0){l=d}else{Hv(c[l+8>>2]|0);l=d}}else{c[b+88>>2]=n;if(!((a[l>>0]&1)==0)){Hv(c[l+8>>2]|0)}u=0;oa(79,b|0,d|0);o=u;u=0;if(o&1){l=qb(-1,-1)|0;break}else{i=m;return}}}while(0);d=c[j>>2]|0;if((d|0)!=0){do{o=d;d=c[d>>2]|0;Bv(o);c[j>>2]=d}while((d|0)!=0)}c[j>>2]=0;c[f>>2]=0;c[g>>2]=0;c[h>>2]=0;f=c[k>>2]|0;if((f|0)!=0){g=c[e>>2]|0;if((g|0)!=(f|0)){c[e>>2]=g+(~((g+ -4+(0-f)|0)>>>2)<<2)}Hv(f)}u=0;na(186,b|0);o=u;u=0;if(o&1){o=qb(-1,-1,0)|0;jd(o)}else{vb(l|0)}}function Pi(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0;f=i;c[b+0>>2]=0;c[b+4>>2]=0;c[b+8>>2]=0;g=a[d>>0]|0;j=(g&1)==0;if(j){g=(g&255)>>>1}else{g=c[d+4>>2]|0}h=a[e>>0]|0;if((h&1)==0){h=(h&255)>>>1}else{h=c[e+4>>2]|0}if(j){d=d+1|0}else{d=c[d+8>>2]|0}j=h+g|0;do{if(j>>>0>4294967279){u=0;na(183,0);k=u;u=0}else{if(j>>>0<11){a[b>>0]=g<<1;k=b+1|0}else{j=j+16&-16;u=0;k=qa(119,j|0)|0;l=u;u=0;if(l&1){break}c[b+8>>2]=k;c[b>>2]=j|1;c[b+4>>2]=g}tw(k|0,d|0,g|0)|0;a[k+g>>0]=0;if((a[e>>0]&1)==0){e=e+1|0}else{e=c[e+8>>2]|0}u=0;ua(31,b|0,e|0,h|0)|0;l=u;u=0;if(!(l&1)){i=f;return}}}while(0);f=qb(-1,-1)|0;if((a[b>>0]&1)==0){vb(f|0)}Hv(c[b+8>>2]|0);vb(f|0)}function Qi(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0;d=i;e=a+8|0;j=c[a>>2]|0;f=j;if(!((((c[e>>2]|0)-f|0)/28|0)>>>0<b>>>0)){i=d;return}g=a+4|0;n=c[g>>2]|0;if((b|0)==0){h=0}else{h=Fv(b*28|0)|0}f=h+(((n-f|0)/28|0)*28|0)|0;b=h+(b*28|0)|0;a:do{if((n|0)==(j|0)){c[a>>2]=f;c[g>>2]=f;c[e>>2]=b}else{m=f;while(1){l=m+ -28|0;n=n+ -28|0;u=0;oa(99,l|0,n|0);o=u;u=0;if(o&1){break}if((n|0)==(j|0)){k=8;break}else{m=l}}if((k|0)==8){j=c[a>>2]|0;h=c[g>>2]|0;c[a>>2]=l;c[g>>2]=f;c[e>>2]=b;if((h|0)==(j|0)){break}while(1){Bd(h+ -12|0,c[h+ -8>>2]|0);h=h+ -28|0;if((h|0)==(j|0)){break a}}}d=qb(-1,-1)|0;if((f|0)!=(m|0)){do{Bd(f+ -12|0,c[f+ -8>>2]|0);f=f+ -28|0}while((f|0)!=(m|0))}if((h|0)==0){vb(d|0)}Hv(h);vb(d|0)}}while(0);if((j|0)==0){i=d;return}Hv(j);i=d;return}function Ri(b,d){b=b|0;d=d|0;var e=0,f=0,j=0,l=0,m=0.0,n=0,o=0.0,p=0,q=0,r=0,s=0,t=0,v=0,w=0,x=0,y=0,z=0,A=0.0;q=i;i=i+208|0;n=q+8|0;r=q;p=q+196|0;e=q+184|0;s=q+172|0;j=q+32|0;t=d+16|0;a[e>>0]=20;x=e+1|0;z=6432|0;y=x+10|0;do{a[x>>0]=a[z>>0]|0;x=x+1|0;z=z+1|0}while((x|0)<(y|0));a[e+11>>0]=0;u=0;v=Ha(38,t|0,e|0)|0;z=u;u=0;do{if(!(z&1)){a[s>>0]=18;x=s+1|0;z=2880|0;y=x+9|0;do{a[x>>0]=a[z>>0]|0;x=x+1|0;z=z+1|0}while((x|0)<(y|0));a[s+10>>0]=0;u=0;w=Ha(38,t|0,s|0)|0;z=u;u=0;if(z&1){f=qb(-1,-1)|0;if((a[s>>0]&1)==0){break}Hv(c[s+8>>2]|0);break}c[n>>2]=v;c[n+4>>2]=w;Ah(6448,n)|0;if(!((a[s>>0]&1)==0)){Hv(c[s+8>>2]|0)}if(!((a[e>>0]&1)==0)){Hv(c[e+8>>2]|0)}s=b+132|0;a[n+0>>0]=a[r+0>>0]|0;Aj(j,s,t,n);u=0;r=Ka(1)|0;z=u;u=0;if(((!(z&1)?(u=0,na(c[(c[j>>2]|0)+40>>2]|0,j|0),z=u,u=0,!(z&1)):0)?(u=0,l=Ka(1)|0,z=u,u=0,!(z&1)):0)?(m=(+(l|0)- +(r|0))/1.0e6+0.0,u=0,o=+La(2,j|0,s|0,b+152|0,b+172|0,+(+g[b+216>>2]),p|0,b+4|0,1,0),z=u,u=0,!(z&1)):0){A=+((fa(c[s>>2]<<2,c[b+136>>2]|0)|0)>>>0);g[d+8>>2]=(A+ +((c[j+128>>2]|0)+(c[j+124>>2]|0)+(c[j+132>>2]|0)|0))/A;g[d>>2]=o;g[d+4>>2]=m;A=+g[b+220>>2];h[k>>3]=m;c[n>>2]=c[k>>2];c[n+4>>2]=c[k+4>>2];z=n+8|0;h[k>>3]=o;c[z>>2]=c[k>>2];c[z+4>>2]=c[k+4>>2];z=n+16|0;h[k>>3]=A;c[z>>2]=c[k>>2];c[z+4>>2]=c[k+4>>2];Ah(6512,n)|0;Ui(j);i=q;return}l=qb(-1,-1)|0;u=0;na(199,j|0);z=u;u=0;if(z&1){z=qb(-1,-1,0)|0;jd(z)}else{z=l;vb(z|0)}}else{f=qb(-1,-1)|0}}while(0);if((a[e>>0]&1)==0){z=f;vb(z|0)}Hv(c[e+8>>2]|0);z=f;vb(z|0)}function Si(a){a=a|0;return(c[a+128>>2]|0)+(c[a+124>>2]|0)+(c[a+132>>2]|0)|0}function Ti(a){a=a|0;var b=0;b=i;Ui(a);i=b;return}function Ui(a){a=a|0;var b=0,d=0,e=0,f=0;b=i;c[a>>2]=6584;d=c[a+136>>2]|0;if((d|0)!=0){u=0;na(c[(c[d>>2]|0)+4>>2]|0,d|0);d=u;u=0;if(!(d&1)){e=c[a>>2]|0;f=4}}else{e=6584|0;f=4}if((f|0)==4?(u=0,na(c[e+68>>2]|0,a|0),f=u,u=0,!(f&1)):0){d=a+112|0;e=c[d>>2]|0;if((e|0)==0){c[d>>2]=0;f=a+108|0;c[f>>2]=0;f=a+124|0;c[f>>2]=0;f=a+128|0;c[f>>2]=0;Hd(a);i=b;return}do{f=e;e=c[e>>2]|0;Bv(f);c[d>>2]=e}while((e|0)!=0);c[d>>2]=0;f=a+108|0;c[f>>2]=0;f=a+124|0;c[f>>2]=0;f=a+128|0;c[f>>2]=0;Hd(a);i=b;return}b=qb(-1,-1)|0;d=a+112|0;e=c[d>>2]|0;if((e|0)!=0){do{f=e;e=c[e>>2]|0;Bv(f);c[d>>2]=e}while((e|0)!=0)}c[d>>2]=0;c[a+108>>2]=0;c[a+124>>2]=0;c[a+128>>2]=0;u=0;na(186,a|0);f=u;u=0;if(f&1){f=qb(-1,-1,0)|0;jd(f)}else{vb(b|0)}}function Vi(a){a=a|0;var b=0,c=0;b=i;u=0;na(199,a|0);c=u;u=0;if(c&1){c=qb(-1,-1)|0;Hv(a);vb(c|0)}else{Hv(a);i=b;return}}function Wi(a){a=a|0;return 2}function Xi(b,d){b=b|0;d=d|0;var e=0,f=0,g=0;f=i;i=i+16|0;g=f;yc[c[(c[b>>2]|0)+68>>2]&255](b);e=g+4|0;c[e>>2]=d;d=g+8|0;a[d>>0]=0;u=0;oa(110,b|0,g|0);b=u;u=0;if(b&1){b=qb(-1,-1)|0;if((a[d>>0]|0)==0){vb(b|0)}Rb(c[e>>2]|0)|0;vb(b|0)}else{if((a[d>>0]|0)==0){i=f;return}Rb(c[e>>2]|0)|0;i=f;return}}function Yi(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0;f=i;i=i+16|0;h=f+12|0;g=f;e=g+4|0;c[e>>2]=d;d=g+8|0;a[d>>0]=0;c[g>>2]=b;u=0;oa(106,b|0,g|0);j=u;u=0;if(j&1){b=qb(-1,-1)|0;if((a[d>>0]|0)==0){vb(b|0)}Rb(c[e>>2]|0)|0;vb(b|0)}else{j=c[g+4>>2]|0;zb(b+88|0,4,1,j|0)|0;zb(b+92|0,4,1,j|0)|0;zb(b+132|0,4,1,j|0)|0;zb(b+100|0,4,1,j|0)|0;c[h>>2]=c[b+96>>2];zb(h|0,4,1,j|0)|0;wj(c[b+104>>2]|0,g);if((a[d>>0]|0)==0){i=f;return}Rb(c[e>>2]|0)|0;i=f;return}}function Zi(a){a=a|0;var b=0,c=0;c=i;b=Fv(140)|0;u=0;oa(111,b|0,a|0);a=u;u=0;if(a&1){c=qb(-1,-1)|0;Hv(b);vb(c|0)}else{i=c;return b|0}return 0}function _i(a,b,d){a=a|0;b=b|0;d=+d;var e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0.0,u=0.0,v=0.0,w=0.0;f=i;h=a+20|0;if((c[b+4>>2]|0)!=(c[h>>2]|0)){Wa(1208,6720,219,1232)}r=a+12|0;e=c[r>>2]|0;He(a,b);if(d>1.0?+((c[a+16>>2]|0)>>>0)*d<+((c[r>>2]|0)>>>0):0){yc[c[(c[a>>2]|0)+40>>2]&255](a);i=f;return}if((c[b>>2]|0)==0){i=f;return}k=a+104|0;l=b+16|0;m=b+8|0;j=0;do{n=c[k>>2]|0;q=c[n>>2]|0;r=(c[l>>2]|0)+(fa(c[m>>2]|0,j)|0)|0;s=c[h>>2]|0;o=q+(s<<2)|0;s=s+ -3|0;p=q+(s<<2)|0;if((s|0)>0){d=0.0;do{w=+g[q>>2]- +g[r>>2];v=+g[q+4>>2]- +g[r+4>>2];u=+g[q+8>>2]- +g[r+8>>2];t=+g[q+12>>2]- +g[r+12>>2];d=d+(w*w+v*v+u*u+t*t);q=q+16|0;r=r+16|0}while(q>>>0<p>>>0);p=r}else{p=r;d=0.0}if(q>>>0<o>>>0){while(1){w=+g[q>>2]- +g[p>>2];q=q+4|0;d=d+w*w;if(!(q>>>0<o>>>0)){break}else{p=p+4|0}}}rj(a,n,j+e|0,d);j=j+1|0}while(j>>>0<(c[b>>2]|0)>>>0);i=f;return}function $i(b,c,d,e){b=b|0;c=c|0;d=d|0;e=e|0;var f=0;f=i;if((a[b+36>>0]|0)==0){ij(b,c,d,e);i=f;return}else{hj(b,c,d,e);i=f;return}}function aj(a){a=a|0;var b=0,d=0,e=0,f=0;b=i;d=a+104|0;e=c[d>>2]|0;if((e|0)!=0){gj(e)}c[d>>2]=0;d=a+112|0;e=c[d>>2]|0;if((e|0)!=0){do{f=e;e=c[e>>2]|0;Bv(f);c[d>>2]=e}while((e|0)!=0)}c[d>>2]=0;c[a+108>>2]=0;c[a+124>>2]=0;c[a+128>>2]=0;i=b;return}function bj(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0;e=i;i=i+16|0;d=e;g=a+88|0;if((c[g>>2]|0)<2){b=Jb(8)|0;u=0;oa(75,b|0,3008);n=u;u=0;if(!(n&1)){c[b>>2]=288;qc(b|0,264,1)}n=qb(-1,-1)|0;pb(b|0);vb(n|0)}h=a+12|0;m=c[h>>2]|0;c[d>>2]=0;b=d+4|0;c[b>>2]=0;n=d+8|0;c[n>>2]=0;if((m|0)!=0){if(m>>>0>1073741823){ss(0)}k=Fv(m<<2)|0;c[b>>2]=k;c[d>>2]=k;l=k+(m<<2)|0;c[n>>2]=l;n=m;m=k;while(1){if((m|0)!=0){c[m>>2]=0}n=n+ -1|0;if((n|0)==0){break}else{m=m+4|0}}c[b>>2]=l;l=c[h>>2]|0;if((l|0)!=0){m=0;do{c[k+(m<<2)>>2]=m;m=m+1|0}while(m>>>0<l>>>0)}}k=a+108|0;m=c[k>>2]|0;do{if((m|0)<48){l=a+128|0;c[l>>2]=(c[l>>2]|0)+m;l=Av(8192)|0;if((l|0)==0){zb(3048,27,1,c[r>>2]|0)|0;k=0;break}else{m=a+112|0;c[l>>2]=c[m>>2];c[m>>2]=l;c[k>>2]=8188;l=l+4|0;c[a+116>>2]=l;m=8140;j=23;break}}else{l=c[a+116>>2]|0;m=m+ -48|0;j=23}}while(0);if((j|0)==23){c[a+116>>2]=l+48;c[k>>2]=m;k=a+124|0;c[k>>2]=(c[k>>2]|0)+48;k=l}m=a+104|0;l=k+0|0;j=l+40|0;do{c[l>>2]=0;l=l+4|0}while((l|0)<(j|0));c[m>>2]=k;u=0;Na(53,a|0,k|0,d|0);n=u;u=0;if(!(n&1)?(f=c[d>>2]|0,u=0,ma(5,a|0,c[m>>2]|0,f|0,c[h>>2]|0,c[g>>2]|0),n=u,u=0,!(n&1)):0){if((f|0)==0){i=e;return}d=c[b>>2]|0;if((d|0)!=(f|0)){c[b>>2]=d+(~((d+ -4+(0-f)|0)>>>2)<<2)}Hv(f);i=e;return}e=qb(-1,-1)|0;d=c[d>>2]|0;if((d|0)==0){n=e;vb(n|0)}f=c[b>>2]|0;if((f|0)!=(d|0)){c[b>>2]=f+(~((f+ -4+(0-d)|0)>>>2)<<2)}Hv(d);n=e;vb(n|0)}function cj(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,h=0,j=0.0,k=0,l=0,m=0,n=0,o=0.0,p=0.0,q=0,r=0.0,s=0,t=0,u=0,v=0.0,w=0.0,x=0.0,y=0.0;e=i;f=c[d>>2]|0;h=(c[d+4>>2]|0)-f>>2;l=c[a+20>>2]|0;d=Gv(l>>>0>1073741823?-1:l<<2)|0;k=l<<2;t=a+132|0;c[t>>2]=(c[t>>2]|0)+k;ww(d|0,0,k|0)|0;k=(h|0)==0;if(!k){s=c[a+72>>2]|0;t=(l|0)==0;n=0;do{q=c[s+(c[f+(n<<2)>>2]<<2)>>2]|0;if(!t){m=0;do{u=d+(m<<2)|0;g[u>>2]=+g[q+(m<<2)>>2]+ +g[u>>2];m=m+1|0}while(m>>>0<l>>>0)}n=n+1|0}while((n|0)!=(h|0))}j=+(h>>>0);o=1.0/j;if((l|0)==0){l=0}else{m=0;do{u=d+(m<<2)|0;g[u>>2]=o*+g[u>>2];m=m+1|0}while(m>>>0<l>>>0)}if(k){r=0.0;p=0.0;p=p/j;u=b+8|0;g[u>>2]=p;u=b+4|0;g[u>>2]=r;c[b>>2]=d;i=e;return}a=c[a+72>>2]|0;k=d+(l<<2)|0;l=d+(l+ -3<<2)|0;n=d>>>0<l>>>0;m=0;o=0.0;p=0.0;do{s=c[a+(c[f+(m<<2)>>2]<<2)>>2]|0;if(n){q=d;r=0.0;do{y=+g[q>>2]- +g[s>>2];x=+g[q+4>>2]- +g[s+4>>2];w=+g[q+8>>2]- +g[s+8>>2];v=+g[q+12>>2]- +g[s+12>>2];r=r+(y*y+x*x+w*w+v*v);q=q+16|0;s=s+16|0}while(q>>>0<l>>>0)}else{q=d;r=0.0}if(q>>>0<k>>>0){while(1){y=+g[q>>2]- +g[s>>2];q=q+4|0;r=r+y*y;if(!(q>>>0<k>>>0)){break}else{s=s+4|0}}}o=r>o?r:o;p=p+r;m=m+1|0}while((m|0)!=(h|0));y=p/j;u=b+8|0;g[u>>2]=y;u=b+4|0;g[u>>2]=o;c[b>>2]=d;i=e;return}



function dw(e,f,g,j,l){e=e|0;f=f|0;g=g|0;j=j|0;l=l|0;var m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,da=0,ea=0,ga=0,ha=0,ia=0,ja=0,ka=0,la=0,ma=0,na=0,oa=0,pa=0,qa=0,ra=0,sa=0,ta=0,ua=0,va=0,wa=0,xa=0,ya=0,za=0,Aa=0,Ba=0,Ca=0,Da=0,Ea=0,Fa=0,Ga=0,Ha=0,Ia=0,Ja=0,Ka=0,La=0,Ma=0,Na=0,Oa=0,Pa=0,Qa=0,Ra=0,Sa=0,Ta=0,Ua=0,Va=0,Wa=0,Xa=0,Ya=0,Za=0.0,_a=0,$a=0.0,ab=0;n=i;i=i+848|0;x=n+16|0;K=n+8|0;r=n+812|0;s=r;q=n+800|0;L=n+544|0;E=n+504|0;H=n;C=n+496|0;G=(e|0)!=0;_=E+40|0;D=_;E=E+39|0;I=H+4|0;p=q+12|0;q=q+11|0;w=p;v=w-s|0;t=-2-s|0;u=w+2|0;y=x+264|0;z=r+9|0;A=z;B=r+8|0;Ia=0;Ja=0;pa=0;Oa=0;La=0;a:while(1){do{if((pa|0)>-1){if((Oa|0)>(2147483647-pa|0)){pa=nc()|0;c[pa>>2]=75;pa=-1;break}else{pa=Oa+pa|0;break}}}while(0);Ga=a[f>>0]|0;if(Ga<<24>>24==0){Ea=339;break}else{Fa=f}while(1){if(Ga<<24>>24==37){S=Fa;R=Fa;Ea=9;break}else if(Ga<<24>>24==0){ha=Fa;oa=Fa;break}_a=Fa+1|0;Ga=a[_a>>0]|0;Fa=_a}b:do{if((Ea|0)==9){while(1){Ea=0;if((a[S+1>>0]|0)!=37){ha=S;oa=R;break b}oa=R+1|0;ha=S+2|0;if((a[ha>>0]|0)==37){S=ha;R=oa}else{break}}}}while(0);Oa=oa-f|0;if(G){aw(f,Oa,e)|0}if((oa|0)!=(f|0)){Ya=Ja;_a=Ia;f=ha;Ja=Ya;Ia=_a;continue}Ha=ha+1|0;Ma=a[Ha>>0]|0;Ka=(Ma<<24>>24)+ -48|0;if(Ka>>>0<10?(a[ha+2>>0]|0)==36:0){Ha=ha+3|0;Ma=a[Ha>>0]|0;Fa=1}else{Ka=-1;Fa=La}Ga=Ma<<24>>24;c:do{if((Ga+ -32|0)>>>0<32){Pa=0;while(1){if((1<<Ga+ -32&75913|0)==0){Ga=Ma;break c}Pa=1<<(Ma<<24>>24)+ -32|Pa;Ha=Ha+1|0;Ma=a[Ha>>0]|0;Ga=Ma<<24>>24;if(!((Ga+ -32|0)>>>0<32)){Ga=Ma;break}}}else{Ga=Ma;Pa=0}}while(0);do{if(Ga<<24>>24==42){Ga=Ha+1|0;Ma=(a[Ga>>0]|0)+ -48|0;if(Ma>>>0<10?(a[Ha+2>>0]|0)==36:0){c[l+(Ma<<2)>>2]=10;Fa=1;Ma=Ha+3|0;Ha=c[j+((a[Ga>>0]|0)+ -48<<3)>>2]|0}else{if((Fa|0)!=0){m=-1;Ea=357;break a}if(!G){Fa=0;Ha=0;break}Fa=c[g>>2]|0;Ha=c[Fa>>2]|0;c[g>>2]=Fa+4;Fa=0;Ma=Ga}if((Ha|0)<0){Ga=Ma;Pa=Pa|8192;Ha=0-Ha|0}else{Ga=Ma}}else{Ma=Ga<<24>>24;if((Ma+ -48|0)>>>0<10){Ga=Ha;Ha=0;do{Ha=Ma+ -48+(Ha*10|0)|0;Ga=Ga+1|0;Ma=a[Ga>>0]|0}while((Ma+ -48|0)>>>0<10);if((Ha|0)<0){m=-1;Ea=357;break a}}else{Ga=Ha;Ha=0}}}while(0);d:do{if((a[Ga>>0]|0)==46){Ma=Ga+1|0;Na=a[Ma>>0]|0;if(!(Na<<24>>24==42)){Na=Na<<24>>24;if((Na+ -48|0)>>>0<10){Ga=Ma;Ma=0}else{Ga=Ma;Ma=0;break}while(1){Ma=Na+ -48+(Ma*10|0)|0;Ga=Ga+1|0;Na=a[Ga>>0]|0;if(!((Na+ -48|0)>>>0<10)){break d}}}Ma=Ga+2|0;Na=(a[Ma>>0]|0)+ -48|0;if(Na>>>0<10?(a[Ga+3>>0]|0)==36:0){c[l+(Na<<2)>>2]=10;Ga=Ga+4|0;Ma=c[j+((a[Ma>>0]|0)+ -48<<3)>>2]|0;break}if((Fa|0)!=0){m=-1;Ea=357;break a}if(G){Ga=c[g>>2]|0;_a=c[Ga>>2]|0;c[g>>2]=Ga+4;Ga=Ma;Ma=_a}else{Ga=Ma;Ma=0}}else{Ma=-1}}while(0);Na=Ga;Qa=0;while(1){Ra=a[Na>>0]|0;Sa=(Ra<<24>>24)+ -65|0;if(Sa>>>0>57){m=-1;Ea=357;break a}Ga=Na+1|0;Ta=a[25832+(Qa*58|0)+Sa>>0]|0;Sa=Ta&255;if((Sa+ -1|0)>>>0<8){Na=Ga;Qa=Sa}else{break}}if(Ta<<24>>24==0){m=-1;Ea=357;break}Ua=(Ka|0)>-1;e:do{if(Ta<<24>>24==19){if(Ua){m=-1;Ea=357;break a}if(!G){Ya=Ja;_a=Ia;f=Ga;La=Fa;Ja=Ya;Ia=_a;continue a}}else{f:do{if(Ua){c[l+(Ka<<2)>>2]=Sa;P=j+(Ka<<3)|0;M=c[P>>2]|0;P=c[P+4>>2]|0;Ea=64}else{if(!G){m=0;Ea=357;break a}if((Ta&255)>20){break e}do{switch(Sa|0){case 18:{M=c[g>>2]|0;c[k>>2]=c[M>>2];c[k+4>>2]=c[M+4>>2];$a=+h[k>>3];c[g>>2]=M+8;h[k>>3]=$a;M=c[k>>2]|0;P=c[k+4>>2]|0;Ea=64;break f};case 12:{_a=c[g>>2]|0;O=_a;N=c[O>>2]|0;O=c[O+4>>2]|0;c[g>>2]=_a+8;break f};case 11:{O=c[g>>2]|0;N=c[O>>2]|0;c[g>>2]=O+4;O=0;break f};case 10:{N=c[g>>2]|0;O=c[N>>2]|0;c[g>>2]=N+4;N=O;O=((O|0)<0)<<31>>31;break f};case 15:{N=c[g>>2]|0;O=c[N>>2]|0;c[g>>2]=N+4;N=O<<24>>24;O=(((O&255)<<24>>24|0)<0)<<31>>31;break f};case 16:{O=c[g>>2]|0;N=c[O>>2]|0;c[g>>2]=O+4;N=N&255;O=0;break f};case 9:{O=c[g>>2]|0;N=c[O>>2]|0;c[g>>2]=O+4;O=Ia;break f};case 13:{N=c[g>>2]|0;O=c[N>>2]|0;c[g>>2]=N+4;N=O<<16>>16;O=(((O&65535)<<16>>16|0)<0)<<31>>31;break f};case 14:{O=c[g>>2]|0;N=c[O>>2]|0;c[g>>2]=O+4;N=N&65535;O=0;break f};case 17:{N=c[g>>2]|0;c[k>>2]=c[N>>2];c[k+4>>2]=c[N+4>>2];$a=+h[k>>3];c[g>>2]=N+8;h[k>>3]=$a;N=c[k>>2]|0;O=c[k+4>>2]|0;break f};default:{N=Ja;O=Ia;break f}}}while(0)}}while(0);if((Ea|0)