function avg(iterable, size, key) {
    var sum = 0,
        size = size || iterable.length,
        key = key || (i => iterable[i]);
    for(var i=0; i<size; i++)
        sum += (val = key(i)) === undefined || Number.isNaN(val) ? 0 : val;
    return sum/size;
}

function deepCopy(o) {
    return $.extend(true, {}, o);
}

function swap(a, i, j) {
    var tmp = a[i];
    a[i] = a[j];
    a[j] = tmp;
}

function cond_perm(result, arr, size, index, cond) {
    if(cond(arr, index-1))
        return;

    if(index === size) {
	result.push([...arr]);
	return;
    }

    for(var i = index; i < size; i++) {
	swap(arr, i, index);
	cond_perm(result, arr, size, index+1, cond);
	swap(arr, i, index);
    }
}

function getNumberInNormalDistribution(mean,std_dev){    
    return mean+(uniform2NormalDistribution()*std_dev);

    function uniform2NormalDistribution(){
	var sum=0.0;
	for(var i=0; i<12; i++){
	    sum=sum+Math.random();
	}
	return sum-6.0;
    }
}

function randn(num, r)
{
    var data = [];
    for(var i=0; i<num; i++) {
	data.push({x:getNumberInNormalDistribution(0,r), y:getNumberInNormalDistribution(0,r)});
    }
    return data;
}

class TupleDictionary {
    constructor(){
	this.dict = new Map();
    }

    tupleToString(tuple) {
	return tuple.join(",");
    }

    put(tuple, val) {
	this.dict.set(this.tupleToString(tuple), val);
    }

    get(tuple) {
	return this.dict.get(this.tupleToString(tuple));
    }

    keys() {
        return this.dict.keys();
    }
}
