/* eslint-disable no-console */
import { json } from 'co-body'

export const resolvers = {
  Routes: {
    clearCart: async (ctx: Context) => {
      const {
        req,
        clients: { checkout },
      } = ctx

      const body: any = await json(req)
      const email = body?.authentication?.storeUserEmail?.value ?? null
      const orderFormId = body?.checkout?.orderFormId?.value ?? null

      console.log('clearCart =>', body)

      ctx.set('Content-Type', 'application/json')
      ctx.set('Cache-Control', 'no-cache, no-store')

      const res = {
        public: {
          demo: {
            value: email ? 'User Authenticated' : 'User not authenticated',
          },
        },
      }

      // If user is not authenticated, and we have an orderFormId
      if (!email && orderFormId) {
        // Get the current orderForm data
        const orderForm: any = await checkout.orderForm(orderFormId)

        // Only if we have an user assigned to this orderForm
        if (orderForm?.clientProfileData?.email) {
          // Change to annonymous
          await checkout.changeToAnonymous(orderFormId).catch((err) => {
            if (err.response.status >= 400) {
              console.log('Cart response error =>', err.response.statusText)
            } else {
              console.log('Cart response all good =>', err.response.status)
            }
          })

          /*
           * To remove items from the Cart
           * If we have items in the Cart
           */
          if (orderForm?.items?.length) {
            // Create a orderItems array with the item position and new quantity set to 0
            const orderItems = orderForm.items.map((_: any, index: number) => {
              return {
                index,
                quantity: 0,
              }
            })

            // Update the Cart items with the new quantity
            await checkout.updateItems(orderFormId, orderItems).catch((err) => {
              console.log('Error removing all items =>', err)
            })
          }
        }
      }

      ctx.response.body = res
      ctx.response.status = 200
    },
  },
}
