import type { InstanceOptions, IOContext } from '@vtex/api'
import { JanusClient } from '@vtex/api'

export class Checkout extends JanusClient {
  constructor(context: IOContext, options?: InstanceOptions) {
    super(context, { ...options })
  }

  public changeToAnonymous = (orderFormId: string) => {
    return this.http.getRaw(`/checkout/changeToAnonymousUser/${orderFormId}`, {
      metric: 'change-to-anonymous',
    })
  }

  public orderForm = (orderFormId: string) => {
    return this.http.post(
      `/api/checkout/pub/orderForm/${orderFormId}`,
      { expectedOrderFormSections: ['items'] },
      {
        metric: 'get-orderForm',
      }
    )
  }

  public updateItems = (orderFormId: string, orderItems: any) => {
    return this.http.post(
      `/api/checkout/pub/orderForm/${orderFormId}/items/update`,
      { orderItems },
      {
        metric: 'update-orderform-items',
      }
    )
  }
}
