/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.update;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.StringTokenizer;
import net.i2p.I2PAppContext;
import net.i2p.app.ClientAppManager;
import net.i2p.crypto.CertUtil;
import net.i2p.crypto.SU3File;
import net.i2p.data.Base64;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.router.Banlist;
import net.i2p.router.Blocklist;
import net.i2p.router.RouterContext;
import net.i2p.router.news.BlocklistEntries;
import net.i2p.router.news.CRLEntry;
import net.i2p.router.news.NewsEntry;
import net.i2p.router.news.NewsManager;
import net.i2p.router.news.NewsMetadata;
import net.i2p.router.news.NewsXMLParser;
import net.i2p.router.update.ConsoleUpdateManager;
import net.i2p.router.update.UpdateRunner;
import net.i2p.router.web.ConfigUpdateHandler;
import net.i2p.router.web.NewsHelper;
import net.i2p.update.UpdateMethod;
import net.i2p.update.UpdateType;
import net.i2p.util.Addresses;
import net.i2p.util.EepGet;
import net.i2p.util.FileUtil;
import net.i2p.util.RFC822Date;
import net.i2p.util.ReusableGZIPInputStream;
import net.i2p.util.SSLEepGet;
import net.i2p.util.SecureFile;
import net.i2p.util.SecureFileOutputStream;
import net.i2p.util.Translate;
import org.cybergarage.xml.Node;

class NewsFetcher
extends UpdateRunner {
    private String _lastModified;
    private long _newLastModified;
    private final File _newsFile;
    private final File _tempFile;
    private boolean _isNewer;
    private boolean _success;
    private static final String TEMP_NEWS_FILE = "news.xml.temp";
    static final String PROP_BLOCKLIST_TIME = "router.blocklistVersion";
    private static final String BLOCKLIST_DIR = "docs/feed/blocklist";
    private static final String BLOCKLIST_FILE = "blocklist.txt";
    private static final String VERSION_PREFIX = "<i2p.release ";
    private static final String VERSION_KEY = "version";
    private static final String MIN_VERSION_KEY = "minversion";
    private static final String MIN_JAVA_VERSION_KEY = "minjavaversion";
    private static final String SUD_KEY = "sudtorrent";
    private static final String SU2_KEY = "su2torrent";
    private static final String SU3_KEY = "su3torrent";
    private static final String CLEARNET_SUD_KEY = "sudclearnet";
    private static final String CLEARNET_SU2_KEY = "su2clearnet";
    private static final String CLEARNET_HTTP_SU3_KEY = "su3clearnet";
    private static final String CLEARNET_HTTPS_SU3_KEY = "su3ssl";
    private static final String I2P_SUD_KEY = "sudi2p";
    private static final String I2P_SU2_KEY = "su2i2p";

    public NewsFetcher(RouterContext ctx, ConsoleUpdateManager mgr, List<URI> uris) {
        super(ctx, mgr, UpdateType.NEWS, uris);
        this._newsFile = new File(ctx.getRouterDir(), "docs/news.xml");
        this._tempFile = new File(ctx.getTempDir(), "tmp-" + ctx.random().nextLong() + TEMP_NEWS_FILE);
        long lastMod = NewsHelper.lastUpdated(ctx);
        if (lastMod > 0L) {
            this._lastModified = RFC822Date.to822Date((long)lastMod);
        }
    }

    @Override
    public void run() {
        this._isRunning = true;
        try {
            try {
                this.fetchNews();
            }
            catch (Throwable t) {
                this._mgr.notifyTaskFailed(this, "", t);
                this._mgr.notifyCheckComplete(this, this._isNewer, this._success);
                this._isRunning = false;
            }
        }
        finally {
            this._mgr.notifyCheckComplete(this, this._isNewer, this._success);
            this._isRunning = false;
        }
    }

    public void fetchNews() {
        boolean shouldProxy = this._context.getProperty("router.fetchNewsThroughProxy", true);
        String proxyHost = this._context.getProperty("router.updateProxyHost", "127.0.0.1");
        int proxyPort = ConfigUpdateHandler.proxyPort((I2PAppContext)this._context);
        if (shouldProxy && proxyPort == 4444 && proxyHost.equals("127.0.0.1") && this._context.portMapper().getPort("HTTP") < 0) {
            if (this._log.shouldWarn()) {
                this._log.warn("Cannot fetch news - HTTP client tunnel not running");
            }
            return;
        }
        if (shouldProxy && this._context.commSystem().isDummy()) {
            if (this._log.shouldWarn()) {
                this._log.warn("Cannot fetch news - VM Comm system");
            }
            return;
        }
        for (URI uri : this._urls) {
            this._currentURI = this.addLang(uri);
            String newsURL = this._currentURI.toString();
            if (this._tempFile.exists()) {
                this._tempFile.delete();
            }
            try {
                int status;
                long start;
                Object get = shouldProxy ? new EepGet((I2PAppContext)this._context, true, proxyHost, proxyPort, 0, this._tempFile.getAbsolutePath(), newsURL, true, null, this._lastModified) : ("https".equals(uri.getScheme()) ? new SSLEepGet((I2PAppContext)this._context, this._tempFile.getAbsolutePath(), newsURL) : new EepGet((I2PAppContext)this._context, false, null, 0, 0, this._tempFile.getAbsolutePath(), newsURL, true, null, this._lastModified));
                get.addStatusListener((EepGet.StatusListener)this);
                this._newLastModified = start = this._context.clock().now();
                if (!get.fetch() || (status = get.getStatusCode()) != 200 && status != 304) continue;
                HashMap<String, String> opts = new HashMap<String, String>(2);
                opts.put("routerconsole.newsLastChecked", Long.toString(start));
                if (status == 200 && this._isNewer) {
                    opts.put("routerconsole.newsLastUpdated", Long.toString(this._newLastModified));
                }
                this._context.router().saveConfig(opts, null);
                return;
            }
            catch (Throwable t) {
                this._log.error("Error fetching the news", t);
            }
        }
    }

    private URI addLang(URI uri) {
        if (!this._context.getBooleanPropertyDefaultTrue("routerconsole.newsTranslate")) {
            return uri;
        }
        String lang = Translate.getLanguage((I2PAppContext)this._context);
        if (lang.equals("en")) {
            return uri;
        }
        String query = uri.getRawQuery();
        if (query != null && (query.startsWith("lang=") || query.contains("&lang="))) {
            return uri;
        }
        String url = uri.toString();
        StringBuilder buf = new StringBuilder();
        buf.append(url);
        if (query != null) {
            buf.append("&lang=");
        } else {
            buf.append("?lang=");
        }
        buf.append(lang);
        String co = Translate.getCountry((I2PAppContext)this._context);
        if (co.length() > 0) {
            buf.append('_').append(co);
        }
        try {
            return new URI(buf.toString());
        }
        catch (URISyntaxException use) {
            return uri;
        }
    }

    /*
     * Exception decompiling
     */
    void checkForUpdates() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 28[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Map<String, String> parseArgs(String args) {
        HashMap<String, String> rv = new HashMap<String, String>(8);
        char[] data = args.toCharArray();
        StringBuilder buf = new StringBuilder(32);
        boolean isQuoted = false;
        String key = null;
        int i = 0;
        while (i < data.length) {
            switch (data[i]) {
                case '\"': 
                case '\'': {
                    if (isQuoted) {
                        if (key != null) {
                            rv.put(key, buf.toString().trim());
                            key = null;
                        }
                        buf.setLength(0);
                    }
                    isQuoted = !isQuoted;
                    break;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case ',': {
                    if (isQuoted) {
                        buf.append(data[i]);
                        break;
                    }
                    if (key != null) {
                        rv.put(key, buf.toString().trim());
                        key = null;
                    }
                    buf.setLength(0);
                    break;
                }
                case '=': {
                    if (isQuoted) {
                        buf.append(data[i]);
                        break;
                    }
                    key = buf.toString().trim().toLowerCase(Locale.US);
                    buf.setLength(0);
                    break;
                }
                default: {
                    buf.append(data[i]);
                }
            }
            ++i;
        }
        if (key != null) {
            rv.put(key, buf.toString().trim());
        }
        return rv;
    }

    private static List<URI> tokenize(String URLs) {
        StringTokenizer tok = new StringTokenizer(URLs, " ,\r\n");
        ArrayList<URI> rv = new ArrayList<URI>();
        while (tok.hasMoreTokens()) {
            try {
                rv.add(new URI(tok.nextToken().trim()));
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return rv;
    }

    private void addMethod(UpdateMethod method, String urls, Map<UpdateMethod, List<URI>> map) {
        List<URI> uris;
        if (urls != null && !(uris = NewsFetcher.tokenize(urls)).isEmpty()) {
            Collections.shuffle(uris, (Random)this._context.random());
            map.put(method, uris);
        }
    }

    @Override
    public void bytesTransferred(long alreadyTransferred, int currentWrite, long bytesTransferred, long bytesRemaining, String url) {
    }

    @Override
    public void headerReceived(String url, int attemptNum, String key, String val) {
        long lm;
        if ("Last-Modified".equals(key) && (lm = RFC822Date.parse822Date((String)val)) > 0L && lm < this._newLastModified) {
            this._newLastModified = lm;
        }
    }

    @Override
    public void transferComplete(long alreadyTransferred, long bytesTransferred, long bytesRemaining, String url, String outputFile, boolean notModified) {
        if (this._log.shouldLog(20)) {
            this._log.info("News fetched from " + url + " with " + (alreadyTransferred + bytesTransferred));
        }
        if (this._tempFile.exists() && this._tempFile.length() > 0L) {
            File from;
            try {
                from = this.processSU3();
            }
            catch (IOException ioe) {
                this._log.error("Failed to extract the news file", (Throwable)ioe);
                this._tempFile.delete();
                return;
            }
            boolean copied = FileUtil.rename((File)from, (File)this._newsFile);
            this._tempFile.delete();
            if (copied) {
                String newVer = Long.toString(this._newLastModified);
                this._mgr.notifyVersionAvailable(this, this._currentURI, UpdateType.NEWS, "", UpdateMethod.HTTP, null, newVer, "");
                this._isNewer = true;
                this.checkForUpdates();
            } else if (this._log.shouldLog(40)) {
                this._log.error("Failed to copy the news file!");
            }
        } else if (this._log.shouldLog(30)) {
            this._log.warn("Transfer complete, but no file? - probably 304 Not Modified");
        }
        this._success = true;
    }

    @Override
    public void transferFailed(String url, long bytesTransferred, long bytesRemaining, int currentAttempt) {
    }

    private File processSU3() throws IOException {
        SU3File su3 = new SU3File((I2PAppContext)this._context, this._tempFile);
        File to1 = new File(this._context.getTempDir(), "tmp-" + this._context.random().nextInt() + ".xml");
        File to2 = new File(this._context.getTempDir(), "tmp2-" + this._context.random().nextInt() + ".xml");
        try {
            List<CRLEntry> crlEntries;
            NewsManager nmgr;
            File xml;
            su3.verifyAndMigrate(to1);
            int type = su3.getFileType();
            if (su3.getContentType() != 4) {
                throw new IOException("bad content type: " + su3.getContentType());
            }
            if (type == 2) {
                File file = to1;
                return file;
            }
            if (type != 1 && type != 3) {
                throw new IOException("bad file type: " + type);
            }
            if (type == 3) {
                NewsFetcher.gunzip(to1, to2);
                xml = to2;
                to1.delete();
            } else {
                xml = to1;
            }
            NewsXMLParser parser = new NewsXMLParser((I2PAppContext)this._context);
            Node root = parser.parse(xml);
            xml.delete();
            NewsMetadata data = parser.getMetadata();
            List<NewsEntry> entries = parser.getEntries();
            ClientAppManager cmgr = this._context.clientAppManager();
            if (cmgr != null && (nmgr = (NewsManager)cmgr.getRegisteredApp("news")) != null) {
                nmgr.addEntries(entries);
                List<Node> nodes = NewsXMLParser.getNodes(root, "entry");
                nmgr.storeEntries(nodes);
            }
            if ((crlEntries = parser.getCRLEntries()) != null) {
                this.persistCRLEntries(crlEntries);
            } else {
                this._log.info("No CRL entries found in news feed");
            }
            BlocklistEntries ble = parser.getBlocklistEntries();
            if (ble != null && ble.isVerified()) {
                this.processBlocklistEntries(ble);
            } else {
                this._log.info("No blocklist entries found in news feed");
            }
            String sudVersion = su3.getVersionString();
            String signingKeyName = su3.getSignerString();
            File to3 = new File(this._context.getTempDir(), "tmp3-" + this._context.random().nextInt() + ".xml");
            this.outputOldNewsXML(data, entries, sudVersion, signingKeyName, to3);
            File file = to3;
            return file;
        }
        finally {
            to2.delete();
        }
    }

    private static void gunzip(File from, File to) throws IOException {
        ReusableGZIPInputStream in = ReusableGZIPInputStream.acquire();
        OutputStream out = null;
        try {
            in.initialize((InputStream)new FileInputStream(from));
            out = new SecureFileOutputStream(to);
            DataHelper.copy((InputStream)in, (OutputStream)out);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
            ReusableGZIPInputStream.release((ReusableGZIPInputStream)in);
        }
    }

    private void persistCRLEntries(List<CRLEntry> entries) {
        SecureFile dir = new SecureFile(this._context.getConfigDir(), "certificates");
        if (!dir.exists() && !dir.mkdir()) {
            this._log.error("Failed to create CRL directory " + dir);
            return;
        }
        if (!(dir = new SecureFile((File)dir, "revocations")).exists() && !dir.mkdir()) {
            this._log.error("Failed to create CRL directory " + dir);
            return;
        }
        int i = 0;
        for (CRLEntry e : entries) {
            File f;
            block22: {
                if (e.id == null || e.data == null) {
                    if (!this._log.shouldWarn()) continue;
                    this._log.warn("Bad CRL entry received");
                    continue;
                }
                byte[] bid = DataHelper.getUTF8((String)e.id);
                byte[] hash = new byte[32];
                this._context.sha().calculateHash(bid, 0, bid.length, hash, 0);
                String name = "crl-" + Base64.encode((byte[])hash) + ".crl";
                f = new File((File)dir, name);
                if (f.exists() && f.lastModified() >= e.updated) continue;
                OutputStream out = null;
                try {
                    byte[] data = DataHelper.getUTF8((String)e.data);
                    CertUtil.loadCRL((InputStream)new ByteArrayInputStream(data));
                    out = new SecureFileOutputStream(f);
                    out.write(data);
                }
                catch (GeneralSecurityException gse) {
                    this._log.error("Bad CRL", (Throwable)gse);
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block22;
                }
                catch (IOException ioe) {
                    try {
                        this._log.error("Failed to write CRL", (Throwable)ioe);
                        break block22;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        if (out != null) {
                            try {
                                out.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
                if (out == null) break block22;
                try {
                    out.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            f.setLastModified(e.updated);
            ++i;
        }
        if (i > 0) {
            this._log.logAlways(30, "Stored " + i + " new CRL " + (i > 1 ? "entries" : "entry"));
        }
    }

    private void processBlocklistEntries(BlocklistEntries ble) {
        boolean fail;
        Object f;
        block29: {
            byte[] ip;
            Hash h;
            byte[] b;
            long oldTime = this._context.getProperty(PROP_BLOCKLIST_TIME, 0L);
            if (ble.updated <= oldTime) {
                if (this._log.shouldWarn()) {
                    this._log.warn("Not processing blocklist " + new Date(ble.updated) + ", already have " + new Date(oldTime));
                }
                return;
            }
            Blocklist bl = this._context.blocklist();
            Banlist ban = this._context.banlist();
            String reason = "Blocklist feed " + new Date(ble.updated);
            int banned = 0;
            Iterator<String> iter = ble.entries.iterator();
            while (iter.hasNext()) {
                String s = iter.next();
                if (s.length() == 44) {
                    b = Base64.decode((String)s);
                    if (b == null || b.length != 32) {
                        iter.remove();
                        continue;
                    }
                    h = Hash.create((byte[])b);
                    if (!ban.isBanlistedForever(h)) {
                        ban.banlistRouterForever(h, reason);
                    }
                } else {
                    ip = Addresses.getIP((String)s);
                    if (ip == null) {
                        iter.remove();
                        continue;
                    }
                    if (!bl.isBlocklisted(ip)) {
                        bl.add(ip);
                    }
                }
                if (++banned >= 2000) break;
            }
            for (String s : ble.removes) {
                if (s.length() == 44) {
                    b = Base64.decode((String)s);
                    if (b == null || b.length != 32 || !ban.isBanlistedForever(h = Hash.create((byte[])b))) continue;
                    ban.unbanlistRouter(h);
                    continue;
                }
                ip = Addresses.getIP((String)s);
                if (ip == null || !bl.isBlocklisted(ip)) continue;
                bl.remove(ip);
            }
            f = new SecureFile(this._context.getConfigDir(), BLOCKLIST_DIR);
            ((File)f).mkdirs();
            f = new File((File)f, BLOCKLIST_FILE);
            fail = false;
            BufferedWriter out = null;
            try {
                try {
                    out = new BufferedWriter(new OutputStreamWriter((OutputStream)new SecureFileOutputStream((File)f), "UTF-8"));
                    out.write("# ");
                    out.write(ble.supdated);
                    out.newLine();
                    banned = 0;
                    for (String s : ble.entries) {
                        s = s.replace(':', ';');
                        out.write(reason);
                        out.write(58);
                        out.write(s);
                        out.newLine();
                        if (++banned < 2000) {
                            continue;
                        }
                        break;
                    }
                }
                catch (IOException ioe) {
                    this._log.error("Error writing blocklist", (Throwable)ioe);
                    fail = true;
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block29;
                }
            }
            catch (Throwable throwable) {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        if (!fail) {
            ((File)f).setLastModified(ble.updated);
            String upd = Long.toString(ble.updated);
            this._context.router().saveConfig(PROP_BLOCKLIST_TIME, upd);
            this._mgr.notifyVersionAvailable(this, this._currentURI, UpdateType.BLOCKLIST, "", UpdateMethod.HTTP, null, upd, "");
        }
        if (this._log.shouldWarn()) {
            this._log.warn("Processed " + ble.entries.size() + " blocks and " + ble.removes.size() + " unblocks from news feed");
        }
    }

    private void outputOldNewsXML(NewsMetadata data, List<NewsEntry> entries, String sudVersion, String signingKeyName, File to) throws IOException {
        NewsMetadata.Release latestRelease = data.releases.get(0);
        Writer out = null;
        try {
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new SecureFileOutputStream(to), "UTF-8"));
            out.write("<!--\n");
            out.write(VERSION_PREFIX);
            if (latestRelease.i2pVersion != null) {
                out.write(" version=\"" + latestRelease.i2pVersion + '\"');
            }
            if (latestRelease.minVersion != null) {
                out.write(" minVersion=\"" + latestRelease.minVersion + '\"');
            }
            if (latestRelease.minJavaVersion != null) {
                out.write(" minJavaVersion=\"" + latestRelease.minJavaVersion + '\"');
            }
            String su3Torrent = "";
            String su2Torrent = "";
            for (NewsMetadata.Update update : latestRelease.updates) {
                if (update.torrent == null) continue;
                if ("su3".equals(update.type)) {
                    su3Torrent = update.torrent;
                    continue;
                }
                if (!"su2".equals(update.type)) continue;
                su2Torrent = update.torrent;
            }
            if (!su2Torrent.isEmpty()) {
                out.write(" su2Torrent=\"" + su2Torrent + '\"');
            }
            if (!su3Torrent.isEmpty()) {
                out.write(" su3Torrent=\"" + su3Torrent + '\"');
            }
            out.write("/>\n");
            out.write("** News version:\t" + DataHelper.stripHTML((String)sudVersion) + '\n');
            out.write("** Signed by:\t" + signingKeyName + '\n');
            out.write("** Feed:\t" + DataHelper.stripHTML((String)data.feedTitle) + '\n');
            out.write("** Feed ID:\t" + DataHelper.stripHTML((String)data.feedID) + '\n');
            out.write("** Feed Date:\t" + new Date(data.feedUpdated) + '\n');
            out.write("-->\n");
            if (entries == null) {
                return;
            }
            for (NewsEntry e : entries) {
                if (e.title == null || e.content == null) continue;
                out.write("<!-- Entry Date: " + e.updated + " -->\n");
                out.write("<h3>");
                out.write(DataHelper.formatDate((long)e.updated));
                out.write(": ");
                out.write(e.title);
                out.write("</h3>\n");
                out.write(e.content);
                out.write("\n\n");
            }
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

