/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.update;

import java.io.File;
import java.net.URI;
import java.util.List;
import net.i2p.I2PAppContext;
import net.i2p.router.RouterContext;
import net.i2p.router.update.ConsoleUpdateManager;
import net.i2p.router.update.UpdateRunner;
import net.i2p.router.web.ConfigUpdateHandler;
import net.i2p.update.UpdateType;
import net.i2p.util.EepGet;
import net.i2p.util.RFC822Date;

class UnsignedUpdateRunner
extends UpdateRunner {
    public UnsignedUpdateRunner(RouterContext ctx, ConsoleUpdateManager mgr, List<URI> uris) {
        super(ctx, mgr, UpdateType.ROUTER_UNSIGNED, uris);
        if (!uris.isEmpty()) {
            this._currentURI = uris.get(0);
        }
    }

    @Override
    protected void update() {
        String proxyHost = this._context.getProperty("router.updateProxyHost", "127.0.0.1");
        int proxyPort = ConfigUpdateHandler.proxyPort((I2PAppContext)this._context);
        if (proxyPort == 4444 && proxyHost.equals("127.0.0.1") && this._context.portMapper().getPort("HTTP") < 0) {
            String msg = this._t("HTTP client proxy tunnel must be running");
            if (this._log.shouldWarn()) {
                this._log.warn(msg);
            }
            this.updateStatus("<b>" + msg + "</b>");
            this._mgr.notifyTaskFailed(this, msg, null);
            return;
        }
        String zipURL = this._currentURI.toString();
        if (this._log.shouldLog(10)) {
            this._log.debug("Starting unsigned update URL: " + zipURL);
        }
        try {
            this._get = new EepGet((I2PAppContext)this._context, proxyHost, proxyPort, 40, this._updateFile, zipURL, false);
            this._get.addStatusListener((EepGet.StatusListener)this);
            this._get.fetch(55000L, -1L, 300000L);
        }
        catch (Throwable t) {
            this._log.error("Error updating", t);
        }
        if (!this.done) {
            this._mgr.notifyTaskFailed(this, "", null);
        }
    }

    @Override
    public void transferComplete(long alreadyTransferred, long bytesTransferred, long bytesRemaining, String url, String outputFile, boolean notModified) {
        String lastmod = this._get.getLastModified();
        File tmp = new File(this._updateFile);
        long modtime = RFC822Date.parse822Date((String)lastmod);
        if (modtime <= 0L) {
            modtime = this._context.clock().now();
        }
        if (this._mgr.notifyComplete(this, Long.toString(modtime), tmp)) {
            this.done = true;
        } else {
            tmp.delete();
        }
    }
}

