/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.update;

import java.net.URI;
import java.util.List;
import net.i2p.router.RouterContext;
import net.i2p.router.update.ConsoleUpdateManager;
import net.i2p.router.update.UpdateRunner;
import net.i2p.update.UpdateMethod;
import net.i2p.update.UpdateTask;
import net.i2p.update.UpdateType;
import net.i2p.update.Updater;

class UpdateHandler
implements Updater {
    protected final RouterContext _context;
    protected final ConsoleUpdateManager _mgr;

    public UpdateHandler(RouterContext ctx, ConsoleUpdateManager mgr) {
        this._context = ctx;
        this._mgr = mgr;
    }

    public UpdateTask update(UpdateType type, UpdateMethod method, List<URI> updateSources, String id, String newVersion, long maxTime) {
        boolean shouldProxy = this._context.getProperty("router.updateThroughProxy", true);
        if (type != UpdateType.ROUTER_SIGNED && type != UpdateType.ROUTER_SIGNED_SU3 || shouldProxy && method != UpdateMethod.HTTP || !shouldProxy && method != UpdateMethod.HTTP_CLEARNET && method != UpdateMethod.HTTPS_CLEARNET || updateSources.isEmpty()) {
            return null;
        }
        UpdateRunner update = new UpdateRunner(this._context, this._mgr, type, method, updateSources);
        this._mgr.notifyProgress(update, "<b>" + this._mgr._t("Updating I2P") + "</b>");
        return update;
    }
}

