/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.i2p.router.RouterContext;
import net.i2p.router.util.RouterPasswordManager;

public class ConsolePasswordManager
extends RouterPasswordManager {
    private static final String PROP_MIGRATED = "routerconsole.passwordManager.migrated";
    private static final String PROP_CONSOLE_OLD = "consolePassword";
    private static final String CONSOLE_USER = "admin";

    public ConsolePasswordManager(RouterContext ctx) {
        super(ctx);
        this.migrateConsole();
    }

    public boolean checkMD5(String realm, String subrealm, String user, String pw) {
        String hex;
        String pfx = realm;
        if (user != null && user.length() > 0) {
            pfx = String.valueOf(pfx) + '.' + user;
        }
        if ((hex = this._context.getProperty(String.valueOf(pfx) + ".md5")) == null) {
            return false;
        }
        return hex.equals(ConsolePasswordManager.md5Hex((String)subrealm, (String)user, (String)pw));
    }

    public Map<String, String> getMD5(String realm) {
        String pfx = String.valueOf(realm) + '.';
        HashMap<String, String> rv = new HashMap<String, String>(4);
        for (Map.Entry e : this._context.router().getConfigMap().entrySet()) {
            String prop = (String)e.getKey();
            if (!prop.startsWith(pfx) || !prop.endsWith(".md5")) continue;
            String user = prop.substring(0, prop.length() - ".md5".length()).substring(pfx.length());
            String hex = (String)e.getValue();
            if (user.length() <= 0 || hex.length() != 32) continue;
            rv.put(user, hex);
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean migrateConsole() {
        Class<ConsolePasswordManager> clazz = ConsolePasswordManager.class;
        synchronized (ConsolePasswordManager.class) {
            block6: {
                if (!this._context.getBooleanProperty(PROP_MIGRATED)) break block6;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return true;
            }
            String pw = this._context.getProperty(PROP_CONSOLE_OLD);
            if (pw != null) {
                HashMap<String, String> toAdd = new HashMap<String, String>(2);
                if (pw.length() > 0) {
                    this.saveMD5("routerconsole.auth.i2prouter", "i2prouter", CONSOLE_USER, pw);
                    toAdd.put("routerconsole.auth.enable", "true");
                }
                toAdd.put(PROP_MIGRATED, "true");
                List<String> toDel = Collections.singletonList(PROP_CONSOLE_OLD);
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this._context.router().saveConfig(toAdd, toDel);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return true;
        }
    }

    public boolean saveMD5(String realm, String subrealm, String user, String pw) {
        String hex;
        String pfx = realm;
        if (user != null && user.length() > 0) {
            pfx = String.valueOf(pfx) + '.' + user;
        }
        if ((hex = ConsolePasswordManager.md5Hex((String)subrealm, (String)user, (String)pw)) == null) {
            return false;
        }
        Map<String, String> toAdd = Collections.singletonMap(String.valueOf(pfx) + ".md5", hex);
        ArrayList<String> toDel = new ArrayList<String>(4);
        toDel.add(String.valueOf(pfx) + ".password");
        toDel.add(String.valueOf(pfx) + ".b64");
        toDel.add(String.valueOf(pfx) + ".crypt");
        toDel.add(String.valueOf(pfx) + ".shash");
        return this._context.router().saveConfig(toAdd, toDel);
    }
}

