/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.io.File;
import java.util.Locale;
import net.i2p.router.web.HelperBase;
import net.i2p.util.FileUtil;

public class ContentHelper
extends HelperBase {
    protected String _page;
    private int _maxLines;
    private boolean _startAtBeginning;
    private String _lang;

    public void setPage(String page) {
        this._page = page;
    }

    public void setStartAtBeginning(String moo) {
        this._startAtBeginning = Boolean.parseBoolean(moo);
    }

    public void setLang(String l) {
    }

    public void setMaxLines(String lines) {
        if (lines != null) {
            try {
                this._maxLines = Integer.parseInt(lines);
            }
            catch (NumberFormatException nfe) {
                this._maxLines = -1;
            }
        } else {
            this._maxLines = -1;
        }
    }

    public String getContent() {
        String str = FileUtil.readTextFile((String)this.filename(), (int)this._maxLines, (boolean)this._startAtBeginning);
        if (str == null) {
            return "";
        }
        return str;
    }

    public String getTextContent() {
        String str = FileUtil.readTextFile((String)this.filename(), (int)this._maxLines, (boolean)this._startAtBeginning);
        if (str == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder(str.length() + 11);
        sb.append("<pre>");
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            switch (str.charAt(i)) {
                case '<': {
                    sb.append("&lt;");
                    break;
                }
                case '>': {
                    sb.append("&gt;");
                    break;
                }
                case '&': {
                    sb.append("&amp;");
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
            ++i;
        }
        return sb.append("</pre>").toString();
    }

    private String filename() {
        int lastdot = this._page.lastIndexOf(46);
        if (lastdot <= 0) {
            return this._page;
        }
        String lang = this._lang;
        if (lang == null || lang.length() <= 0) {
            if (this._context != null) {
                lang = this._context.getProperty("routerconsole.lang");
            }
            if (!(lang != null && lang.length() > 0 || (lang = Locale.getDefault().getLanguage()) != null && lang.length() > 0)) {
                return this._page;
            }
        }
        if (lang.equals("en")) {
            return this._page;
        }
        String newname = String.valueOf(this._page.substring(0, lastdot)) + '_' + lang + this._page.substring(lastdot);
        File newfile = new File(newname);
        if (newfile.exists()) {
            return newname;
        }
        return this._page;
    }
}

