/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web.helpers;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import net.i2p.data.DataHelper;
import net.i2p.router.networkdb.kademlia.FloodfillNetworkDatabaseFacade;
import net.i2p.router.web.FormHandler;

public class ConfigAdvancedHandler
extends FormHandler {
    private boolean _shouldSave;
    private String _oldConfig;
    private String _config;
    private String _ff;

    @Override
    protected void processForm() {
        if (this._shouldSave) {
            if ("ff".equals(this._action) && this._ff != null) {
                this.saveFF();
            } else if (this.isAdvanced()) {
                this.saveChanges();
            } else {
                this.addFormError("Save disabled, edit the router.config file to make changes");
            }
        }
    }

    public void setShouldsave(String moo) {
        this._shouldSave = true;
    }

    public void setFf(String ff) {
        this._ff = ff;
    }

    public void setNofilter_config(String val) {
        this._config = val;
    }

    public void setNofilter_oldConfig(String val) {
        this._oldConfig = val;
    }

    private void saveChanges() {
        if (this._oldConfig != null && this._config != null) {
            Properties oldProps = new Properties();
            Properties props = new Properties();
            try {
                DataHelper.loadProps((Properties)oldProps, (InputStream)new ByteArrayInputStream(DataHelper.getUTF8((String)this._oldConfig)));
                DataHelper.loadProps((Properties)props, (InputStream)new ByteArrayInputStream(DataHelper.getUTF8((String)this._config)));
            }
            catch (IOException ioe) {
                this._log.error("Config error", (Throwable)ioe);
                this.addFormError(ioe.toString());
                this.addFormError(this._t("Error updating the configuration - please see the error logs"));
                return;
            }
            HashSet<String> unsetKeys = new HashSet<String>(oldProps.stringPropertyNames());
            Iterator<Map.Entry<Object, Object>> iter = props.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<Object, Object> e = iter.next();
                String key = (String)e.getKey();
                String nnew = (String)e.getValue();
                String old = oldProps.getProperty(key);
                unsetKeys.remove(key);
                if (!nnew.equals(old)) continue;
                iter.remove();
            }
            boolean saved = this._context.router().saveConfig((Map)props, unsetKeys);
            if (saved) {
                this.addFormNotice(this._t("Configuration saved successfully"));
            } else {
                this.addFormError(this._t("Error saving the configuration (applied but not saved) - please see the error logs"));
            }
        }
    }

    private void saveFF() {
        boolean saved = this._context.router().saveConfig("router.floodfillParticipant", this._ff);
        if (this._ff.equals("false") || this._ff.equals("true")) {
            FloodfillNetworkDatabaseFacade fndf = (FloodfillNetworkDatabaseFacade)this._context.netDb();
            boolean isFF = this._ff.equals("true");
            fndf.setFloodfillEnabled(isFF);
        }
        if (saved) {
            this.addFormNotice(this._t("Configuration saved successfully"));
        } else {
            this.addFormError(this._t("Error saving the configuration (applied but not saved) - please see the error logs"));
        }
    }
}

