/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web.helpers;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.i2p.data.DataHelper;
import net.i2p.router.web.HelperBase;

public class ConfigAdvancedHelper
extends HelperBase {
    static final String PROP_FLOODFILL_PARTICIPANT = "router.floodfillParticipant";
    private static final String PROP_AUTH_PFX = "routerconsole.auth.i2prouter.";
    private static final Set<String> _hideKeys;

    static {
        String[] keys = new String[]{"i2cp.keyPassword", "i2cp.keystorePassword", "i2np.ntcp2.sp", "netdb.family.keyPassword", "netdb.family.keystorePassword", "router.inboundPool.randomKey", "router.outboundPool.randomKey", "router.reseedProxy.password", "router.reseedSSLProxy.password", "routerconsole.keyPassword", "routerconsole.keystorePassword"};
        _hideKeys = new HashSet<String>(Arrays.asList(keys));
    }

    public String getSettings() {
        StringBuilder buf = new StringBuilder(4096);
        TreeMap sorted = new TreeMap();
        sorted.putAll(this._context.router().getConfigMap());
        boolean adv = this.isAdvanced();
        for (Map.Entry e : sorted.entrySet()) {
            String key = (String)e.getKey();
            if (!adv && (_hideKeys.contains(key) || key.startsWith("i2cp.auth.") || key.startsWith(PROP_AUTH_PFX))) continue;
            String name = DataHelper.escapeHTML((String)key);
            String val = DataHelper.escapeHTML((String)((String)e.getValue()));
            buf.append(name).append('=').append(val).append('\n');
        }
        return buf.toString();
    }

    public String getConfigFileName() {
        return this._context.router().getConfigFilename();
    }

    public String getFFChecked(int mode) {
        String ff = this._context.getProperty(PROP_FLOODFILL_PARTICIPANT, "auto");
        if (mode == 0 && ff.equals("false") || mode == 1 && ff.equals("true") || mode == 2 && ff.equals("auto")) {
            return " checked=\"checked\" ";
        }
        return "";
    }

    public boolean isFloodfill() {
        return this._context.netDb().floodfillEnabled();
    }
}

