/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web.helpers;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.i2p.crypto.CertUtil;
import net.i2p.crypto.KeyStoreUtil;
import net.i2p.router.web.FormHandler;
import net.i2p.util.SecureDirectory;

public class ConfigFamilyHandler
extends FormHandler {
    @Override
    protected void processForm() {
        if (this._action.equals(this._t("Create Family"))) {
            String family = this.getJettyString("family");
            String old = this._context.getProperty("netdb.family.name");
            if (family == null || family.trim().length() <= 0) {
                this.addFormError(this._t("You must enter a family name"));
            } else if (old != null) {
                this.addFormError("Family already configured: " + family);
            } else if (family.contains("/") || family.contains("\\")) {
                this.addFormError("Bad characters in Family: " + family);
            } else if (family.length() > 32) {
                this.addFormError("Family too long, 32 chars max: " + family);
            } else if (this._context.router().saveConfig("netdb.family.name", family.trim())) {
                this.addFormNotice(this._t("Configuration saved successfully."));
                this.addFormError(this._t("Restart required to take effect"));
            } else {
                this.addFormError(this._t("Error saving the configuration (applied but not saved) - please see the error logs"));
            }
        } else if (this._action.equals(this._t("Join Family"))) {
            InputStream in = this._requestWrapper.getInputStream("file");
            try {
                if (in == null || in.available() <= 0) {
                    this.addFormError(this._t("You must enter a file"));
                    return;
                }
                try {
                    Object ks;
                    PrivateKey pk = CertUtil.loadPrivateKey((InputStream)in);
                    List certs = CertUtil.loadCerts((InputStream)in);
                    String family = CertUtil.getSubjectValue((X509Certificate)((X509Certificate)certs.get(0)), (String)"CN");
                    if (family == null) {
                        this.addFormError("Bad certificate - No Subject CN");
                    }
                    if (family.endsWith(".family.i2p.net") && family.length() > ".family.i2p.net".length()) {
                        family = family.substring(0, family.length() - ".family.i2p.net".length());
                    }
                    if (!((File)(ks = new SecureDirectory(this._context.getConfigDir(), "keystore"))).exists()) {
                        ((File)ks).mkdirs();
                    }
                    ks = new File((File)ks, "family-" + family + ".ks");
                    String keypw = KeyStoreUtil.randomString();
                    KeyStoreUtil.storePrivateKey((File)ks, (String)"changeit", (String)family, (String)keypw, (PrivateKey)pk, (List)certs);
                    Object cf = new SecureDirectory(this._context.getConfigDir(), "certificates");
                    if (!cf.exists()) {
                        cf.mkdirs();
                    }
                    cf = new SecureDirectory((File)cf, "family");
                    if (!((File)ks).exists()) {
                        ((File)ks).mkdirs();
                    }
                    cf = new File((File)cf, String.valueOf(family) + ".crt");
                    KeyStoreUtil.exportCert((File)ks, (String)"changeit", (String)family, (File)cf);
                    HashMap<String, String> changes = new HashMap<String, String>();
                    changes.put("netdb.family.name", family);
                    changes.put("netdb.family.keyPassword", keypw);
                    changes.put("netdb.family.keystorePassword", "changeit");
                    if (this._context.router().saveConfig(changes, null)) {
                        this.addFormNotice("Family key configured for router family: " + family);
                        this.addFormError(this._t("Restart required to take effect"));
                    }
                    this.addFormError(this._t("Error saving the configuration (applied but not saved) - please see the error logs"));
                }
                catch (GeneralSecurityException gse) {
                    this.addFormError(String.valueOf(this._t("Load from file failed")) + " - " + gse);
                }
                catch (IOException ioe) {
                    this.addFormError(String.valueOf(this._t("Load from file failed")) + " - " + ioe);
                }
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        } else if (this._action.equals(this._t("Leave Family"))) {
            ArrayList<String> removes = new ArrayList<String>();
            removes.add("netdb.family.name");
            removes.add("netdb.family.keyPassword");
            removes.add("netdb.family.keystorePassword");
            if (this._context.router().saveConfig(null, removes)) {
                this.addFormNotice(this._t("Configuration saved successfully."));
                this.addFormError(this._t("Restart required to take effect"));
            } else {
                this.addFormError(this._t("Error saving the configuration (applied but not saved) - please see the error logs"));
            }
        }
    }
}

