/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web.helpers;

import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import net.i2p.data.BlindData;
import net.i2p.data.DataHelper;
import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.data.PrivateKey;
import net.i2p.data.SessionKey;
import net.i2p.router.TunnelPoolSettings;
import net.i2p.router.web.HelperBase;

public class ConfigKeyringHelper
extends HelperBase {
    public String getSummary() {
        StringWriter sw = new StringWriter(4096);
        try {
            this.renderStatusHTML(sw);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return sw.toString();
    }

    private void renderStatusHTML(StringWriter out) throws IOException {
        StringBuilder buf = new StringBuilder(1024);
        buf.append("<h3>").append(this._t("Local encrypted destinations")).append("</h3>");
        boolean rv1 = this.render(buf, true);
        buf.append("<h3>").append(this._t("Remote encrypted destinations")).append("</h3>");
        boolean rv2 = this.render(buf, false);
        if (rv1 || rv2) {
            buf.append("\n<table id=\"addkeyring\"><tr><td align=\"right\"><input type=\"reset\" class=\"cancel\" value=\"").append(this._t("Cancel")).append("\"><input type=\"submit\" name=\"action\" class=\"delete\" value=\"").append(this._t("Delete key")).append("\"></td></tr></table>");
        }
        out.write(buf.toString());
        out.flush();
    }

    private boolean render(StringBuilder buf, boolean local) {
        String b32;
        boolean rv = false;
        buf.append("\n<table class=\"configtable\"><tr>");
        if (!local) {
            buf.append("<th align=\"left\">").append(this._t("Delete"));
        }
        buf.append("<th align=\"left\">").append(this._t("Destination")).append("<th align=\"left\">").append(this._t("Name"));
        if (!local) {
            buf.append("<th align=\"left\">").append(this._t("Type"));
        }
        buf.append("<th align=\"left\">").append(this._t("Encryption Key"));
        if (!local) {
            buf.append("<th align=\"left\">").append(this._t("Lookup Password"));
            buf.append("<th align=\"left\">").append(this._t("Created"));
            buf.append("<th align=\"left\">").append(this._t("Expires"));
        }
        buf.append("</tr>");
        for (Map.Entry e : this._context.keyRing().entrySet()) {
            Hash h = (Hash)e.getKey();
            if (local != this._context.clientManager().isLocal(h)) continue;
            buf.append("\n<tr><td>");
            b32 = h.toBase32();
            if (!local) {
                buf.append("<input value=\"").append(b32).append("\" type=\"checkbox\" name=\"revokeClient\" class=\"tickbox\"/></td><td>");
            }
            buf.append(b32);
            buf.append("</td><td>");
            Destination dest = this._context.netDb().lookupDestinationLocally(h);
            if (dest != null && local) {
                TunnelPoolSettings in = this._context.tunnelManager().getInboundSettings(h);
                if (in != null && in.getDestinationNickname() != null) {
                    buf.append(in.getDestinationNickname());
                }
            } else {
                String host = this._context.namingService().reverseLookup(h);
                if (host != null) {
                    buf.append(host);
                }
            }
            buf.append("</td><td>");
            if (!local) {
                buf.append(this._t("Encrypted")).append(" (AES)</td><td>");
            }
            SessionKey sk = (SessionKey)e.getValue();
            buf.append(sk.toBase64());
            if (!local) {
                buf.append("</td><td></td><td></td><td>");
            }
            buf.append("</td></tr>\n");
            rv = true;
        }
        if (!local) {
            List bdata = this._context.netDb().getBlindData();
            if (bdata.size() > 1) {
                Collections.sort(bdata, new BDComparator());
            }
            for (BlindData bd : bdata) {
                String host;
                buf.append("\n<tr><td>");
                b32 = bd.toBase32();
                if (!local) {
                    buf.append("<input value=\"").append(b32).append("\" type=\"checkbox\" name=\"revokeClient\" class=\"tickbox\"/></td><td>");
                }
                buf.append(b32);
                buf.append("</td><td>");
                Hash h = bd.getDestHash();
                if (h != null && (host = this._context.namingService().reverseLookup(h)) != null) {
                    buf.append(host);
                }
                buf.append("</td><td>");
                int type = bd.getAuthType();
                PrivateKey pk = bd.getAuthPrivKey();
                String secret = bd.getSecret();
                String s = type == 1 ? (secret != null ? String.valueOf(this._t("Encrypted with lookup password")) + " (DH)" : String.valueOf(this._t("Encrypted")) + " (DH)") : (type == 3 ? (secret != null ? String.valueOf(this._t("Encrypted with lookup password")) + " (PSK)" : String.valueOf(this._t("Encrypted")) + " (PSK)") : (secret != null ? this._t("Blinded with lookup password") : this._t("Blinded")));
                buf.append(s);
                buf.append("</td><td>");
                if (pk != null) {
                    if (type == 1) {
                        buf.append(pk.toPublic().toBase64());
                    } else {
                        buf.append(pk.toBase64());
                    }
                }
                buf.append("</td><td>");
                if (secret != null) {
                    buf.append(secret);
                }
                buf.append("</td><td>");
                long t = bd.getDate();
                if (t > 0L) {
                    buf.append(DataHelper.formatDate((long)t));
                }
                buf.append("</td><td>");
                t = bd.getExpiration();
                if (t > 0L) {
                    buf.append(DataHelper.formatDate((long)t));
                }
                buf.append("</td></tr>");
                rv = true;
            }
        }
        if (!rv) {
            buf.append("<tr><td align=\"center\" colspan=\"").append(local ? (char)'3' : '8').append("\"><i>").append(this._t("none")).append("</i></td></tr>");
        }
        buf.append("</table>\n");
        return rv;
    }

    private static class BDComparator
    implements Comparator<BlindData>,
    Serializable {
        private BDComparator() {
        }

        @Override
        public int compare(BlindData l, BlindData r) {
            return l.toBase32().compareTo(r.toBase32());
        }
    }
}

