/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web.helpers;

import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.router.RouterContext;
import net.i2p.router.web.ConfigServiceHandler;
import net.i2p.router.web.ContextHelper;
import net.i2p.router.web.Messages;
import net.i2p.util.RandomSource;

public class ConfigRestartBean {
    private static final String[] SET1 = new String[]{"shutdownImmediate", "stop", "Shutdown immediately", "cancelShutdown", "cancel", "Cancel shutdown"};
    private static final String[] SET2 = new String[]{"restartImmediate", "reload", "Restart immediately", "cancelShutdown", "cancel", "Cancel restart"};
    private static final String[] SET3 = new String[]{"restart", "reload", "Restart", "shutdown", "stop", "Shutdown"};
    private static final String[] SET4 = new String[]{"shutdown", "stop", "Shutdown"};
    private static final String _systemNonce = Long.toString(RandomSource.getInstance().nextLong());

    public static String getNonce() {
        return _systemNonce;
    }

    public static String renderStatus(String urlBase, String action, String nonce) {
        RouterContext ctx = ContextHelper.getContext(null);
        String systemNonce = ConfigRestartBean.getNonce();
        if (nonce != null && systemNonce.equals(nonce) && action != null) {
            if ("shutdownImmediate".equals(action) || ConfigRestartBean._t("Shutdown immediately", ctx).equals(action)) {
                if (ctx.hasWrapper()) {
                    ConfigServiceHandler.registerWrapperNotifier(ctx, 3, false);
                }
                ctx.router().shutdownGracefully(3);
            } else if ("cancelShutdown".equals(action) || ConfigRestartBean._t("Cancel shutdown", ctx).equals(action) || ConfigRestartBean._t("Cancel restart", ctx).equals(action)) {
                ctx.router().cancelGracefulShutdown();
            } else if ("restartImmediate".equals(action) || ConfigRestartBean._t("Restart immediately", ctx).equals(action)) {
                if (ctx.hasWrapper()) {
                    ConfigServiceHandler.registerWrapperNotifier(ctx, 4, false);
                }
                ctx.router().shutdownGracefully(4);
            } else if ("restart".equals(action) || ConfigRestartBean._t("Restart", ctx).equals(action)) {
                if (ctx.hasWrapper()) {
                    ConfigServiceHandler.registerWrapperNotifier(ctx, 5, false);
                }
                ctx.router().shutdownGracefully(5);
            } else if ("shutdown".equals(action) || ConfigRestartBean._t("Shutdown", ctx).equals(action)) {
                if (ctx.hasWrapper()) {
                    ConfigServiceHandler.registerWrapperNotifier(ctx, 2, false);
                }
                ctx.router().shutdownGracefully();
            }
        }
        boolean shuttingDown = ConfigRestartBean.isShuttingDown(ctx);
        boolean restarting = ConfigRestartBean.isRestarting(ctx);
        long timeRemaining = ctx.router().getShutdownTimeRemaining();
        StringBuilder buf = new StringBuilder(128);
        if ((shuttingDown || restarting) && timeRemaining <= 5000L) {
            buf.append("<h4>");
            if (restarting) {
                buf.append(ConfigRestartBean._t("Restart imminent", ctx));
            } else {
                buf.append(ConfigRestartBean._t("Shutdown imminent", ctx));
            }
            buf.append("</h4>");
        } else if (shuttingDown) {
            buf.append("<h4>");
            buf.append(ConfigRestartBean._t("Shutdown in {0}", DataHelper.formatDuration2((long)timeRemaining), ctx));
            int tuns = ctx.tunnelManager().getParticipatingCount();
            if (tuns > 0) {
                buf.append("&hellip;<br>").append(ConfigRestartBean.ngettext("Please wait for routing commitment to expire for {0} tunnel", "Please wait for routing commitments to expire for {0} tunnels", tuns, ctx));
            }
            buf.append("</h4><hr>");
            ConfigRestartBean.buttons(ctx, buf, urlBase, systemNonce, SET1);
        } else if (restarting) {
            buf.append("<h4>");
            buf.append(ConfigRestartBean._t("Restart in {0}", DataHelper.formatDuration2((long)timeRemaining), ctx));
            int tuns = ctx.tunnelManager().getParticipatingCount();
            if (tuns > 0) {
                buf.append("&hellip;<br>").append(ConfigRestartBean.ngettext("Please wait for routing commitment to expire for {0} tunnel", "Please wait for routing commitments to expire for {0} tunnels", tuns, ctx));
            }
            buf.append("</h4><hr>");
            ConfigRestartBean.buttons(ctx, buf, urlBase, systemNonce, SET2);
        } else if (ctx.hasWrapper()) {
            ConfigRestartBean.buttons(ctx, buf, urlBase, systemNonce, SET3);
        } else {
            ConfigRestartBean.buttons(ctx, buf, urlBase, systemNonce, SET4);
        }
        return buf.toString();
    }

    private static void buttons(RouterContext ctx, StringBuilder buf, String url, String nonce, String[] s) {
        buf.append("<form action=\"").append(url).append("\" method=\"POST\">\n");
        buf.append("<input type=\"hidden\" name=\"consoleNonce\" value=\"").append(nonce).append("\" >\n");
        int i = 0;
        while (i < s.length) {
            buf.append("<button type=\"submit\" name=\"action\" value=\"").append(s[i]).append("\" class=\"").append(s[i + 1]).append("\" title=\"").append(ConfigRestartBean._t(s[i + 2], ctx)).append("\" >").append(ConfigRestartBean._t(s[i + 2], ctx)).append("</button>\n");
            i += 3;
        }
        buf.append("</form>\n");
    }

    private static boolean isShuttingDown(RouterContext ctx) {
        int code = ctx.router().scheduledGracefulExitCode();
        return 2 == code || 3 == code;
    }

    private static boolean isRestarting(RouterContext ctx) {
        int code = ctx.router().scheduledGracefulExitCode();
        return 5 == code || 4 == code;
    }

    public static long getRestartTimeRemaining() {
        RouterContext ctx = ContextHelper.getContext(null);
        if (ctx.router().gracefulShutdownInProgress()) {
            return ctx.router().getShutdownTimeRemaining();
        }
        return 0x3FFFFFFFFFFFFFFFL;
    }

    private static String _t(String s, RouterContext ctx) {
        return Messages.getString(s, (I2PAppContext)ctx);
    }

    private static String _t(String s, Object o, RouterContext ctx) {
        return Messages.getString(s, o, (I2PAppContext)ctx);
    }

    private static String ngettext(String s, String p, int n, RouterContext ctx) {
        return Messages.getString(n, s, p, (I2PAppContext)ctx);
    }
}

