/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web.helpers;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import net.i2p.data.DataHelper;
import net.i2p.router.web.FormHandler;
import net.i2p.router.web.helpers.SummaryHelper;

public class ConfigSummaryHandler
extends FormHandler {
    @Override
    protected void processForm() {
        String group = this.getJettyString("group");
        boolean deleting = this._action.equals(this._t("Delete selected"));
        boolean adding = this._action.equals(this._t("Add item"));
        boolean saving = this._action.equals(this._t("Save order"));
        boolean moving = this._action.startsWith("move_");
        if (this._action.equals(this._t("Save")) && "0".equals(group)) {
            try {
                int refreshInterval = Integer.parseInt(this.getJettyString("refreshInterval"));
                if (refreshInterval < 0) {
                    refreshInterval = 0;
                } else if (refreshInterval > 0 && refreshInterval < 3) {
                    refreshInterval = 3;
                }
                HashMap<String, String> toAdd = new HashMap<String, String>(2);
                if (refreshInterval == 0) {
                    toAdd.put("routerconsole.summaryDisableRefresh", "true");
                    toAdd.put("routerconsole.summaryRefresh", "15");
                    this._context.router().saveConfig(toAdd, null);
                    this.addFormNotice(this._t("Refresh disabled"));
                }
                toAdd.put("routerconsole.summaryDisableRefresh", "false");
                toAdd.put("routerconsole.summaryRefresh", Integer.toString(refreshInterval));
                this._context.router().saveConfig(toAdd, null);
                this.addFormNotice(this._t("Refresh interval changed"));
            }
            catch (NumberFormatException e) {
                this.addFormError(this._t("Refresh interval must be a number"));
                return;
            }
        } else if (this._action.equals(this._t("Restore full default"))) {
            this._context.router().saveConfig("routerconsole.summaryBar.default", this.isAdvanced() ? "AdvancedRouterInfo,MemoryBar,UpdateStatus,Bandwidth,NetworkReachability,FirewallAndReseedStatus,I2PServices,I2PInternals,Advanced,Peers,RestartStatus,Tunnels,TunnelStatus,Congestion,Destinations," : "RouterInfo,UpdateStatus,Bandwidth,NetworkReachability,FirewallAndReseedStatus,I2PServices,I2PInternals,HelpAndFAQ,Peers,RestartStatus,Tunnels,TunnelStatus,Destinations,");
            this.addFormNotice(String.valueOf(this._t("Full sidebar default restored.")) + " " + this._t("Sidebar will refresh shortly."));
        } else if (this._action.equals(this._t("Restore minimal default"))) {
            this._context.router().saveConfig("routerconsole.summaryBar.default", this.isAdvanced() ? "AdvancedRouterInfo,MemoryBar,Bandwidth,UpdateStatus,NewsHeadings,NetworkReachability,FirewallAndReseedStatus,RestartStatus,Destinations," : "ShortRouterInfo,Bandwidth,UpdateStatus,NewsHeadings,NetworkReachability,FirewallAndReseedStatus,RestartStatus,Destinations,");
            this.addFormNotice(String.valueOf(this._t("Minimal sidebar default restored.")) + " " + this._t("Sidebar will refresh shortly."));
        } else if (adding || deleting || saving || moving) {
            TreeMap<Integer, String> sections = new TreeMap<Integer, String>();
            for (Object o : this._settings.keySet()) {
                String k;
                if (!(o instanceof String) || !(k = (String)o).startsWith("order_")) continue;
                String v = this.getJettyString(k);
                k = k.substring(6);
                k = k.substring(k.indexOf(95) + 1);
                try {
                    int order = Integer.parseInt(v);
                    sections.put(order, k);
                }
                catch (NumberFormatException e) {
                    this.addFormError(this._t("Order must be an integer"));
                    return;
                }
            }
            if (adding) {
                String name = this.getJettyString("name");
                if (name == null || name.length() <= 0) {
                    this.addFormError(this._t("No section selected"));
                    return;
                }
                String order = this.getJettyString("order");
                if (order == null || order.length() <= 0) {
                    this.addFormError(this._t("No order entered"));
                    return;
                }
                name = DataHelper.escapeHTML((String)name).replace(",", "&#44;");
                order = DataHelper.escapeHTML((String)order).replace(",", "&#44;");
                try {
                    int ki = Integer.parseInt(order);
                    sections.put(ki, name);
                    this.addFormNotice(String.valueOf(this._t("Added")) + ": " + name);
                }
                catch (NumberFormatException e) {
                    this.addFormError(this._t("Order must be an integer"));
                    return;
                }
            }
            if (deleting) {
                HashSet<Integer> toDelete = new HashSet<Integer>();
                for (Object o : this._settings.keySet()) {
                    String k;
                    if (!(o instanceof String) || !(k = (String)o).startsWith("delete_")) continue;
                    k = k.substring(7);
                    try {
                        int ki = Integer.parseInt(k);
                        toDelete.add(ki);
                    }
                    catch (NumberFormatException ki) {
                        // empty catch block
                    }
                }
                Iterator iter = sections.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry e = iter.next();
                    Integer i = (Integer)e.getKey();
                    if (!toDelete.contains(i)) continue;
                    String removedName = (String)e.getValue();
                    iter.remove();
                    this.addFormNotice(String.valueOf(this._t("Removed")) + ": " + removedName);
                }
            } else if (moving) {
                String[] parts = DataHelper.split((String)this._action, (String)"_");
                try {
                    int from = Integer.parseInt(parts[1]);
                    int to = 0;
                    if ("up".equals(parts[2])) {
                        to = from - 1;
                    }
                    if ("down".equals(parts[2])) {
                        to = from + 1;
                    }
                    if ("bottom".equals(parts[2])) {
                        to = sections.size() - 1;
                    }
                    int n = -1;
                    if ("down".equals(parts[2]) || "bottom".equals(parts[2])) {
                        n = 1;
                    }
                    int i = from;
                    while (n * i < n * to) {
                        String temp = (String)sections.get(i + n);
                        sections.put(i + n, (String)sections.get(i));
                        sections.put(i, temp);
                        i += n;
                    }
                    this.addFormNotice(String.valueOf(this._t("Moved")) + ": " + (String)sections.get(to));
                }
                catch (NumberFormatException e) {
                    this.addFormError(this._t("Order must be an integer"));
                    return;
                }
            }
            SummaryHelper.saveSummaryBarSections(this._context, "default", sections);
            this.addFormNotice(String.valueOf(this._t("Saved order of sections.")) + " " + this._t("Sidebar will refresh shortly."));
        }
    }

    public void setMovingAction() {
        for (Object o : this._settings.keySet()) {
            String k;
            if (!(o instanceof String) || !(k = (String)o).startsWith("move_") || !k.endsWith(".x") || this._settings.get(k) == null) continue;
            this._action = k.substring(0, k.length() - 2);
            break;
        }
    }
}

