/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web.helpers;

import java.io.IOException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import net.i2p.data.DataHelper;
import net.i2p.router.util.EventLog;
import net.i2p.router.web.CSSHelper;
import net.i2p.router.web.FormHandler;

public class EventLogHelper
extends FormHandler {
    private long _from;
    private long _age;
    private String _event = "all";
    private final Map<String, String> _xevents = new HashMap<String, String>(1 + _events.length / 2);
    private static final String ALL = "all";
    private static final String[] _events = new String[]{"aborted", EventLogHelper._x("Aborted startup"), "becameFloodfill", EventLogHelper._x("Enabled floodfill"), "changeIP", EventLogHelper._x("Changed IP"), "changePort", EventLogHelper._x("Changed port"), "clockShift", EventLogHelper._x("Clock shifted"), "crashed", EventLogHelper._x("Crashed"), "critical", EventLogHelper._x("Critical error"), "installed", EventLogHelper._x("Installed new version"), "installFailed", EventLogHelper._x("Install failed"), "network", EventLogHelper._x("Network error"), "newIdent", EventLogHelper._x("New router identity"), "disabledFloodfill", EventLogHelper._x("Disabled floodfill"), "oom", EventLogHelper._x("Out of memory error"), "reachability", EventLogHelper._x("Reachability change"), "rekeyed", EventLogHelper._x("New router identity"), "reseed", EventLogHelper._x("Reseeded router"), "softRestart", EventLogHelper._x("Soft restart"), "started", EventLogHelper._x("Started router"), "stopped", EventLogHelper._x("Stopped router"), "updated", EventLogHelper._x("Updated router"), "watchdog", EventLogHelper._x("Watchdog warning")};
    private static final long DAY = 86400L;
    private static final long[] _times;

    static {
        long[] lArray = new long[6];
        lArray[1] = 86400L;
        lArray[2] = 604800L;
        lArray[3] = 2592000L;
        lArray[4] = 7776000L;
        lArray[5] = 31536000L;
        _times = lArray;
    }

    @Override
    protected void processForm() {
    }

    @Override
    public void setContextId(String contextId) {
        super.setContextId(contextId);
        int i = 0;
        while (i < _events.length) {
            this._xevents.put(_events[i], this._t(_events[i + 1]));
            i += 2;
        }
    }

    public void setFrom(String s) {
        try {
            this._age = Long.parseLong(s) * 1000L;
            this._from = this._age > 0L ? this._context.clock().now() - this._age : 0L;
        }
        catch (NumberFormatException nfe) {
            this._age = 0L;
            this._from = 0L;
        }
    }

    public void setType(String s) {
        this._event = s;
    }

    public String getForm() {
        String nonce = CSSHelper.getNonce();
        try {
            this._out.write("<br><h3 id=\"displayevents\">" + this._t("Display Events") + "</h3>");
            this._out.write("<form action=\"events\" method=\"POST\">\n<input type=\"hidden\" name=\"action\" value=\"save\">\n<input type=\"hidden\" name=\"nonce\" value=\"" + nonce + "\" >\n<b>");
            this._out.write(String.valueOf(this._t("Events since")) + ":</b> <select name=\"from\">");
            int i = 0;
            while (i < _times.length) {
                this.writeOption(_times[i]);
                ++i;
            }
            this._out.write("</select>&nbsp;<b>");
            this._out.write(String.valueOf(this._t("Event type")) + ":</b> <select name=\"type\">");
            TreeMap<Object, String> events = new TreeMap<Object, String>(Collator.getInstance());
            int i2 = 0;
            while (i2 < _events.length) {
                events.put(this._xevents.get(_events[i2]), _events[i2]);
                i2 += 2;
            }
            this.writeOption(this._t("All events"), ALL);
            for (Map.Entry e : events.entrySet()) {
                this.writeOption((String)e.getKey(), (String)e.getValue());
            }
            this._out.write("</select>&nbsp;<input type=\"submit\" class=\"accept\" value=\"" + this._t("Filter events") + "\"></form>");
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return "";
    }

    private void writeOption(String key, String val) throws IOException {
        this._out.write("<option value=\"");
        this._out.write(val);
        this._out.write("\"");
        if (val.equals(this._event)) {
            this._out.write(" selected=\"selected\" ");
        }
        this._out.write(">");
        this._out.write(key);
        this._out.write("</option>\n");
    }

    private void writeOption(long age) throws IOException {
        this._out.write("<option value=\"");
        this._out.write(Long.toString(age));
        this._out.write("\"");
        if (age == this._age / 1000L) {
            this._out.write(" selected=\"selected\" ");
        }
        this._out.write(">");
        if (age == 0L) {
            this._out.write(this._t("All events"));
        } else {
            this._out.write(DataHelper.formatDuration2((long)(age * 1000L)));
        }
        this._out.write("</option>\n");
    }

    public String getEvents() {
        EventLog ev = this._context.router().eventLog();
        boolean isAll = ALL.equals(this._event);
        SortedMap events = isAll ? ev.getEvents(this._from) : ev.getEvents(this._event, this._from);
        String xev = this._xevents.get(this._event);
        if (xev == null) {
            xev = this._event;
        }
        xev = DataHelper.escapeHTML((String)xev);
        if (events.isEmpty()) {
            if (isAll) {
                if (this._age == 0L) {
                    return "<table id=\"eventlog\"><tr><td class=\"infohelp\">" + this._t("No events found") + "</td></tr></table>";
                }
                return "<table id=\"eventlog\"><tr><td>" + this._t("No events found in previous {0}", DataHelper.formatDuration2((long)this._age)) + "</td></tr></table>";
            }
            if (this._age == 0L) {
                return "<table id=\"eventlog\"><tr><td  class=\"infohelp\">" + this._t("No \"{0}\" events found", xev) + "</td></tr></table>";
            }
            return "<table id=\"eventlog\"><tr><td class=\"infohelp\">" + this._t("No \"{0}\" events found in previous {1}", xev, DataHelper.formatDuration2((long)this._age)) + "</td></tr></table>";
        }
        StringBuilder buf = new StringBuilder(2048);
        buf.append("<table id=\"eventlog\"><tr><th>");
        buf.append(this._t("Time"));
        buf.append("</th><th>");
        if (isAll) {
            buf.append(this._t("Event"));
            buf.append("</th><th>");
            buf.append(this._t("Details"));
        } else {
            buf.append(xev);
        }
        buf.append("</th></tr>");
        ArrayList entries = new ArrayList(events.entrySet());
        Collections.reverse(entries);
        for (Map.Entry entry : entries) {
            long time = (Long)entry.getKey();
            String event = (String)entry.getValue();
            buf.append("<tr><td>");
            buf.append(DataHelper.formatTime((long)time));
            buf.append("</td><td>");
            if (isAll) {
                String[] s = DataHelper.split((String)event, (String)" ", (int)2);
                String xs = this._xevents.get(s[0]);
                if (xs == null) {
                    xs = s[0];
                }
                buf.append(xs);
                buf.append("</td><td>");
                if (s.length > 1) {
                    buf.append(s[1]);
                }
            } else {
                buf.append(event);
            }
            buf.append("</td></tr>");
        }
        buf.append("</table>");
        return buf.toString();
    }
}

