/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web.helpers;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import net.i2p.crypto.SHA256Generator;
import net.i2p.data.DataHelper;
import net.i2p.router.web.HelperBase;
import net.i2p.util.FileSuffixFilter;
import net.i2p.util.FileUtil;
import net.i2p.util.SystemVersion;

public class FileDumpHelper
extends HelperBase {
    private static final boolean isWindows = SystemVersion.isWindows();

    public String getFileSummary() {
        StringBuilder buf = new StringBuilder(16384);
        buf.append("<table id=\"jardump\">\n<tr><th>File</th><th>Size</th><th>Date</th><th>SHA 256</th><th>Revision</th><th>JDK</th><th>Built</th><th>By</th><th>Mods</th></tr>\n");
        ClassLoader loader = ClassLoader.getSystemClassLoader();
        if (loader instanceof URLClassLoader) {
            URLClassLoader urlClassLoader = (URLClassLoader)loader;
            URL[] urls = urlClassLoader.getURLs();
            ArrayList<File> flist = new ArrayList<File>();
            int i = 0;
            while (i < urls.length) {
                String p = urls[i].toString();
                if (p.startsWith("file:") && p.endsWith(".jar") && !(p = p.substring(5)).startsWith(this._context.getBaseDir().getAbsolutePath()) && !p.startsWith(this._context.getConfigDir().getAbsolutePath())) {
                    flist.add(new File(p));
                }
                ++i;
            }
            Collections.sort(flist);
            for (File f : flist) {
                FileDumpHelper.dumpFile(buf, f);
            }
        }
        File dir = new File(this._context.getBaseDir(), "lib");
        buf.append("<tr><th class=\"subheading routerfiles\" colspan=\"9\"><b>Router Jar Files:</b> <code>");
        buf.append(dir.getAbsolutePath());
        buf.append("</code></th></tr>\n");
        FileDumpHelper.dumpDir(buf, dir, ".jar");
        dir = new File(this._context.getBaseDir(), "webapps");
        buf.append("<tr><th class=\"subheading routerfiles\" colspan=\"9\"><b>Router War Files:</b> <code>");
        buf.append(dir.getAbsolutePath());
        buf.append("</code></th></tr>\n");
        FileDumpHelper.dumpDir(buf, dir, ".war");
        File pluginDir = new File(this._context.getConfigDir(), "plugins");
        buf.append("<tr><th class=\"subheading pluginfiles\" colspan=\"9\"><b>I2P Plugins:</b> <code>");
        buf.append(pluginDir.getAbsolutePath());
        buf.append("</code></th></tr>");
        Object[] files = pluginDir.listFiles();
        if (files != null) {
            Arrays.sort(files);
            int i = 0;
            while (i < files.length) {
                dir = new File((File)files[i], "lib");
                buf.append("<tr><th class=\"subheading pluginfiles\" colspan=\"9\"><b>Plugin File Location:</b> <code>");
                buf.append(dir.getAbsolutePath());
                buf.append("</code></th></tr>");
                FileDumpHelper.dumpDir(buf, dir, ".jar");
                dir = new File((File)files[i], "console/webapps");
                FileDumpHelper.dumpDir(buf, dir, ".war");
                ++i;
            }
        }
        buf.append("</table>");
        return buf.toString();
    }

    private static void dumpDir(StringBuilder buf, File dir, String suffix) {
        Object[] files = dir.listFiles((FileFilter)new FileSuffixFilter(suffix));
        if (files == null) {
            return;
        }
        Arrays.sort(files);
        int i = 0;
        while (i < files.length) {
            FileDumpHelper.dumpFile(buf, (File)files[i]);
            ++i;
        }
    }

    private static void dumpFile(StringBuilder buf, File f) {
        String s;
        Attributes att;
        byte[] hash;
        buf.append("<tr><td><b title=\"").append(f.getAbsolutePath()).append("\">").append(f.getName()).append("</b></td><td align=\"right\">").append(f.length()).append("</td><td>");
        long mod = f.lastModified();
        if (mod > 0L) {
            buf.append(new Date(mod).toString());
        } else {
            buf.append("<font color=\"red\">Not found</font>");
        }
        buf.append("</td><td align=\"center\">");
        if (mod > 0L && !FileUtil.verifyZip((File)f)) {
            buf.append("<font color=\"red\">CORRUPT</font><br>");
        }
        if ((hash = FileDumpHelper.sha256(f)) != null) {
            byte[] hh = new byte[16];
            System.arraycopy(hash, 0, hh, 0, 16);
            buf.append("<span class=\"sha256\"><tt>");
            String p1 = DataHelper.toHexString((byte[])hh);
            int i = p1.length();
            while (i < 32) {
                buf.append('0');
                ++i;
            }
            buf.append(p1).append("</tt><br>");
            System.arraycopy(hash, 16, hh, 0, 16);
            buf.append("<tt>").append(DataHelper.toHexString((byte[])hh)).append("</tt></span>");
        }
        if ((att = FileDumpHelper.attributes(f)) == null) {
            att = new Attributes();
        }
        buf.append("<td align=\"center\">");
        String iv = FileDumpHelper.getAtt(att, "Implementation-Version");
        if (iv != null) {
            buf.append("<b>").append(iv).append("</b>");
        }
        if ((s = FileDumpHelper.getAtt(att, "Base-Revision")) != null && s.length() > 20) {
            if (iv != null) {
                buf.append("<br>");
            }
            buf.append("<span class=\"revision\"><tt>").append(s.substring(0, 20)).append("</tt><br><tt>").append(s.substring(20)).append("</tt></span>");
        }
        buf.append("</td><td>");
        s = FileDumpHelper.getAtt(att, "Created-By");
        if (s != null) {
            buf.append(s);
        }
        buf.append("</td><td>");
        s = FileDumpHelper.getAtt(att, "Build-Date");
        if (s != null) {
            buf.append(s);
        }
        buf.append("</td><td align=\"center\">");
        s = FileDumpHelper.getAtt(att, "Built-By");
        if (s != null) {
            buf.append(s);
        }
        buf.append("</td><td>");
        s = FileDumpHelper.getAtt(att, "Workspace-Changes");
        if (s != null) {
            buf.append("<font color=\"red\"><span class=\"unsignedmod\">").append(s.replace(",", "</span></font><hr><font color=\"red\"><span class=\"unsignedmod\">")).append("</span></font>");
        }
        buf.append("</td></tr>\n");
    }

    /*
     * Loose catch block
     */
    private static byte[] sha256(File f) {
        byte[] byArray;
        FileInputStream in;
        block13: {
            in = null;
            in = new FileInputStream(f);
            MessageDigest md = SHA256Generator.getDigestInstance();
            byte[] b = new byte[4096];
            int cnt = 0;
            while ((cnt = ((InputStream)in).read(b)) >= 0) {
                md.update(b, 0, cnt);
            }
            byArray = md.digest();
            if (in == null) break block13;
            try {
                ((InputStream)in).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return byArray;
        catch (IOException ioe) {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return null;
            catch (Throwable throwable) {
                if (in != null) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    static Attributes attributes(File f) {
        Attributes attributes;
        InputStream in;
        block12: {
            in = null;
            in = new URL("jar:file:" + f.getAbsolutePath() + "!/META-INF/MANIFEST.MF").openStream();
            Manifest man = new Manifest(in);
            attributes = man.getMainAttributes();
            if (in == null) break block12;
            try {
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return attributes;
        catch (IOException ioe) {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return null;
            catch (Throwable throwable) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    static String getAtt(Attributes atts, String s) {
        String rv = atts.getValue(s);
        if (rv != null) {
            rv = DataHelper.stripHTML((String)rv);
        }
        return rv;
    }
}

