/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web.helpers;

import java.io.IOException;
import java.io.Serializable;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.router.web.CSSHelper;
import net.i2p.router.web.FormHandler;
import net.i2p.router.web.StatSummarizer;
import net.i2p.router.web.SummaryListener;
import net.i2p.router.web.helpers.ConfigRestartBean;
import net.i2p.stat.Rate;
import net.i2p.util.SystemVersion;

public class GraphHelper
extends FormHandler {
    private int _periodCount;
    private boolean _showEvents;
    private int _width;
    private int _height;
    private int _refreshDelaySeconds;
    private boolean _persistent;
    private boolean _graphHideLegend;
    private String _stat;
    private int _end;
    private static final String PROP_X = "routerconsole.graphX";
    private static final String PROP_Y = "routerconsole.graphY";
    private static final String PROP_REFRESH = "routerconsole.graphRefresh";
    private static final String PROP_PERIODS = "routerconsole.graphPeriods";
    private static final String PROP_EVENTS = "routerconsole.graphEvents";
    private static final String PROP_LEGEND = "routerconsole.graphHideLegend";
    private static final int DEFAULT_REFRESH = 300;
    private static final int DEFAULT_PERIODS = 60;
    private static final boolean DEFAULT_LEGEND = false;
    private static final int MIN_X = 200;
    private static final int MIN_Y = 60;
    private static final int MIN_C = 20;
    private static final int MAX_C = 131040;
    private static final int MIN_REFRESH = 15;
    private static final int[] times = new int[]{15, 30, 60, 120, 300, 600, 1800, 3600, -1};

    @Override
    public void setContextId(String contextId) {
        super.setContextId(contextId);
        this._width = this._context.getProperty(PROP_X, 400);
        this._height = this._context.getProperty(PROP_Y, 100);
        this._periodCount = this._context.getProperty(PROP_PERIODS, 60);
        this._refreshDelaySeconds = this._context.getProperty(PROP_REFRESH, 300);
        this._showEvents = this._context.getBooleanProperty(PROP_EVENTS);
    }

    public String getRefreshMeta() {
        if (this._refreshDelaySeconds <= 8 || ConfigRestartBean.getRestartTimeRemaining() < (long)(1000 * (this._refreshDelaySeconds + 30))) {
            return "";
        }
        return "<meta http-equiv=\"refresh\" content=\"" + (this._refreshDelaySeconds - 3) + "\">";
    }

    public void setPeriodCount(String str) {
        this.setC(str);
    }

    public void setE(String str) {
        try {
            this._end = Math.max(0, Integer.parseInt(str));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void setC(String str) {
        try {
            this._periodCount = Math.max(20, Math.min(Integer.parseInt(str), 131040));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void setShowEvents(String b) {
        this._showEvents = !"false".equals(b);
    }

    public void setHeight(String str) {
        this.setH(str);
    }

    public void setH(String str) {
        try {
            this._height = Math.max(60, Math.min(Integer.parseInt(str), 1024));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void setWidth(String str) {
        this.setW(str);
    }

    public void setW(String str) {
        try {
            this._width = Math.max(200, Math.min(Integer.parseInt(str), 2048));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void setRefreshDelay(String str) {
        try {
            int rds = Integer.parseInt(str);
            this._refreshDelaySeconds = rds > 0 ? Math.max(rds, 15) : -1;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void setPersistent(String foo) {
        this._persistent = true;
    }

    public void setHideLegend(String foo) {
        this._graphHideLegend = true;
    }

    public void setStat(String stat) {
        this._stat = stat;
    }

    public String getImages() {
        StatSummarizer ss = StatSummarizer.instance((I2PAppContext)this._context);
        if (ss == null) {
            return "";
        }
        try {
            List<SummaryListener> listeners = ss.getListeners();
            TreeSet<SummaryListener> ordered = new TreeSet<SummaryListener>(new AlphaComparator());
            ordered.addAll(listeners);
            boolean hasTx = false;
            boolean hasRx = false;
            for (SummaryListener lsnr : ordered) {
                String title = lsnr.getRate().getRateStat().getName();
                if (title.equals("bw.sendRate")) {
                    hasTx = true;
                    continue;
                }
                if (!title.equals("bw.recvRate")) continue;
                hasRx = true;
            }
            boolean hideLegend = this._context.getProperty(PROP_LEGEND, false);
            if (hasTx && hasRx && !this._showEvents) {
                Iterator<SummaryListener> iter = ordered.iterator();
                while (iter.hasNext()) {
                    SummaryListener lsnr = iter.next();
                    String title = lsnr.getRate().getRateStat().getName();
                    if (!title.equals("bw.sendRate") && !title.equals("bw.recvRate")) continue;
                    iter.remove();
                }
                this._out.write("<a href=\"graph?stat=bw.combined&amp;c=" + 3 * this._periodCount + "&amp;w=" + 3 * this._width + "&amp;h=" + 3 * this._height + "\">");
                String title = this._t("Combined bandwidth graph");
                this._out.write("<img class=\"statimage\" src=\"viewstat.jsp?stat=bw.combined&amp;periodCount=" + this._periodCount + "&amp;width=" + this._width);
                if (!hideLegend) {
                    this._out.write("&amp;height=" + (this._height - 26));
                } else {
                    this._out.write("&amp;height=" + this._height);
                }
                this._out.write("&amp;hideLegend=" + hideLegend + "\" alt=\"" + title + "\" title=\"" + title + "\"></a>\n");
            }
            for (SummaryListener lsnr : ordered) {
                Rate r = lsnr.getRate();
                String title = this._t("{0} for {1}", r.getRateStat().getName(), DataHelper.formatDuration2((long)((long)this._periodCount * r.getPeriod())));
                this._out.write("<a href=\"graph?stat=" + r.getRateStat().getName() + '.' + r.getPeriod() + "&amp;c=" + 3 * this._periodCount + "&amp;w=" + 3 * this._width + "&amp;h=" + 3 * this._height + (this._showEvents ? "&amp;showEvents=1" : "") + "\">");
                this._out.write("<img class=\"statimage\" border=\"0\" src=\"viewstat.jsp?stat=" + r.getRateStat().getName() + "&amp;showEvents=" + this._showEvents + "&amp;period=" + r.getPeriod() + "&amp;periodCount=" + this._periodCount + "&amp;width=" + this._width + "&amp;height=" + this._height + "&amp;hideLegend=" + hideLegend + "\" alt=\"" + title + "\" title=\"" + title + "\"></a>\n");
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return "";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getSingleStat() {
        StatSummarizer ss = StatSummarizer.instance((I2PAppContext)this._context);
        if (ss == null) {
            return "";
        }
        try {
            String displayName;
            String name;
            long period;
            if (this._stat == null) {
                this._out.write("No stat specified");
                return "";
            }
            if (this._stat.equals("bw.combined")) {
                period = 60000L;
                name = this._stat;
                displayName = this._t("Bandwidth usage");
            } else {
                Set<Rate> rates = ss.parseSpecs(this._stat);
                if (rates.size() != 1) {
                    this._out.write("Graphs not enabled for " + this._stat);
                    return "";
                }
                Rate r = rates.iterator().next();
                period = r.getPeriod();
                displayName = name = r.getRateStat().getName();
            }
            this._out.write("<h3 id=\"graphinfo\">");
            this._out.write(this._t("{0} for {1}", displayName, DataHelper.formatDuration2((long)((long)this._periodCount * period))));
            if (this._end > 0) {
                this._out.write(String.valueOf(' ') + this._t("ending {0} ago", DataHelper.formatDuration2((long)((long)this._end * period))));
            }
            boolean hideLegend = this._context.getProperty(PROP_LEGEND, false);
            this._out.write("&nbsp;<a href=\"graphs\">[" + this._t("Return to main graphs page") + "]</a></h3>\n" + "<div class=\"graphspanel\"><img class=\"statimage\" border=\"0\"" + " src=\"viewstat.jsp?stat=" + name + "&amp;showEvents=" + this._showEvents + "&amp;period=" + period + "&amp;periodCount=" + this._periodCount + "&amp;end=" + this._end + "&amp;width=" + this._width + "&amp;height=" + this._height + "&amp;hideLegend=" + hideLegend + "\"></div><p id=\"graphopts\">\n");
            if (this._width < 2048 && this._height < 1024) {
                this._out.write(GraphHelper.link(this._stat, this._showEvents, this._periodCount, this._end, this._width * 3 / 2, this._height * 3 / 2));
                this._out.write(this._t("Larger"));
                this._out.write("</a> - ");
            }
            if (this._width > 200 && this._height > 60) {
                this._out.write(GraphHelper.link(this._stat, this._showEvents, this._periodCount, this._end, this._width * 2 / 3, this._height * 2 / 3));
                this._out.write(this._t("Smaller"));
                this._out.write("</a> - ");
            }
            if (this._height < 1024) {
                this._out.write(GraphHelper.link(this._stat, this._showEvents, this._periodCount, this._end, this._width, this._height * 3 / 2));
                this._out.write(this._t("Taller"));
                this._out.write("</a> - ");
            }
            if (this._height > 60) {
                this._out.write(GraphHelper.link(this._stat, this._showEvents, this._periodCount, this._end, this._width, this._height * 2 / 3));
                this._out.write(this._t("Shorter"));
                this._out.write("</a> - ");
            }
            if (this._width < 2048) {
                this._out.write(GraphHelper.link(this._stat, this._showEvents, this._periodCount, this._end, this._width * 3 / 2, this._height));
                this._out.write(this._t("Wider"));
                this._out.write("</a> - ");
            }
            if (this._width > 200) {
                this._out.write(GraphHelper.link(this._stat, this._showEvents, this._periodCount, this._end, this._width * 2 / 3, this._height));
                this._out.write(this._t("Narrower"));
                this._out.write("</a>");
            }
            this._out.write("<br>");
            if (this._periodCount < 131040) {
                this._out.write(GraphHelper.link(this._stat, this._showEvents, this._periodCount * 2, this._end, this._width, this._height));
                this._out.write(this._t("Larger interval"));
                this._out.write("</a> - ");
            }
            if (this._periodCount > 20) {
                this._out.write(GraphHelper.link(this._stat, this._showEvents, this._periodCount / 2, this._end, this._width, this._height));
                this._out.write(this._t("Smaller interval"));
                this._out.write("</a>");
            }
            this._out.write("<br>");
            if (this._periodCount < 131040) {
                this._out.write(GraphHelper.link(this._stat, this._showEvents, this._periodCount, this._end + this._periodCount, this._width, this._height));
                this._out.write(this._t("Previous interval"));
                this._out.write("</a>");
            }
            if (this._end > 0) {
                int end = this._end - this._periodCount;
                if (end <= 0) {
                    end = 0;
                }
                if (this._periodCount < 131040) {
                    this._out.write(" - ");
                }
                this._out.write(GraphHelper.link(this._stat, this._showEvents, this._periodCount, end, this._width, this._height));
                this._out.write(this._t("Next interval"));
                this._out.write("</a> ");
            }
            this._out.write("<br>");
            this._out.write(GraphHelper.link(this._stat, !this._showEvents, this._periodCount, this._end, this._width, this._height));
            if (!this._stat.equals("bw.combined")) {
                this._out.write(this._showEvents ? this._t("Plot averages") : this._t("plot events"));
            }
            this._out.write("</a>");
            this._out.write("</p><p><i>" + this._t("All times are UTC.") + "</i></p>\n");
            return "";
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return "";
    }

    private static String link(String stat, boolean showEvents, int periodCount, int end, int width, int height) {
        return "<a href=\"graph?stat=" + stat + "&amp;c=" + periodCount + "&amp;w=" + width + "&amp;h=" + height + (end > 0 ? "&amp;e=" + end : "") + (showEvents ? "&amp;showEvents=1" : "") + "\">";
    }

    public String getForm() {
        StatSummarizer ss = StatSummarizer.instance((I2PAppContext)this._context);
        if (ss == null) {
            return "";
        }
        String nonce = CSSHelper.getNonce();
        try {
            this._out.write("<br><h3 id=\"graphdisplay\">" + this._t("Configure Graph Display") + " <a href=\"configstats\">[" + this._t("Select Stats") + "]</a></h3>");
            this._out.write("<form action=\"graphs\" method=\"POST\">\n<table><tr><td><div class=\"optionlist\"><input type=\"hidden\" name=\"action\" value=\"save\">\n<input type=\"hidden\" name=\"nonce\" value=\"" + nonce + "\" >\n");
            this._out.write("<span class=\"nowrap\" title=\"" + this._t("Note: Dimensions are for graph only (excludes title, labels and legend).") + "\"><b>");
            this._out.write(String.valueOf(this._t("Graph size")) + ":</b> <input size=\"4\" style=\"text-align: right;\" type=\"text\" name=\"width\" value=\"" + this._width + "\">" + this._t("pixels wide") + "&nbsp;&nbsp;&nbsp;<input size=\"4\" style=\"text-align: right;\" type=\"text\" name=\"height\" value=\"" + this._height + "\">" + this._t("pixels high") + "</span><br><span class=\"nowrap\">\n<b>");
            this._out.write(String.valueOf(this._t("Display period")) + ":</b> <input size=\"5\" style=\"text-align: right;\" type=\"text\" name=\"periodCount\" value=\"" + this._periodCount + "\">" + this._t("minutes") + "</span><br><span class=\"nowrap\">\n<b>");
            this._out.write(String.valueOf(this._t("Refresh delay")) + ":</b> <select name=\"refreshDelay\">");
            int i = 0;
            while (i < times.length) {
                this._out.write("<option value=\"");
                this._out.write(Integer.toString(times[i]));
                this._out.write(34);
                if (times[i] == this._refreshDelaySeconds) {
                    this._out.write(" selected=\"selected\" ");
                }
                this._out.write(62);
                if (times[i] > 0) {
                    this._out.write(DataHelper.formatDuration2((long)(times[i] * 1000)));
                } else {
                    this._out.write(this._t("Never"));
                }
                this._out.write("</option>\n");
                ++i;
            }
            this._out.write("</select></span><br><span class=\"nowrap\">\n<b>");
            this._out.write(String.valueOf(this._t("Plot type")) + ":</b> ");
            this._out.write("<label><input type=\"radio\" class=\"optbox\" name=\"showEvents\" value=\"false\" " + (this._showEvents ? "" : " checked=\"checked\" ") + ">" + this._t("Averages") + "</label>&nbsp;&nbsp;&nbsp;");
            this._out.write("<label><input type=\"radio\" class=\"optbox\" name=\"showEvents\" value=\"true\" " + (this._showEvents ? " checked=\"checked\" " : "") + ">" + this._t("Events") + "</label></span><br><span class=\"nowrap\">\n<b>");
            this._out.write(String.valueOf(this._t("Hide legend")) + ":</b> ");
            this._out.write("<label><input type=\"checkbox\" class=\"optbox\" value=\"true\" name=\"hideLegend\"");
            boolean hideLegend = this._context.getProperty(PROP_LEGEND, false);
            if (hideLegend) {
                this._out.write(" checked=\"checked\" ");
            }
            this._out.write(">" + this._t("Do not show legend on graphs") + "</label></span><br><span class=\"nowrap\">\n<b>");
            this._out.write(String.valueOf(this._t("Persistence")) + ":</b> <label><input type=\"checkbox\" class=\"optbox\" value=\"true\" name=\"persistent\"");
            boolean persistent = this._context.getBooleanPropertyDefaultTrue("routerconsole.graphPersistent");
            if (persistent) {
                this._out.write(" checked=\"checked\" ");
            }
            this._out.write(">" + this._t("Store graph data on disk") + "</label></span></div></td></tr></table>" + "<hr><div class=\"formaction\" id=\"graphing\"><input type=\"submit\" class=\"accept\" value=\"" + this._t("Save settings and redraw graphs") + "\"></div></form>");
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return "";
    }

    @Override
    public String getAllMessages() {
        if (StatSummarizer.isDisabled((I2PAppContext)this._context)) {
            this.addFormError("Graphing not supported with this JVM or OS");
            this.addFormNotice("JVM: " + System.getProperty("java.vendor") + ' ' + System.getProperty("java.version") + " (" + System.getProperty("java.runtime.name") + ' ' + System.getProperty("java.runtime.version") + ')');
            this.addFormNotice("OS: " + System.getProperty("os.name") + ' ' + System.getProperty("os.arch") + ' ' + System.getProperty("os.version"));
            if (!SystemVersion.isMac() && !SystemVersion.isWindows()) {
                this.addFormNotice("Installing the fonts-dejavu package and then restarting I2P may resolve the issue");
            }
            this.addFormNotice("Check logs for more information");
            if (this._context.getProperty(PROP_REFRESH, 0) >= 0) {
                this._context.router().saveConfig(PROP_REFRESH, "-1");
            }
        }
        return super.getAllMessages();
    }

    @Override
    protected void processForm() {
        if ("save".equals(this._action)) {
            this.saveSettings();
        }
    }

    private void saveSettings() {
        if (this._width != this._context.getProperty(PROP_X, 400) || this._height != this._context.getProperty(PROP_Y, 100) || this._periodCount != this._context.getProperty(PROP_PERIODS, 60) || this._refreshDelaySeconds != this._context.getProperty(PROP_REFRESH, 300) || this._showEvents != this._context.getBooleanProperty(PROP_EVENTS) || this._graphHideLegend != this._context.getProperty(PROP_LEGEND, false) || this._persistent != this._context.getBooleanPropertyDefaultTrue("routerconsole.graphPersistent")) {
            HashMap<String, String> changes = new HashMap<String, String>();
            changes.put(PROP_X, Integer.toString(this._width));
            changes.put(PROP_Y, Integer.toString(this._height));
            changes.put(PROP_PERIODS, Integer.toString(this._periodCount));
            changes.put(PROP_REFRESH, Integer.toString(this._refreshDelaySeconds));
            changes.put(PROP_EVENTS, Boolean.toString(this._showEvents));
            changes.put(PROP_LEGEND, Boolean.toString(this._graphHideLegend));
            changes.put("routerconsole.graphPersistent", Boolean.toString(this._persistent));
            boolean warn = this._persistent ^ this._context.getBooleanPropertyDefaultTrue("routerconsole.graphPersistent");
            this._context.router().saveConfig(changes, null);
            this.addFormNotice(this._t("Graph settings saved"));
            if (warn) {
                this.addFormError(this._t("Restart required to take effect"));
            }
        }
    }

    private static class AlphaComparator
    implements Comparator<SummaryListener>,
    Serializable {
        private AlphaComparator() {
        }

        @Override
        public int compare(SummaryListener l, SummaryListener r) {
            String rName;
            String lName = l.getRate().getRateStat().getName();
            int rv = lName.compareTo(rName = r.getRate().getRateStat().getName());
            if (rv != 0) {
                return rv;
            }
            return (int)(l.getRate().getPeriod() - r.getRate().getPeriod());
        }
    }
}

